package gov.va.med.nhin.adapter.datamanager.adapters;

import com.sun.xml.ws.client.BindingProviderProperties;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.mvi.hl7parsers.HL7Parser201306;
import gov.va.oit.oed.vaww.VAIdMPort;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

import org.hl7.v3.CS;
import org.hl7.v3.II;
import org.hl7.v3.INT;
import org.hl7.v3.MCCIMT000300UV01Acknowledgement;
import org.hl7.v3.MFMIMT700711UV01QueryAck;
import org.hl7.v3.ObjectFactory;
import org.hl7.v3.PRPAIN201305UV02;
import org.hl7.v3.PRPAIN201305UV02QUQIMT021001UV01ControlActProcess;
import org.hl7.v3.PRPAIN201306UV02;
import org.hl7.v3.PRPAMT201306UV02ParameterList;
import org.hl7.v3.PRPAMT201306UV02QueryByParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author VHAISBVAZQUD
 */
public class MVI1305ICNDataAdapter extends MVIDataAdapter implements DataAdapter
{
	private static final Logger logger = LoggerFactory.getLogger(MVI1305ICNDataAdapter.class.getName());

	public List getData(DataQuery dataQuery)
	{
		initializeProperties(dataQuery);

		ArrayList ret = new ArrayList();

		String icn = (String) dataQuery.getParameter("icn");

		icn = this.getWellFormedICN(icn);

		int retriesRemaining = mviRetryLimit;
		while(true)
		{
			try
			{
				PRPAIN201305UV02 request1305 = createAdapters1305Request(icn);
				VAIdMPort port = getVAIdMPort(wsdlURL);
				Map<String, Object> requestContext = ((BindingProvider) port).getRequestContext();
				requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, mviRequestTimeout);
				requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, mviConnectTimeout);
				PRPAIN201306UV02 response1306 = (PRPAIN201306UV02) port.prpaIN201305UV02(request1305);

				MCCIMT000300UV01Acknowledgement ack = response1306.getAcknowledgement().get(0);
				MFMIMT700711UV01QueryAck queryAck = response1306.getControlActProcess().getQueryAck();
				logger.info("ack.getTypeCode().getCode():" + ack.getTypeCode().getCode());
				logger.info("queryAck.getQueryResponseCode().getCode():" + queryAck.getQueryResponseCode().getCode());

				if(ack.getTypeCode().getCode().equalsIgnoreCase("AA") && queryAck.getQueryResponseCode().getCode().equalsIgnoreCase("OK"))
				{
					Map map1306 = this.build1306ResultsMap(response1306);
					ret.add(map1306);
				}
				else
				{
					// MVI returned with error code.
					String mviAckText = (String) ack.getAcknowledgementDetail().get(0).getText().getContent().get(0);
					// fix for fortify issue - Privacy Violation: RTC ticket #
					// 162993
					logger.warn("MVI query for ICN returned error.  {} Details: ", mviAckText);
				}
				break;
			}
			catch(SOAPFaultException sfe)
			{
				String msg = sfe.getMessage();
				String sfStr = sfe.getFault().getFaultString();
				String sfCode = sfe.getFault().getFaultCode();
				throw new DataAdapterException("SOAPFaultException occurred :" + "Message: " + msg + "; " + "FaultString: " + sfStr + ";" + "FaultCode: " + sfCode, sfe);
			}
			catch(WebServiceException ste)
			{
				logger.error("WebServiceException connecting to MVI.  Message={}", ste.getMessage());
				// only execute retries on timeout
				if(ste.getCause() instanceof java.net.SocketTimeoutException)
				{
					if(--retriesRemaining == 0)
					{
						throw new DataAdapterException(ste);
					}
					else
					{
						logger.info("Retrying connection to MVI due to SocketTimeoutException. {} retries remaining.", retriesRemaining);
					}
				}
				else
				{
					throw new DataAdapterException(ste);
				}
			}
			catch(Throwable t)
			{
				logger.error("There was an error getting data from MVI.  Message={}", t.getMessage());
				throw new DataAdapterException("There was an error getting data from MVI.", t);
			}
		}
		return ret;
	}

	private Map build1306ResultsMap(PRPAIN201306UV02 results1306)
	{
		Map map1306 = HL7Parser201306.extractDemographics(results1306);

		return map1306;
	}

	/*
	 * Build 1305 request
	 * 
	 * @param String ICN
	 */
	private PRPAIN201305UV02 createAdapters1305Request(String icn)
	{
		ObjectFactory objFactory = new ObjectFactory();
		PRPAIN201305UV02 adapter1305Request = new PRPAIN201305UV02();

		// Set up message header fields
		adapter1305Request.setId(createMessageId(null));

		adapter1305Request.setCreationTime(createCreationTime());

		// Set Processing Code
		CS processingCode = new CS();
		processingCode.setCode(processingCodeStr);
		adapter1305Request.setProcessingCode(processingCode);

		// Set Acknowlegment Code
		CS acceptAckCode = new CS();
		acceptAckCode.setCode("AL");
		adapter1305Request.setAcceptAckCode(acceptAckCode);

		// Set Sender
		adapter1305Request.setSender(createSender(mviSiteKey1305, VA_OID, mviSiteKey1305));

		// Setup ControlActProces
		PRPAIN201305UV02QUQIMT021001UV01ControlActProcess controlActProcess = new PRPAIN201305UV02QUQIMT021001UV01ControlActProcess();
		adapter1305Request.setControlActProcess(controlActProcess);

		// Set DataEnterer
		controlActProcess.getDataEnterer().add(createDataEnterer2(null)); // expects
																			// an
																			// assertion

		// QueryByParamter
		PRPAMT201306UV02QueryByParameter queryByParameter = new PRPAMT201306UV02QueryByParameter();
		JAXBElement<PRPAMT201306UV02QueryByParameter> queryByParameterJAXB = objFactory.createPRPAIN201305UV02QUQIMT021001UV01ControlActProcessQueryByParameter(queryByParameter);
		controlActProcess.setQueryByParameter(queryByParameterJAXB);

		CS modifyCode = new CS();
		modifyCode.setCode("MVI.COMP1");
		queryByParameter.setModifyCode(modifyCode);

		INT initQty = new INT();
		initQty.setValue(BigInteger.ONE);
		queryByParameter.setInitialQuantity(initQty);

		// Query ParameterList
		PRPAMT201306UV02ParameterList paramList = new PRPAMT201306UV02ParameterList();
		queryByParameter.setParameterList(paramList);

		II icnId = new II();
		icnId.setExtension(this.getWellFormedICN(icn));
		icnId.setRoot(VA_OID);
		paramList.setId(icnId);

		return adapter1305Request;
	}

	private String getWellFormedICN(String icn)
	{
		String icnValue = HL7Parser201306.extractICNValue(icn);
		if(icnValue != null)
		{
			icnValue = icnValue.concat("^NI");
		}
		return icnValue;
	}

}