package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataQuery;

/**
 *
 * @author VHAISBVAZQUD
 */
public class JoinDataAdapter implements DataAdapter
{
	public List getData(DataQuery dataQuery)
	{
		List<Map> ret = new ArrayList<Map>();
		String leftQueryName = dataQuery.getProperty("leftQueryName");
		String rightQueryName = dataQuery.getProperty("rightQueryName");
		String leftJoinColumn = dataQuery.getProperty("leftJoinColumn");
		String rightJoinColumn = dataQuery.getProperty("rightJoinColumn");
		DataManager dataManager = dataQuery.getDataManager();

		DataQuery leftQuery = dataManager.getQuery(leftQueryName);
		for(String parameterName : dataQuery.getParameterBySourceNames())
		{
			if(parameterName.startsWith("left.") && leftQuery.isParameter(parameterName.substring(5)))
			{
				leftQuery.setParameter(parameterName.substring(5), dataQuery.getParameterBySource(parameterName));
			}
		}

		List<Map> leftResults = leftQuery.getResults();

		for(Map leftResult : leftResults)
		{
			Object leftJoinValue = getValue(leftResult, leftJoinColumn);
			DataQuery rightQuery = dataManager.getQuery(rightQueryName);
			if(leftJoinValue != null && rightQuery.isParameter(rightJoinColumn))
			{
				rightQuery.setParameter(rightJoinColumn, leftJoinValue);
				for(String parameterName : dataQuery.getParameterBySourceNames())
				{
					if(parameterName.startsWith("right.") && rightQuery.isParameter(parameterName.substring(6)))
					{
						rightQuery.setParameter(parameterName.substring(6), dataQuery.getParameterBySource(parameterName));
					}
				}
				List<Map> rightResults = rightQuery.getResults();
				for(Map rightResult : rightResults)
				{
					Map retResult = new HashMap();
					retResult.putAll(leftResult);
					retResult.putAll(rightResult);
					ret.add(retResult);
				}
			}
		}

		return ret;
	}

	private Object getValue(Object bean, String property)
	{
		Object ret;

		try
		{
			ret = PropertyUtils.getProperty(bean, property);
		}
		// CCR 179231
		catch(Exception e)
		{
			return new DataAdapterException("Exception occurred during the data retrieval", e);
		}

		return ret;
	}
}
