package gov.va.med.nhin.adapter.datamanager.adapters;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import ca.uhn.hl7v2.model.v24.datatype.CX;
import ca.uhn.hl7v2.model.v24.datatype.XPN;
import ca.uhn.hl7v2.model.v24.message.ADT_A37;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import gov.va.med.nhin.adapter.datamanager.*;

/**
 *
 * @author David Vazquez
 */
public class HL7ADT37DataAdapter extends HL7MLLPDataAdapter
{
	@Override
	String buildMessage(DataQuery dataQuery) throws Exception
	{
		String template = dataQuery.getProperty("template").trim();

		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddhhmmss");
		Date currentTime = new Date();

		Parser parser = new GenericParser();
		ADT_A37 message = (ADT_A37) parser.parse(template);

		MSH msh = message.getMSH();
		msh.getDateTimeOfMessage().getTimeOfAnEvent().setValue(formatter.format(currentTime));
		msh.getMessageControlID().setValue(Long.toString(currentTime.getTime()));
		msh.getProcessingID().getProcessingID().setValue(dataQuery.getProperty("processingId"));
		msh.getSendingFacility().getNamespaceID().setValue((String) dataQuery.getParameter("correlatedFacilityNumber"));

		EVN evn = message.getEVN();
		evn.getRecordedDateTime().getTimeOfAnEvent().setValue(formatter.format(currentTime));
		evn.getEventFacility().getNamespaceID().setValue((String) dataQuery.getParameter("correlatedFacilityNumber"));

		PID pid = message.getPID();
		CX p = pid.getPatientIdentifierList(0);
		p.getID().setValue("");
		p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
		p.getAssigningAuthority().getUniversalIDType().setValue("0363");
		p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
		p.getAssigningFacility().getUniversalID().setValue("200M");
		p.getAssigningFacility().getUniversalIDType().setValue("L");
		p.getIdentifierTypeCode().setValue("NI");
		p = pid.getPatientIdentifierList(1);
		p.getID().setValue((String) dataQuery.getParameter("correlatedPatientId"));
		p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
		p.getAssigningAuthority().getUniversalIDType().setValue("0363");
		p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
		p.getAssigningFacility().getUniversalID().setValue((String) dataQuery.getParameter("correlatedFacilityNumber"));
		p.getAssigningFacility().getUniversalIDType().setValue("L");
		p.getIdentifierTypeCode().setValue("PI");

		XPN xpn = pid.getPatientName(0);
		xpn.getFamilyName().getSurname().setValue("NHINPATIENT");
		xpn.getGivenName().setValue("TWENTY");

		pid = message.getPID2();
		p = pid.getPatientIdentifierList(0);
		p.getID().setValue((String) dataQuery.getParameter("patientId"));
		p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
		p.getAssigningAuthority().getUniversalIDType().setValue("0363");
		p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
		p.getAssigningFacility().getUniversalID().setValue("200M");
		p.getAssigningFacility().getUniversalIDType().setValue("L");
		p.getIdentifierTypeCode().setValue("NI");
		p = pid.getPatientIdentifierList(1);
		p.getID().setValue((String) dataQuery.getParameter("correlatedPatientId"));
		p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
		p.getAssigningAuthority().getUniversalIDType().setValue("0363");
		p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
		p.getAssigningFacility().getUniversalID().setValue((String) dataQuery.getParameter("correlatedFacilityNumber"));
		p.getAssigningFacility().getUniversalIDType().setValue("L");
		p.getIdentifierTypeCode().setValue("PI");

		xpn = pid.getPatientName(0);
		xpn.getFamilyName().getSurname().setValue("NHINPATIENT");
		xpn.getGivenName().setValue("TWENTY");

		return parser.encode(message);
	}

	@Override
	List processResponse(DataQuery dataQuery, String response) throws Exception
	{
		return new ArrayList();
	}
}
