/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.mpi;

import gov.va.med.nhin.adapter.mvi.AdapterMVI;
import java.text.*;
import java.util.*;

import javax.xml.bind.*;

import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.transform.subdisc.*;
import org.junit.*;
import org.junit.runner.*;
import static org.junit.Assert.*;
import org.hl7.v3.*;
import org.jmock.*;
import org.jmock.integration.junit4.*;

        
import gov.va.med.nhin.adapter.audit.*;
import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.propertylookup.*;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author VHAISBVAZQUD
 */
@RunWith(JMock.class)
public class AdapterMPITest
{
    static final private String TEST_SENDING_HCID = "1.1";
    static final private String TEST_SENDING_AA = "1.1";
    static final private String TEST_RECEIVING_HCID = "2.2";
    static final private String TEST_RECEIVING_AA = "2.2";
    static final private String TEST_AA_NAME = "Test Assigning Authority";
    
    private Mockery context = new JUnit4Mockery();
    
    public AdapterMPITest()
    {
    }

    @Test
    public void testFindCandidatesNullRequest()
    {
        System.out.println("findCandidatesNullRequest");
        RespondingGatewayPRPAIN201305UV02RequestType request = null;
        AdapterMVI instance = new AdapterMVI();
        PRPAIN201306UV02 expResult = null;
        
        try {
            PRPAIN201306UV02 result = instance.findCandidates(request);
            fail("This shouldn't happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }
    
    @Test
    public void testFindCandidatesNullPRPAIN201305UV02()
    {
        System.out.println("findCandidatesNullPRPAIN201305UV02");
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        
        AdapterMVI instance = new AdapterMVI();
        PRPAIN201306UV02 expResult = null;
        
        try {
            PRPAIN201306UV02 result = instance.findCandidates(request);
            fail("This shouldn't happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }
    
    @Test
    public void testFindCandidates()
    {
        System.out.println("findCandidates");
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test", "Middle"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        AssertionType assertion = new AssertionType();
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        assertion.setHomeCommunity(homeCommunity);
        UserType user = new UserType();
        user.setUserName("remoteUser");
        PersonNameType personName = new PersonNameType();
        personName.setFamilyName("User");
        personName.setGivenName("Test");
        user.setPersonName(personName);
        user.setOrg(homeCommunity);
        assertion.setUserInfo(user);
        CeType role = new CeType();
        role.setCode("12345");
        user.setRoleCoded(role);
        CeType pou = new CeType();
        pou.setCode("TREATMENT");
        assertion.setPurposeOfDisclosureCoded(pou);
        request.setAssertion(assertion);
        
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        final Date dob;
        Date dobInner = null;
        try {
            dobInner = formatter.parse("20120724");
        }
        catch (ParseException pe) {
            fail("Failed to parse dob");
        }
        finally {
            dob = dobInner;
        }
        
        final Facility sendingFacility = new Facility();
        sendingFacility.setFacilityNumber("200TEST");
        sendingFacility.setHomeCommunityId(TEST_SENDING_HCID);
        sendingFacility.setFullHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("VA");
        facility.setHomeCommunityId(TEST_RECEIVING_HCID);
        facility.setFullHomeCommunityId("urn:oid:" + TEST_RECEIVING_HCID);
        
        final Map mpiResult = new HashMap();
        mpiResult.put("icn", "1234567890V123456");
        mpiResult.put("ssn", "666003333");
        mpiResult.put("firstName", "Test");
        mpiResult.put("middleName", null);
        mpiResult.put("lastName", "Patient");
        mpiResult.put("gender", "M");
        mpiResult.put("dob", dob);
        
        final List<Map> mpiResults = new ArrayList<Map>();
        mpiResults.add(mpiResult);
        
        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};

        final Map patient = new HashMap() {{
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};
        
        final List<Map> patients = new ArrayList<Map>();
        patients.add(patient);
        
        final Audit audit = new Audit();
        audit.setAction("MPI findMatch");
        audit.setDetails(
            "MATCH FOUND ICN= " + mpiResult.get("icn")
            + " Remote Facility=" + TEST_SENDING_HCID
            + " ssn=666003333"
            + ", lastName=Patient"
            + ", middleName=Middle"
            + ", firstName=Test"
            + ", address[0]=1234 Test Lane"
            + ", city=New Orleans"
            + ", state=LA"
            + ", zip=70143"
            + ", phoneNumber=tel:+1-504-529-6111"
            + ", gender=M"
            + ", dob=2012-07-24 00:00:00.0, "
        );
        audit.setOrganizationId("urn:oid:" + TEST_SENDING_HCID);
        audit.setPatientFacilityName("Test Facility");
        audit.setPatientFacilityNumber("TEST");
        audit.setPatientGivenName("Test");
        audit.setPatientId("1234567890V123456");
        audit.setPatientLastName("Patient");
        audit.setPatientSSN("666003333");
        audit.setPurposeForUse("TREATMENT");
        audit.setRemoteOrganizationId("urn:oid:" + TEST_RECEIVING_HCID);
        audit.setUserFacilityName(null);
        audit.setUserFacilityNumber("urn:oid:" + TEST_SENDING_AA);
        audit.setUserId("remoteUser");
        audit.setUserName("Test User");
        audit.setUserRole("12345");
        
        AdapterMVI instance = new AdapterMVI();
        
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        
        instance.setFacilityManager(facilityManager);
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        
        context.checking(new Expectations() {{
            oneOf(facilityManager).getFacilityByHomeCommunityId(TEST_SENDING_HCID);
            will(returnValue(sendingFacility));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            
            oneOf(dataManager).getQuery("MPI.findMatch");
            will(returnValue(dataQuery));
            
            oneOf(dataQuery).setParameter("sendingFacility", sendingFacility.getFacilityNumber());
            oneOf(dataQuery).setParameter("firstName", "Test");
            oneOf(dataQuery).setParameter("middleName", "Middle");
            oneOf(dataQuery).setParameter("lastName", "Patient");
            oneOf(dataQuery).setParameter("gender", "M");
            oneOf(dataQuery).setParameter("dob", dob);
            oneOf(dataQuery).setParameter("prefix", null);
            oneOf(dataQuery).setParameter("suffix", null);
            oneOf(dataQuery).setParameter("ssn", "666003333");
            oneOf(dataQuery).setParameter("sourcePatientId", "1234567890V123456");
            oneOf(dataQuery).setParameter("sourcePatientAssigningAuthority", TEST_SENDING_AA);
            oneOf(dataQuery).setParameter("sourcePatientAssigningFacility", TEST_SENDING_HCID);
            oneOf(dataQuery).setParameter("homeAddressStreet1", "1234 Test Lane");
            oneOf(dataQuery).setParameter("homeAddressStreet2", null);
            oneOf(dataQuery).setParameter("homeAddressCity", "New Orleans");
            oneOf(dataQuery).setParameter("homeAddressState", "LA");
            oneOf(dataQuery).setParameter("homeAddressPostal", "70143");
            oneOf(dataQuery).setParameter("homePhone", "1-504-529-6111");
            oneOf(dataQuery).setParameter("numRecords", "1");
            oneOf(dataQuery).getResults();
            will(returnValue(mpiResults));
            
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            
            oneOf(dataQuery).setParameter("icn", mpiResult.get("icn"));
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            allowing(propertyLookup).getProperty("AssigningAuthority");
            will(returnValue(TEST_RECEIVING_AA));
            
            oneOf(auditManager).storeAudit(audit);
        }});
        
        PRPAIN201306UV02 result = instance.findCandidates(request);
        assertTrue(result != null
                   && result.getControlActProcess() != null
                   && NullChecker.isNotNullOrEmpty(result.getControlActProcess().getSubject()));
    }
    
    @Test
    public void testFindCandidatesNoMiddleName()
    {
        System.out.println("findCandidatesNoMiddleName");
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        AssertionType assertion = new AssertionType();
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        assertion.setHomeCommunity(homeCommunity);
        UserType user = new UserType();
        user.setUserName("remoteUser");
        PersonNameType personName = new PersonNameType();
        personName.setFamilyName("User");
        personName.setGivenName("Test");
        user.setPersonName(personName);
        user.setOrg(homeCommunity);
        assertion.setUserInfo(user);
        CeType role = new CeType();
        role.setCode("12345");
        user.setRoleCoded(role);
        CeType pou = new CeType();
        pou.setCode("TREATMENT");
        assertion.setPurposeOfDisclosureCoded(pou);
        request.setAssertion(assertion);
        
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        final Date dob;
        Date dobInner = null;
        try {
            dobInner = formatter.parse("20120724");
        }
        catch (ParseException pe) {
            fail("Failed to parse dob");
        }
        finally {
            dob = dobInner;
        }
        
        final Facility sendingFacility = new Facility();
        sendingFacility.setFacilityNumber("200TEST");
        sendingFacility.setHomeCommunityId(TEST_SENDING_HCID);
        sendingFacility.setFullHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("VA");
        facility.setHomeCommunityId(TEST_RECEIVING_HCID);
        facility.setFullHomeCommunityId("urn:oid:" + TEST_RECEIVING_HCID);
        
        final Map mpiResult = new HashMap();
        mpiResult.put("icn", "1234567890V123456");
        mpiResult.put("ssn", "666003333");
        mpiResult.put("firstName", "Test");
        mpiResult.put("middleName", null);
        mpiResult.put("lastName", "Patient");
        mpiResult.put("gender", "M");
        mpiResult.put("dob", dob);
        
        final List<Map> mpiResults = new ArrayList<Map>();
        mpiResults.add(mpiResult);
        
        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};

        final Map patient = new HashMap() {{
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};
        
        final List<Map> patients = new ArrayList<Map>();
        patients.add(patient);
        
        final Audit audit = new Audit();
        audit.setAction("MPI findMatch");
        audit.setDetails(
            "MATCH FOUND ICN= " + mpiResult.get("icn")
            + " Remote Facility=" + TEST_SENDING_HCID
            + " ssn=666003333"
            + ", lastName=Patient"
            + ", middleName="
            + ", firstName=Test"
            + ", address[0]=1234 Test Lane"
            + ", city=New Orleans"
            + ", state=LA"
            + ", zip=70143"
            + ", phoneNumber=tel:+1-504-529-6111"
            + ", gender=M"
            + ", dob=2012-07-24 00:00:00.0, "
        );
        audit.setOrganizationId("urn:oid:" + TEST_SENDING_HCID);
        audit.setPatientFacilityName("Test Facility");
        audit.setPatientFacilityNumber("TEST");
        audit.setPatientGivenName("Test");
        audit.setPatientId("1234567890V123456");
        audit.setPatientLastName("Patient");
        audit.setPatientSSN("666003333");
        audit.setPurposeForUse("TREATMENT");
        audit.setRemoteOrganizationId("urn:oid:" + TEST_RECEIVING_HCID);
        audit.setUserFacilityName(null);
        audit.setUserFacilityNumber("urn:oid:" + TEST_SENDING_AA);
        audit.setUserId("remoteUser");
        audit.setUserName("Test User");
        audit.setUserRole("12345");
        
        AdapterMVI instance = new AdapterMVI();
        
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        
        instance.setFacilityManager(facilityManager);
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        
        context.checking(new Expectations() {{
            oneOf(facilityManager).getFacilityByHomeCommunityId(TEST_SENDING_HCID);
            will(returnValue(sendingFacility));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            
            oneOf(dataManager).getQuery("MPI.findMatch");
            will(returnValue(dataQuery));
            
            oneOf(dataQuery).setParameter("sendingFacility", sendingFacility.getFacilityNumber());
            oneOf(dataQuery).setParameter("firstName", "Test");
            oneOf(dataQuery).setParameter("middleName", null);
            oneOf(dataQuery).setParameter("lastName", "Patient");
            oneOf(dataQuery).setParameter("gender", "M");
            oneOf(dataQuery).setParameter("dob", dob);
            oneOf(dataQuery).setParameter("prefix", null);
            oneOf(dataQuery).setParameter("suffix", null);
            oneOf(dataQuery).setParameter("ssn", "666003333");
            oneOf(dataQuery).setParameter("sourcePatientId", "1234567890V123456");
            oneOf(dataQuery).setParameter("sourcePatientAssigningAuthority", TEST_SENDING_AA);
            oneOf(dataQuery).setParameter("sourcePatientAssigningFacility", TEST_SENDING_HCID);
            oneOf(dataQuery).setParameter("homeAddressStreet1", "1234 Test Lane");
            oneOf(dataQuery).setParameter("homeAddressStreet2", null);
            oneOf(dataQuery).setParameter("homeAddressCity", "New Orleans");
            oneOf(dataQuery).setParameter("homeAddressState", "LA");
            oneOf(dataQuery).setParameter("homeAddressPostal", "70143");
            oneOf(dataQuery).setParameter("homePhone", "1-504-529-6111");
            oneOf(dataQuery).setParameter("numRecords", "1");
            oneOf(dataQuery).getResults();
            will(returnValue(mpiResults));
            
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            
            oneOf(dataQuery).setParameter("icn", mpiResult.get("icn"));
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            allowing(propertyLookup).getProperty("AssigningAuthority");
            will(returnValue(TEST_RECEIVING_AA));
            
            oneOf(auditManager).storeAudit(audit);
        }});
        
        PRPAIN201306UV02 result = instance.findCandidates(request);
        assertTrue(result != null
                   && result.getControlActProcess() != null
                   && NullChecker.isNotNullOrEmpty(result.getControlActProcess().getSubject()));
    }

    @Test
    public void testFindCandidatesMatchFailed()
    {
        System.out.println("findCandidatesMatchFailed");
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test", "Middle"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        AssertionType assertion = new AssertionType();
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        assertion.setHomeCommunity(homeCommunity);
        UserType user = new UserType();
        user.setUserName("remoteUser");
        PersonNameType personName = new PersonNameType();
        personName.setFamilyName("User");
        personName.setGivenName("Test");
        user.setPersonName(personName);
        user.setOrg(homeCommunity);
        assertion.setUserInfo(user);
        CeType role = new CeType();
        role.setCode("12345");
        user.setRoleCoded(role);
        CeType pou = new CeType();
        pou.setCode("TREATMENT");
        assertion.setPurposeOfDisclosureCoded(pou);
        request.setAssertion(assertion);
        
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        final Date dob;
        Date dobInner = null;
        try {
            dobInner = formatter.parse("20120724");
        }
        catch (ParseException pe) {
            fail("Failed to parse dob");
        }
        finally {
            dob = dobInner;
        }
        
        final Facility sendingFacility = new Facility();
        sendingFacility.setFacilityNumber("200TEST");
        sendingFacility.setHomeCommunityId(TEST_SENDING_HCID);
        sendingFacility.setFullHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("VA");
        facility.setHomeCommunityId(TEST_RECEIVING_HCID);
        facility.setFullHomeCommunityId("urn:oid:" + TEST_RECEIVING_HCID);
        
        final List<Map> mpiResults = new ArrayList<Map>();
        
        final Audit audit = new Audit();
        audit.setAction("MPI findMatch");
        audit.setDetails(
            "MATCH FAILED"
            + " Remote Facility=" + TEST_SENDING_HCID
            + " ssn=666003333"
            + ", lastName=Patient"
            + ", middleName=Middle"
            + ", firstName=Test"
            + ", address[0]=1234 Test Lane"
            + ", city=New Orleans"
            + ", state=LA"
            + ", zip=70143"
            + ", phoneNumber=tel:+1-504-529-6111"
            + ", gender=M"
            + ", dob=2012-07-24 00:00:00.0, "
        );
        audit.setOrganizationId("urn:oid:" + TEST_SENDING_HCID);
        audit.setPurposeForUse("TREATMENT");
        audit.setRemoteOrganizationId("urn:oid:" + TEST_RECEIVING_HCID);
        audit.setUserFacilityName(null);
        audit.setUserFacilityNumber("urn:oid:" + TEST_SENDING_AA);
        audit.setUserId("remoteUser");
        audit.setUserName("Test User");
        audit.setUserRole("12345");
        
        AdapterMVI instance = new AdapterMVI();
        
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        
        instance.setFacilityManager(facilityManager);
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        
        context.checking(new Expectations() {{
            oneOf(facilityManager).getFacilityByHomeCommunityId(TEST_SENDING_HCID);
            will(returnValue(sendingFacility));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            
            oneOf(dataManager).getQuery("MPI.findMatch");
            will(returnValue(dataQuery));
            
            oneOf(dataQuery).setParameter("sendingFacility", sendingFacility.getFacilityNumber());
            oneOf(dataQuery).setParameter("firstName", "Test");
            oneOf(dataQuery).setParameter("middleName", "Middle");
            oneOf(dataQuery).setParameter("lastName", "Patient");
            oneOf(dataQuery).setParameter("gender", "M");
            oneOf(dataQuery).setParameter("dob", dob);
            oneOf(dataQuery).setParameter("prefix", null);
            oneOf(dataQuery).setParameter("suffix", null);
            oneOf(dataQuery).setParameter("ssn", "666003333");
            oneOf(dataQuery).setParameter("sourcePatientId", "1234567890V123456");
            oneOf(dataQuery).setParameter("sourcePatientAssigningAuthority", TEST_SENDING_AA);
            oneOf(dataQuery).setParameter("sourcePatientAssigningFacility", TEST_SENDING_HCID);
            oneOf(dataQuery).setParameter("homeAddressStreet1", "1234 Test Lane");
            oneOf(dataQuery).setParameter("homeAddressStreet2", null);
            oneOf(dataQuery).setParameter("homeAddressCity", "New Orleans");
            oneOf(dataQuery).setParameter("homeAddressState", "LA");
            oneOf(dataQuery).setParameter("homeAddressPostal", "70143");
            oneOf(dataQuery).setParameter("homePhone", "1-504-529-6111");
            oneOf(dataQuery).setParameter("numRecords", "1");
            oneOf(dataQuery).getResults();
            will(returnValue(mpiResults));
            
            never(dataManager).getQuery("Composite.findDemographics");
            
            allowing(propertyLookup).getProperty("AssigningAuthority");
            will(returnValue(TEST_RECEIVING_AA));
            
            oneOf(auditManager).storeAudit(audit);
        }});
        
        PRPAIN201306UV02 result = instance.findCandidates(request);
        assertTrue(result != null
                   && result.getControlActProcess() != null
                   && NullChecker.isNullOrEmpty(result.getControlActProcess().getSubject()));
    }
    
    private PRPAIN201305UV02 createPRPAIN201305(String lastName,
                                                List<String> givenName,
                                                String prefix,
                                                String suffix,
                                                String dob,
                                                String city,
                                                String state,
                                                List<String> address,
                                                String zip,
                                                String phone,
                                                String gender,
                                                String multiBirth,
                                                String maritalStatus,
                                                String patientId,
                                                String homeCommunityId,
                                                String assigningAuthority,
                                                String ssn)
    {
        JAXBElement<PRPAMT201301UV02Person> patientPerson =
                buildPRPAIN201301PatientPerson(lastName,
                                               givenName,
                                               prefix,
                                               suffix,
                                               dob,
                                               city,
                                               state,
                                               address,
                                               zip,
                                               phone,
                                               gender,
                                               multiBirth,
                                               maritalStatus);

        II ii = new II();
        ii.setRoot(assigningAuthority);
        ii.setExtension(patientId);
        String assigningAuthorityName = TEST_AA_NAME;
        if (!NullChecker.isNullOrEmpty(assigningAuthorityName)) {
            ii.setAssigningAuthorityName(assigningAuthorityName);
        }

        PRPAMT201301UV02Patient patient =
                HL7PatientTransforms.create201301Patient(patientPerson, ii);

        PRPAIN201305UV02 ret =
                HL7PRPA201305Transforms.createPRPA201305(patient, homeCommunityId, "1.1", assigningAuthority);

        // add ssn.
        PRPAMT201306UV02ParameterList paramList = ret.getControlActProcess().getQueryByParameter().getValue().getParameterList();
        PRPAMT201306UV02LivingSubjectId ssnId = new PRPAMT201306UV02LivingSubjectId();
        ii = new II();
        ii.setRoot("2.16.840.1.113883.4.1");
        ii.setExtension(ssn);
        ssnId.getValue().add(ii);
        ST text = new ST();
        ssnId.setSemanticsText(text);
        paramList.getLivingSubjectId().add(ssnId);

        // fix the interaction id.
        ret.setInteractionId(HL7DataTransformHelper.IIFactory(HL7Constants.INTERACTION_ID_ROOT, "PRPA_IN201305UV02"));

        // fix the controlActProccess/code.
        ret.getControlActProcess().setCode(HL7DataTransformHelper.CDFactory("PRPA_TE201305UV02", HL7Constants.INTERACTION_ID_ROOT));

        // fix the acceptAckCode.
        ret.setAcceptAckCode(HL7DataTransformHelper.CSFactory("NE"));
        
        // fix the processingModeCode.
        ret.setProcessingModeCode(HL7DataTransformHelper.CSFactory("T"));
        
        ret.getControlActProcess().setClassCode(ActClassControlAct.CACT);
        ret.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().setClassCode("ASSIGNED");
        
        // fix the creation time of the message.
        TSExplicit te = new TSExplicit();
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        te.setValue(formatter.format(now));
        ret.setCreationTime(te);

        CS responseModalityCode = new CS();
        responseModalityCode.setCode("R");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponseModalityCode(responseModalityCode);
        
        CS responsePriorityCode = new CS();
        responsePriorityCode.setCode("I");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponsePriorityCode(responsePriorityCode);
                
        return ret;
    }

    private JAXBElement<PRPAMT201301UV02Person> buildPRPAIN201301PatientPerson(String lastName,
                                                                               List<String> givenName,
                                                                               String prefix,
                                                                               String suffix,
                                                                               String dob,
                                                                               String city,
                                                                               String state,
                                                                               List<String> address,
                                                                               String zip,
                                                                               String phone,
                                                                               String gender,
                                                                               String multiBirth,
                                                                               String maritalStatus)
    {
        PRPAMT201301UV02Person patientPerson = new PRPAMT201301UV02Person();

        //--------------------------------------------------------------
        //build name
        org.hl7.v3.ObjectFactory factory = new org.hl7.v3.ObjectFactory();
        PNExplicit name = (PNExplicit) (factory.createPNExplicit());
        List namelist = name.getContent();

        //Last name
        EnExplicitFamily familyName = new EnExplicitFamily();
        familyName.setPartType("FAM");
        familyName.setContent(lastName);
        namelist.add(factory.createPNExplicitFamily(familyName));

        //First name
        if (NullChecker.isNotNullOrEmpty(givenName)) {
            for (String n : givenName) {
                if (!NullChecker.isNullOrEmpty(n)) {
                    EnExplicitGiven gn = new EnExplicitGiven();
                    gn.setPartType("GIV");
                    gn.setContent(n);
                    namelist.add(factory.createPNExplicitGiven(gn));

                }
            }
        }

        EnExplicitPrefix pfx = new EnExplicitPrefix();
        pfx.setContent(prefix);
        pfx.setPartType("PFX");
        namelist.add(factory.createENExplicitPrefix(pfx));

        EnExplicitSuffix sfx = new EnExplicitSuffix();
        sfx.setContent(suffix);
        sfx.setPartType("SFX");
        namelist.add(factory.createENExplicitSuffix(sfx));

        patientPerson.getName().add(name);
        //------------------------------------------------------------


        //Date of Birth
        TSExplicit valueTSExplicit = new TSExplicit();
        valueTSExplicit.setValue(dob);
        patientPerson.setBirthTime(valueTSExplicit);


        //Gender
        CE valueCE = new CE();
        valueCE.setCode(gender);
        patientPerson.setAdministrativeGenderCode(valueCE);

        //-------------------------------------------------------------
        //  build address
        ADExplicit addr = (ADExplicit) (factory.createADExplicit());
        List addrlist = addr.getContent();

        //address
        AdxpExplicitCity valueCity = new AdxpExplicitCity();
        valueCity.setContent(city);
        addrlist.add(factory.createADExplicitCity(valueCity));

        AdxpExplicitState valueState = new AdxpExplicitState();
        valueState.setContent(state);
        addrlist.add(factory.createADExplicitState(valueState));

        if (NullChecker.isNotNullOrEmpty(address)) {
            for (String a : address) {
                if (!NullChecker.isNullOrEmpty(a)) {
                    AdxpExplicitStreetAddressLine line = new AdxpExplicitStreetAddressLine();
                    line.setContent(a);
                    addrlist.add(factory.createADExplicitStreetAddressLine(line));
                }
            }
        }
        
        AdxpExplicitPostalCode valueZip = new AdxpExplicitPostalCode();
        valueZip.setContent(zip);
        addrlist.add(factory.createADExplicitPostalCode(valueZip));


        patientPerson.getAddr().add(addr);
        //--------------------------------------------------------------


        //telephone
        TELExplicit valueTELE = new TELExplicit();
        valueTELE.setValue(phone);
        patientPerson.getTelecom().add(valueTELE);

        //multi birth
        BL valueBL = new BL();
        if (multiBirth == null || multiBirth.length() == 0 || multiBirth.startsWith("NO") || multiBirth.startsWith("no")) {
            valueBL.setValue(false);
        }
        else {
            valueBL.setValue(true);
        }
        patientPerson.setMultipleBirthInd(valueBL);  //BL value

        // marital status
        CE maritalStatusCode = new CE();
        maritalStatusCode.setCode(maritalStatus);
        patientPerson.setMaritalStatusCode(maritalStatusCode);

        return factory.createPRPAMT201301UV02PatientPatientPerson(patientPerson);
    }
}
