<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:t="http://gov/va/nvap/privacy/data"
	exclude-result-prefixes="t">

	<xsl:template
		match="//*[local-name()='ConsentDirectiveData' and namespace-uri()='http://gov/va/nvap/privacy/data']">
		<xsl:call-template name="ConsentDirectiveDocumentTemplate">
			<xsl:with-param name="docId" select="t:docId" />
			<xsl:with-param name="effectiveDateTime" select="t:effectiveDateTime" />
			<xsl:with-param name="icn" select="t:icn" />
			<xsl:with-param name="patientRoleStreetAddressLine"
				select="t:patientRoleStreetAddressLine" />
			<xsl:with-param name="patientRoleCity" select="t:patientRoleCity" />
			<xsl:with-param name="patientRoleState" select="t:patientRoleState" />
			<xsl:with-param name="patientRolePostalCode" select="t:patientRolePostalCode" />
			<xsl:with-param name="patientRoleCountry" select="t:patientRoleCountry" />
			<xsl:with-param name="patientRoleTelecom" select="t:patientRoleTelecom" />
			<xsl:with-param name="patientRoleGivenName" select="t:patientRoleGivenName" />
			<xsl:with-param name="patientRoleSsn" select="t:patientRoleSsn" />
			<xsl:with-param name="patientRoleFamilyName" select="t:patientRoleFamilyName" />
			<xsl:with-param name="patientRoleMiddleName" select="t:patientRoleMiddleName" />
			<xsl:with-param name="patientRoleSuffix" select="t:patientRoleSuffix" />
			<xsl:with-param name="patientRolePrefix" select="t:patientRolePrefix" />
			<xsl:with-param name="patientRoleGivenNameAlias"
				select="t:patientRoleGivenNameAlias" />
			<xsl:with-param name="patientRoleFamilyNameAlias"
				select="t:patientRoleFamilyNameAlias" />
			<xsl:with-param name="patientRoleMiddleNameAlias"
				select="t:patientRoleMiddleNameAlias" />
			<xsl:with-param name="patientRoleSuffixAlias" select="t:patientRoleSuffixAlias" />
			<xsl:with-param name="patientRolePrefixAlias" select="t:patientRolePrefixAlias" />
			<xsl:with-param name="patientRoleGenderCode" select="t:patientRoleGenderCode" />
			<xsl:with-param name="patientRoleGenderDisplayName"
				select="t:patientRoleGenderDisplayName" />
			<xsl:with-param name="patientRoleGenderDisplayText"
				select="t:patientRoleGenderDisplayText" />
			<xsl:with-param name="patientRoleDob" select="t:patientRoleDob" />
			<xsl:with-param name="patientRoleMaritalStatusDisplayText"
				select="t:patientRoleMaritalStatusDisplayText" />
			<xsl:with-param name="patientRoleMaritalStatusDisplayName"
				select="t:patientRoleMaritalStatusDisplayName" />
			<xsl:with-param name="patientRoleMaritalStatusCode"
				select="t:patientRoleMaritalStatusCode" />
			<xsl:with-param name="patientRoleEthnicGroupCodeDisplayText"
				select="t:patientRoleEthnicGroupCodeDisplayText" />

			<xsl:with-param name="patientRoleProviderOrganizationNumber"
				select="t:patientRoleProviderOrganizationNumber" />
			<xsl:with-param name="patientRoleProviderOrganizationOid"
				select="t:patientRoleProviderOrganizationOid" />
			<xsl:with-param name="patientRoleProviderOrganizationName"
				select="t:patientRoleProviderOrganizationName" />

			<xsl:with-param name="authorPersonOrgOid" select="t:authorPersonOrgOid" />
			<xsl:with-param name="authorPersonOid" select="t:authorPersonOid" />
			<xsl:with-param name="authorPersonGivenName" select="t:authorPersonGivenName" />
			<xsl:with-param name="authorPersonFamilyName" select="t:authorPersonFamilyName" />
			<xsl:with-param name="authorPersonSuffix" select="t:authorPersonSuffix" />
			<xsl:with-param name="authorPersonPrefix" select="t:authorPersonPrefix" />
			<xsl:with-param name="authorPersonFacilityNumber"
				select="t:authorPersonFacilityNumber" />
			<xsl:with-param name="authorPersonFacilityOid" select="t:authorPersonFacilityOid" />
			<xsl:with-param name="authorPersonFacilityName"
				select="t:authorPersonFacilityName" />
			<xsl:with-param name="authorPersonTelecom" select="t:authorPersonTelecom" />
			<xsl:with-param name="authorPersonStreetAddressLine"
				select="t:authorPersonStreetAddressLine" />
			<xsl:with-param name="authorPersonCity" select="t:authorPersonCity" />
			<xsl:with-param name="authorPersonState" select="t:authorPersonState" />
			<xsl:with-param name="authorPersonPostalCode" select="t:authorPersonPostalCode" />
			<xsl:with-param name="authorPersonCountry" select="t:authorPersonCountry" />


			<xsl:with-param name="authorAssignedScannerTime"
				select="t:authorScannerTime" />
			<xsl:with-param name="authorAssignedScannerOrgOid"
				select="t:authorAssignedScannerOrgOid" />
			<xsl:with-param name="authorAssignedScannerStreetAddressLine"
				select="t:authorAssignedScannerStreetAddressLine" />
			<xsl:with-param name="authorAssignedScannerCity"
				select="t:authorAssignedScannerCity" />
			<xsl:with-param name="authorAssignedScannerState"
				select="t:authorAssignedScannerState" />
			<xsl:with-param name="authorAssignedScannerPostalCode"
				select="t:authorAssignedScannerPostalCode" />
			<xsl:with-param name="authorAssignedScannerCountry"
				select="t:authorAssignedScannerCountry" />
			<xsl:with-param name="authorAssignedScannerTelecom"
				select="t:authorAssignedScannerTelecom" />
			<xsl:with-param name="authorAssignedScannerDeviceCode"
				select="t:authorAssignedScannerDeviceCode" />
			<xsl:with-param name="authorAssignedScannerDeviceName"
				select="t:authorAssignedScannerDeviceName" />
			<xsl:with-param name="authorAssignedScannerManufacturerModelName"
				select="t:authorAssignedScannerManufacturerModelName" />
			<xsl:with-param name="authorAssignedScannerSoftwareName"
				select="t:authorAssignedScannerSoftwareName" />
			<xsl:with-param name="authorRepresentedScannerOrgOid"
				select="t:authorRepresentedScannerOrgOid" />
			<xsl:with-param name="authorRepresentedScannerSourceName"
				select="t:authorRepresentedScannerSourceName" />
			<xsl:with-param name="authorRepresentedScannerTelecom"
				select="t:authorRepresentedScannerTelecom" />
			<xsl:with-param name="authorRepresentedScannerStreetAddressLine"
				select="t:authorRepresentedScannerStreetAddressLine" />
			<xsl:with-param name="authorRepresentedScannerCity"
				select="t:authorRepresentedScannerCity" />
			<xsl:with-param name="authorRepresentedScannerState"
				select="t:authorRepresentedScannerState" />
			<xsl:with-param name="authorRepresentedScannerPostalCode"
				select="t:authorRepresentedScannerPostalCode" />
			<xsl:with-param name="authorRepresentedScannerCountry"
				select="t:authorRepresentedScannerCountry" />

			<xsl:with-param name="dataEntererTime" select="t:dataEntererTime" />
			<xsl:with-param name="dataEntererStationNumber"
				select="t:dataEntererStationNumber" />
			<xsl:with-param name="dataEntererOid" select="t:dataEntererOid" />
			<xsl:with-param name="dataEntererAuthorName" select="t:dataEntererAuthorName" />

			<xsl:with-param name="custodianOid" select="t:custodianOid" />
			<xsl:with-param name="custodianName" select="t:custodianName" />
			<xsl:with-param name="custodianTelecom" select="t:custodianTelecom" />
			<xsl:with-param name="custodianStreetAddressLine"
				select="t:custodianStreetAddressLine" />
			<xsl:with-param name="custodianCity" select="t:custodianCity" />
			<xsl:with-param name="custodianState" select="t:custodianState" />
			<xsl:with-param name="custodianPostalCode" select="t:custodianPostalCode" />
			<xsl:with-param name="custodianCountry" select="t:custodianCountry" />

			<xsl:with-param name="informationRecipientOid" select="t:informationRecipientOid" />
			<xsl:with-param name="informationRecipientId" select="t:informationRecipientId" />
			<xsl:with-param name="informationRecipientStreetAddressLine"
				select="t:informationRecipientStreetAddressLine" />
			<xsl:with-param name="informationRecipientCity"
				select="t:informationRecipientCity" />
			<xsl:with-param name="informationRecipientState"
				select="t:informationRecipientState" />
			<xsl:with-param name="informationRecipientPostalCode"
				select="t:informationRecipientPostalCode" />
			<xsl:with-param name="informationRecipientCountry"
				select="t:informationRecipientCountry" />
			<xsl:with-param name="informationRecipientGivenName"
				select="t:informationRecipientGivenName" />
			<xsl:with-param name="informationRecipientFamilyName"
				select="t:informationRecipientFamilyName" />
			<xsl:with-param name="informationRecipientSuffix"
				select="t:informationRecipientSuffix" />
			<xsl:with-param name="informationRecipientPrefix"
				select="t:informationRecipientPrefix" />
			<xsl:with-param name="informationRecipientReceivedOrganizationOid"
				select="t:informationRecipientReceivedOrganizationOid" />
			<xsl:with-param name="informationRecipientReceivedOrganizationName"
				select="t:informationRecipientReceivedOrganizationName" />

			<xsl:with-param name="previousConsentDirectiveId"
				select="t:previousConsentDirectiveId" />

			<xsl:with-param name="componentStructuredNarrativeText"
				select="t:componentStructuredNarrativeText" />
			<xsl:with-param name="componentPurposeOfUseCode"
				select="t:componentPurposeOfUseCode" />
			<xsl:with-param name="componentPurposeOfUseDisplayName"
				select="t:componentPurposeOfUseDisplayName" />
			<xsl:with-param name="componentStatusCode" select="t:componentStatusCode" />
			<xsl:with-param name="componentInformantEntityOid"
				select="t:componentInformantEntityOid" />
			<xsl:with-param name="componentInformantEntityId"
				select="t:componentInformantEntityId" />
			<xsl:with-param name="componentInformantEntityName"
				select="t:componentInformantEntityName" />
			<xsl:with-param name="componentAssignedEntityTelecom"
				select="t:componentAssignedEntityTelecom" />
			<xsl:with-param name="componentInformantEntityStreetAddressLine"
				select="t:componentInformantEntityStreetAddressLine" />
			<xsl:with-param name="componentInformantEntityCity"
				select="t:componentInformantEntityCity" />
			<xsl:with-param name="componentInformantEntityState"
				select="t:componentInformantEntityState" />
			<xsl:with-param name="componentInformantEntityPostalCode"
				select="t:componentInformantEntityPostalCode" />
			<xsl:with-param name="componentInformantEntityCountry"
				select="t:componentInformantEntityCountry" />

			<xsl:with-param name="legalAuthenticatorTime" select="t:legalAuthenticatorTime" />
			<xsl:with-param name="legalAuthenticatorUserId"
				select="t:legalAuthenticatorUserId" />
			<xsl:with-param name="legalAuthenticatorEntityOid"
				select="t:legalAuthenticatorEntityOid" />
			<xsl:with-param name="legalAuthenticatorStreetAddressLine"
				select="t:legalAuthenticatorStreetAddressLine" />
			<xsl:with-param name="legalAuthenticatorCity" select="t:legalAuthenticatorCity" />
			<xsl:with-param name="legalAuthenticatorState" select="t:legalAuthenticatorState" />
			<xsl:with-param name="legalAuthenticatorPostalCode"
				select="t:legalAuthenticatorPostalCode" />
			<xsl:with-param name="legalAuthenticatorCountry"
				select="t:legalAuthenticatorCountry" />
			<xsl:with-param name="legalAuthenticatorTelecom"
				select="t:legalAuthenticatorTelecom" />
			<xsl:with-param name="legalAuthenticatorGivenName"
				select="t:legalAuthenticatorGivenName" />
			<xsl:with-param name="legalAuthenticatorFamilyName"
				select="t:legalAuthenticatorFamilyName" />
			<xsl:with-param name="legalAuthenticatorSuffix"
				select="t:legalAuthenticatorSuffix" />
			<xsl:with-param name="legalAuthenticatorPrefix"
				select="t:legalAuthenticatorPrefix" />

			<xsl:with-param name="documentationRootId" select="t:documentationRootId" />
			<xsl:with-param name="documentationBeginTime" select="t:documentationBeginTime" />
			<xsl:with-param name="documentationEndTime" select="t:documentationEndTime" />

			<xsl:with-param name="participant" select="t:participant" />

			<xsl:with-param name="scannedConsentDirectiveDocumentBase64Text"
				select="t:scannedConsentDirectiveDocumentBase64Text" />
			<xsl:with-param name="alternatePolicyLanguageRepresentationText"
				select="t:alternatePolicyLanguageRepresentationText" />
			<xsl:with-param name="optoutReason" select="t:optoutReason" />
		</xsl:call-template>
	</xsl:template>
    
    <xsl:template name="ConsentDirectiveDocumentTemplate">

		<xsl:param name="docId" />
		<xsl:param name="effectiveDateTime" />
		<xsl:param name="icn" select="effectiveDateTime" />
		<xsl:param name="patientRoleStreetAddressLine" />
		<xsl:param name="patientRoleCity" />
		<xsl:param name="patientRoleState" />
		<xsl:param name="patientRolePostalCode" />
		<xsl:param name="patientRoleCountry" />
		<xsl:param name="patientRoleTelecom" />
		<xsl:param name="patientRoleGivenName" />
		<xsl:param name="patientRoleSsn" />
		<xsl:param name="patientRoleFamilyName" />
		<xsl:param name="patientRoleMiddleName" />
		<xsl:param name="patientRoleSuffix" />
		<xsl:param name="patientRolePrefix" />
		<xsl:param name="patientRoleGivenNameAlias" />
		<xsl:param name="patientRoleFamilyNameAlias" />
		<xsl:param name="patientRoleMiddleNameAlias" />
		<xsl:param name="patientRoleSuffixAlias" />
		<xsl:param name="patientRolePrefixAlias" />
		<xsl:param name="patientRoleGenderCode" />
		<xsl:param name="patientRoleGenderDisplayName" />
		<xsl:param name="patientRoleGenderDisplayText" />
		<xsl:param name="patientRoleDob" />
		<xsl:param name="patientRoleMaritalStatusDisplayText" />
		<xsl:param name="patientRoleMaritalStatusDisplayName" />
		<xsl:param name="patientRoleMaritalStatusCode" />
		<xsl:param name="patientRoleEthnicGroupCodeDisplayText" />

		<xsl:param name="patientRoleProviderOrganizationNumber" />
		<xsl:param name="patientRoleProviderOrganizationOid" />
		<xsl:param name="patientRoleProviderOrganizationName" />

		<xsl:param name="authorPersonTime" />
		<xsl:param name="authorPersonOrgOid" />
		<xsl:param name="authorPersonOid" />
		<xsl:param name="authorPersonGivenName" />
		<xsl:param name="authorPersonFamilyName" />
		<xsl:param name="authorPersonSuffix" />
		<xsl:param name="authorPersonPrefix" />
		<xsl:param name="authorPersonFacilityNumber" />
		<xsl:param name="authorPersonFacilityOid" />
		<xsl:param name="authorPersonFacilityName" />
		<xsl:param name="authorPersonTelecom" />
		<xsl:param name="authorPersonStreetAddressLine" />
		<xsl:param name="authorPersonCity" />
		<xsl:param name="authorPersonState" />
		<xsl:param name="authorPersonPostalCode" />
		<xsl:param name="authorPersonCountry" />


		<xsl:param name="authorAssignedScannerTime" />
		<xsl:param name="authorAssignedScannerOrgOid" />
		<xsl:param name="authorAssignedScannerStreetAddressLine" />
		<xsl:param name="authorAssignedScannerCity" />
		<xsl:param name="authorAssignedScannerState" />
		<xsl:param name="authorAssignedScannerPostalCode" />
		<xsl:param name="authorAssignedScannerCountry" />
		<xsl:param name="authorAssignedScannerTelecom" />
		<xsl:param name="authorAssignedScannerDeviceCode" />
		<xsl:param name="authorAssignedScannerDeviceName" />
		<xsl:param name="authorAssignedScannerManufacturerModelName" />
		<xsl:param name="authorAssignedScannerSoftwareName" />
		<xsl:param name="authorRepresentedScannerOrgOid" />
		<xsl:param name="authorRepresentedScannerSourceName" />
		<xsl:param name="authorRepresentedScannerTelecom" />
		<xsl:param name="authorRepresentedScannerStreetAddressLine" />
		<xsl:param name="authorRepresentedScannerCity" />
		<xsl:param name="authorRepresentedScannerState" />
		<xsl:param name="authorRepresentedScannerPostalCode" />
		<xsl:param name="authorRepresentedScannerCountry" />

		<xsl:param name="dataEntererTime" />
		<xsl:param name="dataEntererStationNumber" />
		<xsl:param name="dataEntererOid" />
		<xsl:param name="dataEntererAuthorName" />

		<xsl:param name="custodianOid" />
		<xsl:param name="custodianName" />
		<xsl:param name="custodianTelecom" />
		<xsl:param name="custodianStreetAddressLine" />
		<xsl:param name="custodianCity" />
		<xsl:param name="custodianState" />
		<xsl:param name="custodianPostalCode" />
		<xsl:param name="custodianCountry" />


		<xsl:param name="informationRecipientOid" />
		<xsl:param name="informationRecipientId" />
		<xsl:param name="informationRecipientStreetAddressLine" />
		<xsl:param name="informationRecipientCity" />
		<xsl:param name="informationRecipientState" />
		<xsl:param name="informationRecipientPostalCode" />
		<xsl:param name="informationRecipientCountry" />
		<xsl:param name="informationRecipientGivenName" />
		<xsl:param name="informationRecipientFamilyName" />
		<xsl:param name="informationRecipientSuffix" />
		<xsl:param name="informationRecipientPrefix" />
		<xsl:param name="informationRecipientReceivedOrganizationOid" />
		<xsl:param name="informationRecipientReceivedOrganizationName" />

		<xsl:param name="previousConsentDirectiveId" />

		<xsl:param name="componentStructuredNarrativeText" />
		<xsl:param name="componentPurposeOfUseCode" />
		<xsl:param name="componentPurposeOfUseDisplayName" />
		<xsl:param name="componentStatusCode" />
		<xsl:param name="componentInformantEntityOid" />
		<xsl:param name="componentInformantEntityId" />
		<xsl:param name="componentInformantEntityName" />
		<xsl:param name="componentAssignedEntityTelecom" />
		<xsl:param name="componentInformantEntityStreetAddressLine" />
		<xsl:param name="componentInformantEntityCity" />
		<xsl:param name="componentInformantEntityState" />
		<xsl:param name="componentInformantEntityPostalCode" />
		<xsl:param name="componentInformantEntityCountry" />

		<xsl:param name="legalAuthenticatorTime" />
		<xsl:param name="legalAuthenticatorUserId" />
		<xsl:param name="legalAuthenticatorEntityOid" />
		<xsl:param name="legalAuthenticatorStreetAddressLine" />
		<xsl:param name="legalAuthenticatorCity" />
		<xsl:param name="legalAuthenticatorState" />
		<xsl:param name="legalAuthenticatorPostalCode" />
		<xsl:param name="legalAuthenticatorCountry" />
		<xsl:param name="legalAuthenticatorTelecom" />
		<xsl:param name="legalAuthenticatorGivenName" />
		<xsl:param name="legalAuthenticatorFamilyName" />
		<xsl:param name="legalAuthenticatorSuffix" />
		<xsl:param name="legalAuthenticatorPrefix" />

		<xsl:param name="documentationRootId" />
		<xsl:param name="documentationBeginTime" />
		<xsl:param name="documentationEndTime" />

		<!-- Multiple Participant -->
		<xsl:param name="participant" />

		<xsl:param name="scannedConsentDirectiveDocumentBase64Text" />
		<xsl:param name="alternatePolicyLanguageRepresentationText" />

		<xsl:param name="optoutReason" />


		<ClinicalDocument xmlns="urn:hl7-org:v3"
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" classCode="DOCCLIN"
			moodCode="EVN">
			<!-- Consent Directive DSTU Header -->
			<realmCode code="US" />
			<typeId root="2.16.840.1.113883.1.3" extension="09230" />
			<!-- General Header Constraints -->
			<templateId root="2.16.840.1.113883.10.20.3" />
			<!-- Consent Directive Header Constraints -->
			<templateId root="2.16.840.1.113883.3.445.1" />
			<!-- Document instance id -->
			<!-- 0.03 CDA DOCUMENT IDENTIFIER, id=VA OID, extension=system-generated -->
			<id extension="{$docId}" root="2.16.840.1.113883.4.349" />
			<!-- 0.04 CDA DOCUMENT CODE , REQUIRED, LOINC -->
			<!-- Privacy Policy Acknowledgement Document LOINC Type -->
			<code code="57016-8" codeSystem="2.16.840.1.113883.6.1"
				codeSystemName="LOINC" displayName="Privacy Policy Acknowledgement Document" />
			<!-- 0.05 CDA DOCUMENAT TITLE, REQUIRED -->
			<!-- Document Title -->
			<title representation="TXT" mediaType="text/plain">Department of Veterans
				Affairs Consent Authorization Form</title>
			<!-- 0.07 DOCUMENT TIMESTAMP, REQUIRED, Note Signature Date/Time -->
			<!-- Document date/time -->
			<effectiveTime value="{$effectiveDateTime}" />
			<!-- 0.06 CDA CONFIDENTIALITY CODE, REQUIRED -->
			<confidentialityCode code="N" />
			<!-- 0.08 CDA DOCUMENT LANGUAGE, REQUIRED -->
			<languageCode code="en-US" />
			<!-- Client/Record Target Reference -->
			<!-- ******************************************************** PERSON INFORMATION 
				CONTENT MODULE, REQUIRED ******************************************************** -->
			<recordTarget>
				<patientRole>
					<!-- 1.02 PERSON ID, REQUIRED, id=VA OID, extension=GUID -->
					<id extension="{$icn}" root="2.16.840.1.113883.4.349" />
					<id extension="{$patientRoleSsn}" root="2.16.840.1.113883.4.1" />
					<!-- 1.03 PERSON ADDRESS-HOME PERMANENT, REQUIRED -->
					<addr use="HP">
						<streetAddressLine>
							<xsl:value-of select="$patientRoleStreetAddressLine" />
						</streetAddressLine>
						<city>
							<xsl:value-of select="$patientRoleCity" />
						</city>
						<state>
							<xsl:value-of select="$patientRoleState" />
						</state>
						<postalCode>
							<xsl:value-of select="$patientRolePostalCode" />
						</postalCode>
						<country>
							<xsl:value-of select="$patientRoleCountry" />
						</country>
					</addr>
					<!-- 1.04 PERSON PHONE/EMAIL/URL, REQUIRED (tel:+1-760-222-5555) -->
					<telecom use="HP" value="{$patientRoleTelecom}" />
					<patient>
						<!-- 1.05 PERSON NAME LEGAL, REQUIRED -->
						<name use="L">
							<given>
								<xsl:value-of select="$patientRoleGivenName" />
							</given>
							<family>
								<xsl:value-of select="$patientRoleFamilyName" />
							</family>
							<middle>
								<xsl:value-of select="$patientRoleMiddleName" />
							</middle>
							<suffix>
								<xsl:value-of select="$patientRoleSuffix" />
							</suffix>
							<prefix>
								<xsl:value-of select="$patientRolePrefix" />
							</prefix>
						</name>
						<!-- 1.05 PERSON NAME Alias Name, Optional -->
						<name use="P">
							<given>
								<xsl:value-of select="$patientRoleGivenNameAlias" />
							</given>
							<family>
								<xsl:value-of select="$patientRoleFamilyNameAlias" />
							</family>
							<middle>
								<xsl:value-of select="$patientRoleMiddleNameAlias" />
							</middle>
							<suffix>
								<xsl:value-of select="$patientRoleSuffixAlias" />
							</suffix>
							<prefix>
								<xsl:value-of select="$patientRolePrefixAlias" />
							</prefix>
						</name>
						<!--1.06 GENDER, REQUIRED AND REQUIRED Terminology -->
						<!-- When Vista value is M, F, send as HL7AdminGenderCode -->
						<!-- When Vista value is "Unknown", send as genderCode nullFlavor=UNK" -->
						<administrativeGenderCode code="{$patientRoleGenderCode}"
							codeSystem="2.16.840.1.113883.5.1" codeSystemName="AdministrativeGenderCode"
							displayName="{$patientRoleGenderDisplayName}">
							<originalText>
								<xsl:value-of select="$patientRoleGenderDisplayText" />
							</originalText>
						</administrativeGenderCode>
						<!-- 1.07 PERSON DATE OF BIRTH, REQUIRED -->
						<birthTime value="{$patientRoleDob}" />
						<!-- 1.08 MARITAL STATUS, Optional-R2 -->
						<!-- VLER SEG 1B: Send as HL7 MaritalStatus -->
						<maritalStatusCode code="{$patientRoleMaritalStatusCode}"
							codeSystem="2.16.840.1.113883.5.2" codeSystemName="MaritalStatusCode"
							displayName="{$patientRoleMaritalStatusDisplayName}">
							<originalText>
								<xsl:value-of select="$patientRoleMaritalStatusDisplayText" />
							</originalText>
						</maritalStatusCode>
						<!-- 1.09 RELIGIOUS AFFILIATION, Optional, Removed b/c data not yet 
							available via VA VIstA RPCs -->
						<!-- 1.10 RACE, Optional -->
						<!-- 1.10 RACE as originalText per NHIN Core Content Specification 
							b/c VA code translation not yet available -->
						<raceCode codeSystem="2.16.840.1.113883.6.238"
							codeSystemName="CDC Race and Ethnicity" nullFlavor="UNK">
						</raceCode>
						<!-- 1.11 ETHNICITY, Optional -->
						<!-- 1.11 ETHNICITY as originalText per NHIN Core Content Specification 
							b/c VA code translation not yet available -->
						<ethnicGroupCode codeSystem="2.16.840.1.113883.6.238"
							codeSystemName="CDC Race and Ethnicity" nullFlavor="UNK">
							<originalText>
								<xsl:value-of select="$patientRoleEthnicGroupCodeDisplayText" />
							</originalText>
						</ethnicGroupCode>
					</patient>
					<providerOrganization>
						<!-- 2.07 ORGANIZATION ID, REQUIRED IF KNOWN -->
						<!-- AUTHOR ID (root = VA OID, extension = VA Facility Nbr) -->
						<id extension="{$patientRoleProviderOrganizationNumber}" root="{$patientRoleProviderOrganizationOid}" />
						<!-- 2.08 INFORMATION SOURCE NAME, REQUIRED, VA Facility Name -->
						<name>
							<xsl:value-of select="$patientRoleProviderOrganizationName" />
						</name>
						<!-- HITSP C62 V1.1: Assigned Author Telecom Required, but VA VistA 
							data not yet available -->
						<telecom nullFlavor="UNK" />
						<!-- HITSP C62 V1.1: Assigned Author Address Required, but VA VistA 
							data not yet available -->
						<addr />
					</providerOrganization>
				</patientRole>
			</recordTarget>
			<!-- Person and/or organization issuing the consent directive form -->

			<xsl:if test="$authorPersonOid">
				<author>
					<!-- 2.01 AUTHOR TEMPLATE ID, REQUIRED -->
					<templateId root="2.16.840.1.113883.3.445.2" />
					<!-- Required function code -->
					<functionCode code="POACON"
						displayName="healthcare power of attorney consent author"
						codeSystem="2.16.840.1.113883.1.11.19930" codeSystemName="ConsenterParticipationFunction Decision Maker" />
					<!-- 2.02 AUTHOR TIME, REQUIRED -->
					<time value="{$authorPersonTime}" />
					<assignedAuthor>
						<!-- 2.03 AUTHOR ID, REQUIRED IF KNOWN -->
						<!-- AUTHOR ID (VA OID) (authorOID) -->
						<id extension="{$authorPersonOid}" root="{$authorPersonOrgOid}" />
						<assignedPerson classCode="PSN">
							<!-- 2.04 AUTHOR NAME, REQUIRED -->
							<name>
								<given>
									<xsl:value-of select="$authorPersonGivenName" />
								</given>
								<family>
									<xsl:value-of select="$authorPersonFamilyName" />
								</family>
								<suffix>
									<xsl:value-of select="$authorPersonSuffix" />
								</suffix>
								<prefix>
									<xsl:value-of select="$authorPersonPrefix" />
								</prefix>
							</name>
						</assignedPerson>
						<representedOrganization>
							<!-- 2.07 ORGANIZATION ID, REQUIRED IF KNOWN -->
							<!-- AUTHOR ID (root = VA OID, extension = VA Facility Nbr) -->
							<id extension="{$authorPersonFacilityNumber}" root="{$authorPersonFacilityOid}" />
							<!-- 2.08 INFORMATION SOURCE NAME, REQUIRED, VA Facility Name -->
							<name>
								<xsl:value-of select="$authorPersonFacilityName" />
							</name>
							<!-- HITSP C62 V1.1: Assigned Author Telecom Required, but VA VistA 
								data not yet available -->
							<telecom value="{$authorPersonTelecom}" />
							<!-- HITSP C62 V1.1: Assigned Author Address Required, but VA VistA 
								data not yet available -->
							<addr>
								<streetAddressLine>
									<xsl:value-of select="$authorPersonStreetAddressLine" />
								</streetAddressLine>
								<city>
									<xsl:value-of select="$authorPersonCity" />
								</city>
								<state>
									<xsl:value-of select="$authorPersonState" />
								</state>
								<postalCode>
									<xsl:value-of select="$authorPersonPostalCode" />
								</postalCode>
								<country>
									<xsl:value-of select="$authorPersonCountry" />
								</country>
							</addr>
						</representedOrganization>
					</assignedAuthor>
				</author>
			</xsl:if>
			<xsl:if test="$authorAssignedScannerOrgOid">
				<!-- ******************************************************** SCANNER 
					Header Sub-Section, REQUIRED Represents the scanning device and software 
					used to produce the scanned content ******************************************************** -->
				<author>
					<!-- 3.01 AUTHOR TEMPLATE, REQUIRED -->
					<templateId root="1.3.6.1.4.1.19376.1.2.20.2" />
					<!-- 3.02 AUTHOR TIME, REQUIRED, Must be same as 0.07-Document Timestamp -->
					<time value="{$authorAssignedScannerTime}" />
					<assignedAuthor>
						<!-- 3.03 AUTHOR ID (VA OID), REQUIRED -->
						<id root="{$authorAssignedScannerOrgOid}" />
						<!-- HITSP C62 V1.1: Assigned Author Address Required, but VA VistA 
							data not yet available -->
						<addr use="HP">
							<streetAddressLine>
								<xsl:value-of select="$authorAssignedScannerStreetAddressLine" />
							</streetAddressLine>
							<city>
								<xsl:value-of select="$authorAssignedScannerCity" />
							</city>
							<state>
								<xsl:value-of select="$authorAssignedScannerState" />
							</state>
							<postalCode>
								<xsl:value-of select="$authorAssignedScannerPostalCode" />
							</postalCode>
							<country>
								<xsl:value-of select="$authorAssignedScannerCountry" />
							</country>
						</addr>
						<!-- HITSP C62 V1.1: Assigned Author Telecom Required, but VA VistA 
							data not yet available -->
						<telecom use="HP" value="{$authorAssignedScannerTelecom}" />
						<assignedAuthoringDevice>
							<!-- 3.04 DEVICE CODE, REQUIRED -->
							<code code="WSD" codeSystem="{$authorAssignedScannerDeviceCode}"
								displayName="{$authorAssignedScannerDeviceName}" />
							<!-- 3.05 DEVICE NAME, REQUIRED -->
							<manufacturerModelName>
								<xsl:value-of select="$authorAssignedScannerManufacturerModelName" />
							</manufacturerModelName>
							<!-- 3.06 SOFTWARE NAME, REQUIRED -->
							<softwareName>
								<xsl:value-of select="$authorAssignedScannerSoftwareName" />
							</softwareName>
						</assignedAuthoringDevice>
						<representedOrganization>
							<!-- 3.07 ORGANIZATION ID (VA OID), REQUIRED -->
							<id root="{$authorRepresentedScannerOrgOid}" />
							<!-- 3.08 INFORMATION SOURCE NAME, REQUIRED -->
							<name>
								<xsl:value-of select="$authorRepresentedScannerSourceName" />
							</name>
							<!-- HITSP C62 V1.1: Assigned Author Telecom Required, but VA VistA 
								data not yet available -->
							<telecom use="HP" value="{$authorRepresentedScannerTelecom}" />
							<!-- 3.09 INFORMATION SOURCE ADDRESS, OPTIONAL -->
							<addr use="HP">
								<streetAddressLine>
									<xsl:value-of select="$authorRepresentedScannerStreetAddressLine" />
								</streetAddressLine>
								<city>
									<xsl:value-of select="$authorRepresentedScannerCity" />
								</city>
								<state>
									<xsl:value-of select="$authorRepresentedScannerState" />
								</state>
								<postalCode>
									<xsl:value-of select="$authorRepresentedScannerPostalCode" />
								</postalCode>
								<country>
									<xsl:value-of select="$authorRepresentedScannerCountry" />
								</country>
							</addr>
						</representedOrganization>
					</assignedAuthor>
				</author>
			</xsl:if>
			<!-- ******************************************************** CLINICAL 
				DOCUMENT / DATA ENTERER (SCANNER OPERATOR), REQUIRED Data Enterer in VLER 
				"virtually scanned" scenario is software, not a person. ******************************************************** -->
			<xsl:if test="$dataEntererTime">
				<dataEnterer>
					<!-- 4.01 DATA ENTERER TEMPLATE ID, REQUIRED -->
					<templateId root="1.3.6.1.4.1.19376.1.2.20.3" />
					<!-- 4.02 DATA ENTERER TIME, REQUIRED -->
					<time value="{$dataEntererTime}" />
					<assignedEntity>
						<!-- 4.03 ENTITY ID, REQUIRED, Identifer representing the software 
							(VA OID, Station 200) -->
						<id extension="{$dataEntererStationNumber}" root="{$dataEntererOid}" />
						<assignedPerson>
							<!-- 4.04 AUTHOR NAME, Not Required for VLER Virtually scanned scenario -->
							<name>
								<xsl:value-of select="$dataEntererAuthorName" />
							</name>
						</assignedPerson>
					</assignedEntity>
				</dataEnterer>
			</xsl:if>
			<!-- ******************************************************** CUSTODIAN, 
				REQUIRED ******************************************************** -->
			<xsl:if test="$custodianOid">
				<custodian>
					<assignedCustodian>
						<representedCustodianOrganization>
							<!-- 5.01 CUSTODIAN ID (VA OID), REQUIRED -->
							<id root="{$custodianOid}" />
							<!-- 5.02 CUSTODIAN NAME, REQUIRED -->
							<name>
								<xsl:value-of select="$custodianName" />
							</name>
							<!-- 5.03 - TELECOM, REQUIRED, but VA VistA data not yet available -->
							<telecom use="HP" value="{$custodianTelecom}" />
							<!-- 5.04 CUSTODIAN ADDRESS, OPTIONAL -->
							<addr use="HP">
								<streetAddressLine>
									<xsl:value-of select="$custodianStreetAddressLine" />
								</streetAddressLine>
								<city>
									<xsl:value-of select="$custodianCity" />
								</city>
								<state>
									<xsl:value-of select="$custodianState" />
								</state>
								<postalCode>
									<xsl:value-of select="$custodianPostalCode" />
								</postalCode>
								<country>
									<xsl:value-of select="$custodianCountry" />
								</country>
							</addr>
						</representedCustodianOrganization>
					</assignedCustodian>
				</custodian>
			</xsl:if>

			<xsl:if test="$informationRecipientOid">
				<!-- Information Recipient -->
				<informationRecipient typeCode="PRCP">
					<intendedRecipient classCode="ASSIGNED">
						<id root="{$informationRecipientOid}" extension="{$informationRecipientId}" />
						<addr use="HP">
							<streetAddressLine>
								<xsl:value-of select="$informationRecipientStreetAddressLine" />
							</streetAddressLine>
							<city>
								<xsl:value-of select="$informationRecipientCity" />
							</city>
							<state>
								<xsl:value-of select="$informationRecipientState" />
							</state>
							<postalCode>
								<xsl:value-of select="$informationRecipientPostalCode" />
							</postalCode>
							<country>
								<xsl:value-of select="$informationRecipientCountry" />
							</country>
						</addr>
						<informationRecipient classCode="PSN"
							determinerCode="INSTANCE">
							<name use="L">
								<given>
									<xsl:value-of select="$informationRecipientGivenName" />
								</given>
								<family>
									<xsl:value-of select="$informationRecipientFamilyName" />
								</family>
								<suffix>
									<xsl:value-of select="$informationRecipientSuffix" />
								</suffix>
								<prefix>
									<xsl:value-of select="$informationRecipientPrefix" />
								</prefix>
							</name>
						</informationRecipient>
						<receivedOrganization classCode="ORG"
							determinerCode="INSTANCE">
							<id root="{$informationRecipientReceivedOrganizationOid}" />
							<name>
								<xsl:value-of select="$informationRecipientReceivedOrganizationName" />
							</name>
						</receivedOrganization>
					</intendedRecipient>
				</informationRecipient>
			</xsl:if>
			<!-- ******************************************************** LEGAL AUTHENTICATOR, 
				OPTIONAL ******************************************************** -->
			<!-- Substitute Decision Maker or Patient that signs the Consent Directive -->
			<xsl:if test="$legalAuthenticatorUserId">
				<legalAuthenticator contextControlCode="OP"
					typeCode="LA">
					<!-- 6.01 AUTHENTICATOR TIME, REQUIRED -->
					<time value="{$legalAuthenticatorTime}" />
					<!-- 6.02 SIGNATURE CODE, REQUIRED -->
					<signatureCode code="S" />
					<assignedEntity classCode="ASSIGNED">
						<!-- 6.03 ENTITY ID (User ID), REQUIRED -->
						<id extension="{$legalAuthenticatorUserId}" root="{$legalAuthenticatorEntityOid}" />
						<!-- Address Required for assignedEntity, but VA VistA data not yet 
							available -->
						<addr use="HP">
							<streetAddressLine>
								<xsl:value-of select="$legalAuthenticatorStreetAddressLine" />
							</streetAddressLine>
							<city>
								<xsl:value-of select="$legalAuthenticatorCity" />
							</city>
							<state>
								<xsl:value-of select="$legalAuthenticatorState" />
							</state>
							<postalCode>
								<xsl:value-of select="$legalAuthenticatorPostalCode" />
							</postalCode>
							<country>
								<xsl:value-of select="$legalAuthenticatorCountry" />
							</country>
						</addr>
						<!-- Telecom Required for assignedEntity, but VA VistA data not yet 
							available -->
						<telecom use="HP" value="{$legalAuthenticatorTelecom}" />
						<!-- assigned Person Required for legalAuthenticator/assignedEntity -->
						<assignedPerson classCode="PSN">
							<!-- 6.04 AUTHOR NAME, REQUIRED -->
							<name use="L">
								<given>
									<xsl:value-of select="$legalAuthenticatorGivenName" />
								</given>
								<family>
									<xsl:value-of select="$legalAuthenticatorFamilyName" />
								</family>
								<suffix>
									<xsl:value-of select="$legalAuthenticatorSuffix" />
								</suffix>
								<prefix>
									<xsl:value-of select="$legalAuthenticatorPrefix" />
								</prefix>
							</name>
						</assignedPerson>
					</assignedEntity>
				</legalAuthenticator>
			</xsl:if>
			<!-- ******************************************************** DOCUMENTATION 
				OF MODULE, REQUIRED ******************************************************** -->

			<!-- Effective time for the Consent Directive -->
			<documentationOf typeCode="DOC">
				<serviceEvent moodCode="EVN">
					<templateId root="2.16.840.1.113883.3.445.3" />
					<id root="{$documentationRootId}" />
					<code code="57016-8" codeSystem="2.16.840.1.113883.6.1"
						codeSystemName="LOINC" displayName="Privacy Policy Acknowledgement Document" />
					<effectiveTime>
						<!-- 7.01 BEGIN TIME, REQUIRED -->
						<low value="{$documentationBeginTime}" />
						<!-- 7.02 END TIME, REQUIRED -->
						<high value="{$documentationEndTime}" />
					</effectiveTime>
				</serviceEvent>
			</documentationOf>

			<!-- Previous Consent Directive Reference -->
			<relatedDocument typeCode="RPLC">
				<parentDocument classCode="DOCCLIN" moodCode="EVN">
					<id root="1.3.6.1.4.1.19376.1.5.3.1.2.6" extension="{$previousConsentDirectiveId}" />
				</parentDocument>
			</relatedDocument>

			<!-- Consent Directive Entry -->
			<component>
				<structuredBody>
					<component typeCode="COMP">
						<section classCode="DOCSECT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.3.445.17" />
							<code code="57016-8" codeSystemName="LOINC" />
							<title>Privacy Consent Directive Details</title>
							<!-- Narrative privacy consent directive -->
							<text mediaType="text/x-hl7-text+xml">
								<content>
									<xsl:value-of select="$componentStructuredNarrativeText" />
								</content>
							</text>
							<!-- Privacy Consent Directive Entry -->
							<entry typeCode="COMP">
								<templateId root="2.16.840.1.113883.3.445.4" />
								<!-- Structured/computer-readable Privacy Consent Directive Specification -->
								<act classCode="ACT" moodCode="DEF">
									<templateId root="2.16.840.1.113883.3.445.5" />
									<!-- Purpose of use -->
									<code code="{$componentPurposeOfUseCode}" codeSystem="2.16.840.1.113883.3.18.7.1"
										codeSystemName="nhin-purpose" displayName="{$componentPurposeOfUseDisplayName}" />
									<statusCode code="{$componentStatusCode}" />
									<!-- Custodian organization -->
									<informant typeCode="INF" contextControlCode="OP">
										<templateId root="2.16.840.1.113883.3.445.6" />
										<assignedEntity>
											<id root="{$componentInformantEntityOid}" extension="{$componentInformantEntityId}" />
											<representedOrganization>
												<name>
													<xsl:value-of select="$componentInformantEntityName" />
												</name>
												<telecom use="HP" value="{$componentAssignedEntityTelecom}" />
												<addr use="HP">
													<streetAddressLine>
														<xsl:value-of select="$componentInformantEntityStreetAddressLine" />
													</streetAddressLine>
													<city>
														<xsl:value-of select="$componentInformantEntityCity" />
													</city>
													<state>
														<xsl:value-of select="$componentInformantEntityState" />
													</state>
													<postalCode>
														<xsl:value-of select="$componentInformantEntityPostalCode" />
													</postalCode>
													<country>
														<xsl:value-of select="$componentInformantEntityCountry" />
													</country>
												</addr>
											</representedOrganization>
										</assignedEntity>
									</informant>
									<!-- Receiving provider -->
									<!-- Loop make the exclusions - START -->
									<xsl:for-each select="$participant">
										<participant typeCode="IRCP" contextControlCode="OP">
											<templateId extension="2.16.840.1.113883.3.445.7" />
											<participantRole classCode="ASSIGNED">
												<!-- USER ID / root = ORG OID -->
												<id extension="{t:componentParticipantId}" root="{t:componentParticipantOid}" />
												<!-- Role code - optional -->
												<code code="{t:componentParticipantRoleCode}"
													displayName="{t:componentParticipantRoleDisplayName}"
													codeSystemName="{t:componentParticipantRoleCodeSystemName}"
													codeSystem="{t:componentParticipantRoleCodeSystemOid}" />
												<addr use="HP">
													<streetAddressLine>
														<xsl:value-of select="t:componentParticipantStreetAddressLine" />
													</streetAddressLine>
													<city>
														<xsl:value-of select="t:componentParticipantCity" />
													</city>
													<state>
														<xsl:value-of select="t:componentParticipantState" />
													</state>
													<postalCode>
														<xsl:value-of select="t:componentParticipantPostalCode" />
													</postalCode>
													<country>
														<xsl:value-of select="t:componentParticipantCountry" />
													</country>
												</addr>
												<!-- Organization -->
												<playingEntity classCode="ORG">
													<name>
														<xsl:value-of select="t:componentParticipantPlayingEntityName" />
													</name>
												</playingEntity>
												<!-- ***************************************************************** 
													TODO: Only organization exclusions are supported in this release. ***************************************************************** -->
												<!-- <playingEntity classCode="PSN" determinerCode="INSTANCE"> 
													<name> <prefix>Mr.</prefix> <family>SomeDoctorIWishToExludeMyInformationFrom</family> 
													<given>SomeGivenName</given> <suffix>MD</suffix> </name> </playingEntity> -->
											</participantRole>
										</participant>
									</xsl:for-each>
									<!-- Loop make the exclusions - START -->

									<!-- Action -->
									<entryRelationship typeCode="COMP"
										contextConductionInd="true">
										<templateId root="2.16.840.1.113883.3.445.8" />
										<!-- negationInd='false' specifies that the action is authorized -->
										<!-- For this release, it defaults to negationInd="true" only, 
											which means only exlusions are allowed! -->
										<act classCode="OBS" moodCode="DEF" negationInd="true">
											<!-- Action/Operation -->
											<code code="DISCLOSE" codeSystem="2.16.840.1.113883.5.4"
												displayName="Disclose" codeSystemName="ActConsentType" />
										</act>
									</entryRelationship>
									<!-- *********************************************************************** 
										TODO: Consent validation by information *********************************************************************** -->
									<!-- Information references: category, object id, sensitivity, related 
										problem -->
									<entryRelationship typeCode="COMP"
										contextConductionInd="true">
										<templateId root="2.16.840.1.113883.3.445.9" />
										<organizer classCode="CLUSTER" moodCode="DEF">
											<statusCode code="active" />
											<component typeCode="COMP">
												<observation classCode="OBS" moodCode="DEF">
													<templateId extension="2.16.840.1.113883.3.445.10" />
													<code code="GAIN" codeSystemName="ActInformationCategoryCode"
														codeSystem="2.16.840.1.113883.5.4" displayName="Global Appraisal of Individual Needs (GAIN)" />
													<!-- Related Condition/Problem -->
													<!-- TODO: To be supported in future releases. <precondition 
														typeCode="PRCN"> <templateId root="2.16.840.1.113883.3.445.11" /> <criterion 
														classCode="OBS" moodCode="EVN.CRT"> <code code="371422002" codeSystemName="VA/KP 
														Problem Value Set" codeSystem="2.16.840.1.113883.3.88.12.3221.7.4" displayName="History 
														of substance abuse" /> </criterion> </precondition> <precondition typeCode="PRCN"> 
														<templateId root="2.16.840.1.113883.3.445.12" /> <criterion classCode="COND" 
														moodCode="EVN.CRT"> <code code="V" codeSystemName="ConfidentialityByAccessKind" 
														codeSystem="2.16.840.1.113883.1.11.10229" displayName="Very Restricted" /> 
														</criterion> </precondition> -->
												</observation>
											</component>
											<!-- Health Information Privacy Policy and Obligation -->
											<component typeCode="COMP" contextConductionInd="true">
												<templateId root="2.16.840.1.113883.3.445.13" />
												<!-- Policy Reference -->
												<act classCode="CONS" moodCode="DEF">
													<code codeSystemName="SAMSHA" code="42CFRPart2" />
													<precondition typeCode="PRCN">
														<templateId root="2.16.840.1.113883.3.445.14" /><!-- 
															Obligation -->
														<criterion classCode="OBS" moodCode="EVN.CRT">
															<code code="AUDIT" displayName="Audit access to information"
																codeSystemName="Obligation" />
														</criterion>
													</precondition>
												</act>
											</component>
										</organizer>
									</entryRelationship>
									<!-- Other representations: Scanned document and policy language -->

									<!-- Loop - make the pdf's - START -->
									<xsl:for-each select="$scannedConsentDirectiveDocumentBase64Text">
										<entryRelationship typeCode="COMP">
											<templateId root="2.16.840.1.113883.3.445.15" />
											<observationMedia classCode="OBS" moodCode="EVN">
												<!-- For this release - hardcode PDF -->
												<value mediaType="{t:mediaType}" representation="{t:representation}">
													<xsl:value-of select="t:document" />
												</value>
											</observationMedia>
										</entryRelationship>
									</xsl:for-each>

									<!-- Alternate Policy language representation -->
									<!-- TODO: Implement alternate policies for next release -->
									<!-- <entryRelationship typeCode="COMP"> <templateId root="2.16.840.1.113883.3.445.16" 
										/> <observationMedia classCode="OBS" moodCode="EVN"> <value mediaType="text/xml" 
										representation="TXT"> <xsl:value-of select="$alternatePolicyLanguageRepresentationText" 
										/> </value> </observationMedia> </entryRelationship> -->
								</act>
							</entry>
						</section>
					</component>
					<!-- ******************************************************************* 
						TODO: Signature Section. ******************************************************************* -->
					<!-- <component typeCode="COMP" contextConductionInd="true"> <section 
						classCode="DOCSECT" moodCode="EVN"> <templateId root="2.16.840.1.113883.3.445.18" 
						/> <title>Signatures</title> <text mediaType="text/x-hl7-text+xml"> <paragraph>This 
						section contains the signatures of the consenter. </paragraph> <paragraph> 
						<renderMultiMedia referencedObject="Page_1"> <caption>Page 1</caption> </renderMultiMedia> 
						</paragraph> <paragraph> <renderMultiMedia referencedObject="Page_2"> <caption>Page 
						2</caption> </renderMultiMedia> </paragraph> </text> <entry typeCode="COMP"> 
						<observationMedia ID="Page_1" classCode="DGIMG" moodCode="EVN"> <value mediaType="'image/jpeg"> 
						<reference value="P1.jpg" /> </value> </observationMedia> </entry> <entry 
						typeCode="COMP"> <observationMedia ID="Page_2" classCode="DGIMG" moodCode="EVN"> 
						<value mediaType="'image/jpeg"> <reference value="P2.jpg" /> </value> </observationMedia> 
						</entry> </section> </component> -->
				</structuredBody>
			</component>
		</ClinicalDocument>
	</xsl:template>
</xsl:stylesheet>
