package gov.va.med.nhin.adapter.stylesheet;

import gov.va.ccd.service.StandardizeXML;
import gov.va.med.nhin.adapter.documentrepository.Document;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

import javax.activation.DataHandler;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author ChmaraC
 * 
 */
public class ConvertDocument
{
	public static final Logger logger = LoggerFactory.getLogger(ConvertDocument.class.getName());

	public static byte[] getRandomFile()
	{
		File files = new File("C:/test/testFiles");
		File[] filelisting = files.listFiles();
		SecureRandom rand = new SecureRandom();
		InputStream fis = null;
		if(filelisting.length > 1)
		{
			try
			{
				int fileNum = rand.nextInt(filelisting.length);
				System.out.println("Picking file " + fileNum);
				File file = filelisting[fileNum];
				System.out.println("File Name is: " + file.getName());
				fis = new FileInputStream("C:/test/testFiles/" + file.getName());
				return IOUtils.toByteArray(fis);
			}
			catch(FileNotFoundException e)
			{
				logger.error("error occurred: ", e);
			}
			catch(IOException e)
			{
				// CCR 177986
				logger.error("error occurred: ", e);
			}
			// fix for fortify issue - Unreleased Resource: Streams RTC ticket #
			// 163006
			finally
			{
				if(fis != null)
				{
					try
					{
						fis.close();
					}
					catch(IOException e)
					{
						logger.error("error occurred: ", e);
					}
				}
			}
		}

		return null;
	}

	public static byte[] convertDHtoByte(final DataHandler dh)
	{
		byte[] ret;

		if(dh == null)
		{
			return new byte[0];
		}
		try
		{
			ret = IOUtils.toByteArray(dh.getInputStream());
		}
		catch(IOException e)
		{
			logger.error("error occurred: ", e);
			return new byte[0];
		}
		return ret;
	}

	public static DataHandler convertDocument(final DataHandler inDoc)
	{
		// Maybe surround with try catch and if conversion fails log error and
		// do not setRawData.
		try
		{
			byte[] data = convertDocument(convertDHtoByte(inDoc));
			// If you need to create a new hash add it here.
			ByteDS ds = new ByteDS(data);
			return new DataHandler(ds);
		}
		catch(Exception e)
		{
			logger.error("error occurred: ", e);
		}
		return inDoc;
	}

	public static void convertDocument(final Document inDoc)
	{
		// Maybe surround with try catch and if conversion fails log error and
		// do not setRawData.
		try
		{
			byte[] data = convertDocument(inDoc.getRawData());
			inDoc.setRawData(data);
			inDoc.setSize(data.length);
			// If you need to create a new hash add it here.
		}
		catch(Exception e)
		{
			logger.error("error occurred: ", e);
		}
	}

	public static byte[] convertDocument(final byte[] bytes)
	{
		try
		{
			StandardizeXML standardize = new StandardizeXML();

			standardize.setDocBytes(bytes);
			return standardize.processDocument();
		}
		catch(Exception e)
		{
			logger.error("error occurred: ", e);
		}

		return bytes;
	}
}
