package gov.va.med.nhin.adapter.policyengine.pdpproxy;

import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.xml.namespace.QName;

import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import gov.va.med.nhin.vap.server.service.permission.contexthandler.XACMLContextHandlerPortType;
import gov.va.med.nhin.vap.server.service.permission.contexthandler.XACMLContextHandlerService;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;

/**
 *
 * @author VHAISBVAZQUD
 */
@Stateless(name = "PDPProxyVAP")
public class PDPProxyVAP implements PDPProxyLocal
{
	private XACMLContextHandlerService xacmlContextHandlerService;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public ResponseType checkPolicy(RequestType request)
	{
		return getXACMLContextHandlerPort().checkPolicy(request);
	}

	private XACMLContextHandlerPortType getXACMLContextHandlerPort()
	{
		if(xacmlContextHandlerService == null)
		{
			try
			{
				xacmlContextHandlerService = new XACMLContextHandlerService(new URL(propertyLookup.getProperty("XACMLContextHandlerServiceWSDL")), new QName("http://contexthandler.permission.service.server.vap.nhin.domain.ext/", "XACMLContextHandlerService"));
			}
			catch(Throwable t)
			{
				throw new RuntimeException("Unable to get XACMLContextHandlerPort.");
			}
		}

		return xacmlContextHandlerService.getXACMLContextHandlerPort();
	}
}
