package gov.va.med.nhin.adapter.policyengine;

import java.util.List;

import javax.ejb.Stateless;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResultType;

/**
 *
 * @author David Vazquez
 *
 *         inputs checkPolicyRequest
 *
 *         returns boolean true authorized => DecisionType.PERMIT false not
 *         authorized => DecisionType.DENY
 *
 *         if the passed in ICN from the request is found in the OPTEDIN patient
 *         list then they are authorized
 *
 *
 */

@Stateless(name = "AdapterPolicyEnginePermit")
public class AdapterPolicyEnginePermit implements AdapterPolicyEnginePortTypeLocal
{
	private static Logger logger = LoggerFactory.getLogger(AdapterPolicyEnginePermit.class.getName());

	public CheckPolicyResponseType checkPolicy(CheckPolicyRequestType checkPolicyRequest)
	{
		logger.debug("checkPolicy () invoked");

		gov.hhs.fha.nhinc.common.nhinccommonadapter.ObjectFactory objFactory = new gov.hhs.fha.nhinc.common.nhinccommonadapter.ObjectFactory();

		CheckPolicyResponseType checkPolicyResponse = objFactory.createCheckPolicyResponseType();
		ResponseType response = new ResponseType();
		checkPolicyResponse.setResponse(response);

		logger.debug("Checkpolicy Response {} : ", checkPolicyResponse.getResponse());

		List<ResultType> results = response.getResult();
		ResultType result = new ResultType();
		result.setDecision(DecisionType.PERMIT);
		results.add(result);

		logger.debug("checkPolicy () exited");

		return checkPolicyResponse;
	}
}
