package gov.va.med.nhin.adapter.patientdiscovery;

import gov.va.nvap.privacy.ConsentDirectiveAuthorizationRequestType;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationResponseType;
import gov.va.nvap.privacy.ConsentDirectiveDocumentRetrieveRequestType;
import gov.va.nvap.privacy.ConsentDirectiveDocumentRetrieveResponseType;
import gov.va.nvap.privacy.ConsentDirectiveExpirationRequestType;
import gov.va.nvap.privacy.ConsentDirectiveExpirationResponseType;
import gov.va.nvap.privacy.ConsentDirectiveQueryRequestType;
import gov.va.nvap.privacy.ConsentDirectiveQueryResponseType;
import gov.va.nvap.privacy.ConsentDirectiveRevocationRequestType;
import gov.va.nvap.privacy.ConsentDirectiveRevocationResponseType;
import gov.va.nvap.privacy.OrganizationsQueryRequestType;
import gov.va.nvap.privacy.OrganizationsQueryResponseType;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.jws.WebService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import privacy.service.nvap.domain.ConsentManagementServiceFaultMessage;

/**
 *
 * @author Zack Peterson
 */
@WebService(serviceName = "ConsentManagementService", portName = "ConsentManagementPortType", endpointInterface = "privacy.service.nvap.domain.ConsentManagementPortType", targetNamespace = "http://gov.va.nvap.service.privacy/")
@Stateless(name = "VapConsentManagement")
public class VapConsentManagement implements VapConsentManagementPortTypeLocal
{
	private static final Logger logger = LoggerFactory.getLogger(VapConsentManagement.class.getName());

	private CMProxy cmProxy;

	@EJB(beanInterface = CMProxy.class, beanName = "CMProxyVAP")
	public void setCMProxy(CMProxy cmProxy)
	{
		this.cmProxy = cmProxy;
	}

	public ConsentDirectiveQueryResponseType getConsentDirectives(ConsentDirectiveQueryRequestType consentDirectiveQueryRequest) throws ConsentManagementServiceFaultMessage
	{
		logger.debug("getConsentDirectives {}", consentDirectiveQueryRequest);

		ConsentDirectiveQueryResponseType response = cmProxy.getConsentDirectives(consentDirectiveQueryRequest);

		return response;
	}

	public ConsentDirectiveExpirationResponseType getExpiringConsentDirectives(ConsentDirectiveExpirationRequestType consentDirectiveExpirationRequest) throws ConsentManagementServiceFaultMessage
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public ConsentDirectiveExpirationResponseType getExpiringDetailedConsentDirectives(ConsentDirectiveExpirationRequestType consentDirectiveExpirationRequest) throws ConsentManagementServiceFaultMessage
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public ConsentDirectiveExpirationResponseType getAuthorizedConsentForSummary(ConsentDirectiveExpirationRequestType consentDirectiveAuthorizedRequest) throws ConsentManagementServiceFaultMessage
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public ConsentDirectiveDocumentRetrieveResponseType getConsentDirectiveDocuments(ConsentDirectiveDocumentRetrieveRequestType consentDirectiveDocumentRetrieveRequest) throws ConsentManagementServiceFaultMessage
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public ConsentDirectiveAuthorizationResponseType processConsentDirectiveUpdate(ConsentDirectiveRevocationRequestType consentDirectiveUpdateRequest) throws ConsentManagementServiceFaultMessage
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public ConsentDirectiveAuthorizationResponseType processConsentDirectiveAuthorization(ConsentDirectiveAuthorizationRequestType consentDirectiveAuthorizationRequest) throws ConsentManagementServiceFaultMessage
	{
		logger.debug("processConsentDirectiveAuthorization {}", consentDirectiveAuthorizationRequest);

		ConsentDirectiveAuthorizationResponseType response = cmProxy.processConsentDirectiveAuthorization(consentDirectiveAuthorizationRequest);

		return response;
	}

	public ConsentDirectiveRevocationResponseType processConsentDirectiveRevocation(ConsentDirectiveRevocationRequestType consentDirectiveRevocationRequest) throws ConsentManagementServiceFaultMessage
	{
		logger.debug("processConsentDirectiveRevocation {}", consentDirectiveRevocationRequest);

		ConsentDirectiveRevocationResponseType response = cmProxy.processConsentDirectiveRevocation(consentDirectiveRevocationRequest);

		return response;
	}

	public OrganizationsQueryResponseType getOrganizations(OrganizationsQueryRequestType organizationsQueryRequest) throws ConsentManagementServiceFaultMessage
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}
}