package gov.va.med.nhin.adapter.patientcorrelation.parsers.PRPAIN201309UV;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.hl7.v3.II;
import org.hl7.v3.PRPAIN201309UV02;
import org.hl7.v3.PRPAIN201309UV02QUQIMT021001UV01ControlActProcess;
import org.hl7.v3.PRPAMT201307UV02DataSource;
import org.hl7.v3.PRPAMT201307UV02ParameterList;
import org.hl7.v3.PRPAMT201307UV02PatientIdentifier;
import org.hl7.v3.PRPAMT201307UV02QueryByParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author svalluripalli
 */
public class PRPAIN201309UVParser
{
	// CCR 177986
	private static final Logger logger = LoggerFactory.getLogger(PRPAIN201309UVParser.class);

	public static PRPAMT201307UV02ParameterList parseHL7ParameterListFrom201309Message(PRPAIN201309UV02 message)
	{
		if(message == null)
		{
			return null;
		}
		PRPAIN201309UV02QUQIMT021001UV01ControlActProcess ctrlAccess = message.getControlActProcess();
		if(ctrlAccess == null)
		{
			return null;
		}
		JAXBElement<PRPAMT201307UV02QueryByParameter> queryByParameter = ctrlAccess.getQueryByParameter();
		if(queryByParameter == null)
		{
			return null;
		}
		PRPAMT201307UV02ParameterList parameterList = (queryByParameter.getValue() != null) ? queryByParameter.getValue().getParameterList() : null;
		if(parameterList == null)
		{
			return null;
		}
		return parameterList;
	}

	public static PRPAMT201307UV02PatientIdentifier parseHL7PatientPersonFrom201309Message(PRPAIN201309UV02 message)
	{
		logger.debug("Begin PRPAIN201309UVParser.parseHL7PatientPersonFrom201309Message()");
		
		PRPAMT201307UV02ParameterList parameterList = parseHL7ParameterListFrom201309Message(message);

		// CCR 177986 - logger updates
		logger.debug(" PRPAMT201307UV02ParameterList parameterList {}", parameterList);

		PRPAMT201307UV02PatientIdentifier patientIdentifier = (parameterList.getPatientIdentifier() != null) ? parameterList.getPatientIdentifier().get(0) : null;

		// CCR 177986 - logger updates
		logger.debug("PRPAMT201307UV02PatientIdentifier patientIdentifier {}", patientIdentifier);
		logger.debug("End PRPAIN201309UVParser.parseHL7PatientPersonFrom201309Message()");
	
		return patientIdentifier;
	}

	public static List<II> buildAssigningAuthorityInclusionFilterList(PRPAIN201309UV02 message)
	{
		List<II> list = new ArrayList<II>();
		PRPAMT201307UV02ParameterList parameterList = parseHL7ParameterListFrom201309Message(message);

		// CCR 177986 - logger updates
		logger.debug(" PRPAMT201307UV02ParameterList parameterList {}", parameterList);

		List<PRPAMT201307UV02DataSource> dataSourceList;
		if(parameterList != null)
		{
			dataSourceList = parameterList.getDataSource();
			for(PRPAMT201307UV02DataSource dataSource : dataSourceList)
			{
				for(II dataSourceValue : dataSource.getValue())
				{
					list.add(dataSourceValue);
				}
			}
		}

		// CCR 177986 - logger updates
		logger.debug("II list size {}", list.size());

		return list;
	}

	public static JAXBElement<PRPAMT201307UV02QueryByParameter> ExtractQueryId(PRPAIN201309UV02 message)
	{
		JAXBElement<PRPAMT201307UV02QueryByParameter> queryByParameter = null;
		if(message.getControlActProcess() != null)
		{
			queryByParameter = message.getControlActProcess().getQueryByParameter();
		}
		return queryByParameter;
	}

	public static List<String> extractDataSourceList(PRPAIN201309UV02 message)
	{
		List<String> dataSourceStringList = new ArrayList<String>();
		PRPAMT201307UV02ParameterList parameterList = PRPAIN201309UVParser.parseHL7ParameterListFrom201309Message(message);
		List<PRPAMT201307UV02DataSource> dataSources = parameterList.getDataSource();

		if(dataSources != null)
		{
			for(PRPAMT201307UV02DataSource datasource : dataSources)
			{
				for(II value : datasource.getValue())
				{
					dataSourceStringList.add(value.getRoot());
				}
			}
		}

		// CCR 177986 - logger updates
		logger.debug("dataSourcesList size {}", dataSourceStringList.size());

		return dataSourceStringList;
	}
}
