package gov.va.med.nhin.adapter.patientcorrelation.parsers.PRPAIN201301UV;

import java.util.List;

import javax.xml.bind.JAXBElement;

import org.hl7.v3.CE;
import org.hl7.v3.PRPAIN201301UV02MFMIMT700701UV01ControlActProcess;
import org.hl7.v3.PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent;
import org.hl7.v3.PRPAIN201301UV02MFMIMT700701UV01Subject1;
import org.hl7.v3.PRPAIN201301UV02MFMIMT700701UV01Subject2;
import org.hl7.v3.PRPAMT201301UV02Patient;
import org.hl7.v3.PRPAMT201301UV02Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author svalluripalli
 */
public class PRPAIN201301UVParser
{
	private static final Logger log = LoggerFactory.getLogger(PRPAIN201301UVParser.class);

	/**
	 * This method gets the patientPerson from HL7V3 message of type
	 * PRPAIN201301UV
	 * 
	 * @param message of type PRPAIN201301UV
	 * @return PRPAMT201301UVPerson
	 */
	public static PRPAMT201301UV02Patient ParseHL7PatientPersonFrom201301Message(org.hl7.v3.PRPAIN201301UV02 message)
	{
		// assume one subject for now
		PRPAMT201301UV02Patient patient = ParseHL7PatientFromMessage(message);

		return patient;
	}

	/**
	 * This method extracts Patient of type HL7V3 PRPAMT201301UVPatient from
	 * HL7V3 PRPAIN201301UV
	 * 
	 * @param message of type PRPAIN201301UV
	 * @return PRPAMT201301UVPatient
	 */
	public static PRPAMT201301UV02Patient ParseHL7PatientFromMessage(org.hl7.v3.PRPAIN201301UV02 message)
	{
		PRPAMT201301UV02Patient patient = null;
		log.debug("in ExtractPatient");

		PRPAIN201301UV02MFMIMT700701UV01Subject1 subject = ParseSubjectFromMessage(message);
		if(subject == null)
		{
			return null;
		}
		PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent registrationevent = subject.getRegistrationEvent();
		if(registrationevent == null)
		{
			log.debug("registrationevent is null - no patient");
			return null;
		}

		// CCR 177986 - {} = logs if only debugging enabled
		log.debug("registration Event {} : ", registrationevent);

		PRPAIN201301UV02MFMIMT700701UV01Subject2 subject1 = registrationevent.getSubject1();
		if(subject1 == null)
		{
			log.debug("subject1 is null - no patient");
			return null;
		}

		// CCR 177986 - {} = logs if only debugging enabled
		log.debug("subject value from subject1 is {}  : ", subject1);

		patient = subject1.getPatient();
		if(patient == null)
		{
			log.debug("patient is null - no patient");
			return null;
		}

		// CCR 177986 - {} = logs if only debugging enabled
		log.debug("done with ExtractPatient");
		log.debug("patient info from Subject1 {} : ", patient);

		return patient;
	}

	public static PRPAIN201301UV02MFMIMT700701UV01Subject1 ParseSubjectFromMessage(org.hl7.v3.PRPAIN201301UV02 message)
	{
		// assume one subject for now
		if(message == null)
		{
			log.debug("message is null - no patient");
			return null;
		}

		// CCR 177986 - {} = logs if only debugging enabled
		log.debug("message details {}", message);

		PRPAIN201301UV02MFMIMT700701UV01ControlActProcess controlActProcess = message.getControlActProcess();
		if(controlActProcess == null)
		{
			log.debug("controlActProcess is null - no patient");
			return null;
		}

		// CCR 177986 - {} = logs if only debugging enabled
		log.debug("message details {}", message);

		List<PRPAIN201301UV02MFMIMT700701UV01Subject1> subjects = controlActProcess.getSubject();
		if((subjects == null) || (subjects.size() == 0))
		{
			log.debug("subjects is blank/null - no patient");
			return null;
		}

		// CCR 177986 - {} = logs if only debugging enabled
		log.debug("subjects from the message {} ", subjects);

		// for now, assume we only need one subject, this will need to be
		// modified later
		PRPAIN201301UV02MFMIMT700701UV01Subject1 subject = subjects.get(0);

		log.debug("Subject details {} ", subject);

		return subject;
	}

	/**
	 * This method returns patientPerson extracted from PRPAMT201301UVPatient
	 * using JAXB Element
	 * 
	 * @param patient of type PRPAMT201301UVPatient
	 * @return PRPAMT201301UVPerson
	 */
	public static PRPAMT201301UV02Person ParseHL7PatientPersonFromHL7Patient(PRPAMT201301UV02Patient patient)
	{
		JAXBElement<PRPAMT201301UV02Person> patientPersonElement = patient.getPatientPerson();
		PRPAMT201301UV02Person patientPerson = patientPersonElement.getValue();

		// CCR 177986 - {} = logs if only debugging enabled
		log.debug("Patient's details {}", patientPerson);

		return patientPerson;
	}

	public static String ExtractGender(PRPAMT201301UV02Person person)
	{
		String genderCode = null;
		CE administrativeGenderCode = person.getAdministrativeGenderCode();
		if(administrativeGenderCode == null)
		{
			log.debug("message does not contain a gender code");
		}
		else
		{
			// CCR 177986 - {} = logs if only info is enabled
			log.debug("person.getAdministrativeGenderCode().getCode() {} = ", person.getAdministrativeGenderCode().getCode());
			log.debug("person.getAdministrativeGenderCode().getDisplayName() {} = ", person.getAdministrativeGenderCode().getDisplayName());

			genderCode = person.getAdministrativeGenderCode().getCode();
		}
		return genderCode;
	}

	public static String ExtractBirthdate(PRPAMT201301UV02Person person)
	{
		String birthDate = null;
		if(person.getBirthTime() == null)
		{
			log.debug("message does not contain a birthtime");
		}
		else
		{
			birthDate = person.getBirthTime().getValue();

			log.debug("birth date {} ", birthDate);

			if(birthDate == null)
			{
				log.debug("message does not contain a birthtime");
			}
			else
			{
				log.debug("person.getBirthTime().getValue() {}", person.getBirthTime().getValue());
			}
		}

		return birthDate;
	}
}
