package gov.va.med.nhin.adapter.logging;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.va.med.nhin.adapter.utils.NullChecker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AdhocQueryType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author serverchmarc
 *
 */
public class MaintLog
{
	private static Logger logger = LoggerFactory.getLogger(MaintLog.class.getName());

	// CCR 177986- added logger as a parameter
	public static void queryError(final Object obj, final String errorText, Logger logger)
	{
		AdhocQueryType adhocQuery = null;
		AssertionType assertionType = null;

		if(obj != null)
		{
			Method methods[] = obj.getClass().getMethods();
			for(Method method : methods)
			{
				if("getAdhocQueryRequest".equalsIgnoreCase(method.getName()))
				{
					// Should be AdHocQueryRequest
					Object reqObj = null;

					try
					{
						reqObj = method.invoke(obj);
					}
					// CCR 179231
					catch(IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
					{
						// CCR 177986
						logger.error("Failed to parse incoming object methods {}", e);
					}

					if(reqObj instanceof AdhocQueryRequest)
					{
						AdhocQueryRequest request = (AdhocQueryRequest) reqObj;
						adhocQuery = request.getAdhocQuery();
					}
				}
				else if("getAssertion".equalsIgnoreCase(method.getName()))
				{
					// Should be the assertion.
					Object reqObj = null;

					try
					{
						reqObj = method.invoke(obj);
					}
					// CCR 179231
					catch(IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
					{
						// CCR 177986
						logger.error("Failed to parse incoming object methods {}", e);
					}

					if(reqObj instanceof AssertionType)
					{
						assertionType = (AssertionType) reqObj;
					}
				}
			}

			logQueryError(adhocQuery, assertionType, errorText);
		}
	}

	// CCR 177986- added logger as a parameter
	public static void queryError(final Object respondingGatewayType, final ErrorMessage errorText, Logger logger)
	{
		queryError(respondingGatewayType, errorText.getMessage(), logger);
	}

	// CCR 177986- added logger as a parameter
	public static void queryError(final Object respondingGatewayType, final ErrorMessage errorText, final String additionalInfo, Logger logger)
	{
		String errorDetails = additionalInfo;
		
		if(errorText != null)
		{
			errorDetails = errorText.getMessage() + ": " + additionalInfo;
		}
		
		queryError(respondingGatewayType, errorDetails, logger);
	}

	public static String adHocQueryError(final AdhocQueryType queryType)
	{
		StringBuilder sb = new StringBuilder();
		if(queryType != null)
		{
			String queryId = StringUtils.isNotBlank(queryType.getId()) ? queryType.getId() : "Missing";
			sb.append("\tQuery ID:").append(queryId).append("\n");
			String queryHCID = StringUtils.isNotBlank(queryType.getHome()) ? queryType.getHome() : "Missing";
			sb.append("\tQuery HCID:").append(queryHCID).append("\n");
			if(CollectionUtils.isNotEmpty(queryType.getSlot()))
			{
				Map<String, List<String>> slots = getMapFromSlots(queryType.getSlot());
				for(Entry<String, List<String>> entry : slots.entrySet())
				{
					sb.append("\t").append(entry.getKey()).append(": ");

					for(Iterator<String> iter = entry.getValue().iterator(); iter.hasNext();)
					{
						String value = iter.next();
						if(StringUtils.isNotBlank(value))
						{
							sb.append(value);
							if(iter.hasNext())
							{
								sb.append(", ");
							}
						}
					}
					sb.append("\n");
				}
			}
		}
		else
		{
			sb.append("All Document Query parameters are missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static String assertionError(final AssertionType assertionType)
	{
		StringBuilder sb = new StringBuilder();
		if(assertionType != null)
		{
			String hcid = assertionType.getHomeCommunity() != null && StringUtils.isNotBlank(assertionType.getHomeCommunity().getHomeCommunityId()) ? assertionType.getHomeCommunity().getHomeCommunityId() : "Missing";
			sb.append("\tAssertion HCID: ").append(hcid).append("\n");
		}
		else
		{
			sb.append("Document Query Assertion is missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static void logQueryError(final AdhocQueryType queryType, AssertionType assertionType, final String errorText)
	{
		StringBuilder sb = new StringBuilder();

		sb.append(LoggingUtils.ERROR_PREFIX).append(" ").append(errorText).append("\n");
		sb.append(adHocQueryError(queryType));
		sb.append(assertionError(assertionType));

		//CCR 177986- logging updates
		logger.error("error string {} ", sb);
	}

	private static Map<String, List<String>> getMapFromSlots(List<SlotType1> slots)
	{
		HashMap<String, List<String>> ret = new HashMap<String, List<String>>();

		for(SlotType1 slot : slots)
		{
			if(NullChecker.isNotNullOrEmpty(slot.getName()) && NullChecker.isNotNullOrEmpty(slot.getValueList()) && NullChecker.isNotNullOrEmpty(slot.getValueList().getValue()))
			{
				List<String> values = ret.get(slot.getName());
				if(values == null)
				{
					values = new ArrayList<String>();
					ret.put(slot.getName(), values);
				}
				values.addAll(slot.getValueList().getValue());
			}
		}

		return ret;
	}
}
