package gov.va.med.nhin.adapter.docretrieve;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.adapterdocretrieve.AdapterDocRetrievePortType;
import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.common.eventcommon.DocRetrieveEventType;
import gov.hhs.fha.nhinc.common.eventcommon.DocRetrieveMessageType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.PolicyEngineTransformer;
import gov.va.med.nhin.adapter.errors.CreateErrorInterface;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.utils.NullChecker;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocRetrieveSoap12", portName = "AdapterDocRetrievePortSoap", endpointInterface = "gov.hhs.fha.nhinc.adapterdocretrieve.AdapterDocRetrievePortType", targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocretrieve", wsdlLocation = "META-INF/wsdl/AdapterDocRetrieveSoap12.wsdl")
@BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
@Stateless(name = "AdapterDocRetrieve")
public class AdapterDocRetrieve implements AdapterDocRetrievePortTypeLocal
{
	private static final Logger logger = LoggerFactory.getLogger(AdapterDocRetrieve.class.getName());

	static private final String ERROR_XDS_REPOSITORY_ERROR = "XDSRepositoryError";
	static private final String ERROR_DESC_XDS_REPOSITORY_ERROR = "Internal Registry/Repository Error";
	static private final String ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR = "XDSDocumentUniqueIdError";
	static private final String ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR = "Document is not Available";

	private AdapterDocRetrievePortType docRetrieve;
	private AdapterPolicyEnginePortType policyEngine;
	private FacilityManager facilityManager;
	private CreateErrorInterface errorResponse;

	@EJB(beanInterface = CreateErrorInterface.class, beanName = "CreateResponseError")
	public void setErrorResponse(CreateErrorInterface errorResponse)
	{
		this.errorResponse = errorResponse;
	}

	@EJB(beanInterface = AdapterDocRetrievePortTypeLocal.class, beanName = "DocRetrieve")
	public void setDocRetrieve(AdapterDocRetrievePortType docRetrieve)
	{
		this.docRetrieve = docRetrieve;
	}

	@EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
	public void setPolicyEngine(AdapterPolicyEnginePortType policyEngine)
	{
		this.policyEngine = policyEngine;
	}

	@EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
	public void setFacilityManager(FacilityManager facilityManager)
	{
		this.facilityManager = facilityManager;
	}

	public RetrieveDocumentSetResponseType respondingGatewayCrossGatewayRetrieve(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
	{
		String partnerCommunityId = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
		logger.debug("Starting  AdapterDocRetrieveA (2010 Spec) - Call and Partner Homecommunity ID is {} ", partnerCommunityId); // CCR177986

		RetrieveDocumentSetResponseType ret = null;

		try
		{
			if(facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.ONBOARD))
			{
				if(facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.IN_DR))
				{
					if(checkPolicy(respondingGatewayCrossGatewayRetrieveRequest))
					{

						ret = docRetrieve.respondingGatewayCrossGatewayRetrieve(respondingGatewayCrossGatewayRetrieveRequest);
						logger.debug("for valid policy RetrieveDocumentSetResponseType ret {} ", ret);
					}
					else
					{
						ret = errorResponse.createRetrieveDocumentError(ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR, ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR);

						// CCR 177986 - logging
						logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
					}

				}
				else
				{
					logger.debug("NOT ALLOWED TO DO DR - It is turned OFF");
					ret = errorResponse.createRetrieveDocumentError(ErrorMessage.IN_DR_DISABLED);

					// CCR 177986 - logging
					logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
				}
			}
			else
			{
				logger.debug("<<<<NOT ALLOWED TO ANY OPERATIONS - NOT INBOARD TO VA >>>>>> {}");
				ret = errorResponse.createRetrieveDocumentError(ErrorMessage.IN_DR_NOT_A_PARTNER);

				// CCR 177986 - logging
				logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
			}
		}
		catch(Throwable t)
		{
			String hcid;
			String hcidName;
			if(respondingGatewayCrossGatewayRetrieveRequest.getAssertion() != null && respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity() != null)
			{
				hcid = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
				hcidName = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getName();
			}
			else
			{
				hcid = "N/A";
				hcidName = "Not Available";
			}

			// CCR 177986
			logger.error("Error processing DocRetrieve from {} {} - {}", hcid, hcidName, t.getMessage());
			logger.error("Stack trace for AdapterDocRetrieveA (2010 Spec) {} ", t);
			ret = errorResponse.createRetrieveDocumentError(ERROR_XDS_REPOSITORY_ERROR, ERROR_DESC_XDS_REPOSITORY_ERROR);

			// CCR 177986 - logging
			logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
		}

		return ret;
	}

	private boolean checkPolicy(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
	{
		DocRetrieveMessageType docRetrieveMessage = new DocRetrieveMessageType();
		docRetrieveMessage.setAssertion(respondingGatewayCrossGatewayRetrieveRequest.getAssertion());
		docRetrieveMessage.setRetrieveDocumentSetRequest(respondingGatewayCrossGatewayRetrieveRequest.getRetrieveDocumentSetRequest());

		DocRetrieveEventType docRetrieveEvent = new gov.hhs.fha.nhinc.common.eventcommon.DocRetrieveEventType();

		// CCR 177986
		logger.debug("docRetrieveMessage {}", docRetrieveMessage);

		docRetrieveEvent.setMessage(docRetrieveMessage);
		docRetrieveEvent.setDirection(NhincConstants.POLICYENGINE_INBOUND_DIRECTION);

		// CCR 177986
		logger.debug(" docRetrieveEvent {}", docRetrieveEvent);

		PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
		CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformDocRetrieveToCheckPolicy(docRetrieveEvent);

		// CCR 177986
		logger.debug("CheckPolicyRequestType checkPolicyRequest {}", checkPolicyRequest);

		CheckPolicyResponseType checkPolicyResponse = policyEngine.checkPolicy(checkPolicyRequest);

		// CCR 177986
		logger.debug("CheckPolicyResponseType checkPolicyResponse {}", checkPolicyResponse);

		return checkPolicyResponse != null && checkPolicyResponse.getResponse() != null && NullChecker.isNotNullOrEmpty(checkPolicyResponse.getResponse().getResult()) && checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
	}
}
