package gov.va.med.nhin.adapter.docquery;

import java.util.List;

public class QueryParamStringToValueList
{
	public static ValueList translate(Object input)
	{
		ValueList result = new ValueList();

		if(input != null)
		{
			if(!(input instanceof List || input instanceof String))
			{
				throw new RuntimeException("input must be a string or a list of strings.");
			}

			if(input instanceof List)
			{
				List<String> inputAsList = (List) input;

				for(String item : inputAsList)
				{
					parseParamFormattedString(result, item);
					// addToResult(result, parseParamFormattedString(item));
				}
			}
			else
			{
				parseParamFormattedString(result, (String) input);
				// addToResult(result, );
			}
		}

		return result;
	}

	public static void parseParamFormattedString(ValueList valueList, String paramFormattedString)
	{
		if(paramFormattedString != null)
		{
			if(paramFormattedString.startsWith("("))
			{
				String working = paramFormattedString.substring(1);
				int endIndex = working.indexOf(")");
				if(endIndex != -1)
				{
					working = working.substring(0, endIndex);
				}
				String[] multiValueString = working.split(",");
				if(multiValueString != null)
				{
					for(int i = 0; i < multiValueString.length; i++)
					{
						String singleValue = multiValueString[i];
						if(singleValue != null)
						{
							singleValue = singleValue.trim();
						}
						singleValue = processSingleValue(singleValue);
						addToResult(valueList, singleValue);
					}
				}
			}
			else
			{
				addToResult(valueList, processSingleValue(paramFormattedString));
			}
		}
	}

	private static String processSingleValue(String singleValue)
	{
		if(singleValue.startsWith("'"))
		{
			singleValue = singleValue.substring(1);
			int endTickIndex = singleValue.indexOf("'");
			if(endTickIndex != -1)
			{
				singleValue = singleValue.substring(0, endTickIndex);
			}
		}

		return singleValue;
	}

	private static void addToResult(ValueList valueList, String singleValue)
	{
		valueList.add(new StringValue(singleValue));
	}
}
