package gov.va.med.nhin.adapter.connectionmanager;

import gov.hhs.fha.nhinc.common.connectionmanagerinfo.AssigningAuthorityIdType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.EmptyParameterType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.EndpointURLType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetAdapterEndpointURLRequestType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetAssigningAuthoritiesByHomeCommunityResponseType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetBusinessEntityByServiceNameRequestType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetBusinessEntitySetByServiceNameRequestType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetDefaultEndpointURLByServiceNameRequestType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetEndpointURLFromNhinTargetCommunitiesRequestType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetEndpointURLFromNhinTargetCommunitiesResponseType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.GetEndpointURLFromNhinTargetRequestType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.HomeCommunityIdListType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.HomeCommunityIdType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.ServiceNameType;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.SuccessOrFailType;
import gov.hhs.fha.nhinc.nhinccomponentconnectionmanager.NhincComponentConnectionManager;
import gov.hhs.fha.nhinc.nhinccomponentconnectionmanager.NhincComponentConnectionManagerPortType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.xml.namespace.QName;

import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;

/**
 * 
 * @author VHAISBVAZQUD
 */
@Stateless(name = "NhincComponentConnectionManagerWS")
public class NhincComponentConnectionManagerPortTypeWS implements NhincComponentConnectionManagerPortTypeLocal
{
	private NhincComponentConnectionManager connectionManager;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	/**
	 * <PRE>
	 * public ConnectionInfosType getAllConnectionInfoSetByServiceName(GetAllConnectionInfoSetByServiceNameRequestType g)
	 * {
	 * 	return getConnectionManagerPort().getAllConnectionInfoSetByServiceName(g);
	 * }
	 * </PRE>
	 * 
	 * Is replaced by the following.
	 **/
	public BusinessDetail getAllBusinessEntitySetByServiceName(ServiceNameType body)
	{
		return getConnectionManagerPort().getAllBusinessEntitySetByServiceName(body);
	}

	private NhincComponentConnectionManagerPortType getConnectionManagerPort()
	{
		if(connectionManager == null)
		{
			try
			{
				connectionManager = new NhincComponentConnectionManager(new URL(propertyLookup.getProperty("ConnectionManagerWSDL")), new QName("urn:gov:hhs:fha:nhinc:nhinccomponentconnectionmanager", "NhincComponentConnectionManager"));
			}
			catch(Throwable t)
			{
				throw new RuntimeException("Unable to get ConnectionManagerPort.");
			}
		}

		return connectionManager.getNhincComponentConnectionManagerPortSoap();
	}

	public HomeCommunityIdType getHomeCommunityByAssigningAuthority(AssigningAuthorityIdType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public BusinessDetail getBusinessEntitySetByServiceName(GetBusinessEntitySetByServiceNameRequestType getBusinessEntitySetByServiceNameRequest)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public SuccessOrFailType forceRefreshUDDICache(EmptyParameterType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public EndpointURLType getEndpointURLFromNhinTarget(GetEndpointURLFromNhinTargetRequestType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public BusinessDetail getAllBusinessEntities(EmptyParameterType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public GetAssigningAuthoritiesByHomeCommunityResponseType getAssigningAuthoritiesByHomeCommunity(HomeCommunityIdType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public SuccessOrFailType forceRefreshInternalConnectCache(EmptyParameterType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public BusinessEntity getBusinessEntityByServiceName(GetBusinessEntityByServiceNameRequestType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public GetEndpointURLFromNhinTargetCommunitiesResponseType getEndpointURLFromNhinTargetCommunities(GetEndpointURLFromNhinTargetCommunitiesRequestType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public EndpointURLType getAdapterEndpointURL(GetAdapterEndpointURLRequestType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public EndpointURLType getDefaultEndpointURLByServiceName(GetDefaultEndpointURLByServiceNameRequestType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public EndpointURLType getInternalEndpointURLByServiceName(ServiceNameType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public BusinessEntity getBusinessEntity(HomeCommunityIdType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public BusinessDetail getBusinessEntitySet(HomeCommunityIdListType body)
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}
}
