package gov.va.med.nhin.adapter.adaptergateway.patientdiscovery;

import java.net.MalformedURLException;
import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.xml.namespace.QName;

import org.hl7.v3.PRPAIN201305UV02;
import org.hl7.v3.PRPAIN201306UV02;
import org.hl7.v3.RespondingGatewayPRPAIN201305UV02RequestType;
import org.hl7.v3.RespondingGatewayPRPAIN201306UV02ResponseType;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.entitypatientdiscovery.EntityPatientDiscovery;
import gov.hhs.fha.nhinc.entitypatientdiscovery.EntityPatientDiscoveryPortType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

/**
 *
 * @author VHAISBVAZQUD
 */
@Stateless(name = "NhincProxyNHINPatientDiscoverySender")
public class NhincProxyNHINPatientDiscoverySender implements NHINPatientDiscoverySender
{
	private PropertyLookup propertyLookup;
	private EntityPatientDiscovery entityPatientDiscovery;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public PRPAIN201306UV02 sendRequest(PRPAIN201305UV02 prpain201305, AssertionType assertion, String remoteHomeCommunityId)
	{
		try
		{
			RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
			request.setAssertion(assertion);
			request.setPRPAIN201305UV02(prpain201305);
			request.setNhinTargetCommunities(createNhinTargetCommunities(remoteHomeCommunityId));

			RespondingGatewayPRPAIN201306UV02ResponseType response = getPatientDiscoveryEntityPort().respondingGatewayPRPAIN201305UV02(request);
			return response.getCommunityResponse().get(0).getPRPAIN201306UV02();
		}
		catch(Throwable t)
		{
			throw new RuntimeException(t);
		}
	}

	private NhinTargetCommunitiesType createNhinTargetCommunities(String homeCommunityId)
	{

		HomeCommunityType homeCommunity = new HomeCommunityType();
		homeCommunity.setHomeCommunityId(homeCommunityId);

		NhinTargetCommunityType homeTargetCommunity = new NhinTargetCommunityType();
		homeTargetCommunity.setHomeCommunity(homeCommunity);

		NhinTargetCommunitiesType ret = new NhinTargetCommunitiesType();
		ret.getNhinTargetCommunity().add(homeTargetCommunity);

		return ret;
	}

	private EntityPatientDiscoveryPortType getPatientDiscoveryEntityPort() throws MalformedURLException
	{
		if(entityPatientDiscovery == null)
		{
			entityPatientDiscovery = new EntityPatientDiscovery(new URL(propertyLookup.getProperty("PatientDiscoveryProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitypatientdiscovery", "EntityPatientDiscovery"));
		}

		return entityPatientDiscovery.getEntityPatientDiscoveryPortSoap();
	}

}
