package gov.va.med.nhin.adapter.adaptergateway.docretrieve;

import java.net.MalformedURLException;
import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrieve;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "NhincProxyNHINDocRetrieveRequestSender")
public class NhincProxyNHINDocRetrieveRequestSender implements NHINDocRetrieveRequestSender
{

	private static final Logger logger = LoggerFactory.getLogger(NhincProxyNHINDocRetrieveRequestSender.class.getName());

	private EntityDocRetrieve entityDocRetrieve;
	private EntityDocRetrieve entityDocRetrieve2011;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public RetrieveDocumentSetResponseType sendRequest(RetrieveDocumentSetRequestType docRetrieveRequest, AssertionType assertion, String remoteHomeCommunityId, boolean use2011Spec) throws MalformedURLException
	{
		// CCR 177986
		logger.debug("Entering NhincProxyNHINDocRetrieveRequestSender::sendRequest");

		gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType request = new gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType();
		request.setRetrieveDocumentSetRequest(docRetrieveRequest);
		request.setAssertion(assertion);
		request.setNhinTargetCommunities(createNhinTargetCommunities(remoteHomeCommunityId));

		logger.debug("Sending RD to SSA...");
		return getDocRetrieveEntityPort(use2011Spec).respondingGatewayCrossGatewayRetrieve(request);
	}

	private NhinTargetCommunitiesType createNhinTargetCommunities(String homeCommunityId)
	{
		HomeCommunityType homeCommunity = new HomeCommunityType();
		homeCommunity.setHomeCommunityId(homeCommunityId);

		NhinTargetCommunityType homeTargetCommunity = new NhinTargetCommunityType();
		homeTargetCommunity.setHomeCommunity(homeCommunity);

		NhinTargetCommunitiesType ret = new NhinTargetCommunitiesType();
		ret.getNhinTargetCommunity().add(homeTargetCommunity);

		return ret;
	}

	private EntityDocRetrievePortType getDocRetrieveEntityPort(boolean use2011Spec) throws MalformedURLException
	{
		if(use2011Spec)
		{
			if(entityDocRetrieve2011 == null)
			{
				entityDocRetrieve2011 = new EntityDocRetrieve(new URL(propertyLookup.getProperty("DocRetrieve2011ProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitydocretrieve", "EntityDocRetrieve"));
			}
			return entityDocRetrieve2011.getEntityDocRetrievePortSoap();
		}
		else
		{
			if(entityDocRetrieve == null)
			{
				entityDocRetrieve = new EntityDocRetrieve(new URL(propertyLookup.getProperty("DocRetrieveProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitydocretrieve", "EntityDocRetrieve"));
			}
			return entityDocRetrieve.getEntityDocRetrievePortSoap();

		}
	}
}
