package gov.va.med.nhin.adapter.adaptergateway.docretrieve;

import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.CeType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommon.SamlIssuerType;
import gov.hhs.fha.nhinc.common.nhinccommon.UserType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType;
import gov.va.med.nhin.adapter.adaptergateway.util.PrefetchConstants;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.audit.AuditManagerLocal;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.ejb.DataManagerLocal;
import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepositoryLocal;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.logging.EntityRetrieveError;
import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.policyengine.CheckPolicyRequestBuilder;
import gov.va.med.nhin.adapter.prefetch.RetrieveDocumentsResponse;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import gov.va.med.nhin.adapter.stylesheet.ConvertDocument;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.prefetch.PrefetchHelper;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType.DocumentRequest;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType.DocumentResponse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.jws.WebService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryErrorList;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;

/**
 *
 * @author spawaradmin
 */
@WebService(serviceName = "EntityDocRetrieve", portName = "EntityDocRetrievePortSoap11", endpointInterface = "gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType", targetNamespace = "urn:gov:hhs:fha:nhinc:entitydocretrieve", wsdlLocation = "META-INF/wsdl/EntityDocRetrieve.wsdl")
@Stateless(name = "EntityDocRetrieveBean")
public class EntityDocRetrieveBean implements EntityDocRetrievePortType
{
	private static final Logger logger = LoggerFactory.getLogger(EntityDocRetrieveBean.class.getName());

	private static final String PREFETCH_DOCUMENT_RETRIEVE_URL = "PREFETCH_DOCUMENT_RETRIEVE_URL";
	private static final String PREFETCH_CONNECTION_TIMEOUT_SECONDS = "PREFETCH_CONNECTION_TIMEOUT_SECONDS";
	private static final String PREFETCH_READ_TIMEOUT_SECONDS = "PREFETCH_READ_TIMEOUT_SECONDS";

	static private class InvalidDocIdException extends RuntimeException
	{
		private static final long serialVersionUID = 1L;
	}

	private FacilityManager facilityManager;
	private PropertyLookup propertyLookup;
	private AuditManager auditManager;
	private DocumentRepository documentRepository;
	private AdapterPolicyEnginePortType adapterPolicyEngine;
	private EntityDocRetrievePortType entityDocRetrieve;
	private DataManager dataManager;

	@EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
	public void setFacilityManager(FacilityManager facilityManager)
	{
		this.facilityManager = facilityManager;
	}

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	@EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
	public void setAuditManager(AuditManager auditManager)
	{
		this.auditManager = auditManager;
	}

	@EJB(beanInterface = DocumentRepositoryLocal.class, beanName = "DocumentRepository")
	public void setDocumentRepository(DocumentRepository documentRepository)
	{
		this.documentRepository = documentRepository;
	}

	@EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
	public void setAdapterPolicyEngine(AdapterPolicyEnginePortType adapterPolicyEngine)
	{
		this.adapterPolicyEngine = adapterPolicyEngine;
	}

	@EJB(beanInterface = EntityDocRetrievePortTypeLocal.class, beanName = "AdapterGatewayDocRetrieve")
	public void setEntityDocRetrieve(EntityDocRetrievePortType entityDocRetrieve)
	{
		this.entityDocRetrieve = entityDocRetrieve;
	}

	@EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
	public void setDataManager(DataManager dataManager)
	{
		this.dataManager = dataManager;
	}

	public RetrieveDocumentSetResponseType respondingGatewayCrossGatewayRetrieve(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
	{
		String partnerCommunityId = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
		logger.debug("Entering Outbound DocRetrieve call and Partner OID is {} ", partnerCommunityId); // CCR
																										// 177986

		boolean callFromPrefetch = false;
		boolean checkPrefetchCacheBool = false;

		String checkPrefetchCache = propertyLookup.getProperty(PrefetchConstants.PROPERTY_CHECK_PREFETCH_CACHE);
		if(checkPrefetchCache != null && checkPrefetchCache.equalsIgnoreCase("TRUE"))
		{
			checkPrefetchCacheBool = true;
			logger.trace("checking if the call is for prefetch " + partnerCommunityId);
			String prefetchHCID = propertyLookup.getProperty(PrefetchConstants.PROPERTY_PREFETCH_HOME_COMMUNITY_ID);
			String prefetchUserId = propertyLookup.getProperty(PrefetchConstants.PROPERTY_PREFETCH_USER_ID);
			String userIdInRequest = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getUserInfo().getUserName();
			if(partnerCommunityId.equalsIgnoreCase(prefetchHCID) && userIdInRequest != null && userIdInRequest.equalsIgnoreCase(prefetchUserId))
			{
				callFromPrefetch = true;
			}
		}
		RetrieveDocumentSetResponseType ret = new RetrieveDocumentSetResponseType();

		AssertionType assertion = respondingGatewayCrossGatewayRetrieveRequest.getAssertion();
		RetrieveDocumentSetRequestType body = respondingGatewayCrossGatewayRetrieveRequest.getRetrieveDocumentSetRequest();

		try
		{
			if(checkPolicy(assertion))
			{
				boolean prefetched = false;
				RetrieveDocumentsResponse prefetchedDocument = null;
				if(!callFromPrefetch && checkPrefetchCacheBool)
				{
					for(DocumentRequest docReq : body.getDocumentRequest())
					{
						// check if cached query exist in prefetch cache.
						logger.trace("checking if the prefetch data exist" + partnerCommunityId);
						Document document = documentRepository.getDocumentByDocumentUniqueId(docReq.getDocumentUniqueId());
						if(document == null)
						{
							throw new InvalidDocIdException();
						}

						Map<String, String> params = queryParamsToMap(document.getDocGenQueryParams());

						String repositoryId = params.get("documentRepositoryId");
						// ret.setHomeCommunityId(params.get("homeCommunityId"));
						String documentUniqueId = params.get("documentUniqueId");
						logger.trace("params:" + params);
						logger.trace("documentUniqueId From DB:" + documentUniqueId);
                        logger.trace("documentUniqueId From Request:" + docReq.getDocumentUniqueId());
						logger.trace("repositoryId:" + repositoryId);
						String url = propertyLookup.getProperty(PREFETCH_DOCUMENT_RETRIEVE_URL);
						Properties props = new Properties();
						String connectTimeout = propertyLookup.getProperty(PREFETCH_CONNECTION_TIMEOUT_SECONDS);
						String readTimeout = propertyLookup.getProperty(PREFETCH_READ_TIMEOUT_SECONDS);
						if(NullChecker.isNotNullOrEmpty(url))
						{
							props.setProperty("prefetch.service.url", url);
						}
						if(NullChecker.isNotNullOrEmpty(connectTimeout))
						{
							props.setProperty("prefetch.connect.timeout", connectTimeout);
						}
						if(NullChecker.isNotNullOrEmpty(readTimeout))
						{
							props.setProperty("prefetch.read.timeout", readTimeout);
						}

                        //Prefetch uses the adatper generated id's.
                        RetrieveDocumentsResponse tempPrefetchedDocument = PrefetchHelper.retrieveDocuments(props, docReq.getDocumentUniqueId(), documentUniqueId, repositoryId);
						if(tempPrefetchedDocument != null && NullChecker.isNotNullOrEmpty(tempPrefetchedDocument.getDocumentResponse()))
						{
							prefetched = true;
							if(prefetchedDocument == null)
							{
								prefetchedDocument = tempPrefetchedDocument;
							}
							else
							{
								prefetchedDocument.getDocumentResponse().addAll(tempPrefetchedDocument.getDocumentResponse());
							}
						}

					}
				}
				// change code to support more than one.

				RetrieveDocumentSetResponseType retrieveResponse = null;
				gov.hhs.fha.nhinc.common.nhinccommonentity.ObjectFactory objFactory = new gov.hhs.fha.nhinc.common.nhinccommonentity.ObjectFactory();
				RespondingGatewayCrossGatewayRetrieveRequestType request = objFactory.createRespondingGatewayCrossGatewayRetrieveRequestType();
				Map<String, Document> documents = new HashMap<String, Document>();
				request.setRetrieveDocumentSetRequest(createRetrieveDocumentSetRequest(body, documents));
				request.setAssertion(createAssertion(assertion, documents.values()));

				if(!prefetched)
				{

					retrieveResponse = entityDocRetrieve.respondingGatewayCrossGatewayRetrieve(request);
				}
				else
				{
					retrieveResponse = new RetrieveDocumentSetResponseType();
					
					for(DocumentResponse dr : prefetchedDocument.getDocumentResponse())
					{
						retrieveResponse.getDocumentResponse().add(dr);
					}
				}

				auditRetrieve(retrieveResponse, request.getAssertion(), assertion, documents);

				ret = createRetrieveDocumentSetResponse(retrieveResponse, documents);

			}
			else
			{
				ret = createRetrieveDocumentSetResponseError();
				logger.trace("Outbound DR Failed ChekPolicy:");
			}
		}
		catch(RuntimeException e)
		{ // CCR 179231 - Exceptions update
			ret = createRetrieveDocumentSetResponseError();
			logger.error("Runtme Exception - Outbound DR Unknown:", e);
			EntityRetrieveError.retrieveError(respondingGatewayCrossGatewayRetrieveRequest, ErrorMessage.OUT_DR_UKNOWN, e.getMessage());
		}
		catch(Exception e)
		{ // CCR 179231 - Exceptions update
			ret = createRetrieveDocumentSetResponseError();
			logger.error("Outbound DR Unknown:", e);
			EntityRetrieveError.retrieveError(respondingGatewayCrossGatewayRetrieveRequest, ErrorMessage.OUT_DR_UKNOWN, e.getMessage());
		}

		return ret;
	}

	private RetrieveDocumentSetRequestType createRetrieveDocumentSetRequest(RetrieveDocumentSetRequestType fromDocumentSetRequest, Map<String, Document> documents)
	{
		RetrieveDocumentSetRequestType ret = new RetrieveDocumentSetRequestType();
		ret.getDocumentRequest().addAll(createDocumentRequests(fromDocumentSetRequest.getDocumentRequest(), documents));
		return ret;
	}

	private List<DocumentRequest> createDocumentRequests(List<DocumentRequest> fromDocumentRequests, Map<String, Document> documents)
	{
		List<DocumentRequest> ret = new ArrayList<DocumentRequest>();

		for(DocumentRequest documentRequest : fromDocumentRequests)
		{
			ret.add(createDocumentRequest(documentRequest, documents));
		}

		return ret;
	}

	private DocumentRequest createDocumentRequest(DocumentRequest fromDocumentRequest, Map<String, Document> documents)
	{
		DocumentRequest ret = new DocumentRequest();

		Document document = documentRepository.getDocumentByDocumentUniqueId(fromDocumentRequest.getDocumentUniqueId());
		if(document == null)
		{
			throw new InvalidDocIdException();
		}

		Map<String, String> params = queryParamsToMap(document.getDocGenQueryParams());

		ret.setRepositoryUniqueId(params.get("documentRepositoryId"));
		ret.setHomeCommunityId(params.get("homeCommunityId"));
		ret.setDocumentUniqueId(params.get("documentUniqueId"));

		documents.put(ret.getDocumentUniqueId(), document);

		return ret;
	}

	private Map<String, String> queryParamsToMap(String queryParams)
	{
		HashMap<String, String> ret = new HashMap<String, String>();

		for(String param : queryParams.split(","))
		{
			String[] p = param.split("=");
			ret.put(p[0], p[1]);
		}

		return ret;
	}

	private AssertionType createAssertion(AssertionType fromAssertion, Collection<Document> documents)
	{
		AssertionType ret = new AssertionType();
		Facility homeFacility = facilityManager.getFacilityByFacilityNumber("VA");

		ret.setAuthorized(true);

		HomeCommunityType homeCommunity = new HomeCommunityType();
		homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
		homeCommunity.setName(homeFacility.getFacilityName());
		ret.setHomeCommunity(homeCommunity);

		UserType user = new UserType();
		CeType roleCoded = new CeType();
		roleCoded.setCode("224608005");
		if(fromAssertion.getUserInfo() != null)
		{
			user.setUserName(fromAssertion.getUserInfo().getUserName());
			user.setPersonName(fromAssertion.getUserInfo().getPersonName());
			user.setOrg(fromAssertion.getUserInfo().getOrg());
			if(fromAssertion.getUserInfo().getRoleCoded() != null)
			{
				roleCoded.setCode(fromAssertion.getUserInfo().getRoleCoded().getCode());
			}
		}
		else
		{
			user.setUserName("VA_USER");
			PersonNameType person = new PersonNameType();
			person.setGivenName("VA");
			person.setFamilyName("User");
		}

		if(user.getPersonName() != null && (NullChecker.isNotNullOrEmpty(user.getPersonName().getFamilyName()) || NullChecker.isNotNullOrEmpty(user.getPersonName().getSecondNameOrInitials()) || NullChecker.isNotNullOrEmpty(user.getPersonName().getGivenName())))
		{
			user.setUserName(user.getUserName() + ", CN=" + createFullName(user.getPersonName()) + ", O=" + homeFacility.getFacilityName());
		}
		else
		{
			user.setUserName(user.getUserName() + ", CN=" + user.getUserName() + ", O=" + homeFacility.getFacilityName());
		}

		roleCoded.setCodeSystem("2.16.840.1.113883.6.96");
		roleCoded.setCodeSystemName("SNOMED_CT");
		DataQuery query = dataManager.getQuery("STS.lookupSNOMED");
		query.setParameter("code", roleCoded.getCode());
		List<Map> results = query.getResults();
		roleCoded.setDisplayName((String) results.get(0).get("name"));
		user.setRoleCoded(roleCoded);
		// if (user.getOrg() == null) {
		user.setOrg(homeCommunity);
		// }
		ret.setUserInfo(user);

		for(Document document : documents)
		{
			ret.getUniquePatientId().add(document.getPatientId());
		}

		CeType p = new CeType();
		p.setCodeSystem("2.16.840.1.113883.3.18.7.1");
		p.setCodeSystemName("nhin-purpose");
		p.setDisplayName("Treatment");
		if(fromAssertion.getPurposeOfDisclosureCoded() != null)
		{
			p.setCode(fromAssertion.getPurposeOfDisclosureCoded().getCode());
		}
		else
		{
			p.setCode("TREATMENT");
		}
		ret.setPurposeOfDisclosureCoded(p);

		SamlIssuerType sit = new SamlIssuerType();
		sit.setIssuer(propertyLookup.getProperty("AssertionIssuer"));
		sit.setIssuerFormat(propertyLookup.getProperty("AssertionIssuerFormat"));
		ret.setSamlIssuer(sit);

		ret.setMessageId("urn:uuid:" + UUID.randomUUID().toString());

		return ret;
	}

	private RetrieveDocumentSetResponseType createRetrieveDocumentSetResponse(RetrieveDocumentSetResponseType fromDocumentSetResponse, Map<String, Document> documents)
	{
		ihe.iti.xds_b._2007.ObjectFactory objFactory = new ihe.iti.xds_b._2007.ObjectFactory();
		RetrieveDocumentSetResponseType ret = objFactory.createRetrieveDocumentSetResponseType();
		ret.setRegistryResponse(createRegistryResponse(fromDocumentSetResponse.getRegistryResponse()));
		ret.getDocumentResponse().addAll(createDocumentResponses(fromDocumentSetResponse.getDocumentResponse(), documents));
		return ret;
	}

	private RegistryResponseType createRegistryResponse(RegistryResponseType fromRegistryResponse)
	{
		RegistryResponseType ret;

		if(fromRegistryResponse != null)
		{
			ret = fromRegistryResponse;
		}
		else
		{
			ret = new RegistryResponseType();
			ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success");
		}

		return ret;
	}

	private List<DocumentResponse> createDocumentResponses(List<DocumentResponse> fromDocumentResponses, Map<String, Document> documents)
	{
		List<DocumentResponse> ret = new ArrayList<DocumentResponse>();

		if(!NullChecker.isNullOrEmpty(fromDocumentResponses))
		{
			for(DocumentResponse documentResponse : fromDocumentResponses)
			{
				ret.add(createDocumentResponse(documentResponse, documents));
			}
		}

		return ret;
	}

	private DocumentResponse createDocumentResponse(DocumentResponse fromDocumentResponse, Map<String, Document> documents)
	{
		DocumentResponse ret = new DocumentResponse();

		ret.setDocument(fromDocumentResponse.getDocument());
		ret.setHomeCommunityId(fromDocumentResponse.getHomeCommunityId());
		ret.setMimeType(fromDocumentResponse.getMimeType());
		ret.setDocumentUniqueId(documents.get(fromDocumentResponse.getDocumentUniqueId()).getDocumentUniqueId());
		try
		{
			ret.setDocument(ConvertDocument.convertDocument(ret.getDocument()));
		}
		catch(Exception ex)
		{
			logger.trace("Can not Convert document with spec processor.");
		}
		return ret;
	}

	private RetrieveDocumentSetResponseType createRetrieveDocumentSetResponseError()
	{
		ihe.iti.xds_b._2007.ObjectFactory objFactory = new ihe.iti.xds_b._2007.ObjectFactory();
		RetrieveDocumentSetResponseType ret = objFactory.createRetrieveDocumentSetResponseType();
		ret.setRegistryResponse(createRegistryResponseError());
		return ret;
	}

	private RegistryResponseType createRegistryResponseError()
	{
		RegistryResponseType ret = new RegistryResponseType();
		ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
		ret.setRegistryErrorList(createRegistryErrorList());
		return ret;
	}

	private RegistryErrorList createRegistryErrorList()
	{
		RegistryErrorList ret = new RegistryErrorList();
		ret.getRegistryError().add(createRegistryError());
		ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
		return ret;
	}

	private RegistryError createRegistryError()
	{
		RegistryError ret = new RegistryError();
		ret.setErrorCode("XDSRepositoryError");
		ret.setCodeContext("Internal Registry/Repository Error");
		ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
		return ret;
	}

	private void auditRetrieve(RetrieveDocumentSetResponseType response, AssertionType assertion, AssertionType origAssertion, Map<String, Document> documents)
	{
		if(!NullChecker.isNullOrEmpty(response.getDocumentResponse()))
		{
			for(DocumentResponse d : response.getDocumentResponse())
			{
				Date creationTime = new Date();
				Document document = documents.get(d.getDocumentUniqueId());
				byte[] docBytes = ConvertDocument.convertDHtoByte(d.getDocument());
				document.setRawData(docBytes);
				document.setSize(docBytes.length);
				document.setAvailabilityStatus("urn:oasis:names:tc:ebxmlregrep:StatusType:Approved");
				document.setLastAccessedTime(creationTime);
				documentRepository.storeDocument(document);

				Audit audit = new Audit();
				audit.setAction("RetrieveDocumentOut");
				audit.setAuditTime(new Date());
				audit.setDocumentId(document.getDocumentUniqueId());
				audit.setRemoteDocumentId(d.getDocumentUniqueId());
				audit.setRemoteDocumentRepositoryId(d.getRepositoryUniqueId());
				audit.setRemoteOrganizationId(d.getHomeCommunityId());
				logger.trace("assertion:" + assertion);
				logger.trace("assertion.getUserInfo():" + assertion.getUserInfo());
				logger.trace("assertion.getUserInfo().getUserName():" + assertion.getUserInfo().getUserName());

				audit.setUserId(assertion.getUserInfo().getUserName());
				audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
				audit.setUserFacilityNumber(origAssertion.getUserInfo().getOrg().getHomeCommunityId());
				audit.setUserFacilityName(origAssertion.getUserInfo().getOrg().getName());
				if(assertion.getUserInfo().getPersonName() != null)
				{
					PersonNameType personName = assertion.getUserInfo().getPersonName();
					if(!NullChecker.isNullOrEmpty(personName.getFullName()))
					{
						audit.setUserName(personName.getFullName());
					}
					else
					{
						audit.setUserName(personName.getGivenName() + " " + personName.getFamilyName());
					}
				}
				audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
				audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
				audit.setPatientId(document.getPatientId());
				audit.setPatientSSN(document.getPatientSSN());
				audit.setPatientGivenName(document.getPatientGivenName());
				audit.setPatientLastName(document.getPatientLastName());
				audit.setPatientFacilityNumber(document.getPatientPreferredFacilityNumber());
				audit.setPatientFacilityName(document.getPatientPreferredFacilityName());

				audit.setDocSpecType(document.getFormatCodeDisplayName());

				auditManager.storeAudit(audit);
			}
		}
	}

	private boolean checkPolicy(AssertionType assertion)
	{
		boolean ret = false;

		if(assertion.getUserInfo() != null && !NullChecker.isNullOrEmpty(assertion.getUserInfo().getUserName()))
		{
			RequestType request = CheckPolicyRequestBuilder.buildNHINOutCheckPolicyRequest(assertion.getUserInfo().getUserName(), getFullHomeCommunityId());
			CheckPolicyRequestType checkPolicyRequest = new CheckPolicyRequestType();
			checkPolicyRequest.setRequest(request);
			CheckPolicyResponseType checkPolicyResponse = adapterPolicyEngine.checkPolicy(checkPolicyRequest);
			if(checkPolicyResponse != null && !NullChecker.isNullOrEmpty(checkPolicyResponse.getResponse()) && !NullChecker.isNullOrEmpty(checkPolicyResponse.getResponse().getResult()))
			{
				ret = checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
			}
		}

		return ret;
	}

	private String getFullHomeCommunityId()
	{
		String ret = null;
		Facility facility = facilityManager.getFacilityByFacilityNumber("VA");
		if(facility != null)
		{
			ret = facility.getFullHomeCommunityId();
		}
		return ret;
	}

	private String createFullName(PersonNameType personName)
	{
		StringBuffer ret = new StringBuffer();

		if(NullChecker.isNotNullOrEmpty(personName.getGivenName()))
		{
			ret.append(personName.getGivenName());
		}

		if(NullChecker.isNotNullOrEmpty(personName.getSecondNameOrInitials()))
		{
			if(ret.length() > 0)
			{
				ret.append(' ');
			}
			ret.append(personName.getSecondNameOrInitials());
		}

		if(NullChecker.isNotNullOrEmpty(personName.getFamilyName()))
		{
			if(ret.length() > 0)
			{
				ret.append(' ');
			}
			ret.append(personName.getFamilyName());
		}

		return ret.toString();
	}
}
