package gov.va.med.nhin.adapter.adaptergateway.docquery;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQuery;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQueryPortType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

import java.net.MalformedURLException;
import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.xml.namespace.QName;

import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author David Vazquez
 */
@Stateless(name = "NhincProxyNHINDocQueryRequestSender")
public class NhincProxyNHINDocQueryRequestSender implements NHINDocQueryRequestSender
{
	private static Log log = LogFactory.getLog(NhincProxyNHINDocQueryRequestSender.class);

	private EntityDocQuery entityDocQuery;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public AdhocQueryResponse sendRequest(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, String remoteHomeCommunityId, String useSpecVersion) throws Exception
	{
		log.info("Entering NhincProxyNHINDocQueryRequestSender::sendRequest");

		AdhocQueryResponse ret;

		final gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType request = new gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType();
		request.setAdhocQueryRequest(adhocQueryRequest);
		request.setAssertion(assertion);
		request.setNhinTargetCommunities(createNhinTargetCommunities(remoteHomeCommunityId, useSpecVersion));
		log.info("Sending DQ to SSA...");
		ret = getDocQueryEntityPort().respondingGatewayCrossGatewayQuery(request);
		return ret;
	}

	private NhinTargetCommunitiesType createNhinTargetCommunities(String homeCommunityId, String useSpecVersion)
	{

		HomeCommunityType homeCommunity = new HomeCommunityType();
		homeCommunity.setHomeCommunityId(homeCommunityId);

		NhinTargetCommunityType homeTargetCommunity = new NhinTargetCommunityType();
		homeTargetCommunity.setHomeCommunity(homeCommunity);

		NhinTargetCommunitiesType ret = new NhinTargetCommunitiesType();
		ret.getNhinTargetCommunity().add(homeTargetCommunity);
		ret.setUseSpecVersion(useSpecVersion);

		return ret;
	}

	private EntityDocQueryPortType getDocQueryEntityPort() throws MalformedURLException
	{
		if(entityDocQuery == null)
		{
			entityDocQuery = new EntityDocQuery(new URL(propertyLookup.getProperty("DocQueryProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitydocquery", "EntityDocQuery"));
		}

		return entityDocQuery.getEntityDocQueryPortSoap();
	}

}
