package gov.va.med.nhin.adapter.adaptergateway.docquery;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.ejb.EJB;
import javax.ejb.Stateless;

import org.apache.commons.lang3.StringUtils;
import org.hl7.v3.II;
import org.hl7.v3.PRPAIN201310UV02;
import org.hl7.v3.PRPAMT201304UV02Patient;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.hl7.v3.RetrievePatientCorrelationsResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.common.eventcommon.AdhocQueryRequestEventType;
import gov.hhs.fha.nhinc.common.eventcommon.AdhocQueryRequestMessageType;
import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.PatientCorrelationPortType;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.PolicyEngineTransformer;
import gov.hhs.fha.nhinc.transform.subdisc.HL7PRPA201309Transforms;
import gov.va.med.nhin.adapter.audit.requests.RequestActions;
import gov.va.med.nhin.adapter.audit.requests.RequestAudit;
import gov.va.med.nhin.adapter.audit.requests.RequestAuditEntity;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.logging.CheckPolicy;
import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.logging.MaintLog;
import gov.va.med.nhin.adapter.patientcorrelation.PatientCorrelationPortTypeLocal;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.utils.NullChecker;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AdhocQueryType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ValueListType;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryErrorList;

/**
 *
 * @author VHAISBVAZQUD
 */
@Stateless(name = "AdapterGatewayDocQueryOrch")
public class AdapterGatewayDocQueryOrchBean implements AdapterGatewayDocQueryPortTypeLocal
{
	private class SendRequestResponse
	{
		public AdhocQueryResponse adhocQueryResponse;
		public II remotePatientId;
		public String remoteHomeCommunityId;
		public SendRequestException sre = null;

		public boolean hasError()
		{
			if(sre == null)
			{
				return false;
			}

			return true;
		}
	}

	private class SendRequestException extends Exception
	{
		public II remotePatientId;
		public String remoteHomeCommunityId;
	}

	private class SendRequestCallable implements Callable<SendRequestResponse>
	{
		private final AdhocQueryRequest adhocQueryRequest;
		private final AssertionType assertion;
		private II remotePatientId;
		private String remoteHomeCommunityId;
		private String auditUUID;

		public SendRequestCallable(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, II remotePatientId, String remoteHomeCommunityId, String auditUUID)
		{
			this.adhocQueryRequest = adhocQueryRequest;
			this.assertion = assertion;
			this.remotePatientId = remotePatientId;
			this.remoteHomeCommunityId = remoteHomeCommunityId;
			this.auditUUID = auditUUID;
		}

		public SendRequestResponse call() throws Exception
		{
			return sendRequest(adhocQueryRequest, assertion, remotePatientId, remoteHomeCommunityId, auditUUID);
		}
	}

	private static final Logger logger = LoggerFactory.getLogger(AdapterGatewayDocQueryOrchBean.class.getName());

	static private final String EBXML_DOCENTRY_PATIENT_ID = "$XDSDocumentEntryPatientId";

	private FacilityManager facilityManager;
	private PatientCorrelationPortType adapterPatientCorrelation;
	private AdapterPolicyEnginePortType adapterPolicyEngine;
	private NHINDocQueryRequestSender nhinDocQueryRequestSender;
	private ExecutorService executorService;
	private RequestAudit requestAudit;

	@EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
	public void setFacilityManager(FacilityManager facilityManager)
	{
		this.facilityManager = facilityManager;
	}

	@EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
	public void setAdapterPolicyEngine(AdapterPolicyEnginePortType adapterPolicyEngine)
	{
		this.adapterPolicyEngine = adapterPolicyEngine;
	}

	@EJB(beanInterface = PatientCorrelationPortTypeLocal.class, beanName = "AdapterPatientCorrelation")
	public void setAdapterPatientCorrelation(PatientCorrelationPortType adapterPatientCorrelation)
	{
		this.adapterPatientCorrelation = adapterPatientCorrelation;
	}

	@EJB(beanInterface = NHINDocQueryRequestSender.class, beanName = "NhincProxyNHINDocQueryRequestSender")
	public void setNhinDocQueryRequestSender(NHINDocQueryRequestSender nhinDocQueryRequestSender)
	{
		this.nhinDocQueryRequestSender = nhinDocQueryRequestSender;
	}

	@EJB(beanInterface = WorkManagerExecutorServiceLocal.class, beanName = "WorkManagerExecutorService")
	public void setExecutorService(ExecutorService executorService)
	{
		this.executorService = executorService;
	}

	@EJB(beanInterface = RequestAudit.class, beanName = "RequestAudit")
	public void setRequestAudit(RequestAudit requestAudit)
	{
		this.requestAudit = requestAudit;
	}

	public RespondingGatewayCrossGatewayQueryResponseType respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
	{
		RespondingGatewayCrossGatewayQueryResponseType ret = createRespondingGatewayCrossGatewayQueryResponse();

		ExecutorCompletionService<SendRequestResponse> completionService = new ExecutorCompletionService<SendRequestResponse>(executorService);
		II patientId = getPatientId(respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest());

		logger.debug("Patient Id {} :", patientId);

		if(patientId != null)
		{
			// Setup incoming request audit values.
			RequestAuditEntity requestAuditEntity = new RequestAuditEntity();
			requestAuditEntity.setPid(patientId.getExtension());
			requestAuditEntity.generateUUID();
			requestAuditEntity.setStartTime(new Date());
			requestAuditEntity.setAction(RequestActions.PARENT_REQUEST.getValue());

			// CCR 177986
			logger.debug("RequestAuditEntity requestAuditEntity {} ", requestAuditEntity);

			if(respondingGatewayCrossGatewayQueryRequest != null && respondingGatewayCrossGatewayQueryRequest.getAssertion() != null && respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity() != null && StringUtils.isNotBlank(respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId()))
			{
				logger.debug("Home community Id {} from the request ", respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId()); // CCR
																																											// 177986

				requestAuditEntity.setHcid(respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId());
			}
			else
			{
				requestAuditEntity.setHcid("UNKNOWN");
			}

			RetrievePatientCorrelationsResponseType patientCorrelations = getPatientCorrelations(patientId, respondingGatewayCrossGatewayQueryRequest.getAssertion());
			if(patientCorrelations != null && patientCorrelations.getPRPAIN201310UV02() != null)
			{
				int numSubmitted = 0;
				PRPAMT201304UV02Patient patient = extractPatient(patientCorrelations.getPRPAIN201310UV02());

				for(II correlatedPatientId : patient.getId())
				{
					List<String> remoteHomeCommunityIds = getRemoteHomeCommunityIds(correlatedPatientId);
					for(String remoteHomeCommunityId : remoteHomeCommunityIds)
					{
						if(facilityManager.isPartnerAllowed(remoteHomeCommunityId, OperationOnOff.ONBOARD))
						{
							if(facilityManager.isPartnerAllowed(remoteHomeCommunityId, OperationOnOff.OUT_DQ))
							{
								AdhocQueryRequest adhocQueryRequest = createAdhocQueryRequest(respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest(), remoteHomeCommunityId, correlatedPatientId);
								if(checkPolicy(adhocQueryRequest, respondingGatewayCrossGatewayQueryRequest.getAssertion(), remoteHomeCommunityId))
								{
									SendRequestCallable callable = new SendRequestCallable(adhocQueryRequest, respondingGatewayCrossGatewayQueryRequest.getAssertion(), correlatedPatientId, remoteHomeCommunityId, requestAuditEntity.getUuid());
									completionService.submit(callable);
									++numSubmitted;
								}
							}
							else
							{
								addErrorToResponse(ret, respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest(), ErrorMessage.OUT_DQ_DISABLED.getMessage(), remoteHomeCommunityId, correlatedPatientId.getExtension());

								// CCR 177986 - parameterized logging
								logger.error(ErrorMessage.OUT_DQ_DISABLED + " {} ", remoteHomeCommunityId);
							}
						}
						else
						{
							addErrorToResponse(ret, respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest(), ErrorMessage.OUT_DQ_NOT_A_PARTNER.getMessage(), remoteHomeCommunityId, correlatedPatientId.getExtension());

							// CCR 177986 - parameterized logging
							logger.error(ErrorMessage.OUT_DQ_NOT_A_PARTNER + " {} ", remoteHomeCommunityId);
						}
					}
				}

				if(patient.getId().size() < 1)
				{
					// CCR 177986- added logger as a parameter
					MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.OUT_DQ_NO_CORRELATIONS, logger);
				}

				for(int i = 0; i < numSubmitted; ++i)
				{
					try
					{
						SendRequestResponse response = completionService.take().get();
						if(!response.hasError())
						{
							addResultToResponse(ret, response);
						}
						else
						{
							SendRequestException sre = response.sre;
							addErrorToResponse(ret, respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest(), StringUtils.EMPTY, sre.remoteHomeCommunityId, sre.remotePatientId.getExtension());

							// CCR 177986- logging updates
							logger.error("Error sending DocQuery for community Id: {} with exception: {}", new Object[] { sre.remoteHomeCommunityId, sre.getCause().getMessage() });
						}
					}
					catch(ExecutionException ee)
					{
						logger.error("An Unknown error occured processing an outbound doc query request", ee);
						MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.OUT_DQ_UNKNOWN, "An Unknown error occured processing an outbound doc query request.", logger);
					}
					catch(InterruptedException ie)
					{
						logger.error("Outbound Doc Query Threads interrupted.  Return will not be complete ", ie);
					}
					catch(Exception e)
					{
						logger.error("Error in Outbound Doc Query", e);
					}
				}
			}
			else
			{
				MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.OUT_DQ_NO_CORRELATIONS, logger);
			}

			requestAudit.storeAudit(requestAuditEntity);
		}
		else
		{
			MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.OUT_DQ_NO_PATIENT_ID, logger);
		}

		return ret;
	}

	private RespondingGatewayCrossGatewayQueryResponseType createRespondingGatewayCrossGatewayQueryResponse()
	{
		CommunityAdhocQueryResponsesType communityResponses = new CommunityAdhocQueryResponsesType();

		RespondingGatewayCrossGatewayQueryResponseType ret = new RespondingGatewayCrossGatewayQueryResponseType();
		ret.setCommunityResponses(communityResponses);

		return ret;
	}

	private II getPatientId(AdhocQueryRequest adhocQueryRequest)
	{
		II ret = new II();
		Map<String, List<String>> slotMap = getMapFromSlots(adhocQueryRequest.getAdhocQuery().getSlot());
		String patientId = slotMap.get(EBXML_DOCENTRY_PATIENT_ID).get(0);
		Pattern p = Pattern.compile("\\d{10}V\\d{6}");
		Matcher m = p.matcher(patientId);
		if(m.find())
		{
			ret = new II();
			ret.setExtension(m.group());
			ret.setRoot(getHomeCommunityId());
		}
		return ret;
	}

	private Map<String, List<String>> getMapFromSlots(List<SlotType1> slots)
	{
		HashMap<String, List<String>> ret = new HashMap<String, List<String>>();

		for(SlotType1 slot : slots)
		{
			if(!NullChecker.isNullOrEmpty(slot.getName()) && !NullChecker.isNullOrEmpty(slot.getValueList()) && !NullChecker.isNullOrEmpty(slot.getValueList().getValue()))
			{
				List<String> values = ret.get(slot.getName());
				if(values == null)
				{
					values = new ArrayList<String>();
					ret.put(slot.getName(), values);
				}
				values.addAll(parseParamFormattedStrings(slot.getValueList().getValue()));
			}
		}

		return ret;
	}

	public List<String> parseParamFormattedStrings(List<String> paramFormattedStrings)
	{
		List<String> ret = new ArrayList<String>();

		for(String paramFormattedString : paramFormattedStrings)
		{
			parseParamFormattedString(paramFormattedString, ret);
		}

		return ret;
	}

	public void parseParamFormattedString(String paramFormattedString, List<String> resultCollection)
	{
		if((paramFormattedString != null) && (resultCollection != null))
		{
			String working = paramFormattedString;
			if(paramFormattedString.startsWith("("))
			{
				working = paramFormattedString.substring(1);
				int endIndex = working.indexOf(")");
				if(endIndex != -1)
				{
					working = working.substring(0, endIndex);
				}
			}
			String[] multiValueString = working.split(",");
			if(multiValueString != null)
			{
				for(int i = 0; i < multiValueString.length; i++)
				{
					String singleValue = multiValueString[i];
					if(singleValue != null)
					{
						singleValue = singleValue.trim();
					}
					if(singleValue.startsWith("'"))
					{
						singleValue = singleValue.substring(1);
						int endTickIndex = singleValue.indexOf("'");
						if(endTickIndex != -1)
						{
							singleValue = singleValue.substring(0, endTickIndex);
						}
					}
					resultCollection.add(singleValue);
				}
			}
		}
	}

	private RetrievePatientCorrelationsResponseType getPatientCorrelations(II patientId, AssertionType assertion)
	{
		RetrievePatientCorrelationsRequestType request = createRetrievePatientCorrelationsRequest(patientId);
		request.setAssertion(assertion);
		return adapterPatientCorrelation.retrievePatientCorrelations(request);
	}

	private RetrievePatientCorrelationsRequestType createRetrievePatientCorrelationsRequest(II patientId)
	{
		RetrievePatientCorrelationsRequestType ret = new RetrievePatientCorrelationsRequestType();
		ret.setPRPAIN201309UV02(HL7PRPA201309Transforms.createPRPA201309(patientId.getRoot(), patientId.getExtension()));
		return ret;
	}

	private String getHomeCommunityId()
	{
		String ret = null;
		Facility facility = facilityManager.getFacilityByFacilityNumber("VA");
		if(facility != null)
		{
			ret = facility.getHomeCommunityId();
		}
		return ret;
	}

	private PRPAMT201304UV02Patient extractPatient(PRPAIN201310UV02 prpain201310UV02)
	{
		PRPAMT201304UV02Patient ret = null;

		if(prpain201310UV02.getControlActProcess() != null && !NullChecker.isNullOrEmpty(prpain201310UV02.getControlActProcess().getSubject()) && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent() != null && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1() != null && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient() != null)
		{
			ret = prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient();
		}

		return ret;
	}

	private List<String> getRemoteHomeCommunityIds(II remotePatientId)
	{
		List<String> ret = new ArrayList<String>();
		List<Facility> remoteFacilities = facilityManager.getFacilitiesContainingAssigningAuthority(remotePatientId.getRoot());

		if(NullChecker.isNotNullOrEmpty(remoteFacilities))
		{
			for(Facility remoteFacility : remoteFacilities)
			{
				ret.add(remoteFacility.getHomeCommunityId());
			}
		}

		return ret;
	}

	private boolean checkPolicy(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, String homeCommunityId)
	{
		AdhocQueryRequestMessageType adhocQueryRequestMessage = new AdhocQueryRequestMessageType();
		adhocQueryRequestMessage.setAdhocQueryRequest(adhocQueryRequest);
		adhocQueryRequestMessage.setAssertion(assertion);

		HomeCommunityType receivingHomeCommunity = new HomeCommunityType();
		receivingHomeCommunity.setHomeCommunityId(homeCommunityId);

		HomeCommunityType sendingHomeCommunity = new HomeCommunityType();
		sendingHomeCommunity.setHomeCommunityId(getHomeCommunityId());

		AdhocQueryRequestEventType adhocQueryRequestEvent = new AdhocQueryRequestEventType();
		adhocQueryRequestEvent.setMessage(adhocQueryRequestMessage);
		adhocQueryRequestEvent.setDirection(NhincConstants.POLICYENGINE_OUTBOUND_DIRECTION);
		adhocQueryRequestEvent.setReceivingHomeCommunity(receivingHomeCommunity);
		adhocQueryRequestEvent.setSendingHomeCommunity(sendingHomeCommunity);
		adhocQueryRequestEvent.setInterface(NhincConstants.AUDIT_LOG_ENTITY_INTERFACE);

		PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
		CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformAdhocQueryToCheckPolicy(adhocQueryRequestEvent);

		CheckPolicyResponseType checkPolicyResponse = adapterPolicyEngine.checkPolicy(checkPolicyRequest);

		return CheckPolicy.checkPolicy(checkPolicyRequest, checkPolicyResponse);
	}

	private SendRequestResponse sendRequest(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, II remotePatientId, String remoteHomeCommunityId, final String auditUUID) throws SendRequestException
	{
		SendRequestResponse ret = new SendRequestResponse();
		RequestAuditEntity auditEntity = new RequestAuditEntity();
		auditEntity.setStartTime(new Date());
		auditEntity.setUuid(auditUUID);
		auditEntity.setHcid(remoteHomeCommunityId);
		auditEntity.setPid(remotePatientId.getExtension());
		auditEntity.setAction(RequestActions.QUERY_REQUEST.getValue());

		try
		{
			final String version = "2.0";
			ret.adhocQueryResponse = nhinDocQueryRequestSender.sendRequest(adhocQueryRequest, assertion, remoteHomeCommunityId, version);
			auditEntity.setStopTime(new Date());
			auditEntity.setStatus(ret.adhocQueryResponse.getStatus());
			requestAudit.storeAudit(auditEntity);
			ret.remoteHomeCommunityId = remoteHomeCommunityId;
			ret.remotePatientId = remotePatientId;
		}
		catch(Throwable e)
		{
			SendRequestException sre = new SendRequestException();
			sre.remoteHomeCommunityId = remoteHomeCommunityId;
			sre.remotePatientId = remotePatientId;
			sre.initCause(e);
			auditEntity.setStopTime(new Date());
			auditEntity.setStatus("Failed:" + e.getMessage());
			requestAudit.storeAudit(auditEntity);
			ret.sre = sre;
		}
		return ret;
	}

	private AdhocQueryRequest createAdhocQueryRequest(AdhocQueryRequest fromAdhocQueryRequest, String homeCommunityId, II remotePatientId)
	{
		AdhocQueryRequest ret = new AdhocQueryRequest();
		ret.setFederation(fromAdhocQueryRequest.getFederation());
		ret.setMaxResults(fromAdhocQueryRequest.getMaxResults());
		ret.setStartIndex(fromAdhocQueryRequest.getStartIndex());
		ret.setId(fromAdhocQueryRequest.getId());
		ret.setComment(fromAdhocQueryRequest.getComment());
		ret.setRequestSlotList(fromAdhocQueryRequest.getRequestSlotList());
		ret.setAdhocQuery(createAdhocQuery(fromAdhocQueryRequest.getAdhocQuery(), homeCommunityId, remotePatientId));
		ret.setResponseOption(fromAdhocQueryRequest.getResponseOption());
		return ret;
	}

	private AdhocQueryType createAdhocQuery(AdhocQueryType fromAdhocQuery, String homeCommunityId, II remotePatientId)
	{
		AdhocQueryType ret = new AdhocQueryType();
		ret.setDescription(fromAdhocQuery.getDescription());
		ret.setHome("urn:oid:" + homeCommunityId);
		ret.setId(fromAdhocQuery.getId());
		ret.setLid(fromAdhocQuery.getLid());
		ret.setName(fromAdhocQuery.getName());
		ret.setObjectType(fromAdhocQuery.getObjectType());
		ret.setQueryExpression(fromAdhocQuery.getQueryExpression());
		ret.setStatus(fromAdhocQuery.getStatus());
		ret.setVersionInfo(fromAdhocQuery.getVersionInfo());
		ret.getExternalIdentifier().addAll(fromAdhocQuery.getExternalIdentifier());
		ret.getSlot().addAll(createSlots(fromAdhocQuery.getSlot(), remotePatientId));
		ret.getClassification().addAll(fromAdhocQuery.getClassification());
		return ret;
	}

	private List<SlotType1> createSlots(List<SlotType1> slots, II remotePatientId)
	{
		ArrayList<SlotType1> ret = new ArrayList<SlotType1>();

		for(SlotType1 slot : slots)
		{
			SlotType1 newSlot;
			if(slot.getName().equals(EBXML_DOCENTRY_PATIENT_ID))
			{
				newSlot = new SlotType1();
				newSlot.setName(EBXML_DOCENTRY_PATIENT_ID);
				newSlot.setValueList(createValueList("'" + remotePatientId.getExtension() + "^^^&" + remotePatientId.getRoot() + "&ISO'"));
			}
			else
			{
				newSlot = slot;
			}
			ret.add(newSlot);
		}

		return ret;
	}

	private ValueListType createValueList(String value)
	{
		ValueListType ret = new ValueListType();
		ret.getValue().add(value);
		return ret;
	}

	private void addResultToResponse(RespondingGatewayCrossGatewayQueryResponseType respondingGatewayCrossGatewayQueryResponse, SendRequestResponse response)
	{
		HomeCommunityType homeCommunity = new HomeCommunityType();
		homeCommunity.setHomeCommunityId(response.remoteHomeCommunityId);
		Facility facility = facilityManager.getFacilityByHomeCommunityId(response.remoteHomeCommunityId);
		homeCommunity.setName(facility.getFacilityName());

		NhinTargetCommunityType nhinTargetCommunity = new NhinTargetCommunityType();
		nhinTargetCommunity.setHomeCommunity(homeCommunity);

		CommunityAdhocQueryResponseType communityResponse = new CommunityAdhocQueryResponseType();
		communityResponse.setAdhocQueryResponse(response.adhocQueryResponse);
		communityResponse.setNhinTargetCommunity(nhinTargetCommunity);

		respondingGatewayCrossGatewayQueryResponse.getCommunityResponses().getCommunityResponse().add(communityResponse);
	}

	private void addErrorToResponse(RespondingGatewayCrossGatewayQueryResponseType respondingGatewayCrossGatewayQueryResponse, AdhocQueryRequest adhocQueryRequest, final String errorMessage, final String hcid, final String patientId)
	{
		AdhocQueryResponse adhocQueryResponse = createAdhocQueryResponseError(adhocQueryRequest);
		adhocQueryResponse.setRegistryErrorList(new RegistryErrorList());
		adhocQueryResponse.getRegistryErrorList().setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");

		RegistryError registryError = new RegistryError();
		registryError.setErrorCode("XDSRegistryError");
		registryError.setCodeContext("Internal Registry/Repository Error - HCID = " + hcid + " - " + ", patientId = " + patientId + " " + errorMessage);
		registryError.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
		adhocQueryResponse.getRegistryErrorList().getRegistryError().add(registryError);

		HomeCommunityType homeCommunity = new HomeCommunityType();
		homeCommunity.setHomeCommunityId(hcid);
		Facility facility = facilityManager.getFacilityByHomeCommunityId(hcid);
		homeCommunity.setName(facility.getFacilityName());

		NhinTargetCommunityType nhinTargetCommunity = new NhinTargetCommunityType();
		nhinTargetCommunity.setHomeCommunity(homeCommunity);

		CommunityAdhocQueryResponseType communityResponse = new CommunityAdhocQueryResponseType();
		communityResponse.setAdhocQueryResponse(adhocQueryResponse);
		communityResponse.setNhinTargetCommunity(nhinTargetCommunity);

		respondingGatewayCrossGatewayQueryResponse.getCommunityResponses().getCommunityResponse().add(communityResponse);
	}

	private AdhocQueryResponse createAdhocQueryResponseError(AdhocQueryRequest adhocQueryRequest)
	{
		AdhocQueryResponse ret = new AdhocQueryResponse();
		ret.setRequestId(adhocQueryRequest.getId());
		ret.setStartIndex(adhocQueryRequest.getStartIndex());
		ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
		return ret;
	}
}
