package gov.va.med.nhin.adapter.propertylookup;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "PropertyLookup", mappedName = "PropertyLookup")
public class PropertyLookupBean implements PropertyLookupLocal, PropertyLookupRemote
{
    @PersistenceContext
    private EntityManager entityManager;

    public String getProperty(String key)
    {
        Property property = entityManager.find(Property.class, key);
        return property != null ? property.getValue() : null;
    }
}
