package gov.va.med.nhin.adapter.logging;

import gov.va.med.nhin.adapter.utils.NullChecker;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import oasis.names.tc.xacml._2_0.context.schema.os.ActionType;
import oasis.names.tc.xacml._2_0.context.schema.os.AttributeType;
import oasis.names.tc.xacml._2_0.context.schema.os.AttributeValueType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResourceType;
import oasis.names.tc.xacml._2_0.context.schema.os.SubjectType;

/**
 * Some of these were taken directly from AdapterPolicyEngine.
 * 
 * @author serverchmarc
 * 
 */
public final class LoggingUtils
{
	public final static String ERROR_PREFIX = "Transaction Error: ";

	public static String extractValueFromAction(ActionType actionType, String key)
	{
		return extractValueFromAttributes(actionType.getAttribute(), key);
	}

	public static String extractValueFromSubject(SubjectType subjectType, String key)
	{
		return extractValueFromAttributes(subjectType.getAttribute(), key);
	}

	public static String extractValueFromSubject(List<SubjectType> subjectTypes, String key)
	{
		if(CollectionUtils.isNotEmpty(subjectTypes))
		{
			StringBuilder sb = new StringBuilder();
			for(SubjectType subject : subjectTypes)
			{
				sb.append(extractValueFromAttributes(subject.getAttribute(), key));
			}
			if(sb.length() > 1)
			{
				return sb.toString();
			}
		}
		return StringUtils.EMPTY;

	}

	public static String extractValueFromResource(List<ResourceType> resourceTypes, String key)
	{
		if(CollectionUtils.isNotEmpty(resourceTypes))
		{
			StringBuilder sb = new StringBuilder();
			for(ResourceType resource : resourceTypes)
			{
				sb.append(extractValueFromAttributes(resource.getAttribute(), key));
			}
			if(sb.length() > 1)
			{
				return sb.toString();
			}
		}
		return StringUtils.EMPTY;

	}

	public static String extractValueFromResource(ResourceType resourceType, String key)
	{
		return extractValueFromAttributes(resourceType.getAttribute(), key);
	}

	public static String extractValueFromAttributes(List<AttributeType> attributes, String key)
	{
		StringBuilder ret = new StringBuilder();

		for(AttributeType attribute : attributes)
		{
			if(attribute != null && attribute.getAttributeId() != null && attribute.getAttributeId().equalsIgnoreCase(key) && !NullChecker.isNullOrEmpty(attribute.getAttributeValue()) && !NullChecker.isNullOrEmpty(attribute.getAttributeValue().get(0)) && !NullChecker.isNullOrEmpty(attribute.getAttributeValue().get(0).getContent()))
			{
				extractValues(attribute.getAttributeValue(), ret);
			}
		}

		if(ret.length() > 1)
		{
			return ret.toString();
		}
		return StringUtils.EMPTY;
	}

	public static void extractValues(final List<AttributeValueType> attributes, final StringBuilder sb)
	{
		for(AttributeValueType attribute : attributes)
		{
			if(CollectionUtils.isNotEmpty(attribute.getContent()))
			{
				for(Object content : attribute.getContent())
				{
					if(StringUtils.isNotBlank(content.toString()))
					{
						sb.append(content.toString()).append(" ");
					}
				}
			}
		}
	}
}
