package gov.va.med.nhin.adapter.logging;

public enum ErrorMessage{	
	IN_DQ_QUERY_ID("Inbound QD: Unknown Stored QueryID."),
	IN_DQ_NO_RESULTS("Inbound QD: No results returned from query."),
	IN_DQ_TOO_MANY("Inbound QD: Too many results returned from query."),
	IN_DQ_MISSING_PARAM("Inbound QD: Missing required query parameter(s)"), 
	IN_DQ_NON_APPROVED_ENTY("Inbound QD: System can not return non-Approved documents."),
	IN_DQ_STATUS_ENTRY("Inbound QD: Entry Status has either an AND condition that cannot be met, is missing, or invalid."),
	IN_DQ_STABLE ("Inbound QD: Entry stable is either non-stable document type, or missing."),
	IN_DQ_UKNOWN("Inbound QD: An unknown error has occured"),
	IN_DQ_NOT_A_PARTNER("Inbound QD: Partner is not registered with the system."), 
	IN_DQ_DISABLED("Inbound QD: Partner inbound DQ has been disabled."), 
	IN_DR_UKNOWN("Inbound RD: An unknown error has occured"),
	IN_DR_NOT_A_PARTNER("Inbound RD: Partner is not registered with the system."), 
	IN_DR_DISABLED("Inbound RD: Partner inbound DR has been disabled."), 	
	OUT_DQ_NO_PATIENT_ID("Outbound QD: No patient ID found in request."),
	OUT_DQ_DISABLED("Outbound QD: Partner outbound DQ has been disabled."), 
	OUT_DQ_DISABLED_NEW("is not currently configured to accept Query for Document requests from the VA eHealth Exchange."), 
	OUT_DQ_NOT_A_PARTNER("Outbound QD: Partner is not registered with the system."), 
	OUT_DQ_NOT_A_PARTNER_NEW("is not currently onboarded with the VA eHealth Exchange."), 
	OUT_DQ_UNKNOWN("Outbound QD: An unknown error has occured"),
	OUT_DQ_NO_CORRELATIONS("Outbound QD: Failed to find correlations for patient."), 
	IN_DR_UNKNOWN("Inbound RD: An unknown error has occured"), 
	IN_DR_DOC_ID("Inbound RD: Cannot return doc due to permissions or document does not exist."), 
	IN_DR_UNKNOWN_REPO_ID("Inbound RD: Unknown repository ID."), 
	IN_DR_UNKNOWN_HCID("Inbound RD: Unknown HCID."), 
	IN_DR_NO_HCID("Inbound RD: Missing HCID"), 
	OUT_DR_UKNOWN("Outbound RD: An known error has occured"),
	OUT_DR_DISABLED("Outbound RD: Partner outbound DR has been disabled."), 
	OUT_DR_NOT_A_PARTNER("Outbound RD: Partner is not registered with the system."), 
	IN_PD_FAILED_POLICY_CHECK("Inbound PD: Failed policy check."), 
	IN_PD_NO_MATCH("Inbound PD: Could not find match or correlation."), 
	IN_PD_NO_RESPONSE("Inbound PD: Did not receive a response."), 
	IN_PD_DISABLED("Inbound PD: Partner inbound PD disabled."), 
	IN_PD_NOT_A_PARTNER("Inbound PD: Partner is not registered with the system."), 
	IN_PD_UNKNOWN("Inbound PD: An unknown error has occured"), 
	IN_PC_NO_ID("Inbound PatientCorrelation: Failed to find Identifier."), 
	OUT_PD_NOT_A_PARTNER("Outbound PD: Partner is not registered with the system."),
	OUT_PD_DISABLED("Outbound PD: Partner outbound PD has been disabled."),
	OUT_PD_UNKOWN("Outbound PD: An unknown error has occured"),
	CHECK_POLICY("Request failed a policy check."); 
	
	private String message;

	private ErrorMessage(final String message)
	{
		this.message = message;
	}

	public String getMessage()
	{
		return message;
	}
}