package gov.va.med.nhin.adapter.logging;

import org.apache.commons.lang3.StringUtils;
import org.hl7.v3.PRPAIN201309UV02;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;

public class AdapterCorrelationError
{
	private static Logger logger = LoggerFactory.getLogger(AdapterCorrelationError.class.getName());  //CCR 177986
	
	public static void queryError(final RetrievePatientCorrelationsRequestType respondingGatewayType, final String errorText)
	{
		if(respondingGatewayType != null)
		{
			PRPAIN201309UV02 adhocQuery = respondingGatewayType.getPRPAIN201309UV02() != null ? respondingGatewayType.getPRPAIN201309UV02() : null;
			AssertionType assertionType = respondingGatewayType.getAssertion() != null ? respondingGatewayType.getAssertion() : null;
			queryError(adhocQuery, assertionType, errorText);
		}
	}

	public static void queryError(final RetrievePatientCorrelationsRequestType respondingGatewayType, final ErrorMessage errorText)
	{
		queryError(respondingGatewayType, errorText.getMessage());
	}

	public static void queryError(final RetrievePatientCorrelationsRequestType respondingGatewayType, final ErrorMessage errorText, final String additionalInfo)
	{
		queryError(respondingGatewayType, errorText.getMessage() + ": " + additionalInfo);
	}

	public static String adHocQueryError(final PRPAIN201309UV02 queryType)
	{
		StringBuilder sb = new StringBuilder();
		if(queryType != null)
		{
		}
		else
		{
			sb.append("All Patiet Query parameters are missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static String assertionError(final AssertionType assertionType)
	{
		StringBuilder sb = new StringBuilder();
		if(assertionType != null)
		{
			String hcid = assertionType.getHomeCommunity() != null && StringUtils.isNotBlank(assertionType.getHomeCommunity().getHomeCommunityId()) ? assertionType.getHomeCommunity().getHomeCommunityId() : "Missing";
			sb.append("\tAssertion HCID: ").append(hcid).append("\n");
		}
		else
		{
			sb.append("Patient Query Assertion is missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static void queryError(final PRPAIN201309UV02 queryType, AssertionType assertionType, final String errorText)
	{
		StringBuilder sb = new StringBuilder();

		sb.append(LoggingUtils.ERROR_PREFIX).append(" ").append(errorText).append("\n");
		sb.append(adHocQueryError(queryType));
		sb.append(assertionError(assertionType));

		logger.error("error string {} ", sb); // CCR 177986- logging updates
	}
}
