package gov.va.med.nhin.adapter.internalApp;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

@Entity
@Cache(type = CacheType.SOFT, // Cache everything until the JVM decides memory
								// is low.
size = 64000, // Use 64,000 as the initial cache size.
expiry = 360000, // 1 minutes
coordinationType = CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS // if cache
																	// coordination
																	// is used,
																	// only send
																	// invalidation
																	// messages.
)
@Table(name = "INT_FAC_FILT_VIEW")
@NamedQueries({
    @NamedQuery(name = "InternalAppFilterView.findAll", query = "SELECT f FROM InternalAppFilterView f"),
    @NamedQuery(name = "InternalAppFilterView.findByFacilityName", query = "SELECT f FROM InternalAppFilterView f WHERE f.facilityName = :facilityName"),
    @NamedQuery(name = "InternalAppFilterView.findByFacilityNumber", query = "SELECT f FROM InternalAppFilterView f WHERE f.facilityNumber = :facilityNumber"),
    @NamedQuery(name = "InternalAppFilterView.findByViewID", query = "SELECT f FROM InternalAppFilterView f WHERE f.facFiltId = :filterId")
})
public class InternalAppFilterView implements Serializable
{
	private static final long serialVersionUID = 1L;
	@Id
	@Basic(optional = false)
	@Column(name = "FAC_FILT_ID")
	private int facFiltId;
	@Column(name = "FACILITY_NAME")
	private String facilityName;
	@Column(name = "FACILITY_NUMBER")
	private String facilityNumber;
	@Column(name = "FILTER_NAME")
	private String filterName;
	@Column(name = "ROOT_NAME")
	private String rootName;
	@Column(name = "OBJ_NAME")
	private String objName;
	@Column(name = "PARAM")
	private String parameter;

	/**
	 * @return the facSupId
	 */
	public int getFacFiltId()
	{
		return facFiltId;
	}

	/**
	 * @param facSupId the facSupId to set
	 */
	public void setFacFiltId(int facSupId)
	{
		this.facFiltId = facSupId;
	}

	/**
	 * @return the faciltiyName
	 */
	public String getFacilityName()
	{
		return facilityName;
	}

	/**
	 * @param faciltiyName the faciltiyName to set
	 */
	public void setFacilityName(String facilityName)
	{
		this.facilityName = facilityName;
	}

	/**
	 * @return the facilityNumber
	 */
	public String getFacilityNumber()
	{
		return facilityNumber;
	}

	/**
	 * @param facilityNumber the facilityNumber to set
	 */
	public void setFacilityNumber(String facilityNumber)
	{
		this.facilityNumber = facilityNumber;
	}

	/**
	 * @return the filterName
	 */
	public String getFilterName()
	{
		return filterName;
	}

	/**
	 * @param filterName the filterName to set
	 */
	public void setFilterName(String filterName)
	{
		this.filterName = filterName;
	}

	/**
	 * @return the rootName
	 */
	public String getRootName()
	{
		return rootName;
	}

	/**
	 * @param rootName the rootName to set
	 */
	public void setRootName(String rootName)
	{
		this.rootName = rootName;
	}

	/**
	 * @return the objName
	 */
	public String getObjName()
	{
		return objName;
	}

	/**
	 * @param objName the objName to set
	 */
	public void setObjName(String objName)
	{
		this.objName = objName;
	}

	/**
	 * @return the parameter
	 */
	public String getParameter()
	{
		return parameter;
	}

	/**
	 * @param parameter the parameter to set
	 */
	public void setParameter(String parameter)
	{
		this.parameter = parameter;
	}
}
