package gov.va.med.nhin.adapter.internalApp;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

@Entity
@Cache(type = CacheType.SOFT, // Cache everything until the JVM decides memory
								// is low.
size = 64000, // Use 64,000 as the initial cache size.
expiry = 360000, // 1 minutes
coordinationType = CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS // if cache
																	// coordination
																	// is used,
																	// only send
																	// invalidation
																	// messages.
)
@Table(name = "INT_FILT_CONST")
public class InternalAppEnums
{
	@Id
	@Basic(optional = false)
	@Column(name = "FILTER_ID")
	private int filterId;
	@Column(name = "FILTER_NAME")
	private String filterName;
	@Column(name = "FILTER_DESCRIPTION")
	private String filterDesc;

	/**
	 * @return the filterId
	 */
	public int getFilterId()
	{
		return filterId;
	}

	/**
	 * @param filterId the filterId to set
	 */
	public void setFilterId(int filterId)
	{
		this.filterId = filterId;
	}

	/**
	 * @return the filterName
	 */
	public String getFilterName()
	{
		return filterName;
	}

	/**
	 * @param filterName the filterName to set
	 */
	public void setFilterName(String filterName)
	{
		this.filterName = filterName;
	}

	/**
	 * @return the filterDesc
	 */
	public String getFilterDesc()
	{
		return filterDesc;
	}

	/**
	 * @param filterDesc the filterDesc to set
	 */
	public void setFilterDesc(String filterDesc)
	{
		this.filterDesc = filterDesc;
	}
}
