package gov.va.med.nhin.adapter.facilitymanager;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "FACILITIES_TO_AAS")
@NamedQueries({
    @NamedQuery(name = "FacilityToAA.findAll", query = "SELECT f FROM FacilityToAA f"),
    @NamedQuery(name = "FacilityToAA.findByFacilityToAAId", query = "SELECT f FROM FacilityToAA f WHERE f.facilityToAAId = :facilityToAAId")
})
@SequenceGenerator(name = "facilityToAAIdGenerator", sequenceName = "FACILITY_TO_AA_ID_SEQ", allocationSize = 1)
public class FacilityToAA implements Serializable
{
	private static final long serialVersionUID = 1L;

	@Id
	@Basic(optional = false)
	@Column(name = "FACILITY_TO_AA_ID")
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "facilityToAAIdGenerator")
	private Long facilityToAAId;
	@JoinColumn(name = "ASSIGNING_AUTHORITY_ID", referencedColumnName = "ASSIGNING_AUTHORITY_ID")
	@ManyToOne(optional = false, fetch = FetchType.EAGER)
	private AssigningAuthority assigningAuthority;
	@JoinColumn(name = "FACILITY_ID", referencedColumnName = "FACILITY_ID")
	@ManyToOne(optional = false, fetch = FetchType.EAGER)
	private Facility facility;

	public FacilityToAA()
	{
	}

	public FacilityToAA(Long facilityToAAId)
	{
		this.facilityToAAId = facilityToAAId;
	}

	public Long getFacilityToAAId()
	{
		return facilityToAAId;
	}

	public void setFacilyToAAId(Long facilityToAAId)
	{
		this.facilityToAAId = facilityToAAId;
	}

	public AssigningAuthority getAssigningAuthority()
	{
		return assigningAuthority;
	}

	public void setAssigningAuthority(AssigningAuthority assigningAuthority)
	{
		this.assigningAuthority = assigningAuthority;
	}

	public Facility getFacility()
	{
		return facility;
	}

	public void setFacility(Facility facility)
	{
		this.facility = facility;
	}

	@Override
	public int hashCode()
	{
		int hash = 0;
		hash += (facilityToAAId != null ? facilityToAAId.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object object)
	{
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if(!(object instanceof FacilityToAA))
		{
			return false;
		}
		FacilityToAA other = (FacilityToAA) object;
		if((this.facilityToAAId == null && other.facilityToAAId != null) || (this.facilityToAAId != null && !this.facilityToAAId.equals(other.facilityToAAId)))
		{
			return false;
		}
		return true;
	}

	@Override
	public String toString()
	{
		return "gov.va.med.nhin.adapter.facilitymanager.FacilityToAA[facilitiesToAasId=" + facilityToAAId + "]";
	}
}
