package gov.va.med.nhin.adapter.facilitymanager;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

/**
 *
 * @author MandepudiS
 */
@Entity
@Cache(
		  type=CacheType.SOFT, // Cache everything until the JVM decides memory is low.
		  size=64000,  // Use 64,000 as the initial cache size.
		  expiry=360000,  // 6 minutes
		  coordinationType=CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS  // if cache coordination is used, only send invalidation messages.
		)
@Table(name = "FAC_SUP_DOCTYPES")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "FacSupDoctypes.findAll", query = "SELECT f FROM FacSupDoctypes f"),
    @NamedQuery(name = "FacSupDoctypes.findByFacSupId", query = "SELECT f FROM FacSupDoctypes f WHERE f.facSupId = :facSupId"),
    @NamedQuery(name = "FacSupDoctypes.findByHomeCommunityId", query = "SELECT f FROM FacSupDoctypes f WHERE f.homeCommunityId = :homeCommunityId"),
    @NamedQuery(name = "FacSupDoctypes.findByLoincCode", query = "SELECT f FROM FacSupDoctypes f WHERE f.loincCode = :loincCode"),
    @NamedQuery(name = "FacSupDoctypes.findByDocSpecType", query = "SELECT f FROM FacSupDoctypes f WHERE f.docSpecType = :docSpecType"),
    @NamedQuery(name = "FacSupDoctypes.findByIsPrefType", query = "SELECT f FROM FacSupDoctypes f WHERE f.isPrefType = :isPrefType")})
public class FacSupDoctypes implements Serializable
{
	private static final long serialVersionUID = 1L;

	@Id
	@Basic(optional = false)
	@Column(name = "FAC_SUP_ID")
	private BigDecimal facSupId;
	@Column(name = "HOME_COMMUNITY_ID")
	private String homeCommunityId;
	@Column(name = "LOINC_CODE")
	private String loincCode;
	@Column(name = "DOC_SPEC_TYPE")
	private String docSpecType;
	@Column(name = "IS_PREF_TYPE")
	private String isPrefType;

	@Column(name = "QUERYNAME")
	private String queryName;

	public FacSupDoctypes()
	{
	}

	public FacSupDoctypes(BigDecimal facSupId)
	{
		this.facSupId = facSupId;
	}

	public BigDecimal getFacSupId()
	{
		return facSupId;
	}

	public void setFacSupId(BigDecimal facSupId)
	{
		this.facSupId = facSupId;
	}

	public String getHomeCommunityId()
	{
		return homeCommunityId;
	}

	public void setHomeCommunityId(String homeCommunityId)
	{
		this.homeCommunityId = homeCommunityId;
	}

	public String getLoincCode()
	{
		return loincCode;
	}

	public void setLoincCode(String loincCode)
	{
		this.loincCode = loincCode;
	}

	public String getDocSpecType()
	{
		return docSpecType;
	}

	public void setDocSpecType(String docSpecType)
	{
		this.docSpecType = docSpecType;
	}

	public String getIsPrefType()
	{
		return isPrefType;
	}

	public void setIsPrefType(String isPrefType)
	{
		this.isPrefType = isPrefType;
	}

	public String getQueryName()
	{
		return queryName;
	}

	public void setQueryName(String queryName)
	{
		this.queryName = queryName;
	}

	@Override
	public int hashCode()
	{
		int hash = 0;
		hash += (facSupId != null ? facSupId.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object object)
	{
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if(!(object instanceof FacSupDoctypes))
		{
			return false;
		}
		FacSupDoctypes other = (FacSupDoctypes) object;
		if((this.facSupId == null && other.facSupId != null) || (this.facSupId != null && !this.facSupId.equals(other.facSupId)))
		{
			return false;
		}
		return true;
	}

	@Override
	public String toString()
	{
		return "gov.va.adapter.test.FacSupDoctypes[ facSupId=" + facSupId + " ]";
	}
}
