package gov.va.med.nhin.adapter.documentrepositorycleanup;

import java.util.Collection;

import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepositoryLocal;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "DocumentRepositoryCleanup", mappedName = "DocumentRepositoryCleanup")
public class DocumentRepositoryCleanupBean implements DocumentRepositoryCleanupRemote, DocumentRepositoryCleanupLocal
{
	private static final Logger logger = LoggerFactory.getLogger(DocumentRepositoryCleanupBean.class.getName());

	private DocumentRepository documentRepository;
	private PropertyLookup propertyLookup;
	private SessionContext ctx;

	@EJB(beanInterface = DocumentRepositoryLocal.class)
	public void setDocumentRepository(DocumentRepository documentRepository)
	{
		this.documentRepository = documentRepository;
	}

	@EJB(beanInterface = PropertyLookupLocal.class)
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	@Resource
	public void setSessionContext(SessionContext ctx)
	{
		this.ctx = ctx;
	}

	public void startCleanupService()
	{
		logger.trace("Starting clean up service");
		TimerService timerService = ctx.getTimerService();
		String documentCacheCleanupInterval = propertyLookup.getProperty("documentCacheCleanupInterval");
		long dcci = Long.parseLong(documentCacheCleanupInterval);
		String documentCacheRetentionTime = propertyLookup.getProperty("documentCacheRetentionTime");
		Long dcrt = Long.parseLong(documentCacheRetentionTime);

		timerService.createTimer(dcci, dcci, dcrt);
	}

	public void stopCleanupService()
	{
		logger.trace("Stopping clean up service");
		TimerService timerService = ctx.getTimerService();
		Collection<Timer> timers = timerService.getTimers();
		for(Timer timer : timers)
		{
			timer.cancel();
		}
	}

	public void cleanup(long documentCacheRetentionTime)
	{
		documentRepository.deleteDocumentsNotAccessed(documentCacheRetentionTime);
	}

	@Timeout
	public void onTimeout(Timer timer)
	{
		Long documentCacheRetentionTime = (Long) timer.getInfo();
		cleanup(documentCacheRetentionTime);
	}
}
