package gov.va.med.nhin.adapter.datamanager.ejb;

import javax.ejb.EJB;
import javax.ejb.Stateless;

import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataManagerFactory;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

/**
 *
 * @author VHAISBVAZQUD
 */
@Stateless(name = "DataManager")
public class DataManagerBean implements DataManagerLocal
{
	private DataManager dataManager;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public DataQuery getQuery(String queryName)
	{
		if(dataManager == null)
		{
			dataManager = DataManagerFactory.getDataManager(propertyLookup.getProperty("dataManagerConfigFilename"));
		}
		
		return dataManager.getQuery(queryName);
	}
}
