package gov.va.med.nhin.adapter.cache;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "CACHE")
@NamedQueries({
    @NamedQuery(name = "Cache.findAll", query = "SELECT c FROM Cache c"),
    @NamedQuery(name = "Cache.findByCacheId", query = "SELECT c FROM Cache c WHERE c.cacheId = :cacheId"),
    @NamedQuery(name = "Cache.findByHash", query = "SELECT c FROM Cache c WHERE c.hash = :hash")
})
@SequenceGenerator(name = "cacheIdGenerator", sequenceName = "CACHE_ID_SEQ", allocationSize = 1)
public class Cache implements Serializable
{
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "CACHE_ID")
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "cacheIdGenerator")
    private Long cacheId;
    @Basic(optional = false)
    @Column(name = "HASH")
    private String hash;
    @Lob
    @Column(name = "DATA")
    private Serializable data;

    public Cache()
    {
    }

    public Cache(Long cacheId)
    {
        this.cacheId = cacheId;
    }

    public Cache(Long cacheId, String hash)
    {
        this.cacheId = cacheId;
        this.hash = hash;
    }

    public Long getCacheId()
    {
        return cacheId;
    }

    public void setCacheId(Long cacheId)
    {
        this.cacheId = cacheId;
    }

    public String getHash()
    {
        return hash;
    }

    public void setHash(String hash)
    {
        this.hash = hash;
    }

    public Serializable getData()
    {
        return data;
    }

    public void setData(Serializable data)
    {
        this.data = data;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (cacheId != null ? cacheId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Cache)) {
            return false;
        }
        Cache other = (Cache)object;
        if ((this.cacheId == null && other.cacheId != null) || (this.cacheId != null && !this.cacheId.equals(other.cacheId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.terminology.Cache[cacheId=" + cacheId + "]";
    }
}
