package gov.va.med.nhin.adapter.audit;

import java.util.Date;
import java.util.List;

/**
 *
 * @author David Vazquez
 */
public interface AuditManager
{
    public void storeAudit(Audit audit);

    public List<Audit> getAuditsByUserId(String userId, Date fromDate, Date toDate);

    public List<Audit> getAuditsByICN(String icn, Date fromDate, Date toDate);

    public List<Audit> getAuditsByICN(String icn, Date fromDate, Date toDate, String action);

    public List<AuditsReport> getAuditsByICN(String icn, Date fromDate, Date toDate, String[] actions);

    public List<AuditsReport> getAudits(Date fromDate, Date toDate,
                          String[] patientIds, boolean notPatientIds,
                          String[] organizations, boolean notOrganizations,
                          String[] remoteOrganizations, boolean notRemoteOrganizations,
                          String[] actions, boolean notActions,
                          int pageSize, int pageNumber);

    public List<AuditsReport> getAudits(Date fromDate, Date toDate,
                          String[] patientIds, boolean notPatientIds,
                          String[] organizations, boolean notOrganizations,
                          String[] remoteOrganizations, boolean notRemoteOrganizations,
                          String[] actions, boolean notActions,
                          String detailsSearch,
                          int pageSize, int pageNumber);
}
