DROP USER CISS CASCADE;
DROP USER CISS_EXT CASCADE;
DROP USER sdsadm CASCADE;
CREATE USER sdsadm IDENTIFIED BY sdsadm;
 
GRANT "DBA" TO sdsadm; 
GRANT "CONNECT" TO sdsadm;
GRANT "RESOURCE" TO sdsadm;



CREATE TABLE sdsadm.STD_AddressChangeSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AddressChangeSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressChangeSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AddressDeliveryFailureCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressDeliveryFailureCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(30) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AddressInvalidReason    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressInvalidReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AddressType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_AddressTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AdministrativeEntity    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AdministrativeEntity(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(80) NOT NULL UNIQUE,
  administrativeParent_id NUMBER(20, 0) NULL,
  agency_id NUMBER(20, 0) NULL,
  institution_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AdrsDlvryFlrCdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AdrsDlvryFlrCdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_AdrsInvalRsnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AdrsInvalRsnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AffectedExtremity    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AffectedExtremity(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AffectedExtremityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AffectedExtremityHistory(
  id_num NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Agency    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Agency(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(15) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);

INSERT INTO sdsadm.STD_Agency (id, code, name, description, version, created, updated, createdBy, updatedBy)
VALUES (1009121, 'V', 'VA', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Agency (id, code, name, description, version, created, updated, createdBy, updatedBy)
VALUES (1009122, 'AF', 'AIR FORCE', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Agency (id, code, name, description, version, created, updated, createdBy, updatedBy)
VALUES (1009123, 'I', 'IHS', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Agency (id, code, name, description, version, created, updated, createdBy, updatedBy)
VALUES (1009124, 'ARMY', 'ARMY', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Agency (id, code, name, description, version, created, updated, createdBy, updatedBy)
VALUES (1009125, 'N', 'NAVY', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Agency (id, code, name, description, version, created, updated, createdBy, updatedBy)
VALUES (1009126, 'O', 'OTHER', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);



/****** Object:  Table sdsadm.STD_AgencyHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AgencyHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AgentOrangeLocation    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AgentOrangeLocation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AgentOrangeLocnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AgentOrangeLocnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AlliedCountry    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AlliedCountry(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AlliedCountryHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AlliedCountryHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AppParameterType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AppParameterTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AppParameterUnit    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterUnit(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AppParameterUnitHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterUnitHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AppParamGrpType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParamGrpType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AppParamGrpTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParamGrpTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AssetType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssetType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL ,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AssetTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssetTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AssigningAuthority    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssigningAuthority(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  country_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AssigningAuthorityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssigningAuthorityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_BenefitsCoordType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BenefitsCoordType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_BenefitsCoordTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BenefitsCoordTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_BillingTransType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BillingTransType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_BillingTransTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BillingTransTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineReason    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineStTyp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineStTyp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineStTypHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineStTypHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CataDisabilityExtCd    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CataDisabilityExtCd(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CataDisabilityExtCdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CataDisabilityExtCdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ClinDeterType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ClinDeterType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ClinDeterTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ClinDeterTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CodeSet    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CodeSet(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(30) NULL,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(2000) NULL,
  implementor VARCHAR(10) NOT NULL,
  className VARCHAR(100) NOT NULL UNIQUE,
  tablename VARCHAR(30) NOT NULL UNIQUE,
  dataContentSteward VARCHAR(60) NULL,
  pocEmailAddress VARCHAR(200) NULL,
  applicationServiceOwner VARCHAR(60) NULL,
  registeredUsers VARCHAR(2000) NULL,
  integrationAgreements char(1) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_CodingSystem    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CodingSystem(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(45) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CodingSystemHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CodingSystemHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CollectionHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CollectionHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CollectionMethod    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CollectionMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  hl7code VARCHAR(8) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CombatLocation    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatLocation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  oeif_ind NUMBER(10, 0) NULL,
  startDate DATE NOT NULL,
  endDate DATE NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatLocationHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatLocationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatPayType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatPayType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatPayTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatPayTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatSvcLocation    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcLocation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  area VARCHAR(120) NOT NULL,
  included_locations VARCHAR(120) NOT NULL,
  startDate DATE NOT NULL,
  endDate DATE NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CombatSvcLocationHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcLocationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CombatSvcSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_CombatSvcSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommErrorType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommErrorType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommErrorTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommErrorTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommLetterGenType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterGenType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommLetterGenTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterGenTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommLetterType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommLetterTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommMailingStType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMailingStType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_CommMailingStTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMailingStTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommMlTriggerType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMlTriggerType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommMlTriggerTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMlTriggerTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ComRejectReasonType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ComRejectReasonType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code char(1) NOT NULL,
  name VARCHAR(100) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ComRejectReasonTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ComRejectReasonTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ConditionCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConditionCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ConditionCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConditionCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ConfAddrCatHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConfAddrCatHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ConfidentialAddressCat    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConfidentialAddressCat(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  hl7Value VARCHAR(10) NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Country    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Country(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  numericCode char(3) NOT NULL UNIQUE,
  shortName VARCHAR(64) NOT NULL,
  alpha3Code char(3) NOT NULL UNIQUE,
  fipsCode char(2) NOT NULL UNIQUE,
  postalName VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);

INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006004, '004', 'Afghanistan', 'AFG', 'AF', 'AFGHANISTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006008, '008', 'Albania', 'ALB', 'AL', 'ALBANIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006010, '010', 'Antarctica', 'ATA', 'AY', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006012, '012', 'Algeria', 'DZA', 'AG', 'ALGERIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006020, '020', 'Andorra', 'AND', 'AN', 'ANDORRA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006024, '024', 'Angola', 'AGO', 'AO', 'ANGOLA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006028, '028', 'Antigua and Barbuda', 'ATG', 'AC', 'ANTIGUA AND BARBUDA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006031, '031', 'Azerbaijan', 'AZE', 'AJ', 'AZERBAIJAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006032, '032', 'Argentina', 'ARG', 'AR', 'ARGENTINA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006036, '036', 'Australia', 'AUS', 'AS', 'AUSTRALIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006040, '040', 'Austria', 'AUT', 'AU', 'AUSTRIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006044, '044', 'Bahamas', 'BHS', 'BF', 'BAHAMAS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006048, '048', 'Bahrain', 'BHR', 'BA', 'BAHRAIN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006050, '050', 'Bangladesh', 'BGD', 'BG', 'BANGLADESH', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006051, '051', 'Armenia', 'ARM', 'AM', 'ARMENIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006052, '052', 'Barbados', 'BRB', 'BB', 'BARBADOS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006056, '056', 'Belgium', 'BEL', 'BE', 'BELGIUM', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006060, '060', 'Bermuda', 'BMU', 'BD', 'BERMUDA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006064, '064', 'Bhutan', 'BTN', 'BT', 'BHUTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006068, '068', 'Bolivia', 'BOL', 'BL', 'BOLIVIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006070, '070', 'Bosnia and Herzegovina', 'BIH', 'BK', 'BOSNIA-HERZOGOVINA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006072, '072', 'Botswana', 'BWA', 'BC', 'BOTSWANA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006074, '074', 'Bouvet Island', 'BVT', 'BV', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006076, '076', 'Brazil', 'BRA', 'BR', 'BRAZIL', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006084, '084', 'Belize', 'BLZ', 'BH', 'BELIZE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006086, '086', 'British Indian Ocean Territory', 'IOT', 'IO', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006090, '090', 'Solomon Islands', 'SLB', 'BP', 'SOLOMON ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006092, '092', 'Virgin Islands, British', 'VGB', 'VI', 'BRITISH VIRGIN ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006096, '096', 'Brunei Darussalam', 'BRN', 'BX', 'BRUNEI DARUSSALAM', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006100, '100', 'Bulgaria', 'BGR', 'BU', 'BULGARIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006104, '104', 'Myanmar', 'MMR', 'BM', 'BURMA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006108, '108', 'Burundi', 'BDI', 'BY', 'BURUNDI', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006112, '112', 'Belarus', 'BLR', 'BO', 'BELARUS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006116, '116', 'Cambodia', 'KHM', 'CB', 'CAMBODIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006120, '120', 'Cameroon', 'CMR', 'CM', 'CAMEROON', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006124, '124', 'Canada', 'CAN', 'CA', 'CANADA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006132, '132', 'Cape Verde', 'CPV', 'CV', 'CAPE VERDE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006136, '136', 'Cayman Islands', 'CYM', 'CJ', 'CAYMAN ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006140, '140', 'Central African Republic', 'CAF', 'CT', 'CENTRAL AFRICAN REPUBLIC', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006144, '144', 'Sri Lanka', 'LKA', 'CE', 'SRI LANKA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006148, '148', 'Chad', 'TCD', 'CD', 'CHAD', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006152, '152', 'Chile', 'CHL', 'CI', 'CHILE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006156, '156', 'China', 'CHN', 'CH', 'CHINA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006158, '158', 'Taiwan', 'TWN', 'TW', 'TAIWAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006162, '162', 'Christmas Island', 'CXR', 'KT', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006166, '166', 'Cocos (Keeling) Islands', 'CCK', 'CK', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006170, '170', 'Colombia', 'COL', 'CO', 'COLOMBIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006174, '174', 'Comoros', 'COM', 'CN', 'COMOROS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006175, '175', 'Mayotte', 'MYT', 'MF', 'FRANCE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006178, '178', 'Congo (Brazzaville)', 'COG', 'CF', 'REPUBLIC OF THE CONGO (BRAZZAVILLE)', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006180, '180', 'Congo (Kinshasa)', 'COD', 'CG', 'DEMOCRATIC REPUBLIC OF THE CONGO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006184, '184', 'Cook Islands', 'COK', 'CW', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006188, '188', 'Costa Rica', 'CRI', 'CS', 'COSTA RICA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006191, '191', 'Croatia', 'HRV', 'HR', 'CROATIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006192, '192', 'Cuba', 'CUB', 'CU', 'CUBA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006196, '196', 'Cyprus', 'CYP', 'CY', 'CYPRUS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006203, '203', 'Czech Republic', 'CZE', 'EZ', 'CZECH REPUBLIC', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006204, '204', 'Benin', 'BEN', 'BN', 'BENIN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006208, '208', 'Denmark', 'DNK', 'DA', 'DENMARK', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006212, '212', 'Dominica', 'DMA', 'DO', 'DOMINICA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006214, '214', 'Dominican Republic', 'DOM', 'DR', 'DOMINICAN REPUBLIC', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006218, '218', 'Ecuador', 'ECU', 'EC', 'ECUADOR', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006222, '222', 'El Salvador', 'SLV', 'ES', 'EL SALVADOR', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006226, '226', 'Equatorial Guinea', 'GNQ', 'EK', 'EQUATORIAL GUINEA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006231, '231', 'Ethiopia', 'ETH', 'ET', 'ETHIOPIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006232, '232', 'Eritrea', 'ERI', 'ER', 'ERITREA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006233, '233', 'Estonia', 'EST', 'EN', 'ESTONIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006234, '234', 'Faroe Islands', 'FRO', 'FO', 'FAROE ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006238, '238', 'Falkland Islands', 'FLK', 'FK', 'FALKLAND ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006239, '239', 'South Georgia and South Sandwich Islands', 'SGS', 'SX', 'FALKLAND ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006242, '242', 'Fiji', 'FJI', 'FJ', 'FIJI', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006246, '246', 'Finland', 'FIN', 'FI', 'FINLAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006250, '250', 'France', 'FRA', 'FR', 'FRANCE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006254, '254', 'French Guiana', 'GUF', 'FG', 'FRENCH GUIANA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006258, '258', 'French Polynesia', 'PYF', 'FP', 'FRENCH POLYNESIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006260, '260', 'French Southern Territories', 'ATF', 'FS', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006262, '262', 'Djibouti', 'DJI', 'DJ', 'DJIBOUTI', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006266, '266', 'Gabon', 'GAB', 'GB', 'GABON', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006268, '268', 'Georgia', 'GEO', 'GG', 'REPUBLIC OF GEORGIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006270, '270', 'Gambia', 'GMB', 'GA', 'GAMBIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006276, '276', 'Germany', 'DEU', 'GM', 'GERMANY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006288, '288', 'Ghana', 'GHA', 'GH', 'GHANA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006292, '292', 'Gibraltar', 'GIB', 'GI', 'GIBRALTAR', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006296, '296', 'Kiribati', 'KIR', 'KR', 'KIRIBATI', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006300, '300', 'Greece', 'GRC', 'GR', 'GREECE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006304, '304', 'Greenland', 'GRL', 'GL', 'GREENLAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006308, '308', 'Grenada', 'GRD', 'GJ', 'GRENADA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006312, '312', 'Guadeloupe', 'GLP', 'GP', 'GUADELOUPE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006320, '320', 'Guatemala', 'GTM', 'GT', 'GUATEMALA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006324, '324', 'Guinea', 'GIN', 'GV', 'GUINEA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006328, '328', 'Guyana', 'GUY', 'GY', 'GUYANA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006332, '332', 'Haiti', 'HTI', 'HA', 'HAITI', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006334, '334', 'Heard and McDonald Islands', 'HMD', 'HM', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006336, '336', 'Vatican City', 'VAT', 'VT', 'VATICAN CITY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);


INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006340, '340', 'Honduras', 'HND', 'HO', 'HONDURAS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006344, '344', 'Hong Kong', 'HKG', 'HK', 'HONG KONG', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006348, '348', 'Hungary', 'HUN', 'HU', 'HUNGARY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006352, '352', 'Iceland', 'ISL', 'IC', 'ICELAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006356, '356', 'India', 'IND', 'IN', 'INDIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006360, '360', 'Indonesia', 'IDN', 'ID', 'INDONESIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006364, '364', 'Iran', 'IRN', 'IR', 'IRAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006368, '368', 'Iraq', 'IRQ', 'IZ', 'IRAQ', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006372, '372', 'Ireland', 'IRL', 'EI', 'IRELAND (EIRE)', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006376, '376', 'Israel', 'ISR', 'IS', 'ISRAEL', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006380, '380', 'Italy', 'ITA', 'IT', 'ITALY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006384, '384', 'Cote d''Ivoire', 'CIV', 'IV', 'Cote d''Ivoire', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006388, '388', 'Jamaica', 'JAM', 'JM', 'JAMAICA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006392, '392', 'Japan', 'JPN', 'JA', 'JAPAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006398, '398', 'Kazakhstan', 'KAZ', 'KZ', 'KAZAKHSTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006400, '400', 'Jordan', 'JOR', 'JO', 'JORDAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006404, '404', 'Kenya', 'KEN', 'KE', 'KENYA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006408, '408', 'Korea, North', 'PRK', 'KN', 'DEMOCRATIC PEOPLE''S REPUBLIC OF KOREA (NORTH KOREA)', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006410, '410', 'Korea, South', 'KOR', 'KS', 'REPUBLIC OF KOREA (SOUTH KOREA)', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006414, '414', 'Kuwait', 'KWT', 'KU', 'KUWAIT', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006417, '417', 'Kyrgyzstan', 'KGZ', 'KG', 'KYRGYZSTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006418, '418', 'Laos', 'LAO', 'LA', 'LAOS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006422, '422', 'Lebanon', 'LBN', 'LE', 'LEBANON', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006426, '426', 'Lesotho', 'LSO', 'LT', 'LESOTHO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006428, '428', 'Latvia', 'LVA', 'LG', 'LATVIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006430, '430', 'Liberia', 'LBR', 'LI', 'LIBERIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006434, '434', 'Libya', 'LBY', 'LY', 'LIBYA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006438, '438', 'Liechtenstein', 'LIE', 'LS', 'LIECHTENSTEIN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006440, '440', 'Lithuania', 'LTU', 'LH', 'LITHUANIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006442, '442', 'Luxembourg', 'LUX', 'LU', 'LUXEMBOURG', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006446, '446', 'Macao', 'MAC', 'MC', 'MACAO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006450, '450', 'Madagascar', 'MDG', 'MA', 'MADAGASCAR', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006454, '454', 'Malawi', 'MWI', 'MI', 'MALAWI', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006458, '458', 'Malaysia', 'MYS', 'MY', 'MALAYSIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006462, '462', 'Maldives', 'MDV', 'MV', 'MALDIVES', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006466, '466', 'Mali', 'MLI', 'ML', 'MALI', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006470, '470', 'Malta', 'MLT', 'MT', 'MALTA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006474, '474', 'Martinique', 'MTQ', 'MB', 'MARTINIQUE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006478, '478', 'Mauritania', 'MRT', 'MR', 'MAURITANIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006480, '480', 'Mauritius', 'MUS', 'MP', 'MAURITIUS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006484, '484', 'Mexico', 'MEX', 'MX', 'MEXICO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006492, '492', 'Monaco', 'MCO', 'MN', 'FRANCE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006496, '496', 'Mongolia', 'MNG', 'MG', 'MONGOLIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006498, '498', 'Moldova', 'MDA', 'MD', 'MOLDOVA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006500, '500', 'Montserrat', 'MSR', 'MH', 'MONTSERRAT', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006504, '504', 'Morocco', 'MAR', 'MO', 'MOROCCO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006508, '508', 'Mozambique', 'MOZ', 'MZ', 'MOZAMBIQUE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006512, '512', 'Oman', 'OMN', 'MU', 'OMAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006516, '516', 'Namibia', 'NAM', 'WA', 'NAMIBIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006520, '520', 'Nauru', 'NRU', 'NR', 'NAURU', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006524, '524', 'Nepal', 'NPL', 'NP', 'NEPAL', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006528, '528', 'Netherlands', 'NLD', 'NL', 'NETHERLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006530, '530', 'Netherlands Antilles', 'ANT', 'NT', 'NETHERLANDS ANTILLES', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006533, '533', 'Aruba', 'ABW', 'AA', 'ARUBA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006540, '540', 'New Caledonia', 'NCL', 'NC', 'NEW CALEDONIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006548, '548', 'Vanuatu', 'VUT', 'NH', 'VANUATU', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006554, '554', 'New Zealand', 'NZL', 'NZ', 'NEW ZEALAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006558, '558', 'Nicaragua', 'NIC', 'NU', 'NICARAGUA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006562, '562', 'Niger', 'NER', 'NG', 'NIGER', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006566, '566', 'Nigeria', 'NGA', 'NI', 'NIGERIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006570, '570', 'Niue', 'NIU', 'NE', 'NEW ZEALAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006574, '574', 'Norfolk Island', 'NFK', 'NF', 'AUSTRALIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006578, '578', 'Norway', 'NOR', 'NO', 'NORWAY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006583, '583', 'Micronesia', 'FSM', 'FM', 'FEDERATED STATES OF MICRONESIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006586, '586', 'Pakistan', 'PAK', 'PK', 'PAKISTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006591, '591', 'Panama', 'PAN', 'PM', 'PANAMA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006598, '598', 'Papua New Guinea', 'PNG', 'PP', 'PAPUA NEW GUINEA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006600, '600', 'Paraguay', 'PRY', 'PA', 'PARAGUAY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006604, '604', 'Peru', 'PER', 'PE', 'PERU', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006608, '608', 'Philippines', 'PHL', 'RP', 'PHILIPPINES', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006612, '612', 'Pitcairn', 'PCN', 'PC', 'PITCAIRN ISLAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006616, '616', 'Poland', 'POL', 'PL', 'POLAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006620, '620', 'Portugal', 'PRT', 'PO', 'PORTUGAL', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006624, '624', 'Guinea-Bissau', 'GNB', 'PU', 'GUINEA-BISSAU', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006626, '626', 'Timor-Leste', 'TLS', 'TT', 'INDONESIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006634, '634', 'Qatar', 'QAT', 'QA', 'QATAR', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006638, '638', 'Reunion', 'REU', 'RE', 'Reunion', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006642, '642', 'Romania', 'ROU', 'RO', 'ROMANIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006643, '643', 'Russian Federation', 'RUS', 'RS', 'RUSSIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006646, '646', 'Rwanda', 'RWA', 'RW', 'RWANDA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006654, '654', 'Saint Helena', 'SHN', 'SH', 'SAINT HELENA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006659, '659', 'Saint Kitts and Nevis', 'KNA', 'SC', 'SAINT CHRISTOPHER (ST. KITTS) AND NEVIS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006660, '660', 'Anguilla', 'AIA', 'AV', 'ANGUILLA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006662, '662', 'Saint Lucia', 'LCA', 'ST', 'SAINT LUCIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006666, '666', 'Saint Pierre and Miquelon', 'SPM', 'SB', 'SAINT PIERRE AND MIQUELON', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006670, '670', 'Saint Vincent and the Grenadines', 'VCT', 'VC', 'SAINT VINCENT AND THE GRENADINES', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006674, '674', 'San Marino', 'SMR', 'SM', 'SAN MARINO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006678, '678', 'Sao Tome and Principe', 'STP', 'TP', 'SAO TOME AND PRINCIPE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006682, '682', 'Saudi Arabia', 'SAU', 'SA', 'SAUDI ARABIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006686, '686', 'Senegal', 'SEN', 'SG', 'SENEGAL', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006690, '690', 'Seychelles', 'SYC', 'SE', 'SEYCHELLES', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006694, '694', 'Sierra Leone', 'SLE', 'SL', 'SIERRA LEONE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006702, '702', 'Singapore', 'SGP', 'SN', 'SINGAPORE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006703, '703', 'Slovakia', 'SVK', 'LO', 'SLOVAK REPUBLIC', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006704, '704', 'Viet Nam', 'VNM', 'VM', 'VIETNAM', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006705, '705', 'Slovenia', 'SVN', 'SI', 'SLOVENIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006706, '706', 'Somalia', 'SOM', 'SO', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006710, '710', 'South Africa', 'ZAF', 'SF', 'SOUTH AFRICA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006716, '716', 'Zimbabwe', 'ZWE', 'ZI', 'ZIMBABWE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006724, '724', 'Spain', 'ESP', 'SP', 'SPAIN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);


INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006732, '732', 'Western Sahara', 'ESH', 'WI', NULL, 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006736, '736', 'Sudan', 'SDN', 'SU', 'SUDAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006740, '740', 'Suriname', 'SUR', 'NS', 'SURINAME', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006748, '748', 'Swaziland', 'SWZ', 'WZ', 'SWAZILAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006752, '752', 'Sweden', 'SWE', 'SW', 'SWEDEN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006756, '756', 'Switzerland', 'CHE', 'SZ', 'SWITZERLAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006760, '760', 'Syrian Arab Republic', 'SYR', 'SY', 'SYRIAN ARAB REPUBLIC', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006762, '762', 'Tajikistan', 'TJK', 'TI', 'TAJIKISTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006764, '764', 'Thailand', 'THA', 'TH', 'THAILAND', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006768, '768', 'Togo', 'TGO', 'TO', 'TOGO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006772, '772', 'Tokelau', 'TKL', 'TL', 'WESTERN SAMOA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006776, '776', 'Tonga', 'TON', 'TN', 'TONGA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006780, '780', 'Trinidad and Tobago', 'TTO', 'TD', 'TRINIDAD AND TOBAGO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006784, '784', 'United Arab Emirates', 'ARE', 'AE', 'UNITED ARAB EMIRATES', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006788, '788', 'Tunisia', 'TUN', 'TS', 'TUNISIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006792, '792', 'Turkey', 'TUR', 'TU', 'TURKEY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006795, '795', 'Turkmenistan', 'TKM', 'TX', 'TURKMENISTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006796, '796', 'Turks and Caicos Islands', 'TCA', 'TK', 'TURKS AND CAICOS ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006798, '798', 'Tuvalu', 'TUV', 'TV', 'TUVALU', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006800, '800', 'Uganda', 'UGA', 'UG', 'UGANDA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006804, '804', 'Ukraine', 'UKR', 'UP', 'UKRAINE', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006807, '807', 'Macedonia', 'MKD', 'MK', 'REPUBLIC OF MACEDONIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006818, '818', 'Egypt', 'EGY', 'EG', 'EGYPT', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006826, '826', 'United Kingdom', 'GBR', 'UK', 'UNITED KINGDOM', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006834, '834', 'Tanzania', 'TZA', 'TZ', 'TANZANIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006840, '840', 'United States', 'USA', 'US', '', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006854, '854', 'Burkina Faso', 'BFA', 'UV', 'BURKINA FASO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006858, '858', 'Uruguay', 'URY', 'UY', 'URUGUAY', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006860, '860', 'Uzbekistan', 'UZB', 'UZ', 'UZBEKISTAN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006862, '862', 'Venezuela', 'VEN', 'VE', 'VENEZUELA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006876, '876', 'Wallis and Futuna Islands', 'WLF', 'WF', 'WALLIS AND FUTUNA ISLANDS', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006887, '887', 'Yemen', 'YEM', 'YM', 'YEMEN', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006891, '891', 'Serbia and Montenegro', 'SCG', 'YI', 'SERBIA-MONTENEGRO', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_Country (id, numericCode, shortName, alpha3Code, fipsCode, postalName, version, created, updated, createdBy, updatedBy)
VALUES (1006894, '894', 'Zambia', 'ZMB', 'ZA', 'ZAMBIA', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);




/****** Object:  Table sdsadm.STD_CountryHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CountryHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_County    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_County(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(35) NOT NULL,
  countyNumber char(3) NOT NULL,
  description VARCHAR(60) NULL,
  state_id NUMBER(20, 0) NOT NULL UNIQUE,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CountyHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CountyHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DatabaseVersion    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DatabaseVersion(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  versionNumber VARCHAR(10) NULL,
  installationDate DATE NULL,
  description VARCHAR(50) NULL,
  version NUMBER NULL,
  created DATE NULL,
  updated DATE NULL,
  createdBy VARCHAR(50) NULL,
  updatedBy VARCHAR(50) NULL);




/****** Object:  Table sdsadm.STD_DataCollectJobType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DataCollectJobType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DataCollectJobTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DataCollectJobTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DeathNotification    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DeathNotification(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DeathNotificationHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DeathNotificationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationDocumentType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationDocumentType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DecorationStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DecoratnDocTypHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecoratnDocTypHistory(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Degree    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Degree(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(10) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DegreeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DegreeHistory(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DetailedIncFinDoc    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncFinDoc(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  detailedIncomeType_id NUMBER(20, 0) NOT NULL UNIQUE,
  financialDocumType_id NUMBER(20, 0) NOT NULL UNIQUE,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DetailedIncFinDocHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncFinDocHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DetailedIncomeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncomeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  earned_income NUMBER(10, 0) NULL,
  income_summary_type_id NUMBER(10, 0) NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DetailedIncomeTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncomeTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DiagnosisCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DiagnosisCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DiagnosisCodSch    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCodSch(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DiagnosisCodSchHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCodSchHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DiagnosisType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DiagnosisTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DisabilityCondition    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DisabilityCondition(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  ien NUMBER(10, 0) NOT NULL UNIQUE,
  dxcode VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DisabilityConditionHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DisabilityConditionHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DistributionCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DistributionCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DistributionType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DistributionTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DocumentSourceType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DocumentSourceType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DocumentSourceTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DocumentSourceTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EgtProcessStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtProcessStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EgtProcessStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtProcessStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EgtType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EgtTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ElectronicPlanType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ElectronicPlanType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ElectronicPlanTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ElectronicPlanTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligDocType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligDocType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligDocTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligDocTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  vaCodeType NUMBER(10, 0) NOT NULL,
  type_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligibilityCodeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCodeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityCodeTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCodeTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligibilityFactor    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityFactor(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EligibilityFactorHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityFactorHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligibilityPrimaryDataSrc    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityPrimaryDataSrc(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(30) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EligibilityVrScTyp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityVrScTyp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(30) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EligibilityVrScTypHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityVrScTypHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligPrmryDataSrcHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligPrmryDataSrcHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Email_Domain    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Email_Domain(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  institution_id NUMBER(20, 0) NOT NULL UNIQUE,
  email_domain_name VARCHAR(50) NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Email_DomainHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Email_DomainHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EmailAddressType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailAddressType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EmailAddressTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailAddressTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EmailChangeSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailChangeSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EmailChangeSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailChangeSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EmergencyResponse    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmergencyResponse(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EmergencyResponseHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmergencyResponseHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EmploymentStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmploymentStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EmploymentStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmploymentStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentCatType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentCatType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentCatTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentCatTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentOverrideReason    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentOverrideReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentOvrdeRsnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentOvrdeRsnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentPriorGrp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorGrp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentPriorGrpHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorGrpHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentPriorSGrp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorSGrp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentPriorSGrpHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorSGrpHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  enrollmentCat_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EntitlementCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EntitlementCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EntitlementCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EntitlementCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EthCollMthdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EthCollMthdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Ethnicity    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Ethnicity(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  abbreviation VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  hl7Value VARCHAR(10) NULL,
  cdcValue VARCHAR(6) NULL,
  ptfValue char(1) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EthnicityCollectionMethod    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EthnicityCollectionMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EthnicityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EthnicityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EvaluationMethod    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EvaluationMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EvaluationMethodHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EvaluationMethodHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ExclusionRsnType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExclusionRsnType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ExclusionRsnTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExclusionRsnTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ExpenseType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExpenseType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NULL,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(2000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ExpenseTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExpenseTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ExtremityCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExtremityCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ExtremityCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExtremityCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FacilityType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FacilityType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(11) NOT NULL UNIQUE,
  name VARCHAR(45) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  isMedicalTreating char(1) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);

SET DEFINE OFF

INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009141, 'AIMC', 'ACADEMIC AFFAIRS INF. MGMT CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009142, 'AO', 'AREA OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009143, 'AR', 'ACCOUNTS RECEIVABLE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009144, 'BDC', 'BENEFITS DELIVERY CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009145, 'BIRLS', 'BIRLS', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009146, 'BVA/VBA', 'BOARD OF VETERANS APPEALS/VBA SUPPORT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009147, 'BVA/VBA-SO', 'BOARD OF VETERANS APPEALS/VBA SUPPORT OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009148, 'CBOC', 'COMMUNITY BASED OUTPATIENT CLINIC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009149, 'CC', 'CONFEDERATE CEMETARY', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009150, 'CHAMPUS', 'CHAMPUS', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009151, 'CHAMPVA', 'CHAMPVA', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009152, 'CHEP', 'COOPERATIVE HEALTH EDUCATION PROGRAM', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009153, 'CIVH', 'CIVILIAN HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009154, 'CM', 'COFEDERATE MONUMENT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009155, 'CMOP', 'CONSOLIDATED MAIL OUTPATIENT PHARMACY', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009156, 'CO', 'CENTRAL OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009157, 'CP', 'CONFEDERATE PLOT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009158, 'DOM', 'DOMICILIARY', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009159, 'DEC', 'DENTAL EDUCATION CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009160, 'DENT', 'DENTAL CLINIC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009161, 'DOD', 'DEPARTMENT OF DEFENSE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009162, 'DPC', 'VA DATA PROCESSING CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009163, 'EES', 'EMPLOYEE EDUCATION SYSTEMS', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009164, 'ETC', 'ENGINEERING TRAINING CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009165, 'GC', 'GENERAL COUNSEL', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009166, 'GL', 'GOVERNMENT LOT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009167, 'HOST', 'HOSPITAL OPEN SYSTEMS TECHNOLOGY', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009168, 'HRA', 'HUMAN RESOURCES ADMINISTRATION', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009169, 'IG', 'INSPECTOR GENERAL', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009170, 'IHS', 'INDIAN HEALTH SERVICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009171, 'IHSD', 'IHS DEVELOPMENT CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009172, 'IO', 'INFORMATION OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009173, 'IVMP', 'INCOME VERIFICATION MATCH PROGRAM', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009174, 'M&ROC', 'MEDICAL AND REGIONAL OFFFICE CENTER', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009175, 'MC(&)', 'MEDICAL CENTER (MEDICAL AND DOMICILIARY)', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009176, 'MC(M)', 'MEDICAL CENTER (MEDICAL LOCATION)', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009177, 'MORC', 'MOBILE OUTREACH CLINIC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009178, 'MPI', 'MASTER PATIENT INDEX', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009179, 'MSN', 'MEMORIAL SERVICE NETWORK', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009180, 'MUG', 'MUMPS USERS GROUP', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009181, 'NAC', 'NATIONAL ACQUISITION CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009182, 'NC', 'NATIONAL CEMETERY', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009183, 'NCAO', 'NATIONAL CEMETERY AREA OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009184, 'NCSO', 'NATIONAL CEMETERY STATION OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009185, 'NHC', 'NURSING HOME CARE', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009186, 'NIB', 'NATIONAL INDUSTRIES FOR THE BLIND', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009187, 'NOA', 'NOA', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009188, 'NVA', 'FEDERAL HOSPITAL (OTHER)', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009189, 'OC', 'OUTPATIENT CLINIC (INDEPENDENT)', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009190, 'OCMC', 'OUTPATIENT CLINIC (SUBORDINATE)', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009191, 'OCS', 'OUTPATIENT CLINIC SUBSTATION', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009192, 'OIFO', 'OFFICE OF INFORMATION FIELD OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009193, 'OIG/ROA', 'REGIONAL OFFICE OF AUDIT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009194, 'OIG/ROI', 'REGIONAL OFFICE OF INVESTIGATIONS', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009195, 'OIG/SOA', 'SUB OFFICE OF AUDIT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009196, 'OISC', 'OFFICE OF INFORMATION SERVICE CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009197, 'OPC', 'OUT PATIENT CLINIC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009198, 'ORC', 'OUTREACH CLINIC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009199, 'OTHER', 'OTHER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009200, 'PDC', 'PROSTHETIC DISTRIBUTION CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009201, 'PHARM', 'PHARMACY', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009202, 'PHS', 'PUBLIC HEALTH SERVICE HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009203, 'PRDC', 'PROSTHETICS RESEARCH AND DEVELOPMENT CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009204, 'PRRTP', 'PSYCHOLOGICAL RESIDENTIAL REHAB TREATMNT PRG', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009205, 'PUBH', 'PUBLIC HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009206, 'PVA/VBD', 'PVA/VBD', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);


INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009207, 'RO', 'REGIONAL OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009208, 'RO&IC', 'REGIONAL OFFICE AND INSURANCE CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009209, 'RO-OC', 'REGIONAL OFFICE - OUTPATIENT CLINIC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009210, 'RPC', 'RECORDS PROCESSING CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009211, 'RPVM', 'REPUBLIC OF PHILIPPINES VETERANS MEMORIAL', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009212, 'SARRTP', 'SUBSTANCE ABUSE REHAB TREATMENT PROGRAM', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009213, 'SD', 'SUPPLY DEPOT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009214, 'SDC', 'SYSTEMS DEVELOPMENT CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009215, 'SENTIENT', 'SENTIENT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009216, 'SL', 'SOLDIERS LOT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009217, 'SOC', 'SATELLITE OUTPATIENT CLINIC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009218, 'STDIR', 'STATE DIRECTORS OF VA', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009219, 'STDM', 'STATE DOMICILIARY', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009220, 'STHH', 'STATE HH', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009221, 'STNB', 'STATE NURSING BEDS', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009222, 'SVH', 'STATE VETERANS HOME', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009223, 'UNIVERSITY', 'UNIVERSITY', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009224, 'USAF', 'US AIR FORCE HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009225, 'USAF-MC', 'USAF-MC', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009226, 'USAH', 'US ARMY HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009227, 'USCG', 'US COAST GUARD HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009228, 'USMC', 'US MARINE CORP HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009229, 'USNH', 'US NAVAL HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009230, 'VAIP', 'VA INSURANCE PAYMENT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009231, 'VAMC', 'VA MEDICAL CENTER', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009232, 'VANB', 'VA NURSING BEDS', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009233, 'VANPH', 'NEURAL PSYCHIATRIC HOSPITAL', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009234, 'VASDC', 'VA SERVICE & DISTRIBUTION CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009235, 'VBA', 'VETERANS BENEFITS ADMINISTRATION', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009236, 'VBAML', 'VBA MORGAGE LOAN', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009237, 'VCSFC', 'VETERANS CANTEEN SERVICE FINANCE CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009238, 'VCSFO', 'VETERANS CANTEEN SERVICE FIELD OFFICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009239, 'VEND/CONS', 'VENDOR/CONSULTANT', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009240, 'VET CENTER', 'VETERANS CENTER', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009241, 'VISN', 'VETERANS INTEGRATED SERVICE NETWORK', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009242, 'HCS', 'HEALTH CARE SYSTEM', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1009243, 'VCS', 'VETERANS CANTEEN SERVICE', NULL, '0', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1617786, 'HEALTH CARE', 'VA Southern Colorado Health Care System', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1617787, 'HEALTHCARE', 'VA Boston Health Care System', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1617788, 'M&ROC(M&RO)', 'Medical and Regional Office Center', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1617789, 'MOC', 'Mobile Outpatient Clinic', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1617790, 'NETWORK', 'VA Healthcare Network Upstate NY', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1617791, 'SATELLITE', 'Satellite Outpatient Clinic', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);
INSERT INTO sdsadm.STD_FacilityType (id, code, name, description, isMedicalTreating, version, created, updated, createdBy, updatedBy)
VALUES (1617792, 'VA ROSEBURG', 'VA Roseburg Health Care System', NULL, '1', 0, TO_DATE('2009-03-24', 'YYYY-MM-DD'), NULL, 'Initial Load', NULL);

SET DEFINE ON


/****** Object:  Table sdsadm.STD_FacilityTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FacilityTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FeeBasisPrgrmHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisPrgrmHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FeeBasisProgram    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisProgram(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FeeBasisTreatmentCodeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisTreatmentCodeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FeeBasisTrtmntHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisTrtmntHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FilipinoVeteranProof    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FilipinoVeteranProof(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FilipinoVetProofHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FilipinoVetProofHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinancialDocumType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialDocumType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FinancialDocumTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialDocumTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinancialMapping    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialMapping(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinancialMappingHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialMappingHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FinanInfoSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinanInfoSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinanInfoSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinanInfoSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FTITransStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FTITransStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FTITransType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(10) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FTITransTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Gender    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Gender(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_GenderHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_GenderHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_GMTThresholds    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_GMTThresholds(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  effectiveYear char(4) NOT NULL,
  stateName VARCHAR(50) NOT NULL,
  countyName VARCHAR(50) NOT NULL,
  FIPS char(5) NOT NULL,
  TRHD1 NUMBER(18, 0) NOT NULL,
  TRHD2 NUMBER(18, 0) NOT NULL,
  TRHD3 NUMBER(18, 0) NOT NULL,
  TRHD4 NUMBER(18, 0) NOT NULL,
  TRHD5 NUMBER(18, 0) NOT NULL,
  TRHD6 NUMBER(18, 0) NOT NULL,
  TRHD7 NUMBER(18, 0) NOT NULL,
  TRHD8 NUMBER(18, 0) NOT NULL,
  MSA NUMBER(10, 0) NOT NULL,
  msaName VARCHAR(40) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HealthBenefitType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HealthBenefitType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HealthBenefitTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HealthBenefitTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724EthnicityMap    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724EthnicityMap(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  hl7value VARCHAR(8) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  ethnicity_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724EthnicityMapHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724EthnicityMapHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724MaritalStaMap    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724MaritalStaMap(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  hl7value VARCHAR(8) NOT NULL UNIQUE, 
  name VARCHAR(80) NOT NULL UNIQUE,
  maritalstatus_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL724MaritalStaMapHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724MaritalStaMapHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL724RaceMap    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724RaceMap(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  hl7value VARCHAR(8) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  race_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724RaceMapHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724RaceMapHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7AckCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AckCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7AcknowledgementCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AcknowledgementCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7AcknowledgementType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AcknowledgementType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7AckTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AckTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ActionCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ActionCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(15) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ActionCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ActionCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7DataType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7DataType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7DataTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7DataTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7EventType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7EventType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7EventTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7EventTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7FileLevelEvent    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7FileLevelEvent(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7FileLevelEventHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7FileLevelEventHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7MasterFileIDCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MasterFileIDCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7MasterFileIDCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MasterFileIDCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7MessageStruc    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageStruc(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(7) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7MessageStrucHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageStrucHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7MessageType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7MessageTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ObservResultCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ObservResultCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(1000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ObservResultCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ObservResultCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7PrimaryKeyValueType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7PrimaryKeyValueType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7PrimKeyValTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7PrimKeyValTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ProcessingID    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcessingID(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ProcessingMode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcessingMode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ProcIDHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcIDHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ProcModeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcModeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QryRespFmtCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QryRespFmtCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QryRespFmtCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QryRespFmtCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QryRespStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QryRespStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QuanLimReqHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QuanLimReqHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QuantityLimitedRequest    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QuantityLimitedRequest(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryPriority    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryPriority(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryPriorityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryPriorityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryResponseStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryResponseStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QueryResults    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryResults(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryResultsHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryResultsHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RecLevErrRet    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevErrRet(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RecLevErrRetHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevErrRetHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RecLevEvCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevEvCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RecLevEvCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevEvCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RespLevCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespLevCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RespLevCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespLevCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RespModality    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespModality(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RespModalityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespModalityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7SrcOfComment    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7SrcOfComment(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7SrcOfCommentHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7SrcOfCommentHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ValueType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ValueType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ValueTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ValueTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7VersionID    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7VersionID(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(7) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7VersionIDHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7VersionIDHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_HL7WhatSubjectFltr    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7WhatSubjectFltr(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(90) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_HL7WhatSubjectFltrHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7WhatSubjectFltrHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdentifierType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdentifierType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdentifierTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdentifierTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdEventType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdEventType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdEventTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdEventTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdExcepTypeGroup    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdExcepTypeGroup(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  name VARCHAR(50) NOT NULL UNIQUE,
  create_task_ind NUMBER(10, 0) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdExcepTypeGroupHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdExcepTypeGroupHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdTaskProbCatery    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskProbCatery(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdTaskProbCateryHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskProbCateryHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdTaskStatusType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskStatusType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdTaskStatusTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskStatusTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeTestSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeTestSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IncomeTestType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_IncomeTestTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeThreshold    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeThreshold(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  income_threshold_year NUMBER(4, 0) NOT NULL,
  exempt_amount NUMBER(18, 0) NULL,
  medical_expense_deductible NUMBER(18, 0) NULL,
  child_income_exclusion NUMBER(18, 0) NULL,
  dependent NUMBER(18, 0) NULL,
  add_dependent_threshold NUMBER(18, 0) NULL,
  property_threshold NUMBER(18, 0) NULL,
  pension_threshold NUMBER(18, 0) NULL,
  pension_1_dependent NUMBER(18, 0) NULL,
  add_dependent_pension NUMBER(18, 0) NULL,
  ninety_day_hospital_copay NUMBER(18, 0) NULL,
  add_90_day_hospital_copay NUMBER(18, 0) NULL,
  outpatient_basic_care_copay NUMBER(18, 0) NULL,
  outpatient_specialty_copay NUMBER(18, 0) NULL,
  threshold_effective_date DATE NULL,
  aid_and_attendance_threshold NUMBER(18, 0) NULL,
  outpatient_preventive_copay NUMBER(18, 0) NULL,
  medication_copay NUMBER(18, 0) NULL,
  medication_copay_annual_cap NUMBER(18, 0) NULL,
  ltc_inpatient_copay NUMBER(18, 0) NULL,
  ltc_outpatient_copay NUMBER(18, 0) NULL,
  ltc_domiciliary_copay NUMBER(18, 0) NULL,
  inpatient_per_diem NUMBER(18, 0) NULL,
  description VARCHAR(2000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IncomeThresholdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeThresholdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IncomeTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeVerifStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeVerifStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE, 
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeVerifStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeVerifStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_InsPlanTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsPlanTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_InsRprtSrcHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsRprtSrcHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Institution    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Institution(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  activationDate DATE NULL,
  deactivationDate DATE NULL,
  name VARCHAR(80) NOT NULL UNIQUE,
  stationNumber VARCHAR(7) NULL,
  vistaname VARCHAR(30) NOT NULL UNIQUE,
  agency_id NUMBER(20, 0) NULL,
  streetCountry_id NUMBER(20, 0) NULL,
  streetAddressLine1 VARCHAR(64) NULL,
  streetAddressLine2 VARCHAR(64) NULL,
  streetAddressLine3 VARCHAR(64) NULL,
  streetCity VARCHAR(50) NULL,
  streetState_id NUMBER(20, 0) NULL,
  streetCounty_id NUMBER(20, 0) NULL,
  streetPostalCode VARCHAR(10) NULL,
  mailingCountry_id NUMBER(20, 0) NULL,
  mailingAddressLine1 VARCHAR(64) NULL,
  mailingAddressLine2 VARCHAR(64) NULL,
  mailingAddressLine3 VARCHAR(64) NULL,
  mailingCity VARCHAR(50) NULL,
  mailingState_id NUMBER(20, 0) NULL,
  mailingCounty_id NUMBER(20, 0) NULL,
  mailingPostalCode VARCHAR(10) NULL,
  facilityType_id NUMBER(20, 0) NOT NULL,
  mfn_zeg_recipient char(1) NOT NULL,
  parent_id NUMBER(20, 0) NULL,
  realignedFrom_id NUMBER(20, 0) NULL,
  realignedTo_id NUMBER(20, 0) NULL,
  visn_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


Insert into sdsadm.STD_Institution values(1000003,NULL,NULL, 'CAPITAL REGION DATA CTR (CRDC)', '103', 'CAPITAL REGION DATA CTR (CRDC)',1009121,1006840,NULL,NULL,NULL, 'FALLING WATERS',1009354,NULL,NULL,1006840,NULL,NULL,NULL, 'FALLING WATERS',1009354,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:43:11 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/15/06 changes');
Insert into sdsadm.STD_Institution values(1000004,NULL,NULL, 'AUSTIN FINANCE CENTER', '104', 'AUSTIN FINANCE CENTER',1009121,1006840,NULL,NULL,NULL, 'AUSTIN',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009156, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000005,NULL,NULL, 'VBA MORTGAGE LOAN', '105', 'VBA MORTGAGE LOAN',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009235, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000006,NULL,NULL, 'FORUM', '120', 'FORUM',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000007,NULL,NULL, 'CENTRAL OFFICE (123)', '123', 'CENTRAL OFFICE (123)',1009121,1006840,NULL,NULL,NULL,NULL,1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009156, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000008,NULL,NULL, 'AUSTIN INFORMATION TECH CTR', '200', 'AUSTIN INFORMATION TECH CTR',1009121,1006840, '1615 WOODWARD ST.',NULL,NULL, 'AUSTIN',1009348,NULL, '78772',1006840, '1615 WOODWARD ST.',NULL,NULL, 'AUSTIN',1009348,NULL, '78772',1009162, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:55:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 12/14/2009 changes');
Insert into sdsadm.STD_Institution values(1000010,NULL,NULL, 'LOS ANGELES (DPC)', '202', 'LOS ANGELES (DPC)',1009121,1006840,NULL,NULL,NULL, 'LOS ANGELES',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009162, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000011,NULL,NULL, 'PHILADELPHIA (DPC)', '203', 'PHILADELPHIA (DPC)',1009121,1006840,NULL,NULL,NULL, 'PHILADELPHIA',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009162, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000012,NULL,NULL, 'ST. PAUL (DPC)', '204', 'ST. PAUL (DPC)',1009121,1006840,NULL,NULL,NULL, 'ST. PAUL',1009327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009162, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000013,NULL,NULL, 'WASHINGTON (DPC)', '205', 'WASHINGTON (DPC)',1009121,1006840,NULL,NULL,NULL,NULL,1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009162, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000016,NULL,NULL, 'AUSTIN SYSTEMS DEVELOPMENT CENTER', '281', 'AUSTIN (281)',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000019,NULL,NULL, 'PHILADELPHIA DELIVERY CTR', '284', 'PHILADELPHIA DELIVERY CTR',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000020,NULL,NULL, 'PHILADELPHIA SUPPLY DEPOT', '285', 'PHILADELPHIA SUPPLY DEPOT',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000021,NULL,NULL, 'BOSTON-RO', '301', 'BOSTON-RO',1009121,1006840,NULL,NULL,NULL, 'BOSTON',1009325,NULL, '2114',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000022,NULL,NULL, 'PROVIDENCE-RO', '304', 'PROVIDENCE-RO',1009121,1006840,NULL,NULL,NULL, 'PROVIDENCE',1009344,NULL, '2903',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000023,NULL,NULL, 'NEW YORK-RO', '306', 'NEW YORK-RO',1009121,1006840,NULL,NULL,NULL, 'NEW YORK',1009336,NULL, '10014',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000024,NULL,NULL, 'BUFFALO-RO', '307', 'BUFFALO-RO',1009121,1006840,NULL,NULL,NULL, 'BUFFALO',1009336,NULL, '14202',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000025,NULL,NULL, 'HARTFORD-RO', '308', 'HARTFORD-RO',1009121,1006840,NULL,NULL,NULL, 'HARTFORD',1009309,NULL, '6103',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000026,NULL,NULL, 'NEWARK-RO', '309', 'NEWARK-RO',1009121,1006840,NULL,NULL,NULL, 'NEWARK',1009334,NULL, '7102',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000027,NULL,NULL, 'PHILADELPHIA-RO', '310', 'PHILADELPHIA-RO',1009121,1006840,NULL,NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19101',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000028,NULL,NULL, 'PITTSBURG-RO', '311', 'PITTSBURG-RO',1009121,1006840,NULL,NULL,NULL, 'PITTSBURGH',1009342,NULL, '15222',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000029,NULL,NULL, 'BALTIMORE-RO', '313', 'BALTIMORE-RO',1009121,1006840,NULL,NULL,NULL, 'BALTIMORE',1009324,NULL, '21201',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000030,NULL,NULL, 'ROANOKE-RO', '314', 'ROANOKE-RO',1009121,1006840,NULL,NULL,NULL, 'ROANOKE',1009351,NULL, '24011',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000031,NULL,NULL, 'HUNTINGTON-RO', '315', 'HUNTINGTON-RO',1009121,1006840,NULL,NULL,NULL, 'HUNTINGTON',1009354,NULL, '25701',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000032,NULL,NULL, 'ATLANTA-RO', '316', 'ATLANTA-RO',1009121,1006840,NULL,NULL,NULL, 'ATLANTA',1009313,NULL, '30033',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000033,NULL,NULL, 'ST. PETERSBURG-RO', '317', 'ST. PETERSBURG-RO',1009121,1006840,NULL,NULL,NULL, 'ST. PETERSBURG',1009312,NULL, '33708',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000034,NULL,NULL, 'WINSTON-RO', '318', 'WINSTON-RO',1009121,1006840,NULL,NULL,NULL, 'SALEM',1009337,NULL, '27155',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000035,NULL,NULL, 'COLUMBIA-RO', '319', 'COLUMBIA-RO',1009121,1006840, '6437 GARNERS FERRY ROAD',NULL,NULL, 'COLUMBIA',1009345,NULL, '29209',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000036,NULL,NULL, 'NASHVILLE-RO', '320', 'NASHVILLE-RO',1009121,1006840,NULL,NULL,NULL, 'NASHVILLE',1009347,NULL, '37203',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000037,NULL,NULL, 'NEW ORLEANS-RO', '321', 'NEW ORLEANS-RO',1009121,1006840,NULL,NULL,NULL, 'NEW ORLEANS',1009322,NULL, '70113',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000038,NULL,NULL, 'MONTGOMERY-RO', '322', 'MONTGOMERY-RO',1009121,1006840,NULL,NULL,NULL, 'MONTGOMERY',1009301,NULL, '36109',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000039,NULL,NULL, 'JACKSON-RO', '323', 'JACKSON-RO',1009121,1006840,NULL,NULL,NULL, 'JACKSON',1009328,NULL, '39216',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000040,NULL,NULL, 'VBA TIGER TEAM 324', '324', 'VBA TIGER TEAM 324',1009121,1006840,NULL,NULL,NULL,NULL,1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000041,NULL,NULL, 'CLEVELAND-RO', '325', 'CLEVELAND-RO',1009121,1006840,NULL,NULL,NULL, 'CLEVELAND',1009339,NULL, '44199',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000042,NULL,NULL, 'INDIANAPOLIS-RO', '326', 'INDIANAPOLIS-RO',1009121,1006840,NULL,NULL,NULL, 'INDIANAPOLIS',1009318,NULL, '46204',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000043,NULL,NULL, 'LOUISVILLE-RO', '327', 'LOUISVILLE-RO',1009121,1006840,NULL,NULL,NULL, 'LOUISVILLE',1009321,NULL, '40202',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000044,NULL,NULL, 'CHICAGO-RO', '328', 'CHICAGO-RO',1009121,1006840,NULL,NULL,NULL, 'CHICAGO',1009317,NULL, '60605',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000045,NULL,NULL, 'DETROIT-RO', '329', 'DETROIT-RO',1009121,1006840,NULL,NULL,NULL, 'DETROIT',1009326,NULL, '48226',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000046,NULL,NULL, 'MILWAUKEE-RO', '330', 'MILWAUKEE-RO',1009121,1006840,NULL,NULL,NULL, 'MILWAUKEE',1009355,NULL, '53295',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000047,NULL,NULL, 'ST. LOUIS-RO', '331', 'ST. LOUIS-RO',1009121,1006840,NULL,NULL,NULL, 'ST. LOUIS',1009329,NULL, '63103',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000048,NULL,NULL, 'DES MOINES-RO', '333', 'DES MOINES-RO',1009121,1006840,NULL,NULL,NULL, 'DES MOINES',1009319,NULL, '50309',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000049,NULL,NULL, 'LINCOLN-RO', '334', 'LINCOLN-RO',1009121,1006840, '3800 VILLAGE DR',NULL,NULL, 'LINCOLN',1009331,NULL, '68516-5816',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1000050,NULL,NULL, 'ST. PAUL-RO', '335', 'ST. PAUL-RO',1009121,1006840,NULL,NULL,NULL, 'ST. PAUL',1009327,NULL, '55111',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000051,NULL,NULL, 'DENVER-RO', '339', 'DENVER-RO',1009121,1006840,NULL,NULL,NULL, 'DENVER',1009308,NULL, '80255',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000052,NULL,NULL, 'ALBUQUERQUE-RO', '340', 'ALBUQUERQUE-RO',1009121,1006840,NULL,NULL,NULL, 'ALBUQUERQUE',1009335,NULL, '87102',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000053,NULL,NULL, 'SALT LAKE CITY-RO', '341', 'SALT LAKE CITY-RO',1009121,1006840,NULL,NULL,NULL, 'SALT LAKE CITY',1009349,NULL, '84158',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000054,NULL,NULL, 'OAKLAND-RO', '343', 'OAKLAND-RO',1009121,1006840,NULL,NULL,NULL, 'OAKLAND',1009306,NULL, '94612',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000055,NULL,NULL, 'LOS ANGELES-RO', '344', 'LOS ANGELES-RO',1009121,1006840,NULL,NULL,NULL, 'LOS ANGELES',1009306,NULL, '90024',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000056,NULL,NULL, 'PHOENIX-RO', '345', 'PHOENIX-RO',1009121,1006840,NULL,NULL,NULL, 'PHOENIX',1009304,NULL, '85012',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000057,NULL,NULL, 'SEATTLE-RO', '346', 'SEATTLE-RO',1009121,1006840,NULL,NULL,NULL, 'SEATTLE',1009353,NULL, '98174',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000058,NULL,NULL, 'BOISE-RO', '347', 'BOISE-RO',1009121,1006840,NULL,NULL,NULL, 'BOISE',1009316,NULL, '83702',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000059,NULL,NULL, 'PORTLAND-RO', '348', 'PORTLAND-RO',1009121,1006840,NULL,NULL,NULL, 'PORTLAND',1009341,NULL, '97204',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000060,NULL,NULL, 'WACO-RO', '349', 'WACO-RO',1009121,1006840,NULL,NULL,NULL, 'WACO',1009348,NULL, '76799',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000061,NULL,NULL, 'LITTLE ROCK-RO', '350', 'LITTLE ROCK-RO',1009121,1006840,NULL,NULL,NULL, 'LITTLE ROCK',1009305,NULL, '72115',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000062,NULL,NULL, 'MUSKOGEE-RO', '351', 'MUSKOGEE-RO',1009121,1006840,NULL,NULL,NULL, 'MUSKOGEE',1009340,NULL, '74401',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000063,NULL,NULL, 'RENO-RO', '354', 'RENO-RO',1009121,1006840,NULL,NULL,NULL, 'RENO',1009332,NULL, '89502',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000064,NULL,NULL, 'SAN JUAN-RO', '355', 'SAN JUAN-RO',1009121,1006840,NULL,NULL,NULL, 'HATO REY',1009372,NULL, '918',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000066,NULL,NULL, 'HONOLULU-RO', '359', 'HONOLULU-RO',1009121,1006840, 'P.0. Box 50188',NULL,NULL, 'HONOLULU',1009315,NULL, '96819-1522',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000068,NULL,NULL, 'ANCHORAGE RO', '363', 'ANCHORAGE RO',1009121,1006840, '1201 NORTH MULDOON ROAD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:00:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 11/09/2010 changes');
Insert into sdsadm.STD_Institution values(1000069,NULL,NULL, 'WASHINGTON DC-RO', '372', 'WASHINGTON DC-RO',1009121,1006840,NULL,NULL,NULL, 'WASHINGTON',1009311,NULL, '20421',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000070,NULL,NULL, 'MANCHESTER-RO', '373', 'MANCHESTER-RO',1009121,1006840,NULL,NULL,NULL, 'MANCHESTER',1009333,NULL, '3101',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000071,NULL,NULL, 'ROME-RO', '374', 'ROME-RO',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000072,NULL,NULL, 'ST. LOUIS (RPC)', '375', 'ST. LOUIS (RPC)',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009210, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000074,NULL,NULL, 'SAN DIEGO-RO', '377', 'SAN DIEGO-RO',1009121,1006840,NULL,NULL,NULL, 'SAN DIEGO',1009306,NULL, '92108',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000075,NULL,NULL, 'ARMY', '378', 'ARMY',1009124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000076,NULL,NULL, 'NAVY', '379', 'NAVY',1009125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009229, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000078,NULL,NULL, 'AIR FORCE', '381', 'AIR FORCE',1009122,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000079,NULL,NULL, 'COAST GUARD', '382', 'COAST GUARD',1009125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009227, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000080,NULL,NULL, 'PUBLIC HEALTH SERVICE', '383', 'PUBLIC HEALTH SERVICE',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009202, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000081,NULL,NULL, 'CONTINENTAL DISTRICT', '384', 'CONTINENTAL DISTRICT',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000082,NULL,NULL, 'DEBT MANAGEMENT CENTER', '389', 'DEBT MANAGEMENT CENTER',1009121,1006840,NULL,NULL,NULL,NULL,1009327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000083,NULL,NULL, 'EASTERN AREA OFFICE', '392', 'EASTERN AREA OFFICE',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000084,NULL,NULL, 'SOUTHERN AREA OFFICE', '393', 'SOUTHERN AREA OFFICE',1009121,1006840,NULL,NULL,NULL,NULL,1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000085,NULL,NULL, 'CENTRAL AREA OFFICE', '394', 'CENTRAL AREA OFFICE',1009121,1006840,NULL,NULL,NULL,NULL,1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000086,NULL,NULL, 'WESTERN AREA OFFICE', '395', 'WESTERN AREA OFFICE',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000087,NULL,NULL, 'APPEALS MANAGEMENT CENTER (397)', '397', 'APPEALS MANAGEMENT CENTER',1009121,1006840,NULL,NULL,NULL,NULL,1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009147, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000088,NULL,NULL, 'MAINE VA HCS', '402', 'VA MAINE HCS',1009121,1006840, '1 VA CENTER',NULL,NULL, 'AUGUSTA',1009323,NULL, '04330-6719',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009174, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000089,NULL,NULL, 'WHITE RIVER JCT VAMROC', '405', 'WHITE RIVER JCT VAMROC',1009121,1006840, '215 NORTH MAIN STREET',NULL,NULL, 'WHITE RIVER JUNCTION',1009350,NULL, '05009-3833',1006840, '215 NORTH MAIN STREET',NULL,NULL, 'WHITE RIVER JUNCTION',1009350,NULL, '05009-3833',1009174, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000090,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'CRAWFORD COUNTY CBOC (420)', '420', 'ZZ CRAWFORD COUNTY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000091,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ASHTABULA COUNTY CBOC (421)', '421', 'ZZ ASHTABULA COUNTY',1009121,1006840,NULL,NULL,NULL,NULL,1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000092,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MCKEAN COUNTY CBOC', '422', 'ZZ MCKEAN COUNTY CBOC',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000093,NULL,NULL, 'JACKSON VAMROC', '423', 'JACKSON VAMROC',1009121,1006840,NULL,NULL,NULL,NULL,1009328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009174, '0',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1000094,NULL,NULL, 'DES MOINES VAMROC', '433', 'DES MOINES VAMROC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009174, '0',1002223,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1000095,NULL,NULL, 'FORT HARRISON MEDICAL CENTER', '436', 'FORT HARRISON MEDICAL CENTER',1009121,1006840, '3687 VETERANS DRIVE',NULL,NULL, 'FORT HARRISON',1009330,NULL, '59636-9703',1006840, '3687 VETERANS DRIVE',NULL,NULL, 'FORT HARRISON',1009330,NULL, '59636-9703',1009174, '1',1002142,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000096,NULL,NULL, 'FARGO VA HCS', '437', 'FARGO VA HCS',1009121,1006840, '2101 NORTH ELM STREET',NULL,NULL, 'FARGO',1009338,NULL, '58102-2417',1006840, '2101 NORTH ELM STREET',NULL,NULL, 'FARGO',1009338,NULL, '58102-2417',1009174, '1',1002223,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1000097,NULL,NULL, 'SIOUX FALLS VA HCS', '438', 'SIOUX FALLS VA HCS',1009121,1006840, '2501 WEST 22ND ST.',NULL,NULL, 'SIOUX FALLS',1009346,NULL, '57117-1305',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009174, '1',1002223,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1000098,NULL,NULL, 'CHEYENNE VA MEDICAL', '442', 'CHEYENNE VA MEDICAL',1009121,1006840, '2360 E PERSHING BLVD',NULL,NULL, 'CHEYENNE',1009356,NULL, '82001-5356',1006840, '2360 E PERSHING BLVD',NULL,NULL, 'CHEYENNE',1009356,NULL, '82001-5356',1009174, '1',1002219,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000099,NULL,NULL, 'BOISE VAMROC', '447', 'BOISE VAMROC',1009121,1006840,NULL,NULL,NULL,NULL,1009316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009174, '0',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1000100,NULL,NULL, 'ROBERT J. DOLE DEPARTMENT OF VETERANS AFFAIRS MEDICAL AND REGIONAL OFFICE CENTER', '452', 'WICHITA-RO',1009121,1006840, 'VA Medical and Regional Office Center',NULL,NULL, 'WICHITA',1009320,NULL, '67218-1607',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,1001265,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000101,NULL,NULL, 'RENO VAMROC', '454', 'RENO VAMROC',1009121,1006840,NULL,NULL,NULL,NULL,1009332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009174, '0',1002222,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1000102,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SAN JUAN-RO', '455', 'ZZ SAN JUAN-RO',1009121,1006840,NULL,NULL,NULL,NULL,1009372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009207, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000103,NULL,NULL, 'SPARK M. MATSUNAGA VAMC', '459', 'SPARK M. MATSUNAGA VAMC',1009121,1006840, '459 PATTERSON ROAD',NULL,NULL, 'HONOLULU',1009315,NULL, '96819-1522',1006840, '459 PATTERSON ROAD',NULL,NULL, 'HONOLULU',1009315,NULL, '96819-1522',1009174, '1',1002221,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000104,NULL,NULL, 'WILMINGTON VA MEDICAL CENTER', '460', 'WILMINGTON VA MEDICAL CENTER',1009121,1006840, '1601 KIRKWOOD HIGHWAY',NULL,NULL, 'WILMINGTON',1009310,NULL, '19805-4917',1006840, '1601 KIRKWOOD HIGHWAY',NULL,NULL, 'WILMINGTON',1009310,NULL, '19805-4917',1009174, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000105,NULL,NULL, 'ANCHORAGE VA MEDICAL CENTER', '463', 'ANCHORAGE VA MEDICAL CENTER',1009121,1006840, '1201 NORTH MULDOON ROAD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504-6104',1006840, '1201 NORTH MULDOON ROAD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504-6104',1009189, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000107,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ALBANY VA MEDICAL CENTER', '999HH', 'ZZ ALBANY',1009121,1006840, '113 Holland Avenue',NULL,NULL, 'ALBANY',1009336,NULL, '12208',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000820,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000109,NULL,NULL, 'ALEXANDRIA VA MEDICAL CENTER', '502', 'ALEXANDRIA VA MEDICAL CENTER',1009121,1006840, '2495 SHREVEPORT HWY 71 NORTH',NULL,NULL, 'PINEVILLE',1009322,NULL, '71360-4044',1006840, '2495 SHREVEPORT HWY 71 NORTH',NULL,NULL, 'PINEVILLE',1009322,NULL, '71360-4044',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000110,NULL,NULL, 'JAMES E VAN ZANDT VAMC', '503', 'JAMES E VAN ZANDT VAMC',1009121,1006840, '2907 PLEASANT VALLEY BOULEVARD',NULL,NULL, 'ALTOONA',1009342,NULL, '16602-4305',1006840, '2907 PLEASANT VALLEY BOULEVARD',NULL,NULL, 'ALTOONA',1009342,NULL, '16602-4305',1009231, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000112,NULL,TO_DATE('7/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ AMERICAN LAKE VAMC', '505', 'ZZ AMERICAN LAKE VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001816,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000113,NULL,NULL, 'ANN ARBOR VA MEDICAL CENTER', '506', 'ANN ARBOR VA MEDICAL CENTER',1009121,1006840, '2215 Fuller Road',NULL,NULL, 'ANN ARBOR',1009326,NULL, '48105-2303',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000114,NULL,NULL, 'ATLANTA VAMC', '508', 'ATLANTA VAMC',1009121,1006840, '1670 CLAIRMONT RD',NULL,NULL, 'DECATUR',1009313,NULL, '30033-4004',1006840, '1670 CLAIRMONT RD',NULL,NULL, 'DECATUR',1009313,NULL, '30033-4004',1009231, '1',1002207,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000115,NULL,NULL, 'AUGUSTA VAMC', '509', 'AUGUSTA VAMC',1009121,1006840, '950 15TH STREET',NULL,NULL, 'AUGUSTA',1009313,NULL, '30901-2608',NULL, '950 15TH STREET',NULL,NULL, 'AUGUSTA',1009313,NULL, '30901-2608',1009231, '1',1002207,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000116,NULL,NULL, 'VA MARYLAND HEALTH CARE SYS', '512', 'VA MARYLAND HEALTH CARE SYS',1009121,1006840, '10 N. GREENE STREET',NULL,NULL, 'BALTIMORE',1009324,NULL, '21201-1524',1006840, '10 N. GREENE STREET',NULL,NULL, 'BALTIMORE',1009324,NULL, '21201-1524',1009231, '1',1002141,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000117,NULL,TO_DATE('1/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BATAVIA VAMC', '513', 'ZZ BATAVIA VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000816,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000118,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BATH VAMC', '514', 'ZZ BATH VAMC',1009121,1006840,NULL,NULL,NULL, 'BATH',1009336,NULL, '14810',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000818,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000119,NULL,NULL, 'BATTLE CREEK VA MEDICAL CENTER', '515', 'BATTLE CREEK VA MEDICAL CENTER',1009121,1006840, '5500 ARMSTRONG ROAD',NULL,NULL, 'BATTLE CREEK',1009326,NULL, '49037-7314',1006840, '5500 ARMSTRONG ROAD',NULL,NULL, 'BATTLE CREEK',1009326,NULL, '49037-7314',1009231, '1',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000120,NULL,NULL, 'C.W. BILL YOUNG DEPT OF VAMC', '516', 'C.W. BILL YOUNG DEPT OF VAMC',1009121,1006840, '10000 BAY PINES BLVD',NULL,NULL, 'ST PETERSBURG',1009312,NULL, '33744-8298',1006840, 'PO BOX 5005',NULL,NULL, 'BAY PINES',1009312,NULL, '33744-8298',1009231, '1',1002208,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000121,NULL,NULL, 'BECKLEY VA MEDICAL CENTER', '517', 'BECKLEY VA MEDICAL CENTER',1009121,1006840, '200 VETERANS AVENUE',NULL,NULL, 'BECKLEY',1009354,NULL, '25801-6444',1006840, '200 VETERANS AVENUE',NULL,NULL, 'BECKLEY',1009354,NULL, '25801-6444',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000122,NULL,NULL, 'EDITH NOURSE ROGERS VAMC', '518', 'EDITH NOURSE ROGERS VAMC',1009121,1006840, '200 SPRINGS ROAD',NULL,NULL, 'BEDFORD',1009325,NULL, '01730-1114',1006840, '200 SPRINGS ROAD',NULL,NULL, 'BEDFORD',1009325,NULL, '01730-1114',1009231, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/11/2015 11:19:34 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0935 10/07/2015');
Insert into sdsadm.STD_Institution values(1000123,NULL,NULL, 'WEST TEXAS VA HEALTH CARE SYSTEM - BIG SPRING DIVISION', '519', 'WEST TEXAS HCS',1009121,1006840, '300 VETERANS BLVD.',NULL,NULL, 'BIG SPRING',1009348,NULL, '79720-5566',1006840, '300 VETERANS BLVD',NULL,NULL, 'BIG SPRING',1009348,NULL, '79720-5566',1009231, '1',1002218,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000124,NULL,NULL, 'BILOXI VA MEDICAL CENTER', '520', 'BILOXI VA MEDICAL CENTER',1009121,1006840, '400 Veterans Ave',NULL,NULL, 'Biloxi',1009328,NULL, '39531-2410',1006840, '400 Veterans Ave',NULL,NULL, 'Biloxi',1009328,NULL, '39531-2410',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000125,NULL,NULL, 'BIRMINGHAM VAMC', '521', 'BIRMINGHAM VAMC',1009121,1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233-1927',1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233-1927',1009231, '1',1002207,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000126,NULL,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BONHAM', '522', 'ZZ BONHAM',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000995,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000127,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - BOSTON DIVISION', '523', 'BOSTON HCS VAMC',1009121,1006840, '150 SOUTH HUNTINGTON AVENUE',NULL,NULL, 'BOSTON',1009325,NULL, '02130-4893',1006840, '150 SOUTH HUNTINGTON AVE',NULL,NULL, 'BOSTON',1009325,NULL, '02130-4893',1009231, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load', 'PARENT ID CLEANUP');
Insert into sdsadm.STD_Institution values(1000128,NULL,TO_DATE('10/16/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZBRECKSVILLE VAMC', '524', 'ZZBRECKSVILLE VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000129,NULL,TO_DATE('7/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROCKTON VAMC', '525', 'ZZ BROCKTON VAMC',1009121,1006840, 'Brockton Division',NULL,NULL, 'BROCKTON',1009325,NULL, '2401',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000780,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000130,NULL,NULL, 'BRONX VA HOSPITAL', '526', 'BRONX VAMC',1009121,1006840, '130 W. KINGSBRIDGE ROAD',NULL,NULL, 'Bronx',1009336,NULL, '10468-3904',1006840, '130 W. KINGSBRIDGE ROAD',NULL,NULL, 'BRONX',1009336,NULL, '10468-3904',1009231, '1',1002203,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000131,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROOKLYN (VAMC)', '527', 'ZZ BROOKLYN (VAMC)',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001528,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000132,NULL,NULL, 'BUFFALO VA MEDICAL CENTER', '528', 'BUFFALO VA MEDICAL CENTER',1009121,1006840, '3495 Bailey Avenue',NULL,NULL, 'BUFFALO',1009336,NULL, '14215-1129',1006840, '3495 Bailey Avenue',NULL,NULL, 'BUFFALO',1009336,NULL, '14215-1129',1009231, '1',1002202,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000133,NULL,NULL, 'BUTLER VA MEDICAL CENTER', '529', 'BUTLER VA MEDICAL CENTER',1009121,1006840, '325 New Castle Road',NULL,NULL, 'Butler',1009342,NULL, '16001-2464',1006840, '325 New Castle Road',NULL,NULL, 'Butler',1009342,NULL, '16001-2464',1009231, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000134,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BRENTWOOD VAMC', '530', 'ZZ BRENTWOOD VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000135,NULL,NULL, 'BOISE VA MEDICAL CENTER', '531', 'BOISE VA MEDICAL CENTER',1009121,1006840, '500 WEST FORT ST.',NULL,NULL, 'BOISE',1009316,NULL, '83702-4501',1006840, '500 W. FORT ST.',NULL,NULL, 'BOISE',1009316,NULL, '83702-4501',1009231, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000136,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CANANDAIGUA', '532', 'ZZ CANANDAIGUA',1009121,1006840, 'Fort Hill Avenue',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000817,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000137,NULL,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CASTLE POINT VAMC', '533', 'ZZ CASTLE POINT VAMC',1009121,1006840,NULL,NULL,NULL, 'CASTLE POINT',1009336,NULL, '12511',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001472,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000138,NULL,NULL, 'RALPH H. JOHNSON VA MEDICAL CENTER (534)', '534', 'CHARLESTON VAMC',1009121,1006840, '109 BEE STREET',NULL,NULL, 'CHARLESTON',1009345,NULL, '29401-5799',1006840, '109 BEE STREET',NULL,NULL, 'CHARLESTON',1009345,NULL, '29401-5799',1009231, '1',1002207,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000139,NULL,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHICAGO LAKESIDE VAMC', '535', 'ZZ CHICAGO LAKESIDE VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000895,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000140,NULL,NULL, 'JESSE BROWN VA MEDICAL CENTER', '537', 'JESSE BROWN VAMC',1009121,1006840, '820 SOUTH DAMEN AVENUE',NULL,NULL, 'CHICAGO',1009317,NULL, '60612-3728',1006840, '820 SOUTH DAMEN AVENUE',NULL,NULL, 'CHICAGO',1009317,NULL, '60612-3728',1009231, '1',1002166,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000141,NULL,NULL, 'CHILLICOTHE VA MEDICAL CENTER', '538', 'CHILLICOTHE VA MEDICAL CENTER',1009121,1006840, '17273 ST. RT. 104',NULL,NULL, 'CHILLICOTHE',1009339,NULL, '45601-8608',1006840, '17273 ST. RT. 104',NULL,NULL, 'CHILLICOTHE',1009339,NULL, '45601-8608',1009231, '1',1002210,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000142,NULL,NULL, 'CINCINNATI VAMC', '539', 'CINCINNATI',1009121,1006840, '3200 VINE STREET',NULL,NULL, 'CINCINNATI',1009339,NULL, '45220-2213',1006840, '3200 VINE STREET',NULL,NULL, 'CINCINNATI',1009339,NULL, '45220-2213',1009231, '1',1002210,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000143,NULL,NULL, 'LOUIS A JOHNSON VAMC', '540', 'LOUIS A JOHNSON VAMC',1009121,1006840, '1 MED CENTER DRIVE',NULL,NULL, 'CLARKSBURG',1009354,NULL, '26301-4155',1006840, '1 MED CENTER DRIVE',NULL,NULL, 'CLARKSBURG',1009354,NULL, '26301-4155',1009231, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000144,NULL,NULL, 'CLEVELAND VAMC', '541', 'CLEVELAND VAMC',1009121,1006840, '10701 EAST BLVD',NULL,NULL, 'CLEVELAND',1009339,NULL, '44106-1702',1006840, '10701 EAST BLVD',NULL,NULL, 'CLEVELAND',1009339,NULL, '44106-1702',1009231, '1',1002210,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000145,NULL,NULL, 'COATESVILLE VA MEDICAL CENTER', '542', 'COATESVILLE VA MEDICAL CENTER',1009121,1006840, '1400 BLACKHORSE HILL ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320-2040',1006840, '1400 BLACKHORSE HILL ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320-2040',1009231, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000148,NULL,NULL, 'BRUCE W. CARTER DEPT OF VAMC', '546', 'BRUCE W. CARTER DEPT OF VAMC',1009121,1006840, '1201 Northwest 16th Street',NULL,NULL, 'MIAMI',1009312,NULL, '33125-1624',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002208,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000149,NULL,NULL, 'WEST PALM BEACH VAMC', '548', 'WEST PALM BEACH VAMC',1009121,1006840, '7305 N. MILITARY TRAIL',NULL,NULL, 'WEST PALM BEACH',1009312,NULL, '33410-7417',1006840, '7305 N. MILITARY TRAIL',NULL,NULL, 'WEST PALM BEACH',1009312,NULL, '33410-7417',1009231, '1',1002208,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000150,NULL,NULL, 'DALLAS VA MEDICAL CENTER', '549', 'DALLAS VA MEDICAL CENTER',1009121,1006840, '4500 SOUTH LANCASTER ROAD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1006840, '4500 SOUTH LANCASTER ROAD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009231, '1',1002217,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000151,NULL,NULL, 'DANVILLE VA MEDICAL CENTER', '550', 'DANVILLE VA MEDICAL CENTER',1009121,1006840, '1900 EAST MAIN STREET',NULL,NULL, 'DANVILLE',1009317,NULL, '61832-5100',1006840, '1900 EAST MAIN STREET',NULL,NULL, 'DANVILLE',1009317,NULL, '61832-5100',1009231, '1',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000153,NULL,NULL, 'JOHN D. DINGELL VAMC', '553', 'JOHN D. DINGELL VAMC',1009121,1006840, '4646 John R',NULL,NULL, 'DETROIT',1009326,NULL, '48201-2720',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000154,NULL,NULL, 'DENVER VA MEDICAL CENTER', '554', 'DENVER VA MEDICAL CENTER',1009121,1006840, '1055 CLERMONT STREET',NULL,NULL, 'DENVER',1009308,NULL, '80220-3808',1006840, '1055 CLERMONT STREET',NULL,NULL, 'DENVER',1009308,NULL, '80220-3808',1009231, '1',1002135,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000155,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA CENTRAL IOWA HEALTH CARE SYSTEM', '555', 'ZZ CENTRAL IOWA HCS',1009121,1006840, '3600 30TH ST.',NULL,NULL, 'DES MOINES',1009319,NULL, '50310',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001598,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000156,NULL,NULL, 'CAPTN JAMES LOVELL FED HLT CTR', '556', 'CAPTN JAMES LOVELL FED HLT CTR',1009121,1006840, '3001 GREEN BAY ROAD',NULL,NULL, 'NORTH CHICAGO',1009317,NULL, '60064-3048',1006840, '3001 GREEN BAY ROAD',NULL,NULL, 'NORTH CHICAGO',1009317,NULL, '60064-3048',1009231, '1',1002212,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000157,NULL,NULL, 'DUBLIN', '557', 'DUBLIN VAMC',1009121,1006840, '1826 VETERANS BLVD',NULL,NULL, 'DUBLIN',1009313,NULL, '31021-3620',1006840, '1826 VETERANS BLVD',NULL,NULL, 'DUBLIN',1009313,NULL, '31021-3620',1009231, '1',1002207,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000158,NULL,NULL, 'DURHAM VA MEDICAL CENTER', '558', 'DURHAM VA MEDICAL CENTER',1009121,1006840, '508 Fulton Street',NULL,NULL, 'DURHAM',1009337,NULL, '27705-3875',1006840, '508 FULTON STREET',NULL,NULL, 'DURHAM',1009337,NULL, '27705-3875',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000159,NULL,NULL, 'NEW JERSEY HEALTH CARE SYSTEM - EAST ORANGE', '561', 'EAST ORANGE-VA NEW JERSEY HCS',1009121,1006840, '385 T-- remONT AVE',NULL,NULL, 'EAST ORANGE',1009334,NULL, '07018-1023',1006840, '385 T-- remONT AVE',NULL,NULL, 'EAST ORANGE',1009334,NULL, '07018-1023',1009231, '1',1002144,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000160,NULL,NULL, 'ERIE VA MEDICAL CENTER', '562', 'ERIE VA MEDICAL CENTER',1009121,1006840, '135 E 38TH STREET',NULL,NULL, 'ERIE',1009342,NULL, '16504-1559',1006840, '135 E 38TH STREET',NULL,NULL, 'ERIE',1009342,NULL, '16504-1559',1009231, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000161,NULL,NULL, 'FAYETTEVILLE VA MEDICAL', '564', 'FAYETTEVILLE VA MEDICAL',1009121,1006840, '1100 N COLLEGE AVE.',NULL,NULL, 'FAYETTEVILLE',1009305,NULL, '72703-1944',1006840, '1100 N COLLEGE AVE.',NULL,NULL, 'FAYETTEVILLE',1009305,NULL, '72703-1944',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000162,NULL,NULL, 'FAYETTEVILLE VA MEDICAL CENTER', '565', 'FAYETTEVILLE VA MEDICAL CENTER',1009121,1006840, '2300 RAMSEY ST',NULL,NULL, 'FAYETTEVILLE',1009337,NULL, '28301-3856',1006840, '2300 RAMSEY ST',NULL,NULL, 'FAYETTEVILLE',1009337,NULL, '28301-3856',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000163,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FORT HOWARD', '566', 'ZZ FORT HOWARD',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000685,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000164,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'SOUTHERN COLORADO HEALTH CARE SYSTEM - FT. LYON', '567', 'ZZ SOUTHERN COLORADO HCS',1009121,1006840,NULL,NULL,NULL, 'FT. LYON',1009308,NULL, '81038',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001038,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000165,NULL,NULL, 'BLACK HILLS HEALTH CARE SYSTEM - FT. MEADE DIVISION', '568', 'BLACK HILLS HCS',1009121,1006840, '113 COMANCHE RD',NULL,NULL, 'FORT MEADE',1009346,NULL, '57741-1002',1006840, 'VA MEDICAL CENTER',NULL,NULL, 'FORT MEADE',1009346,NULL, '57741-1002',1009231, '1',1002223,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000166,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FT WAYNE VAMC', '569', 'ZZ FT WAYNE VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001405,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000167,NULL,NULL, 'FRESNO VA MEDICAL CENTER', '570', 'FRESNO VA MEDICAL CENTER',1009121,1006840, '2615 EAST CLINTON AVE',NULL,NULL, 'FRESNO',1009306,NULL, '93703-2223',NULL, '2615 EAST CLINTON AVE',NULL,NULL, 'FRESNO',1009306,NULL, '93703-2223',1009231, '1',1002221,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000168,NULL,NULL, 'MALCOM RANDALL DEPT OF VAMC', '573', 'MALCOM RANDALL DEPT OF VAMC',1009121,1006840, '1601 S.W. ARCHER ROAD',NULL,NULL, 'GAINESVILLE',1009312,NULL, '32608-1197',1006840, '1601 S.W. ARCHER ROAD',NULL,NULL, 'GAINESVILLE',1009312,NULL, '32608-1197',1009231, '1',1002208,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000169,NULL,TO_DATE('10/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GRAND ISLAND', '574', 'ZZ GRAND ISLAND',1009121,1006840,NULL,NULL,NULL, 'GRAND ISLAND',1009331,NULL, '68801',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001342,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000170,NULL,NULL, 'GRAND JUNCTION VAMC', '575', 'GRAND JUNCTION VAMC',1009121,1006840, '2121 NORTH AVENUE',NULL,NULL, 'GRAND JUNCTION',1009308,NULL, '81501-6428',1006840, '2121 NORTH AVENUE',NULL,NULL, 'GRAND JUNCTION',1009308,NULL, '81501-6428',1009231, '1',1002219,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000172,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ HOT SPRINGS', '579', 'ZZ HOT SPRINGS',1009121,1006840,NULL,NULL,NULL,NULL,1009346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001137,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000173,NULL,NULL, 'MICHAEL E. DEBAKEY VA MEDICAL CENTER', '580', 'HOUSTON VAMC',1009121,1006840, '2002 HOLCOMBE BOULEVARD',NULL,NULL, 'HOUSTON',1009348,NULL, '77030-4211',1006840, '2002 HOLCOMBE BOULEVARD',NULL,NULL, 'HOUSTON',1009348,NULL, '77030-4211',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000174,NULL,NULL, 'HUNTINGTON VAMC', '581', 'HUNTINGTON VAMC',1009121,1006840, '1540 Spring Valley Drive',NULL,NULL, 'Huntington',1009354,NULL, '25704-9300',1006840, '1540 SPRING VALLEY DRIVE',NULL,NULL, 'HUNTINGTON',1009354,NULL, '25704-9300',1009231, '1',1002209,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000175,NULL,NULL, 'RICHARD L. ROUDEBUSH VAMC', '583', 'RICHARD L. ROUDEBUSH VAMC',1009121,1006840, '1481 West 10th Street',NULL,NULL, 'INDIANAPOLIS',1009318,NULL, '46202-2803',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000176,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ IOWA CITY VAMC', '584', 'ZZ IOWA CITY VAMC',1009121,1006840, 'Highway 6 West',NULL,NULL, 'IOWA CITY',1009319,NULL, '52246',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001600,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000177,NULL,NULL, 'IRON MOUNTAIN VA MEDICAL CENTER', '585', 'IRON MOUNTAIN VAMC',1009121,1006840, '325 EAST H STREET',NULL,NULL, 'IRON MOUNTAIN',1009326,NULL, '49801-4760',1006840, '325 EAST H STREET',NULL,NULL, 'IRON MOUNTAIN',1009326,NULL, '49801-4760',1009231, '1',1002212,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000178,NULL,NULL, 'G.V. (SONNY) MONTGOMERY', '586', 'JACKSON VAMC',1009121,1006840, '1500 E. WOODROW WILSON',NULL,NULL, 'JACKSON',1009328,NULL, '39216-5116',1006840, '1500 E. WOODROW WILSON',NULL,NULL, 'JACKSON',1009328,NULL, '39216-5116',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000179,NULL,NULL, 'JEFFERSON BARRACKS-RO', '587', 'JEFFERSON BARRACKS-RO',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009209, '0',1002215,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1000181,NULL,NULL, 'HAMPTON VA MEDICAL CENTER', '590', 'HAMPTON VA MEDICAL CENTER',1009121,1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667-0001',1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667-0001',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000182,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ KERRVILLE VAMC', '591', 'ZZ KERRVILLE VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001871,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000183,NULL,TO_DATE('10/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-KNOXVILLE VAMC', '592', 'ZZ-KNOXVILLE VAMC',1009121,1006840, '1515 West Pleasant Street',NULL,NULL, 'KNOXVILLE',1009319,NULL, '50138',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001062,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1000184,NULL,NULL, 'SOUTHERN NEVADA HCS', '593', 'SOUTHERN NEVADA HCS',1009121,1006840, '6900 NORTH PECOS ROAD',NULL,NULL, 'LAS VEGAS',1009332,NULL, '89086-4400',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000185,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LAKE CITY VAMC', '594', 'ZZ LAKE CITY VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001165,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000186,NULL,NULL, 'LEBANON VA MEDICAL CENTER', '595', 'LEBANON VA MEDICAL CENTER',1009121,1006840, '1700 SOUTH LINCOLN AVE.',NULL,NULL, 'LEBANON',1009342,NULL, '17042-7529',1006840, '1700 SOUTH LINCOLN AVE',NULL,NULL, 'LEBANON',1009342,NULL, '17042-7529',1009231, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000187,NULL,NULL, 'LEXINGTON VAMC-LEESTOWN', '596', 'LEXINGTON VAMC-LEESTOWN',1009121,1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40511-1052',1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40511-1052',1009231, '1',1002209,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000188,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA GREATER NEBRASKA HEALTHCARE SYSTEM - LINCOLN DIVISION', '597', 'ZZ GREATER NEBRASKA HCS',1009121,1006840, '600 South 70th Street',NULL,NULL, 'LINCOLN',1009331,NULL, '68510',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001597,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000189,NULL,NULL, 'CENTRAL ARKANSAS HEALTH CARE SYSTEM - LITTLE ROCK', '598', 'CENTRAL ARKANSAS HCS',1009121,1006840, '4300 WEST 7TH',NULL,NULL, 'LITTLE ROCK',1009305,NULL, '72205-5446',1006840, '4300 WEST 7TH',NULL,NULL, 'LITTLE ROCK',1009305,NULL, '72205-5446',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000190,NULL,TO_DATE('5/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LIVERMORE VAMC', '599', 'ZZ LIVERMORE VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001630,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000191,NULL,NULL, 'VA LONG BEACH HEALTHCARE SYSTEM', '600', 'LONG BEACH VAMC',1009121,1006840, '5901 EAST 7TH ST',NULL,NULL, 'LONG BEACH',1009306,NULL, '90822-5201',1006840, '5901 East 7th St',NULL,NULL, 'Long Beach',1009306,NULL, '90822-5201',1009231, '1',1002222,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000192,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WADSWORTH VAMC', '601', 'ZZ WADSWORTH VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000193,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LOS ANGELES VAMC', '602', 'ZZ LOS ANGELES VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000194,NULL,NULL, 'ROBLEY REX VAMC', '603', 'ROBLEY REX VAMC',1009121,1006840, '800 ZORN AVE',NULL,NULL, 'LOUISVILLE',1009321,NULL, '40206-1433',1006840, '800 ZORN AVE',NULL,NULL, 'LOUISVILLE',1009321,NULL, '40206-1433',1009231, '1',1002209,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000195,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LYONS VAMC', '604', 'ZZ LYONS VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001094,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000196,NULL,NULL, 'LOMA LINDA HCS', '605', 'LOMA LINDA HCS',1009121,1006840, '11201 BENTON ST',NULL,NULL, 'LOMA LINDA',1009306,NULL, '92357-1000',1006840, '11201 BENTON ST',NULL,NULL, 'LOMA LINDA',1009306,NULL, '92357-1000',1009231, '1',1002222,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000197,NULL,NULL, 'WILLIAM S. MIDDLETON MEMORIAL VA HOSPITAL', '607', 'WILLIAM S. MIDDLETON VAMC',1009121,1006840, '2500 OVERLOOK TERR',NULL,NULL, 'MADISON',1009355,NULL, '53705-2254',1006840, '2500 OVERLOOK TERR',NULL,NULL, 'MADISON',1009355,NULL, '53705-2254',1009231, '1',1002212,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000198,NULL,NULL, 'MANCHESTER VAMC', '608', 'MANCHESTER VAMC',1009121,1006840, '718 SMYTH ROAD',NULL,NULL, 'MANCHESTER',1009333,NULL, '03104-7004',1006840, '718 SMYTH ROAD',NULL,NULL, 'MANCHESTER',1009333,NULL, '03104-7004',1009231, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000199,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARION VAMC', '609', 'ZZ MARION VAMC',1009121,1006840, '2401 West Main Street',NULL,NULL, 'MARION',1009317,NULL, '62959',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001733,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000200,NULL,NULL, 'MARION VA MEDICAL CENTER', '610', 'MARION VA MEDICAL CENTER',1009121,1006840, '1700 EAST 38TH STREET',NULL,NULL, 'MARION',1009318,NULL, '46953-4568',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000201,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARLIN VAMC', '611', 'ZZ MARLIN VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001916,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000202,NULL,NULL, 'NORTHERN CALIFORNIA HCS', '612', 'NORTHERN CALIFORNIA HCS',1009121,1006840, '150 Muir Road',NULL,NULL, 'MARTINEZ',1009306,NULL, '94553-4668',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002221,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000203,NULL,NULL, 'MARTINSBURG VA MEDICAL CENTER', '613', 'MARTINSBURG VA MEDICAL CENTER',1009121,1006840, '510 BUTLER AVENUE',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25405-9990',1006840, '510 BUTLER AVENUE',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25405-9990',1009231, '1',1002205,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000204,NULL,NULL, 'MEMPHIS VA MEDICAL CENTER', '614', 'MEMPHIS VA MEDICAL CENTER',1009121,1006840, '1030 JEFFERSON AVENUE',NULL,NULL, 'MEMPHIS',1009347,NULL, '38104-2127',1006840, '1030 JEFFERSON AVENUE',NULL,NULL, 'MEMPHIS',1009347,NULL, '38104-2127',1009231, '1',1002209,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000205,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MIAMI VAMC', '616', 'ZZ MIAMI VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000206,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MILES CITY VAMC', '617', 'ZZ MILES CITY VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000525,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000207,NULL,NULL, 'MINNEAPOLIS VA HCS', '618', 'MINNEAPOLIS VA HCS',1009121,1006840, 'ONE VETERANS DRIVE',NULL,NULL, 'MINNEAPOLIS',1009327,NULL, '55417-2309',1006840, 'ONE VETERANS DRIVE',NULL,NULL, 'MINNEAPOLIS',1009327,NULL, '55417-2309',1009231, '1',1002223,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000208,NULL,NULL, 'CENTRAL ALABAMA HEALTH CARE SYSTEM - MONTGOMERY DIVISION', '619', 'CENTRAL ALABAMA HCS',1009121,1006840, '215 PERRY HILL ROAD',NULL,NULL, 'MONTGOMERY',1009301,NULL, '36109-3725',1006840, '215 PERRY HILL ROAD',NULL,NULL, 'MONTGOMERY',1009301,NULL, '36109-3725',1009231, '1',1002207,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000209,NULL,NULL, 'VA HUDSON VALLEY HEALTH CARE SYSTEM - MONTROSE DIVISION', '620', 'HUDSON VALLEY HCS VAMC',1009121,1006840, '2094 Albany Post Road',NULL,NULL, 'MONTROSE',1009336,NULL, '10548-1454',1006840, '2094 Albany Post Road',NULL,NULL, 'Montrose',1009336,NULL, '10548-1454',1009231, '1',1002203,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000210,NULL,NULL, 'JAMES H. QUILLEN VAMC', '621', 'JAMES H. QUILLEN VAMC',1009121,1006840, 'SIDNEY    LAMONT ST',NULL,NULL, 'MOUNTAIN HOME',1009347,NULL, '37684-4000',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002209,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000211,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MURFREESBORO VAMC', '622', 'ZZ MURFREESBORO VAMC',1009121,1006840, 'ALVIN C. YORK VA MEDICAL CENTER',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37130',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001503,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000213,NULL,NULL, 'NASHVILLE VA MEDICAL CENTER', '626', 'NASHVILLE VA MEDICAL CENTER',1009121,1006840, '1310 24TH AVE SOUTH',NULL,NULL, 'NASHVILLE',1009347,NULL, '37212-2637',1006840, '1310 24th AVE SOUTH',NULL,NULL, 'NASHVILLE',1009347,NULL, '37212-2637',1009231, '1',1002209,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000214,NULL,TO_DATE('7/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NEWINGTON VAMC', '627', 'ZZ NEWINGTON VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1002015,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000215,NULL,NULL, 'SE LOUISIANA VETERANS HCS', '629', 'SE LOUISIANA VETERANS HCS',1009121,1006840, '1601 PERDIDO ST',NULL,NULL, 'NEW ORLEANS',1009322,NULL, '70112-1262',1006840, '1601 PERDIDO ST',NULL,NULL, 'NEW ORLEANS',1009322,NULL, '70112-1262',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000216,NULL,NULL, 'VA NEW YORK HARBOR HEALTHCARE SYSTEM - NEW YORK DIVISION', '630', 'NEW YORK HHS',1009121,1006840, '423 EAST 23RD STREET',NULL,NULL, 'NEW YORK',1009336,NULL, '10010-5011',1006840, '423 EAST 23RD STREET',NULL,NULL, 'NEW YORK',1009336,NULL, '10010-5011',1009231, '1',1002203,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000217,NULL,NULL, 'VA CNTRL WSTRN MASSCHUSETS HCS', '631', 'VA CNTRL WSTRN MASSCHUSETS HCS',1009121,1006840, '421 NORTH MAIN STREET',NULL,NULL, 'LEEDS',1009325,NULL, '01053-9764',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:07:11 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 07/21/2011 changes');
Insert into sdsadm.STD_Institution values(1000218,NULL,NULL, 'NORTHPORT VAMC NY', '632', 'NORTHPORT VAMC',1009121,1006840, '79 MIDDLEVILLE ROAD',NULL,NULL, 'NORTHPORT',1009336,NULL, '11768-2200',1006840, '79 MIDDLEVILLE ROAD',NULL,NULL, 'NORTHPORT',1009336,NULL, '11768-2200',1009231, '1',1002203,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000219,NULL,NULL, 'OKLAHOMA CITY VA MEDICAL CENTER', '635', 'OKLAHOMA CITY VAMC',1009121,1006840, '921 N.E. 13TH ST',NULL,NULL, 'OKLAHOMA CITY',1009340,NULL, '73104-5007',1006840, '921 N.E. 13TH ST',NULL,NULL, 'OKLAHOMA CITY',1009340,NULL, '73104-5007',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000221,NULL,NULL, 'CHARLES GEORGE VAMC', '637', 'CHARLES GEORGE VAMC',1009121,1006840, '1100 TUNNEL ROAD',NULL,NULL, 'ASHEVILLE',1009337,NULL, '28805-2043',1006840, '1100 TUNNEL ROAD',NULL,NULL, 'ASHEVILLE',1009337,NULL, '28805-2043',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000222,NULL,NULL, 'PALO ALTO VA MEDICAL CENTER', '640', 'PALO ALTO VA MEDICAL CENTER',1009121,1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',1009231, '1',1002221,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000223,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PERRY POINT', '641', 'ZZ PERRY POINT',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000686,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000225,NULL,NULL, 'PHOENIX VAMC', '644', 'PHOENIX VAMC',1009121,1006840, '650 EAST INDIAN SCHOOL ROAD',NULL,NULL, 'PHOENIX',1009304,NULL, '85012-1839',1006840, '650 EAST INDIAN SCHOOL ROAD',NULL,NULL, 'PHOENIX',1009304,NULL, '85012-1839',1009231, '1',1002218,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000226,NULL,TO_DATE('10/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PITTSBURGH HIGHLAND', '645', 'ZZ PITTSBURGH HIGHLAND',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001664,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000227,NULL,NULL, 'PITTSBURGH VAMC UNIVERSITY DR.', '646', 'PITTSBURGH VAMC UNIVERSITY DR.',1009121,1006840, 'UNIVERSITY DRIVE C',NULL,NULL, 'PITTSBURGH',1009342,NULL, '15240-1000',1006840, 'UNIVERSITY DRIVE C',NULL,NULL, 'PITTSBURGH',1009342,NULL, '15240-1000',1009231, '1',1002150,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000228,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'JOHN J. PERSHING', '647', 'ZZ POPLAR BLUFF VAMC',1009121,1006840, '1500 N. Westwood',NULL,NULL, 'POPLAR BLUFF',1009329,NULL, '63901',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001732,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000229,NULL,NULL, 'PORTLAND VA MEDICAL CENTER', '648', 'PORTLAND VA MEDICAL CENTER',1009121,1006840, '3710 SW US VETERANS HOSPTL RD',NULL,NULL, 'PORTLAND',1009341,NULL, '97239-2964',1006840, '3710 SW US VETERANS HOSPTL RD',NULL,NULL, 'PORTLAND',1009341,NULL, '97239-2964',1009231, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000230,NULL,NULL, 'NORTHERN ARIZONA HEALTH CARE SYSTEM - PRESCOTT DIVISION', '649', 'NORTHERN ARIZONA HCS',1009121,1006840, '500 N. HWY 89',NULL,NULL, 'PRESCOTT',1009304,NULL, '86313-5001',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002218,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000231,NULL,NULL, 'PROVIDENCE VAMC', '650', 'PROVIDENCE VAMC',1009121,1006840, '830 CHALKSTONE AVE.',NULL,NULL, 'PROVIDENCE',1009344,NULL, '02908-4734',1006840, '830 CHALKSTONE AVE.',NULL,NULL, 'PROVIDENCE',1009344,NULL, '02908-4734',1009231, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000232,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ RICHMOND - OLD BLDG', '651', 'ZZ RICHMOND - OLD BLDG',1009121,1006840,NULL,NULL,NULL,NULL,1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000233,NULL,NULL, 'HUNTER HOLMES MCGUIRE HOSPITAL', '652', 'HUNTER HOLMES MCGUIRE HOSPITAL',1009121,1006840, '1201 BROAD ROCK BLVD.',NULL,NULL, 'RICHMOND',1009351,NULL, '23249-0001',1006840, '1201 BROAD ROCK BLVD',NULL,NULL, 'RICHMOND',1009351,NULL, '23249-0001',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000234,NULL,NULL, 'ROSEBURG VA MEDICAL CENTER', '653', 'ROSEBURG VA MEDICAL CENTER',1009121,1006840, '913 NW GARDEN VALLEY BLVD.',NULL,NULL, 'ROSEBURG',1009341,NULL, '97471-6523',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000235,NULL,NULL, 'IOANNIS A. LOUGARIS VAMC', '654', 'IOANNIS A. LOUGARIS VAMC',1009121,1006840, '975 KIRMAN AVE',NULL,NULL, 'RENO',1009332,NULL, '89502-0993',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002221,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000236,NULL,NULL, 'ALEDA E. LUTZ VAMC', '655', 'ALEDA E. LUTZ VAMC',1009121,1006840, '1500 WEISS ST',NULL,NULL, 'SAGINAW',1009326,NULL, '48602-5251',1006840, '1500 WEISS ST',NULL,NULL, 'SAGINAW',1009326,NULL, '48602-5251',1009231, '1',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000237,NULL,NULL, 'ST. CLOUD VA HEALTH CARE SYSTEM', '656', 'ST. CLOUD VA HCS',1009121,1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303-2015',1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303-2015',1009231, '1',1002223,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000239,NULL,NULL, 'SALEM VA MEDICAL CENTER', '658', 'SALEM VA MEDICAL CENTER',1009121,1006840, '1970 ROANOKE BOULEVARD',NULL,NULL, 'SALEM',1009351,NULL, '24153-6404',1006840, '1970 ROANOKE BLVD.',NULL,NULL, 'SALEM',1009351,NULL, '24153-6404',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000240,NULL,NULL, 'W.G. HEFNER SALISBURY VAMC', '659', 'W.G. HEFNER SALISBURY VAMC',1009121,1006840, '1601 BRENNER AVE.',NULL,NULL, 'SALISBURY',1009337,NULL, '28144-2515',1006840, '1601 BRENNER AVE',NULL,NULL, 'SALISBURY',1009337,NULL, '28144-2515',1009231, '1',1002206,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000241,NULL,NULL, 'GEORGE E. WAHLEN VAMC', '660', 'GEORGE E. WAHLEN VAMC',1009121,1006840, '500 FOOTHILL BLVD.',NULL,NULL, 'SALT LAKE CITY',1009349,NULL, '84148-0001',1006840, '500 FOOTHILL BLVD.',NULL,NULL, 'SALT LAKE CITY',1009349,NULL, '84148-0001',1009231, '1',1002219,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000242,NULL,NULL, 'SAN FRANCISCO VAMC', '662', 'SAN FRANCISCO VAMC',1009121,1006840, '4150 CLEMENT STREET',NULL,NULL, 'SAN FRANCISCO',1009306,NULL, '94121-1545',1006840, '4150 CLEMENT STREET',NULL,NULL, 'SAN FRANCISCO',1009306,NULL, '94121-1545',1009231, '1',1002221,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000243,NULL,NULL, 'SEATTLE VA MEDICAL CENTER', '663', 'SEATTLE VA MEDICAL CENTER',1009121,1006840, '1660 SOUTH COLUMBIAN WAY',NULL,NULL, 'SEATTLE',1009353,NULL, '98108-1532',1006840, '1660 S. Columbian Way',NULL,NULL, 'Seattle',1009353,NULL, '98108-1532',1009231, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000244,NULL,NULL, 'VA SAN DIEGO HEALTHCARE SYSTEM (664)', '664', 'SAN DIEGO HCS',1009121,1006840, '3350 La Jolla Village Drive',NULL,NULL, 'San Diego',1009306,NULL, '92161-0002',1006840, '3350 La Jolla Village Drive',NULL,NULL, 'San Diego',1009306,NULL, '92161-0002',1009231, '1',1002222,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000245,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SEPULVEDA DIVISION', '665', 'ZZ SEPULVEDA',1009121,1006840, '16111 PLUMMER STREET',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,1000298,1002030,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000246,NULL,NULL, 'SHERIDAN VA MEDICAL CENTER', '666', 'SHERIDAN VA MEDICAL CENTER',1009121,1006840, '1898 FORT ROAD',NULL,NULL, 'SHERIDAN',1009356,NULL, '82801-8320',1006840, '1898 FORT ROAD',NULL,NULL, 'SHERIDAN',1009356,NULL, '82801-8320',1009231, '1',1002219,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000247,NULL,NULL, 'OVERTON BROOKS VA MEDICAL CENTER', '667', 'SHREVEPORT VAMC',1009121,1006840, '510 EAST STONER AVENUE',NULL,NULL, 'SHREVEPORT',1009322,NULL, '71101-4243',1006840, '510 E. STONER AVE.',NULL,NULL, 'SHREVEPORT',1009322,NULL, '71101-4243',1009231, '1',1002216,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000248,NULL,NULL, 'MANN-GRANDSTAFF VAMC', '668', 'MANN-GRANDSTAFF VAMC',1009121,1006840, '4815 N. ASSEMBLY',NULL,NULL, 'SPOKANE',1009353,NULL, '99205-6185',1006840, '4815 N. ASSEMBLY',NULL,NULL, 'SPOKANE',1009353,NULL, '99205-6185',1009231, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000249,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SYRACUSE', '670', 'ZZ SYRACUSE',1009121,1006840, '800 Irving Avenue and University Place',NULL,NULL, 'SYRACUSE',1009336,NULL, '13210',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000819,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000250,NULL,NULL, 'AUDIE L. MURPHY MEMORIAL HOSP', '671', 'AUDIE L. MURPHY MEMORIAL HOSP',1009121,1006840, '7400 MERTON MINTER BLVD',NULL,NULL, 'SAN ANTONIO',1009348,NULL, '78229-4404',1006840, '7400 MERTON MINTER BLVD',NULL,NULL, 'SAN ANTONIO',1009348,NULL, '78229-4404',1009231, '1',1002217,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000251,NULL,NULL, 'SAN JUAN VA MEDICAL CENTER', '672', 'SAN JUAN VA MEDICAL CENTER',1009121,1006840, '10 Casia St.',NULL,NULL, 'SAN JUAN',1009372,NULL, '00921-3200',1006840, '10 Casia St.',NULL,NULL, 'SAN JUAN',1009372,NULL, '00921-3200',1009231, '1',1002208,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000252,NULL,NULL, 'JAMES A. HALEY VETERANS HOSP', '673', 'JAMES A. HALEY VETERANS HOSP',1009121,1006840, '13000 BRUCE B DOWNS BLVD',NULL,NULL, 'TAMPA',1009312,NULL, '33612-4745',1006840, '13000 BRUCE B DOWNS BLVD',NULL,NULL, 'TAMPA',1009312,NULL, '33612-4745',1009231, '1',1002208,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000253,NULL,NULL, 'OLIN E. TEAGUE VET CENTER', '674', 'OLIN E. TEAGUE VET CENTER',1009121,1006840, '1901 VETERANS MEMORIAL DRIVE',NULL,NULL, 'TEMPLE',1009348,NULL, '76504-7451',1006840, '1901 VETERANS MEMORIAL DRIVE',NULL,NULL, 'TEMPLE',1009348,NULL, '76504-7451',1009231, '1',1002217,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000254,NULL,NULL, 'TOMAH VAMC', '676', 'TOMAH VAMC',1009121,1006840, '500 E. VETERANS ST.',NULL,NULL, 'TOMAH',1009355,NULL, '54660-3105',1006840, '500 E. VETERANS ST.',NULL,NULL, 'TOMAH',1009355,NULL, '54660-3105',1009231, '1',1002212,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000256,NULL,NULL, 'SOUTHERN ARIZONA HEALTH CARE SYSTEM - TUCSON DIVISION', '678', 'SOUTHERN ARIZONA VA HCS',1009121,1006840, '3601 SOUTH 6TH AVE',NULL,NULL, 'TUCSON',1009304,NULL, '85723-0001',1006840, '3601 SOUTH 6TH AVE',NULL,NULL, 'TUCSON',1009304,NULL, '85723-0001',1009231, '1',1002218,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000257,NULL,NULL, 'TUSCALOOSA VA MEDICAL CENTER', '679', 'TUSCALOOSA',1009121,1006840, '3701 LOOP ROAD EAST',NULL,NULL, 'TUSCALOOSA',1009301,NULL, '35404-5015',1006840, '3701 LOOP ROAD EAST',NULL,NULL, 'TUSCALOOSA',1009301,NULL, '35404-5015',1009231, '1',1002207,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000258,NULL,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TUSKEGEE', '680', 'ZZ TUSKEGEE',1009121,1006840,NULL,NULL,NULL,NULL,1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001461,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000259,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ VANCOUVER VAMC', '683', 'ZZ VANCOUVER VAMC',1009121,1006840, 'Vancouver Division',NULL,NULL, 'PORTLAND',1009353,NULL, '97207',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000260,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WACO VAMC', '685', 'ZZ WACO VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001915,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000261,NULL,TO_DATE('1/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LEAVENWORTH VAMC', '686', 'ZZ LEAVENWORTH VAMC',1009121,1006840,NULL,NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001939,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000262,NULL,NULL, 'JONATHAN M. WAINWRIGHT VAMC', '687', 'JONATHAN M. WAINWRIGHT VAMC',1009121,1006840, '77 WAINWRIGHT DRIVE',NULL,NULL, 'WALLA WALLA',1009353,NULL, '99362-3975',1006840, '77 WAINWRIGHT DRIVE',NULL,NULL, 'WALLA WALLA',1009353,NULL, '99362-3975',1009231, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000263,NULL,NULL, 'WASHINGTON VA MEDICAL CENTER', '688', 'WASHINGTON VA MEDICAL CENTER',1009121,1006840, '50 IRVING ST NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422-0001',1006840, '50 IRVING ST NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422-0001',1009231, '1',1002205,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000264,NULL,NULL, 'VA CONNECTICUT HEALTHCARE SYSTEM - WEST HAVEN DIVISION', '689', 'CONNECTICUT HCS',1009121,1006840, '950 CAMPBELL AVENUE',NULL,NULL, 'WEST HAVEN',1009309,NULL, '06516-2770',1006840, '950 CAMPBELL AVENUE',NULL,NULL, 'WEST HAVEN',1009309,NULL, '06516-2770',1009231, '1',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:15:45 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0833 1/14/2013');
Insert into sdsadm.STD_Institution values(1000265,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WEST ROXBURY', '690', 'ZZ WEST ROXBURY',1009121,1006840,NULL,NULL,NULL, 'WEST ROXBURY',1009325,NULL, '2132',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000266,NULL,NULL, 'VA GREATER LOS ANGELES HEALTHCARE SYSTEM - WEST LOS ANGELES DIVISION', '691', 'WEST LA VAMC',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073-1003',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073-1003',1009231, '1',1002222,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000267,NULL,NULL, 'WHITE CITY VA MEDICAL CENTER', '692', 'WHITE CITY VA MEDICAL CENTER',1009121,1006840, '8495 Crater Lake Hwy.',NULL,NULL, 'WHITE CITY',1009341,NULL, '97503-3011',1006840, '8495 Crater Lake Hwy.',NULL,NULL, 'WHITE CITY',1009341,NULL, '97503-3011',1009231, '1',1002220,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000268,NULL,NULL, 'WILKES-BARRE VAMC', '693', 'WILKES-BARRE VAMC',1009121,1006840, '1111 EAST END BLVD',NULL,NULL, 'WILKES BARRE',1009342,NULL, '18711-0030',1006840, '1111 EAST END BLVD',NULL,NULL, 'WILKES BARRE',1009342,NULL, '18711-0030',1009231, '1',1002204,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000269,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WILMINGTON VAMC', '694', 'ZZ WILMINGTON VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000270,NULL,NULL, 'CLEMENT J ZABLOCKI', '695', 'MILWAUKEE VAMC',1009121,1006840, '5000 W NATIONAL AVE',NULL,NULL, 'MILWAUKEE',1009355,NULL, '53295-0001',1006840, '5000 W NATIONAL AVE',NULL,NULL, 'MILWAUKEE',1009355,NULL, '53295-0001',1009231, '1',1002212,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000271,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ INACTIVE HONOLULU', '696', 'ZZ INACTIVE HONOLULU',1009121,1006840,NULL,NULL,NULL,NULL,1009315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000272,NULL,NULL, 'EMPLOYEE EDUCATION CENTER', '697', 'EMPLOYEE EDUCATION CENTER',1009121,1006840,NULL,NULL,NULL,NULL,1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009163, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000273,NULL,NULL, 'HEALTH RESOURCE CENTER', '702', 'HEALTH RESOURCE CENTER',1009121,NULL, '3401 SOUTH WEST 21ST STREET',NULL,NULL, 'TOPEKA',1009320,NULL, '66604',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:44:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 04/23/2009 changes');
Insert into sdsadm.STD_Institution values(1000274,NULL,NULL, 'OFFICE OF RESOLUTION MGMT', '705', 'OFFICE OF RESOLUTION MGMT',1009121,1006840,NULL,NULL,NULL,NULL,1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000275,NULL,NULL, 'HARTFORD OIG', '710', 'HARTFORD OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000276,NULL,NULL, 'KANSAS CITY OIG', '711', 'KANSAS CITY OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000277,NULL,NULL, 'ATLANTA (OIG/ROA)', '712', 'ATLANTA (OIG/ROA)',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000278,NULL,NULL, 'CHICAGO OIG', '713', 'CHICAGO OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000279,NULL,NULL, 'WESTERN FIELD OFFICE OIG', '714', 'WESTERN FIELD OFFICE OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000280,NULL,NULL, 'WASHINGTON OIG', '715', 'WASHINGTON OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000281,NULL,NULL, 'NEW YORK OIG', '716', 'NEW YORK OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000282,NULL,NULL, 'ATLANTA (OIG/ROI)', '717', 'ATLANTA (OIG/ROI)',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000284,NULL,NULL, 'LOS ANGELES OIG', '719', 'LOS ANGELES OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000286,NULL,NULL, 'ALBUQUERQUE U.S. AIR FORCE', '721', 'ALBUQUERQUE U.S. AIR FORCE',1009122,1006840,NULL,NULL,NULL,NULL,1009335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000287,NULL,NULL, 'ALBUQUERQUE CHAMPUS', '722', 'ALBUQUERQUE CHAMPUS',1009121,1006840,NULL,NULL,NULL,NULL,1009335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000288,NULL,NULL, 'ALBUQUERQUE (IHS)', '723', 'ALBUQUERQUE (IHS)',1009121,1006840,NULL,NULL,NULL,NULL,1009335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009170, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000289,NULL,NULL, 'ALBUQUERQUE CHAMPVA', '724', 'ALBUQUERQUE CHAMPVA',1009121,1006840,NULL,NULL,NULL,NULL,1009335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000290,NULL,NULL, 'ST. LOUIS (725)', '725', 'ST. LOUIS (725)',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000291,NULL,NULL, 'CHICAGO (726)', '726', 'CHICAGO (726)',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000292,NULL,NULL, 'ST. LOUIS (727)', '727', 'ST. LOUIS (727)',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000293,NULL,NULL, 'HEALTH ADMINISTRATION CENTER', '741', 'HEALTH ADMINISTRATION CENTER',1009121,1006840, '3773 CHERRY CREEK NORTH DRIVE',NULL,NULL, 'DENVER',1009308,NULL, '80209',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',1000293,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('4/30/2014 9:48:39 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0897 03/03/2014');
Insert into sdsadm.STD_Institution values(1000294,NULL,NULL, 'HEALTH ELIGIBILITY CENTER', '742', 'HEALTH ELIGIBILITY CENTER',1009121,1006840, '1644 Tullie Circle',NULL,NULL, 'Atlanta',1009313,NULL, '30329-2323',1006840, '1644 Tullie Circle',NULL,NULL, 'Atlanta',1009313,NULL, '30329-2323',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000295,NULL,NULL, 'PERRY POINT', '743', 'PERRY POINT',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009152, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000296,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BOSTON', '750', 'ZZ BOSTON',1009121,1006840, '251 Causeway Street',NULL,NULL, 'BOSTON',1009325,NULL, '2114',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000297,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROOKLYN (OC)', '751', 'ZZ BROOKLYN (OC)',1009121,1006840,NULL,NULL,NULL, 'BROOKLYN',1009336,NULL, '11209',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000298,NULL,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LOS ANGELES OC', '752', 'ZZ LOS ANGELES OC',1009121,1006840, '351 E. Temple Street',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90012-3328',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1000245,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000299,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LUBBOCK OC', '753', 'ZZ LUBBOCK OC',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000300,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PHILADELPHIA (OC)', '754', 'ZZ PHILADELPHIA (OC)',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000301,NULL,NULL, 'SAN ANTONIO OPC', '755', 'SAN ANTONIO OPC',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1002217,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1000302,NULL,NULL, 'EL PASO HCS', '756', 'EL PASO VA HCS',1009121,1006840, '5001 N PIEDRAS ST',NULL,NULL, 'EL PASO',1009348,NULL, '79930-4211',1006840, '5001 N PIEDRAS ST',NULL,NULL, 'EL PASO',1009348,NULL, '79930-4211',1009189, '1',1002218,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load', 'PARENT ID CLEANUP');
Insert into sdsadm.STD_Institution values(1000303,NULL,NULL, 'CHALMERS P. WYLIE VA AMBULATORY CARE CENTER (757)', '757', 'COLUMBUS VAMC',1009121,1006840, '420 NORTH JAMES ROAD',NULL,NULL, 'COLUMBUS',1009339,NULL, '43219-1834',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '1',1002210,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000304,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LAS VEGAS OC', '758', 'ZZ LAS VEGAS OC',1009121,1006840,NULL,NULL,NULL,NULL,1009332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000305,NULL,NULL, 'LEAVENWORTH CMOP', '760', 'LEAVENWORTH CMOP',1009121,1006840, '5000 SOUTH 13TH ST.',NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048-5581',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009155, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000306,NULL,NULL, 'CHELMSFORD CMOP', '761', 'CHELMSFORD CMOP',1009121,1006840, '200 SPRINGS RD',NULL,NULL, 'BEDFORD',1009325,NULL, '01730-3610',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009155, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000307,NULL,NULL, 'TUCSON CMOP', '762', 'TUCSON CMOP',1009121,1006840, '3675 EAST BRITANNIA DRIVE',NULL,NULL, 'TUCSON',1009304,NULL, '85706-5041',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009155, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000308,NULL,NULL, 'LANCASTER CMOP', '763', 'LANCASTER CMOP',1009121,1006840, '2962 S. LONGHORN',NULL,NULL, 'LANCASTER',1009348,NULL, '75134-2118',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009155, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000309,NULL,NULL, 'MID-SOUTH CMOP', '764', 'MURFREESBORO CMOP',1009121,1006840, '5171 SAM JARED DRIVE',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37130-1382',1006840, '5171 SAM JARED DRIVE',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37130-1382',1009155, '0',1002223,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000311,NULL,NULL, 'CHARLESTON CMOP', '766', 'CHARLESTON CMOP',1009121,1006840, '3725 RIVERS AVE.',NULL,NULL, 'NORTH CHARLESTON',1009345,NULL, '29405-7038',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009155, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000312,NULL,NULL, 'INDIANAPOLIS CEMETERY', '774', 'INDIANAPOLIS CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000313,NULL,NULL, 'OAKLAND CEMETERY', '775', 'OAKLAND CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000314,NULL,NULL, 'OFFICE OF INFORMATION SERVICE CENTER', '776', 'OFFICE OF INFORMATION SRV CNTR',1009121,1006840, 'LOUIS STOKES CLEVELAND VA MEDICAL CENTER',NULL,NULL, 'BRECKSVILLE',1009339,NULL, '44141',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',1000314,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:41:00 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 06/30/06 changes');
Insert into sdsadm.STD_Institution values(1000315,NULL,NULL, 'CLEVELAND EES', '777', 'CLEVELAND EES',1009121,1006840,NULL,NULL,NULL,NULL,1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009163, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000316,NULL,NULL, 'DENVER VCS', '778', 'DENVER VCS',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009243, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000317,NULL,NULL, 'WASHINGTON VCS', '779', 'WASHINGTON VCS',1009121,1006840,NULL,NULL,NULL,NULL,1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009243, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000318,NULL,NULL, 'ATLANTA (VCSFO)', '780', 'ATLANTA (VCSFO)',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009243, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000319,NULL,NULL, 'SOMERVILLE VCS', '781', 'SOMERVILLE VCS',1009121,1006840,NULL,NULL,NULL,NULL,1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009243, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000320,NULL,NULL, 'SAN FRANCISCO VCS', '782', 'SAN FRANCISCO VCS',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009243, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000321,NULL,NULL, 'ST. LOUIS VCS', '783', 'ST. LOUIS VCS',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009243, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000324,NULL,NULL, 'TRIANGLE CEMETERY', '786', 'TRIANGLE CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000325,NULL,NULL, 'PHILADELPHIA MEM SRV NETWORK', '787', 'PHILADELPHIA MEM SRV NETWORK',1009121,1006840,NULL,NULL,NULL, 'PHILADELPHIA',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000326,NULL,NULL, 'ATLANTA MEMORIAL SRVC NETWORK', '788', 'ATLANTA MEMORIAL SRVC NETWORK',1009121,1006840,NULL,NULL,NULL, 'ATLANTA',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000327,NULL,NULL, 'DENVER CEMETERY', '789', 'DENVER CEMETERY',1009121,1006840,NULL,NULL,NULL, 'DENVER',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000328,NULL,NULL, 'ZZ NEW YORK (790)', '790', 'ZZ NEW YORK (790)',1009121,1006840,NULL,NULL,NULL, 'NEW YORK',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:38:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 12/15/05 changes');
Insert into sdsadm.STD_Institution values(1000329,NULL,NULL, 'DENVER (DDC)', '791', 'DENVER (DDC)',1009121,1006840,NULL,NULL,NULL, 'DENVER',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000330,NULL,NULL, 'WASHINGTON PDC', '792', 'WASHINGTON PDC',1009121,1006840, '103 South Gay Street',NULL,NULL, 'BALTIMORE',1009311,NULL, '21202',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009200, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000332,NULL,NULL, 'SOMERVILLE (794)', '794', 'SOMERVILLE (794)',1009121,1006840,NULL,NULL,NULL, 'SOMERVILLE',1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000333,NULL,NULL, 'SUPPLY DEPOT - BELL', '795', 'SUPPLY DEPOT - BELL',1009121,1006840,NULL,NULL,NULL, 'BELL',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000336,NULL,NULL, 'CENTER FOR ACQUISITION INNOVATION', '798', 'CTR FOR ACQUISITION INNOVATION',1009121,1006840,NULL,NULL,NULL, 'FREDERICK',1009324,NULL,NULL,1006840,NULL,NULL,NULL, 'FREDERICK',1009324,NULL,NULL,1009199, '0',1000334,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:51:25 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/05/2009 changes');
Insert into sdsadm.STD_Institution values(1000338,NULL,NULL, 'ALTON NATL CEMETERY', '800', 'ALTON NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ALTON',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000339,NULL,NULL, 'ANNAPOLIS CEMETERY', '801', 'ANNAPOLIS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ANNAPOLIS',1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000340,NULL,NULL, 'BALTIMORE NATL CEMETERY', '802', 'BALTIMORE NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BALTIMORE',1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000341,NULL,NULL, 'BATH NATIONAL CEMETERY', '803', 'BATH NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BATH',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000342,NULL,NULL, 'BEVERLY CEMETERY', '804', 'BEVERLY CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BEVERLY',1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000343,NULL,NULL, 'CALVERTON CEMETERY', '805', 'CALVERTON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'CALVERTON',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000344,NULL,NULL, 'CAMP BUTLER  CEMETERY', '806', 'CAMP BUTLER  CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SPRINGFIELD',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000345,NULL,NULL, 'CROWN HILL CEMETERY', '807', 'CROWN HILL CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000346,NULL,NULL, 'CYPRESS HILLS CEMETERY', '808', 'CYPRESS HILLS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BROOKLYN',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000347,NULL,NULL, 'DANVILLE CEMETERY', '809', 'DANVILLE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'DANVILLE',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000348,NULL,NULL, 'DAYTON NATIONAL CEMETERY', '810', 'DAYTON NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'DAYTON',1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000351,NULL,NULL, 'INDIANTOWN GAP CEMETERY', '813', 'INDIANTOWN GAP CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ANNVILLE',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000352,NULL,NULL, 'KEOKUK CEMETERY', '814', 'KEOKUK CEMETERY',1009121,1006840,NULL,NULL,NULL, 'KEOKUK',1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000353,NULL,NULL, 'LONG ISLAND CEMETERY', '815', 'LONG ISLAND CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FARMINGDALE',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000354,NULL,NULL, 'LOUDON PARK CEMETERY', '816', 'LOUDON PARK CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BALTIMORE',1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000355,NULL,NULL, 'MARION NATL CEMETERY', '817', 'MARION NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MARION',1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000356,NULL,NULL, 'MASSACHUSETTES CEMETERY', '818', 'MASSACHUSETTES CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BOURNE',1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000357,NULL,NULL, 'PHILADELPHIA NATL CEMETERY', '819', 'PHILADELPHIA NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'PHILADELPHIA',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000358,NULL,NULL, 'QUINCY CEMETERY', '820', 'QUINCY CEMETERY',1009121,1006840,NULL,NULL,NULL, 'QUINCY',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000359,NULL,NULL, 'ROCK ISLAND CEMETERY', '821', 'ROCK ISLAND CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ROCK ISLAND',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000360,NULL,NULL, 'TOGUS CEMETERY', '822', 'TOGUS CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000361,NULL,NULL, 'WOOD CEMETERY', '823', 'WOOD CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MILWAUKEE',1009355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000362,NULL,NULL, 'WOODLAWN NATIONAL CEMETERY', '824', 'WOODLAWN NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ELMIRA',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000365,NULL,NULL, 'BALLS BLUFF NATL CEMETERY', '827', 'BALLS BLUFF NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'LEESBURG',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000366,NULL,NULL, 'BARRANCAS CEMETERY', '828', 'BARRANCAS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BARRANCAS',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000367,NULL,NULL, 'NATL CEMETERY - BATON ROUGE', '829', 'NATL CEMETERY - BATON ROUGE',1009121,1006840,NULL,NULL,NULL, 'BATON ROUGE',1009322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000368,NULL,NULL, 'NATL CEMETERY - BAY PINES', '830', 'NATL CEMETERY - BAY PINES',1009121,1006840,NULL,NULL,NULL, 'BAY PINES',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000369,NULL,NULL, 'NATL CEMETERY - BEAUFORT', '831', 'NATL CEMETERY - BEAUFORT',1009121,1006840,NULL,NULL,NULL, 'BEAUFORT',1009345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000370,NULL,NULL, 'NATL CEMETERY - BILOXI', '832', 'NATL CEMETERY - BILOXI',1009121,1006840,NULL,NULL,NULL, 'BILOXI',1009328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000371,NULL,NULL, 'CAMP NELSON CEMETERY', '833', 'CAMP NELSON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'NICHOLASVILLE',1009321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000372,NULL,NULL, 'CAVE HILL CEMETERY', '834', 'CAVE HILL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'LOUISVILLE',1009321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000373,NULL,NULL, 'CHATTANOOGA CEMETERY', '835', 'CHATTANOOGA CEMETERY',1009121,1006840,NULL,NULL,NULL, 'CHATTANOOGA',1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000374,NULL,NULL, 'CITY POINT CEMETERY', '836', 'CITY POINT CEMETERY',1009121,1006840,NULL,NULL,NULL, 'HOPEWELL',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000375,NULL,NULL, 'COLD HARBOR CEMETERY', '837', 'COLD HARBOR CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MECHANICSVILLE',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000376,NULL,NULL, 'CORINTH CEMETERY', '838', 'CORINTH CEMETERY',1009121,1006840,NULL,NULL,NULL, 'CORINTH',1009328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000377,NULL,NULL, 'CULPEPPER CEMETERY', '839', 'CULPEPPER CEMETERY',1009121,1006840,NULL,NULL,NULL, 'CULPEPER',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000380,NULL,NULL, 'FAYETTEVILE AR-CEMETERY', '842', 'FAYETTEVILE AR-CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FAYETTEVILLE',1009305,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000381,NULL,NULL, 'FLORENCE CEMETERY', '843', 'FLORENCE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FLORENCE',1009345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000382,NULL,NULL, 'FT. GIBSON CEMETERY', '844', 'FT. GIBSON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FORT GIBSON',1009340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000383,NULL,NULL, 'FT. HARRISON CEMETERY', '845', 'FT. HARRISON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'RICHMOND',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000384,NULL,NULL, 'FT. SAM HOUSTON CEMETERY', '846', 'FT. SAM HOUSTON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SAN ANTONIO',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000385,NULL,NULL, 'FT. SMITH NATL CEMETERY', '847', 'FT. SMITH NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FORT SMITH',1009305,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000386,NULL,NULL, 'GLENDALE CEMETERY', '848', 'GLENDALE CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000387,NULL,NULL, 'HAMPTON (NATL CEMETERY)', '849', 'HAMPTON (NATL CEMETERY)',1009121,1006840,NULL,NULL,NULL, 'HAMPTON',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000389,NULL,NULL, 'HOUSTON (NATL CEMETERY)', '851', 'HOUSTON (NATL CEMETERY)',1009121,1006840,NULL,NULL,NULL, 'HOUSTON',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000390,NULL,NULL, 'JEFFERSON BARRACKS CEMETERY', '852', 'JEFFERSON BARRACKS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ST. LOUIS',1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000391,NULL,NULL, 'JEFFERSON CITY CEMETERY', '853', 'JEFFERSON CITY CEMETERY',1009121,1006840,NULL,NULL,NULL, 'JEFFERSON CITY',1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000392,NULL,NULL, 'KERRVILLE CEMETERY', '854', 'KERRVILLE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'KERRVILLE',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000393,NULL,NULL, 'KNOXVILLE CEMETERY', '855', 'KNOXVILLE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'KNOXVILLE',1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000395,NULL,NULL, 'LEXINGTON NATIONAL CEMETERY', '857', 'LEXINGTON NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'LEXINGTON',1009321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000396,NULL,NULL, 'LITTLE ROCK CEMETERY', '858', 'LITTLE ROCK CEMETERY',1009121,1006840,NULL,NULL,NULL, 'LITTLE ROCK',1009305,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000397,NULL,NULL, 'MARIETTA CEMETERY', '859', 'MARIETTA CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MARIETTA',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000398,NULL,NULL, 'MEMPHIS CEMETERY', '860', 'MEMPHIS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MEMPHIS',1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000399,NULL,NULL, 'MILL SPRINGS CEMETERY', '861', 'MILL SPRINGS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'NANCY',1009321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000400,NULL,NULL, 'MOBILE CEMETERY', '862', 'MOBILE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MOBILE',1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000401,NULL,NULL, 'MOUND CITY CEMETERY', '863', 'MOUND CITY CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MOUND CITY',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000403,NULL,NULL, 'NASHVILLE CEMETERY', '865', 'NASHVILLE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'NASHVILLE',1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000404,NULL,NULL, 'NATCHEZ CEMETERY', '866', 'NATCHEZ CEMETERY',1009121,1006840,NULL,NULL,NULL, 'NATCHEZ',1009328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000405,NULL,NULL, 'NEW ALBANY NATIONAL CEMETERY', '867', 'NEW ALBANY NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ALBANY',1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000406,NULL,NULL, 'NEW BERN CEMETERY', '868', 'NEW BERN CEMETERY',1009121,1006840,NULL,NULL,NULL, 'NEW BERN',1009337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000407,NULL,NULL, 'PERRYVILLE CEMETERY', '869', 'PERRYVILLE CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000408,NULL,NULL, 'PORT HUDSON CEMETERY', '870', 'PORT HUDSON CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000409,NULL,NULL, 'PUERTO RICO CEMETERY', '871', 'PUERTO RICO CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BAYAMON',1009372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000410,NULL,NULL, 'QUANTICO CEMETERY', '872', 'QUANTICO CEMETERY',1009121,1006840,NULL,NULL,NULL, 'TRIANGLE',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000411,NULL,NULL, 'RALEIGH CEMETERY', '873', 'RALEIGH CEMETERY',1009121,1006840,NULL,NULL,NULL, 'RALEIGH',1009337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000412,NULL,NULL, 'NC RICHMOND CEMETERY', '874', 'NC RICHMOND CEMETERY',1009121,1006840,NULL,NULL,NULL, 'RICHMOND',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000413,NULL,NULL, 'ST. AUGUSTINE CEMETERY', '875', 'ST. AUGUSTINE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ST. AUGUSTINE',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000414,NULL,NULL, 'SALISBURY CEMETERY', '876', 'SALISBURY CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SSALISBURY',1009337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000415,NULL,NULL, 'SAN ANTONIO CEMETERY', '877', 'SAN ANTONIO CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SAN ANTONIO',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000416,NULL,NULL, 'SEVEN PINES CEMETERY', '878', 'SEVEN PINES CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SEVEN PINES',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000417,NULL,NULL, 'SPRINGFIELD CEMETERY', '879', 'SPRINGFIELD CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SPRINGFIELD',1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000418,NULL,NULL, 'STAUNTON CEMETERY', '880', 'STAUNTON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'STAUNTON',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000419,NULL,NULL, 'WILMINGTON CEMETERY', '881', 'WILMINGTON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'WILMINGTON',1009337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000420,NULL,NULL, 'WINCHESTER CEMETERY', '882', 'WINCHESTER CEMETERY',1009121,1006840,NULL,NULL,NULL, 'WINCHESTER',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000422,NULL,NULL, 'BLACK HILLS NATIONAL CEMETERY', '884', 'NATL CEMETERY - BLACK HILLS',1009121,1006840, '20901 PLEASANT VALLEY DR',NULL,NULL, 'STURGIS',1009346,NULL, '57785',1006840, 'BLACK HILLS NATIONAL CEMETERY',NULL,NULL, 'STURGIS',1009346,NULL, '57785',1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000423,NULL,NULL, 'FT. BAYARD CEMETERY', '885', 'FT. BAYARD CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000424,NULL,NULL, 'FT. BLISS CEMETERY', '886', 'FT. BLISS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FORT BLISS',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000425,NULL,NULL, 'FT. LEAVENWORTH CEMETERY', '887', 'FT. LEAVENWORTH CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000426,NULL,NULL, 'FT. LOGAN CEMETERY', '888', 'FT. LOGAN CEMETERY',1009121,1006840,NULL,NULL,NULL, 'DENVER',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000427,NULL,NULL, 'FORT LOGAN CEMETERY', '889', 'FORT LOGAN CEMETERY',1009121,1006840,NULL,NULL,NULL, 'DENVER',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000428,NULL,NULL, 'FT. MCPHERSON CEMETERY', '890', 'FT. MCPHERSON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MAXWELL',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000429,NULL,NULL, 'FORT MEADE CEMETERY', '891', 'FORT MEADE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'VAMC FORT MEADE',1009346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000430,NULL,NULL, 'FT. ROSECRANS CEMETERY', '892', 'FT. ROSECRANS CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SAN DIEGO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000431,NULL,NULL, 'FT. SCOTT CEMETERY', '893', 'FT. SCOTT CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FORT SCOTT',1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000432,NULL,NULL, 'FT. SNELLING NATL CEMETERY', '894', 'FT. SNELLING NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'MINNEAPOLIS',1009327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000433,NULL,NULL, 'GOLDEN GATE CEMETERY', '895', 'GOLDEN GATE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SAN BRUNO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000434,NULL,NULL, 'LEAVENWORTH NATL CEMETERY', '897', 'LEAVENWORTH NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'LEAVENWORTH',1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 9:53:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/16/2010 changes');
Insert into sdsadm.STD_Institution values(1000435,NULL,NULL, 'LOS ANGELES CEMETERY', '898', 'LOS ANGELES CEMETERY',1009121,1006840,NULL,NULL,NULL, 'LOS ANGELES',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000436,NULL,NULL, 'PACIFIC MEMORIAL CEMETERY', '899', 'PACIFIC MEMORIAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'HONOLULU',1009315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000437,NULL,NULL, 'PRESCOTT CEMETERY', '900', 'PRESCOTT CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000438,NULL,NULL, 'RIVERSIDE CEMETERY', '901', 'RIVERSIDE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'RIVERSIDE',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000439,NULL,NULL, 'ROSEBURG CEMETERY', '902', 'ROSEBURG CEMETERY',1009121,1006840,NULL,NULL,NULL, 'ROCK ISLAND',1009341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000440,NULL,NULL, 'SAN FRANCISCO CEMETERY', '903', 'SAN FRANCISCO CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SAN FRANCISCO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000441,NULL,NULL, 'SANTA FE NATIONAL CEMETERY', '904', 'SANTA FE NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SANTA FE',1009335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000442,NULL,NULL, 'SITKA CEMETERY', '905', 'SITKA CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000443,NULL,NULL, 'EAGLE POINT CEMETERY', '906', 'EAGLE POINT CEMETERY',1009121,1006840,NULL,NULL,NULL, 'EAGLE POINT',1009341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000444,NULL,NULL, 'WILLIAMETTE CEMETERY', '907', 'WILLIAMETTE CEMETERY',1009121,1006840,NULL,NULL,NULL, 'PORTLAND',1009341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000445,NULL,NULL, 'FT. MITCHELL CEMETERY', '908', 'FT. MITCHELL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'PHOENIX CITY',1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:43:10 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/15/06 changes');
Insert into sdsadm.STD_Institution values(1000446,NULL,NULL, 'FT. CUSTER CEMETERY', '909', 'FT. CUSTER CEMETERY',1009121,1006840,NULL,NULL,NULL, 'AUGUSTA',1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000447,NULL,NULL, 'FT. RICHARDSON CEMETERY', '910', 'FT. RICHARDSON CEMETERY',1009121,1006840,NULL,NULL,NULL, 'FORT RICHARDSON',1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000448,NULL,NULL, 'FLORIDA  CEMETERY', '911', 'FLORIDA  CEMETERY',1009121,1006840,NULL,NULL,NULL, 'BUSHNELL',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000449,NULL,NULL, 'WEST VIRGINIA CEMETERY', '912', 'WEST VIRGINIA CEMETERY',1009121,1006840,NULL,NULL,NULL, 'GRAFTON',1009354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000450,NULL,NULL, 'SAN JOAQUIN CEMETERY', '913', 'SAN JOAQUIN CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000451,NULL,NULL, 'ARIZONA MEMORIAL', '914', 'ARIZONA MEMORIAL',1009121,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000452,NULL,NULL, 'ABRAHAM LINCOLN NATL CEMETERY', '915', 'ABRAHAM LINCOLN NATL CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000453,NULL,NULL, 'DALLAS/FT. WORTH CEMETERY', '916', 'DALLAS/FT. WORTH CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000454,NULL,NULL, 'SARATOGA NATIONAL CEMETERY', '917', 'SARATOGA NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000455,NULL,NULL, 'CLEVELAND AREA CEMETERY', '918', 'CLEVELAND AREA CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:57 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/31/07 changes');
Insert into sdsadm.STD_Institution values(1000456,NULL,NULL, 'KENT CEMETERY', '919', 'KENT CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000457,NULL,NULL, 'FT. SILL CEMETERY', '920', 'FT. SILL CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000458,NULL,NULL, 'SACRAMENTO NATIONAL CEMETERY', '921', 'SACRAMENTO NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'SACRAMENTO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:43:11 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/15/06 changes');
Insert into sdsadm.STD_Institution values(1000459,NULL,NULL, 'GEORGIA NATIONAL CEMETERY', '922', 'GEORGIA NATIONAL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'WASHINGTON',1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000460,NULL,NULL, 'GREAT LAKES NATL CEMETERY', '923', 'GREAT LAKES NATL CEMETERY',1009121,1006840,NULL,NULL,NULL, 'HOLLY',1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000461,NULL,NULL, 'SOUTH FLORIDA NATIONAL CEMETERY', '924', 'SOUTH FLORIDA CEMETERY',1009121,1006840, '6501 S. State Road 7 Director',NULL,NULL, 'Lake Worth',1009312,NULL, '33467',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000462,NULL,NULL, 'PITTSBURGH NATL CEMETERY', '925', 'PITTSBURGH NATL CEMETERY',1009121,1006840, '3911 MORGAN ROAD',NULL,NULL, 'BRIDGEVILLE',1009342,NULL, '15017',1006840, '3911 MORGAN ROAD',NULL,NULL, 'BRIDGEVILLE',1009342,NULL, '15017',1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000463,NULL,NULL, 'SOUTHERN PENNSYLVANIA AREA CEMETERY', '926', 'SOUTHERN PENNSYLVANIA CEMETERY',1009121,1006840,NULL,NULL,NULL, 'PHILADELPHIA',1009342,NULL,NULL,NULL,NULL,NULL,NULL, 'PHILADELPHIA',1009342,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:21:34 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/29/2008 changes');
Insert into sdsadm.STD_Institution values(1000464,NULL,NULL, 'BIRMINGHAM CEMETERY', '927', 'BIRMINGHAM AREA CEMETERY',1009121,1006840, '3133 HIGHWAY 119',NULL,NULL, 'MONTEVALLO',1009301,NULL, '35115',NULL, '3133 HIGHWAY 119',NULL,NULL, 'MONTEVALLO',1009301,NULL, '35115',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:21:34 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/29/2008 changes');
Insert into sdsadm.STD_Institution values(1000465,NULL,NULL, 'JACKSONVILLE FL NATIONAL CEMETERY', '928', 'JACKSONVILLE FL AREA CMETERY',1009121,1006840, '4083 LANNIE ROAD',NULL,NULL, 'JACKSONVILLE',1009312,NULL, '32218-1247',NULL, '4083 LANNIE ROAD',NULL,NULL, 'JACKSONVILLE',1009312,NULL, '32218-1247',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:21:34 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/29/2008 changes');
Insert into sdsadm.STD_Institution values(1000466,NULL,NULL, 'BAKERSFIELD AREA CEMETERY', '929', 'BAKERSFIELD AREA CEMETERY',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',NULL, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1009199, '0',NULL,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:22:53 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 05/31/2008 changes');
Insert into sdsadm.STD_Institution values(1000467,NULL,NULL, 'COLUMBIA/GREENVILLE CEMETERY', '930', 'COLUMBIA/GREENVILLE CEMETERY',1009121,1006840, '4170 PERCIVAL ROAD',NULL,NULL, 'COLUMBIA',1009345,NULL, '29229',NULL, '4170 PERCIVAL ROAD',NULL,NULL, 'COLUMBIA',1009345,NULL, '29229',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:21:34 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/29/2008 changes');
Insert into sdsadm.STD_Institution values(1000468,NULL,NULL, 'SARASOTA VA NATIONAL CEMETERY', '931', 'SARASOTA VA NATIONAL CEMETERY',1009121,1006840, '9810 STATE ROAD 72',NULL,NULL, 'SARASOTA',1009312,NULL, '34241',NULL, '9810 STATE ROAD 72',NULL,NULL, 'SARASOTA',1009312,NULL, '34241',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:21:34 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/29/2008 changes');
Insert into sdsadm.STD_Institution values(1000469,NULL,TO_DATE('6/30/2009' , 'mm/dd/yyyy hh:mi:ss AM'), 'NCA NATIONAL SCHEDULING OFC', '932', 'ZZ-NCA NATIONAL SCHEDULING OFC',1009121,1006840, '4850 LEMAY FERRY ROAD',NULL,NULL, 'ST. LOUIS',1009329,NULL, '63129',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:51:25 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/05/2009 changes');
Insert into sdsadm.STD_Institution values(1000470,NULL,NULL, 'COLORADO SPRINGS NATL CEM', '933', 'COLORADO SPRINGS NATL CEM',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009152, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000471,NULL,NULL, 'MELBOURNE NATL CEMETERY', '934', 'MELBOURNE NATL CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009152, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000472,NULL,NULL, 'OMAHA NATL CEMETERY', '935', 'OMAHA NATL CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009152, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:02:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/22/2011 changes');
Insert into sdsadm.STD_Institution values(1000474,NULL,NULL, 'TALLAHASSE NATL CEMETERY', '937', 'TALLAHASSE NATL CEMETERY',1009121,1006840, '5015 APALACHEE PARKWAY',NULL,NULL, 'TALLAHASSEE',1009312,NULL, '32311',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('11/19/2014 8:26:49 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0920 10/06/2014');
Insert into sdsadm.STD_Institution values(1000475,NULL,NULL, 'TOGUS CHEP', '938', 'TOGUS CHEP',1009121,1006840,NULL,NULL,NULL, 'TOGUS',1009323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009152, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000476,NULL,NULL, 'TUSKEGEE-CHEP', '939', 'TUSKEGEE-CHEP',1009121,1006840,NULL,NULL,NULL, 'TUSKEGEE',1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009152, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000477,NULL,NULL, 'LOS ANGELES (941)', '941', 'LOS ANGELES (941)',1009121,1006840,NULL,NULL,NULL, 'WEST LOS ANGELES',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000478,NULL,NULL, 'DURHAM EES', '954', 'DURHAM EES',1009121,1006840,NULL,NULL,NULL, 'DURHAM',1009337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009163, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000480,NULL,NULL, 'NEOSHO RC  V', '200AA', 'NEOSHO RC  V',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009210, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000481,NULL,NULL, 'CHICAGO CDC', '200BA', 'CHICAGO CDC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009162, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000482,NULL,NULL, 'PHILADELPHIA CDC', '200BB', 'PHILADELPHIA CDC',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009162, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000483,NULL,NULL, 'AUSTIN HEALTH DATA REPOSITORY (HDR)', '200HD', 'HDR (AVAILABLE SOON)',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:34:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/18/05 changes');
Insert into sdsadm.STD_Institution values(1000484,NULL,NULL, 'MPI', '200M', 'MPI',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009178, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000485,NULL,NULL, 'DES MOINES OIG', '333GC', 'DES MOINES OIG',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009165, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000486,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'MANILA RO', '358DC', 'ZZQUEZON CITY',1009121,1006608, '2201 ROXAS BLVD',NULL,NULL, 'MANILA',1009396,NULL, '1300',1006608, '2201 ROXAS BLVD',NULL,NULL, 'MANILA',1009396,NULL, '1300',1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:40:12 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/23/06 changes');
Insert into sdsadm.STD_Institution values(1000487,NULL,NULL, 'HONOLULU US ARMY HOSPITAL', '359CN', 'HONOLULU US ARMY HOSPITAL',1009124,1006840,NULL,NULL,NULL, 'TRIPLER',1009315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000488,NULL,NULL, 'MARSHALL ISLAND NAVY HOSP', '359CT', 'MARSHALL ISLAND NAVY HOSP',1009125,1006840,NULL,NULL,NULL, 'MARSHALL ISLAND',1009366,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009229, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000489,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ANCHORAGE (DOMIC)', '363BU', 'ZZ ANCHORAGE (DOMIC)',1009121,1006840,NULL,NULL,NULL,NULL,1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('11/19/2014 8:26:49 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0920 10/06/2014');
Insert into sdsadm.STD_Institution values(1000490,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ANCHORAGE (PHS)', '363C5', 'ZZ ANCHORAGE (PHS)',1009121,1006840,NULL,NULL,NULL,NULL,1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009202, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000491,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ANCHORAGE USAH', '363CN', 'ZZ ANCHORAGE USAH',1009124,1006840,NULL,NULL,NULL, 'ANCHORAGE',1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000492,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ANCHORAGE USAF', '363CZ', 'ZZ ANCHORAGE USAF',1009122,1006840,NULL,NULL,NULL, 'ANCHORAGE',1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000493,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ANCHORAGE (PUBH)', '363DM', 'ZZ ANCHORAGE (PUBH)',1009121,1006840,NULL,NULL,NULL,NULL,1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000494,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ANCHORAGE (CIVH)', '363DS', 'ZZ ANCHORAGE (CIVH)',1009121,1006840,NULL,NULL,NULL,NULL,1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000495,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FT. WAINWRIGHT (ORC)', '363HA', 'ZZ FT. WAINWRIGHT (ORC)',1009121,1006840,NULL,NULL,NULL,NULL,1009302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000496,NULL,NULL, 'TOGUS MAINE NHCU', '4029AA', 'TOGUS MAINE NHCU',1009121,1006840, 'DEPARTMENT OF VETERANS AFFAIRS',NULL,NULL, 'TOGUS',1009323,NULL, '4330',1006840, 'DEPARTMENT OF VETERANS AFFAIRS',NULL,NULL, 'TOGUS',1009323,NULL, '4330',1009185, '0',1000088,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000497,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZZTOGUS STNB', '4029AF', 'ZZZTOGUS STNB',1009121,1006840, 'TOGUS',NULL,NULL, 'TOGUS',1009323,NULL, '4330',1006840, 'TOGUS',NULL,NULL, 'TOGUS',1009323,NULL, '4330',1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000499,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZZCARIBOU STNB', '402DU', 'ZZZCARIBOU',1009121,1006840, 'CARIBOU',NULL,NULL, 'CARIBOU',1009323,NULL, '4736',1006840, 'CARIBOU',NULL,NULL, 'CARIBOU',1009323,NULL, '4736',1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000500,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZZSCARBOUROUGH', '402DV', 'ZZZSCARBOROUGH',1009121,1006840, 'SCARBOROUGH',NULL,NULL, 'SCARBOROUGH',1009323,NULL, '4074',1006840, 'SCARBOROUGH',NULL,NULL, 'SCARBOROUGH',1009323,NULL, '4074',1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000501,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZZSOUTH PARIS', '402DW', 'ZZZSOUTH PARIS',1009121,1006840, 'SOUTH PARIS',NULL,NULL, 'SO. PARIS',1009323,NULL, '4281',1006840, 'SOUTH PARIS',NULL,NULL, 'SOUTH PARIS',1009323,NULL, '4281',1009222, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000502,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZZBANGOR', '402DX', 'ZZZBANGOR',1009121,1006840, 'BANGOR',NULL,NULL, 'BANGOR',1009323,NULL, '4401',1006840, 'BANGOR',NULL,NULL, 'BANGOR',1009323,NULL, '4401',1009222, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000503,NULL,NULL, 'CARIBOU MAINE CBOC', '402GA', 'CARIBOU MAINE CBOC',1009121,1006840, '163 VAN BUREN RD #6',NULL,NULL, 'CARIBOU',1009323,NULL, '04736-3567',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000088,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000504,NULL,NULL, 'CALAIS MAINE CBOC', '402GB', 'CALAIS MAINE CBOC',1009121,1006840, '50 UNION STREET',NULL,NULL, 'CALAIS',1009323,NULL, '04619-1839',1006840, '1 VA CENTER',NULL,NULL, 'AUGUSTA',1009323,NULL, '04619-1839',1009148, '0',1000088,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000505,NULL,NULL, 'RUMFORD MAINE CBOC', '402GC', 'RUMFORD MAINE CBOC',1009121,1006840, '431 FRANKLIN STREET',NULL,NULL, 'RUMFORD',1009323,NULL, '04276-2100',1006840, '431 FRANKLIN STREET',NULL,NULL, 'RUMFORD',1009323,NULL, '04276-2100',1009148, '0',1000088,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000506,NULL,NULL, 'SACO MAINE CBOC', '402GD', 'SACO MAINE CBOC',1009121,1006840, '655 MAIN STREET',NULL,NULL, 'SACO',1009323,NULL, '04072-1543',1006840, '655 MAIN STREET',NULL,NULL, 'SACO',1009323,NULL, '04072-1543',1009148, '0',1000088,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000508,NULL,NULL, 'BANGOR MAINE CBOC', '402HB', 'BANGOR MAINE CBOC',1009121,1006840, '35 STATE HOSPITAL DRIVE',NULL,NULL, 'BANGOR',1009323,NULL, '04401-8816',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000088,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000509,NULL,NULL, 'PORTLAND MAINE MH ORC', '402HC', 'PORTLAND MAINE MH ORC',1009121,1006840, '144 FORE ST #200',NULL,NULL, 'PORTLAND',1009323,NULL, '04101-4843',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000088,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000510,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZZCALAIS/MACHIAS', '402HK', 'ZZZCALAIS/MACHIAS',1009121,1006840, '1 PALMER STREET',NULL,NULL, 'CALAIS',1009323,NULL, '4619',1006840, '1 PALMER STREET',NULL,NULL, 'CALAIS',1009323,NULL, '4619',1009177, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1000511,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TOGUS', '4059AA', 'ZZ TOGUS',1009121,1006840,NULL,NULL,NULL, 'TOGUS',1009323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000512,NULL,NULL, 'BENNINGTON STATE NURSING HOME', '4059AF', 'BENNINGTON STATE NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BENNINGTON',1009350,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000513,NULL,NULL, 'BENNINGTON VERMONT STATE HOME', '405DT', 'BENNINGTON STATE HOME',1009121,1006840,NULL,NULL,NULL, 'BENNINGTON',1009350,NULL, '5201',1006840,NULL,NULL,NULL, 'BENNINGTON',1009350,NULL, '5201',1009221, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000514,NULL,NULL, 'BENNINGTON VERMONT OUTREACH CLINIC', '405GA', 'BENNINGTON CBOC',1009121,1006840, '186 NORTH ST',NULL,NULL, 'BENNINGTON',1009350,NULL, '05201-1874',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000515,NULL,NULL, 'BURLINGTON LAKESIDE CBOC', '405HA', 'BURLINGTON LAKESIDE CBOC',1009121,1006840, '128 LAKESIDE AVE #260',NULL,NULL, 'BURLINGTON',1009350,NULL, '05401-5911',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('2/11/2014 1:48:36 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0889 01/06/2014');
Insert into sdsadm.STD_Institution values(1000516,NULL,NULL, 'MONTPELIER OUTREACH CLINIC', '405HB', 'MONTPELIER ORC',1009121,1006840,NULL,NULL,NULL, 'MONTPELIER',1009350,NULL, '5602',1006840,NULL,NULL,NULL, 'MONTPELIER',1009350,NULL, '5602',1009198, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000517,NULL,NULL, 'ST. JOHNSBURY VERMONT OUTREACH CLINIC', '405HC', 'ST. JOHNSBURY CBOC',1009121,1006840, '685 MEADOW ST #4',NULL,NULL, 'LITTLETON',1009333,NULL, '03561-3629',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000518,NULL,NULL, 'NEWPORT VERMONT ORC', '405HD', 'NEWPORT CBOC',1009121,1006840, '60 BROADVIEW AVE',NULL,NULL, 'NEWPORT',1009350,NULL, '05855-5516',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000519,NULL,NULL, 'KEENE OUT REACH CENTER', '405HE', 'KEENE CBOC',1009121,1006840, '640 MARLBORO ST',NULL,NULL, 'KEENE',1009333,NULL, '03431-4049',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000520,NULL,NULL, 'RUTLAND VERMONT OUTREACH CLINIC', '405HF', 'RUTLAND CBOC',1009121,1006840, '215 STRATTON ROAD',NULL,NULL, 'RUTLAND',1009350,NULL, '05701-4621',1006840, '215 STRATTON ROAD',NULL,NULL, 'RUTLAND',1009350,NULL, '05701-4621',1009148, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:15:45 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0833 1/14/2013');
Insert into sdsadm.STD_Institution values(1000522,NULL,NULL, 'WHITE RIVER JUNCTION MORC', '405HK', 'WHITE RIVER JCT MORC',1009121,1006840,NULL,NULL,NULL, 'WHITE RIVER JUNCTION',1009350,NULL, '5009',1006840,NULL,NULL,NULL, 'WHITE RIVER JUNCTION',1009350,NULL, '5009',1009177, '0',1000089,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000523,NULL,NULL, 'MONTANA HCS VA NURSING HOME', '4369AA', 'MONTANA HCS VA NURSING HOME',1009121,1006840, '210 SOUTH WINCHESTER',NULL,NULL, 'MILES CITY',1009330,NULL, '59301',1006840, '210 SOUTH WINCHESTER',NULL,NULL, 'MILES CITY',1009330,NULL, '59301',1009185, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000524,NULL,NULL, 'COLUMBIA FALLS ST NURSING HOME', '4369AF', 'COLUMBIA FALLS ST NURSING HOME',1009121,1006840, 'PO BOX 250',NULL,NULL, 'COLUMBIA FALLS',1009330,NULL, '59912',1006840, 'P.O. BOX 250',NULL,NULL, 'COLUMBIA FALLS',1009330,NULL, '59912',1009221, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000525,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MILES CITY VA MEDICAL CENTER', '436A4', 'MILES CITY VA MEDICAL CENTER',1009121,1006840, '210 S WINCHESTER',NULL,NULL, 'MILES CITY',1009330,NULL, '59301-4757',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',1000095,1000206,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000526,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'FT HARRISON VET STATE HOME', '436DT', 'FT. HARRISON VET STATE HOME',1009121,1006840, 'Box 250',NULL,NULL, 'Columbia Falls',1009330,NULL, '59912',1006840, 'PO Box 250',NULL,NULL, 'Columbia Falls',1009330,NULL, '59912',1009219, '0',1000095,1001443,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000527,NULL,NULL, 'FT HARRISON STATE HOME', '436DU', 'FT. HARRISON STATE HOME',1009121,1006840, '2000 MONTANA AVENUE',NULL,NULL, 'GLENDIVE',1009330,NULL, '59330',1006840, '200 MONTANA AVENUE',NULL,NULL, 'GLENDIVE',1009330,NULL, '59330',1009221, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000528,NULL,NULL, 'ANACONDA CBOC', '436GA', 'ANACONDA CBOC',1009121,1006840, '118 East 7th Street',NULL,NULL, 'ANACONDA',1009330,NULL, '59711-2900',1006840, '118 EAST 7TH STREET',NULL,NULL, 'ANACONDA',1009330,NULL, '59711-2900',1009148, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000532,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WOLF POINT CBOC', '436GE', 'ZZ WOLF POINT CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009330,NULL, '59201',1006840,NULL,NULL,NULL,NULL,1009330,NULL, '59201',1009148, '0',NULL,1001445,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000533,NULL,NULL, 'KALISPELL VA CLINIC', '436GF', 'KALISPELL VA CLINIC',1009121,1006840, '31 3 MILE DR',NULL,NULL, 'KALISPELL',1009330,NULL, '59901-3099',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000534,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'BILLINGS VA CLINIC', '436GH', 'BILLINGS VA CLINIC',1009121,1006840, '1766 MAJESTIC LANE',NULL,NULL, 'BILLINGS',1009330,NULL, '59102-6759',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000095,1001444,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000535,NULL,NULL, 'GLASGOW VA CLINIC', '436GI', 'GLASGOW VA CLINIC',1009121,1006840, '630 2ND AVENUE SOUTH SUITE A',NULL,NULL, 'GLASGOW',1009330,NULL, '59230-2304',1006840, '630 2ND AVENUE SOUTH SUITE A',NULL,NULL, 'GLASGOW',1009330,NULL, '59230-2304',1009148, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000536,NULL,NULL, 'MILES CITY VA CLINIC', '436GJ', 'MILES CITY VA CLINIC',1009121,1006840, '210 South Winchester',NULL,NULL, 'Miles City',1009330,NULL, '59301-4757',1006840, '210 SOUTH WINCHESTER',NULL,NULL, 'MILES CITY',1009330,NULL, '59301-4757',1009148, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000537,NULL,NULL, 'GLENDIVE VA CLINIC', '436GK', 'GLENDIVE VA CLINIC',1009121,1006840, '2000 MONTANA AVENUE',NULL,NULL, 'GLENDIVE',1009330,NULL, '59330-3700',1006840, '2000 MONTANA AVENUE',NULL,NULL, 'GLENDIVE',1009330,NULL, '59330-3700',1009148, '0',1000095,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000538,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROWNING CBOC', '436HB', 'ZZ BROWNING ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009330,NULL, '59417',1006840,NULL,NULL,NULL,NULL,1009330,NULL, '59417',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000539,NULL,NULL, 'FARGO (NHCU)', '4379AA', 'FARGO (NHCU)',1009121,1006840, '2101 N ELM ST',NULL,NULL, 'FARGO',1009338,NULL, '58102',1006840, '2101 N ELM ST',NULL,NULL, 'FARGO',1009338,NULL, '58102',1009185, '0',1000096,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000540,NULL,NULL, 'MINOT AFB', '437CZ', 'MINOT AFB',1009122,1006840, '10 MISSILE AVE',NULL,NULL, 'MINOT',1009338,NULL, '58709',1006840, 'FIFTH MEDICAL GROUP',NULL,NULL, 'MINOT',1009338,NULL, '58709',1009224, '0',1000096,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000541,NULL,NULL, 'LISBON', '437DT', 'LISBON',1009121,1006840, '1400 ROSE ST',NULL,NULL, 'LISBON',1009338,NULL, '58054',1006840, '1400 ROSE ST',NULL,NULL, 'LISBON',1009338,NULL, '58054',1009221, '0',1000096,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000542,NULL,NULL, 'MINESOTA VETERANS STATE HOME', '437DU', 'FERGUS FALLS',1009121,1006840, '1821 N PARK ST',NULL,NULL, 'FERGUS FALLS',1009327,NULL, '56537',1006840, '1821 N PARK ST',NULL,NULL, 'FERGUS FALLS',1009327,NULL, '56537',1009221, '0',1000096,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000543,NULL,NULL, 'GRAFTON', '437GA', 'GRAFTON',1009121,1006840, '701 WEST 6TH STREET',NULL,NULL, 'GRAFTON',1009338,NULL, '58237-1379',1006840, 'ND STATE DEVELOPMENTAL CENTER VA CLINIC',NULL,NULL, 'GRAFTON',1009338,NULL, '58237-1379',1009148, '0',1000096,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000546,NULL,NULL, 'MINOT CBOC', '437GD', 'MINOT CBOC',1009121,1006840, '10 MISSILE AVE',NULL,NULL, 'MINOT',1009338,NULL, '58705-5003',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000096,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1000547,NULL,NULL, 'SIOUX FALLS NHC', '4389AA', 'SIOUX FALLS NHC',1009121,1006840, '2501 W 22nd St',NULL,NULL, 'SIOUX FALLS',1009346,NULL, '57105',1006840, '2501 W 22nd St',NULL,NULL, 'Sioux Falls',1009346,NULL, '57105',1009185, '0',1000097,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000548,NULL,NULL, 'LUVERNE CBOC', '438DT', 'LUVERNE',1009121,1006840, '305 EAST LUVERNE STREET',NULL,NULL, 'LUVERNE',1009327,NULL, '56156',1006840, '305 EAST LUVERNE STREET',NULL,NULL, 'LUVERNE',1009327,NULL, '56156',1009221, '0',1000097,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000552,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'SIOUX CITY CBOC', '438HA', 'ZZSIOUX CITY',1009121,1006840, '1551 INDIAN HILLS',NULL,NULL, 'SIOUX CITY',1009319,NULL, '51104',1006840, '1551 INDIAN HILLS',NULL,NULL, 'SIOUX CITY',1009319,NULL, '51104',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000553,NULL,NULL, 'SCOTTSBLUFF STNB', '442DT', 'SCOTTSBLUFF ANNEX',1009121,1006840, '1102 WEST 42ND ST',NULL,NULL, 'SCOTTSBLUFF',1009331,NULL, '69361',1006840, '1102 WEST 42ND ST',NULL,NULL, 'SCOTTSBLUFF',1009331,NULL, '69361',1009221, '0',1000098,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000554,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CASPER CBOC', '442GA', 'ZZ CASPER CBOC',1009121,1006840,NULL,NULL,NULL, 'CASPER',1009356,NULL, '82601',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000555,NULL,NULL, 'SIDNEY VA CLINC', '442GB', 'SIDNEY VA CLINC',1009121,1006840, '1116 10TH ST',NULL,NULL, 'SIDNEY',1009331,NULL, '69162-2001',1006840, '1116 10TH ST',NULL,NULL, 'SIDNEY',1009331,NULL, '69162-2001',1009148, '0',1000098,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000556,NULL,NULL, 'FORT COLLINS VA CLINIC', '442GC', 'FORT COLLINS VA CLINIC',1009121,1006840, '2509 RESEARCH BLVD',NULL,NULL, 'FORT COLLINS',1009308,NULL, '80526-8108',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000098,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000557,NULL,NULL, 'GREELEY VA CLINIC', '442GD', 'GREELEY VA CLINIC',1009121,1006840, '2001 70TH AVE #200',NULL,NULL, 'GREELEY',1009308,NULL, '80634-4613',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000098,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000558,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WICHITA NHCU', '4529AA', 'ZZ WICHITA NHCU',1009121,1006840,NULL,NULL,NULL, 'WICHITA',1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000559,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FORT DODGE STNB', '4529AF', 'ZZ FORT DODGE STNB',1009121,1006840,NULL,NULL,NULL, 'FORT DODGE',1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001261,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1000560,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FT. DODGE STNB', '452DT', 'ZZ FT. DODGE STNB',1009121,1006840,NULL,NULL,NULL, 'FT. DODGE',1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001278,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000561,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ DODGE CITY CBOC', '452GA', 'ZZ DODGE CITY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001281,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000562,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LIBERAL CBOC', '452GB', 'ZZ LIBERAL CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001282,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000563,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ HAYS CBOC', '452GC', 'ZZ HAYS CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001283,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000564,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PARSONS CBOC', '452GD', 'ZZ PARSONS CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001284,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000566,NULL,NULL, 'TRIPLER ARMY MEDICAL CENTER', '459CN', 'TRIPLER ARMY MEDICAL CENTER',1009124,1006840, '1 JARRETT WHITE ROAD',NULL,NULL, 'HONOLULU',1009315,NULL, '96859-5000',1006840, '1 JARRETT WHITE ROAD',NULL,NULL, 'HONOLULU',1009315,NULL, '96859-5000',1009226, '0',1000103,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000567,NULL,NULL, 'US NAVAL HOSPITAL GUAM', '459CT', 'US NAVAL HOSPITAL GUAM',1009125,1006840, 'U.S. NAVAL HOSPITAL',NULL,NULL, 'FPO',1009366,NULL, '96638-1600',1006840, 'U.S. NAVAL HOSPITAL',NULL,NULL, 'FPO',1009366,NULL, '96638-1600',1009229, '0',1000103,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000570,NULL,NULL, 'KONA CBOC', '459GC', 'KONA CLINIC',1009121,1006840, '75-377 HUALALAI RD',NULL,NULL, 'KAILUA-KONA',1009315,NULL, '96740-9724',1006840, '75-377 HUALALAI RD',NULL,NULL, 'KAILUA-KONA',1009315,NULL, '96740-9724',1009148, '0',1000103,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000571,NULL,NULL, 'KAUAI CBOC', '459GD', 'KAUAI CLINIC',1009121,1006840, '4485 PAHEE ST #150',NULL,NULL, 'LIHUE',1009315,NULL, '96766-2018',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000103,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000572,NULL,NULL, 'GUAM CBOC', '459GE', 'GUAM CLINIC',1009121,1006840, '498 CHALAN PALAYSO',NULL,NULL, 'GUAM',1009366,NULL, '96910-6427',1006840, '498 CHALAN PALAYSO',NULL,NULL, 'AGANA HEIGHTS',1009366,NULL, '96910-6427',1009148, '0',1000103,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000577,NULL,NULL, 'WILMINGTON NHC', '4609AA', 'WILMINGTON NHC',1009121,1006840,NULL,NULL,NULL, 'WILMINGTON',1009310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000578,NULL,NULL, 'VINELAND STNB', '4609AF', 'VINELAND STNB',1009121,1006840,NULL,NULL,NULL, 'VINELAND',1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000579,NULL,TO_DATE('1/8/2007' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-VINELAND STATE HOME', '460DT', 'ZZ-VINELAND STATE HOME',1009121,1006840,NULL,NULL,NULL, 'VINELAND',1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1000580,NULL,NULL, 'SUSSEX COUNTY VA CLINIC', '460GA', 'SUSSEX COUNTY VA CLINIC',1009121,1006840, '15 GEORGETOWN PLAZA',NULL,NULL, 'GEORGETOWN',1009310,NULL, '19947-2300',1006840, '15 GEORGETOWN PLAZA',NULL,NULL, 'GEORGETOWN',1009310,NULL, '19947-2300',1009148, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000581,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZCAPE MAY (WILMINGTON)', '460GB', 'ZZCAPE MAY (WILMINGTON)',1009121,1006840, '1 MUNRO AVENUE USCG TRAINING CENTER DISP',NULL,NULL, 'CAPE MAY',1009334,NULL, '8204',1006840, '1 MUNRO AVENUE USCG TRAINING CENTER DISP',NULL,NULL, 'CAPE MAY',1009334,1010018, '8204',1009148, '0',NULL,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000582,NULL,NULL, 'DOVER ORC', '460HA', 'DOVER ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000583,NULL,NULL, 'GEORGETOWN ORC', '460HB', 'GEORGETOWN ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000584,NULL,NULL, 'OCEANVIEW ORC', '460HC', 'OCEANVIEW ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000585,NULL,NULL, 'REHOBETH ORC', '460HD', 'REHOBETH ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000586,NULL,NULL, 'ATLANTIC COUNTY VA CLINIC', '460HE', 'ATLANTIC COUNTY VA CLINIC',1009121,1006840, '1909 NEW RD #302',NULL,NULL, 'NORTHFIELD',1009334,NULL, '08225-1537',1006840,NULL,NULL,NULL,NULL,NULL,1010017,NULL,1009148, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000587,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-BLACKWOOD ORC', '460HF', 'ZZ-BLACKWOOD ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000589,NULL,NULL, 'WILMINGTON VA MOBILE CLINIC', '460HK', 'WILMINGTON VA MOBILE CLINIC',1009121,1006840, '1601 KIRKWOOD HIGHWAY',NULL,NULL, 'WILMINGTON',1009310,NULL, '19805-4917',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000590,NULL,NULL, 'SMYRNA MORC', '460HL', 'SMYRNA MORC',1009121,1006840,NULL,NULL,NULL,NULL,1009310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009177, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000591,NULL,NULL, 'MILLINTON MORC', '460HM', 'MILLINTON MORC',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009177, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000592,NULL,NULL, 'SALEM CITY MORC', '460HO', 'SALEM CITY MORC',1009121,1006840,NULL,NULL,NULL,NULL,1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009177, '0',1000104,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000593,NULL,NULL, 'ANCHORAGE DOMICILIARY', '463BU', 'ANCHORAGE DOMICILIARY',1009121,1006840, '3001 C ST.',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99503-3913',1006840, '1201 NORTH MULDOON RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504',1009158, '0',1000105,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000594,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZANCHORAGE (PHS)', '463C5', 'ZZANCHORAGE (PHS)',1009121,1006840, '2925 DEBARR RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99508',1006840, '2925 DEBARR RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99508',1009202, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:03:05 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/15/2011 changes');
Insert into sdsadm.STD_Institution values(1000595,NULL,NULL, 'ANCHORAGE (ARMY HOSPITAL)', '463CN', 'ANCHORAGE (ARMY HOSPITAL)',1009124,1006840, 'Bassett Army Community Hospital (BACH)',NULL,NULL, 'Fort Wainwright',1009302,NULL, '99703',1006840, 'P.O. BOX 74570',NULL,NULL, 'FAIRBANKS',1009302,NULL, '99707',1009226, '0',1000105,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:03:05 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/15/2011 changes');
Insert into sdsadm.STD_Institution values(1000596,NULL,NULL, 'EAFB/VA JOINT VENTURE HOSPITAL', '463CZ', 'EAFB/VA JOINT VENTURE HOSPITAL',1009122,1006840, '5955 ZEAMER AVE',NULL,NULL, 'ELMENDORF AFB',1009302,NULL, '99508',1006840, '1201 NORTH MULDOON RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504',1009224, '0',1000105,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 9:55:28 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 06/08/2010 changes');
Insert into sdsadm.STD_Institution values(1000597,NULL,NULL, 'ANCHORAGE (PUBLIC HOSPITAL)', '463DM', 'ANCHORAGE (PUBLIC HOSPITAL)',1009121,1006840, '2925 DEBARR RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99508',1006840, '1201 NORTH MULDOON RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504',1009153, '0',1000105,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:03:05 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/15/2011 changes');
Insert into sdsadm.STD_Institution values(1000598,NULL,NULL, 'ANCHORAGE (CIVILIAN HOSPITAL)', '463DS', 'ANCHORAGE (CIVILIAN HOSPITAL)',1009121,1006840, '2925 DEBARR RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99508',1006840, '1201 NORTH MULDOON RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504',1009153, '0',1000105,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:03:05 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/15/2011 changes');
Insert into sdsadm.STD_Institution values(1000600,NULL,NULL, 'KENAI VA CLINIC', '463GB', 'KENAI VA CLINIC',1009121,1006840, '11312 KENAI SPUR HWY #39',NULL,NULL, 'KENAI',1009302,NULL, '99611-9106',1006840, '11312 KENAI SPUR HWY #39',NULL,NULL, 'KENAI',1009302,NULL, '99611-9106',1009148, '0',1000105,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000601,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZFT. WAINWRIGHT (ORC)', '463HA', 'ZZFT. WAINWRIGHT (ORC)',1009121,1006840, 'Bassett Army Community Hospital (BACH)',NULL,NULL, 'Fort Wainwright',1009302,NULL, '99703',1006840, 'P.O. Box 74570',NULL,NULL, 'FAIRBANKS',1009302,NULL, '99707',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:03:05 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 03/15/2011 changes');
Insert into sdsadm.STD_Institution values(1000602,NULL,NULL, 'ANCHORAGE-PRRTP', '463PA', 'ANCHORAGE-PRRTP',1009121,1006840, '3001 C ST.',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99503-3913',1006840, '1201 NORTH MULDOON RD',NULL,NULL, 'ANCHORAGE',1009302,NULL, '99504',1009204, '0',1000105,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000603,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SIDNEY', '500BY', 'ZZ SIDNEY',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000605,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GLENS FALLS', '500GB', 'ZZ GLENS FALLS',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000607,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ALBANY CBOC', '500GD', 'ZZ ALBANY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000855,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000608,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'PLATTSBURG CBOC', '500GE', 'ZZ PLATTSBURGH',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000856,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000609,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SCHENECTADY', '500GF', 'ZZ SCHENECTADY',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000857,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000610,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TROY', '500GG', 'ZZ TROY',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000858,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000611,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CLIFTON PARK', '500GH', 'ZZ CLIFTON PARK',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000859,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000612,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ KINGSTON', '500GI', 'ZZ KINGSTON',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000860,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000613,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MALONE', '500GJ', 'ZZ MALONE',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000826,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000615,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ELIZABETHTOWN', '500HA', 'ZZ ELIZABETHTOWN',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1000827,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000618,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ALBANY-PRRTP', '500PA', 'ZZ ALBANY-PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',NULL,NULL,1000862,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000619,NULL,NULL, 'ALBUQUERQUE (NHCU)', '5019AA', 'ALBUQUERQUE (NHCU)',1009121,1006840, '1501 SAN PEDRO DRIVE S.E.',NULL,NULL, 'ALBUQUERQUE',1009335,NULL, '87108',1006840, '1501 SAN PEDRO DRIVE S.E.',NULL,NULL, 'ALBUQUERQUE',1009335,NULL, '87108',1009185, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000620,NULL,NULL, 'ALBUQUERQUE STATE DOMICILIARY', '5019AF', 'ALBUQUERQUE STATE DOMICILIARY',1009121,1006840, '992 SOUTH BROADWAY',NULL,NULL, 'TRUTH OR CONSEQUENCES',1009335,NULL, '87901',1006840, '992 SOUTH BROADWAY',NULL,NULL, 'TRUTH OR CONSEQUENCES',1009335,NULL, '87901',1009219, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000621,NULL,NULL, 'ALBUQUERQUE ARMY HOSPITAL', '501CN', 'ALBUQUERQUE ARMY HOSPITAL',1009124,1006840, 'UNKNOWN',NULL,NULL, 'ALBUQUERQUE',1009335,NULL, '87108',1006840, 'UNKNOWN',NULL,NULL, 'ALBUQUERQUE',1009335,NULL, '87108',1009226, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000622,NULL,NULL, 'TRUTH OR CONSEQUENCES (DOM)', '501DT', 'TRUTH OR CONSEQUENCES',1009121,1006840, 'PO BOX 927',NULL,NULL, 'TRUTH OR CONSEQUENCES',1009335,NULL, '87901',1006840, 'PO BOX 927',NULL,NULL, 'TRUTH OR CONSEQUENCES',1009335,NULL, '87901',1009219, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000623,NULL,NULL, 'FORT BAYARD (STATE NURSING)', '501DU', 'FORT BAYARD (STATE NURSING)',1009121,1006840, 'PO BOX 36219',NULL,NULL, 'FORT BAYARD',1009335,NULL, '88036',1006840, 'PO BOX 36219',NULL,NULL, 'FORT BAYARD',1009335,NULL, '88036',1009221, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000624,NULL,NULL, 'LAS VEGAS (CBOC)', '501G2', 'LAS VEGAS (CBOC)',1009121,1006840, '624 UNIVERSITY AVENUE',NULL,NULL, 'LAS VEGAS',1009335,NULL, '87701-4278',1006840, '624 UNIVERSITY AVENUE',NULL,NULL, 'LAS VEGAS',1009335,NULL, '87701-4278',1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000625,NULL,NULL, 'ARTESIA VA CLINIC', '501GA', 'ARTESIA VA CLINIC',1009121,1006840, '2410 WEST MAIN ST',NULL,NULL, 'ARTESIA',1009335,NULL, '88210-3716',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000626,NULL,NULL, 'FARMINGTON VA CLINIC', '501GB', 'FARMINGTON VA CLINIC',1009121,1006840, '3605 ENGLISH ROAD',NULL,NULL, 'FARMINGTON',1009335,NULL, '87402-8303',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000627,NULL,NULL, 'SILVER CITY VA CLINIC', '501GC', 'SILVER CITY VA CLINIC',1009121,1006840, '1302 EAST 32ND STREET',NULL,NULL, 'SILVER CITY',1009335,NULL, '88061-7252',1006840, '1302 EAST 32ND STREET',NULL,NULL, 'SILVER CITY',1009335,NULL, '88061-7252',1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000628,NULL,NULL, 'GALLUP VA CLINIC', '501GD', 'GALLUP VA CLINIC',1009121,1006840, '2075 NM HWY 602',NULL,NULL, 'GALLUP',1009335,NULL, '87301-9998',1006840, '520 STATE HWY 564',NULL,NULL, 'GALLUP',1009335,NULL, '87301-4873',1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 9:56:58 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0932 07/08/2015');
Insert into sdsadm.STD_Institution values(1000629,NULL,NULL, 'ESPANOLA (CBOC)', '501GE', 'ESPANOLA (CBOC)',1009121,1006840, '105 S. CORONADO ST SUITE B',NULL,NULL, 'ESPANOLA',1009335,NULL, '87532-2725',1006840, '105 S. CORONADO ST SUITE B',NULL,NULL, 'ESPANOLA',1009335,NULL, '87532-2725',1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000630,NULL,NULL, 'SANTA ROSA (CBOC)', '501GF', 'SANTA ROSA (CBOC)',1009121,1006840, '535 LAKE DRIVE',NULL,NULL, 'SANTA ROSA',1009335,NULL, '88435',1006840, '535 LAKE DRIVE',NULL,NULL, 'SANTA ROSA',1009335,NULL, '88435',1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000631,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZHOBBS (CBOC)', '501GG', 'ZZHOBBS (CBOC)',1009121,1006840, 'UNKNOWN',NULL,NULL, 'HOBBS',1009335,NULL, '88240',1006840, 'UNKNOWN',NULL,NULL, 'HOBBS',1009335,NULL, '88240',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1000632,NULL,NULL, 'TRUTH OR CONSEQUENCES (CBOC)', '501GH', 'TRUTH OR CONSEQUENCES (CBOC)',1009121,1006840, '1960 NORTH DATE STREET',NULL,NULL, 'TRUTH OR CONSEQUENCES',1009335,NULL, '87901-3701',1006840, '1960 NORTH DATE STREET',NULL,NULL, 'TRUTH OR CONSEQUENCES',1009335,NULL, '87901-3701',1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:07 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000634,NULL,NULL, 'DURANGO VA CLINIC', '501GJ', 'DURANGO VA CLINIC',1009121,1006840, '1970 E. THIRD AVE SUITE 102',NULL,NULL, 'DURANGO',1009308,NULL, '81301-6805',1006840, '1970 E. THIRD AVE SUITE 102',NULL,NULL, 'DURANGO',1009308,NULL, '81301-6805',1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000635,NULL,NULL, 'SANTA FE VA CLINIC', '501GK', 'SANTA FE VA CLINIC',1009121,1006840, '5152 BECKNER ROAD',NULL,NULL, 'SANTA FE',1009335,NULL, '87505-9998',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000636,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZGALLUP (ORC)', '501HA', 'ZZGALLUP (ORC)',1009121,1006840, '1806 EAST 66 AVENUE #5',NULL,NULL, 'GALLUP',1009335,NULL, '87301',1006840, '1806 EAST 66 AVENUE #5',NULL,NULL, 'GALLUP',1009335,NULL, '87301',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000637,NULL,NULL, 'RATON (CBOC)', '501HB', 'RATON CBOC',1009121,1006840, '1493 WHITTIER ST',NULL,NULL, 'RATON',1009335,NULL, '87740-9998',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('11/19/2014 8:26:49 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0920 10/06/2014');
Insert into sdsadm.STD_Institution values(1000638,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZSANTA ROSA', '501HC', 'ZZSANTA ROSA',1009121,1006840, '535 LAKE DRIVE',NULL,NULL, 'SANTA ROSA',1009335,NULL, '88435',1006840, '535 LAKE DRIVE',NULL,NULL, 'SANTA ROSA',1009335,NULL, '88435',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000639,NULL,NULL, 'ALBUQUERQUE/GALLUP (PRRTP)', '501PA', 'ALBUQUERQUE/GALLUP (PRRTP)',1009121,1006840, '1501 SAN PEDRO DRIVE S.E.',NULL,NULL, 'ALBUQUERQUE',1009335,NULL, '87108-5103',1006840, '1501 SAN PEDRO DRIVE S.E.',NULL,NULL, 'ALBUQUERQUE',1009335,NULL, '87108-5103',1009204, '0',1000108,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000641,NULL,NULL, 'JENNINGS CBOC', '502GA', 'JENNINGS CBOC',1009121,1006840, '1907 JOHNSON STREET',NULL,NULL, 'JENNINGS',1009322,NULL, '70546-3627',1006840, '1907 JOHNSON STREET',NULL,NULL, 'JENNINGS',1009322,NULL, '70546-3627',1009148, '0',1000109,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000642,NULL,NULL, 'LAFAYETTE VA CLINIC', '502GB', 'LAFAYETTE VA CLINIC',1009121,1006840, '2100 JEFFERSON ST',NULL,NULL, 'LAFAYETTE',1009322,NULL, '70501-5556',1006840, '2100 JEFFERSON ST',NULL,NULL, 'LAFAYETTE',1009322,NULL, '70501-5556',1009148, '0',1000109,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000643,NULL,NULL, 'ALTOONA (NHCU)', '5039AA', 'ALTOONA (NHCU)',1009121,1006840, '2907 PLEASANT VALLEY BLVD',NULL,NULL, 'ALTOONA',1009342,NULL, '16602',1006840, '2907 PLEASANT VALLEY BLVD',NULL,NULL, 'ALTOONA',1009342,NULL, '16602',1009185, '0',1000110,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000644,NULL,NULL, 'HOLIDAYSBURG (STATE DOM)', '5039AF', 'HOLIDAYSBURG (STATE DOM)',1009121,1006840,NULL,NULL,NULL, 'HOLLIDAYSBURG',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009219, '0',1000110,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000645,NULL,NULL, 'HOLLIDAYSBURG STATE VETERANS HOME', '503DT', 'HOLLIDAYSBURG (STNB)',1009121,1006840, 'PO BOX 319',NULL,NULL, 'HOLLIDAYSBURG',1009342,NULL, '16648',1006840, 'PO BOX 319',NULL,NULL, 'HOLLIDAYSBURG',1009342,NULL, '16648',1009221, '0',1000110,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000646,NULL,NULL, 'JOHNSTOWN VA CLINIC', '503GA', 'JOHNSTOWN VA CLINIC',1009121,1006840, '598 GALLERIA DRIVE',NULL,NULL, 'JOHNSTOWN',1009342,NULL, '15904-9998',1006840, '1425 SCALP AVENUE',NULL,NULL, 'JOHNSTOWN',1009342,NULL, '15904-3328',1009148, '0',1000110,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000647,NULL,NULL, 'DUBOIS CBOC', '503GB', 'DUBOIS CBOC',1009121,1006840, '5690 SHAFFER ROAD',NULL,NULL, 'DUBOIS',1009342,NULL, '15801-3870',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000110,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:16:44 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0850 03/11/2013');
Insert into sdsadm.STD_Institution values(1000648,NULL,NULL, 'STATE COLLEGE VA CLINIC', '503GC', 'STATE COLLEGE VA CLINIC',1009121,1006840, '2581 CLYDE AVE',NULL,NULL, 'STATE COLLEGE',1009342,NULL, '16801-2755',1006840, '3048 ENTERPRISE DRIVE',NULL,NULL, 'STATE COLLEGE',1009342,NULL, '16801-2755',1009148, '0',1000110,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:31:37 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0928 03/02/2015');
Insert into sdsadm.STD_Institution values(1000649,NULL,NULL, 'AMARILLO VA HEALTH CARE CENTER', '5049AA', 'AMARILLO (NHCU)',1009121,1006840, '6010 AMARILLO BLVD W',NULL,NULL, 'AMARILLO',1009348,NULL, '79106',1006840, '6010 AMARILLO BLVD W',NULL,NULL, 'AMARILLO',1009348,NULL, '79106',1009185, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000650,NULL,NULL, 'LUBBOCK OUTPATIENT CLINIC', '504BY', 'LUBBOCK',1009121,1006840, '6104 AVENUE Q SOUTH DRIVE',NULL,NULL, 'LUBBOCK',1009348,NULL, '79412-3700',1006840, '6104 AVENUE Q SOUTH DRIVE',NULL,NULL, 'LUBBOCK',1009348,NULL, '79412-3700',1009197, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000651,NULL,NULL, 'CLOVIS OUTPATIENT CLINIC', '504BZ', 'CLOVIS',1009121,1006840, '921 EAST LLANO ESTACADO BLVD',NULL,NULL, 'CLOVIS',1009335,NULL, '88101-3807',1006840, '921 EAST LLANO ESTACADO BLVD',NULL,NULL, 'CLOVIS',1009335,NULL, '88101-3807',1009197, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000652,NULL,NULL, 'REESE AFB', '504CZ', 'REESE',1009122,1006840, 'REESE AFB',NULL,NULL, 'LUBBOCK',1009348,NULL, '79416',1006840, 'REESE AFB',NULL,NULL, 'LUBBOCK',1009348,NULL, '79416',1009224, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000653,NULL,NULL, 'CHILDRESS OUTPATIENT CLINIC', '504GA', 'CHILDRESS',1009121,1006840, '1001 HWY 83 NORTH',NULL,NULL, 'CHILDRESS',1009348,NULL, '79201-2322',1006840, '1001 HWY 83 NORTH',NULL,NULL, 'CHILDRESS',1009348,NULL, '79201-2322',1009197, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000654,NULL,TO_DATE('11/2/2011' , 'mm/dd/yyyy hh:mi:ss AM'), 'LIBERAL KANSAS CBOC', '504GB', 'ZZ-LIBERAL KANSAS CBOC',1009121,1006840, '2 ROCK ISLAND ROAD STE 200',NULL,NULL, 'LIBERAL',1009320,NULL, '67901-3765',1006840, '2 ROCK ISLAND ROAD STE 200',NULL,NULL, 'LIBERAL',1009320,NULL, '67901-3765',1009148, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000655,NULL,NULL, 'CLAYTON OUTPATIENT CLINIC', '504HA', 'CLAYTON',1009121,1006840, '301 HARDING',NULL,NULL, 'CLAYTON',1009335,NULL, '88415-3321',1006840, '301 HARDING',NULL,NULL, 'CLAYTON',1009335,NULL, '88415-3321',1009197, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000656,NULL,NULL, 'STRATFORD OUTPATIENT CLINIC', '504HB', 'STRATFORD',1009121,1006840, '1220 PURNELL AVENUE',NULL,NULL, 'STRATFORD',1009348,NULL, '79084-1107',1006840, '1220 PURNELL AVENUE',NULL,NULL, 'STRATFORD',1009348,NULL, '79084-1107',1009148, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1000657,NULL,NULL, 'AMARILLO VA HEALTHCARE SYSTEM', '504PA', 'AMARILLO (PRRTP)',1009121,1006840, '6010 Amarillo Blvd. W',NULL,NULL, 'Amarillo',1009348,NULL, '79106-1990',1006840, '6010 AMARILLO BLVD W',NULL,NULL, 'AMARILLO',1009348,NULL, '79106-1990',1009212, '0',1000111,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000658,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ AMERICAN LAKE NHC', '5059AA', 'ZZ AMERICAN LAKE NHC',1009121,1006840,NULL,NULL,NULL, 'AMERICAN LAKE',1009353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000659,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ AMERICAN LAKE (DOM)', '505BU', 'ZZ AMERICAN LAKE (DOM)',1009121,1006840,NULL,NULL,NULL, 'AMERICAN LAKE',1009353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000660,NULL,TO_DATE('4/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MADIGAN USAH', '505CN', 'ZZ MADIGAN USAH',1009124,1006840,NULL,NULL,NULL, 'TACOMA',1009353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,1001819,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000661,NULL,NULL, 'ANN ARBOR NURSING HOME', '5069AA', 'ANN ARBOR NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'ANN ARBOR',1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000113,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000662,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TOLEDO', '506BY', 'ZZ TOLEDO',1009121,1006840,NULL,NULL,NULL, 'ANN ARBOR',1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1000663,NULL,NULL, 'TOLEDO VA CLINIC', '506GA', 'TOLEDO VA CLINIC',1009121,1006840, '1200 S. DETROIT AVE',NULL,NULL, 'TOLEDO',1009339,NULL, '43614-2426',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000113,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000664,NULL,NULL, 'FLINT VA CLINIC', '506GB', 'FLINT VA CLINIC',1009121,1006840, 'G2360 SOUTH LINDEN ROAD',NULL,NULL, 'FLINT',1009326,NULL, '48532-3615',1006840,NULL,NULL,NULL,NULL,NULL,1011292,NULL,1009148, '0',1000113,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000665,NULL,NULL, 'JACKSON CBOC', '506GC', 'JACKSON MI CBOC',1009121,1006840, '4328 PAGE AVE',NULL,NULL, 'MICHIGAN CENTER',1009326,NULL, '49254-1077',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000113,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:17:19 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0857 5/6/2013');
Insert into sdsadm.STD_Institution values(1000666,NULL,NULL, 'ATLANTA NURSING HOME', '5089AA', 'ATLANTA VA COMM LIVING CTR',1009121,1006840, '1670 CLAIRMONT ROAD',NULL,NULL, 'DECATUR',1009313,NULL, '30033',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000114,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:31:37 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0928 03/02/2015');
Insert into sdsadm.STD_Institution values(1000667,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ATLANTA (ARMY HOSP)', '508CN', 'ZZ ATLANTA (ARMY HOSP)',1009124,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000668,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ATLANTA (USAF)', '508CZ', 'ZZ ATLANTA (USAF)',1009122,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000670,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ATLANTA NORTHEAST CORRIDOR', '508GB', 'ZZ ATLANTA NORTHEAST CORRIDOR',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000671,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BUFORD', '508GC', 'ZZ BUFORD',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000672,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ DAWSONVILLE', '508GD', 'ZZ DAWSONVILLE',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000673,NULL,NULL, 'OAKWOOD VA CLINIC', '508GE', 'OAKWOOD VA CLINIC',1009121,1006840, '4175 TANNERS CREEK DR',NULL,NULL, 'FLOWERY BRANCH',1009313,NULL, '30542-2816',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000114,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1000676,NULL,NULL, 'ATL-PRRTP', '508PA', 'ATL-PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',1000114,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000677,NULL,NULL, 'AUGUSTA NURSING HOME', '5099AA', 'AUGUSTA NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'AUGUSTA',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000115,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000678,NULL,NULL, 'AUGUSTA (STATE HOME)', '5099AF', 'AUGUSTA (STATE HOME)',1009121,1006840,NULL,NULL,NULL, 'AUGUSTA',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000115,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000679,NULL,NULL, 'AUGUSTA VAMC - UPTOWN', '509A0', 'AUGUSTA UPTOWN',1009121,1006840, '1 FREEDOM WAY',NULL,NULL, 'AUGUSTA',1009313,NULL, '30904-6285',1006840, '1 FREEDOM WAY',NULL,NULL, 'AUGUSTA',1009313,NULL, '30904-6285',1009231, '0',1000115,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1000680,NULL,NULL, 'AUGUSTA (ARMY HOSP)', '509CS', 'AUGUSTA (ARMY HOSP)',1009124,1006840,NULL,NULL,NULL, 'AUGUSTA',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',1000115,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000681,NULL,NULL, 'AUGUSTA (PUBLIC HOSP)', '509DM', 'AUGUSTA (PUBLIC HOSP)',1009121,1006840,NULL,NULL,NULL, 'AUGUSTA',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',1000115,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000683,NULL,NULL, 'BALTIMORE NURSING HOME', '5129AA', 'BALTIMORE NURSING HOME',1009121,1006840, '3900 LOCH RAVEN BLVD',NULL,NULL, 'BALTIMORE',1009324,NULL, '21218',1006840, '3900 LOCH RAVEN BLVD',NULL,NULL, 'BALTIMORE',1009324,NULL, '21218',1009185, '0',1000116,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000687,NULL,NULL, 'PERRY POINT DOM', '512BU', 'PERRY POINT DOM',1009121,1006840, '601 Perryville Drive',NULL,NULL, 'PERRY POINT',1009324,NULL, '21902-1111',1006840, '601 Perryville Drive',NULL,NULL, 'PERRY POINT',1009324,NULL, '21902-1111',1009158, '0',1002141,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000688,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZBALTIMORE (SOC)', '512BY', 'ZZBALTIMORE (SOC)',1009121,1006840, 'NA',NULL,NULL, 'BALTIMORE',1009324,NULL, '21201',1006840, 'NA',NULL,NULL, 'BALTIMORE',1009324,NULL, '21201',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000689,NULL,NULL, 'FORT MEADE', '512CN', 'FORT MEADE',1009124,1006840, 'FORT MEADE',NULL,NULL, 'FORT MEADE',1009324,NULL, '20755',1006840, 'FORT MEADE',NULL,NULL, 'FORT MEADE',1009324,NULL, '20755',1009226, '0',1002141,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000692,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZBALTIMORE SVH', '512DT', 'ZZBALTIMORE SVH',1009121,1006840, 'NA',NULL,NULL, 'PERRYVILLE',1009324,NULL, '21902',1006840, 'PERRYVILLE',NULL,NULL, 'PERRY POINT',1009324,NULL, '21902',1009222, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000693,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CAMBRIDGE VA CLINIC', '512GA', 'CAMBRIDGE VA CLINIC',1009121,1006840, '830 CHESAPEAKE DR',NULL,NULL, 'CAMBRIDGE',1009324,NULL, '21613-9408',1006840, '830 CHESAPEAKE DR',NULL,NULL, 'CAMBRIDGE',1009324,NULL, '21613-9408',1009148, '0',1000116,1001644,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000694,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZCHARLOTTE HALL', '512GB', 'ZZCHARLOTTE HALL',1009121,1006840, 'NA',NULL,NULL, 'CHARLOTTE HALL',1009324,NULL, '20622',1006840, 'NA',NULL,NULL, 'CHARLOTTE HALL',1009324,NULL, '20622',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000695,NULL,NULL, 'GLEN BURNIE VA CLINIC', '512GC', 'GLEN BURNIE VA CLINIC',1009121,1006840, '808 LANDMARK DR #128',NULL,NULL, 'GLEN BURNIE',1009324,NULL, '21061-4983',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000116,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000696,NULL,NULL, 'LOCH RAVEN VA CLINIC', '512GD', 'LOCH RAVEN VA CLINIC',1009121,1006840, '3901 THE ALAMEDA',NULL,NULL, 'BALTIMORE',1009324,NULL, '21218-2100',1006840, '3901 THE ALAMEDA',NULL,NULL, 'BALTIMORE',1009324,NULL, '21218-2100',1009148, '0',1000116,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000697,NULL,NULL, 'POCOMOKE CITY VA CLINIC', '512GE', 'POCOMOKE CITY VA CLINIC',1009121,1006840, '1701 MARKET PLACE #211',NULL,NULL, 'POCOMOKE CITY',1009324,NULL, '21851-1738',1006840, '101 MARKET STREET',NULL,NULL, 'POCOMOKE CITY',1009324,NULL, '21851-1042',1009148, '0',1000116,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000698,NULL,NULL, 'FORT HOWARD VA CLINIC', '512GF', 'FORT HOWARD VA CLINIC',1009121,1006840, '9600 N. POINT ROAD',NULL,NULL, 'FORT HOWARD',1009324,NULL, '21052-3050',1006840, '9400 N. POINT ROAD',NULL,NULL, 'FORT HOWARD',1009324,NULL, '21052-3050',1009148, '0',1000116,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000699,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZBALTIMORE MOBILE OUTREACH', '512HK', 'ZZBALTIMORE MOBILE OUTREACH',1009121,1006840, '9300 N. POINT ROAD',NULL,NULL, 'FORT HOWARD',1009324,NULL, '21052',1006840, '9300 N. POINT ROAD',NULL,NULL, 'FORT HOWARD',1009324,NULL, '21052',1009177, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000701,NULL,NULL, 'PERRY POINT PRRTP', '512PC', 'PERRY POINT PRRTP',1009121,1006840, '601 Perryville Drive',NULL,NULL, 'PERRY POINT',1009324,NULL, '21902-1111',1006840, '601 Perryville Drive',NULL,NULL, 'PERRY POINT',1009324,NULL, '21902-1111',1009204, '0',1002141,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000702,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'BALTIMORE PRRP', '512PD', 'ZZ BALTIMORE PRRP',1009121,1006840, '10 NORTH GREENE STREET',NULL,NULL, 'BALTIMORE',1009324,NULL, '21201',1006840, '10 NORTH GREENE STREET',NULL,NULL, 'BALTIMORE',1009324,NULL, '21201',1009204, '0',NULL,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000703,NULL,TO_DATE('8/11/2004' , 'mm/dd/yyyy hh:mi:ss AM'), 'PERRY POINT COMP WORK THERAPY/TR', '512PE', 'ZZ PERRY POINT CWT/TR',1009121,1006840, '601 Perryville  Drive',NULL,NULL, 'PERRY POINT',1009324,NULL, '21902',1006840, '601 Perryville Drive',NULL,NULL, 'PERRY POINT',1009324,NULL, '21902',1009199, '0',NULL,NULL,1002231,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1000704,NULL,TO_DATE('1/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ROCHESTER', '513BZ', 'ZZ ROCHESTER',1009121,1006840,NULL,NULL,NULL, 'BATAVIA',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1000823,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000705,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BATH (DOM)', '514BU', 'ZZ BATH (DOM)',1009121,1006840,NULL,NULL,NULL, 'BATH',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1000822,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000706,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ELMIRA', '514GA', 'ZZ ELMIRA',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000829,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000707,NULL,NULL, 'BATTLE CREEK NH', '5159AA', 'BATTLE CREEK NURSING HOME',1009121,1006840, '5500 ARMSTRONG ROAD',NULL,NULL, 'BATTLE CREEK',1009326,NULL, '49015',1006840, '5500 ARMSTRONG RD',NULL,NULL, 'BATTLE CREEK',1009326,NULL, '49015',1009185, '0',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000708,NULL,NULL, 'WYOMING HEALTH CARE CENTER', '515BY', 'WYOMING HEALTH CARE CENTER',1009121,1006840, '5838 METRO WAY S.W.',NULL,NULL, 'WYOMING',1009326,NULL, '49519-9998',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000119,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:31:37 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0928 03/02/2015');
Insert into sdsadm.STD_Institution values(1000709,NULL,NULL, 'GRAND RAPIDS STATE HOME', '515DT', 'GRAND RAPIDS STATE HOME',1009121,1006840, 'MILITARY AFFAIRS',NULL,NULL, 'LANSING',1009326,NULL, '48901',1006840, 'MILITARY AFFAIRS',NULL,NULL, 'LANSING',1009326,NULL, '48901',1009221, '0',1000119,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000710,NULL,NULL, 'MUSKEGON VA CLINIC', '515GA', 'MUSKEGON VA CLINIC',1009121,1006840, '5000 HAKES DRIVE',NULL,NULL, 'MUSKEGON',1009326,NULL, '49441-5574',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000119,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000711,NULL,NULL, 'LANSING CBOC', '515GB', 'LANSING SOUTH VA CLINIC',1009121,1006840, '2025 S WASHINGTON AVE',NULL,NULL, 'EAST LANSING',1009326,NULL, '48910-0828',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000119,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000712,NULL,NULL, 'BENTON HARBOR VA CLINIC', '515GC', 'BENTON HARBOR VA CLINIC',1009121,1006840, '115 MAIN ST',NULL,NULL, 'BENTON HARBOR',1009326,NULL, '49022-3663',1006840, '115 MAIN ST',NULL,NULL, 'BENTON HARBOR',1009326,NULL, '49022-3663',1009148, '0',1000119,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000713,NULL,NULL, 'BATTLE CREEK PRRTP', '515PA', 'BATTLE CREEK-PRRTP',1009121,1006840, '5500 ARMSTRONG ROAD',NULL,NULL, 'BATTLE CREEK',1009326,NULL, '49037-7314',1006840, '55 ARMSTRONG ROAD',NULL,NULL, 'BATTLE CREEK',1009326,NULL, '49037-7314',1009204, '0',1002211,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000714,NULL,NULL, 'BAY PINES NURSING HOME', '5169AA', 'BAY PINES NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BAY PINES',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000715,NULL,NULL, 'BAY PINES DOMICILIARY', '516BU', 'BAY PINES DOMICILIARY',1009121,1006840, '10000 BAY PINES BLVD',NULL,NULL, 'ST PETERSBURG',1009312,NULL, '33744-8298',1006840, 'DOMICILARY OPERATIONS',NULL,NULL, 'BAY PINES',1009312,NULL, '33744-8298',1009158, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000716,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZST PETERSBURG OPC', '516BY', 'ZZST PETERSBURG OPC',1009121,1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000717,NULL,NULL, 'LEE COUNTY VA CLINIC', '516BZ', 'LEE COUNTY VA CLINIC',1009121,1006840, '2489 DIPLOMAT PARKWAY EAST',NULL,NULL, 'CAPE CORAL',1009312,NULL, '33909-5422',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000718,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZORLANDO USNH', '516CT', 'ZZORLANDO USNH',1009121,1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000719,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZPENSACOLA', '516CU', 'PENSACOLA NAVAL HOSPITAL',1009121,1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:14:32 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/28/07 changes');
Insert into sdsadm.STD_Institution values(1000720,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZJACKSONVILLE NAVY HOSP', '516CV', 'ZZJACKSONVILLE NAVY HOSP',1009121,1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000721,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZST PETERSBURG AFB', '516CZ', 'ZZST PETERSBURG AFB',1009121,1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1006840, 'ZZ',NULL,NULL, 'ZZ',1009312,NULL, '11111',1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000722,NULL,NULL, 'SARASOTA COUNTY CBOC', '516GA', 'SARASOTA COUNTY CBOC',1009121,1006840, '5682 BEE RIDGE ROAD',NULL,NULL, 'SARASOTA',1009312,NULL, '34233-1500',1006840, '5682 BEE RIDGE ROAD',NULL,NULL, 'SARASOTA',1009312,NULL, '34233-1500',1009148, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000723,NULL,NULL, 'ST. PETERSBURG VA CLINIC', '516GB', 'ST. PETERSBURG VA CLINIC',1009121,1006840, '840 DR MLK JR STREET NORTH',NULL,NULL, 'ST PETERSBURG',1009312,NULL, '33705-1214',1006840, '840 DR MLK JR STREET NORTH',NULL,NULL, 'ST PETERSBURG',1009312,NULL, '33705-1214',1009148, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000724,NULL,NULL, 'PALM HARBOR VA CLINIC', '516GC', 'PALM HARBOR VA CLINIC',1009121,1006840, '35209 US HWY 19 NORTH',NULL,NULL, 'PALM HARBOR',1009312,NULL, '34684-1908',1006840, '35209 US HWY 19 NORTH',NULL,NULL, 'PALM HARBOR',1009312,NULL, '34684-1908',1009148, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000725,NULL,NULL, 'BRADENTON VA CLINIC', '516GD', 'BRADENTON VA CLINIC',1009121,1006840, '5520 S.R. 64',NULL,NULL, 'BRADENTON',1009312,NULL, '34208-5526',1006840, '5520 S.R. 64',NULL,NULL, 'BRADENTON',1009312,NULL, '34208-5526',1009148, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000727,NULL,NULL, 'NAPLES VA CLINIC', '516GF', 'NAPLES VA CLINIC',1009121,1006840, '2685 HORSESHOE DR S',NULL,NULL, 'NAPLES',1009312,NULL, '34104-6113',1006840, '2685 HORSESHOE DR S',NULL,NULL, 'NAPLES',1009312,NULL, '34104-6113',1009148, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000728,NULL,NULL, 'SEBRING VA CLINIC', '516GH', 'SEBRING VA CLINIC',1009121,1006840, '5901 US HIGHWAY 27 SOUTH',NULL,NULL, 'SEBRING',1009312,NULL, '33870-2117',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000120,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000729,NULL,NULL, 'BAY PINES-PRRTP', '516PA', 'BAY PINES-PRRTP',1009121,1006840, '10000 BAY PINES BLVD',NULL,NULL, 'ST PETERSBURG',1009312,NULL, '33744-8298',1006840, 'PO BOX 5005',NULL,NULL, 'BAY PINES',1009312,NULL, '33744-8298',1009204, '0',1002208,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000730,NULL,NULL, 'BECKLEY NURSING HOME', '5179AA', 'BECKLEY NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BECKLEY',1009354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000121,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000731,NULL,NULL, 'GASSAWAY CBOC', '517GA', 'GASSAWAY',1009121,1006840, '617 RIVER STREET',NULL,NULL, 'GASSAWAY',1009354,NULL, '26624',1006840, '617 RIVER STREET',NULL,NULL, 'GASSAWAY',1009354,NULL, '26624',1009148, '0',1000121,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000732,NULL,NULL, 'BEDFORD NURSING HOME', '5189AA', 'BEDFORD NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BEDFORD',1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000733,NULL,NULL, 'BEDFORD DOMICILIARY 518BU', '518BU', 'BEDFORD DOMICILIARY',1009121,1006840, '200 SPRINGS ROAD',NULL,NULL, 'BEDFORD',1009325,NULL, '01730-1114',1006840, '200 SPRINGS ROAD',NULL,NULL, 'BEDFORD',1009325,NULL, '01730-1114',1009158, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000734,NULL,NULL, 'LYNN VA CLINIC', '518GA', 'LYNN VA CLINIC',1009121,1006840, '225 BOSTON STREET',NULL,NULL, 'LYNN',1009325,NULL, '01904-3135',1006840, '225 BOSTON STREET',NULL,NULL, 'LYNN',1009325,NULL, '01905-3137',1009148, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/11/2015 11:19:34 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0935 10/07/2015');
Insert into sdsadm.STD_Institution values(1000735,NULL,NULL, 'HAVERHILL VA CLINIC', '518GB', 'HAVERHILL VA CLINIC',1009121,1006840, '108 MERRIMACK STREET',NULL,NULL, 'HAVERHILL',1009325,NULL, '01830-5210',1006840, '108 MERRIMACK STREET',NULL,NULL, 'HAVERHILL',1009325,NULL, '01830-5210',1009148, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/11/2015 11:19:34 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0935 10/07/2015');
Insert into sdsadm.STD_Institution values(1000736,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-LOWELL VCCC', '518GD', 'ZZ-LOWELL VCCC',1009121,1006840, '130 MARSHALL ROAD',NULL,NULL, 'LOWELL',1009325,NULL, '01852-5130',1006840, '130 MARSHALL ROAD',NULL,NULL, 'BEDFORD',1009325,NULL, '01852-5130',1009148, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000737,NULL,NULL, 'GLOUCESTER VA CLINIC', '518GE', 'GLOUCESTER VA CLINIC',1009121,1006840, '298 WASHINGTON STREET',NULL,NULL, 'GLOUCESTER',1009325,NULL, '01930-4832',1006840, '298 WASHINGTON STREET',NULL,NULL, 'GLOUCESTER',1009325,NULL, '01930-4832',1009148, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/11/2015 11:19:34 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0935 10/07/2015');
Insert into sdsadm.STD_Institution values(1000738,NULL,NULL, 'FITCHBURG CBOC', '518GG', 'FITCHBURG CBOC',1009121,1006840, '275 NICHOLS ROAD',NULL,NULL, 'FITCHBURG',1009325,NULL, '01420-1931',1006840, '275 NICHOLS ROAD',NULL,NULL, 'FITCHBURG',1009325,NULL, '01420-1931',1009148, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000739,NULL,NULL, 'BEDFORD-PRRTP', '518PA', 'BEDFORD-PRRTP',1009121,1006840, '200 SPRINGS ROAD',NULL,NULL, 'BEDFORD',1009325,NULL, '01730-1114',1006840, '200 SPRINGS ROAD',NULL,NULL, 'BEDFORD',1009325,NULL, '01730-1114',1009204, '0',1000122,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000740,NULL,NULL, 'BIG SPRING NHC', '5199AA', 'BIG SPRING',1009121,1006840, '300 WEST VETERANS BLVD',NULL,NULL, 'BIG SPRING',1009348,NULL, '79720',1006840, '300 WEST VETERANS BLVD',NULL,NULL, 'BIG SPRING',1009348,NULL, '79720',1009185, '0',1000123,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000741,NULL,NULL, 'LLS-SVH', '519DT', 'LAMUN LUSK SANCHEZ ST VET HOME',1009121,1006840, '1809 North Hwy. 87',NULL,NULL, 'Big Spring',1009348,NULL, '79720',1006840, '1809 North Hwy 87',NULL,NULL, 'Big Spring',1009348,NULL, '79720',1009222, '0',1000123,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000742,NULL,NULL, 'PERMIAN BASIN CBOC', '519GA', 'PERMIAN BASIN CBOC',1009121,1006840, '8050 E. HIGHWAY 191',NULL,NULL, 'ODESSA',1009348,NULL, '79765-8613',1006840, '8050 E. HIGHWAY 191',NULL,NULL, 'ODESSA',1009348,NULL, '79765-8610',1009148, '0',1000123,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/2/2014 11:20:28 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0904 05/13/2014');
Insert into sdsadm.STD_Institution values(1000743,NULL,NULL, 'HOBBS CBOC', '519GB', 'HOBBS',1009121,1006840, '1601 N TURNER BROADMOOR TOWER',NULL,NULL, 'HOBBS',1009335,NULL, '88240-4331',1006840, '1601 N TURNER BROADMOOR TOWER',NULL,NULL, 'HOBBS',1009335,NULL, '88240-4331',1009148, '0',1000123,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000744,NULL,NULL, 'FT. STOCKTON CBOC', '519GD', 'FT STOCKTON CBOC',1009121,1006840, '2071 NORTH MAIN',NULL,NULL, 'FT STOCKTON',1009348,NULL, '79735-3041',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000123,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:17:19 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0857 5/6/2013');
Insert into sdsadm.STD_Institution values(1000745,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MONAHANS', '519GE', 'ZZ MONAHANS',1009121,1006840, 'NA',NULL,NULL, 'MONAHANS',1009348,NULL, '79756',1006840, 'na',NULL,NULL, 'MONAHANS',1009348,NULL, '79756',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000746,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'SAN ANGELO CBOC', '519GF', 'ZZ SAN ANGELO',1009121,1006840, '2018 PULLIAM',NULL,NULL, 'SAN ANGELO',1009348,NULL, '76905',1006840, '2018 PULLIUM',NULL,NULL, 'SAN ANGELO',1009348,NULL, '76905',1009148, '0',NULL,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000747,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ABILENE CBOC', '519HA', 'ZZ ABILENE',1009121,1006840, '4225 WOODS PLACE',NULL,NULL, 'ABILENE',1009348,NULL, '79602',1006840, '4225 WOODS PLACE',NULL,NULL, 'ABILENE',1009348,NULL, '79602',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000748,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'PECOS COUNTY MEMORIAL HOSPITAL', '519HB', 'ZZ FT. STOCKTON CBOC',1009121,1006840, 'PECOS COUNTY MEMORIAL HOSPITAL',NULL,NULL, 'FT. STOCKTON',1009348,NULL, '79735',1006840, 'PECOS COUNTY MEMORIAL HOSPITAL',NULL,NULL, 'FT. STOCKTON',1009348,NULL, '79735',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000750,NULL,NULL, 'STAMFORD CBOC', '519HD', 'STAMFORD CBOC',1009121,1006840, '1601 COLUMBIA ST',NULL,NULL, 'STAMFORD',1009348,NULL, '79553-6863',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000123,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000752,NULL,NULL, 'BILOXI NURSING HOME', '5209AA', 'BILOXI NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BILOXI',1009328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000753,NULL,NULL, 'GULFPORT VAMC', '520A0', 'GULFPORT DIV',1009121,1006840, '200 E Beach Blvd',NULL,NULL, 'GULFPORT',1009328,NULL, '39507',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/11/2015 11:19:34 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0935 10/07/2015');
Insert into sdsadm.STD_Institution values(1000754,NULL,NULL, 'BILOXI DOMICILIARY', '520BU', 'BILOXI DOMICILIARY',1009121,1006840, '400 Veterans Ave',NULL,NULL, 'BILOXI',1009328,NULL, '39531-2410',1006840, '400 Veterans Ave',NULL,NULL, 'BILOXI',1009328,NULL, '39531-2410',1009158, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000755,NULL,NULL, 'BILOXI OPC', '520BY', 'BILOXI (OCS)',1009121,1006840, '400 Veterans Ave',NULL,NULL, 'BILOXI',1009328,NULL, '39531-2410',1006840, '400 Veterans Ave',NULL,NULL, 'BILOXI',1009328,NULL, '39531-2410',1009197, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000756,NULL,NULL, 'PENSACOLA VA CLINIC', '520BZ', 'PENSACOLA VA CLINIC',1009121,1006840, '790 VETERANS WAY',NULL,NULL, 'PENSACOLA',1009312,NULL, '32507-1000',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000757,NULL,NULL, 'GULFPORT (PHARM)', '520CA', 'GULFPORT (PHARM)',1009121,1006840, '200 E Beach Blvd',NULL,NULL, 'GULFPORT',1009328,NULL, '39507',1006840, '200 E Beach Blvd',NULL,NULL, 'GULFPORT',1009328,NULL, '39507',1009201, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000758,NULL,NULL, 'BILOXI (PHARM)', '520CB', 'BILOXI (PHARM)',1009121,1006840, '400 Veterans Ave',NULL,NULL, 'BILOXI',1009328,NULL, '39531',1006840, '400 Veterans Ave',NULL,NULL, 'BILOXI',1009328,NULL, '39531',1009201, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000759,NULL,NULL, 'MOBILE OPC', '520GA', 'MOBILE OPC',1009121,1006840, '1504 SPRINGHILL AVE',NULL,NULL, 'MOBILE',1009301,NULL, '36604-3207',1006840, '1504 SPRINGHILL AVE',NULL,NULL, 'MOBILE',1009301,NULL, '36604-3207',1009197, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000760,NULL,NULL, 'PANAMA CITY BEACH VA CLINIC', '520GB', 'PANAMA CITY BEACH VA CLINIC',1009121,1006840, '101 VERNON AVE',NULL,NULL, 'PANAMA CITY',1009312,NULL, '32407-7001',1006840, '101 VERNON AVE',NULL,NULL, 'PANAMA CITY',1009312,NULL, '32407-7001',1009148, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000761,NULL,NULL, 'GULFPORT PRRTP', '520PA', 'PRRTP',1009121,1006840, '400 Veterans Blvd',NULL,NULL, 'BILOXI',1009328,NULL, '39531-2410',1006840, '400 Veterans Blvd',NULL,NULL, 'BILOXI',1009328,NULL, '39531-2410',1009204, '0',1000124,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000762,NULL,NULL, 'BIRMINGHAM NURSING HOME', '5219AA', 'BIRMINGHAM NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BIRMINGHAM',1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000763,NULL,NULL, 'BIRMINGHAM DENTAL', '521BY', 'BIRMINGHAM DENTAL',1009121,1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233',1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233',1009160, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000764,NULL,NULL, 'HUNTSVILLE (STNB)', '521DT', 'COLONEL ROBERT L HOWARD SVH',1009121,1006840, '7054 VETERANS PARKWAY',NULL,NULL, 'PELL CITY',1009301,NULL, '35125',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009222, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('7/8/2014 7:27:25 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0909 06/09/2014');
Insert into sdsadm.STD_Institution values(1000765,NULL,NULL, 'ALEXANDER CITY', '521DU', 'ALEXANDER CITY',1009121,1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233',1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233',1009221, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000766,NULL,NULL, 'BAY MINETTE', '521DV', 'BAY MINETTE (521DV)',1009121,1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233',1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233',1009221, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000769,NULL,NULL, 'FLORENCE CBOC', '521GC', 'FLORENCE',1009121,1006840, '422 COX BLVD DD',NULL,NULL, 'Sheffield',1009301,NULL, '35660-4000',1006840, '422 COX BLVD DD',NULL,NULL, 'Sheffield',1009301,NULL, '35660-4000',1009148, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000770,NULL,NULL, 'RAINBOW CITY CBOC', '521GD', 'RAINBOW CITY CBOC',1009121,1006840, '206 RESCIA AVE',NULL,NULL, 'GADSDEN',1009301,NULL, '35906-5933',1006840, '206 RESCIA AVE',NULL,NULL, 'GADSDEN',1009301,NULL, '35906-5933',1009148, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000771,NULL,NULL, 'ANNISTON CBOC', '521GE', 'ANNISTON',1009121,1006840, '96 ALI WAY',NULL,NULL, 'Oxford',1009301,NULL, '36203-1835',1006840, '96 ALI WAY',NULL,NULL, 'Oxford',1009301,NULL, '36203-1835',1009148, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000772,NULL,NULL, 'JASPER VA CLINIC', '521GF', 'JASPER VA CLINIC',1009121,1006840, '1454 JONES DAIRY RD',NULL,NULL, 'JASPER',1009301,NULL, '35501-6164',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 9:56:58 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0932 07/08/2015');
Insert into sdsadm.STD_Institution values(1000773,NULL,NULL, 'BIRMINGHAM PRRTP', '521PA', 'BIRMINGHAM PRRTP',1009121,1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233-1927',1006840, '700 South 19th Street',NULL,NULL, 'Birmingham',1009301,NULL, '35233-1927',1009204, '0',1000125,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000774,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BONHAM (NHCU)', '5229AA', 'ZZ BONHAM (NHCU)',1009121,1006840,NULL,NULL,NULL, 'BONHAM',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000775,NULL,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BONHAM DOM', '522BU', 'ZZ BONHAM DOM',1009121,1006840,NULL,NULL,NULL, 'BONHAM',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1000997,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000776,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BONHAM (CIVH)', '522DS', 'ZZ BONHAM (CIVH)',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000777,NULL,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BONHAM (DOM)', '522EX', 'ZZ BONHAM (DOM)',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1001001,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000778,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'BOSTON NURSING HOME', '5239AA', 'ZZBOSTON NURSING HOME',1009121,1006840, 'ZZINACTIVE',NULL,NULL, 'BOSTON',1009325,NULL, '2130',1006840, 'ZZINACTIVE',NULL,NULL, 'BOSTON',1009325,NULL, '2130',1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000779,TO_DATE('7/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'VA BOSTON HEALTHCARE SYSTEM - WEST ROXBURY DIVISION', '523A4', 'WEST ROXBURY',1009121,1006840, '1400 VFW PARKWAY',NULL,NULL, 'WEST ROXBURY',1009325,NULL, '02132-4927',1006840, '1400 VFW PARKWAY',NULL,NULL, 'WEST ROXBURY',1009325,NULL, '02132-4927',1009231, '0',1000127,1000792,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000780,TO_DATE('7/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'VA BOSTON HEALTHCARE SYSTEM - BROCKTON DIVISION', '523A5', 'BROCKTON VAMC',1009121,1006840, '940 BELMONT STREET',NULL,NULL, 'BROCKTON',1009325,NULL, '02301-5596',1006840, '940 BELMONT STREET',NULL,NULL, 'BROCKTON',1009325,NULL, '02301-5596',1009231, '0',1000127,1000129,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000781,TO_DATE('7/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'VA BOSTON HEALTHCARE SYSTEM - BROCKTON DOMICILARY', '523BU', 'BROCKTON DOM',1009121,1006840, '940 BELMONT STREET',NULL,NULL, 'BROCKTON',1009325,NULL, '02301-5596',1006840, '940 BELMONT STREET',NULL,NULL, 'BROCKTON',1009325,NULL, '02301-5596',1009158, '0',1000127,1000793,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000782,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - LOWELL DIVISION', '523BY', 'LOWELL OPC',1009121,1006840, '130 MARSHALL ROAD',NULL,NULL, 'LOWELL',1009325,NULL, '01852-5130',1006840, '130 MARSHALL ROAD',NULL,NULL, 'LOWELL',1009325,NULL, '01852-5130',1009197, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000783,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - BOSTON OPC DIVISION', '523BZ', 'BOSTON SOC',1009121,1006840, '251 CAUSEWAY STREET',NULL,NULL, 'BOSTON',1009325,NULL, '02114-2148',1006840, '251 CAUSEWAY STREET',NULL,NULL, 'BOSTON',1009325,NULL, '02114-2148',1009197, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000784,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - CHELSEA SOLDIERS HOME', '523DT', 'CHELSEA',1009121,1006840, '91 CREST AVENUE',NULL,NULL, 'CHELSEA',1009325,NULL, '2150',1006840, '91 CREST AVENUE',NULL,NULL, 'CHELSEA',1009325,NULL, '2150',1009221, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000785,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - FRAMINGHAM CBOC', '523GA', 'FRAMINGHAM',1009121,1006840, '61 LINCOLN STREET',NULL,NULL, 'FRAMINGHAM',1009325,NULL, '01702-8264',1006840, '61 LINCOLN STREET',NULL,NULL, 'FRAMINGHAM',1009325,NULL, '01702-8264',1009148, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000786,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - WORCESTER DIVISION', '523GB', 'WORCESTER',1009121,1006840, '605 LINCOLN STREET',NULL,NULL, 'WORCESTER',1009325,NULL, '01605-1901',1006840, '605 LINCOLN STREET',NULL,NULL, 'WORCESTER',1009325,NULL, '01605-1901',1009148, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000787,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - QUINCY CBOC', '523GC', 'QUINCY',1009121,1006840, '110 WEST SQUANTAM ST',NULL,NULL, 'QUINCY',1009325,NULL, '2171',1006840, '110 WEST SQUANTAM ST',NULL,NULL, 'QUINCY',1009325,NULL, '2171',1009148, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 9:56:58 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0932 07/08/2015');
Insert into sdsadm.STD_Institution values(1000788,NULL,NULL, 'PLYMOUTH CBOC', '523GD', 'PLYMOUTH CBOC',1009121,1006840, '116 LONG POND ROAD',NULL,NULL, 'PLYMOUTH',1009325,NULL, '02360-2663',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000789,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - DORCHESTER CBOC', '523GE', 'DORCHESTER',1009121,1006840, '895 BLUE HILL AVE',NULL,NULL, 'DORCHESTER',1009325,NULL, '02121-2902',1006840, '895 BLUE HILL AVE',NULL,NULL, 'DORCHESTER',1009325,NULL, '02121-2902',1009148, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000790,NULL,NULL, 'VA BOSTON HEALTHCARE SYSTEM - BOSTON PRRTP', '523PA', 'BOSTON PRRTP',1009121,1006840, '150 SOUTH HUNTINGTON AVE',NULL,NULL, 'BOSTON',1009325,NULL, '02130-4893',1006840, '150 SOUTH HUNTINGTON AVE',NULL,NULL, 'BOSTON',1009325,NULL, '02130-4893',1009204, '0',1000127,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1000791,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WEST ROXBURY VANPH', '525A0', 'ZZ WEST ROXBURY VANPH',1009121,1006840,NULL,NULL,NULL,NULL,1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009233, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000792,NULL,TO_DATE('7/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WEST ROXBURY VAMC', '525A4', 'ZZ WEST ROXBURY VAMC',1009121,1006840, 'West Roxbury Division',NULL,NULL, 'WEST ROXBURY',1009325,NULL, '2132',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1000779,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000793,NULL,TO_DATE('7/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROCKTON DOM', '525BU', 'ZZ BROCKTON DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1000781,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000794,NULL,TO_DATE('7/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WORCHESTER SOC', '525BY', 'ZZ WORCHESTER SOC',1009121,1006840,NULL,NULL,NULL, 'BROCKTON',1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000795,NULL,NULL, 'BRONX VA NURSING HOME CARE UNIT', '5269AA', 'BRONX (NHCU)',1009121,1006840, '130 W. KINGSBRIDGE ROAD',NULL,NULL, 'BRONX',1009336,NULL, '10468',1006840, '130 W. KINGSBRIDGE ROAD',NULL,NULL, 'BRONX',1009336,NULL, '10468',1009185, '0',1000130,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000796,NULL,NULL, 'WHITE PLAINS CLINIC', '526GA', 'WHITE PLAINS CBOC',1009121,1006840, '23 SOUTH BROADWAY',NULL,NULL, 'WHITE PLAINS',1009336,NULL, '10601-3503',1006840, '23 SOUTH BROADWAY',NULL,NULL, 'WHITE PLAINS',1009336,NULL, '10601-3503',1009148, '0',1000130,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000797,NULL,NULL, 'YONKERS CLINIC', '526GB', 'YONKERS CBOC',1009121,1006840, '124 NEW MAIN STREET',NULL,NULL, 'YONKERS',1009336,NULL, '10701-4126',1006840, '124 NEW MAIN STREET',NULL,NULL, 'YONKERS',1009336,NULL, '10701-4126',1009148, '0',1000130,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000798,NULL,TO_DATE('10/26/2010' , 'mm/dd/yyyy hh:mi:ss AM'), 'SOUTH BRONX CLINIC', '526GC', 'ZZ-SOUTH BRONX CBOC',1009121,1006840, '953 SOUTHERN BLVD.',NULL,NULL, 'BRONX',1009336,NULL, '10459',1006840, '953 SOUTHERN BLVD.',NULL,NULL, 'BRONX',1009336,NULL, '10459',1009148, '0',1000130,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000799,NULL,NULL, 'NORTH QUEENS CLINIC', '526GD', 'QUEENS CBOC',1009121,1006840, '41-03 QUEENS BOULEVARD',NULL,NULL, 'QUEENS',1009336,NULL, '11104-2801',1006840, '41-03 QUEENS BOULEVARD',NULL,NULL, 'QUEENS',1009336,NULL, '11104-2801',1009148, '0',1000130,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000800,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROOKLYN NHCU', '5279AA', 'ZZ BROOKLYN NHCU',1009121,1006840,NULL,NULL,NULL, 'BROOKLYN',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000801,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ST. ALBANS VAMC', '527A4', 'ZZ ST. ALBANS VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,1001529,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000802,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZST.ALBANS', '527BU', 'ZZST.ALBANS',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1001532,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:13:40 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/31/07 changes');
Insert into sdsadm.STD_Institution values(1000803,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROOKLYN (SOC)', '527BY', 'ZZ BROOKLYN (SOC)',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1001546,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000804,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ STATEN ISLAND PHS', '527C5', 'ZZ STATEN ISLAND PHS',1009121,1006840,NULL,NULL,NULL, 'STATEN ISLAND',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009202, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000805,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BROOKLYN (PHARM)', '527CA', 'ZZ BROOKLYN (PHARM)',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009201, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000806,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ST. ALBANS STNB', '527DT', 'ZZ ST. ALBANS STNB',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001543,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000807,NULL,NULL, 'ROCKY HILL HOME', '527EL', 'ROCKY HILL HOME',1009121,1006840,NULL,NULL,NULL, 'ROCKY HILL',1009309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009220, '0',1000216,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000808,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ STATEN ISLAND CBOC', '527GA', 'ZZ STATEN ISLAND CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001545,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000809,NULL,NULL, 'BATAVIA PRRP', '5284PA', 'BATAVIA PRRP',1009121,1006840, '222 RICHMOND AVENUE',NULL,NULL, 'BATAVIA',1009336,NULL, '14020',1006840, '222 RICHMOND AVENUE',NULL,NULL, 'BATAVIA',1009336,NULL, '14020',1009204, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000811,NULL,NULL, 'BATAVIA NHCU', '5289AB', 'BATAVIA NHCU',1009121,1006840, '222 RICHMOND AVENUE',NULL,NULL, 'BATAVIA',1009336,NULL, '14020',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000816,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000812,NULL,NULL, 'CANANDAIGUA NHCU', '5289AC', 'CANANDAIGUA NHCU',1009121,1006840, '400 FORT HILL AVENUE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424',1006840, '400 FORT HILL AVENUE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424',1009185, '0',1000817,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000813,NULL,NULL, 'SYRACUSE NHCU', '5289AD', 'SYRACUSE NHCU',1009121,1006840, '800 IRVING AVENUE',NULL,NULL, 'SYRACUSE',1009336,NULL, '13210',1006840, '800 IRVING AVENUE',NULL,NULL, 'SYRACUSE',1009336,NULL, '13210',1009185, '0',1000819,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000814,NULL,NULL, 'BATH NHCU', '5289AK', 'BATH NHCU',1009121,1006840, '76 VETERANS AVENUE',NULL,NULL, 'BATH',1009336,NULL, '14810',1006840, '76 VETERANS AVENUE',NULL,NULL, 'BATH',1009336,NULL, '14810',1009185, '0',1000818,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000816,TO_DATE('1/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'VA HEALTHCARE NETWORK UPSTATE NEW YORK SYSTEM VISN 2 - BATAVIA DIVISION', '528A4', 'BATAVIA VAMC',1009121,1006840, '222 RICHMOND AVENUE',NULL,NULL, 'BATAVIA',1009336,NULL, '14020-1227',1006840, '222 RICHMOND AVENUE',NULL,NULL, 'BATAVIA',1009336,NULL, '14020-1227',1009231, '0',1000132,1000117,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000817,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CANANDAIGUA VA MEDICAL CENTER', '528A5', 'CANANDAIGUA VA MEDICAL CENTER',1009121,1006840, '400 FORT HILL AVE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424-1159',1006840, '400 FORT HILL AVE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424-1159',1009231, '0',1000132,1000136,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000818,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'BATH VA MEDICAL CENTER', '528A6', 'BATH VA MEDICAL CENTER',1009121,1006840, '76 VETERANS AVENUE',NULL,NULL, 'BATH',1009336,NULL, '14810-0810',1006840, '76 VETERANS AVENUE',NULL,NULL, 'BATH',1009336,NULL, '14810-0810',1009231, '0',1000132,1000118,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000819,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SYRACUSE VA MEDICAL CENTER', '528A7', 'SYRACUSE VA MEDICAL CENTER',1009121,1006840, '800 IRVING AVE',NULL,NULL, 'SYRACUSE',1009336,NULL, '13210-2716',1006840, '800 IRVING AVE',NULL,NULL, 'SYRACUSE',1009336,NULL, '13210-2716',1009231, '0',1000132,1000249,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000820,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SAMUEL S. STRATTON VAMC', '528A8', 'SAMUEL S. STRATTON VAMC',1009121,1006840, '113 HOLLAND AVENUE',NULL,NULL, 'ALBANY',1009336,NULL, '12208-3410',1006840, '113 HOLLAND AVE',NULL,NULL, 'ALBANY',1009336,NULL, '12208-3410',1009231, '0',1000132,1000107,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000821,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CANANDAIGUA DOMICILIARY', '528BU', 'CANANDAIGUA DOMICILIARY',1009121,1006840, '400 FORT HILL AVENUE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424-1159',1006840, '400 FORT HILL AVE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424-1159',1009158, '0',1000817,1000876,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000822,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'BATH VA DOMICILIARY', '528BV', 'BATH DOMICILIARY',1009121,1006840, '76 VETERANS AVENUE',NULL,NULL, 'BATH',1009336,NULL, '14810-0810',1006840, '76 VETERANS AVENUE',NULL,NULL, 'BATH',1009336,NULL, '14810-0810',1009158, '0',1000818,1000705,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000824,NULL,NULL, 'BATAVIA STATE NURSING HOME', '528DT', 'BATAVIA STATE NURSING HOME',1009121,1006840, '220 RICHMOND AVENUE',NULL,NULL, 'BATAVIA',1009336,NULL, '14020',1006840, '220 RICHMOND AVENUE',NULL,NULL, 'BATAVIA',1009336,NULL, '14020',1009221, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000825,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'OXFORD STATE HOME', '528DU', 'OXFORD',1009121,1006840, '4211 STATE HIGHWAY 220',NULL,NULL, 'OXFORD',1009336,NULL, '13830',1006840, '4211 STATE HIGHWAY 220',NULL,NULL, 'OXFORD',1009336,NULL, '13830',1009221, '0',1000819,1001863,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000826,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MALONE CBOC', '528G1', 'MALONE',1009121,1006840, '3372 STATE ROUTE 11',NULL,NULL, 'MALONE',1009336,NULL, '12953-4712',1006840, '3372 STATE ROUTE 11',NULL,NULL, 'MALONE',1009336,NULL, '12953-4712',1009148, '0',1000820,1000613,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:31:37 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0928 03/02/2015');
Insert into sdsadm.STD_Institution values(1000827,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ELIZABETHTOWN CBOC', '528G2', 'ELIZABETHTOWN CBOC',1009121,1006840, '7426 NYS  ROUTE 9N',NULL,NULL, 'WESTPORT',1009336,NULL, '12993-2801',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000820,1000615,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000828,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SIDNEY CBOC', '528G3', 'BAINBRIDGE CBOC',1009121,1006840, '109 MAIN STREET',NULL,NULL, 'BAINBRIDGE',1009336,NULL, '13733-1212',1006840, '109 MAIN STREET',NULL,NULL, 'BAINBRIDGE',1009336,NULL, '13733-1212',1009148, '0',1000820,1000617,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000829,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ELMIRA CBOC', '528G4', 'ELMIRA CBOC',1009121,1006840, '1316 COLLEGE AVENUE',NULL,NULL, 'ELMIRA',1009336,NULL, '14901-1169',1006840, '200 MADISON AVENUE',NULL,NULL, 'ELMIRA',1009336,NULL, '14901-3218',1009148, '0',1000818,1000706,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1000830,NULL,NULL, 'AUBURN', '528G5', 'AUBURN',1009121,1006840, '17 LANSING STREET',NULL,NULL, 'AUBURN',1009336,NULL, '13021-1983',1006840, '17 LANSING STREET',NULL,NULL, 'AUBURN',1009336,NULL, '13021-1983',1009148, '0',1000819,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000831,NULL,NULL, 'FONDA CBOC', '528G6', 'FONDA CBOC',1009121,1006840, '2623 STATE HIGHWAY 30A',NULL,NULL, 'FONDA',1009336,NULL, '12068-5961',1006840, '2623 STATE HIGHWAY 30A',NULL,NULL, 'FONDA',1009336,NULL, '12068-5961',1009148, '0',1000820,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000832,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CATSKILL CBOC', '528G7', 'CATSKILL CBOC',1009121,1006840, '159 JEFFERSON HEIGHTS SUITE 102',NULL,NULL, 'CATSKILL',1009336,NULL, '12414-1237',1006840, '159 JEFFERSON HEIGHTS SUITE 102',NULL,NULL, 'CATSKILL',1009336,NULL, '12414-1237',1009148, '0',1000820,1000614,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000834,NULL,NULL, 'CORTLAND', '528G9', 'CORTLAND',1009121,1006840, '1451 DRYDEN ROAD',NULL,NULL, 'FREEVILLE',1009336,NULL, '13068-9633',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000819,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000835,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BUFFALO', '528GA', 'ZZ BUFFALO',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000836,NULL,NULL, 'JAMESTOWN VA CLINIC', '528GB', 'JAMESTOWN VA CLINIC',1009121,1006840, '608 WEST 3RD STREET',NULL,NULL, 'JAMESTOWN',1009336,NULL, '14701-4705',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000837,NULL,NULL, 'DUNKIRK VA CLINIC', '528GC', 'DUNKIRK VA CLINIC',1009121,1006840, '166 EAST 4TH ST',NULL,NULL, 'DUNKIRK',1009336,NULL, '14048-2226',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000838,NULL,NULL, 'NIAGARA FALLS VA CLINIC', '528GD', 'NIAGARA FALLS VA CLINIC',1009121,1006840, '2201 PINE AVENUE',NULL,NULL, 'NIAGARA FALLS',1009336,NULL, '14301-2300',1006840, '2201 PINE AVENUE',NULL,NULL, 'NIAGARA FALLS',1009336,NULL, '14301-2300',1009148, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000839,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ROCHESTER OPC', '528GE', 'ROCHESTER OPC',1009121,1006840, '465 WESTFALL ROAD',NULL,NULL, 'ROCHESTER',1009336,NULL, '14620-4645',1006840, '465 WESTFALL ROAD',NULL,NULL, 'ROCHESTER',1009336,NULL, '14620-4645',1009148, '0',1000817,1000877,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000840,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GENEVA', '528GF', 'ZZ GENEVA',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,1000880,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000841,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'LYONS CBOC', '528GG', 'ZZ LYONS',1009121,1006840, 'BOX 391 RT 14A',NULL,NULL, 'LYONS',1009336,NULL, '14489',1006840, 'BOX 391 RT 14A',NULL,NULL, 'LYONS',1009336,NULL, '14489',1009148, '0',NULL,1000881,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000842,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ITHACA CBOC', '528GH', 'ZZ ITHACA',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,1000883,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000843,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('2/23/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'MT. MORRIS CBOC (LIVINGSTON COUNTY)', '528GI', 'ZZ MT. MORRIS CBOC',1009121,1006840, 'c/o CANANDAIGUA VAMC',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424',1006840, 'C/O CANANDAIGUA VAMC',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424',1009148, '0',1000817,1000878,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1000844,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SENECA COUNTY', '528GJ', 'SENECA COUNTY',1009121,1006840, '123 BAYARD STREET',NULL,NULL, 'SENECA FALLS',1009336,NULL, '13148',1006840, '123 BAYARD STREET',NULL,NULL, 'SENECA FALLS',1009336,NULL, '13148',1009148, '0',1000817,1000879,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000845,NULL,NULL, 'LOCKPORT', '528GK', 'LOCKPORT',1009121,1006840, '5883 SNYDER DRIVE',NULL,NULL, 'LOCKPORT',1009336,NULL, '14094-9497',1006840, '5883 SNYDER DRIVE',NULL,NULL, 'LOCKPORT',1009336,NULL, '14094-9497',1009148, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000846,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MASSENA CBOC', '528GL', 'MASSENA CBOC',1009121,1006840, '6100 ST. LAWRENCE CENTRE',NULL,NULL, 'MASSENA',1009336,NULL, '13662-3214',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000819,1001864,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 9:56:58 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0932 07/08/2015');
Insert into sdsadm.STD_Institution values(1000847,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ROME CBOC', '528GM', 'ROME CBOC',1009121,1006840, '125 BROOKLEY ROAD',NULL,NULL, 'ROME',1009336,NULL, '13441-4301',1006840, '125 BROOKLEY ROAD',NULL,NULL, 'ROME',1009336,NULL, '13441-4301',1009148, '0',1000819,1001866,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000848,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'BINGHAMTON CBOC', '528GN', 'BINGHAMTON CBOC',1009121,1006840, '425 ROBINSON STREET',NULL,NULL, 'BINGHAMTON',1009336,NULL, '13901-1735',1006840, '425 ROBINSON STREET',NULL,NULL, 'BINGHAMTON',1009336,NULL, '13901-1735',1009148, '0',1000819,1001868,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000849,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'WATERTOWN CBOC', '528GO', 'WATERTOWN CBOC',1009121,1006840, '144 EASTERN BLVD',NULL,NULL, 'WATERTOWN',1009336,NULL, '13601-3132',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000819,1001865,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1000850,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'OSWEGO CBOC', '528GP', 'OSWEGO CBOC',1009121,1006840, '437 STATE ROUTE 104E',NULL,NULL, 'OSWEGO',1009336,NULL, '13126-2998',1006840, '437 STATE ROUTE 104E',NULL,NULL, 'OSWEGO',1009336,NULL, '13126-2998',1009148, '0',1000819,1001869,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000851,NULL,NULL, 'LACKAWANNA CBOC', '528GQ', 'LACKAWANNA CBOC',1009121,1006840, '1234 ABBOTT ROAD',NULL,NULL, 'LACKAWANNA',1009336,NULL, '14218-1944',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/22/2014 6:42:33 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0922 11/03/2014');
Insert into sdsadm.STD_Institution values(1000852,NULL,NULL, 'OLEAN CBOC', '528GR', 'OLEAN',1009121,1006840, '465 NORTH UNTION STREET',NULL,NULL, 'OLEAN',1009336,NULL, '14760-1921',1006840, '465 NORTH UNION STREET',NULL,NULL, 'OLEAN',1009336,NULL, '14760-1921',1009148, '0',1000132,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000853,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ERIE COUNTY CBOC', '528GS', 'ZZ ERIE COUNTY',1009121,1006840, '1500 BROADWAY',NULL,NULL, 'BUFFALO',1009336,NULL, '14212',1006840, '1500 BROADWAY',NULL,NULL, 'BUFFALO',1009336,NULL, '14212',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000854,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'GLENS FALLS CBOC', '528GT', 'GLENS FALLS CBOC',1009121,1006840, '84 BROAD STREET',NULL,NULL, 'GLENS FALLS',1009336,NULL, '12801-4381',1006840, '84 BROAD STREET',NULL,NULL, 'GLENS FALLS',1009336,NULL, '12801-4381',1009148, '0',1000820,1000606,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000855,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'BENNINGTON CBOC', '528GU', 'ZZ BENNINGTON CBOC-UPSTATE NY',1009121,1006840,NULL,NULL,NULL,NULL,1009350,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,1000607,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000856,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PLATTSBURGH', '528GV', 'PLATTSBURGH CBOC',1009121,1006840, '80 SHARRON AVE',NULL,NULL, 'PLATTSBURGH',1009336,NULL, '12901-4700',1006840, '80 SHARRON AVE',NULL,NULL, 'PLATTSBURGH',1009336,NULL, '12901-4700',1009148, '0',1000820,1000608,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000857,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SCHENECTADY CBOC', '528GW', 'SCHENECTADY',1009121,1006840, '1346 GERLING STREET',NULL,NULL, 'SCHENECTADY',1009336,NULL, '12308-1702',1006840, '1346 GERLING STREET',NULL,NULL, 'SCHENECTADY',1009336,NULL, '12308-1702',1009148, '0',1000820,1000609,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('9/30/2014 7:54:58 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0918 08/18/2014');
Insert into sdsadm.STD_Institution values(1000858,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'TROY CBOC', '528GX', 'TROY',1009121,1006840, '295 RIVER STREET',NULL,NULL, 'TROY',1009336,NULL, '12180-3215',1006840, '295 RIVER STREET',NULL,NULL, 'TROY',1009336,NULL, '12180-3215',1009148, '0',1000820,1000610,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000859,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CLIFTON PARK CBOC', '528GY', 'CLIFTON PARK VA CLINIC',1009121,1006840, '963 ROUTE 146',NULL,NULL, 'CLIFTON PARK',1009336,NULL, '12065',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000820,1000611,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 8:55:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0931 06/03/2015');
Insert into sdsadm.STD_Institution values(1000860,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'KINGSTON CBOC', '528GZ', 'KINGSTON CBOC',1009121,1006840, '324 PLAZA RD.',NULL,NULL, 'KINGSTON',1009336,NULL, '12401-2832',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000820,1000612,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/2/2014 11:20:28 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0904 05/13/2014');
Insert into sdsadm.STD_Institution values(1000862,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'BUFFALO SARRTP', '528PA', 'BUFFALO SARRTP',1009121,1006840, '3495 BAILEY AVENUE',NULL,NULL, 'BUFFALO',1009336,NULL, '14215-1129',1006840, '3495 BAILEY AVENUE',NULL,NULL, 'BUFFALO',1009336,NULL, '14215-1129',1009212, '0',1000132,1000618,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000863,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CANANDAIGUA PRRTP', '528PC', 'CANANDAIGUA PRRTP',1009121,1006840, 'FORT HILL AVENUE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424',1006840, '400 FORT HILL AVENUE',NULL,NULL, 'CANANDAIGUA',1009336,NULL, '14424',1009204, '0',1000817,1000885,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000864,NULL,NULL, 'ALBANY PRRTP', '528PD', 'ALBANY PRRTP',1009121,1006840, '113 HOLLAND AVENUE',NULL,NULL, 'ALBANY',1009336,NULL, '12208-3410',1006840, '113 HOLLAND AVENUE',NULL,NULL, 'ALBANY',1009336,NULL, '12208-3410',1009204, '0',1000820,NULL,NULL,1002202,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000865,NULL,NULL, 'BUTLER (NHC)', '5299AA', 'BUTLER (NHC)',1009121,1006840,NULL,NULL,NULL, 'BUTLER',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000133,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000866,NULL,NULL, 'BUTLER VETERANS AFFAIRS MEDICAL CENTER-DOMICILIARY', '529BU', 'BUTLER (D)',1009121,1006840, '325 New Castle Road',NULL,NULL, 'Butler',1009342,NULL, '16001-2464',1006840, '325 New Castle Road',NULL,NULL, 'Butler',1009342,NULL, '16001-2464',1009158, '0',1000133,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000867,NULL,NULL, 'MICHAEL A. MARZANO VA OPC', '529GA', 'MICHAEL A. MARZANO VA OPC',1009121,1006840, '295 N. KERRWOOD DRIVE',NULL,NULL, 'HERMITAGE',1009342,NULL, '16148-5207',1006840, '325 New Caslte Road',NULL,NULL, 'Butler',1009342,NULL, '16001',1009148, '0',1000133,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000868,NULL,NULL, 'LAWRENCE COUNTY VA CLINIC', '529GB', 'LAWRENCE COUNTY VA CLINIC',1009121,1006840, '1750 New Butler Road',NULL,NULL, 'New Castle',1009342,NULL, '16101-3184',1006840, '325 New Castle Road',NULL,NULL, 'Butler',1009342,NULL, '16001',1009148, '0',1000133,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000869,NULL,NULL, 'ARMSTRONG COUNTY VA CLINIC', '529GC', 'ARMSTRONG COUNTY VA CLINIC',1009121,1006840, '11 HILLTOP PLAZA',NULL,NULL, 'KITTANNING',1009342,NULL, '16201',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000133,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000871,NULL,NULL, 'BOISE NURSING HOME', '5319AA', 'BOISE NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BOISE',1009316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000135,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000872,NULL,NULL, 'BOISE STATE NURSING HOME', '5319AF', 'BOISE STATE NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BOISE',1009316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000135,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000873,NULL,NULL, 'BOISE STATE HOME', '531DT', 'BOISE STATE HOME',1009121,1006840,NULL,NULL,NULL, 'BOISE',1009316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000135,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000874,NULL,TO_DATE('6/7/2007' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ONTARIO CBOC', '531GD', 'ZZ ONTARIO CBOC',1009121,1006840, '20 SW 3RD',NULL,NULL, 'ONTARIO',1009341,NULL, '97914',1006840, '20 SW 3RD',NULL,NULL, 'ONTARIO',1009341,1013013, '97914',1009148, '0',1000135,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000875,NULL,NULL, 'TWIN FALLS VA CLINIC', '531GE', 'TWIN FALLS VA CLINIC',1009121,1006840, '260 2ND AVE E STREET',NULL,NULL, 'TWIN FALLS',1009316,NULL, '83301-6242',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000135,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000879,NULL,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SENECA COUNTY', '532GC', 'ZZ SENECA COUNTY',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000844,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000880,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GENEVA ORC', '532HA', 'ZZ GENEVA ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1000840,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1000882,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'GROVELAND VETERANS OUTREACH RESIDENTIAL THERAPEUTIC PROGRAM', '532HC', 'ZZ GROVELAND',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000886,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CASTLE POINT NHC', '5339AA', 'ZZ CASTLE POINT NHC',1009121,1006840,NULL,NULL,NULL, 'CASTLE POINT',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000887,NULL,NULL, 'CHAS NHC', '5349AA', 'CHAS NHC',1009121,1006840,NULL,NULL,NULL, 'CHARLESTON',1009345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000138,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000888,NULL,NULL, 'SAVANNAH PRIMARY CARE CLINIC', '534BY', 'SAVANNAH OPC-CHARLESTON',1009121,1006840, '325 WEST MONTGOMERY CROSSROADS',NULL,NULL, 'SAVANNAH',1009313,NULL, '31406-3309',1006840, '325 WEST MONTGOMERY CROSSROADS',NULL,NULL, 'SAVANNAH',1009313,NULL, '31406-3309',1009148, '0',1000138,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000889,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MYRTLE BEACH', '534GA', 'ZZ MYRTLE BEACH',1009121,1006840,NULL,NULL,NULL,NULL,1009345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000890,NULL,NULL, 'MYRTLE  BEACH PRIMARY CARE CLINIC', '534GB', 'MYRTLE BEACH',1009121,1006840, '3381 PHILLIS BLVD',NULL,NULL, 'MYRTLE BEACH',1009345,NULL, '29577-1533',1006840, '3381 PHILLIS BLVD',NULL,NULL, 'MYRTLE BEACH',1009345,NULL, '29577-1533',1009148, '0',1000138,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000891,NULL,NULL, 'BEAUFORT PRIMARY CARE CLINIC', '534GC', 'BEAUFORT',1009121,1006840, '1 PINCKNEY BLVD',NULL,NULL, 'BEAUFORT',1009345,NULL, '29902-6122',1006840, '1 PINCKNEY BLVD',NULL,NULL, 'BEAUFORT',1009345,NULL, '29902-6122',1009148, '0',1000138,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000892,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHICAGO (LAKESIDE) NHC', '5359AA', 'ZZ CHICAGO (LAKESIDE) NHC',1009121,1006840,NULL,NULL,NULL, 'CHICAGO (LAKESIDE)',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000893,NULL,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CROWN POINT SOC', '535BY', 'ZZ CROWN POINT SOC',1009121,1006840,NULL,NULL,NULL, 'CROWN POINT',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1000896,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000894,NULL,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHICHAGO HEIGHTS', '535GA', 'ZZ CHICHAGO HEIGHTS',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000897,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000898,NULL,NULL, 'BEVERLY CBOC', '537HA', 'BEVERLY CLINIC',1009121,1006840, '7731 S HALSTED',NULL,NULL, 'CHICAGO',1009317,NULL, '60620-2412',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000140,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1000899,NULL,NULL, 'CHI-PRRTP', '537PA', 'CHI-PRRTP',1009121,1006840, '820 S. DAMEN',NULL,NULL, 'CHICAGO',1009317,NULL, '60612-3728',1006840, '820 S. DAMEN',NULL,NULL, 'CHICAGO',1009317,NULL, '60612-3728',1009204, '0',1000140,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000900,NULL,NULL, 'CHILLICOTHE NHCU', '5389AA', 'CHILLICOTHE NHCU',1009121,1006840, '17273 State Route 104',NULL,NULL, 'CHILLICOTHE',1009339,NULL, '45601-0999',1006840, '17273 State Route 104',NULL,NULL, 'CHILLICOTHE',1009339,NULL, '45601-0999',1009185, '0',1000141,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000902,NULL,NULL, 'ATHENS VA CLINIC', '538GA', 'ATHENS VA CLINIC',1009121,1006840, '510 W UNION STREET',NULL,NULL, 'ATHENS',1009339,NULL, '45701-2331',1006840, '510 W UNION STREET',NULL,NULL, 'ATHENS',1009339,NULL, '45701-2331',1009148, '0',1000141,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000903,NULL,NULL, 'PORTSMOUTH VA CLINIC', '538GB', 'PORTSMOUTH VA CLINIC',1009121,1006840, '840 GALLIA STREET',NULL,NULL, 'PORTSMOUTH',1009339,NULL, '45662-4164',1006840, '840 GALLIA STREET',NULL,NULL, 'PORTSMOUTH',1009339,NULL, '45662-4164',1009148, '0',1000141,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000904,NULL,NULL, 'MARIETTA VA CLINIC', '538GC', 'MARIETTA VA CLINIC',1009121,1006840, '418 COLGATE',NULL,NULL, 'MARIETTA',1009339,NULL, '45750-9549',1006840, '418 COLGATE',NULL,NULL, 'MARIETTA',1009339,NULL, '45750-9549',1009148, '0',1000141,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000905,NULL,NULL, 'LANCASTER VA CLINIC', '538GD', 'LANCASTER VA CLINIC',1009121,1006840, '1550 SHERIDAN DR. SUITE 100',NULL,NULL, 'LANCASTER',1009339,NULL, '43130-1380',1006840, '1550 SHERIDAN DR. SUITE 100',NULL,NULL, 'LANCASTER',1009339,NULL, '43130-1380',1009148, '0',1000141,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000915,NULL,NULL, 'BELLEVUE CBOC', '539GA', 'BELLEVUE',1009121,1006840, '103 LANDMARK DR #3 FLOOR',NULL,NULL, 'BELLEVUE',1009321,NULL, '41073-1393',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000142,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1000916,NULL,NULL, 'CINCINNATI (CLERMONT COUNTY)', '539GB', 'CLERMONT',1009121,1006840, '4600 BEECHWOOD RAD',NULL,NULL, 'CINCINNATI',1009339,NULL, '45244-1809',1006840, '3200 VINE STREET',NULL,NULL, 'CINCINNATI',1009339,NULL, '45220-2213',1009148, '0',1000142,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000917,NULL,NULL, 'LAWRENCEBURG (DEARBORN COUNTY)', '539GC', 'LAWRENCEBURG',1009121,1006840, '1600 FLOSSIE DRIVE',NULL,NULL, 'GREENDALE',1009318,NULL, '47025-8424',1006840, '1600 FLOSSIE DRIVE',NULL,NULL, 'GREENDALE',1009318,NULL, '47025-8424',1009148, '0',1000142,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:17:19 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0857 5/6/2013');
Insert into sdsadm.STD_Institution values(1000918,NULL,NULL, 'CIN-PRRTP', '539PA', 'CIN-PRRTP',1009121,1006840, '3200 VINE STREET',NULL,NULL, 'CINCINNATI',1009339,NULL, '45220-2213',1006840, '3200 VINE STREET',NULL,NULL, 'CINCINNATI',1009339,NULL, '45220-2213',1009204, '0',1000142,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000919,NULL,NULL, 'LOUIS A JOHNSON VA MEDICAL CENTER', '5409AA', 'CLARKSBURG NHCU',1009121,1006840, '1 MED CENTER DRIVE',NULL,NULL, 'CLARKSBURG',1009354,NULL, '26301',1006840, '1 MED CENTER DRIVE',NULL,NULL, 'CLARKSBURG',1009354,NULL, '26301',1009185, '0',1000143,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000920,NULL,NULL, 'TUCKER COUNTY VA CLINIC', '540GA', 'TUCKER COUNTY VA CLINIC',1009121,1006840, '260 SPRUCE STREET',NULL,NULL, 'PARSONS',1009354,NULL, '26287-1015',1006840, '206 SPRUCE STREET',NULL,NULL, 'PARSONS',1009354,NULL, '26287-1015',1009148, '0',1000143,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000922,NULL,NULL, 'BRAXTON COUNTY VA CLINIC', '540GC', 'BRAXTON COUNTY VA CLINIC',1009121,1006840, '93 SKIDMORE LANE',NULL,NULL, 'SUTTON',1009354,NULL, '26601-9327',1006840, '93 SKIDMORE LANE',NULL,NULL, 'SUTTON',1009354,NULL, '26601-9327',1009148, '0',1000143,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000923,NULL,NULL, 'CLEVELAND COMM LIVING CENTER', '5419AA', 'CLEVELAND COMM LIVING CENTER',1009121,1006840, '10701 EAST BOULEVARD',NULL,NULL, 'CLEVELAND',1009339,NULL, '44106',1006840, '10701 EAST BOULEVARD',NULL,NULL, 'CLEVELAND',1009339,NULL, '44106',1009185, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000924,NULL,NULL, 'OHIO VETERANS HOME', '5419AF', 'SANDUSKY',1009121,1006840, '3416 COLUMBUS AVENUE',NULL,NULL, 'SANDUSKY',1009339,NULL, '44870',1006840, '3416 COLUMBUS AVENUE',NULL,NULL, 'SANDUSKY',1009339,NULL, '44870',1009221, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000925,NULL,TO_DATE('11/19/2012' , 'mm/dd/yyyy hh:mi:ss AM'), 'BRECKSVILLE VANPH', '541A0', 'ZZ-BRECKSVILLE VANPH',1009121,1006840, '10000 BRECKSVILLE RD',NULL,NULL, 'BRECKSVILLE',1009339,NULL, '44141-3204',1006840, '10000 BRECKSVILLE RD',NULL,NULL, 'BRECKSVILLE',1009339,NULL, '44141-3204',1009233, '0',1000144,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:15:45 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0833 1/14/2013');
Insert into sdsadm.STD_Institution values(1000926,NULL,NULL, 'CLEVELAND DOMICILIARY', '541BU', 'CLEVELAND DOMICILIARY',1009121,1006840, '10701 EAST BOULEVARD',NULL,NULL, 'CLEVELAND',1009339,NULL, '44106-1702',1006840, '10000 BRECKSVILLE ROAD',NULL,NULL, 'BRECKSVILLE',1009339,NULL, '44141',1009158, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000927,NULL,NULL, 'CANTON CBOC', '541BY', 'CANTON CBOC',1009121,1006840, '733 MARKET AVENUE S',NULL,NULL, 'CANTON',1009339,NULL, '44702-2165',1006840, '733 MARKET AVENUE S',NULL,NULL, 'CANTON',1009339,NULL, '44702-2165',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000928,NULL,NULL, 'YOUNGSTOWN CBOC', '541BZ', 'YOUNGSTOWN CBOC',1009121,1006840, '2031 BELMONT AVENUE',NULL,NULL, 'YOUNGSTOWN',1009339,NULL, '44505-2401',1006840, '2031 BELMONT AVENUE',NULL,NULL, 'YOUNGSTOWN',1009339,NULL, '44505-2401',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000929,NULL,NULL, 'CLEVELAND PHARMACY', '541CA', 'CLEVELAND PHARM',1009121,1006840, '10701 EAST BLVD',NULL,NULL, 'CLEVELAND',1009339,NULL, '44106',1006840, '10701 EAST BLVD',NULL,NULL, 'CLEVELAND',1009339,NULL, '44106',1009201, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000931,NULL,NULL, 'LORAIN CBOC', '541GB', 'LORAIN CBOC',1009121,1006840, '205 WEST 20TH STREET',NULL,NULL, 'LORAIN',1009339,NULL, '44052-3779',1006840, '205 WEST 20TH STREET',NULL,NULL, 'LORAIN',1009339,NULL, '44052-3779',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000932,NULL,NULL, 'SANDUSKY CBOC', '541GC', 'SANDUSKY CBOC',1009121,1006840, '3416 COLUMBUS AVENUE',NULL,NULL, 'SANDUSKY',1009339,NULL, '44870-5557',1006840, '3416 COLUMBUS AVENUE',NULL,NULL, 'SANDUSKY',1009339,NULL, '44870-5557',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000933,NULL,NULL, 'MANSFIELD CBOC', '541GD', 'DAVID F WINDER CLINIC',1009121,1006840, '1025 SOUTH TRIMBLE RD.',NULL,NULL, 'MANSFIELD',1009339,NULL, '44906-2700',1006840, '1456 PARK AVENUE WEST',NULL,NULL, 'MANSFIELD',1009339,NULL, '44906-2700',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/29/2015 9:03:15 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0930 05/04/2015');
Insert into sdsadm.STD_Institution values(1000934,NULL,NULL, 'MCCAFERTY CBOC', '541GE', 'MCCAFERTY CBOC',1009121,1006840, '4242 LORAIN AVENUE',NULL,NULL, 'CLEVELAND',1009339,NULL, '44113-3715',1006840, '4242 LORAIN AVENUE',NULL,NULL, 'CLEVELAND',1009339,NULL, '44113-3715',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000935,NULL,NULL, 'PAINSVILLE CBOC', '541GF', 'PAINESVILLE CBOC',1009121,1006840, '7 WEST JACKSON STREET',NULL,NULL, 'PAINESVILLE',1009339,NULL, '44077-3210',1006840, '7 WEST JACKSON STREET',NULL,NULL, 'PAINESVILLE',1009339,NULL, '44077-3210',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000936,NULL,NULL, 'AKRON CBOC', '541GG', 'AKRON CBOC',1009121,1006840, '55 WEST WATERLOO RD',NULL,NULL, 'AKRON',1009339,NULL, '44319-1116',1006840, '55 WEST WATERLOO RD',NULL,NULL, 'AKRON',1009339,NULL, '44319-1116',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000938,NULL,NULL, 'WARREN CBOC', '541GI', 'WARREN CBOC',1009121,1006840, '1406 TOD AVE NW',NULL,NULL, 'WARREN',1009339,NULL, '44485-2407',1006840, '1406 TOD AVE NW',NULL,NULL, 'WARREN',1009339,NULL, '44485-2407',1009148, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000939,NULL,NULL, 'CLEVELAND PRRTP', '541PA', 'CLEVELAND PRRTP',1009121,1006840, '10000 BRECKSVILLE RD',NULL,NULL, 'BRECKSVILLE',1009339,NULL, '44141-3204',1006840, '10000 BRECKSVILLE RD',NULL,NULL, 'BRECKSVILLE',1009339,NULL, '44141-3204',1009204, '0',1000144,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000940,NULL,NULL, 'COATESVILLE (NHC)', '5429AA', 'COATESVILLE (NHC)',1009121,1006840,NULL,NULL,NULL, 'COATESVILLE',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000145,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1000941,NULL,NULL, 'COATESVILLE (DOM)', '542BU', 'COATESVILLE (DOM)',1009121,1006840, '1400 BLACKHORSE HILL ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320',1006840, '1400 BLACKHORSE HILL ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320',1009158, '0',1000145,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1000942,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZDANVILLE STATE HOME', '542DT', 'ZZDANVILLE STATE HOME',1009121,1006840, '1400 BLACKHORSE ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320',1006840, '1400 BLACKHORSE ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320',1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000944,NULL,NULL, 'PHILA-COATESVILLE CBOC', '542GB', 'PHILADELPHIA-COATESVILLE CBOC',1009121,1006840, '1344 W YORK STREET',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19132',1006840, '1344 W YORK STREET',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19132',1009148, '0',1000145,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000945,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'COMMUNITY BASED OUTPT CLINIC', '542GC', 'ZZ READING CBOC',1009121,1006840, '145 NORTH 6TH STREET',NULL,NULL, 'READING',1009342,NULL, '19601',1006840, '145 NORTH 6TH STREET',NULL,NULL, 'READING',1009342,NULL, '19601',1009148, '0',NULL,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000947,NULL,NULL, 'SPRING CITY VA CLINIC', '542GE', 'SPRING CITY VA CLINIC',1009121,1006840, '11 INDEPENDENCE DRIVE',NULL,NULL, 'SPRING CITY',1009342,NULL, '19475-1239',1006840, '11 INDEPENDENCE DRIVE',NULL,NULL, 'SPRING CITY',1009342,NULL, '19475-1239',1009148, '0',1000145,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000948,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'VINELAND CBOC', '542GF', 'ZZ VINELAND CBOC',1009121,1006840, '520 NORTHWEST BOULEVARD',NULL,NULL, 'VINELAND',1009334,NULL, '8360',1006840, '520 NORTHWEST BOULEVARD',NULL,NULL, 'VINELAND',1009334,NULL, '8360',1009148, '0',NULL,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000950,NULL,NULL, 'COATESVILLE CBOC', '542GH', 'COATESVILLE CBOC',1009121,1006840, '827 CHESTNUT STREET',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320',1006840, '827 CHESTNUT STREET',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320',1009148, '0',1000145,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000951,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'VENTNOR CBOC', '542GI', 'ZZ VENTNOR CBOC',1009121,1006840, '6601 VENTNOR AVE',NULL,NULL, 'VENTNOR',1009334,NULL, '8406',1006840, '6601 VENTNOR AVE',NULL,NULL, 'VENTNOR',1009334,NULL, '8406',1009148, '0',NULL,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000952,NULL,NULL, 'COATESVILLE PRRTP', '542PA', 'COATESVILLE PRRTP',1009121,1006840, '1400 BLACKHORSE HILL ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320-2040',1006840, '1400 BLACKHORSE HILL ROAD',NULL,NULL, 'COATESVILLE',1009342,NULL, '19320-2040',1009204, '0',1000145,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000955,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ UNIV OF MISSOURI', '543DN', 'ZZ UNIV OF MISSOURI',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',NULL,NULL,1001269,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000957,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ KIRKSVILLE CBOC', '543GA', 'ZZ KIRKSVILLE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001290,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000958,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FT LEONARD WOOD', '543GB', 'ZZ FT LEONARD WOOD',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001291,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000974,NULL,NULL, 'MIAMI (NHCU)', '5469AA', 'MIAMI (NHCU)',1009121,1006840,NULL,NULL,NULL, 'MIAMI',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000975,NULL,NULL, 'MIAMI (OCS)', '546B0', 'MIAMI (OCS)',1009121,1006840,NULL,NULL,NULL, 'KEY WEST',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000976,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ RIVIERA BEACH SOC', '546BY', 'ZZ RIVIERA BEACH SOC',1009121,1006840,NULL,NULL,NULL, 'RIVIERA BEACH',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1000977,NULL,NULL, 'WILLIAM BILL KLING VAOC', '546BZ', 'WILLIAM BILL KLING VAOC',1009121,1006840, '9800 W. COMMERCIAL BLVD',NULL,NULL, 'TAMARAC',1009312,NULL, '33351-4325',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000978,NULL,NULL, 'KEY WEST NAVY HOSP', '546CU', 'KEY WEST NAVY HOSP',1009125,1006840,NULL,NULL,NULL, 'KEY WEST',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009229, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000980,NULL,NULL, 'KEY WEST CBOC', '546GB', 'KEY WEST CBOC',1009121,1006840, '1300 DOUGLAS CIRCLE',NULL,NULL, 'KEY WEST',1009312,NULL, '33040-4536',1006840, '1300 DOUGLAS CIRCLE',NULL,NULL, 'KEY WEST',1009312,NULL, '33040-4536',1009148, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000983,NULL,NULL, 'KEY LARGO VA CLINIC', '546GE', 'KEY LARGO VA CLINIC',1009121,1006840, '105662 OVERSEAS HWY',NULL,NULL, 'KEY LARGO',1009312,NULL, '33037-3010',1006840, '105662 OVERSEAS HWY',NULL,NULL, 'KEY LARGO',1009312,NULL, '33037-3010',1009148, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000986,NULL,NULL, 'DEERFIELD BEACH CLINIC', '546GH', 'DEERFIELD BEACH CLINIC',1009121,1006840, '2100 SW 10TH STREET',NULL,NULL, 'DEERFIELD BEACH',1009312,NULL, '33442-7690',1006840, '2100 SW 10TH STREET',NULL,NULL, 'DEERFIELD BEACH',1009312,NULL, '33442-7690',1009148, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000987,NULL,NULL, 'MIA-PRRTP', '546PA', 'MIA-PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',1000148,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1000988,NULL,NULL, 'FORT PIERCE VA CLINIC', '548GA', 'FORT PIERCE VA CLINIC',1009121,1006840, '727 N US 1',NULL,NULL, 'FT PIERCE',1009312,NULL, '34950-9125',1006840, '727 N US 1',NULL,NULL, 'FT PIERCE',1009312,NULL, '34950-9125',1009148, '0',1000149,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000989,NULL,NULL, 'DELRAY BEACH VA CLINIC', '548GB', 'DELRAY BEACH VA CLINIC',1009121,1006840, '4800 LINTON BLVD',NULL,NULL, 'DELRAY BEACH',1009312,NULL, '33445-6584',1006840, '4800 LINTON BLVD',NULL,NULL, 'DELRAY BEACH',1009312,NULL, '33445-6584',1009148, '0',1000149,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000990,NULL,NULL, 'STUART VA CLINIC', '548GC', 'STUART VA CLINIC',1009121,1006840, '3501 S E WILLOUGHBY BLVD',NULL,NULL, 'STUART',1009312,NULL, '34997-5059',1006840, '3501 S E WILLOUGHBY BLVD',NULL,NULL, 'STUART',1009312,NULL, '34997-5059',1009148, '0',1000149,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000991,NULL,NULL, 'BOCA RATON CBOC', '548GD', 'BOCA RATON CBOC',1009121,1006840, '901 MEADOWS ROAD',NULL,NULL, 'BOCA RATON',1009312,NULL, '33433-2300',1006840, '901 MEADOWS ROAD',NULL,NULL, 'BOCA RATON',1009312,NULL, '33433-2300',1009148, '0',1000149,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000992,NULL,NULL, 'VERO BEACH VA CLINIC', '548GE', 'VERO BEACH VA CLINIC',1009121,1006840, '372 17TH STREET',NULL,NULL, 'VERO BEACH',1009312,NULL, '32960-5690',1006840, '372 17TH STREET',NULL,NULL, 'VERO BEACH',1009312,NULL, '32960-5690',1009148, '0',1000149,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000993,NULL,NULL, 'OKEECHOBEE VA CLINIC', '548GF', 'OKEECHOBEE VA CLINIC',1009121,1006840, '1201 N PARROTT AVE',NULL,NULL, 'OKEECHOBEE',1009312,NULL, '34972-1936',1006840, '1201 N PARROTT AVE',NULL,NULL, 'OKEECHOBEE',1009312,NULL, '34972-1936',1009148, '0',1000149,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1000994,NULL,NULL, 'NORTH TEXAS HEALTH CARE SYSTEM - DALLAS NHC', '5499AA', 'DALLAS (NHC)',1009121,1006840, '4500 SOUTH LANCASTER ROAD',NULL,NULL, 'DALLAS',1009348,NULL, '75216',1006840, '4500 SOUTH LANCASTER ROAD',NULL,NULL, 'DALLAS',1009348,NULL, '75216',1009185, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1000995,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SAM RAYBURN MEM VET CENTER', '549A4', 'SAM RAYBURN MEM VET CENTER',1009121,1006840, '1201 EAST NINTH STREET',NULL,NULL, 'BONHAM',1009348,NULL, '75418-4059',1006840, '1201 EAST NINTH STREET',NULL,NULL, 'BONHAM',1009348,NULL, '75418-4059',1009231, '0',1000150,1000126,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000996,NULL,NULL, 'NORTH TEXAS HEALTH CARE SYSTEM - DALLAS DOM', '549BU', 'DALLAS',1009121,1006840, '4500 SOUTH LANCASTER ROAD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1006840, '4500 SOUTH LANCASTER ROAD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009158, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000997,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'NORTH TEXAS HEALTH CARE SYSTEM - BONHAM DOM', '549BV', 'BONHAM DOMICILIARY (549BV)',1009121,1006840, '1201 EAST NINTH STREET',NULL,NULL, 'BONHAM',1009348,NULL, '75418-4059',1006840, '1201 EAST NINTH STREET',NULL,NULL, 'BONHAM',1009348,NULL, '75418-4059',1009158, '0',1000150,1000775,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1000998,NULL,NULL, 'FORT WORTH VA CLINIC', '549BY', 'FORT WORTH VA CLINIC',1009121,1006840, '2201 SOUTHEAST LOOP 820',NULL,NULL, 'FORT WORTH',1009348,NULL, '76119-5863',1006840, '2201 SOUTHEAST LOOP 820',NULL,NULL, 'FORT WORTH',1009348,NULL, '76119-5863',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1000999,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ DALLAS', '549CZ', 'ZZ DALLAS',1009122,1006840, 'UNKNOWN',NULL,NULL, 'DALLAS',1009348,NULL, '75216',1006840, 'UNKNOWN',NULL,NULL, 'DALLAS',1009348,NULL, '75216',1009224, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001000,NULL,NULL, 'NORTH TEXAS HEALTH CARE SYSTEM - COSPER SVH', '549DT', 'CLYDE W COSPER SVH',1009121,1006840, '1300 SEVEN OAKS ROAD',NULL,NULL, 'BONHAM',1009348,NULL, '75418',1006840, '1300 SEVEN OAKS ROAD',NULL,NULL, 'BONHAM',1009348,NULL, '75418',1009222, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001001,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'NORTH TEXAS HEALTH CARE SYSTEM - ZZ BONHAM DOM(549EX)', '549EX', 'ZZ BONHAM DOM(549EX)',1009121,1006840, '1201 EAST NINTH STREET',NULL,NULL, 'BONHAM',1009348,NULL, '75418',1006840, '1201 EAST NINTH STREET',NULL,NULL, 'BONHAM',1009348,NULL, '75418',1009158, '0',NULL,1000777,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001002,NULL,NULL, 'TYLER VA CLINIC', '549GA', 'TYLER VA CLINIC',1009121,1006840, '3414 GOLDEN RD',NULL,NULL, 'TYLER',1009348,NULL, '75708-8336',1006840, '3414 GOLDEN RD',NULL,NULL, 'TYLER',1009348,NULL, '75708-8336',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001003,NULL,NULL, 'NORTH TEXAS HEALTH CARE SYSTEM - DALLAS CBOC', '549GB', 'DALLAS CBOC',1009121,1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001004,NULL,NULL, 'BONHAM VA CLINIC', '549GC', 'BONHAM VA CLINIC',1009121,1006840, '635 STONE AVENUE',NULL,NULL, 'PARIS',1009348,NULL, '75460-9342',1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001005,NULL,NULL, 'DENTON VA CLINIC', '549GD', 'DENTON VA CLINIC',1009121,1006840, '2223 COLORADO BLVD',NULL,NULL, 'DENTON',1009348,NULL, '76205-7523',1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001006,NULL,NULL, 'BRIDGEPORT VA CLINIC', '549GE', 'BRIDGEPORT VA CLINIC',1009121,1006840, '806 WOODROW WILSON RAY CIRCLE',NULL,NULL, 'BRIDGEPORT',1009348,NULL, '76426-2061',1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001007,NULL,NULL, 'GRANBURY VA CLINIC', '549GF', 'GRANBURY VA CLINIC',1009121,1006840, '601 FALL CREEK HWY',NULL,NULL, 'GRANBURY',1009348,NULL, '76049-7960',1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001008,NULL,NULL, 'NORTH TEXAS HEALTH CARE SYSTEM - MCKINNEY CBOC', '549GG', 'MCKINNEY CBOC',1009121,1006840, '1128 CLARKSVILLE ST #100',NULL,NULL, 'PARIS',1009348,NULL, '75460',1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001009,NULL,NULL, 'GREENVILLE VA CLINIC', '549GH', 'GREENVILLE VA CLINIC',1009121,1006840, '4006 WELLINGTON ST',NULL,NULL, 'GREENVILLE',1009348,NULL, '75401-7829',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001010,NULL,NULL, 'NORTH TEXAS HEALTH CARE SYSTEM - CLEBURNE CBOC', '549GI', 'CLEBURNE CBOC',1009121,1006840, '207 FERRIS AVE',NULL,NULL, 'WAXAHACHIE',1009348,NULL, '75165-0361',1006840, '4500 S LANCASTER RD',NULL,NULL, 'DALLAS',1009348,NULL, '75216-7167',1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001011,NULL,TO_DATE('2/22/2011' , 'mm/dd/yyyy hh:mi:ss AM'), 'NORTH TEXAS HEALTH CARE SYSTEM - DIAMOND HILL CBOC', '549HA', 'ZZ-TARRANT COUNTY CBOC',1009121,1006840, 'UNIVERSITY OF NTH SCIENCE CTR',NULL,NULL, 'FORT WORTH',1009348,NULL, '76107',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000150,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001013,NULL,NULL, 'DANVILLE (NHC)', '5509AA', 'DANVILLE (NHC)',1009121,1006840, '1900 EAST MAIN STREET',NULL,NULL, 'DANVILLE',1009317,NULL, '61832',1006840, '1900 EAST MAIN STREET',NULL,NULL, 'DANVILLE',1009317,NULL, '61832',1009185, '0',1000151,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001014,NULL,NULL, 'BOB MICHEL VA OPC', '550BY', 'BOB MICHEL VA OPC',1009121,1006840, '7717 NORTH ORANGE PRAIRIE RD',NULL,NULL, 'PEORIA',1009317,NULL, '61615-9323',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000151,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001015,NULL,NULL, 'DECATUR VA CLINIC', '550GA', 'DECATUR VA CLINIC',1009121,1006840, '3035 EAST MOUND ROAD',NULL,NULL, 'DECATUR',1009317,NULL, '62526-9381',1006840, '3035 EAST MOUND ROAD',NULL,NULL, 'DECATUR',1009317,NULL, '62526-9381',1009148, '0',1000151,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001016,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'MANTENO', '550GB', 'ZZMANTENO',1009121,1006840, '1 VETERANS DRIVE',NULL,NULL, 'MANTENO',1009317,NULL, '60950',1006840, '1 VETERANS DRIVE',NULL,NULL, 'MANTENO',1009317,NULL, '60950',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001018,NULL,NULL, 'SPRINGFIELD VA CLINIC', '550GD', 'SPRINGFIELD VA CLINIC',1009121,1006840, '5850 S 6TH ST FRONTAGE RD EAST #A',NULL,NULL, 'SPRINGFIELD',1009317,NULL, '62703-5162',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000151,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001020,NULL,NULL, 'DANVILLE PRRTP', '550PA', 'DANVILLE PRRTP',1009121,1006840, '1900 EAST MAIN STREET',NULL,NULL, 'DANVILLE',1009317,NULL, '61832-5100',1006840, '1900 EAST MAIN STREET',NULL,NULL, 'DANVILLE',1009317,NULL, '61832-5100',1009204, '0',1000151,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001021,NULL,NULL, 'DAYTON (NHCU)', '5529AA', 'DAYTON (NHCU)',1009121,1006840, '4100 W. THIRD STREET',NULL,NULL, 'DAYTON',1009339,NULL, '45428',1006840, '4100 W. THIRD STREET',NULL,NULL, 'DAYTON',1009339,NULL, '45428',1009185, '0',1000152,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001022,NULL,NULL, 'MIDDLETOWN CBOC', '552GA', 'MIDDLETOWN',1009121,1006840, '4337 N. UNION RD',NULL,NULL, 'MIDDLETOWN',1009339,NULL, '45005-5211',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000152,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001023,NULL,NULL, 'LIMA CBOC', '552GB', 'LIMA',1009121,1006840, '1303 BELLEFONTAINE AVE',NULL,NULL, 'LIMA',1009339,NULL, '45804-2850',1006840, '1303 BELLEFONTAINE AVE',NULL,NULL, 'LIMA',1009339,NULL, '45804-2850',1009148, '0',1000152,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001025,TO_DATE('4/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SPRINGFIELD CBOC', '552GD', 'SPRINGFIELD CBOC',1009121,1006840, '512 S BURNETT ROAD',NULL,NULL, 'SPRINGFIELD',1009339,NULL, '45505-4823',1006840, '512 S BURNETT ROAD',NULL,NULL, 'SPRINGFIELD',1009339,NULL, '45505-4823',1009148, '0',1000152,1001026,NULL,1002210,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001026,NULL,TO_DATE('4/1/99' , 'mm/dd/yyyy hh:mi:ss AM'), 'SPRINGFIELD', '552HA', 'ZZSPRINGFIELD',1009121,1006840, 'BARKHARDT RD',NULL,NULL, 'SPRINGFIELD',1009339,NULL, '45503',1006840, 'BARKHARDT RD',NULL,NULL, 'SPRINGFIELD',1009339,NULL, '45503',1009198, '0',NULL,NULL,1001025,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001027,NULL,NULL, 'ALLEN PARK VA NURSING HOME', '5539AA', 'ALLEN PARK VA NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'ALLEN PARK',1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000153,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/14/2014 7:35:51 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0912 07/02/2014');
Insert into sdsadm.STD_Institution values(1001029,NULL,NULL, 'OSCODA AFB', '553CZ', 'OSCODA AFB',1009122,1006840,NULL,NULL,NULL,NULL,1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',1000153,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001030,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ 553DT', '553DT', 'ZZ 553DT',1009121,1006840,NULL,NULL,NULL, 'GRAND RAPIDS',1009326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001031,NULL,NULL, 'YALE VA CLINIC', '553GA', 'YALE VA CLINIC',1009121,1006840, '7470 BROCKWAY RD',NULL,NULL, 'YALE',1009326,NULL, '48097-3458',1006840, '7470 BROCKWAY RD',NULL,NULL, 'YALE',1009326,NULL, '48097-3458',1009148, '0',1000153,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001032,NULL,NULL, 'PONTIAC VA CLINIC', '553GB', 'PONTIAC VA CLINIC',1009121,1006840, '44200 WOODWARD AVENUE SUITE 208',NULL,NULL, 'PONTIAC',1009326,NULL, '48341-3412',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000153,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001033,NULL,NULL, 'DENVER NHC', '5549AA', 'DENVER NHC',1009121,1006840,NULL,NULL,NULL, 'DENVER',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001034,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PUEBLO NURSING HOME CARE UNIT', '5549AB', 'PUEBLO NHCU',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000154,1001129,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001035,NULL,NULL, 'HAOME LAKE STATE HOME', '5549AF', 'HAOME LAKE STATE HOME',1009121,1006840,NULL,NULL,NULL, 'HOME LAKE',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001036,NULL,NULL, 'FLORENCE STATE HOME', '5549AG', 'FLORENCE STATE HOME',1009121,1006840,NULL,NULL,NULL, 'FLORENCE',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001037,NULL,NULL, 'RIFLE STATE HOME', '5549AH', 'RIFLE STATE HOME',1009121,1006840,NULL,NULL,NULL, 'RIFLE',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001038,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PUEBLO VA CLC', '554A4', 'PUEBLO VA CLC',1009121,1006840, '2600 Oakshire La',NULL,NULL, 'Pueblo',1009308,NULL, '81001-5671',1006840, '2600 Oakshire Lane',NULL,NULL, 'Pueblo',1009308,NULL, '81001-5671',1009185, '0',1000154,1000164,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001039,NULL,NULL, 'DENVER (DENT)', '554BY', 'DENVER (DENT)',1009121,1006840, '1055 Clermont Street',NULL,NULL, 'DENVER',1009308,NULL, '80220',1006840, '1055 Clermont Street',NULL,NULL, 'Denver',1009308,NULL, '80220',1009160, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001040,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'FITZSIMONS ARMY MED CENTER', '554CN', 'ZZFITZSIMONS ARMY MED CTR',1009124,1006840, '13001 E 17TH PLACE',NULL,NULL, 'Aurora',1009308,NULL, '80045',1006840, '13001 E 17TH PLACE',NULL,NULL, 'Aurora',1009308,NULL, '80045',1009226, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001041,NULL,NULL, 'EVANS ARMY COMMUNITY HOSPITAL', '554CP', 'EVANS ARMY COMMUNITY HOSPITAL',1009124,1006840, '7500 COCHRANE',NULL,NULL, 'FT CARSON',1009308,NULL, '80913-4603',1006840, '7500 COCHRANE',NULL,NULL, 'FT CARSON',1009308,NULL, '80913-4603',1009226, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001043,NULL,NULL, 'HOMELAKE STATE VETS CENTER', '554DT', 'HOMELAKE STATE VETS CENTER',1009121,1006840, 'COLO STATE VET CENTER NURSING HOME',NULL,NULL, 'HOMELAKE',1009308,NULL, '81135',1006840, 'COLO STATE VET CENTER NURSING HOME',NULL,NULL, 'HOMELAKE',1009308,NULL, '81135',1009221, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001044,NULL,NULL, 'FLORENCE STATE VETS NURS. HOME', '554DU', 'FLORENCE STATE VETS NURS. HOME',1009121,1006840, 'COLORADO STATE NURSING HOME',NULL,NULL, 'FLORENCE',1009308,NULL, '81226',1006840, 'COLORADO STATE NURSING HOME',NULL,NULL, 'FLORENCE',1009308,NULL, '81226',1009221, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001045,NULL,NULL, 'RIFLE STATE VETS NURSING HOME', '554DV', 'RIFLE STATE VETS NURSING HOME',1009121,1006840, 'COLORADO STATE NURSING HOME',NULL,NULL, 'RIFLE',1009308,NULL, '81650',1006840, 'BOX 1420',NULL,NULL, 'RIFLE',1009308,NULL, '81650',1009221, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001046,NULL,NULL, 'WALSENBURG STATE VETS NH', '554DW', 'WALSENBURG STATE VETS NH',1009121,1006840, '23500 US HIGHWAY 160',NULL,NULL, 'WALSENBURG',1009308,NULL, '81089',1006840, '23500 US HIGHWAY 160',NULL,NULL, 'WALSENBURG',1009308,NULL, '81089',1009221, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001047,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'COLORADO SPRINGS', '554GA', 'ZZCOLORADO SPRINGS',1009121,1006840, '1785 n. Academy',NULL,NULL, 'Colorado Springs',1009308,NULL, '80913',1006840, '1785 N. Academy',NULL,NULL, 'Colorado Springs',1009308,NULL, '80913',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001048,NULL,NULL, 'AURORA VA CLINIC', '554GB', 'AURORA VA CLINIC',1009121,1006840, '13701 E. MISSISSIPPI AVE',NULL,NULL, 'AURORA',1009308,NULL, '80012-6141',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001049,NULL,NULL, 'GOLDEN VA CLINIC', '554GC', 'GOLDEN VA CLINIC',1009121,1006840, '1020 JOHNSON RD',NULL,NULL, 'GOLDEN',1009308,NULL, '80401-6002',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001050,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PUEBLO VA CLINIC', '554GD', 'PUEBLO VA CLINIC',1009121,1006840, '4112 OUTLOOK BOULEVARD',NULL,NULL, 'PUEBLO',1009308,NULL, '81008-1667',1006840, '4112 OUTLOOK BOULEVARD',NULL,NULL, 'PUEBLO',1009308,NULL, '81008-1667',1009148, '0',1000154,1001130,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001051,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'FLOYD K. LINDSTROM VA CLINIC', '554GE', 'FLOYD K. LINDSTROM VA CLINIC',1009121,1006840, '3141 CENTENNIAL BLVD',NULL,NULL, 'COLORADO SPRINGS',1009308,NULL, '80907-9998',1006840, '3141 CENTENNIAL BLVD',NULL,NULL, 'COLORADO SPRINGS',1009308,NULL, '80907-9998',1009148, '0',1000154,1001131,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 8:55:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0931 06/03/2015');
Insert into sdsadm.STD_Institution values(1001052,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ALAMOSA VA CLINIC', '554GF', 'ALAMOSA VA CLINIC',1009121,1006840, '622 DEL SOL DRIVE',NULL,NULL, 'ALAMOSA',1009308,NULL, '81101-8548',1006840, '622 DEL SOL DRIVE',NULL,NULL, 'ALAMOSA',1009308,NULL, '81101-8548',1009148, '0',1000154,1001132,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001054,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LAMAR VA CLINIC', '554GH', 'LAMAR VA CLINIC',1009121,1006840, '1401 SOUTH MAIN STREET',NULL,NULL, 'LAMAR',1009308,NULL, '81052-3821',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000154,1001133,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001055,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'FT. COLLINS', '554HA', 'ZZFT. COLLINS',1009121,1006840, 'AMERICAN LEGION HALL',NULL,NULL, 'FT COLLINS',1009308,NULL, '80511',1006840, 'AMERICAN LEGION HALL',NULL,NULL, 'FORT COLLINS',1009308,NULL, '80511',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001056,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'FT. MORGAN', '554HB', 'ZZFT. MORGAN',1009121,1006840, '208 W. Beaver Street',NULL,NULL, 'FORT MORGAN',1009308,NULL, '80701',1006840, '208 W. Beaver Street',NULL,NULL, 'FORT MORGAN',1009308,NULL, '80701',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001058,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'PUEBLO OUTREACH CLINIC', '554HD', 'ZZPUEBLO',1009121,1006840, 'VA Outreach Clinic',NULL,NULL, 'Pueblo',1009308,NULL, '81003',1006840, '909 N. Elizabeth',NULL,NULL, 'Pueblo',1009308,NULL, '81003',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001059,NULL,NULL, 'DENVER PRRTP', '554PA', 'DENVER',1009121,1006840, '1055 CLERMONT ST.',NULL,NULL, 'DENVER',1009308,NULL, '80220-3808',1006840, '1055 Clermont Street',NULL,NULL, 'Denver',1009308,NULL, '80220-3808',1009204, '0',1000154,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001060,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ DES MOINES NHC', '5559AA', 'ZZ DES MOINES NHC',1009121,1006840,NULL,NULL,NULL, 'DES MOINES',1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001061,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARSHALLTOWN STNB', '5559AF', 'ZZ MARSHALLTOWN STNB',1009121,1006840,NULL,NULL,NULL, 'MARSHALLTOWN',1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001062,TO_DATE('10/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA CENTRAL IOWA HEALTH CARE SYSTEM - KNOXVILLE DIVISION', '555A4', 'ZZ KNOXVILLE VAMC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,1000183,1001599,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001063,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ DES MOINES DOM', '555BU', 'ZZ DES MOINES DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1001601,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1001064,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ KNOXVILLE DOM', '555BV', 'ZZ KNOXVILLE DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1001602,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001065,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'MARSHALLTOWN STATE DOMICILIARY', '555DT', 'ZZ MARSHALLTOWN STDM',1009121,1006840,NULL,NULL,NULL, 'MARSHALLTOWN',1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009219, '0',NULL,NULL,1001607,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001067,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MASON CITY CBOC', '555GA', 'ZZ MASON CITY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001068,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARSHALLTOWN ORC', '555HA', 'ZZ MARSHALLTOWN ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001069,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MASON CITY ORC', '555HB', 'ZZ MASON CITY ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001613,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1001070,TO_DATE('10/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ OTTUMWA ORC', '555HC', 'ZZ OTTUMWA ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,1001318,1001615,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001072,NULL,NULL, 'NORTH CHICAGO (NHC)', '5569AA', 'NORTH CHICAGO (NHC)',1009121,1006840,NULL,NULL,NULL, 'MORTH CHICAGO',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000156,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001073,NULL,NULL, 'NORTH CHICAGO (DOM)', '556BU', 'NORTH CHICAGO (DOM)',1009121,1006840, '3001 GREEN BAY ROAD',NULL,NULL, 'NORTH CHICAGO',1009317,NULL, '60064-3048',1006840, '3001 GREEN BAY ROAD',NULL,NULL, 'NORTH CHICAGO',1009317,NULL, '60064-3048',1009158, '0',1000156,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001074,NULL,NULL, 'EVANSTON CBOC', '556GA', 'EVANSTON CBOC',1009121,1006840, '1942 DEMPSTER',NULL,NULL, 'EVANSTON',1009317,NULL, '60202-1016',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000156,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1001075,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GURNEE CBOC', '556GB', 'ZZ GURNEE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL, '0',1006840,NULL,NULL,NULL,NULL,1009317,NULL, '0',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001076,NULL,NULL, 'MCHENRY CBOC', '556GC', 'MCHENRY CBOC',1009121,1006840, '620 SOUTH ROUTE 31',NULL,NULL, 'MCHENRY',1009317,NULL, '60050-3134',1006840, '620 SOUTH ROUTE 31',NULL,NULL, 'MCHENRY',1009317,NULL, '60050-3134',1009148, '0',1000156,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:34:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 02/17/2009 changes');
Insert into sdsadm.STD_Institution values(1001077,NULL,NULL, 'KENOSHA CBOC', '556GD', 'KENOSHA CBOC',1009121,1006840, '800 55TH STREET',NULL,NULL, 'KENOSHA',1009355,NULL, '53140-3733',1006840, '800 55TH STREET',NULL,NULL, 'KENOSHA',1009355,NULL, '53140-3733',1009148, '0',1000156,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001078,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ROCKFORD ORC', '556HA', 'ZZ ROCKFORD ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL, '0',1006840,NULL,NULL,NULL,NULL,1009317,NULL, '0',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001079,NULL,NULL, 'NORTH CHICAGO (PRRTP)', '556PA', 'NORTH CHICAGO (PRRTP)',1009121,1006840, '3001 GREEN BAY ROAD',NULL,NULL, 'NORTH CHICAGO',1009317,NULL, '60064-3048',1006840, '3001 GREEN BAY ROAD',NULL,NULL, 'NORTH CHICAGO',1009317,NULL, '60064-3048',1009204, '0',1000156,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001080,NULL,NULL, 'DUBLIN VANB', '5579AA', 'DUBLIN VANB',1009121,1006840,NULL,NULL,NULL, 'DUBLIN',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000157,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001081,NULL,NULL, 'MILLEDGEVILLE STATE HOME', '5579AF', 'MILLEDGEVILLE STATE HOME',1009121,1006840,NULL,NULL,NULL, 'MILLEDGEVILLE',1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000157,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001082,NULL,NULL, 'DUBLIN DOMICILIARY', '557BU', 'DUBLIN DOM',1009121,1006840, 'CARL VINSON VAMC (DOMICILIARY)',NULL,NULL, 'DUBLIN',1009313,NULL, '31021-3620',1006840, 'CARL VINSON VAMC (DOMICILIARY)',NULL,NULL, 'DUBLIN',1009313,NULL, '31021-3620',1009158, '0',1000157,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001083,NULL,NULL, 'GWVH DOMICILIARY MILLEDGEVILLE', '557DT', 'MILLEDGEVILLE',1009121,1006840, '2249 VINSON HWY',NULL,NULL, 'MILLEDGEVILLE',1009313,NULL, '31061',1006840, '2249 VINSON HIGHWAY',NULL,NULL, 'MILLEDGEVILLE',1009313,NULL, '31061',1009219, '0',1000157,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001084,NULL,NULL, 'MACON VA CBOC', '557GA', 'MACON CBOC',1009121,1006840, '5398 THOMASTON RD',NULL,NULL, 'MACON',1009313,NULL, '31220-8110',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000157,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:26 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0777 04/17/2012');
Insert into sdsadm.STD_Institution values(1001108,NULL,NULL, 'MORRIS PLAINS CBOC', '561GH', 'MORRIS PLAINS CBOC',1009121,1006840, '340 WEST HANOVER AVENUE',NULL,NULL, 'MORRISTOWN',1009334,NULL, '07960-2777',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000159,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001110,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ HACKENSACK', '561HA', 'ZZ HACKENSACK',1009121,1006840, '385 PROSPECT AVENUE',NULL,NULL, 'HACKENSACK',1009334,NULL, '7601',1006840, '385 PROSPECT AVENUE',NULL,NULL, 'HACKENSACK',1009334,NULL, '7601',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001111,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'JAMESBURG', '561HB', 'ZZ-JAMESBURG',1009121,1006840, '74 WEST RAILROAD AVE',NULL,NULL, 'JAMESBURG',1009334,NULL, '08831-1359',1006840, '74 WEST RAILROAD AVE',NULL,NULL, 'JAMESBURG',1009334,NULL, '08831-1359',1009198, '0',1000159,1001374,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001112,NULL,NULL, 'NEW JERSEY HEALTH CARE SYSTEM - PRRTP', '561PA', 'NJH-PRRTP',1009121,1006840, '151 KNOLLCROFT ROAD',NULL,NULL, 'LYONS',1009334,NULL, '07939-5001',1006840, '151 KNOLLCROFT ROAD',NULL,NULL, 'LYONS',1009334,NULL, '07939-5001',1009204, '0',1000159,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001113,NULL,NULL, 'ERI (NHC)', '5629AA', 'ERI (NHC)',1009121,1006840,NULL,NULL,NULL, 'ERIE',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000160,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001114,NULL,NULL, 'ERI (STNB)', '5629AF', 'ERI (STNB)',1009121,1006840,NULL,NULL,NULL, 'ERIE',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000160,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001115,NULL,NULL, 'ERIE SOLDIERS    SAILORS HOME', '562DT', 'ERIE S',1009121,1006840, '560 E 3RD ST',NULL,NULL, 'ERIE',1009342,NULL, '16507',1006840, 'PO BOX 6239',NULL,NULL, 'ERIE',1009342,NULL, '16507',1009221, '0',1000160,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001116,NULL,NULL, 'CRAWFORD COUNTY VA CLINIC', '562GA', 'CRAWFORD COUNTY VA CLINIC',1009121,1006840, '16954 CONNEAUT LAKE ROAD',NULL,NULL, 'MEADVILLE',1009342,NULL, '16335-3738',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000160,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001117,NULL,NULL, 'ASHTABULA COUNTY VA CLINIC', '562GB', 'ASHTABULA COUNTY VA CLINIC',1009121,1006840, '2044 LAMBROS LANE',NULL,NULL, 'ASHTABULA',1009339,NULL, '44004-2700',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000160,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001118,NULL,NULL, 'MCKEAN COUNTY VA CLINIC', '562GC', 'MCKEAN COUNTY VA CLINIC',1009121,1006840, '23 KENNEDY STREET',NULL,NULL, 'BRADFORD',1009342,NULL, '16701-2065',1006840, '23 KENNEDY STREET',NULL,NULL, 'BRADFORD',1009342,NULL, '16701-2065',1009148, '0',1000160,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001119,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FAYETTEVILLE AR-VANB', '5649AA', 'ZZ FAYETTEVILLE AR-VANB',1009121,1006840, 'NA',NULL,NULL, 'FAYETTEVILLE',1009305,NULL, '72703',1006840, 'NA',NULL,NULL, 'FAYETTEVILLE',1009305,NULL, '72703',1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001120,NULL,NULL, 'MOUNT VERNON-SOC', '564BY', 'MOUNT VERNON-SOC',1009121,1006840, '600 MAIN STREET',NULL,NULL, 'MOUNT VERNON',1009329,NULL, '65712-1004',1006840, '600 MAIN STREET',NULL,NULL, 'MOUNT VERNON',1009329,NULL, '65712-1004',1009197, '0',1000161,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001121,NULL,NULL, 'HARRISON VA CLINIC', '564GA', 'HARRISON VA CLINIC',1009121,1006840, '707 N MAIN',NULL,NULL, 'HARRISON',1009305,NULL, '72601-2912',1006840, '707 N MAIN',NULL,NULL, 'HARRISON',1009305,NULL, '72601-2912',1009148, '0',1000161,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001122,NULL,NULL, 'FORT SMITH VA CLINIC', '564GB', 'FORT SMITH VA CLINIC',1009121,1006840, '1500 DODSON',NULL,NULL, 'FORT SMITH',1009305,NULL, '72901-5182',1006840, 'PO BOX 2406',NULL,NULL, 'FORT SMITH',1009305,NULL, '72902',1009148, '0',1000161,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001123,NULL,NULL, 'FAYETTEVILLE CLC', '5659AA', 'FAYETTEVILLE CLC',1009121,1006840, '2300 RAMSEY ST',NULL,NULL, 'FAYETTEVILLE',1009337,NULL, '28301',1006840, '2300 RAMSEY ST',NULL,NULL, 'FAYETTEVILLE',1009337,NULL, '28311',1009185, '0',1000162,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/14/2014 7:35:51 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0912 07/02/2014');
Insert into sdsadm.STD_Institution values(1001125,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FAYETTEVILLE CBOC', '565GB', 'ZZ FAYETTEVILLE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001127,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'FAYETTEVILLE CBOC', '565HK', 'ZZFAYETTEVILLE CBOC',1009121,1006840, '2300 RAMSEY ST',NULL,NULL, 'FAYETTEVILLE',1009337,NULL, '28301',1006840, '2300 RAMSEY ST',NULL,NULL, 'FAYETTEVILLE',1009337,NULL, '28301',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001129,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'FOR LYON NURSING HOME CARE UNIT (5679AA)', '5679AA', 'ZZ FORT LYON NHC',1009121,1006840,NULL,NULL,NULL, 'FORT LYON',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,1001034,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001130,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'PUEBLO COMMUNITY BASED OUTPATIENT CLINIC (567GA)', '567GA', 'ZZ PUEBLO CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001050,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001131,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'COLORADO SPRINGS COMMUNITY BASED OUTPATIENT CLINIC (567GB)', '567GB', 'ZZ COLORADO SPRINGS',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001051,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001132,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ALAMOSA COMMUNITY BASED OUTPATIENT CLINIC (567GC)', '567GC', 'ZZ ALAMOSA',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001052,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001133,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'LAMAR COMMUNITY BASED OUTPATIENT CLINIC (567GD)', '567GD', 'ZZ LAMAR CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001054,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001134,NULL,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'LA JUNTA COMMUNITY BASED OUTPATIENT CLINIC (567GE)', '567GE', 'ZZ LA JUNTA CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001053,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001135,NULL,NULL, 'LA JUNTA ORC', '567HA', 'LA JUNTA ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000164,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001136,NULL,NULL, 'FORT MEADE NHC', '5689AA', 'FORT MEADE NHC',1009121,1006840, '113 COMANCHE RD',NULL,NULL, 'FORT MEADE',1009346,NULL, '57741',1006840, '113 COMANCHE RD',NULL,NULL, 'FORT MEADE',1009346,NULL, '57741',1009185, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001138,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'HOT SPRINGS DOM', '568BU', 'HOT SPRINGS DOM',1009121,1006840, '500 N. 5TH STREET',NULL,NULL, 'HOT SPRINGS',1009346,NULL, '57747-1480',1006840, 'VA MEDICAL CENTER',NULL,NULL, 'HOT SPRINGS',1009346,NULL, '57747-1480',1009158, '0',1000165,1001205,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001139,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'HOT SPRINGS STATE DOM', '568DT', 'HOT SPRINGS STATE DOM',1009121,1006840, '2500 MINNEKAHTA AVE',NULL,NULL, 'HOT SPRINGS',1009346,NULL, '57747',1006840, '2500 MINNEKAHTA AVE',NULL,NULL, 'HOT SPRINGS',1009346,NULL, '57747',1009221, '0',1000165,1001206,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001140,NULL,NULL, 'RAPID CITY CBOC', '568GA', 'RAPID CITY CBOC',1009121,1006840, '3625 5TH STREET',NULL,NULL, 'RAPID CITY',1009346,NULL, '57701-6015',1006840, '3625 5TH STREET',NULL,NULL, 'RAPID CITY',1009346,NULL, '57701-6015',1009148, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001142,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZALLIANCE', '568GC', 'ZZALLIANCE',1009121,1006840, '524 BOX BUTTE AVENUE',NULL,NULL, 'ALLIANCE',1009331,NULL, '69301',1006840, '524 BOX BUTTE AVENUE',NULL,NULL, 'ALLIANCE',1009331,NULL, '69301',1009148, '0',NULL,1001209,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001143,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'NEWCASTLE', '568HA', 'NEWCASTLE',1009121,1006840, '1124 WASHINGTON BLVD',NULL,NULL, 'NEWCASTLE',1009356,NULL, '82701-2331',1006840, 'VFW POST',NULL,NULL, 'NEWCASTLE',1009356,NULL, '82701-2331',1009148, '0',1000165,1001207,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001144,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'GORDON CBOC', '568HB', 'GORDON CBOC',1009121,1006840, '300 E 8TH STREET',NULL,NULL, 'GORDON',1009331,NULL, '69343-1123',1006840, '300 E 8TH STREET',NULL,NULL, 'GORDON',1009331,NULL, '69343-1123',1009148, '0',1000165,1001208,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001145,NULL,TO_DATE('10/26/2010' , 'mm/dd/yyyy hh:mi:ss AM'), 'ALLIANCE', '568HC', 'ZZ-ALLIANCE',1009121,1006840, '524 BOX BUTTE AVENUE',NULL,NULL, 'ALLIANCE',1009331,NULL, '69301',1006840, '524 BOX BUTTE AVENUE',NULL,NULL, 'ALLIANCE',1009331,NULL, '69301',1009148, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001146,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ELLSWORTH AFB', '568HD', 'ELLSWORTH AFB',1009121,1006840, '2900 DOOLITTLE DRIVE',NULL,NULL, 'ELLSWORTH AIR FORCE BASE',1009346,NULL, '57706',1006840, '2900 DOOLITTLE DRIVE',NULL,NULL, 'ELLSWORTH AIR FORCE BASE',1009346,NULL, '57706',1009198, '0',1000165,1001210,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001147,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'KYLE', '568HE', 'ZZ-KYLE VA CLINIC',1009121,1006840, 'IHS HEALTH CARE',NULL,NULL, 'KYLE',1009346,NULL, '57752',1006840, 'IHS HEALTH CARE',NULL,NULL, 'KYLE',1009346,NULL, '57752',1009198, '0',1000165,1001211,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001148,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PINE RIDGE', '568HF', 'PINE RIDGE',1009121,1006840, '500 NORTH 5TH STREET',NULL,NULL, 'HOT SPRINGS',1009346,NULL, '57747-1480',1006840, '500 NORTH 5TH STREET',NULL,NULL, 'HOT SPRINGS',1009346,NULL, '57747-1480',1009148, '0',1000165,1001212,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001149,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SIOUX SAN', '568HG', 'SIOUX SAN',1009121,1006840, '3200 CANYON LAKE DRIVE',NULL,NULL, 'RAPID CITY',1009346,NULL, '57702-8114',1006840, '3200 CANYON LAKE DRIVE',NULL,NULL, 'RAPID CITY',1009346,NULL, '57702-8114',1009198, '0',1000165,1001213,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001150,NULL,NULL, 'SCOTTSBLUFF CBOC', '568HH', 'SCOTTSBLUFF CBOC',1009121,1006840, '1720 EAST PORTAL ST',NULL,NULL, 'SCOTTSBLUFF',1009331,NULL, '69361-2748',1006840, '1720 EAST PORTAL ST',NULL,NULL, 'SCOTTSBLUFF',1009331,NULL, '69361-2748',1009148, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001151,NULL,NULL, 'MISSION CBOC', '568HJ', 'MISSION CBOC',1009121,1006840, '153 S. MAIN STREET',NULL,NULL, 'MISSION',1009346,NULL, '57555-9998',1006840, 'MISSION MEDICAL CLINIC',NULL,NULL, 'MISSION',1009346,NULL, '57555-9998',1009148, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001152,NULL,NULL, 'MCLAUGHLIN', '568HK', 'MCLAUGHLIN',1009121,1006840, 'SALES BARN RD',NULL,NULL, 'MCLAUGHLIN',1009346,NULL, '57642-9998',1006840, 'SALES BARN RD',NULL,NULL, 'MCLAUGHLIN',1009346,NULL, '57642-9998',1009148, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001153,NULL,NULL, 'EAGLE BUTTE', '568HM', 'EAGLE BUTTE',1009121,1006840, '8000 HWY 212',NULL,NULL, 'EAGLE BUTTE',1009346,NULL, '57625-9998',1006840, '8000 HWY 212',NULL,NULL, 'EAGLE BUTTE',1009346,NULL, '57625-9998',1009148, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001154,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'LAME DEER', '568HN', 'ZZ-LAME DEER',1009121,1006840, 'CHEYENNE RECOVERY CENTER',NULL,NULL, 'LAME DEER',1009330,NULL, '59043',1006840, 'TRIBAL HEALTH BUILDING',NULL,NULL, 'LAME DEER',1009330,NULL, '59043',1009198, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001155,NULL,NULL, 'WINNER', '568HP', 'WINNER',1009121,1006840, '1436 EAST 10TH',NULL,NULL, 'WINNER',1009346,NULL, '57580-2873',1006840, 'SCHRAMM MEDICAL CLINIC AVERA HEALTH',NULL,NULL, 'WINNER',1009346,NULL, '57580-2873',1009148, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001156,NULL,NULL, 'BHH-PRRTP', '568PA', 'BHH-PRRTP',1009121,1006840, '113 COMANCHE ROAD',NULL,NULL, 'FORT MEADE',1009346,NULL, '57741-1002',1006840, '113 COMANCHE ROAD',NULL,NULL, 'FORT MEADE',1009346,NULL, '57741-1002',1009204, '0',1000165,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001157,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FORT WAYNE', '5699AA', 'ZZ FORT WAYNE',1009121,1006840,NULL,NULL,NULL, 'FORT WAYNE',1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001158,NULL,NULL, 'FRESNO NHC', '5709AA', 'FRESNO NHC',1009121,1006840,NULL,NULL,NULL, 'FRESNO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000167,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001159,NULL,NULL, 'MERCED VA CLINIC', '570GA', 'MERCED VA CLINIC',1009121,1006840, '340 E. YOSEMITE AVENUE',NULL,NULL, 'MERCED',1009306,NULL, '95340-9167',1006840, '340 E. YOSEMITE AVENUE',NULL,NULL, 'MERCED',1009306,1012926, '95340-9167',1009148, '0',1000167,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001160,NULL,NULL, 'TULARE VA CLINIC', '570GB', 'TULARE VA CLINIC',1009121,1006840, '1050 N CHERRY ST',NULL,NULL, 'TULARE',1009306,NULL, '93274-2251',1006840, '1050 N CHERRY ST',NULL,NULL, 'TULARE',1009306,1012918, '93274-2251',1009148, '0',1000167,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001161,NULL,TO_DATE('10/15/2007' , 'mm/dd/yyyy hh:mi:ss AM'), 'FRESNO PRRTP', '570PA', 'FRESNO PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',NULL,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001162,NULL,NULL, 'GAINESVILLE NHC', '5739A', 'GAINESVILLE NHC',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('7/8/2014 7:27:25 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0909 06/09/2014');
Insert into sdsadm.STD_Institution values(1001163,NULL,NULL, 'GAINESVILLE NHCU', '5739AA', 'GAINESVILLE (NHCU)',1009121,1006840, '1601 S.W. ARCHER ROAD',NULL,NULL, 'GAINESVILLE',1009312,NULL, '32608',1006840, '1601 S.W. ARCHER ROAD',NULL,NULL, 'GAINESVILLE',1009312,NULL, '32608',1009185, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001164,NULL,NULL, 'LAKE CITY NHC', '5739B', 'LAKE CITY NHC',1009121,1006840, '619 S. MARION AVE',NULL,NULL, 'LAKE CITY',1009312,NULL, '32025-5808',1006840, '619 S. MARION AVE',NULL,NULL, 'LAKE CITY',1009312,NULL, '32025-5808',1009185, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001165,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LAKE CITY VA MEDICAL CENTER', '573A4', 'LAKE CITY VA MEDICAL CENTER',1009121,1006840, '619 S. MARION AVE.',NULL,NULL, 'LAKE CITY',1009312,NULL, '32025-5808',1006840, '619 S. MARION AVE.',NULL,NULL, 'LAKE CITY',1009312,NULL, '32025-5808',1009231, '0',1000168,1000185,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001166,NULL,NULL, 'JACKSONVILLE 1 VA CLINIC', '573BY', 'JACKSONVILLE 1 VA CLINIC',1009121,1006840, '1536 N JEFFERSON STREET',NULL,NULL, 'JACKSONVILLE',1009312,NULL, '32209',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001167,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'DAYTONA BEACH OPC', '573BZ', 'ZZ-DAYTONA BEACH OPC',1009121,1006840, '551   National Healthcare Drive',NULL,NULL, 'DAYTONA BEACH',1009312,NULL, '32114-1495',1006840, '551 National Healthcare Drive',NULL,NULL, 'DAYTONA BEACH',1009312,NULL, '32114-1495',1009197, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001168,NULL,NULL, 'EMORY L. BENNETT STATE VETERANS NURSING HOME', '573DT', 'DAYTONA VETERANS NURSING HOME',1009121,1006840, '1920 Mason Ave.',NULL,NULL, 'DAYTONA BEACH',1009312,NULL, '32117',1006840, '1920 Mason Ave.',NULL,NULL, 'DAYTONA BEACH',1009312,NULL, '32117',1009221, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001169,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LAKE CITY STATE HOME', '573DU', 'LAKE CITY STATE HOME',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000168,1001326,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001170,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'VALDOSTA CBOC', '573GA', 'VALDOSTA',1009121,1006840, '2841 NORTH PATTERSON ST.',NULL,NULL, 'VALDOSTA',1009313,NULL, '31602-1743',1006840, '2841 NORTH PATTERSON ST.',NULL,NULL, 'VALDOSTA',1009313,NULL, '31602-1743',1009148, '0',1000168,1001327,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001172,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'DAYTONA BEACH CBOC', '573GC', 'DAYTONA BEACH',1009121,1006840, 'UNK',NULL,NULL, 'DAYTONA',1009312,NULL, '11111',1006840, 'UNK',NULL,NULL, 'DAYTONA',1009312,NULL, '11111',1009148, '0',NULL,1001167,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001175,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'TALLAHASSEE VA CLINIC', '573GF', 'TALLAHASSEE VA CLINIC',1009121,1006840, '1607 ST. JAMES CT',NULL,NULL, 'TALLAHASSEE',1009312,NULL, '32308-5352',1006840, '1607 ST. JAMES CT',NULL,NULL, 'TALLAHASSEE',1009312,NULL, '32308-5352',1009197, '0',1000168,1001325,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001177,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'LEESBURG CBOC', '573GH', 'ZZ-LEESBURG CBOC',1009121,1006840, '711 W. Main Street',NULL,NULL, 'LEESBURG',1009312,NULL, '34748',1006840, '711 W. Main Street',NULL,NULL, 'LEESBURG',1009312,NULL, '34748',1009148, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001178,NULL,NULL, 'GAINESVILLE PRRTP', '573PA', 'GAINESVILLE (PRRTP)',1009121,1006840, '1601 SW Archer Road',NULL,NULL, 'Gainesville',1009312,NULL, '32608-1197',1006840, '1601 SW ARCHER ROAD',NULL,NULL, 'GAINESVILLE',1009312,NULL, '32608-1197',1009204, '0',1000168,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001179,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GRAND ISLAND (NHCU)', '5749AA', 'ZZ GRAND ISLAND (NHCU)',1009121,1006840,NULL,NULL,NULL, 'GRAND ISLAND',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001180,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GRAND ISLAND (STNB)', '5749AF', 'ZZ GRAND ISLAND (STNB)',1009121,1006840,NULL,NULL,NULL, 'GRAND ISLAND',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001181,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NORFOLK', '5749AG', 'ZZ NORFOLK',1009121,1006840,NULL,NULL,NULL, 'NORFOLK (ANNEX)',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001182,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ OMAHA', '5749AH', 'ZZ OMAHA',1009121,1006840,NULL,NULL,NULL, 'OMAHA (ANNEX)',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001183,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SCOTTSBLUF', '5749AJ', 'ZZ SCOTTSBLUF',1009121,1006840,NULL,NULL,NULL, 'SCOTTSBLUFF (ANNEX)',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001185,NULL,TO_DATE('10/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NORFOLK STNB', '574DU', 'ZZ NORFOLK STNB',1009121,1006840,NULL,NULL,NULL, 'NORFOLK (ANNEX)',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1001187,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SCOTTSBLUFF', '574DW', 'ZZ SCOTTSBLUFF',1009121,1006840,NULL,NULL,NULL, 'SCOTTSBLUFF (ANNEX)',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009219, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001188,NULL,TO_DATE('10/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NORTH PLATTE CBOC', '574GA', 'ZZ NORTH PLATTE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001345,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001189,NULL,NULL, 'GRAND JUNCTION (NHCU)', '5759AA', 'GRAND JUNCTION (NHCU)',1009121,1006840,NULL,NULL,NULL, 'GRAND JUNCTION',1009308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000170,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001193,NULL,NULL, 'MANTENO ILLINOIS VETERANS HOME', '578DT', 'MANTENO ILLINOIS VETERANS HOME',1009121,1006840,NULL,NULL,NULL, 'HINES',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001194,NULL,NULL, 'LASALLE ILLINOIS VETERANS HOME', '578DU', 'LASALLE ILLINOIS VETERANS HOME',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001195,NULL,NULL, 'JOLIET CBOC (578GA)', '578GA', 'JOLIET CBOC',1009121,1006840, '1201 EAGLE STREET',NULL,NULL, 'JOLIET',1009317,NULL, '60432-9998',1006840, '1201 EAGLE STREET',NULL,NULL, 'JOLIET',1009317,1011806, '60432-9998',1009148, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:17:00 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0853 4/3/2013');
Insert into sdsadm.STD_Institution values(1001196,NULL,TO_DATE('1/8/2007' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-OAK PARK CBOC', '578GB', 'ZZ-OAK PARK CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001197,NULL,NULL, 'KANKAKEE COUNTY CBOC', '578GC', 'KANKAKEE COUNTY CBOC',1009121,1006840, '581 WILLIAM LATHAM DR',NULL,NULL, 'BOURBONNAIS',1009317,NULL, '60914-2317',1006840,NULL,NULL,NULL,NULL,NULL,1011812,NULL,1009148, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1001198,NULL,NULL, 'AURORA CBOC (578GD)', '578GD', 'AURORA CBOC',1009121,1006840, '161 S LINCOLNWAY',NULL,NULL, 'NORTH AURORA',1009317,NULL, '60542-1148',1006840, '161 S LINCOLNWAY',NULL,NULL, 'NORTH AURORA',1009317,1011803, '60542-1148',1009148, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001199,NULL,NULL, 'ELGIN CBOC (578GE)', '578GE', 'ELGIN CBOC',1009121,1006840, '450 WEST DUNDEE #100',NULL,NULL, 'ELGIN',1009317,NULL, '60120-4205',1006840,NULL,NULL,NULL,NULL,NULL,1011803,NULL,1009148, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1001200,NULL,NULL, 'LASSALLE CBOC (578GF)', '578GF', 'LASALLE CBOC',1009121,1006840, '4461 N PROGRESS VILLAGE',NULL,NULL, 'PERU',1009317,NULL, '61354-1109',1006840,NULL,NULL,NULL,NULL,NULL,1011809,NULL,1009148, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1001201,NULL,NULL, 'OAK LAWN CBOC (578GG)', '578GG', 'OAK LAWN CBOC',1009121,1006840, '10201 S CICERO AVE',NULL,NULL, 'OAK LAWN',1009317,NULL, '60453-4023',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000171,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0809 11/19/2012');
Insert into sdsadm.STD_Institution values(1001207,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NEWCASTLE ORC', '579HA', 'ZZ NEWCASTLE ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001143,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001208,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ RUSHVILLE ORC', '579HB', 'ZZ RUSHVILLE ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001144,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001209,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ALLIANCE', '579HC', 'ZZ ALLIANCE',1009121,1006840,NULL,NULL,NULL,NULL,1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001142,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001210,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ELLSWORTH AFB', '579HD', 'ZZ ELLSWORTH AFB',1009121,1006840,NULL,NULL,NULL,NULL,1009346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001146,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001211,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ KYLE ORC', '579HE', 'ZZ KYLE ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001147,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001212,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PINE RIDGE ORC', '579HF', 'ZZ PINE RIDGE ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001148,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001213,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SIOUX SAN ORC', '579HG', 'ZZ SIOUX SAN ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001149,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001214,NULL,NULL, 'HOUSTON (NHCU)', '5809AA', 'HOUSTON (NHCU)',1009121,1006840, '2002 HOLCOMBE BLVD',NULL,NULL, 'HOUSTON',1009348,NULL, '77030',1006840, '2002 HOLCOMBE BLVD',NULL,NULL, 'HOUSTON',1009348,NULL, '77030',1009185, '0',1000173,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001215,NULL,NULL, 'BEAUMONT', '580BY', 'BEAUMONT OPC',1009121,1006840, '3420 Veterans Circle',NULL,NULL, 'BEAUMONT',1009348,NULL, '77707-2552',1006840, '3420 Veterans Circle',NULL,NULL, 'BEAUMONT',1009348,NULL, '77707-2552',1009197, '0',1000173,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001216,NULL,NULL, 'LUFKIN OUTPATIENT CLINIC', '580BZ', 'LUFKIN',1009121,1006840, '2206 N. JOHN REDDITT DR',NULL,NULL, 'LUFKIN',1009348,NULL, '75904-1776',1006840, '2206 N. JOHN REDDITT DR',NULL,NULL, 'LUFKIN',1009348,NULL, '75904-1776',1009197, '0',1000173,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001217,NULL,NULL, 'HOUSTON CBOC', '580GA', 'HOUSTON (CBOC)',1009121,1006840, '1418 PRESTON ST',NULL,NULL, 'HOUSTON',1009348,NULL, '77002-2192',1006840, '1418 PRESTON ST',NULL,NULL, 'HOUSTON',1009348,NULL, '77002-2192',1009148, '0',1000173,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001218,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'GALVESTON CBOC', '580GB', 'ZZHOUSTON (CBOC)',1009121,1006840, '2002 HOLCOMBE BLVD',NULL,NULL, 'HOUSTON',1009348,NULL, '77030',1006840, '2002 HOLCOMBE BLVD',NULL,NULL, 'HOUSTON',1009348,NULL, '77030',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001219,NULL,NULL, 'BARBOURSVILLE STATE HOME', '581DT', 'BARBOURSVILLE VETERANS HOME',1009121,1006840, '512 WATER STREET',NULL,NULL, 'BARBOURSVILLE',1009354,NULL, '25504',1006840, '512 WATER STREET',NULL,NULL, 'BARBOURSVILLE',1009354,NULL, '25504',1009221, '0',1000174,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001221,NULL,NULL, 'CHARLESTON VA CLINIC', '581GB', 'CHARLESTON VA CLINIC',1009121,1006840, '104 ALEX LANE',NULL,NULL, 'CHARLESTON',1009354,NULL, '25304-2952',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000174,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001222,NULL,NULL, 'WHITESBURG CBOC', '581GC', 'WHITESBURG CBOC',1009121,1006840, '226 MEDICAL PLAZA LANE',NULL,NULL, 'WHITESBURG',1009321,NULL, '41858',1006840, '226 MEDICAL PLAZA LANE',NULL,NULL, 'WHITESBURG',1009321,NULL, '41858',1009148, '0',1000174,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001223,NULL,NULL, 'WILLIAMSON CBOC', '581GD', 'WILLIAMSON CBOC',1009121,1006840, '75 WEST FOURTH AVE',NULL,NULL, 'WILLIAMSON',1009354,NULL, '25661-3509',1006840, '75 WEST FOURTH AVE',NULL,NULL, 'WILLIAMSON',1009354,NULL, '25661-3509',1009148, '0',1000174,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001224,NULL,NULL, 'LOGAN CBOC', '581GE', 'LOGAN CBOC',1009121,1006840, '513 DINGESS ST',NULL,NULL, 'LOGAN',1009354,NULL, '25601-3500',1006840, '513 DINGESS ST',NULL,NULL, 'LOGAN',1009354,NULL, '25601-3500',1009148, '0',1000174,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001225,NULL,NULL, 'INDIANAPOLIS NHC', '5839AA', 'INDIANAPOLIS NHC',1009121,1006840,NULL,NULL,NULL, 'INDIANAPOLIS',1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000175,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001226,NULL,NULL, 'INDIANAPOLIS STATE HOME', '5839AF', 'INDIANAPOLIS STATE HOME',1009121,1006840,NULL,NULL,NULL, 'LAYFAYETTE',1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000175,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001227,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZRICHARD L ROUDEBUSH VAMC', '583A4', 'ZZINDIANAPOLIS',1009121,1006840, '1481 W. TENTH STREET',NULL,NULL, 'INDIANAPOLIS',1009318,NULL, '46202',1006840, '1481 W. TENTH STREET',NULL,NULL, 'INDIANAPOLIS',1009318,NULL, '46202',1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001228,NULL,NULL, 'LAFAYETTE STATE HOME', '583DT', 'LAFAYETTE STATE HOME',1009121,1006840, '3851 N RIVER RD',NULL,NULL, 'WEST LAFAYETTE',1009318,NULL, '47906',1006840, '3851 N RIVER RD',NULL,NULL, 'WEST LAFAYETTE',1009318,NULL, '47906',1009221, '0',1000175,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001229,NULL,NULL, 'TERRE HAUTE VA CLINIC', '583GA', 'TERRE HAUTE VA CLINIC',1009121,1006840, '110 W. HONEYCREEK PARKWAY',NULL,NULL, 'TERRE HAUTE',1009318,NULL, '47804-4114',1006840, '110 W. HONEYCREEK PARKWAY',NULL,NULL, 'TERRE HAUTE',1009318,NULL, '47804-4114',1009148, '0',1000175,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001230,NULL,NULL, 'BLOOMINGTON VA CLINIC', '583GB', 'BLOOMINGTON VA CLINIC',1009121,1006840, '455 SOUTH LANDMARK AVE',NULL,NULL, 'BLOOMINGTON',1009318,NULL, '47403-5004',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000175,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001231,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ IOWA CITY', '5849AA', 'ZZ IOWA CITY',1009121,1006840,NULL,NULL,NULL, 'IOWA CITY',1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001232,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ QUINCY', '5849AF', 'ZZ QUINCY',1009121,1006840,NULL,NULL,NULL, 'QUINCY',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001233,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BETTENDORF', '584BY', 'ZZ BETTENDORF',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1001616,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001234,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ILLINOIS', '584DT', 'ZZ ILLINOIS',1009121,1006840,NULL,NULL,NULL, 'QUINCY',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009222, '0',NULL,NULL,1001608,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1001235,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ QUINCY STDM', '584EL', 'ZZ QUINCY STDM',1009121,1006840,NULL,NULL,NULL, 'QUNICY',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009219, '0',NULL,NULL,1001610,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1001236,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ QUINCY CBOC', '584GA', 'ZZ QUINCY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001617,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001237,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WATERLOO CBOC', '584GB', 'ZZ WATERLOO CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001618,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001238,NULL,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GALESBURG CBOC', '584GC', 'ZZ GALESBURG CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001619,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001239,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ DUBUQUE CBOC', '584GD', 'ZZ DUBUQUE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001620,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001240,NULL,NULL, 'IRON MTN NH', '5859AA', 'IRON MTN NH',1009121,1006840, '325 EAST H STREET',NULL,NULL, 'IRON MOUNTAIN',1009326,NULL, '49801',1006840, '325 EAST H STRET',NULL,NULL, 'IRON MOUNTAIN',1009326,NULL, '49801',1009185, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001241,NULL,NULL, 'JACOBETTI NH', '5859AF', 'JACOBETTI NH',1009121,1006840, '425 FISHER STREET',NULL,NULL, 'MARQUETTE',1009326,NULL, '49855',1006840, '425 FISHER STREET',NULL,NULL, 'MARQUETTE',1009326,NULL, '49855',1009221, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001242,NULL,NULL, 'JACOBETTI VETERANS HOME', '585DT', 'JACOBETTI VETERANS HOME',1009121,1006840, '425 FISHER STREET',NULL,NULL, 'MARQUETTE',1009326,NULL, '49885',1006840, '425 FISHER STREET',NULL,NULL, 'MARQUETTE',1009326,NULL, '49855',1009221, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001243,NULL,NULL, 'HANCOCK CBOC', '585GA', 'HANCOCK CBOC',1009121,1006840, '787 MARKET STREET',NULL,NULL, 'HANCOCK',1009326,NULL, '49930-1163',1006840, '787 MARKET STREET',NULL,NULL, 'HANCOCK',1009326,NULL, '49930-1163',1009148, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('7/8/2014 7:27:25 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0909 06/09/2014');
Insert into sdsadm.STD_Institution values(1001244,NULL,NULL, 'RHINELANDER CBOC', '585GB', 'RHINELANDER CBOC',1009121,1006840, '639 WEST KEMP STREET',NULL,NULL, 'RHINELANDER',1009355,NULL, '54501-3879',1006840, '639 WEST KEMP STREET',NULL,NULL, 'RHINELANDER',1009355,NULL, '54501-3879',1009148, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1001245,NULL,NULL, 'MENOMINEE CBOC', '585GC', 'MENOMINEE CBOC',1009121,1006840, '1110 10TH AVENUE SUITE 101',NULL,NULL, 'MENOMINEE',1009326,NULL, '49858-3058',1006840, '1110 10TH AVENUE SUITE 101',NULL,NULL, 'MENOMINEE',1009326,NULL, '49858-3058',1009148, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001246,NULL,NULL, 'IRONWOOD CBOC', '585GD', 'IRONWOOD CBOC',1009121,1006840, '629 W CLOVERLAND DRIVE SIUTE 1',NULL,NULL, 'IRONWOOD',1009326,NULL, '49938-1006',1006840, '629 W CLOVERLAND DRIVE SIUTE 1',NULL,NULL, 'IRONWOOD',1009326,NULL, '49938-1006',1009148, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001247,NULL,NULL, 'MARQUETTE CBOC', '585HA', 'MARQUETTE CBOC',1009121,1006840, '1414 W. FAIR AVENUE SIUTE 285',NULL,NULL, 'MARQUETTE',1009326,NULL, '49855-2675',1006840, '1414 W. FAIR AVENUE SIUTE 285',NULL,NULL, 'MARQUETTE',1009326,NULL, '49855-2675',1009148, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001248,NULL,NULL, 'SAULT SAINT MARIE CBOC', '585HB', 'SAULT SAINT MARIE CBOC',1009121,1006840, '2864 ASHMUN ROAD',NULL,NULL, 'SAULT STE MARIE',1009326,NULL, '49783',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/22/2014 6:42:32 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0922 11/03/2014');
Insert into sdsadm.STD_Institution values(1001249,NULL,NULL, 'IRON MTN PRRTP', '585PA', 'IRON MTN PRRTP',1009121,1006840, '325 EAST H STREET',NULL,NULL, 'IRON MOUNTAIN',1009326,NULL, '49801-4760',1006840, '325 EAST H STREET',NULL,NULL, 'IRON MOUNTAIN',1009326,NULL, '49801-4760',1009204, '0',1000177,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001250,NULL,NULL, 'KOSCIUSKO VA CLINIC', '586GA', 'KOSCIUSKO VA CLINIC',1009121,1006840, '405 WEST ADAMS ST',NULL,NULL, 'KOSCIUSKO',1009328,NULL, '39090-3617',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000178,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 9:56:58 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0932 07/08/2015');
Insert into sdsadm.STD_Institution values(1001251,NULL,NULL, 'MERIDIAN', '586GB', 'MERIDIAN',1009121,1006840, '2103 13TH STREET',NULL,NULL, 'MERIDIAN',1009328,NULL, '39301-4045',1006840, '2103 13TH STREET',NULL,NULL, 'MERIDIAN',1009328,NULL, '39301-4045',1009148, '0',1000178,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001252,NULL,NULL, 'GREENVILLE', '586GC', 'GREENVILLE',1009121,1006840, '1502 S COLORADO ST',NULL,NULL, 'GREENVILLE',1009328,NULL, '38703-7219',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000178,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1001253,NULL,NULL, 'HATTIESBURG', '586GD', 'HATTIESBURG',1009121,1006840, '231 Methodist Boulevard',NULL,NULL, 'HATTIESBURG',1009328,NULL, '39402-1297',1006840, '231 Methodist Boulevard',NULL,NULL, 'HATTIESBURG',1009328,NULL, '39402-1297',1009148, '0',1000178,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001254,NULL,NULL, 'NATCHEZ', '586GE', 'NATCHEZ',1009121,1006840, '105 NORTHGATE DRIVE SUITE 2',NULL,NULL, 'NATCHEZ',1009328,NULL, '39120-9162',1006840, '105 NORTHGATE DRIVE SUITE 2',NULL,NULL, 'NATCHEZ',1009328,NULL, '39120-9162',1009148, '0',1000178,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001255,NULL,NULL, 'JACKSON PRRTP', '586PA', 'JACKSON PRRTP',1009121,1006840, '1500 EAST WOODROW WILSON',NULL,NULL, 'JACKSON',1009328,NULL, '39216-5116',1006840, '1500 EAST WOODROW WILSON',NULL,NULL, 'JACKSON',1009328,NULL, '39216-5116',1009204, '0',1000178,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001256,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'KANSAS CITY VA NURSING HOME CARE UNIT (5899AA)', '5899AA', 'ZZ KANSAS CITY',1009121,1006840,NULL,NULL,NULL, 'KANSAS CITY',1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001258,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'TOPEKA NHCU', '5899AC', 'TOPEKA NHCU',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000180,1001937,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001259,NULL,NULL, 'LEAVENWORTH NHCU', '5899AD', 'LEAVENWORTH NHCU',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:34:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/18/05 changes');
Insert into sdsadm.STD_Institution values(1001260,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'WICHITA NURSING HOME CARE UNIT', '5899AE', 'WICHITA NURSING HOME CARE UNIT',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001261,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'FORT DODGE STATE NURSING DOM', '5899AF', 'FORT DODGE STATE NURSING DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009219, '0',1000180,1000559,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001262,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'HARRY S. TRUMAN VAMC', '589A4', 'HARRY S. TRUMAN VAMC',1009121,1006840, '800 HOSPITAL DRIVE',NULL,NULL, 'COLUMBIA',1009329,NULL, '65201-5275',1006840, '800 HOSPITAL DRIVE',NULL,NULL, 'COLUMBIA',1009329,NULL, '65201-5275',1009231, '0',1000180,1000146,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001263,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'COLMERY O NEIL VAMC', '589A5', 'COLMERY O NEIL VAMC',1009121,1006840, '2200 GAGE BLVD',NULL,NULL, 'TOPEKA',1009320,NULL, '66622-0001',1006840, '2200 GAGE BLVD',NULL,NULL, 'TOPEKA',1009320,NULL, '66622-0001',1009231, '0',1000180,1000255,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001264,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'DWIGHT D. EISENHOWER VAMC', '589A6', 'DWIGHT D. EISENHOWER VAMC',1009121,1006840, '4101 S 4TH STREET TRAFFICWAY',NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048-5014',1006840, '4101 S 4TH STREET TRAFFICWAY',NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048-5014',1009231, '0',1000180,1001939,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001265,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ROBERT J. DOLE  VAMC', '589A7', 'ROBERT J. DOLE  VAMC',1009121,1006840, '5500 E KELLOGG ST',NULL,NULL, 'WICHITA',1009320,NULL, '67218-1607',1006840, '5500 E KELLOGG ST',NULL,NULL, 'WICHITA',1009320,NULL, '67218-1607',1009231, '0',1000180,1000100,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001266,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LEAVENWORTH VA DOMICILIARY (589BU)', '589BU', 'LEAVENWORTH DOMICILIARY',1009121,1006840, '4101 SOUTH 4TH STREET TRAFFICWAY',NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048-5014',1006840, '4101 SOUTH 4TH STREET TRAFFICWAY',NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048-5014',1009158, '0',1001264,1001940,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:08 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0771 02/06/2012');
Insert into sdsadm.STD_Institution values(1001267,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'TOPEKA (PUBLIC HOSPITAL)', '589DH', 'TOPEKA (PUBLIC HOSPITAL)',1009121,1006840, '2200 GAGE BLVD.',NULL,NULL, 'TOPEKA',1009320,NULL, '66622',1006840, '2200 GAGE BLVD.',NULL,NULL, 'TOPEKA',1009320,NULL, '66622',1009153, '0',1000180,1001944,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001273,NULL,NULL, 'WICHITA NON-VA HOSPITALS CIVH', '589DS', 'KANSAS CITY NON-VA HOSP (CIVH)',1009121,1006840, '4801 LINWOOD BVLD',NULL,NULL, 'KANSAS CITY',1009329,NULL, '64128',1006840, '4801 LINWOOD BLVD',NULL,NULL, 'KANSAS CITY',1009329,1011948, '64128',1009153, '0',1000180,NULL,1001271,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:51:25 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/05/2009 changes');
Insert into sdsadm.STD_Institution values(1001274,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ST. JAMES STATE VETERANS HOME', '589DT', 'ST. JAMES STATE VETERANS HOME',1009121,1006840, '620 NORTH JEFFERSON',NULL,NULL, 'ST. JAMES',1009329,NULL, '65559',1006840, '620 NORTH JEFFERSON',NULL,NULL, 'ST. JAMES',1009329,1011995, '65559',1009222, '0',1000180,1001741,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:18:19 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/31/07 changes');
Insert into sdsadm.STD_Institution values(1001276,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MEXICO STATE VETERANS HOME', '589DV', 'MEXICO STATE VETERANS HOME',1009121,1006840, '#1 VETERANS DRIVE',NULL,NULL, 'MEXICO',1009329,NULL, '65265',1006840, '#1 VETERANS DRIVE',NULL,NULL, 'MEXICO',1009329,1011913, '65265',1009222, '0',1000180,1001743,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:18:19 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/31/07 changes');
Insert into sdsadm.STD_Institution values(1001278,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'KANSAS SOLDIERS HOME', '589DX', 'KANSAS SOLDIERS HOME',1009121,1006840, '714 Sheridan St',NULL,NULL, 'FT DODGE',1009320,NULL, '67843',1006840, '714 Sheridan St',NULL,NULL, 'FT DODGE',1009320,NULL, '67843',1009220, '0',1000180,1000560,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001279,NULL,NULL, 'KANSAS VETERANS HOME-WI', '589DZ', 'KANSAS VETERANS HOME-WI',1009121,1006840, '1220 WWII MEMORIAL DR',NULL,NULL, 'WINFIELD',1009320,NULL, '67156',1006840, '1220 WWII MEMORIAL DR',NULL,NULL, 'WINFIELD',1009320,NULL, '67156',1009222, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001280,NULL,NULL, 'WARRENSBURG MO CBOC', '589G1', 'WARRENSBURG VA CLINIC',1009121,1006840, '702 E. YOUNG AVE',NULL,NULL, 'Warrensburg',1009329,NULL, '64093-9610',1006840, '1300 Veterans Road',NULL,NULL, 'Warrensburg',1009329,NULL, '64093-8294',1009148, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/29/2015 9:03:15 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0930 05/04/2015');
Insert into sdsadm.STD_Institution values(1001281,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'DODGE CITY VA CLINIC', '589G2', 'DODGE CITY VA CLINIC',1009121,1006840, '2201 SUMMERLON CIR',NULL,NULL, 'DODGE CITY',1009320,NULL, '67801-2985',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001265,1000561,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 8:55:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0931 06/03/2015');
Insert into sdsadm.STD_Institution values(1001282,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LIBERAL CBOC', '589G3', 'LIBERAL CBOC',1009121,1006840, '2 ROCK ISLAND ROAD SUITE 200',NULL,NULL, 'Liberal',1009320,NULL, '67901-3760',1006840, '2 ROCK ISLAND ROAD SUITE 200',NULL,NULL, 'Liberal',1009320,NULL, '67901-3760',1009148, '0',1001265,1000562,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001283,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'HAYS CBOC', '589G4', 'HAYS CBOC',1009121,1006840, '207 B EAST SEVENTH',NULL,NULL, 'HAYS',1009320,NULL, '67601-4152',1006840, '207 B EAST SEVENTH',NULL,NULL, 'HAYS',1009320,NULL, '67601-4153',1009148, '0',1001265,1000563,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001284,TO_DATE('10/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PARSONS CBOC', '589G5', 'PARSONS CBOC',1009121,1006840, '1907 HARDING DRIVE',NULL,NULL, 'PARSONS',1009320,NULL, '67357-8111',1006840, '1907 HARDING DRIVE',NULL,NULL, 'PARSONS',1009320,NULL, '67357-8111',1009148, '0',1001265,1000564,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001286,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'WHITEMAN AFB COMMUNITY BASED OUTPATIENT CLINIC (589GA)', '589GA', 'ZZ WHITEMAN AFB',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001287,NULL,NULL, 'BELTON VA CLINIC', '589GB', 'BELTON VA CLINIC',1009121,1006840, '17140 Bel-Ray Place',NULL,NULL, 'Belton',1009329,NULL, '64012-5331',NULL, '17140 Bel-Ray Place',NULL,NULL, 'Belton',1009329,NULL, '64012-5331',1009148, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001288,NULL,NULL, 'PAOLA VA CLINIC', '589GC', 'PAOLA VA CLINIC',1009121,1006840, '510 S. HOSPITAL DRIVE',NULL,NULL, 'PAOLA',1009320,NULL, '66071-1851',NULL, '510 S. HOSPITAL DRIVE',NULL,NULL, 'PAOLA',1009320,NULL, '66071-1851',1009148, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001289,NULL,NULL, 'NEVADA VA CLINIC', '589GD', 'NEVADA VA CLINIC',1009121,1006840, '322 S. Prewitt',NULL,NULL, 'Nevada',1009329,NULL, '64772-3803',NULL, '322 S. Prewitt',NULL,NULL, 'Nevada',1009329,NULL, '64772-3803',1009148, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001290,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'KIRKSVILLE VA CLINIC', '589GE', 'KIRKSVILLE VA CLINIC',1009121,1006840, '1510 NORTH CROWN DRIVE',NULL,NULL, 'KIRKSVILLE',1009329,NULL, '63501-2553',1006840, '1510 NORTH CROWN DRIVE',NULL,NULL, 'KIRKSVILLE',1009329,NULL, '63501-2553',1009148, '0',1001262,1000957,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001291,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'FORT LEONARD WOOD VA CLINIC', '589GF', 'FORT LEONARD WOOD VA CLINIC',1009121,1006840, '700 GW LANE',NULL,NULL, 'WAYNESVILLE',1009329,NULL, '65583-2325',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001262,1000958,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001292,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'WHITEMAN AFB CBOC', '589GG', 'ZZWHITEMAN AFB',1009121,1006840, '509th MEDICAL GROUP',NULL,NULL, 'WHITEMAN AFB.',1009329,NULL, '65305',1006840, '509th MEDICAL GROUP',NULL,NULL, 'Whiteman AFD',1009329,NULL, '65305',1009148, '0',NULL,1000959,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001293,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LAKE OF THE OZARKS VA CLINIC', '589GH', 'LAKE OF THE OZARKS VA CLINIC',1009121,1006840, '940 EXECUTIVE DRIVE',NULL,NULL, 'OSAGE BEACH',1009329,NULL, '65065-3497',1006840, '940 EXECUTIVE DRIVE',NULL,NULL, 'OSAGE BEACH',1009329,NULL, '65065-3497',1009148, '0',1001262,1000960,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001297,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CHANUTE VA CLINIC', '589GM', 'CHANUTE VA CLINIC',1009121,1006840, '629 SOUTH PLUMMER',NULL,NULL, 'CHANUTE',1009320,NULL, '66720-1928',1006840, '629 SOUTH PLUMMER',NULL,NULL, 'CHANUTE',1009320,NULL, '66720-1928',1009148, '0',1001263,1001949,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001298,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'EMPORIA VA CLINIC', '589GN', 'EMPORIA VA CLINIC',1009121,1006840, '919 W.12TH AVENUE SUITE D',NULL,NULL, 'EMPORIA',1009320,NULL, '66801-5554',1006840, '919 W. 12TH AVENUE SUITE D',NULL,NULL, 'EMPORIA',1009320,NULL, '66801-5554',1009148, '0',1001263,1001950,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001299,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('2/23/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'FT. RILEY CBOC', '589GO', 'ZZ FT. RILEY',1009121,1006840, 'IRWIN ARMY HOSPITAL',NULL,NULL, 'FORT RILEY',1009320,NULL, '66442',1006840, 'IRWIN ARMY HOSPITAL',NULL,NULL, 'FORT RILEY',1009320,NULL, '66442',1009148, '0',1000180,1001951,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001300,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'GARNETT VA CLINIC', '589GP', 'GARNETT VA CLINIC',1009121,1006840, '421 SOUTH MAPLE',NULL,NULL, 'GARNETT',1009320,NULL, '66032-1334',1006840, '421 SOUTH MAPLE',NULL,NULL, 'GARNETT',1009320,NULL, '66032-1334',1009148, '0',1001263,1001952,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001301,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'HOLTON CBOC', '589GQ', 'HOLTON CBOC',1009121,1006840, '1110 COLUMBINE DRIVE',NULL,NULL, 'HOLTON',1009320,NULL, '66436',1006840, '1110 COLUMBINE DRIVE',NULL,NULL, 'HOLTON',1009320,NULL, '66436',1009148, '0',1000180,1001953,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001302,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'JUNCTION CITY VA CLINIC', '589GR', 'JUNCTION CITY VA CLINIC',1009121,1006840, '715 SOUTHWIND DR',NULL,NULL, 'JUNCTION CITY',1009320,NULL, '66441-9021',1006840, '715 SOUTHWIND DR',NULL,NULL, 'JUNCTION CITY',1009320,NULL, '66441-9021',1009148, '0',1001263,1001954,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001303,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('2/23/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-RUSSELL CBOC', '589GS', 'ZZ-RUSSELL',1009121,1006840, 'Medical Arts Building',NULL,NULL, 'RUSSELL',1009320,NULL, '67665',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000180,1001955,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001304,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SENECA VA CLINIC', '589GT', 'SENECA VA CLINIC',1009121,1006840, '1600 COMMUNITY DRIVE',NULL,NULL, 'SENECA',1009320,NULL, '66538-9739',1006840, '1600 COMMUNITY DRIVE',NULL,NULL, 'SENECA',1009320,NULL, '66538-9739',1009148, '0',1001263,1001956,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001305,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LAWRENCE VA CLINIC', '589GU', 'LAWRENCE VA CLINIC',1009121,1006840, '2200 HARVARD ROAD',NULL,NULL, 'LAWRENCE',1009320,NULL, '66049-2611',1006840, '2200 HARVARD ROAD',NULL,NULL, 'LAWRENCE',1009320,NULL, '66049-2611',1009148, '0',1001263,1001957,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001306,NULL,NULL, 'FORT SCOTT VA CLINIC', '589GV', 'FORT SCOTT VA CLINIC',1009121,1006840, '902 HORTON STREET',NULL,NULL, 'FORT SCOTT',1009320,NULL, '66701-2438',1006840, '902 HORTON STREET',NULL,NULL, 'FORT SCOTT',1009320,NULL, '66701-2438',1009148, '0',1001263,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001308,NULL,NULL, 'CAMERON CBOC', '589GZ', 'CAMERON CBOC',1009121,1006840, '1111 Euclid',NULL,NULL, 'Cameron',1009329,NULL, '64429-2005',1006840, '1111 Euclid',NULL,NULL, 'Cameron',1009329,NULL, '64429-2005',1009148, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001309,NULL,NULL, 'KANSAS CITY PSYCHOSOCIAL RESIDENTIAL REHABILITATION TREATMENT PROGRAM', '589PA', 'KANSAS CITY',1009121,1006840, '409 E ARMOUR BLVD',NULL,NULL, 'KANSAS CITY',1009329,NULL, '64109-2336',1006840, '409 E ARMOUR BLVD',NULL,NULL, 'KANSAS CITY',1009329,1011948, '64109-2336',1009204, '0',1000180,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001310,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LEAVENWORTH-PRRTP', '589PB', 'LEAVENWORTH-PRRTP',1009121,1006840, '4101 S 4TH STREET TRAFFICWAY',NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048-5014',1006840, '4101 S 4TH STREET TRAFFICWAY',NULL,NULL, 'LEAVENWORTH',1009320,NULL, '66048-5014',1009204, '0',1000180,1001968,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001311,NULL,NULL, 'HAMPTON (NHCU)', '5909AA', 'HAMPTON (NHCU)',1009121,1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667',1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667',1009185, '0',1000181,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001312,NULL,NULL, 'HAMPTON (DOM)', '590BU', 'HAMPTON (DOM)',1009121,1006840, '100 EMANCIPATION DR',NULL,NULL, 'HAMPTON',1009351,NULL, '23667-0001',1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667-0001',1009158, '0',1000181,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001313,NULL,NULL, 'LANGLEY', '590CZ', 'LANGLEY',1009122,1006840, '66 NEALY AVENUE',NULL,NULL, 'HAMPTON',1009351,NULL, '23665',1006840, '66 NEALY AVENUE',NULL,NULL, 'HAMPTON',1009351,NULL, '23665',1009224, '0',1000181,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001314,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZNORFOLK', '590GA', 'ZZNORFOLK',1009121,1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667',1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001315,NULL,NULL, 'HAMPTON (PRRTP)', '590PA', 'HAMPTON (PRRTP)',1009121,1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667-0001',1006840, '100 EMANCIPATION DRIVE',NULL,NULL, 'HAMPTON',1009351,NULL, '23667-0001',1009204, '0',1000181,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001316,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ KERRVILLE', '5919AA', 'ZZ KERRVILLE',1009121,1006840,NULL,NULL,NULL, 'KERRVILLE',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001317,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ KNOXVILLE', '5929AA', 'ZZ KNOXVILLE',1009121,1006840,NULL,NULL,NULL, 'KNOXVILLE',1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001320,NULL,NULL, 'KNOXVILLE PRRTP', '592PA', 'KNOXVILLE PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',1000183,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001321,NULL,NULL, 'LAS VEGAS CBOC MASH', '593GA', 'LAS VEGAS CBOC MASH',1009121,1006840, '912 WEST OWENS AVENUE',NULL,NULL, 'LAS VEGAS',1009332,NULL, '89106-2516',1006840, 'P.O. Box 360001',NULL,NULL, 'NORTH LAS VEGAS',1009332,NULL, '89036',1009148, '0',1000184,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1001322,NULL,TO_DATE('11/19/2012' , 'mm/dd/yyyy hh:mi:ss AM'), 'HENDERSON CBOC', '593GB', 'ZZ-HENDERSON CBOC',1009121,1006840, '2920 NORTH GREEN VALLEY PKWY STE 215',NULL,NULL, 'HENDERSON',1009332,NULL, '89014-0406',1006840, 'P.O. Box 360001',NULL,NULL, 'NORTH LAS VEGAS',1009332,NULL, '89036',1009148, '0',1000184,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001323,NULL,NULL, 'PAHRUMP CBOC', '593GC', 'PAHRUMP CBOC',1009121,1006840, '2100 EAST CALVADA BLVD.',NULL,NULL, 'PAHRUMP',1009332,NULL, '89048-5805',1006840, 'P.O. Box 360001',NULL,NULL, 'NORTH LAS VEGAS',1009332,NULL, '89036',1009148, '0',1000184,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001324,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LAKE CITY', '5949AA', 'ZZ LAKE CITY',1009121,1006840,NULL,NULL,NULL, 'LAKE CITY',1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001325,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TALLAHASSEE SOC', '594BY', 'ZZ TALLAHASSEE SOC',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1001175,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001326,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LAKE CITY STNB', '594DT', 'ZZ LAKE CITY STNB',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001169,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001327,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ VALDOSTA CBOC', '594GA', 'ZZ VALDOSTA CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001170,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001328,NULL,NULL, 'LEBANON NHC', '5959AA', 'LEBANON NHC',1009121,1006840,NULL,NULL,NULL, 'LEBANON',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000186,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:49:16 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 06/11/2009 changes');
Insert into sdsadm.STD_Institution values(1001330,NULL,NULL, 'CAMP HILL VA CLINIC', '595GA', 'CAMP HILL VA CLINIC',1009121,1006840, '25 NORTH 32 ST',NULL,NULL, 'CAMP HILL',1009342,NULL, '17011-2918',1006840, '25 NORTH 32 ST',NULL,NULL, 'CAMP HILL',1009342,NULL, '17011-2918',1009148, '0',1000186,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001331,NULL,NULL, 'SCHUHKILL COUNTY GOOD SAMARITAN REGIONAL', '595GB', 'SCHUYLKILL',1009121,1006840, '700 E SAMARITAN REGIONAL MED CENTER',NULL,NULL, 'POTTSVILLE',1009342,NULL, '17901-3849',1006840, '700 E SAMARITAN REGIONAL MED CENTER',NULL,NULL, 'POTTSVILLE',1009342,NULL, '17901-3849',1009148, '0',1000186,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001336,NULL,NULL, 'LEXINGTON NHCU', '5969AA', 'LEXINGTON NHCU',1009121,1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40502',1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40502',1009185, '0',1000187,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001337,NULL,NULL, 'LEXINGTON VETERANS AFFAIRS MEDICAL CENTER', '596A4', 'LEXINGTON-CDD VAMC',1009121,1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40502-2235',1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40502-2235',1009231, '0',1000187,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001338,NULL,NULL, 'THOMPSON HOOD VETERANS CENTER', '596DT', 'WILMORE STATE HOME',1009121,1006840, '100 VETERANS DRIVE',NULL,NULL, 'WILMORE',1009321,NULL, '40390',1006840, '100 VETERANS DRIVE',NULL,NULL, 'WILMORE',1009321,NULL, '40390',1009221, '0',1000187,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001339,NULL,NULL, 'SOMERSET VA CLINIC', '596GA', 'SOMERSET VA CLINIC',1009121,1006840, '163 TOWER CIRCLE',NULL,NULL, 'SOMERSET',1009321,NULL, '42503-3479',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000187,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001340,NULL,NULL, 'LEXINGTON MOBILE OUTREACH CLINIC', '596HA', 'LEXINGTON MOBILE MEDIC',1009121,1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40502-2235',1006840, '1101 VETERANS DRIVE',NULL,NULL, 'LEXINGTON',1009321,NULL, '40502-2235',1009148, '0',1000187,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001341,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LINCOLN', '5979AA', 'ZZ LINCOLN',1009121,1006840,NULL,NULL,NULL, 'LINCOLN',1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001344,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NORFOLK STDM', '597DU', 'ZZ NORFOLK STDM',1009121,1006840,NULL,NULL,NULL,NULL,1009331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009219, '0',NULL,NULL,1001606,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001369,NULL,NULL, 'NEW ALBANY VA CLINIC', '603GB', 'NEW ALBANY VA CLINIC',1009121,1006840, '811 Northgate Blvd.',NULL,NULL, 'New Albany',1009318,NULL, '47150-6419',1006840, '811 Northgate Blvd.',NULL,NULL, 'New Albany',1009318,NULL, '47150-6419',1009148, '0',1000194,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001370,NULL,NULL, 'SHIVELY VA CLINIC', '603GC', 'SHIVELY VA CLINIC',1009121,1006840, '3934 N. Dixie Highway',NULL,NULL, 'Louisville',1009321,NULL, '40216-4163',1006840, '3934 N. Dixie Highway',NULL,NULL, 'Louisville',1009321,NULL, '40216-4163',1009148, '0',1000194,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001373,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TRENTON CBOC', '604GA', 'ZZ TRENTON CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001101,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001374,NULL,TO_DATE('7/1/96' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ JAMESBURG ORC', '604HA', 'ZZ JAMESBURG ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001111,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001375,NULL,NULL, 'LOMA LINDA NURSING HOME CARE', '6059AA', 'LOMA LINDA NHC',1009121,1006840, '11201 BENTON STREET',NULL,NULL, 'LOMA LINDA',1009306,NULL, '92357',1006840, '11201 BENTON STREET',NULL,NULL, 'LOMA LINDA',1009306,NULL, '92357',1009185, '0',1000196,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001376,NULL,NULL, 'LOMA LINDA CIVH', '605DS', 'LOMA LINDA CIVH',1009121,1006840, '11201 BENTON STREET',NULL,NULL, 'LOMA LINDA',1009306,NULL, '92357',1006840, '11201 BENTON STREET',NULL,NULL, 'LOMA LINDA',1009306,NULL, '92357',1009153, '0',1000196,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001377,NULL,NULL, 'VETERANS HOME OF CALIFORNIA - BARSTOW', '605DT', 'BARSTOW STNB',1009121,1006840, '100 EAST VETERANS PARKWAY',NULL,NULL, 'BARSTOW',1009306,NULL, '92311',1006840, '100 EAST VETERANS PARKWAY',NULL,NULL, 'BARSTOW',1009306,NULL, '92311',1009221, '0',1000196,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001378,NULL,NULL, 'VICTORVILLE CBOC', '605GA', 'VICTORVILLE CBOC',1009121,1006840, '12138 INDUSTRIAL BLVD #120',NULL,NULL, 'VICTORVILLE',1009306,NULL, '92395-4757',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000196,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1001379,NULL,NULL, 'MURRIETA CBOC', '605GB', 'MURRIETA CBOC',1009121,1006840, '28078 BAXTER ROAD SUITE 540',NULL,NULL, 'MURRIETA',1009306,NULL, '92563-1405',1006840, '28078 BAXTER ROAD SUITE 540',NULL,NULL, 'MURRIETA',1009306,NULL, '92563-1405',1009148, '0',1000196,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001382,NULL,NULL, 'RANCHO CUCAMONGA CBOC', '605GE', 'RANCHO CUCAMONGA CBOC',1009121,1006840, '8599 HAVEN AVE SUITE 102',NULL,NULL, 'RANCHO CUCAMONGA',1009306,NULL, '91730-4849',1006840, '8599 HAVEN AVE SUITE 102',NULL,NULL, 'RANCHO CUCAMONGA',1009306,NULL, '91730-4849',1009148, '0',1000196,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001383,NULL,NULL, 'WISCONSIN VETERANS HOME', '607DT', 'KING',1009121,1006840, 'N2665 HWY QQ',NULL,NULL, 'KING',1009355,NULL, '54946',1006840, 'N2665 HWY QQ',NULL,NULL, 'KING',1009355,NULL, '54946',1009222, '0',1000197,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001390,NULL,NULL, 'MANCHESTER STATE HOME', '6089AF', 'MANCHESTER STATE HOME',1009121,1006840,NULL,NULL,NULL, 'TILTON',1009333,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000198,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001391,NULL,NULL, 'TILTON', '608DT', 'TILTON',1009121,1006840, '1 WINTER STREET',NULL,NULL, 'TILTON',1009333,NULL, '3276',1006840, '1 WINTER STREET',NULL,NULL, 'TILTON',1009333,NULL, '3276',1009221, '0',1002201,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001393,NULL,NULL, 'SOMERSWORTH CBOC', '608GC', 'SOMERSWORTH CBOC',1009121,1006840, '200 ROUTE 108 NORTH',NULL,NULL, 'SOMERSWORTH',1009333,NULL, '03878-1119',1006840, '200 ROUTE 108 NORTH',NULL,NULL, 'SOMERSWORTH',1009333,NULL, '03878-1119',1009148, '0',1000198,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001394,NULL,NULL, 'CONWAY CBOC', '608GD', 'CONWAY CBOC',1009121,1006840, '71 HOBBS STREET',NULL,NULL, 'CONWAY',1009333,NULL, '03818-8109',1006840, '71 HOBBS STREET',NULL,NULL, 'CONWAY',1009333,NULL, '03818-8109',1009148, '0',1000198,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001396,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARION NHC', '6099AA', 'ZZ MARION NHC',1009121,1006840,NULL,NULL,NULL, 'MARION',1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,1001727,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001397,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'MARION STATE NURSING HOME CARE UNIT (6099AF)', '6099AF', 'ZZ MARION STNB',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001728,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001398,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ EVANSVILLE SOC', '609BY', 'ZZ EVANSVILLE SOC',1009121,1006840,NULL,NULL,NULL, 'MARION',1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1001758,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001399,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ILLINOIS ST VETERANS HOME', '609DT', 'ZZ ILLINOIS ST VETERANS HOME',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001747,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001400,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MT VERNON CBOC', '609GA', 'ZZ MT VERNON CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001759,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001401,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PADUCAH CBOC', '609GB', 'ZZ PADUCAH CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001760,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001402,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ EFFINGHAM CBOC', '609GC', 'ZZ EFFINGHAM CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001761,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001403,NULL,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARION PRRTP', '609PA', 'ZZ MARION PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',NULL,NULL,1001763,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001404,NULL,NULL, 'MARION', '6109AA', 'MARION',1009121,1006840,NULL,NULL,NULL, 'MARION',1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000200,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001405,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'FORT WAYNE VA MEDICAL CENTER', '610A4', 'FORT WAYNE VA MEDICAL CENTER',1009121,1006840, '2121 LAKE AVE.',NULL,NULL, 'FORT WAYNE',1009318,NULL, '46805-5100',1006840, '2121 LAKE AVE',NULL,NULL, 'FORT WAYNE',1009318,NULL, '46805-5100',1009231, '0',1000200,1000166,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001406,NULL,NULL, 'SOUTH BEND VA CLINIC', '610GA', 'SOUTH BEND VA CLINIC',1009121,1006840, '333 WEST WESTERN AVENUE',NULL,NULL, 'SOUTH BEND',1009318,NULL, '46601-2215',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000200,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001407,NULL,NULL, 'MUNCIE VA CLINIC', '610GB', 'MUNCIE VA CLINIC',1009121,1006840, '2600 W WHITE RIVER BLVD',NULL,NULL, 'MUNCIE',1009318,NULL, '47303-5263',1006840, '2600 W WHITE RIVER BLVD',NULL,NULL, 'MUNCIE',1009318,NULL, '47303-5263',1009148, '0',1000200,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001408,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARLIN', '6119AA', 'ZZ MARLIN',1009121,1006840,NULL,NULL,NULL, 'MARLIN',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001409,NULL,NULL, 'MARTINEZ NHCU', '6129AA', 'MARTINEZ NHCU',1009121,1006840,NULL,NULL,NULL, 'MARTINEZ',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001410,NULL,NULL, 'SACRAMENTO VA MEDICAL CENTER', '612A4', 'SACRAMENTO VA MEDICAL CENTER',1009121,1006840, '10535 HOSPITAL WAY',NULL,NULL, 'MATHER',1009306,NULL, '95655-4200',1006840, '10535 HOSPITAL WAY',NULL,NULL, 'SACRAMENTO',1009306,NULL, '95655-4200',1009231, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001411,NULL,NULL, 'REDDING VA CLINIC', '612B4', 'REDDING VA CLINIC',1009121,1006840, '351 HARTNELL AVENUE',NULL,NULL, 'REDDING',1009306,NULL, '96002-1845',1006840, '351 HARTNELL AVENUE',NULL,NULL, 'REDDING',1009306,NULL, '96002-1845',1009197, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001412,NULL,NULL, 'OAKLAND VA CLINIC', '612BY', 'OAKLAND VA CLINIC',1009121,1006840, '2221 MARTIN LUTHER KING JR. WAY',NULL,NULL, 'OAKLAND',1009306,NULL, '94612-1318',1006840, '2221 MARTIN LUTHER KING JR. WAY',NULL,NULL, 'OAKLAND',1009306,NULL, '94612-1318',1009197, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001413,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'DAVID GRANT MEDICAL CENTER', '612CZ', 'ZZ DAVID GRANT MEDICAL CENTER',1009121,1006840, '101 BODIN CIRCLE',NULL,NULL, 'TRAVIS AFB',1009306,NULL, '94535-1800',1006840, '101 BODIN CIRCLE',NULL,NULL, 'TRAVIS AFB',1009306,NULL, '94535-1800',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001414,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'DAY TREATMENT CENTER', '612GA', 'ZZ DAY TREATMENT CENTER',1009121,1006840, '150 MUIR RD',NULL,NULL, 'MARTINEZ',1009306,NULL, '94553',1006840, '150 MUIR RD',NULL,NULL, 'MARTINEZ',1009306,NULL, '94553',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001415,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'OAKLAND SATP', '612GB', 'ZZ OAKLAND SATP',1009121,1006840, '841 FOLGER',NULL,NULL, 'BERKELEY',1009306,NULL, '94710',1006840, '841 FOLGER',NULL,NULL, 'BERKELEY',1009306,NULL, '94710',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001416,NULL,NULL, 'FAIRFIELD VA CLINIC', '612GD', 'FAIRFIELD VA CLINIC',1009121,1006840, '103 BODIN CIR',NULL,NULL, 'TRAVIS AFB',1009306,NULL, '94535-1801',1006840, '103 BODIN CIR',NULL,NULL, 'TRAVIS AFB',1009306,NULL, '94535-1801',1009148, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001417,NULL,NULL, 'MARE ISLAND VA CLINIC', '612GE', 'MARE ISLAND VA CLINIC',1009121,1006840, '201 WALNUT AVE',NULL,NULL, 'VALLEJO',1009306,NULL, '94592-1107',1006840, '201 WALNUT AVE.',NULL,NULL, 'VALLEJO',1009306,NULL, '94592-1107',1009148, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001418,NULL,NULL, 'MARTINEZ CBOC', '612GF', 'MARTINEZ CBOC',1009121,1006840, '150 MUIR ROAD',NULL,NULL, 'MARTINEZ',1009306,NULL, '94553-4668',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/2/2014 11:20:28 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0904 05/13/2014');
Insert into sdsadm.STD_Institution values(1001419,NULL,NULL, 'CHICO VA CLINIC', '612GG', 'CHICO VA CLINIC',1009121,1006840, '280 COHASSET ROAD',NULL,NULL, 'CHICO',1009306,NULL, '95926-2210',1006840, '280 COHASSET ROAD',NULL,NULL, 'CHICO',1009306,NULL, '95926-2210',1009148, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001420,NULL,NULL, 'MCCLELLAN VA CLINIC', '612GH', 'MCCLELLAN VA CLINIC',1009121,1006840, '5342 DUDLEY BLVD',NULL,NULL, 'MCCLELLAN AIR FORCE BASE',1009306,NULL, '95652-1012',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000202,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001421,NULL,NULL, 'MARTINSBURG NHC', '6139AA', 'MARTINSBURG NHC',1009121,1006840,NULL,NULL,NULL, 'MARTINSBURG',1009354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:51:25 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/05/2009 changes');
Insert into sdsadm.STD_Institution values(1001422,NULL,NULL, 'MARTINSBURG DOM', '613BU', 'MARTINSBURG DOM',1009121,1006840, '510 BUTLER ROAD',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25405-9990',1006840, '510 BUTLER ROAD',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25405-9990',1009158, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001423,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CUMBERLAND SOC', '613BY', 'ZZ CUMBERLAND',1009121,1006840, '200 GLENN STREET',NULL,NULL, 'CUMBERLAND',1009324,NULL, '21502',1006840, '200 GLENN STREET',NULL,NULL, 'CUMBERLAND',1009324,NULL, '21502',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001424,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MARTINSBURG PHARM', '613CA', 'ZZ MARTINSBURG',1009121,1006840, '510 BUTLER ROAD',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25401',1006840, '510 BUTLER ROAD',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25401',1009201, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001425,NULL,NULL, 'CUMBERLAND CBOC', '613GA', 'CUMBERLAND',1009121,1006840, '200 GLENN STREET',NULL,NULL, 'CUMBERLAND',1009324,NULL, '21502-2436',1006840, '200 GLENN STREET',NULL,NULL, 'CUMBERLAND',1009324,NULL, '21502-2436',1009148, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001426,NULL,NULL, 'HAGERSTOWN VA CLINIC', '613GB', 'HAGERSTOWN VA CLINIC',1009121,1006840, '1101 OPAL COURT',NULL,NULL, 'HAGERSTOWN',1009324,NULL, '21740-5941',1006840, '1101 OPAL COURT',NULL,NULL, 'HAGERSTOWN',1009324,NULL, '21740-5941',1009148, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001427,NULL,NULL, 'STEPHENS CITY VA CLINIC', '613GC', 'STEPHENS CITY VA CLINIC',1009121,1006840, '170 PROSPERITY DRIVE',NULL,NULL, 'WINCHESTER',1009351,NULL, '22602-5356',1006840, '170 PROSPERITY DRIVE',NULL,NULL, 'WINCHESTER',1009351,NULL, '22602-5356',1009148, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001429,NULL,NULL, 'PETERSBURG VA CLINIC', '613GE', 'PETERSBURG VA CLINIC',1009121,1006840, '15 GRANT STREET',NULL,NULL, 'PETERSBURG',1009354,NULL, '26847-1613',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001430,NULL,NULL, 'HARRISONBURG VA CLINIC', '613GF', 'HARRISONBURG VA CLINIC',1009121,1006840, '1755 SOUTH HIGH STREET',NULL,NULL, 'HARRISONBURG',1009351,NULL, '22801-1553',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001431,NULL,NULL, 'MOBILE VAN CLINIC MORC', '613HK', 'MOBILE VAN CLINIC',1009121,1006840, '510 BUTLER ROAD',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25405-9990',1006840, '510 BUTLER ROAD',NULL,NULL, 'MARTINSBURG',1009354,NULL, '25405-9990',1009177, '0',1000203,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001432,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'MEMPHIS NHCU', '6149AA', 'ZZ MEMPHIS NHCU',1009121,1006840, '1030 JEFFERSON AVENUE',NULL,NULL, 'MEMPHIS',1009347,NULL, '38104',1006840, '1030 JEFFERSON AVENUE',NULL,NULL, 'MEMPHIS',1009347,NULL, '38104',1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001442,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MILES CITY', '6179AA', 'ZZ MILES CITY',1009121,1006840,NULL,NULL,NULL, 'MILES CITY',1009330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001443,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GLENDIVE STNB', '617DT', 'ZZ GLENDIVE STNB',1009121,1006840,NULL,NULL,NULL,NULL,1009330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1000526,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001444,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BILLINGS', '617GA', 'ZZ BILLINGS',1009121,1006840,NULL,NULL,NULL,NULL,1009330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000534,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001445,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WOLF POINT ORC', '617HA', 'ZZ WOLF POINT ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1000532,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001446,NULL,NULL, 'MINNEAPLS NHC', '6189AA', 'MINNEAPLS NHC',1009121,1006840,NULL,NULL,NULL, 'MINNEAPOLIS',1009327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001447,NULL,NULL, 'MINNEAPLS STATE HOME', '6189AF', 'MINNEAPLS STATE HOME',1009121,1006840,NULL,NULL,NULL, 'MINNEAPOLIS',1009327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001448,NULL,NULL, 'TWIN PORTS CBOC', '618BY', 'TWIN PORTS CBOC',1009121,1006840, '3520 TOWER AVENUE',NULL,NULL, 'SUPERIOR',1009355,NULL, '54880-5335',1006840, '3520 TOWER AVENUE',NULL,NULL, 'SUPERIOR',1009355,NULL, '54880-5335',1009197, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001449,NULL,NULL, 'MINNEAPOLIS (STATE VET HOME)', '618DT', 'MINNEAPOLIS (STATE VET HOME)',1009121,1006840, '5101 Minnehaha Avenue',NULL,NULL, 'Minneapolis',1009327,NULL, '55417',1006840, '5101 Minnehaha Avenue',NULL,NULL, 'Minneapolis',1009327,NULL, '55417',1009221, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001450,NULL,NULL, 'HASTINGS (STATE VET HOME)', '618DU', 'HASTINGS (STATE VET HOME)',1009121,1006840, '1200 East 18th St',NULL,NULL, 'Hastings',1009327,NULL, '55033',1006840, '1200 East 18th St',NULL,NULL, 'Hastings',1009327,NULL, '55033',1009221, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001451,NULL,NULL, 'SILVER BAY (STATE VET HOME)', '618DV', 'SILVER BAY (STATE VET HOME)',1009121,1006840, '45 Banks Blvd.',NULL,NULL, 'Silver Bay',1009327,NULL, '55614',1006840, '45 Banks Blvd',NULL,NULL, 'Silver Bay',1009327,NULL, '55614',1009221, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001452,NULL,NULL, 'SOUTH CENTRAL CBOC', '618GA', 'ST. JAMES VA CLINIC',1009121,1006840, '1212 HECKMAN COURT',NULL,NULL, 'ST. JAMES',1009327,NULL, '56081-8702',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 8:55:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0931 06/03/2015');
Insert into sdsadm.STD_Institution values(1001453,NULL,NULL, 'HIBBING (CBOC)', '618GB', 'HIBBING (CBOC)',1009121,1006840, '990 W 41ST ST SUITE 78',NULL,NULL, 'HIBBING',1009327,NULL, '55746-3045',1006840, '990 W 41ST ST SUITE 78',NULL,NULL, 'HIBBING',1009327,NULL, '55746-3045',1009148, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001454,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZOWATONNA (CBOC)', '618GC', 'ZZOWATONNA (CBOC)',1009121,1006840, 'N/A',NULL,NULL, 'OWATONNA',1009327,NULL, '99999',1006840, 'N/A',NULL,NULL, 'OWATONNA',1009327,NULL, '99999',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001457,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZLA CROSSE (CBOC)', '618GF', 'ZZLA CROSSE (CBOC)',1009121,1006840, 'N/A',NULL,NULL, 'LA CROSSE',1009355,NULL, '88888',1006840, 'N/A',NULL,NULL, 'LA CROSSE',1009355,NULL, '88888',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001458,NULL,NULL, 'ROCHESTER (CBOC)', '618GG', 'ROCHESTER (CBOC)',1009121,1006840, '3900 55th Street NW',NULL,NULL, 'ROCHESTER',1009327,NULL, '55901-0119',1006840, '3900 55th Street NW',NULL,NULL, 'ROCHESTER',1009327,NULL, '55901-0119',1009148, '0',1000207,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001459,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MONTGOMERY', '6199AA', 'ZZ MONTGOMERY',1009121,1006840,NULL,NULL,NULL, 'MONTGOMERY',1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001460,NULL,NULL, 'TUSKEGEE-NHC', '6199AB', 'TUSKEGEE-NHC',1009121,1006840,NULL,NULL,NULL,NULL,1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000208,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001461,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CENTRAL ALABAMA HEALTH CARE SYSTEM - TUSKEGEE DIVISION', '619A4', 'TUSKEGEE VAMC',1009121,1006840, '2400 Hospital Road',NULL,NULL, 'Tuskegee',1009301,NULL, '36083-5001',1006840, '2400 Hospital Road',NULL,NULL, 'Tuskegee',1009301,NULL, '36083-5001',1009231, '0',1000208,1000258,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001462,TO_DATE('1/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CENTRAL ALABAMA HCS - DOMICILIARY', '619BU', 'TUSKEGEE-DOM',1009121,1006840, '2400 HOSPITAL ROAD',NULL,NULL, 'TUSKEGEE',1009301,NULL, '36083-5001',1006840, '2400 HOSPITAL ROAD',NULL,NULL, 'TUSKEGEE',1009301,NULL, '36083-5001',1009158, '0',1000208,1001983,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001463,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MONTGOMERY USAH', '619CN', 'ZZ MONTGOMERY USAH',1009124,1006840,NULL,NULL,NULL,NULL,1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001464,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MONTGOMERY USAF', '619CZ', 'ZZ MONTGOMERY USAF',1009122,1006840,NULL,NULL,NULL,NULL,1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001465,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ALEXANDER CITY', '619DT', 'ZZ ALEXANDER CITY',1009121,1006840,NULL,NULL,NULL,NULL,1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001466,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BAY MINETTE (619DU)', '619DU', 'ZZ BAY MINETTE (619DU)',1009121,1006840,NULL,NULL,NULL,NULL,1009301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001467,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ HUNTSVILLE', '619DV', 'ZZ HUNTSVILLE (STNB)',1009121,1006840, 'UNKNOWN',NULL,NULL, 'HUNTSVILLE',1009301,NULL, '0',1006840, 'UNKNOWN',NULL,NULL, 'HUNTSVILLE',1009301,NULL, '0',1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001468,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CENTRAL ALABAMA HCS - COLUMBUS CBOC', '619GA', 'COLUMBUS CBOC',1009121,1006840, '1310  13TH AVENUE',NULL,NULL, 'COLUMBUS',1009313,NULL, '31906-2335',1006840, '1310 13TH AVENUE',NULL,NULL, 'COLUMBUS',1009313,NULL, '31906-2335',1009148, '0',1000208,1001984,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001469,NULL,NULL, 'CENTRAL ALABAMA HCS - DOTHAN CBOC', '619GB', 'DOTHAN',1009121,1006840, '2020 ALEXANDER DRIVE',NULL,NULL, 'DOTHAN',1009301,NULL, '36301-3004',1006840, '2020 ALEXANDER DRIVE',NULL,NULL, 'DOTHAN',1009301,NULL, '36301-3004',1009148, '0',1000208,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001470,NULL,NULL, 'CENTRAL ALABAMA HCS - PRRTP', '619PA', 'TUSKEGEE PRRTP',1009121,1006840, '2400 HOSPITAL ROAD',NULL,NULL, 'TUSKEGEE',1009301,NULL, '36083-5001',1006840, '2400 HOSPITAL ROAD',NULL,NULL, 'TUSKEGEE',1009301,NULL, '36083-5001',1009204, '0',1000208,NULL,NULL,1002207,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001471,NULL,NULL, 'MONTROSE NURSING HOME', '6209AA', 'MONTROSE',1009121,1006840, '2094 Albany Post Road',NULL,NULL, 'MONTROSE',1009336,NULL, '10548',1006840, '2094 Albany Post Road',NULL,NULL, 'Montrose',1009336,NULL, '10548',1009185, '0',1000209,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001472,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'VA HUDSON VALLEY HEALTH CARE - CASTLE POINT DIVISION', '620A4', 'CASTLE POINT',1009121,1006840, 'Rt. 9D',NULL,NULL, 'CASTLE POINT',1009336,NULL, '12511-0001',1006840, 'RT. 9D',NULL,NULL, 'CASTLE POINT',1009336,NULL, '12511-0001',1009231, '0',1000209,1000137,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001473,NULL,NULL, 'NEW YORK STATE VETERANS HOME', '620DT', 'NEW YORK STATE VET HOME',1009121,1006840, 'Albany Post Road',NULL,NULL, 'Montrose',1009336,NULL, '10548',1006840, 'Albany Post Road',NULL,NULL, 'Montrose',1009336,NULL, '10548',1009222, '0',1000209,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001475,NULL,NULL, 'PUTNAM COUNTY', '620GB', 'PUTNAM COUNTY',1009121,1006840, '1875 ROUTE 6',NULL,NULL, 'CARMEL',1009336,NULL, '10512-2316',1006840, '1875 ROUTE 6',NULL,NULL, 'CARMEL',1009336,NULL, '10512-2316',1009148, '0',1000209,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001476,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZKINGSTON', '620GC', 'ZZKINGSTON',1009121,1006840, '63 HURLEY STREET',NULL,NULL, 'KINGSTON',1009336,NULL, '12401',1006840, '63 HURLEY STREET',NULL,NULL, 'KINGSTON',1009336,NULL, '12401',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001478,NULL,NULL, 'PORT JERVIS', '620GE', 'PORT JERVIS',1009121,1006840, '150 PIKE STREET',NULL,NULL, 'PORT JERVIS',1009336,NULL, '12771-1808',1006840, '150 PIKE STREET',NULL,NULL, 'PORT JERVIS',1009336,NULL, '12771-1808',1009148, '0',1000209,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001479,NULL,NULL, 'HARRIS', '620GF', 'HARRIS',1009121,1006840, '55 STURGIS ROAD',NULL,NULL, 'MONTICELLO',1009336,NULL, '12701-1225',1006840, '55 STURGIS ROAD',NULL,NULL, 'MONTICELLO',1009336,NULL, '12701-1225',1009148, '0',1000209,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001481,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZCARMEL', '620HB', 'ZZCARMEL',1009121,1006840, '65 GLENEIDA AVENUE',NULL,NULL, 'CARMEL',1009336,NULL, '10512',1006840, '65 GLENEIDA AVENUE',NULL,NULL, 'CARMEL',1009336,NULL, '10512',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001482,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZMONTROSE', '620PA', 'ZZMONTROSE',1009121,1006840, '2094 Albany Post Road',NULL,NULL, 'Montrose',1009336,NULL, '10548',1006840, '2094 Albany Post Road',NULL,NULL, 'Montrose',1009336,NULL, '10548',1009204, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001483,NULL,NULL, 'MOUNTAIN HOME NHC', '6219AA', 'MOUNTAIN HOME NHC',1009121,1006840, 'Lamont Street',NULL,NULL, 'Mountain Home',1009347,NULL, '37684',1006840, 'Lamont Street',NULL,NULL, 'Mountain Home',1009347,NULL, '37684',1009185, '0',1000210,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001484,NULL,NULL, 'MOUNTAIN HOME DOM', '621BU', 'MOUNTAIN HOME DOM',1009121,1006840, 'Lamont Street',NULL,NULL, 'Mountain Home',1009347,NULL, '37684-4000',1006840, 'Lamont Street',NULL,NULL, 'Mountain Home',1009347,NULL, '37684-4000',1009158, '0',1000210,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001485,NULL,NULL, 'ROGERSVILLE VA CLINIC', '621GA', 'ROGERSVILLE VA CLINIC',1009121,1006840, '401 SCENIC DRIVE',NULL,NULL, 'Rogersville',1009347,NULL, '37857-2452',1006840, '401 SCENIC DRIVE',NULL,NULL, 'Rogersville',1009347,NULL, '37857-2452',1009148, '0',1000210,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001486,NULL,TO_DATE('6/8/2010' , 'mm/dd/yyyy hh:mi:ss AM'), 'MOUNTAIN CITY CBOC', '621GB', 'ZZ-MOUNTAIN CITY CBOC',1009121,1006840, '1901 South Shady St',NULL,NULL, 'Mountain City',1009347,NULL, '37683',1006840, '1901 South Shady St',NULL,NULL, 'Mountain City',1009347,NULL, '37683',1009148, '0',1000210,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001487,NULL,NULL, 'NORTON VA CLINIC', '621GC', 'NORTON VA CLINIC',1009121,1006840, '654 HIGHWAY 58 EAST',NULL,NULL, 'Norton',1009351,NULL, '24273-3002',1006840, '654 HIGHWAY 58 EAST',NULL,NULL, 'Norton',1009351,NULL, '24273-3002',1009148, '0',1000210,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001488,NULL,TO_DATE('6/22/2010' , 'mm/dd/yyyy hh:mi:ss AM'), 'ST CHARLES CBOC', '621GD', 'ZZ-ST CHARLES (MNT HM) CBOC',1009121,1006840, '100 MAIN ST',NULL,NULL, 'ST. CHARLES',1009351,NULL, '24282',1006840, '100 MAIN ST',NULL,NULL, 'ST. CHARLES',1009351,NULL, '24282',1009148, '0',1000210,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001489,NULL,NULL, 'MURFREESBORO NHC', '6229AA', 'MURFREESBORO NHC',1009121,1006840,NULL,NULL,NULL, 'MURFREESBORO',1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000213,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001490,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MURFREESBORO DOM', '622BU', 'ZZ MURFREESBORO DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1001505,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001491,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHATTANOOGA SOC', '622BY', 'ZZ CHATTANOOGA SOC',1009121,1006840,NULL,NULL,NULL, 'CHATTANOOGA',1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1001515,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001492,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MURFREESBORO STNB', '622DT', 'ZZ MURFREESBORO STNB',1009121,1006840,NULL,NULL,NULL,NULL,1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001509,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001493,NULL,NULL, 'YOUNTVILLE STATE HOME', '622EL', 'YOUNTVILLE STATE HOME',1009121,1006840,NULL,NULL,NULL, 'YOUNTVILLE',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009220, '0',1000213,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001494,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TULLAHOMA CBOC', '622GA', 'ZZ TULLAHOMA CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001516,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001495,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ COOKEVILLE ORC', '622HA', 'ZZ COOKEVILLE ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001517,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001496,NULL,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MURFREESBORO PRRTP', '622PA', 'ZZ MURFREESBORO PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',NULL,NULL,1001518,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001497,NULL,NULL, 'MUSKOGEE NHC', '6239AA', 'MUSKOGEE NHC',1009121,1006840,NULL,NULL,NULL, 'MUSKOGEE',1009340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000212,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001499,NULL,NULL, 'CLAREMORE VETERANS CENTER', '623DT', 'CLAREMORE VETERANS CENTER',1009121,1006840, '3001 WEST BLUE STARR DRIVE',NULL,NULL, 'CLA-- remORE',1009340,NULL, '74018',1006840, 'P. O. BOX 988',NULL,NULL, 'CLA-- remORE',1009340,NULL, '74018',1009222, '0',1000212,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001501,NULL,NULL, 'HARTSHORNE CBOC', '623GA', 'HARTSHORNE OUTPATIENT CLINIC',1009121,1006840, '1429 PENNSYLVANIA AVE',NULL,NULL, 'HARTSHORNE',1009340,NULL, '74547-3839',1006840, '1429 PENNSYLVANIA AVE',NULL,NULL, 'HARTSHORNE',1009340,NULL, '74547-3839',1009148, '0',1000212,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001502,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZTALIHINA OUTREACH CLINIC', '623HA', 'ZZTALHINA OUTREACH CLINIC',1009121,1006840, 'P. O. BOX 1168',NULL,NULL, 'TALIHINA',1009340,NULL, '74571',1006840, 'P. O. BOX 1168',NULL,NULL, 'TALIHINA',1009340,NULL, '74571',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001503,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ALVIN C. YORK VAMC', '626A4', 'ALVIN C. YORK VAMC',1009121,1006840, '3400 LEBANON PIKE',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37129-1237',1006840, '3400 LEBANON PIKE',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37129-1237',1009231, '0',1000213,1000211,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001504,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZNASHVILLE', '626B0', 'ZZNASHVILLE',1009121,1006840, '1310 24TH AVE SOUTH',NULL,NULL, 'NASHVILLE',1009347,NULL, '37212',1006840, '1310 24TH AVE SOUTH',NULL,NULL, 'NASHVILLE',1009347,NULL, '37212',1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001505,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MURFREESBORO VA DOMICILIARY', '626BU', 'MURFREESBORO DOM',1009121,1006840, '3400 LEBANON PIKE',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37129-1237',1006840, '3400 LEBANON PIKE',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37129-1237',1009158, '0',1000213,1001490,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001506,NULL,TO_DATE('4/8/2008' , 'mm/dd/yyyy hh:mi:ss AM'), 'KNOXVILLE VA OUTPATIENT CLINIC', '626BY', 'ZZ-KNOXVILLE TN CBOC',1009121,1006840, '9031 Cross Park Drive',NULL,NULL, 'KNOXVILLE',1009347,NULL, '37923',1006840, '9031 CROSS PARK DRIVE',NULL,NULL, 'KNOXVILLE',1009347,NULL, '37923',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001508,NULL,NULL, 'FT. CAMPBELL ARMY HOSPITAL', '626CN', 'FT. CAMPBELL ARMY HOSPITAL',1009124,1006840, '650 JOEL DR',NULL,NULL, 'FORT CAMPBELL',1009321,NULL, '42223',1006840, '650 JOEL DR',NULL,NULL, 'FORT CAMPBELL',1009321,NULL, '42223',1009226, '0',1000213,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001510,NULL,NULL, 'DOVER VA CLINIC', '626GA', 'DOVER VA CLINIC',1009121,1006840, '1225 SPRING ST',NULL,NULL, 'DOVER',1009347,NULL, '37058-3352',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000213,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 9:56:58 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0932 07/08/2015');
Insert into sdsadm.STD_Institution values(1001511,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'MADISON COMMUNITY BASED OUTPATIENT CLINIC', '626GB', 'ZZMADISON',1009121,1006840, '968 MADISON SQUARE',NULL,NULL, 'MADISON',1009347,NULL, '37116-0968',1006840, '968 MADISON SQUARE',NULL,NULL, 'MADISON',1009347,NULL, '37116-0968',1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001512,NULL,NULL, 'BOWLING GREEN COMMUNITY BASED OUTPATIENT CLINIC', '626GC', 'BOWLING GREEN',1009121,1006840, '1110 WILKINSON TRACE CIRCLE',NULL,NULL, 'BOWLING GREEN',1009321,NULL, '42103-3402',1006840, '1110 WILKINSON TRACE CIRCLE',NULL,NULL, 'BOWLING GREEN',1009321,NULL, '42103-3402',1009148, '0',1000213,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001513,NULL,TO_DATE('4/12/2011' , 'mm/dd/yyyy hh:mi:ss AM'), 'HOPKINSVILLE COMMUNITY BASED OUTPATIENT CLINIC', '626GD', 'ZZ FT CAMPBELL CBOC',1009121,1006840, 'DESERT STORM AVE. BUILDING 6139',NULL,NULL, 'FORT CAMPBELL',1009321,NULL, '42223-5564',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000213,NULL,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001516,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'TULLAHOMA COMMUNITY BASED OUTPATIENT CLINIC', '626GG', 'TULLAHOMA',1009121,1006840, '225 VON KARMAN ROAD',NULL,NULL, 'ARNOLD AFB',1009347,NULL, '37389-9998',1006840, '225 FIRST STREET',NULL,NULL, 'TULLAHOMA',1009347,NULL, '37389-2402',1009148, '0',1000213,1001494,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/11/2015 11:19:34 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0935 10/07/2015');
Insert into sdsadm.STD_Institution values(1001518,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MURFREESBORO PSYCHOSOCIAL RESIDENTIAL REHABILITATION TREATMENT PROGRAM', '626PA', 'MURFREESBORO PRRTP',1009121,1006840, '3400 LEBANON ROAD',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37129-1237',1006840, '3400 LEBANON PK',NULL,NULL, 'MURFREESBORO',1009347,NULL, '37129-1237',1009204, '0',1000213,1001496,NULL,1002209,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001519,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NEWINGTON', '6279AA', 'ZZ NEWINGTON',1009121,1006840,NULL,NULL,NULL, 'NEWINGTON',1009309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001520,NULL,TO_DATE('7/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ROCKY HILL STNB', '627DT', 'ZZ ROCKY HILL STNB',1009121,1006840, 'VA CONNECTICUT HEALTH CARE SYSTEM',NULL,NULL, 'NEWINGTON',1009309,NULL, '6111',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1002016,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001522,NULL,NULL, 'LINDY BOGGS TRANSITIONAL CARE UNIT', '6299AA', 'NEW ORL-NHC',1009121,1006840, '1601 Perdido St.',NULL,NULL, 'NEW ORLEANS',1009322,NULL, '70112',1006840, '1601 Perdido St.',NULL,NULL, 'NEW ORLEANS',1009322,NULL, '70112',1009185, '0',1000215,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001523,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ JACKSON', '6299AF', 'ZZ JACKSON',1009121,1006840,NULL,NULL,NULL, 'JACKSON',1009322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001524,NULL,NULL, 'VA BATON ROUGE OUTPATIENT CLINIC', '629BY', 'NEW ORLEANS-BROPC',1009121,1006840, '7968 ESSEN PARK AVENUE',NULL,NULL, 'BATON ROUGE',1009322,NULL, '70809-7439',1006840, '7968 ESSEN PARK AVENUE',NULL,NULL, 'BATON ROUGE',1009322,NULL, '70809-7439',1009197, '0',1000215,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001525,NULL,NULL, 'LOUISIANA WAR VETERANS HOME', '629DT', 'NEW ORLEANS-JACKSON',1009121,1006840, '4739 Highway 10',NULL,NULL, 'JACKSON',1009322,NULL, '70748',1006840, '4739 Highway 10',NULL,NULL, 'JACKSON',1009322,NULL, '70748',1009221, '0',1000215,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001526,NULL,NULL, 'NEW ORLEANS PSYCHOLOGICAL RESIDENTIAL REHABILITATION TREATMENT PROGRAM', '629PA', 'NEW ORL-PRRTP',1009121,1006840, '1601 PERDIDO ST.',NULL,NULL, 'NEW ORLEANS',1009322,NULL, '70112-1262',1006840, '1601 PERDIDO ST.',NULL,NULL, 'NEW ORLEANS',1009322,NULL, '70112-1262',1009204, '0',1000215,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001527,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ NEW YORK', '6309AA', 'ZZ NEW YORK',1009121,1006840,NULL,NULL,NULL, 'NEW YORK CITY',1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001528,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'VA NEW YORK HARBOR HEALTHCARE SYSTEM - BROOKLYN DIVISION', '630A4', 'BROOKLYN HHS',1009121,1006840, '800 POLY PLACE',NULL,NULL, 'BROOKLYN',1009336,NULL, '11209-7104',1006840, '800 POLY PLACE',NULL,NULL, 'BROOKLYN',1009336,NULL, '11209-7104',1009231, '0',1000216,1000131,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001529,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ST ALBANS EXTENDED CARE CNTR', '630A5', 'ST. ALBANS HHS',1009121,1006840, '179-00 LINDEN BLVD',NULL,NULL, 'JAMAICA',1009336,NULL, '11425-0001',1006840, '179-00 LINDEN BLVD',NULL,NULL, 'JAMAICA',1009336,NULL, '11425-0001',1009231, '0',1000216,1000801,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001531,NULL,TO_DATE('8/15/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'NEW YORK SOC (SOHO VA CARE CENTER)', '630B2', 'ZZSOHO VA CARE CTR HOUSTON',1009121,1006840, '245 WEST HOUSTON STREET',NULL,NULL, 'NEW YORK',1009336,NULL, '10014',1006840, '245 WEST HOUSTON STREET',NULL,NULL, 'NEW YORK CITY',1009336,NULL, '10014',1009197, '0',NULL,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001532,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ST. ALBANS DOM', '630BU', 'ST. ALBANS DOM',1009121,1006840, '179th Street + Linden Blvd',NULL,NULL, 'ST ALBANS',1009336,NULL, '11425-0001',1006840, '179th Street + Linden Blvd',NULL,NULL, 'St. Albans',1009336,NULL, '11425-0001',1009158, '0',1000216,1000802,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001533,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'NULL', '630BY', 'ZZ BRONX SOC',1009121,1006840, 'NULL',NULL,NULL, 'NULL',1009336,NULL, '0',1006840, 'NULL',NULL,NULL, 'NULL',1009336,NULL, '0',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001534,NULL,TO_DATE('11/19/2012' , 'mm/dd/yyyy hh:mi:ss AM'), 'NEW YORK SOC (OPIATE SUBSTITUTION PROGRAM)', '630BZ', 'ZZ-NY OPIATE SUBSTITUTION SOC',1009121,1006840, '437 WEST 16 STREET',NULL,NULL, 'NEW YORK',1009336,NULL, '10011-5800',1006840, '437 WEST 16TH STREET',NULL,NULL, 'NEW YORK CITY',1009336,NULL, '10011-5800',1009197, '0',1000216,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0809 11/19/2012');
Insert into sdsadm.STD_Institution values(1001544,NULL,NULL, 'HARLEM CBOC-NYHHS', '630GA', 'HARLEM CBOC',1009121,1006840, '55 WEST 125TH ST',NULL,NULL, 'NEW YORK',1009336,NULL, '10027-4516',1006840, '55 WEST 125TH STREET',NULL,NULL, 'NEW YORK CITY',1009336,NULL, '10027-4516',1009148, '0',1000216,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001546,TO_DATE('10/1/99' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CHAPEL STREET OPC', '630GC', 'CHAPEL ST',1009121,1006840, '40 FLATBUSH AVENUE EXTENSION - 8th FLOOR',NULL,NULL, 'BROOKLYN',1009336,NULL, '11201-2903',1006840, '40 FLATBUSH AVENUE EXTENSION - 8th FLOOR',NULL,NULL, 'BROOKLYN',1009336,NULL, '11201-2903',1009197, '0',1000216,1000803,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001547,NULL,TO_DATE('12/15/2005' , 'mm/dd/yyyy hh:mi:ss AM'), 'BROOKLYN CBOC (BEDFORD STUYVESANT)', '630GD', 'ZZ BEDFORD STUYVESANT CBOC',1009121,1006840, 'FIRST AVENUE AND 24TH ST',NULL,NULL, 'NEW YORK',1009336,NULL, '10010',1006840, 'FIRST AVENUE AND 24TH STREET',NULL,NULL, 'NEW YORK',1009336,NULL, '10010',1009148, '0',NULL,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001548,NULL,TO_DATE('12/15/2005' , 'mm/dd/yyyy hh:mi:ss AM'), 'BROOKLYN CBOC (SISTER THEA BOWMAN)', '630GE', 'ZZ SISTER THEA BOWMAN CBOC',1009121,1006840, 'FIRST AVENUE AND 24TH ST',NULL,NULL, 'NEW YORK',1009336,NULL, '10010',1006840, 'FIRST AVENUE AND 24TH ST',NULL,NULL, 'NEW YORK',1009336,NULL, '10010',1009148, '0',NULL,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001549,NULL,TO_DATE('12/15/2005' , 'mm/dd/yyyy hh:mi:ss AM'), 'FAR ROCKAWAY CBOC (JOSEPH P. ADDOBO)', '630GF', 'ZZ FAR ROCKAWAY CBOC',1009121,1006840, 'FIRST AVENUE AND 24TH ST',NULL,NULL, 'NEW YORK',1009336,NULL, '10010',1006840, 'FIRST AVENUE AND 24TH ST',NULL,NULL, 'NEW YORK',1009336,NULL, '10010',1009148, '0',NULL,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001550,NULL,NULL, 'NEW YORK PRRTP', '630PA', 'NEW YORK PRRTP',1009121,1006840, '423 EAST 23RD STREET',NULL,NULL, 'NEW YORK CITY',1009336,NULL, '10010-5011',1006840, '423 EAST 23RD STREET',NULL,NULL, 'NEW YORK CITY',1009336,NULL, '10010-5011',1009204, '0',1000216,NULL,NULL,1002203,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001551,NULL,NULL, 'NORTHAMPTON NHC', '6319AA', 'NORTHAMPTON',1009121,1006840, '421 NORTH MAIN STREET',NULL,NULL, 'LEEDS',1009325,NULL, '01053-9764',1006840, '421 NORTH MAIN STREET',NULL,NULL, 'LEEDS',1009325,NULL, '01053-9764',1009185, '0',1000217,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001552,NULL,NULL, 'HOLYOKE (STNB)', '6319AF', 'HOLYOKE (STNB)',1009121,1006840, '110 Cherry Street',NULL,NULL, 'HOLYOKE',1009325,NULL, '1040',1006840, '110 Cherry Street',NULL,NULL, 'Holyoke',1009325,NULL, '1040',1009221, '0',1000217,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001553,NULL,NULL, 'SPRINGFIELD OPC', '631BY', 'SPRINGFIELD',1009121,1006840, '25 BOND STREET',NULL,NULL, 'SPRINGFIELD',1009325,NULL, '01104-3401',1006840, '25 BOND STREET',NULL,NULL, 'SPRINGFIELD',1009325,NULL, '01104-3401',1009197, '0',1000217,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001555,NULL,NULL, 'HOLYOKE SOLDIERS HOME DOMICILIARY', '631EL', 'HOLYOKE (STATE DOM)',1009121,1006840, '110 CHERRY STREET',NULL,NULL, 'HOLYOKE',1009325,NULL, '1040',1006840, '110 CHERRY STREET',NULL,NULL, 'HOLYOKE',1009325,NULL, '1040',1009219, '0',1000217,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001556,NULL,NULL, 'NORTHAMPTON CBOC', '631GA', 'NORTHAMPTON CBOC',1009121,1006840, '421 NORTH MAIN STREET',NULL,NULL, 'LEEDS',1009325,NULL, '01053-9764',1006840, '421 NORTH MAIN STREET',NULL,NULL, 'LEEDS',1009325,NULL, '01053-9764',1009148, '0',1000217,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001558,NULL,NULL, 'PITTSFIELD CBOC', '631GC', 'PITTSFIELD CBOC',1009121,1006840, '73 EAGLE STREET',NULL,NULL, 'PITTSFIELD',1009325,NULL, '01201-4714',1006840, '73 EAGLE STREET',NULL,NULL, 'PITTSFIELD',1009325,NULL, '01201-4714',1009148, '0',1000217,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001559,TO_DATE('11/2/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'GREENFIELD CBOC', '631GD', 'GREENFIELD (CBOC)',1009121,1006840, '143 MUNSON STREET',NULL,NULL, 'GREENFIELD',1009325,NULL, '01301-9694',1006840, '143 MUNSON STREET',NULL,NULL, 'GREENFIELD',1009325,NULL, '01301-9694',1009148, '0',1000217,1001560,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001560,NULL,TO_DATE('11/2/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GREENFIELD', '631HA', 'ZZ GREENFIELD',1009121,1006840, 'MOBILE CLINIC',NULL,NULL, 'GREENFIELD',1009325,NULL, '1301',1006840, 'MOBILE CLINIC',NULL,NULL, 'GREENFIELD',1009325,NULL, '1301',1009198, '0',NULL,NULL,1001559,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001561,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PITTSFIELD', '631HB', 'ZZ PITTSFIELD',1009121,1006840, 'XXX',NULL,NULL, 'PITTSFIELD',1009325,NULL, '1201',1006840, 'XXX',NULL,NULL, 'PITTSFIELD',1009325,NULL, '1201',1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001573,NULL,NULL, 'OKLAHOMA CITY (NHCU)', '6359AA', 'OKLAHOMA CITY (NHCU)',1009121,1006840,NULL,NULL,NULL, 'OKLAHOMA CITY',1009340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001574,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ OKLAHOMA CITY', '6359AF', 'ZZ OKLAHOMA CITY',1009121,1006840,NULL,NULL,NULL, 'ARDMORE',1009340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001581,NULL,NULL, 'ARDMORE CENTER', '635DT', 'ARDMORE (SVH)',1009121,1006840, 'P.O. Box 489',NULL,NULL, 'ARDMORE',1009340,NULL, '73402',1006840, '1015 S. COMMERCE',NULL,NULL, 'ARDMORE',1009340,NULL, '73402',1009222, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001582,NULL,NULL, 'NORMAN CENTER', '635DU', 'NORMAN (SVH)',1009121,1006840, '1776 East Robinson Street',NULL,NULL, 'NORMAN',1009340,NULL, '73070',1006840, '1776 EAST ROBINSON ST.',NULL,NULL, 'NORMAN',1009340,NULL, '73070',1009222, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001583,NULL,NULL, 'SULPHUR CENTER', '635DV', 'SULPHUR (SVH)',1009121,1006840, '200 E. Fairlane',NULL,NULL, 'SULPHUR',1009340,NULL, '73086',1006840, '200 E. FAIRLANE',NULL,NULL, 'SULPHUR',1009340,NULL, '73086',1009222, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001584,NULL,NULL, 'CLINTON CENTER', '635DW', 'CLINTON (SVH)',1009121,1006840, 'P.O. Box 1209',NULL,NULL, 'CLINTON',1009340,NULL, '73601',1006840, 'P.O. BOX 1209',NULL,NULL, 'CLINTON',1009340,NULL, '73601',1009222, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001585,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TALIHINA', '635DX', 'ZZ TALIHINA',1009121,1006840, '921 N.E. 13TH ST',NULL,NULL, 'TALIHINA',1009340,NULL, '73104',1006840, '921 N.E. 13TH ST',NULL,NULL, 'TALIHINA',1009340,NULL, '73104',1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001586,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CLAREMORE', '635DY', 'ZZ CLAREMORE',1009121,1006840, '3001 W. Blue Starr Drive',NULL,NULL, 'CLA-- remORE',1009340,NULL, '74018',1006840, '3001 W. Blue Starr Drive',NULL,NULL, 'CLA-- remORE',1009340,NULL, '74018',1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001587,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SULPHUR', '635EL', 'ZZ SULPHUR',1009121,1006840, '200 E. Fairlane',NULL,NULL, 'SULPHUR',1009340,NULL, '73086',1006840, '200 E. Fairlane',NULL,NULL, 'SULPHUR',1009340,NULL, '73086',1009220, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001589,NULL,NULL, 'WICHITA FALLS CBOC VETERANS CLINIC OF NORTH TEXAS', '635GB', 'WICHITA FALLS (CBOC)',1009121,1006840, '1800 7TH STREET',NULL,NULL, 'WICHITA FALLS',1009348,NULL, '76301-4204',1006840, '1800 7TH STREET',NULL,NULL, 'WICHITA FALLS',1009348,NULL, '76301-4204',1009148, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001590,NULL,NULL, 'BLACKWELL CBOC', '635GC', 'BLACKWELL CBOC',1009121,1006840, '1009 W. FERGUSON AVE',NULL,NULL, 'BLACKWELL',1009340,NULL, '74631-5602',1006840, '1009 W. FERGUSON AVE',NULL,NULL, 'BLACKWELL',1009340,NULL, '74631-5602',1009148, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001591,NULL,NULL, 'ADA CBOC', '635GD', 'ADA CBOC',1009121,1006840, '301 N. MONTE VISTA',NULL,NULL, 'ADA',1009340,NULL, '74820-4607',1006840, '301 N. MONTE VISTA',NULL,NULL, 'ADA',1009340,NULL, '74820-4607',1009148, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001592,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'CLINTON VETERANS CENTER', '635HA', 'ZZ-CLINTON CBOC',1009121,1006840, '1901 S. FOURTH STREET',NULL,NULL, 'CLINTON',1009340,NULL, '73601-9998',1006840, '1901 S. FOURTH STREET',NULL,NULL, 'CLINTON',1009340,NULL, '73601-9998',1009148, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001594,NULL,NULL, 'OKLAHOMA CITY PRRTP', '635PA', 'OKLAHOMA CITY (PRRTP)',1009121,1006840, '921 NE 13TH STREET',NULL,NULL, 'OKLAHOMA CITY',1009340,NULL, '73104-5007',1006840, '921 N.E. 13TH ST.',NULL,NULL, 'OKLAHOMA CITY',1009340,NULL, '73104-5007',1009204, '0',1000219,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001595,NULL,TO_DATE('5/31/2007' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ OMAHA NHC', '6369AA', 'ZZ OMAHA NHC',1009121,1006840,NULL,NULL,NULL,NULL,1009331,NULL,NULL,1006840,NULL,NULL,NULL,NULL,1009331,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:15:55 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 05/31/07 changes');
Insert into sdsadm.STD_Institution values(1001600,TO_DATE('10/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'IOWA CITY HCS', '636A8', 'IOWA CITY HCS',1009121,1006840, '601 HWY 6 WEST',NULL,NULL, 'IOWA CITY',1009319,NULL, '52246-2292',1006840, '601 HWY 6 WEST',NULL,NULL, 'IOWA CITY',1009319,NULL, '52246-2292',1009231, '0',1000220,1000176,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001601,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'DES MOINES VA DOMICILIARY', '636BU', 'VA DOM DES MOINES',1009121,1006840, '3600 30TH STREET',NULL,NULL, 'DES MOINES',1009319,NULL, '50310-5876',1006840, '3600 30TH STREET',NULL,NULL, 'DES MOINES',1009319,NULL, '50310-5876',1009158, '0',1000220,1001063,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001602,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'KNOXVILLE VA DOMICILIARY', '636BV', 'VA DOM KNOXVILLE',1009121,1006840, '1515 W PLEASANT',NULL,NULL, 'KNOXVILLE',1009319,NULL, '50138-3399',1006840, '1515 W PLEASANT',NULL,NULL, 'KNOXVILLE',1009319,NULL, '50138-3399',1009158, '0',1000220,1001064,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001603,NULL,NULL, 'BELLEVUE (OFFUTT AFB)', '636CZ', 'OFFUTT AFB-BELLEVUE',1009122,1006840, 'Offutt AFB',NULL,NULL, 'Bellevue',1009331,NULL, '68113',1006840, 'Offutt AFB',NULL,NULL, 'Bellevue',1009331,NULL, '68113',1009224, '0',1000220,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001604,NULL,TO_DATE('8/18/2009' , 'mm/dd/yyyy hh:mi:ss AM'), 'THOMAS FITZGERALD STATE NURSING HOME', '636DT', 'ZZ-OMAHA STATE VET HOME',1009121,1006840, '156th West Maple Road',NULL,NULL, 'Omaha',1009331,NULL, '68113',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001605,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'GRAND ISLAND NEBRASKA STATE VETERANS HOME', '636DU', 'GRAND ISLAND STATE VET HOME',1009121,1006840, 'Burkett Station',NULL,NULL, 'Grand Island',1009331,NULL, '68802',1006840, 'Burkett Station',NULL,NULL, 'GRAND ISLAND',1009331,NULL, '68802',1009219, '0',1000220,1001343,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001606,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'NORFOLK NEBRASKA STATE VETERANS HOME', '636DV', 'NORFOLK STATE VET HOME',1009121,1006840, '600 E. BENJAMIN',NULL,NULL, 'NORFOLK',1009331,NULL, '68701',1006840, '600 E. BENJAMIN',NULL,NULL, 'NORFOLK',1009331,NULL, '68701',1009219, '0',1000220,1001344,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001608,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'QUINCY VA DOMICILIARY', '636DX', 'QUINCY STATE DOM',1009121,1006840, '1707 N 12TH STREET',NULL,NULL, 'QUINCY',1009317,NULL, '62301',1006840, '1707 N 12TH STREET',NULL,NULL, 'QUINCY',1009317,NULL, '62301',1009222, '0',1000220,1001234,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001609,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MARSHALLTOWN STATE HOME', '636EL', 'MARSHALLTOWN STATE VET HOME',1009121,1006840, '1301 SUMMIT',NULL,NULL, 'MARSHALLTOWN',1009319,NULL, '50158',1006840, '1301 SUMMIT',NULL,NULL, 'MARSHALLTOWN',1009319,NULL, '50158',1009221, '0',1000220,1001066,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001610,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'QUINCY STATE HOME', '636EM', 'QUINCY STATE VET HOME',1009121,1006840, '1707 N 12TH STREET',NULL,NULL, 'QUINCY',1009317,NULL, '62301',1006840, '1707 N 12TH STREET',NULL,NULL, 'QUINCY',1009317,NULL, '62301',1009219, '0',1000220,1001235,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001612,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'NORTH PLATTE CBOC', '636GB', 'NORTH PLATTE CBOC',1009121,1006840, '600 East Francis  Suite 3',NULL,NULL, 'NORTH PLATTE',1009331,NULL, '69101-6796',1006840, '600 East Francis  Suite 3',NULL,NULL, 'NORTH PLATTE',1009331,NULL, '69101-6796',1009148, '0',1001598,1001345,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001613,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MASON CITY COMMINITY BASED OUTPATIENT CLINIC', '636GC', 'MASON CITY CBOC',1009121,1006840, '520 S PIERCE AVE #150',NULL,NULL, 'MASON CITY',1009319,NULL, '50401-2711',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001598,1001069,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1001614,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MARSHALLTOWN COMMUNITY BASED OUTPATIENT CLINIC', '636GD', 'MARSHALLTOWN CBOC',1009121,1006840, '101 IOWA AVE',NULL,NULL, 'MARSHALLTOWN',1009319,NULL, '50158-4768',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001598,1001071,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001615,NULL,TO_DATE('2/22/2011' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ OTTUMWA COMMUNITY BASED OUTPATIENT CLINIC', '636GE', 'ZZ OTTUMWA CBOC',1009121,1006840, '1001 PENNSYLVANIA',NULL,NULL, 'OTTUMWA',1009319,NULL, '52501',1006840, '1001 PENNSYLVANIA',NULL,NULL, 'OTTUMWA',1009319,NULL, '52501',1009148, '0',1000220,1001070,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001616,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'BETTENDORF COMMUNITY BASED OUTPATIENT CLINIC', '636GF', 'BETTENDORF CBOC',1009121,1006840, '2979 VICTORIA STREET',NULL,NULL, 'BETTENDORF',1009319,NULL, '52722-2784',1006840, '2979 VICTORIA STREET',NULL,NULL, 'BETTENDORF',1009319,NULL, '52722-2784',1009148, '0',1001600,1001233,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001617,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'QUINCY COMMUNITY BASED OUTPATIENT CLINIC', '636GG', 'QUINCY CBOC',1009121,1006840, '721 BROADWAY',NULL,NULL, 'QUINCY',1009317,NULL, '62301-2708',1006840, '721 BROADWAY',NULL,NULL, 'QUINCY',1009317,NULL, '62301-2708',1009148, '0',1001600,1001236,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001618,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'WATERLOO COMMUNITY BASED OUTPATIENT CLINIC', '636GH', 'WATERLOO CBOC',1009121,1006840, '945 TOWER PARK DRIVE',NULL,NULL, 'WATERLOO',1009319,NULL, '50701-3500',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001600,1001237,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1001619,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'GALESBURG COMMUNITY BASED OUTPATIENT CLINIC', '636GI', 'GALESBURG CBOC',1009121,1006840, '387 E GROVE STREET',NULL,NULL, 'GALESBURG',1009317,NULL, '61401-3728',1006840, 'COTTAGE HOSPITAL',NULL,NULL, 'GALESBURG',1009317,NULL, '61401-3728',1009148, '0',1001600,1001238,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001620,TO_DATE('7/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'DUBUQUE COMMUNITY BASED OUTPATIENT CLINIC', '636GJ', 'DUBUQUE CBOC',1009121,1006840, '200 MERCY DRIVE',NULL,NULL, 'DUBUQUE',1009319,NULL, '52001-7303',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001600,1001239,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1001621,NULL,NULL, 'FORT DODGE CBOC', '636GK', 'FORT DODGE CBOC',1009121,1006840, '2419 SECOND AVE NORTH',NULL,NULL, 'FORT DODGE',1009319,NULL, '50501-5742',1006840, '2419 SECOND AVE NORTH',NULL,NULL, 'FORT DODGE',1009319,NULL, '50501-5742',1009148, '0',1001598,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001622,NULL,NULL, 'GRAND ISLAND SARRTP', '636PA', 'GRAND ISLAND SARRTP',1009121,1006840, '2201 NORTH BROADWELL AVENUE',NULL,NULL, 'GRAND ISLAND',1009331,NULL, '68801-2153',1006840, '2201 NORTH BROADWELL AVENUE',NULL,NULL, 'GRAND ISLAND',1009331,NULL, '68801-2153',1009212, '0',1000220,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001623,NULL,NULL, 'OMAHA SARRTP', '636PB', 'OMAHA SARRTP',1009121,1006840, '4101 WOOLWORTH AVENUE',NULL,NULL, 'OMAHA',1009331,NULL, '68105-1850',1006840, '4101 WOOLWORTH AVENUE',NULL,NULL, 'OMAHA',1009331,NULL, '68105-1850',1009212, '0',1000220,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001624,NULL,NULL, 'ASHEVILLE NURSING HOME', '6379AA', 'ASHEVILLE NURSING HOME',1009121,1006840, '1100 TUNNEL ROAD',NULL,NULL, 'ASHEVILLE',1009337,NULL, '28805',1006840, '1100 TUNNEL ROAD',NULL,NULL, 'ASHEVILLE',1009337,NULL, '28805',1009185, '0',1000221,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001625,NULL,NULL, 'ASHEVILLE-PRRTP', '637PA', 'ASHEVILLE-PRRTP',1009121,1006840, '1100 TUNNEL ROAD',NULL,NULL, 'ASHEVILLE',1009337,NULL, '28805-2043',1006840, '1100 TUNNEL ROAD',NULL,NULL, 'ASHEVILLE',1009337,NULL, '28805-2043',1009212, '0',1000221,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001626,NULL,NULL, 'PALO ALTO NHC', '6409AA', 'PALO ALTO NHC',1009121,1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304',NULL, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304',1009185, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 9:58:18 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/31/2010 changes');
Insert into sdsadm.STD_Institution values(1001627,NULL,NULL, 'LIVERMORE NHC', '6409AB', 'LIVERMORE NHC',1009121,1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',NULL, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',1009185, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 9:58:05 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/16/2010 changes');
Insert into sdsadm.STD_Institution values(1001628,NULL,NULL, 'MENLO PARK VA NHC', '6409AC', 'MENLO PARK VA NHC',1009121,1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304',NULL, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304',1009185, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 9:58:18 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/31/2010 changes');
Insert into sdsadm.STD_Institution values(1001629,NULL,NULL, 'PALO ALTO HEALTH CARE SYSTEM - MENLO PARK DIVSION', '640A0', 'MENLO PARK',1009121,1006840, '795 WILLOW ROAD',NULL,NULL, 'MENLO PARK',1009306,NULL, '94025-2539',1006840, '795 WILLOW ROAD',NULL,NULL, 'MENLO PARK',1009306,NULL, '94025-2539',1009233, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001630,TO_DATE('5/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PALO ALTO VAMC-LIVERMORE', '640A4', 'PALO ALTO VAMC-LIVERMORE',1009121,1006840, '4951 ARROYO ROAD',NULL,NULL, 'LIVERMORE',1009306,NULL, '94550-9650',1006840, '4951 ARROYO ROAD',NULL,NULL, 'LIVERMORE',1009306,NULL, '94550-9650',1009231, '0',1000222,1000190,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001631,NULL,NULL, 'VADOM MENLO PARK', '640BU', 'VADOM MENLO PARK',1009121,1006840, '795 WILLOW ROAD',NULL,NULL, 'MENLO PARK',1009306,NULL, '94025-2539',1006840, '795 WILLOW ROAD',NULL,NULL, 'MENLO PARK',1009306,NULL, '94025-2539',1009158, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1001632,NULL,NULL, 'SAN JOSE VA CLINIC', '640BY', 'SAN JOSE VA CLINIC',1009121,1006840, '80 GREAT OAKS BLVD',NULL,NULL, 'SAN JOSE',1009306,NULL, '95119-1310',1006840, '80 GREAT OAKS BLVD',NULL,NULL, 'SAN JOSE',1009306,NULL, '95119-1310',1009197, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001633,NULL,NULL, 'CAPITOLA VA CLINIC', '640GA', 'CAPITOLA VA CLINIC',1009121,1006840, '1350 N. 41ST AVE',NULL,NULL, 'CAPITOLA',1009306,NULL, '95010-3906',1006840, '1350 N. 41ST AVE',NULL,NULL, 'CAPITOLA',1009306,NULL, '95010-3906',1009148, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001634,NULL,NULL, 'SONORA VA CLINIC', '640GB', 'SONORA VA CLINIC',1009121,1006840, '13663 MONO WAY',NULL,NULL, 'SONORA',1009306,NULL, '95370-5998',1006840, '13663 MONO WAY',NULL,NULL, 'SONORA',1009306,NULL, '95370-5998',1009148, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001635,TO_DATE('4/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PALO ALTO HEALTH CARE SYSTEM - STOCKTON DIVSION', '640HA', 'STOCKTON',1009121,1006840, '7777 South Freedom Drive',NULL,NULL, 'French Camp',1009306,NULL, '95231-9694',1006840, '7777 South Freedom Drive',NULL,NULL, 'French Camp',1009306,NULL, '95231-9694',1009148, '0',1000222,1001355,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:12:13 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0790 08/17/2012');
Insert into sdsadm.STD_Institution values(1001636,NULL,NULL, 'MODESTO VA CLINIC', '640HB', 'MODESTO VA CLINIC',1009121,1006840, '1225 OAKDALE ROAD',NULL,NULL, 'MODESTO',1009306,NULL, '95335-3357',1006840, '1225 OAKDALE ROAD',NULL,NULL, 'MODESTO',1009306,NULL, '95335-3357',1009148, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001637,TO_DATE('4/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MONTEREY VA CLINIC', '640HC', 'MONTEREY VA CLINIC',1009121,1006840, '3401 ENGINEER LANE',NULL,NULL, 'SEASIDE',1009306,NULL, '93955-7200',1006840, '3401 ENGINEER LANE',NULL,NULL, 'SEASIDE',1009306,NULL, '93955-7200',1009148, '0',1000222,1001357,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001638,NULL,NULL, 'PALO ALTO HEALTH CARE SYSTEM - PAD-PRRTP DIVSION', '640PA', 'PAD-PRRTP',1009121,1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',1009204, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001639,NULL,NULL, 'PALO ALTO HEALTH CARE SYSTEM - MPD-PRRTP DIVSION', '640PB', 'MPD-PRRTP',1009121,1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',1006840, '3801 MIRANDA AVE',NULL,NULL, 'PALO ALTO',1009306,NULL, '94304-1207',1009204, '0',1000222,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001643,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CAMBRIDGE', '641GA', 'ZZ CAMBRIDGE',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1001645,NULL,NULL, 'PHILADELPHIA NURSING HOME', '6429AA', 'PHILADELPHIA NURSING HOME',1009121,1006840, '3461 CIVIC CENTER BLVD',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19104',1006840, '3461 CIVIC CENTER BLVD',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19104',1009185, '0',1000224,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001646,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PHILADELPHIA (SOC)', '642BY', 'ZZ PHILADELPHIA (SOC)',1009121,1006840, '1421 CHERRY STREET',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19107',1006840, '1421 CHERRY STREET',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19107',1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001647,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZPNSY-PHILADELPHIA', '642CT', 'ZZPNSY-PHILADELPHIA',1009125,1006840, '1700 PATTISON AVENUE',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19145',1006840, '1700 PATTISON AVENUE',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19145',1009229, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001648,NULL,NULL, 'DELAWARE VALLEY STATE VET HOME', '642DT', 'DELAWARE VALLEY STATE VET HOME',1009121,1006840, '2701 SOUTHAMPTON ROAD',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19154',1006840, '2701 SOUTHAMPTON ROAD',NULL,NULL, 'PHILADELPHIA',1009342,NULL, '19154',1009222, '0',1000224,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001650,NULL,TO_DATE('11/29/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'US COAST GUARD TRAINING CENTER', '642GB', 'US COAST GUARD TRAINING CENTER',1009121,1006840, '1 MUNRO AVENUE',NULL,NULL, 'CAPE MAY',1009334,NULL, '8204',1006840, '1 MUNRO AVENUE',NULL,NULL, 'CAPE MAY',1009334,NULL, '8204',1009148, '0',NULL,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001651,NULL,NULL, 'VICTOR J. SARACINI VA OPC', '642GC', 'VICTOR J. SARACINI VA OPC',1009121,1006840, '433 CAREDEAN DRIVE',NULL,NULL, 'HORSHAM',1009342,NULL, '19044-1321',1006840, '433 CAREDEAN DRIVE',NULL,NULL, 'HORSHAM',1009342,NULL, '19044-1321',1009148, '0',1000224,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001652,NULL,NULL, 'PHOENIX NHC', '6449AA', 'PHOENIX NHC',1009121,1006840,NULL,NULL,NULL, 'PHOENIX',1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000225,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001653,NULL,NULL, 'SOUTHEAST CBOC', '644BY', 'SOUTHEAST CBOC',1009121,1006840, '3285 S. VAL VISTA DR',NULL,NULL, 'GILBERT',1009304,NULL, '85295',1006840,NULL,NULL,NULL,NULL,NULL,1012844,NULL,1009148, '0',1000225,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/2/2014 9:56:22 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0901 04/02/2014');
Insert into sdsadm.STD_Institution values(1001654,NULL,NULL, 'PHOENIX ARMY HOSP', '644CN', 'PHOENIX ARMY HOSP',1009124,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',1000225,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001655,NULL,NULL, 'PHOENIX AFB HOSP', '644CZ', 'PHOENIX AFB HOSP',1009122,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',1000225,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001656,NULL,NULL, 'PHOENIX STATE DOM', '644DT', 'PHOENIX STATE DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000225,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001658,NULL,NULL, 'SHOW LOW CBOC', '644GB', 'SHOW LOW CBOC',1009121,1006840, '2450 SHOW LOW LAKE RD STE 1',NULL,NULL, 'SHOW LOW',1009304,NULL, '85901-7953',1006840, '2450 SHOW LOW LAKE RD STE 1',NULL,NULL, 'SHOW LOW',1009304,NULL, '85901-7953',1009148, '0',1000225,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001659,NULL,NULL, 'SOUTHWEST CBOC', '644GC', 'SOUTHWEST CBOC',1009121,1006840, '213 E MONROE AVE',NULL,NULL, 'BUCKEYE',1009304,NULL, '85326-2704',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000225,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0809 11/19/2012');
Insert into sdsadm.STD_Institution values(1001661,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PITTSBURGH', '6459AA', 'ZZ PITTSBURGH',1009121,1006840,NULL,NULL,NULL, 'PITTSBURGH',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001663,NULL,NULL, 'H. JOHN HEINZ III VAMC', '646A4', 'H. JOHN HEINZ III VAMC',1009121,1006840, '1010 DELAFIELD RD',NULL,NULL, 'PITTSBURGH',1009342,NULL, '15215-3247',1006840, '1010 DELAFIELD RD',NULL,NULL, 'PITTSBURGH',1009342,NULL, '15215-3247',1009231, '0',1000227,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001667,NULL,NULL, 'BELMONT COUNTY VA CLINIC', '646GA', 'BELMONT COUNTY VA CLINIC',1009121,1006840, '107 PLAZA DR',NULL,NULL, 'ST. CLAIRSVILLE',1009339,NULL, '43950-7729',1006840, '107 PLAZA DR.',NULL,NULL, 'ST. CLAIRSVILLE',1009339,NULL, '43950-7729',1009148, '0',1000227,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001669,NULL,NULL, 'BEAVER COUNTY VA CLINIC', '646GC', 'BEAVER COUNTY VA CLINIC',1009121,1006840, '90 WAGNER ROAD',NULL,NULL, 'MONACA',1009342,NULL, '15061-2489',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000227,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001671,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ POPLAR BLUFF NHC', '6479AA', 'ZZ POPLAR BLUFF NHC',1009121,1006840,NULL,NULL,NULL, 'POPLAR BLUFF',1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,1001726,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001672,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ POPLAR BLUFF CIVH', '647DS', 'ZZ POPLAR BLUFF CIVH',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',NULL,NULL,1001738,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001673,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CAPE GIRARDEAU STNB', '647DT', 'ZZ CAPE GIRARDEAU STNB',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,1001745,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001674,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ST LOUIS SVH', '647DU', 'ZZ ST LOUIS SVH',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009222, '0',NULL,NULL,1001746,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001675,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WEST PLAINS CBOC', '647GA', 'ZZ WEST PLAINS CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001754,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001676,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ PARAGOULD CBOC', '647GB', 'ZZ PARAGOULD CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001755,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001677,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CAPE GIRARDEAU CBOC', '647GC', 'ZZ CAPE GIRARDEAU CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001756,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001678,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ POPLAR BLUFF MORC', '647HK', 'ZZ POPLAR BLUFF MORC',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009177, '0',NULL,NULL,1001762,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001679,NULL,NULL, 'VANCOUVER VANC', '6489AA', 'VANCOUVER VNC',1009121,1006840, '1601 E. FOURTH PLAIN BLVD',NULL,NULL, 'VANCOUVER',1009353,NULL, '98661',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000229,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001682,NULL,NULL, 'OREGON STATE HOME', '648DT', 'OREGON STATE HOME',1009121,1006840, '700 Veterans Drive',NULL,NULL, 'THE DALLES',1009341,NULL, '97058',1006840, 'PO BOX 1034',NULL,NULL, 'PORTLAND',1009341,NULL, '97207',1009221, '0',1000229,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001686,NULL,NULL, 'NORTH COAST VA CLINIC', '648GD', 'NORTH COAST VA CLINIC',1009121,1006840, '91400 RILEA NEOCOXIE RD',NULL,NULL, 'Warrenton',1009341,NULL, '97146-7267',1006840, '91400 RILEA NEOCOXIE RD',NULL,NULL, 'WARRENTON',1009341,NULL, '97146-7267',1009148, '0',1000229,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001687,NULL,NULL, 'PRESCOTT NHC', '6499AA', 'PRESCOTT NHC',1009121,1006840,NULL,NULL,NULL, 'PRESCOTT',1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001688,NULL,NULL, 'PRESCOTT DOM', '649BU', 'PRESCOTT DOM',1009121,1006840,NULL,NULL,NULL, 'PRESCOTT',1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001689,NULL,NULL, 'KINGMAN CBOC', '649GA', 'KINGMAN CBOC',1009121,1006840, '2668 HUALAPAI MOUNTAIN ROAD',NULL,NULL, 'KINGMAN',1009304,NULL, '86401-8387',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('7/8/2014 7:27:25 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0909 06/09/2014');
Insert into sdsadm.STD_Institution values(1001690,NULL,NULL, 'FLAGSTAFF CBOC', '649GB', 'FLAGSTAFF CBOC',1009121,1006840, '1300 W UNIVERSITY AVE #200',NULL,NULL, 'FLAGSTAFF',1009304,NULL, '86001-7228',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:16:44 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0850 03/11/2013');
Insert into sdsadm.STD_Institution values(1001691,NULL,NULL, 'PRESCOTT CBOC LAKE HAVASU CITY', '649GC', 'LAKE HAVASU CITY CBOC',1009121,1006840, '2035 Mesquite Ave.',NULL,NULL, 'Lake Havasu City',1009304,NULL, '86403-5894',1006840, '2025 Mesquite Ave.',NULL,NULL, 'Lake Havasu City',1009304,NULL, '86403-5894',1009148, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001692,NULL,NULL, 'ANTHEM CBOC', '649GD', 'ANTHEM CBOC',1009121,1006840, '3618 West Anthem Way',NULL,NULL, 'Anthem',1009304,NULL, '85086-0419',1006840, '3618 West Anthem Way',NULL,NULL, 'Anthem',1009304,NULL, '85086-0419',1009148, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001693,NULL,NULL, 'COTTONWOOD CBOC', '649GE', 'COTTONWOOD CBOC',1009121,1006840, '501 SOUTH WILLARD ST',NULL,NULL, 'COTTONWOOD',1009304,NULL, '86326-8120',1006840,NULL,NULL,NULL,NULL,NULL,1012848,NULL,1009148, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1001694,NULL,NULL, 'HOLBROOK CBOC', '649GF', 'HOLBROOK CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001695,NULL,NULL, 'PRESCOTT MORC', '649HK', 'PRESCOTT MORC',1009121,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009177, '0',1000230,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001696,NULL,NULL, 'BRISTOL SVH', '650DT', 'BRISTOL',1009121,1006840, 'METACOM AVENUE',NULL,NULL, 'BRISTOL',1009344,NULL, '2809',1006840, 'METACOM AVENUE',NULL,NULL, 'BRISTOL',1009344,NULL, '2809',1009221, '0',1000231,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001697,NULL,NULL, 'NEW BEDFORD CBOC', '650GA', 'NEW BEDFORD',1009121,1006840, '175 ELM STREET',NULL,NULL, 'NEW BEDFORD',1009325,NULL, '02740-6006',1006840, '175 ELM STREET',NULL,NULL, 'NEW BEDFORD',1009325,NULL, '02740-6006',1009148, '0',1000231,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001698,NULL,NULL, 'HYANNIS CBOC', '650GB', 'HYANNIS',1009121,1006840, '233 STEVENS STREET',NULL,NULL, 'HYANNIS',1009325,NULL, '02601-3766',1006840, '233 STEVENS STREET',NULL,NULL, 'HYANNIS',1009325,NULL, '02601-3766',1009148, '0',1000231,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001701,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'NANTUCKET CBOC', '650GE', 'ZZ-NANTUCKET',1009121,1006840, '57 PROSPECT STREET',NULL,NULL, 'NANTUCKET',1009325,NULL, '02554-2799',1006840, '57 PROSPECT STREET',NULL,NULL, 'NANTUCKET',1009325,NULL, '02554-2799',1009148, '0',1000231,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001702,NULL,NULL, 'NHC RICHMOND', '6529AA', 'NHC RICHMOND',1009121,1006840, '1201 BROAD ROCK BLVD',NULL,NULL, 'RICHMOND',1009351,NULL, '23249',1006840, '1201 BROAD ROCK BLVD',NULL,NULL, 'RICHMOND',1009351,NULL, '23249',1009185, '0',1000233,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:16:45 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 07/31/07 changes');
Insert into sdsadm.STD_Institution values(1001703,NULL,NULL, 'FREDERICKSBURG VA CLINIC', '652GA', 'FREDERICKSBURG VA CLINIC',1009121,1006840, '130 EXECUTIVE CTR PKWY',NULL,NULL, 'FREDERICKSBURG',1009351,NULL, '22401-3100',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000233,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001704,NULL,NULL, 'ROSEBURG NHC', '6539AA', 'ROSEBURG NHC',1009121,1006840,NULL,NULL,NULL, 'ROSEBURG',1009341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000234,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001706,NULL,NULL, 'NORTH BEND VA CLINIC', '653GA', 'NORTH BEND VA CLINIC',1009121,1006840, '2191 MARION STREET',NULL,NULL, 'NORTH BEND',1009341,NULL, '97459-2314',1006840, '2191 MARION STREET',NULL,NULL, 'NORTH BEND',1009341,NULL, '97459-2314',1009148, '0',1000234,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001707,NULL,NULL, 'BROOKINGS VA CLINIC', '653GB', 'BROOKINGS VA CLINIC',1009121,1006840, '555 5TH STREET',NULL,NULL, 'BROOKINGS',1009341,NULL, '97415-9702',1006840, '555 5TH STREET',NULL,NULL, 'BROOKINGS',1009341,NULL, '97415-9702',1009148, '0',1000234,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001708,NULL,NULL, 'ROSEBURG SARRTP', '653PA', 'ROSEBURG SARRTP',1009121,1006840, '913 NW GARDEN VALLEY BLVD.',NULL,NULL, 'ROSEBURG',1009341,NULL, '97470-6253',1006840, '913 NW GARDEN VALLEY BLVD.',NULL,NULL, 'ROSEBURG',1009341,NULL, '97470-6253',1009212, '0',1000234,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001709,NULL,NULL, 'VANC RENO', '6549AA', 'VANC RENO',1009121,1006840, '975 KIRMAN AVENUE',NULL,NULL, 'RENO',1009332,NULL, '89502',NULL, '975 KIRMAN AVENUE',NULL,NULL, 'RENO',1009332,NULL, '89502',1009185, '0',1000235,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:11:53 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0786 06/14/2012');
Insert into sdsadm.STD_Institution values(1001710,NULL,NULL, 'SIERRA FOOTHILLS VA CLINIC', '654GA', 'SIERRA FOOTHILLS VA CLINIC',1009121,1006840, '11985 HERITAGE OAK PLACE',NULL,NULL, 'AUBURN',1009306,NULL, '95603-2413',1006840, '11985 HERITAGE OAK PLACE',NULL,NULL, 'AUBURN',1009306,NULL, '95603-2413',1009148, '0',1000235,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001711,NULL,NULL, 'CARSON VALLEY VA CLINIC', '654GB', 'CARSON VALLEY VA CLINIC',1009121,1006840, '1330 WATERLOO LN',NULL,NULL, 'GARDNERVILLE',1009332,NULL, '89410-5587',1006840,NULL,NULL,NULL,NULL,NULL,1012903,NULL,1009148, '0',1000235,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001712,NULL,NULL, 'SAGINAW (NHCU)', '6559AA', 'SAGINAW (NHCU)',1009121,1006840, '1500 WEISS ST',NULL,NULL, 'SAGINAW',1009326,NULL, '48602',1006840, '1500 WEISS ST',NULL,NULL, 'SAGINAW',1009326,NULL, '48602',1009185, '0',1000236,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001713,NULL,NULL, 'SAGINAW (DENT)', '655BY', 'SAGINAW (DENT)',1009121,1006840, '1500 WEISS ST',NULL,NULL, 'SAGINAW',1009326,NULL, '48602',1006840, '1500 WEISS ST',NULL,NULL, 'SAGINAW',1009326,NULL, '48602',1009160, '0',1000236,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001714,NULL,NULL, 'GAYLORD VA OUTPATIENT CLINIC', '655GA', 'GAYLORD OUTPATIENT CLINIC',1009121,1006840, '806 S OTSEGO',NULL,NULL, 'GAYLORD',1009326,NULL, '49735-1725',1006840, '806 S OTSEGO',NULL,NULL, 'GAYLORD',1009326,NULL, '49735-1725',1009197, '0',1000236,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001715,NULL,NULL, 'TRAVERSE CITY VA CLINIC', '655GB', 'TRAVERSE CITY VA CLINIC',1009121,1006840, '3271 RACQUET CLUB DRIVE',NULL,NULL, 'TRAVERSE CITY',1009326,NULL, '49684-4708',1006840, '3271 RACQUET CLUB DRIVE',NULL,NULL, 'TRAVERSE CITY',1009326,NULL, '49684-4708',1009148, '0',1000236,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001716,NULL,NULL, 'OSCODA VA CLINIC', '655GC', 'OSCODA VA CLINIC',1009121,1006840, '5671 SKEEL AVE.',NULL,NULL, 'OSCODA',1009326,NULL, '48750-1535',1006840, '5671 SKEEL AVE.',NULL,NULL, 'OSCODA',1009326,NULL, '48750-1535',1009148, '0',1000236,NULL,NULL,1002211,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001717,NULL,NULL, 'ST CLOUD NHCU', '6569AA', 'ST. CLOUD (NHCU)',1009121,1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303',1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303',1009185, '0',1000237,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001718,NULL,NULL, 'ST. CLOUD DOM', '656BU', 'ST. CLOUD (DOM)',1009121,1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303-2015',1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303-2015',1009158, '0',1000237,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001719,NULL,NULL, 'BRAINERD VA COMMUNITY OUTPATIENT CLINIC', '656GA', 'BRAINERD CBOC',1009121,1006840, '722 NW 7th STREET',NULL,NULL, 'BRAINERD',1009327,NULL, '56401-2912',1006840, '722 NW 7th STREET',NULL,NULL, 'BRAINERD',1009327,NULL, '56401-2912',1009148, '0',1000237,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001720,NULL,NULL, 'MONTEVIDEO CBOC', '656GB', 'MONTEVIDEO CBOC',1009121,1006840, '1025 N 13TH ST',NULL,NULL, 'MONTEVIDEO',1009327,NULL, '56265-1653',1006840, '1025 N 13TH ST',NULL,NULL, 'MONTEVIDEO',1009327,NULL, '56265-1653',1009148, '0',1000237,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001721,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ COPE VIRGINIA', '656HA', 'ZZ COPE VIRGINIA',1009121,1006840, '///',NULL,NULL, 'VIRGINIA',1009327,NULL, '56484',1006840, '///',NULL,NULL, 'VIRGINIA',1009327,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001722,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ COPE DULUTH', '656HB', 'ZZ COPE DULUTH',1009121,1006840, '///',NULL,NULL, 'DULUTH',1009327,NULL, '56501',1006840, '///',NULL,NULL, 'DULUTH',1009327,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001723,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ COPE HIBBING', '656HC', 'ZZ COPE HIBBING',1009121,1006840, '///',NULL,NULL, 'HIBBING',1009327,NULL, '56361',1006840, '///',NULL,NULL, 'HIBBING',1009327,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001724,NULL,NULL, 'ST CLOUD PRRTP', '656PA', 'STC-PRRTP',1009121,1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303-2015',1006840, '4801 VETERANS DRIVE',NULL,NULL, 'ST. CLOUD',1009327,NULL, '56303-2015',1009204, '0',1000237,NULL,NULL,1002223,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001725,NULL,NULL, 'ST. LOUIS VA NURSING HOME CARE UNIT (6579AA)', '6579AA', 'ST. LOUIS MO VA NHCU',1009121,1006840, '#1 JEFFERSON BARRACKS DR',NULL,NULL, 'ST LOUIS',1009329,NULL, '63125',1006840, '#1 JEFFERSON BARRACKS DR',NULL,NULL, 'ST LOUIS',1009329,NULL, '63125',1009185, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001726,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'POPLAR BLUFF NURSING HOME CARE UNIT (6579AB)', '6579AB', 'POPLAR BLUFF MO NHC',1009121,1006840, '1500 N WESTWOOD BLVD',NULL,NULL, 'POPLAR BLUFF',1009329,NULL, '63901',1006840, '1500 N WESTWOOD BLVD',NULL,NULL, 'POPLAR BLUFF',1009329,NULL, '63901',1009185, '0',1001732,1001671,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001727,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MARION VA NURSING HOME CARE UNIT (6579AC)', '6579AC', 'MARION IL VA NHCU',1009121,1006840, '2401 W MAIN STREET',NULL,NULL, 'MARION',1009317,NULL, '62959',1006840, '2401 W MAIN STREET',NULL,NULL, 'MARION',1009317,NULL, '62959',1009185, '0',1001733,1001396,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001728,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MARION STATE NURSING HOME CARE UNIT (6579AF)', '6579AF', 'MARION IL STATE NHCU',1009121,1006840, '2401 W MAIN STREET',NULL,NULL, 'MARION',1009317,NULL, '62959',1006840, '2401 W MAIN STREET',NULL,NULL, 'MARION',1009317,NULL, '62959',1009185, '0',1001733,1001397,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001729,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ST. LOUIS MO STNB', '6579AG', 'ZZ ST. LOUIS MO STNB',1009121,1006840,NULL,NULL,NULL, 'MT. VERNON',1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001734,NULL,NULL, 'ST LOUIS MO VA DOMICILIARY (657BU)', '657BU', 'ST. LOUIS VA DOMICILIARY',1009121,1006840, '#1 JEFFERSON BARRACKS DRIVE',NULL,NULL, 'ST LOUIS',1009329,NULL, '63125-4181',1006840, '#1 JEFFERSON BARRACKS DRIVE',NULL,NULL, 'ST LOUIS',1009329,NULL, '63125-4181',1009158, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001735,NULL,NULL, 'ST. LOUIS VA PHARMACY/DDTU (657CA)', '657CA', 'ST. LOUIS VA PHARM/DDTU MO PHA',1009121,1006840, '915 N GRAND BLVD',NULL,NULL, 'ST LOUIS',1009329,NULL, '63106',1006840, '915 N GRAND BLVD',NULL,NULL, 'ST LOUIS',1009329,NULL, '63106',1009201, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001736,NULL,NULL, 'ST. LOUIS VA PHARMACY/NUCL MED', '657CB', 'ST. LOUIS VA PHARMACY/NUCL MED',1009121,1006840, '915 N GRAND BLVD',NULL,NULL, 'ST LOUIS',1009329,NULL, '63106',1006840, '915 N GRAND BLVD',NULL,NULL, 'ST LOUIS',1009329,NULL, '63106',1009201, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001737,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'FORT LEONARD WOOD NON-VA HOSPITAL (657CN) (ARMY)', '657CN', 'ZZFT. LEONARD WOOD MO USAH',1009124,1006840, '126 MISSOURI AVE',NULL,NULL, 'FT. LEONARD WOOD',1009329,NULL, '65473',1006840, '126 MISSOURI AVE',NULL,NULL, 'FT. LEONARD WOOD',1009329,NULL,NULL,1009226, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001738,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'POPLAR BLUFF NON-VA HOSPITAL (657DN) (CIVH)', '657DN', 'POPLAR BLUFF NON-VA HOSP (CIV)',1009121,1006840, '1500 N WESTWOOD BLVD',NULL,NULL, 'POPLAR BLUFF',1009329,NULL, '63901',1006840, '1500 N WESTWOOD BLVD',NULL,NULL, 'POPLAR BLUFF',1009329,NULL, '63901',1009153, '0',1001732,1001672,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001739,NULL,NULL, 'MARION IL HOSPITAL (657DP) (CIVIL/PUBLIC)', '657DP', 'MARION HOSPITAL (CIVIL/PUBLIC)',1009121,1006840, '2401 W MAIN',NULL,NULL, 'MARION',1009317,NULL, '62959',1006840, '2401 W MAIN',NULL,NULL, 'MARION',1009317,NULL, '62959',1009153, '0',1001733,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001740,NULL,NULL, 'ST. LOUIS NON-VA HOSPITAL (CIVIL/PUBLIC)', '657DS', 'ST. LOUIS NON VA HOSP (CIVH)',1009121,1006840, '#1 JEFFERSON BARRACKS DRIVE',NULL,NULL, 'ST LOUIS',1009329,NULL, '63125',1006840, '#1 JEFFERSON BARRACKS DRIVE',NULL,NULL, 'ST LOUIS',1009329,NULL, '63125',1009153, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001741,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ST. JAMES STATE HOME (657DT)', '657DT', 'ZZ ST. JAMES STATE HOME',1009121,1006840,NULL,NULL,NULL, 'ST. JAMES',1009329,NULL, '65559',1006840,NULL,NULL,NULL, 'ST. JAMES',1009329,NULL,NULL,1009221, '0',NULL,NULL,1001274,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001742,NULL,NULL, 'MT. VERNON MO STATE HOME (657DU)', '657DU', 'MT. VERNON STATE HOME',1009121,1006840, '600 N MAIN',NULL,NULL, 'MT. VERNON',1009329,NULL, '65712',1006840, '600 N MAIN',NULL,NULL, 'MT. VERNON',1009329,NULL, '65712',1009221, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001743,NULL,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'MEXICO STATE HOME (657DV)', '657DV', 'ZZ MEXICO STATE HOME',1009121,1006840,NULL,NULL,NULL, 'MEXICO',1009329,NULL, '65265',1006840,NULL,NULL,NULL, 'MEXICO',1009329,NULL,NULL,1009221, '0',NULL,NULL,1001276,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001744,NULL,NULL, 'ST. LOUIS MISSOURI VETERANS STATE HOME (657DW)', '657DW', 'ST. LOUIS MO VET STATE HOME',1009121,1006840, '10600 LEWIS AND CLARK',NULL,NULL, 'ST LOUIS',1009329,NULL, '63136',1006840, '10600 LEWIS AND CLARK',NULL,NULL, 'ST LOUIS',1009329,NULL, '63136',1009221, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001745,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CAPE GIRARDEAU MO STATE HOME (657DX)', '657DX', 'CAPE GIRARDEAU MO STATE HOME',1009121,1006840, '2400 VETERANS MEMORIAL DRIVE',NULL,NULL, 'CAPE GIRARDEAU',1009329,NULL, '63701',1006840, '2400 VETERANS MEMORIAL DRIVE',NULL,NULL, 'CAPE GIRARDEAU',1009329,NULL, '63701',1009221, '0',1001732,1001673,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001746,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MISSOURI STATE VETERANS HOME (657DY)', '657DY', 'MISSOURI STATE VETERANS HOME',1009121,1006840, '10600 LEWIS AND CLARK',NULL,NULL, 'ST LOUIS',1009329,NULL, '63136',1006840, '10600 LEWIS AND CLARK',NULL,NULL, 'ST LOUIS',1009329,NULL, '63136',1009221, '0',1000238,1001674,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001747,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ILLINOIS STATE VETERANS HOME (657DZ)', '657DZ', 'ILLINOIS STATE VETERANS HOME',1009121,1006840, '792 N. MAIN STREET',NULL,NULL, 'ANNA',1009317,NULL, '62906',1006840, '792 N. MAIN STREET',NULL,NULL, 'ANNA',1009317,NULL, '62906',1009221, '0',1001733,1001399,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001748,NULL,NULL, 'WESTERN KENTUCKY SVH', '657EA', 'WESTERN KENTUCKY SVH',1009121,1006840, '926 VETERANS DRIVE',NULL,NULL, 'HANSON',1009317,NULL, '42413',1006840, '926 VETERANS DRIVE',NULL,NULL, 'HANSON',1009321,NULL, '42413',1009222, '0',1001733,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001749,NULL,NULL, 'BELLEVILLE IL CBOC (657GA)', '657GA', 'BELLEVILLE IL CBOC',1009121,1006840, '6500 W MAIN STREET',NULL,NULL, 'BELLEVILLE',1009317,NULL, '62223-3700',1006840, '6500 W MAIN STREET',NULL,NULL, 'BELLEVILLE',1009317,NULL, '62223-3700',1009148, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001750,NULL,NULL, 'ST LOUIS MO CBOC (657GB)', '657GB', 'ST. LOUIS MO CBOC',1009121,1006840, '6854 PARKER ROAD',NULL,NULL, 'FLORISSANT',1009329,NULL, '63033-5313',1006840, '6854 PARKER ROAD',NULL,NULL, 'FLORISSANT',1009329,NULL, '63033-5313',1009148, '0',1000238,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001751,NULL,TO_DATE('12/15/2005' , 'mm/dd/yyyy hh:mi:ss AM'), 'EFFINGHAM IL CBOC-STL (657GC)', '657GC', 'ZZ EFFINGHAM IL CBOC-STL',1009121,1006840, '301 W. VIRGINIA STREET',NULL,NULL, 'EFFINGHAM',1009317,NULL, '62401',1006840, '301 W. VIRGINIA STREET',NULL,NULL, 'EFFINGHAM',1009317,NULL,NULL,1009148, '0',NULL,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001753,NULL,TO_DATE('5/5/2008' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SPRINGFIELD IL CBOC', '657GE', 'ZZ SPRINGFIELD IL CBOC',1009121,1006840, '326 N. 7TH STREET',NULL,NULL, 'SPRINGFIELD',1009317,NULL, '62769',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001754,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'WEST PLAINS MO CBOC (657GF)', '657GF', 'WEST PLAINS MO CBOC',1009121,1006840, '1801 E STATE ROUTE K',NULL,NULL, 'WEST PLAINS',1009329,NULL, '65775-6616',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001732,1001675,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:16:15 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0846 2/12/2013');
Insert into sdsadm.STD_Institution values(1001755,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PARAGOULD AR CBOC (657GG)', '657GG', 'PARAGOULD CBOC',1009121,1006840, '2420 LINWOOD DRIVE SUITE 3',NULL,NULL, 'PARAGOULD',1009305,NULL, '72450-6122',1006840, '2420 LINWOOD DRIVE SUITE 3',NULL,NULL, 'PARAGOULD',1009305,NULL, '72450-6122',1009148, '0',1001732,1001676,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0765 12/09/2011');
Insert into sdsadm.STD_Institution values(1001756,TO_DATE('4/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CAPE GIRARDEAU MO CBOC (657GH)', '657GH', 'CAPE GIRARDEAU MO CBOC',1009121,1006840, '3051 WILLIAM ST',NULL,NULL, 'CAPE GIRARDEAU',1009329,NULL, '63701-6393',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001732,1001677,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:31:37 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0928 03/02/2015');
Insert into sdsadm.STD_Institution values(1001757,NULL,NULL, 'FARMINTON MO CBOC (657GI)', '657GI', 'FARMINGTON MO CBOC',1009121,1006840, '1580 W COLUMBIA DRIVE',NULL,NULL, 'FARMINGTON',1009329,NULL, '63640-3512',1006840, '1580 W COLUMBIA DRIVE',NULL,NULL, 'FARMINGTON',1009329,NULL, '63640-3512',1009148, '0',1001732,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001758,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'EVANSVILLE IL CBOC', '657GJ', 'EVANSVILLE CBOC',1009121,1006840, '6211 E WATERFORD BLVD',NULL,NULL, 'EVANSVILLE',1009318,NULL, '47715-2869',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001733,1001398,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:15:45 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0833 1/14/2013');
Insert into sdsadm.STD_Institution values(1001759,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MT. VERNON IL CBOC (657GK)', '657GK', 'MT. VERNON IL CBOC',1009121,1006840, '4105 N WATER TOWER PLACE',NULL,NULL, 'MT. VERNON',1009317,NULL, '62864-6296',1006840, '4105 N WATER TOWER PLACE',NULL,NULL, 'MT. VERNON',1009317,NULL, '62864-6296',1009148, '0',1001733,1001400,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001760,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PADUCAH KY CBOC (657GL)', '657GL', 'PADUCAH KY CBOC',1009121,1006840, '2620 PERKINS CREEL DRIVE',NULL,NULL, 'PADUCAH',1009321,NULL, '42001-7494',1006840, '2620 PERKINS CREEL DRIVE',NULL,NULL, 'PADUCAH',1009321,NULL, '42001-7494',1009148, '0',1001733,1001401,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001761,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'EFFINGHAM VA CLINIC', '657GM', 'EFFINGHAM VA CLINIC',1009121,1006840, '1011 FORD AVE',NULL,NULL, 'EFFINGHAM',1009317,NULL, '62401-9998',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001733,1001402,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001763,TO_DATE('7/1/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'MARION PSYCHOSOCIAL RESIDENTIAL REHABILITATION TREATMENT PROGRAM', '657PC', 'MARION IL PRRTP',1009121,1006840, '2401 W. MAIN STREET',NULL,NULL, 'MARION',1009317,NULL, '62959-1188',1006840, '2401 W. MAIN STREET',NULL,NULL, 'MARION',1009317,NULL, '62959-1188',1009204, '0',1001733,1001403,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001764,NULL,NULL, 'SALEM NHC', '6589AA', 'SALEM NHC',1009121,1006840,NULL,NULL,NULL, 'SALEM',1009351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000239,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001765,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ROANOKE PHS', '658C6', 'ZZ ROANOKE PHS',1009121,1006840, 'ZZ',NULL,NULL, 'ZZ',1009351,NULL, '24153',1006840, 'ZZ',NULL,NULL, 'ZZ',1009351,NULL,NULL,1009202, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001766,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ROANOKE NAVY HOSP', '658CT', 'ZZ ROANOKE NAVY HOSP',1009125,1006840, 'ZZ',NULL,NULL, 'ZZ',1009351,NULL, '24153',1006840, 'ZZ',NULL,NULL, 'ZZ',1009351,NULL,NULL,1009229, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001767,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'SALEM AFB HOSP', '658CZ', 'ZZ SALEM AFB HOSP',1009122,1006840, 'ZZ',NULL,NULL, 'ZZ',1009351,NULL, '24153',1006840, 'ZZ',NULL,NULL, 'ZZ',1009351,NULL,NULL,1009224, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001768,NULL,NULL, 'VA VETERANS CARE CENTER', '658DT', 'VIRGINIA VETERANS CARE CENTER',1009121,1006840, '4550 SHENANDOAH AVE',NULL,NULL, 'ROANOKE',1009351,NULL, '24017-4749',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000239,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('8/13/2015 8:55:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0931 06/03/2015');
Insert into sdsadm.STD_Institution values(1001769,NULL,NULL, 'TAZEWELL VA CLINIC', '658GA', 'TAZEWELL VA CLINIC',1009121,1006840, '123 BEN BOLT AVENUE',NULL,NULL, 'TAZEWELL',1009351,NULL, '24651-9700',1006840, '123 BEN BOLT AVE',NULL,NULL, 'TAZEWELL',1009351,NULL, '24651-9700',1009148, '0',1000239,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001770,NULL,NULL, 'DANVILLE VA CLINIC', '658GB', 'DANVILLE VA CLINIC',1009121,1006840, '705 PINEY FOREST ROAD',NULL,NULL, 'DANVILLE',1009351,NULL, '24540-2860',1006840, '705 PINEY FOREST ROAD',NULL,NULL, 'DANVILLE',1009351,NULL, '24540-2860',1009148, '0',1000239,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001771,NULL,NULL, 'STUARTS DRAFT OUTREACH CLINIC', '658HA', 'STUARTS DRAFT',1009121,1006840, '3251 STUARTS DRAFT HIGHWAY',NULL,NULL, 'STUARTS DRAFT',1009351,NULL, '24477-2785',1006840, '3251 STUARTS DRAFT HIGHWAY',NULL,NULL, 'STUARTS DRAFT',1009351,NULL,NULL,1009148, '0',1000239,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001772,NULL,TO_DATE('1/17/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'PULASKI OUTREACH CLINIC', '658HB', 'ZZ PULASKI',1009121,1006840, 'PRESBYTERIAN CHURCH',NULL,NULL, 'PULASKI',1009351,NULL, '24301',1006840, 'VA MEDICAL CENTER',NULL,NULL, 'SALEM',1009351,NULL,NULL,1009198, '0',NULL,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001773,NULL,TO_DATE('9/13/2010' , 'mm/dd/yyyy hh:mi:ss AM'), 'LYNCHBURG OUTREACH CLINIC', '658HC', 'ZZ-LYNCHBURG CBOC',1009121,1006840, 'AMERICAN LEGION POST #16',NULL,NULL, 'LYNCHBURG',1009351,NULL, '24506',1006840, '1970 ROANOKE BLVD',NULL,NULL, 'SALEM',1009351,NULL,NULL,1009148, '0',1000239,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001774,NULL,TO_DATE('1/17/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'HILLSVILLE OUTREACH CLINIC', '658HD', 'ZZ HILLSVILE',1009121,1006840, 'VFW GROVER KING POST #1115',NULL,NULL, 'HILLSVILLE',1009351,NULL, '24343',1006840, '1970 ROANOKE BLVD',NULL,NULL, 'SALEM',1009351,NULL,NULL,1009198, '0',NULL,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001775,NULL,TO_DATE('1/17/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'MARTINSVILLE CBOC', '658HE', 'ZZ MARTINSVILLE CBOC',1009121,1006840, '315 HOSPITAL DR. SUITE 101',NULL,NULL, 'MARTINSVILLE',1009351,NULL, '24112',1006840, '315 HOSPITAL DR. SUITE 101',NULL,NULL, 'MARTINSVILLE',1009351,NULL,NULL,1009148, '0',NULL,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001776,NULL,TO_DATE('1/17/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'DANVILLE', '658HF', 'ZZ DANVILLE',1009121,1006840, '2811 RIVERSIDE DR',NULL,NULL, 'DANVILLE',1009351,NULL, '24541',1006840, '2811 RIVERSIDE DR',NULL,NULL, 'DANVILLE',1009351,NULL,NULL,1009198, '0',NULL,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001777,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'COVINGTON OUTREACH CLINIC', '658HG', 'ZZ-COVINGTON OUTREACH CLINIC',1009121,1006840, '710 E DOLLY ANN DR',NULL,NULL, 'COVINGTON',1009351,NULL, '24426-2193',1006840, '1970 ROANOKE BLVD',NULL,NULL, 'SALEM',1009351,NULL,NULL,1009148, '0',1000239,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001778,NULL,TO_DATE('1/17/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'MARION OUTREACH CLINIC', '658HH', 'ZZ MARION',1009121,1006840, 'VFW POST #4667',NULL,NULL, 'MARION',1009351,NULL, '24354',1006840, '1970 ROANOKE BLVD',NULL,NULL, 'SALEM',1009351,NULL,NULL,1009198, '0',NULL,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001779,NULL,NULL, 'SALISBURY NHC', '6599AA', 'SALISBURY NHC',1009121,1006840,NULL,NULL,NULL, 'SALISBURY',1009337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000240,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001781,NULL,NULL, 'WINSTON', '659CN', 'WINSTON',1009124,1006840, '1601 BRENNER AVE',NULL,NULL, 'SALISBURY',1009337,NULL, '28144',1006840, '1601 BRENNER AVE',NULL,NULL, 'SALISBURY',1009337,NULL, '28144',1009226, '0',1000240,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001783,NULL,NULL, 'NORTH CHARLOTTE VA CLINIC', '659GA', 'NORTH CHARLOTTE VA CLINIC',1009121,1006840, '8601 UNIVERSITY EAST DRIVE',NULL,NULL, 'CHARLOTTE',1009337,NULL, '28213-4353',1006840, '8601 UNIVERSITY EAST DRIVE',NULL,NULL, 'CHARLOTTE',1009337,NULL, '28213-4353',1009148, '0',1000240,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001784,NULL,NULL, 'SALISBURY PSYCHOLOGICAL RESIDENTIAL REHABILITATION TREATMENT PROGRAM', '659PA', 'SAL-PRRTP',1009121,1006840, '1601 BRENNER AVE',NULL,NULL, 'SALISBURY',1009337,NULL, '28144-2515',1006840, '1601 BRENNER AVE',NULL,NULL, 'SALISBURY',1009337,NULL, '28144-2515',1009204, '0',1000240,NULL,NULL,1002206,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001785,NULL,NULL, 'SALT LAKE CITY NHC', '6609AA', 'SALT LAKE CITY NHC',1009121,1006840,NULL,NULL,NULL, 'SALT LAKE CITY',1009349,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001786,NULL,NULL, 'HILL AIR FORCE BASE', '660CZ', 'SALT LAKE CITY',1009122,1006840, '5847 O AVE',NULL,NULL, 'HILL AIR BASE',1009349,NULL, '84056-5016',1006840, 'HILL AIR FORCE BASE',NULL,NULL, 'HILL AIR FORCE BASE',1009349,NULL, '84056-5016',1009224, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001787,NULL,NULL, 'IDAHO STATE VETERANS HOME', '660DT', 'POCATELLO STNB',1009121,1006840, '1957 Alvin Ricken Drive',NULL,NULL, 'POCATELLO',1009316,NULL, '83201',1006840, '1957 Alvin Ricken Drive',NULL,NULL, 'POCATELLO',1009316,NULL, '83201',1009221, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001788,NULL,NULL, 'UTAH STATE VETERANS NURSING HOME (660DU)', '660DU', 'UTAH',1009121,1006840, '700 FOOTHILL BLVD.',NULL,NULL, 'SALT LAKE CITY',1009349,NULL, '84113-1104',1006840, '700 FOOTHILL BLVD.',NULL,NULL, 'SALT LAKE CITY',1009349,NULL, '84113-1104',1009221, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001789,NULL,NULL, 'VA POCATELLO CBOC (660GA)', '660GA', 'POCATELLO CBOC',1009121,1006840, '444 HOSPITAL WAY SUITE 801',NULL,NULL, 'POCATELLO',1009316,NULL, '83201-2745',1006840, '444 HOSPITAL WAY SUITE 801',NULL,NULL, 'POCATELLO',1009316,NULL, '83201-2745',1009148, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001790,NULL,NULL, 'OGDEN VA CLINIC', '660GB', 'OGDEN VA CLINIC',1009121,1006840, '982 CHAMBERS STREET',NULL,NULL, 'SOUTH OGDEN',1009349,NULL, '84403-4571',1006840, '982 CHAMBERS STREET',NULL,NULL, 'SOUTH OGDEN',1009349,NULL, '84403-4571',1009148, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001791,NULL,NULL, 'ELY VA CLINIC', '660GC', 'ELY VA CLINIC',1009121,1006840, '#6 STEPTOE CIRCLE',NULL,NULL, 'ELY',1009332,NULL, '89301-2692',1006840, '#6 STEPTOE CIRCLE',NULL,NULL, 'ELY',1009332,NULL, '89301-2692',1009148, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001792,NULL,NULL, 'ROOSEVELT VA CLINIC', '660GD', 'ROOSEVELT VA CLINIC',1009121,1006840, '245 WEST 200 NORTH',NULL,NULL, 'ROOSEVELT',1009349,NULL, '84066-2740',1006840, '245 WEST 200 NORTH',NULL,NULL, 'ROOSEVELT',1009349,NULL, '84066-2740',1009148, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001794,NULL,TO_DATE('3/13/2007' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA GREEN RIVER CBOC CLINIC (660GF)', '660GF', 'ZZ GREEN RIVER',1009121,1006840, '1400 UINTA DRIVE',NULL,NULL, 'GREEN RIVER',1009356,NULL, '82935',1006840, '1400 UINTA DRIVE',NULL,NULL, 'GREEN RIVER',1009356,NULL,NULL,1009148, '0',NULL,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001796,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA TOOELE OUTPATIENT CLINIC (660GH)', '660GH', 'ZZ TOOELE CBOC',1009121,1006840, 'UNNK',NULL,NULL, 'TOOELE',1009349,NULL, '84148',1006840, 'UNNK',NULL,NULL, 'TOOELE',1009349,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001797,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA SOUTH CENTERAL CBOC (660GI)', '660GI', 'ZZ-NEPHI CBOC',1009121,1006840, '48 WEST 1500 NORTH',NULL,NULL, 'NEPHI',1009349,NULL, '84648-8900',1006840, '48 WEST 1500 NORTH',NULL,NULL, 'NEPHI',1009349,NULL,NULL,1009148, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001798,NULL,NULL, 'VA SALT LAKE CITY PRRTP (660PA)', '660PA', 'SALT LAKE CITY PRRTP',1009121,1006840, '500 FOOTHILL BLVD.',NULL,NULL, 'SALT LAKE CITY',1009349,NULL, '84148-0001',1006840, 'SALT LAKE CITY PRRTP',NULL,NULL, 'SALT LAKE CITY',1009349,NULL, '84148-0001',1009204, '0',1000241,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001799,NULL,NULL, 'SAN FRAN NHC', '6629AA', 'SAN FRAN NHC',1009121,1006840,NULL,NULL,NULL, 'SAN FRANCISCO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001800,NULL,NULL, 'SAN FRAN STNB', '6629AF', 'SAN FRAN STNB',1009121,1006840,NULL,NULL,NULL, 'SAN FRANCISCO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001801,NULL,TO_DATE('2/20/2008' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ VA COMPREHENSIVE HMLESS CTR', '662BU', 'ZZ VA COMPREHENSIVE HMLESS CTR',1009121,1006840, '401 3RD STREET',NULL,NULL, 'SAN FRANCISCO',1009306,NULL, '94107',1006840, '401 3RD STREET',NULL,NULL, 'SAN FRANCISCO',1009306,NULL,NULL,1009158, '0',NULL,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001802,NULL,NULL, 'SAN FRAN PHS', '662C5', 'SAN FRAN PHS',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009202, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001803,NULL,NULL, 'SAN FRAN USAH', '662CN', 'SAN FRAN USAH',1009124,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001804,NULL,NULL, 'SAN FRAN USNH', '662CT', 'SAN FRAN USNH',1009125,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009229, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001805,NULL,NULL, 'SAN FRAN USAF', '662CZ', 'SAN FRAN USAF',1009122,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001806,NULL,NULL, 'YOUNTVILLE STNB', '662DT', 'YOUNTVILLE STNB',1009121,1006840,NULL,NULL,NULL, 'YOUNTVILLE',1009306,NULL, '94121',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001808,NULL,NULL, 'VALLEJO CBOC', '662GB', 'VALLEJO CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001809,NULL,NULL, 'EUREKA VA CLINIC', '662GC', 'EUREKA VA CLINIC',1009121,1006840, '930 W HARRIS ST',NULL,NULL, 'EUREKA',1009306,NULL, '95503-3927',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001810,NULL,NULL, 'UKIAH VA CLINIC', '662GD', 'UKIAH VA CLINIC',1009121,1006840, '630 KINGS COURT',NULL,NULL, 'UKIAH',1009306,NULL, '95482-5003',NULL, '630 KINGS COURT',NULL,NULL, 'UKIAH',1009306,NULL, '95482-5003',1009148, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001811,NULL,NULL, 'YOUNTVILLE ORC', '662HA', 'YOUNTVILLE ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001812,NULL,NULL, 'SAN FRAN PRRTP', '662PA', 'SAN FRAN PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',1000242,NULL,NULL,1002221,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001813,NULL,NULL, 'PUGET SOUND HEALTH CARE SYSTEM - SEATTLE NHC PTF', '6639AA', 'SEATTLE',1009121,1006840, '1660 South Columbian Way',NULL,NULL, 'SEATTLE',1009353,NULL, '98108',1006840, '1660 South Columbian Way',NULL,NULL, 'SEATTLE',1009353,NULL, '98108',1009185, '0',1000243,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:34:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/18/05 changes');
Insert into sdsadm.STD_Institution values(1001816,TO_DATE('7/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PUGET SOUND HEALTH CARE SYSTEM - AMERICAN LAKE DIVISION', '663A4', 'AMERICAN LAKE (VAMC)',1009121,1006840, '9600 VETERANS DRIVE SW',NULL,NULL, 'TACOMA',1009353,NULL, '98493-0001',1006840, '9600 VETERANS DRIVE SW',NULL,NULL, 'TACOMA',1009353,NULL, '98493-0001',1009231, '0',1000243,1000112,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001817,NULL,NULL, 'PUGET SOUND HEALTH CARE SYSTEM - AMERICAN LAKE DOM PTF', '663BU', 'AMERICAN LAKE',1009121,1006840, '9600 VETERANS DRIVE SW',NULL,NULL, 'TACOMA',1009353,NULL, '98493-0001',1006840, '9600 VETERANS DRIVE SW',NULL,NULL, 'TACOMA',1009353,NULL, '98493-0001',1009158, '0',1001816,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001819,TO_DATE('4/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'PUGET SOUND HEALTH CARE SYSTEM - MADIGAN PTF', '663CN', 'MADIGAN',1009124,1006840, '1660 S COLUMBIAN WAY',NULL,NULL, 'SEATTLE',1009353,NULL, '98108',1006840, '1660 S COLUMBIAN WAY',NULL,NULL, 'SEATTLE',1009353,NULL, '98108',1009226, '0',1001816,1000660,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:34:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/18/05 changes');
Insert into sdsadm.STD_Institution values(1001821,NULL,NULL, 'PUGET SOUND HEALTH CARE SYSTEM - MADIGAN ARMY MEDICAL CENTER', '663DO', 'MADIGAN ARMY MEDICAL CENTER',1009124,1006840, 'DEPARTMENT OF THE ARMY',NULL,NULL, 'TACOMA',1009353,NULL, '98431',1006840, 'DEPARTMENT OF THE ARMY',NULL,NULL, 'TACOMA',1009353,NULL, '98431',1009226, '0',1000243,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:34:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/18/05 changes');
Insert into sdsadm.STD_Institution values(1001822,NULL,NULL, 'PUGET SOUND HEALTH CARE SYSTEM - ORTING STATE HOME', '663DT', 'ORTING',1009121,1006840, 'PO BOX 500',NULL,NULL, 'ORTING',1009353,NULL, '98360',1006840, 'PO BOX 500',NULL,NULL, 'ORTING',1009353,NULL, '98360',1009221, '0',1000243,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:34:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/18/05 changes');
Insert into sdsadm.STD_Institution values(1001823,NULL,NULL, 'PUGET SOUND HEALTH CARE SYSTEM - RETSIL STATE HOME', '663DU', 'RETSIL',1009121,1006840, 'PO BOX 671',NULL,NULL, 'RETSIL',1009353,NULL, '98378',1006840, 'PO BOX 671',NULL,NULL, 'RETSIL',1009353,NULL, '98378',1009221, '0',1000243,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:34:48 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/18/05 changes');
Insert into sdsadm.STD_Institution values(1001824,NULL,NULL, 'BELLEVUE VA CLINIC', '663GA', 'BELLEVUE VA CLINIC',1009121,1006840, '13033 BEL-RED RD #210',NULL,NULL, 'BELLEVUE',1009353,NULL, '98005-2633',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000243,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001825,NULL,NULL, 'BREMERTON VA CLINIC', '663GB', 'BREMERTON VA CLINIC',1009121,1006840, '925 ADELE STREET',NULL,NULL, 'B-- remERTON',1009353,NULL, '98312-3521',1006840, '925 ADELE STREET',NULL,NULL, 'B-- remERTON',1009353,NULL, '98312-3521',1009148, '0',1000243,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001826,NULL,NULL, 'SAN DIEGO NHC', '6649AA', 'SAN DIEGO NHC',1009121,1006840, '3350 LA JOLLA VILLAGE DR',NULL,NULL, 'SAN DIEGO',1009306,NULL, '92161',1006840, '3350 LA JOLLA VILLAGE DR',NULL,NULL, 'SAN DIEGO',1009306,NULL, '92161',1009185, '0',1000244,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:16:45 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 07/31/07 changes');
Insert into sdsadm.STD_Institution values(1001827,NULL,NULL, 'MISSION VALLEY SOC', '664BY', 'MISSION VALLEY',1009121,1006840, '8810 RIO SAN DIEGO DRIVE',NULL,NULL, 'SAN DIEGO',1009306,NULL, '92108-1698',1006840, '8810 RIO SAN DIEGO DRIVE',NULL,NULL, 'SAN DIEGO',1009306,NULL, '92108-1698',1009197, '0',1000244,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001828,NULL,NULL, 'NAVAL MEDICAL CENTER SAN DIEGO', '664CU', 'NAVAL MEDICAL CENTER SAN DIEGO',1009125,1006840, '34800 BOB WILSON DRIVE',NULL,NULL, 'SAN DIEGO',1009306,NULL, '92136',1006840, 'NAVAL MED CNTR 34800 BOB WILSON DRIVE',NULL,NULL, 'SAN DIEGO',1009306,NULL, '92134-5000',1009229, '0',1000244,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:51:25 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/05/2009 changes');
Insert into sdsadm.STD_Institution values(1001829,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZSAN DIEGO', '664DS', 'ZZSAN DIEGO',1009121,1006840, '3350 LA JOLLA VILLAGE DR.',NULL,NULL, 'SAN DIEGO',1009306,NULL, '92161',1006840, '3350 LA JOLLA VILLAGE DR',NULL,NULL, 'SAN DIEGO',1009306,NULL,NULL,1009153, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001830,NULL,NULL, 'STHOME DOMICILLIARY CHULA VSTA', '664DT', 'STHOME DOMICILLIARY CHULA VSTA',1009121,1006840, '700 E. NAPLES CT',NULL,NULL, 'CHULA VISTA',1009306,NULL, '91911',1006840, '700 E. NAPLES CT',NULL,NULL, 'CHULA VISTA',1009306,NULL, '91911',1009158, '0',1000244,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('2/11/2014 1:48:36 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0889 01/06/2014');
Insert into sdsadm.STD_Institution values(1001831,NULL,NULL, 'IMPERIAL VALLEY CBOC', '664GA', 'IMPERIAL VALLEY CBOC',1009121,1006840, '1600 SOUTH IMPERIAL AVENUE',NULL,NULL, 'EL CENTRO',1009306,NULL, '92243-4242',1006840, '1600 SOUTH IMPERIAL AVENUE',NULL,NULL, 'EL CENTRO',1009306,NULL, '92243-4242',1009148, '0',1000244,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001832,NULL,NULL, 'OCEANSIDE CBOC', '664GB', 'OCEANSIDE CBOC',1009121,1006840, '1300 RANCHO DEL ORO ROAD',NULL,NULL, 'OCEANSIDE',1009306,NULL, '92056-1729',1006840, '1300 RANCHO DEL ORO ROAD',NULL,NULL, 'OCEANSIDE',1009306,NULL, '92056-1729',1009148, '0',1000244,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001834,NULL,NULL, 'ESCONDIDO CBOC', '664GD', 'ESCONDIDO',1009121,1006840, '815 E. PENNSYLVANIA AVE',NULL,NULL, 'ESCONDIDO',1009306,NULL, '92025-3424',1006840, '815 E. PENNSYLVANIA AVE',NULL,NULL, 'ESCONDIDO',1009306,NULL, '92025-3424',1009148, '0',1000244,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001835,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SEPULVEDA (NHCU)', '6659AA', 'ZZ SEPULVEDA (NHCU)',1009121,1006840,NULL,NULL,NULL, 'SEPULVEDA',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001836,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SANTA BARBARA (CBOC)', '665B2', 'ZZ SANTA BARBARA (CBOC)',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup Realignment');
Insert into sdsadm.STD_Institution values(1001837,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BAKERSFIELD (SOC)', '665BY', 'ZZ BAKERSFIELD (SOC)',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1002043,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001838,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LOS ANGELES SOC', '665BZ', 'ZZ LOS ANGELES SOC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',NULL,NULL,1002044,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001839,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SEPULVEDA (PHARM)', '665CA', 'ZZ SEPULVEDA (PHARM)',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009201, '0',NULL,NULL,1002035,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001841,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LOS ANGELES PHARM', '665CC', 'ZZ LOS ANGELES PHARM',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009201, '0',NULL,1002085,1002039,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001842,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'EDWARDS AFB', '665CZ', 'ZZ EDWARDS AFB',1009122,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009224, '0',NULL,1002087,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001843,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LOS ANGELES CBOC', '665GA', 'ZZ LOS ANGELES CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,1002088,1002045,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001844,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LANCASTER CBOC', '665GB', 'ZZ LANCASTER CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1002046,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001845,NULL,NULL, 'SHERIDAN NHCU', '6669AA', 'SHERIDAN NHCU',1009121,1006840, '1898 FORT ROAD',NULL,NULL, 'SHERIDAN',1009356,NULL, '82801',1006840, '1898 FORT ROAD',NULL,NULL, 'SHERIDAN',1009356,NULL, '82801',1009185, '0',1000246,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001849,NULL,NULL, 'RIVERTON VA CLINIC', '666GC', 'RIVERTON VA CLINIC',1009121,1006840, '2300 ROSE LANE',NULL,NULL, 'RIVERTON',1009356,NULL, '82501-2257',1006840, '2300 ROSE LANE',NULL,NULL, 'RIVERTON',1009356,NULL, '82501-2257',1009148, '0',1000246,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001850,NULL,NULL, 'POWELL VA CLINIC', '666GD', 'POWELL VA CLINIC',1009121,1006840, '777 AVENUE H',NULL,NULL, 'POWELL',1009356,NULL, '82435-2260',1006840, '777 AVENUE H',NULL,NULL, 'POWELL',1009356,NULL, '82435-2260',1009148, '0',1000246,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001851,NULL,NULL, 'GILLETTE VA CLINIC', '666GE', 'GILLETTE VA CLINIC',1009121,1006840, '604 EXPRESS DRIVE',NULL,NULL, 'GILLETTE',1009356,NULL, '82718-4112',1006840, '604 EXPRESS DRIVE',NULL,NULL, 'GILLETTE',1009356,NULL, '82718-4112',1009148, '0',1000246,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001852,NULL,NULL, 'SHERIDAN PRRTP', '666PA', 'SHER-PRRTP',1009121,1006840, '1898 FORT ROAD',NULL,NULL, 'SHERIDAN',1009356,NULL, '82801-8320',1006840, '1898 FORT ROAD',NULL,NULL, 'SHERIDAN',1009356,NULL, '82801-8320',1009204, '0',1000246,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001853,NULL,NULL, 'SHREVEPORT ARMY HOSP', '667CN', 'SHREVEPORT ARMY HOSP',1009124,1006840,NULL,NULL,NULL, 'SHREVEPORT',1009322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',1000247,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:49:16 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 06/11/2009 changes');
Insert into sdsadm.STD_Institution values(1001854,NULL,NULL, 'NORTHEAST LOUISIANA WAR VETERANS HOME', '667DT', 'NORTH MONRO',1009121,1006840, '6700 HIGHWAY 165 NORTH',NULL,NULL, 'MONROE',1009322,NULL, '71203',1006840, '6700 HIGHWAY 165 NORTH',NULL,NULL, 'MONROE',1009322,NULL, '71203',1009221, '0',1000247,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001855,NULL,NULL, 'TEXARKANA CBOC', '667GA', 'TEXARKANA',1009121,1006840, '910 REALTOR ROAD',NULL,NULL, 'TEXARKANA',1009305,NULL, '71854-1020',1006840, '910 REALTOR ROAD',NULL,NULL, 'TEXARKANA',1009305,NULL, '71854-1020',1009148, '0',1000247,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001856,NULL,NULL, 'MONROE VA CLINIC', '667GB', 'MONROE VA CLINIC',1009121,1006840, '1691 BIENVILLE DRIVE',NULL,NULL, 'MONROE',1009322,NULL, '71201-3756',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000247,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:31:37 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0928 03/02/2015');
Insert into sdsadm.STD_Institution values(1001857,NULL,NULL, 'LONGVIEW CBOC', '667GC', 'LONGVIEW',1009121,1006840, '1005 N. EASTMAN RD',NULL,NULL, 'LONGVIEW',1009348,NULL, '75601-4231',1006840, '1005 N. EASTMAN RD',NULL,NULL, 'LONGVIEW',1009348,NULL, '75601-4231',1009148, '0',1000247,NULL,NULL,1002216,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001858,NULL,NULL, 'SPOKANE NHC', '6689AA', 'SPOKANE NHC',1009121,1006840,NULL,NULL,NULL, 'SPOKANE',1009353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000248,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:18:19 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/31/07 changes');
Insert into sdsadm.STD_Institution values(1001859,NULL,NULL, 'LEWISTON', '668DT', 'LEWISTON',1009121,1006840, '821 21ST AVENUE',NULL,NULL, 'LEWISTON',1009316,NULL, '83501',1006840, '821 21ST AVENUE',NULL,NULL, 'LEWISTON',1009316,NULL, '83501',1009221, '0',1000248,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001860,NULL,NULL, 'WASHINGTON STATE VETERANS HOME', '668DU', 'WASHINGTON STATE VET HOME',1009121,1006840, '222 E 5th AVE',NULL,NULL, 'SPOKANE',1009353,NULL, '99202',1006840, '222 E 5th AVE',NULL,NULL, 'SPOKANE',1009353,NULL, '99202',1009222, '0',1000248,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001861,NULL,NULL, 'SPOKANE MORC', '668HK', 'SPOKANE MORC',1009121,1006840, 'N. 4815 ASSEMBLY',NULL,NULL, 'SPOKANE',1009353,NULL, '99205-6185',1006840, '4815 N. ASSEMBLY',NULL,NULL, 'SPOKANE',1009353,NULL, '99205',1009177, '0',1000248,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001864,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ MASSENA', '670GA', 'ZZ MASSENA',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000846,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001865,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FT. DRUM', '670GB', 'ZZ FT. DRUM',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000849,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001866,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ROME', '670GC', 'ZZ ROME',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000847,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001867,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ UTICA', '670GD', 'ZZ UTICA',1009121,1006840, 'FOERY DRIVE',NULL,NULL, 'UTICA',1009336,NULL, '13501',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001868,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BINGHAMTON', '670GE', 'ZZ BINGHAMTON',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000848,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001869,NULL,TO_DATE('4/1/2000' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ OSWEGO', '670GF', 'ZZ OSWEGO',1009121,1006840,NULL,NULL,NULL,NULL,1009336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1000850,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001870,NULL,NULL, 'SAN ANTONIO NHC', '6719AA', 'SAN ANTONIO NHC',1009121,1006840,NULL,NULL,NULL, 'SAN ANTONIO',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:51:25 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/05/2009 changes');
Insert into sdsadm.STD_Institution values(1001871,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'KERRVILLE VA MEDICAL CENTER', '671A4', 'KERRVILLE VA MEDICAL CENTER',1009121,1006840, '3600 MEMORIAL BLVD',NULL,NULL, 'KERRVILLE',1009348,NULL, '78028-5768',1006840, '3600 MEMORIAL DRIVE',NULL,NULL, 'KERRVILLE',1009348,NULL, '78028-5768',1009231, '0',1000250,1000182,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001872,NULL,NULL, 'SOUTH TEXAS HEALTH CARE SYSTEM - MC ALLEN OUTPATIENT CLINIC', '671B0', 'MC ALLEN OUTPATIENT CLINIC',1009121,1006840, '2101 SOUTH COLONEL ROWE BLVD',NULL,NULL, 'MCALLEN',1009348,NULL, '78503-1272',1006840, '2101 SOUTH COLONEL ROWE BLVD',NULL,NULL, 'MCALLEN',1009348,NULL, '78503-1272',1009197, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001873,NULL,NULL, 'FRANK M. TEJEDA VA OPC', '671BY', 'FRANK M. TEJEDA VA OPC',1009121,1006840, '5788 ECKHERT RD',NULL,NULL, 'SAN ANTONIO',1009348,NULL, '78240-3900',1006840, '5788 ECKERT ROAD',NULL,NULL, 'SAN ANTONIO',1009348,NULL, '78240-3900',1009197, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001874,NULL,NULL, 'SOUTH TEXAS HEALTH CARE SYSTEM - CORPUS CHRISTI OUTPATIENT CLINIC', '671BZ', 'CORPUS CHRISTI',1009121,1006840, '5283 OLD BROWNSVILLE RD',NULL,NULL, 'CORPUS CHRISTI',1009348,NULL, '78405-3908',1006840, '5283 OLD BROWNSVILLE ROAD',NULL,NULL, 'CORPUS CHRISTI',1009348,NULL, '78405-3908',1009197, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001875,NULL,NULL, 'BROOKE ARMY MEDICAL CENTER', '671CN', 'BROOKE ARMY MEDICAL CENTER',1009124,1006840, 'BLDG 3600',NULL,NULL, 'FORT SAM HOUSTON',1009348,NULL, '78234-6200',1006840, 'BLDG 3600',NULL,NULL, 'FORT SAM HOUSTON',1009348,NULL, '78234-6200',1009226, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001876,NULL,NULL, 'CORPUS CHRISTI NAVAL HOSPITAL', '671CT', 'CORPUS CHRISTI NAVAL HOSPITAL',1009125,1006840, '10651 E STREET',NULL,NULL, 'CORPUS CHRISTI',1009348,NULL, '78418',1006840, '10651 E STREET',NULL,NULL, 'CORPUS CHRISTI',1009348,NULL, '78418',1009229, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001877,NULL,NULL, 'WILFORD HALL USAF MEDICAL CENTER', '671CZ', 'WILFORD HALL MEDICAL CENTER',1009122,1006840, '59 MDW',NULL,NULL, 'LACKLAND AFB',1009348,NULL, '78236-5300',1006840, '59 MDW',NULL,NULL, 'LACKLAND AFB',1009348,NULL, '78236-5300',1009224, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001878,NULL,NULL, 'FRANK M TEJEDA TEXAS STATE VETERANS HOME', '671DT', 'FRANK TEJEDA TX STATE VET HOME',1009121,1006840, '200 VETERANS DR',NULL,NULL, 'FLORESVILLE',1009348,NULL, '78114',1006840, '200 VETERANS DR',NULL,NULL, 'FLORESVILLE',1009348,NULL, '78114',1009222, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001879,NULL,NULL, 'VA HARLINGEN OUTPATIENT CLINIC', '671GA', 'HARLINGEN CBOC',1009121,1006840, '1629 TREASURE HILLS BLVD',NULL,NULL, 'Harlingen',1009348,NULL, '78550-8907',1006840, '1629 TREASURE HILLS BLVD',NULL,NULL, 'Harlingen',1009348,NULL, '78550-8907',1009148, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001880,NULL,NULL, 'VICTORIA VA CLINIC', '671GB', 'VICTORIA VA CLINIC',1009121,1006840, '1908 N. LAURENT ST #150',NULL,NULL, 'VICTORIA',1009348,NULL, '77901-5417',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001881,NULL,NULL, 'DEL RIO VA CLINIC', '671GC', 'DEL RIO VA CLINIC',1009121,1006840, '1011 E 7TH STREET',NULL,NULL, 'DEL RIO',1009348,NULL, '78840-4162',1006840, '1011 E 7TH STREET',NULL,NULL, 'DEL RIO',1009348,NULL, '78840-4162',1009148, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001883,NULL,NULL, 'SOUTH TEXAS HEALTH CARE SYSTEM - LAREDO OUTPATIENT CLINIC', '671GE', 'LAREDO',1009121,1006840, '6551 STAR COURT',NULL,NULL, 'LAREDO',1009348,NULL, '78041-9140',1006840, '6551 STAR COURT',NULL,NULL, 'LAREDO',1009348,NULL, '78041-9140',1009197, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001886,NULL,NULL, 'BEEVILLE VA CLINIC', '671GH', 'BEEVILLE VA CLINIC',1009121,1006840, '302 S HILLSIDE DR',NULL,NULL, 'BEEVILLE',1009348,NULL, '78102-5333',1006840, '302 S HILLSIDE DR',NULL,NULL, 'BEEVILLE',1009348,NULL, '78102-5333',1009148, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001887,NULL,NULL, 'CHRISTUS SPOHN BISHOP FAMILY HEALTH CLINIC', '671GI', 'KINGSVILLE',1009121,1006840, '415 S. 6TH STREET',NULL,NULL, 'KINGSVILLE',1009348,NULL, '78363-5518',1006840, '415 S. 6TH STREET',NULL,NULL, 'KINGSVILLE',1009348,NULL, '78363-5518',1009148, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001891,NULL,NULL, 'SAN MARCOS CBOC (HAYS COUNTY)', '671GM', 'SAN MARCOS',1009121,1006840, '2003 MEDICAL PARKWAY SUITE C',NULL,NULL, 'SAN MARCOS',1009348,NULL, '78666',1006840, '2003 MEDICAL PARKWAY SUITE C',NULL,NULL, 'SAN MARCOS',1009348,NULL,NULL,1009148, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001892,NULL,NULL, 'SEGUIN VA CLINIC', '671GN', 'SEGUIN VA CLINIC',1009121,1006840, '1215 E COURT ST',NULL,NULL, 'SEGUIN',1009348,NULL, '78155-5129',1006840, '1215 E COURT ST',NULL,NULL, 'SEGUIN',1009348,NULL, '78155-5129',1009148, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001893,NULL,NULL, 'SAN ANTONIO PRRTP', '671PA', 'SAN ANTONIO PRRTP',1009121,1006840, '7400 MERTON MINTER BLVD',NULL,NULL, 'SAN ANTONIO',1009348,NULL, '78229-4404',1006840, '7400 MERTON MINTER BLVD',NULL,NULL, 'SAN ANTONIO',1009348,NULL, '78229-4404',1009204, '0',1000250,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001894,NULL,NULL, 'SAN JUAN NHC', '6729AA', 'SAN JUAN NHC',1009121,1006840,NULL,NULL,NULL, 'SAN JUAN',1009372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000251,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001895,NULL,NULL, 'PONCE OUTPATIENT CLINIC', '672B0', 'PONCE',1009121,1006840, 'PASEO DEL VETERANO #1010',NULL,NULL, 'PONCE',1009372,NULL, '00716-2001',1006840, 'PASEO DEL VETERANO #1010',NULL,NULL, 'PONCE',1009372,NULL, '00716-2001',1009197, '0',1000251,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001896,NULL,NULL, 'MAYAGUEZ OUTPATIENT CLINIC', '672BZ', 'MAYAGUEZ',1009121,1006840, '345 HOSTOS AVENUE',NULL,NULL, 'MAYAGUEZ',1009372,NULL, '00680-1507',1006840, '345 HOSTOS AVENUE',NULL,NULL, 'MAYAGUEZ',1009372,NULL, '00680-1507',1009197, '0',1000251,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001897,NULL,NULL, 'US NAVAL HOSPITAL', '672CT', 'SAN JUAN',1009125,1006840, 'ROOOSEVELT ROADS STATION',NULL,NULL, 'CEIBA',1009372,NULL, '635',1006840, 'ROOOSEVELT ROADS STATION',NULL,NULL, 'CEIBA',1009372,NULL, '635',1009229, '0',1000251,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001900,NULL,NULL, 'ARECIBO VETERANS CLINIC (CBOC)', '672GC', 'ARECIBO',1009121,1006840, 'ZONA INDUSTRIAL ROAD 129',NULL,NULL, 'ARECIBO',1009372,NULL, '00616-3085',1006840, 'ZONA INDUSTRIAL ROAD 129',NULL,NULL, 'ARECIBO',1009372,NULL, '00616-3085',1009148, '0',1000251,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001902,NULL,NULL, 'JAMES A. HALEY NHCU', '6739AA', 'TAMPA NHCU',1009121,1006840, '13000 BRUCE B. DOWNS BLVD.',NULL,NULL, 'TAMPA',1009312,NULL, '33612',1006840, '13000 BRUCE B. DOWNS BLVD.',NULL,NULL, 'TAMPA',1009312,NULL, '33612',1009185, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001903,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'ORLANDO VA HEALTHCARE CENTER NHCU', '6739AB', 'ZZ-ORLANDO NHCU',1009121,1006840, '5201 Raymond St. Blgd 503',NULL,NULL, 'Orlando',1009312,NULL, '32803',1006840, '5201 RAYMOND STREET BLD. 503',NULL,NULL, 'ORLANDO',1009312,NULL,NULL,1009185, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001905,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'ORLANDO VA HEALTHCARE CENTER OPC', '673BY', 'ZZ-ORLANDO OPC',1009121,1006840, '5201 RAYMOND STREET',NULL,NULL, 'ORLANDO',1009312,NULL, '32803',1006840, '5201 RAYMOND STREET',NULL,NULL, 'ORLANDO',1009312,NULL,NULL,1009197, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001906,NULL,NULL, 'PORT RICHEY OUTPATIENT CLINIC', '673BZ', 'PASCO OPC',1009121,1006840, '9912 LITTLE ROAD',NULL,NULL, 'NEW PORT RICHEY',1009312,NULL, '34654-3419',1006840, '9912 LITTLE ROAD',NULL,NULL, 'NEW PORT RICHEY',1009312,NULL, '34654-3419',1009197, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:23:16 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 06/30/2008 changes');
Insert into sdsadm.STD_Institution values(1001907,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'VIERA OUTPATIENT CLINIC', '673GA', 'ZZ-VIERA OPC',1009121,1006840, '2900 VETERANS WAY',NULL,NULL, 'VIERA',1009312,NULL, '32940',1006840, '2900 VETERANS WAY',NULL,NULL, 'VIERA',1009312,NULL,NULL,1009197, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001908,NULL,NULL, 'LAKELAND VA CLINIC', '673GB', 'LAKELAND VA CLINIC',1009121,1006840, '4237 SOUTH PIPKIN',NULL,NULL, 'LAKELAND',1009312,NULL, '33811-1442',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001909,NULL,NULL, 'BROOKSVILLE CBOC', '673GC', 'BROOKSVILLE CBOC',1009121,1006840, '14540 CORTEZ BLVD STE 108',NULL,NULL, 'BROOKSVILLE',1009312,NULL, '34613-6056',1006840, '14540 CORTEZ BLVD STE 108',NULL,NULL, 'BROOKSVILLE',1009312,NULL, '34613-6056',1009148, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001910,NULL,NULL, 'SANFORD CBOC', '673GD', 'SANFORD CBOC',1009121,1006840, '1403 Medical Plaza Dr. Suite 109',NULL,NULL, 'SANFORD',1009312,NULL, '32771',1006840, '1403 Medical Plaza Dr. Suite 109',NULL,NULL, 'SANFORD',1009312,NULL,NULL,1009148, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001911,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'KISSIMMEE CBOC', '673GE', 'ZZ-KISSIMMEE CBOC',1009121,1006840, '2285 NORTH CENTRAL AVE',NULL,NULL, 'KISSIMMEE',1009312,NULL, '34741',1006840, '2285 NORTH CENTRAL AVE',NULL,NULL, 'KISSIMMEE',1009312,NULL,NULL,1009148, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001912,NULL,NULL, 'ZEPHYRHILLS VA CLINIC', '673GF', 'ZEPHYRHILLS VA CLINIC',1009121,1006840, '6937 MEDICAL VIEW LANE',NULL,NULL, 'ZEPHYRHILLS',1009312,NULL, '33542-6648',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000252,NULL,NULL,1002208,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1001913,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'THIS ENTRY ENTERED IN ERROR', '673PA', 'ZZGAINESVILLE PRRTP',1009121,1006840, '1601 SW ARCHER ROAD',NULL,NULL, 'GAINESVILLE',1009312,NULL, '32608-1197',1006840, '1601 SW ARCHER ROAD',NULL,NULL, 'GAINESVILLE',1009312,NULL,NULL,1009197, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001914,NULL,NULL, 'TEMPLE NHC', '6749AA', 'TEMPLE NHC',1009121,1006840, '1901 SOUTH FIRST STREET',NULL,NULL, 'TEMPLE',1009348,NULL, '76504',1006840, '1901 SOUTH FIRST STREET',NULL,NULL, 'TEMPLE',1009348,NULL, '76504',1009185, '0',1000253,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:16:45 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 07/31/07 changes');
Insert into sdsadm.STD_Institution values(1001916,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('1/6/2009' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZMARLIN VAMC', '674A5', 'ZZMARLIN',1009121,1006840, '1016 WARD ST',NULL,NULL, 'MARLIN',1009348,NULL, '76661',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',1000253,1000201,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001918,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'WACO VA FACILITY DOM', '674BV', 'WACO VA FACILITY DOM',1009121,1006840, '1901 SOUTH 1ST',NULL,NULL, 'TEMPLE',1009348,NULL, '76504-7451',1006840, '1901 SOUTH 1ST',NULL,NULL, 'TEMPLE',1009348,NULL, '76504-7451',1009158, '0',1000253,1001986,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001919,NULL,NULL, 'AUSTIN VA CLINIC', '674BY', 'AUSTIN VA CLINIC',1009121,1006840, '2901 MONTOPOLIS DR',NULL,NULL, 'AUSTIN',1009348,NULL, '78741-6411',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000253,NULL,NULL,1002217,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001928,NULL,NULL, 'TOMAH NHC', '6769AA', 'TOMAH NHC',1009121,1006840,NULL,NULL,NULL, 'TOMAH',1009355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000254,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0755 11/02/2011');
Insert into sdsadm.STD_Institution values(1001929,NULL,NULL, 'WAUSAU CBOC', '676GA', 'WAUSAU',1009121,1006840, '515 SOUTH 32 AVE',NULL,NULL, 'WAUSAU',1009355,NULL, '54401-4074',1006840, '515 SOUTH 32 AVE',NULL,NULL, 'WAUSAU',1009355,NULL, '54401-4074',1009148, '0',1000254,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001931,NULL,NULL, 'LACROSSE CBOC', '676GC', 'LACROSS',1009121,1006840, '2600 STATE ROAD',NULL,NULL, 'LACROSSE',1009355,NULL, '54601-6157',1006840, '2600 STATE ROAD',NULL,NULL, 'LACROSSE',1009355,NULL, '54601-6157',1009148, '0',1000254,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001932,NULL,NULL, 'WISCONSIN RAPIDS CBOC', '676GD', 'WISCONSIN RAPIDS',1009121,1006840, '555 WEST GRAND AVE.',NULL,NULL, 'WISCONSIN RAPIDS',1009355,NULL, '54495-2784',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000254,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:14:40 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0830 12/12/2012');
Insert into sdsadm.STD_Institution values(1001933,TO_DATE('10/15/2001' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'CLARK COUNTY CBOC', '676GE', 'CLARK COUNTY CBOC',1009121,1006840, '8 JOHNSON STREET',NULL,NULL, 'OWEN',1009355,NULL, '54460-9534',1006840, '8 JOHNSON STREET',NULL,NULL, 'OWEN',1009355,NULL, '54460-9534',1009148, '0',1000254,1001936,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001934,NULL,NULL, 'CHIPPEWA FALLS ORC', '676HA', 'CHIPPEWA FALLS ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000254,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001935,NULL,NULL, 'WAUTOMA ORC', '676HB', 'WAUTOMA ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000254,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001936,NULL,TO_DATE('10/15/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'LOYAL ORC', '676HC', 'ZZ LOYAL ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001933,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:20 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 09/30/2009 changes');
Insert into sdsadm.STD_Institution values(1001937,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TOPEKA NURSING HOME', '6779AA', 'ZZ TOPEKA NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'TOPEKA',1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,1001258,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001938,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LEAVENWORTH NHCU', '6779AB', 'ZZ LEAVENWORTH NHCU',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,1001259,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001940,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LEAVENWORTH DOM', '677BU', 'ZZ LEAVENWORTH DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,1001990,1001266,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001941,TO_DATE('1/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TOPEKA-PHARM', '677CA', 'ZZ TOPEKA-PHARM',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009201, '0',NULL,1001991,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001944,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TOPEKA (PUBLIC HOSPITAL)', '677DM', 'ZZ TOPEKA (PUBLIC HOSPITAL)',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',NULL,NULL,1001267,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001945,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TOPEKA (CIVILIAN HOSPITAL)', '677DS', 'ZZ TOPEKA (CIVILIAN HOSPITAL)',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009153, '0',NULL,NULL,1001270,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001946,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ST JOSEPH CBOC', '677GA', 'ZZ ST JOSEPH CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,1001994,1001294,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001947,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WYANDOTTE CBOC', '677GB', 'ZZ WYANDOTTE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001295,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001949,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHANUTE CBOC', '677GD', 'ZZ CHANUTE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001297,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001950,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ EMPORIA CBOC', '677GE', 'ZZ EMPORIA CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001298,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001951,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FT RILEY CBOC', '677GF', 'ZZ FT RILEY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001299,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001952,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GARNETT CBOC', '677GG', 'ZZ GARNETT CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001300,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001953,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ HOLTON', '677GH', 'ZZ HOLTON',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001301,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001954,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ JUNCTION CITY CBOC', '677GI', 'ZZ JUNCTION CITY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001302,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001955,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ RUSSELL CBOC', '677GJ', 'ZZ RUSSELL CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001303,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001956,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SENECA CBOC', '677GK', 'ZZ SENECA CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001304,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001957,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LAWRENCE CBOC', '677GL', 'ZZ LAWRENCE CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001305,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001958,NULL,NULL, 'GARNETT ORC', '677HA', 'GARNETT ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000255,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001959,NULL,NULL, 'HOLTON (ORC)', '677HB', 'HOLTON (ORC)',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000255,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001960,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ EMPORIA ORC', '677HC', 'ZZ EMPORIA ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001961,NULL,NULL, 'LAWRENCE ORC', '677HD', 'LAWRENCE ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000255,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001963,NULL,NULL, 'SENACA ORC', '677HF', 'SENACA ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000255,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001964,NULL,NULL, 'JUNCTION CITY ORC', '677HG', 'JUNCTION CITY ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000255,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001966,NULL,NULL, 'SENECA ORC', '677HP', 'SENECA ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',1000255,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001967,NULL,NULL, 'JUNCTION CITY CBOC', '677HQ', 'JUNCTION CITY CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000255,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:53:59 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/28/2009 changes');
Insert into sdsadm.STD_Institution values(1001968,NULL,TO_DATE('5/21/2001' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LEAVENWORTH-PRRTP', '677PA', 'ZZ LEAVENWORTH-PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',NULL,NULL,1001310,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001969,NULL,NULL, 'TUCSON NHC', '6789AA', 'TUCSON NHC',1009121,1006840,NULL,NULL,NULL, 'TUCSON',1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000256,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1001971,NULL,NULL, 'YUMA CBOC', '678GB', 'YUMA CBOC',1009121,1006840, '2555 E GILA RIDGE ROAD',NULL,NULL, 'YUMA',1009304,NULL, '85365-2240',1006840, '2555 E GILA RIDGE ROAD',NULL,NULL, 'YUMA',1009304,NULL, '85365-2240',1009148, '0',1000256,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1001973,NULL,NULL, 'SAFFORD CBOC', '678GD', 'SAFFORD CBOC',1009121,1006840, '355 NORTH 8TH AVE',NULL,NULL, 'SAFFORD',1009304,NULL, '85546-2694',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000256,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/22/2014 6:54:23 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0923 12/1/2014');
Insert into sdsadm.STD_Institution values(1001975,NULL,NULL, 'TUC-PRRTP', '678PA', 'TUC-PRRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009204, '0',1000256,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1001977,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZANNISTON (ORC)', '679HA', 'ZZ ANNISTON (ORC)',1009121,1006840, '96 ALI WAY',NULL,NULL, 'OXFORD',1009301,NULL, '36203',1006840, '96 ALI WAY',NULL,NULL, 'OXFORD',1009301,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001978,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ GADSDEN HEALTH CARE CENTER', '679HB', 'ZZ GADSDEN (ORC)',1009121,1006840, '206 RESCIA AVENUE',NULL,NULL, 'GADSDEN',1009301,NULL, '35906',1006840, '206 RESCIA AVENUE',NULL,NULL, 'GADSDEN',1009301,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001979,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ FLORENCE (ORC)', '679HC', 'ZZ FLORENCE (ORC)',1009121,1006840, '422 DD COX BLVD',NULL,NULL, 'SHEFFIELD',1009301,NULL, '35660',1006840, '422 DD COX BLVD',NULL,NULL, 'SHEFFIELD',1009301,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001984,NULL,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ COLUMBUS CBOC', '680GA', 'ZZ COLUMBUS CBOC',1009121,1006840,NULL,NULL,NULL,NULL,1009313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,1001468,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001985,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WACO', '6859AA', 'ZZ WACO',1009121,1006840,NULL,NULL,NULL, 'WACO',1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001986,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WACO DOM', '685BU', 'ZZ WACO DOM',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009158, '0',NULL,NULL,1001918,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001987,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WACO USAH', '685CN', 'ZZ WACO USAH',1009124,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,1001920,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001988,NULL,TO_DATE('10/1/95' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ HAMILTON', '685HA', 'ZZ HAMILTON',1009121,1006840, '303 NORTH BROWN',NULL,NULL, 'HAMILTON',1009348,NULL, '76531',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,1001926,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001991,NULL,TO_DATE('1/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LEAVENWORTH (PHARM)', '686CA', 'ZZ LEAVENWORTH (PHARM)',1009121,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009201, '0',NULL,NULL,1001941,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001993,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ LEAVENWORTH ARMY HOSP', '686CN', 'ZZ LEAVENWORTH ARMY HOSP',1009124,1006840,NULL,NULL,NULL,NULL,1009320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009226, '0',NULL,NULL,1001943,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001995,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ ST JOSEPH ORC', '686HA', 'ZZ ST JOSEPH ORC',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009198, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1001996,NULL,NULL, 'WALLA WALLA NHC', '6879AA', 'WALLA WALLA NHC',1009121,1006840, '77 WAINWRIGHT DRIVE',NULL,NULL, 'WALLA WALLA',1009353,NULL, '99362',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000262,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1001999,NULL,NULL, 'YAKIMA CBOC', '687HA', 'YAKIMA CBOC',1009121,1006840, '717 FRUITVALE BLVD',NULL,NULL, 'YAKIMA',1009353,NULL, '98902-1465',1006840, '717 FRUITVALE BLVD',NULL,NULL, 'YAKIMA',1009353,NULL, '98902-1465',1009148, '0',1000262,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:07:27 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 08/03/2011 changes');
Insert into sdsadm.STD_Institution values(1002000,NULL,NULL, 'NURSING HOME', '687PA', 'WAL-PRRTP',1009121,1006840, '77 WAINWRIGHT DRIVE',NULL,NULL, 'WALLA WALLA',1009353,NULL, '99362-3975',1006840, '77 WAINWRIGHT DRIVE',NULL,NULL, 'WALLA WALLA',1009353,NULL, '99362-3975',1009204, '0',1000262,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002001,NULL,NULL, 'WASHINGTON NHC', '6889AA', 'WASHINGTON NHC',1009121,1006840,NULL,NULL,NULL, 'WASHINGTON',1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1002002,NULL,NULL, 'WASHINGTON STNB', '6889AF', 'WASHINGTON STNB',1009121,1006840,NULL,NULL,NULL, 'CHARLOTTE HALL',1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002003,NULL,NULL, 'WALTER REED ARMY HOSPITAL', '688CN', 'WALTER REED',1009124,1006840, '6900 GEORGIA AVE NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20012',1006840, '6900 GEORGIA AVE NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20012',1009226, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002004,NULL,NULL, 'BETHESDA NAVEL', '688CT', 'BETHESDA NAVEL',1009125,1006840, '8901 WISCONSIN AVENUE',NULL,NULL, 'BETHESDA',1009324,NULL, '20899-5000',1006840, '8901 WISCONSIN AVENUE',NULL,NULL, 'BETHESDA',1009324,NULL, '20899-5000',1009229, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002005,NULL,NULL, 'ST ELIZABETHS', '688DB', 'ST. ELIZABETHS',1009121,1006840, '2700 M L King Ave SE',NULL,NULL, 'WASHINGTON',1009311,NULL, '20020',1006840, '2700 M L King Ave SE',NULL,NULL, 'WASHINGTON',1009311,NULL, '20020',1009199, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002006,NULL,NULL, 'STATE HOME', '688DU', 'D.C. STATE HOME',1009121,1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422',1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422',1009221, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002007,NULL,NULL, 'CHARLOTTE HALL STATE VET HOME', '688DV', 'CHARLOTTE HALL STATE VET HOME',1009121,1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422',1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422',1009222, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002009,NULL,NULL, 'SOUTHEAST WASHINGTON VA CLINIC', '688GB', 'SOUTHEAST WASHINGTON VA CLINIC',1009121,1006840, '820 CHESAPEAKE ST. SE',NULL,NULL, 'WASHINGTON',1009311,NULL, '20032-3428',1006840, '820 CHESAPEAKE ST. SE',NULL,NULL, 'WASHINGTON',1009311,NULL, '20032-3428',1009148, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1002011,NULL,NULL, 'CHARLOTTE HALL VA CLINIC', '688GD', 'CHARLOTTE HALL VA CLINIC',1009121,1006840, '29431 CHARLOTTE HALL RD',NULL,NULL, 'CHARLOTTE HALL',1009324,NULL, '20622-3042',1006840, '29431 CHARLOTTE HALL RD',NULL,NULL, 'CHARLOTTE HALL',1009324,NULL, '20622-3042',1009148, '0',1000263,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1002012,NULL,TO_DATE('1/17/2006' , 'mm/dd/yyyy hh:mi:ss AM'), 'SUBSTANCE ABUSE COMM CLINIC', '688HA', 'ZZ D.C. SUBSTANCE ABUSE CLINIC',1009121,1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422',1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL,NULL,1009198, '0',NULL,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002013,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'WASHINGTON MOC', '688HK', 'ZZ WASHINGTON MOC',1009121,1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL, '20422',1006840, '50 IRVING STREET NW',NULL,NULL, 'WASHINGTON',1009311,NULL,NULL,1009177, '0',NULL,NULL,NULL,1002205,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002014,NULL,NULL, 'WEST HAVEN NHC', '6899AA', 'WEST HAVEN NHC',1009121,1006840,NULL,NULL,NULL, 'WEST HAVEN',1009309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000264,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 4:31:43 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 01/06/2009 changes');
Insert into sdsadm.STD_Institution values(1002015,TO_DATE('7/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'NEWINGTON', '689A4', 'NEWINGTON',1009121,1006840, '555 WILLARD AVENUE',NULL,NULL, 'NEWINGTON',1009309,NULL, '06111-2631',1006840, '555 WILLARD AVENUE',NULL,NULL, 'NEWINGTON',1009309,NULL, '06111-2631',1009231, '0',1000264,1000214,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002016,TO_DATE('7/1/95' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'ROCKY HILL', '689DT', 'ROCKY HILL',1009121,1006840, 'ROCKY HILL STATE VETERANS HOME',NULL,NULL, 'ROCKY HILL',1009309,NULL, '6067',1006840, 'ROCKY HILL STATE VETERANS HOME',NULL,NULL, 'ROCKY HILL',1009309,NULL, '6067',1009221, '0',1000264,1001520,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002018,NULL,NULL, 'WATERBURY', '689GA', 'WATERBURY',1009121,1006840, '95 SCOVILL STREET',NULL,NULL, 'WATERBURY',1009309,NULL, '06706-1113',1006840, '95 SCOVILL STREET',NULL,NULL, 'WATERBURY',1009309,NULL, '06706-1113',1009148, '0',1000264,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002020,NULL,NULL, 'WINDHAM CBOC', '689GC', 'WINDHAM CBOC',1009121,1006840, '1320 MAIN STREET',NULL,NULL, 'WILLIMANTIC',1009309,NULL, '06226-1940',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000264,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:13:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0800 10/17/2012');
Insert into sdsadm.STD_Institution values(1002021,NULL,NULL, 'WINSTED', '689GD', 'WINSTED',1009121,1006840, '115 SPENCER STREET',NULL,NULL, 'WINSTED',1009309,NULL, '06098-1140',1006840, '115 SPENCER STREET',NULL,NULL, 'WINSTED',1009309,NULL, '06098-1140',1009148, '0',1000264,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002023,NULL,TO_DATE('3/11/2013' , 'mm/dd/yyyy hh:mi:ss AM'), 'WILLIMANTIC', '689HA', 'ZZ-WILLIMANTIC CBOC',1009121,1006840, 'WINDHAM TOWN HALL',NULL,NULL, 'WINDHAM',1009309,NULL, '6226',1006840, 'WINDHAM TOWN HALL',NULL,NULL, 'WINDHAM',1009309,NULL,NULL,1009198, '0',1000264,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002024,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'NORWICH', '689HB', 'ZZ NORWICH',1009121,1006840, 'NORWICH VETERAN OUTREACH CENTER',NULL,NULL, 'NORWICH',1009309,NULL, '6360',1006840, 'NORWICH VETERAN OUTREACH CENTER',NULL,NULL, 'NORWICH',1009309,NULL,NULL,1009198, '0',NULL,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002026,NULL,NULL, 'WEST HAVEN MORC', '689HK', 'WEST HAVEN MORC',1009121,1006840, '950 CAMPBELL AVENUE',NULL,NULL, 'WEST HAVEN',1009309,NULL, '06516-2770',1006840, '950 CAMPBELL AVENUE',NULL,NULL, 'WEST HAVEN',1009309,NULL, '06516-2770',1009177, '0',1000264,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002027,NULL,NULL, 'WH-PRRTP', '689PA', 'WH-PRRTP',1009121,1006840, '950 CAMPBELL AVE',NULL,NULL, 'WEST HAVEN',1009309,NULL, '06516-2770',1006840, '950 CAMPBELL AVENUE',NULL,NULL, 'WEST HAVEN',1009309,NULL, '06516-2770',1009204, '0',1000264,NULL,NULL,1002201,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002028,NULL,NULL, 'LOS ANGELES', '6919AA', 'LOS ANGELES',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1009185, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002029,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BRENTWOOD', '691A0', 'ZZ BRENTWOOD',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL,NULL,1009233, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002030,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SEPULVEDA OUTPATIENT    NURSING HOME CARE', '691A4', 'SEPULVEDA VAMC',1009121,1006840, '16111 PLUMMER ST',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343-2036',1006840, '16111 PLUMMER ST',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343-2036',1009231, '0',1000266,1000245,NULL,1002222,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002031,NULL,NULL, 'NHCU-WLA', '691AA', 'NHCU-WLA',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073-1003',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073-1003',1009185, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002032,NULL,NULL, 'NHCU-SEP', '691AB', 'NHCU-SEP',1009121,1006840, '16111 PLUMMER STREET',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343-2036',1006840, '16111 PLUMMER STREET',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343-2036',1009185, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002033,NULL,NULL, 'WEST LOS ANGELES VA DOMICILIARY', '691BU', 'WLA DOMICILIARY',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073-1003',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073-1003',1009158, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002034,NULL,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SANTA BARBARA (SOC)', '691BY', 'ZZ SANTA BARBARA (SOC)',1009121,1006840, '4440 CALLE REAL',NULL,NULL, 'SANTA BARBARA',1009306,NULL, '93110',1006840, '4440 CALLE REAL',NULL,NULL, 'SANTA BARBARA',1009306,NULL,NULL,1009197, '0',NULL,NULL,1002041,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002035,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SEPULVEDA DRUG TREATMENT PHARMACY', '691CA', 'METHADONE/LAAM/SEP',1009121,1006840, '16111 PLUMMER STREET',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343',1006840, '16111 PLUMMER STREET',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343',1009201, '0',1000266,1001839,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002036,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'WEST LOS ANGELES PHARMACY MAILOUT-1', '691CB', 'ZZ WEST LOS ANGELES',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL,NULL,1009201, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002038,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SEPULVEDA RADIOPHARMACY', '691CD', 'RADIOPHARMACY/SEP',1009121,1006840, '16111 PLUMMER STREET',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343',1006840, '16111 PLUMMER STREET',NULL,NULL, 'SEPULVEDA',1009306,NULL, '91343',1009201, '0',1000266,1001840,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002039,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LOS ANGELES OUTPATIENT PHARMACY', '691CE', 'LOS ANGELES BASED PHARM',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1009201, '0',1000266,1001841,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002040,NULL,TO_DATE('3/2/2010' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-LOS ANGELES CBOC', '691GA', 'ZZ-LOS ANGELES CBOC',1009121,1006840, '351 EAST TEMPLE',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90012',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',NULL,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002041,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'SANTA BARBARA CBOC', '691GB', 'SANTA BARBARA CBOC',1009121,1006840, '4440 CALLE REAL',NULL,NULL, 'SANTA BARBARA',1009306,NULL, '93110-1002',1006840, '4440 CALLE REAL',NULL,NULL, 'SANTA BARBARA',1009306,NULL, '93110-1002',1009148, '0',1000266,1002034,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002042,NULL,NULL, 'GARDENA CBOC', '691GC', 'GARDENA',1009121,1006840, '1251 REDONDO BEACH BLVD',NULL,NULL, 'GARDENA',1009306,NULL, '90247-3456',1006840, '1251 REDONDO BEACH BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90247-3456',1009148, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002043,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'BAKERSFIELD CBOC', '691GD', 'BAKERSFIELD',1009121,1006840, '1801 WESTWIND DRIVE',NULL,NULL, 'BAKERSFIELD',1009306,NULL, '93301-3028',1006840, '1801 WESTWIND DRIVE',NULL,NULL, 'BAKERSFIELD',1009306,NULL, '93301-3028',1009148, '0',1000266,1001837,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002044,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'LOS ANGELES CBOC', '691GE', 'LAOPC',1009121,1006840, '351 E. TEMPLE ST.',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90012-3328',1006840, '351 E. TEMPLE ST.',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90012-3328',1009148, '0',1000266,1001838,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002045,TO_DATE('10/1/98' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'EAST LOS ANGELES CBOC', '691GF', 'EAST LOS ANGELES',1009121,1006840, '5426 E OLYMPIC BLVD',NULL,NULL, 'COMMERCE',1009306,NULL, '90022-5113',1006840, '5426 E OLYMPIC BLVD',NULL,NULL, 'COMMERCE',1009306,NULL, '90022-5113',1009148, '0',1000266,1001843,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002047,NULL,NULL, 'WEST LOS ANGELES CBOC', '691GH', 'WEST LOS ANGELES',1009121,1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL, '90073',1006840, '11301 WILSHIRE BLVD',NULL,NULL, 'LOS ANGELES',1009306,NULL,NULL,1009148, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002048,NULL,TO_DATE('4/2/2007' , 'mm/dd/yyyy hh:mi:ss AM'), 'CULVER CITY CBOC', '691GI', 'ZZ CULVER CITY',1009121,1006840, '3831 HUGHES AVE SUITE 104',NULL,NULL, 'CULVER CITY',1009306,NULL, '90230',1006840, '3831 HUGHES AVE SUITE 104',NULL,NULL, 'CULVER CITY',1009306,NULL,NULL,1009148, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002049,NULL,NULL, 'WEST HOLLYWOOD CBOC', '691GJ', 'WEST HOLLYWOOD CBOC',1009121,1006840, '1063 N VINE STREET',NULL,NULL, 'HOLLYWOOD',1009306,NULL, '90038-2744',1006840, '1063 N VINE STREET',NULL,NULL, 'HOLLYWOOD',1009306,NULL,NULL,1009148, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002050,NULL,NULL, 'SAN LUIS OBISPO CBOC', '691GK', 'SAN LUIS OBISPO',1009121,1006840, '1288 MORRO ST SUITE 200',NULL,NULL, 'SAN LUIS OBISPO',1009306,NULL, '93401-6301',1006840, '1288 MORRO ST SUITE 200',NULL,NULL, 'SAN LUIS OBISPO',1009306,NULL, '93401-6301',1009148, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002051,NULL,NULL, 'SANTA MARIA CBOC', '691GL', 'SANTA MARIA CBOC',1009121,1006840, '1500 EAST MAIN ST',NULL,NULL, 'SANTA MARIA',1009306,NULL, '93454-4819',1006840, '1500 EAST MAIN ST',NULL,NULL, 'SANTA MARIA',1009306,NULL, '93454-4819',1009148, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:10:47 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0768 01/17/2012');
Insert into sdsadm.STD_Institution values(1002053,NULL,NULL, 'LYNWOOD CBOC', '691GN', 'LYNWOOD CBOC',1009121,1006840, '3737 E MARTIN LUTHER KING DR SUITE 515',NULL,NULL, 'LYNWOOD',1009306,NULL, '90262-3513',1006840, '3737 E MARTIN LUTHER KING DR SUITE 515',NULL,NULL, 'LYNWOOD',1009306,NULL, '90262-3513',1009148, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002054,NULL,NULL, 'PASADENA CBOC', '691GO', 'PASADENA CBOC',1009121,1006840, '420 S. LAS TUNAS DR',NULL,NULL, 'SAN GABRIEL',1009306,NULL, '91776-1268',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000266,NULL,NULL,1002222,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002055,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA DOMICILIARY', '692BU', 'ZZ WHITE CITY',1009121,1006840, 'VA DOMICILIARY',NULL,NULL, 'WHITE CITY',1009341,NULL, '97503',1006840, 'VA DOMICILIARY',NULL,NULL, 'WHITE CITY',1009341,NULL,NULL,1009158, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002057,NULL,NULL, 'KLAMATH FALLS VA CLINIC', '692GA', 'KLAMATH FALLS VA CLINIC',1009121,1006840, '2225 NORTH ELDORADO BLVD',NULL,NULL, 'KLAMATH FALLS',1009341,NULL, '97601-6417',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000267,NULL,NULL,1002220,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:38:28 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0936 11/03/2015');
Insert into sdsadm.STD_Institution values(1002058,NULL,NULL, 'WILKES-BARRE (NHC)', '6939AA', 'WILKES-BARRE (NHC)',1009121,1006840,NULL,NULL,NULL, 'WILKES-BARRE',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009185, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002059,NULL,NULL, 'ALLENTOWN OPC', '693B4', 'ALLENTOWN OPC',1009121,1006840, '3110 HAMILTON BOULEVARD',NULL,NULL, 'ALLENTOWN',1009342,NULL, '18103-3672',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009197, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002060,NULL,NULL, 'WILKES-BARRE (DENT)', '693BY', 'WILKES-BARRE (DENT)',1009121,1006840,NULL,NULL,NULL, 'ALLENTOWN',1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009160, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002061,NULL,NULL, 'SCRANTON STNB', '693DT', 'SCRANTON STNB',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002062,NULL,NULL, 'SAYRE OPC', '693GA', 'SAYRE OPC',1009121,1006840, '1537 ELMIRA STREET',NULL,NULL, 'SAYRE',1009342,NULL, '18840-9254',1006840, '1537 ELMIRA STREET',NULL,NULL, 'SAYRE',1009342,1010115, '18840-9254',1009197, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002063,NULL,NULL, 'WILLIAMSPORT VA CLINIC', '693GB', 'WILLIAMSPORT VA CLINIC',1009121,1006840, '1705 WARREN AVE 3RD FLOOR',NULL,NULL, 'WILLIAMSPORT',1009342,NULL, '17701-2647',1006840, '1705 WARREN AVE 3RD FLOOR',NULL,NULL, 'WILLIAMSPORT',1009342,1010127, '17701-2647',1009148, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002064,NULL,NULL, 'TOBYHANNA VA CLINIC', '693GC', 'TOBYHANNA VA CLINIC',1009121,1006840, 'TOBYHANNA ARMY DEPOT BLDG 220',NULL,NULL, 'TOBYHANNA',1009342,NULL, '18466-5002',1006840, 'TOBYHANNA ARMY DEPOT BLDG 220',NULL,NULL, 'TOBYHANNA',1009342,1010140, '18466-5002',1009148, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002065,NULL,NULL, 'WILKES-BARRE (CBOC)', '693GD', 'WILKES-BARRE (CBOC)',1009121,1006840, '1111 EAST END BLVD',NULL,NULL, 'WILKES-BARRE',1009342,NULL, '18711',1006840, '1111 EAST END BLVD',NULL,NULL, 'WILKES-BARRE',1009342,1010141, '18711',1009148, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:15:33 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 04/30/07 changes');
Insert into sdsadm.STD_Institution values(1002066,NULL,NULL, 'SCHUYLKILL COUNTY CBOC', '693GE', 'SCHUYLKILL COUNTY CBOC',1009121,1006840, '700 SCHUYLKILL MANOR RD',NULL,NULL, 'POTTSVILLE',1009342,NULL, '17901',1006840, '700 SCHUYLKILL MANOR RD',NULL,NULL, 'POTTSVILLE',1009342,1010133, '17901',1009148, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:18:19 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 10/31/07 changes');
Insert into sdsadm.STD_Institution values(1002067,NULL,NULL, 'COLUMBIA COUNTY VA CLINIC', '693GF', 'COLUMBIA COUNTY VA CLINIC',1009121,1006840, 'ALLEY MEDICAL CENTER 301 W THIRD ST',NULL,NULL, 'BERWICK',1009342,NULL, '18603-3603',1006840, 'ALLEY MEDICAL CENTER 301 W THIRD ST',NULL,NULL, 'BERWICK',1009342,NULL, '18603-3603',1009148, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:26 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002068,NULL,TO_DATE('11/19/2012' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ-WILKES-BARRE (MORC)', '693HK', 'ZZ-WILKES-BARRE (MORC)',1009121,1006840, '1111 EAST END BOULEVARD',NULL,NULL, 'WILKES-BARRE',1009342,NULL, '18711-0030',1006840, '1111 EAST END BOULEVARD',NULL,NULL, 'WILKES-BARRE',1009342,1010141,NULL,1009177, '0',1000268,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002069,NULL,NULL, 'WIL-SARRTP', '693PA', 'WIL-SARRTP',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009212, '0',1000268,NULL,NULL,1002204,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002072,NULL,NULL, 'FOX VALLEY', '695BY', 'FOX VALLEY',1009121,1006840, '10 TRI PARK WAY',NULL,NULL, 'APPLETON',1009355,NULL, '54914-1658',1006840, '10 TRI PARK WAY',NULL,NULL, 'APPLETON',1009355,NULL, '54914-1658',1009197, '0',1000270,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002075,NULL,NULL, 'WISCONSIN STATE VETERANS HOME', '695DT', 'WISCONSIN SVH 695DT (DOM)',1009121,1006840, '21425C SPRING STREET',NULL,NULL, 'UNION GROVE',1009355,NULL, '53182',1006840, '21425C SPRING STREET',NULL,NULL, 'UNION GROVE',1009355,NULL, '53182',1009222, '0',1000270,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 12:19:05 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - 12/31/07 changes');
Insert into sdsadm.STD_Institution values(1002076,NULL,NULL, 'UNION GROVE', '695GA', 'UNION GROVE',1009121,1006840, '21425 SPRING STREET',NULL,NULL, 'UNION GROVE',1009355,NULL, '53182-9707',1006840, '21425 SPRING STREET',NULL,NULL, 'UNION GROVE',1009355,NULL, '53182-9707',1009148, '0',1000270,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002078,NULL,NULL, 'MILO C. HUEMPFNER CBOC', '695GD', 'MILO C. HUEMPFNER CBOC',1009121,1006840, '2851 UNIVERSITY AVE',NULL,NULL, 'GREEN BAY',1009355,NULL, '54311-0008',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000270,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('2/11/2014 1:48:36 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0889 01/06/2014');
Insert into sdsadm.STD_Institution values(1002080,NULL,NULL, 'MILWAUKEE PSYCHOLOGICAL RESIDENTIAL REHABILITATION TREATMENT PROGRAM', '695PA', 'MIL-PRRTP',1009121,1006840, '5000 W NATIONAL',NULL,NULL, 'MILWAUKEE',1009355,NULL, '53295-0001',1006840, '5000 W NATIONAL',NULL,NULL, 'MILWAUKEE',1009355,NULL, '53295-0001',1009204, '0',1000270,NULL,NULL,1002212,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:43 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002081,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ BOSTON STATE NURSING HOME', '7509AF', 'ZZ BOSTON STATE NURSING HOME',1009121,1006840,NULL,NULL,NULL, 'BOSTON',1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1002083,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHELSEA', '750DT', 'ZZ CHELSEA',1009121,1006840,NULL,NULL,NULL, 'CHELSEA',1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1002084,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHELSEA STNB', '750EL', 'ZZ CHELSEA STNB',1009121,1006840,NULL,NULL,NULL, 'CHELSEA',1009325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009221, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1002085,NULL,TO_DATE('7/1/97' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ WEST LOS ANGELES PHARM', '752CA', 'ZZ WEST LOS ANGELES PHARM',1009121,1006840,NULL,NULL,NULL,NULL,1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009201, '0',NULL,NULL,1001841,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1002086,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ SAN DIEGO', '752CU', 'ZZ SAN DIEGO',1009125,1006840,NULL,NULL,NULL, 'SAN DIEGO',1009306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009229, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1002089,NULL,NULL, 'EL PASO USAH', '756CN', 'EL PASO USAH',1009124,1006840, '5001 NORTH PIEDRAS ST.',NULL,NULL, 'EL PASO',1009348,NULL, '79930',1006840, '5001 NORTH PIEDRAS ST.',NULL,NULL, 'EL PASO',1009348,NULL, '79930',1009226, '0',1000302,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002090,NULL,NULL, 'LAS CRUCES CBOC', '756GA', 'LAS CRUCES',1009121,1006840, '1635 DON ROSER',NULL,NULL, 'LAS CRUCES',1009335,NULL, '88011-4550',1006840, '1635 DON ROSER',NULL,NULL, 'LAS CRUCES',1009335,NULL, '88011-4550',1009148, '0',1000302,NULL,NULL,1002218,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002091,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'UNUSED FACILITY ENTRY', '757DM', 'ZZCOLUMBUS',1009121,1006840, '0',NULL,NULL, 'COLUMBUS',1009339,NULL, '0',1006840, '0',NULL,NULL, 'columbus',1009339,NULL,NULL,1009153, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('12/29/2015 8:39:27 PM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0938 12/09/2015');
Insert into sdsadm.STD_Institution values(1002093,NULL,NULL, 'ZANESVILLE CBOC', '757GA', 'ZANESVILLE',1009121,1006840, '2800 MAPLE AVE',NULL,NULL, 'ZANESVILLE',1009339,NULL, '43701-1716',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1000303,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002094,NULL,NULL, 'GROVE CITY CBOC', '757GB', 'GROVE CITY CBOC',1009121,1006840, '1955 OHIO DRIVE',NULL,NULL, 'GROVE CITY',1009339,NULL, '43123-4835',1006840, '1955 OHIO DRIVE',NULL,NULL, 'GROVE CITY',1009339,NULL, '43123-4835',1009148, '0',1000303,NULL,NULL,1002210,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/26/2013 10:08:24 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0757 11/02/2011');
Insert into sdsadm.STD_Institution values(1002095,NULL,NULL, 'UNION CEMETERY', '788IP', 'UNION CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002096,NULL,NULL, 'POINT LOOKOUT CEMETERY', '802IP', 'POINT LOOKOUT CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002098,NULL,NULL, 'MOUNT MORIAH CEMETERY', '804IA', 'MOUNT MORIAH CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002100,NULL,NULL, 'WOODLAWN CEMETERY', '809IF', 'WOODLAWN CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002101,NULL,NULL, 'CONFEDERATE MOUND', '809IK', 'CONFEDERATE MOUND',1009121,1006840,NULL,NULL,NULL,NULL,1009317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002102,NULL,NULL, 'CONFEDERATE STOCK', '810IK', 'CONFEDERATE STOCK',1009121,1006840,NULL,NULL,NULL,NULL,1009339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002104,NULL,NULL, 'ALLEGHENY CEMETERY', '813IU', 'ALLEGHENY CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002121,NULL,NULL, 'CONGRESS CEMETERY', '872IA', 'CONGRESS CEMETERY',1009121,1006840,NULL,NULL,NULL,NULL,1009311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009179, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:49 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002126,NULL,NULL, 'Amarillo HCS (504)',NULL, 'Amarillo HCS (504)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002127,NULL,NULL, 'Black Hills HCS (568)',NULL, 'Black Hills HCS (568)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002128,NULL,NULL, 'Boston HCS (523)',NULL, 'Boston HCS (523)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002129,NULL,NULL, 'Central Alabama HCS (619)',NULL, 'Central Alabama HCS (619)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002130,NULL,TO_DATE('6/4/2004' , 'mm/dd/yyyy hh:mi:ss AM'), 'Central Arkansas HCS',NULL, 'Central Arkansas HCS',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002131,NULL,NULL, 'Central California HCS (570)',NULL, 'Central California HCS (570)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002133,NULL,NULL, 'Central Texas HCS (674)',NULL, 'Central Texas HCS (674)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002134,NULL,NULL, 'Connecticut HCS (689)',NULL, 'Connecticut HCS (689)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002135,NULL,NULL, 'Eastern Colorado HCS (554)',NULL, 'Eastern Colorado HCS (554)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002136,NULL,NULL, 'Eastern Kansas HCS (677)',NULL, 'Eastern Kansas HCS (677)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002137,NULL,NULL, 'El Paso VA HCS (756)',NULL, 'El Paso VA HCS (756)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002138,NULL,NULL, 'Greater Nebraska HCS (597)',NULL, 'Greater Nebraska HCS (597)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002140,NULL,NULL, 'Long Beach HCS (600)',NULL, 'Long Beach HCS (600)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002141,NULL,NULL, 'Maryland HCS (512)',NULL, 'Maryland HCS (512)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002142,NULL,NULL, 'Montana HCS (436)',NULL, 'Montana HCS (436)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002143,NULL,NULL, 'N Florida/S Georgia HCS (573)',NULL, 'N Florida/S Georgia HCS (573)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002144,NULL,NULL, 'New Jersey HCS (561)',NULL, 'New Jersey HCS (561)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002145,NULL,TO_DATE('6/4/2004' , 'mm/dd/yyyy hh:mi:ss AM'), 'New Mexico HCS',NULL, 'New Mexico HCS',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002147,NULL,NULL, 'North Texas HCS (549)',NULL, 'North Texas HCS (549)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002148,NULL,NULL, 'Northern Arizona HCS (649)',NULL, 'Northern Arizona HCS (649)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002149,NULL,NULL, 'Palo Alto HCS (640)',NULL, 'Palo Alto HCS (640)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002150,NULL,NULL, 'Pittsburgh HCS (646)',NULL, 'Pittsburgh HCS (646)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002151,NULL,NULL, 'Puget Sound HCS (663)',NULL, 'Puget Sound HCS (663)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002152,NULL,TO_DATE('6/4/2004' , 'mm/dd/yyyy hh:mi:ss AM'), 'Roseburg HCS',NULL, 'Roseburg HCS',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002153,NULL,NULL, 'Salt Lake City HCS (660)',NULL, 'Salt Lake City HCS (660)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002154,NULL,NULL, 'San Diego HCS (664)',NULL, 'San Diego HCS (664)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002155,NULL,NULL, 'Sierra Nevada HCS (654)',NULL, 'Sierra Nevada HCS (654)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002156,NULL,NULL, 'South Texas HCS (671)',NULL, 'South Texas HCS (671)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002157,NULL,NULL, 'Southern Arizona VA HCS (678)',NULL, 'Southern Arizona VA HCS (678)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002158,NULL,TO_DATE('6/4/2004' , 'mm/dd/yyyy hh:mi:ss AM'), 'Tennessee Valley HCS',NULL, 'Tennessee Valley HCS',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002159,NULL,NULL, 'Upstate New York HCS (528)',NULL, 'Upstate New York HCS (528)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002162,NULL,NULL, 'VA Heartland-East VISN15 (657)',NULL, 'VA Heartland-East VISN15 (657)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002163,NULL,NULL, 'VA Heartland-West VISN15 (589)',NULL, 'VA Heartland-West VISN15 (589)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002164,NULL,TO_DATE('6/4/2004' , 'mm/dd/yyyy hh:mi:ss AM'), 'VA Pacific Islands HCS',NULL, 'VA Pacific Islands HCS',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002165,NULL,NULL, 'West Texas HCS (519)',NULL, 'West Texas HCS (519)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002166,NULL,NULL, 'VA Chicago HSC (537)',NULL, 'VA Chicago HSC (537)',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009242, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:19:04 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002201,NULL,NULL, 'VISN 1',NULL, 'VISN 1',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002202,NULL,NULL, 'VISN 2',NULL, 'VISN 2',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002203,NULL,NULL, 'VISN 3',NULL, 'VISN 3',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002204,NULL,NULL, 'VISN 4',NULL, 'VISN 4',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002205,NULL,NULL, 'VISN 5',NULL, 'VISN 5',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002206,NULL,NULL, 'VISN 6',NULL, 'VISN 6',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002207,NULL,NULL, 'VISN 7',NULL, 'VISN 7',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002208,NULL,NULL, 'VISN 8',NULL, 'VISN 8',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002209,NULL,NULL, 'VISN 9',NULL, 'VISN 9',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002210,NULL,NULL, 'VISN 10',NULL, 'VISN 10',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002211,NULL,NULL, 'VISN 11',NULL, 'VISN 11',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002212,NULL,NULL, 'VISN 12',NULL, 'VISN 12',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002213,NULL,NULL, 'VISN 13',NULL, 'VISN 13',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002214,NULL,NULL, 'VISN 14',NULL, 'VISN 14',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002215,NULL,NULL, 'VISN 15',NULL, 'VISN 15',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002216,NULL,NULL, 'VISN 16',NULL, 'VISN 16',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002217,NULL,NULL, 'VISN 17',NULL, 'VISN 17',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002218,NULL,NULL, 'VISN 18',NULL, 'VISN 18',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002219,NULL,NULL, 'VISN 19',NULL, 'VISN 19',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002220,NULL,NULL, 'VISN 20',NULL, 'VISN 20',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002221,NULL,NULL, 'VISN 21',NULL, 'VISN 21',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002222,NULL,NULL, 'VISN 22',NULL, 'VISN 22',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002223,NULL,NULL, 'VISN 23',NULL, 'VISN 23',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009241, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002224,NULL,NULL, 'NATIONAL CEMETERY ADMINISTRATION CENTRALIZED TRAINING FACILITY', '767', 'NCA CENTRALIZED TRAINING FCLTY',1009121,1006840,NULL,NULL,NULL,NULL,1009329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009163, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:19:04 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002225,NULL,NULL, 'CHEYENNE NHCU', '4429AA', 'CHEYENNE NHCU',1009121,1006840, '2360 EAST PERSHING BLVD',NULL,NULL, 'CHEYENNE',1009356,NULL, '82001-5356',1006840, '2360 E PERSHING BLVD',NULL,NULL, 'CHEYENNE',1009356,NULL, '82001-5356',1009185, '0',1000098,NULL,NULL,1002219,0,TO_DATE('6/4/2004 1:19:04 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Initial Load',NULL);
Insert into sdsadm.STD_Institution values(1002226,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ TRICARE - REGION 3 / 4 SC', '520ZZ', 'ZZ TRICARE - REGION 3 / 4 SC',1009121,1006840,NULL,NULL,NULL,NULL,1009345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009231, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:19:04 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1002227,NULL,TO_DATE('12/31/69' , 'mm/dd/yyyy hh:mi:ss AM'), 'ZZ CHAMPVA', '553CH', 'ZZ CHAMPVA',1009121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('6/4/2004 1:19:04 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('6/24/2013 11:26:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'Cleanup For Inactive Rows');
Insert into sdsadm.STD_Institution values(1002228,NULL,NULL, 'MEXICO CBOC (MO)', '589GX', 'MEXICO CBOC (MO)',1009121,1006840, '3460 S CLARK STREET',NULL,NULL, 'MEXICO',1009329,NULL, '65265-4124',1006840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009148, '0',1001262,NULL,NULL,1002215,0,TO_DATE('6/4/2004 1:19:04 PM' , 'mm/dd/yyyy hh:mi:ss AM'),TO_DATE('5/19/2015 8:35:55 AM' , 'mm/dd/yyyy hh:mi:ss AM'), 'Initial Load', 'DataBroker - CQ# 0929 04/01/2015');
Insert into sdsadm.STD_Institution values(1002229,TO_DATE('8/20/2004' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'AUSTIN PSIM', '200PS', 'AUSTIN PSIM',1009121,1006840,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,TO_DATE('9/2/2004 1:18:48 PM' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'Update for PSIM',NULL);
Insert into sdsadm.STD_Institution values(1002230,TO_DATE('8/15/2004' , 'mm/dd/yyyy hh:mi:ss AM'),NULL, 'AUSTIN MHV', '200MH', 'AUSTIN MHV',1009121,NULL,NULL,NULL,NULL,NULL,1009348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1009199, '0',NULL,NULL,NULL,NULL,0,