'use strict';

var vprjpr = require('VprPatient');

module.exports = {
  parse: function(ewd) {
    var query = ewd.query;
    var path = ewd.query.rest_path.split('/');
    var method = ewd.query.rest_method;
    var body, jpid, pid, uid;
    var template = '';

    if (method === 'GET') {
      if (path[1] === 'pid') {
        pid = path[2];

        return vprjpr.getpt(ewd, pid);
      } else if (path[1].indexOf(';') !== -1 || path[1].indexOf('V') !== -1) {
        pid = path[1];

        if (path[2] !== undefined && path[2].indexOf('urn:va') !== -1) {
          uid = path[2];

          if (path[3] !== undefined) { template = path[3]; } 

          return vprjpr.getobj(ewd, pid, uid, template);
        } else {
          return vprjpr.getpt(ewd, pid);
        }
      } else {
       return {
         "error": {
           "text": "Unrecognized Service",
           "statusCode": "400"
         }
       };
      }
    } else if (method === 'POST' || method === 'PUT') {
      if (path[1] === 'jpid') {
        jpid = path[2] !== undefined ? path[2] : '';

        body = ewd.query.ewd_body;

        return vprjpr.associate(ewd, jpid, body);
      } else {
        body = ewd.query.ewd_body;

        return vprjpr.putpt(ewd, body);
      }
    } else if (method === 'DELETE') {
      if (path[1].indexOf(';') !== -1) {
        if (path[2] !== undefined) {
          pid = path[1];
          uid = path[2];

          return vprjpr.deluid(ewd, pid, uid);
        } else {
          pid = path[1];

          return vprjpr.delpt(ewd, pid);
        }
      } else if (path[1] === 'uid') {
        pid = '';
        uid = path[2];

        return vprjpr.deluid(ewd, pid, uid);
      }
    } else {
      return {
        "error": {
          "text": "Unrecognized Service",
          "statusCode": "400"
        }
      };
    }
  }
};
