::: page-description
# ADK Libraries #
Which libraries are available with sample implementations
:::

## 3rd Party Libraries ##
updated Apr 05, 2016
| Library                                                           | Version            | Require shortcut                    | License      | Documentation                         |
|-------------------------------------------------------------------|--------------------|-------------------------------------|--------------|---------------------------------------|
|**async**                                                          |0.2.9              |async                                 |MIT           |_https://github.com/caolan/async_
|**handlebars**                                                     |2.0.0              |handlebars                            |MIT           |_http://handlebarsjs.com/_
|**lodash**                                                         |1.3.1              |underscore                            |MIT           |_https://github.com/lodash/lodash/blob/1.3.1/doc/README.md_
|**moment**                                                         |2.7.0              |moment                                |MIT           |_http://momentjs.com/_
|**jquery**                                                         |1.9.1              |jquery                                |MIT           |_http://jquery.com/_
|**gridster**                                                       |0.5.8 custom       |gridster                              |MIT           |_http://gridster.net/#documentation_
|**hbs**                                                            |2.0.0 custom       |hbs                                   |MIT           |_https://github.com/SlexAxton/require-handlebars-plugin_
|**backbone.fetch-cache**                                           |1.4.0 custom       |backbone.fetch-cache                  |MIT           |_https://github.com/mrappleton/backbone-fetch-cache.git_
|**backbone-marionette-accessibility**                              |Unversioned custom |backbone-marionette-accessibility     |MIT           |
|**backgrid.paginator**                                             |Unversioned custom |backgrid.paginator                    |MIT           |_http://backgridjs.com/ref/extensions/paginator.html_
|**bootstrap-accessibility**                                        |1.0.2 custom       |bootstrap-accessibility               |PayPal        |_http://paypal.github.io/bootstrap-accessibility-plugin/_
|**modernizr**                                                      |2.6.2 custom       |modernizr                             |MIT           |_https://modernizr.com/docs_
|**jquery.inputmask**                                               |3.2.2 custom       |jquery.inputmask                      |MIT           |_https://github.com/RobinHerbots/jquery.inputmask_
|**typeahead.js**                                                   |0.10.5             |typeahead                             |MIT           |_https://github.com/twitter/typeahead.js/_
|**select2**                                                        |4.0.2              |select2                               |MIT           |_https://select2.github.io/examples.html_
|**jquery.form**                                                    |20130616           |jquery.form                           |MIT           |_http://malsup.com/jquery/form/#ajaxForm_
|**jquery.formparams**                                              |Unversioned        |jquery.formparams                     |MIT           |_https://github.com/tinganho/jquery.formParams_
|**jquery.datatable**                                               |1.9.4              |jquery-datatable                      |MIT           |_https://datatables.net/_
|**jquery.scroll**                                                  |Unversioned        |jquery-scroll                         |MIT           |_http://james.padolsey.com/javascript/special-scroll-events-for-jquery/_
|**Marionette**                                                     |2.4.3              |marionette                            |MIT           |_http://marionettejs.com/_
|**backbone-sessionStorage**                                        |Unversioned        |sessionstorage                        |MIT           |_https://gist.github.com/davemo/3875274_
|**backbone.paginator**                                             |2.0.0              |backbone.paginator                    |MIT           |_https://github.com/backbone-paginator/backbone.paginator_
|**jasmine-jquery**                                                 |2.1.1              |jasminejquery                         |MIT           |_http://jasmine.github.io/1.3/introduction.html_
|**fastclick**                                                      |0.6.11             |fastclick                             |MIT           |_https://github.com/ftlabs/fastclick_
|**backgrid**                                                       |0.3.5              |backgrid                              |MIT           |_http://backgridjs.com/_
|**backgrid-filter**                                                |0.3.x              |backgrid.filter                       |MIT           |_http://backgridjs.com/ref/extensions/filter.html_
|**backgrid-moment-cell**                                           |0.3.x              |backgrid-moment-cell                  |MIT           |_https://github.com/wyuenho/backgrid-moment-cell_
|**bootstrap**                                                      |3.3.5              |bootstrap                             |MIT           |_http://getbootstrap.com/getting-started_
|**bootstrap-timepicker**                                           |0.2.x              |bootstrap-timepicker                  |MIT           |_http://jdewit.github.io/bootstrap-timepicker/_
|**bootstrap-datepicker**                                           |1.4.x              |bootstrap-datepicker                  |Apache 2.0    |_http://bootstrap-datepicker.readthedocs.org/en/release/_
|**font-awesome**                                                   |4.3.x              |                                      |MIT           |_http://fortawesome.github.io/Font-Awesome/examples/_
|**backbone**                                                       |1.2.3              |backbone                              |MIT           |_http://backbonejs.org/_
|**backbone-sorted-collection**                                     |0.3.8              |backbone-sorted-collection            |MIT           |_https://github.com/jmorrell/backbone-sorted-collection_
|**backbone.radio**                                                 |0.6.0              |backbone.radio                        |MIT           |_https://github.com/marionettejs/backbone.radio_
|**crossfilter**                                                    |1.3.x              |crossfilter                           |MIT           |_https://github.com/square/crossfilter/wiki/API-Reference_
|**highcharts**                                                     |2.0.4              |highcharts                            |Commercial    |_http://www.highcharts.com/docs_
|**pattern-fill**                                                   |2.0.2              |pattern-fill                          |MIT           |_http://www.highcharts.com/plugin-registry/single/9/Pattern-Fill_
|**bowser**                                                         |0.7.2              |bowser                                |MIT           |_https://github.com/ded/bowser_
|**grouped_categories**                                             |1.0.13             |grouped_categories                    |MIT           |_https://github.com/blacklabel/grouped_categories_
|**libphonenumber**                                                 |7.2.4              |libphonenumber                        |Apache 2.0    |_https://github.com/googlei18n/libphonenumber_
|**backbone_component**                                             |0.2.3              |backbone.component                    |MIT           |_https://github.com/malroc/backbone-component_
|**query-string**                                                   |1.0.0              |queryString                           |MIT           |_https://github.com/sindresorhus/query-string_
|**nouislider**                                                     |7.0.x              |nouislider                            |MIT           |_http://refreshless.com/nouislider/_
|**remarkable-bootstrap-notify**                                    |3.1.x              |bootstrap-notify                      |MIT           |_http://bootstrap-notify.remabledesigns.com/_
|**datejs**                                                         |1.0.x              |datejs                                |MIT           |_http://www.datejs.com/_
|**requirejs-text**                                                 |2.0.14             |                                      |MIT           |_https://github.com/requirejs/text/_
|**requirejs-plugins**                                              |1.0.3              |                                      |MIT           |_http://requirejs.org/docs/plugins.html_
|**require-css**                                                    |0.1.8              |                                      |MIT           |_https://github.com/guybedford/require-css_

> **Note:** Highcharts is not free, but is redistributed under the [terms of non-commerical use](http://shop.highsoft.com/faq/non-commercial#non-commercial-redistribution).

## Implementations ##
### jQuery Inputmask ###
This library enables the use of input formatting, such as limiting input to numeric characters and then displaying the input in an appropriate format. So for example, a user inputs a string of "19921102" and input mask could be used to format it to show "1992-11-02", with no additional logic/eventing. Review the documentation for more options.

Below is an example of adding an input mask to an input field:
```HTML
// HTML Template
<div class="input-group date">
      <input type="text" class="form-control input-sm" id="date" name="date">
</div>
```
```JavaScript
// JavaScript
this.$("#date").inputmask("y-m-d", {
    "placeholder": "YYYY-MM-DD"
});
```

### Bootstrap-Datepicker ###
This library provides a popover-like utility for picking a date graphically and have it set the date as a value inside an input field.

Below is an example of adding a date picker to an input field:
```HTML
// HTML Template
<div class="input-group date">
    <input type="text" class="form-control input-sm" id="filter-from-date" name="date">
</div>
```
```JavaScript
// JavaScript
this.$('.input-group.date').datepicker({});
```

### Bootstrap-Timepicker ###
This library provides a popover-like utility for picking a time graphically and have it set the time as a value inside an input field.

This example below creates a timepicker that has an attached fontawesome icon button, which triggers the popover/selector:
```HTML
// HTML Template
<div class="input-append input-group bootstrap-timepicker">
  <input id="timepicker" type="text" class="form-control input-sm">
    <span class="input-group-addon">
      <i class="fa fa-clock-o color-blue"></i>
    </span>
</div>
```
```JavaScript
// JavaScript
this.$('#timepicker').timepicker();
```
**Note:** The examples in the documentation uses deprecated icons, so please use Bootstrap's glyphicons instead.

### Marionette-Accessibility ###

As the native PayPal accessibility library only sets events and event listeners on initial execution, a custom library has been created which leverages the same features as the PayPal library but sets the roles, events, and listeners on a view when the attach event is fired.  If the view triggering the attach event has a parent, it attempts to issue the function against the parent view.  This library helps with keyboard navigation as well as ARIA role changes for Bootstrap components so long as the Bootstrap patterns are followed.

## CSS/SASS ##
*More Information:* documentation on SASS can be found by visiting their website at: [sass](http://sass-lang.com/)

> **All applet styling should now be done in SASS format.**

Your Sass file ("styles.scss") should be located in the following folder: `[applet]/assets/sass/`
The SASS file will be used during the applet's build task to create css styling for your applet.

**Reminder:** The app imports "styles.css" and the converter names CSS files based on the SASS file name, so SASS files should be named **"styles.scss"** to ensure that the app imports the correct styles file.

### Best Practices when developing SASS for you Applet ###
To apply CSS styles to only your applet the best approach is to have the applet container has the first selctor of all your styles.  Using SASS, this process easy.  See below for an example.

```SASS
[data-appletid="patient_search"] {
  font-size: 14px;
  p {
    ....
  }
  .margin {
    ....
  }
}
```

The above example makes use of the **data-appletid** attribute that is on the container element of every applet.  *Note:* this attribute is set to the value of the applet id so it is unqiue to that specific applet.

The above SASS code will translate into the following CSS when you run `gradle build[applet id]`:

```CSS
[data-appletid="patient_search"] {
  font-size: 14px;
}
[data-appletid="patient_search"] p {
  ....
}
[data-appletid="patient_search"] .margin {
  ....
}
```

If you have styles that are specific to the way your applet looks inside a **modal**, you can use the following method to ensure your styles are speciifc your applet only.

In your JavaScript file where you create the modal view to pass to ADK.showModal(), add a className attribute to the view:
```JavaScript
var modalView = Backbone.Marionette.ItemView.extend({
    className: "uniqueClassName"
});
var modalOptions = {
    ....
};
ADK.showModal(modalView, modalOptions);
```

Then in your SASS file (styles.scss), use that unique class name as your top level selector:
```SASS
.uniqueClassName {
  .p {
    /* some styles */
  }
}
```
