/* global jQuery */
(function( $ ) {
  'use strict';

  var _ = {
    analyzeHeader: function  (elem) {
      var header = {},
          jqElem = $(elem)
          ;

      header.jq = jqElem;
      header.level = elem.tagName[1];  // extract the number from h1,h2, etc.
      header.title = header.jq.text(); // innerHTML would keep inner tags.
      header.hash = elem.id;           // generated by marked

      return header;
    },

    buildTocItem: function  (hash, title) {
      // The <li> is to be closed when all his children have been added.
      return '<li><a href="#' + hash + '">' + title + '</a>';
    },

    generateClosingTags: function (previousLevel, currentLevel) {
      var difference = previousLevel - currentLevel,
          closingTags = ''
          ;

      while (difference--) {
        closingTags += '</ul>';
      }
      closingTags += '</li>';
      return closingTags;
    },

    makeToc: function  (contentEl, settings) {
      var headerLevels = 'h1,h2,h3',
          tocString = '',
          prevLevel
          ;

      contentEl.find(headerLevels).each(function (index, elem) {
        var header = _.analyzeHeader(elem);

        // Building the tag hierarchy
        if (!prevLevel) {
          // Initialization, <ul> tag not needed
        } else if (header.level > prevLevel) {
          tocString += '<ul>';
        } else if (header.level < prevLevel) {
          tocString += _.generateClosingTags(prevLevel, header.level);
        } else {
          tocString += '</li>';
        }

        // add <li>
        tocString += _.buildTocItem(header.hash, header.title, header.level -1);
        prevLevel = header.level;
      });

      tocString += _.generateClosingTags(prevLevel, 1);

      if (settings.toc.topLink) {
        var label = settings.toc.topLink;
        tocString += '<li><a href="#" id="backTop" onlick="' +
                     'jQuery(\'html,body\').animate({scrollTop:0},0);' +
                     '" >' + label + '</a></li>';
      }

      return tocString;
    }
  };

  $.fn.strapdown.toc = function (contentEl, settings) {
    var navbarTocEl = $(settings.toc.dest);

    if (settings && settings.toc && !settings.toc.disabled) {

      if (!contentEl.length) {
        console.warn('No content available to generate the table of content from. Aborting.');
        return this;
      } else if (! navbarTocEl.length ) {
        console.warn('Unable to find the insertion point for the table of content. Aborting.');
        return this;
      } else {
        navbarTocEl.append($('<ul/>', {
          'class': settings.toc.scrollspy ? 'nav navbar-nav' : '',
          'html': _.makeToc(contentEl, settings)
        }));

        if (settings.toc.scrollspy) {
          if ($.fn.scrollspy) {
            setTimeout(function () {
              $('body').scrollspy({
                target: settings.toc.dest,
                offset: settings.toc.scrollspyOffset
              });
            }, 500);
          } else {
            console.warn('boostrap scrollspy is not available.');
          }
        }
      }
    }

    return this;
  };

  // @ifdef DEBUG
  $.fn.strapdown.toc._internals = _;   // For testing purposes
  // @endif

}( jQuery ));