/*
 * Decompiled with CFR 0.152.
 */
package com.vistacowboy.jVista;

import com.vistacowboy.jVista.RpcParameter;
import com.vistacowboy.jVista.VistaConnection;
import com.vistacowboy.jVista.VistaException;
import com.vistacowboy.jVista.VistaRpc;
import com.vistacowboy.jVista.VistaUtils;
import java.util.LinkedHashMap;

public class VistaSelect {
    private String file;
    private String iens;
    private String fields = "@";
    private String flags = "IP";
    private int number = -1;
    private String from;
    private String part;
    private String index = "#";
    private String screen;
    private String identifier;
    private String[][] records;

    public String getFile() {
        return this.file;
    }

    public void setFile(String value) {
        this.file = value;
    }

    public String getIens() {
        return this.iens;
    }

    public void setIens(String value) throws VistaException {
        String[] parts;
        if (!value.startsWith(",")) {
            value = ',' + value;
        }
        if (!value.endsWith(",")) {
            value = value + ',';
        }
        for (String ien : parts = value.substring(1, value.length() - 1).split(",", -1)) {
            if (VistaUtils.isNumeric(ien)) continue;
            throw new VistaException(String.format("Non-numeric IEN: %s", ien));
        }
        this.iens = value;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String value) {
        if (!value.isEmpty()) {
            this.fields = value.contains("@") ? value : this.fields + ';' + value;
        }
    }

    public String getFlags() {
        return this.flags;
    }

    public void setFlags(String value) throws VistaException {
        if (value.isEmpty()) {
            value = "IP";
        } else if (!value.contains("P")) {
            throw new VistaException("Current version does packed queries only");
        }
        this.flags = value;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String value) {
        this.index = value;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int value) {
        this.number = value;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String value) {
        this.from = value;
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String value) {
        this.part = value;
    }

    public String getScreen() {
        return this.screen;
    }

    public void setScreen(String value) {
        this.screen = value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String value) {
        this.identifier = value;
    }

    public String[][] getRecords() {
        return this.records;
    }

    public String[][] find(VistaConnection cxn) throws VistaException {
        String rpc = this.prepare();
        String response = cxn.exec(rpc);
        this.load(response);
        return this.records;
    }

    private String prepare() throws VistaException {
        LinkedHashMap<String, String> param_list = this.prepareParamList();
        RpcParameter param = new RpcParameter(3, param_list);
        return VistaRpc.prepare("DDR LISTER", new RpcParameter[]{param});
    }

    private LinkedHashMap<String, String> prepareParamList() throws VistaException {
        if (this.file == null || this.file.isEmpty()) {
            throw new VistaException("VistaSelect must specify a file");
        }
        LinkedHashMap<String, String> param_list = new LinkedHashMap<String, String>();
        param_list.put("\"FILE\"", this.file);
        if (this.iens != null && !this.iens.isEmpty()) {
            param_list.put("\"IENS\"", this.iens);
        }
        param_list.put("\"FIELDS\"", this.fields);
        param_list.put("\"FLAGS\"", this.flags);
        if (this.number != -1) {
            param_list.put("\"MAX\"", String.valueOf(this.number));
        }
        if (this.from != null && !this.from.isEmpty()) {
            param_list.put("\"FROM\"", VistaUtils.adjustForSearch(this.from));
        }
        if (this.part != null && !this.part.isEmpty()) {
            param_list.put("\"PART\"", this.part);
        }
        param_list.put("\"XREF\"", this.index);
        if (this.screen != null && !this.screen.isEmpty()) {
            param_list.put("\"SCREEN\"", this.screen);
        }
        if (this.identifier != null && !this.identifier.isEmpty()) {
            param_list.put("\"ID\"", this.identifier);
        }
        return param_list;
    }

    private void load(String response) throws VistaException {
        int linenum;
        String[] lines = response.split("\r\n");
        for (linenum = 0; linenum < lines.length && !lines[linenum].equals("[BEGIN_diDATA]") && !lines[linenum].equals("[BEGIN_diERRORS]"); ++linenum) {
        }
        if (linenum == lines.length) {
            throw new VistaException("Empty response");
        }
        int nrex = lines.length - ++linenum - 1;
        String[] flds = lines[linenum].split("\\^");
        this.records = new String[nrex][flds.length];
        int recnum = 0;
        while (recnum < nrex) {
            this.records[recnum] = lines[linenum].split("\\^");
            ++recnum;
            ++linenum;
        }
        if (!lines[linenum].equals("[END_diDATA]") && !lines[linenum].equals("[END_diERRORS]")) {
            throw new VistaException("Response error: missing END_diDATA?");
        }
        if (lines[linenum].equals("[END_diERRORS]")) {
            throw new VistaException("Errors returned in response", this.records);
        }
    }
}

