HMPROS2 ;SLC/GRR -- Roster Management
 ;;2.0;ENTERPRISE HEALTH MANAGEMENT PLATFORM;**1**;Sep 01, 2011;Build 49
 ;; Compile Roster
COMPILE(HMP,HMPIEN,HMPOWNER) ;
 ;; Input - HMPIEN is internal entry number of roster
 ;;         HMPOWNER - If this parameter exists, only rosters for this owner will be compiled and passed
 ;; Output - AFTER array contains current patients
 ;
 K HMPLIST,HMPLIST2
 N HMPLIST,HMPFILT,HMPTYPE,VPERR,HMPI,HMPRNAME,HMPY,HMPOP,HMPTAG,HMPLAB,HMPNLIST,BEG,DOB,END,GENDER,ICN,NAME,HMPACT,HMPC
 N HMPCIEN,HMPDNAME,HMPDOB,HMPIII,HMPINM,HMPLIEN,HMPNAME,HMPOIEN,HMPONAME,HMPOWNID,HMPOWNNM,HMPPAT,HMPPIEN,HMPNME,HMPCNT
 N HMPSRCDN,HMPCID,HMPTEXT,HMPTIEN,HMPTLST,HMPVER,HMPWIEN,HMPWNAME,HMPPNME,HMPRCNT,HMPSRCID,X,Y
 K ^TMP($J,"HMPROSTR")
 S HMP=$NA(^TMP($J,"HMPROSTR")),HMPNLIST=""
 I $G(HMPIEN)="" S HMPIEN=0
 S (HMPLIST,HMPFILT,HMPTYPE,HMPOP,HMPLIST2,VPERR)="",HMPI=0
 I $G(HMPOWNER)'="" D MULTI Q HMP
 I +$G(HMPIEN)'>0 S VPERR="0^Invalid Roster IEN" Q
 S HMPRNAME=$P(^HMPROSTR(HMPIEN,0),"^",1)
 F  S HMPI=$O(^HMPROSTR(HMPIEN,1,HMPI)) Q:HMPI'>0  D
 . S HMPY=$G(^HMPROSTR(HMPIEN,1,HMPI,0))
 . S HMPOP=$P(HMPY,"^",3)
 . S HMPFILT=$P(HMPY,"^",4)
 . S HMPTAG=$P($P(HMPY,"^",2),";",2)
 . S HMPLAB=""
 . I HMPTAG["SC(" S HMPLAB="CLIN"
 . I HMPTAG["DIC(42" S HMPLAB="WARD"
 . I HMPTAG["DPT" S HMPLAB="PAT"
 . I HMPTAG["SCTM" S HMPLAB="PCMM"
 . I HMPTAG["OR(100.21" S HMPLAB="CPRS"
 . I HMPTAG["HMPROSTR" S HMPLAB="ROST"
 . I HMPTAG["DIC(45.7" S HMPLAB="SPEC"
 . I HMPTAG["VA(200" S HMPLAB="PROV"
 . I HMPTAG["PXRM(810.4" S HMPLAB="PXRM"
 . I HMPLAB="" S VPERR="1^INVALID FILE TYPE" Q
 . D @HMPLAB
 . S HMPLAB=$S(HMPOP=0:"UNION",HMPOP=1:"INTER",1:"DIFF")
 . S HMPNLIST=""
 . D @HMPLAB
 I $D(HMPOUT) K HMPOUT M HMPLIST2=HMPLIST Q
 I $O(HMPLIST(0))'>0 S VPERR="1^EMPTY ROSTER",@HMP@(1)=VPERR Q
 M AFTER=HMPLIST
 D SEND
 D ENROS^HMPFPTC(.ZZ,.HMPLIST) ;added 5/17/12 grr to check patient sensitivity
 Q
 ;
CLIN ;Process patients for this clinic.  Select all if filter is null
 K HMPLIST2 S HMPLIST2=""
 I '$D(DT) S DT=$$DT^XLFDT()
 S BEG=DT,END=$S(HMPFILT="T":DT+.24,1:9999999+.24),HMPIII=BEG
 S HMPCIEN=+$P(HMPY,"^",2) F  S HMPIII=$O(^SC(HMPCIEN,"S",HMPIII)) Q:HMPIII'>0!(HMPIII>END)  D
 . S HMPII=0 F  S HMPII=$O(^SC(HMPCIEN,"S",HMPIII,1,HMPII)) Q:HMPII'>0  S DFN=$P($G(^SC(HMPCIEN,"S",HMPIII,1,HMPII,0)),"^",1) I DFN>0 D
 . .S HMPLIST2(DFN)=""
 Q
 ;
WARD ;Process patients for this ward
 K HMPLIST2 S HMPLIST2=""
 S HMPWIEN=+$P(HMPY,"^",2),HMPWNAME=$P($G(^DIC(42,HMPWIEN,0)),"^",1)
 S HMPIII=0 F  S HMPIII=$O(^DGPM("CN",HMPWNAME,HMPIII)) Q:HMPIII'>0  D
 . S DFN=$P($G(^DGPM(HMPIII,0)),"^",3),HMPLIST2(DFN)=""
 Q
 ;
PAT ;Process patient from Patient file Source
 K HMPLIST2 S HMPLIST2=""
 S DFN=+$P(HMPY,"^",2),HMPLIST2(DFN)=""
 Q
 ;
PCMM ;Process patients from a PCMM team
 K HMPLIST2 S HMPLIST2=""
 S HMPTIEN=+$P(HMPY,"^",2),VPERR="",HMPTLST=""
 D PTTM^SCAPMC(HMPTIEN,,"HMPTLST",VPERR)
 S HMPIII="" F  S HMPIII=$O(HMPTLST(HMPIII)) Q:HMPIII'>0  S DFN=$P(HMPTLST(HMPIII),"^",1) S HMPLIST2(DFN)=""
 Q
 ;
CPRS ;Process patients from CPRS Lists
 K HMPLIST2 S HMPLIST2=""
 S HMPOIEN=+$P(HMPY,"^",2),VPERR=""
 S HMPIII=0 F  S HMPIII=$O(^OR(100.21,HMPOIEN,10,HMPIII)) Q:HMPIII'>0  S DFN=$P(^OR(100.21,HMPOIEN,10,HMPIII,0),";",1) S HMPLIST2(DFN)=""
 Q
 ;
ROST ;Process patients from selected roster
 K HMPLIST2,HMPBLIST S (HMPLIST2,HMPBLIST)="" ; -- kcm added comma
 N HMP,HMPIEN,VPERR
 S HMPIEN=+$P(HMPY,"^",2),VPERR="",HMPOUT=1,HMP="HMPBLIST"
 D COMPILE^HMPROS2(.HMP,HMPIEN,"")
 M HMPBLIST=HMPLIST2
 K HMPOUT
 Q
 ;
SPEC ;Process patients with selected Treating Specialty
 K HMPLIST2 S HMPLIST2=""
 S HMPOIEN=+$P(HMPY,"^",2),VPERR=""
 N DFN S DFN=0 F  S DFN=$O(^DPT("ATR",HMPOIEN,DFN)) Q:DFN'>0  S HMPLIST2(DFN)=""
 Q
 ;
PROV ;Process patients for selected provider
 K HMPLIST2 S HMPLIST2=""
 S HMPPIEN=+$P(HMPY,"^",2),VPERR=""
 N DFN S DFN=0 F  S DFN=$O(^DPT("APR",HMPPIEN,DFN)) Q:DFN'>0  S HMPLIST2(DFN)=""
 Q
 ;
PXRM ;Process patients for selected panel
 K HMPLIST2 S HMPLIST2=""
 S HMPPIEN=+$P(HMPY,"^",2),VPERR=""
 S HMPC=HMPPIEN,HMPLIEN=$P(^HMPROSTR(HMPIEN,0),"^",1),HMPPNME=$P(^HMPROSTR(HMPIEN,0),"^",6) I HMPPNME="" S HMPPNME=HMPRNAME,$P(^HMPROSTR(HMPIEN,0),U,6)=HMPRNAME
 S HMPPAT="" D RUNLIST^HMPROS5(.HMPPAT,HMPLIEN,HMPPNME,0,1)
 S HMPII=0 F  S HMPII=$O(HMPPAT(HMPC,HMPII)) Q:HMPII'>0  S DFN=HMPPAT(HMPC,HMPII),HMPLIST2(DFN)=""
 Q
 ;
UNION ;Add to existing list
 S HMPII=0 F  S HMPII=$O(HMPLIST2(HMPII)) Q:HMPII'>0  S HMPLIST(HMPII)=""
 Q
 ;
INTER ;Intersect with existing list
 S HMPII=0 F  S HMPII=$O(HMPLIST(HMPII)) Q:HMPII'>0  D
 . I '$D(HMPLIST2(HMPII)) K HMPLIST(HMPII)
 Q
 ;
DIFF ;Remove patients from this source that we have so far
 S HMPII=0 F  S HMPII=$O(HMPLIST2(HMPII)) Q:HMPII'>0  D
 . K HMPLIST(HMPII)
 Q
 ;
SEND ;send pending rosters.  Called through RPC
 S HMPRCNT=0,HMPI=0,HMPII=0
 S HMPVER="<results version='"_$P($T(HMPROS2+1),";",3)_"'>"
 D ADD(HMPVER)
 S HMPRNAME=$P(^HMPROSTR(HMPIEN,0),"^",1),HMPDNAME=$P(^HMPROSTR(HMPIEN,0),"^",2),HMPRNAME=$$ESC^HMPD(HMPRNAME),HMPDNAME=$$ESC^HMPD(HMPDNAME)
 S HMPTEXT="<roster ien='"_HMPIEN_"'>" D ADD(HMPTEXT)
 S HMPTEXT="<rosterName>"_HMPRNAME_"</rosterName>" D ADD(HMPTEXT)
 S HMPTEXT="<displayName>"_HMPDNAME_"</displayName>" D ADD(HMPTEXT)
 D ADD("<patients>")
 K HMPII S HMPII=0 F  S HMPII=$O(HMPLIST(HMPII)) Q:HMPII'>0  D
 . N HMPY
 . S DFN=HMPII,HMPY=$G(^DPT(DFN,0))
 . S ICN=$$GETICN^MPIF001(DFN)
 . S NAME=$P(HMPY,"^",1),GENDER=$P(HMPY,"^",2),DOB=$P(HMPY,"^",3),SSN=$P(HMPY,"^",9),HMPDOB=$$FMTHL7^XLFDT(DOB)
 . S Y="<patient name='"_NAME_"' gender='"_GENDER_"' dob='"_HMPDOB_"' ssn='"_SSN_"' id='"_DFN_$S(ICN:"' icn='"_ICN,1:"")_"' />" D ADD(Y)
 D ADD("</patients>")
 D ADD("</roster>")
 S HMPTEXT="</results>" D ADD(HMPTEXT)
 Q
 ;
ADD(X) ; -- Add a line @HMP@(n)=X
 S HMPI=$G(HMPI)+1
 S @HMP@(HMPI)=X
 Q
 ;
GETROS(HMP,HMPFILT) ;; Get all Rosters
 ;; Input - None
 N HMPLIST,HMPTYPE,VPERR,HMPI,HMPRNAME,HMPY,HMPOP,HMPTAG,HMPLAB,HMPNLIST,BEG,DOB,END,GENDER,ICN,NAME,HMPACT,HMPC
 N HMPCIEN,HMPDNAME,HMPDOB,HMPIII,HMPINM,HMPLIEN,HMPNAME,HMPOIEN,HMPONAME,HMPOWNID,HMPOWNNM,HMPPAT,HMPPIEN,HMPNME,HMPCNT
 N HMPSRCDN,HMPCID,HMPTEXT,HMPTIEN,HMPTLST,HMPVER,HMPWIEN,HMPWNAME,HMPPNME,HMPRCNT,HMPSRCID,X,Y
 K HMPLIST
 S (HMPLIST,HMPNAME,HMPTYPE,HMPOP,HMPLIST2)="",HMPI=0,HMPIEN=0
 S HMPACT="I 1"
 K ^TMP($J,"HMPROSTR")
 S HMP=$NA(^TMP($J,"HMPROSTR"))
 S HMPVER="<results version='"_$P($T(HMPROS2+1),";",3)_"'>"
 D ADD(HMPVER)
 S HMPNAME="",HMPFILT=$G(HMPFILT)
 I HMPFILT'="" S X=HMPFILT X ^%ZOSF("UPPERCASE") S HMPFILT=X,HMPNAME="",HMPACT="I HMPNAME[HMPFILT"
 F  S HMPNAME=$O(^HMPROSTR("B",HMPNAME)) Q:HMPNAME=""  S X=HMPNAME X ^%ZOSF("UPPERCASE") X HMPACT D
 . S HMPIEN=0 F  S HMPIEN=$O(^HMPROSTR("B",HMPNAME,HMPIEN)) Q:HMPIEN'>0  I '$P(^HMPROSTR(HMPIEN,0),"^",3)!($P($G(^HMPROSTR(HMPIEN,3)),"^",1)']"") X HMPACT I  D 
 . . S HMPONAME=$$ESC^HMPD(HMPNAME),HMPDNAME=$P(^HMPROSTR(HMPIEN,0),"^",2),HMPDNAME=$$ESC^HMPD(HMPDNAME)
 . . S HMPOWNID=$P(^HMPROSTR(HMPIEN,0),"^",4),HMPOWNNM=$P($G(^VA(200,HMPOWNID,0)),"^",1),HMPOWNNM=$$ESC^HMPD(HMPOWNNM)
 . . S HMPTEXT="<roster ien='"_HMPIEN_"'  ownername='"_HMPOWNNM_"'  ownerid='"_HMPOWNID_"'>" D ADD(HMPTEXT)
 . . S HMPTEXT="<rosterName>"_HMPONAME_"</rosterName>" D ADD(HMPTEXT)
 . . S HMPTEXT="<displayName>"_HMPDNAME_"</displayName>" D ADD(HMPTEXT)
 . . S HMPTEXT="<sources>" D ADD(HMPTEXT)
 . . N HMPII,HMPAS S HMPII=0 F  S HMPII=$O(^HMPROSTR(HMPIEN,1,"AS",HMPII)) Q:HMPII'>0  S HMPAS=$O(^HMPROSTR(HMPIEN,1,"AS",HMPII,0)) D
 . . . N HMPSEQ,HMPSRC,HMPTYP,HMPOP,HMPY,HMPSRCNM
 . . . S HMPY=$G(^HMPROSTR(HMPIEN,1,HMPAS,0))
 . . . S HMPSRC=$P($P(HMPY,"^",2),";",2)
 . . . S HMPSEQ=HMPII
 . . . I HMPSRC["SC(" S HMPSRCNM="Clinic"
 . . . I HMPSRC["DIC(42," S HMPSRCNM="Ward"
 . . . I HMPSRC["DPT(" S HMPSRCNM="Patient"
 . . . I HMPSRC["SCTM" S HMPSRCNM="PCMM Team"
 . . . I HMPSRC["OR(100.21" S HMPSRCNM="OE/RR"
 . . . I HMPSRC["HMPROSTR" S HMPSRCNM="HMP Roster"
 . . . I HMPSRC["DIC(45.7" S HMPSRCNM="Specialty"
 . . . I HMPSRC["VA(200," S HMPSRCNM="Provider"
 . . . I HMPSRC["PXRM(810.4," S HMPSRCNM="PXRM"
 . . . S HMPSRCID=+$P(HMPY,"^",2),HMPSRCDN="^"_HMPSRC_HMPSRCID_",0)",HMPINM=$P(@HMPSRCDN,"^",1),HMPINM=$$ESC^HMPD(HMPINM)
 . . . S HMPOP=$S($P(HMPY,"^",3)=0:"Union",$P(HMPY,"^",3)=1:"Intersection",$P(HMPY,"^",3)=2:"Difference",1:"Invalid")
 . . . S HMPTEXT="<source sequence='"_HMPSEQ_"'  type='"_HMPSRCNM_"'  name='"_HMPINM_"'  id='"_HMPSRCID_"'  operation='"_HMPOP_"' />" D ADD(HMPTEXT)
 . . S HMPTEXT="</sources>" D ADD(HMPTEXT)
 . . S HMPTEXT="</roster>" D ADD(HMPTEXT)
 S HMPTEXT="</results>" D ADD(HMPTEXT)
 Q
 ;
MULTI ;;Process multiple rosters
 I $O(^HMPROSTR("AC",HMPOWNER,0))'>0 S VPERR="1^EMPTY ROSTER",@HMP@(1)=VPERR Q
 S HMPRCNT=0,HMPI=0,HMPII=0,HMPIII=0
 S HMPVER="<results version='"_$P($T(HMPROS2+1),";",3)_"'>"
 D ADD(HMPVER)
 F  S HMPIEN=$O(^HMPROSTR("AC",HMPOWNER,HMPIEN)) Q:HMPIEN'>0  D
 .S HMPRNAME=$P(^HMPROSTR(HMPIEN,0),"^",1),HMPDNAME=$P(^HMPROSTR(HMPIEN,0),"^",2)
 .S HMPTEXT="<roster ien='"_HMPIEN_"'>" D ADD(HMPTEXT)
 .S HMPTEXT="<rosterName>"_HMPRNAME_"</rosterName>" D ADD(HMPTEXT)
 .S HMPTEXT="<displayName>"_HMPDNAME_"</displayName>" D ADD(HMPTEXT)
 . S HMPIII=0 F  S HMPIII=$O(^HMPROSTR(HMPIEN,1,HMPIII)) Q:HMPIII'>0  D
 .. S HMPY=$G(^HMPROSTR(HMPIEN,1,HMPIII,0))
 .. S HMPOP=$P(HMPY,"^",3)
 .. S HMPFILT=$P(HMPY,"^",4)
 .. S HMPTAG=$P($P(HMPY,"^",2),";",2)
 .. S HMPLAB=""
 .. I HMPTAG["SC(" S HMPLAB="CLIN"
 .. I HMPTAG["DIC(42" S HMPLAB="WARD"
 .. I HMPTAG["DPT" S HMPLAB="PAT"
 .. I HMPTAG["SCTM" S HMPLAB="PCMM"
 .. I HMPTAG["OR(100.21" S HMPLAB="CPRS"
 .. I HMPTAG["HMPROSTR" S HMPLAB="ROST"
 .. I HMPTAG["DIC(45.7" S HMPLAB="SPEC"
 .. I HMPTAG["VA(200" S HMPLAB="PROV"
 .. I HMPTAG["PXRM(810.4," S HMPLAB="PXRM"
 .. I HMPLAB="" S VPERR="1^INVALID FILE TYPE" Q
 .. D @HMPLAB
 .. S HMPLAB=$S(HMPOP=0:"UNION",HMPOP=1:"INTER",1:"DIFF")
 .. D @HMPLAB
 . D FORMAT
 . I $O(HMPLIST(0))'>0 S VPERR="1^EMPTY ROSTER",@HMP@(1)=VPERR Q
 . D ENROS^HMPFPTC(.ZZ,HMPLIST) ;added 5/17/12 grr to check patient sensitivity
 . I $D(HMPOUT) K HMPOUT M @HMP=HMPLIST Q
 S HMPTEXT="</results>" D ADD(HMPTEXT)
 Q
 ;;
FORMAT ;;
 D ADD("<patients>")
 K HMPII S HMPII=0 F  S HMPII=$O(HMPLIST(HMPII)) Q:HMPII'>0  D
 . N HMPY
 . S DFN=HMPII,HMPY=^DPT(DFN,0)
 . S ICN=$$GETICN^MPIF001(DFN)
 . S NAME=$P(HMPY,"^",1),GENDER=$P(HMPY,"^",2),DOB=$P(HMPY,"^",3),HMPDOB=$$FMTHL7^XLFDT(DOB),SSN=$P(HMPY,"^",9)
 . S Y="<patient name='"_NAME_"' gender='"_GENDER_"' dob='"_HMPDOB_"' ssn='"_SSN_"' id='"_DFN_$S(ICN:"' icn='"_ICN,1:"")_"' />" D ADD(Y)
 D ADD("</patients>")
 D ADD("</roster>")
 K Y
 Q
 ;;
