HMPEHL7 ;ALB/MJK - HMP HL7 ADT Message Processor ;03/25/2014 16:50:09
 ;;2.0;ENTERPRISE HEALTH MANAGEMENT PLATFORM;**1**;Sep 01, 2011;Build 49
 ;;
 ;
ADT ; -- main entry point for the following HMP ADT client/router protocols:
 ;          - HMP ADT-A04 CLIENT protocol
 ;             o  subscribes to VAFC ADT-A04 SERVER 
 ;          - HMP ADT-A08 CLIENT protocol
 ;             o  subscribes to VAFC ADT-A08 SERVER 
 ;
 ; Note: These variables are provided by the VistA HL7 system when a
 ;       subscriber protocol's ROUTING LOGIC is called:
 ;            - HLNEXT
 ;            - HLQUIT
 ;            - HLNODE
 ;            - HL("FS")
 ;            - HL("ECH")
 ;
 ; -- Filters ADT/A04(registration) & A08 (patient security level change) events
 ;    Scans for PID segment and uses embedded DFN
 ;    Sets ^XTMP("HMPFS~... freshness queue
 ;
 NEW DONE,HMPSEG,HMPEVT
 SET DONE=0
 FOR  XECUTE HLNEXT QUIT:HLQUIT'>0  DO  QUIT:DONE
 . SET HMPSEG=$EXTRACT(HLNODE,1,3)
 . ;
 . IF HMPSEG="EVN" DO  QUIT
 . . SET HMPEVT=$PIECE(HLNODE,HLFS,2)
 . . IF HMPEVT="A04" QUIT
 . . ; -- 97 reason = sensitive patient change occurred
 . . IF HMPEVT="A08",$PIECE(HLNODE,HLFS,5)=97 QUIT
 . . ; -- not an event HMP is interested in so done with message
 . . SET DONE=1
 . ; -- PID segment always comes after EVN segment
 . IF HMPSEG'="PID" QUIT
 . SET DONE=1
 . ; -- HMPEVT should always be defined at this point
 . IF $G(HMPEVT)="" QUIT
 . NEW DFN
 . SET DFN=+$PIECE($PIECE(HLNODE,HL("FS"),4),$EXTRACT(HL("ECH")))
 . IF 'DFN QUIT
 . DO POSTX^HMPEVNT("pt-select",DFN_"&"_HMPEVT)  ;Ref File event
 . IF $DATA(^HMP(800000,"AITEM",DFN)) DO POST^HMPEVNT(DFN,"patient",DFN)
 QUIT
 ;
