HMPCORD2 ;;SLC/AGP - Process Order Request from AVIVA System ; 11/2/10 11:39am
 ;;2.0;ENTERPRISE HEALTH MANAGEMENT PLATFORM;**1**;Sep 01, 2011;Build 49
 ;
 ;The purpose of this API is to process a request to renew an
 ;Outpatient Prescription
 ;
 Q
 ;
 ;add possible values from the dialog to XML List return for each prompt
ADDPOSS(POSS,RESULT) ;
 N CNT,ISFIRST,NUM,LAST,PROMPT,TEMP
 ;S RESULT("possibleValues")=""
 M RESULT=POSS
 S ISFIRST=1,LAST="",PROMPT=""
 ;F  S PROMPT=$O(POSS(PROMPT)) Q:PROMPT=""  D
 ;.S TEMP=PROMPT_"s",LAST=PROMPT
 ;.S RESULT("possibleValues",TEMP)=""
 ;.S CNT="",NUM=0 F  S CNT=$O(POSS(PROMPT,CNT)) Q:CNT=""  
 ;..S RESULT("possibleValues",TEMP,NUM,"value")=POSS(PROMPT,CNT),NUM=NUM+1
 Q
 ;
ARRREAS(REAS,UID) ;
 I '$D(^XTMP("HMP SNIPPET",DFN,DT)) S ^XTMP("HMP SNIPPET",0)=""
 N CNT S CNT=$O(^XTMP("HMP SNIPPET",DFN,DT,""),-1)
 S CNT=CNT+1
 S ^XTMP("HMP SNIPPET",DFN,DT,CNT)=""
 S ^XTMP("HMP SNIPPET",DFN,DT,CNT,"text")=REAS
 I $G(UID)'="" S ^XTMP("HMP SNIPPET",DFN,DT,CNT,"uid")=UID
 Q
 ;
 ;initial API needed for order actions and QO
BEG(DFN,LOC,IEN,USER,VARSARR,BLDRES,HMPVALUE) ;
 N CNT,FLDS,HASKEY,TEXT,HMPLST
 D BLDVAR(DFN,LOC,DT,.VARSARR) I VARSARR("PATIENT")="" D AE^HMPCORD1("Invalid Patient",.HMPVALUE) Q 0
 D NPHASKEY^ORWU(.HASKEY,USER,"PROVIDER") I HASKEY=0 D AE^HMPCORD1("DOES NOT HOLD THE PROVIDER KEY",.HMPVALUE) Q 0
 S FLDS=DFN_U_LOC_U_USER_U_VARSARR("ISINP")_U_VARSARR("SEX")_U_VARSARR("AGE")_U_"0;C;0;0^0^^^"
 I $P($G(^ORD(101.41,IEN,0)),U,4)="O" D  Q 1
 .S BLDRES(0)="^^^O"
 .D LOADSET^ORWDXM(.HMPLST,IEN)
 .S CNT=0 F  S CNT=$O(HMPLST(CNT)) Q:CNT'>0  D
 ..S BLDRES(CNT)=HMPLST(CNT)
 D BLDQRSP^ORWDXM1(.BLDRES,IEN,FLDS,VARSARR("ISIMO"),LOC)
 K ^TMP("ORWDXMQ",$J)
 I +BLDRES(0)=8 D AE^HMPCORD1(BLDRES(.5),.HMPVALUE) Q 0
 Q 1
 ;
 ;builds multiple arrays from the ORDIALOG array.
 ;builds XML return structure of the dialog,
 ;ORDERCHK array for order checks when placing an order
 ;SAVEARR array for saving an order for QO
BLDARRS(RESULT,ORDIALOG,VARSARR,DFN,LOC,ORDERCHK,SAVEARR,POSS) ;
 ;D ADD("<dialog>")
 N CNT,DEF,DRUG,EXT,FILLER,INC,IEN,INST,NODE,PROMPT,SCH,STR,TEMP,VALUE,X,ZERO
 D SCHALL^ORWDPS1(.SCH,DFN,LOC)
 S RESULT("name")=VARSARR("DIALOG NAME"),RESULT("displayGroup")=VARSARR("DISPLAY GROUP")
 S IEN=$$PTR("ORDERABLE ITEM")
 S OI=ORDIALOG(IEN,1),FILLER=VARSARR("FILLER ID")
 D LOADPOSS(DFN,LOC,OI,FILLER,.VARSARR,.POSS)
 S CNT=0,IEN=0,INC=0 F  S IEN=$O(ORDIALOG(IEN)) Q:IEN'>0  D
 .S NODE=$G(ORDIALOG(IEN)),ZERO=ORDIALOG(IEN,0)
 .S PROMPT=$P(NODE,U,2),CNT=CNT+1,INC=INC+1
 .S RESULT("structure",INC,"name")=PROMPT,RESULT("structure",INC,"id")=$P(NODE,U)
 .S TEMP=$S(PROMPT="DOSE":"ALLDOSES",PROMPT="DRUG":"DISPENSE",1:PROMPT)
 .;I $D(POSS(TEMP)) D ADDPOSS(TEMP,.POSS)
 .I $P(ZERO,U)="S" D LOADPOSC(PROMPT,$P(ZERO,U,2),.POSS)
 .;D ADD("<instances>")
 .S X=$O(ORDIALOG(IEN,99),-1)
 .;I X=0 D  Q
 .;.S VALUE=$O(POSS(PROMPT,"DEFAULT","")) I VALUE="" D  Q
 .;..D ADD("</instances>")
 .;..D ADD("</prompt>")
 .;.D ADD("<default value='"_$$ESC^HMPD(VALUE)_"'/>")
 .;.D ADD("</instances>")
 .;.D ADD("</prompt>")
 .F INST=1:1:X D
 ..S VALUE=ORDIALOG(IEN,INST)
 ..I VALUE["^TMP(" D  Q
 ... I $G(@VALUE@(1,0))="" Q
 ...S SAVEARR(IEN,INST)="ORDIALOG(""WP"","_IEN_",1)"
 ...S SAVEARR("WP",IEN,INST,1,0)=@VALUE@(1,0)
 ..S SAVEARR(IEN,INST)=VALUE
 ..S EXT=$$EXT^ORCD(IEN,INST)
 ..S ORDERCHK(CNT)=FILLER_U_PROMPT_U_VALUE_U_EXT,CNT=CNT+1
 ..S RESULT("structure",INC,"instance",INST,"number")=INST
 ..S RESULT("structure",INC,"instance",INST,"value")=VALUE
 ..S RESULT("structure",INC,"instance",INST,"external")=EXT
 ..I PROMPT="ORDERABLE" S OI=VALUE
 ..W !,PROMPT_" "_$G(VALUE)
 ..I PROMPT="DRUG" S DRUG=$G(VALUE)
 W !,FILLER
 S ORDERCHK(1)=OI_U_FILLER_U_$S(FILLER["PS":$G(DRUG),1:"")
 Q
 ;
 ;build patient demographic variables
BLDVAR(DFN,LOC,DATE,OUTPUT) ;
 N IMO,TEMP
 I $L(DFN)'>0 S OUTPUT("PATIENT")="" Q
 S TEMP=$G(^DPT(DFN,0))
 I TEMP="" S OUTPUT("PATIENT")="" Q
 S OUTPUT("PATIENT")=$P(TEMP,U,1)
 S OUTPUT("SEX")=$P(TEMP,U,2)
 S OUTPUT("DOB")=$P(TEMP,U,3)
 S OUTPUT("SSN")=$P(TEMP,U,9)
 S OUTPUT("DOD")=$P($G(^DPT(DFN,.35)),U,1)
 I OUTPUT("DOD")>DATE S OUTPUT("DOD")=""
 S OUTPUT("DFN")=DFN
 S OUTPUT("AGE")=$$AGE^PXRMAGE(OUTPUT("DOB"),OUTPUT("DOD"),DATE)
 S OUTPUT("ISINP")=$S(+$G(^DPT(DFN,.1))>0:1,1:0)
 D IMOLOC^ORIMO(.IMO,LOC,DFN)
 S OUTPUT("ISIMO")=$S(IMO>0:1,1:0)
 Q
 ;
BLDJSON(RESULT,ORDARR,HMPPOSS,HMPVALUE,REAS,UID,DATA) ;
 N CNT,ERROR,STR,TEMP,TEXT
 S RESULT("success")="true"
 I REAS'="",UID'="" D ARRREAS(REAS,UID)
 I $D(HMPPOSS) D ADDPOSS(.HMPPOSS)
 I $D(ORDARR) D
 .S RESULT("ordered placed")="true"
 .S CNT=0 F  S CNT=$O(ORDARR(CNT)) Q:CNT'>0  D
 ..S TEMP=ORDARR(CNT),STR=""
 ..I $E(TEMP)="t" S STR=$E(TEMP,2,$L(TEMP))
 ..I STR'="" S RESULT("text")=$G(RESULT("text"))_STR_$C(13,10)
 I $D(^TMP($J,"ORDER CHECKS")) D
 .S CNT=0 F  S CNT=$O(^TMP($J,"ORDER CHECKS",CNT)) Q:CNT'>0  D
 ..S RESULT("orderChecks")=$G(RESULT("orderChecks"))_^TMP($J,"ORDER CHECKS",CNT)_$C(13,10)
 I $D(DATA) M RESULT("data")=DATA
 D ENCODE^HMPJSON("RESULT","HMPVALUE","HMPERR")
 I $D(HMPERR) D
 .K HMPVALUE S TEXT(1)="Problem encoding save order array. Check CPRS to see if the order was saved."
 .D SETERROR^HMPUTILS(.ERROR,.HMPERR,.TEXT,.DATA)
 .D ENCODE^HMPJSON("ERROR","HMPVALUE","HMPERR")
 Q
 ;
CHANGE(ORDIEN,DFN,LOC,USER,ERRARR) ;
 N TEXT,VALUE
 D VALID^ORWDXA(.VALUE,ORDIEN,"XX",USER) I VALUE'="" D AE^HMPCORD1(VALUE,.HMPVALUE) Q 0
 D OFCPLX^ORWDXA(.VALUE,ORDIEN) I VALUE'="" D AE^HMPCORD1("CANNOT CHANGE A COMPLEX ORDER",.HMPVALUE) Q 0
 Q 1
 ;
INFO(OCHKS) ;
 N INC,CNT,NUM,NODE,TEMP,HMPORCK
 S NUM=0,CNT=+$O(^TMP($J,"ORDER CHECKS",""),-1)
 F  S NUM=$O(OCHKS(NUM)) Q:NUM'>0  D
 .S NODE=$P(OCHKS(NUM),U,4)
 .I NODE="" S NODE=OCHKS(NUM)
 .S TEMP=""
 .I NODE["||",NODE["&" D
 ..S TEMP=$P(NODE,"&")
 ..S NODE=$P(NODE,"&",2)
 .S CNT=CNT+1
 .S ^TMP($J,"ORDER CHECKS",CNT)=NODE
 .I TEMP'="" D
 ..D GETXTRA^ORCHECK(.HMPORCK,$P(TEMP,"||",2),NODE)
 ..S INC=0 F  S INC=$O(HMPORCK(INC)) Q:INC'>0  D
 ...S CNT=CNT+1
 ...S ^TMP($J,"ORDER CHECKS",CNT)=HMPORCK(INC)
 Q
 ;
KILLALRT(DFN,TYPE) ;
 N HMPOUT
 D KILUNSNO^ORWORB(.HMPOUT,DFN) K HMPOUT
 I TYPE["PS" D
 . D KILEXMED^ORWORB(.HMPOUT,DFN) K HMPOUT
 . D KILUNVMD^ORWORB(.HMPOUT,DFN) K HMPOUT
 D KILUNVOR^ORWORB(.HMPOUT,DFN) K HMPOUT
 Q
 ;build a list of possible selection items for a prompt
LOADPOSS(DFN,LOC,OI,FILLER,VARSARR,POSS) ;
 N CNT,DGIEN,ID,NUM,PROMPT,STR,TYPE,HMPPOSS
 S TYPE=$S(FILLER="PSO":"O",1:"I")
 S NUM=0
 S DGIEN=VARSARR("DISPLAY GROUP IEN")
 I FILLER["PS" D OISLCT^ORWDPS2(.HMPPOSS,OI,TYPE,DFN,"Y","N")
 I FILLER["LR" D DEF^ORWDLR32(.HMPPOSS,LOC,"")
 I FILLER["RA" D DEF^ORWDRA32(.HMPPOSS,DFN,"",DGIEN)
 S CNT=0
 F  S CNT=$O(HMPPOSS(CNT)) Q:CNT'>0  D
 .S NODE=HMPPOSS(CNT)
 .S TEMP=$E($G(NODE),2,$L(NODE))
 .I $E(NODE)="~" D  Q
 ..S NUM=0,PROMPT=$$LOW^XLFSTR(TEMP)
 ..S PROMPT=$TR(PROMPT," ","_")
 ..S POSS(PROMPT)=""
 ..S NUM=0
 .I PROMPT="alldoses"!(PROMPT="route") D  Q
 ..S ID=TEMP
 ..S TEMP=$S(PROMPT="alldoses":$P(TEMP,U),PROMPT="route":$P(TEMP,U,2),1:TEMP)
 ..S POSS($$LOW^XLFSTR(PROMPT),NUM,"value")=TEMP
 ..S POSS($$LOW^XLFSTR(PROMPT),NUM,"id")=ID
 ..S POSS($$LOW^XLFSTR(PROMPT),NUM,"default")=$S($E(NODE)="d":"true",1:"false")
 ..S NUM=NUM+1
 .S POSS($$LOW^XLFSTR(PROMPT),NUM,"value")=TEMP
 .;S POSS($$LOW^XLFSTR(PROMPT),NUM,"id")=ID
 .S POSS($$LOW^XLFSTR(PROMPT),NUM,"default")=$S($E(NODE)="d":"true",1:"false")
 .S NUM=NUM+1
 ;build list of possible schedules
 I FILLER["PS" D
 .D SCHALL^ORWDPS1(.SCH,DFN,LOC)
 .S NUM=0
 .S CNT=0 F  S CNT=$O(SCH(CNT)) Q:CNT'>0  D
 ..S TEMP=SCH(CNT)
 ..S POSS("schedule",NUM,"value")=$P(TEMP,U)
 ..S POSS("schedule",NUM,"external")=$P(TEMP,U,2)
 ..S POSS("schedule",NUM,"type")=$P(TEMP,U,3)
 ..S POSS("schedule",NUM,"admin")=$P(TEMP,U,4)
 ..S NUM=NUM+1
 Q
 ;
 ;;add possible code values from the dialog to XML return for each prompt
LOADPOSC(PROMPT,CODES,POSS) ;
 N CNT,STR,NUM,TEMP
 S TEMP=$$LOW^XLFSTR(PROMPT),POSS(TEMP)="",NUM=0,CNT=0
 F X=1:1:$L(CODES) I $E(CODES,X)=";" D
 .S CNT=CNT+1,STR=$P(CODES,";",CNT) Q:STR=""
 .S POSS(TEMP,NUM,"value")=$P(STR,":",2),POSS(TEMP,NUM,"id")=$P(STR,":"),NUM=NUM+1
 Q
PTR(NAME) ; -- Returns ptr value of prompt in Dialog file
 Q +$O(^ORD(101.41,"AB",$E("OR GTX "_NAME,1,63),0))
 ;
UNSIGNED(UIFN) ;queue unsigned order alert
 N ORVP,ORIFN,ORNP,A
 Q:$G(UIFN)=""  S A=$G(^OR(100,UIFN,0)),ORVP=$P(A,"^",2),ORNP=$P(A,"^",4),ORIFN=UIFN_";1"
 D NOTIF^ORCSIGN
 Q
