/*
 * Decompiled with CFR 0.152.
 */
package com.vistacowboy.jVista;

import com.vistacowboy.jVista.RpcParameter;
import com.vistacowboy.jVista.VistaException;
import com.vistacowboy.jVista.VistaUtils;

public class VistaRpc {
    private static final String PREFIX = "[XWB]";
    private static final int COUNT_WIDTH = 3;
    private static final String RPC_VERSION = "1.108";

    public static String prepare(String rpcName, RpcParameter[] params) throws VistaException {
        if (rpcName.equals("HELLO")) {
            return VistaRpc.prepareConnectRpc(params);
        }
        if (rpcName.equals("BYE")) {
            return VistaRpc.prepareDisconnectRpc();
        }
        return VistaRpc.prepareStandardRpc(rpcName, params);
    }

    private static String prepareStandardRpc(String rpcName, RpcParameter[] params) throws VistaException {
        return String.format("%s11302%s%s%s%s", PREFIX, VistaUtils.prependCount(RPC_VERSION), VistaUtils.prependCount(rpcName), VistaRpc.prepareParamString(params), "\u0004");
    }

    private static String prepareParamString(RpcParameter[] params) throws VistaException {
        String param_str = "5";
        if (params != null) {
            block5: for (RpcParameter param : params) {
                switch (param.getType()) {
                    case 1: {
                        param_str = param_str + String.format("%s%sf", Character.valueOf('0'), VistaUtils.strPack(param.getValue(), 3));
                        continue block5;
                    }
                    case 2: {
                        param_str = param_str + String.format("%s%sf", Character.valueOf('1'), VistaUtils.strPack(param.getValue(), 3));
                        continue block5;
                    }
                    case 3: {
                        param_str = param_str + String.format("%s%s", Character.valueOf('2'), param.paramList2String());
                        continue block5;
                    }
                    default: {
                        throw new VistaException("Invalid param type");
                    }
                }
            }
        }
        if (param_str.equals("5")) {
            param_str = param_str + "4f";
        }
        return param_str;
    }

    private static String prepareConnectRpc(RpcParameter[] params) {
        return String.format("[XWB]10304\nTCPConnect50%sf0%sf0%sf%s", VistaUtils.strPack(params[0].getValue(), 3), VistaUtils.strPack("0", 3), VistaUtils.strPack(params[1].getValue(), 3), "\u0004");
    }

    private static String prepareDisconnectRpc() {
        return String.format("[XWB]10304\u0005#BYE#%s", "\u0004");
    }
}

