/*
 * Decompiled with CFR 0.152.
 */
package com.vistacowboy.jVista;

import com.vistacowboy.jVista.RpcParameter;
import com.vistacowboy.jVista.VistaException;
import com.vistacowboy.jVista.VistaRpc;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.lang3.ArrayUtils;

public class VistaConnection {
    public static final String EOT = "\u0004";
    String host;
    int port;
    boolean isConnected = false;
    Socket socket;
    DataOutputStream socket_out;
    DataInputStream socket_in;

    public void configure(String host, int port) {
        this.host = host;
        this.port = port;
        this.isConnected = false;
    }

    public void connect(String clientIP, String hostName) throws VistaException {
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, this.port));
            this.socket_out = new DataOutputStream(this.socket.getOutputStream());
            this.socket_in = new DataInputStream(this.socket.getInputStream());
            RpcParameter[] params = new RpcParameter[]{new RpcParameter(1, clientIP), new RpcParameter(1, hostName)};
            String rpc = VistaRpc.prepare("HELLO", params);
            System.out.println(rpc);
            String response = this.exec(rpc);
            System.out.println(response);
            if (!response.equals("accept")) {
                this.socket.close();
                throw new VistaException("Connection not accepted");
            }
            this.isConnected = true;
        }
        catch (UnknownHostException e) {
            throw new VistaException(String.format("Unknown host: %s", e.getMessage()));
        }
        catch (IOException e) {
            throw new VistaException(String.format("Refused connection: %s", e.getMessage()));
        }
    }

    public String exec(String rpc) throws VistaException {
        this.send(rpc);
        return this.recv();
    }

    private void send(String rpc) throws VistaException {
        byte[] bytes = rpc.getBytes();
        try {
            this.socket_out.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new VistaException(e.getMessage());
        }
    }

    private String recv() throws VistaException {
        int EOT_BYTE = 4;
        byte[] buf = this.readBuf();
        boolean done = ArrayUtils.contains((byte[])buf, (byte)4);
        if (buf[0] != 0) {
            String response = new String(buf, 1, (int)buf[0]);
            throw new VistaException(String.format("VistA SECURITY error: %s", response));
        }
        if (buf[1] != 0) {
            String response = new String(buf, 2, buf.length - 2);
            throw new VistaException(String.format("VistA APPLICATION error: %s", response));
        }
        String response = new String(buf, 2, buf.length - 2);
        while (!done) {
            buf = this.readBuf();
            response = response + new String(ArrayUtils.subarray((byte[])buf, (int)0, (int)buf.length));
            done = ArrayUtils.contains((byte[])buf, (byte)4);
        }
        if ((response = response.substring(0, response.length() - 1)).startsWith("M  ERROR")) {
            throw new VistaException(response);
        }
        return response;
    }

    private byte[] readBuf() throws VistaException {
        int bytes_read;
        int BUF_SIZE = 256;
        byte[] buf = new byte[256];
        try {
            bytes_read = this.socket_in.read(buf);
        }
        catch (IOException e) {
            throw new VistaException(String.format("Error receiving: %s", e.getMessage()));
        }
        if (bytes_read == 0) {
            throw new VistaException("Error receiving: no response");
        }
        if (bytes_read < 256) {
            buf = ArrayUtils.subarray((byte[])buf, (int)0, (int)bytes_read);
        }
        return buf;
    }

    public String disconnect() throws VistaException {
        if (this.isConnected) {
            String rpc = VistaRpc.prepare("BYE", null);
            String response = this.exec(rpc);
            try {
                this.socket_out.close();
                this.socket_in.close();
                this.socket.close();
            }
            catch (IOException e) {
                throw new VistaException(e.getMessage());
            }
            this.isConnected = false;
            return response;
        }
        return "Socket was not connected";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getIsConnected() {
        return this.isConnected;
    }
}

