
--VBECS 2.3.0.1 SQL Script

--VBECS 2.3.0.1 SPRINT 1 SQL Script (Defect 210159, 213863, 209790, 499503)

/************************************************************************************************************************************
   SCRIPT NOTES

TOKENS CONTAINED IN THIS SCRIPT

@DBNAME@  - replaced this with the name of the VBECS database e.g. VBECS_TS1_TEST
@PATCHUSERID@  - replaced with the windows login ID of the user running the script
@TARGETVERSION@ - replaced with the target build number e.g., 2.3.0.1

!!!!!  Powershell script requried to copy file to 'H:\temppatch2301\PMTMData.txt'
for bulk load of PMTMData.txt (ProductModificationTargetMapping table Data)
*************************************************************************************************************************************/


--Defect 210159
USE @DBNAME@
GO


SET NOCOUNT ON

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_AntibodyScreenDisplay]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_AntibodyScreenDisplay]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_DaylightSavingsType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_DaylightSavingsType ]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_Facility]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_Facility]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_IconOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_IconOrderAlertType]
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_PrinterOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_PrinterOrderAlertType]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_TimeZone]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_TimeZone]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntibodyParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntibodyParameter]'))
ALTER TABLE [dbo].[AntibodyParameter] DROP CONSTRAINT [FK_AntibodyParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntiseraWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntiseraWorklist]'))
ALTER TABLE [dbo].[AntiseraWorklist] DROP CONSTRAINT [FK_AntiseraWorklist_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssociatedInstitution_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]'))
ALTER TABLE [dbo].[AssociatedInstitution] DROP CONSTRAINT [FK_AssociatedInstitution_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnit]'))
ALTER TABLE [dbo].[BloodUnit] DROP CONSTRAINT [FK_BloodUnit_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitAntigen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitAntigen]'))
ALTER TABLE [dbo].[BloodUnitAntigen] DROP CONSTRAINT [FK_BloodUnitAntigen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitModification]'))
ALTER TABLE [dbo].[BloodUnitModification] DROP CONSTRAINT [FK_BloodUnitModification_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]'))
ALTER TABLE [dbo].[BloodUnitTest] DROP CONSTRAINT [FK_BloodUnitTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CannedComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[CannedComment]'))
ALTER TABLE [dbo].[CannedComment] DROP CONSTRAINT [FK_CannedComment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ComponentClassParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ComponentClassParameter]'))
ALTER TABLE [dbo].[ComponentClassParameter] DROP CONSTRAINT [FK_ComponentClassParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyControl_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyControl]'))
ALTER TABLE [dbo].[DailyControl] DROP CONSTRAINT [FK_DailyControl_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyQcWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyQcWorklist]'))
ALTER TABLE [dbo].[DailyQcWorklist] DROP CONSTRAINT [FK_DailyQcWorklist_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Equipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Equipment]'))
ALTER TABLE [dbo].[Equipment] DROP CONSTRAINT [FK_Equipment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionAntigenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionAntigenTest]'))
ALTER TABLE [dbo].[ExceptionAntigenTest] DROP CONSTRAINT [FK_ExceptionAntigenTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionCautionTag_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionCautionTag]'))
ALTER TABLE [dbo].[ExceptionCautionTag] DROP CONSTRAINT [FK_ExceptionCautionTag_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionElectronicTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionElectronicTransfusion]'))
ALTER TABLE [dbo].[ExceptionElectronicTransfusion] DROP CONSTRAINT [FK_ExceptionElectronicTransfusion_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueOrder]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueOrder] DROP CONSTRAINT [FK_ExceptionEmergencyIssueOrder_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueUnitTest]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueUnitTest] DROP CONSTRAINT [FK_ExceptionEmergencyIssueUnitTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredTask_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredTask]'))
ALTER TABLE [dbo].[ExceptionExpiredTask] DROP CONSTRAINT [FK_ExceptionExpiredTask_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredUnitReceived_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredUnitReceived]'))
ALTER TABLE [dbo].[ExceptionExpiredUnitReceived] DROP CONSTRAINT [FK_ExceptionExpiredUnitReceived_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionInconclusiveCrossmatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionInconclusiveCrossmatch]'))
ALTER TABLE [dbo].[ExceptionInconclusiveCrossmatch] DROP CONSTRAINT [FK_ExceptionInconclusiveCrossmatch_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionLabelMismatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionLabelMismatch]'))
ALTER TABLE [dbo].[ExceptionLabelMismatch] DROP CONSTRAINT [FK_ExceptionLabelMismatch_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRh]'))
ALTER TABLE [dbo].[ExceptionPatientAboRh] DROP CONSTRAINT [FK_ExceptionPatientAboRh_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRhDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRhDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAboRhDiscrepancy] DROP CONSTRAINT [FK_ExceptionPatientAboRhDiscrepancy_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientRestriction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientRestriction]'))
ALTER TABLE [dbo].[ExceptionPatientRestriction] DROP CONSTRAINT [FK_ExceptionPatientRestriction_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTest]'))
ALTER TABLE [dbo].[ExceptionPatientTest] DROP CONSTRAINT [FK_ExceptionPatientTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTestInactivated_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTestInactivated]'))
ALTER TABLE [dbo].[ExceptionPatientTestInactivated] DROP CONSTRAINT [FK_ExceptionPatientTestInactivated_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQc_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQc]'))
ALTER TABLE [dbo].[ExceptionQc] DROP CONSTRAINT [FK_ExceptionQc_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcInactivation_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcInactivation]'))
ALTER TABLE [dbo].[ExceptionQcInactivation] DROP CONSTRAINT [FK_ExceptionQcInactivation_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcNotPerformed_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcNotPerformed]'))
ALTER TABLE [dbo].[ExceptionQcNotPerformed] DROP CONSTRAINT [FK_ExceptionQcNotPerformed_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQuarantine_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQuarantine]'))
ALTER TABLE [dbo].[ExceptionQuarantine] DROP CONSTRAINT [FK_ExceptionQuarantine_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRackTest]'))
ALTER TABLE [dbo].[ExceptionRackTest] DROP CONSTRAINT [FK_ExceptionRackTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRemoveFinalUnitStatus_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRemoveFinalUnitStatus]'))
ALTER TABLE [dbo].[ExceptionRemoveFinalUnitStatus] DROP CONSTRAINT [FK_ExceptionRemoveFinalUnitStatus_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReturnedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReturnedUnit]'))
ALTER TABLE [dbo].[ExceptionReturnedUnit] DROP CONSTRAINT [FK_ExceptionReturnedUnit_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionSpecimen]'))
ALTER TABLE [dbo].[ExceptionSpecimen] DROP CONSTRAINT [FK_ExceptionSpecimen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusion]'))
ALTER TABLE [dbo].[ExceptionTransfusion] DROP CONSTRAINT [FK_ExceptionTransfusion_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusionReactionWorkup_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusionReactionWorkup]'))
ALTER TABLE [dbo].[ExceptionTransfusionReactionWorkup] DROP CONSTRAINT [FK_ExceptionTransfusionReactionWorkup_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTrwSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTrwSpecimen]'))
ALTER TABLE [dbo].[ExceptionTrwSpecimen] DROP CONSTRAINT [FK_ExceptionTrwSpecimen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitAboRh]'))
ALTER TABLE [dbo].[ExceptionUnitAboRh] DROP CONSTRAINT [FK_ExceptionUnitAboRh_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitIssue_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitIssue]'))
ALTER TABLE [dbo].[ExceptionUnitIssue] DROP CONSTRAINT [FK_ExceptionUnitIssue_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitModification]'))
ALTER TABLE [dbo].[ExceptionUnitModification] DROP CONSTRAINT [FK_ExceptionUnitModification_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitSelection_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitSelection]'))
ALTER TABLE [dbo].[ExceptionUnitSelection] DROP CONSTRAINT [FK_ExceptionUnitSelection_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_HcpcsAssignment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[HcpcsAssignment]'))
ALTER TABLE [dbo].[HcpcsAssignment] DROP CONSTRAINT [FK_HcpcsAssignment_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_IssuedUnitComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[IssuedUnitComment]'))
ALTER TABLE [dbo].[IssuedUnitComment] DROP CONSTRAINT [FK_IssuedUnitComment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LocalSupplier_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LocalSupplier]'))
ALTER TABLE [dbo].[LocalSupplier] DROP CONSTRAINT [FK_LocalSupplier_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LoginMessage_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LoginMessage]'))
ALTER TABLE [dbo].[LoginMessage] DROP CONSTRAINT [FK_LoginMessage_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Msbos_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Msbos]'))
ALTER TABLE [dbo].[Msbos] DROP CONSTRAINT [FK_Msbos_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedComponent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedComponent]'))
ALTER TABLE [dbo].[OrderedComponent] DROP CONSTRAINT [FK_OrderedComponent_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedTest]'))
ALTER TABLE [dbo].[OrderedTest] DROP CONSTRAINT [FK_OrderedTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedUnit]'))
ALTER TABLE [dbo].[OrderedUnit] DROP CONSTRAINT [FK_OrderedUnit_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientOrder]'))
ALTER TABLE [dbo].[PatientOrder] DROP CONSTRAINT [FK_PatientOrder_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecialInstruction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecialInstruction]'))
ALTER TABLE [dbo].[PatientSpecialInstruction] DROP CONSTRAINT [FK_PatientSpecialInstruction_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecimen]'))
ALTER TABLE [dbo].[PatientSpecimen] DROP CONSTRAINT [FK_PatientSpecimen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTest]'))
ALTER TABLE [dbo].[PatientTest] DROP CONSTRAINT [FK_PatientTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusion]'))
ALTER TABLE [dbo].[PatientTransfusion] DROP CONSTRAINT [FK_PatientTransfusion_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionComment]'))
ALTER TABLE [dbo].[PatientTransfusionComment] DROP CONSTRAINT [FK_PatientTransfusionComment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionReaction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionReaction]'))
ALTER TABLE [dbo].[PatientTransfusionReaction] DROP CONSTRAINT [FK_PatientTransfusionReaction_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingBloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingBloodUnitTest]'))
ALTER TABLE [dbo].[PendingBloodUnitTest] DROP CONSTRAINT [FK_PendingBloodUnitTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingSpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingSpecimenTest]'))
ALTER TABLE [dbo].[PendingSpecimenTest] DROP CONSTRAINT [FK_PendingSpecimenTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PoolCounter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PoolCounter]'))
ALTER TABLE [dbo].[PoolCounter] DROP CONSTRAINT [FK_PoolCounter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductModificationParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductModificationParameter]'))
ALTER TABLE [dbo].[ProductModificationParameter] DROP CONSTRAINT [FK_ProductModificationParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductShipper_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductShipper]'))
ALTER TABLE [dbo].[ProductShipper] DROP CONSTRAINT [FK_ProductShipper_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Rack_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Rack]'))
ALTER TABLE [dbo].[Rack] DROP CONSTRAINT [FK_Rack_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackLot_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackLot]'))
ALTER TABLE [dbo].[RackLot] DROP CONSTRAINT [FK_RackLot_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackTest]'))
ALTER TABLE [dbo].[RackTest] DROP CONSTRAINT [FK_RackTest_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Reagent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Reagent]'))
ALTER TABLE [dbo].[Reagent] DROP CONSTRAINT [FK_Reagent_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTestParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTestParameter]'))
ALTER TABLE [dbo].[ReagentTestParameter] DROP CONSTRAINT [FK_ReagentTestParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTypeParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTypeParameter]'))
ALTER TABLE [dbo].[ReagentTypeParameter] DROP CONSTRAINT [FK_ReagentTypeParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Shipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Shipment]'))
ALTER TABLE [dbo].[Shipment] DROP CONSTRAINT [FK_Shipment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTest]'))
ALTER TABLE [dbo].[SpecimenTest] DROP CONSTRAINT [FK_SpecimenTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTestThreshold_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTestThreshold]'))
ALTER TABLE [dbo].[SpecimenTestThreshold] DROP CONSTRAINT [FK_SpecimenTestThreshold_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Supply_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Supply]'))
ALTER TABLE [dbo].[Supply] DROP CONSTRAINT [FK_Supply_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VBECSLock_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsLock]'))
ALTER TABLE [dbo].[VbecsLock] DROP CONSTRAINT [FK_VBECSLock_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole] DROP CONSTRAINT [FK_VbecsUserDivisionRole_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadEvent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadEvent]'))
ALTER TABLE [dbo].[WorkloadEvent] DROP CONSTRAINT [FK_WorkloadEvent_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionRequirement_CreateDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]'))
ALTER TABLE [dbo].[PatientTransfusionRequirement] DROP CONSTRAINT [FK_PatientTransfusionRequirement_CreateDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionRequirement_InactivateDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]'))
ALTER TABLE [dbo].[PatientTransfusionRequirement] DROP CONSTRAINT [FK_PatientTransfusionRequirement_InactivateDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadProcess_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadProcess]'))
ALTER TABLE [dbo].[WorkloadProcess] DROP CONSTRAINT [FK_WorkloadProcess_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAntigenDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAntigenDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAntigenDiscrepancy] DROP CONSTRAINT [FK_ExceptionPatientAntigenDiscrepancy_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReflexTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReflexTest]'))
ALTER TABLE [dbo].[ExceptionReflexTest] DROP CONSTRAINT [FK_ExceptionReflexTest_VamcDivision]
GO

/************************************************************************************************************************************/
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VamcDivision]') AND name = N'PK_VamcDivision')
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [PK_VamcDivision]
GO

ALTER TABLE [dbo].[VamcDivision] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VamcDivision]') AND name = N'PK_VamcDivision')
ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [PK_VamcDivision] PRIMARY KEY CLUSTERED 
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/************************************************************************************************************************************/

ALTER TABLE [dbo].[AntibodyParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntibodyParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntibodyParameter]'))
ALTER TABLE [dbo].[AntibodyParameter]  WITH NOCHECK ADD  CONSTRAINT [FK_AntibodyParameter_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntibodyParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntibodyParameter]'))
ALTER TABLE [dbo].[AntibodyParameter] CHECK CONSTRAINT [FK_AntibodyParameter_VamcDivision]
GO

ALTER TABLE [dbo].[AntiseraWorklist] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntiseraWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntiseraWorklist]'))
ALTER TABLE [dbo].[AntiseraWorklist]  WITH NOCHECK ADD  CONSTRAINT [FK_AntiseraWorklist_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntiseraWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntiseraWorklist]'))
ALTER TABLE [dbo].[AntiseraWorklist] CHECK CONSTRAINT [FK_AntiseraWorklist_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]') AND name = N'IX_AssociatedInstitution_DivisionCode')
DROP INDEX [IX_AssociatedInstitution_DivisionCode] ON [dbo].[AssociatedInstitution]
GO

ALTER TABLE [dbo].[AssociatedInstitution] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[AssociatedInstitution] ALTER COLUMN InstitutionDivisionCode VARCHAR(50) NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssociatedInstitution_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]'))
ALTER TABLE [dbo].[AssociatedInstitution]  WITH CHECK ADD  CONSTRAINT [FK_AssociatedInstitution_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssociatedInstitution_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]'))
ALTER TABLE [dbo].[AssociatedInstitution] CHECK CONSTRAINT [FK_AssociatedInstitution_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]') AND name = N'IX_AssociatedInstitution_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_AssociatedInstitution_DivisionCode] ON [dbo].[AssociatedInstitution]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO


IF  EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[dbo].[CK_BloodUnit]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnit]'))
ALTER TABLE [dbo].[BloodUnit] DROP CONSTRAINT [CK_BloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnit]') AND name = N'IX_BloodUnit_DivisionCode')
DROP INDEX [IX_BloodUnit_DivisionCode] ON [dbo].[BloodUnit]
GO

ALTER TABLE [dbo].[BloodUnit] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnit]'))
ALTER TABLE [dbo].[BloodUnit]  WITH NOCHECK ADD  CONSTRAINT [FK_BloodUnit_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnit]'))
ALTER TABLE [dbo].[BloodUnit] CHECK CONSTRAINT [FK_BloodUnit_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[dbo].[CK_BloodUnit]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnit]'))
ALTER TABLE [dbo].[BloodUnit]  WITH NOCHECK ADD  CONSTRAINT [CK_BloodUnit] CHECK  (([dbo].[fnBloodUnitLogicalKey]([DivisionCode], [LabelUnitId], [EyeReadableUnitId], [BloodProductGuid], [DonationTypeID], [UnitDivisionId], [BloodUnitGuid]) < 2))
GO

IF  EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[dbo].[CK_BloodUnit]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnit]'))
ALTER TABLE [dbo].[BloodUnit] CHECK CONSTRAINT [CK_BloodUnit]
GO

ALTER TABLE [dbo].[BloodUnitAntigen] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnit]') AND name = N'IX_BloodUnit_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_BloodUnit_DivisionCode] ON [dbo].[BloodUnit]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitAntigen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitAntigen]'))
ALTER TABLE [dbo].[BloodUnitAntigen]  WITH NOCHECK ADD  CONSTRAINT [FK_BloodUnitAntigen_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitAntigen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitAntigen]'))
ALTER TABLE [dbo].[BloodUnitAntigen] CHECK CONSTRAINT [FK_BloodUnitAntigen_VamcDivision]
GO

ALTER TABLE [dbo].[BloodUnitModification] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitModification]'))
ALTER TABLE [dbo].[BloodUnitModification]  WITH CHECK ADD  CONSTRAINT [FK_BloodUnitModification_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitModification]'))
ALTER TABLE [dbo].[BloodUnitModification] CHECK CONSTRAINT [FK_BloodUnitModification_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]') AND name = N'IX_BloodUnitTest_DivisonCode_BloodTestTypeId_TestDate_RecordStatusCode')
DROP INDEX [IX_BloodUnitTest_DivisonCode_BloodTestTypeId_TestDate_RecordStatusCode] ON [dbo].[BloodUnitTest]
GO

ALTER TABLE [dbo].[BloodUnitTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]'))
ALTER TABLE [dbo].[BloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_BloodUnitTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]'))
ALTER TABLE [dbo].[BloodUnitTest] CHECK CONSTRAINT [FK_BloodUnitTest_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]') AND name = N'IX_BloodUnitTest_DivisonCode_BloodTestTypeId_TestDate_RecordStatusCode')
CREATE NONCLUSTERED INDEX [IX_BloodUnitTest_DivisonCode_BloodTestTypeId_TestDate_RecordStatusCode] ON [dbo].[BloodUnitTest]
(
	[DivisionCode] ASC,
	[BloodTestTypeId] ASC,
	[TestDate] ASC,
	[RecordStatusCode] ASC
)
INCLUDE ( 	[BloodUnitTestGuid],
	[BloodUnitGuid],
	[TestTechId],
	[TestResultId],
	[EntryTechId],
	[TestingMethodCode],
	[TestComments],
	[AntiseraWorklistTypingGuid],
	[ConfirmationWorklistUnitGuid],
	[InactivateDate],
	[InactivateUser],
	[RackGuid],
	[AutoInstrumentName],
	[LastUpdateDate],
	[LastUpdateUser]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CannedComment]') AND name = N'IX_CannedComment_DivisionCode')
DROP INDEX [IX_CannedComment_DivisionCode] ON [dbo].[CannedComment]
GO

ALTER TABLE [dbo].[CannedComment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CannedComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[CannedComment]'))
ALTER TABLE [dbo].[CannedComment]  WITH NOCHECK ADD  CONSTRAINT [FK_CannedComment_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CannedComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[CannedComment]'))
ALTER TABLE [dbo].[CannedComment] CHECK CONSTRAINT [FK_CannedComment_VamcDivision]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CannedComment]') AND name = N'IX_CannedComment_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_CannedComment_DivisionCode] ON [dbo].[CannedComment]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

ALTER TABLE [dbo].[ComponentClassParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ComponentClassParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ComponentClassParameter]'))
ALTER TABLE [dbo].[ComponentClassParameter]  WITH NOCHECK ADD  CONSTRAINT [FK_ComponentClassParameter_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ComponentClassParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ComponentClassParameter]'))
ALTER TABLE [dbo].[ComponentClassParameter] CHECK CONSTRAINT [FK_ComponentClassParameter_VamcDivision]
GO

ALTER TABLE [dbo].[DailyControl] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyControl_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyControl]'))
ALTER TABLE [dbo].[DailyControl]  WITH NOCHECK ADD  CONSTRAINT [FK_DailyControl_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyControl_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyControl]'))
ALTER TABLE [dbo].[DailyControl] CHECK CONSTRAINT [FK_DailyControl_VamcDivision]
GO


ALTER TABLE [dbo].[DailyQcWorklist] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyQcWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyQcWorklist]'))
ALTER TABLE [dbo].[DailyQcWorklist]  WITH NOCHECK ADD  CONSTRAINT [FK_DailyQcWorklist_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyQcWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyQcWorklist]'))
ALTER TABLE [dbo].[DailyQcWorklist] CHECK CONSTRAINT [FK_DailyQcWorklist_VamcDivision]
GO


ALTER TABLE [dbo].[Equipment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Equipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Equipment]'))
ALTER TABLE [dbo].[Equipment]  WITH NOCHECK ADD  CONSTRAINT [FK_Equipment_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Equipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Equipment]'))
ALTER TABLE [dbo].[Equipment] CHECK CONSTRAINT [FK_Equipment_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionAntigenTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionAntigenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionAntigenTest]'))
ALTER TABLE [dbo].[ExceptionAntigenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionAntigenTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionAntigenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionAntigenTest]'))
ALTER TABLE [dbo].[ExceptionAntigenTest] CHECK CONSTRAINT [FK_ExceptionAntigenTest_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionCautionTag] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionCautionTag_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionCautionTag]'))
ALTER TABLE [dbo].[ExceptionCautionTag]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionCautionTag_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionCautionTag_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionCautionTag]'))
ALTER TABLE [dbo].[ExceptionCautionTag] CHECK CONSTRAINT [FK_ExceptionCautionTag_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionElectronicTransfusion] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionElectronicTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionElectronicTransfusion]'))
ALTER TABLE [dbo].[ExceptionElectronicTransfusion]  WITH CHECK ADD  CONSTRAINT [FK_ExceptionElectronicTransfusion_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionElectronicTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionElectronicTransfusion]'))
ALTER TABLE [dbo].[ExceptionElectronicTransfusion] CHECK CONSTRAINT [FK_ExceptionElectronicTransfusion_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionEmergencyIssueOrder] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueOrder]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueOrder]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionEmergencyIssueOrder_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueOrder]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueOrder] CHECK CONSTRAINT [FK_ExceptionEmergencyIssueOrder_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionEmergencyIssueUnitTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueUnitTest]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionEmergencyIssueUnitTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueUnitTest]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueUnitTest] CHECK CONSTRAINT [FK_ExceptionEmergencyIssueUnitTest_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionExpiredTask] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredTask_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredTask]'))
ALTER TABLE [dbo].[ExceptionExpiredTask]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionExpiredTask_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredTask_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredTask]'))
ALTER TABLE [dbo].[ExceptionExpiredTask] CHECK CONSTRAINT [FK_ExceptionExpiredTask_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionExpiredUnitReceived] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredUnitReceived_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredUnitReceived]'))
ALTER TABLE [dbo].[ExceptionExpiredUnitReceived]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionExpiredUnitReceived_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredUnitReceived_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredUnitReceived]'))
ALTER TABLE [dbo].[ExceptionExpiredUnitReceived] CHECK CONSTRAINT [FK_ExceptionExpiredUnitReceived_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionInconclusiveCrossmatch] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionInconclusiveCrossmatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionInconclusiveCrossmatch]'))
ALTER TABLE [dbo].[ExceptionInconclusiveCrossmatch]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionInconclusiveCrossmatch_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionInconclusiveCrossmatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionInconclusiveCrossmatch]'))
ALTER TABLE [dbo].[ExceptionInconclusiveCrossmatch] CHECK CONSTRAINT [FK_ExceptionInconclusiveCrossmatch_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionLabelMismatch] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionLabelMismatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionLabelMismatch]'))
ALTER TABLE [dbo].[ExceptionLabelMismatch]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionLabelMismatch_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionLabelMismatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionLabelMismatch]'))
ALTER TABLE [dbo].[ExceptionLabelMismatch] CHECK CONSTRAINT [FK_ExceptionLabelMismatch_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionPatientAboRh] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRh]'))
ALTER TABLE [dbo].[ExceptionPatientAboRh]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionPatientAboRh_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRh]'))
ALTER TABLE [dbo].[ExceptionPatientAboRh] CHECK CONSTRAINT [FK_ExceptionPatientAboRh_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionPatientAboRhDiscrepancy] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRhDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRhDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAboRhDiscrepancy]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionPatientAboRhDiscrepancy_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRhDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRhDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAboRhDiscrepancy] CHECK CONSTRAINT [FK_ExceptionPatientAboRhDiscrepancy_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionPatientRestriction] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientRestriction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientRestriction]'))
ALTER TABLE [dbo].[ExceptionPatientRestriction]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionPatientRestriction_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientRestriction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientRestriction]'))
ALTER TABLE [dbo].[ExceptionPatientRestriction] CHECK CONSTRAINT [FK_ExceptionPatientRestriction_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionPatientTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTest]'))
ALTER TABLE [dbo].[ExceptionPatientTest]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionPatientTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTest]'))
ALTER TABLE [dbo].[ExceptionPatientTest] CHECK CONSTRAINT [FK_ExceptionPatientTest_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionPatientTestInactivated] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTestInactivated_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTestInactivated]'))
ALTER TABLE [dbo].[ExceptionPatientTestInactivated]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionPatientTestInactivated_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTestInactivated_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTestInactivated]'))
ALTER TABLE [dbo].[ExceptionPatientTestInactivated] CHECK CONSTRAINT [FK_ExceptionPatientTestInactivated_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionQc] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQc_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQc]'))
ALTER TABLE [dbo].[ExceptionQc]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionQc_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQc_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQc]'))
ALTER TABLE [dbo].[ExceptionQc] CHECK CONSTRAINT [FK_ExceptionQc_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionQcInactivation] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcInactivation_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcInactivation]'))
ALTER TABLE [dbo].[ExceptionQcInactivation]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionQcInactivation_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcInactivation_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcInactivation]'))
ALTER TABLE [dbo].[ExceptionQcInactivation] CHECK CONSTRAINT [FK_ExceptionQcInactivation_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionQcNotPerformed] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcNotPerformed_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcNotPerformed]'))
ALTER TABLE [dbo].[ExceptionQcNotPerformed]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionQcNotPerformed_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcNotPerformed_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcNotPerformed]'))
ALTER TABLE [dbo].[ExceptionQcNotPerformed] CHECK CONSTRAINT [FK_ExceptionQcNotPerformed_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionQuarantine] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQuarantine_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQuarantine]'))
ALTER TABLE [dbo].[ExceptionQuarantine]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionQuarantine_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQuarantine_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQuarantine]'))
ALTER TABLE [dbo].[ExceptionQuarantine] CHECK CONSTRAINT [FK_ExceptionQuarantine_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionRackTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRackTest]'))
ALTER TABLE [dbo].[ExceptionRackTest]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionRackTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRackTest]'))
ALTER TABLE [dbo].[ExceptionRackTest] CHECK CONSTRAINT [FK_ExceptionRackTest_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionRemoveFinalUnitStatus] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRemoveFinalUnitStatus_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRemoveFinalUnitStatus]'))
ALTER TABLE [dbo].[ExceptionRemoveFinalUnitStatus]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionRemoveFinalUnitStatus_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRemoveFinalUnitStatus_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRemoveFinalUnitStatus]'))
ALTER TABLE [dbo].[ExceptionRemoveFinalUnitStatus] CHECK CONSTRAINT [FK_ExceptionRemoveFinalUnitStatus_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionReturnedUnit] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReturnedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReturnedUnit]'))
ALTER TABLE [dbo].[ExceptionReturnedUnit]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionReturnedUnit_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReturnedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReturnedUnit]'))
ALTER TABLE [dbo].[ExceptionReturnedUnit] CHECK CONSTRAINT [FK_ExceptionReturnedUnit_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionSpecimen] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionSpecimen]'))
ALTER TABLE [dbo].[ExceptionSpecimen]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionSpecimen_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionSpecimen]'))
ALTER TABLE [dbo].[ExceptionSpecimen] CHECK CONSTRAINT [FK_ExceptionSpecimen_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionTransfusion] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusion]'))
ALTER TABLE [dbo].[ExceptionTransfusion]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionTransfusion_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusion]'))
ALTER TABLE [dbo].[ExceptionTransfusion] CHECK CONSTRAINT [FK_ExceptionTransfusion_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionTransfusionReactionWorkup] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusionReactionWorkup_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusionReactionWorkup]'))
ALTER TABLE [dbo].[ExceptionTransfusionReactionWorkup]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionTransfusionReactionWorkup_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusionReactionWorkup_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusionReactionWorkup]'))
ALTER TABLE [dbo].[ExceptionTransfusionReactionWorkup] CHECK CONSTRAINT [FK_ExceptionTransfusionReactionWorkup_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionTrwSpecimen] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTrwSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTrwSpecimen]'))
ALTER TABLE [dbo].[ExceptionTrwSpecimen]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionTrwSpecimen_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTrwSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTrwSpecimen]'))
ALTER TABLE [dbo].[ExceptionTrwSpecimen] CHECK CONSTRAINT [FK_ExceptionTrwSpecimen_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionUnitAboRh] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitAboRh]'))
ALTER TABLE [dbo].[ExceptionUnitAboRh]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionUnitAboRh_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitAboRh]'))
ALTER TABLE [dbo].[ExceptionUnitAboRh] CHECK CONSTRAINT [FK_ExceptionUnitAboRh_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionUnitIssue] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitIssue_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitIssue]'))
ALTER TABLE [dbo].[ExceptionUnitIssue]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionUnitIssue_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitIssue_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitIssue]'))
ALTER TABLE [dbo].[ExceptionUnitIssue] CHECK CONSTRAINT [FK_ExceptionUnitIssue_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionUnitModification] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitModification]'))
ALTER TABLE [dbo].[ExceptionUnitModification]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionUnitModification_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitModification]'))
ALTER TABLE [dbo].[ExceptionUnitModification] CHECK CONSTRAINT [FK_ExceptionUnitModification_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionUnitSelection] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitSelection_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitSelection]'))
ALTER TABLE [dbo].[ExceptionUnitSelection]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionUnitSelection_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitSelection_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitSelection]'))
ALTER TABLE [dbo].[ExceptionUnitSelection] CHECK CONSTRAINT [FK_ExceptionUnitSelection_VamcDivision]
GO

ALTER TABLE [dbo].[HospitalLocationCache] ALTER COLUMN LocationDivision VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[HcpcsAssignment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_HcpcsAssignment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[HcpcsAssignment]'))
ALTER TABLE [dbo].[HcpcsAssignment]  WITH NOCHECK ADD  CONSTRAINT [FK_HcpcsAssignment_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_HcpcsAssignment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[HcpcsAssignment]'))
ALTER TABLE [dbo].[HcpcsAssignment] CHECK CONSTRAINT [FK_HcpcsAssignment_VamcDivision]
GO


ALTER TABLE [dbo].[IssuedUnitComment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_IssuedUnitComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[IssuedUnitComment]'))
ALTER TABLE [dbo].[IssuedUnitComment]  WITH NOCHECK ADD  CONSTRAINT [FK_IssuedUnitComment_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_IssuedUnitComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[IssuedUnitComment]'))
ALTER TABLE [dbo].[IssuedUnitComment] CHECK CONSTRAINT [FK_IssuedUnitComment_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LocalSupplier]') AND name = N'CK_LocalSupplier')
DROP INDEX [CK_LocalSupplier] ON [dbo].[LocalSupplier]
GO

ALTER TABLE [dbo].[LocalSupplier] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LocalSupplier_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LocalSupplier]'))
ALTER TABLE [dbo].[LocalSupplier]  WITH NOCHECK ADD  CONSTRAINT [FK_LocalSupplier_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LocalSupplier_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LocalSupplier]'))
ALTER TABLE [dbo].[LocalSupplier] CHECK CONSTRAINT [FK_LocalSupplier_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LocalSupplier]') AND name = N'CK_LocalSupplier')
CREATE UNIQUE NONCLUSTERED INDEX [CK_LocalSupplier] ON [dbo].[LocalSupplier]
(
	[FdaRegistrationNumber] ASC,
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LoginMessage]') AND name = N'IX_LoginMessage_DivisionCode')
DROP INDEX [IX_LoginMessage_DivisionCode] ON [dbo].[LoginMessage]
GO

ALTER TABLE [dbo].[LoginMessage] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LoginMessage_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LoginMessage]'))
ALTER TABLE [dbo].[LoginMessage]  WITH NOCHECK ADD  CONSTRAINT [FK_LoginMessage_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LoginMessage_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LoginMessage]'))
ALTER TABLE [dbo].[LoginMessage] CHECK CONSTRAINT [FK_LoginMessage_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LoginMessage]') AND name = N'IX_LoginMessage_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_LoginMessage_DivisionCode] ON [dbo].[LoginMessage]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Msbos]') AND name = N'CK_Msbos')
DROP INDEX [CK_Msbos] ON [dbo].[Msbos]
GO

ALTER TABLE [dbo].[Msbos] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Msbos_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Msbos]'))
ALTER TABLE [dbo].[Msbos]  WITH NOCHECK ADD  CONSTRAINT [FK_Msbos_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Msbos_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Msbos]'))
ALTER TABLE [dbo].[Msbos] CHECK CONSTRAINT [FK_Msbos_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Msbos]') AND name = N'CK_Msbos')
CREATE UNIQUE NONCLUSTERED INDEX [CK_Msbos] ON [dbo].[Msbos]
(
	[SurgeryName] ASC,
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

ALTER TABLE [dbo].[OrderedComponent] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedComponent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedComponent]'))
ALTER TABLE [dbo].[OrderedComponent]  WITH NOCHECK ADD  CONSTRAINT [FK_OrderedComponent_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedComponent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedComponent]'))
ALTER TABLE [dbo].[OrderedComponent] CHECK CONSTRAINT [FK_OrderedComponent_VamcDivision]
GO

ALTER TABLE [dbo].[OrderedTest] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedTest]'))
ALTER TABLE [dbo].[OrderedTest]  WITH NOCHECK ADD  CONSTRAINT [FK_OrderedTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedTest]'))
ALTER TABLE [dbo].[OrderedTest] CHECK CONSTRAINT [FK_OrderedTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[OrderedUnit]') AND name = N'IX_OrderedUnit_ReleaseDate_DivisionCode_RecordStatusCode')
DROP INDEX [IX_OrderedUnit_ReleaseDate_DivisionCode_RecordStatusCode] ON [dbo].[OrderedUnit]
GO

ALTER TABLE [dbo].[OrderedUnit] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedUnit]'))
ALTER TABLE [dbo].[OrderedUnit]  WITH NOCHECK ADD  CONSTRAINT [FK_OrderedUnit_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedUnit]'))
ALTER TABLE [dbo].[OrderedUnit] CHECK CONSTRAINT [FK_OrderedUnit_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[OrderedUnit]') AND name = N'IX_OrderedUnit_ReleaseDate_DivisionCode_RecordStatusCode')
CREATE NONCLUSTERED INDEX [IX_OrderedUnit_ReleaseDate_DivisionCode_RecordStatusCode] ON [dbo].[OrderedUnit]
(
	[ReleaseDate] ASC,
	[DivisionCode] ASC,
	[RecordStatusCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

ALTER TABLE [dbo].[PatientLocation] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

ALTER TABLE [dbo].[PatientOrder] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

ALTER TABLE [dbo].[PatientOrder] ALTER COLUMN InstitutionDivisionCode VARCHAR(50)  NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientOrder]'))
ALTER TABLE [dbo].[PatientOrder]  WITH CHECK ADD  CONSTRAINT [FK_PatientOrder_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientOrder]'))
ALTER TABLE [dbo].[PatientOrder] CHECK CONSTRAINT [FK_PatientOrder_VamcDivision]
GO


ALTER TABLE [dbo].[PatientSpecialInstruction] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecialInstruction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecialInstruction]'))
ALTER TABLE [dbo].[PatientSpecialInstruction]  WITH NOCHECK ADD  CONSTRAINT [FK_PatientSpecialInstruction_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecialInstruction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecialInstruction]'))
ALTER TABLE [dbo].[PatientSpecialInstruction] CHECK CONSTRAINT [FK_PatientSpecialInstruction_VamcDivision]
GO

ALTER TABLE [dbo].[PatientSpecimen] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecimen]'))
ALTER TABLE [dbo].[PatientSpecimen]  WITH NOCHECK ADD  CONSTRAINT [FK_PatientSpecimen_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecimen]'))
ALTER TABLE [dbo].[PatientSpecimen] CHECK CONSTRAINT [FK_PatientSpecimen_VamcDivision]
GO

ALTER TABLE [dbo].[PatientTest] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTest]'))
ALTER TABLE [dbo].[PatientTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PatientTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTest]'))
ALTER TABLE [dbo].[PatientTest] CHECK CONSTRAINT [FK_PatientTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusion]'))
ALTER TABLE [dbo].[PatientTransfusion] DROP CONSTRAINT [FK_PatientTransfusion_VamcDivision]
GO

ALTER TABLE [dbo].[PatientTransfusion] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusion]'))
ALTER TABLE [dbo].[PatientTransfusion]  WITH CHECK ADD  CONSTRAINT [FK_PatientTransfusion_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusion]'))
ALTER TABLE [dbo].[PatientTransfusion] CHECK CONSTRAINT [FK_PatientTransfusion_VamcDivision]
GO

ALTER TABLE [dbo].[PatientTransfusionComment] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionComment]'))
ALTER TABLE [dbo].[PatientTransfusionComment]  WITH NOCHECK ADD  CONSTRAINT [FK_PatientTransfusionComment_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionComment]'))
ALTER TABLE [dbo].[PatientTransfusionComment] CHECK CONSTRAINT [FK_PatientTransfusionComment_VamcDivision]
GO

ALTER TABLE [dbo].[PatientTransfusionReaction] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionReaction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionReaction]'))
ALTER TABLE [dbo].[PatientTransfusionReaction]  WITH NOCHECK ADD  CONSTRAINT [FK_PatientTransfusionReaction_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionReaction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionReaction]'))
ALTER TABLE [dbo].[PatientTransfusionReaction] CHECK CONSTRAINT [FK_PatientTransfusionReaction_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PendingBloodUnitTest]') AND name = N'IX_PendingBloodUnitTest_PendingTestStatusId_DivisionCode')
DROP INDEX [IX_PendingBloodUnitTest_PendingTestStatusId_DivisionCode] ON [dbo].[PendingBloodUnitTest] WITH ( ONLINE = OFF )
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingBloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingBloodUnitTest]'))
ALTER TABLE [dbo].[PendingBloodUnitTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingBloodUnitTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingBloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingBloodUnitTest]'))
ALTER TABLE [dbo].[PendingBloodUnitTest] CHECK CONSTRAINT [FK_PendingBloodUnitTest_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PendingBloodUnitTest]') AND name = N'IX_PendingBloodUnitTest_PendingTestStatusId_DivisionCode')
CREATE CLUSTERED INDEX [IX_PendingBloodUnitTest_PendingTestStatusId_DivisionCode] ON [dbo].[PendingBloodUnitTest]
(
	[PendingTestStatusId] ASC,
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO


IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PendingSpecimenTest]') AND name = N'IX_PendingSpecimenTest_PendingTestStatusId_DivisionCode')
DROP INDEX [IX_PendingSpecimenTest_PendingTestStatusId_DivisionCode] ON [dbo].[PendingSpecimenTest] WITH ( ONLINE = OFF )
GO

ALTER TABLE [dbo].[PendingSpecimenTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingSpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingSpecimenTest]'))
ALTER TABLE [dbo].[PendingSpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_PendingSpecimenTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingSpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingSpecimenTest]'))
ALTER TABLE [dbo].[PendingSpecimenTest] CHECK CONSTRAINT [FK_PendingSpecimenTest_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PendingSpecimenTest]') AND name = N'IX_PendingSpecimenTest_PendingTestStatusId_DivisionCode')
CREATE CLUSTERED INDEX [IX_PendingSpecimenTest_PendingTestStatusId_DivisionCode] ON [dbo].[PendingSpecimenTest]
(
	[PendingTestStatusId] ASC,
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PoolCounter]') AND name = N'IX_PoolCounter_DivisionCode')
DROP INDEX [IX_PoolCounter_DivisionCode] ON [dbo].[PoolCounter]
GO

ALTER TABLE [dbo].[PoolCounter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PoolCounter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PoolCounter]'))
ALTER TABLE [dbo].[PoolCounter]  WITH NOCHECK ADD  CONSTRAINT [FK_PoolCounter_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PoolCounter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PoolCounter]'))
ALTER TABLE [dbo].[PoolCounter] CHECK CONSTRAINT [FK_PoolCounter_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PoolCounter]') AND name = N'IX_PoolCounter_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_PoolCounter_DivisionCode] ON [dbo].[PoolCounter]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

ALTER TABLE [dbo].[ProductModificationParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductModificationParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductModificationParameter]'))
ALTER TABLE [dbo].[ProductModificationParameter]  WITH NOCHECK ADD  CONSTRAINT [FK_ProductModificationParameter_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductModificationParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductModificationParameter]'))
ALTER TABLE [dbo].[ProductModificationParameter] CHECK CONSTRAINT [FK_ProductModificationParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProductShipper]') AND name = N'IX_ProductShipper_DivisionCode')
DROP INDEX [IX_ProductShipper_DivisionCode] ON [dbo].[ProductShipper]
GO

ALTER TABLE [dbo].[ProductShipper] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductShipper_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductShipper]'))
ALTER TABLE [dbo].[ProductShipper]  WITH NOCHECK ADD  CONSTRAINT [FK_ProductShipper_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductShipper_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductShipper]'))
ALTER TABLE [dbo].[ProductShipper] CHECK CONSTRAINT [FK_ProductShipper_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProductShipper]') AND name = N'IX_ProductShipper_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_ProductShipper_DivisionCode] ON [dbo].[ProductShipper]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Rack] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Rack_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Rack]'))
ALTER TABLE [dbo].[Rack]  WITH NOCHECK ADD  CONSTRAINT [FK_Rack_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Rack_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Rack]'))
ALTER TABLE [dbo].[Rack] CHECK CONSTRAINT [FK_Rack_VamcDivision]
GO

ALTER TABLE [dbo].[RackLot] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackLot_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackLot]'))
ALTER TABLE [dbo].[RackLot]  WITH NOCHECK ADD  CONSTRAINT [FK_RackLot_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackLot_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackLot]'))
ALTER TABLE [dbo].[RackLot] CHECK CONSTRAINT [FK_RackLot_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RackTest]') AND name = N'IX_RackTest_DivisionCode')
DROP INDEX [IX_RackTest_DivisionCode] ON [dbo].[RackTest]
GO

ALTER TABLE [dbo].[RackTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackTest]'))
ALTER TABLE [dbo].[RackTest]  WITH CHECK ADD  CONSTRAINT [FK_RackTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackTest]'))
ALTER TABLE [dbo].[RackTest] CHECK CONSTRAINT [FK_RackTest_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RackTest]') AND name = N'IX_RackTest_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_RackTest_DivisionCode] ON [dbo].[RackTest]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Reagent]') AND name = N'IX_Reagent_DivisionCode')
DROP INDEX [IX_Reagent_DivisionCode] ON [dbo].[Reagent]
GO

ALTER TABLE [dbo].[Reagent] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Reagent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Reagent]'))
ALTER TABLE [dbo].[Reagent]  WITH NOCHECK ADD  CONSTRAINT [FK_Reagent_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Reagent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Reagent]'))
ALTER TABLE [dbo].[Reagent] CHECK CONSTRAINT [FK_Reagent_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Reagent]') AND name = N'IX_Reagent_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_Reagent_DivisionCode] ON [dbo].[Reagent]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

ALTER TABLE [dbo].[ReagentTestParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTestParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTestParameter]'))
ALTER TABLE [dbo].[ReagentTestParameter]  WITH NOCHECK ADD  CONSTRAINT [FK_ReagentTestParameter_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTestParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTestParameter]'))
ALTER TABLE [dbo].[ReagentTestParameter] CHECK CONSTRAINT [FK_ReagentTestParameter_VamcDivision]
GO

ALTER TABLE [dbo].[ExceptionPatientAntigenDiscrepancy] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAntigenDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAntigenDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAntigenDiscrepancy]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionPatientAntigenDiscrepancy_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAntigenDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAntigenDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAntigenDiscrepancy] CHECK CONSTRAINT [FK_ExceptionPatientAntigenDiscrepancy_VamcDivision]
GO


ALTER TABLE [dbo].[ExceptionReflexTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReflexTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReflexTest]'))
ALTER TABLE [dbo].[ExceptionReflexTest]  WITH NOCHECK ADD  CONSTRAINT [FK_ExceptionReflexTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReflexTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReflexTest]'))
ALTER TABLE [dbo].[ExceptionReflexTest] CHECK CONSTRAINT [FK_ExceptionReflexTest_VamcDivision]
GO

ALTER TABLE [dbo].[ReagentTypeParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTypeParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTypeParameter]'))
ALTER TABLE [dbo].[ReagentTypeParameter]  WITH NOCHECK ADD  CONSTRAINT [FK_ReagentTypeParameter_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTypeParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTypeParameter]'))
ALTER TABLE [dbo].[ReagentTypeParameter] CHECK CONSTRAINT [FK_ReagentTypeParameter_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[dbo].[CK_Shipment]') AND parent_object_id = OBJECT_ID(N'[dbo].[Shipment]'))
ALTER TABLE [dbo].[Shipment] DROP CONSTRAINT [CK_Shipment]
GO

ALTER TABLE [dbo].[Shipment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Shipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Shipment]'))
ALTER TABLE [dbo].[Shipment]  WITH NOCHECK ADD  CONSTRAINT [FK_Shipment_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Shipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Shipment]'))
ALTER TABLE [dbo].[Shipment] CHECK CONSTRAINT [FK_Shipment_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[dbo].[CK_Shipment]') AND parent_object_id = OBJECT_ID(N'[dbo].[Shipment]'))
ALTER TABLE [dbo].[Shipment]  WITH CHECK ADD  CONSTRAINT [CK_Shipment] CHECK  (([dbo].[fnShipmentLogicalKey]([DivisionCode], [LocalSupplierGuid], [ProductShipperGuid], [InvoiceNumber], [ShipmentDate], [ShipmentDirection]) < 2))
GO

IF  EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[dbo].[CK_Shipment]') AND parent_object_id = OBJECT_ID(N'[dbo].[Shipment]'))
ALTER TABLE [dbo].[Shipment] CHECK CONSTRAINT [CK_Shipment]
GO


ALTER TABLE [dbo].[PatientTransfusionRequirement] ALTER COLUMN CreateDivisionCode VARCHAR(50)  NULL
GO

ALTER TABLE [dbo].[PatientTransfusionRequirement] ALTER COLUMN InactivateDivisionCode VARCHAR(50)  NULL
GO

ALTER TABLE [dbo].[PatientTransfusionRequirement] ADD CONSTRAINT [FK_PatientTransfusionRequirement_CreateDivision] FOREIGN KEY ([CreateDivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionRequirement_InactivateDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]'))
ALTER TABLE [dbo].[PatientTransfusionRequirement]  WITH CHECK ADD  CONSTRAINT [FK_PatientTransfusionRequirement_InactivateDivision] FOREIGN KEY([InactivateDivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionRequirement_InactivateDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]'))
ALTER TABLE [dbo].[PatientTransfusionRequirement] CHECK CONSTRAINT [FK_PatientTransfusionRequirement_InactivateDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsLock]') AND name = N'IX_VbecsLock_LastupdateUser')
DROP INDEX [IX_VbecsLock_LastupdateUser] ON [dbo].[VbecsLock]
GO

ALTER TABLE [dbo].[VbecsLock] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsLock]') AND name = N'IX_VbecsLock_LastupdateUser')
CREATE NONCLUSTERED INDEX [IX_VbecsLock_LastupdateUser] ON [dbo].[VbecsLock]
(
	[LastUpdateUser] ASC
)
INCLUDE ( 	[DivisionCode],
	[LockedRecordGuid],
	[LockedUseCaseId],
	[SessionGuid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

ALTER TABLE [dbo].[SpecimenTest] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTest]'))
ALTER TABLE [dbo].[SpecimenTest]  WITH NOCHECK ADD  CONSTRAINT [FK_SpecimenTest_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTest]'))
ALTER TABLE [dbo].[SpecimenTest] CHECK CONSTRAINT [FK_SpecimenTest_VamcDivision]
GO

ALTER TABLE [dbo].[SpecimenTestThreshold] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTestThreshold_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTestThreshold]'))
ALTER TABLE [dbo].[SpecimenTestThreshold]  WITH NOCHECK ADD  CONSTRAINT [FK_SpecimenTestThreshold_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTestThreshold_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTestThreshold]'))
ALTER TABLE [dbo].[SpecimenTestThreshold] CHECK CONSTRAINT [FK_SpecimenTestThreshold_VamcDivision]
GO


ALTER TABLE [dbo].[Supply] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Supply_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Supply]'))
ALTER TABLE [dbo].[Supply]  WITH NOCHECK ADD  CONSTRAINT [FK_Supply_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Supply_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Supply]'))
ALTER TABLE [dbo].[Supply] CHECK CONSTRAINT [FK_Supply_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsLock]') AND name = N'IX_VbecsLock_LastupdateUser')
DROP INDEX [IX_VbecsLock_LastupdateUser] ON [dbo].[VbecsLock]
GO

ALTER TABLE [dbo].[VbecsLock] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsLock]') AND name = N'IX_VbecsLock_LastupdateUser')
CREATE NONCLUSTERED INDEX [IX_VbecsLock_LastupdateUser] ON [dbo].[VbecsLock]
(
	[LastUpdateUser] ASC
)
INCLUDE ( 	[DivisionCode],
	[LockedRecordGuid],
	[LockedUseCaseId],
	[SessionGuid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO


IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VBECSLock_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsLock]'))
ALTER TABLE [dbo].[VbecsLock]  WITH CHECK ADD  CONSTRAINT [FK_VBECSLock_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VBECSLock_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsLock]'))
ALTER TABLE [dbo].[VbecsLock] CHECK CONSTRAINT [FK_VBECSLock_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'IX_VbecsUserDivisionRole')
DROP INDEX [IX_VbecsUserDivisionRole] ON [dbo].[VbecsUserDivisionRole] WITH ( ONLINE = OFF )
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'IX_VbecsUserDivisionRole_DivisionCode')
DROP INDEX [IX_VbecsUserDivisionRole_DivisionCode] ON [dbo].[VbecsUserDivisionRole]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_VbecsUser]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole] DROP CONSTRAINT [FK_VbecsUserDivisionRole_VbecsUser]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_UserRole]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole] DROP CONSTRAINT [FK_VbecsUserDivisionRole_UserRole]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'PK_VbecsUserDivisionRole')
ALTER TABLE [dbo].[VbecsUserDivisionRole] DROP CONSTRAINT [PK_VbecsUserDivisionRole]
GO

ALTER TABLE [dbo].[VbecsUserDivisionRole] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole]  WITH NOCHECK ADD  CONSTRAINT [FK_VbecsUserDivisionRole_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole] CHECK CONSTRAINT [FK_VbecsUserDivisionRole_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'PK_VbecsUserDivisionRole')
ALTER TABLE [dbo].[VbecsUserDivisionRole] ADD  CONSTRAINT [PK_VbecsUserDivisionRole] PRIMARY KEY CLUSTERED 
(
	[DivisionCode] ASC,
	[UserRoleId] ASC,
	[VbecsUserId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_UserRole]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole]  WITH NOCHECK ADD  CONSTRAINT [FK_VbecsUserDivisionRole_UserRole] FOREIGN KEY([UserRoleId])
REFERENCES [dbo].[UserRole] ([UserRoleId])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_UserRole]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole] CHECK CONSTRAINT [FK_VbecsUserDivisionRole_UserRole]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_VbecsUser]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole]  WITH NOCHECK ADD  CONSTRAINT [FK_VbecsUserDivisionRole_VbecsUser] FOREIGN KEY([VbecsUserId])
REFERENCES [dbo].[VbecsUser] ([VbecsUserId])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_VbecsUser]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole] CHECK CONSTRAINT [FK_VbecsUserDivisionRole_VbecsUser]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'IX_VbecsUserDivisionRole_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_VbecsUserDivisionRole_DivisionCode] ON [dbo].[VbecsUserDivisionRole]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WorkloadEvent]') AND name = N'IX_WorkLoadEvent_RecordStatusCode_WorkloadEventDate')
DROP INDEX [IX_WorkLoadEvent_RecordStatusCode_WorkloadEventDate] ON [dbo].[WorkloadEvent]
GO

ALTER TABLE [dbo].[WorkloadEvent] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadEvent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadEvent]'))
ALTER TABLE [dbo].[WorkloadEvent]  WITH NOCHECK ADD  CONSTRAINT [FK_WorkloadEvent_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadEvent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadEvent]'))
ALTER TABLE [dbo].[WorkloadEvent] CHECK CONSTRAINT [FK_WorkloadEvent_VamcDivision]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WorkloadEvent]') AND name = N'IX_WorkLoadEvent_RecordStatusCode_WorkloadEventDate')
CREATE NONCLUSTERED INDEX [IX_WorkLoadEvent_RecordStatusCode_WorkloadEventDate] ON [dbo].[WorkloadEvent]
(
	[RecordStatusCode] ASC,
	[WorkloadEventDate] ASC
)
INCLUDE ( 	[WorkloadProcessGuid],
	[WorkloadEventStatusCode],
	[WeightMultiplier],
	[DivisionCode]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO


ALTER TABLE [dbo].[WorkloadProcess] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadProcess_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadProcess]'))
ALTER TABLE [dbo].[WorkloadProcess]  WITH NOCHECK ADD  CONSTRAINT [FK_WorkloadProcess_VamcDivision] FOREIGN KEY([DivisionCode])
REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadProcess_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadProcess]'))
ALTER TABLE [dbo].[WorkloadProcess] CHECK CONSTRAINT [FK_WorkloadProcess_VamcDivision]
GO


/********************************************************************************************************************************/
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_TimeZone]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision]  WITH CHECK ADD  CONSTRAINT [FK_VamcDivision_TimeZone] FOREIGN KEY([TimeZoneId])
REFERENCES [dbo].[TimeZone] ([TimeZoneId])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_TimeZone]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] CHECK CONSTRAINT [FK_VamcDivision_TimeZone]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_PrinterOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision]  WITH CHECK ADD  CONSTRAINT [FK_VamcDivision_PrinterOrderAlertType] FOREIGN KEY([PrinterOrderAlertTypeCode])
REFERENCES [dbo].[OrderAlertType] ([OrderAlertTypeCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_PrinterOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] CHECK CONSTRAINT [FK_VamcDivision_PrinterOrderAlertType]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_IconOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision]  WITH CHECK ADD  CONSTRAINT [FK_VamcDivision_IconOrderAlertType] FOREIGN KEY([IconOrderAlertTypeCode])
REFERENCES [dbo].[OrderAlertType] ([OrderAlertTypeCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_IconOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] CHECK CONSTRAINT [FK_VamcDivision_IconOrderAlertType]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_Facility]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision]  WITH CHECK ADD  CONSTRAINT [FK_VamcDivision_Facility] FOREIGN KEY([FacilityGuid])
REFERENCES [dbo].[Facility] ([FacilityGuid])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_Facility]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] CHECK CONSTRAINT [FK_VamcDivision_Facility]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_DaylightSavingsType ]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision]  WITH CHECK ADD  CONSTRAINT [FK_VamcDivision_DaylightSavingsType ] FOREIGN KEY([DaylightSavingsTypeId])
REFERENCES [dbo].[DaylightSavingsType ] ([DaylightSavingsTypeId])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_DaylightSavingsType ]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] CHECK CONSTRAINT [FK_VamcDivision_DaylightSavingsType ]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_AntibodyScreenDisplay]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision]  WITH CHECK ADD  CONSTRAINT [FK_VamcDivision_AntibodyScreenDisplay] FOREIGN KEY([AntibodyScreenDisplayCode])
REFERENCES [dbo].[AntibodyScreenDisplay] ([AntibodyScreenDisplayCode])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_AntibodyScreenDisplay]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] CHECK CONSTRAINT [FK_VamcDivision_AntibodyScreenDisplay]
GO


--Task 499503 -Removal of DaylightSavingsStartDate and DaylightSavingsEndDate column

ALTER TABLE dbo.VamcDivision DROP COLUMN DaylightSavingsStartDate
ALTER TABLE dbo.VamcDivision DROP COLUMN DaylightSavingsEndDate

USE @DBNAME@_MIRROR
GO

/************************************************************************************************************************************/

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VamcDivision]') AND name = N'IX_VamcDivision')
DROP INDEX [IX_VamcDivision] ON [dbo].[VamcDivision] WITH ( ONLINE = OFF )
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VamcDivision]') AND name = N'PK_VamcDivision')
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [PK_VamcDivision]
GO

ALTER TABLE [dbo].[VamcDivision] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[VamcDivision] ADD CONSTRAINT [PK_VamcDivision] PRIMARY KEY NONCLUSTERED ([MirrorId]) ON [PRIMARY]
GO


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VamcDivision]') AND name = N'IX_VamcDivision')
CREATE CLUSTERED INDEX [IX_VamcDivision] ON [dbo].[VamcDivision]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/************************************************************************************************************************************/
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AntibodyParameter]') AND name = N'IX_AntibodyParameter_DivisionCode')
DROP INDEX [IX_AntibodyParameter_DivisionCode] ON [dbo].[AntibodyParameter]
GO

ALTER TABLE [dbo].[AntibodyParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AntibodyParameter]') AND name = N'IX_AntibodyParameter_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_AntibodyParameter_DivisionCode] ON [dbo].[AntibodyParameter]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[AntiseraWorklist] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]') AND name = N'IX_AssociatedInstitution_DivisionCode')
DROP INDEX [IX_AssociatedInstitution_DivisionCode] ON [dbo].[AssociatedInstitution]
GO

ALTER TABLE [dbo].[AssociatedInstitution] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[AssociatedInstitution] ALTER COLUMN InstitutionDivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]') AND name = N'IX_AssociatedInstitution_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_AssociatedInstitution_DivisionCode] ON [dbo].[AssociatedInstitution]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[BloodUnit] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnitAntigen]') AND name = N'IX_BloodUnitAntigen_DivisionCode')
DROP INDEX [IX_BloodUnitAntigen_DivisionCode] ON [dbo].[BloodUnitAntigen]
GO

ALTER TABLE [dbo].[BloodUnitAntigen]ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnitAntigen]') AND name = N'IX_BloodUnitAntigen_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_BloodUnitAntigen_DivisionCode] ON [dbo].[BloodUnitAntigen]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[BloodUnitModification] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO 

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]') AND name = N'IX_BloodUnitTest_DivisionCode')
DROP INDEX [IX_BloodUnitTest_DivisionCode] ON [dbo].[BloodUnitTest]
GO

ALTER TABLE [dbo].[BloodUnitTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]') AND name = N'IX_BloodUnitTest_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_BloodUnitTest_DivisionCode] ON [dbo].[BloodUnitTest]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[CannedComment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ComponentClassParameter]') AND name = N'IX_ComponentClassParameter_DivisionCode')
DROP INDEX [IX_ComponentClassParameter_DivisionCode] ON [dbo].[ComponentClassParameter]
GO

ALTER TABLE [dbo].[ComponentClassParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ComponentClassParameter]') AND name = N'IX_ComponentClassParameter_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_ComponentClassParameter_DivisionCode] ON [dbo].[ComponentClassParameter]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DailyControl]') AND name = N'IX_DailyControl_DivisionCode')
DROP INDEX [IX_DailyControl_DivisionCode] ON [dbo].[DailyControl]
GO

ALTER TABLE [dbo].[DailyControl] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DailyControl]') AND name = N'IX_DailyControl_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_DailyControl_DivisionCode] ON [dbo].[DailyControl]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[DailyQcWorklist] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[Equipment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HcpcsAssignment]') AND name = N'IX_HcpcsAssignment_DivisionCode')
DROP INDEX [IX_HcpcsAssignment_DivisionCode] ON [dbo].[HcpcsAssignment]
GO

ALTER TABLE [dbo].[HcpcsAssignment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HcpcsAssignment]') AND name = N'IX_HcpcsAssignment_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_HcpcsAssignment_DivisionCode] ON [dbo].[HcpcsAssignment]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[IssuedUnitComment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LocalSupplier]') AND name = N'IX_LocalSupplier_DivisionCode')
DROP INDEX [IX_LocalSupplier_DivisionCode] ON [dbo].[LocalSupplier]
GO

ALTER TABLE [dbo].[LocalSupplier] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LocalSupplier]') AND name = N'IX_LocalSupplier_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_LocalSupplier_DivisionCode] ON [dbo].[LocalSupplier]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[LoginMessage] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Msbos]') AND name = N'IX_Msbos_DivisionCode')
DROP INDEX [IX_Msbos_DivisionCode] ON [dbo].[Msbos]
GO

ALTER TABLE [dbo].[Msbos] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Msbos]') AND name = N'IX_Msbos_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_Msbos_DivisionCode] ON [dbo].[Msbos]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[OrderedComponent] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[OrderedTest] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[OrderedUnit]') AND name = N'IX_OrderedUnit_DivisionCode')
DROP INDEX [IX_OrderedUnit_DivisionCode] ON [dbo].[OrderedUnit]
GO

ALTER TABLE [dbo].[OrderedUnit] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[OrderedUnit]') AND name = N'IX_OrderedUnit_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_OrderedUnit_DivisionCode] ON [dbo].[OrderedUnit]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[PatientOrder] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

ALTER TABLE [dbo].[PatientOrder] ALTER COLUMN InstitutionDivisionCode VARCHAR(50)  NULL
GO

ALTER TABLE [dbo].[PatientSpecialInstruction] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientSpecimen]') AND name = N'IX_PatientSpecimen_DivisionCode')
DROP INDEX [IX_PatientSpecimen_DivisionCode] ON [dbo].[PatientSpecimen]
GO

ALTER TABLE [dbo].[PatientSpecimen] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientSpecimen]') AND name = N'IX_PatientSpecimen_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_PatientSpecimen_DivisionCode] ON [dbo].[PatientSpecimen]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[PatientTest] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientTransfusion]') AND name = N'IX_PatientTransfusion_DivisionCode')
DROP INDEX [IX_PatientTransfusion_DivisionCode] ON [dbo].[PatientTransfusion]
GO

ALTER TABLE [dbo].[PatientTransfusion] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientTransfusion]') AND name = N'IX_PatientTransfusion_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_PatientTransfusion_DivisionCode] ON [dbo].[PatientTransfusion]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

ALTER TABLE [dbo].[PatientTransfusionComment] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

ALTER TABLE [dbo].[PatientTransfusionReaction] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[PendingSpecimenTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProductModificationParameter]') AND name = N'IX_ProductModificationParameter_DivisionCode')
DROP INDEX [IX_ProductModificationParameter_DivisionCode] ON [dbo].[ProductModificationParameter]
GO

ALTER TABLE [dbo].[ProductModificationParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProductModificationParameter]') AND name = N'IX_ProductModificationParameter_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_ProductModificationParameter_DivisionCode] ON [dbo].[ProductModificationParameter]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProductShipper]') AND name = N'IX_ProductShipper_DivisionCode')
DROP INDEX [IX_ProductShipper_DivisionCode] ON [dbo].[ProductShipper]
GO

ALTER TABLE [dbo].[ProductShipper] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProductShipper]') AND name = N'IX_ProductShipper_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_ProductShipper_DivisionCode] ON [dbo].[ProductShipper]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Rack] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[RackLot] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[RackTest] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

ALTER TABLE [dbo].[Reagent] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReagentTestParameter]') AND name = N'IX_ReagentTestParameter_DivisionCode')
DROP INDEX [IX_ReagentTestParameter_DivisionCode] ON [dbo].[ReagentTestParameter]
GO

ALTER TABLE [dbo].[ReagentTestParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReagentTestParameter]') AND name = N'IX_ReagentTestParameter_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_ReagentTestParameter_DivisionCode] ON [dbo].[ReagentTestParameter]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReagentTypeParameter]') AND name = N'IX_ReagentTypeParameter_DivisionCode')
DROP INDEX [IX_ReagentTypeParameter_DivisionCode] ON [dbo].[ReagentTypeParameter]
GO

ALTER TABLE [dbo].[ReagentTypeParameter] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReagentTypeParameter]') AND name = N'IX_ReagentTypeParameter_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_ReagentTypeParameter_DivisionCode] ON [dbo].[ReagentTypeParameter]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Shipment] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]') AND name = N'IX_PatientTransfusionRequirement_CreateDivisionCode')
DROP INDEX [IX_PatientTransfusionRequirement_CreateDivisionCode] ON [dbo].[PatientTransfusionRequirement]
GO

ALTER TABLE [dbo].[PatientTransfusionRequirement] ALTER COLUMN CreateDivisionCode VARCHAR(50)  NULL
GO

ALTER TABLE [dbo].[PatientTransfusionRequirement] ALTER COLUMN InactivateDivisionCode VARCHAR(50)  NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]') AND name = N'IX_PatientTransfusionRequirement_CreateDivisionCode')
CREATE NONCLUSTERED INDEX [IX_PatientTransfusionRequirement_CreateDivisionCode] ON [dbo].[PatientTransfusionRequirement]
(
	[CreateDivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Reagent] ALTER COLUMN DivisionCode VARCHAR(50)  NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SpecimenTest]') AND name = N'IX_SpecimenTest_DivisionCode')
DROP INDEX [IX_SpecimenTest_DivisionCode] ON [dbo].[SpecimenTest]
GO

ALTER TABLE [dbo].[SpecimenTest] ALTER COLUMN DivisionCode VARCHAR(50) NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SpecimenTest]') AND name = N'IX_SpecimenTest_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_SpecimenTest_DivisionCode] ON [dbo].[SpecimenTest]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SpecimenTestThreshold]') AND name = N'IX_SpecimenTestThreshold_DivisionCode')
DROP INDEX [IX_SpecimenTestThreshold_DivisionCode] ON [dbo].[SpecimenTestThreshold]
GO

ALTER TABLE [dbo].[SpecimenTestThreshold] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SpecimenTestThreshold]') AND name = N'IX_SpecimenTestThreshold_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_SpecimenTestThreshold_DivisionCode] ON [dbo].[SpecimenTestThreshold]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Supply] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WorkloadProcess]') AND name = N'IX_WorkloadProcess_DivisionCode')
DROP INDEX [IX_WorkloadProcess_DivisionCode] ON [dbo].[WorkloadProcess]
GO

ALTER TABLE [dbo].[WorkloadProcess] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WorkloadProcess]') AND name = N'IX_WorkloadProcess_DivisionCode')
CREATE NONCLUSTERED INDEX [IX_WorkloadProcess_DivisionCode] ON [dbo].[WorkloadProcess]
(
	[DivisionCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO


IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'PK_VbecsUserDivisionRole')
ALTER TABLE [dbo].[VbecsUserDivisionRole] DROP CONSTRAINT [PK_VbecsUserDivisionRole]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'IX_VbecsUserDivisionRole_MirrorDate')
DROP INDEX [IX_VbecsUserDivisionRole_MirrorDate] ON [dbo].[VbecsUserDivisionRole]
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'IX_VbecsUserDivisionRole')
DROP INDEX [IX_VbecsUserDivisionRole] ON [dbo].[VbecsUserDivisionRole] WITH ( ONLINE = OFF )
GO

ALTER TABLE [dbo].[VbecsUserDivisionRole] ALTER COLUMN DivisionCode VARCHAR(50)  NOT NULL
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'PK_VbecsUserDivisionRole')
ALTER TABLE [dbo].[VbecsUserDivisionRole] ADD  CONSTRAINT [PK_VbecsUserDivisionRole] PRIMARY KEY NONCLUSTERED 
(
	[MirrorId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'IX_VbecsUserDivisionRole_MirrorDate')
CREATE NONCLUSTERED INDEX [IX_VbecsUserDivisionRole_MirrorDate] ON [dbo].[VbecsUserDivisionRole]
(
	[MirrorDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]') AND name = N'IX_VbecsUserDivisionRole')
CREATE CLUSTERED INDEX [IX_VbecsUserDivisionRole] ON [dbo].[VbecsUserDivisionRole]
(
	[VbecsUserId] ASC,
	[DivisionCode] ASC,
	[UserRoleId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
GO


--Task 499503 -Removal of DaylightSavingsStartDate and DaylightSavingsEndDate column

ALTER TABLE dbo.VamcDivision DROP COLUMN DaylightSavingsStartDate
ALTER TABLE dbo.VamcDivision DROP COLUMN DaylightSavingsEndDate

/*---------------------------------------------------------
  Create the VamcDivision view in the Mirror database
  (now that both mirror/non-mirror are updated)
---------------------------------------------------------*/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_VamcDivision]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.V_VamcDivision
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****************************************************************************************************************************************************************
**	Name: 	V_VamcDivision
**
**	Desc: 	Returns data in VamcDivision table (main and mirror) (Defect 340457).
**
**	Author:	Kwame Adu-Poku
**
**	Date: 	09/19/2016
**
******************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------	---------	------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	04/12/17	K. Adu-Poku	 Removed DaylightSavingsStartDate and DaylightSavingsEndDate (Task 499503).
**	04/30/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************************************************************/

CREATE VIEW V_VamcDivision
AS 
SELECT Source='MIRROR', MirrorId, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, ReactivityPhaseCode, RecordStatusCode, LabelPrinterEndPointId, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, MirrorDate
FROM dbo.VamcDivision
UNION ALL 
SELECT Source='ACTIVE', 0, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, ReactivityPhaseCode, RecordStatusCode, LabelPrinterEndPointId, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, LastUpdateDate AS MirrorDate 
FROM Syn_VamcDivision
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

--Permissions

GRANT SELECT ON dbo.V_VamcDivision TO VbecsAppMirrorUser
GO



USE @DBNAME@
GO


/************************************Stored Procedures***************************/          

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetComponentTaskList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetComponentTaskList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7UpdateOrderedTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7UpdateOrderedTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTreatingSpecialtyList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTreatingSpecialtyList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTestResultsWithErrorForTask]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTestResultsWithErrorForTask]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentByGuid]
GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPendingPatientMerges]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPendingPatientMerges]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInvalidateTransfusionReactionWorkup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInvalidateTransfusionReactionWorkup]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertPatientTransfusionReaction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertPatientTransfusionReaction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7GetXMBySpecimenUIDAndUnitID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7GetXMBySpecimenUIDAndUnitID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRacks]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRacks]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRackQCTestingWorklistCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRackQCTestingWorklistCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRackQCTestingWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRackQCTestingWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetHospitalLocationCache]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetHospitalLocationCache]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentMaintenance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentMaintenance]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetConfigureDailyQCByGUID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetConfigureDailyQCByGUID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitByUnitIdProduct]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitByUnitIdProduct]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitByGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitAssignedPatients]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitAssignedPatients]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitAntigens]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitAntigens]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodProductByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodProductByGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodProductByCode]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodProductByCode]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodAvailabilityPatientCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodAvailabilityPatientCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodAvailabilityItems]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodAvailabilityItems]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditWorkload]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditWorkload]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditVistALinkControl]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditVistALinkControl]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditUserRole]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditUserRole]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditUserAlerts]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditUserAlerts]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditUser]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditUser]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditTransfusionEffectiveness]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditTransfusionEffectiveness]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditTransfusionComplications]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditTransfusionComplications]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditTR]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditTR]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditSpecimenTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditSpecimenTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditSI]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditSI]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditReagentTypeParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditReagentTypeParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditReagentTestParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditReagentTestParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditProductShipper]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditProductShipper]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditProductModificationParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditProductModificationParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditMsbosComponentClass]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditMsbosComponentClass]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditMsbos]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditMsbos]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditLocalSupplier]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditLocalSupplier]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditInterfaceControl]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditInterfaceControl]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditInappropriateRequestIndicators]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditInappropriateRequestIndicators]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditHcpcs]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditHcpcs]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditDailyControl]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditDailyControl]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditConfigureTesting]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditConfigureTesting]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditComponentClass]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditComponentClass]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodUnitTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodUnitStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitModification]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodUnitModification]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitMedia]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodUnitMedia]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitFinance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodUnitFinance]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitAntigen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodUnitAntigen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodProduct]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditBloodProduct]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditAssociatedInstitution]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditAssociatedInstitution]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditAntibody]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAuditAntibody]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAssociatedInstitutionByDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAssociatedInstitutionByDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraWorklistUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistTypingDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraWorklistTypingDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistsPartiallyCompleted]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraWorklistsPartiallyCompleted]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistQCResults]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraWorklistQCResults]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistQCControls]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraWorklistQCControls]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraWorklistDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraWorklistByGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraOrderedTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntiseraOrderedTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntigenTypingTestsForUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntigenTypingTestsForUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntigenTypingForConsistencyCheck]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntigenTypingForConsistencyCheck]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntibodyTypeLookupList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntibodyTypeLookupList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntibodyParameterByID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntibodyParameterByID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntibodiesWithoutAntigens]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAntibodiesWithoutAntigens]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAllAntigensForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAllAntigensForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsTransfused]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAdminReportBloodUnitsTransfused]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsShipped]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAdminReportBloodUnitsShipped]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsReceived]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAdminReportBloodUnitsReceived]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsOutdated]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAdminReportBloodUnitsOutdated]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsModifiedPrepared]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAdminReportBloodUnitsModifiedPrepared]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsDiscarded]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAdminReportBloodUnitsDiscarded]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetActiveOrLocalBloodProductsByCode]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetActiveOrLocalBloodProductsByCode]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAboRhTestHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAboRhTestHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAboRhForConsistencyCheck]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAboRhForConsistencyCheck]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAboRHConfirmationTestsForUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetAboRHConfirmationTestsForUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spFinalizePatientTransfusionReaction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spFinalizePatientTransfusionReaction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spDeleteVbecsLock]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spDeleteVbecsLock]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spCrossmatchResultCodesForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spCrossmatchResultCodesForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spCreateOutgoingInvoice]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spCreateOutgoingInvoice]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spConfirmOutgoingShipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spConfirmOutgoingShipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spCheckIsAlreadyCrossMatched]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spCheckIsAlreadyCrossMatched]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spBloodProductSearch]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spBloodProductSearch]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[batchspRunMarkUnitsPresumedTransfused]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[batchspRunMarkUnitsPresumedTransfused]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[batchspRunExpireTestOrders]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[batchspRunExpireTestOrders]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[batchspRunExpireComponentOrders]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[batchspRunExpireComponentOrders]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitsForUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitsForUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitsForRepeatXM]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitsForRepeatXM]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitsForPatientSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitsForPatientSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitsForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitsForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitRecordHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitRecordHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitByPatientAndUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitByPatientAndUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitByGUID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitByGUID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnitByComponent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnitByComponent]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedTestsforSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedTestsforSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderedComponent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderedComponent]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderDataTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderDataTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderData]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderData]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOffsiteABID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOffsiteABID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetNewOrdersCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetNewOrdersCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetNewOrderedTestsWithNoRequiredSpecimenOrSpecimenOnFile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetNewOrderedTestsWithNoRequiredSpecimenOrSpecimenOnFile]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetNewOrderedTestsForRequiredTimeFrame]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetNewOrderedTestsForRequiredTimeFrame]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetNewOrderedTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetNewOrderedTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetNewOrderedComponentsWithNoRequiredSpecimenOrSpecimenOnFile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetNewOrderedComponentsWithNoRequiredSpecimenOrSpecimenOnFile]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetNewOrderedComponentsForRequiredTimeFrame]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetNewOrderedComponentsForRequiredTimeFrame]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetNewOrderedComponents]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetNewOrderedComponents]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetMsbosComponents]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetMsbosComponents]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetModifiedBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetModifiedBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetModifiedBloodUnitChildren]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetModifiedBloodUnitChildren]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetModifiableBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetModifiableBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetMedicalDirectors]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetMedicalDirectors]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetManufacturerReagentNames]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetManufacturerReagentNames]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetLocalSuppliersForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetLocalSuppliersForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetLocalSupplierLookupList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetLocalSupplierLookupList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetLocalSupplierByICCBARegistrationNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetLocalSupplierByICCBARegistrationNumber]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetLocalSupplierByFdaRegistrationNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetLocalSupplierByFdaRegistrationNumber]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetLimitedBloodUnitsByDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetLimitedBloodUnitsByDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetLimitedBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetLimitedBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetLabTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetLabTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIssueToLocationList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIssueToLocationList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIssuedUnitsList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIssuedUnitsList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIssuedUnitsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIssuedUnitsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIssuedUnitFromGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIssuedUnitFromGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIssuedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIssuedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIssuedAndTransfusedUnitsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIssuedAndTransfusedUnitsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetInvoiceText]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetInvoiceText]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIncomingShipmentsList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIncomingShipmentsList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetIncomingShipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetIncomingShipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetInappropriateTransfusionRequests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetInappropriateTransfusionRequests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetInappropriateTransfusionRequestReportCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetInappropriateTransfusionRequestReportCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetInactivatedUnitsList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetInactivatedUnitsList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetImplicatedUnitsForPatientTransfusionReaction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetImplicatedUnitsForPatientTransfusionReaction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetHistoricalOrderedUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetHistoricalOrderedUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetHcpcsAssignmentHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetHcpcsAssignmentHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetFinancialBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetFinancialBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExistingReagentTypes]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExistingReagentTypes]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSupplyForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitSupplyForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSupply]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitSupply]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSelectionForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitSelectionForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSelectionForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitSelectionForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSelection]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitSelection]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitModificationForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitModificationForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitModification]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitModification]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitIssueForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitIssueForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitIssue]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitIssue]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitAboRhForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitAboRhForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitAboRh]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportUnitAboRh]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTrwSpecimenForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportTrwSpecimenForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTrwSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportTrwSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionReactionWorkupForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportTransfusionReactionWorkupForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionReactionWorkup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportTransfusionReactionWorkup]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportTransfusionForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportTransfusionForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportTransfusion]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportSpecimenForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportSpecimenForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReturnIssuedUnitForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportReturnIssuedUnitForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReturnIssuedUnitForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportReturnIssuedUnitForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReturnIssuedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportReturnIssuedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportRemoveFinalUnitStatusForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportRemoveFinalUnitStatusForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportRemoveFinalUnitStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportRemoveFinalUnitStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReflexTestForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportReflexTestForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReflexTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportReflexTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQuarantineForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQuarantineForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQuarantineForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQuarantineForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQuarantine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQuarantine]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcNotPerformedForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQcNotPerformedForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcNotPerformed]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQcNotPerformed]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQCInactivated]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQCInactivated]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQcForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQcForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTestInactivatedForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientTestInactivatedForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTestInactivated]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientTestInactivated]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTestForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientTestForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientRestrictionForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientRestrictionForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientRestriction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientRestriction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAntigenDiscrepancyForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientAntigenDiscrepancyForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAntigenDiscrepancy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientAntigenDiscrepancy]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRhForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientAboRhForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRHDiscrepancyForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientAboRHDiscrepancyForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRHDiscrepancy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientAboRHDiscrepancy]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRh]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportPatientAboRh]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportLabelMismatchForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportLabelMismatchForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportLabelMismatch]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportLabelMismatch]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportInconclusiveCrossmatch]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportInconclusiveCrossmatch]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportExpiredUnitReceivedForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportExpiredUnitReceivedForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportExpiredUnitReceived]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportExpiredUnitReceived]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportExpiredTask]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportExpiredTask]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueUnitTestForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueUnitTestForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueUnitTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueUnitTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueOrderForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueOrderForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueOrder]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueOrder]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportElectronicTransfusion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportElectronicTransfusion]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportCautionTagBtrfForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportCautionTagBtrfForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportCautionTagBTRF]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportCautionTagBTRF]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAntigenTestInvalidatedForBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportAntigenTestInvalidatedForBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAntigenTestInvalidated]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportAntigenTestInvalidated]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAboIncompatibleTransfusionForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportAboIncompatibleTransfusionForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAboIncompatibleTransfusion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetExceptionReportAboIncompatibleTransfusion]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentTypes]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentTypes]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentRecordForReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentRecordForReport]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentManufacturers]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentManufacturers]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentMaintenanceTypes]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentMaintenanceTypes]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentMaintenanceForEquipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentMaintenanceForEquipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentMaintenanceByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentMaintenanceByGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentBySerialNumberAndManufacturer]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentBySerialNumberAndManufacturer]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentByGUID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipmentByGUID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEquipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEligibleUnitsForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetEligibleUnitsForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDssExtract]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDssExtract]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionWorkloadReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDivisionWorkloadReport]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionTimeZoneAbbreviation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDivisionTimeZoneAbbreviation]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionTimeZone]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDivisionTimeZone]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionCurrentDateTime]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDivisionCurrentDateTime]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDiscardOrQuarantineUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDiscardOrQuarantineUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDiscardOrQuarantineData]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDiscardOrQuarantineData]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDiscardedUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDiscardedUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyQCReagentTypes]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDailyQCReagentTypes]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyQCRacks]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDailyQCRacks]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyControlRack]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDailyControlRack]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyControl]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetDailyControl]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCurrentCrossmatchResults]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCurrentCrossmatchResults]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCrossmatchedUnitsInDateRangeCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCrossmatchedUnitsInDateRangeCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCrossmatchedUnitsInDateRange]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCrossmatchedUnitsInDateRange]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetConfigureReagentQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetConfigureReagentQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetConfigurableRackQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetConfigurableRackQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetComponentClass]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetComponentClass]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompletedPatientTransfusionReactions]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCompletedPatientTransfusionReactions]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleWholeBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCompatibleWholeBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatiblePlateletBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCompatiblePlateletBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleOtherBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCompatibleOtherBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleNonWholeBloodNonPlasmaUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCompatibleNonWholeBloodNonPlasmaUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleFFPUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCompatibleFFPUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleCryoUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCompatibleCryoUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCannedComments]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCannedComments]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCannedComment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetCannedComment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBoodUnitTestResultsForTransfusionReaction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBoodUnitTestResultsForTransfusionReaction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitWrkLst]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitWrkLst]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForOrderedTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestResultsForOrderedTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForOrderedComponent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestResultsForOrderedComponent]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestResultsForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForAntiseraWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestResultsForAntiseraWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResults]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestResults]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResult]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestResult]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestingWorklistCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestingWorklistCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestingWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitTestingWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitStatusByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitStatusByGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsInPool]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsInPool]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsInFinalStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsInFinalStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsForHistoryReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsForHistoryReport]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsForEdit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsForEdit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsEligibleForCrossover]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsEligibleForCrossover]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByUnitId]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsByUnitId]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByPatientAndComponentClassID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsByPatientAndComponentClassID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsByPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByIdAndProduct]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsByIdAndProduct]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByAntiBodyTypeId]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitsByAntiBodyTypeId]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitOriginalShipper]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitOriginalShipper]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitModificationsForChildUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitModificationsForChildUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitModificationsByUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitModificationsByUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitMediaByUnitGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitMediaByUnitGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitGUID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitGUID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitFinancialData]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitFinancialData]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitFinanceByUnitGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitFinanceByUnitGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitDetailsFromBloodUnitShipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodUnitDetailsFromBloodUnitShipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertEquipmentMaintenance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertEquipmentMaintenance]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertEquipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertEquipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertDailyQcWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertDailyQcWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertDailyControl]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertDailyControl]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertComponentClassParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertComponentClassParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertCannedComment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertCannedComment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertBloodUnitTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertBloodUnitTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertBloodUnitStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertBloodUnitStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertBloodUnitModification]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertBloodUnitModification]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertBloodUnitMedia]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertBloodUnitMedia]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertBloodUnitAntigen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertBloodUnitAntigen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertAssociatedInstitution]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertAssociatedInstitution]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertAntiseraWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertAntiseraWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInactivateOrderedTestResults]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInactivateOrderedTestResults]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInactivateBloodUnitAntigen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInactivateBloodUnitAntigen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInactivateAntigenTypingTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInactivateAntigenTypingTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInactivateAboRHConfirmationTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInactivateAboRHConfirmationTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7UpdatePatientTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7UpdatePatientTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7UpdatePatientOrder]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7UpdatePatientOrder]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7UpdatePatientLocation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7UpdatePatientLocation]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7UpdateOrderedComponent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7UpdateOrderedComponent]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7InsertPendingSpecimenTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7InsertPendingSpecimenTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7InsertPendingBloodUnitTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7InsertPendingBloodUnitTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7InsertPatientLocation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7InsertPatientLocation]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7GetPendingSpecimenTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7GetPendingSpecimenTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7GetPendingBloodUnitTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7GetPendingBloodUnitTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spHL7GetOrderedTestBySpecimenUIDAndTestName]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spHL7GetOrderedTestBySpecimenUIDAndTestName]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetXMBloodUnitsBySpecimenUIDAndUnitID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetXMBloodUnitsBySpecimenUIDAndUnitID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetWorkloadProcessGuidByVbecsProcessID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetWorkloadProcessGuidByVbecsProcessID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetVbecsWorkLoadForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetVbecsWorkLoadForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetVbecsUsersWithRoleInGivenDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetVbecsUsersWithRoleInGivenDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetVbecsUsersActiveForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetVbecsUsersActiveForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetVbecsLock]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetVbecsLock]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetUnitModifications]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetUnitModifications]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionRequirementsReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionRequirementsReport]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionReport]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionRelatedInformation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionRelatedInformation]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionReactionsForPatientCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionReactionsForPatientCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionReactionsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionReactionsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionReactionImplicatedUnitsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionReactionImplicatedUnitsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionHistoryForPatientSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionHistoryForPatientSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusionHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusionHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusedUnitsInDateRangeCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusedUnitsInDateRangeCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusedUnitsInDateRange]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusedUnitsInDateRange]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTransfusedUnitsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTransfusedUnitsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTestResultsForTask]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTestResultsForTask]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTestResultsForSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTestResultsForSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTestResults]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTestResults]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTestResult]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTestResult]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTestOrders]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTestOrders]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTestingTaskList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTestingTaskList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetTargetProducts]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetTargetProducts]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSupplyNameList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSupplyNameList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSupplyManufacturerList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSupplyManufacturerList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSupplyInventoryReportData]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSupplyInventoryReportData]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSupplyByInvoiceLotNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSupplyByInvoiceLotNumber]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSupplyByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSupplyByGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSupplies]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSupplies]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenTestThresholds]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenTestThresholds]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenTestResultsForTransfusionReaction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenTestResultsForTransfusionReaction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenTestResultsForOrderedTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenTestResultsForOrderedTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenTestRecordHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenTestRecordHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimensForPatientCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimensForPatientCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimensForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimensForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenSearchDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenSearchDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimenByGUID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimenByGUID]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetSpecialInstructionsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetSpecialInstructionsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetShipmentsWithAvailableUnitsFromPastFiveDays]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetShipmentsWithAvailableUnitsFromPastFiveDays]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetShipmentInvoiceCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetShipmentInvoiceCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetShipmentByUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetShipmentByUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetShipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetShipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportTransfusionReactionCountSummaryMultidivisional]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportTransfusionReactionCountSummaryMultidivisional]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportTransfusionReactionCountSummary]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportTransfusionReactionCountSummary]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportTransfusionReactionCountDetailsMultidivisional]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportTransfusionReactionCountDetailsMultidivisional]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportTransfusionReactionCountDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportTransfusionReactionCountDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportSingleOrderTestHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportSingleOrderTestHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportSingleOrderComponentHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportSingleOrderComponentHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportPatientTransfusionReaction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportPatientTransfusionReaction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportMultiOrderHistoryCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportMultiOrderHistoryCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportMultiOrderHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportMultiOrderHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportIssuedReturnedUnitCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportIssuedReturnedUnitCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportIssuedReturnedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportIssuedReturnedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitTransfusionHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitTransfusionHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitTestingHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitTestingHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitTargetModificationSummary]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitTargetModificationSummary]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitStatusHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitStatusHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitSourceModificationSummary]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitSourceModificationSummary]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitPoolModificationHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitPoolModificationHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitPatientAssociationHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitPatientAssociationHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitOutgoingShipmentHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitOutgoingShipmentHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitModificationSummary]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitModificationSummary]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitModificationHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitModificationHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitIssueHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitIssueHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitIncomingShipmentHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitIncomingShipmentHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitHistorySummary]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitHistorySummary]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitHistoryRecordCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitHistoryRecordCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitFinanceHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitFinanceHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitDirectedPatientHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitDirectedPatientHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitCrossmatchTestingHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitCrossmatchTestingHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReportBloodUnitAnitgenTypingHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReportBloodUnitAnitgenTypingHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReimbursementPercentage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReimbursementPercentage]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReflexTestsForOrder]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReflexTestsForOrder]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentTestOrdersForPatientCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentTestOrdersForPatientCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentTestOrdersForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentTestOrdersForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentPatientAboRhHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentPatientAboRhHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentlyUpdatedPatients]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentlyUpdatedPatients]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentlyUpdatedPatientDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentlyUpdatedPatientDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentlyIssuedAndTransfusedUnitsForPatientCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentlyIssuedAndTransfusedUnitsForPatientCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentlyIssuedAndTransfusedUnitsForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentlyIssuedAndTransfusedUnitsForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentlyDeceasedPatients]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentlyDeceasedPatients]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentlyDeceasedPatientDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentlyDeceasedPatientDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentInvoicesForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentInvoicesForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentComponentOrdersForPatientCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentComponentOrdersForPatientCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRecentComponentOrdersForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRecentComponentOrdersForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentTypeStockLevel]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentTypeStockLevel]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentTestResult]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentTestResult]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentsForInvoice]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentsForInvoice]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentsByType]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentsByType]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagents]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagents]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentQCTestingWorklistCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentQCTestingWorklistCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentQCTestingWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentQCTestingWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentPreviousAntigenTypingPhases]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentPreviousAntigenTypingPhases]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentManufacturers]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentManufacturers]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentLotsFromPreviousTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentLotsFromPreviousTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentLotsForRetest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentLotsForRetest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetReagentFromRack]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetReagentFromRack]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRackTestResult]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRackTestResult]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRackTestDate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRackTestDate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetRack]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetRack]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetQCResultsForOrderedTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetQCResultsForOrderedTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetProlongedTransfusionTimeReportCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetProlongedTransfusionTimeReportCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetProlongedTransfusionTimeReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetProlongedTransfusionTimeReport]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetProductShippersByDivisionLookUpList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetProductShippersByDivisionLookUpList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetProductShippersByDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetProductShippersByDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetProductShipperByLocalSupplierDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetProductShipperByLocalSupplierDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetProductModifications]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetProductModifications]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPreviousRackTestResult]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPreviousRackTestResult]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPooledBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPooledBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPoolCounter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPoolCounter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPhysicianList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPhysicianList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPhenotypeUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPhenotypeUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPendingSpecimenTestsCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPendingSpecimenTestsCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPendingSpecimenTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPendingSpecimenTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPendingPatientMergesDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPendingPatientMergesDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPendingBloodUnitXMTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPendingBloodUnitXMTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPendingBloodUnitTestsCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPendingBloodUnitTestsCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPendingBloodUnitTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPendingBloodUnitTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionRequirements]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionRequirements]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionRequirementRecordHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionRequirementRecordHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionRecords]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionRecords]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionRecordHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionRecordHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionRecord]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionRecord]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionReactionSymptoms]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionReactionSymptoms]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionReactionRecordHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionReactionRecordHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionReactionComment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionReactionComment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionReaction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionReaction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTransfusionGuidsForDssExtract]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTransfusionGuidsForDssExtract]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTestOrdersAll]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTestOrdersAll]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTestingWorklistCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTestingWorklistCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTestingWorklistByDates]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTestingWorklistByDates]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientTestingWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientTestingWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientsWithPendingSpecimenTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientsWithPendingSpecimenTests]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientSpecimenRecordHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientSpecimenRecordHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientSpecialInstructionRecordHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientSpecialInstructionRecordHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientRecordReportCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientRecordReportCount]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientOrder]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientOrder]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientDemographicHistoryForPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientDemographicHistoryForPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientComponentOrdersAll]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientComponentOrdersAll]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientAboRHHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientAboRHHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPatientAboHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPatientAboHistory]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetPartiallyCompletedQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetPartiallyCompletedQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOutgoingShipmentsList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOutgoingShipmentsList]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOutgoingInvoiceByGuid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOutgoingInvoiceByGuid]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOutgoingInvoice]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOutgoingInvoice]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOutgoingBloodUnitShipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOutgoingBloodUnitShipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetOrderSearchDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetOrderSearchDetails]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spVistaGetXmlBloodBankData]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spVistaGetXmlBloodBankData]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spValidSpecimenExists]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spValidSpecimenExists]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateWorkLoadProcess]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateWorkLoadProcess]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateVbecsUserDivisionRole]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateVbecsUserDivisionRole]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateVamcDivisionBase]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateVamcDivisionBase]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateTransfusionRequirements]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateTransfusionRequirements]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateSupplyUsage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateSupplyUsage]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateSpecimenTestStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateSpecimenTestStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateSpecimenTestForPatientTesting]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateSpecimenTestForPatientTesting]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateSpecialInstructions]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateSpecialInstructions]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateRackTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateRackTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateRackLot]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateRackLot]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateRackDailyUse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateRackDailyUse]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateQuarantineStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateQuarantineStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateProductModifications]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateProductModifications]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdatePatientTransfusionRecord]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdatePatientTransfusionRecord]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdatePatientTransfusionReactionStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdatePatientTransfusionReactionStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdatePatientTransfusionReactionPartialSaveId]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdatePatientTransfusionReactionPartialSaveId]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdatePatientTransfusionComment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdatePatientTransfusionComment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdatePatientSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdatePatientSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateOrderedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateOrderedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateMsbos]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateMsbos]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateMergeToPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateMergeToPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateMergeFromPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateMergeFromPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateLabTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateLabTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateIssuedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateIssuedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateInvoiceText]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateInvoiceText]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateHcpcsAssignment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateHcpcsAssignment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateEquipmentMaintenance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateEquipmentMaintenance]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateEquipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateEquipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateDiscardStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateDiscardStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateDailyQcWorklist]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateDailyQcWorklist]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateDailyControl]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateDailyControl]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateCrossmatchTestStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateCrossmatchTestStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateConfigureReagentQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateConfigureReagentQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateConfigurableRackQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateConfigurableRackQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateComponentClassParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateComponentClassParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateBloodUnitTestResult]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateBloodUnitTestResult]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateBloodUnitTestRecordStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateBloodUnitTestRecordStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateBloodUnitStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateBloodUnitStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateBloodUnitShipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateBloodUnitShipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateBloodUnitModification]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateBloodUnitModification]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateBloodUnitMedia]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateBloodUnitMedia]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateBloodUnitAntigen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateBloodUnitAntigen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateAssociatedInstitution]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateAssociatedInstitution]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spUpdateAntibodyTypes]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spUpdateAntibodyTypes]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedVbecsUserFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedVbecsUserFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedVbecsUserDivisionRoleFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedVbecsUserDivisionRoleFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedReagentTestParameterFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedReagentTestParameterFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedRackFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedRackFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedProductModParameterFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedProductModParameterFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedMSBOSFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedMSBOSFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedComponentClassParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedComponentClassParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedCannedCommentFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedCannedCommentFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedAntibodyParameterFromTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedAntibodyParameterFromTemplate]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spSeedAllDayOneTemplatesForDivision]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spSeedAllDayOneTemplatesForDivision]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spRestoreRestriction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spRestoreRestriction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spReleaseRestriction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spReleaseRestriction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spReleaseOrderedUnitsByBloodUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spReleaseOrderedUnitsByBloodUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spReleaseOrderedUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spReleaseOrderedUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spPatientSearch]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spPatientSearch]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spPatientOrderAlertPrint]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spPatientOrderAlertPrint]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spOutGoingInvoiceReport2]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spOutGoingInvoiceReport2]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsValidFdaRegistrationNumber]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsValidFdaRegistrationNumber]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsTransfusionHistoryforPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsTransfusionHistoryforPatient]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsSpecimenAssociatedWithDiagnosticTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsSpecimenAssociatedWithDiagnosticTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsPendingSpecimenTestLocked]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsPendingSpecimenTestLocked]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsPendingBloodUnitTestLocked]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsPendingBloodUnitTestLocked]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsOrderedTestPending]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsOrderedTestPending]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsOrderedComponentPending]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsOrderedComponentPending]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsLocalSupplierOnActiveBloodUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsLocalSupplierOnActiveBloodUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsLocalSupplierActiveByIccbbaRegNum]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsLocalSupplierActiveByIccbbaRegNum]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsBloodUnitNotInFinalStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsBloodUnitNotInFinalStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsBloodProductOnActiveUnits]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsBloodProductOnActiveUnits]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spIsBloodProductActive]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spIsBloodProductActive]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertWorkLoadProcess]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertWorkLoadProcess]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertWorkloadEvents]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertWorkloadEvents]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertVbecsUserDivisionRole]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertVbecsUserDivisionRole]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertVbecsLock]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertVbecsLock]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertVamcDivisionBase]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertVamcDivisionBase]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertTransfusionRequirements]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertTransfusionRequirements]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertSupply]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertSupply]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertSpecimenTestThreshold]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertSpecimenTestThreshold]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertSpecimenTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertSpecimenTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertSpecialInstructions]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertSpecialInstructions]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertShipment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertShipment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertReagentTypeParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertReagentTypeParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertReagentTestParameter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertReagentTestParameter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertReagent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertReagent]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertRackTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertRackTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertRackLot]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertRackLot]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertProductShipper]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertProductShipper]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertPoolCounter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertPoolCounter]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertPatientTransfusionComment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertPatientTransfusionComment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertPatientTransfusion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertPatientTransfusion]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertPatientSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertPatientSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertPatientOrder]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertPatientOrder]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertOrderedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertOrderedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertOrderedTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertOrderedTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertMsbos]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertMsbos]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertLocalSupplier]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertLocalSupplier]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertIssuedUnitComment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertIssuedUnitComment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertIssuedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertIssuedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertHcpcsAssignment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertHcpcsAssignment]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionUnitSelection]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionUnitSelection]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionUnitModification]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionUnitModification]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionUnitIssue]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionUnitIssue]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionUnitAboRH]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionUnitAboRH]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionTrwSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionTrwSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionTransfusionReactionWorkup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionTransfusionReactionWorkup]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionSpecimen]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionSpecimen]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionReturnIssuedUnit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionReturnIssuedUnit]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionRemoveFinalUnitStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionRemoveFinalUnitStatus]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionReflexTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionReflexTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionQuarantine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionQuarantine]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionQCNotPerformed]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionQCNotPerformed]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionQCInactivated]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionQCInactivated]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionQC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionQC]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionPatientTestInactivated]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionPatientTestInactivated]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionPatientTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionPatientTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionPatientRestriction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionPatientRestriction]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionPatientAntigenDiscrepancy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionPatientAntigenDiscrepancy]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionPatientAboRHDiscrepancy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionPatientAboRHDiscrepancy]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionPatientAboRH]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionPatientAboRH]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionLabelMismatch]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionLabelMismatch]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionInconclusiveCrossmatch]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionInconclusiveCrossmatch]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionExpiredUnitReceived]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionExpiredUnitReceived]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionExpiredTask]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionExpiredTask]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionEmergencyIssueUnitTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionEmergencyIssueUnitTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionEmergencyIssueOrder]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionEmergencyIssueOrder]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionElectronicTransfusion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionElectronicTransfusion]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionCautionTagBTRF]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionCautionTagBTRF]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionAntigenTest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionAntigenTest]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertExceptionAboIncompatibleTransfusion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertExceptionAboIncompatibleTransfusion]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spInsertHospitalLocationCache]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spInsertHospitalLocationCache]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spVistaUpdateWorkloadEventData]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spVistaUpdateWorkloadEventData]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spVistaGetXmlTransfusionReactionHistory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spVistaGetXmlTransfusionReactionHistory]
GO



SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[batchspRunExpireComponentOrders]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

/*******************************************************************************************************************************************************************************
**	Desc: 	R.E. BR_16.16 Author 3.2.4.5.2
**		Script that will determine all orders that will be expired.
**		This script will lock all the orders, call background job that marks Task Status Code of
**		 Component Order as ''E''-Expired and unlock records after the update is done.  
**
**	Author: Margaret Jablonski
**
**	Date: 	07/21/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	TODO: Change PO.OrderReceivedDatetime to new column for order acceptance date in part 2
**	02/08/2005	Stas Antropov	Changed BACKGROUNDJOB user name to VBECS
**	04/19/2005	Dan McHugh	Removed cursor logic, consolidated with batchspExpireComponentOrders
**	04/21/2005	Stas Antropov	Removed debug print statements, added division code to locking
**	06/29/2005	Dan McHugh	Added OrderStatusCode, OrderedComponentComments to UPDATE of table OrderedComponent, added dbo prefix to objects
**	07/25/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Removed name, input/output from comment header, Added NOCOUNT OFF, Specified table owners, spaced out SQL,
**					Placed TRANSACTIONS in areas that do actual Inserts/Updates/Deletes and gave Transactions names to clarify
**	09/29/2005	D McHugh	CR1194 - Updated check for SpecimenRequiredIndicator to use COALESCE
**					Updated check on TaskStatusCode to include comparing against NULL
**					Reformatted WHERE clause for easier reading
**	12/06/2005	Lohse		Adding SessionGuid required parameter for spInsertLock
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	11/10/2009	K.Dobranowski	Fixed the inintial SELECT to take only Accepted orders, replaced OrderedReceivedDate with OrderAcceptanceDate, simplified  WHERE clause
**					in the first SELECT statement (CR 2368)
**	08/15/2011	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	03/12/2013	Lohse		Updated to use new spInsertVbecsLock and spDeleteVbecsLock sprocs, updated ID to 996
**	11/01/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/20/2014	Lohse	CR 3409 - adding LockInactivityTimeoOutMin parameter needed by spInsertVbecsLock, updated logic to continue after error/rollback
**	03/28/2014	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[batchspRunExpireComponentOrders]

AS

SET NOCOUNT ON

DECLARE 

	@orderedComponentGuid 	UNIQUEIDENTIFIER,
	@divisionCode 			VARCHAR(50),
	@message 			VARCHAR(80),
	@lastError			INT,
	@expiredOrdersCount		INT,
	@currentOrderedComponentId 	INT,
	@sessionguid			UNIQUEIDENTIFIER,
	@lockfunctionid			INT,
	@fakeformid				INT,
	@lockinactivitytimeoutmin	INT


DECLARE @ExpiredOrders TABLE 
(	

	[Id] 			INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
	OrderedComponentGuid 	UNIQUEIDENTIFIER,
	DivisionCode 		VARCHAR(50) 

);

	SET @lockfunctionid = 996
	SET @fakeformid = -996
	SET @sessionguid = NEWID()
		
	INSERT INTO @ExpiredOrders( OrderedComponentGuid, DivisionCode )

		SELECT 

			OC.OrderedComponentGuid,
			OC.DivisionCode

		FROM 

			dbo.OrderedComponent OC

			JOIN dbo.PatientOrder PO ON PO.PatientOrderGUID = OC.PatientOrderGUID

			LEFT JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OC.PatientSpecimenGUID

		WHERE 

			OC.OrderStatusCode = ''A'' AND
			(OC.TaskStatusCode != ''E'' OR OC.TaskStatusCode IS NULL) AND

			(

			/*If there is no specimen the expiration date is 10 days from AcceptanceDate*/
			(PS.SpecimenExpirationDate IS NULL AND
			GETUTCDATE() > DATEADD(DAY, 10, OC.OrderAcceptanceDate))

			OR

			/*If specimen exists the expiration date of the order is the same as expiration date of associated specimen*/
			(PS.SpecimenExpirationDate IS NOT NULL AND
			PS.SpecimenExpirationDate < GETUTCDATE())

			)	
	
	SELECT @expiredOrdersCount = @@ROWCOUNT, @lastError = @@ERROR 

	IF @lastError <> 0 

		BEGIN 
	
			RETURN @lastError 
	
		END

	SET @currentOrderedComponentId = 1
	
/*=========================================================> B E G I N  L O O P  <=====================================================*/
	WHILE @currentOrderedComponentId <= @expiredOrdersCount

	BEGIN

		
	
			
				SELECT	@orderedComponentGuid = tmpTable.OrderedComponentGuid,
						@divisionCode = tmpTable.DivisionCode,
						@lockinactivitytimeoutmin = LockInactivityTimeoutMin
		
				FROM	@ExpiredOrders tmpTable
				JOIN	dbo.VamcDivision ON VamcDivision.DivisionCode = tmpTable.DivisionCode
		
				WHERE	[Id] = @currentOrderedComponentId

		
	BEGIN TRANSACTION Comp



				EXECUTE @lastError =  dbo.spInsertVbecsLock @orderedComponentGuid, null, @fakeformid, @fakeformid, @lockfunctionid, ''VBECS'', @lockfunctionid, @lockinactivitytimeoutmin, @divisionCode, @sessionguid, 0

				SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)
			
				IF @lastError <> 0 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
	/*	=============================  THE LOCK HAS BEEN PLACED NOW DO THE UPDATE ==========================================================*/
	
				
	
				UPDATE 
			
					dbo.OrderedComponent
			
				SET 
					OrderStatusCode = ''X'',
					OrderedComponentComments = ''Canceled by background job'',
					TaskStatusCode = ''E'',
					LastUpdateDate = GETUTCDATE(),
					LastUpdateUser = ''VBECS''	
			
				FROM 
			
					dbo.OrderedComponent
			
					JOIN
						@ExpiredOrders ExpOrders ON ExpOrders.OrderedComponentGuid = dbo.OrderedComponent.OrderedComponentGuid
				
					JOIN
				
						dbo.VbecsLock ON dbo.VbecsLock.LockedRecordGuid = dbo.OrderedComponent.OrderedComponentGuid 
				
						          AND SessionGuid = @sessionguid
			
				WHERE ExpOrders.OrderedComponentGuid = @orderedComponentGuid AND SessionGuid = @sessionguid
			
				SET @lastError = @@ROWCOUNT + @@ERROR
			
				IF @lastError <> 1 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord 
			
					END
		
	
	/*	========================================= UPDATE COMPLETED =========================================================================*/
	
	/*	========================================= RELEASE THE LOCK  =========================================================================*/
	
				EXECUTE @lastError = dbo.spDeleteVbecsLock @orderedComponentGuid, null, @fakeformid, @lockfunctionid, ''VBECS'', NULL, @divisioncode, @sessionguid, @fakeformid
			
				SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)
			
				IF @lastError <> 0 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
				
				ELSE
		
			/* All of our actions have NOT resulted in an error - so commit the transaction:  */
		
					BEGIN
			
						COMMIT TRANSACTION Comp
			
					END
	/*	========================================= LOCK RELEASE  COMPLETED ==================================================================*/
ContinueWithNextRecord:				
				/* Increment @currentOrderedComponentId  by one until <= @expiredOrdersCount : */
				SET @currentOrderedComponentId = @currentOrderedComponentId + 1;
	
	END


/*=========================================================> END  L O O P  <=====================================================*/

	

SET NOCOUNT OFF

RETURN(@lastError)

' 
END
GO

GRANT EXECUTE ON [dbo].[batchspRunExpireComponentOrders] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[batchspRunExpireTestOrders]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

/*******************************************************************************************************************************************************************************
**	Desc:  This sp is used to expire TAS orders, it is part of Expire Orders background job
**
**	Author: Krzysztof Dobranowski
**
**	Date: 	11/10/2009
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	11/10/2009	K.Dobranowski	Initial creation (CR 2368)
**	08/15/2011	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	03/12/2013	Lohse			Updated to use new spInsertVbecsLock and spDeleteVbecsLock sprocs, set LockFunctionId = 995
**	11/01/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/20/2014	Lohse		CR 3409 - adding LockInactivityTimeoOutMin parameter needed by spInsertVbecsLock,, updated logic to continue after error/rollback
**	03/28/2014	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/01/2016	K. Dobranowski	Added status of ''A'' (Pending Review from Auto Instrument) to the check so that orders that have pending results are not marked as expired (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[batchspRunExpireTestOrders]

AS

SET NOCOUNT ON

DECLARE 

	@orderedTestGuid	 	UNIQUEIDENTIFIER,
	@divisionCode 			VARCHAR(50),
	@message 			VARCHAR(80),
	@lastError			INT,
	@expiredOrdersCount		INT,
	@currentOrderedTestId 		INT,
	@sessionguid			UNIQUEIDENTIFIER,
	@lockfunctionid			INT,
	@fakeformid				INT,
	@lockinactivitytimeoutmin INT

DECLARE @ExpiredOrders TABLE 
(	

	[Id] 			INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
	OrderedTestGuid 	UNIQUEIDENTIFIER,
	DivisionCode 		VARCHAR(50) 

);

	SET @lockfunctionid = 995
	SET @fakeformid = -995
	SET @sessionguid = NEWID()
		
	INSERT INTO @ExpiredOrders( OrderedTestGuid, DivisionCode )

		SELECT 

			OT.OrderedTestGuid,
			OT.DivisionCode

		FROM 

			dbo.OrderedTest OT

			JOIN dbo.PatientOrder PO ON PO.PatientOrderGUID = OT.PatientOrderGUID

			LEFT JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID

		WHERE 

			OT.OrderStatusCode = ''A'' AND
			((OT.TaskStatusCode != ''E'' AND OT.TaskStatusCode != ''A'') OR OT.TaskStatusCode IS NULL) AND
			OT.OrderableTestId = 7 AND

			(

			/*If there is no specimen the expiration date is 10 days from AcceptanceDate*/
			(PS.SpecimenExpirationDate IS NULL AND
			GETUTCDATE() > DATEADD(DAY, 10, OT.OrderAcceptanceDate))

			OR

			/*If specimen exists the expiration date of the order is the same as expiration date of associated specimen*/
			(PS.SpecimenExpirationDate IS NOT NULL AND
			PS.SpecimenExpirationDate < GETUTCDATE())

			)	
	
	SELECT @expiredOrdersCount = @@ROWCOUNT, @lastError = @@ERROR 

	IF @lastError <> 0 

		BEGIN 
	
			RETURN @lastError 
	
		END

	SET @currentOrderedTestId = 1
	
/*=========================================================> B E G I N  L O O P  <=====================================================*/
	WHILE @currentOrderedTestId <= @expiredOrdersCount

	BEGIN

		
	
			
				SELECT	@orderedTestGuid = tmpTable.OrderedTestGuid,
						@divisionCode = tmpTable.DivisionCode,
						@lockinactivitytimeoutmin = LockInactivityTimeoutMin
		
				FROM	@ExpiredOrders tmpTable
				JOIN	dbo.VamcDivision ON VamcDivision.DivisionCode = tmpTable.DivisionCode
		
				WHERE	[Id] = @currentOrderedTestId

		
	BEGIN TRANSACTION Comp



				EXECUTE @lastError =  dbo.spInsertVbecsLock @orderedTestGuid, null, @fakeformid, @fakeformid, @lockfunctionid, ''VBECS'', @lockfunctionid, @lockinactivitytimeoutmin, @divisionCode, @sessionguid,0

				SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)
			
				IF @lastError <> 0 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
	/*	=============================  THE LOCK HAS BEEN PLACED NOW DO THE UPDATE ==========================================================*/
	
				
	
				UPDATE 
			
					dbo.OrderedTest
			
				SET 
					OrderStatusCode = ''X'',
					OrderedTestComments = ''Canceled by background job'',
					TaskStatusCode = ''E'',
					LastUpdateDate = GETUTCDATE(),
					LastUpdateUser = ''VBECS''	
			
				FROM 
			
					dbo.OrderedTest
			
					JOIN
						@ExpiredOrders ExpOrders ON ExpOrders.OrderedTestGuid = dbo.OrderedTest.OrderedTestGuid
				
					JOIN
				
						dbo.VbecsLock ON dbo.VbecsLock.LockedRecordGuid = dbo.OrderedTest.OrderedTestGuid 
				
						          AND SessionGuid = @sessionguid
			
				WHERE ExpOrders.OrderedTestGuid = @orderedTestGuid AND SessionGuid = @sessionguid
			
				SET @lastError = @@ROWCOUNT + @@ERROR
			
				IF @lastError <> 1 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
		
	
	/*	========================================= UPDATE COMPLETED =========================================================================*/
	
	/*	========================================= RELEASE THE LOCK  =========================================================================*/
	
				EXECUTE @lastError = dbo.spDeleteVbecsLock @orderedTestGuid, null, @fakeformid, @lockfunctionid, ''VBECS'', NULL, @divisioncode, @sessionguid, @fakeformid
			
				SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)
			
				IF @lastError <> 0 
			
					BEGIN 
			
						ROLLBACK TRANSACTION Comp
						GOTO ContinueWithNextRecord
			
					END
				
				ELSE
		
			/* All of our actions have NOT resulted in an error - so commit the transaction:  */
		
					BEGIN
			
						COMMIT TRANSACTION Comp
			
					END
	/*	========================================= LOCK RELEASE  COMPLETED ==================================================================*/
ContinueWithNextRecord:
				/* Increment @currentOrderedTestId  by one until <= @expiredOrdersCount : */
				SET @currentOrderedTestId = @currentOrderedTestId + 1;
	
	END


/*=========================================================> END  L O O P  <=====================================================*/

	

SET NOCOUNT OFF

RETURN(@lastError)

' 
END
GO

GRANT EXECUTE ON [dbo].[batchspRunExpireTestOrders] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[batchspRunMarkUnitsPresumedTransfused]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Background job that marks units as presumed transfused
**		if transfusion or bedside verification info was not returned
**		to the blood bank within 48 hours.
**		Based on BR_69.01
**
**	Author: Margaret Jablonski
**
**	Date: 	07/01/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	----------	------------	-----------------------------------------------------------------------------------------------------------------
**	08/27/04	M.Jablonski	Added UnitStatusCode = ''T to SET statement (per Krzys)
**	12/03/04	C. Taylor	Rewrote sproc to insert ''blank'' PatientTransfusion record
**	02/08/2005	S. Antropov	Changed BACKGROUNDJOB user name to VBECS, removed commented out code. 
**	04/20/2005	D. McHugh	Added locking
**	04/21/2005	S. Antropov 	Minor variable renamings
**	06/03/2005	C. Taylor	Removed UnitStatusCode update
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, spaced out SQL,
**					Placed TRANSACTIONS in areas that do actual Inserts/Updates/Deletes and gave Transactions names to clarify
**	08/26/2005	N.Paterson	Added ,'''',@divisionCode  to the end of the call to sp_DeleteLock as divisioncode is required.
**	12/06/2005	Lohse		Adding SessionGuid  parameter to spInsertlock call
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	02/21/2006	Lohse		Adding default to the sessionguid
**	03/23/2006	Lohse		CR1741 - The PatientTransufion record should contain the Volume of the Unit being marked, adding code to save and load
**	01/04/2010	M. Smith	Checked UnitStatusCode on the BloodUnitStatusCodeCurrent table for issued units. (CR 1174)
**	01/21/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/12/2013	Lohse		Updated to use spInsertVbecsLock and spDeleteVbecsLock. Set LockFuctionId to 994
**	11/01/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/20/2014	Lohse	CR 3409 - adding LockInactivityTimeoOutMin parameter needed by spInsertVbecsLock, updated logic to continue after error/rollback
**	03/28/2014	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[batchspRunMarkUnitsPresumedTransfused]

AS

SET NOCOUNT ON

DECLARE 

	@bloodUnitStatusGuid 			UNIQUEIDENTIFIER,
	@bloodUnitGuid				UNIQUEIDENTIFIER,
	@divisionCode				VARCHAR(50),
	@issuedDateTime			DATETIME,
	@patientGuid				UNIQUEIDENTIFIER,
	@lastError				INT,
	@presumedTransfusedOrderCount 	INT,
	@sessionguid				UNIQUEIDENTIFIER,
	@originalvolume				DECIMAL,
	@lockfunctionid				INT,
	@fakeformid					INT,
	@lockinactivitytimeoutmin	INT

	DECLARE @PresumedTransfusedOrders TABLE
			( 

			[Id] 			INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
			BloodUnitStatusGuid 	UNIQUEIDENTIFIER,
			BloodUnitGuid 		UNIQUEIDENTIFIER,
			DivisionCode 		VARCHAR(50),
			IssueDateTime 		DATETIME,
			PatientGuid 		UNIQUEIDENTIFIER,
			OriginalVolume 		DECIMAL

			);	

	SET @lockfunctionid = 994
	SET @fakeformid = -994
	SET @sessionguid = newid()

	INSERT INTO @PresumedTransfusedOrders
	(
			BloodUnitStatusGuid,
			BloodUnitGuid,
			DivisionCode,
			IssueDateTime,
			PatientGuid,
			OriginalVolume
	)	
	SELECT 
			BUS.BloodUnitStatusGuid,
			BU.BloodUnitGuid,
			BU.DivisionCode,
			IU.IssueDateTime,
			PT.PatientGuid,
			BU.OriginalVolume
	FROM	
			dbo.IssuedUnit IU

	JOIN 	dbo.BloodUnit BU ON IU.BloodUnitGuid = BU.BloodUnitGuid

	JOIN	dbo.BloodUnitStatus BUS ON BU.BloodUnitGUID = BUS.BloodUnitGUID

	JOIN	dbo.BloodUnitStatusCodeCurrent BUSCC ON BU.BloodUnitGUID = BUSCC.BloodUnitGUID

	JOIN	dbo.OrderedUnit OU ON IU.BloodUnitGUID = OU.BloodUnitGUID AND OU.ReleaseDate IS NULL AND OU.RecordStatusCode = ''A''

	JOIN	dbo.OrderedComponent OC ON OU.OrderedComponentGUID = OC.OrderedComponentGUID

	JOIN	dbo.PatientOrder PO ON OC.PatientOrderGUID = PO.PatientOrderGUID

	JOIN	dbo.PatientTreatment PT ON PO.PatientTreatmentGUID = PT.PatientTreatmentGUID

	WHERE
			BUSCC.UnitStatusCode = ''I'' AND

			BU.RecordStatusCode NOT IN (''E'', ''X'') AND

			IU.ReturnDateTime IS NULL AND

			GETUTCDATE() > DATEADD(HOUR, 48, IU.IssueDateTime)

	ORDER BY BloodUnitStatusGuid;


	SELECT @lastError = @@ERROR, @presumedTransfusedOrderCount = @@ROWCOUNT

	IF @lastError <> 0 

			BEGIN 
	
				RETURN @lastError 
	
			END

	DECLARE @currentPresumedTransfusedOrderId INT;
	SET @currentPresumedTransfusedOrderId = 1;

/*===================>>>>  START OF WHILE LOOP <<<<===========================*/

	WHILE @currentPresumedTransfusedOrderId <= @presumedTransfusedOrderCount

	BEGIN


				
		SELECT	@bloodUnitStatusGuid = tmpTable.BloodUnitStatusGuid, 
				@bloodUnitGuid = tmpTable.BloodUnitGuid, 
				@divisionCode = tmpTable.DivisionCode, 
				@issuedDateTime = tmpTable.IssueDateTime, 
				@patientGuid = tmpTable.PatientGuid,
				@originalvolume = tmpTable.OriginalVolume,
				@lockinactivitytimeoutmin = LockInactivityTimeoutMin

		FROM	@PresumedTransfusedOrders tmpTable
		JOIN	dbo.VamcDivision ON VamcDivision.DivisionCode = tmpTable.DivisionCode

		WHERE 	[Id] = @currentPresumedTransfusedOrderId;



		BEGIN TRANSACTION UpdBUS


		EXECUTE @lastError =  dbo.spInsertVbecsLock @bloodUnitStatusGuid, null, @fakeformid, @fakeformid, @lockfunctionid, ''VBECS'', @lockfunctionid, @lockinactivitytimeoutmin, @divisionCode, @sessionguid, 0

		SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)
/*###########################################################################################################################*/	
		--If the record failed to get the lock, spInsertLock will return non-0
		IF @lastError = 0
/*###########################################################################################################################*/
			BEGIN
				
	
				UPDATE	
					dbo.BloodUnitStatus
				SET
					PresumedTransfusedIndicator = 1,
					LastUpdateDate = GETUTCDATE(),
					LastUpdateUser = ''VBECS'',
					LastUpdateFunctionId = 998
				WHERE
					BloodUnitStatusGuid = @bloodUnitStatusGuid		
				
				SELECT @lastError = @@ROWCOUNT + @@ERROR

					IF @lastError <> 1 
		
						BEGIN 
			
							ROLLBACK TRANSACTION  UpdBUS
							GOTO ContinueWithNextRecord 
			
						END

	
				INSERT INTO

					dbo.PatientTransfusion
				(
					PatientTransfusionGuid,
					PatientGuid,
					BloodUnitGuid,
					TransfusionStartDateTime,
					TransfusionEndDateTime,
					ReactionIndicator,
					OtherDifficultyIndicator,
					TransfusedVolume,
					DivisionCode,
					LastUpdateDate,
					LastUpdateUser,
					LastUpdateFunctionId
				)
				VALUES
				(
					NEWID(),
					@patientGuid,
					@bloodUnitGuid,
					@issuedDateTime,
					@issuedDateTime,
					0,
					0,
					@originalvolume,
					@divisionCode,
					GETUTCDATE(),
					''VBECS'',
					998
				)
	
				SELECT @lastError = @@ROWCOUNT + @@ERROR 
				IF @lastError <> 1 
	
					BEGIN 
	
						ROLLBACK TRANSACTION UpdBUS
						GOTO ContinueWithNextRecord
	
					END
	
		
				EXECUTE @lastError = dbo.spDeleteVbecsLock @bloodUnitStatusGuid, null, @fakeformid, @lockfunctionid, ''VBECS'', NULL, @divisioncode, @sessionguid, @fakeformid
			
				SELECT @lastError = COALESCE(NULLIF(@lastError, 0), @@ERROR)		
		
				IF @lastError <> 0 
	
					BEGIN 
	
						ROLLBACK TRANSACTION UpdBUS
						GOTO ContinueWithNextRecord 
					END

				ELSE

				-- ALL OF OUR ACTIONS HAVE NOT RESULTED IN ANY ERRORS, COMMIT THE LOCK/UNLOCK, UPDATE/INSERT

					BEGIN
						COMMIT TRANSACTION  UpdBUS
					END
			END

/*###########################################################################################################################*/
	--An Error Occurred at INSERT LOCK:

		ELSE

/*###########################################################################################################################*/
			BEGIN
					ROLLBACK TRANSACTION UpdBUS
					GOTO ContinueWithNextRecord 
			END

/*=========================>>>>  END  OF WHILE LOOP <<<<===========================*/
ContinueWithNextRecord:

		SET @currentPresumedTransfusedOrderId = @currentPresumedTransfusedOrderId + 1;
	END	

SET NOCOUNT OFF

RETURN(@lastError)
' 
END
GO

GRANT EXECUTE ON [dbo].[batchspRunMarkUnitsPresumedTransfused] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spBloodProductSearch]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Name: 	spBloodProductSearch
**
**	Author:	Cameron Taylor
**	Date: 	8/28/2002
**
**	Modified:
**	Date		Name		Description
**	---------------	---------		-----------------
**	5/20/2003	Greg Lohse	The Mapped SchemaType employed causes this to error because of the LEFT JOIN.
**                                                            	Re-wrote the SQL to fit the program. :)    -- put the original at the bottom
**                                                            	Also added the hcpcs code
**	7/30/2003	Greg Lohse	Hcpcs code is now coming from HcpcsAssignment table
**	12/2/2003	Lohse		Added RecordStatusCode to WHERE clause to only include valid producttypes
**	03/01/2004	M.Jablonski	Added row version to SELECT
**	03/25/2005	Lohse		Added fnIsProductActive to replace DSP table drop
**	07/19/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL,
					Added @ERROR variable, placed input parameters in brackets
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spBloodProductSearch]
(
	@productname		VARCHAR(175),
	@producttypecode	CHAR(4),
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	IF @productname <> ''''
	
		BEGIN
		
			SET @productname = ''%'' + @productname + ''%''
		
			SELECT  

				BP.BloodProductGUID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator 					AS BarcodeType,

				dbo.fnIsProductActive(BP.BloodProductGuid, @divisioncode) 	AS ProductActiveIndicator,

				HA.HcpcsCode

			FROM  

				dbo.BloodProduct BP

			INNER JOIN 

				dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode

				AND PT.ProductTypeCode = @producttypecode

			LEFT OUTER JOIN	dbo.HcpcsAssignment HA

				ON BP.BloodProductGuid = HA.BloodProductGUID

			AND	HA.UnAssignedDate IS NULL

			AND	HA.DivisionCode = @divisioncode
		
			WHERE	

				BP.ProductName LIKE @productname

			AND	BP.RecordStatusCode = ''A''

			ORDER BY BP.ProductName

			SET @ERROR = @@ERROR
		
		END

	ELSE 

		BEGIN

			SELECT  

				BP.BloodProductGUID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator 					AS BarcodeType,

				dbo.fnIsProductActive(BP.BloodProductGuid, @divisioncode) 	AS ProductActiveIndicator,

				HA.HcpcsCode

			FROM  

				dbo.BloodProduct BP
		
			INNER JOIN 

				dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode

				AND PT.ProductTypeCode = @producttypecode

			LEFT OUTER JOIN	dbo.HcpcsAssignment HA

				ON BP.BloodProductGuid = HA.BloodProductGUID

			AND	HA.UnAssignedDate IS NULL

			AND	HA.DivisionCode = @divisioncode

			WHERE

				BP.RecordStatusCode = ''A''

			ORDER BY 

				BP.ProductName

			SET @ERROR = @@ERROR

		END

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spBloodProductSearch] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spCheckIsAlreadyCrossMatched]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Returns  any matching records and if any records are returned then the given blood unit is already crossmatched
**
**	Author:	Carrie Van Stedum
**
**	Date: 	07/07/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	10/27/2003	C. Jensen	Removed "and BUM.DirectedPatientGUID = @patientguid"  A unit doesn''t have to be directed to be
**					assigned to a patient.
**	01/27/2004	C. Jensen	Added joins so that only current patient is retrieved.
**	06/07/2004	C. Taylor	Replaced PatientGuid clause with fnWherePatientGuid function, to include possible merged patients
**	02/04/2005	C. Jensen	Added check for NULL on ReleaseDate
**	07/19/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT OFF, formatted SQL
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/            
CREATE PROCEDURE [dbo].[spCheckIsAlreadyCrossMatched]
(
    @bloodunitguid 	UNIQUEIDENTIFIER,
    @divisioncode   	VARCHAR(50),
    @patientguid 		UNIQUEIDENTIFIER
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
	
	SELECT 

		OrderedUnitGUID, 
		OU.BloodUnitGUID, 
		DirectedPatientGUID, 
		PT.PatientGUID

	FROM 

		dbo.OrderedUnit OU

		INNER JOIN dbo.BloodUnitMedia BUM ON OU.BloodUnitGUID = BUM.BloodUnitGUID

		JOIN dbo.OrderedComponent OC ON OU.OrderedComponentGUID = OC.OrderedComponentGUID

		JOIN dbo.PatientOrder PO ON OC.PatientOrderGUID = PO.PatientOrderGUID

		JOIN dbo.PatientTreatment PT ON PO.PatientTreatmentGUID = PT.PatientTreatmentGUID

	WHERE 

		OU.BloodUnitGuid = @bloodunitguid 

	AND 	OU.RecordStatusCode = ''A''

	AND 	OU.ReleaseDate IS NULL

	AND	PT.PatientGUID IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	AND 	OU.DivisionCode = @divisioncode

	AND 	OU.CrossmatchDate IS NOT NULL

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spCheckIsAlreadyCrossMatched] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spConfirmOutgoingShipment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Confirms an outgoing shipment, plugging in the shipment date
**
**	Author:	John Vrooland
**
**	Date: 	10/24/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		-----------------
** 	07-23-03    	JHV         	Modified to address new reqts.
**  	08-20-03    	JHV         	Removed RecordStatusCode
**	01/30/2004	M.Jablonski	Added 3 row versions 
**	02/03/2004	Greg Lohse	Adding LastUpdateFunctionId
**	02/12/2004	C. Jensen	Temporarily commented out RowVersion because it''s not working.
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	10/11/2004	C. Van Stedum	Made changes to get outgoingshipmentguid from bloodunitshipment table instead of bloodunitfinance
**	12/17/2004	R Heiberger	Removed the bloodunitrowversion and statusrowversion. Moved the update bloodunit and update
**					bloodunitstatus commands to seperate stored procedures respectively.
**	1/24/2005	R Heiberger	Added last update date.
**	07/19/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified table owner
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spConfirmOutgoingShipment]
(
		@shipmentguid 		UNIQUEIDENTIFIER,
		@shipmentdate 		DATETIME,
		@lastupdateuser 	VARCHAR(30),
		@lastupdatefunctionid	INT,
		@divisioncode		VARCHAR(50),
		@rowversion		TIMESTAMP,
		@lastupdatedate	DateTime	
)
AS
	SET NOCOUNT ON
	
	DECLARE @ERROR		INT
	DECLARE @ROWCOUNT	INT
	

		UPDATE
	
			dbo.Shipment
	
		SET 
	
			ShipmentDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @shipmentdate), 
	
			LastUpdateDate = @lastupdatedate,
	
			LastUpdateUser = @lastupdateuser,
	
			LastUpdateFunctionId = @lastupdatefunctionid
	
		WHERE
	
			ShipmentGUID = @shipmentguid
	
		AND 	[RowVersion]   = @rowversion 

   	SELECT @ERROR = @@ERROR, @ROWCOUNT=@@ROWCOUNT
	

	IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM  dbo.Shipment WHERE [RowVersion] = @rowversion ) <> 1 

		RAISERROR(50001, 16, 127)

	IF @ROWCOUNT <> 1 AND @ERROR=0

		SET @ERROR = -1

SET NOCOUNT OFF

	RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spConfirmOutgoingShipment] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spCreateOutgoingInvoice]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Inserts a new Shipment row, retrieves same
**
**	Author:	John Vrooland
**
**	Date: 	10/24/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		----------		-----------------
**	9/25/2003	C. Jensen	Changed VARCHAR(10) to varchar(14) on the @invoicenumber parameter to reflect the use case and DB.
**	02/03/2004	Greg Lohse	Adding LastUpdateFunctionId
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	05/18/2005 	D. Askew	Changed code to use passed-in @lastupdatedate and split the update from the query
**	07/19/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL,
					Added RowCount check, specified table owner
**	09/26/2005	D. Askew	Added @shipmenttypecode to VALUES section; it was hard-coded as 1
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spCreateOutgoingInvoice]
(
	@shipmentguid		UNIQUEIDENTIFIER,
	@invoicenumber	VARCHAR(14),
	@localsupplierguid	UNIQUEIDENTIFIER,
	@shipmenttypecode	CHAR,
	@divisioncode		VARCHAR(50),
	@lastupdatedate	DATETIME,
	@lastupdateuser	VARCHAR(30),
	@lastupdatefunctionid	INT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE 	@ERROR INT,
		@ROWCOUNT INT

	SET NOCOUNT ON
	
	INSERT INTO dbo.Shipment
	(
		ShipmentGuid, 
		LocalSupplierGuid, 
		InvoiceNumber, 
		ShipmentDirection, 
		ShipmentTypeCode, 
		ShipmentTemperature, 
		DivisionCode, 
		RecordStatusCode, 
		LastUpdateDate, 
		LastUpdateUser, 
		LastUpdateFunctionId 
	)
	VALUES
	( 
		@shipmentguid, 
		@localsupplierguid, 
		@invoicenumber,
		0, 
		@shipmenttypecode, 
		0.0, 
		@divisioncode,
		''A'', 
		@lastupdatedate,
		@lastupdateuser,
		@lastupdatefunctionid 
	)

	SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT

	IF @ROWCOUNT <> 1 RAISERROR( 50003, 16, 1, ''SHIPPING OUTGOING INVOICE'', @rowcount )

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spCreateOutgoingInvoice] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spCrossmatchResultCodesForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets  crossmatch test result codes for a patient.
**
**	Author:	Carl Jensen
**
**	Date: 	06/1/2006
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spCrossmatchResultCodesForPatient]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)

AS
	
DECLARE @ERROR INT

SET @ERROR = 0

	SET NOCOUNT ON
	
	SELECT DISTINCT
		CR.CrossmatchResultCode
		
	FROM 

		SynMirror_V_BloodUnitTest BUT
		
		JOIN dbo.OrderedUnit OU
			ON BUT.OrderedUnitGuid = OU.OrderedUnitGuid
		
		JOIN dbo.OrderedComponent OC 
			ON BUT.OrderedComponentGuid = OC.OrderedComponentGuid 
		
		JOIN dbo.PatientOrder PO 
			ON OC.PatientOrderGUID = PO.PatientOrderGUID
		
		JOIN dbo.PatientTreatment PT 
			ON PO.PatientTreatmentGuid = PT.PatientTreatmentGuid
		
		JOIN dbo.Patient LinkPatient 
			ON PT.PatientGuid = LinkPatient.PatientGuid
		JOIN dbo.Patient P 
			ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)
		
		LEFT OUTER JOIN dbo.CrossMatchResult CR
			ON OU.CrossmatchResultCode = CR.CrossmatchResultCode
		
	WHERE

		BUT.BloodUnitGuid = @bloodunitguid
		AND P.PatientGuid = @patientguid
		AND BUT.RecordStatusCode = ''A''

UNION

--Now get repeat XMs

	SELECT DISTINCT
		CR.CrossmatchResultCode
		
	FROM 

		SynMirror_V_BloodUnitTest BUT
	
		JOIN dbo.OrderedUnit OU
			ON BUT.OrderedUnitGuid = OU.OrderedUnitGuid
		
		JOIN dbo.OrderedTest OT 
			ON BUT.OrderedTestGuid = OT.OrderedTestGuid 
		
		JOIN dbo.PatientOrder PO 
			ON OT.PatientOrderGUID = PO.PatientOrderGUID
		
		JOIN dbo.PatientTreatment PT 
			ON PO.PatientTreatmentGuid = PT.PatientTreatmentGuid
		
		JOIN dbo.Patient LinkPatient 
			ON PT.PatientGuid = LinkPatient.PatientGuid
		JOIN dbo.Patient P 
			ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)
		
		JOIN dbo.CrossMatchResult CR
			ON OU.CrossmatchResultCode = CR.CrossmatchResultCode
		
	WHERE

		BUT.BloodUnitGuid = @bloodunitguid
		AND P.PatientGuid = @patientguid
		AND BUT.RecordStatusCode = ''A''

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spCrossmatchResultCodesForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spDeleteVbecsLock]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/************************************************************************************************************
**	Desc: 	Removes a row from the vbecsLock table
**
**	Author:	Greg Lohse
**
**	Date: 	08/20/2003
**
*************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------	----------		-----------
**	3/12/2013	Lohse			VBECS 2.0 refactor
**	09/12/2013	Lohse			CR3311 - corrections to how DivisionCode is treated in WHERE clauses
								if DivisionCode is NULL, then MultiDivisional must be true, otherwise they must equal
**	10/01/2013	K. Adu-Poku	**	Reviewed for compliance with database standards and recommendations **
**	05/08/2015	Lohse			CR3555 = replaced check (= NULL) with (IS NULL) to utilize ANSI_NULLS ON
**	05/11/2015	K. Adu-Poku	**	Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************/
CREATE PROCEDURE [dbo].[spDeleteVbecsLock]
(
	@lockedrecordguid	UNIQUEIDENTIFIER = NULL,
	@lockedusecaseid	INT = NULL,
	@lockedformid		INT, 
	@lockfunctionid		INT = NULL,
	@lastupdateuser		VARCHAR(30),
	@lastupdatedate		DATETIME = NULL ,
	@divisioncode		VARCHAR(50)  = NULL,
	@sessionguid		UNIQUEIDENTIFIER = NULL,
	@baselockedformid	INT = NULL
)

AS

DECLARE @ERROR INT

SET NOCOUNT ON

	IF (@lockedrecordguid IS NULL)		-- We want to delete all Lock for a UC/Form  ..UnlockAllRecordsForUseCaseUser()

		BEGIN
	
			DELETE FROM
	
				dbo.VBECSLock
	
			WHERE
	
				(LockFunctionID = @lockfunctionid
	
			AND	LockedFormId = @lockedformid 
	
			AND	LastUpdateUser = @lastupdateuser

			AND	((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode))

			AND 	((@sessionguid IS NULL) OR (@sessionguid IS NOT NULL AND SessionGuid = @sessionguid))
			     )

			OR
			(	
					SessionGuid = @sessionguid 
				AND BaseLockedFormId = @baselockedformid 
				AND LastUpdateUser = @lastupdateuser 
				AND ((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode)))

		END



	ELSE 

		BEGIN	
		IF (@lockfunctionid IS NULL)	--@lockfunctionid is missing but @lockedrecordguid has a value
			BEGIN

				DELETE FROM	dbo.VbecsLock
				WHERE
						LockedRecordGUID = @lockedrecordguid
				AND		((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode))
				AND 	((@sessionguid IS NULL) OR (@sessionguid IS NOT NULL AND SessionGuid = @sessionguid))

			END
		ELSE		--LockFunctionId has a value

			BEGIN
			
				DELETE FROM	dbo.VbecsLock
				WHERE
						LockedRecordGUID = @lockedrecordguid
				AND		LockedFormId = @lockedformid
				AND		LockFunctionID = @lockfunctionid
				AND		LastUpdateUser = @lastupdateuser
				AND		((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode))
				AND 	((@sessionguid IS NULL) OR (@sessionguid IS NOT NULL AND SessionGuid = @sessionguid))

			END

		END

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spDeleteVbecsLock] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spFinalizePatientTransfusionReaction]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Update partial save id for PatientTransfusionReaction
**			Used and enter medical director name.
**
**	Author:	Cameron Taylor
**
**	Date: 	10/28/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/19/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spFinalizePatientTransfusionReaction]
(
	@patienttransfusionreactionguid		UNIQUEIDENTIFIER,
	@partialsaveid				TINYINT,
	@medicaldirectorname			VARCHAR(50),
	@transfusionreactiontypecode		CHAR,
	@lastupdateuser			VARCHAR(30),
	@lastupdatefunctionid			INT,
	@rowversion				TIMESTAMP,
	@divisioncode			VARCHAR(50),
	@lastupdatedate			DATETIME
)				

AS

SET NOCOUNT ON

DECLARE @ERROR		INT
DECLARE @ROWCOUNT	INT

	UPDATE

		dbo.PatientTransfusionReaction

	SET

		PartialSaveId = @partialsaveid,

		MedicalDirectorName = @medicaldirectorname,

		TransfusionReactionTypeCode = @transfusionreactiontypecode,

		LastUpdateDate = @lastupdatedate,

		LastUpdateUser = @LastUpdateUser,

		LastUpdateFunctionId = @LastUpdateFunctionId

	WHERE

	 	PatientTransfusionReactionGuid = @patienttransfusionreactionguid

	AND

		[RowVersion] = @RowVersion

	AND

		DivisionCode = @divisioncode

SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT

IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM PatientTransfusionReaction WHERE [RowVersion] = @RowVersion ) <> 1 

	RAISERROR(50001, 16, 127)

ELSE

	IF (@ERROR = 0 AND @ROWCOUNT <> 1)	

		SET @ERROR = -1

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spFinalizePatientTransfusionReaction] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAboRHConfirmationTestsForUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

/*******************************************************************************************************************************************************************************
**	Desc:	Gets a blood unit''s Abo/Rh Confirmation test results
**
**	Author:	Martin Tsotchev
**
**	Date: 	01/28/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT
					Placed rowcount in square brackets, spaced out SQL, place input params in ()
					NOTE: BloodTestTypeID is hardcoded, consider doing a subquery so that if the Test Typevalues change
					this code will not have to be modified.
**	01/15/2016	K.Dobranowski	Modified this sp to allow loading of the automated instrument tests (they don''t have the worklist Guid) (Defect 251282)
**	01/29/2016	K.Dobranowski	Added sorting by unique Guid (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAboRHConfirmationTestsForUnit]
(
		@bloodunitguid		UNIQUEIDENTIFIER,
		@divisioncode		VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BUT.ConfirmationWorklistUnitGUID,
		BUT.BloodUnitTestGUID,
		BUT.BloodUnitGUID,
		BUT.BloodTestTypeID,
		BTT.BloodTestName,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate,

		BUT.TestResultID,
		BUT.TestComments,
		BUT.EntryMethodCode,
		BUT.DivisionCode,
		BUT.[RowVersion],
		TR.TestResultText,
		PBUT.UnitResultSetGuid

	FROM

		dbo.BloodUnitTest BUT

		JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID

		JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		LEFT JOIN dbo.PendingBloodUnitTest PBUT ON BUT.BloodUnitTestGuid = PBUT.BloodUnitTestGuid

	WHERE
		BUT.DivisionCode = @divisioncode

	AND	BUT.BloodUnitGUID = @bloodunitguid

	AND	BUT.RecordStatusCode = ''A''

	AND BUT.BloodTestTypeID IN (15,16,17,18,19,20,21)

	ORDER BY

		ISNULL(PBUT.UnitResultSetGuid, BUT.ConfirmationWorklistUnitGUID) ASC,
		BUT.TestDate DESC
		
	SET @ERROR = @@ERROR

RETURN @ERROR


' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAboRHConfirmationTestsForUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAboRhForConsistencyCheck]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Brings back two DataTables, corresponding to current and tested  ABO + Rh
**
**	Author: 	David Askew
**
**	Date: 	01/24/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, added error handler
					NOTE: BloodTestTypeID is hardcoded, consider doing a subquery so that if the Test Typevalues change
					this code will not have to be modified.
**	08/02/2005	N.Paterson	Commented out first SQL Block because these columns do not allow NULLS
**	08/19/2005	C. Taylor	The above change caused the entire sproc to function incorrectly. Restored the first
							block of code, but removed the ISNULLs from BloodTypeCode and RhFactorText.
**	05/18/2012	Lohse	**SQL 2008 Upgrade**Ln105 - Replaced ORDER BY dbo.BloodUnitTest.LastUpdateDate DESC, dbo.BloodTestType.BloodTestName with ORDER BY LastUpdateDate DESC, BloodTestName
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAboRhForConsistencyCheck]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
	
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT DISTINCT

		dbo.BloodType.BloodTypeCode AS BloodTypeCode,
		dbo.RhFactor.RhFactorText AS RhFactorText

	FROM

		dbo.BloodUnit

		JOIN dbo.BloodUnitMedia ON dbo.BloodUnit.BloodUnitGuid = dbo.BloodUnitMedia.BloodUnitGuid

		JOIN dbo.BloodType ON dbo.BloodUnitMedia.BloodTypeCode = dbo.BloodType.BloodTypeCode

		JOIN dbo.RhFactor ON dbo.BloodUnitMedia.RhFactorCode = dbo.RhFactor.RhFactorCode

	WHERE 	

		dbo.BloodUnit.BloodUnitGuid = @bloodunitguid

		AND dbo.BloodUnit.DivisionCode = @divisioncode

	SET @ERROR = @@ERROR
		IF @ERROR !=0 GOTO ERR_HANDLER




	
	SELECT DISTINCT
		(
			CASE 	WHEN dbo.BloodTestType.BloodTestName LIKE ''%ABO%'' THEN 
					''ABO''
				WHEN dbo.BloodTestType.BloodTestName LIKE ''%Rh%'' THEN 
					''Rh''
			END
		) AS BloodTestName,

		dbo.TestResult.TestResultText,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.BloodUnitTest.LastUpdateDate) AS LastUpdateDate

	FROM

		dbo.BloodUnitTest

		JOIN dbo.BloodTestType 

			ON dbo.BloodUnitTest.BloodTestTypeId = dbo.BloodTestType.BloodTestTypeId

		JOIN dbo.TestResult 

			ON dbo.BloodUnitTest.TestResultId = dbo.TestResult.TestResultId

		JOIN dbo.VBecsUser AS LastUpdateUser 

			ON dbo.BloodUnitTest.LastUpdateUser = LastUpdateUser.VBecsUserId

	WHERE 	

		dbo.BloodUnitTest.BloodUnitGuid = @bloodunitguid

		AND dbo.BloodUnitTest.DivisionCode = @divisioncode

		AND dbo.BloodUnitTest.BloodTestTypeId IN (18, 21, 25, 65, 68, 105, 106, 118, 121, 125)

		AND dbo.BloodUnitTest.RecordStatusCode = ''A''
	
	ORDER BY LastUpdateDate DESC, BloodTestName

	SET @ERROR = @@ERROR
		IF @ERROR !=0 GOTO ERR_HANDLER


SET NOCOUNT OFF

	RETURN (0)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAboRhForConsistencyCheck] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAboRhTestHistory]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Returns Abo/Rh tests associated with a patient
**
**	Author: Krzysztof Dobranowski
**
**	Date: 	01/28/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, aliased tables
**	08/02/2005	NPaterson	Replaced PatientGuid clause with fnWherePatientGuid function, to include possible merged patients
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	04/22/2006	Lohse		Swapped DateTime Convserion on @testdate to improve performance
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAboRhTestHistory]

(
	@patientguid		UNIQUEIDENTIFIER,
	@testdate		DATETIME,
	@divisioncode		VARCHAR(50)
)

AS

SET	@testdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @testdate)

SET NOCOUNT ON
-- Patient Testing from SpecimenTest

	SELECT 

		ST.TestResultId,
		ST.BloodTestTypeId,
		BT.BloodTestName
		
	FROM	dbo.SpecimenTest ST
	
	JOIN	dbo.PatientSpecimen PS ON 

		PS.PatientSpecimenGuid = ST.PatientSpecimenGuid --AND PS.PatientGuid = @patientguid

	JOIN dbo.BloodTestType BT ON 

		BT.BloodTestTypeId = ST.BloodTestTypeId
	
	WHERE ST.TestDate < @testdate

		AND ST.BloodTestTypeId IN (18,21,65,68)

	AND	PS.PatientGUID IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	
	ORDER  BY ST.TestDate DESC, ST.BloodTestTypeId

SET NOCOUNT OFF

RETURN
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAboRhTestHistory] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetActiveOrLocalBloodProductsByCode]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Search BloodProduct table for matching entry, searches local or national products (CR 2210)
**
**	Author:	David Askew
**
**	Date: 	04/10/2007
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------		---------			------------------
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetActiveOrLocalBloodProductsByCode]
(
	@productcode 	VARCHAR (5),
	@divisioncode 	VARCHAR(50)
)
--
AS
--
DECLARE @ERROR INT

SET NOCOUNT ON
	
	SELECT
		BP.BloodProductGUID,
		PT.ComponentClassID,
		CC.ComponentClassName,
		BP.ProductCode,
		BP.ProductShortName,
		BP.ProductName,
		BP.ProductTypeCode,
		PT.ProductTypeName,
		BP.ProductVolume,
		BP.MaximumStorageTime,
		BP.ProductCodeIndicator 					AS BarcodeType,
		dbo.fnIsProductActive(BP.BloodProductGuid, @divisioncode) 	AS ProductActiveIndicator,
		ISNULL(HA.HcpcsCode,'''') 					AS HcpcsCode,
		BP.ProductAttributeForm
	
	FROM  	
		dbo.BloodProduct BP

		JOIN dbo.ProductType PT 
			ON BP.ProductTypeCode = PT.ProductTypeCode
		
		JOIN dbo.ComponentClass CC
			ON CC.ComponentClassId = PT.ComponentClassId
		
		LEFT OUTER JOIN dbo.HcpcsAssignment HA
			ON BP.BloodProductGUID = HA.BloodProductGUID
			AND HA.UnAssignedDate IS NULL
			AND HA.DivisionCode = @divisioncode

	WHERE
		BP.ProductCode = @productcode
		AND BP.RecordStatusCode IN (''A'', ''L'')
	
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetActiveOrLocalBloodProductsByCode] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsDiscarded]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	This stored procedure is used for UC_107 Administrative Data Report.
**		For the selected date range and a division or all divisions, it returns 
**		blood units in discarded unit status for each component class and its subdivisions.  
**
**	Author:	Margaret Jablonski	
**
**	Date: 	10/21/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	07/18/2005	N.Paterson	Modified to use a new view
**	08/02/05	N.Paterson	Modified per mike smith to use modified view to rid sub queries.
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAdminReportBloodUnitsDiscarded]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50),
	@ismultidivision 	BIT
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	
	SELECT

		V.DivisionCode,
		V.BloodUnitGuid,
		V.DonationTypeID,
		V.UnitDivisionId,
		V.LabelTypeCode,
		V.EyeReadableUnitId,
		V.DiscardedPlasmaVolume, 
		V.ComponentClassID,
		V.ComponentClassName, 
		V.UnitProductCode,
		V.ProductTypeCode,
		V.ProductAttributeForm,
		V.CMVNegative,
		V.SCNegative

	FROM
		dbo.vw_GetAdminReportBase AS V

	WHERE

		V.UnitStatusCode = ''D'' 		--Discarded blood units only

	AND    	V.DonationTypeID > 1			--2-20 only (max is 20)

	AND	V.UnitStatusDate >= @startdate 	--within date range

	AND	V.UnitStatusDate <= @enddate   	--within date range

	AND 	((@ismultidivision = 0 AND V.DivisionCode = @divisioncode) 

		OR @ismultidivision = 1)		-- one division

	ORDER BY V.DivisionCode, V.ComponentClassID ASC, V.DonationTypeID

	SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAdminReportBloodUnitsDiscarded] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsModifiedPrepared]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	This stored procedure is used for UC_107 Administrative Data Report.
**		For the selected date range and a division or all divisions, it returns 
**		blood units in modified unit status for each component class and its subdivisions.  
**
**	Author:	Margaret Jablonski	
**
**	Date: 	10/21/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		-------------------
**	03/29/2005	Lohse		Adding RecordStatusCode check
**	06/03/2005	Lohse		PooledUnitsCount is now a function
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Replace date => <= with BETWEEN, Using a new view vw_GetAdminReportBase
**	08/02/05	N.Paterson	Modified per mike smith to use modified view to rid sub queries.
**	09/27/2005	D. Askew	Removed V.UnitStatusCode = ''M'' from the WHERE clause; the inner join on  BloodUnitModification
**					ensures we will only get back modified units
**	11/10/2005	Lohse		Making a major change to bring in one row per pool, and one row per split -- The # of units in pool/split is
**					returned in the PooledUnitsCount.  Creating a UNION statement for Splits - which has a different BUM join
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAdminReportBloodUnitsModifiedPrepared]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50),
	@ismultidivision 	BIT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SELECT DISTINCT

		V.DivisionCode,
		V.BloodUnitGuid,
		V.DonationTypeID,
		V.UnitDivisionId,
		V.LabelTypeCode,
		V.EyeReadableUnitId,
		V.DiscardedPlasmaVolume, 
		V.ComponentClassID,
		V.ComponentClassName,
		V.UnitProductCode,
		V.ProductTypeCode,
		V.ProductAttributeForm,
		V. CMVNegative,
		V.SCNegative,

		BUM.ProductModificationCode,
		BUM.ToBloodUnitGuid,
		dbo.fnGetPooledUnitsCount(BUM.ToBloodUnitGuid) 	AS	PooledUnitsCount

	FROM

	dbo.vw_GetAdminReportBase AS V

	JOIN 	dbo.BloodUnitModification BUM ON 
		(BUM.ToBloodUnitGuid = V.BloodUnitGUID AND BUM.ProductModificationCode NOT IN (''S'',''C''))

	JOIN 	dbo.ProductModification PM ON PM.ProductModificationCode =BUM.ProductModificationCode

	WHERE

	    	V.DonationTypeID > 1			--2-20 only (max is 20)

	AND BUM.ModificationDate BETWEEN @startdate  AND @enddate

	AND 	((@ismultidivision = 0 AND V.DivisionCode = @divisioncode) 

		OR @ismultidivision = 1)		-- one division

	AND	BUM.RecordStatusCode = ''A''

UNION

	SELECT DISTINCT

		V.DivisionCode,
		V.BloodUnitGuid,
		V.DonationTypeID,
		V.UnitDivisionId,
		V.LabelTypeCode,
		V.EyeReadableUnitId,
		V.DiscardedPlasmaVolume, 
		V.ComponentClassID,
		V.ComponentClassName,
		V.UnitProductCode,
		V.ProductTypeCode,
		V.ProductAttributeForm,
		V. CMVNegative,
		V.SCNegative,

		BUM.ProductModificationCode,
		BUM.FromBloodUnitGuid AS ToBloodUnitGuid,
		COUNT(1) AS PooledUnitsCount

	FROM

	dbo.vw_GetAdminReportBase AS V

	JOIN 	dbo.BloodUnitModification BUM ON 
		(BUM.FromBloodUnitGuid = V.BloodUnitGUID AND BUM.ProductModificationCode IN (''S'',''C''))

	JOIN 	dbo.ProductModification PM ON PM.ProductModificationCode =BUM.ProductModificationCode

	WHERE

	    	V.DonationTypeID > 1			--2-20 only (max is 20)

	AND BUM.ModificationDate BETWEEN @startdate  AND @enddate

	AND 	((@ismultidivision = 0 AND V.DivisionCode = @divisioncode) 

		OR @ismultidivision = 1)		-- one division

	AND	BUM.RecordStatusCode = ''A''

	GROUP BY 
		V.DivisionCode,
		V.BloodUnitGuid,
		V.DonationTypeID,
		V.UnitDivisionId,
		V.LabelTypeCode,
		V.EyeReadableUnitId,
		V.DiscardedPlasmaVolume, 
		V.ComponentClassID,
		V.ComponentClassName,
		V.UnitProductCode,
		V.ProductTypeCode,
		V.ProductAttributeForm,
		V. CMVNegative,
		V.SCNegative,

		BUM.ProductModificationCode,
		BUM.FromBloodUnitGuid

	ORDER BY 

	V.ComponentClassID,

	 BUM.ProductModificationCode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAdminReportBloodUnitsModifiedPrepared] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsOutdated]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	This stored procedure is used for UC_107 Administrative Data Report.
**		For the selected date range and a division or all divisions, it returns 
**		expired blood units for each component class and its subdivisions.  
**
**	Author:	Margaret Jablonski	
**
**	Date: 	10/21/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	07/18/2005	N.Paterson	Modified to use a new view
**	08/02/05	N.Paterson	Modified per mike smith to use modified view to rid sub queries.
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAdminReportBloodUnitsOutdated]
(
	@startdate	DATETIME,
	@divisioncode	VARCHAR(50),
	@ismultidivision 	BIT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SELECT
		BU.DivisionCode,
		BU.BloodUnitGuid,
		BU.DonationTypeID,
		BU.UnitDivisionId,
		BU.LabelTypeCode,
		BU.EyeReadableUnitId,
		BU.DiscardedPlasmaVolume, 
		BU.ComponentClassID,
		BU.ComponentClassName, 
		BU.UnitProductCode,
		BU.ProductTypeCode,
		BU.ProductAttributeForm,
		BU.CMVNegative,
		BU.SCNegative

	FROM

		dbo.vw_GetAdminReportBase  BU


	JOIN 	dbo.BloodUnitMedia BUM ON BU.BloodUnitGUID = BUM.BloodUnitGUID

	WHERE

		BU.UnitStatusCode NOT IN (''D'', ''M'', ''T'', ''X'') --not in terminal status

	AND    	BU.DonationTypeID > 1			     --2-20 only (max is 20)

	AND	BUM.UnitExpirationDate < @startdate

	AND 	((@ismultidivision = 0 AND BU.DivisionCode = @divisioncode) 
		OR @ismultidivision = 1)

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAdminReportBloodUnitsOutdated] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsReceived]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	This stored procedure is used for UC_107 Administrative Data Report.
**		For the selected date range and a division or all divisions, it returns all
**		blood units received during incoming shipment for each component class and its subdivisions.  
**
**	Author:	Margaret Jablonski	
**
**	Date: 	10/21/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/12/05	N. Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Changed date query from  >= @startdate <= @enddate  to BETWEEN
**	07/18/05	N. Paterson	Modified to use a new view
**	08/02/05	N. Paterson	Modified per mike smith to use modified view to rid sub queries.
**	09/27/05	D. Askew	Added AND condition to exclude modified-from units; these will be show in the modification section
**	12/19/05	G. Lohse	Changing UnitInDate to ShipmentDate -- ShipmentDate is the time of the invoice.
**	01/22/06	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	06/02/10	D. Askew	Cleaned up SQL; removed dead code; added AND ToBloodUnitGuid <> FromBloodUnitGuid to final 
**					AND condition in WHERE clause. (CR 2797)
**	07/19/10	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAdminReportBloodUnitsReceived]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50),
	@ismultidivision 	BIT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SELECT

		BU.DivisionCode,
		BU.BloodUnitGuid,
		BU.DonationTypeID,
		BU.UnitDivisionId,
		BU.LabelTypeCode,
		BU.EyeReadableUnitId,
		BU.DiscardedPlasmaVolume, 
		BU.ComponentClassID,
		BU.ComponentClassName, 
		BU.UnitProductCode,
		BU.ProductTypeCode,
		BU.ProductAttributeForm,
		BU.CMVNegative,
		BU.SCNegative

	FROM

		dbo.vw_GetAdminReportBase BU
	
		JOIN dbo.BloodUnitShipment BUS ON BU.BloodUnitGuid = BUS.BloodUnitGuid AND BUS.IncomingShipmentGuid IS NOT NULL AND BUS.RecordStatusCode = ''A''
	
		JOIN dbo.Shipment S ON BUS.IncomingShipmentGuid = S.ShipmentGuid

	WHERE

		S.ShipmentDate BETWEEN @startdate AND @enddate

		AND BU.DonationTypeID > 1 --2-20 only (max is 20)

		AND ( (@ismultidivision = 0 AND BU.DivisionCode = @divisioncode) OR @ismultidivision = 1 ) -- one division

		-- we exclude modified-from units
		AND BU.BloodUnitGuid NOT IN (SELECT FromBloodUnitGuid FROM dbo.BloodUnitModification WHERE FromBloodUnitGuid = BU.BloodUnitGuid AND ToBloodUnitGuid <> FromBloodUnitGuid)

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAdminReportBloodUnitsReceived] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsShipped]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	This stored procedure is used for UC_107 Administrative Data Report.
**		For the selected date range and a division or all divisions, it returns all
**		blood units in transfered blood unit status for each component class and its subdivisions.  
**
**	Author:	Margaret Jablonski	
**
**	Date: 	10/21/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/12/05	D. Askew           Changed joins for BloodUnitShipment and Shipment
**	05/25/05	G. Lohse	PooledUnitsCount is now a function.
**	07/12/05	N. Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Changed date filter from => <= to BETWEEN
**	07/18/05	N. Paterson	Modified to use a new view
**	08/02/05	N. Paterson	Modified per mike smith to use modified view to rid sub queries.
**	06/02/10	D. Askew	Cleaned up SQL; removed BU.UnitStatusCode = ''X'' from WHERE clause. (CR 2797)
**	07/19/10	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/16	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAdminReportBloodUnitsShipped]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50),
	@ismultidivision 	BIT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SELECT

		BU.DivisionCode,
		BU.BloodUnitGuid,
		BU.DonationTypeID,
		BU.UnitDivisionId,
		BU.LabelTypeCode,
		BU.EyeReadableUnitId,
		BU.DiscardedPlasmaVolume, 
		BU.ComponentClassID,
		BU.ComponentClassName, 
		BU.UnitProductCode,
		BU.ProductTypeCode,
		BU.ProductAttributeForm,

		dbo.fnGetPooledUnitsCount(BU.BloodUnitGuid) AS PooledUnitsCount,
		BU.CMVNegative,
		BU.SCNegative
	
	FROM
			
		dbo.vw_GetAdminReportBase BU

		JOIN dbo.BloodUnitFinance BUF ON BUF.BloodUnitGuid = BU.BloodUnitGuid
	
		JOIN dbo.BloodUnitShipment BS ON BU.BloodUnitGuid = BS.BloodUnitGuid
	
		JOIN dbo.Shipment S ON BS.OutgoingShipmentGuid = S.ShipmentGuid AND BS.RecordStatusCode = ''A'' AND S.ShipmentDate IS NOT NULL


	
	WHERE

		BU.DonationTypeID > 1 --2-20 only (max is 20)

		AND S.ShipmentDate BETWEEN @startdate AND @enddate

		AND ((@ismultidivision = 0 AND BU.DivisionCode = @divisioncode) 

		OR @ismultidivision = 1) -- one division
	
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAdminReportBloodUnitsShipped] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAdminReportBloodUnitsTransfused]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	This stored procedure is used for UC_107 Administrative Data Report.
**		For the selected date range and a division or all divisions, it returns all
**		blood units in transfused blood unit status for each component class and its subdivisions.  
**
**	Author:	Margaret Jablonski	
**
**	Date: 	10/21/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to BETWEEN
**	07/18/2005	N.Paterson	Modified to use a new view
**	08/02/05	N.Paterson	Modified per mike smith to use modified view to rid sub queries.
**	10/07/16	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAdminReportBloodUnitsTransfused]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50),
	@ismultidivision 	BIT
)
AS


/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
	
	SELECT

		BU.DivisionCode,
		BU.BloodUnitGuid,
		BU.DonationTypeID,
		BU.UnitDivisionId,
		BU.LabelTypeCode,
		BU.EyeReadableUnitId,
		BU.DiscardedPlasmaVolume, 
		BU.ComponentClassID,
		BU.ComponentClassName, 
		BU.UnitProductCode,
		BU.ProductTypeCode,
		BU.ProductAttributeForm,
		BU.CMVNegative,
		BU.SCNegative

	FROM

			dbo.vw_GetAdminReportBase BU

	JOIN 	dbo.PatientTransfusion T ON T.BloodUnitGUID = BU.BloodUnitGUID

	WHERE

		BU.UnitStatusCode = ''T'' 		--Transfused blood units only
	
		AND    	BU.DonationTypeID > 1			--2-20 only (max is 20)
	
		AND T.TransfusionEndDateTime BETWEEN @startdate AND @enddate
	
		AND 	((@ismultidivision = 0 AND BU.DivisionCode = @divisioncode) 

		OR @ismultidivision = 1)		-- one division

	ORDER BY 

		BU.DivisionCode, 

		BU.ComponentClassID ASC, 

		BU.DonationTypeID

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAdminReportBloodUnitsTransfused] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAllAntigensForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets active and inactive Blood Unit Antigens based on Blood Unit GUID and DivisionCode
**
**	Author:	David Askew (very similar to existing spGetBloodUnitAntigens)
**
**	Date: 	07/21/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAllAntigensForBloodUnit]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BUA.BloodUnitGUID,
		BUA.AntigenTypeID,
		ANT.AntigenTypeName,
		BUA.Positive,
		BUA.RecordStatusCode,
		BUA.DivisionCode,
		BUA.[RowVersion]
	
	FROM
		dbo.BloodUnitAntigen BUA

	JOIN 	dbo.AntigenType ANT ON ANT.AntigenTypeID = BUA.AntigenTypeID
		
	WHERE

		BloodUnitGUID = @bloodunitguid 

	AND	DivisionCode = @divisioncode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAllAntigensForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntibodiesWithoutAntigens]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets list of antibody Types without antigen information
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	12/21/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	----------	----------	------------------------------------
**	04/18/2005	C. Taylor	Added ClinicallySignificantIndicator
**	06/22/2005	Lohse		Adding AntibodyParameterGuid for locking
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, aliased tables
					Placed parameters around input parameter
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAntibodiesWithoutAntigens]
(
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT


SET NOCOUNT ON

	SELECT 	

		ANT.AntibodyTypeID,
		ANT.AntibodyTypeName,
		ANT.ClinicallySignificantIndicator,
		AP.AntibodyParameterGuid,
		AP.HigherLevelOverrideIndicator,
		AP.CompatibilityPercentage,
		AP.CanChangeIndicator,
		AP.[RowVersion]
	
	FROM  

		dbo.AntibodyType ANT
	
		JOIN dbo.AntibodyParameter AP ON 

			AP.AntibodyTypeID = ANT.AntibodyTypeID
	
	WHERE

		AP.DivisionCode = @divisioncode
		
	ORDER BY 

		ANT.SortColumn

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntibodiesWithoutAntigens] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntibodyParameterByID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Returns antibody type from AntibodyType table for given ID/DivisionCode
**
**	Author:	Greg Lohse
**
**	Date: 	04/08/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		-----------------
**	04/08/2004	Greg Lohse	Initial Draft.
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntibodyParameterByID]
(
	@divisioncode		VARCHAR(50),
	@antibodytypeid		INT
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		AntibodyParameterGUID, 	
		AntibodyTypeID,
		HigherLevelOverrideIndicator,
		CanChangeIndicator,
		CompatibilityPercentage,
		DivisionCode

	FROM  

		dbo.AntibodyParameter
	
	WHERE

		DivisionCode = @divisioncode

	AND	AntibodyTypeID = @antibodytypeid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntibodyParameterByID] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntibodyTypeLookupList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets list of antibody Types 
**
**	Author:	Cameron Taylor
**
**	Date: 	03/10/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/12/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, aliased tables,
					Placed input parameter in brackets
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntibodyTypeLookupList]
(
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT


SET NOCOUNT ON

	SELECT 	
	
		ABT.AntibodyTypeID,
		ABT.AntibodyTypeName,
		ANT.AntigenTypeId,
		ANT.AntigenTypeName,
		ABP.HigherLevelOverrideIndicator,
		ABP.CompatibilityPercentage,
		ABP.CanChangeIndicator,
		ABP.[RowVersion]
	
	FROM  
	
		dbo.AntibodyType ABT
	
		JOIN dbo.AntibodyAntigen ABA ON 
	
			ABA.AntibodyTypeId = ABT.AntibodyTypeId
	
		JOIN dbo.AntigenType ANT ON 
	
			ABA.AntigenTypeId = ANT.AntigenTypeId
	
		JOIN dbo. AntibodyParameter ABP ON 
	
			ABP.AntibodyTypeID = ABT.AntibodyTypeID
	
	WHERE
	
		ABP.DivisionCode = @divisioncode
		
	ORDER BY 
	
		ABT.SortColumn

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntibodyTypeLookupList] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntigenTypingForConsistencyCheck]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Brings back two DataTables, corresponding to current and tested  Antigen Typing
**
**	Author: 	David Askew
**
**	Date: 	01/24/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, aliased tables
					Error checking both SQL statements instead of just the last one (original code mistake)
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntigenTypingForConsistencyCheck]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
	
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
	-- ***********************************************************************************************************************************
	SELECT DISTINCT

		BUA.AntigenTypeId

	FROM

		dbo.BloodUnit BU

		JOIN dbo.BloodUnitAntigen BUA

			ON BU.BloodUnitGuid = BUA.BloodUnitGuid

		JOIN dbo.AntigenType ANT

			ON ANT.AntigenTypeId = BUA.AntigenTypeId

		JOIN dbo.VBecsUser AS LastUpdateUser 

			ON BUA.LastUpdateUser = LastUpdateUser.VBecsUserId

	WHERE 	

		BU.BloodUnitGuid = @bloodunitguid

		AND BU.DivisionCode = @divisioncode

		AND BUA.RecordStatusCode = ''A''



	UNION



	SELECT DISTINCT

		ANT.AntigenTypeId

	FROM

		dbo.BloodUnit BU

		JOIN dbo.BloodUnitTest BUT

			ON BU.BloodUnitGuid = BUT.BloodUnitGuid

		JOIN dbo.AntigenTest ATEST

			ON BUT.BloodTestTypeId = ATEST.BloodTestTypeId

		JOIN dbo.AntigenType ANT

			ON ATEST.AntigenTypeId = ANT.AntigenTypeId

		JOIN dbo.BloodTestType BTT

			ON BUT.BloodTestTypeId = BTT.BloodTestTypeId

		JOIN dbo.TestResult TR

			ON BUT.TestResultId = TR.TestResultId

		JOIN dbo.VBecsUser AS LastUpdateUser 

			ON BUT.LastUpdateUser = LastUpdateUser.VBecsUserId

	WHERE 	

		BU.BloodUnitGuid = @bloodunitguid

		AND BU.DivisionCode = @divisioncode

		AND TR.TestResultText IN (''Pos'', ''Neg'')

		AND BUT.RecordStatusCode = ''A''

	SELECT @ERROR = @@ERROR

	IF @ERROR != 0 GOTO ERR_HANDLER
	-- ***********************************************************************************************************************************

	SELECT DISTINCT

		BUA.AntigenTypeId,

		ANT.AntigenTypeName,

		BUA.Positive,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUA.LastUpdateDate) AS LastUpdateDate

	FROM

		dbo.BloodUnit BU

		JOIN dbo.BloodUnitAntigen BUA

			ON BU.BloodUnitGuid = BUA.BloodUnitGuid

		JOIN dbo.AntigenType ANT

			ON ANT.AntigenTypeId = BUA.AntigenTypeId

		JOIN dbo.VBecsUser AS LastUpdateUser 

			ON BUA.LastUpdateUser = LastUpdateUser.VBecsUserId

	WHERE 	

		BU.BloodUnitGuid = @bloodunitguid

		AND BU.DivisionCode = @divisioncode

		AND BUA.RecordStatusCode = ''A''


	UNION


	SELECT DISTINCT

		ATEST.AntigenTypeId,
		ANT.AntigenTypeName,
		(
			CASE 	WHEN TR.TestResultText = ''Pos'' THEN 1
				WHEN TR.TestResultText = ''Neg'' THEN 0
				ELSE -1 END
		) AS Positive,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) AS LastUpdateDate

	FROM

		dbo.BloodUnit BU

		JOIN dbo.BloodUnitTest BUT

			ON BU.BloodUnitGuid = BUT.BloodUnitGuid

		JOIN dbo.AntigenTest ATEST

			ON BUT.BloodTestTypeId = ATEST.BloodTestTypeId

		JOIN dbo.AntigenType ANT

			ON ATEST.AntigenTypeId = ANT.AntigenTypeId

		JOIN dbo.BloodTestType BTT

			ON BUT.BloodTestTypeId = BTT.BloodTestTypeId

		JOIN dbo.TestResult TR

			ON BUT.TestResultId = TR.TestResultId

		JOIN dbo.VBecsUser AS LastUpdateUser 

			ON BUT.LastUpdateUser = LastUpdateUser.VBecsUserId

	WHERE 	

		BU.BloodUnitGuid = @bloodunitguid

		AND BU.DivisionCode = @divisioncode

		AND TR.TestResultText IN (''Pos'', ''Neg'')

		AND BUT.RecordStatusCode = ''A''

	ORDER BY LastUpdateDate DESC

	SELECT @ERROR = @@ERROR

	IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

RETURN (0)

ERR_HANDLER:

	SET NOCOUNT OFF

	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntigenTypingForConsistencyCheck] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntigenTypingTestsForUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc:	Gets a blood unit''s Antigen Typing test results
**
**	Author:	Martin Tsotchev
**
**	Date: 	01/28/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					NOTE: The last subquery was using the same table alias (OrderableTest OT) as in the main query
					I have changed this realizing there is a far off remote chance that the resulting data set may now be different
**	01/15/2016	K.Dobranowski	Modified this sp to allow loading of the automated instrument tests (they don''t have the worklist Guid) (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAntigenTypingTestsForUnit]
(
		@bloodunitguid		UNIQUEIDENTIFIER,
		@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BUT.AntiseraWorklistTypingGUID,
		AWT.OrderableTestID,
		OT.OrderableTestName,
		BUT.BloodUnitTestGUID,
		BUT.BloodUnitGUID,
		BUT.BloodTestTypeID,
		BTT.BloodTestName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate,
		BUT.TestResultID,
		BUT.TestComments,
		BUT.EntryMethodCode,
		BUT.DivisionCode,
		BUT.[RowVersion],
		TR.TestResultText,
		R.ReagentGUID,
		PBUT.UnitResultSetGuid

	FROM

		dbo.BloodUnitTest BUT

		JOIN dbo.TestResult TR ON 

			TR.TestResultID = BUT.TestResultID

		JOIN dbo.BloodTestType BTT ON 

			BTT.BloodTestTypeID = BUT.BloodTestTypeID

		LEFT JOIN dbo.AntiseraWorklistTyping AWT ON 

			BUT.AntiseraWorklistTypingGUID = AWT.AntiseraWorklistTypingGUID

		LEFT JOIN dbo.AntiseraUnitTest AUT ON 

			AWT.AntiseraWorklistTypingGUID = AUT.AntiseraWorklistTypingGUID

		LEFT JOIN dbo.RackLot RL ON 

			AUT.RackLotGUID = RL.RackLotGUID

		LEFT JOIN dbo.Reagent R ON 

			RL.ReagentGUID = R.ReagentGUID

		JOIN dbo.OrderableTest OT ON 

			BTT.OrderableTestID = OT.OrderableTestID
		
		LEFT JOIN dbo.PendingBloodUnitTest PBUT ON
			
			BUT.BloodUnitTestGuid = PBUT.BloodUnitTestGuid

	WHERE

		BUT.DivisionCode = @divisioncode

	AND	BUT.BloodUnitGUID = @bloodunitguid

	AND	BUT.RecordStatusCode = ''A''

	AND	(	(	AUT.RecordStatusCode IS NULL	) OR
			(	AUT.RecordStatusCode = ''A''	)
		)

	AND	(	(	RL.RecordStatusCode IS NULL	) OR
			(	RL.RecordStatusCode = ''A''	)
		)

	AND	(	(	R.RecordStatusCode IS NULL	) OR
			(	R.RecordStatusCode = ''A''	)
		)

	AND	RL.ControlCellID IS NULL

	AND OT.OrderableTestName NOT LIKE ''Repeat%''

	AND OT.ReagentTypeId IS NOT NULL

	ORDER BY

		ISNULL(PBUT.UnitResultSetGuid, BUT.AntiseraWorklistTypingGuid) ASC,
		OT.OrderableTestID ASC, 
		BUT.TestDate DESC
		
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntigenTypingTestsForUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraOrderedTests]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Antisera Ordered Test records associated with given ordered test guid 
**
**	Author:	Cameron Taylor
**
**	Date: 	09/07/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntiseraOrderedTests]
(
	@orderedtestguid 		UNIQUEIDENTIFIER,
	@divisioncode			VARCHAR(50)
)
AS
	
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
		AntiseraOrderedTestGuid,
		OrderedTestGuid,
		RackLotGuid,
		RecordStatusCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LastUpdateDate) AS  LastUpdateDate,
		LastUpdateUser,
		[RowVersion]
	FROM
		dbo.AntiseraOrderedTest

	WHERE
		OrderedTestGuid = @orderedtestguid
	AND
		RecordStatusCode NOT IN (''E'',''X'')

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraOrderedTests] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistByGuid]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Antisera Work List 
**
**	Author:	Cameron Taylor
**
**	Date: 	05/30/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	6/16/2003	C Taylor	Added RecordStatusCode and DivisionCode
**	9/30/2003	C Taylor	Added AutoInstrumentName and TestingMethodCode
**	02/27/2004	M.Jablonski	Added row version to SELECT
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQLssss
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntiseraWorklistByGuid]
(
	@antiseraworklistguid 	UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
AS
	
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT 

		AntiseraWorklistGUID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, WorklistCreateDate) AS  WorklistCreateDate,

		WorklistName,
		AutoInstrumentName,
		TestingMethodCode,
		LastUpdateUser,
		RecordStatusCode,
		DivisionCode,
		[RowVersion]

	FROM

		dbo.AntiseraWorklist

	WHERE

		AntiseraWorklistGUID = @antiseraworklistguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraWorklistByGuid] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistDetails]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets details of Antigen Typing specificities
**
**	Author:	Cameron Taylor
**
**	Date: 	06/16/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	02/27/2004	M.Jablonski	Added row version to SELECT
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	NOTES Per Mike Smith:
?					Need to check with author to see if LEFT JOIN to RackLot table should be a JOIN.  The way it is written it acts like a JOIN because 
**				RL.RecordStatusCode = ''A'' is in the where clause.  If it is a true left join move this to the join condition.
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntiseraWorklistDetails]
(
	@antiseraworklistguid 	UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		AWT.AntiseraWorklistGUID,
		AWT.AntiseraWorklistTypingGUID,
		AUT.AntiseraUnitTestGUID,
		AUT.LastUpdateUser,
		RL.RackLotGUID,
		RL.DivisionCode,
		RL.ControlCellID,
		RG.ReagentGUID,
		RT.ReagentTypeID,
		RT.ReagentTypeName,
		RG.LotNumber,
		RG.ReagentManufacturerName,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,RG.LotExpirationDate) 	AS LotExpirationDate,

		RP.ReactivityPhaseCode,
		RP.ReactivityPhaseText,
		R.RackGUID,
		R.RackName,
		OT.OrderableTestID,
		OT.OrderableTestName,
		RL.[RowVersion],
		AUT.[RowVersion] 								AS AntiseraUnitTestRowVersion,
		RL.TestWithID
	
	FROM

		dbo.AntiseraWorklistTyping AWT

	JOIN

		dbo.AntiseraWorklist AW ON AWT.AntiseraWorklistGUID = AW.AntiseraWorklistGUID	

	JOIN

		 dbo.AntiseraUnitTest AUT ON AUT.AntiseraWorklistTypingGUID = AWT.AntiseraWorklistTypingGUID

	LEFT JOIN

		dbo.OrderableTest OT ON AWT.OrderableTestID = OT.OrderableTestID

	LEFT JOIN

		dbo.RackLot RL ON AUT.RackLotGUID = RL.RackLotGUID

	LEFT JOIN

		dbo.Reagent RG ON RL.ReagentGUID = RG.ReagentGUID

	LEFT JOIN

		dbo.ReactivityPhase RP ON RP.ReactivityPhaseCode = RL.ReactivityPhaseCode

	LEFT JOIN

		dbo.Rack R ON R.RackGUID = RL.RackGUID

	LEFT JOIN

		dbo.ReagentType RT ON RT.ReagentTypeID = RG.ReagentTypeID

	WHERE

		AW.AntiseraWorklistGUID = @AntiseraWorklistGUID

	  AND

	    RL.ControlCellID IS NULL

	  AND

		AUT.RecordStatusCode = ''A''

	  AND

	    RL.RecordStatusCode = ''A''

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraWorklistDetails] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistQCControls]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the QC controls for a reagent in an antisera worklist
**
**	Author: Cameron Taylor
**
**	Date: 	07/07/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	03/03/2004	C. Taylor		Added SatisfactoryResultIndicator
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, ALIASED TABLES
					NOTE: OrderableTestID IS HARD CODED, consider using subquery so if values change you don''t have to update this code
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntiseraWorklistQCControls]
(
	@antiseraworklisttypingguid	UNIQUEIDENTIFIER,
	@divisioncode			VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
	
		RL.ReagentGUID,
		RL.RackLotGUID,
		RL.ControlCellID,
		RL.LotVialNumber,
		RL.SatisfactoryResultIndicator,
		RL.Comments,
		REA.LotNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, REA.LotExpirationDate) AS LotExpirationDate,

		REA.ReagentTypeID,
		RT.ReagentTypeName,
		REA.ReagentManufacturerName,
		RL.[RowVersion]
		
	   FROM 

		dbo.RackLot RL
	
	JOIN
		dbo.Reagent REA ON REA.ReagentGUID = RL.ReagentGUID
	JOIN
		dbo.AntiseraUnitTest AUT ON AUT.RackLotGUID = RL.RackLotGUID
	JOIN
		dbo.ReagentType RT ON RT.ReagentTypeID = REA.ReagentTypeID
	JOIN
		dbo.AntiseraWorklistTyping AWT ON AWT.AntiseraWorklistTypingGUID = AUT.AntiseraWorklistTypingGUID
	
	WHERE

		AUT.AntiseraWorklistTypingGUID = @antiseraworklisttypingguid

	  AND

	    RL.ControlCellID IS NOT NULL

	  AND

	    ((RL.LotVialNumber IS NOT NULL) OR (AWT.OrderableTestID = 11))

	  AND

		RL.RecordStatusCode = ''A''


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraWorklistQCControls] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistQCResults]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the QC results for a reagent in an antisera worklist
**
**	Author: Cameron Taylor
**
**	Date: 	07/02/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, aliased tables,
					Placed input parameters in brackets
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAntiseraWorklistQCResults]
(
	@antiseraworklisttypingguid		UNIQUEIDENTIFIER,
	@divisioncode				VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
	
		RL.ReagentGUID,
		RL.RackLotGUID,
		RL.ControlCellID,
		RL.SatisfactoryResultIndicator,
		RL.ReactivityPhaseCode,
		RL.LotVialNumber,
		RL.Comments,
		REA.LotNumber,
		RL.TestWithID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, REA.LotExpirationDate) AS LotExpirationDate,

		REA.ReagentTypeID,
		REA.ReagentManufacturerName,
		RT.RackTestGUID,
		RT.RackTestResult,
		RT.RackTestResultTypeCode,
		RT.[RowVersion],
		RL.[RowVersion] AS RackLotRowVersion
	
	   FROM 

		dbo.RackLot RL
	
	JOIN
		dbo.Reagent REA ON REA.ReagentGUID = RL.ReagentGUID
	JOIN
		dbo.RackTest RT ON RT.RackLotGUID = RL.RackLotGUID
	JOIN
		dbo.AntiseraUnitTest AUT ON AUT.RackLotGUID = RL.RackLotGUID
	
	WHERE

		AUT.AntiseraWorklistTypingGUID = @AntiseraWorklistTypingGUID

	  AND

	    RL.ControlCellID IS NOT NULL

	  AND

	    RT.RecordStatusCode = ''A''


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraWorklistQCResults] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistsPartiallyCompleted]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Antisera Work Lists that are Partially Completed
**
**	Author:	Cameron Taylor
**
**	Date: 	05/30/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
** 	 6/16/2003  	 C Taylor	Added check for RecordStatusCode
**	9/30/2003	C Taylor	Added TestingMethodText
**	02/27/2004	M.Jablonski	Added row version to SELECT
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntiseraWorklistsPartiallyCompleted]
(
	@divisioncode AS VARCHAR(50)
)
AS
	
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT 

		AW.AntiseraWorklistGUID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, AW.WorklistCreateDate) AS  WorklistCreateDate,

		AW.WorklistName,
		AW.TestingMethodCode,
		TM.TestingMethodText,
		AW.AutoInstrumentName,
		AW.LastUpdateUser,
		AW.[RowVersion]

	FROM

		dbo.AntiseraWorklist AW

	JOIN

		dbo.TestingMethod TM ON TM.TestingMethodCode = AW.TestingMethodCode

	WHERE

		AW.DivisionCode = @divisioncode

	  AND

		AW.RecordStatusCode = ''A''

	  AND

		AW.TaskStatusCode IN (''P'',''N'')

	ORDER BY  

	AW.WorklistCreateDate DESC, 
	AW.WorklistName

SET @ERROR = @@ERROR

SET NOCOUNT OFF
	
RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraWorklistsPartiallyCompleted] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistTypingDetails]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets details of Antigen Typing specificities
**
**	Author:	Cameron Taylor
**
**	Date: 	07/16/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntiseraWorklistTypingDetails]
(
	@antiseraworklisttypingguid 	UNIQUEIDENTIFIER,
	@divisioncode			VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		AWT.AntiseraWorklistGUID,
		AWT.AntiseraWorklistTypingGUID,
		AUT.AntiseraUnitTestGUID,
		AUT.LastUpdateUser,
		RL.RackLotGUID,
		RL.DivisionCode,
		RL.ControlCellID,
		RG.ReagentGUID,
		RT.ReagentTypeID,
		RT.ReagentTypeName,
		RG.LotNumber,
		RG.ReagentManufacturerName,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, RG.LotExpirationDate) AS LotExpirationDate,

		RP.ReactivityPhaseCode,
		RP.ReactivityPhaseText,
		R.RackGUID,
		R.RackName,
		OT.OrderableTestID,
		OT.OrderableTestName
	
	FROM

		dbo.AntiseraWorklistTyping AWT

	JOIN

		dbo.AntiseraWorklist AW ON AWT.AntiseraWorklistGUID = AW.AntiseraWorklistGUID	

	JOIN

		 dbo.AntiseraUnitTest AUT ON AUT.AntiseraWorklistTypingGUID = AWT.AntiseraWorklistTypingGUID

	LEFT JOIN

		dbo.OrderableTest OT ON AWT.OrderableTestID = OT.OrderableTestID

	LEFT JOIN

		dbo.RackLot RL ON AUT.RackLotGUID = RL.RackLotGUID

	LEFT JOIN

		dbo.Reagent RG ON RL.ReagentGUID = RG.ReagentGUID

	LEFT JOIN

		dbo.ReactivityPhase RP ON RP.ReactivityPhaseCode = RL.ReactivityPhaseCode

	LEFT JOIN

		dbo.Rack R ON R.RackGUID = RL.RackGUID

	LEFT JOIN

		dbo.ReagentType RT ON RT.ReagentTypeID = RG.ReagentTypeID

	WHERE

		AWT.AntiseraWorklistTypingGUID = @antiseraworklisttypingguid

	  AND

	    RL.ControlCellID IS NULL

	  AND

		AUT.RecordStatusCode = ''A''

	  AND

	    RL.RecordStatusCode = ''A''

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraWorklistTypingDetails] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAntiseraWorklistUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets units for an antigen typing worklist
**
**	Author:	Cameron Taylor
**
**	Date: 	06/16/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------	---------		-----------------
**	01/22/2004	Greg Lohse	Selecting RhFactorText from table -- to replace the function call
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	01/10/2005	Lohse		Adding BloodUnitStatusGuid for locking code
**	01/10/2006	C. Taylor	Added DonationTypeCode and UnitDivisionId and LabelTypeCode (DR 1729)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAntiseraWorklistUnits]
(
	@antiseraworklistguid as UNIQUEIDENTIFIER,
	@divisioncode			VARCHAR(50)
)

AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BU.BloodUnitGUID,
		BU.UnitProductCode,
		BU.EyeReadableUnitID,
		BP.BloodProductGUID,
		BP.ProductShortName,
		BP.ProductName,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUM.UnitExpirationDate) AS UnitExpirationDate,

		RTRIM(BUM.BloodTypeCode) + '' '' + RH.RhFactorText AS AboRh,
		BUS.BloodUnitStatusGuid,
		BU.UnitDivisionId,
		DT.DonationTypeCode,
		BU.LabelTypeCode
	
	FROM

		dbo.BloodUnit BU

	JOIN

		dbo.BloodProduct BP ON BP.BloodProductGUID = BU.BloodProductGUID

	JOIN

		dbo.BloodUnitMedia BUM ON BUM.BloodUnitGUID = BU.BloodUnitGUID

	JOIN	

		dbo.RhFactor RH ON RH.RhFactorCode = BUM.RhFactorCode

	JOIN 	dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BU.BloodUnitGuid
	
	JOIN	dbo.DonationType DT ON DT.DonationTypeId = BU.DonationTypeId

	WHERE

		(BU.BloodUnitGUID IN (

					SELECT

						BloodUnitGUID

					FROM

						dbo.BloodUnitTest BUT

					WHERE

						(

						BUT.AntiseraWorklistTypingGUID IN (
											SELECT
												AntiseraWorklistTypingGUID
											FROM
												dbo.AntiseraWorklistTyping 
											WHERE
												AntiseraWorklistGUID = @AntiseraWorklistGUID
										      )
					AND	BUT.RecordStatusCode = ''A'')
						)
					)
	

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAntiseraWorklistUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAssociatedInstitutionByDivision]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



/*******************************************************************************************************************************************************************************
**	Desc: 	Selects against the AssociatedInstitution table		
**		This stored procedure was added for (CR 2316)
**	Use Case(s):	
**
**	Author: 		Carrie Van Stedum
**
**	Date: 		9/20/2007
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAssociatedInstitutionByDivision]
(
	@divisioncode AS VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR 		INT

SET @ERROR = 0


	SELECT 
		AssociatedInstitutionGuid,	
		InstitutionDivisionCode,				
		DivisionCode,
		RecordStatusCode,
		LastUpdateDate,
		LastUpdateUser,
		RowVersion,
		LastUpdateFunctionId

	FROM
		dbo.AssociatedInstitution 
	
	WHERE 
		
		DivisionCode = @divisioncode

	ORDER BY
		InstitutionDivisionCode

	
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAssociatedInstitutionByDivision] TO [VbecsAppUser] AS [dbo]
GO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditAntibody]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Antibody audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditAntibody]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

	SELECT

		VAP.AntibodyParameterGUID,
		VAP.HigherLevelOverrideIndicator,
		VAP.CompatibilityPercentage,
		VAP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VAP.LastUpdateDate) AS MirrorDate,

		VAP.LastUpdateUser,
		dbo.AntibodyType.AntibodyTypeName
	
	FROM

		SynMirror_V_AntibodyParameter VAP

	JOIN dbo.AntibodyType ON dbo.AntibodyType.AntibodyTypeID = VAP.AntibodyTypeID
	
	WHERE

		VAP.MirrorDate BETWEEN @startdate AND  @enddate
	AND
		VAP.DivisionCode = @divisioncode
	
	ORDER BY

		VAP.AntibodyParameterGUID,
		VAP.Source,
		VAP.MirrorId DESC


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET NOCOUNT OFF

RETURN (@ERROR)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditAntibody] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditAssociatedInstitution]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

/*******************************************************************************************************************************************************************************
**	Desc: 	Get Associated Institution audit information
**		This stored procedure was added for (CR 2316)
**	Author: Krzysztof Dobranowski
**
**	Date:   09/26/2007
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditAssociatedInstitution]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VAI.AssociatedInstitutionGuid,
		VAI.DivisionCode,
		VAI.InstitutionDivisionCode,
		VAI.RecordStatusCode,
		VAI.MirrorId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VAI.LastUpdateDate) AS MirrorDate,
		VAI.LastUpdateUser,
		dbo.VamcDivision.DivisionName

	FROM

		SynMirror_V_AssociatedInstitution VAI

	LEFT JOIN dbo.VamcDivision ON dbo.VamcDivision.DivisionCode = VAI.DivisionCode
	WHERE

		VAI.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VAI.DivisionCode = @divisioncode

	ORDER BY

		VAI.AssociatedInstitutionGuid,
		VAI.Source,
		VAI.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)


' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditAssociatedInstitution] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodProduct]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood product audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/13/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditBloodProduct]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode  VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

	SELECT

		VPS.BloodProductGUID,
		dbo.BloodProduct.ProductName,
		dbo.BloodProduct.ProductCode,
		VPS.LocalSupplierGuid,
		dbo.LocalSupplier.FacilityName,
		VPS.RecordStatusCode,
		VPS.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VPS.LastUpdateDate) AS MirrorDate,

		VPS.LastUpdateUser

	FROM

		SynMirror_V_ProductShipper VPS

	JOIN dbo.BloodProduct ON dbo.BloodProduct.BloodProductGUID = VPS.BloodProductGUID

	JOIN dbo.LocalSupplier ON dbo.LocalSupplier.LocalSupplierGUID = VPS.LocalSupplierGUID

	WHERE

		VPS.MirrorDate BETWEEN @startdate AND  @enddate

	AND

		VPS.DivisionCode = @divisioncode

	ORDER BY

		VPS.BloodProductGUID,

		VPS.Source,

		VPS.MirrorId DESC

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

RETURN (@ERROR)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodProduct] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood unit audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/15/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/25/2007	K. Dobranowski	Added JOIN on BloodUnitMedia in order to retrieve Comments from BloodUnitMedia table (CR 2134)
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditBloodUnit]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

	SELECT

		VBU.BloodUnitGuid,
		VBU.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VBU.LastUpdateDate) AS MirrorDate,

		VBU.LastUpdateUser,
		VBU.OriginalVolume,
		VBU.DiscardedPlasmaVolume,
		VBU.DonationTypeId,
		VBU.RecordStatusCode,
		VBU.LastUpdateFunctionId,
		dbo.DonationType.DonationTypeText,
		VBU.EyeReadableUnitID,
		dbo.BloodProduct.ProductName,
		dbo.BloodProduct.ProductCode,
		dbo.BloodUnitMedia.Comments

	FROM

		SynMirror_V_BloodUnit VBU

	JOIN dbo.DonationType ON dbo.DonationType.DonationTypeId = VBU.DonationTypeId

	JOIN dbo.BloodProduct ON dbo.BloodProduct.BloodProductGuid = VBU.BloodProductGuid
	JOIN dbo.BloodUnitMedia ON dbo.BloodUnitMedia.BloodUnitGuid = VBU.BloodUnitGuid


	
	WHERE

		VBU.MirrorDate BETWEEN @startdate AND  @enddate

	AND

		VBU.DivisionCode = @divisioncode
	
	ORDER BY

		VBU.BloodUnitGuid,
		VBU.Source,
		VBU.MirrorId DESC

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET NOCOUNT OFF

RETURN (@ERROR)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitAntigen]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood unit antigen audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/15/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditBloodUnitAntigen]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS


/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

	SELECT

		VBUA.BloodUnitGuid,
		VBUA.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VBUA.LastUpdateDate) AS MirrorDate ,

		VBUA.LastUpdateUser,
		VBUA.Positive,
		VBUA.RecordStatusCode,
		VBUA.LastUpdateFunctionId,
		dbo.AntigenType.AntigenTypeName,
		dbo.BloodUnit.EyeReadableUnitID,
		BP.ProductName,
		BP.ProductCode

	FROM
		SynMirror_V_BloodUnitAntigen VBUA

	JOIN dbo.BloodUnit ON dbo.BloodUnit.BloodUnitGUID = VBUA.BloodUnitGUID

	JOIN dbo.AntigenType ON dbo.AntigenType.AntigenTypeID = VBUA.AntigenTypeID

	JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = dbo.BloodUnit.BloodProductGuid

	WHERE

		VBUA.MirrorDate BETWEEN @startdate  AND  @enddate

		AND

		VBUA.DivisionCode = @divisioncode

	ORDER BY

		VBUA.BloodUnitGuid,
		dbo.AntigenType.AntigenTypeName,
		VBUA.Source,
		VBUA.MirrorId DESC

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

RETURN (@ERROR)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodUnitAntigen] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitFinance]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood unit finance audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/10/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditBloodUnitFinance]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

	SELECT

		VBUF.BloodUnitFinanceGuid,
		VBUF.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VBUF.LastUpdateDate) AS MirrorDate,

		VBUF.LastUpdateUser,
		VBUF.ReturnCreditAmount,
		VBUF.UnitCost,
		VBUF.SpecialTestingCost,
		VBUF.LastUpdateFunctionId,
		dbo.BloodUnit.EyeReadableUnitID,
		BP.ProductName,
		BP.ProductCode

	FROM

		SynMirror_V_BloodUnitFinance VBUF

	JOIN dbo.BloodUnit ON dbo.BloodUnit.BloodUnitGUID = VBUF.BloodUnitGUID

	JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = dbo.BloodUnit.BloodProductGuid


	WHERE

		VBUF.MirrorDate BETWEEN @startdate  AND  @enddate


	AND

		dbo.BloodUnit.DivisionCode = @divisioncode

	ORDER BY

		VBUF.BloodUnitFinanceGUID,
		VBUF.Source,
		VBUF.MirrorId DESC

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET NOCOUNT OFF

RETURN (@ERROR)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodUnitFinance] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitMedia]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood unit media audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/15/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	04/13/2006	K. Dobranowski	Replaced DirectedPatientGUID with DirectedPatientGuid to fix problem described in CR 1764
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAuditBloodUnitMedia]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

	SELECT

		VBUM.BloodUnitGuid,
		VBUM.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VBUM.LastUpdateDate ) AS MirrorDate,

		VBUM.LastUpdateUser,
		VBUM.DirectedPatientGuid,
		VBUM.LastUpdateFunctionId,
		dbo.Patient.PatientLastName,
		dbo.Patient.PatientFirstName,
		dbo.Patient.DisplayVistaPatientId,
		dbo.BloodUnit.EyeReadableUnitId,
		dbo.BloodProduct.ProductName,
		dbo.BloodProduct.ProductCode

	FROM

		SynMirror_V_BloodUnitMedia VBUM

	JOIN dbo.Patient ON dbo.Patient.PatientGuid = VBUM.DirectedPatientGuid

	JOIN dbo.BloodUnit ON dbo.BloodUnit.BloodUnitGuid = VBUM.BloodUnitGuid

	JOIN dbo.BloodProduct ON dbo.BloodProduct.BloodProductGuid = dbo.BloodUnit.BloodProductGuid

	WHERE

		VBUM.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		dbo.BloodUnit.DivisionCode = @divisioncode

	ORDER BY

		VBUM.BloodUnitGuid,
		VBUM.Source,
		VBUM.MirrorId DESC

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET NOCOUNT OFF

RETURN (@ERROR)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodUnitMedia] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitModification]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood unit modification audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   07/20/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	--------------------	-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	08/17/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Specified object owners, aliased Tables, spaced out SQL, placed input params in brackets, added error variable
**					Changed MirrorDate filter to use BETWEEN instead of => <=
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditBloodUnitModification]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

SET NOCOUNT ON

DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ONERROR

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ONERROR

SELECT

	VBM.FromBloodUnitGuid,
	VBM.ToBloodUnitGuid,
	VBM.MirrorId,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VBM.LastUpdateDate) AS MirrorDate,
	VBM.LastUpdateUser,
	VBM.RecordStatusCode,
	VBM.Comments,
	VBM.OriginalUnitIndicator,
	VBM.LastUpdateFunctionId,
	BU.EyeReadableUnitID,
	BP.ProductName,
	BP.ProductCode

FROM
	SynMirror_V_BloodUnitModification VBM

		JOIN dbo.BloodUnit BU ON BU.BloodUnitGuid = VBM.ToBloodUnitGuid

		JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BU.BloodProductGuid

WHERE

	VBM.MirrorDate BETWEEN @startdate AND @enddate AND

	VBM.DivisionCode = @divisioncode AND

	(VBM.ProductModificationCode = ''P'' OR

	VBM.ProductModificationCode = ''U'')

ORDER BY
	VBM.ToBloodUnitGuid,
	VBM.FromBloodUnitGuid,
	VBM.Source,
	VBM.MirrorId DESC

SET @ERROR = @@ERROR

ONERROR:
SET NOCOUNT OFF
RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodUnitModification] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitStatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood unit status audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/05/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	01/04/2010	M. Smith	Changed to get UnitStatusCode from the V_BloodUnitStatusCodeCurrent view. (CR 1174)
**	01/27/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditBloodUnitStatus]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

	SELECT
		BUS.BloodUnitGuid,
		BUS.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUS.LastUpdateDate) AS MirrorDate,

		BUS.LastUpdateUser,
		BUS.UnitStatusComments,
		BUSCC.UnitStatusCode,
		BUS.BiohazardousWarningIndicator,
		BUS.LastUpdateFunctionId,
		dbo.UnitStatus.UnitStatusText,
		dbo.BloodUnit.EyeReadableUnitID,
		dbo.BloodProduct.ProductName,
		dbo.BloodProduct.ProductCode

	FROM SynMirror_V_BloodUnitStatus BUS

	JOIN SynMirror_V_BloodUnitStatusCodeCurrent BUSCC
				ON BUS.BloodUnitGuid = BUSCC.BloodUnitGuid
				AND BUS.LastUpdateDate >= BUSCC.LastUpdateDate
				AND BUSCC.LastUpdateDate = (SELECT MAX(LastUpdateDate) FROM SynMirror_V_BloodUnitStatusCodeCurrent MBUSCC 
							     WHERE BUS.BloodUnitGuid = MBUSCC.BloodUnitGuid AND BUS.LastUpdateDate >= MBUSCC.LastUpdateDate)

	JOIN dbo.BloodUnit ON dbo.BloodUnit.BloodUnitGUID = BUS.BloodUnitGUID

	JOIN dbo.UnitStatus ON dbo.UnitStatus.UnitStatusCode = BUSCC.UnitStatusCode

	JOIN dbo.BloodProduct ON dbo.BloodProduct.BloodProductGuid = dbo.BloodUnit.BloodProductGuid

	WHERE	BUS.MirrorDate BETWEEN @startdate  AND  @enddate
	AND	dbo.BloodUnit.DivisionCode = @divisioncode

UNION
	SELECT
		BUS.BloodUnitGuid,
		BUS.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUSCC.LastUpdateDate) AS MirrorDate,

		BUSCC.LastUpdateUser,
		BUS.UnitStatusComments,
		BUSCC.UnitStatusCode,
		BUS.BiohazardousWarningIndicator,
		BUS.LastUpdateFunctionId,
		dbo.UnitStatus.UnitStatusText,
		dbo.BloodUnit.EyeReadableUnitID,
		dbo.BloodProduct.ProductName,
		dbo.BloodProduct.ProductCode

	FROM SynMirror_V_BloodUnitStatusCodeCurrent BUSCC

	JOIN SynMirror_V_BloodUnitStatus BUS
				ON BUSCC.BloodUnitGuid = BUS.BloodUnitGuid
				AND BUSCC.LastUpdateDate >= BUS.LastUpdateDate
				AND BUS.LastUpdateDate = (SELECT MAX(LastUpdateDate) FROM SynMirror_V_BloodUnitStatus MBUS
							     WHERE BUSCC.BloodUnitGuid = MBUS.BloodUnitGuid AND BUSCC.LastUpdateDate >= MBUS.LastUpdateDate)
		
	JOIN dbo.BloodUnit ON dbo.BloodUnit.BloodUnitGUID = BUSCC.BloodUnitGUID

	JOIN dbo.UnitStatus ON dbo.UnitStatus.UnitStatusCode = BUSCC.UnitStatusCode

	JOIN dbo.BloodProduct ON dbo.BloodProduct.BloodProductGuid = dbo.BloodUnit.BloodProductGuid

	WHERE	BUSCC.MirrorDate BETWEEN @startdate  AND  @enddate
	AND	dbo.BloodUnit.DivisionCode = @divisioncode

	ORDER BY

		BUS.BloodUnitGuid,
		MirrorDate DESC

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO ERR_HANDLER

SET NOCOUNT OFF

RETURN (@ERROR)

ERR_HANDLER:

	SET NOCOUNT OFF
	RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodUnitStatus] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditBloodUnitTest]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the blood unit test audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditBloodUnitTest]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS


/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VBUT.BloodUnitGuid,
		VBUT.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  VBUT.LastUpdateDate) AS MirrorDate,

		VBUT.LastUpdateUser,
		VBUT.BloodTestTypeId,
		VBUT.TestResultId,
		VBUT.RecordStatusCode,
		VBUT.ConfirmationWorklistUnitGuid,
		VBUT.TestComments,
		VBUT.LastUpdateFunctionId,
		BTT.BloodTestName,
		BU.EyeReadableUnitID,
		BP.ProductName,
		BP.ProductCode

	FROM

		SynMirror_V_BloodUnitTest VBUT

	JOIN dbo.BloodUnit BU ON BU.BloodUnitGUID = VBUT.BloodUnitGUID

	JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = VBUT.BloodTestTypeId

	JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BU.BloodProductGuid

	WHERE

		VBUT.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VBUT.DivisionCode = @divisioncode AND

		(BTT.BloodTestName LIKE ''%Interp'' OR

		 BTT.BloodTestName LIKE ''%CMV'' ) AND

		VBUT.BloodTestTypeId <> 102 --no xmatch


	ORDER BY

		VBUT.BloodUnitGuid,
		VBUT.BloodTestTypeId,
		VBUT.Source,
		VBUT.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditBloodUnitTest] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditComponentClass]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Component Class audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/17/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAuditComponentClass]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VCCP.ComponentClassParameterGUID,
		VCCP.SpecimenRequiredIndicator,
		VCCP.MaximumTransfusionTime,
		VCCP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  VCCP.LastUpdateDate) AS MirrorDate,

		VCCP.LastUpdateUser,
		dbo.ComponentClass.ComponentClassName

	FROM

		SynMirror_V_ComponentClassParameter VCCP

	JOIN dbo.ComponentClass ON dbo.ComponentClass.ComponentClassID = VCCP.ComponentClassID

	WHERE

		VCCP.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VCCP.DivisionCode = @divisioncode

	ORDER BY

		VCCP.ComponentClassParameterGUID,
		VCCP.Source,
		VCCP.MirrorId DESC

SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditComponentClass] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditConfigureTesting]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Configure Testing audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditConfigureTesting]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VVD.DivisionCode,
		VVD.DivisionName,
		VVD.AntibodyScreenDisplayCode,
		VVD.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,   VVD.LastUpdateDate) AS MirrorDate,

		VVD.LastUpdateUser,
		dbo.AntibodyScreenDisplay.AntibodyScreenDisplayText

	FROM

		SynMirror_V_VamcDivision VVD

	JOIN dbo.AntibodyScreenDisplay ON dbo.AntibodyScreenDisplay.AntibodyScreenDisplayCode = VVD.AntibodyScreenDisplayCode

	WHERE

		VVD.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VVD.DivisionCode = @divisioncode

	ORDER BY

		VVD.DivisionCode,
		VVD.Source,
		VVD.MirrorId DESC

SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditConfigureTesting] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditDailyControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Daily Control audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/17/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	01/25/2006	K. Dobranowski	Added columns PrimaryEnhancementMediaId, SecondaryEnhancementMediaId, NumberOfRacks, DailyAlertTime (CR 1498)
**	02/11/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	03/30/2006	K. Dobranowski	Added time zone conversion for daily alert time (CR 1769)
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditDailyControl]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS


/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VDC.DailyControlGUID,
		VDC.CommercialTemplateIndicator,
		VDC.RackNamesIndicator,
		VDC.RecordStatusCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VDC.DailyAlertTime) AS DailyAlertTime,
		VDC.PrimaryEnhancementMediaId,
		VDC.SecondaryEnhancementMediaId,
		VDC.NumberOfRacks,
		VDC.Comments,
		VDC.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VDC.LastUpdateDate) AS MirrorDate,

		VDC.LastUpdateUser

	FROM

		SynMirror_V_DailyControl VDC

	WHERE

		VDC.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VDC.DivisionCode = @divisioncode

	AND

		VDC.RecordStatusCode = ''A''

	ORDER BY

		VDC.RecordStatusCode,
		VDC.MirrorDate DESC,
		VDC.Source

SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditDailyControl] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditDivision]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Division audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/13/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/24/2007	K. Dobranowski Changed all JOINS to LEFT JOINS (CR 2312)
**	10/25/2007	K. Dobranowski Added PrinterName to SELECT statement (CR 2320)
**	10/02/2009	K.Dobranowski Added ReactivityPhaseCode to SELECT statement (CR 2717)
**	08/18/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/14/2016	Pablo Sanchez	Removed LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber columns and added LabelPrinterEndPointId column (Defect 340457).
**	10/02/2016	K. Dobranowski	Added second SELECT to get the Label Printer IP and Port (Defect 340457).
**	02/14/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/29/2017	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159).
**	03/30/2017	K. Adu-Poku	Removed DaylightSavingsStartDate and DaylightSavingsEndDate (Task 499503).
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditDivision]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VVD.DivisionCode,
		VVD.DivisionName,
		VVD.ServiceTypeIndicator,
		dbo.Facility.FacilityName,
		VVD.RecordStatusCode,
		VVD.LabelPrinterUseIndicator,
		VVD.AccessionAreaId,
		VVD.LockInactivityTimeoutMin,	
		dbo.TimeZone.TimeZoneName,
		dbo.DaylightSavingsType.DaylightSavingsTypeText,
		VVD.ElectronicCrossmatchIndicator,
		VVD.IccbbaRegistrationNumber,
		VVD.MaximumSpecimenExpirationDays,
		VVD.MedicalDirectorName,
		VVD.LoginMessageText,
		VVD.InvoiceTemplateText,
		dbo.AntibodyScreenDisplay.AntibodyScreenDisplayText,
		VVD.MirrorId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VVD.LastUpdateDate) AS MirrorDate,
		VVD.LastUpdateUser,
		VVD.PrinterName,
		VVD.ReactivityPhaseCode,
		VVD.LabelPrinterEndPointId

	FROM

		dbo.SynMirror_V_VamcDivision VVD

	LEFT JOIN dbo.Facility ON dbo.Facility.FacilityGuid = VVD.FacilityGuid

	LEFT JOIN dbo.TimeZone ON dbo.TimeZone.TimeZoneId = VVD.TimeZoneId
	LEFT JOIN dbo.AntibodyScreenDisplay ON dbo.AntibodyScreenDisplay.AntibodyScreenDisplayCode = VVD.AntibodyScreenDisplayCode
	LEFT JOIN dbo.DaylightSavingsType ON dbo.DaylightSavingsType.DaylightSavingsTypeId = VVD.DaylightSavingsTypeId
	
	WHERE

		VVD.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VVD.DivisionCode = @divisioncode
	
	ORDER BY

		VVD.DivisionCode,
		VVD.Source,
		VVD.MirrorId DESC

	--getting label printer IP and Port
	SELECT

		VD.DivisionCode,
		VD.DivisionName,
		VEP.EndPointPort,
		VEP.EndPointAddress,
		VEP.MirrorId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,
		VEP.LastUpdateUser

	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	LEFT JOIN dbo.VamcDivision VD ON VD.LabelPrinterEndPointId = VEP.VbecsEndPointId
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VD.DivisionCode = @divisioncode
	
	ORDER BY

		VD.DivisionCode,
		VEP.Source,
		VEP.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditDivision] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditHcpcs]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get HCPCS audit information
**	Author: Krzysztof Dobranowski
**
**	Date:   02/13/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditHcpcs]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS


/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT


	SELECT

		VHA.HcpcsAssignmentGUID,
		VHA.BloodProductGUID,
		VHA.HcpcsCode,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VHA.AssignedDate) 		AS AssignedDate,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VHA.UnAssignedDate) 	AS UnAssignedDate,

		VHA.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VHA.LastUpdateDate)		 AS MirrorDate,

		VHA.LastUpdateUser,
		dbo.BloodProduct.ProductName,
		dbo.BloodProduct.ProductCode
	
	FROM

		SynMirror_V_HcpcsAssignment VHA

	JOIN dbo.BloodProduct ON dbo.BloodProduct.BloodProductGUID = VHA.BloodProductGUID
	
	WHERE

		VHA.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VHA.DivisionCode = @divisioncode
	
	ORDER BY

		VHA.BloodProductGUID,
		VHA.MirrorDate DESC,
		VHA.HcpcsAssignmentGUID,
		VHA.MirrorId DESC

SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditHcpcs] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditInappropriateRequestIndicators]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Inappropriate Request Indicators audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/17/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditInappropriateRequestIndicators]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS


/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VSTT.SpecimenTestThresholdGUID,
		VSTT.VistaLaboratoryTestName,
		VSTT.LabTestID,
		VSTT.ThresholdResult,
		VSTT.RecordStatusCode,
		VSTT.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VSTT.LastUpdateDate) AS MirrorDate,

		VSTT.LastUpdateUser,
		dbo.SpecimenType.SpecimenTypeText,
		dbo.ComponentClass.ComponentClassName
	
	FROM

		SynMirror_V_SpecimenTestThreshold VSTT

	JOIN dbo.SpecimenType ON dbo.SpecimenType.SpecimenTypeCode = VSTT.SpecimenTypeCode

	JOIN dbo.ComponentClass ON dbo.ComponentClass.ComponentClassID = VSTT.ComponentClassID
	
	WHERE

		VSTT.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VSTT.DivisionCode = @divisioncode AND

		VSTT.ReportTypeID = 9
	
	ORDER BY

		VSTT.SpecimenTestThresholdGUID,
		VSTT.Source,
		VSTT.MirrorId DESC


SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditInappropriateRequestIndicators] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditInterfaceControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Interface Control audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/18/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	07/17/2007	K. Dobranowski  Fixed names of two columns InterfaceFacilityId and VbecsFacilityId (was InterfaceFacilityID and VbecsFacilityID) CR 1979
**	07/17/2007	K. Dobranowski	Added InterfaceDomainName to SELECT statement CR 2267
**	11/14/2008	M. Smith	Changed to get the InterfaceName from the new Interface reference table.  CR 2516
**	12/17/2008	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/16/2010	K. Dobranowski	Added InterfaceActiveIndicator (CR 2940)
**	04/04/2011	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/30/2016	K. Dobranowski	I rewrote this stored procedure to acommodate latest DB design changes for interface configuration (Defect 340457).
**	10/25/2016	K. Dobranowski	Fixed select getting the inteface IP and Port to use direct link from EndPoint to Interface table (Defect 340457).
**	02/14/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/30/2017	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159).
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditInterfaceControl]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	--this SELECT returns VBECS IP and Port
	SELECT

		VEP.EndPointAddress AS VbecsIPAddress,
		VEP.EndPointPort AS VbecsPortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = ''VBECS_EndPoint'' AND VGC.ApplicationName = ''HL7Service''
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

	--this SELECT returns Interface IP and Port
	SELECT

		I.InterfaceId,
		I.InterfaceName,
		VEP.EndPointAddress AS InterfaceIPAddress,
		VEP.EndPointPort AS InterfacePortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.Interface	I
		ON I.VbecsEndPointId = VEP.VbecsEndPointId   
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	AND VEP.EndPointType IS NOT NULL
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

  	--this SELECT returns Interface Status and Facility ID
	SELECT

		I.InterfaceId,
		I.InterfaceName,
		VGC.ParameterName,
		VGC.ParameterValue,
		VGC.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VGC.LastUpdateDate) AS MirrorDate,

		VGC.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsGlobalConfig VGC

	JOIN dbo.Interface	I
		ON VGC.ParameterName LIKE I.ConfigPrefix + ''%''   
	
	WHERE

		VGC.ApplicationName = ''HL7Service''
	AND	(VGC.ParameterName LIKE ''%FacilityID'' OR VGC.ParameterName LIKE ''%IsActive'')
	AND	VGC.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		I.InterfaceId,
		VGC.ParameterName,
		VGC.Source,
		VGC.MirrorId DESC   
		
		--this SELECT returns AckTimeout, ReTransmitAttempts and Email that are common for all interfaces
	SELECT

		VGC.ParameterName,
		VGC.ParameterValue,
		VGC.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VGC.LastUpdateDate) AS MirrorDate,

		VGC.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsGlobalConfig VGC

	WHERE

		VGC.ApplicationName = ''HL7Service''
	AND	VGC.ParameterName IN (''VBECS_AckTimeout'', ''VBECS_EmailAlertAddress'',''VBECS_ReTransmitAttempts'')
	AND	VGC.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VGC.ParameterName,
		VGC.Source,
		VGC.MirrorId DESC 
		  
SET @ERROR = @@ERROR



SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)


' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditInterfaceControl] TO [VbecsAppUser] AS [dbo]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditLocalSupplier]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the local supplier audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/12/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	11/18/2005	K. Dobranowski	Changed LocalSupplierGUID to LocalSupplierGuid to fix the problem described in CR 1314
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditLocalSupplier]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VLS.LocalSupplierGuid,
		VLS.MirrorId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VLS.LastUpdateDate) AS MirrorDate,
		VLS.LastUpdateUser,
		VLS.FacilityName,
		VLS.FdaRegistrationNumber,
		VLS.FacilityPrefix,
		VLS.IccbbaRegistrationNumber,
		VLS.RecordStatusCode,
		VLS.CollectionIndicator,
		VLS.TestingIndicator,
		VLS.LabelUnitIdTrimIndicator,
		VLS.PhoneNumber,
		VLS.FaxNumber,
		VA.AddressLine1,
		VA.AddressLine2,
		VA.AddressLine3,
		VA.AddressCity,
		VA.StateCode,
		VA.AddressZipCode
	
	FROM

		SynMirror_V_LocalSupplier VLS

	LEFT JOIN SynMirror_V_Address VA ON 

		VA.AddressGUID = VLS.AddressGUID AND

					VA.LastUpdateDate = VLS.LastUpdateDate
	
	WHERE

		VLS.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VLS.DivisionCode = @divisioncode
	
	ORDER BY

		VLS.LocalSupplierGuid,
		VLS.Source,
		VLS.MirrorId DESC

SET @ERROR = @@ERROR
	
SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditLocalSupplier] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditMsbos]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get MSBOS audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditMsbos]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS


/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VMSBOS.MsbosGUID,
		VMSBOS.SurgeryName,
		VMSBOS.TypeAndScreenIndicator,
		VMSBOS.NoBloodRequiredIndicator,
		VMSBOS.RecordStatusCode,
		VMSBOS.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VMSBOS.LastUpdateDate) AS MirrorDate,

		VMSBOS.LastUpdateUser
	
	FROM

		SynMirror_V_MSBOS VMSBOS
	
	WHERE
		VMSBOS.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VMSBOS.DivisionCode = @divisioncode
	
	ORDER BY

		VMSBOS.MsbosGUID,
		VMSBOS.Source,
		VMSBOS.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditMsbos] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditMsbosComponentClass]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get MSBOS Component Class audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditMsbosComponentClass]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VMCC.MsbosGUID,
		VMCC.MaximumSetupUnitQuantity,
		VMCC.RecordStatusCode,
		VMCC.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VMCC.LastUpdateDate) AS MirrorDate,

		VMCC.LastUpdateUser,
		dbo.ComponentClass.ComponentClassShortName,
		dbo.Msbos.SurgeryName
	
	FROM

		SynMirror_V_MSBOSComponentClass VMCC

	JOIN dbo.ComponentClass ON dbo.ComponentClass.ComponentClassID = VMCC.ComponentClassID

	JOIN dbo.Msbos ON dbo.Msbos.MsbosGUID = VMCC.MsbosGUID
	
	WHERE

		VMCC.MirrorDate BETWEEN @startdate  AND  @enddate
	AND
		Msbos.DivisionCode = @divisioncode
	
	ORDER BY

		VMCC.MsbosGUID,
		VMCC.ComponentClassID,
		VMCC.Source,
		VMCC.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditMsbosComponentClass] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the Patient audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/09/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	05/27/2004 	M.Jablsonki		Added Time Zone function
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	11/18/2005	K. Dobranowski	Changed PatientGUID to PatientGuid to fix the problem described in CR 1314
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	04/22/2006	Lohse		Adding DateTime Conversion to LastUpdateDate
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAuditPatient]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		PatientGuid,
		PatientFirstName,
		PatientLastName,
		PatientSSN,
		MirrorId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, LastUpdateDate)	AS LastUpdateDate,
		LastUpdateUser

	FROM

		SynMirror_V_Patient VP
	
	WHERE

		MirrorDate BETWEEN @startdate  AND  @enddate

	ORDER BY

		VP.PatientGuid,
		VP.Source,
		VP.MirrorId DESC

SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditProductModificationParameter]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the product modification parameter audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	11/22/2004	C. Taylor		Added ProductModificationCost
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAuditProductModificationParameter]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VPMP.ProductModificationParameterGUID,
		VPMP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VPMP.LastUpdateDate) AS MirrorDate,

		VPMP.LastUpdateUser,
		VPMP.RecordStatusCode,
		VPMP.ProductModificationCost,
		PM.ProductModificationText

	FROM

		SynMirror_V_ProductModificationParameter VPMP

	JOIN dbo.ProductModification PM ON PM.ProductModificationCode = VPMP.ProductModificationCode
	
	WHERE

		VPMP.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VPMP.DivisionCode = @divisioncode
	
	ORDER BY

		VPMP.ProductModificationParameterGUID,
		VPMP.Source,
		VPMP.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditProductModificationParameter] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditProductShipper]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the product shipper audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/12/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditProductShipper]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VPS.ProductShipperGUID,

		VPS.BloodProductGuid,

		VPS.ReturnCreditPercentage,

		VPS.ProductCost,

		VPS.RecordStatusCode,

		VPS.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VPS.LastUpdateDate) AS MirrorDate,

		VPS.LastUpdateUser,

		dbo.LocalSupplier.FacilityName,

		dbo.LocalSupplier.FdaRegistrationNumber,

		dbo.BloodProduct.ProductName,

		dbo.BloodProduct.ProductCode

	FROM

		SynMirror_V_ProductShipper VPS

	JOIN dbo.LocalSupplier ON dbo.LocalSupplier.LocalSupplierGUID = VPS.LocalSupplierGUID

	JOIN dbo.BloodProduct ON dbo.BloodProduct.BloodProductGuid = VPS.BloodProductGuid
	
	WHERE

		VPS.MirrorDate  BETWEEN @startdate  AND  @enddate

	AND

		VPS.DivisionCode = @divisioncode
	
	ORDER BY

		VPS.BloodProductGuid,
		VPS.ProductShipperGUID,
		VPS.Source,
		VPS.MirrorId DESC


SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditProductShipper] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditReagentTestParameter]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Reagent Test Control audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/17/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetAuditReagentTestParameter]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT
		VRTP.ReagentTypeID,
		VRTP.DailyUseIndicator,
		VRTP.MustUseIndicator,
		VRTP.TestWithName,
		VRTP.SetVialID,
		VRTP.RecordStatusCode,
		VRTP.ExpectedMinimumReactions,
		VRTP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VRTP.LastUpdateDate) AS MirrorDate,

		VRTP.LastUpdateUser,
		RT.ReagentTypeName
	
	FROM

		SynMirror_V_ReagentTestParameter VRTP

	JOIN dbo.ReagentType RT ON RT.ReagentTypeID = VRTP.ReagentTypeID
	
	WHERE

		VRTP.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VRTP.DivisionCode = @divisioncode
	
	ORDER BY

		VRTP.CommercialIndicator,
		VRTP.SortColumn,
		VRTP.ReagentTypeID,
		VRTP.SetVialID,
		VRTP.TestWithName,
		VRTP.MirrorDate DESC,
		VRTP.RecordStatusCode,
		VRTP.Source,
		VRTP.MirrorId DESC

SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditReagentTestParameter] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditReagentTypeParameter]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Reagent Type Parameter audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/18/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditReagentTypeParameter]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT
		VRTP.ReagentTypeParameterGUID,
		VRTP.MinimumStockLevel,
		VRTP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VRTP.LastUpdateDate) AS MirrorDate,

		VRTP.LastUpdateUser,
		RT.ReagentTypeName
	
	FROM

		SynMirror_V_ReagentTypeParameter VRTP

	JOIN dbo.ReagentType RT ON RT.ReagentTypeID = VRTP.ReagentTypeID

	
	WHERE

		VRTP.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VRTP.DivisionCode = @divisioncode
	
	ORDER BY

		VRTP.ReagentTypeParameterGUID,
		VRTP.Source,
		VRTP.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditReagentTypeParameter] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditSI]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the special instruction audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   06/21/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	--------------------	-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	08/17/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Specified object owners, aliased Tables, spaced out SQL, placed input params in brackets, added error variable
**					Changed MirrorDate filter to use BETWEEN instead of => <=
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditSI]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)

 AS

SET NOCOUNT ON

DECLARE @ERROR INT

--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ON_ERROR

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ON_ERROR

SELECT

	VMP.PatientSpecialInstructionGUID,
	VMP.MirrorId,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VMP.LastUpdateDate) AS MirrorDate,
	VMP.LastUpdateUser,
	VMP.PatientSpecialInstructions,
	VMP.RecordStatusCode,
	VMP.InactivationComment,
	P.PatientFirstName,
	P.PatientLastName,
	P.DisplayVistaPatientId

FROM

	SynMirror_V_PatientSpecialInstruction VMP

		JOIN dbo.Patient P ON 

			P.PatientGUID = VMP.PatientGUID

WHERE


	(VMP.MirrorDate BETWEEN  @startdate AND @enddate)  AND

	VMP.DivisionCode = @divisioncode

ORDER BY

	VMP.PatientSpecialInstructionGUID,
	VMP.Source,
	VMP.MirrorId DESC

	SET @ERROR = @@ERROR

ON_ERROR:

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditSI] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditSpecimenTest]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the specimen test audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   05/25/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	8/5/2004	K. Dobranowski		Modified Order By clause.

**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	05/25/2006	K. Dobranowski	Added AntibodyTypeName and sorting by AntibodyTypeId to fix display of ABID results (CR 1851)
**	05/25/2006	K. Dobranowski Added SpecimenUid and sorting by SpecimenUid to fix display of TRW results (CR 1852)
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditSpecimenTest]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT
		VST.OrderedTestGuid,
		VST.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  VST.LastUpdateDate) AS MirrorDate,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  VST.TestDate) AS TestDate,

		VST.LastUpdateUser,
		VST.BloodTestTypeId,
		VST.TestResultId,
		VST.RecordStatusCode,
		VST.TestComments,
		VST.AboRhChangeIndicator,
		VST.AboRhChangeJustification,
		VST.LastUpdateFunctionId,
		VST.AntibodyTypeId,
		VST.PatientSpecimenGuid,
		BTT.BloodTestName,
		OBT.OrderableTestName,
		P.PatientFirstName,
		P.PatientLastName,
		P.DisplayVistaPatientId,
		P.PatientGuid,
		AT.AntibodyTypeName,
		PS.SpecimenUid
	
	FROM

		SynMirror_V_SpecimenTest VST

	JOIN dbo.OrderedTest OT ON OT.OrderedTestGuid = VST.OrderedTestGuid

	JOIN dbo.PatientOrder PO ON PO.PatientOrderGuid = OT.PatientOrderGuid

	JOIN dbo.PatientTreatment PT ON PT.PatientTreatmentGuid = PO.PatientTreatmentGuid

	JOIN dbo.Patient P ON P.PatientGuid = PT.PatientGuid

	JOIN dbo.OrderableTest OBT ON OBT.OrderableTestID = OT.OrderableTestID

	JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = VST.BloodTestTypeId
   LEFT JOIN dbo.AntibodyType AT ON AT.AntibodyTypeId = VST.AntibodyTypeId
	JOIN dbo.PatientSpecimen PS ON PS.PatientSpecimenGuid = VST.PatientSpecimenGuid
	
	WHERE

		VST.MirrorDate  BETWEEN @startdate  AND  @enddate

	AND

		VST.DivisionCode = @divisioncode
	
	ORDER BY

		VST.OrderedTestGuid,
		VST.TestDate,
		VST.BloodTestTypeId,
		VST.AntibodyTypeId,
		PS.SpecimenUid,
		VST.Source,
		VST.MirrorId DESC

SET @ERROR = @@ERROR

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditSpecimenTest] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditTR]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get the transfusion requirements audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/10/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	04/21/2005	C. Taylor		Remove InactivationDetails column
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditTR]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VPTR.PatientTransfusionRequirementGUID,
		VPTR.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VPTR.LastUpdateDate) AS MirrorDate,

		VPTR.LastUpdateUser,
		VPTR.TransfusionRequirementText,
		VPTR.RecordStatusCode,
		VPTR.InactivationComment,
		TRC.TransfusionRequirementCategoryText,
		P.PatientFirstName,
		P.PatientLastName,
		P.DisplayVistaPatientId

	FROM

		SynMirror_V_PatientTransfusionRequirement VPTR

	JOIN dbo.Patient P ON P.PatientGUID = VPTR.PatientGUID

	JOIN dbo.TransfusionRequirementCategory TRC ON TRC.TransfusionRequirementCategoryCode = 
				VPTR.TransfusionRequirementCategoryCode
	
	WHERE

		VPTR.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VPTR.CreateDivisionCode = @divisioncode
	
	ORDER BY

		VPTR.PatientTransfusionRequirementGUID,
		VPTR.Source,
		VPTR.MirrorId DESC

SET @ERROR = @@ERROR
	


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditTR] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditTransfusionComplications]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Transfusion Complications audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/17/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditTransfusionComplications]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VSTT.SpecimenTestThresholdGUID,
		VSTT.VistaLaboratoryTestName,
		VSTT.LabTestID,
		VSTT.ThresholdResult,
		VSTT.RecordStatusCode,
		VSTT.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VSTT.LastUpdateDate) AS MirrorDate,

		VSTT.LastUpdateUser,
		ST.SpecimenTypeText
	
	FROM

		SynMirror_V_SpecimenTestThreshold VSTT

	JOIN dbo.SpecimenType ST ON ST.SpecimenTypeCode = VSTT.SpecimenTypeCode
	
	WHERE

		VSTT.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VSTT.DivisionCode = @divisioncode AND

		VSTT.ReportTypeID = 7
	
	ORDER BY

		VSTT.SpecimenTestThresholdGUID,
		VSTT.Source,
		VSTT.MirrorId DESC

SET @ERROR = @@ERROR
	

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditTransfusionComplications] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditTransfusionEffectiveness]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Transfusion Effectiveness audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/17/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditTransfusionEffectiveness]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VSTT.SpecimenTestThresholdGUID,
		VSTT.VistaLaboratoryTestName,
		VSTT.LabTestID,
		VSTT.RecordStatusCode,
		VSTT.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VSTT.LastUpdateDate) AS MirrorDate,

		VSTT.LastUpdateUser,
		ST.SpecimenTypeText
	
	FROM

		SynMirror_V_SpecimenTestThreshold VSTT

	JOIN dbo.SpecimenType ST ON ST.SpecimenTypeCode = VSTT.SpecimenTypeCode
	
	WHERE

		VSTT.MirrorDate  BETWEEN @startdate  AND  @enddate

	AND

		VSTT.DivisionCode = @divisioncode AND

		VSTT.ReportTypeID = 8
	
	ORDER BY

		VSTT.SpecimenTestThresholdGUID,
		VSTT.Source,
		VSTT.MirrorId DESC

SET @ERROR = @@ERROR
	


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditTransfusionEffectiveness] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditUser]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/********************************************************************************************************************************
**	Desc: 	Get User audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   06/22/2005
**
*********************************************************************************************************************************
**	Modified:
**	Date		Name			Defect	Description
**	----------	---------		------	--------------------------------------------------------------
**	08/17/2005	N.Paterson				** Reviewed for compliance with database standards and recommendations **
**										Specified object owners, aliased Tables, spaced out SQL, placed input params in brackets, added error variable
**										Changed MirrorDate filter to use BETWEEN instead of => <=
**  12/29/2015	Lohse			251166	Adding VbecsUserGuid for sorting info (key field), adding UserName, changing sort order
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditUser]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

SET NOCOUNT ON

DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ON_ERROR

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ON_ERROR

SELECT

	VMU.VbecsUserGuid,		--added GL
	VMU.VbecsUserId,
	VMU.UserName,
	VMU.UserDUZ,
	VMU.VistaUserName,
	VMU.UserEmail,
	VMU.UserInitials,
	VMU.RecordStatusCode,
	VMU.MirrorId,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VMU.LastUpdateDate) AS MirrorDate,
	VMU.LastUpdateUser

FROM

	dbo.SynMirror_V_VbecsUser VMU

WHERE

	VMU.MirrorDate BETWEEN @startdate AND @enddate

ORDER BY

	VMU.VbecsUserGuid,		--changed (from VbecsUserId) to use the key field in DAL
	VMU.Source,
	VMU.MirrorId DESC

SET @ERROR = @@ERROR

ON_ERROR:

SET NOCOUNT OFF

RETURN (@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditUser] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditUserAlerts]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get User Alerts audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/18/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditUserAlerts]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VVD.DivisionCode,
		VVD.DivisionName,
		VVD.PrinterAlertsIndicator,
		VVD.PrinterAlertsPrinterName,
		VVD.PrinterOrderAlertTypeCode,
		VVD.PrinterOrdersNeededHours,
		VVD.IconAlertsIndicator,
		VVD.IconRefreshRate,
		VVD.IconOrderAlertTypeCode,
		VVD.IconOrdersNeededHours,
		VVD.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VVD.LastUpdateDate) AS MirrorDate,

		VVD.LastUpdateUser
	
	FROM

		SynMirror_V_VamcDivision VVD
	
	WHERE

		VVD.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VVD.DivisionCode = @divisioncode
	
	ORDER BY

		VVD.DivisionCode,
		VVD.Source,
		VVD.MirrorId DESC

SET @ERROR = @@ERROR
	
SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditUserAlerts] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditUserRole]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/********************************************************************************************************************************
**	Desc: 	Get User Role audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/17/2004
**
*********************************************************************************************************************************
**	Modified:
**	Date		Name			Defect	Description
**	----------	---------		------	--------------------------------------------------------------
**	04/27/2004	M. Jablonski			Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson				** Reviewed for compliance with database standards and recommendations **
**										Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**										Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/19/2005	N.Paterson				Implemented differences between Review_Start and DEV before porting changes to DEV
**	12/29/2015	Lohse			251166	Adding VbecsUserGuid for sorting info (key field), adding UserName, changing sort order
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditUserRole]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)


SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT
		
		VU.VbecsUserGuid,
		VVUDR.UserRoleId,
		VVUDR.RecordStatusCode,
		VVUDR.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VVUDR.LastUpdateDate) AS MirrorDate,

		VVUDR.LastUpdateUser,
		VU.UserName,
		VU.VbecsUserId,
		UR.UserRoleName
	
	FROM

		dbo.SynMirror_V_VbecsUserDivisionRole VVUDR

	JOIN dbo.VbecsUser VU ON VU.VbecsUserId = VVUDR.VbecsUserId

	JOIN dbo.UserRole UR ON UR.UserRoleId = VVUDR.UserRoleId
	
	WHERE

		VVUDR.MirrorDate  BETWEEN @startdate  AND  @enddate

	AND

		VVUDR.DivisionCode = @divisioncode
	
	ORDER BY

		VU.VbecsUserGuid,	--changed (from VbecsUserId) to use the key field in DAL
		VVUDR.Source,
		VVUDR.MirrorId DESC


SET @ERROR = @@ERROR
	

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditUserRole] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditVistALinkControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get VistALink Control audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/10/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	07/26/2007	K. Dobranowski	Added VistaDomainName to SELECT statement (CR 2267)
**	02/19/2014	C. Jensen	Added VVC.VbecsServiceIpAddress, VVC.VbecsServicePortNumber to SELECT statement. (CR 3149)
**	04/28/2014	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/30/2016	K. Dobranowski Updated sproc to select values from EndPoint and GlobalConfig (Defect 340457).
**	10/25/2016	K. Dobranowski Removed LEFT from JOINs (Defect 340457).
**	02/13/2017	K. Dobranowski Added new SELECT to get the broker IP and Port (Task 459208).
**	02/14/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/30/2017	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditVistALinkControl]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

SET NOCOUNT ON
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	--this SELECT returns VBECS IP and Port
	SELECT

		VEP.EndPointAddress AS VbecsServiceIpAddress,
		VEP.EndPointPort AS VbecsServicePortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = ''VBECS_EndPoint'' AND VGC.ApplicationName = ''VistALinkService''
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

	--this SELECT returns Vista IP and Port
	SELECT

		VEP.EndPointAddress AS VistaIpAddress,
		VEP.EndPointPort AS VistaPortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = ''Interface_Vista_EndPoint'' AND VGC.ApplicationName = ''Vbecs''
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

	--this SELECT returns Broker IP and Port
	SELECT

		VEP.EndPointAddress AS BrokerIpAddress,
		VEP.EndPointPort AS BrokerPortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = ''Interface_Vista_BrokerEndPoint'' AND VGC.ApplicationName = ''Vbecs''
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC


SET @ERROR = @@ERROR
	

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditVistALinkControl] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetAuditWorkload]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get Workload audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditWorkload]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
 AS

 SET NOCOUNT ON

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VWP.WorkloadProcessGUID,
		VWP.WorkloadCode,
		VWP.WorkloadProcedure,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  VWP.AssignedDate) AS AssignedDate,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  VWP.UnAssignedDate) AS UnAssignedDate,

		VWP.RecordStatusCode,
		VWP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VWP.LastUpdateDate) AS MirrorDate,

		VWP.LastUpdateUser,
		VP.VbecsProcessName
	
	FROM

		SynMirror_V_WorkloadProcess VWP

	JOIN dbo.VbecsProcess VP ON VP.VbecsProcessID = VWP.VbecsProcessID
	
	WHERE

		VWP.MirrorDate  BETWEEN @startdate  AND  @enddate

	AND

		VWP.DivisionCode = @divisioncode
	
	ORDER BY

		VWP.WorkloadProcessGUID,
		VWP.Source,
		VWP.MirrorId DESC

SET @ERROR = @@ERROR
	

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetAuditWorkload] TO [VbecsAppUser] AS [dbo]
GO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodAvailabilityItems]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/************************************************************************************************************
**	Desc: 	Get Blood Unit Items for the Blood Availability Report
**
**	Author: Rob Heiberger
**
**	Date:   03/10/2004
**
*************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-----------	---------		------------------
**	4/19/04		C. Taylor		Replaced PatientSSN with DisplayVistaPatientId and added TestingStatusText, QurantineIndicator and Biohazardous indicator
**	03/29/2005	Lohse			Added RecordStatusCode to BloodUnitModification table join
**	05/26/2005	Lohse			PooledUnitsCount is now a function.
**	07/14/2005	N.Paterson		** Reviewed for compliance with database standards and recommendations **
**								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, 
**								Specified object owners in SQL
**								Using EXEC and dynamic SQL for a dynamic WHERE clause, consider using this approach instead:
**								WHERE Cus_Name = COALESCE(@Cus_Name,Cus_Name) AND
**									Cus_City = COALESCE(@Cus_City,Cus_City) AND
**									Cus_Country = COALESCE(@Cus_Country,Cus_Country)
**								SQL CODE IS SIMILAR TO THE OTHER "GETBLOODAVAILABILITY" PROCEDURES, CONSIDER USING A COMMON VIEW
**
**	07/28/2005	J.Engstrom		Cannot modify this SP in a manner similar to the other "spGetBloodAvailibility..." procedures because the dynamic SQL statement
**								is larger than 4000 characters, which is the limit for an NVarChar type.  NVarChar type is necessary in order to call spexecsql.
**								Modified to join on vw_BloodUnitsWithAntigensIdentified instead of fnGetUnitsWithAntigensIdentified().
**
**	08/19/2005	N.Paterson		Implemented differences between Review_Start and DEV before porting changes to DEV
**								NOTE: Do not remove joins to the following tables
**								that are already joined in the main view: BloodUnitStatus, Dontationtype, Patient, shipment as these are required and expected by the dynamic WHERE feature
**
**	08/22/2005	Lohse			Missing FROM in dynamic SQL
**	10/05/2005	C Taylor		Added ProductType join to identify modifications using ProductTypePrintName
**	01/17/2006	C. Taylor		Added FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) to ProductShortName (DR 1729)
**	01/22/2006	M Smith			** Reviewed for compliance with database standards and recommendations **
**	05/08/2015	Lohse			CR3555 - replaced (= NULL) with (IS NULL) to utilize ANSI_NULLS = ON, formating
**	05/11/2015	K. Adu-Poku		**	Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku		** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodAvailabilityItems]
	--This parameter should contain the string to filter the data.
	--The number of parameters is dynamic and we never know exactly how many 
	--there are going to be so we need to make a long string of comparisons.
(
	@WhereClause	NVARCHAR(4000),
	@divisioncode	VARCHAR(50)
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR		INT

SET NOCOUNT ON
--Query String that will be executed at the end.
DECLARE @QUERY		varchar(8000)
DECLARE @WHERE		varchar(8000)

SET @QUERY=''
	SELECT
		DISTINCT b.BloodUnitGuid,
		(SELECT 
			v.DivisionName 
		FROM 
			VamcDivision v 
		WHERE 
			v.DivisionCode=b.DivisionCode
		) as DivisionName,
		b.DivisionCode,
		b.EyeReadableUnitId,
		CASE b.LabelTypeCode
			WHEN ''''I'''' THEN b.ProductShortName+'''', ''''+b.UnitProductCode + b.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + b.UnitDivisionId 
			ELSE b.ProductShortName+'''', ''''+b.UnitProductCode
		END AS ProductShortName,
		dbo.fnGetPooledUnitsCount(b.BloodUnitGuid) AS PooledUnitsCount,
		b.BloodTypeCode,
		bt.SortColumn as ABOSortColumn,
		b.RhFactorCode,
		rh.SortColumn as RhSortColumn,
		dbo.fnTimeZoneConversionDateTime(''''''+@divisioncode+'''''', 0, b.UnitExpirationDate) AS  UnitExpirationDate,
		(CASE 
			dt.RestrictionTypeCode
		WHEN 
			''''N'''' THEN ''''Allogeneic'''' 
		WHEN 
			''''A'''' THEN ''''Autologous'''' 
		ELSE 
			''''Directed'''' 
		END
		) as DonationTypeCode,
		b.UnitStatusText,
		us.SortColumn as UnitStatusSortColumn,
		b.BiohazardousWarningIndicator,
		b.QuarantineIndicator,
		b.DirectedPatientGuid,
		b.PatientLastName as DirectedPatientLastName,
		b.PatientFirstName as DirectedPatientFirstName,
		b.PatientMiddleName as DirectedPatientMiddleName,
		ts.TestingStatusText,
		(SELECT
			iu.IssueToLocationName 
		FROM
			IssuedUnit iu 
		WHERE 
			iu.BloodUnitGuid=b.BloodUnitGuid 
		AND
			iu.ReturnDateTime IS NULL
		) as IssueToLocationName,
		cc.ComponentClassName as ComponentClassId,
		cc.SortColumn as ComponentClassSortColumn
	FROM	dbo.vw_BloodShipPatientAllCurrent b
	JOIN
		dbo.BloodType bt ON bt.BloodTypeCode= b.BloodTypeCode
	JOIN
		dbo.RhFactor rh ON 	rh.RhFactorCode=b.RhFactorCode	
	JOIN
		dbo.BloodUnitStatus s ON s.BloodUnitStatusGuid = b.BloodUnitStatusGuid	
	JOIN
		dbo.UnitStatus us ON us.UnitStatusCode=b.UnitStatusCode
	LEFT OUTER JOIN
		dbo.BloodUnitModification d ON b.BloodUnitGuid=d.FromBloodUnitGuid AND d.RecordStatusCode = ''''A''''
	LEFT OUTER JOIN
		dbo.vw_BloodUnitsWithAntigensIdentified a ON b.BloodUnitGuid=a.BloodUnitGuid			
	LEFT OUTER JOIN
		dbo.BloodUnitTest t ON b.BloodUnitGuid=t.BloodUnitGUID
	JOIN
		dbo.ComponentClass cc ON cc.ComponentClassId=b.ComponentClassId
	JOIN
		dbo.ProductType pt ON pt.ProductTypeCode=b.ProductTypeCode
	LEFT OUTER JOIN
		dbo.DonationType dt ON b.DonationTypeId=dt.DonationTypeID
	LEFT OUTER JOIN
		dbo.TestingStatus ts ON b.TestingStatusId = ts.TestingStatusId
	LEFT OUTER JOIN 
		dbo.OrderedUnit ou on b.BloodUnitGuid = ou.BloodUnitGuid AND ou.ReleaseDate IS NULL AND ou.RecordStatusCode = ''''A'''' AND ou.DivisionCode = b.DivisionCode
	LEFT OUTER JOIN 
		dbo.OrderedComponent oc on oc.OrderedComponentGuid = ou.OrderedComponentGuid 
	LEFT OUTER JOIN 
		dbo.PatientOrder po on po.PatientOrderGuid = oc.PatientOrderGuid 
	LEFT OUTER JOIN 
		dbo.PatientTreatment ptt on ptt.PatientTreatmentGuid = po.PatientTreatmentGuid
	LEFT OUTER JOIN 
		dbo.Patient pat on pat.PatientGuid = ptt.PatientGuid
	LEFT OUTER JOIN
		dbo.Shipment os on os.ShipmentGuid = b.OutgoingShipmentGuid AND os.ShipmentDate IS NOT NULL''

SET @WHERE=''
	WHERE
		''+@WhereClause+''
		AND b.RecordStatusCode = ''''A'''' 
	ORDER BY
		DivisionName, ComponentClassSortColumn, ABOSortColumn, RhSortColumn, UnitStatusSortColumn, ProductShortName, UnitExpirationDate, EyeReadableUnitId''

EXEC(@QUERY+@WHERE)

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodAvailabilityItems] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodAvailabilityPatientCount]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Get a preliminary number of rows that will be returned by this stored procedure.
**			(Using different sproc for patient count to speed up patient load)
**
**	Author: Cameron Taylor
**
**	Date:   10/06/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------		----------			-----------------
**	04/03/2006	Lohse			Changed Count(*) to Count(1) and UnitStatus IN to multiple ORs - to conform to Database standards
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodAvailabilityPatientCount]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

SELECT 
	COUNT(1) AS Total
FROM
	dbo.vw_BloodShipPatientAllCurrent b			
LEFT OUTER JOIN 
	dbo.OrderedUnit ou on b.BloodUnitGuid = ou.BloodUnitGuid AND ou.ReleaseDate IS NULL AND ou.RecordStatusCode = ''A'' AND ou.DivisionCode = b.DivisionCode
LEFT OUTER JOIN 
	dbo.OrderedComponent oc on oc.OrderedComponentGuid = ou.OrderedComponentGuid 
LEFT OUTER JOIN 
	PatientOrder po on po.PatientOrderGuid = oc.PatientOrderGuid 
LEFT OUTER JOIN 
	dbo.PatientTreatment ptt on ptt.PatientTreatmentGuid = po.PatientTreatmentGuid 
LEFT OUTER JOIN 
	dbo.Patient pat on pat.PatientGuid = ptt.PatientGuid
WHERE
	(b.DivisionCode = @divisioncode) 
AND
	(b.UnitStatusCode = ''S'' OR b.UnitStatusCode = ''C'' OR b.UnitStatusCode = ''I'')
AND
	(b.RecordStatusCode = ''A'')
AND
	(pat.PatientGuid = @patientguid)

SET NOCOUNT OFF
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodAvailabilityPatientCount] TO [VbecsAppUser] AS [dbo]
GO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodProductByCode]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc: 	Search BloodProduct table for matching entry
**
**	Author:	Cameron Taylor
**
**	Date: 	8/28/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------	----			--------------
**	03/05/03	L. Meyer		Added RowVersion
**	05/14/03	M. Smith		Added HcpcsCode and locking.
**	06/12/03	Stas Antropov	Added Top 1 to ''SELECT TOP 1 @RecordGUID = BloodProductGUID '' because there may be duplicate product codes
**	7/22/2003	C. Jensen		Removed HcpcsCode (this was breaking the sproc)
**	8/12/2003	C. Jensen		Added ProductAttributeForm
**	12/2/2003	Lohse			Added RecordStatusCode to WHERE clause to only include valid producttypes
**	03/01/2004	M.Jablonski		Added row version to SELECT, commented out BP.RowVersion, not needed since BP cannot be updated
**	11/09/2004	Lohse			Adding ComponentClassName
**	03/23/2005	Lohse			Adding fnIsProductActive to replace DSPtable  drop
**	07/14/2005	N.Paterson		** Reviewed for compliance with database standards and recommendations **
								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
								Added brackets around input parameters, Changed RecordStatusCode IN (''A'') to RecordStatusCode = ''A'' 
**	08/03/2005	Lohse			Adding divisioncode to Hcpcs table join
**	08/19/2005	N.Paterson		Implemented differences between Review_Start and DEV before porting changes to DEV
**	05/06/2015	Lohse			CR3558 - Adding new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodProductByCode]
(
	@productcode 		VARCHAR (5),
	@divisioncode 		VARCHAR(50)
)

AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
	
	SELECT

		BP.BloodProductGUID,
		PT.ComponentClassID,
		CC.ComponentClassName,
		BP.ProductCode,
		BP.ProductShortName,
		BP.ProductName,
		BP.ProductTypeCode,
		PT.ProductTypeName,
		BP.ProductVolume,
		BP.MaximumStorageTime,
		BP.ProductCodeIndicator 					AS BarcodeType,

		dbo.fnIsProductActive(BP.BloodProductGuid, @divisioncode) 	AS ProductActiveIndicator,

		ISNULL(HA.HcpcsCode,'''') 					AS HcpcsCode,
		BP.ProductAttributeForm,
		PT.AboRhConfirmationRequired	--CR3558
	
	FROM	
		dbo.BloodProduct BP
	JOIN 
		dbo.ProductType PT ON BP.ProductTypeCode = PT.ProductTypeCode
	JOIN 
		dbo.ComponentClass CC ON CC.ComponentClassId = PT.ComponentClassId
	LEFT OUTER JOIN 
		dbo.HcpcsAssignment HA ON BP.BloodProductGUID = HA.BloodProductGUID
									AND	HA.UnAssignedDate IS NULL
									AND	HA.DivisionCode = @divisioncode
	WHERE
		BP.ProductCode = @productcode
	AND	BP.RecordStatusCode = ''A'' 
	
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodProductByCode] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodProductByGuid]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc: 	Gets Blood Product information based on the blood product guid and division passed to the procedure.
**
**	Author:	Cameron Taylor
**
**	Date: 	10/3/2002
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	------		-------			-----------------
**	5/18/03		M. Smith		Added HcpcsCode
**	7/29/03		C.VanStedum		Removed HcpcsCode, not compiling
**	10/30/03	M.Jablonski		Added IFNULL check to HcpcsCode.
**	03/01/2004	M.Jablonski		Added row version to SELECT, commented out BP.RowVersion, not needed since BP cannot be updated
**	11/9/2004	Lohse			Adding ComponentClassName
**	03/23/2005	Lohse			Adding fnIsProductActive to replace DSP table drop
**	07/14/2005	N.Paterson		** Reviewed for compliance with database standards and recommendations **
								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
**	08/03/2005	Lohse			Adding DivisionCode to HcpcsAssignment table join
**	05/06/2015	Lohse			CR3558 - Adding new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodProductByGuid]
(
	@bloodproductguid AS UNIQUEIDENTIFIER,
	@divisioncode AS VARCHAR(50)
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT DISTINCT

		BP.BloodProductGUID,
		BP.ProductAttributeForm,
		PT.ComponentClassID,
		CC.ComponentClassName,
		BP.ProductCode,
		BP.ProductShortName,
		BP.ProductName,
		BP.ProductTypeCode,
		PT.ProductTypeName,
		BP.ProductVolume,
		BP.MaximumStorageTime,
		BP.ProductCodeIndicator 					AS BarcodeType,

		dbo.fnIsProductActive(BP.BloodProductGuid, @divisioncode) 	AS ProductActiveIndicator,

		ISNULL(HA.HcpcsCode,'''') 					AS HcpcsCode,
		PT.AboRhConfirmationRequired	--CR3558
	
	FROM  	
		dbo.BloodProduct BP
	JOIN 
		dbo.ProductType PT ON BP.ProductTypeCode = PT.ProductTypeCode
	JOIN 
		dbo.ComponentClass CC ON PT.ComponentClassId = CC.ComponentClassId
	LEFT OUTER JOIN 
		dbo.HcpcsAssignment HA ON BP.BloodProductGUID = HA.BloodProductGUID
									AND	HA.UnAssignedDate IS NULL
									AND	HA.DivisionCode = @divisioncode
	WHERE
		BP.BloodProductGUID = @bloodproductguid


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodProductByGuid] TO [VbecsAppUser] AS [dbo]
GO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitAntigens]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc:	Gets Blood Unit Antigens based on Blood Unit GUID and DivisionCode
**
**	Author:	Cameron Taylor
**
**	Date: 	03/10/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	02/27/2004	M.Jablonski	Added row version to SELECT
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
**	10/13/2010	M. Smith	Changed the input parameter to allow multiple blood unit guids.  (CR 2899)
**	12/22/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitAntigens]
(
	@bloodunitguidlist	VARCHAR(8000),  -- Allows multiple copies of (38-character guid + 1-char delimiter)
	@divisioncode		VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BUA.BloodUnitGUID,
		BUA.AntigenTypeID,
		ANT.AntigenTypeName,
		BUA.Positive,
		BUA.RecordStatusCode,
		BUA.DivisionCode,
		BUA.[RowVersion]
	
	FROM
		dbo.BloodUnitAntigen BUA
			JOIN dbo.fnSplit(@bloodunitguidlist, '','')
				ON BUA.BloodUnitGUID = Item
			JOIN dbo.AntigenType ANT 
				ON ANT.AntigenTypeID = BUA.AntigenTypeID
		
	WHERE DivisionCode = @divisioncode
	AND	RecordStatusCode != ''X''


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitAntigens] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitAssignedPatients]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Blood Unit Assigned Patients for a specified blood unit GUID
**
**	Author:	Carrie Van Stedum
**
**	Date: 	03/20/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	01/13/2004	C. Taylor	Added DisplayVistaPatientId
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitAssignedPatients]
(
		@bloodunitguid 	UNIQUEIDENTIFIER,
		@divisioncode	VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT 

		PatientGUID, 
		VistaPatientID, 
		PatientSSN,
		DisplayVistaPatientId, 
		PatientICN, 
		BloodTypeCode, 
		RhFactorCode, 
		PatientLastName, 
		PatientFirstName, 
		PatientMiddleName, 
		PatientNamePrefix, 
		PatientNameSuffix, 
		PatientDOB, 
		PatientDOBCode, 
		PatientSexCode, 
		PatientLocation, 
		RecordStatusCode, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LastUpdateDate) AS LastUpdateDate, 

		LastUpdateUser, 
		[RowVersion]

	FROM 

		dbo.fnAssignedPatients(@bloodunitguid) 


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitAssignedPatients] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitByGuid]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/****************************************************************************************************************************************************
**	Desc:	Gets Blood Unit By Guid
**
**	Author:	John Vrooland
**
**	Date: 	03/18/2003
**
*****************************************************************************************************************************************************
**	Modified:
**	Date			Name			Description
**	-----------		----------		------------------
** 	8/26/2003		LMeyer			Eliminated workload code from call (no longer on table)
**	04/27/2004		M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	10/11/2004		C. Van Stedum	Changed for the db design change of adding bloodunitshipment table
**	01/29/2005		Lohse			Changed BloodUnitShipment JOIN to include AND IncomingShipmentGuid IS NOT NULL
**									if a unit is put on an unconfirmed outgoing shipment, this field was coming back null
**									but now I''m not sure if the BloodUnitStatus should be restricted to NON-FINAL units???  Anyone??
**	01/30/2005		Lohse			Adding PreviouslyPooledIndicator for MODIFY
**	04/11/2005		Lohse			Removing AnticoagulantTypeId and StorageTypeCode --- fields dropped
**	05/26/2005		Lohse			PooledUnitsCount is now a function.  Removed OriginalUnitIndicator and PreviouslyPooledINdicator
**	07/14/2005		N.Paterson		** Reviewed for compliance with database standards and recommendations **
**									Removed Name/input/output from comment header, added SET NOCOUNT OFF, formatted SQL, specified object owners
**	03/15/2006		Lohse			Adding PendingTransferIndicator
**  04/09/2014		Lohse			CR1804-changing BloodUnitShipment from subselect to JOIN for performance improvement
**	04/10/2014		K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016		K. Adu-Poku		** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017		K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
*****************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitByGuid]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

	SET NOCOUNT ON


	SELECT

		BU.BloodUnitGUID, 
		UnitProductCode, 
		OriginalVolume, 
		DiscardedPlasmaVolume, 

		dbo.fnGetPooledUnitsCount(BU.BloodUnitGuid) 					AS PooledUnitsCount,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 		AS  UnitInDate, 

		UnitFdaRegistrationNumber, 
		UnitContainerLotNumber, 
		DonationTypeID,
		UnitDivisionID, 
		LabelTypeCode, 
		LabelUnitID, 
		EyeReadableUnitID, 
		BloodProductGUID, 
		BUCS.IncomingShipmentGuid,
		ProcessingTechID,
		DivisionCode, 
		EntryMethodCode,
		BU.RecordStatusCode, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BU.LastUpdateDate) 	AS LastUpdateDate, 

		BU.LastUpdateUser, 
		BUS.[RowVersion] 								AS UnitStatusRowVersion,
		BU.[RowVersion],
		dbo.fnIsUnitPendingTransfer(BU.BloodUnitGuid) AS PendingTransferIndicator

	FROM 

		dbo.BloodUnit BU

	INNER JOIN dbo.BloodUnitStatus BUS ON BUS.BloodUnitGUID = BU.BloodUnitGUID
	JOIN dbo.BloodUnitCurrentShipment BUCS ON BUCS.BloodUnitGuid = BU.BloodUnitGuid
	WHERE 

		BU.BloodUnitGUID = @bloodunitguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitByGuid] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitByUnitIdProduct]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/****************************************************************************************************************************************************
**	Desc:	Gets Blood Unit By Unit Id Product
**
**	Author:	John Vrooland
**
**	Date: 	03/17/2003
**
*****************************************************************************************************************************************************
**	Modified:
**	Date			Name			Description
**	-------------	---------		-----------------
**	10/14/2003		Greg Lohse		Cleaned up the parameters.  Added divisioncode, RecordStatusCode check.
**	04/27/2004		M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	10/11/2004		C. Van Stedum	Changed for the db design change of adding bloodunitshipment table
**	01/29/2005		Lohse			Changed BloodUnitShipment JOIN to include AND IncomingShipmentGuid IS NOT NULL
**									if a unit is put on an unconfirmed outgoing shipment, this field was coming back null
**									but now I''m not sure if the BloodUnitStatus should be restricted to NON-FINAL units???  Anyone??
**	04/11/2005		Lohse			Removing AnticoagulantTypeId and StorageTypeCode --- fields dropped
**	05/26/2005		Lohse			PooledUnitsCount is now a function.  Removed OriginalContainerIndicator.
**	07/14/2005		N.Paterson		** Reviewed for compliance with database standards and recommendations **
**									Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
**	11/22/05		C.VanStedum		Changed query to also look for donationtypeid and unitdivisionid to define uniqueness of 8 char product code
**	01/22/2006		M Smith			** Reviewed for compliance with database standards and recommendations **
**	03/15/2006		Lohse			Adding PendingTransferIndicator
**  04/09/2014		Lohse			CR1804-changing BloodUnitShipment from subselect to JOIN for performance improvement
**	04/10/2014		K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016		K. Adu-Poku		** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017		K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
*****************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitByUnitIdProduct]
(
	@eyereadableunitid		VARCHAR(13),
	@unitproductcode		CHAR(8),
	@divisioncode			VARCHAR(50),
	@productguid			UNIQUEIDENTIFIER
)
AS
	
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

IF(@unitproductcode is NULL) OR LEN(@unitproductcode) = 5

	BEGIN

	SELECT        

		BUT.BloodUnitGuid, 
		BUT.UnitProductCode, 
		BUT.OriginalVolume, 
		BUT.DiscardedPlasmaVolume, 

		dbo.fnGetPooledUnitsCount(BUT.BloodUnitGuid) 					AS PooledUnitsCount, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.UnitInDate) 		AS UnitInDate, 

		BUT.UnitFdaRegistrationNumber, 
		BUT.UnitContainerLotNumber, 
		BUT.DonationTypeID,
		DT.DonationTypeCode,
		BUT.UnitDivisionID, 
		BUT.LabelTypeCode, 
		BUT.LabelUnitID, 
		BUT.EyeReadableUnitID, 
		BUT.BloodProductGUID, 
		BUCS.IncomingShipmentGuid,

		BUT.DivisionCode, 
		BUT.EntryMethodCode, 
		BUT.ProcessingTechID,
		BUT.RecordStatusCode,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) 	AS LastUpdateDate, 

		BUT.LastUpdateUser, 
		BUT.[RowVersion],
		dbo.fnIsUnitPendingTransfer(BUT.BloodUnitGuid) AS PendingTransferIndicator

	FROM

		dbo.BloodUnit BUT
	JOIN 	dbo.BloodUnitCurrentShipment BUCS ON BUCS.BloodUnitGuid = BUT.BloodUnitGuid
		INNER JOIN dbo.DonationType DT ON

			DT.DonationTypeID = BUT.DonationTypeID

	WHERE

		EyeReadableUnitId = @eyereadableunitid

	AND	BloodProductGUID = @productguid

	AND	DivisionCode	= @divisioncode

	AND	BUT.RecordStatusCode <> ''X''
	END
ELSE
	BEGIN
	SELECT        

		BUT.BloodUnitGUID, 
		BUT.UnitProductCode, 
		BUT.OriginalVolume, 
		BUT.DiscardedPlasmaVolume, 

		dbo.fnGetPooledUnitsCount(BUT.BloodUnitGuid) 					AS PooledUnitsCount, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.UnitInDate) 		AS UnitInDate, 

		BUT.UnitFdaRegistrationNumber, 
		BUT.UnitContainerLotNumber, 
		BUT.DonationTypeID,
		DT.DonationTypeCode,
		BUT.UnitDivisionID, 
		BUT.LabelTypeCode, 
		BUT.LabelUnitID, 
		BUT.EyeReadableUnitID, 
		BUT.BloodProductGUID, 
		BUCS.IncomingShipmentGuid,

		BUT.DivisionCode, 
		BUT.EntryMethodCode, 
		BUT.ProcessingTechID,
		BUT.RecordStatusCode,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) 	AS LastUpdateDate, 

		BUT.LastUpdateUser, 
		BUT.[RowVersion],
		dbo.fnIsUnitPendingTransfer(BUT.BloodUnitGuid) AS PendingTransferIndicator

	FROM

		dbo.BloodUnit BUT
		JOIN 	dbo.BloodUnitCurrentShipment BUCS ON BUCS.BloodUnitGuid = BUT.BloodUnitGuid
		INNER JOIN dbo.DonationType DT ON

			DT.DonationTypeID = BUT.DonationTypeID

	WHERE

		EyeReadableUnitId = @eyereadableunitid

	AND	UnitProductCode = SUBSTRING(@unitproductcode, 1, 5)

	AND 	UnitDivisionID = SUBSTRING(@unitproductcode, 7, 2)

	AND 	DT.DonationTypeCode = SUBSTRING(@unitproductcode, 6,1)

	AND	BloodProductGUID = @productguid

	AND	DivisionCode	= @divisioncode

	AND	BUT.RecordStatusCode <> ''X''
	END


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitByUnitIdProduct] TO [VbecsAppUser] AS [dbo]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitDetailsFromBloodUnitShipment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc: 	Checks to see if a unit was ever entered in the system matching the input parameters
**
**	Author: 	Greg Lohse
**
**	Date: 	03/07/2007
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	03/07/2007	Lohse		Intiial.
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitDetailsFromBloodUnitShipment]
(
	@unitid					VARCHAR(13),
	@bloodproductguid			UNIQUEIDENTIFIER,
	@divisioncode				VARCHAR(50),
	@fullproductcode			VARCHAR(8) = NULL
)
AS

SET NOCOUNT ON

DECLARE @continue	BIT

SET @continue = 0


	---First check to see if the record is out there already with a BloodUnit.RecordStatusCode = ''X''
	IF (@fullproductcode IS NULL) OR LEN(@fullproductcode) = 5
		BEGIN

		IF EXISTS (SELECT 1
				FROM
					dbo.BloodUnitShipment BUS
				INNER JOIN
					dbo.BloodUnit BU ON BU.BloodUnitGuid = BUS.BloodUnitGuid
				INNER JOIN
					dbo.BloodProduct BP	ON BP.BloodProductGuid = BUS.LoginBloodProductGuid
				WHERE
					BU.DivisionCode = @divisioncode
				AND	BP.BloodProductGuid = @bloodproductguid
				AND	(BU.EyeReadableUnitId = @unitid	OR	 LabelUnitId = @unitid)
				AND	BU.RecordStatusCode = ''X''
			)
			SET @continue = 1
		END

	ELSE
		BEGIN

		IF EXISTS (SELECT 1
					FROM
						dbo.BloodUnitShipment BUS
					INNER JOIN
						dbo.BloodUnit BU ON BU.BloodUnitGuid = BUS.BloodUnitGuid
					INNER JOIN
						dbo.BloodProduct BP	ON BP.BloodProductGuid = BUS.LoginBloodProductGuid
					WHERE
						BU.DivisionCode = @divisioncode
					AND	BP.BloodProductGuid = @bloodproductguid
					AND	(BU.EyeReadableUnitId = @unitid	OR	 BU.LabelUnitId = @unitid)
					AND	SUBSTRING(BUS.LoginFullProductCode, 1, 5) = SUBSTRING(@fullproductcode, 1, 5)
					AND	SUBSTRING(BUS.LoginFullProductCode, 7, 2) = SUBSTRING(@fullproductcode, 7, 2)
					AND	SUBSTRING(BUS.LoginFullProductCode, 6, 1) = SUBSTRING(@fullproductcode, 6,1)
					AND	BU.RecordStatusCode = ''X''
			)
			SET @continue = 1
		END


	IF (@continue = 0)
	BEGIN
	IF (@fullproductcode IS NULL) OR LEN(@fullproductcode) = 5
		BEGIN

		SELECT
			BU.BloodUnitGuid,
			BU.EyeReadableUnitId,
			BU.LabelUnitId,
			BUM.BloodTypeCode,
			BUM.RhFactorCode,
			BP.ProductShortName,
			BUS.LoginFullProductCode,
			BUS.LoginValues			--Expiration Date, Donation Type Text, Restricted For Patient Info, Special Testing Stuff			
		FROM
			dbo.BloodUnitShipment BUS
		INNER JOIN
			dbo.BloodUnit BU ON BU.BloodUnitGuid = BUS.BloodUnitGuid
		INNER JOIN 
			dbo.BloodUnitMedia BUM ON BUM.BloodUnitGuid = BU.BloodUnitGuid
		INNER JOIN
			dbo.BloodProduct BP	ON BP.BloodProductGuid = BUS.LoginBloodProductGuid
		WHERE
			BU.DivisionCode = @divisioncode
		AND	BP.BloodProductGuid = @bloodproductguid
		AND	(BU.EyeReadableUnitId = @unitid	OR	 LabelUnitId = @unitid)

		END

	ELSE
		BEGIN

		SELECT
			BU.BloodUnitGuid,
			BU.EyeReadableUnitId,
			BU.LabelUnitId,
			BUM.BloodTypeCode,
			BUM.RhFactorCode,
			BP.ProductShortName,
			BUS.LoginFullProductCode,
			BUS.LoginValues			--Expiration Date, Donation Type Text, Restricted For Patient Info, Special Testing Stuff				
		FROM
			dbo.BloodUnitShipment BUS
		INNER JOIN
			dbo.BloodUnit BU ON BU.BloodUnitGuid = BUS.BloodUnitGuid
		INNER JOIN 
			dbo.BloodUnitMedia BUM ON BUM.BloodUnitGuid = BU.BloodUnitGuid
		INNER JOIN
			dbo.BloodProduct BP	ON BP.BloodProductGuid = BUS.LoginBloodProductGuid
		WHERE
			BU.DivisionCode = @divisioncode
		AND	BP.BloodProductGuid = @bloodproductguid
		AND	(BU.EyeReadableUnitId = @unitid	OR	 BU.LabelUnitId = @unitid)
		AND	SUBSTRING(BUS.LoginFullProductCode, 1, 5) = SUBSTRING(@fullproductcode, 1, 5)
		AND	SUBSTRING(BUS.LoginFullProductCode, 7, 2) = SUBSTRING(@fullproductcode, 7, 2)
		AND	SUBSTRING(BUS.LoginFullProductCode, 6, 1) = SUBSTRING(@fullproductcode, 6,1)

		END

	END
	ELSE
		SELECT @continue

SET NOCOUNT OFF

RETURN(@@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitDetailsFromBloodUnitShipment] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitFinanceByUnitGuid]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Blood Unit Finance By Blood Unit Guid
**
**	Author:	John Vrooland
**
**	Date: 	03/19/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
					Placed input parameter in brackets
**	12/08/2011	K. Dobranowski	Added LastUpdateDate (CR 3195)
**	12/28/2011	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitFinanceByUnitGuid]
(
	@bloodunitguid 	UNIQUEIDENTIFIER,
	@divisioncode VARCHAR(50)
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BloodUnitFinanceGuid, 
		BUF.BloodUnitGuid, 
		UnitCost, 
		SpecialTestingCost, 
		ReturnCreditAmount, 

		(SELECT TOP 1 outgoingshipmentguid FROM dbo.BloodUnitShipment WHERE BloodUnitGuid = BUF.BloodUnitGUID AND recordstatuscode = ''A'' 

		ORDER BY  lastupdatedate DESC) 											AS OutgoingShipmentGuid,

		BUF.LastUpdateUser, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUF.LastUpdateDate) AS LastUpdateDate,
		BUF.[RowVersion]


	FROM
		dbo.BloodUnitFinance BUF

	WHERE

		BUF.BloodUnitGuid = @bloodunitguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitFinanceByUnitGuid] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitFinancialData]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets blood unit financial data for a given product code and/or unit id
**
**	Author:	Luke Meyer
**
**	Date: 	10/4/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------	---------		------------------
**	12/04/2003	Lohse		Changed input parameter DivisionCode from int to Char(5), because some have alphas.
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
					NOTE: NULL default values are used in the logic
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
 CREATE PROCEDURE [dbo].[spGetBloodUnitFinancialData]
(
	@unitid  		VARCHAR(13) 	= NULL, 
	@productcode		VARCHAR(5) 	= NULL,
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT


SET NOCOUNT ON

IF @UnitID IS NULL

	BEGIN

	SELECT  

		UnitCost, 
		SpecialTestingCost,
		ReturnCreditAmount

	FROM  

		dbo.vw_BloodShipFinanceAllCurrent

	WHERE

		UnitProductCode = @productcode

	AND	DivisionCode = @divisioncode  

	SET @ERROR = @@ERROR
		IF @ERROR !=0 GOTO SPROC_EXIT

	END

ELSE

	BEGIN

		IF @productcode IS NULL
			
			BEGIN

				SELECT  

					UnitCost,
					SpecialTestingCost, 
					ReturnCreditAmount

				FROM  

					dbo.vw_BloodShipFinanceAllCurrent

				WHERE

					EyeReadableUnitID = @unitid
				AND	DivisionCode = @divisioncode

				SET @ERROR = @@ERROR
					IF @ERROR !=0 GOTO SPROC_EXIT

			END

		ELSE	

			BEGIN
	
				SELECT

					UnitCost, 
					SpecialTestingCost, 
					ReturnCreditAmount

				FROM

					dbo.vw_BloodShipFinanceAllCurrent

				WHERE

					UnitProductCode = @productcode 
				AND	EyeReadableUnitID = @unitid
				AND	DivisionCode = @divisioncode

				SET @ERROR = @@ERROR
					IF @ERROR !=0 GOTO SPROC_EXIT

			END
	END

SET NOCOUNT OFF

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitFinancialData] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitGUID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Gets the blood unit GUID for the associated unit id and product code
**
**	Author:	Carrie Van Stedum
**
**	Date: 	03/13/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	---------	----		-----------
**	10/02/2003	Greg Lohse	Added the check for RecordStatusCode <> ''X''
**	10/31/2003	C Taylor	Somebody removed the search on LabelUnitID. I am putting it back, otherwise
**							the BloodUnitSelector may not find units when a label is scanned. There was
**							no comment, so I don''t know why it was removed. We perhaps need to revisit the
**							fact that potentially 2 units could be returned, based on the either/or search
**	02/09/2004	Greg Lohse	I think I might''ve removed the LabelUnitID Cameron is talking about and not commented on it because I was trying to be sneaky.
**	02/09/2004	Greg Lohse	Adding UnitDivisionId - needed to narrow down a bloodunit search when after a unit has been split (ISBT only)
**	02/12/2004	M Tsotchev	Adding a conditional check so that not passing in a @unitdivisionid excludes it from the where search
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitGUID]
(
	@labelunitid		VARCHAR(13),
	@productcode		VARCHAR(5),
	@divisioncode		VARCHAR(50),
	@unitdivisionid		VARCHAR(2) = NULL
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT 

		BloodUnitGuid

	FROM

		dbo.BloodUnit

	WHERE  

		UnitProductCode  = @ProductCode

	AND	(LabelUnitID = @LabelUnitID OR EyeReadableUnitId = @LabelUnitID)

	AND	DivisionCode = @DivisionCode

	AND 	RecordStatusCode <> ''X''

	AND	(RTRIM(UnitDivisionId) = @unitdivisionid or @unitdivisionid IS NULL)

	 
SET @ERROR = @@ERROR

SET NOCOUNT OFF

 RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitGUID] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitMediaByUnitGuid]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets Blood Unit Media By Blood Unit Guid
**
**	Author:	Unknown
**
**	Date: 	03/18/2003
**
*******************************************************************************************************************************************************************************
**	Modified:            
**	Date		Name		Description
**	------------		---------		------------------
**	Unknown	C. Van Stedum  	Fixed cause issuetolocationname is on the issued unit table and this sproc 
**					was looking for it on the blood unit media table
**	07-25-03	JHV		Removed IssueToLocationName - it is not an attribute of BloodUnitMedia
**	08-25-03	JHV		Removed RecordStatusCode from BloodUnitMedia
**	12-23-03	CRT		Removed BUM.Comments - no longer in database - needs to be replaced by BloodUnitComment.BloodUnitCommentText 
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/06/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitMediaByUnitGuid]
(
	@bloodunitguid  	UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BUM.BloodUnitMediaGuid, 
		BUM.BloodUnitGuid, 
		BUM.BloodTypeCode, 
		BUM.RhFactorCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUM.UnitExpirationDate) AS UnitExpirationDate, 
		BUM.TestingStatusID, 
		BUM.DirectedPatientGuid, 
		BUM.Comments, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUM.LastUpdateDate) AS  LastUpdateDate, 
		BUM.LastUpdateUser, 
		BUM.[RowVersion]
	FROM
		dbo.BloodUnitMedia BUM
	WHERE
		BUM.BloodUnitGuid = @bloodunitguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitMediaByUnitGuid] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitModificationsByUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects blood units created by modification of supplied blood unit
**
**	Author: Cameron Taylor	
**
**	Date: 	5/3/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	------------		---------		-----------------
**	07/06/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated
**	11/17/2005	Lohse		Adding ModificationCost - for rollback - we need to know what the process fee was
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	04/04/2006	Lohse		Adding DateTimeConversion to LastUpdateDate to comply with Database Standards 
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitModificationsByUnit]
(
	@bloodunitguid			UNIQUEIDENTIFIER,
	@divisioncode			VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BUM.BloodUnitModificationGuid,
		BUM.FromBloodUnitGuid,
		BUM.ToBloodUnitGuid,
		BUM.ProductModificationCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  BUM.ModificationDate) as ModificationDate,
		BUM.ModificationTechId,
		BUM.ModificationMethodCode,
		BUM.NewContainerWeldIndicator,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  BUM.NewLabelVerificationDateTime) as NewLabelVerificationDateTime,
		BUM.DivisionCode,
		BUM.RecordStatusCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUM.LastUpdateDate) 		AS  LastUpdateDate, 
		BUM.LastUpdateUser,
		BUM.[RowVersion],
		BUM.FromOriginalVolume,
		BUM.FromBloodProductGuid,
		BP.ProductCode,
		BP.ProductShortName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  BUM.FromUnitExpirationDate) as FromUnitExpirationDate,
		BUM.FromProductShipperGuid,
		BUM.ModificationCost
	FROM
		dbo.BloodUnitModification BUM
	LEFT JOIN
		dbo.BloodProduct BP ON BP.BloodProductGuid = BUM.FromBloodProductGuid
	WHERE
		BUM.FromBloodUnitGUID = @bloodunitguid
	AND	BUM.RecordStatusCode = ''A''

	ORDER BY
		 BUM.LastUpdateDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN @ERROR
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitModificationsByUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitModificationsForChildUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects blood units that resulted in creating the supplied blood unit
**
**	Author: Krzysztof Dobranowski
**
**	Date: 	12/19/2006
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	------------		---------		-----------------
**	12/19/2006	K. Dobranowski	Initial creation. This sp was created for the purpose of using it in UC_15 to generate negative workload when
**					inactivating blood unit in UC_70.
**	01/09/2007	Lohse		Reviewed: Prefixed table names with dbo
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitModificationsForChildUnit]
(
	@bloodunitguid			UNIQUEIDENTIFIER,
	@divisioncode			VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BUM.BloodUnitModificationGuid,
		BUM.FromBloodUnitGuid,
		BUM.ToBloodUnitGuid,
		BUM.ProductModificationCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  BUM.ModificationDate) as ModificationDate,
		BUM.ModificationTechId,
		BUM.ModificationMethodCode,
		BUM.NewContainerWeldIndicator,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  BUM.NewLabelVerificationDateTime) as NewLabelVerificationDateTime,
		BUM.DivisionCode,
		BUM.RecordStatusCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUM.LastUpdateDate) 		AS  LastUpdateDate, 
		BUM.LastUpdateUser,
		BUM.[RowVersion],
		BUM.FromOriginalVolume,
		BUM.FromBloodProductGuid,
		BP.ProductCode,
		BP.ProductShortName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  BUM.FromUnitExpirationDate) as FromUnitExpirationDate,
		BUM.FromProductShipperGuid,
		BUM.ModificationCost
	FROM
		dbo.BloodUnitModification BUM
	LEFT JOIN
		dbo.BloodProduct BP ON BP.BloodProductGuid = BUM.FromBloodProductGuid
	WHERE
		BUM.ToBloodUnitGUID = @bloodunitguid
	AND	BUM.RecordStatusCode = ''A''

	ORDER BY
		 BUM.LastUpdateDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN @ERROR
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitModificationsForChildUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitOriginalShipper]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Blood Unit Original Shipper (CR3193)
**
**	Author:	Carrie Van Stedum
**
**	Date: 	12/06/2011
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	----------------	----------		------------------
**	12/28/2011	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitOriginalShipper]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

	SET NOCOUNT ON


	SELECT TOP 1 LS.LocalSupplierGuid, LS.FacilityGuid, LS.FacilityName

             FROM dbo.BloodUnitShipment BUS 

	JOIN dbo.Shipment SH 

	ON BUS.IncomingShipmentGuid = SH.ShipmentGuid

              JOIN dbo.LocalSupplier LS ON

	SH.LocalSupplierGuid = LS.LocalSupplierGuid


	WHERE BUS.BloodUnitGuid = @bloodunitguid
	AND SH.DivisionCode = @divisioncode

              ORDER BY BUS.LastUpdateDate ASC



	

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitOriginalShipper] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects blood units for an invoice
**
**	Author: 	Mike Smith	
**
**	Date: 	9/24/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
** 	1/13/03    	 C Taylor	Added PatientSSN, TestingStatusId, ProductShortName, AssignedPatientLastName, 
**					AssignedPatientFirstName, Comments, AssignedPatientMiddleInitial, AssignedPatientSSN, 
**					SpecimenExpirationDatetime, OriginalVolume, MaximumStorageTime,
**                         			QuarantineIndicator
**	9/26/2003	C. Jensen	Added UnitContainerLotNumber, IncomingShipmentGUID
**	10/14/2003	Greg Lohse	Making things look pretty. Adding DivisionCode as a parameter
**	01/13/2004	C. Taylor	Added DisplayVistaPatientId
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	06/17/2005	N.Paterson	Modified to use new view for increased performance
**	07/07/2005	D. Askew	Added condition to ignore units in final status; changed formatting slightly to improve readability
**	07/06/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated;
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	01/10/2006	C. Taylor	Added DonationTypeCode and UnitDivisionId (DR 1729)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnits]
(
	@shipmentguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
	
AS
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BloodUnitGuid, 
		EyeReadableUnitId, 
		DirectedPatientGuid,
		UnitProductCode, 
		dbo.vw_BloodShipAllCurrent.RhFactorCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		DonationTypeId, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS UnitInDate,
		DivisionCode, 
		dbo.vw_BloodShipAllCurrent.BloodTypeCode, 
		UnitFdaRegistrationNumber, 
		LabelUnitId, 
		ProductTypeCode, 
		ProductName, 
		TestingStatusId, 
		ProductShortName,
		ProcessingTechId, 
		OriginalVolume, 
		MaximumStorageTime, 
		QuarantineIndicator, 
		DonationTypeText, 
		ProductName AS ProducttypeName,
		RhFactorText AS RhFactorText, 
		FacilityName AS FacilityName, 
		P.PatientFirstName, 
		P.PatientMiddleName, 
		P.PatientLastName, 
		P.PatientSsn, 
		P.DisplayVistaPatientId,
		P.VistaPatientId, 
		UnitStatusComments, 
		DiscardCannedCommentGuid, 
		UnitStatusCode, 
		UnitStatusText ,
		dbo.vw_BloodShipAllCurrent.[RowVersion], 
		Comments ,
		dbo.vw_BloodShipAllCurrent.LastUpdateUser, 
		LabelTypeCode, 
		UnitContainerLotNumber, 
		IncomingShipmentGuid ,
		BloodProductGuid, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
		ISNULL(PresumedTransfusedIndicator, 0) AS PresumedTransfusedIndicator,
		UnitDivisionId,
		DonationTypeCode

		 FROM 
			dbo.vw_BloodShipAllCurrent  
			
			LEFT OUTER JOIN dbo.Patient P  
				ON dbo.vw_BloodShipAllCurrent.DirectedPatientGuid = P.PatientGuid 
			
		WHERE	dbo.vw_BloodShipAllCurrent.IncomingShipmentGuid = @shipmentguid
				AND dbo.vw_BloodShipAllCurrent.DivisionCode = @divisioncode
				-- Don''t bring back units that are in final status
				AND UnitStatusCode NOT IN (''D'',''M'',''T'',''X'')
		ORDER BY	dbo.vw_BloodShipAllCurrent.LastUpdateDate 

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByAntiBodyTypeId]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets Blood Units with AntibodyType, Pos or Neg
**
**	Author:	John Vrooland
**
**	Date: 	11/05/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		-----------------
**  	07/21/03    	JHV         	Changed AntibodyTypeId to AntigenTypeId
**	10/27/04	Greg Lohse	Adding BloodUnitTest Union - changed 7-21-03 back to antibodytypeid/w join
**	07/06/05 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; added alias to where clause
**					for division code in first SELECT
**	11/28/06	Lohse		Adding code to filter only Active records, and no return any partial tests (TestResultId = null) - CR2099
**	02/08/07	D. Askew     	** Reviewed for compliance with database standards and recommendations **
**					Added dbo prefix
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitsByAntiBodyTypeId]
(
	@antibodytypeid 	INT,
	@divisioncode 		VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT
		BloodUnitGuid,
		Positive
	FROM
		dbo.BloodUnitAntigen BUA
		JOIN dbo.AntibodyAntigen ON AntibodyAntigen.AntigenTypeId = BUA.AntigenTypeId
		JOIN dbo.AntibodyType AbT ON AbT.AntibodyTypeId = AntibodyAntigen.AntibodyTypeId
	WHERE
		AbT.AntibodyTypeId = @antibodytypeid
	AND	BUA.DivisionCode = @divisioncode
	AND	BUA.RecordStatusCode = ''A''

UNION

	SELECT 
		BUT.BloodUnitGuid,
		CASE BUT.TestResultId
			WHEN ''1'' THEN CAST(1 AS BIT)
			WHEN ''2'' THEN CAST(1 AS BIT)
			WHEN ''3'' THEN CAST(1 AS BIT)
			WHEN ''4'' THEN CAST(1 AS BIT)
			WHEN ''P'' THEN CAST(1 AS BIT)
			ELSE CAST(0 AS BIT)
		END AS Positive

	FROM 
		dbo.BloodUnitTest BUT
		JOIN dbo.AntigenTest AgT ON BUT.BloodTestTypeId = AgT.BloodTestTypeId
		JOIN dbo.AntibodyAntigen ON AntibodyAntigen.AntigenTypeId = AgT.AntigenTypeid
		JOIN dbo.AntibodyType AbT ON AbT.AntibodyTypeId = AntibodyAntigen.AntibodyTypeId
	WHERE
		AbT.AntibodyTypeId = @antibodytypeid
	AND	BUT.DivisionCode = @divisioncode
	AND 	BUT.RecordStatusCode = ''A''
	AND	BUT.TestResultId IS NOT NULL		--This filters out partially completed tests, which would otherwise be counted as "negative'' antigens

SET @ERROR = @@ERROR

SET NOCOUNT OFF
		
RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsByAntiBodyTypeId] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByIdAndProduct]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Gets the blood units for the associated unit id and product code.  We say units here because
**		there could be multiple guids for a given unit id and unit product code, and this does not normally
**		equate to bad data.  For example, a thawed codabar cryo unit will have at least two guids for the same
**		eye readable id and unit product code.  Very similar to spGetBloodUnitGuid.
**
**	Author:	David Askew
**
**	Date: 	12/20/2004
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	---------		----		-----------
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	01/31/2005	D. Askew	Added RecordStatusCode to select list
**	03/16/2005	Lohse		Adding SearchCriteria of 0 -- to replace spGetBloodUnitGuid (needed for modified units)
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/21/2005	Lohse		Adding ORDER BY EyeReadableUnitId, FullProductCode
**	07/06/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; capitalized all SQL statements
**	11/30/2005	Lohse		Removing LabelUnitId in WHERE clause -- we don''t need to search looking for the UnitId since it''s never enetered
**	12/20/2005	C. Taylor	That''s where your wrong Mr Lohse. Actually they can enter either the labelunitid or eyereadableunitid to search for units.
**							So I''m putting LabelUnitId back in the WHERE clause. Please leave it there.
**	01/19/2006	C. Taylor	Adding DonationTypeCode parameter for full 8-digit ISBT search (CR 1528)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitsByIdAndProduct]
(
	@labelunitid		VARCHAR(13),
	@productcode		VARCHAR(5),
	@divisioncode		VARCHAR(50),
	@unitdivisionid		VARCHAR(2) = NULL,
	@donationtypecode	VARCHAR(1) = NULL,
	@searchcriteria		INT
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON
	-- Also get Blood Units in Final Status
	IF @searchcriteria IN (0,1)
		SELECT
			BloodUnitGuid,
			EyeReadableUnitId,
			DirectedPatientGuid,
			UnitProductCode,
			RhFactorCode,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS  UnitExpirationDate,
			DonationTypeID, 
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS  UnitInDate,
			DivisionCode,
			BloodTypeCode,
			UnitFdaRegistrationNumber,
			LabelUnitId,
			ProductTypeCode,
			ProductName,
			ProductShortName,
			BiohazardousWarningIndicator,
			DonationTypeText,
			ProductTypeName,
			RhFactorText,
			FacilityName,
			PatientFirstName,
			PatientMiddleName,
			PatientLastName,
			MaximumStorageTime,
			VistaPatientID,
			PatientSSN,
			DisplayVistaPatientId,
			UnitStatusComments,
			DiscardCannedCommentGuid,
			UnitStatusCode,
			UnitStatusText,
			QuarantineIndicator,
			TestingStatusId,
			OriginalVolume,
			[RowVersion],
			Comments,
			IncomingShipmentGuid,
			RTRIM(BloodTypeCode) + '' '' + RhFactorText AS AboRh,
			UnitDivisionId,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
			PresumedTransfusedIndicator,
			CASE LabelTypeCode
				WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
				ELSE UnitProductCode
			END AS FullProductCode,
			RecordStatusCode
		FROM
			dbo.vw_BloodShipPatientAllCurrent
		WHERE  
			UnitProductCode  = @ProductCode
		AND	(EyeReadableUnitId = @LabelUnitID OR LabelUnitId = @LabelUnitID)
		AND	DivisionCode = @DivisionCode
		AND 	RecordStatusCode <> ''X''
		AND	(RTRIM(UnitDivisionId) = @unitdivisionid OR @unitdivisionid IS NULL)
		AND (RTRIM(DonationTypeCode) = @donationtypecode OR @donationtypecode IS NULL)

		ORDER BY EyeReadableUnitId, FullProductCode

	-- Also get Inactive Blood Units
	ELSE IF @searchcriteria = 2
		SELECT
			BloodUnitGuid,
			EyeReadableUnitId,
			DirectedPatientGuid,
			UnitProductCode,
			RhFactorCode,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS  UnitExpirationDate,
			DonationTypeID, 
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS  UnitInDate,
			DivisionCode,
			BloodTypeCode,
			UnitFdaRegistrationNumber,
			LabelUnitID,
			LabelUnitID AS LabelUnitId,
			ProductTypeCode,
			ProductName,
			ProductShortName,
			BiohazardousWarningIndicator,
			DonationTypeText,
			ProductTypeName,
			RhFactorText,
			FacilityName,
			PatientFirstName,
			PatientMiddleName,
			PatientLastName,
			MaximumStorageTime,
			VistaPatientID,
			PatientSSN,
			DisplayVistaPatientId,
			UnitStatusComments,
			DiscardCannedCommentGuid,
			UnitStatusCode,
			UnitStatusText,
			QuarantineIndicator,
			TestingStatusId,
			OriginalVolume,
			[RowVersion],
			Comments,
			IncomingShipmentGuid,
			RTRIM(BloodTypeCode) + '' '' + RhFactorText AS AboRh,
			UnitDivisionId,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
			PresumedTransfusedIndicator,
			CASE LabelTypeCode
				WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
				ELSE UnitProductCode
			END AS FullProductCode,
			RecordStatusCode
		FROM
			dbo.vw_ActiveAndInactiveBloodUnitsWithCurrentStatus
		WHERE  
			UnitProductCode  = @ProductCode
		AND	(EyeReadableUnitId = @LabelUnitID OR LabelUnitId = @LabelUnitID)
		AND	DivisionCode = @DivisionCode
		AND	(RTRIM(UnitDivisionId) = @unitdivisionid OR @unitdivisionid IS NULL)
		AND (RTRIM(DonationTypeCode) = @donationtypecode OR @donationtypecode IS NULL)

		ORDER BY EyeReadableUnitId, FullProductCode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

 RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsByIdAndProduct] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



/*******************************************************************************************************************************************************************************
**	Name: 	spGetBloodUnitsByPatient
**
**	Desc: 	Selects blood units that are directed to a patient
**
**	Input: 	@directedpatientguid,  @divisioncode
**
**	Output:	Lots of stuff!
**
**	Author: 	Mike Smith	
**
**	Date: 	9/24/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**  	1/13/03     	C Taylor		Added PatientSSN, TestingStatusId, ProductShortName, AssignedPatientLastName, AssignedPatientFirstName, Comments,
**                          			AssignedPatientMiddleInitial, AssignedPatientSSN, SpecimenExpirationDatetime, OriginalVolume, MaximumStorageTime,
**                          			QuarantineIndicator
**	10/29/2003	C. Jensen	Added DivisionCode as an input parameter and it to the WHERE clause.
**	11/3/2003	C. Jensen	Added BloodProductGUID and LabelTypeCode to SELECT
**	01/13/2004	C. Taylor	Added DisplayVistaPatientId
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/07/2004	C. Taylor	Replaced PatientGuid clause with fnWherePatientGuid function, to include possible merged patients
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	09/28/2004	C. Jensen	Added IncomingShipmentGuid
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/14/2005	C. Jensen	Adding WHERE clause to only get units that aren''t in a final status
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	07/06/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated;  DivisionCode requirement was removed from
**					 WHERE clause (was commented out) at some point but was not notated, I am removing the
**					 unused code
**	06/17/2005	NPaterson	Changed to use new view and inner join rather than an IN statement
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	03/14/2006	C. Jensen	Added UnitDivisionID
**	07/05/2006	Lohse		Adding BloodUnitStatusGuid for CR2043
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitsByPatient]
(
	@directedpatientguid	UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)

AS
SET NOCOUNT ON

DECLARE @ERROR INT

	SELECT
		BU.EyeReadableUnitId, 
		BU.UnitProductCode, 
		BU.DonationTypeID,
		BU.DonationTypeText,
		BU.LabelTypeCode,

		BU.BloodUnitGuid, 
		BU.RhFactorCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS  UnitExpirationDate, 
		BU.ComponentClassId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS  UnitInDate, 

		BU.DivisionCode, 
		BU.BloodTypeCode, 
		BU.UnitFdaRegistrationNumber,
		BU.LabelUnitId, 
		BU.ProductTypeCode, 

		BU.ProductName, 
		BU.ProductShortName,
		BU.ProductTypeName, 
		BU.RhFactorText, 
		BU.FacilityName, 

		BU.BloodProductGuid,
		BU.PatientFirstName,
		BU.PatientMiddleName,
		BU.PatientLastName, 
		BU.MaximumStorageTime,

		BU.VistaPatientID,
		BU.PatientSSN,
		BU.DisplayVistaPatientId,
		BU.UnitStatusComments,
		BU.DiscardCannedCommentGuid,

		BU.UnitStatusCode,
		BU.UnitStatusText,
		BU.QuarantineIndicator,
		BU.TestingStatusId,
		BU.OriginalVolume,

		BU.IncomingShipmentGuid,
		BU.[RowVersion],
		BU.Comments,
		BU.UnitDivisionId,
		RTRIM(BU.BloodTypeCode) + '' '' + BU.RhFactorText AS AboRh,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BU.ShipmentDate) AS ShipmentDate,
		BU.PresumedTransfusedIndicator,
		BU.BloodUnitStatusGuid
	
	 FROM
		dbo.vw_BloodShipPatientAllCurrent BU

	 WHERE
		BU.DirectedPatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @directedpatientguid
		)
	AND	BU.UnitExpirationDate > GETUTCDATE()
	AND	BU.UnitStatusCode IN (''L'',''A'',''S'',''C'')
	ORDER BY 
		BU.LastUpdateDate

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsByPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByPatientAndComponentClassID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects blood units that are directed to a patient
**
**	Author:	Carl Jensen
**
**	Date: 	9/24/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**  	1/13/03     	C Taylor		Added PatientSSN, TestingStatusId, ProductShortName, AssignedPatientLastName, AssignedPatientFirstName, Comments,
**                          			AssignedPatientMiddleInitial, AssignedPatientSSN, SpecimenExpirationDatetime, OriginalVolume, MaximumStorageTime,
**                          			QuarantineIndicator
**	10/13/2003	C. Jensen	Added LabelTypeCode so the label control would populate correctly
**	01/13/2004	C. Taylor	Added DisplayVistaPatientId
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/07/2004	C. Taylor	Replaced PatientGuid clause with fnWherePatientGuid function, to include possible merged patients
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	09/20/2004	C. Jensen	Added IncomingShipmentGuid
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/06/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; removed unused code;
**					added alias for DirectedPatientGuid, ComponentClassId, and UnitExpirationDate in WHERE clause
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitsByPatientAndComponentClassID]
(
	@directedpatientguid	UNIQUEIDENTIFIER,
	@componentclassid	INT,
	@divisioncode		VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
		EyeReadableUnitID, 
		UnitProductCode, 
		DonationTypeID,
		DonationTypeText,
		BloodProductGuid,
		BU.BloodUnitGuid, 
		RhFactorCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate, 
		ComponentClassId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS UnitInDate, 
		DivisionCode, 
		BloodTypeCode, 
		UnitFdaRegistrationNumber,
		LabelUnitId, 
		ProductTypeCode, 
		ProductName, 
		ProductShortName,
		ProductTypeName, 
		RhFactorText, 
		FacilityName, 
		PatientFirstName,
		PatientMiddleName,
		PatientLastName, 
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitStatusText,
		QuarantineIndicator,
		TestingStatusId,
		OriginalVolume,
		BU.[RowVersion],
		Comments,
		BloodTypeCode + '' '' + RhFactorText AS AboRh,
		BU.IncomingShipmentGuid,
		LabelTypeCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
		BU.PresumedTransfusedIndicator
	
	FROM
		dbo.vw_BloodShipPatientAllCurrent BU
	WHERE
		BU.DirectedPatientGUID IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @directedpatientguid
		)
	AND	BU.ComponentClassID = @componentclassid
	AND	BU.UnitExpirationDate > GETUTCDATE()
	ORDER BY
		BU. LastUpdateDate

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsByPatientAndComponentClassID] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsByUnitId]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'


/****************************************************************************************************************************************************
**	Desc:	Gets Blood Unit By Unit Id Product (Defect 235352).
**
**	Author:	Russell Stephenson
**
**	Date: 	12/22/2015
**
*****************************************************************************************************************************************************
**	Modified:
**	Date			Name				Description
**	-------------	---------			-----------------
**	01/25/2016	Russell Stephenson	Defect 235352: Took out comments and verified that this projection is being used by UC_115 and UC_114.
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/16/2016	Douglas Forst	Defect 286187 changed sproc name from spGetBloodUnitByUnitId to spGetBloodUnitsByUnitId
**	03/31/2016	P. Sanchez	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
******************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitsByUnitId]
(
	@unitid		VARCHAR(13),
	@divisioncode	VARCHAR(50)
)
AS
	
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON


	SELECT        

		BUT.BloodUnitGuid, 
		BUS.BloodUnitStatusGuid,		
		BUT.UnitProductCode, 
		BP.ProductShortName,
		PT.ProductTypeName,
		PT.SortColumn AS ProductTypeSortColumn,
		BUT.OriginalVolume, 
		BUT.DiscardedPlasmaVolume, 

		dbo.fnGetPooledUnitsCount(BUT.BloodUnitGuid) 					AS PooledUnitsCount, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.UnitInDate) 		AS UnitInDate, 

		BUT.UnitFdaRegistrationNumber, 
		BUT.UnitContainerLotNumber, 
		BUT.DonationTypeID,
		DT.DonationTypeCode,
		BUT.UnitDivisionID, 
		BUT.LabelTypeCode, 
		BUT.LabelUnitID, 
		BUT.EyeReadableUnitID, 
		BUT.BloodProductGUID, 
		BUCS.IncomingShipmentGuid,

		BUT.DivisionCode, 
		BUT.EntryMethodCode, 
		BUT.ProcessingTechID,
		BUT.RecordStatusCode,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) 	AS LastUpdateDate, 

		BUT.LastUpdateUser, 
		BUT.[RowVersion],
		dbo.fnIsUnitPendingTransfer(BUT.BloodUnitGuid) AS PendingTransferIndicator,
		BUM.BloodTypeCode, 
		BUM.RhFactorCode,
		RHF.RhFactorText,
		BUS.[RowVersion] as BloodUnitStatusRowVersion,
		BUSCC.UnitStatusCode
	FROM

		dbo.BloodUnit BUT
	
		JOIN dbo.BloodUnitCurrentShipment BUCS ON BUCS.BloodUnitGuid = BUT.BloodUnitGuid
		
		JOIN dbo.BloodUnitMedia BUM ON BUM.BloodUnitGuid = BUT.BloodUnitGuid

		JOIN dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BUT.BloodUnitGuid

		JOIN dbo.BloodUnitStatusCodeCurrent BUSCC ON BUSCC.BloodUnitGuid = BUT.BloodUnitGuid
		
		JOIN dbo.RhFactor RHF ON RHF.RhFactorCode = BUM.RhFactorCode

		JOIN dbo.DonationType DT ON DT.DonationTypeID = BUT.DonationTypeID

		JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BUT.BloodProductGuid

		JOIN dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode

	WHERE

		EyeReadableUnitId = @unitid

		AND	DivisionCode = @divisioncode

		AND	BUT.RecordStatusCode <> ''X''

		AND PT.AboRhConfirmationRequired = 1

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsByUnitId] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsEligibleForCrossover]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Gets Blood Unit data for all units that meet the following business rule criteria:
**		-> The unit and actor are in the same division (division parameter)
**		-> The unit is restricted for a patient and is not autologous
**		-> Donation type is "Volunteer Directed, Elgible for Crossover"
**		-> Unit is not in final status
**		-> Unit is not assigned to a patient
**
**	Author:	David Askew
**
**	Date: 	3/1/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	10/11/2004	Carrie Van Stedum	Changed for the db design change of adding bloodunitshipment table
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/21/2005	Lohse		Adding ORDER BY EyeReadableUnitId, FullProductCode
**	07/07/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; capitalized all SQL statements
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitsEligibleForCrossover]
(
		@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT DISTINCT
		vwBLWCS.BloodUnitGuid,
		vwBLWCS.EyeReadableUnitId,
		vwBLWCS.DirectedPatientGuid,
		vwBLWCS.UnitProductCode,
		vwBLWCS.RhFactorCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  vwBLWCS.UnitExpirationDate) AS UnitExpirationDate,
		vwBLWCS.DonationTypeID, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, vwBLWCS.UnitInDate) AS UnitInDate,
		vwBLWCS.DivisionCode,
		vwBLWCS.BloodTypeCode,
		vwBLWCS.UnitFdaRegistrationNumber,
		vwBLWCS.LabelTypeCode,
		vwBLWCS.LabelUnitId,
		vwBLWCS.ProductTypeCode,
		vwBLWCS.BloodProductGuid,
		vwBLWCS.ProductName,
		vwBLWCS.ProductShortName,
		vwBLWCS.BiohazardousWarningIndicator,
		vwBLWCS.DonationTypeText,
		vwBLWCS.ProductTypeName,
		vwBLWCS.RhFactorText,
		vwBLWCS.FacilityName,
		vwBLWCS.PatientFirstName,
		vwBLWCS.PatientMiddleName,
		vwBLWCS.PatientLastName,
		vwBLWCS.MaximumStorageTime,
		vwBLWCS.VistaPatientId,
		vwBLWCS.PatientSSN,
		vwBLWCS.DisplayVistaPatientId,
		vwBLWCS.UnitStatusComments,
		vwBLWCS.DiscardCannedCommentGuid,
		vwBLWCS.UnitStatusCode,
		vwBLWCS.UnitStatusText,
		vwBLWCS.QuarantineIndicator,
		vwBLWCS.TestingStatusId,
		vwBLWCS.OriginalVolume,
		vwBLWCS.[RowVersion],
		vwBLWCS.UnitStatusRowVersion,
		vwBLWCS.Comments,
		vwBLWCS.IncomingShipmentGuid,
		RTRIM(vwBLWCS.BloodTypeCode) + '' '' + vwBLWCS.RhFactorText AS AboRh,
		vwBLWCS.UnitDivisionId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, vwBLWCS.ShipmentDate) AS ShipmentDate,
		vwBLWCS.PresumedTransfusedIndicator,
		CASE LabelTypeCode
			WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
			ELSE UnitProductCode
		END AS FullProductCode 
	FROM
		dbo.vw_BloodShipPatientAllCurrent as vwBLWCS
	WHERE
		vwBLWCS.DivisionCode = @DivisionCode
	AND	(vwBLWCS.UnitStatusCode NOT IN (''D'', ''M'', ''T'', ''X''))
	AND 	(vwBLWCS.DirectedPatientGuid IS NOT NULL)
	AND	(vwBLWCS.DonationTypeID = 12)

	AND (SELECT COUNT(1) FROM dbo.Patient 
		JOIN dbo.PatientTreatment ON dbo.Patient.PatientGUID = PatientTreatment.PatientGUID 
		JOIN dbo.PatientOrder ON dbo.PatientTreatment.PatientTreatmentGUID = dbo.PatientOrder.PatientTreatmentGUID 
       		JOIN dbo.OrderedComponent ON dbo.PatientOrder.PatientOrderGUID = dbo.OrderedComponent.PatientOrderGUID 
		JOIN dbo.OrderedUnit ON dbo.OrderedComponent.OrderedComponentGuid = dbo.OrderedUnit.OrderedComponentGuid
		AND dbo.OrderedUnit.BloodUnitGUID = vwBLWCS.BloodUnitGUID AND dbo.OrderedUnit.RecordStatusCode = ''A'') = 0

	ORDER BY EyeReadableUnitId, FullProductCode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsEligibleForCrossover] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsForEdit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects blood units for an invoice
**
**	Author: Martin Tsotchev
**
**	Date: 	02/02/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	05/31/2005	Lohse		Adding logic for BR_11.04 - can''t select a unit that is on an outgoing shipment (confirmed or not)
**	07/07/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; capitalized all SQL statements;
**					added alias to WHERE clause for DivisionCode, UnitStatusCode and BloodUnitGuid
**	01/30/2006	D. Askew	Changed WHERE condition for Unit Status Code for improved performance (CR#1525);
**					changed SQL formatting for readability
**	02/04/2006	D. Askew	Added ReleaseDate IS NULL AND ReleaseTechId IS NULL to WHERE condition for selection
**					of units with previously associated patients, meaning that we will ignore units that are currently
**					assigned/crossmatched (the code was check RecordStatusCode which does not change when
**					we release a unit).
**	03/09/2006	Lohse		Swapped PendingTransfer logic to use PendingTransferIndicator now being returned in vw_BloodShipPatientAllCurrent
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitsForEdit]
(
	@previouslyassociatedunits	BIT,
	@divisioncode		VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BU.BloodUnitGuid,
		EyeReadableUnitId,
		DirectedPatientGuid,
		UnitProductCode,
		RhFactorCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		DonationTypeID, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS UnitInDate,
		DivisionCode,
		BloodTypeCode,
		UnitFdaRegistrationNumber,
		LabelUnitId,
		ProductTypeCode,
		ProductName,
		ProductShortName,
		BiohazardousWarningIndicator,
		DonationTypeText,
		ProductTypeName,
		RhFactorText,
		FacilityName,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName,
		MaximumStorageTime,
		VistaPatientId,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitStatusText,
		QuarantineIndicator,
		TestingStatusId,
		OriginalVolume,
		[RowVersion],
		Comments,
		IncomingShipmentGuid,
		RTRIM(BloodTypeCode) + '' '' + RhFactorText AS AboRh,
		UnitDivisionId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
		BU.PresumedTransfusedIndicator,
		CASE LabelTypeCode
			WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
			ELSE UnitProductCode
		END AS FullProductCode
	FROM
		dbo.vw_BloodShipPatientAllCurrent BU
	WHERE
		BU.DivisionCode = @divisioncode
	-- *******************************************************************************************************************************************************************************************************************
	AND	(BU.UnitStatusCode = ''L'' OR BU.UnitStatusCode = ''A'' OR BU.UnitStatusCode = ''S'' OR BU.UnitStatusCode = ''C'') 
	-- *******************************************************************************************************************************************************************************************************************

	AND	PendingTransferIndicator = 0

	-- *******************************************************************************************************************************************************************************************************************
	AND	(
			-- **********************************************************************
			(
				@previouslyassociatedunits = 1 

				AND BU.BloodUnitGuid NOT IN 
				(
					SELECT 
						BloodUnitGuid 
					FROM 
						dbo.OrderedUnit 
					WHERE 
						ReleaseDate IS NULL
						AND ReleaseTechId IS NULL
				)
			)
			-- **********************************************************************
			OR
			(
				@previouslyassociatedunits = 0

				AND BU.BloodUnitGuid NOT IN 
				(
					SELECT 
						BloodUnitGuid 
					FROM 
						dbo.OrderedUnit
				)
			)
			-- **********************************************************************
		)
	-- *******************************************************************************************************************************************************************************************************************

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsForEdit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsForHistoryReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects blood units for the Blood Unit History Report
**		which requires the ability to view both active and 
**		inactive units
**
**	Author: 	David Askew
**
**	Date: 	10/07/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	------------		---------		------------------
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	07/07/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; capitalized all SQL statements
**					added alias to WHERE clause for DivisionCode
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitsForHistoryReport]
(
	@divisioncode	VARCHAR(50)
)

AS

SET NOCOUNT ON

	SELECT
		BloodUnitGuid,
		RecordStatusCode,
		EyeReadableUnitId,
		DirectedPatientGuid,
		UnitProductCode,
		RhFactorCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		DonationTypeID, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS  UnitInDate,
		DivisionCode,
		BloodTypeCode,
		UnitFdaRegistrationNumber,
		LabelUnitId,
		ProductTypeCode,
		ProductName,
		ProductShortName,
		BiohazardousWarningIndicator,
		DonationTypeText,
		ProductTypeName,
		RhFactorText,
		FacilityName,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName,
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitStatusText,
		QuarantineIndicator,
		TestingStatusId,
		OriginalVolume,
		[RowVersion],
		Comments,
		IncomingShipmentGuid,
		RTRIM(BloodTypeCode) + '' '' + RhFactorText AS AboRh,
		UnitDivisionId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
		PresumedTransfusedIndicator,
		CASE LabelTypeCode
			WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
			ELSE UnitProductCode
		END AS FullProductCode 

	FROM
		dbo.vw_ActiveAndInactiveBloodUnitsWithCurrentStatus BU
	WHERE
		BU.DivisionCode = @divisioncode

SET NOCOUNT OFF
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsForHistoryReport] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsInFinalStatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Gets Blood Unit data for all units that are in a final status (Modified, Transfused, Transferred, Discarded)
**
**	Author: Cameron Taylor
**
**	Date: 	1/27/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------	---------		------------------
**	02/10/2004	Greg Lohse	Adding UnitDivisionId for ISBT alloQUAT unit searching.
**					also adding FullProductCode for VBECSControl - UC5
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/21/2005	Lohse		Adding ORDER BY EyeReadableUnitId, FullProductCode
**	07/07/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; capitalized all SQL statements
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitsInFinalStatus]
(
		@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
		BloodUnitGuid,
		EyeReadableUnitId,
		DirectedPatientGuid,
		UnitProductCode,
		RhFactorCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS  UnitExpirationDate,
		DonationTypeID, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS  UnitInDate,
		DivisionCode,
		BloodTypeCode,
		UnitFdaRegistrationNumber,
		LabelUnitId,
		ProductTypeCode,
		ProductName,
		ProductShortName,
		BiohazardousWarningIndicator,
		DonationTypeText,
		ProductTypeName,
		RhFactorText,
		FacilityName,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName,
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitStatusText,
		QuarantineIndicator,
		TestingStatusId,
		OriginalVolume,
		[RowVersion],
		Comments,
		IncomingShipmentGuid,
		RTRIM(BloodTypeCode) + '' '' + RhFactorText AS AboRh,
		UnitDivisionId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
		PresumedTransfusedIndicator,
		CASE LabelTypeCode
			WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
			ELSE UnitProductCode
		END AS FullProductCode 
	FROM
		dbo.vw_BloodShipPatientAllCurrent
	WHERE
		DivisionCode =@DivisionCode
	AND 	UnitStatusCode IN (''D'',''M'',''T'',''X'')

	ORDER BY EyeReadableUnitId, FullProductCode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsInFinalStatus] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitsInPool]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects blood units that were used to pool the passed in unit
**
**	Author: 	Greg Lohse
**	
**	Date: 	03/10/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	--------------	---------		------------------
**	03/10/2004	Greg Lohse	Initial Draft.
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	03/29/2005	Lohse		Adding RecordStatusCode to where clause
**	07/22/2005	Lohse		Adding OriginalUnitIndicator
**	07/07/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated
**	11/18/2005	Lohse		Adding ModificationCost (needed for later update in spUpdateBloodunitModification
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitsInPool]
(
	@tobloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
		BloodUnitModificationGuid,
		FromBloodUnitGuid,
		ToBloodUnitGuid,
		ProductModificationCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ModificationDate) AS ModificationDate,
		ModificationTechID,
		ModificationMethodCode,
		NewContainerWeldIndicator,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, NewLabelVerificationDatetime) AS NewLabelVerificationDatetime,
		@divisioncode AS DivisionCode,
		OriginalUnitIndicator,
		[RowVersion],
		ModificationCost
	FROM
		dbo.BloodUnitModification 
	WHERE
		ToBloodUnitGuid = @tobloodunitguid
	AND	RecordStatusCode = ''A''

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitsInPool] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitStatusByGuid]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets Blood Unit Status By Guid
**
**	Author:	John Vrooland
**
**	Date: 	03/13/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------		----			-----------
**	8/15/03	Carrie Van Stedum	Removed the select of the BUS recordstatuscode
**	10/02/2003	Greg Lohse	Removed the select of BUS.DivisionCode (where''d it go?)
**	10/17/2003	Greg Lohse	Removed the UnitStatusText -- not needed
**	04/05/2004	C. Jensen	Added PresumedTransfusedIndicator
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/09/2004	C. Taylor	PresumedTranfusedIndicator typo
**	01/19/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid, QuarantineDetailCode
**					to QuarantineCannedCommentGuid
**	07/15/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	04/11/2006	Lohse		Adding TestingLimitIndicator (needed for UC2/UnitStatusCode) (CR1730)
**	01/04/2010	M. Smith	Changed to get UnitStatusCode from the BloodUnitStatusCodeCurrent table. (CR 1174)
**	01/21/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	12/08/2011	K. Dobranowski	Added LastUpdateDate for BloodUnitStatusCodeCurrent (CR 3195)
**	12/28/2011	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitStatusByGuid]
(
    	@bloodunitguid		UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT 
		BUS.BloodUnitStatusGuid, 
		BUS.BloodUnitGuid, 
		BUSCC.UnitStatusCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUS.UnitStatusDate) AS UnitStatusDate, 
		BUS.UnitStatusComments, 
		BUS.DiscardCannedCommentGuid, 
		BUS.BiohazardousWarningIndicator, 
		BUS.QuarantineIndicator, 
		BUS.QuarantineCannedCommentGuid, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUS.LastUpdateDate) AS LastUpdateDate, 
		BUS.LastUpdateUser, 
		BUS.PresumedTransfusedIndicator,
		BUS.EmergencyIssueIndicator,
		BUS.[RowVersion],
		@divisioncode AS DivisionCode,
		BUS.TestingLimitIndicator,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUSCC.LastUpdateDate) AS CurrentStatusLastUpdateDate

	FROM	dbo.BloodUnitStatus BUS
		JOIN dbo.BloodUnitStatusCodeCurrent BUSCC
			ON BUS.BloodUnitGuid = BUSCC.BloodUnitGuid
	WHERE
		BUS.BloodUnitGuid = @bloodunitguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitStatusByGuid] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestingWorklist]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'


/*******************************************************************************************************************************************************************************
**	Desc:	Get results of all unit ABO/Rh and Antigen Typing tests for a given division and date range (BR_48.10)
**
**	Author:	Cameron Taylor
**
**	Date: 	02/26/2004
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/19/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/15/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; renamed parameter to be consistent with 
**					database standards (all lower case); changed formatting slightly for readability
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/12/2005	C. Taylor	CR 1141: Added Lot Number to TestedWith column for AG Typings.
**						Changed to use vw_ActiveAndInactiveBloodUnits view otherwise joins may fail when run historically.
**	01/17/2006	C. Taylor	Added FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) to ProductShortName (DR 1729)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**  05/18/2012  Lohse		**SQL 2008 Upgrade** - Ln121 - removing alias from ORDER BY clauses
**	01/18/2015	K. Dobranowski	Added AutoInstrumentComments (Defect 251282)
**	01/22/2015	K. Dobranowski	Added UnitResultSetGuid (Defect 251282)
**	02/04/2016	K. Dobranowski	Added ReviewUser (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/23/2016	K. Dobranowski Removed CAST from BUT.TestComments. Added error handling (Defect 286179)
**	03/31/2016	R. Sankala	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestingWorklist]
(
	@startdate			DATETIME,
	@enddate			DATETIME,
	@divisioncode		VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
--Convert the start and end date to UTC 
SET @StartDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate) 
SET @EndDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate) 

SELECT DISTINCT
	2 AS TestingWorklistReportType,
	BUT.BloodUnitGuid,
	BUT.BloodUnitTestGuid,
	ISNULL(BUT.AntiseraWorklistTypingGuid,BUT.ConfirmationWorklistUnitGuid) AS BloodUnitTestId,
--Test Performed
	OT.OrderableTestID,
	OT.OrderableTestText as OrderableTestName,
--Unit ID and Product COde
	BU.EyeReadableUnitID,
	BU.UnitProductCode,
	CASE BU.LabelTypeCode
		WHEN ''I'' THEN BU.ProductShortName+'', ''+BU.UnitProductCode + BU.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
		ELSE BU.ProductShortName+'', ''+BU.UnitProductCode
	END AS ProductShortName, 
	BU.UnitDivisionId,
--Testing Method
	BUT.TestingMethodCode,
	TM.TestingMethodText,
--Rack (if applicable)
	RCK.RackName,
--Tested With
	CASE ISNULL(TWR.LotNumber,'''')
	WHEN '''' THEN
		BTT.TestedWith
	ELSE
		BTT.TestedWith + '', '' + TWR.LotNumber
	END AS TestedWith,
	BTT.BloodTestTypeId,
	BTT.BloodTestName,
	BTT.SortColumn,
--Phase
	BTT.Phase,
--Reaction Result
	BUT.TestResultId,
	TR.TestResultText,
--Testing Tech
	BUT.TestTechID,
	ISNULL(TU.UserName,BUT.TestTechID) as TestTechName,
--Date Tested
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) as TestDate,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,(SELECT TOP 1 BloodUnitTest.TestDate FROM dbo.BloodUnitTest WHERE ISNULL(BloodUnitTest.AntiseraWorklistTypingGUID,BloodUnitTest.ConfirmationWorklistUnitGuid) = ISNULL(BUT.AntiseraWorklistTypingGUID,BUT.ConfirmationWorklistUnitGuid) AND BloodUnitTest.BloodUnitGuid = BUT.BloodUnitGuid AND ISNULL(BloodUnitTest.InactivateDate,''1/1/2000'') = ISNULL(BUT.InactivateDate,''1/1/2000'') ORDER BY BloodUnitTest.TestDate DESC)) AS WorklistDate,
--Additional Info
	BUT.TestComments,
	BUT.AutoInstrumentName,
	BUT.RecordStatusCode,
	BUT.LastUpdateUser,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.LastUpdateDate) AS LastUpdateDate, 
	ISNULL(IU.UserName,BUT.InactivateUser) AS InactivateUser,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS InactivateDate,
--	Instrument Comment
	PBUT.AutoInstrumentComments,
	PBUT.UnitResultSetGuid,
	LU.UserName AS ReviewUser

FROM
	dbo.BloodUnitTest BUT
	LEFT JOIN  dbo.vw_ActiveAndInactiveBloodUnits BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
	LEFT JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
	LEFT JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
	LEFT JOIN dbo.OrderableTest OT on OT.OrderableTestID = BTT.OrderableTestID
	LEFT JOIN dbo.TestingMethod TM ON BUT.TestingMethodCode = TM.TestingMethodCode
	LEFT JOIN dbo.Rack RCK on RCK.RackGUID = BUT.RackGUID
	LEFT JOIN dbo.VbecsUser IU ON BUT.InactivateUser = IU.VbecsUserId
	LEFT JOIN dbo.VbecsUser TU ON BUT.TestTechId = TU.VbecsUserId
	LEFT JOIN dbo.ConfirmationWorklistUnit CWU ON BUT.ConfirmationWorklistUnitGuid = CWU.ConfirmationWorklistUnitGuid
	LEFT JOIN dbo.RackLot TWRL ON TWRL.RackLotGuid = (SELECT TOP 1 RackLot.RackLotGuid 
								FROM dbo.RackLot
								JOIN dbo.AntiseraUnitTest ON AntiseraUnitTest.RackLotGuid = RackLot.RackLotGuid
								WHERE AntiseraUnitTest.AntiseraWorklistTypingGuid = BUT.AntiseraWorklistTypingGuid
								AND ((BUT.BloodTestTypeID NOT IN (28,29,30) AND RackLot.ControlCellId IS NULL) OR (BUT.BloodTestTypeID IN (28,29,30) AND RackLot.ControlCellId = 0))
								AND RackLot.LotVialNumber IS NULL
								AND RackLot.TestWithId IS NULL
								AND AntiseraUnitTest.RecordStatusCode = BUT.RecordStatusCode)
	LEFT JOIN dbo.Reagent TWR ON TWR.ReagentGuid = TWRL.ReagentGuid
	LEFT JOIN dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid
	LEFT JOIN	dbo.VbecsUser LU ON BUT.EntryTechId = LU.VbecsUserId

WHERE
	BUT.DivisionCode = @divisioncode
	AND	BUT.RecordStatusCode IN (''A'', ''E'',''X'')
	AND BUT.TestDate BETWEEN @startdate AND @enddate
	AND ((BUT.BloodTestTypeID > 200) OR (BUT.BloodTestTypeID in (15,16,17,18,19,20,21,28,29,30)))
ORDER BY
	OT.OrderableTestID, WorklistDate, BU.EyeReadableUnitID, BU.UnitProductCode, BU.UnitDivisionId, BUT.RecordStatusCode, BloodUnitTestId, BTT.SortColumn, BTT.Phase, TestDate, InactivateDate

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)



' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestingWorklist] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestingWorklistCount]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Get a preliminary number of rows that will be returned by the report stored procedure
**
**	Author:	Cameron Taylor
**
**	Date: 	04/16/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	07/15/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated; renamed parameter to be consistent with 
**					database standards (all lower case); changed formatting slightly for readability
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestingWorklistCount]
(
	@startdate		DATETIME,
	@enddate		DATETIME,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	--Convert the start and end date to UTC 
	SET @StartDate = dbo.fnTimeZoneConversionDateTime(@DivisionCode, 1, @StartDate) 
	SET @EndDate = dbo.fnTimeZoneConversionDateTime(@DivisionCode, 1, @EndDate) 
	
	SELECT
	
	COUNT(1) AS Total
	
	FROM dbo.BloodUnitTest BUT
	
	WHERE	BUT.DivisionCode = @DivisionCode
	AND		BUT.RecordStatusCode IN (''A'', ''E'', ''X'')
	AND		((BUT.BloodTestTypeID IN (15,16,17,18,19,20,21)) OR (BUT.BloodTestTypeID >200))
	AND		BUT.TestDate BETWEEN @startdate AND @enddate

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestingWorklistCount] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResult]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets Blood Unit Test Result
**
**	Author:	John Vrooland, Cameron Taylor
**
**	Date: 	03/10/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	04/27/04	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/15/05 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	11/29/06	Lohse		Adding fitler to only include Active records - this affects UC_4, UC_41 - CR 2099
**	02/08/07	D. Askew     	** Reviewed for compliance with database standards and recommendations **
**					Added dbo prefix
**	10/07/16	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestResult]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@bloodtesttypeid	INT,
	@divisioncode		VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BUT.BloodUnitTestGuid,
		BUT.BloodUnitGuid,
		BUT.BloodTestTypeId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate,
		BUT.TestResultID,
		BUT.TestComments,
		BUT.EntryMethodCode,
		BUT.DivisionCode,
		BUT.RowVersion,
		TR.TestResultText
		
	FROM 
		dbo.BloodUnitTest BUT
		LEFT JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
	
	WHERE 
		BUT.DivisionCode = @divisioncode 
	AND	BUT.BloodUnitGUID = @bloodunitguid 
	AND 	BUT.BloodTestTypeID = @bloodtesttypeid
	AND	BUT.RecordStatusCode = ''A''
	AND	BUT.TestResultId IS NOT NULL			--partially completed antigen tests will have null values, but A recordstatuscodes

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestResult] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResults]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets Blood Unit Test Results
**
**	Author:	John Vrooland
**
**	Date: 	05/15/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/27/04	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	07/08/04	Greg Lohse	Adding columns (denoted by --)
**	10/01/04 	C.Jensen	Added RecordStatusCode
**	07/15/05 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated
**	06/30/05	Lohse		Adding more fields for Modification test duplication (denoted by --*)
**	08/19/05	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV, SEE ABOVE
**	04/04/06	Lohse		Adding DateTimeConversion to InactivateDate
**	11/29/06	Lohse		Adding fitler to only include Active records - this affects UC_4, UC_41 - CR 2099
**	02/08/07	D. Askew     	** Reviewed for compliance with database standards and recommendations **
**					Added dbo prefix
**	10/13/10	M. Smith	Changed the input parameter to allow multiple blood unit guids.  (CR 2899)
**	12/22/10	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/16	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestResults]
(
	@bloodunitguidlist	VARCHAR(8000),  -- Allows multiple copies of (38-character guid + 1-char delimiter)
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BUT.BloodUnitTestGuid,
		BUT.BloodUnitGuid,
		BUT.BloodTestTypeId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate,
		BUT.TestTechId,--
		BUT.OrderedTestGuid, --
		BUT.TestingMethodCode, --
		BUT.EntryTechId, --
		BUT.CorrectedResultIndicator, --
		BUT.AntiseraWorklistTypingGuid, --
		BUT.ConfirmationWorklistUnitGuid, --
		BUT.TestResultId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS InactivateDate,
		BUT.TestComments,
		BUT.EntryMethodCode,
		BUT.DivisionCode,
		BUT.RecordStatusCode,
		BUT.[RowVersion],
		TR.TestResultText,
		BUT.AutoInstrumentName,--*
		BUT.RackGuid--*
		
	FROM	dbo.BloodUnitTest BUT
			JOIN dbo.fnSplit(@bloodunitguidlist, '','')
				ON BUT.BloodUnitGUID = Item
			JOIN dbo.TestResult TR 
				ON TR.TestResultID = BUT.TestResultID
	
	WHERE
		BUT.DivisionCode = @divisioncode
	AND	BUT.RecordStatusCode = ''A''
	AND	BUT.TestResultId IS NOT NULL		--partially completed antigen tests will have null values, but A recordstatuscodes

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestResults] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForAntiseraWorklist]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets Blood Unit Test Results for an antisera worklist
**
**	Author:	Cameron Taylor
**
**	Date: 	06/19/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	03/02/2004	C. Taylor	Added RowVersion
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/15/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestResultsForAntiseraWorklist]
(
	@bloodunitguid			UNIQUEIDENTIFIER,
	@antiseraworklisttypingguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		BUT.BloodUnitTestGuid,
		BUT.BloodUnitGuid,
		BU.EyeReadableUnitId,
		BP.ProductShortName,
		BUT.BloodTestTypeId,
		BTT.BloodTestName,
		OT.OrderableTestText,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate,
		BUT.TestTechId,
		BUT.TestResultId,
		BUT.TestComments,
		BUT.EntryMethodCode,
		BUT.DivisionCode,
		TR.TestResultText,
		BUT.RowVersion
		
	FROM dbo.BloodUnitTest BUT
	
	LEFT JOIN dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
	JOIN dbo.BloodTestType BTT ON BTT.BloodTestTypeId = BUT.BloodTestTypeId
	JOIN dbo.OrderableTest OT ON OT.OrderableTestID = BTT.OrderableTestID
	JOIN dbo.BloodUnit BU ON BU.BloodUnitGuid = BUT.BloodUnitGuid
	JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BU.BloodProductGuid
	
	WHERE  BUT.BloodUnitGuid = @BloodUnitGUID
	AND BUT.AntiseraWorklistTypingGuid = @AntiseraWorklistTypingGUID 
	AND BUT.RecordStatusCode != ''X''		

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestResultsForAntiseraWorklist] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForDivision]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/***********************************************************************************************************
**
**	Desc:	Gets Blood Unit Test Results For Division
**
**	Author:	John Vrooland
**
**	Date: 	03/10/2003
**
************************************************************************************************************
**  Modified:
**  Date        Name        Description
**	----------  ---------   ------------------
**  07/17/2005  D. Askew    ** Reviewed for compliance with database standards and recommendations **
**                          NO COUNT set OFF; comments updated; capitalized SQL statements
**  07/19/2005  S. Antropov ** Reviewed for compliance with database standards and recommendations **
**                          Placed the call to fnBloodUnitTestResultsForDivision inline, removed 
**                          unneeded local variable, reformatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
***********************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestResultsForDivision]
(
	@divisioncode	VARCHAR(50),
	@bloodtesttypeid	INT      = NULL,
	@testresultid		CHAR(2)  = NULL
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

   SELECT 
            BUT.BloodTestTypeID, 
            BTT.BloodTestName, 
            BUT.BloodUnitGUID, 
            BUT.DivisionCode, 
            dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS TestDate, 
            TR.TestResultText, 
            TR.TestResultID
   FROM 
            dbo.BloodUnitTest BUT
   JOIN 
            dbo.BloodTestType BTT ON BUT.BloodTestTypeID = BTT.BloodTestTypeID 
   JOIN 
            dbo.TestResult TR ON BUT.TestResultID = TR.TestResultID
   WHERE
            BUT.DivisionCode = @divisioncode 
        AND BUT.RecordStatusCode NOT IN(''X'',''E'',''T'')
        AND TR.TestResultId LIKE ISNULL( @testresultid, ''%'' )
        AND (
              ( @bloodtesttypeid IS NULL ) 
              OR 
              ( @bloodtesttypeid IS NOT NULL AND @bloodtesttypeid = BUT.BloodTestTypeId )
            )

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestResultsForDivision] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForOrderedComponent]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

/*******************************************************************************************************************************************************************************
**	Desc:	Gets test results for a given ordered component
**
**	Author:	Cameron Taylor
**
**	Date: 	04/09/2004
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/23/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/17/2005	NPaterson	Use new view for increased performance
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	04/04/2006	Lohse		Adding DateTimeConversion to InactivateDate
**	01/31/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to allow invalidation logic to differentiate between automated and manual tests (Defect 251282)
**	02/10/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to the ELSE part of the stored procedure (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitTestResultsForOrderedComponent]
(
	@orderedcomponentguid	UNIQUEIDENTIFIER,
	@bloodunitguid			UNIQUEIDENTIFIER = NULL,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT OFF

IF @BloodUnitGUID IS NULL
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedComponentGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedComponent OC ON OC.OrderedComponentGUID = BUT.OrderedComponentGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OC.PatientSpecimenGUID
		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		LEFT JOIN	dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid
		
		WHERE	BUT.OrderedComponentGUID = @orderedcomponentguid
		AND		BUT.RecordStatusCode = ''A''
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END
ELSE
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedComponentGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedComponent OC ON OC.OrderedComponentGUID = BUT.OrderedComponentGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OC.PatientSpecimenGUID
		LEFT JOIN		dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		LEFT JOIN	dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		WHERE	BUT.OrderedComponentGUID = @orderedcomponentguid
		AND		BUT.BloodUnitGUID = @bloodunitguid
		AND		BUT.RecordStatusCode = ''A''
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END
		
SET NOCOUNT OFF

RETURN(@ERROR)


' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestResultsForOrderedComponent] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitTestResultsForOrderedTest]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

/*******************************************************************************************************************************************************************************
**	Desc:	Gets test results for a given ordered test
**
**	Author:	Cameron Taylor
**
**	Date: 	04/09/2004
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/17/2005	NPaterson	Changed to use new view for increased performance
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	04/04/2006	Lohse		Adding DateTimeConversion to InactivateDate
**	01/31/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to allow invalidation logic to differentiate between automated and manual tests (Defect 251282)
**	02/10/2016	K. Dobranowski	Added JOIN to PendingBloodUnitTest to the ELSE part of the stored procedure (Defect 251282)
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodUnitTestResultsForOrderedTest]
(
	@orderedtestguid	UNIQUEIDENTIFIER,
	@bloodunitguid		UNIQUEIDENTIFIER = NULL,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET NOCOUNT ON

IF @BloodUnitGUID IS NULL
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedTestGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = BUT.OrderedTestGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID
		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		JOIN		dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid
		
		WHERE	BUT.OrderedTestGUID = @orderedtestguid
		AND		BUT.RecordStatusCode = ''A''
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END
ELSE
	BEGIN
		SELECT
			PS.PatientSpecimenGUID,
			BUT.OrderedTestGUID,
			BUT.BloodUnitTestGUID,
			BUT.OrderedUnitGuid,
		--Blood Unit
			BU.BloodUnitGUID,
			BU.EyeReadableUnitID,
			BU.ProductShortName,
		--Testing Method
			BUT.TestingMethodCode,
			TM.TestingMethodText,
		--Rack
			BUT.RackGUID,
			R.RackName,
		--Tested With
			BTT.TestedWith,
		--Phase
			BUT.BloodTestTypeID,
			BTT.BloodTestName,
			BTT.Phase,
			BTT.SortColumn,
		--Reaction Result
			BUT.TestResultID,
			TR.TestResultText,
		--Testing Tech
			ISNULL(VU.UserName,BUT.TestTechID) AS TestTechID,
		--Date Tested
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.TestDate) AS  TestDate,
		--Additional Info
			BUT.TestComments,
			BUT.AutoInstrumentName,
			BUT.RecordStatusCode,
			BUT.InactivateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
			BUT.[RowVersion],
			PBUT.UnitResultSetGuid
			
		FROM dbo.BloodUnitTest BUT
		
		JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = BUT.OrderedTestGUID
		JOIN		dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
		LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID
		LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
		LEFT JOIN	dbo.Rack R ON R.RackGUID = BUT.RackGUID
		JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
		JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
		JOIN		dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
		LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
		LEFT JOIN	dbo.PendingBloodUnitTest PBUT ON PBUT.BloodUnitTestGuid = BUT.BloodUnitTestGuid

		WHERE	BUT.OrderedTestGUID = @orderedtestguid
		AND		BUT.BloodUnitGUID = @bloodunitguid
		AND		BUT.RecordStatusCode = ''A''
		
		ORDER BY BU.EyeReadableUnitID,BU.UnitProductCode,BUT.BloodTestTypeID

		SET @ERROR = @@ERROR
	END	

SET NOCOUNT OFF
	
RETURN(@ERROR)


' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitTestResultsForOrderedTest] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodUnitWrkLst]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Gets Blood Unit data for a given product code and or unit id for the worklist builder control
**
**	Author: 	Carrie Van Stedum
**
**	Date: 	8/29/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	----------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	10/03/02	LMeyer			Added UnitCost, SpecialTestingCost, & ReturnCreditAmount
**	10/4/2002	LMeyer			Took out UnitCost, SpecialTestingCost, & ReturnCreditAmount
**	10/9/2002	LMeyer			Added RowVersion
**	10/10/2002	LMeyer/MSmith		Added DivisionCode to WHERE condition
**	12/2/2002	C Taylor		Added PatientSSN and TestingStatusCode and ProductShortName
**	12/10/2002	C Taylor		Added AssignedPatientLastName, AssignedPatientFirstName, AssignedPatientMiddleInitial, AssignedPatientSSN and SpecimenExpirationDate
**	12/18/2002	LMeyer			Added TestingStatusID/Deleted TestingStatusCode
**	1/2/2003	C Taylor		Added OriginalVolume and MaximumStorageTime
**	1/9/2003	C Taylor		Added Comments
**	1/16/2003	C Jensen		Added IncomingShipmentGUID
**	1/28/2003	C Jensen		Added UnitContainerLotNumber
**	1/31/2003	C Jensen		Added UnitDivisionID
**	10/14/2003	Greg Lohse		Removing NULL parm defaults and the logic to support them, reformatting, etc.
**	12/23/03	C Taylor		Replaced PatientMiddleInitial with PatientMiddleName
**	01/13/2004	C. Taylor		Added DisplayVistaPatientId
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor		Added PresumedTransfusedIndicator
**	01/20/2005	C. Jensen		Changed DiscardDetailCode to DiscardCannedCommentGuid
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
**	11/22/05	C.VanStedum	Added product code
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	01/04/2010	M. Smith	Changed to get UnitStatusCode from the BloodUnitStatusCodeCurrent table. (CR 1174)
**	01/21/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodUnitWrkLst]
(
	@unitid			VARCHAR(13),
	@productguid		UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50),
	@unitproductcode	VARCHAR(8) = NULL
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	if(@unitproductcode is NULL) OR LEN(@unitproductcode) = 5
		BEGIN

			SELECT

				BU.BloodUnitGUID,
				EyeReadableUnitID,
				DirectedPatientGuid,
				UnitProductCode,
				RhFactorCode,

				dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 	AS  UnitExpirationDate,

				DonationTypeID,
				UnitContainerLotNumber,
				UnitDivisionID,
				BloodProductGUID,

				dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 		AS  UnitInDate,

				DivisionCode,
				BloodTypeCode,
				UnitFdaRegistrationNumber,
				LabelUnitID,
				LabelTypeCode,
				ProductTypeCode,
				ProductName,
				ProductShortName,
				BUS.BiohazardousWarningIndicator,
				DonationTypeText,
				ProductTypeName, 
				RhFactorText,
				FacilityName,
				PatientFirstName,
				PatientMiddleName,
				PatientLastName,
				MaximumStorageTime,
				VistaPatientID,
				PatientSSN,
				DisplayVistaPatientId,
				BUS.UnitStatusComments,
				BUS.DiscardCannedCommentGuid,
				BUSCC.UnitStatusCode,
				UnitStatusText,
				BUS.QuarantineIndicator,
				TestingStatusId,
				OriginalVolume, 
				BU.[RowVersion],
				BUS.[RowVersion] 								AS UnitStatusRowVersion,
				Comments,
				IncomingShipmentGUID,
				BUS.BloodUnitStatusGUID,

				dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) 		AS ShipmentDate,

				BU.PresumedTransfusedIndicator

			FROM

				dbo.vw_BloodShipPatientAllCurrent BU
					JOIN dbo.BloodUnitStatus BUS 
						ON BUS.BloodUnitGUID = BU.BloodUnitGUID
					JOIN dbo.BloodUnitStatusCodeCurrent BUSCC
						ON BU.BloodUnitGuid = BUSCC.BloodUnitGuid

			WHERE

				bloodproductguid = @productguid

			AND	DivisionCode =@divisioncode

			AND	(EyeReadableUnitID = @unitid OR  LabelUnitID = @unitid)
		END
	ELSE
		BEGIN

		SELECT

				BU.BloodUnitGUID,
				EyeReadableUnitID,
				DirectedPatientGuid,
				UnitProductCode,
				RhFactorCode,

				dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 	AS  UnitExpirationDate,

				DonationTypeID,
				UnitContainerLotNumber,
				UnitDivisionID,
				BloodProductGUID,

				dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 		AS  UnitInDate,

				DivisionCode,
				BloodTypeCode,
				UnitFdaRegistrationNumber,
				LabelUnitID,
				LabelTypeCode,
				ProductTypeCode,
				ProductName,
				ProductShortName,
				BUS.BiohazardousWarningIndicator,
				DonationTypeText,
				ProductTypeName, 
				RhFactorText,
				FacilityName,
				PatientFirstName,
				PatientMiddleName,
				PatientLastName,
				MaximumStorageTime,
				VistaPatientID,
				PatientSSN,
				DisplayVistaPatientId,
				BUS.UnitStatusComments,
				BUS.DiscardCannedCommentGuid,
				BUSCC.UnitStatusCode,
				UnitStatusText,
				BUS.QuarantineIndicator,
				TestingStatusId,
				OriginalVolume, 
				BU.[RowVersion],
				BUS.[RowVersion] 								AS UnitStatusRowVersion,
				Comments,
				IncomingShipmentGUID,
				BUS.BloodUnitStatusGUID,

				dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) 		AS ShipmentDate,

				BU.PresumedTransfusedIndicator

			FROM
				dbo.vw_BloodShipPatientAllCurrent BU
					JOIN dbo.BloodUnitStatus BUS 
						ON BUS.BloodUnitGUID = BU.BloodUnitGUID
					JOIN dbo.BloodUnitStatusCodeCurrent BUSCC
						ON BU.BloodUnitGuid = BUSCC.BloodUnitGuid
			WHERE

				bloodproductguid = @productguid
				
			AND	UnitProductCode = SUBSTRING(@unitproductcode, 1, 5)

			AND 	UnitDivisionID = SUBSTRING(@unitproductcode, 7, 2)

			AND 	DonationTypeCode = SUBSTRING(@unitproductcode, 6,1)
			AND	DivisionCode =@divisioncode

			AND	(EyeReadableUnitID = @unitid OR  LabelUnitID = @unitid)
		END

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBloodUnitWrkLst] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBoodUnitTestResultsForTransfusionReaction]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************

**	Desc: 	Gets the ABO/Rh and XM unit tests for a TRW
**
**	Author:	David Askew (slightly different version of Cameron''s spGetBloodUnitTestResultsForOrderedTest)
**
**	Date: 	6/1/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability;
**					capitalized SQL statements; ORT.OrderableTestId = 10 requirement was removed from
**					 WHERE clause (was commented out) at some point but was not notated, I am removing the
**					 unused code
**	04/04/2006	Lohse		Added DateTimeConversion  to  InactivateDate
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBoodUnitTestResultsForTransfusionReaction]
(
	@orderedtestguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

SELECT DISTINCT
	PS.PatientSpecimenGUID,
	BUT.OrderedTestGUID,
	BUT.BloodUnitTestGUID,
	PTR.PatientTransfusionReactionGuid,
--Blood Unit
	BU.BloodUnitGUID,
	BU.EyeReadableUnitID,
	BU.ProductShortName,
--Testing Method
	BUT.TestingMethodCode,
	TM.TestingMethodText,
--Rack
	BUT.RackGUID,
	R.RackName,
--Tested With
	BTT.TestedWith,
--Phase
	BUT.BloodTestTypeID,
	BTT.BloodTestName,
	BTT.Phase,
	BTT.SortColumn,
--Reaction Result
	BUT.TestResultID,
	TR.TestResultText,
--Testing Tech
	VU.UserName AS TestTechID,
--Date Tested
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TestDate) AS  TestDate,
--Additional Info
	BUT.TestComments,
	BUT.AutoInstrumentName,
	BUT.RecordStatusCode,
	BUT.InactivateUser,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUT.InactivateDate) AS  InactivateDate,
	BUT.[RowVersion]
	
FROM dbo.BloodUnitTest BUT

JOIN		dbo.OrderedTest OT ON OT.OrderedTestGUID = BUT.OrderedTestGUID
JOIN		dbo.PatientTransfusionReaction PTR ON OT.OrderedTestGuid = PTR.OrderedTestGuid AND PTR.RecordStatusCode NOT IN (''E'',''X'')
JOIN		dbo.TransfusionReaction TRN ON PTR.PatientTransfusionReactionGuid = TRN.PatientTransfusionReactionGuid
JOIN 		dbo.PatientTransfusion PT ON TRN.PatientTransfusionGuid = PT.PatientTransfusionGuid
JOIN dbo.vw_BloodShipAllCurrent BU ON BU.BloodUnitGUID = BUT.BloodUnitGUID
LEFT JOIN	dbo.PatientSpecimen PS ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID
LEFT JOIN	dbo.TestingMethod TM ON TM.TestingMethodCode = BUT.TestingMethodCode
JOIN		dbo.BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID
JOIN		dbo.TestResult TR ON TR.TestResultID = BUT.TestResultID
JOIN		dbo.VbecsUser VU ON BUT.TestTechID = VU.VbecsUserId
LEFT JOIN	dbo.OrderableTest ORT ON ORT.OrderableTestID = BTT.ReportableTestID
LEFT JOIN	dbo.Rack R ON R.RackGuid = BUT.RackGuid

WHERE	BUT.OrderedTestGUID = @OrderedTestGUID
AND		BUT.RecordStatusCode = ''A''
AND		BUT.BloodTestTypeId IN (105, 106, 109, 110)

ORDER BY BU.EyeReadableUnitID,BU.ProductShortName,BUT.BloodTestTypeID

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetBoodUnitTestResultsForTransfusionReaction] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCannedComment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Name: 	spGetCannedComment
**
**	Desc: 	Selects a record from the CannedComment table based on the Guid
**
**	Author:	Cameron Taylor
**
**	Date: 	07/26/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated; capitalized SQL statements
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCannedComment]
(
	@cannedcommentguid		UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		CannedCommentGuid,
		CannedCommentText,
		CannedCommentCategoryCode,
		SortColumn,
		DivisionCode,
		RecordStatusCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LastUpdateDate) AS LastUpdateDate,
		LastUpdateUser,
		RowVersion
	FROM
		dbo.CannedComment
	WHERE
		CannedCommentGuid = @cannedcommentguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCannedComment] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCannedComments]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects all records from the CannedComment table based on the division code and, if supplied, catgegory code.
**
**	Author:	Cameron Taylor
**
**	Date: 	11/5/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	06/17/2003	M.Jablonski	Per C.Taylor, any time canned comments are used, they should include General Comments. 
**					Add  CannedCommentCategoryCode = ''GC'' line and CannedCommentCategoryCode ASC to Order By
**	8/4/2003	C. Jensen	I changed the stored procedure to retrieve comments regardless of RecordStatusCode.  The code will
**					now apply a filter to show only Active comments.  Previously, if the most recent comment in the table was
**					inactive, the code would increment the CannedCommentID incorrectly and the save would fail.
**	10/17/2003	C. Taylor	We must check RecordStatusCode if CannedCommentCategoryCode is supplied, else we will be offering 
**					inactive comments.  Also, the SMEs have changed their minds (Gasp!!), ''GC'' will not be supplied by default 
**					any more.
**	01/20/2004	C. Taylor	Replaced CannedCommentID with CannedCommentGUID
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated; capitalized SQL statements; removed unused code
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCannedComments]
(
	@divisioncode	VARCHAR(50),
	@cannedcommentcategorycode		CHAR(2) = NULL
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

IF (@cannedcommentcategorycode IS NOT NULL)
BEGIN
	SELECT
			CannedCommentGUID,
			CannedCommentText,
			CannedCommentCategoryCode,
			SortColumn,
			DivisionCode,
			RecordStatusCode,
			LastUpdateUser,
			RowVersion
	FROM
			dbo.CannedComment
	WHERE
			DivisionCode = @divisioncode
		AND	CannedCommentCategoryCode = @cannedcommentcategorycode
		AND RecordStatusCode = ''A''
	ORDER BY
			CannedCommentCategoryCode ASC, SortColumn ASC
END
ELSE
BEGIN
	SELECT
			CC.CannedCommentGUID,
			CC.CannedCommentText,
			CC.CannedCommentCategoryCode,
			CC.SortColumn,
			CC.DivisionCode,
			CC.RecordStatusCode,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CC.LastUpdateDate) as LastUpdateDate,
			CC.LastUpdateUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CCC.LastUpdateDate) as CreationDate,
			CCC.LastUpdateUser as CreationUser,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ICC.LastUpdateDate) as InactivationDate,
			ICC.LastUpdateUser as InactivationUser,
			CC.RowVersion
	FROM
			CannedComment CC
	JOIN
			SynMirror_V_CannedComment CCC ON CCC.CannedCommentGuid = CC.CannedCommentGuid AND CCC.MirrorId = (SELECT TOP 1 MirrorId FROM SynMirror_V_CannedComment WHERE CannedCommentGuid = CC.CannedCommentGuid AND RecordStatusCode = ''A'' ORDER BY MirrorDate)
	LEFT JOIN
			SynMirror_V_CannedComment ICC ON ICC.CannedCommentGuid = CC.CannedCommentGuid AND ICC.MirrorId = (SELECT TOP 1 MirrorId FROM SynMirror_V_CannedComment WHERE CannedCommentGuid = CC.CannedCommentGuid AND RecordStatusCode = ''X'' ORDER BY MirrorDate DESC)			
	WHERE
			CC.DivisionCode = @divisioncode
	ORDER BY
			CC.CannedCommentCategoryCode ASC,CC.SortColumn ASC
END

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCannedComments] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleCryoUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects CRYO  blood units that are compatible for a given patients abo rh
**		This implements TT 3.03 
**		SAMPLE USAGE: EXEC spGetCompatibleCryoUnitsORIG ''A'',''589''
**
**	Author: 	Carl Jensen
**	Date: 	9/3/2004
**          
**	
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		------------------
**	09/16/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/23/2004	Lohse		Changed DiscardDetailCode to DiscardCannedCommentGuid
**	02/02/2005	C. Jensen	Adder RTRIM to BloodTypeCode and changed IF statements to match TT_3.03B
**	03/15/2005	Lohse		Adding BiohazardousWarningIndicator for - SelectUnits
**	05/26/2005	Lohse		PooledUnitsCount is now a function
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	06/24/2005	Npaterson	Modified to use table variables instead of dynamic sql
**	07/07/2005	C. Jensen	Deleted ABO type comparisons
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
					Put input parameters in brackets NOTE ComponentClassID is hard coded, consider subquery instead
**	03/23/2006	C. Jensen	Removed extra spaces between the single quotes in the RTRIM(BloodTypeCode) + '' ''.
**	04/04/2006	Lohse		Adding DateTimeConversion to ShipmentDate, changed UnitStatus IN check to use ORs
**  05/18/2012  Lohse		**SQL 2008 Upgrade**Ln133 - Replaced ORDER BY  BloodTypeCode ASC,  UnitExpirationDate ASC with ORDER BY  AboRh ASC,  UnitExpirationDate ASC
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/


CREATE PROCEDURE [dbo].[spGetCompatibleCryoUnits]
(
		@bloodtypecode 	CHAR(2),
		@divisioncode	VARCHAR(50)
)
			
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	BEGIN

		SELECT 

			BloodUnitGUID, 
			EyeReadableUnitID,
			DirectedPatientGuid,  
			UnitProductCode,  
			RhFactorCode, 

			 dbo.fnTimeZoneConversionDateTime(@divisioncode , 0, UnitExpirationDate) 					AS UnitExpirationDate, 

			 DonationTypeID, 
			 DonationTypeCode,
			 ComponentClassID,

			 dbo.fnTimeZoneConversionDateTime(@divisioncode , 0, UnitInDate)						 AS UnitInDate, 

			 DivisionCode, 
			 BloodTypeCode, 
			 UnitFdaRegistrationNumber,
			 LabelUnitID, 
			 ProductTypeCode, 
			 ProductName, 
			 ProductShortName,
			 DonationTypeText, 
			 ProductTypeName, 
			 RhFactorText, 
			 FacilityName, 
			 BloodProductGUID,
			 LabelTypeCode,
			 PatientFirstName, 
			PatientMiddleName, 
			PatientLastName, 
			 MaximumStorageTime,	
			VistaPatientID, 
			PatientSSN, 
			DisplayVistaPatientId, 
			 UnitStatusComments, 
			DiscardCannedCommentGuid, 
			UnitStatusCode,
			 UnitStatusText, 
			QuarantineIndicator, 
			TestingStatusId, 
			OriginalVolume, 
			UnitContainerLotNumber,
			BiohazardousWarningIndicator,
			BloodTypeCode, RhFactorCode,
			RTRIM(BloodTypeCode) + '' '' + RhFactorText  									AS AboRh,
			[RowVersion], 
			Comments,
			UnitDivisionId,

			dbo.fnGetPooledUnitsCount(BloodUnitGuid) 									AS PooledUnitsCount,

			 dbo.fnTimeZoneConversionDateTime(@divisioncode , 0, ShipmentDate) AS ShipmentDate,
			PresumedTransfusedIndicator,

			CASE LabelTypeCode

				WHEN ''I'' THEN 

					UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

				ELSE 

					UnitProductCode

			END 														AS FullProductCode 

			FROM dbo.vw_BloodShipPatientAllCurrent


			WHERE 

				DivisionCode =   @divisioncode 
	
				AND QuarantineIndicator = 0
	
				AND UnitExpirationDate >  GETUTCDATE() 
	
				/*Fresh Frozen plasma */
				AND (ComponentClassID = 3
	
				AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')
			
			) ORDER BY AboRh ASC,  UnitExpirationDate ASC
	END

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCompatibleCryoUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleFFPUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc: 	Selects FFP  blood units that are compatible for a given patients abo rh
**		This implements TT 3.03 
**
**	Author: 	Carl Jensen
**	Date: 	9/3/2004
**          
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		------------------
**	09/16/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	02/02/2005	C. Jensen	Adder RTRIM to BloodTypeCode
**	03/15/2005	Lohse		Adding BiohazardousWarningIndicator for SelectUnits
**	05/26/2005	Lohse		PooledUnitsCount is now a function
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	06/23/2005	Npaterson	Removed Dynamic SQL and EXEC, replaced with Table Variable for faster performance
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
					Placed input parameters in brackets - NOTE ComponentClassID is hard coded consider subquery instead
**	03/23/2006	C. Jensen	Removed extra spaces between the single quotes in the RTRIM(BloodTypeCode) + '' ''.
**	04/04/2006	Lohse		Adding DateTimeConversion to ShipmentDate, changed UnitStatus IN check to use ORs
**  05/18/2012  Lohse		**SQL 2008 Upgrade**Ln177 - Replaced ORDER BY  BloodTypeCode ASC,  UnitExpirationDate ASC with ORDER BY  AboRh ASC,  UnitExpirationDate ASC
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCompatibleFFPUnits]
(
		@bloodtypecode 	CHAR(2),
		@divisioncode	VARCHAR(50)	
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

/* SETUP THE TABLE VARIABLE WHICH IS ALIVE AS LONG AS THE QUERY IS RUNNING THEN IS AUTO DISPOSED */
	DECLARE @TTABOCode     table    (
						bcode VARCHAR(5)
					 )
	/* default - This is what is allowed by emergency issue*/
	BEGIN
		INSERT INTO  @TTABOCode  (bcode) VALUES (''AB'')
	END
	/* ''O'' */
	IF @bloodtypecode = ''O''
		BEGIN
			/*REMOVE THE DEFAULT VALUE WE INSERTED PREVIOUSLY*/
			DELETE @TTABOCode
			INSERT INTO  @TTABOCode  (bcode) VALUES (''O'')
			INSERT INTO  @TTABOCode  (bcode) VALUES (''A'')
			INSERT INTO  @TTABOCode  (bcode) VALUES (''AB'')
			INSERT INTO  @TTABOCode  (bcode) VALUES (''B'')
		END
	/* ''A'' */
	IF @bloodtypecode = ''A'' 
		BEGIN
			DELETE @TTABOCode
			INSERT INTO  @TTABOCode  (bcode) VALUES (''A'')
			INSERT INTO  @TTABOCode  (bcode) VALUES (''AB'')
		END
	/* ''B''*/
	IF @bloodtypecode = ''B''
		BEGIN
			DELETE @TTABOCode
			INSERT INTO  @TTABOCode  (bcode) VALUES (''B'')
			INSERT INTO  @TTABOCode  (bcode) VALUES (''AB'')
		END
	/* ''AB'' */
	IF @bloodtypecode = ''AB''
		BEGIN
			DELETE @TTABOCode
			INSERT INTO  @TTABOCode  (bcode) VALUES (''AB'')
		END
	/* ''I*/
	IF @bloodtypecode = ''I''
		BEGIN
			DELETE @TTABOCode
			INSERT INTO  @TTABOCode  (bcode) VALUES (''AB'')
		END

		SELECT 

			BloodUnitGUID, 
			EyeReadableUnitID,
			DirectedPatientGuid,  
			UnitProductCode,  
			RhFactorCode, 

			 dbo.fnTimeZoneConversionDateTime(@divisioncode , 0, UnitExpirationDate) AS UnitExpirationDate, 

			 DonationTypeID, 
			 DonationTypeCode,
			 ComponentClassID,

			 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, UnitInDate) 	AS UnitInDate, 

			 DivisionCode, 
			 BloodTypeCode, 
			 UnitFdaRegistrationNumber,
			 LabelUnitID, 
			 ProductTypeCode, 
			 ProductName, 
			 ProductShortName,
			 DonationTypeText, 
			 ProductTypeName, 
			 RhFactorText, 
			 FacilityName, 
			 BloodProductGUID,
			 LabelTypeCode,
			 PatientFirstName, 
			PatientMiddleName, 
			PatientLastName, 
			 MaximumStorageTime,	
			VistaPatientID, 
			PatientSSN, 
			DisplayVistaPatientId, 
			 UnitStatusComments, 
			DiscardCannedCommentGuid, 
			UnitStatusCode,
			 UnitStatusText, 
			QuarantineIndicator, 
			TestingStatusId, 
			OriginalVolume, 
			UnitContainerLotNumber,
			BiohazardousWarningIndicator,
			BloodTypeCode, RhFactorCode,
			RTRIM(BloodTypeCode) + '' '' + RhFactorText  				AS AboRh,
			[RowVersion], Comments,
			UnitDivisionId,

			dbo.fnGetPooledUnitsCount(BloodUnitGuid) 				AS PooledUnitsCount,

			 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
			PresumedTransfusedIndicator,

			CASE LabelTypeCode

				WHEN ''I'' THEN 

					UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
				ELSE 

					UnitProductCode

			END 									AS FullProductCode 

		FROM dbo.vw_BloodShipPatientAllCurrent

/* FILTER THE RESULTS BASED ON THE VALUES STORED IN OUR TABLE VARIABLE: */

		WHERE  BloodTypeCode  IN ( 

							SELECT bcode FROM @TTABOCode
			       		       )

			AND DivisionCode =  @divisioncode 

			AND QuarantineIndicator = 0

			AND UnitExpirationDate >  GETUTCDATE() 

			/*Fresh Frozen plasma */
			AND (ComponentClassID = 2

			AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')
			
			) 

		ORDER BY  AboRh ASC,  UnitExpirationDate ASC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCompatibleFFPUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleNonWholeBloodNonPlasmaUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects "Non-Whole Blood", "Non-Plasma"  blood units with that are compatible for a given patients abo rh
**		This implements TT 3.02 
**		SAMPLE USAGE: EXEC spGetCompatibleNonWholeBloodNonPlasmaUnits ''p'',''MX'',''589''
**
**	Author: 	Carrie Van Stedum
**	Date: 	6/26/2003
**          
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	7/22/2003	C. Jensen	Added UnitContainerLotNumber,
**	8/5/2003	C. Jensen	Removed quotes and +''s from GETUTCDATE()
**	11/3/2003	C. Jensen	Added BloodProductGUID, LabelTypeCode to SELECT
**	1/9/2004	C. Jensen	Changed PatientMiddleInitial to PatientMiddleName in 2nd part of query
**	1/26/2004	C. Jensen	Deleted reference to function fnRhFactorAbbrevFromCode in favor or JOIN
**	02/10/2004	Greg Lohse	Adding UnitDivisionId - for ISBT alloQUAT unit searching.  This sproc is WHACK!.  Also added FullProductCode
**	04/21/2004	M. Jablonski	I will add to this mess too! Call fnTimeZoneConversionDateTime function on all dates;
**	06/17/2004	C. Jensen	Added PooledUnitsCount
**	06/17/2004	C. Jensen	Added fix for emergency issue situations
**	09/16/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	02/02/2005	C. Jensen	Added RTRIM to BloodTypeCode
**	03/07/2005	C. Jensen	Added RhFactorText
**	03/15/2005	Lohse		Adding BiohazardousWarningIndicator for SelectUnits
**	03/28/2005	C. Jensen	Adding BiohazardousWarningIndicator to second query to fix bug (LOHSE!)
**	05/26/2005	Lohse		PooledUnitsCount is now a function..  BUG, SHMUG!
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	06/23/2005	Npaterson	Modified to use inline dynamic Order By clause and WHERE clause  rather than an entire dynamic SQL with EXEC
**					The first (IF..INSERT) blocks should be further improved by using CASE Statements
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header,  formatted SQL, specified object owners
					Condensed the IF..INSERT statements by grouping common scenarios, added/revised comments to guide coders
**	04/04/2006	Lohse		Adding DateTimeConversion to ShipmentDate, changed UnitStatus IN check to use ORs
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCompatibleNonWholeBloodNonPlasmaUnits]
(
		@BloodTypeCode 	CHAR(2),
		@RhFactorCode	CHAR(1),
		@DivisionCode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

/* 			These table variables are  used in the Dynamic WHERE CLAUSE					 */

	DECLARE @TTRhFactorCode    table  (
						fcode VARCHAR(5)
					         )
/* 		TABLE VARIABLE IS ALIVE AS LONG AS THE QUERY IS RUNNING THEN IS AUTO DISPOSED 		*/
	DECLARE @TTABOCode     table    (
						position int IDENTITY PRIMARY KEY  CLUSTERED ,
						bcode VARCHAR(5)
					 )

	/* SET THE DEFAULT VALUE - This is what is allowed by emergency issue*/
	INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
		INSERT INTO @TTABOCode (bcode) VALUES (''O'')
/*******************************************************************************************************************************************************/
/*		POPULATE THE TABLE VARIABLES WITH DATA USED IN THE DYNAMIC WHERE CLAUSE		*/
/*******************************************************************************************************************************************************/
	/* ''O Positive'' OR  ABO INCONCLUSIVE RH Positive*/

	IF (@BloodTypeCode = ''O'' AND @RhFactorCode = ''P'' ) OR (@BloodTypeCode = ''I'' AND @RhFactorCode = ''P'')

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''P'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
	    END


	/* ''A Negative'' OR  A RH INCONCLUSIVE*/

	IF (@BloodTypeCode = ''A'' AND @RhFactorCode = ''N'' ) OR (@BloodTypeCode = ''A'' AND @RhFactorCode =  ''I'')

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
			INSERT INTO @TTABOCode (bcode) VALUES (''A'')
	    END

	/* ''A Positive'' */

	IF @BloodTypeCode = ''A'' AND @RhFactorCode = ''P'' 

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''P'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
			INSERT INTO @TTABOCode (bcode) VALUES (''A'')
	    END

	/* B Negative OR ''B RH INCONCLUSIVE*/

	IF (@BloodTypeCode = ''B'' AND @RhFactorCode = ''N'') OR (@BloodTypeCode = ''B'' AND @RhFactorCode = ''I'')

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
			INSERT INTO @TTABOCode (bcode) VALUES (''B'')
	    END

	/* ''B Positive */

	IF @BloodTypeCode = ''B'' AND @RhFactorCode = ''P'' 

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''P'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
			INSERT INTO @TTABOCode (bcode) VALUES (''B'')
	    END

	/* ''AB Negative */

	IF @BloodTypeCode = ''AB'' AND @RhFactorCode = ''N'' 

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
			INSERT INTO @TTABOCode (bcode) VALUES (''B'')
			INSERT INTO @TTABOCode (bcode) VALUES (''AB'')
			INSERT INTO @TTABOCode (bcode) VALUES (''A'')
	    END

	/* ''AB Positive THEN SET THE RHfactor code N or P*/

	IF @BloodTypeCode = ''AB'' AND @RhFactorCode = ''P'' 

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''P'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
			INSERT INTO @TTABOCode (bcode) VALUES (''B'')
			INSERT INTO @TTABOCode (bcode) VALUES (''AB'')
			INSERT INTO @TTABOCode (bcode) VALUES (''A'')
	   END

	/* ''AB RH INCONCLUSIVE*/

	IF @BloodTypeCode = ''AB'' AND @RhFactorCode =  ''I'' 

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''AB'')
			INSERT INTO @TTABOCode (bcode) VALUES (''A'')
			INSERT INTO @TTABOCode (bcode) VALUES (''B'')
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
	    END

	/* [O RH INCONCLUSIVE]  OR  [ABO AND RH INCONCLUSIVE]  OR  [ABO AND RH INCONCLUSIVE]  OR [O NEGATIVE] */

	IF (@BloodTypeCode = ''O'' AND @RhFactorCode =  ''I'' ) OR (@BloodTypeCode = ''I'' AND @RhFactorCode =  ''I'')

		OR (@BloodTypeCode = ''I'' AND @RhFactorCode =  ''N'') OR (@BloodTypeCode = ''O'' AND @RhFactorCode = ''N'')

	    BEGIN
			DELETE  @TTRhFactorCode 
			INSERT INTO @TTRhFactorCode (fcode) VALUES (''N'')
			DELETE @TTABOCode
			INSERT INTO @TTABOCode (bcode) VALUES (''O'')
	    END

/*************************************************  END POPULATING TABLE VARIABLES   **********************************************************/


	    BEGIN
			SELECT 

			 BloodUnitGUID, 
			 EyeReadableUnitID,
			 DirectedPatientGuid, 
			 UnitProductCode, 
			 BU.RhFactorCode, 

			 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, UnitExpirationDate) AS  UnitExpirationDate, 

			 DonationTypeID, 
			 DonationTypeCode,
			 ComponentClassID,

			 dbo.fnTimeZoneConversionDateTime(@divisioncode , 0, UnitInDate) AS  UnitInDate, 

			 DivisionCode, 
			 BloodTypeCode, 
			 UnitFdaRegistrationNumber,
			 LabelUnitID, 
			 ProductTypeCode, 
			 Rh.RhFactorText,
			 ProductName, 
			 ProductShortName,
			 DonationTypeText, 
			 ProductTypeName, 
			 RTRIM(BloodTypeCode) + '' '' + Rh.RhFactorText AS AboRh, 
			 FacilityName, 
			 BloodProductGUID,
			 LabelTypeCode, 
			 PatientFirstName, PatientMiddleName, PatientLastName,  
			 MaximumStorageTime, VistaPatientID,PatientSSN,
			 UnitStatusComments,
			DiscardCannedCommentGuid,
			UnitStatusCode,
			 UnitStatusText, QuarantineIndicator,
			BiohazardousWarningIndicator,
			TestingStatusId,
			OriginalVolume,
			UnitContainerLotNumber,
			BU.[RowVersion], 
			Comments,
			UnitDivisionId,
			dbo.fnGetPooledUnitsCount(BloodUnitGuid) AS PooledUnitsCount,
			 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
			PresumedTransfusedIndicator,

			CASE LabelTypeCode

				WHEN ''I'' THEN 

					UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

				ELSE 

					UnitProductCode

			END AS FullProductCode 

			FROM dbo.vw_BloodShipPatientAllCurrent BU

			INNER JOIN

                      		dbo.RhFactor RH ON BU.RhFactorCode = RH.RhFactorCode

			WHERE ComponentClassID = ''1''

			AND UnitExpirationDate >  GETUTCDATE() 

			AND QuarantineIndicator = 0

			AND DivisionCode = @DivisionCode
			
			AND (BloodTypeCode IN (

						SELECT bcode FROM @TTABOCode )

						)
			
	
			AND (BU.RhFactorCode IN (

						SELECT fcode FROM  @TTRhFactorCode)

						     ) 

			AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')
			
/* ====================================================================================================================
Dynamic Order By clause - if RhFactorCode = P then it will sort on that column DESCENDING and BloodtypeCode & UnitExpirationDate ASCENDING
	, otherwise will sort Ascending ON RhFactorCode,BloodTypeCode,UnitExpirationDate
=====================================================================================================================*/
	
	ORDER BY 

		CASE  WHEN @RhFactorCode = ''P'' THEN 

			BU.RhFactorCode  

		ELSE

			NULL

		END DESC,

		CASE WHEN @RHFactorCode != ''P'' THEN

			 BU.RhFactorCode + '','' + BloodTypeCode + '','' +  CAST(UnitExpirationDate AS VARCHAR)

		ELSE

			BloodTypeCode + '','' + CAST(UnitExpirationDate AS VARCHAR)

		END ASC
END

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCompatibleNonWholeBloodNonPlasmaUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleOtherBloodUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects "Other" blood units that are compatible for a given patients abo rh
**		This implements TTs 3.04 and 3.06
**
**	Author: 	Carl Jensen
**	Date: 	9/3/2004
**          
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		----------		-------------------
**	09/16/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	02/02/2005	C. Jensen	Adder RTRIM to BloodTypeCode
**	03/15/2005	Lohse		Adding BiohazardousWarningIndicator for SelectUnits
**	05/29/2005	Lohse		PooledUnitsCount is now a function.
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	04/04/2006	Lohse		Adding DateTimeConversion to ShipmentDate, changed UnitStatus IN check to use ORs
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCompatibleOtherBloodUnits]
(
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0
		
SET NOCOUNT ON

	SELECT

		BloodUnitGUID, 
		EyeReadableUnitID,
		DirectedPatientGuid, 
		UnitProductCode, 
		RhFactorCode, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 			AS UnitExpirationDate, 

		DonationTypeID, 
		DonationTypeCode,
		ComponentClassID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 				AS UnitInDate, 

		DivisionCode, 
		BloodTypeCode, 
		UnitFdaRegistrationNumber,
		LabelUnitID, 
		ProductTypeCode, 
		ProductName, 
		ProductShortName,
		DonationTypeText, 
		ProductTypeName, 
		RhFactorText, 
		FacilityName, 
		BloodProductGUID,
		LabelTypeCode,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName, 
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitContainerLotNumber,
		UnitStatusText,
		QuarantineIndicator,
		BiohazardousWarningIndicator,
		TestingStatusId,
		OriginalVolume,
		[RowVersion],
		Comments,
		RTRIM(BloodTypeCode) + '' '' + RhFactorText  							AS AboRh,
		UnitDivisionId,

		dbo.fnGetPooledUnitsCount(BloodUnitGuid) 							AS PooledUnitsCount,

		 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
		PresumedTransfusedIndicator,

		CASE LabelTypeCode

			WHEN ''I'' THEN 

				UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

			ELSE 

				UnitProductCode

		END 												AS FullProductCode 

	FROM

		dbo.vw_BloodShipPatientAllCurrent
		
	WHERE

		DivisionCode = @divisioncode

	AND	ComponentClassID = 5

	AND	QuarantineIndicator = 0

	AND	UnitExpirationDate > GETUTCDATE()

	AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')
			

	ORDER BY

		RhFactorCode ASC, BloodTypeCode DESC,  UnitExpirationDate ASC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCompatibleOtherBloodUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatiblePlateletBloodUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects "Platelet" blood units that are compatible for a given patients abo rh
**		This implements TTs 3.04 and 3.06
**
**	Author: 	Carl Jensen
**	Date: 	9/3/2004
**          
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		----------		-------------------
**	09/16/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	03/15/2005	Lohse		Adding BiohazardousWarningIndicator for SelectUnits
**	05/26/2005	Lohse		PooledUnitsCount is now a function
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**	04/04/2006	Lohse		Adding DateTimeConversion to ShipmentDate, changed UnitStatus IN check to use ORs
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCompatiblePlateletBloodUnits]
(
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0
		
SET NOCOUNT ON

	SELECT

		BloodUnitGUID, 
		EyeReadableUnitID,
		DirectedPatientGuid, 
		UnitProductCode, 
		RhFactorCode, 

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 				AS UnitExpirationDate, 

		DonationTypeID, 
		DonationTypeCode,
		ComponentClassID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 					AS UnitInDate, 

		DivisionCode, 
		BloodTypeCode, 
		UnitFdaRegistrationNumber,
		LabelUnitID, 
		ProductTypeCode, 
		ProductName, 
		ProductShortName,
		DonationTypeText, 
		ProductTypeName, 
		RhFactorText, 
		FacilityName, 
		BloodProductGUID,
		LabelTypeCode,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName, 
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitContainerLotNumber,
		UnitStatusText,
		QuarantineIndicator,
		BiohazardousWarningIndicator,
		TestingStatusId,
		OriginalVolume,
		[RowVersion],
		Comments,
		RTRIM(BloodTypeCode) + '' '' + RhFactorText  								AS AboRh,
		UnitDivisionId,

		dbo.fnGetPooledUnitsCount(BloodUnitGuid) 								AS PooledUnitsCount,

		 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,

		PresumedTransfusedIndicator,

		CASE LabelTypeCode

			WHEN ''I'' THEN 

				UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

			ELSE 

				UnitProductCode

		END 													AS FullProductCode 

	FROM

		dbo.vw_BloodShipPatientAllCurrent
		
	WHERE

		DivisionCode = @divisioncode

	AND	ComponentClassID = 4

	AND	QuarantineIndicator = 0

	AND	UnitExpirationDate > GETUTCDATE()

	AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')
		
	ORDER BY

		RhFactorCode ASC, BloodTypeCode DESC,  UnitExpirationDate ASC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCompatiblePlateletBloodUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompatibleWholeBloodUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects "Whole Blood"  blood units that are compatible for a given patients abo rh
**		This implements TT 3.01 and BR 3.41
**
**	Author: 	Carrie Van Stedum
**	Date: 	6/26/2003
**          
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------	---------		------------------
**	7/22/2003	C. Jensen	Added UnitContainerLotNumber,
**	11/3/2003	C. Jensen	Added BloodProductGUID and LabelTypeCode to SELECT
**	02/10/2004	Greg Lohse	Adding UnitDivisionId for ISBT alloQUAT unit searching. Also adding FullProductCode
**	04/21/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/17/2004	C. Jensen	Added PooledUnitsCount for BTRF
**	09/16/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/31/2005	C. Jensen	Added default select statement so something is returned when the patient has no ABO/Rh
**	03/15/2005	Lohse		Adding BiohazardousWarningIndicator for SelectUnits
**	05/10/2005	C. Jensen	Adding BiohazardousWarningIndicator for for ALL queries (Lohse!!!)
**	05/26/2005	Lohse		PooledUnitsCount is now a function.  (What!!!? Its not my fault there''s 4 queries in here!)
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL,
					Placed brackets around input parameters NOTE: Queries are using hard coded values
**	04/04/2006	Lohse		Adding DateTimeConversion to ShipmentDate, changed UnitStatus IN check to use ORs
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCompatibleWholeBloodUnits]
(
		@bloodtypecode 	CHAR(2),
		@rhfactorcode		CHAR(1),
		@patientguid 		UNIQUEIDENTIFIER,
		@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	DECLARE @TTRhFactorCode    VARCHAR(15)
	DECLARE @TTRhFactorCode2  VARCHAR(15)

	
		/* ''O NEGATIVE'' THEN SET THE RHfactor code N*/
		
		IF @bloodtypecode = ''O'' AND @rhfactorcode = ''N''
			BEGIN
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''N''	
			END
		/* ''O Positive'' THEN SET THE RHfactor code N or P*/
		IF @bloodtypecode  = ''O'' AND  @rhfactorcode =  ''P'' 
			BEGIN
				--SET @TTRhFactorCode = ''P  OR RhFactorCode = N''
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''P''
			END
		/* ''A Negative'' THEN SET THE RHfactor code N*/
		IF @bloodtypecode = ''A '' AND @rhfactorcode =  ''N''
			BEGIN
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''N''	
			END
		/* ''A Positive'' THEN SET THE RHfactor code N or P*/
		IF @bloodtypecode = ''A '' AND @rhfactorcode =  ''P'' 
			BEGIN
				--SET @TTRhFactorCode =  ''P  OR RhFactorCode = N''
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''P''
			END
		/* ''B Negative THEN SET THE RHfactor code N*/
		IF @bloodtypecode = ''B'' AND @rhfactorcode =  ''N'' 
			BEGIN
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''N''	
			END
		/* ''B Positive THEN SET THE RHfactor code N or P*/
		IF @bloodtypecode = ''B'' AND @rhfactorcode =  ''P'' 
			BEGIN
				--SET @TTRhFactorCode =  ''P OR RhFactorCode =  N''
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''P''	
			END
		/* ''AB Negative THEN SET THE RHfactor code N*/
		IF @bloodtypecode = ''AB'' AND @rhfactorcode =  ''N'' 
			BEGIN
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''N''
			END
		/* ''AB Positive THEN SET THE RHfactor code N or P*/
		IF @bloodtypecode = ''AB'' AND @rhfactorcode =  ''P'' 
		    	BEGIN
				--SET @TTRhFactorCode = ''P  OR RhFactorCode =  N''
				SET @TTRhFactorCode = ''N''
				SET @TTRhFactorCode2 = ''P''
				--print @bloodtypecode
				--print @TTRhFactorCode
				--print @TTRhFactorCode2
			 END	
		/*INCONCLUSIVE*/
		/* When the patient ABO is inconclusive, blood units from the "WHOLE BLOOD"*/
		/* ICCBA component class cannot be selected unless the unit donation type is "AUTOLOGOUS"*/
		/*and the units are restricted to the patient*/

		IF (@bloodtypecode = ''I'' AND @rhfactorcode = ''N'')

			BEGIN

				SET @TTRhFactorCode = ''false''

				SELECT 

					BloodUnitGUID, 
					 EyeReadableUnitID,
					 DirectedPatientGUID, 
					 UnitProductCode, 
					 RhFactorCode, 

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 			AS UnitExpirationDate, 

					 DonationTypeID,
					 DonationTypeCode,
					 ComponentClassID,

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 				AS UnitInDate, 

					 DivisionCode, 
					 BloodTypeCode, 
					 UnitFdaRegistrationNumber,
					 LabelUnitID, 
					 ProductTypeCode, 
					 ProductName, 
					 ProductShortName,
					 DonationTypeText, 
					 ProductTypeName, 
					 RhFactorText, 
					 FacilityName, 
					 BloodProductGUID,
			 		 LabelTypeCode,
					 PatientFirstName, 
					PatientMiddleName, 
					PatientLastName, 
					 MaximumStorageTime,	
					VistaPatientID, 
					PatientSSN,
					 UnitStatusComments, 
					DiscardCannedCommentGuid, 
					UnitStatusCode,
					 UnitStatusText, 
					QuarantineIndicator, 
					OriginalVolume, 
					UnitContainerLotNumber, 
					IncomingShipmentGUID,
					BiohazardousWarningIndicator,

					dbo.fnGetPooledUnitsCount(BloodUnitGuid) 							AS PooledUnitsCount,

					[RowVersion], Comments,
					RTRIM(BloodTypeCode) + '' '' + RhFactorText 							AS AboRh,
					TestingStatusId,
					UnitDivisionId,
					 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
					PresumedTransfusedIndicator,

					CASE LabelTypeCode

						WHEN ''I'' THEN 

							UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

						ELSE 

							UnitProductCode

					END 												AS FullProductCode 

	 	 		FROM dbo.vw_BloodShipPatientAllCurrent 
	

				WHERE  (DonationTypeID= 9 OR DonationTypeID = 10 OR DonationTypeID = 11)
	
				AND DirectedPatientGUID = @patientguid

				AND DivisionCode = @divisioncode
				
				AND QuarantineIndicator = 0

				AND ComponentClassID = 6

				AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')
			
				--part of BR_3.19
				AND UnitExpirationDate > GETUTCDATE()

				ORDER BY 

					RhFactorCode ASC,  
					BloodTypeCode ASC, 
					UnitExpirationDate ASC
	
			END

		ELSE IF  (@bloodtypecode = ''I'' AND @rhfactorcode = ''P'')

			BEGIN

				SET @TTRhFactorCode = ''false''

				SELECT 

					BloodUnitGUID, 
					 EyeReadableUnitID,
					 DirectedPatientGuid, 
					 UnitProductCode, 
					 RhFactorCode, 

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 			AS UnitExpirationDate, 

					 DonationTypeID,
					 DonationTypeCode,
					 ComponentClassID,

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate)				 AS UnitInDate, 

					 DivisionCode, 
					 BloodTypeCode, 
					 UnitFdaRegistrationNumber,
					 LabelUnitID, 
					 ProductTypeCode, 
					 ProductName, 
					 ProductShortName,
					 DonationTypeText, 
					 ProductTypeName, 
					 RhFactorText, 
					 FacilityName, 
					 BloodProductGUID,
			 		LabelTypeCode,
					 PatientFirstName, 
					PatientMiddleName, 
					PatientLastName, 
					 MaximumStorageTime,	
					VistaPatientID, 
					PatientSSN,
					 UnitStatusComments, 
					DiscardCannedCommentGuid, 
					UnitStatusCode,
					 UnitStatusText, 
					QuarantineIndicator, 
					TestingStatusId, 
					OriginalVolume, 
					UnitContainerLotNumber, 
					IncomingShipmentGUID,
					BiohazardousWarningIndicator,

					dbo.fnGetPooledUnitsCount(BloodUnitGuid) AS PooledUnitsCount,

					[RowVersion], Comments,
					RTRIM(BloodTypeCode) + '' '' + RhFactorText							 AS AboRh,
					UnitDivisionId,
					 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
					PresumedTransfusedIndicator,

					CASE LabelTypeCode

						WHEN ''I'' THEN 

							UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

						ELSE 

							UnitProductCode

					END 												AS FullProductCode 

	 	 		FROM dbo.vw_BloodShipPatientAllCurrent 
	
				WHERE (DonationTypeID= 9 OR DonationTypeID = 10 OR DonationTypeID = 11)
	
				AND DirectedPatientGUID = @patientguid
				
				AND QuarantineIndicator = 0

				AND DivisionCode = @divisioncode
				--part of BR_3.19
				AND UnitExpirationDate > GETUTCDATE()
				
				AND ComponentClassID = 6

				AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')
			
				ORDER BY 

					RhFactorCode DESC,  
					BloodTypeCode ASC, 
					UnitExpirationDate ASC
	
			END

		IF (@TTRhFactorCode != ''false'' AND @rhfactorcode = ''N'')

			BEGIN
				--print '' in select''
				SELECT 

					BloodUnitGUID, 
					 EyeReadableUnitID,
					 DirectedPatientGuid, 
					 UnitProductCode, 
					 RhFactorCode, 

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 		AS UnitExpirationDate, 

					 DonationTypeID, 
					 DonationTypeCode,
					 ComponentClassID,

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 			AS UnitInDate, 

					 DivisionCode, 
					 BloodTypeCode, 
					 UnitFdaRegistrationNumber,
					 LabelUnitID, 
					 ProductTypeCode, 
					 ProductName, 
					 ProductShortName,
					 DonationTypeText, 
					 ProductTypeName, 
					 RhFactorText, 
					 FacilityName, 
					 BloodProductGUID,
			 		LabelTypeCode,
					 PatientFirstName, 
					PatientMiddleName, 
					PatientLastName, 
					 MaximumStorageTime,	
					VistaPatientID, 
					PatientSSN,
					 UnitStatusComments, 
					DiscardCannedCommentGuid, 
					UnitStatusCode, 
					UnitContainerLotNumber, 
					IncomingShipmentGUID,
					BiohazardousWarningIndicator,
					UnitStatusText, 
					QuarantineIndicator, 
					TestingStatusId, 
					OriginalVolume,

					dbo.fnGetPooledUnitsCount(BloodUnitGuid) 					AS PooledUnitsCount,

					[RowVersion], Comments,
					RTRIM(BloodTypeCode) + '' '' + RhFactorText 					AS AboRh,
					UnitDivisionId,
					 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
					PresumedTransfusedIndicator,

					CASE LabelTypeCode

						WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

						ELSE UnitProductCode

					END 										AS FullProductCode 
					
		 	 	FROM dbo.vw_BloodShipPatientAllCurrent 
		
				--IN ALL CASES EXCEPT FOR INCONCLUSIVE THE TT STATES THAT THE ABO MATCHES THE PATIENT ABO SO THIS 
				--DOES NOT NEED TO BE IN THE SELECT STATEMENT
				WHERE BloodTypeCode = @bloodtypecode

				AND DivisionCode = @divisioncode

				AND QuarantineIndicator = 0

				AND (RhFactorCode = @TTRhFactorCode OR RhFactorCode = @TTRhFactorCode2)

				AND ComponentClassID = 6
				--part of BR_3.19
				AND UnitExpirationDate > GETUTCDATE()

				AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')

				ORDER BY 

					RhFactorCode ASC, 
					BloodTypeCode ASC,  
					UnitExpirationDate ASC

			END

		ELSE  IF (@TTRhFactorCode != ''false'' AND @rhfactorcode = ''P'')

			BEGIN
				--print '' in select''
				SELECT 

					BloodUnitGUID, 
					 EyeReadableUnitID,
					 DirectedPatientGuid, 
					 UnitProductCode, 
					 RhFactorCode, 

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 	AS UnitExpirationDate, 

					 DonationTypeID, 
					 DonationTypeCode,
					 ComponentClassID,

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 		AS UnitInDate, 

					 DivisionCode, 
					 BloodTypeCode, 
					 UnitFdaRegistrationNumber,
					 LabelUnitID, 
					 ProductTypeCode, 
					 ProductName, 
					 ProductShortName,
					 DonationTypeText, 
					 ProductTypeName, 
					 RhFactorText, 
					 FacilityName, 
					 BloodProductGUID,
			 		 LabelTypeCode,
					 PatientFirstName, 
					PatientMiddleName, 
					PatientLastName, 
					 MaximumStorageTime,	
					VistaPatientID, 
					PatientSSN,
					 UnitStatusComments, 
					DiscardCannedCommentGuid, 
					UnitStatusCode, 
					UnitContainerLotNumber, 
					IncomingShipmentGUID,
					 UnitStatusText, 
					QuarantineIndicator, 
					TestingStatusId, 
					OriginalVolume,
					BiohazardousWarningIndicator,

					dbo.fnGetPooledUnitsCount(BloodUnitGuid) 					AS PooledUnitsCount,

					[RowVersion], Comments,
					RTRIM(BloodTypeCode) + '' '' + RhFactorText 					AS AboRh,
					UnitDivisionId,
					 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
					PresumedTransfusedIndicator,

					CASE LabelTypeCode

						WHEN ''I'' THEN 

							UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

						ELSE 

							UnitProductCode

					END 										AS FullProductCode 
					
		 	 	FROM dbo.vw_BloodShipPatientAllCurrent 
		
				--IN ALL CASES EXCEPT FOR INCONCLUSIVE THE TT STATES THAT THE ABO MATCHES THE PATIENT ABO SO THIS 
				--DOES NOT NEED TO BE IN THE SELECT STATEMENT
				WHERE BloodTypeCode = @bloodtypecode

				AND DivisionCode = @divisioncode

				AND QuarantineIndicator = 0

				AND (RhFactorCode = @TTRhFactorCode OR RhFactorCode = @TTRhFactorCode2)

				--part of BR_3.19
				AND UnitExpirationDate > GETUTCDATE()

				AND ComponentClassID = 6

				AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')

				ORDER BY 

					RhFactorCode DESC,  
					BloodTypeCode ASC, 
					UnitExpirationDate ASC

			END
			-- This is the default statement and would only be called if the patient didn''t have an ABO/Rh on file.  I had to put this statement in here to bring back an empty table.

		ELSE

			BEGIN
				--print '' in select''
				SELECT 

					BloodUnitGUID, 
					 EyeReadableUnitID,
					 DirectedPatientGuid, 
					 UnitProductCode, 
					 RhFactorCode, 

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 	AS UnitExpirationDate, 

					 DonationTypeID, 
					 DonationTypeCode,
					 ComponentClassID,

					 dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) 		AS UnitInDate, 

					 DivisionCode, 
					 BloodTypeCode, 
					 UnitFdaRegistrationNumber,
					 LabelUnitID, 
					 ProductTypeCode, 
					 ProductName, 
					 ProductShortName,
					 DonationTypeText, 
					 ProductTypeName, 
					 RhFactorText, 
					 FacilityName, 
					 BloodProductGUID,
			 		 LabelTypeCode,
					 PatientFirstName, 
					PatientMiddleName, 
					PatientLastName, 
					 MaximumStorageTime,	
					VistaPatientID, 
					PatientSSN,
					 UnitStatusComments, 
					DiscardCannedCommentGuid, 
					UnitStatusCode, 
					UnitContainerLotNumber, 
					IncomingShipmentGUID, 
					BiohazardousWarningIndicator,
					 UnitStatusText, 
					QuarantineIndicator, 
					TestingStatusId, 
					OriginalVolume,

					dbo.fnGetPooledUnitsCount(BloodUnitGuid) 				AS PooledUnitsCount,

					[RowVersion], Comments,
					RTRIM(BloodTypeCode) + '' '' + RhFactorText 				AS AboRh,
					UnitDivisionId,
					 dbo.fnTimeZoneConversionDateTime( @divisioncode , 0, ShipmentDate) 	AS ShipmentDate,
					PresumedTransfusedIndicator,

					CASE LabelTypeCode

						WHEN ''I'' THEN 

							UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

						ELSE 
	
							UnitProductCode

					END 									AS FullProductCode 
					
		 	 	FROM dbo.vw_BloodShipPatientAllCurrent 
		
				--IN ALL CASES EXCEPT FOR INCONCLUSIVE THE TT STATES THAT THE ABO MATCHES THE PATIENT ABO SO THIS 
				--DOES NOT NEED TO BE IN THE SELECT STATEMENT
				WHERE BloodTypeCode = @bloodtypecode

				AND DivisionCode = @divisioncode

				AND QuarantineIndicator = 0

				AND (RhFactorCode = @TTRhFactorCode OR RhFactorCode = @TTRhFactorCode2)

				--part of BR_3.19
				AND UnitExpirationDate > GETUTCDATE()

				AND ComponentClassID = 6

				AND (UnitStatusCode = ''A'' OR UnitStatusCode = ''C'' OR UnitStatusCode = ''S'')

				ORDER BY 

					RhFactorCode DESC,  
					BloodTypeCode ASC, 
					UnitExpirationDate ASC

			END


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCompatibleWholeBloodUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCompletedPatientTransfusionReactions]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Name: 	spGetCompletedPatientTransfusionReactions
**
**	Author: Cameron Taylor
**
**	Date: 	10/26/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date				Name			Description
**	-------------		--------		-----------------
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; capitalized SQL statements
**	09/09/2005	D. Askew	Changed JOIN on Patient to select either the FinalMergeToPatient if the patient has one or more
**					merges (choosing the final merge record) or simply the patient guid if there are none
**	01/18/2006	C. Taylor	Updated to get PreSpecimenGuid & PostSpecimenGuid from PatientTransfusionReaction (CR 1462)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCompletedPatientTransfusionReactions]
(
	@divisioncode	AS VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT DISTINCT
		PTR.PatientTransfusionReactionGuid,
		PTR.PatientGuid,
		P.DisplayVistaPatientId,
		P.PatientSsn,
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		PTR.TransfusionReactionTypeCode,
		TRT.TransfusionReactionTypeText,
		PTR.OrderedTestGuid,
		PTR.PreSpecimenNotAvailableIndicator,
		PTR.PreSpecimenGuid,
		PreS.SpecimenUid AS PreSpecimenUid,
		PTR.PostSpecimenNotAvailableIndicator,
		PTR.PostSpecimenGuid,
		PostS.SpecimenUid AS PostSpecimenUid,
		PTR.PartialSaveId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CPTR.LastUpdateDate) AS CompletedDateTime,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, FPTR.LastUpdateDate) AS FinalizedDateTime

	FROM
		dbo.PatientTransfusionReaction PTR

	JOIN 	dbo.Patient LinkPatient ON PTR.PatientGuid = LinkPatient.PatientGuid
	JOIN	dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

	LEFT JOIN dbo.TransfusionReactionType TRT ON
		TRT.TransfusionReactionTypeCode = PTR.TransfusionReactionTypeCode
		
	LEFT JOIN dbo.PatientSpecimen PreS ON
		PreS.PatientSpecimenGuid = PTR.PreSpecimenGuid
	
	LEFT JOIN dbo.PatientSpecimen PostS ON
		PostS.PatientSpecimenGuid = PTR.PostSpecimenGuid
		
	LEFT JOIN dbo.VbecsUser VU ON
		VU.VbecsUserId = PTR.EntryTechId
	
	LEFT JOIN dbo.SynMirror_V_PatientTransfusionReaction CPTR ON 
		CPTR.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid AND CPTR.MirrorId = (SELECT Max(MirrorId) FROM SynMirror_V_PatientTransfusionReaction WHERE SynMirror_V_PatientTransfusionReaction.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid AND SynMirror_V_PatientTransfusionReaction.RecordStatusCode = ''A'' AND SynMirror_V_PatientTransfusionReaction.PartialSaveId = 4)

	LEFT JOIN dbo.SynMirror_V_PatientTransfusionReaction FPTR ON 
		FPTR.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid AND FPTR.MirrorId = (SELECT Max(MirrorId) FROM SynMirror_V_PatientTransfusionReaction WHERE SynMirror_V_PatientTransfusionReaction.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid AND SynMirror_V_PatientTransfusionReaction.RecordStatusCode = ''A'' AND SynMirror_V_PatientTransfusionReaction.PartialSaveId = 5)

	WHERE
		PTR.DivisionCode = @divisioncode
	AND
		PTR.PartialSaveId > 3
	AND
		PTR.RecordStatusCode NOT IN (''E'',''X'')

ORDER BY CompletedDateTime DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCompletedPatientTransfusionReactions] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetComponentClass]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Get the blood component class based on the division.
**
**	Author: 	Mike Smith	
**
**	Date: 	12/10/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-----------		----------		-------------------
**	7/31/03	C Taylor		Added sort order based on SortColumn
**	8/6/03		C Taylor		Don''t include Conversion Class (ComponentClassID 9)
**	04/27/2004	Greg Lohse	Added ComponentClassParameterGuid for locking
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetComponentClass]
(
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT 
		CCP.ComponentClassParameterGuid,
		CC.ComponentClassID, 
		ComponentClassShortName, 
		ComponentClassName, 
		DivisionCode, 
		OrderableIndicator, 
		SpecimenRequiredIndicator, 
		MaximumTransfusionTime,
		CC.SortColumn,
		CCP.RowVersion
	FROM
		dbo.ComponentClass CC 
		LEFT JOIN dbo.ComponentClassParameter CCP
		ON CC.ComponentClassID = CCP.ComponentClassID
			AND  DivisionCode = @divisioncode
			AND RecordStatusCode = ''A''
	WHERE
		CC.ComponentClassID != 9
	
	ORDER BY 
		CC.SortColumn

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetComponentClass] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetConfigurableRackQC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects all rack data for the associated active daily control
**
**	Author:	Carrie Van Stedum
**
**	Date: 	12/31/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		-----------------
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetConfigurableRackQC]
(
	@divisioncode	VARCHAR(50),
	@dailycontrolguid	UNIQUEIDENTIFIER
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		R.RackGUID,
		R.RackName,
		R.DailyControlGUID,
		R.RecordStatusCode,
		R.DivisionCode,
		R.RowVersion
	FROM
		dbo.Rack R
	WHERE
		R.DailyControlGUID = @dailycontrolguid
	AND	R.DivisionCode = @divisioncode	
	AND	R.RecordStatusCode != ''X''

	ORDER BY
		R.RackName

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetConfigurableRackQC] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetConfigureReagentQC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Retrieves ReagentTestParameter for a given CommercialIndicator and Division
**
**	Author:	David Askew
**
**	Date: 	07/26/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		------------------
**	07/27/2005	Lohse		Adding Commercial Indicator to select list
**	07/12/2005	N.Paterson	** Secondary review for compliance with database standards and recommendations **  Added spacing to SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetConfigureReagentQC]
(
	@commercialindicator	BIT,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT

		ReagentTestParameterGuid,
		CommercialIndicator,
		DivisionCode,
		[RowVersion]

	FROM

		dbo.ReagentTestParameter

	WHERE

		CommercialIndicator = @commercialindicator
		AND DivisionCode = @divisioncode
			
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetConfigureReagentQC] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCrossmatchedUnitsInDateRange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets all units crossmatched to patients in a given division within a date range
**
**	Author:	Cameron Taylor
**
**	Date: 	08/04/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------	---------	-----------------
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated; changed formatting slightly for readability
**	07/19/05	C Taylor		Added call to fnCrossmatchResultOrderedUnitGuid to ensure latest crossmatch result is 
**					used (there may be repeat XMs)
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV, 
**					major changes, most Indicated by -->
**	09/09/2005	D. Askew	Changed JOIN on Patient to select either the FinalMergeToPatient if the patient has one or more
**					merges (choosing the final merge record) or simply the patient guid if there are none
**	01/17/2006	C. Taylor	Added FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) to ProductShortName (DR 1729)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	06/12/2008	K. Dobranowski	Modifed JOIN and WHERE clauses to make sure that units that were crossmatched and then subsequently 
**					released are counted in the report (CR 2434)
**	06/16/2008	M. Smith	** Reviewed for compliance with database standards and recommendations **
**					Removed multiple "OR" and used "IN" on CrossmatchResultCode check
**	01/04/2010	M. Smith	Changed to get UnitStatusCode from the BloodUnitStatusCodeCurrent table. (CR 1174)
**	01/22/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**  05/18/2012  Lohse		**SQL 2008 Upgrade**Ln127 - Replaced OU.CrossmatchDate with CrossmatchDate in ORDER BY clause
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCrossmatchedUnitsInDateRange]
(
	@startdate			DATETIME,
	@enddate			DATETIME,
	@divisioncode	VARCHAR(50),
	@multidivisional			BIT = false
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	--Convert the start and end date to UTC 
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate) 
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate) 
	
	SELECT DISTINCT
		PT.PatientGuid,
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		BU.BloodUnitGuid,
		BU.EyeReadableUnitId,
		BU.UnitProductCode,
		CASE BU.LabelTypeCode
			WHEN ''I'' THEN BP.ProductShortName+'', ''+BU.UnitProductCode + DT.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
			ELSE BP.ProductShortName+'', ''+BU.UnitProductCode
		END AS ProductShortName,
		BUSCC.UnitStatusCode,
		US.UnitStatusText,
		BUS.PresumedTransfusedIndicator,
		OU.DivisionCode,
		D.DivisionName,
--3>
		OU.OrderedUnitGuid,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, OU.CrossmatchDate) AS CrossmatchDate,
		OU.CrossmatchResultCode,

		CR.CrossmatchResultText,
		PO.PatientOrderGuid,
		PO.OrderingProviderId,
		PO.OrderingProviderLastName,
		PO.OrderingProviderFirstName,
		PO.OrderingProviderMiddleInitial,
		PT.PatientTreatmentGuid,
		PT.TreatingSpecialtyCode,
		TS.TreatingSpecialtyName,
		TS.SortColumn
		
	FROM 
		dbo.OrderedUnit OU

		JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGUID = OU.OrderedComponentGUID

		JOIN dbo.PatientOrder PO ON OC.PatientOrderGUID = PO.PatientOrderGUID

		JOIN dbo.PatientTreatment PT ON PO.PatientTreatmentGUID = PT.PatientTreatmentGUID

		JOIN dbo.Patient LinkPatient ON PT.PatientGuid = LinkPatient.PatientGuid

		JOIN dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)

		JOIN dbo.BloodUnit BU ON OU.BloodUnitGUID = BU.BloodUnitGUID

		JOIN dbo.BloodProduct BP ON BU.BloodProductGuid = BP.BloodProductGuid

		JOIN dbo.DonationType DT ON DT.DonationTypeId = BU.DonationTypeId
		
		JOIN dbo.BloodUnitStatus BUS ON BU.BloodUnitGuid = BUS.BloodUnitGuid

		JOIN dbo.BloodUnitStatusCodeCurrent BUSCC ON BU.BloodUnitGuid = BUSCC.BloodUnitGuid

		JOIN dbo.UnitStatus US ON BUSCC.UnitStatusCode = US.UnitStatusCode

		LEFT JOIN dbo.TreatingSpecialty TS ON PT.TreatingSpecialtyCode = TS.TreatingSpecialtyCode

		JOIN dbo.CrossmatchResult CR ON OU.CrossmatchResultCode = CR.CrossmatchResultCode
		JOIN dbo.VamcDivision D ON OU.DivisionCode = D.DivisionCode
	
	WHERE 
		BU.RecordStatusCode = ''A''
		AND OU.RecordStatusCode = ''A''

	AND ((OU.DivisionCode = @divisioncode) OR (@multidivisional = 1))

	 	AND OU.CrossmatchDate BETWEEN @startdate AND @enddate
	AND 	OU.CrossmatchResultCode IN (''C'', ''E'', ''G'')
	ORDER BY 

		  OU.DivisionCode , P.PatientLastName, P.PatientFirstName, P.PatientMiddleName, P.DisplayVistaPatientId, CrossmatchDate, BU.EyeReadableUnitId
	

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCrossmatchedUnitsInDateRange] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCrossmatchedUnitsInDateRangeCount]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets count of units crossmatched to patients in a given division within a date range
**
**	Author:	Cameron Taylor
**
**	Date: 	08/04/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
** 	---------	----------	-----------------------------------------------------
**	07/17/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated; changed formatting slightly for readability;
**					capitalized SQL statements
**	07/19/05	C Taylor		Added call to fnCrossmatchResultOrderedUnitGuid to ensure latest crossmatch result is used (there may be repeat XMs)
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	06/12/2006	K. Dobranowski	Modifed JOIN and WHERE clauses to make sure that units that were crossmatched and then subsequently 
**					released are counted in the report (CR 2434)
**	06/16/2008	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetCrossmatchedUnitsInDateRangeCount]
(
	@startdate			DATETIME,
	@enddate			DATETIME,
	@divisioncode	VARCHAR(50),
	@multidivisional			BIT = FALSE
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	--Convert the start and end date to UTC 
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate) 
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate) 
	

	SELECT COUNT(1) AS Total
		
	FROM 
		dbo.OrderedUnit OU

		JOIN dbo.BloodUnit BU ON OU.BloodUnitGUID = BU.BloodUnitGUID
		JOIN dbo.BloodUnitStatus BUS ON BU.BloodUnitGuid = BUS.BloodUnitGuid
	
	WHERE 
		BU.RecordStatusCode = ''A''
	AND 	OU.RecordStatusCode = ''A''
	AND 	((OU.DivisionCode = @divisioncode) OR (@multidivisional = 1))
	AND 	OU.CrossmatchDate BETWEEN @startdate AND @enddate
	AND 	OU.CrossmatchResultCode IN (''C'', ''E'', ''G'')
	
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCrossmatchedUnitsInDateRangeCount] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetCurrentCrossmatchResults]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects a record from the CannedComment table based on the Guid
**
**	Author:	Carl Jensen
**
**	Date: 	07/21/2005
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	08/17/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations ** Added Set Nocount OFF
					specified object owner for fnOrderedUnitCrossmatchResult
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetCurrentCrossmatchResults]
(
		@orderedunitguid	UNIQUEIDENTIFIER,
		@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

	SELECT 

		CrossmatchResultCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CrossmatchDate) AS CrossmatchDate,
		CrossmatchTechId

	FROM

		dbo.fnOrderedUnitCrossmatchResult(@orderedUnitGuid)

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetCurrentCrossmatchResults] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects all data from the Daily Control table based on the division code.
**
**	Author:	Greg Lohse
**
**	Date: 	07/26/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	07/26/2005	Lohse		Intial Draft.
**	08/17/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations ** Added @ERROR
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDailyControl]
(
	@divisioncode	VARCHAR(50),
	@recordstatuscode		CHAR(1)
)

AS

SET NOCOUNT ON

DECLARE @ERROR INT

             SELECT 

		DailyControlGuid,
		NumberOfRacks,
		RackNamesIndicator,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DailyAlertTime) AS DailyAlertTime,
		CommercialTemplateIndicator,
		PrimaryEnhancementMediaId,
		SecondaryEnhancementMediaId,
		Comments,
		DivisionCode,
		RecordStatusCode,
		[RowVersion]

	FROM 

		dbo.DailyControl

	WHERE

		DivisionCode = @divisioncode
	AND	RecordStatusCode = @recordstatuscode
	
	ORDER BY LastUpdateDate DESC		-- for Inactive Record Selection

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDailyControl] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyControlRack]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	
**
**	Author:	D. Askew
**
**	Date: 	08/02/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	----------------	---------------------------	--------------------------------------------------------------------------------------------------------------------------------------------------------
**	08/17/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Specified object owners, aliased tables
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDailyControlRack]
(
	@commercialtemplateindicator	BIT,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT 

		R.RackGUID,
		R.[RowVersion] ,
		R.LastUpdateUser,
		R.LastUpdateFunctionId

	FROM 

		dbo.DailyControl DC

		JOIN dbo.Rack R ON 

			DC.DailyControlGUID = R.DailyControlGUID

	WHERE 

		DC.DivisionCode = @divisioncode 

		AND DC.CommercialTemplateIndicator != @commercialtemplateindicator 

		AND DC.RecordStatusCode = ''A''

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDailyControlRack] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyQCRacks]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc: 	Get the list of racks for daily QC
**
**	Author: 	Krzysztof Dobranowski
**
**	Date: 	01/06/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	------------		---------			------------------
**	01/06/2003	Krzysztof Dobranowski	Initial creation.
**	04/21/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/17/2005 	D. Askew		** Reviewed for compliance with database standards and recommendations **
**						NO COUNT set OFF; comments updated; capitalized SQL statements;
**						removed unused code			
**	08/19/2005	N.Paterson	Specified object owners, aliased tables
**	11/04/2009	K.Dobranowski	Added QCOfflineIndicator (CR 2718)
**	08/18/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**  04/23/2015	K. Dobranowski Removed time zone conversion from JOIN and replaced it with variable (CR 3563)
**	05/08/2015	K. Adu-Poku		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDailyQCRacks]
(
	@divisioncode	VARCHAR(50),
	@testdatetime			DATETIME
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

SET @testdatetime = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @testdatetime) 

	SELECT
		R.RackGuid,
		R.RackName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DCW.DailyQcExpirationDate) AS DailyQcExpirationDate,
		DCW.DailyQcWorklistGuid,
		DCW.PartiallyTestedIndicator,
		DCW.DailyUseIndicator,
		DCW.QCOfflineIndicator,
		DCW.[RowVersion],
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DCW.LastUpdateDate) AS LastUpdateDate,
		R.DivisionCode,
		R.LastUpdateUser,
		DC.DailyControlGuid,
		DC.RackNamesIndicator,
		DC.CommercialTemplateIndicator,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DC.DailyAlertTime) AS DailyAlertTime

   	FROM dbo.Rack R

	JOIN dbo.DailyControl DC ON R.DailyControlGUID = DC.DailyControlGuid

	LEFT JOIN dbo.DailyQcWorklist DCW ON DCW.RackGuid = R.RackGuid 
		AND ((DATEDIFF(SECOND, @testdatetime, DCW.DailyQcExpirationDate))) BETWEEN 0 AND 86400 
		AND DCW.RecordStatusCode = ''A''
	WHERE
		DC.DivisionCode = @divisioncode
	AND
		DC.RecordStatusCode = ''A''
	AND
		R.RecordStatusCode = ''A''
	
	ORDER BY R.SortColumn, DCW.DailyQcExpirationDate

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDailyQCRacks] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDailyQCReagentTypes]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Get the list of reagent types for daily QC
**
**	Author: 	Krzysztof Dobranowski
**
**	Date: 	01/03/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	------------		---------		------------------
**	07/18/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability;
**					renamed parameter to be consistent with database standards (all lower case)
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDailyQCReagentTypes]
(
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	
	SELECT
		ReagentType.ReagentTypeID,
		ReagentType.ReagentTypeName,
	             ReagentType.MustUseIndicator,
		ReagentTestParameter.CanChangeIndicator,
		ReagentTestParameter.TestWithName,
		ReagentTestParameter.TestWithID,
		ReagentTestParameter.ExpectedMinimumReactions,
		ReagentTestParameter.SetVialID,
		ReactivityPhase.ReactivityPhaseText,
		ReagentTestParameter.ReactivityPhaseCode,
		DailyControl.PrimaryEnhancementMediaID,
		DailyControl.SecondaryEnhancementMediaID
	FROM 
		dbo.ReagentType
	JOIN
		dbo.ReagentTestParameter ON ReagentTestParameter.ReagentTypeID = ReagentType.ReagentTypeID
	JOIN
		dbo.ReactivityPhase ON ReagentTestParameter.ReactivityPhaseCode = ReactivityPhase.ReactivityPhaseCode
	JOIN
		dbo.DailyControl ON DailyControl.CommercialTemplateIndicator = ReagentTestParameter.CommercialIndicator
	WHERE
		DailyControl.RecordStatusCode = ''A''
	AND
		DailyControl.DivisionCode = @DivisionCode
	AND
		ReagentTestParameter.DivisionCode = @DivisionCode
	AND
		ReagentTestParameter.RecordStatusCode = ''A''
	AND
		ReagentTestParameter.DailyUseIndicator = 1
	
	ORDER BY ReagentType.SortColumn,  ReagentTestParameter.SetVialID

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDailyQCReagentTypes] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDiscardedUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc:	Gets the list of discarded units for the date range
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	08/11/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	07/18/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; changed formatting slightly for readability
**	01/19/2006	C Taylor	Added FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) to ProductShortName (CR 1462)
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	04/23/2006	Lohse		Adding DateTimeConversion to UnitStatusDate
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDiscardedUnits]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SELECT DISTINCT
		BU.EyeReadableUnitId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BUS.UnitStatusDate) AS UnitStatusDate,
		CASE BU.LabelTypeCode
			WHEN ''I'' THEN BP.ProductShortName+'', ''+BU.UnitProductCode + DT.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + BU.UnitDivisionId 
			ELSE BP.ProductShortName+'', ''+BU.UnitProductCode
		END AS ProductShortName,
		BUF.ReturnCreditAmount

	FROM
		dbo.BloodUnit BU

	JOIN dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BU.BloodUnitGuid
	JOIN dbo.BloodProduct BP ON BP.BloodProductGuid = BU.BloodProductGuid
	LEFT JOIN dbo.BloodUnitFinance BUF ON BUF.BloodUnitGuid = BU.BloodUnitGuid
	JOIN dbo.DonationType DT ON DT.DonationTypeId = BU.DonationTypeId

	WHERE
		BU.DivisionCode = @divisioncode
	AND	BUS.UnitStatusDate BETWEEN @startdate AND @enddate
	
	ORDER	 BY UnitStatusDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDiscardedUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDiscardOrQuarantineData]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets blood unit financial data for a given product code and/or unit id
**
**	Author:	Carl Jensen
**
**	Date: 	11/11/2002
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		-------------------
**	10/29/2003	C. Jensen	Changed Division code from int to char
**	02/10/2004	Greg Lohse	Changing the input parameters to GUID to guarantee uniqueness of the unit selected
**	03/02/2004	M.Jablonski	Added row version to SELECT
**	04/23/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/18/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; removed unused code
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/


 CREATE PROCEDURE [dbo].[spGetDiscardOrQuarantineData]
(
	@bloodunitguid		UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT  
		ReturnCreditAmount,
		DirectedPatientGUID,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS  UnitExpirationDate, 
		P.PatientFirstName,
		P.PatientLastName,
		UnitStatusCode,
		QuarantineIndicator,
		ProductTypeCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.vw_BloodShipFinanceAllCurrent.LastUpdateDate) AS  LastUpdateDate,
		UnitStatusRowVersion
	FROM  
		dbo.vw_BloodShipFinanceAllCurrent
		LEFT JOIN dbo.Patient P ON dbo.vw_BloodShipFinanceAllCurrent.DirectedPatientGuid = P.PatientGuid 
	WHERE
		BloodUnitGUID = @bloodunitguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDiscardOrQuarantineData] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDiscardOrQuarantineUnits]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets  Discard or Ouarantine Units for a given division code 
**
**	Author:	Carl Jensen
**
**	Date: 	03/10/2003
**
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------	---------		-------------------
**	10/30/2003	C. Jensen	Added LabelTypeCode
**	01/13/2004	C. Taylor	Added DisplayVistaPatientId
**	02/10/2004	Greg Lohse	Adding UnitDivisionId for ISBT alloQUAT unit searching. Adding FullProductCode
**	04/23/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	01/20/2005	D. Askew	Changed to DiscardDetailCode DiscardCannedCommentGuid
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	07/21/2005	Lohse		Adding ORDER BY EyeReadableUnitId, FullProductCode
**	07/18/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set ON/OFF; comments updated; removed unused code
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetDiscardOrQuarantineUnits]
(
		@divisioncode	VARCHAR(50)
)

AS
	
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
		BloodUnitGUID,
		EyeReadableUnitID,
		DirectedPatientGuid,
		UnitProductCode,
		RhFactorCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		DonationTypeID, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS UnitInDate,
		DivisionCode,
		BloodTypeCode,
		UnitFdaRegistrationNumber,
		LabelUnitId,
		ProductTypeCode,
		ProductName,
		ProductShortName,
		BiohazardousWarningIndicator,
		DonationTypeText,
		ProductTypeName,
		RhFactorText,
		FacilityName,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName,
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitStatusText,
		QuarantineIndicator,
		TestingStatusId,
		OriginalVolume,
		LabelTypeCode,
		[RowVersion],
		Comments,
		IncomingShipmentGUID,
		RTRIM(BloodTypeCode) + '' '' + RhFactorText AS AboRh,
		UnitDivisionId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) AS ShipmentDate,
		PresumedTransfusedIndicator,
		CASE LabelTypeCode
			WHEN ''I'' THEN UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 
			ELSE UnitProductCode
		END AS FullProductCode 
	FROM
		dbo.vw_BloodShipPatientAllCurrent
	WHERE
		(DivisionCode = @DivisionCode) AND
		UnitStatusCode IN (''L'', ''A'', ''S'', ''C'')

	ORDER BY EyeReadableUnitId, FullProductCode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDiscardOrQuarantineUnits] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivision]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects records from the VamcDivision table based on the primary key.
**
**	Author:	Cameron Taylor
**
**	Date: 	10/30/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date			Name		Description
**	04/08/2003	LMeyer		Added ServiceTypeIndicator, AntibodyScreenDisplayCode, AutoAboRhIndicator,
**						MaximumSpecimenExpirationDays
**	01/14/2004	C. Jensen	Added fields from pertaining to DivisionAlerts.
**	03/04/2004	C. Taylor	Added MedicalDirectorName.
**	04/08/2004	Greg Lohse	Adding DivisionGUID field
**	04/15/2004	C. Jensen	Added FacilityGUID
** 	06/25/2004	S. Antropov	Updatred list of columns
**	09/09/2004	S. Antropov	Added VamcDivision.AccessionAreaId
**	07/18/2005	D. Askew	** Reviewed for compliance with database standards and recommendations **
**						NO COUNT set OFF; comments updated; capitalized SQL statements; 
**						changed formatting slightly for readability
**	08/10/2005	J. Engstrom	Modified procedure to get DaylighSavingsStartDate and DayLightSavingsEndDate from VamcDivision 
**						table.  Removed Left Outer Join on DaylighSavings table.
**	10/18/2007	C. Jensen	Added PrinterName field to accomodate retrieval of reports printer (CR 2320).
**	10/01/2009	K. Dobranowski	Added ReactivityPhaseCode (CR 2717)
**	08/18/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/13/2016	Pablo Sanchez	Removed LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber columns and added LabelPrinterEndPointId column (Defect 340457).
**	12/19/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/29/2017	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159).
**	03/30/2017	K. Adu-Poku	Removed DaylightSavingsStartDate and DaylightSavingsEndDate (Task 499503).
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDivision]
(
	@divisioncode	VARCHAR(50)
)

AS

SET NOCOUNT ON

	SELECT 	VamcDivision.DivisionCode, 
			DivisionGuid, 
			DivisionName, 
			ServiceTypeIndicator, 
			VamcDivision.IccbbaRegistrationNumber, 
			ElectronicCrossmatchIndicator, 
			VamcDivision.FacilityGuid, 
			VamcDivision.AccessionAreaId,
			Facility.FacilityName,
			VamcDivision.LocalSupplierGuid, 
			AntibodyScreenDisplayCode, 
			MaximumSpecimenExpirationDays, 
			AutomatedInstrumentIndicator, 
			LabelPrinterUseIndicator, 
			PrinterName,
			TimeZoneId, 
			DaylightSavingsTypeId, 
			PrinterAlertsIndicator, 
			PrinterAlertsPrinterName, 
			PrinterOrderAlertTypeCode, 
			PrinterOrdersNeededHours, 
			IconAlertsIndicator, 
			IconOrderAlertTypeCode, 
			IconOrdersNeededHours, 
			IconRefreshRate, 
			LoginMessageText, 
			InvoiceTemplateText, 
			MedicalDirectorName, 
			LockInactivityTimeoutMin, 
			VamcDivision.RecordStatusCode,
			VamcDivision.[RowVersion],
			ReactivityPhaseCode,
			LabelPrinterEndPointId
	FROM 		dbo.VamcDivision 
		LEFT OUTER JOIN dbo.Facility ON Facility.FacilityGuid = VamcDivision.FacilityGuid
	WHERE
		VamcDivision.DivisionCode = @divisionCode;	

RETURN @@ERROR

SET NOCOUNT OFF

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDivision] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionCurrentDateTime]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 	Selects Current datetime for VamcDivision based on the primary key.
**
**	Author:	Margaret Jablonski	
**
**	Date: 	03/22/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date			Name		Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT OFF, formatted SQL
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDivisionCurrentDateTime]
	
	@divisioncode	VARCHAR(50)

AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT dbo.fnTimeZoneConversion(@divisioncode, 0, GETUTCDATE(), 0)

SET @ERROR = @@ERROR

RETURN(@Error)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDivisionCurrentDateTime] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionTimeZone]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects Time Zone information for VamcDivision based on the primary key.
**
**	Author:	Margaret Jablonski	
**
**	Date: 	03/22/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date			Name		Description
**	------------			---------			------------------
**	07/18/2005 		D. Askew	** Reviewed for compliance with database standards and recommendations **
**						NO COUNT set OFF; comments updated; capitalized SQL statements; 
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDivisionTimeZone]
(
	@divisioncode	VARCHAR(50)
)

AS

SET NOCOUNT ON

	SELECT dbo.fnTimeZoneConversion(@divisioncode, 0, GETUTCDATE(), 2)

RETURN @@ERROR

SET NOCOUNT OFF
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDivisionTimeZone] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionTimeZoneAbbreviation]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects Time Zone information for VamcDivision based on the primary key.
**
**	Author:	Margaret Jablonski	
**
**	Date: 	03/22/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	07/18/2005 	D. Askew	** Reviewed for compliance with database standards and recommendations **
**					NO COUNT set OFF; comments updated; capitalized SQL statements; 
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDivisionTimeZoneAbbreviation]
(
	@divisioncode	VARCHAR(50)
)

AS

SET NOCOUNT ON

	SELECT dbo.fnTimeZoneConversion(@divisioncode, 0, GETUTCDATE(), 3) AS TimeZoneName

RETURN @@ERROR

SET NOCOUNT OFF
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDivisionTimeZoneAbbreviation] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDivisionWorkloadReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects all records from the Division Workload Report
**
**	Author: Carrie Van Stedum
**
**	Date: 	09/24/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		---------		------------------
**	07/18/2005	D. Askew	** Reviewed for compliance with database standards and recommendations **
**							NO COUNT set ON/OFF; comments updated; capitalized SQL statements
**	01/11/2016	C. Van Stedum	Added WorkloadEventStatusText to Select and a JOIN to the WorkloadEventStatus table Defect 251270.
**	02/17/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDivisionWorkloadReport]
(
	@divisioncode	VARCHAR(50),
	@singledivision		BIT,
	@startdate		DATETIME,
	@enddate		DATETIME
)

AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SELECT 
		vp.VbecsProcessName, 
		VP.TransactionType, 
		wp.WorkloadCode,
		we.DivisionCode,
		we.weightmultiplier,
		vd.DivisionName,
		wes.WorkloadEventStatusText
		
	FROM 
		dbo.WorkloadEvent we 

	LEFT JOIN dbo.WorkloadProcess wp 
		ON we.WorkloadProcessGuid = wp.WorkloadProcessGuid 
	JOIN dbo.WorkloadEventStatus wes 
		ON we.WorkloadEventStatusCode = wes.WorkloadEventStatusCode	
	LEFT JOIN dbo.VbecsProcess vp 
		ON wp.VbecsProcessId = vp.VbecsProcessId

	LEFT JOIN dbo.VamcDivision vd
		ON vd.DivisionCode = we.DivisionCode

	-- doing the or @divisioncode = null cause if they pass null I want data for all divisions
	WHERE ((@singledivision = 1 AND we.DivisionCode = @divisioncode) or  (@singledivision = 0))
	 AND we.WorkloadEventDate BETWEEN @startdate AND @enddate
	 AND we.RecordStatusCode = ''A''
		
	ORDER BY VbecsProcessName

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDivisionWorkloadReport] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetDssExtract]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc: 		Retrieves patient transfusion related data for transmission (via RPC) to the DSS (Decision Support System) team
**
**	Use Case(s):	69, 78
**
**	Author: 		David Askew
**
**	Date: 		11/07/2006
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	12/26/06	D. Askew	Added check to WHERE condition for DssExtractSuccessIndicator
**	01/08/07	D. Askew	Added PT.[RowVersion] to SELECT
**	01/09/07	Lohse		Reviewed: Prefixed table names with dbo, minor performance fixes
**	01/11/07	D. Askew	Added code to allow for @patienttransfusionguid to be optional, so we may retrieve either data for a 
**					single update in UCs 69 and 78 or a ''batch update'' for records that were not processed successfully
**	01/12/07	D. Askew	Added more conditions to WHERE clause for modification data
**	01/17/07	D. Askew	Changed JOIN condition on Issued Unit to AND IU.ReturnDateTime IS NULL (from IS NOT NULL)
**					for both SELECT statements in which the JOIN is present
**	01/24/07	D. Askew	Added AND PT.PatientTransfusionGuid = @patienttransfusionguid to WHERE condition for modifications
**					and removed AND ( PT.DssExtractSuccessIndicator IS NULL OR PT.DssExtractSuccessIndicator = 0 );
**					corrected sub query for TransfusionReactionTypeText
**	06/20/07	D. Askew	Replaced PT.TransfusedVolume with code to calculate the value in SELECT statements (CR 2248)
**	10/23/07 	D. Askew	Replaced PT.DivisionCode with CASE statement as OrderingLocation, added PT.TransfusionLocation
**					(CR 2323)
**	11/01/07	D. Askew	Changed PT.TransfusionLocation to PT.DivisionCode to match VBECS Application Interface 
**					Specification v 6.0 (CR 2323)
**	02/14/08	D. Askew	Changed subquery for TransfusionReactionTypeText (CR 2378)
**	03/04/08	K Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**  05/18/2012  Lohse		**SQL 2008 Upgrade** - Ln222 and Ln396 - removing alias from ORDER BY clauses
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDssExtract]
(
	@divisioncode 	VARCHAR(50),
	@patienttransfusionguid		UNIQUEIDENTIFIER = NULL
)

AS

SET NOCOUNT ON

DECLARE @ERROR 		INT

DECLARE @bloodunitguid	UNIQUEIDENTIFIER

SET @ERROR = 0

-- ****************************************************************************************************************************************************************************************************************************************************************************************************
-- ******************************************************************* Get information for requested Patient Transfusion Record *************************************************************************************************************************************************************
IF @patienttransfusionguid IS NOT NULL
BEGIN
	SELECT DISTINCT					
		PT.PatientTransfusionGuid,
		-- **************************************************************************************************************************************************************************************************************************	
		CASE WHEN PO.InstitutionDivisionCode IS NULL THEN 
			PO.DivisionCode  
		ELSE 
			PO.InstitutionDivisionCode
		END 																	AS OrderingLocation,
		-- **************************************************************************************************************************************************************************************************************************	
		PT.DivisionCode,
		PT.ReactionIndicator,
		-- **************************************************************************************************************************************************************************************************************************	
		dbo.fnDateTimeConversionToFileManDateTime( dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, PT.TransfusionEndDateTime ) ) 	AS TransfusionEndDateTime, 
		-- **************************************************************************************************************************************************************************************************************************
		CASE WHEN ( PT.TransfusedVolume IS NULL OR PT.TransfusedVolume = 0 ) THEN
			( BU.OriginalVolume - ISNULL(BU.DiscardedPlasmaVolume, 0) )  
		ELSE
			PT.TransfusedVolume
		END																	AS TransfusedVolume,
		-- **************************************************************************************************************************************************************************************************************************
		P.PatientSsn,
		PT.[RowVersion],
		P.VistaPatientId,
		PO.OrderingProviderId,
		IU.PhysicianName,
		BP.ProductShortName,
		CC.ComponentClassShortName,
		-- **************************************************************************************************************************************************************************************************************************
		(
			SELECT 
				COUNT(1) 
			FROM 
				dbo.BloodUnitModification 
			WHERE 
				ToBloodUnitGuid = BU.BloodUnitGuid 
				AND (ProductModificationCode = ''P'' OR ProductModificationCode = ''U'')
				AND RecordStatusCode = ''A''
		) 																	AS TransfusionPooledUnitsCount,
		-- **************************************************************************************************************************************************************************************************************************
		(
			SELECT  
				TOP 1 TRT.TransfusionReactionTypeText
			FROM 
				dbo.PatientTransfusion PT 
			
				JOIN dbo.TransfusionReaction TR
					ON PT.PatientTransfusionGuid = TR.PatientTransfusionGuid
			
				JOIN dbo.PatientTransfusionReaction PTR
					ON TR.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid
			
				JOIN dbo.TransfusionReactionType TRT
					ON PTR.TransfusionReactionTypeCode = TRT.TransfusionReactionTypeCode
			
			WHERE  
				PT.PatientTransfusionGuid = @patienttransfusionguid
				AND PT.DivisionCode = @divisioncode
				AND PT.RecordStatusCode = ''A''
				AND PTR.RecordStatusCode = ''A''
				AND PTR.PartialSaveId = 5
			
			ORDER BY PTR.LastUpdateDate DESC
		) 																	AS TransfusionReactionTypeText,
		-- **************************************************************************************************************************************************************************************************************************
		dbo.fnDateTimeConversionToFileManDateTime( dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, PT.LastUpdateDate ) ) 		AS LastUpdateDate

	FROM
			dbo.PatientTransfusion PT 
	
			JOIN dbo.BloodUnit BU 
				ON PT.BloodUnitGuid = BU.BloodUnitGuid	
	
			JOIN dbo.BloodProduct BP
				ON BU.BloodProductGuid = BP.BloodProductGuid
		
			JOIN dbo.ProductType PTYP
				ON BP.ProductTypeCode = PTYP.ProductTypeCode
		
			JOIN dbo.ComponentClass CC
				ON PTYP.ComponentClassID = CC.ComponentClassID
		
			JOIN dbo.OrderedUnit OU
				ON BU.BloodUnitGuid = OU.BloodUnitGuid
				AND OU.RecordStatusCode = ''A''
				AND OU.ReleaseDate IS NULL

			JOIN dbo.OrderedComponent OC
				ON OU.OrderedComponentGuid = OC.OrderedComponentGuid
		
			JOIN dbo.PatientOrder PO 
				ON OC.PatientOrderGuid = PO.PatientOrderGuid
	
			JOIN dbo.PatientTreatment PTRMT
				ON PO.PatientTreatmentGuid =  PTRMT.PatientTreatmentGuid
	
			JOIN dbo.Patient P
				ON PTRMT.PatientGuid = P.PatientGuid
				AND PT.PatientGuid = P.PatientGuid
	
			LEFT JOIN dbo.IssuedUnit IU
				ON PT.BloodUnitGuid = IU.BloodUnitGuid	
				AND IU.ReturnDateTime IS NULL
		
	WHERE 
			PT.DivisionCode = @divisioncode
			AND PT.RecordStatusCode = ''A''
			AND PT.PatientTransfusionGuid = @patienttransfusionguid

	ORDER BY 
			PT.PatientTransfusionGuid

	-- ****************************************************************************************************************************************************************************
	-- Also return the modifications (if any)
	SELECT DISTINCT	
			PT.PatientTransfusionGuid,
			BloodUnitModification.ProductModificationCode,
			ProductModification.ProductModificationText,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BloodUnitModification.LastUpdateDate) AS LastUpdateDate
	
	FROM
			SynMirror_V_BloodUnitModification AS BloodUnitModification 
	
			JOIN dbo.BloodUnit FromBloodUnit
				ON BloodUnitModification.FromBloodUnitGuid = FromBloodUnit.BloodUnitGuid
	
			JOIN dbo.PatientTransfusion PT 
				ON FromBloodUnit.BloodUnitGuid = PT.BloodUnitGuid
	
			JOIN dbo.BloodProduct FromBloodProduct
				ON BloodUnitModification.FromBloodProductGuid = FromBloodProduct.BloodProductGuid
	
			JOIN dbo.ProductModification 
				ON BloodUnitModification.ProductModificationCode = ProductModification.ProductModificationCode
	WHERE 	
			FromBloodUnit.DivisionCode = @divisioncode
			AND PT.DivisionCode = @divisioncode
			AND PT.RecordStatusCode = ''A''
			AND PT.PatientTransfusionGuid = @patienttransfusionguid
	
	UNION
	
	SELECT DISTINCT
			PT.PatientTransfusionGuid,
			BloodUnitModification.ProductModificationCode,
			ProductModification.ProductModificationText,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BloodUnitModification.LastUpdateDate) AS LastUpdateDate
	
	FROM
			SynMirror_V_BloodUnitModification AS BloodUnitModification 
	
			JOIN dbo.BloodUnit ToBloodUnit
				ON BloodUnitModification.ToBloodUnitGuid = ToBloodUnit.BloodUnitGuid
	
			JOIN dbo.PatientTransfusion PT 
				ON ToBloodUnit.BloodUnitGuid = PT.BloodUnitGuid
	
			JOIN dbo.BloodProduct ToBloodProduct
				ON ToBloodUnit.BloodProductGuid = ToBloodProduct.BloodProductGuid
	
			JOIN dbo.ProductModification 
				ON BloodUnitModification.ProductModificationCode = ProductModification.ProductModificationCode
	WHERE 	
			ToBloodUnit.DivisionCode = @divisioncode
			AND PT.DivisionCode = @divisioncode
			AND PT.RecordStatusCode = ''A''
			AND PT.PatientTransfusionGuid = @patienttransfusionguid
	
	ORDER BY 
			PatientTransfusionGuid,  LastUpdateDate ASC
END
ELSE
-- ****************************************************************************************************************************************************************************************************************************************************************************************************
-- ******************************************************************* Get information for all Patient Transfusion Records that have not been sent successfully *************************************************************************************************************************
BEGIN
	SELECT DISTINCT					
		PT.PatientTransfusionGuid,
		-- **************************************************************************************************************************************************************************************************************************	
		CASE WHEN PO.InstitutionDivisionCode IS NULL THEN 
			PO.DivisionCode  
		ELSE 
			PO.InstitutionDivisionCode
		END 																	AS OrderingLocation,
		-- **************************************************************************************************************************************************************************************************************************	
		PT.DivisionCode,
		PT.ReactionIndicator,
		-- **************************************************************************************************************************************************************************************************************************	
		dbo.fnDateTimeConversionToFileManDateTime( dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, PT.TransfusionEndDateTime ) ) 	AS TransfusionEndDateTime, 
		-- **************************************************************************************************************************************************************************************************************************
		CASE WHEN ( PT.TransfusedVolume IS NULL OR PT.TransfusedVolume = 0 ) THEN
			( BU.OriginalVolume - ISNULL(BU.DiscardedPlasmaVolume, 0) )
		ELSE
			PT.TransfusedVolume
		END																	AS TransfusedVolume,
		-- **************************************************************************************************************************************************************************************************************************
		P.PatientSsn,
		PT.[RowVersion],
		P.VistaPatientId,
		PO.OrderingProviderId,
		IU.PhysicianName,
		BP.ProductShortName,
		CC.ComponentClassShortName,
		-- **************************************************************************************************************************************************************************************************************************
		(
			SELECT 
				COUNT(1) 
			FROM 
				dbo.BloodUnitModification 
			WHERE 
				ToBloodUnitGuid = BU.BloodUnitGuid 
				AND (ProductModificationCode = ''P'' OR ProductModificationCode = ''U'')

				AND RecordStatusCode = ''A''
		) 																	AS TransfusionPooledUnitsCount,
		-- **************************************************************************************************************************************************************************************************************************
		(
			SELECT  
				TOP 1 TRT.TransfusionReactionTypeText
			FROM 
				dbo.PatientTransfusion PT 
			
				JOIN dbo.TransfusionReaction TR
					ON PT.PatientTransfusionGuid = TR.PatientTransfusionGuid
			
				JOIN dbo.PatientTransfusionReaction PTR
					ON TR.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid
			
				JOIN dbo.TransfusionReactionType TRT
					ON PTR.TransfusionReactionTypeCode = TRT.TransfusionReactionTypeCode
			
			WHERE  
				PT.PatientTransfusionGuid = @patienttransfusionguid
				AND PT.DivisionCode = @divisioncode
				AND PT.RecordStatusCode = ''A''
				AND PTR.RecordStatusCode = ''A''
				AND PTR.PartialSaveId = 5
			
			ORDER BY PTR.LastUpdateDate DESC
		) 																	AS TransfusionReactionTypeText,
		-- **************************************************************************************************************************************************************************************************************************
		dbo.fnDateTimeConversionToFileManDateTime( dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, PT.LastUpdateDate ) ) 		AS LastUpdateDate

	FROM
			dbo.PatientTransfusion PT 
	
			JOIN dbo.BloodUnit BU 
				ON PT.BloodUnitGuid = BU.BloodUnitGuid	
	
			JOIN dbo.BloodProduct BP
				ON BU.BloodProductGuid = BP.BloodProductGuid
		
			JOIN dbo.ProductType PTYP
				ON BP.ProductTypeCode = PTYP.ProductTypeCode
		
			JOIN dbo.ComponentClass CC
				ON PTYP.ComponentClassID = CC.ComponentClassID
		
			JOIN dbo.OrderedUnit OU
				ON BU.BloodUnitGuid = OU.BloodUnitGuid
				AND OU.RecordStatusCode = ''A''
				AND OU.ReleaseDate IS NULL

			JOIN dbo.OrderedComponent OC
				ON OU.OrderedComponentGuid = OC.OrderedComponentGuid
		
			JOIN dbo.PatientOrder PO 
				ON OC.PatientOrderGuid = PO.PatientOrderGuid
	
			JOIN dbo.PatientTreatment PTRMT
				ON PO.PatientTreatmentGuid =  PTRMT.PatientTreatmentGuid
	
			JOIN dbo.Patient P
				ON PTRMT.PatientGuid = P.PatientGuid
				AND PT.PatientGuid = P.PatientGuid
	
			LEFT JOIN dbo.IssuedUnit IU
				ON PT.BloodUnitGuid = IU.BloodUnitGuid	
				AND IU.ReturnDateTime IS NULL
		
	WHERE 
			PT.DivisionCode = @divisioncode
			AND PT.RecordStatusCode = ''A''
			AND ( PT.DssExtractSuccessIndicator IS NULL OR PT.DssExtractSuccessIndicator = 0 ) 

	ORDER BY 
			PT.PatientTransfusionGuid
	
	-- ****************************************************************************************************************************************************************************
	-- Also return the modifications (if any)
	SELECT DISTINCT	
			PT.PatientTransfusionGuid,
			BloodUnitModification.ProductModificationCode,
			ProductModification.ProductModificationText,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BloodUnitModification.LastUpdateDate) AS LastUpdateDate
	
	FROM
			SynMirror_V_BloodUnitModification AS BloodUnitModification 
	
			JOIN dbo.BloodUnit FromBloodUnit
				ON BloodUnitModification.FromBloodUnitGuid = FromBloodUnit.BloodUnitGuid
	
			JOIN dbo.PatientTransfusion PT 
				ON FromBloodUnit.BloodUnitGuid = PT.BloodUnitGuid
	
			JOIN dbo.BloodProduct FromBloodProduct
				ON BloodUnitModification.FromBloodProductGuid = FromBloodProduct.BloodProductGuid
	
			JOIN dbo.ProductModification 
				ON BloodUnitModification.ProductModificationCode = ProductModification.ProductModificationCode
	WHERE 	
			FromBloodUnit.DivisionCode = @divisioncode
			AND PT.DivisionCode = @divisioncode
			AND PT.RecordStatusCode = ''A''
			AND ( PT.DssExtractSuccessIndicator IS NULL OR PT.DssExtractSuccessIndicator = 0 ) 
	
	UNION
	
	SELECT DISTINCT
			PT.PatientTransfusionGuid,
			BloodUnitModification.ProductModificationCode,
			ProductModification.ProductModificationText,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BloodUnitModification.LastUpdateDate) AS LastUpdateDate
	
	FROM
			SynMirror_V_BloodUnitModification AS BloodUnitModification 
	
			JOIN dbo.BloodUnit ToBloodUnit
				ON BloodUnitModification.ToBloodUnitGuid = ToBloodUnit.BloodUnitGuid
	
			JOIN dbo.PatientTransfusion PT 
				ON ToBloodUnit.BloodUnitGuid = PT.BloodUnitGuid
	
			JOIN dbo.BloodProduct ToBloodProduct
				ON ToBloodUnit.BloodProductGuid = ToBloodProduct.BloodProductGuid
	
			JOIN dbo.ProductModification 
				ON BloodUnitModification.ProductModificationCode = ProductModification.ProductModificationCode
	WHERE 	
			ToBloodUnit.DivisionCode = @divisioncode
			AND PT.DivisionCode = @divisioncode
			AND PT.RecordStatusCode = ''A''
			AND ( PT.DssExtractSuccessIndicator IS NULL OR PT.DssExtractSuccessIndicator = 0 ) 
	
	ORDER BY 
			PatientTransfusionGuid,  LastUpdateDate ASC
END

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetDssExtract] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEligibleUnitsForDivision]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets a list of unit data eligible for shipment
**
**	Author:	John Vrooland
**
**	Date: 	10/24/2002
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	02/10/2004	Greg Lohse	Adding UnitDivisionId  - for selecting ISBT alloQUATS, tweaked this nasty sproc a bit
					also adding a way to select FullProductCode for ISBT units - VBECSControls - UC5
**	04/22/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004	C. Taylor	Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004	C. Taylor	Added PresumedTransfusedIndicator
**	1/11/2004	R. Heiberger	Adjusted UnitStatusCode to select only those units that are in the Available, Crossmatched, Limited, or
**					Assigned statuses.
**	1/26/2004	R Heiberger	Removed the LocalSupplier Join. The join prevented ISBT units from being selectable.
**	06/17/2005	Npaterson	Changed to use new view to increase performance
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Using New view ,Added [] to RowVersion, Added NOCOUNT OFF, Specified table owners
**	07/21/2005	Lohse		Adding ORDER BY EyeReadableUnitId, FullProductCode
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEligibleUnitsForDivision]
(
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		VW.BloodUnitGUID,
		VW.EyeReadableUnitID,
		VW.UnitDivisionId,
		VW.DirectedPatientGUID,
		VW.UnitProductCode,
		VW.BloodTypeCode,
		VW.RhFactorCode,
		VW.RhFactorText,
		RTRIM(VW.BloodTypeCode) + '' '' + (VW.RhFactorText) AS AboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VW.UnitInDate) AS UnitInDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VW.UnitExpirationDate) AS UnitExpirationDate,
		VW.DonationTypeID,
		VW.UnitFdaRegistrationNumber,
		VW.LabelUnitID,
		VW.BiohazardousWarningIndicator,
		VW.QuarantineIndicator,
		VW.UnitCost,
		VW.SpecialTestingCost,
		VW.ReturnCreditAmount,
		VW.[RowVersion],
		VW.DivisionCode,
		VW.Comments,
		VW.OutgoingShipmentGUID,
		VW.IncomingShipmentGUID,
		VW.ProductTypeCode,
		VW.ProductName,
		VW.ProductShortName,
		VW.DonationTypeText,
		VW.ProductTypeName,
		VW.FacilityName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.PatientLastName,
		P.VistaPatientID,
		VW.UnitStatusCode,
		VW.UnitStatusText,	
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VW.ShipmentDate) AS ShipmentDate,
		PresumedTransfusedIndicator,
		CASE VW.LabelTypeCode
			WHEN ''I'' THEN VW.UnitProductCode + VW.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + VW.UnitDivisionId 
			ELSE VW.UnitProductCode
		END AS FullProductCode 

	FROM 
		dbo.vw_BloodShipFinanceAllCurrent  VW

LEFT OUTER JOIN dbo.Patient P ON VW.DirectedPatientGUID = P.PatientGuid		

	WHERE

		VW.Divisioncode = @divisioncode
	AND 	VW.UnitStatusCode IN (''L'', ''A'', ''S'', ''C'')

	ORDER BY

		EyeReadableUnitId, FullProductCode

SET @ERROR = @@ERROR

	SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEligibleUnitsForDivision] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets data about Equipment base on parameters
**
**	Author:	Cameron Taylor
**
**	Date: 	03/10/2003
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/23/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**					Refactored this code with one SELECT statement that does the same
**	06/08/2004	Greg Lohse	Adding InspectionIndicator for BR_26.45
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added [] to rowversion
**					Removed Begin,End, Capitalized ON, Added blank lines, Removed IS NULL check per Mike Smith
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipment]
(
	@divisioncode	VARCHAR(50),
	@equipmenttype	VARCHAR(25) = NULL,
	@manufacturername	VARCHAR(50) = NULL,
	@serialnumber		VARCHAR(50) = NULL,
	@includeall		BIT = NULL
)
	AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		E.EquipmentGUID,
		E.EquipmentName,
		E.EquipmentType,
		E.ManufacturerName,
		E.ManufacturerPhoneNumber,	
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ReceiptDate) AS ReceiptDate,
		E.ReceiptTechId,
		E.AddressGuid,
		E.InvoiceNumber,
		E.SerialNumber,
		E.LocalIdentifier,
		E.MaintenanceContractNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, MaintenanceContractDate) AS  MaintenanceContractDate,
		E.InspectionIndicator,
		E.OutOfServiceIndicator,
		E.Comments,
		E.NextMaintenanceText,
		E.DivisionCode,
		E.[RowVersion],
		A.AddressGuid,
		A.AddressLine1,
		A.AddressLine2,
		A.AddressLine3,
		A.AddressCity,
		A.StateCode,
		A.AddressZipCode,
		A.[RowVersion] AS AddressRowVersion

	FROM

		dbo.Equipment E

	LEFT OUTER  JOIN dbo.Address A ON E.AddressGuid = A.AddressGuid

	WHERE

		E.DivisionCode = @divisioncode

	AND	((E.EquipmentType = @equipmenttype) OR @equipmenttype IS NULL)

	AND	((E.ManufacturerName = @manufacturername) OR @manufacturername IS NULL) 

	AND	((E.SerialNumber = @serialnumber) OR @serialnumber IS NULL)

	AND	(((@includeall IS NULL OR @includeall = 0) AND E.OutOfServiceIndicator = 0) OR @includeall = 1)
		
	ORDER BY

		SerialNumber,EquipmentName

SET @ERROR = @@ERROR

	SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipment] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentByGUID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets data about Equipment matching guid parameter
**
**	Author:	Greg Lohse
**
**	Date: 	02/23/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	02/24/2004	Greg Lohse	Initial Draft.
**	04/23/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added [] to rowversion
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentByGUID]
(
	@equipmentguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		E.EquipmentGUID,
		E.EquipmentName,
		E.EquipmentType,
		E.ManufacturerName,
		E.AddressGuid,
		A.AddressLine1,
		A.AddressLine2,
		A.AddressLine3,
		A.AddressCity,
		A.StateCode,
		A.AddressZipCode,
		A.[RowVersion] AS AddressRowVersion,
		E.ManufacturerPhoneNumber,	
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ReceiptDate) AS  ReceiptDate,
		E.ReceiptTechId,
		E.InvoiceNumber,
		E.SerialNumber,
		E.LocalIdentifier,
		E.MaintenanceContractNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, MaintenanceContractDate) AS  MaintenanceContractDate,
		E.InspectionIndicator,
		E.OutOfServiceIndicator,
		E.Comments,
		E.NextMaintenanceText,
		E.DivisionCode,
		E.[RowVersion]
	FROM
		dbo.Equipment E

	LEFT OUTER  JOIN dbo.Address A on E.AddressGuid = A.AddressGuid

	WHERE
		E.EquipmentGUID = @equipmentguid

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentByGUID] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentBySerialNumberAndManufacturer]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Identifies equipment matching serial number and manufacturer
**
**	Author:	Cameron Taylor
**
**	Date: 	10/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentBySerialNumberAndManufacturer]
(
	@serialnumber		VARCHAR(50),
	@manufacturername	VARCHAR(50),
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

	SET NOCOUNT ON

		SELECT
			E.EquipmentGUID
	
		FROM
			dbo.Equipment E
	
		WHERE
			E.SerialNumber = @serialnumber
		AND
			E.ManufacturerName = @manufacturername
		AND
			E.DivisionCode = @divisioncode

SET @ERROR = @@ERROR

	SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentBySerialNumberAndManufacturer] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentDetails]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Equipment Details
**
**	Author:	Greg Lohse
**
**	Date: 	06/08/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/07/2004	Greg Lohse	Initial Draft.
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentDetails]
(
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT


	SET NOCOUNT ON

			SELECT DISTINCT
		
				EquipmentType
		
			FROM
				dbo.Equipment
		
			WHERE
		
				DivisionCode = @divisioncode
		
			ORDER BY 

				EquipmentType
		
				SET @ERROR = @@ERROR
			
				IF @ERROR != 0 GOTO ERR_HANDLER
		

		
			SELECT DISTINCT

				ManufacturerName

			FROM

				dbo.Equipment 

			WHERE

				DivisionCode = @divisioncode

			ORDER BY 

				ManufacturerName
	
				SET @ERROR = @@ERROR
		
				IF @ERROR != 0 GOTO ERR_HANDLER
		

	SET NOCOUNT OFF

RETURN(0)

ERR_HANDLER:
	
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentDetails] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentMaintenanceByGuid]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets data about Equipment maintenance matching guid parameter
**
**	Author:	CVS
**
**	Date: 	08/26/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	08/26/2004	CVS		Initial Draft.
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added [] to rowversion
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentMaintenanceByGuid]
(
	@equipmentmaintenanceguid		UNIQUEIDENTIFIER,
	@divisioncode		VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

	SET NOCOUNT ON

	SELECT
		EM.EquipmentMaintenanceGUID,
		EM.EquipmentGuid,
		EM.MaintenanceType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EM.MaintenanceDate) AS  MaintenanceDate,
		EM.MaintenanceResults,
		EM.PendingIssues,
		EM.[RowVersion],
		E.DivisionCode
	FROM
		dbo.EquipmentMaintenance EM
	JOIN
		dbo.Equipment E ON E.EquipmentGuid = EM.EquipmentGuid
	WHERE
		EM.EquipmentMaintenanceGUID = @equipmentmaintenanceguid

SET @ERROR = @@ERROR

	SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentMaintenanceByGuid] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentMaintenanceForEquipment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets data about Equipment maintenance matching equipment guid parameter
**
**	Author:	Cameron Taylor
**
**	Date: 	09/23/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added [] to rowversion
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentMaintenanceForEquipment]
(
	@equipmentguid				UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

	SET NOCOUNT ON

		SELECT
			EM.EquipmentMaintenanceGUID,
			EM.EquipmentGuid,
			EM.MaintenanceType,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EM.MaintenanceDate) AS  MaintenanceDate,
			EM.MaintenanceResults,
			EM.PendingIssues,
			EM.[RowVersion],
			E.DivisionCode
		FROM
			dbo.EquipmentMaintenance EM
		JOIN
			dbo.Equipment E ON E.EquipmentGuid = EM.EquipmentGuid
		WHERE
			EM.EquipmentGUID = @equipmentguid
		AND
			E.DivisionCode = @divisioncode
	
		ORDER BY 
			MaintenanceDate DESC

SET @ERROR = @@ERROR

	SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentMaintenanceForEquipment] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentMaintenanceTypes]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets list of equipment maintenance types entered previously
**
**	Author:	Cameron Taylor
**
**	Date: 	09/28/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added spacing
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentMaintenanceTypes]
(
	@divisioncode	VARCHAR(50)
)

AS


DECLARE @ERROR INT

SET @ERROR = 0

		SET NOCOUNT ON

			SELECT DISTINCT

				EM.MaintenanceType

			FROM
				dbo.Equipment E

				JOIN

				dbo.EquipmentMaintenance EM ON EM.EquipmentGuid = E.EquipmentGuid

			WHERE

				E.DivisionCode = @divisioncode

			ORDER BY

				MaintenanceType

SET @ERROR = @@ERROR

		SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentMaintenanceTypes] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentManufacturers]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets list of equipment manufacturers entered previously
**
**	Author:	Cameron Taylor
**
**	Date: 	09/21/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	N.paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added spacing
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentManufacturers]
(
	@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

	SET NOCOUNT ON

		SELECT DISTINCT

			ManufacturerName

		FROM

			dbo.Equipment

		WHERE

			DivisionCode = @divisioncode

		AND

			OutOfServiceIndicator = 0

		ORDER BY

			ManufacturerName
	
SET @ERROR = @@ERROR

	SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentManufacturers] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentRecordForReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets data about Equipment & maintenance for report
**
**	Author:	Cameron Taylor
**
**	Date: 	09/24/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentRecordForReport]
(
	@equipmentguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		E.EquipmentGUID,
		E.EquipmentName,
		E.EquipmentType,
		E.ManufacturerName,
		E.AddressGuid,
		A.AddressLine1,
		A.AddressLine2,
		A.AddressCity,
		A.StateCode,
		A.AddressZipCode,
		E.ManufacturerPhoneNumber,	

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.ReceiptDate) AS  ReceiptDate,

		ISNULL(U.UserName,E.ReceiptTechId) AS ReceiptTechId,
		E.SerialNumber,
		E.LocalIdentifier,
		E.MaintenanceContractNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.MaintenanceContractDate) AS  MaintenanceContractDate,

		E.OutOfServiceIndicator,
		E.Comments,
		E.NextMaintenanceText,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.LastUpdateDate) AS LastUpdateDate,
		ISNULL(LU.UserName,E.LastUpdateUser) AS LastUpdateUser
	FROM
		dbo.Equipment E

		LEFT OUTER JOIN 

			dbo.Address A ON E.AddressGuid = A.AddressGuid

		LEFT JOIN

			dbo.VbecsUser U ON U.VbecsUserId = E.ReceiptTechId

		LEFT JOIN

			dbo.VbecsUser LU ON LU.VbecsUserId = E.LastUpdateUser

		WHERE

			EquipmentGUID = @equipmentguid

	SET @ERROR = @@ERROR

	IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		EM.EquipmentGUID,
		CAST(EM.EquipmentMaintenanceGuid as VARCHAR(50)) AS EquipmentMaintenanceGuid, -- CAST for Crystal so that it can be grouped!
		EM.MaintenanceType,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EM.MaintenanceDate) AS  MaintenanceDate,

		EM.MaintenanceResults,
		EM.PendingIssues,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EM.LastUpdateDate) AS LastUpdateDate,

		ISNULL(U.UserName,EM.LastUpdateUser) AS LastUpdateUser,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.MaintenanceDate) as CurrentMaintenanceDate -- Need all records for same guid to have the same date for grouping
	FROM

			dbo.SynMirror_V_EquipmentMaintenance EM

	JOIN
		dbo.EquipmentMaintenance E ON E.EquipmentMaintenanceGuid = EM.EquipmentMaintenanceGuid

	LEFT JOIN

		dbo.VbecsUser U 

	ON U.VbecsUserId = EM.LastUpdateUser

	WHERE

		EM.EquipmentGuid = @equipmentguid

	ORDER BY

			CurrentMaintenanceDate DESC, EquipmentMaintenanceGuid, LastUpdateDate DESC


	SET @ERROR = @@ERROR

	IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT DISTINCT
		E.EquipmentName,
		E.EquipmentType,
		E.ManufacturerName,
		E.ManufacturerPhoneNumber,	
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.ReceiptDate) AS  ReceiptDate,
		ISNULL(U.UserName,E.ReceiptTechId) AS ReceiptTechId,
		E.SerialNumber,
		E.LocalIdentifier,
		E.MaintenanceContractNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.MaintenanceContractDate) AS  MaintenanceContractDate,
		E.OutOfServiceIndicator,
		E.Comments,
		E.NextMaintenanceText,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.LastUpdateDate) AS LastUpdateDate,
		ISNULL(LU.UserName,E.LastUpdateUser) as LastUpdateUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, E.MirrorDate) AS MirrorDate
	FROM
		dbo.SynMirror_V_Equipment E
	LEFT JOIN
		dbo.VbecsUser U ON U.VbecsUserId = E.ReceiptTechId
	LEFT JOIN
		dbo.VbecsUser LU ON LU.VbecsUserId = E.LastUpdateUser
	WHERE
		E.EquipmentGUID = @equipmentguid
	AND
		E.Source = ''MIRROR''
	ORDER BY
		MirrorDate DESC

	SELECT DISTINCT
		E.AddressGuid,
		A.AddressLine1,
		A.AddressLine2,
		A.AddressCity,
		A.StateCode,
		A.AddressZipCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, A.LastUpdateDate) AS LastUpdateDate,
		ISNULL(U.UserName,A.LastUpdateUser) AS LastUpdateUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, A.MirrorDate) AS MirrorDate
	FROM
		dbo.SynMirror_V_Address A
	JOIN 
		dbo.Equipment E ON E.AddressGuid = A.AddressGuid
	LEFT JOIN
		dbo.VbecsUser U ON U.VbecsUserId = A.LastUpdateUser
	WHERE
		E.EquipmentGUID = @equipmentguid
	AND
		A.Source = ''MIRROR''
	AND (A.AddressLine1 IS NOT NULL OR A.AddressLine2 IS NOT NULL OR A.AddressCity IS NOT NULL OR A.StateCode IS NOT NULL OR A.AddressZipCode IS NOT NULL)
	ORDER BY
		MirrorDate DESC

	SET @ERROR = @@ERROR


ERR_HANDLER:

	SET NOCOUNT OFF

	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentRecordForReport] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetEquipmentTypes]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets list of equipment types entered previously
**
**	Author:	Cameron Taylor
**
**	Date: 	09/21/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Added Tabs
**					ADDITION OF RETURN(@ERROR) AFFECTS CODE
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetEquipmentTypes]
(
		@divisioncode	VARCHAR(50)
)

AS

DECLARE @ERROR INT

SET NOCOUNT ON


		SELECT DISTINCT
			EquipmentType
		FROM
			dbo.Equipment
		WHERE
			DivisionCode = @divisioncode
		AND
			OutOfServiceIndicator = 0
		ORDER BY
			EquipmentType

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetEquipmentTypes] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAboIncompatibleTransfusion]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Margaret Jablonski	
**
**	Date: 	06/30/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added Error Checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportAboIncompatibleTransfusion]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER
	SELECT
		ExceptionTransfusionGuid,
		ExceptionType.ExceptionTypeName,
		UnitId,
		UnitProductType,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		TransfusedPatientName,
		TransfusedPatientId,
		TransfusedPatientAboRh,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTransfusion

		JOIN dbo.ExceptionType ON 
			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTransfusion.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode
	AND	ExceptionDate BETWEEN @startdate AND @enddate
	
	ORDER BY ExceptionDate DESC

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER
	SET NOCOUNT OFF
	RETURN 0

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN @ERROR
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportAboIncompatibleTransfusion] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAboIncompatibleTransfusionForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor	
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportAboIncompatibleTransfusionForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionTransfusionGuid,
		ExceptionType.ExceptionTypeName,
		UnitId,
		UnitProductType,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		TransfusedPatientName,
		TransfusedPatientId,
		TransfusedPatientAboRh,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTransfusion
		JOIN dbo.ExceptionType ON ExceptionType.ExceptionTypeId = ExceptionTransfusion.ExceptionTypeId
	WHERE
		TransfusedPatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)


	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportAboIncompatibleTransfusionForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAntigenTestInvalidated]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Cameron Taylor
**
**	Date: 	11/26/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportAntigenTestInvalidated]
(
	@startdate		DATETIME,
	@enddate		DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionAntigenTestGuid,
		ExceptionType.ExceptionTypeName,
		UnitId,
		ProductShortName,
		TestPerformed,
		InvalidatedResult,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, InvalidatedDate) AS InvalidatedDate,
		PreviousTestingTechName,
		CurrentTestingTechName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionAntigenTest
	JOIN 
		dbo.ExceptionType ON ExceptionType.ExceptionTypeId = ExceptionAntigenTest.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode
	AND	ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER

	SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportAntigenTestInvalidated] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportAntigenTestInvalidatedForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data for individual unit (multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	11/26/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportAntigenTestInvalidatedForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionAntigenTestGuid,
		ExceptionType.ExceptionTypeName,
		UnitId,
		ProductShortName,
		TestPerformed,
		InvalidatedResult,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, InvalidatedDate) AS InvalidatedDate,
		PreviousTestingTechName,
		CurrentTestingTechName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionAntigenTest
	JOIN 
		dbo.ExceptionType ON ExceptionType.ExceptionTypeId = ExceptionAntigenTest.ExceptionTypeId
	WHERE
		UnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportAntigenTestInvalidatedForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportCautionTagBTRF]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data related to the printing of Caution Tags and Blood TransfusionRecordForms
**
**	Author:	Carl Jensen
**
**	Date: 	10/26/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added Error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportCautionTagBTRF]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionCautionTagGuid,
		ECT.ExceptionTypeId,
		ExceptionTypeName,
		SpecimenUid,		
		PatientName,
		PatientId,
		PatientGuid,
		PatientAboRh,
		UnitId,
		UnitGuid,
		ProductCode,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionCautionTag ECT
			JOIN dbo.ExceptionType 
				ON ExceptionType.ExceptionTypeId = ECT.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode
	AND	ExceptionDate BETWEEN @startdate AND @enddate
	
	ORDER BY ExceptionDate DESC
				SET @ERROR = @@ERROR
				IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportCautionTagBTRF] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportCautionTagBtrfForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data related to the printing of Caution Tags and Blood TransfusionRecordForms for a single patient (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	11/24/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportCautionTagBtrfForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionCautionTagGuid,
		ECT.ExceptionTypeId,
		ExceptionTypeName,
		SpecimenUid,		
		PatientName,
		PatientId,
		PatientGuid,
		PatientAboRh,
		UnitId,
		UnitGuid,
		ProductCode,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionCautionTag ECT
	JOIN 
		dbo.ExceptionType 
			ON ExceptionType.ExceptionTypeId = ECT.ExceptionTypeId
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportCautionTagBtrfForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportElectronicTransfusion]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (CR 2942)
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/10/2011
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/13/11	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportElectronicTransfusion]
(
	@startdate		DATETIME,
	@enddate		DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionElectronicTransfusionGuid,
		PatientTransfusionGuid,
		ExceptionType.ExceptionTypeName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, BedsideVerificationDate) AS BedsideVerificationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TransfusionStartDateTime) AS TransfusionStartDateTime,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TransfusionEndDateTime) AS TransfusionEndDateTime,
		BedsideVerificationUnitManualEntryReason,
		InterruptionIndicator,
		ReactionIndicator,
		ReactionSymptoms,
		TransfusedVolume,
		Transfusionist1Id,
		Transfusionist2Id,
		TransfusionLocation,
		PatientName,
		PatientId,
		UnitId,
		UnitProductCode,
		PatientTransfusionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionElectronicTransfusion

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionElectronicTransfusion.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportElectronicTransfusion] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueOrder]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data related to the issuance of units
**
**	Author:	Carl Jensen
**
**	Date: 	1/30/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks, Removed comments
**	04/04/2006	Lohse		Adding TimeZone Conversion for date fields
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueOrder]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR

	IF @ERROR != 0 GOTO ERR_HANDLER

		SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
	
		SET @ERROR = @@ERROR
	
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionEmergencyIssueOrderGuid,
		ET.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientGuid,
		CprsOrderNumber,
		UrgencyIndicator,
		OrderUrgencyText,
		ComponentClassOrdered,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateWanted) AS DateWanted,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateAcknowledged) AS DateAcknowledged,
		ProcessingTechName,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		DivisionCode

	FROM
		dbo.ExceptionEmergencyIssueOrder EUI

		JOIN dbo.ExceptionType ET ON 
			ET.ExceptionTypeId = EUI.ExceptionTypeId

		JOIN dbo.OrderUrgency OU ON 
			OU.OrderUrgencyCode = EUI.UrgencyIndicator 

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND  @enddate

	ORDER BY ExceptionDate DESC
				
	SET @ERROR = @@ERROR
					
	IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportEmergencyIssueOrder] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueOrderForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data related to the issuance of units (multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	02/01/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Removed comments
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	04/04/2006	Lohse		Adding DateTime Conversion for date fields
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueOrderForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionEmergencyIssueOrderGuid,
		ET.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientGuid,
		CprsOrderNumber,
		UrgencyIndicator,
		OrderUrgencyText,
		ComponentClassOrdered,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateWanted) AS DateWanted,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateAcknowledged) AS DateAcknowledged,
		ProcessingTechName,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		DivisionCode

	FROM
		dbo.ExceptionEmergencyIssueOrder EUI

		JOIN dbo.ExceptionType ET ON 
			ET.ExceptionTypeId = EUI.ExceptionTypeId

		JOIN dbo.OrderUrgency OU ON 
			OU.OrderUrgencyCode = EUI.UrgencyIndicator 

	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportEmergencyIssueOrderForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueUnitTest]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	01/20/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	04/04/2006	Lohse		Adding DateTimeConversion to UnitExpirationDate
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueUnitTest]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionEmergencyIssueUnitTestGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientAboRh,
		TestPerformed,
		TestInterp,
		UnitId,
		UnitAboRh,
		UnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		TestingTechName,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionEmergencyIssueUnitTest 

		JOIN dbo.ExceptionType ON 
			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionEmergencyIssueUnitTest.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportEmergencyIssueUnitTest] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportEmergencyIssueUnitTestForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	02/01/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	04/04/2006	Lohse		Adding DateTimeConversion to UnitExpirationDate
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportEmergencyIssueUnitTestForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionEmergencyIssueUnitTestGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientAboRh,
		TestPerformed,
		TestInterp,
		UnitId,
		UnitAboRh,
		UnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		TestingTechName,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionEmergencyIssueUnitTest 
	JOIN 
		dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionEmergencyIssueUnitTest.ExceptionTypeId
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC
	
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportEmergencyIssueUnitTestForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportExpiredTask]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	01/20/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	04/04/2006	Lohse		Adding DateTimeConversion to DateWanted
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportExpiredTask]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionExpiredTaskGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		CprsOrderNumber,
		SpecimenUID,
		ComponentClassOrdered,
		Quantity,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateWanted) AS DateWanted,
		LoginTechName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionExpiredTask

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionExpiredTask.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportExpiredTask] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportExpiredUnitReceived]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Carrie Van Stedum
**
**	Date: 	09/29/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**					Added joins to replace subqueries per Mike Smith
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportExpiredUnitReceived]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionExpiredUnitReceivedGuid,
		ExceptionType.ExceptionTypeName,
		ExceptionExpiredUnitReceived.ExceptionTypeId,
		UnitId,
		UnitGuid,
		UnitAboRh,
		ProductType,
		ProductCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExpirationDate) AS ExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, IncomingShipmentDate) AS IncomingShipmentDate,
		ProcessingTechId,
		/* Next 2 lines are Code Review change suggested by Mike Smith to replace subqueries */
		--(SELECT UserName  FROM dbo.VBECSUser WHERE VbecsUserID =  dbo.ExceptionExpiredUnitReceived.ProcessingTechId) AS ProcessingTechName,
		--(SELECT UserName  FROM dbo.VBECSUser WHERE VbecsUserID = ExceptionUser) AS ExceptionUserName,
		VUPT.UserName AS ProcessingTechName,
		VUEU.UserName AS ExceptionUserName,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionExpiredUnitReceived 

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionExpiredUnitReceived.ExceptionTypeId
		/* Next 2 lines are Code Review change suggested by Mike Smith to replace subqueries */
		LEFT JOIN  dbo.VBECSUser VUPT ON VUPT.VbecsUserID=dbo.ExceptionExpiredUnitReceived.ProcessingTechId
	
		LEFT JOIN  dbo.VBECSUser VUEU ON  VUEU.VbecsUserID=dbo.ExceptionExpiredUnitReceived.ExceptionUser

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportExpiredUnitReceived] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportExpiredUnitReceivedForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data for Unit History Report (based on spGetExceptionReportExpiredUnitReceived)
**
**	Author:	David Askew
**
**	Date: 	10/11/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportExpiredUnitReceivedForBloodUnit]
(
	@divisioncode	VARCHAR(50),
	@bloodunitguid	UNIQUEIDENTIFIER
)

AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionExpiredUnitReceivedGuid,
		ExceptionType.ExceptionTypeName,
		ExceptionExpiredUnitReceived.ExceptionTypeId,
		UnitId,
		UnitGuid,
		UnitAboRh,
		ProductType,
		ProductCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExpirationDate) AS ExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, IncomingShipmentDate) AS IncomingShipmentDate,
		ProcessingTechId,
		VUPT.UserName AS ProcessingTechName,
		VUEU.UserName AS ExceptionUserName,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionExpiredUnitReceived 

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionExpiredUnitReceived.ExceptionTypeId
		
		LEFT JOIN  dbo.VBECSUser VUPT ON VUPT.VbecsUserID = dbo.ExceptionExpiredUnitReceived.ProcessingTechId
	
		LEFT JOIN  dbo.VBECSUser VUEU ON  VUEU.VbecsUserID = dbo.ExceptionExpiredUnitReceived.ExceptionUser

	WHERE
		DivisionCode = @divisioncode

	AND  UnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportExpiredUnitReceivedForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportInconclusiveCrossmatch]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	06/29/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	08/17/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Specified object owners, aliased tables, spaced out SQL, added error check
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportInconclusiveCrossmatch]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
		SET @ERROR = @@ERROR
			IF @ERROR != 0 GOTO ON_ERROR

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
		SET @ERROR = @@ERROR
			IF @ERROR != 0 GOTO ON_ERROR

	SELECT

		ExceptionInconclusiveCrossmatchGuid,
		ET.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUid,
		BloodUnitId,
		UnitProductCode,
		SystemInterp,
		TechInterp,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName

	FROM

		dbo.ExceptionInconclusiveCrossmatch EIC

		JOIN dbo.ExceptionType ET ON 

			ET.ExceptionTypeId = EIC.ExceptionTypeId

	WHERE

		DivisionCode = @divisioncode

		AND	ExceptionDate BETWEEN @startdate AND  @enddate

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

ON_ERROR:

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportInconclusiveCrossmatch] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportLabelMismatch]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	---------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportLabelMismatch]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionLabelMismatchGuid,
		ExceptionType.ExceptionTypeName,
		ModificationType,
		TargetUnitID,
		TargetUnitABORh,
		TargetProductType,
		TargetProductCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TargetUnitExpirationDate) AS TargetUnitExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ModificationDate) AS ModificationDate,
		DiscrepantField,
		CorrectedValue,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionLabelMismatch

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionLabelMismatch.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate  AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportLabelMismatch] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportLabelMismatchForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportLabelMismatchForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionLabelMismatchGuid,
		ExceptionType.ExceptionTypeName,
		ModificationType,
		TargetUnitID,
		TargetUnitABORh,
		TargetProductType,
		TargetProductCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TargetUnitExpirationDate) AS TargetUnitExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ModificationDate) AS ModificationDate,
		DiscrepantField,
		CorrectedValue,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionLabelMismatch

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionLabelMismatch.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode
	AND	TargetUnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportLabelMismatchForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRh]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientAboRh]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionPatientAboRhGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		PreTestingAboRh,
		CurrentTechAboRh,
		CurrentSystemAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TestDate) AS TestDate,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientAboRh

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientAboRh.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

		AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientAboRh] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRHDiscrepancy]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		--------		-----------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	Npaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	08/19/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientAboRHDiscrepancy]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0

	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionPatientAboRhDiscrepancyGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PreviousSpecimenUID,
		PreviousSpecimenAboRh,
		PreviousTestingTechName,
		PreviousEntryTechName,
		PreviousTestingDivision,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PreviousTestingDate) AS PreviousTestingDate,
		CurrentSpecimenUID,
		CurrentSpecimenAboRh,
		CurrentTestingTechName,
		CurrentEntryTechName,
		CurrentTestingDivision,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CurrentTestingDate) AS CurrentTestingDate,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionPatientAboRhDiscrepancy

	JOIN dbo.ExceptionType ON 
	dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientAboRhDiscrepancy.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode
	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientAboRHDiscrepancy] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRHDiscrepancyForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientAboRHDiscrepancyForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON
	SELECT
		ExceptionPatientAboRhDiscrepancyGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PreviousSpecimenUID,
		PreviousSpecimenAboRh,
		PreviousTestingTechName,
		PreviousEntryTechName,
		PreviousTestingDivision,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PreviousTestingDate) AS PreviousTestingDate,
		CurrentSpecimenUID,
		CurrentSpecimenAboRh,
		CurrentTestingTechName,
		CurrentEntryTechName,
		CurrentTestingDivision,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CurrentTestingDate) AS CurrentTestingDate,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionPatientAboRhDiscrepancy
	
	JOIN dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientAboRhDiscrepancy.ExceptionTypeId
	
	WHERE
		PatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientAboRHDiscrepancyForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAboRhForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientAboRhForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionPatientAboRhGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		PreTestingAboRh,
		CurrentTechAboRh,
		CurrentSystemAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TestDate) AS TestDate,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientAboRh

	JOIN dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientAboRh.ExceptionTypeId
	
	WHERE
		PatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientAboRhForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAntigenDiscrepancy]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets QC Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/26/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientAntigenDiscrepancy]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionPatientAntigenDiscrepancyGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		ReagentName,
		ReagentTypeName,
		LotNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LotExpirationDate) AS LotExpirationDate,
		ReagentManufacturerName,
		HistoricSpecimenTestResults,
		CurrentSpecimenTestResults,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientAntigenDiscrepancy

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientAntigenDiscrepancy.ExceptionTypeId

	WHERE
			DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientAntigenDiscrepancy] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientAntigenDiscrepancyForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets QC Exception Report data (Multi-divisional)
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientAntigenDiscrepancyForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionPatientAntigenDiscrepancyGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		ReagentName,
		ReagentTypeName,
		LotNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LotExpirationDate) AS LotExpirationDate,
		ReagentManufacturerName,
		HistoricSpecimenTestResults,
		CurrentSpecimenTestResults,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientAntigenDiscrepancy

	JOIN dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientAntigenDiscrepancy.ExceptionTypeId
	
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientAntigenDiscrepancyForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientRestriction]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data for directed/restricted blood units and corresponding patients
**
**	Author:	David Askew
**
**	Date: 	1/27/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientRestriction]
(
	@divisioncode	VARCHAR(50),
	@startdate	DATETIME,
	@enddate	DATETIME
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		EPR.ExceptionPatientRestrictionGuid,      
		EPR.ExceptionTypeId, 
		ExceptionType.ExceptionTypeName,
		EPR.UnitId,        
		EPR.UnitGuid,                             
		EPR.UnitAboRh,  
		EPR.ProductShortName,                                   
		EPR.ProductCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EPR.UnitExpirationDate) AS UnitExpirationDate,                                        
		EPR.SpecialTesting,                                     
		EPR.DonationType,                                       
		EPR.RestrictedPatientName,                                        
		EPR.RestrictedPatientId,            
		EPR.RestrictedPatientGuid,                
		EPR.ExceptionUser,                  
		EPR.ExceptionComment,                                                                                                                                                                                                                                                
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EPR.ExceptionDate) AS ExceptionDate,                                          
		EPR.DivisionCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EPR.LastUpdateDate) AS LastUpdateDate,                                                    
		EPR.LastUpdateUser 

	FROM
		dbo.ExceptionPatientRestriction EPR

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = EPR.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientRestriction] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientRestrictionForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data for directed/restricted blood units for a single patient (multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	02/08/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientRestrictionForPatient]
(
	@divisioncode	VARCHAR(50),
	@patientguid	UNIQUEIDENTIFIER
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		EPR.ExceptionPatientRestrictionGuid,      
		EPR.ExceptionTypeId, 
		ExceptionType.ExceptionTypeName,
		EPR.UnitId,        
		EPR.UnitGuid,                             
		EPR.UnitAboRh,  
		EPR.ProductShortName,                                   
		EPR.ProductCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EPR.UnitExpirationDate) AS UnitExpirationDate,                                        
		EPR.SpecialTesting,                                     
		EPR.DonationType,                                       
		EPR.RestrictedPatientName,                                        
		EPR.RestrictedPatientId,            
		EPR.RestrictedPatientGuid,                
		EPR.ExceptionUser,                  
		EPR.ExceptionComment,                                                                                                                                                                                                                                                
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EPR.ExceptionDate) AS ExceptionDate,                                          
		EPR.DivisionCode, 
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, EPR.LastUpdateDate) AS LastUpdateDate,                                                    
		EPR.LastUpdateUser 

	FROM
		dbo.ExceptionPatientRestriction EPR
	JOIN 
		dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = EPR.ExceptionTypeId
	WHERE
		RestrictedPatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)
	ORDER BY 
		ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF
		
RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientRestrictionForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTest]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	11/29/2004	C. Taylor		Added PatientGuid to WHERE clause, to filter out BR_41.26 exceptions
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientTest]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionPatientTestGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		TestName,
		TestInterp,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TestDate) AS TestDate,
		ReactivityPhase,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientTest

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientTest.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	AND	 PatientGuid IS NOT NULL

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientTest] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTestForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientTestForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionPatientTestGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		TestName,
		TestInterp,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TestDate) AS TestDate,
		ReactivityPhase,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientTest

	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientTest.ExceptionTypeId
	
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientTestForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTestInactivated]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientTestInactivated]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionPatientTestInactivatedGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		TestName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, InactivationDate) AS InactivationDate,
		CurrentTechName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientTestInactivated

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientTestInactivated.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

		RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientTestInactivated] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportPatientTestInactivatedForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportPatientTestInactivatedForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionPatientTestInactivatedGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		TestName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, InactivationDate) AS InactivationDate,
		CurrentTechName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionPatientTestInactivated

	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionPatientTestInactivated.ExceptionTypeId
	
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportPatientTestInactivatedForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets QC Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/26/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	N. Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	12/29/2005 	D. Askew	Removed ExceptionQcGuid - not used in report
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQC]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT DISTINCT
		ExceptionType.ExceptionTypeName,
		ReagentName,
		LotNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LotExpirationDate) AS LotExpirationDate,
		ReagentManufacturerName,
		ReagentTypeName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		RackName,
		PreviousResult,
		CurrentResult,
		ReactivityPhase,
		TestingTechName
	FROM
		dbo.ExceptionQc

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQc.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

		RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQC] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets QC Exception Report data for a Blood Unit Guid
**
**	Author:	David Askew
**
**	Date: 	12/15/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	12/29/2005 	D. Askew	Removed ExceptionQcGuid - not used in report
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQcForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionType.ExceptionTypeName,
		ReagentName,
		LotNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LotExpirationDate) AS LotExpirationDate,
		ReagentManufacturerName,
		ReagentTypeName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		RackName,
		PreviousResult,
		CurrentResult,
		ReactivityPhase,
		TestingTechName
	FROM
		dbo.ExceptionQc

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQc.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

		AND BloodUnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

		RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQcForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets QC Exception Report data for a Patient Guid
**
**	Author:	Cameron Taylor
**
**	Date: 	12/29/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQcForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionQcGuid,
		ExceptionType.ExceptionTypeName,
		ReagentName,
		LotNumber,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LotExpirationDate) AS LotExpirationDate,
		ReagentManufacturerName,
		ReagentTypeName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		RackName,
		PreviousResult,
		CurrentResult,
		ReactivityPhase,
		TestingTechName
	FROM
		dbo.ExceptionQc

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQc.ExceptionTypeId

	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQcForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQCInactivated]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQCInactivated]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		CAST(dbo.ExceptionQcInactivation.ExceptionQcInactivationGuid AS VARCHAR(50)) AS ExceptionQcInactivationGuid, -- for use in Crystal as a group header
		dbo.ExceptionType.ExceptionTypeName,
		dbo.ExceptionQcInactivation.ExceptionComment,
		dbo.ExceptionQcInactivation.ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionQcInactivation.ExceptionDate) AS ExceptionDate,
		dbo.ExceptionQcInactivation.ReagentRack,
		dbo.ExceptionQcInactivation.TestingTechName,
		dbo.ExceptionQcInactivationReagent.ReagentTypeName,
		dbo.ExceptionQcInactivationReagent.TestWithName,
		dbo.ExceptionQcInactivationReagent.IsResult,
		dbo.ExceptionQcInactivationReagent.IatResult,
		dbo.ExceptionQcInactivationReagent.CcResult
	FROM
		dbo.ExceptionQcInactivation

	JOIN dbo.ExceptionType ON 
		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQcInactivation.ExceptionTypeId

	LEFT JOIN dbo.ExceptionQcInactivationReagent ON 
		dbo.ExceptionQcInactivationReagent.ExceptionQcInactivationGuid = dbo.ExceptionQcInactivation.ExceptionQcInactivationGuid

	LEFT JOIN dbo.ReagentType ON 
		dbo.ReagentType.ReagentTypeName = dbo.ExceptionQcInactivationReagent.ReagentTypeName COLLATE database_default

	
	WHERE
		dbo.ExceptionQcInactivation.DivisionCode = @divisioncode

	AND dbo.ExceptionQcInactivation.ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY dbo.ExceptionQcInactivation.ExceptionDate DESC, ReagentType.SortColumn

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

		RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQCInactivated] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcNotPerformed]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	04/23/2005	Lohse		Adding UnitId, ProductCode
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQcNotPerformed]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0

	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionQcNotPerformedGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		RackName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName,
		UnitId,
		ProductCode
	FROM
		dbo.ExceptionQcNotPerformed

	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQcNotPerformed.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQcNotPerformed] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQcNotPerformedForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date				Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQcNotPerformedForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionQcNotPerformedGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		RackName,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionQcNotPerformed

	JOIN dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQcNotPerformed.ExceptionTypeId
	
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQcNotPerformedForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQuarantine]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQuarantine]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0

	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionQuarantineGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		UnitID,
		UnitProductType,
		UnitProductCode,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		UnitAntigenTypingResult,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionQuarantine

		JOIN dbo.ExceptionType ON 
			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQuarantine.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

		RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQuarantine] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQuarantineForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQuarantineForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionQuarantineGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		UnitID,
		UnitProductType,
		UnitProductCode,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		UnitAntigenTypingResult,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionQuarantine
		JOIN dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQuarantine.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode
	AND	UnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQuarantineForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportQuarantineForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date				Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportQuarantineForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionQuarantineGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		UnitID,
		UnitProductType,
		UnitProductCode,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		UnitAntigenTypingResult,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionQuarantine

	JOIN dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionQuarantine.ExceptionTypeId
	
	WHERE
		PatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportQuarantineForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReflexTest]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportReflexTest]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionReflexTestGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenExpirationDate) AS SpecimenExpirationDate,
		TestOrdered,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionReflexTest

	JOIN dbo.ExceptionType 

		ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionReflexTest.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportReflexTest] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReflexTestForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date				Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**						Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportReflexTestForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionReflexTestGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		SpecimenUID,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenExpirationDate) AS SpecimenExpirationDate,
		TestOrdered,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionReflexTest

	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionReflexTest.ExceptionTypeId
	
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportReflexTestForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportRemoveFinalUnitStatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Cameron Taylor	
**
**	Date: 	06/03/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	06/29/2005	C. Taylor	Added new columns for removal of unit modification
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportRemoveFinalUnitStatus]
(
	@startdate		DATETIME,
	@enddate		DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionRemoveFinalUnitStatusGuid,
		ExceptionType.ExceptionTypeName,
		UnitGuid,
		UnitId, 
		UnitAboRh,
		PreviousUnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PreviousUnitExpirationDate) AS PreviousUnitExpirationDate,
		PreviousUnitStatus,
		PreviousUnitVolume,
		CurrentUnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CurrentUnitExpirationDate) AS CurrentUnitExpirationDate,
		CurrentUnitStatus,
		CurrentUnitVolume,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionRemoveFinalUnitStatus

	JOIN 
		dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionRemoveFinalUnitStatus.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportRemoveFinalUnitStatus] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportRemoveFinalUnitStatusForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Cameron Taylor	
**
**	Date: 	06/03/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	06/29/2005	C. Taylor	Added new columns for removal of unit modification
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportRemoveFinalUnitStatusForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionRemoveFinalUnitStatusGuid,
		ExceptionType.ExceptionTypeName,
		UnitGuid,
		UnitId, 
		UnitAboRh,
		PreviousUnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PreviousUnitExpirationDate) AS PreviousUnitExpirationDate,
		PreviousUnitStatus,
		PreviousUnitVolume,
		CurrentUnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, CurrentUnitExpirationDate) AS CurrentUnitExpirationDate,
		CurrentUnitStatus,
		CurrentUnitVolume,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionRemoveFinalUnitStatus
	JOIN 
		dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionRemoveFinalUnitStatus.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode
	AND	UnitGuid = @bloodunitguid
	
	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR
SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportRemoveFinalUnitStatusForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReturnIssuedUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Margaret Jablonski	
**
**	Date: 	06/22/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportReturnIssuedUnit]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionReturnedUnitGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId, 
		PatientAboRh,
		ReturnedUnitId,
		ReturnedUnitProductShortName,
		ReturnedUnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ReturnedUnitExpirationDate) AS ReturnedUnitExpirationDate,
		IssueToLocation,
		VisualInspectionIndicator,
		ProcessingTechName,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionReturnedUnit

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionReturnedUnit.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportReturnIssuedUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReturnIssuedUnitForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Margaret Jablonski	
**
**	Date: 	06/22/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportReturnIssuedUnitForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionReturnedUnitGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId, 
		PatientAboRh,
		ReturnedUnitId,
		ReturnedUnitProductShortName,
		ReturnedUnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ReturnedUnitExpirationDate) AS ReturnedUnitExpirationDate,
		IssueToLocation,
		VisualInspectionIndicator,
		ProcessingTechName,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionReturnedUnit

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionReturnedUnit.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode
	AND	ReturnedUnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportReturnIssuedUnitForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportReturnIssuedUnitForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor	
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportReturnIssuedUnitForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionReturnedUnitGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId, 
		PatientAboRh,
		ReturnedUnitId,
		ReturnedUnitProductShortName,
		ReturnedUnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ReturnedUnitExpirationDate) AS ReturnedUnitExpirationDate,
		IssueToLocation,
		VisualInspectionIndicator,
		ProcessingTechName,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionReturnedUnit
		
	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionReturnedUnit.ExceptionTypeId
	
	WHERE
		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportReturnIssuedUnitForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportSpecimen]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	04/04/2006	Lohse		Adding DateTimeConversion to LastTransfusionDateTime & DateOrderAccepted 
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportSpecimen]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionSpecimenGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientAntibodies,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LastTransfusionDateTime) AS LastTransfusionDateTime,
		SpecimenUID,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenExpirationDate) AS SpecimenExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExtendedExpirationDate) AS ExtendedExpirationDate,
		ComponentClassOrdered,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateWanted) AS DateWanted,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateOrderAccepted) AS DateOrderAccepted,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionSpecimen

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionSpecimen.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportSpecimen] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportSpecimenForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date				Name			Description

**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted. Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	04/04/2006	Lohse		Adding DateTimeConversion to LastTransfusionDateTime & DateOrderAccepted
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportSpecimenForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionSpecimenGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientAntibodies,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, LastTransfusionDateTime) AS LastTransfusionDateTime,
		SpecimenUID,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SpecimenExpirationDate) AS SpecimenExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExtendedExpirationDate) AS ExtendedExpirationDate,
		ComponentClassOrdered,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateWanted) AS DateWanted,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DateOrderAccepted) AS DateOrderAccepted,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM
		dbo.ExceptionSpecimen

	JOIN dbo.ExceptionType ON dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionSpecimen.ExceptionTypeId
	
	WHERE
		PatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportSpecimenForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusion]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Cameron Taylor	
**
**	Date: 	12/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description

**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportTransfusion]
(
	@startdate		DATETIME,
	@enddate		DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionTransfusionGuid,
		ExceptionType.ExceptionTypeName,
		TransfusedPatientName,
		TransfusedPatientId, 
		TransfusedPatientAboRh,
		UnitId,
		UnitProductType,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTransfusion

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTransfusion.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportTransfusion] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Cameron Taylor	
**
**	Date: 	12/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description

**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportTransfusionForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionTransfusionGuid,
		ExceptionType.ExceptionTypeName,
		TransfusedPatientName,
		TransfusedPatientId, 
		TransfusedPatientAboRh,
		UnitId,
		UnitProductType,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTransfusion

		JOIN dbo.ExceptionType ON 

				dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTransfusion.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode
	AND	UnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportTransfusionForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor	
**
**	Date: 	12/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description

**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportTransfusionForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionTransfusionGuid,
		ExceptionType.ExceptionTypeName,
		TransfusedPatientName,
		TransfusedPatientId, 
		TransfusedPatientAboRh,
		UnitId,
		UnitProductType,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTransfusion

		JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTransfusion.ExceptionTypeId
	WHERE
		TransfusedPatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportTransfusionForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionReactionWorkup]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Cameron Taylor
**
**	Date: 	11/24/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	04/04/2006	Lohse		Adding DateTimeConversion to UnitExpirationDate
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportTransfusionReactionWorkup]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionTransfusionReactionWorkupGuid,
		ExceptionType.ExceptionTypeName,
		UnitId,
		UnitAboRh,
		ProductCode,
		ProductShortName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) as UnitExpirationDate,
		UnitDonationType,
		TrwPatientName,
		TrwPatientId,
		AssignedPatientName,
		AssignedPatientId,
		ClericalCheckFailed,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, IssueDate) as IssueDate,
		IssueTechId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TrwDate) AS TrwDate,
		TrwTechId,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTransfusionReactionWorkup

	JOIN 
		dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTransfusionReactionWorkup.ExceptionTypeId
	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportTransfusionReactionWorkup] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTransfusionReactionWorkupForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	11/24/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	04/04/2006	Lohse		Adding DateTimeConversion to UnitExpirationDate
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportTransfusionReactionWorkupForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionTransfusionReactionWorkupGuid,
		ExceptionType.ExceptionTypeName,
		UnitId,
		UnitAboRh,
		ProductCode,
		ProductShortName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) as UnitExpirationDate,
		UnitDonationType,
		TrwPatientName,
		TrwPatientId,
		AssignedPatientName,
		AssignedPatientId,
		ClericalCheckFailed,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, IssueDate) as IssueDate,
		IssueTechId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TrwDate) AS TrwDate,
		TrwTechId,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTransfusionReactionWorkup

	JOIN 
		dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTransfusionReactionWorkup.ExceptionTypeId

	WHERE
		TrwPatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)
	OR	
		AssignedPatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportTransfusionReactionWorkupForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTrwSpecimen]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Cameron Taylor
**
**	Date: 	11/23/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description

**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportTrwSpecimen]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionTrwSpecimenGuid,
		ExceptionType.ExceptionTypeName,
		TrwPatientName,
		TrwPatientId,
		SpecimenUid,
		SpecimenPatientName,
		SpecimenPatientId,
		ClericalCheckFailed,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TrwDate) AS TrwDate,
		TrwTechId,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTrwSpecimen

	JOIN 
		dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTrwSpecimen.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF
	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportTrwSpecimen] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportTrwSpecimenForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	11/24/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportTrwSpecimenForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0


SET NOCOUNT ON

	SELECT
		ExceptionTrwSpecimenGuid,
		ExceptionType.ExceptionTypeName,
		TrwPatientName,
		TrwPatientId,
		SpecimenUid,
		SpecimenPatientName,
		SpecimenPatientId,
		ClericalCheckFailed,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, TrwDate) AS TrwDate,
		TrwTechId,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM
		dbo.ExceptionTrwSpecimen

	JOIN 
		dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionTrwSpecimen.ExceptionTypeId

	WHERE

		TrwPatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	OR	
		SpecimenPatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportTrwSpecimenForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitAboRh]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitAboRh]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionUnitAboRhGuid,
		ExceptionType.ExceptionTypeName,
		UnitID,
		UnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		LoginUnitABORh,
		UnitAboRhInterp,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM

		dbo.ExceptionUnitAboRh

	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionUnitAboRh.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitAboRh] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitAboRhForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitAboRhForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionUnitAboRhGuid,
		ExceptionType.ExceptionTypeName,
		UnitID,
		UnitProductType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		LoginUnitABORh,
		UnitAboRhInterp,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM

		dbo.ExceptionUnitAboRh

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionUnitAboRh.ExceptionTypeId

	WHERE
		DivisionCode = @divisioncode

	AND	UnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitAboRhForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitIssue]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data related to the issuance of units
**
**	Author:	Carl Jensen
**
**	Date: 	1/25/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	11/14/2005	Lohse		ExceptionUnitIssue''s column Unit_AboRh column renamed to UnitAboRh
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitIssue]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionUnitIssueGuid,
		EUI.ExceptionTypeId,
		ET.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientGuid,
		HistoricAboRh,
		TechAboRh,
		SystemAboRh,
		PatientAntibodies,
		PatientTransfusionRequirements,
		SpecimenUid,
		UnitId,
		UnitGuid,
		UnitProductType,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		UnitAntigens,
		Unitdonationtype,
		UnitTestingEntry,
		OrderIndicator,
		OrderedBy,
		IssuedToLocation,
		TransporterName,
		IssuingTechName,
		LoginTechName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, IssueDateTime) AS IssueDateTime,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		DivisionCode

	FROM

		dbo.ExceptionUnitIssue EUI

		JOIN dbo.ExceptionType ET ON 

			ET.ExceptionTypeId = EUI.ExceptionTypeId

	WHERE

		DivisionCode = @divisioncode


	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF


	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitIssue] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitIssueForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data related to the issuance of units for a single patient (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	1/27/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	11/14/2005	Lohse		ExceptionUnitIssue''s column Unit_AboRh column renamed to UnitAboRh
**	01/22/2006	M Smith		** Reviewed for compliance with database standards and recommendations **
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitIssueForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionUnitIssueGuid,
		EUI.ExceptionTypeId,
		ET.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientGuid,
		HistoricAboRh,
		TechAboRh,
		SystemAboRh,
		PatientAntibodies,
		PatientTransfusionRequirements,
		SpecimenUid,
		UnitId,
		UnitGuid,
		UnitProductType,
		UnitAboRh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		UnitAntigens,
		Unitdonationtype,
		UnitTestingEntry,
		OrderIndicator,
		OrderedBy,
		IssuedToLocation,
		TransporterName,
		IssuingTechName,
		LoginTechName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, IssueDateTime) AS IssueDateTime,
		ExceptionUser,
		ExceptionComment,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		DivisionCode
	FROM

		dbo.ExceptionUnitIssue EUI

	JOIN 

		dbo.ExceptionType ET ON 

			ET.ExceptionTypeId = EUI.ExceptionTypeId

	WHERE

		PatientGuid IN 
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY 
		ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitIssueForPatient] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitModification]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT,Specified table owners, Added error checks
**	02/21/2006	Lohse		Adding  ExceptionType.ExceptionTypeId filter to distinguish between Expired Units and Supplies
**	04/10/2006	K. Dobranowski	Added ExceptionTypeId 11 to the query (CR 1697)
**	05/11/2006	D. Askew	Added OR ExceptionType.ExceptionTypeId = 12 to ExceptionType JOIN
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitModification]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionUnitModificationGuid,
		ExceptionType.ExceptionTypeName,
		ModificationType,
		UnitId,
		UnitABORh,
		UnitProductType,
		UnitProductCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ModificationDate) AS ModificationDate,
		ComponentName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, RecommendedExpirationDate) AS RecommendedExpirationDate,
		ModifyingTech,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM

		dbo.ExceptionUnitModification

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionUnitModification.ExceptionTypeId
			AND (ExceptionType.ExceptionTypeId = 10 OR ExceptionType.ExceptionTypeId = 11 OR ExceptionType.ExceptionTypeId = 12)
	
	WHERE

		DivisionCode = @divisioncode

	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF

	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitModification] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitModificationForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	02/21/2006	Lohse		Adding  ExceptionType.ExceptionTypeId filter to distinguish between Expired Units and Supplies
**	04/06/2006 	D. Askew	Added ExceptionTypeId 11 to ExceptionType JOIN
**	05/11/2006	D. Askew	Added OR ExceptionType.ExceptionTypeId = 12 to ExceptionType JOIN
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitModificationForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionUnitModificationGuid,
		ExceptionType.ExceptionTypeName,
		ModificationType,
		UnitId,
		UnitABORh,
		UnitProductType,
		UnitProductCode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ModificationDate) AS ModificationDate,
		ComponentName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, RecommendedExpirationDate) AS RecommendedExpirationDate,
		ModifyingTech,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate
	FROM

		dbo.ExceptionUnitModification

	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionUnitModification.ExceptionTypeId
		AND (ExceptionType.ExceptionTypeId = 10 OR ExceptionType.ExceptionTypeId = 11 OR ExceptionType.ExceptionTypeId = 12)

	WHERE

		DivisionCode = @divisioncode

	AND	UnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitModificationForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSelection]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	03/31/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski	Call fnTimeZoneConversionDateTime function on all dates
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, Added error checks
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitSelection]
(
	@startdate	DATETIME,
	@enddate	DATETIME,
	@divisioncode	VARCHAR(50)
)
AS

SET NOCOUNT ON

DECLARE @ERROR INT

SET @ERROR = 0
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

	SELECT
		ExceptionUnitSelectionGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientCurrentAboRh,
		PatientHistoricalAboRh,
		PatientAntibodies,
		ComponentRequirements,
		AntigenNegativeRequirements,
		UnitID,
		UnitProductType,
		UnitABORh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		AntigenTypingResult,
		DonationType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SelectionDate) AS SelectionDate,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM

		dbo.ExceptionUnitSelection

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionUnitSelection.ExceptionTypeId
	
	WHERE

		DivisionCode = @divisioncode


	AND ExceptionDate BETWEEN @startdate AND @enddate

	ORDER BY ExceptionDate DESC

	SET @ERROR = @@ERROR
		IF @ERROR != 0 GOTO ERR_HANDLER

SET NOCOUNT OFF


	RETURN(0)

ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitSelection] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSelectionForBloodUnit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date				Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitSelectionForBloodUnit]
(
	@bloodunitguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionUnitSelectionGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientCurrentAboRh,
		PatientHistoricalAboRh,
		PatientAntibodies,
		ComponentRequirements,
		AntigenNegativeRequirements,
		UnitID,
		UnitProductType,
		UnitABORh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		AntigenTypingResult,
		DonationType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SelectionDate) AS SelectionDate,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM

		dbo.ExceptionUnitSelection

		JOIN dbo.ExceptionType ON 

			dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionUnitSelection.ExceptionTypeId
	
	WHERE

		UnitGuid = @bloodunitguid

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitSelectionForBloodUnit] TO [VbecsAppUser] AS [dbo]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetExceptionReportUnitSelectionForPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'/*******************************************************************************************************************************************************************************
**	Desc:	Gets Exception Report data (Multi-divisional)
**
**	Author:	Cameron Taylor
**
**	Date: 	09/01/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date				Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/07/2016	K. Adu-Poku	** changed DivisionCode to VARCHAR(50) as per (Defect 210159)
**	04/30/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetExceptionReportUnitSelectionForPatient]
(
	@patientguid	UNIQUEIDENTIFIER,
	@divisioncode	VARCHAR(50)
)
AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT
		ExceptionUnitSelectionGuid,
		ExceptionType.ExceptionTypeName,
		PatientName,
		PatientId,
		PatientCurrentAboRh,
		PatientHistoricalAboRh,
		PatientAntibodies,
		ComponentRequirements,
		AntigenNegativeRequirements,
		UnitID,
		UnitProductType,
		UnitABORh,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS UnitExpirationDate,
		AntigenTypingResult,
		DonationType,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SelectionDate) AS SelectionDate,
		ExceptionComment,
		ExceptionUser,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ExceptionDate) AS ExceptionDate,
		TestingTechName
	FROM

		dbo.ExceptionUnitSelection

	JOIN dbo.ExceptionType ON 

		dbo.ExceptionType.ExceptionTypeId = dbo.ExceptionUnitSelection.ExceptionTypeId
	
	WHERE

		PatientGuid IN
		(
			SELECT 
				P.PatientGuid
			FROM
				dbo.Patient P
			JOIN 
			    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
			WHERE
				LinkPatient.PatientGuid = @patientguid
		)

	ORDER BY ExceptionDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
' 
END
GO

GRANT EXECUTE ON [dbo].[spGetExceptionReportUnitSelectionForPatient] TO [VbecsAppUser] AS [dbo]
GO
