#*********************************************************************************
#  Purpose:  
#            Copy the data file needed by the SQL patch to the SQL server.
#
#  Scope:    Uses a checksum so the file can be shared by multiple servers during patching.
#            File is not removed to prevent concurrency issues.
#
#  Date:     12/04/2017
#
#*********************************************************************************
$ErrorActionPreference = "Stop"

#-----------------------------------------------------------------------
#    STEP 1: Determine the environment (TOKEN replaced by Patch Console)
#
#   Here"s the SQL I used to build the commands.
#   Execute this against a patch database..
#
#   FOR TEST COMMANDS
#     select '	'"' + appip + '"' {$bulkLoadFile += "' + vnnip + '"}' from vwEnvironmentsWithAllData 
#      where isprod = 0
#      order by vnnip, appip
#
#   FOR PROD COMMANDS
#     select '	'"' + appip + '"' {$bulkLoadFile += "' + vnnip + '"}' from vwEnvironmentsWithAllData 
#      where isprod = 1
#      order by vnnip, appip
#
#-----------------------------------------------------------------------

$bulkLoadFile = "\\"


if ("@ENVIRONMENT@" -eq "TEST")
{
  switch ("@APPSERVERIP@")
  {
	"IP          " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP            " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
  }
}
else
{
  switch("@APPSERVERIP@")
  {
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP          " {$bulkLoadFile += "IP           "}
	"IP          " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP           " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP          " {$bulkLoadFile += "IP           "}
	"IP          " {$bulkLoadFile += "IP           "}
	"IP          " {$bulkLoadFile += "IP           "}
	"IP          " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP            " {$bulkLoadFile += "IP           "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP          " {$bulkLoadFile += "IP          "}
	"IP           " {$bulkLoadFile += "IP          "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
	"IP        " {$bulkLoadFile += "IP        "}
   }
}

#-----------------------------------------------------------------------
#    STEP 2: Create the SQL target folder if it doesn't exist
#-----------------------------------------------------------------------
$bulkLoadFile += "\h$\temppatch2301"

#CREATE THE FOLDER IF NEEDED
if (-not (Test-Path $bulkLoadFile))
{
      New-Item $bulkLoadFile -type directory | Out-Null;
}

$bulkLoadFile += "\PMTMData.txt";

 
#-----------------------------------------------------------------------
#    STEP 3: If the file doesn"t exist, copy it over.
#-----------------------------------------------------------------------

$goldDataFile = "\\SERVER\VBECS Software\Dev\PMTMData.txt";

if (-not (Test-Path $bulkLoadFile))
{
   Copy-Item $goldDataFile $bulkLoadFile;
}

#-----------------------------------------------------------------------
#    STEP 4: Verify the checksum
#-----------------------------------------------------------------------
$dataChecksum = certutil -hashfile $bulkLoadFile MD5
if (-not ($dataChecksum -eq "7c e3 6c c4 b1 84 a7 c7 2c 98 30 7a 4b c9 7a f8"))
{
   Write-Host "Checksum failed for {$bulkLoadFile} ";
   exit 1;
}


#-----------------------------------------------------------------------
#    STEP 5: Get out
#-----------------------------------------------------------------------
exit 0;



trap
{
   Write-Host -foreground red $_.Exception.Message; 
   exit 1;
}