--VBECS 2.3.0.1 and VBECS 2.3.0.1 combined script


--VBECS 2.3.0.1 SQL Script

/*****************************************************************************************
   SCRIPT NOTES

TOKENS CONTAINED IN THIS SCRIPT

@DBNAME@  - replaced this with the name of the VBECS database e.g. VBECS_TS1_TEST
@PATCHUSERID@  - replaced with the windows login ID of the user running the script
@TARGETVERSION@ - replaced with the target build number e.g., 2.3.0.1
*****************************************************************************************/



--VBECS Admin changes (Defect 340457)

USE @DBNAME@
GO

--Interface

/*****************************************************************************************
   Create a temporary Interface table and save the original data
*****************************************************************************************/
IF OBJECT_ID(N'tempdb..#Interface') IS NOT NULL
	DROP TABLE #Interface
GO

CREATE TABLE dbo.#Interface
	(
	[InterfaceId] [tinyint]  NOT NULL,
	[InterfaceName] [varchar](50) NOT NULL,
	[FieldSeparator] [char](1) NOT NULL,
	[EncodingCharacters] [char](4) NOT NULL,
	[InterfaceApplicationId] [varchar](50) NOT NULL,
	[VbecsApplicationId] [varchar](50) NOT NULL,
	[VersionId] [varchar](8) NOT NULL,
	[ApplicationAckType] [char](2) NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
	)  ON [PRIMARY]
GO

INSERT INTO #Interface 
	(InterfaceId, InterfaceName, FieldSeparator, EncodingCharacters, InterfaceApplicationId, VbecsApplicationId, VersionId,
	 ApplicationAckType, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)
SELECT 	 InterfaceId, InterfaceName, FieldSeparator, EncodingCharacters, InterfaceApplicationId, VbecsApplicationId, VersionId,
	 ApplicationAckType, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId
  FROM dbo.Interface
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_InterfaceControl_Interface]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [FK_InterfaceControl_Interface]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.Interface') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.Interface
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[Interface](
	[InterfaceId] [tinyint] IDENTITY(1,1) NOT NULL,
	[VbecsEndPointId] [int] NULL,
	[InterfaceName] [varchar](50) NOT NULL,
	[FieldSeparator] [char](1) NOT NULL,
	[EncodingCharacters] [char](4) NOT NULL,
	[InterfaceApplicationId] [varchar](50) NOT NULL,
	[VbecsApplicationId] [varchar](50) NOT NULL,
	[VersionId] [varchar](8) NOT NULL,
	[ApplicationAckType] [char](2) NULL,
	[ApplicationName] [varchar] (100) NULL,
	[ConfigPrefix] [varchar] (100) NULL,
	[ProcessingId] [char] (1) NULL,
	[PurgeSuccessfulMessage] [tinyint]  NULL,
	[PurgeUnSuccessfulMessage] [tinyint]  NULL,
	[LogEventsIndicator] [bit]  NULL CONSTRAINT [DF_Interface_LogEventsIndicator]  DEFAULT (0),
	[VbecsFacilityId] [varchar] (20) NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL CONSTRAINT [DF_Interface_LastUpdateFunctionId]  DEFAULT (0),
 CONSTRAINT [PK_Interface] PRIMARY KEY CLUSTERED 
(
	[InterfaceId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO



EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific interface in VBECS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'InterfaceId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific interface in VBECS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'VbecsEndPointId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the interface. [for example: CPRS]' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'InterfaceName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Defines the character to be used as a separator for the message.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'FieldSeparator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This field contains the four characters in the following order: the component separator, repetition separator, escape character, and subcomponent separator.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'EncodingCharacters'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Uniquely identifies the sending application.  In the case of an OMG_O19 message generated from CPRS, this field would be defined as OERR.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'InterfaceApplicationId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Uniquely identifies the receiving application.  In the case of an ORM message generated from CPRS, this field would be defined as VBECS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'VbecsApplicationId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This field is matched by the receiving system to its own version to be sure the message will be interpreted correctly.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'VersionId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This field identifies the conditions under which accept acknowledgments are required to be returned in response to this message.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'ApplicationAckType'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates the name of the application/project associated with this interface. Along with the [ConfigPrefix] field, this can be used to join to the [VbecsGlobalConfig] table to find additional configuration values associated with the interface.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'ApplicationName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The prefix used in conjunction with a  setting to create a unique ParameterName entry on the VbecsGlobalConfig table for the interface (e.g. ConfigPrefix = ''Interface_CPRS'' and Setting = ''IsActive'' creates a ParameterName = ''Interface_CPRS_IsActive'')' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'ConfigPrefix'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The interface will only accept HL7 messages containing the same ProcessingID configure in the HL7 Site Parameters menu.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'ProcessingId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Specifies number of days to wait before deleting successful HL7 messages.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'PurgeSuccessfulMessage'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Specifies number of days to wait before deleting unsuccessful HL7 messages.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'PurgeUnSuccessfulMessage'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the interface will enter events in the event log.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'LogEventsIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A descriptor of the Receiving Application field in MSH segments (e.g. VBECS).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'VbecsFacilityId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time the record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the user who performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Interface', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO

SET IDENTITY_INSERT dbo.Interface ON
INSERT INTO Interface 
	(InterfaceId, InterfaceName, FieldSeparator, EncodingCharacters, InterfaceApplicationId, VbecsApplicationId, VersionId,
	 ApplicationAckType, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)
SELECT 	 InterfaceId, InterfaceName, FieldSeparator, EncodingCharacters, InterfaceApplicationId, VbecsApplicationId, VersionId,
	 ApplicationAckType, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId
  FROM dbo.#Interface
GO

SET IDENTITY_INSERT dbo.Interface OFF

ALTER TABLE [dbo].[InterfaceControl]  WITH CHECK ADD  CONSTRAINT [FK_InterfaceControl_Interface] FOREIGN KEY([InterfaceId])
REFERENCES [dbo].[Interface] ([InterfaceId])
GO

ALTER TABLE [dbo].[InterfaceControl] CHECK CONSTRAINT [FK_InterfaceControl_Interface]
GO

DROP TABLE #Interface


GRANT SELECT ON  [dbo].[Interface] TO [VbecsAppUser]
GO



--MessageLog and MessageType table changes for InterfaceControlId references

ALTER TABLE [dbo].[MessageLog] DROP CONSTRAINT [FK_MessageLog_InterfaceControl]
GO
DROP INDEX [IX_MessageLog_InterfaceControlId] ON [dbo].[MessageLog]
GO

ALTER TABLE dbo.MessageLog
ALTER COLUMN InterfaceControlId tinyint NOT NULL
GO

sp_RENAME 'MessageLog.InterfaceControlId', 'InterfaceId' , 'COLUMN'
GO 


ALTER TABLE [dbo].[MessageLog]  WITH CHECK ADD  CONSTRAINT [FK_MessageLog_Interface] FOREIGN KEY([InterfaceId])
REFERENCES [dbo].[Interface] ([InterfaceId])
GO

ALTER TABLE [dbo].[MessageLog] CHECK CONSTRAINT [FK_MessageLog_Interface]
GO

CREATE NONCLUSTERED INDEX [IX_MessageLog_InterfaceId] ON [dbo].[MessageLog]
(
	[InterfaceId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO



ALTER TABLE [dbo].[MessageType] DROP CONSTRAINT [FK_MessageType_InterfaceControl]
GO
DROP INDEX [IX_MessageType_InterfaceControlId] ON [dbo].[MessageType]
GO


ALTER TABLE dbo.MessageType
ALTER COLUMN InterfaceControlId tinyint NOT NULL
GO

sp_RENAME 'MessageType.InterfaceControlId', 'InterfaceId' , 'COLUMN'
GO 


ALTER TABLE [dbo].[MessageType]  WITH NOCHECK ADD  CONSTRAINT [FK_MessageType_Interface] FOREIGN KEY([InterfaceId])
REFERENCES [dbo].[Interface] ([InterfaceId])
GO

ALTER TABLE [dbo].[MessageType] CHECK CONSTRAINT [FK_MessageType_Interface]
GO

CREATE NONCLUSTERED INDEX [IX_MessageType_InterfaceId] ON [dbo].[MessageType]
(
	[InterfaceId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO





--VbecsGlobalConfig

USE @DBNAME@_MIRROR
GO


/**********************************************
   Create the new VbecsGlobalConfig mirror table
**********************************************/
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[VbecsGlobalConfig]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	DROP TABLE dbo.VbecsGlobalConfig
GO

/****** Object:  Table [dbo].[VbecsGlobalConfig]    Script Date: 8/30/2016 8:50:15 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[VbecsGlobalConfig](
	[MirrorId]  [int] IDENTITY(1,1) NOT NULL,
	[ApplicationName] [varchar](100) NOT NULL,
	[ParameterName] [varchar](100) NOT NULL,
	[ParameterValue] [varchar](1000) NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [binary](8) NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
	[MirrorDate] [datetime] NOT NULL,
 CONSTRAINT [PK_VbecsGlobalConfig] PRIMARY KEY NONCLUSTERED 
(
	[MirrorId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'Syn_VbecsGlobalConfig') 
DROP SYNONYM dbo.[Syn_VbecsGlobalConfig]
GO

CREATE SYNONYM [dbo].[Syn_VbecsGlobalConfig] FOR [@DBNAME@].[dbo].[VbecsGlobalConfig]
GO

/*---------------------------------------------------------
  Create the VbecsGlobalConfig view in the Mirror database
  (now that both mirror/non-mirror are updated)
---------------------------------------------------------*/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_VbecsGlobalConfig]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.V_VbecsGlobalConfig
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****************************************************************************************************************************************************************
**	Name: 	V_VbecsGlobalConfig
**
**	Desc: 	Returns data in VbecsGlobalConfig table (main and mirror) (Defect 340457).
**
**	Author:	Kwame Adu-Poku
**
**	Date: 	09/19/2016
**
******************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------	---------	------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************************************************************/

CREATE VIEW V_VbecsGlobalConfig
AS 
SELECT Source='MIRROR', MirrorId, ApplicationName, ParameterName, ParameterValue, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, MirrorDate
FROM dbo.VbecsGlobalConfig
UNION ALL 
SELECT Source='ACTIVE', 0, ApplicationName, ParameterName, ParameterValue, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, LastUpdateDate AS MirrorDate 
FROM Syn_VbecsGlobalConfig
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

--Permissions

GRANT SELECT, INSERT ON dbo.VbecsGlobalConfig TO VbecsAppMirrorUser
GO

GRANT SELECT ON dbo.V_VbecsGlobalConfig TO VbecsAppMirrorUser
GO

USE @DBNAME@
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trUpdateVbecsGlobalConfig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trUpdateVbecsGlobalConfig]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trUpdateVbecsGlobalConfig2]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trUpdateVbecsGlobalConfig2]
GO


--Create Synonyms
IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'SynMirror_VbecsGlobalConfig') 
DROP SYNONYM dbo.[SynMirror_VbecsGlobalConfig]
GO

CREATE SYNONYM [dbo].[SynMirror_VbecsGlobalConfig] FOR [@DBNAME@_MIRROR].[dbo].[VbecsGlobalConfig]
GO

IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'SynMirror_V_VbecsGlobalConfig') 
DROP SYNONYM dbo.[SynMirror_V_VbecsGlobalConfig]
GO

CREATE SYNONYM [dbo].[SynMirror_V_VbecsGlobalConfig] FOR [@DBNAME@_MIRROR].[dbo].[V_VbecsGlobalConfig]
GO


--Create Trigger

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trMirrorVbecsGlobalConfig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trMirrorVbecsGlobalConfig]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[trMirrorVbecsGlobalConfig]
ON [dbo].[VbecsGlobalConfig]
FOR UPDATE 
AS 
BEGIN
	INSERT INTO [dbo].[SynMirror_VbecsGlobalConfig]
	SELECT *, GETUTCDATE()
	FROM DELETED
END



GO


--VbecsEndPoint

USE @DBNAME@_MIRROR
GO


/**********************************************
   Create the new VbecsEndPoint mirror table
**********************************************/
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[VbecsEndPoint]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	DROP TABLE dbo.VbecsEndPoint
GO

/****** Object:  Table [dbo].[VbecsEndPoint]    Script Date: 8/30/2016 8:50:15 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[VbecsEndPoint](
	[MirrorId]  [int] IDENTITY(1,1) NOT NULL,
	[VbecsEndPointId] [int]  NOT NULL,
	[EndPointAddress] [varchar](255) NULL,
	[EndPointPort] [int] NULL,
	[EndPointType] [varchar](50) NOT NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [binary](8) NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
	[MirrorDate] [datetime] NOT NULL,
 CONSTRAINT [PK_VbecsEndPoint] PRIMARY KEY NONCLUSTERED 
(
	[MirrorId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'Syn_VbecsEndPoint') 
DROP SYNONYM dbo.[Syn_VbecsEndPoint]
GO

CREATE SYNONYM [dbo].[Syn_VbecsEndPoint] FOR [@DBNAME@].[dbo].[VbecsEndPoint]
GO


--Permissions

GRANT SELECT, INSERT ON dbo.VbecsEndPoint TO VbecsAppMirrorUser
GO



USE @DBNAME@
GO


--VbecsEndPoint

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[VbecsEndPoint]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	DROP TABLE dbo.VbecsEndPoint
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[VbecsEndPoint](
	[VbecsEndPointId] [int] IDENTITY(1,1) NOT NULL,
	[EndPointAddress] [varchar](255) NULL,
	[EndPointPort] [int] NULL,
	[EndPointType] [varchar](50) NULL,
	[LastUpdateDate] datetime NOT NULL,
	[LastUpdateUser] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
    [RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
	 CONSTRAINT [PK_VbecsEndPoint] PRIMARY KEY CLUSTERED 
(
	[VbecsEndPointId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


ALTER TABLE [dbo].[VbecsEndPoint] ADD  CONSTRAINT [DF_VbecsEndPoint_LastUpdateFunctionId]  DEFAULT (0) FOR [LastUpdateFunctionId]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique identifier for the VbecsEndPoint record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'VbecsEndPointId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Network TCP/IP Address or Server Name for the endpoint' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'EndPointAddress'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Network TCP/IP Port Number for the endpoint.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'EndPointPort'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of endpoint (IPAddress, IPv6Address, DnsHostName, AnyLocal)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'EndPointType'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time the record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the user who performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VbecsEndPoint', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO

--Permissions

GRANT SELECT ON  dbo.VbecsEndPoint TO [VbecsAppUser]
GO


--Create Synonyms
IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'SynMirror_VbecsEndPoint') 
DROP SYNONYM dbo.[SynMirror_VbecsEndPoint]
GO

CREATE SYNONYM [dbo].[SynMirror_VbecsEndPoint] FOR [@DBNAME@_MIRROR].[dbo].[VbecsEndPoint]
GO

IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'SynMirror_V_VbecsEndPoint') 
DROP SYNONYM dbo.[SynMirror_V_VbecsEndPoint]
GO

CREATE SYNONYM [dbo].[SynMirror_V_VbecsEndPoint] FOR [@DBNAME@_MIRROR].[dbo].[V_VbecsEndPoint]
GO


USE @DBNAME@_MIRROR
GO
/*---------------------------------------------------------
  Create the VbecsEndPoint view in the Mirror database
  (now that both mirror/non-mirror are updated)
---------------------------------------------------------*/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_VbecsEndPoint]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.V_VbecsEndPoint
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****************************************************************************************************************************************************************
**	Name: 	V_VbecsEndPoint
**
**	Desc: 	Returns data in VbecsEndPoint table (main and mirror) (Defect 340457).
**
**	Author:	Kwame Adu-Poku
**
**	Date: 	09/19/2016
**
******************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------	---------	------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************************************************************/

CREATE VIEW V_VbecsEndPoint
AS 
SELECT Source='MIRROR', MirrorId, VbecsEndPointId, EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, MirrorDate
FROM dbo.VbecsEndPoint
UNION ALL 
SELECT Source='ACTIVE', 0, VbecsEndPointId, EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, LastUpdateDate AS MirrorDate 
FROM Syn_VbecsEndPoint
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


GRANT SELECT ON dbo.V_VbecsEndPoint TO VbecsAppMirrorUser
GO





USE @DBNAME@
GO


--Create Trigger

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trMirrorVbecsEndPoint]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trMirrorVbecsEndPoint]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[trMirrorVbecsEndPoint]
ON [dbo].[VbecsEndPoint]
FOR UPDATE 
AS 
BEGIN
	INSERT INTO [dbo].[SynMirror_VbecsEndPoint]
	SELECT *, GETUTCDATE()
	FROM DELETED
END



GO



/*****************************************************************************************
* 	VamcDivision table Updates 
*****************************************************************************************/


USE @DBNAME@_MIRROR

/**********************************************
   Create a temp table to store our existing 
   VamcDivision data
**********************************************/
IF OBJECT_ID(N'tempdb..#VamcDivision') IS NOT NULL
	DROP TABLE #VamcDivision
GO
CREATE TABLE #VamcDivision
	(
	MirrorId int,
	DivisionCode char (5) NOT NULL,
	DivisionGuid uniqueidentifier NOT NULL,
	DivisionName varchar(50) NOT NULL,
	ServiceTypeIndicator bit NOT NULL,
	IccbbaRegistrationNumber char(5) NULL,
	ElectronicCrossmatchIndicator bit NULL,
	FacilityGuid uniqueidentifier NULL,
	LocalSupplierGuid uniqueidentifier NULL,
	AntibodyScreenDisplayCode int NULL,
	MaximumSpecimenExpirationDays smallint NULL,
	AutomatedInstrumentIndicator bit NULL,
	LabelPrinterUseIndicator bit NOT NULL,
	LabelPrinterComPortNumber tinyint NULL,
	LabelPrinterIPAddress varchar(15) NULL,
	LabelPrinterTcpPortNumber int NULL,
	TimeZoneId char(1) NOT NULL,
	DaylightSavingsTypeId smallint NOT NULL,
	PrinterName varchar(50) NULL,
	PrinterAlertsIndicator bit NOT NULL,
	PrinterAlertsPrinterName varchar(50) NULL,
	PrinterOrderAlertTypeCode char(1) NULL,
	PrinterOrdersNeededHours smallint NULL,
	IconAlertsIndicator bit NULL,
	IconOrderAlertTypeCode char(1) NULL,
	IconOrdersNeededHours smallint NULL,
	IconRefreshRate int NULL,
	LoginMessageText varchar(510) NULL,
	InvoiceTemplateText varchar(1000) NOT NULL,
	MedicalDirectorName varchar(30) NULL,
	UsaIndicator bit NOT NULL,
	LockInactivityTimeoutMin int NOT NULL,
	AccessionAreaId int NULL,
	DaylightSavingsStartDate datetime NULL,
	DaylightSavingsEndDate datetime NULL,
	ReactivityPhaseCode char (1) NOT NULL,
	RecordStatusCode char(1) NOT NULL,
	LastUpdateDate datetime NOT NULL,
	LastUpdateUser varchar(30) NOT NULL,
	RowVersion binary(8) NOT NULL,
	LastUpdateFunctionId int NOT NULL,
	MirrorDate datetime NOT NULL
	) 

/**********************************************
   Save the existing VamcDivision data to the 
   temp table
**********************************************/
INSERT INTO dbo.#VamcDivision 
	(MirrorId, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, RowVersion, LastUpdateFunctionId, MirrorDate)
SELECT 	 MirrorId, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, RowVersion, LastUpdateFunctionId, MirrorDate
  FROM dbo.VamcDivision


/**********************************************
   Create the new VamcDivision table
**********************************************/
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[VamcDivision]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	DROP TABLE dbo.VamcDivision
GO

CREATE TABLE VamcDivision (
	MirrorId int NOT NULL IDENTITY (1, 1),
	DivisionCode char (5) NOT NULL ,
	DivisionGuid uniqueidentifier NOT NULL ,
	DivisionName varchar (50) NOT NULL ,
	ServiceTypeIndicator bit NOT NULL,
	IccbbaRegistrationNumber char (5) NULL ,
	ElectronicCrossmatchIndicator bit NULL,
	FacilityGuid uniqueidentifier NULL ,
	LocalSupplierGuid uniqueidentifier NULL ,
	AntibodyScreenDisplayCode int NULL ,
	MaximumSpecimenExpirationDays smallint NULL ,
	AutomatedInstrumentIndicator bit NULL ,
	LabelPrinterUseIndicator bit NOT NULL ,
	LabelPrinterComPortNumber tinyint NULL ,
	LabelPrinterIPAddress varchar (15) NULL ,
	LabelPrinterTcpPortNumber int NULL ,
	TimeZoneId char (1) NOT NULL ,
	DaylightSavingsTypeId smallint NOT NULL,
	PrinterName varchar(50) NULL,
	PrinterAlertsIndicator bit NOT NULL,
	PrinterAlertsPrinterName varchar (50) NULL ,
	PrinterOrderAlertTypeCode char (1) NULL ,
	PrinterOrdersNeededHours smallint NULL ,
	IconAlertsIndicator bit NULL ,
	IconOrderAlertTypeCode char (1) NULL ,
	IconOrdersNeededHours smallint NULL ,
	IconRefreshRate int NULL ,
	LoginMessageText varchar (510) NULL ,
	InvoiceTemplateText varchar (1000) NOT NULL ,
	MedicalDirectorName varchar (30) NULL ,
	UsaIndicator bit NOT NULL,
	LockInactivityTimeoutMin int NOT NULL ,
	AccessionAreaId int NOT NULL ,
	DaylightSavingsStartDate datetime NULL ,
	DaylightSavingsEndDate datetime NULL ,
	ReactivityPhaseCode char (1) NOT NULL,
	RecordStatusCode char (1) NOT NULL ,
	LabelPrinterEndPointId int NULL,
	LastUpdateDate datetime NOT NULL ,
	LastUpdateUser varchar (30) NOT NULL ,
	RowVersion binary(8) NULL ,
	LastUpdateFunctionId int NOT NULL,
	MirrorDate datetime NOT NULL
CONSTRAINT [PK_VamcDivision] PRIMARY KEY NONCLUSTERED 
(
	[MirrorId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

/**********************************************
   Save the temporary VamcDivision data to the 
   new VamcDivision table
**********************************************/
SET IDENTITY_INSERT dbo.VamcDivision ON
GO

INSERT INTO dbo.VamcDivision 
	(MirrorId, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, RowVersion, LastUpdateFunctionId, MirrorDate)
SELECT 	 MirrorId, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, RowVersion, LastUpdateFunctionId, MirrorDate
  FROM #VamcDivision
GO

SET IDENTITY_INSERT dbo.VamcDivision OFF
GO

/**********************************************
   Drop the temp table
**********************************************/
DROP TABLE #VamcDivision
GO

 CREATE  CLUSTERED  INDEX IX_VamcDivision ON dbo.VamcDivision(DivisionCode) ON [PRIMARY]
GO

 CREATE  INDEX IX_VamcDivision_AntibodyScreenDisplayCode ON dbo.VamcDivision(AntibodyScreenDisplayCode) ON [PRIMARY]
GO

 CREATE  INDEX IX_VamcDivision_FacilityGuid ON dbo.VamcDivision(FacilityGuid) ON [PRIMARY]
GO

 CREATE  INDEX IX_VamcDivision_MedicalDirectorName ON dbo.VamcDivision(MedicalDirectorName) ON [PRIMARY]
GO

 CREATE  INDEX IX_VamcDivision_MirrorDate ON dbo.VamcDivision (MirrorDate) ON [PRIMARY]
GO


--Create Mirror Synonyms

IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'Syn_VamcDivision') 
DROP SYNONYM dbo.[Syn_VamcDivision]
GO

CREATE SYNONYM [dbo].[Syn_VamcDivision] FOR [@DBNAME@].[dbo].[VamcDivision]
GO


USE @DBNAME@

/**********************************************
   Create a temp table to store our existing 
   VamcDivision data
**********************************************/

IF OBJECT_ID(N'tempdb..#VamcDivision') IS NOT NULL
	DROP TABLE #VamcDivision

CREATE TABLE dbo.#VamcDivision
	(
	DivisionCode char(5) NOT NULL,
	DivisionGuid uniqueidentifier NOT NULL,
	DivisionName varchar(50) NOT NULL,
	ServiceTypeIndicator bit NOT NULL,
	IccbbaRegistrationNumber char(5) NULL,
	ElectronicCrossmatchIndicator bit NULL,
	FacilityGuid uniqueidentifier NULL,
	LocalSupplierGuid uniqueidentifier NULL,
	AntibodyScreenDisplayCode int NULL,
	MaximumSpecimenExpirationDays smallint NULL,
	AutomatedInstrumentIndicator bit NULL,
	LabelPrinterUseIndicator bit NOT NULL,
	LabelPrinterComPortNumber tinyint NULL,
	LabelPrinterIPAddress varchar(15) NULL,
	LabelPrinterTcpPortNumber int NULL,
	TimeZoneId char(1) NOT NULL,
	DaylightSavingsTypeId smallint NOT NULL,
	PrinterName varchar(50) NULL,
	PrinterAlertsIndicator bit NOT NULL,
	PrinterAlertsPrinterName varchar(50) NULL,
	PrinterOrderAlertTypeCode char(1) NULL,
	PrinterOrdersNeededHours smallint NULL,
	IconAlertsIndicator bit NULL,
	IconOrderAlertTypeCode char(1) NULL,
	IconOrdersNeededHours smallint NULL,
	IconRefreshRate int NULL,
	LoginMessageText varchar(510) NULL,
	InvoiceTemplateText varchar(1000) NOT NULL,
	MedicalDirectorName varchar(30) NULL,
	UsaIndicator bit NOT NULL,
	LockInactivityTimeoutMin int NOT NULL,
	AccessionAreaId int NULL,
	DaylightSavingsStartDate datetime NULL,
	DaylightSavingsEndDate datetime NULL,
	ReactivityPhaseCode char (1) NOT NULL,
	RecordStatusCode char(1) NOT NULL,
	LastUpdateDate datetime NOT NULL,
	LastUpdateUser varchar(30) NOT NULL,
	LastUpdateFunctionId int NOT NULL
	)  ON [PRIMARY]
GO



/**********************************************
   Save the existing VamcDivision data to the 
   temp table
**********************************************/

INSERT INTO #VamcDivision 
	(DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)
SELECT 	 DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId
  FROM dbo.VamcDivision
GO

/*********************************************************
   Drop the existing VamcDivision constraints and FK
*********************************************************/

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_AntibodyScreenDisplay]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_AntibodyScreenDisplay]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_DaylightSavingsType ]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_DaylightSavingsType ]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_Facility]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_Facility]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_IconOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_IconOrderAlertType]
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_PrinterOrderAlertType]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_PrinterOrderAlertType]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VamcDivision_TimeZone]') AND parent_object_id = OBJECT_ID(N'[dbo].[VamcDivision]'))
ALTER TABLE [dbo].[VamcDivision] DROP CONSTRAINT [FK_VamcDivision_TimeZone]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntibodyParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntibodyParameter]'))
ALTER TABLE [dbo].[AntibodyParameter] DROP CONSTRAINT [FK_AntibodyParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AntiseraWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AntiseraWorklist]'))
ALTER TABLE [dbo].[AntiseraWorklist] DROP CONSTRAINT [FK_AntiseraWorklist_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssociatedInstitution_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[AssociatedInstitution]'))
ALTER TABLE [dbo].[AssociatedInstitution] DROP CONSTRAINT [FK_AssociatedInstitution_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnit]'))
ALTER TABLE [dbo].[BloodUnit] DROP CONSTRAINT [FK_BloodUnit_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitAntigen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitAntigen]'))
ALTER TABLE [dbo].[BloodUnitAntigen] DROP CONSTRAINT [FK_BloodUnitAntigen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitModification]'))
ALTER TABLE [dbo].[BloodUnitModification] DROP CONSTRAINT [FK_BloodUnitModification_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[BloodUnitTest]'))
ALTER TABLE [dbo].[BloodUnitTest] DROP CONSTRAINT [FK_BloodUnitTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CannedComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[CannedComment]'))
ALTER TABLE [dbo].[CannedComment] DROP CONSTRAINT [FK_CannedComment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ComponentClassParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ComponentClassParameter]'))
ALTER TABLE [dbo].[ComponentClassParameter] DROP CONSTRAINT [FK_ComponentClassParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyControl_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyControl]'))
ALTER TABLE [dbo].[DailyControl] DROP CONSTRAINT [FK_DailyControl_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_DailyQcWorklist_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[DailyQcWorklist]'))
ALTER TABLE [dbo].[DailyQcWorklist] DROP CONSTRAINT [FK_DailyQcWorklist_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Equipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Equipment]'))
ALTER TABLE [dbo].[Equipment] DROP CONSTRAINT [FK_Equipment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionAntigenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionAntigenTest]'))
ALTER TABLE [dbo].[ExceptionAntigenTest] DROP CONSTRAINT [FK_ExceptionAntigenTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionCautionTag_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionCautionTag]'))
ALTER TABLE [dbo].[ExceptionCautionTag] DROP CONSTRAINT [FK_ExceptionCautionTag_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionElectronicTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionElectronicTransfusion]'))
ALTER TABLE [dbo].[ExceptionElectronicTransfusion] DROP CONSTRAINT [FK_ExceptionElectronicTransfusion_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueOrder]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueOrder] DROP CONSTRAINT [FK_ExceptionEmergencyIssueOrder_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionEmergencyIssueUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionEmergencyIssueUnitTest]'))
ALTER TABLE [dbo].[ExceptionEmergencyIssueUnitTest] DROP CONSTRAINT [FK_ExceptionEmergencyIssueUnitTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredTask_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredTask]'))
ALTER TABLE [dbo].[ExceptionExpiredTask] DROP CONSTRAINT [FK_ExceptionExpiredTask_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionExpiredUnitReceived_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionExpiredUnitReceived]'))
ALTER TABLE [dbo].[ExceptionExpiredUnitReceived] DROP CONSTRAINT [FK_ExceptionExpiredUnitReceived_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionInconclusiveCrossmatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionInconclusiveCrossmatch]'))
ALTER TABLE [dbo].[ExceptionInconclusiveCrossmatch] DROP CONSTRAINT [FK_ExceptionInconclusiveCrossmatch_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionLabelMismatch_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionLabelMismatch]'))
ALTER TABLE [dbo].[ExceptionLabelMismatch] DROP CONSTRAINT [FK_ExceptionLabelMismatch_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRh]'))
ALTER TABLE [dbo].[ExceptionPatientAboRh] DROP CONSTRAINT [FK_ExceptionPatientAboRh_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAboRhDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAboRhDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAboRhDiscrepancy] DROP CONSTRAINT [FK_ExceptionPatientAboRhDiscrepancy_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientRestriction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientRestriction]'))
ALTER TABLE [dbo].[ExceptionPatientRestriction] DROP CONSTRAINT [FK_ExceptionPatientRestriction_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTest]'))
ALTER TABLE [dbo].[ExceptionPatientTest] DROP CONSTRAINT [FK_ExceptionPatientTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientTestInactivated_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientTestInactivated]'))
ALTER TABLE [dbo].[ExceptionPatientTestInactivated] DROP CONSTRAINT [FK_ExceptionPatientTestInactivated_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQc_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQc]'))
ALTER TABLE [dbo].[ExceptionQc] DROP CONSTRAINT [FK_ExceptionQc_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcInactivation_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcInactivation]'))
ALTER TABLE [dbo].[ExceptionQcInactivation] DROP CONSTRAINT [FK_ExceptionQcInactivation_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQcNotPerformed_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQcNotPerformed]'))
ALTER TABLE [dbo].[ExceptionQcNotPerformed] DROP CONSTRAINT [FK_ExceptionQcNotPerformed_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionQuarantine_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionQuarantine]'))
ALTER TABLE [dbo].[ExceptionQuarantine] DROP CONSTRAINT [FK_ExceptionQuarantine_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRackTest]'))
ALTER TABLE [dbo].[ExceptionRackTest] DROP CONSTRAINT [FK_ExceptionRackTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionRemoveFinalUnitStatus_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionRemoveFinalUnitStatus]'))
ALTER TABLE [dbo].[ExceptionRemoveFinalUnitStatus] DROP CONSTRAINT [FK_ExceptionRemoveFinalUnitStatus_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReturnedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReturnedUnit]'))
ALTER TABLE [dbo].[ExceptionReturnedUnit] DROP CONSTRAINT [FK_ExceptionReturnedUnit_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionSpecimen]'))
ALTER TABLE [dbo].[ExceptionSpecimen] DROP CONSTRAINT [FK_ExceptionSpecimen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusion]'))
ALTER TABLE [dbo].[ExceptionTransfusion] DROP CONSTRAINT [FK_ExceptionTransfusion_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTransfusionReactionWorkup_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTransfusionReactionWorkup]'))
ALTER TABLE [dbo].[ExceptionTransfusionReactionWorkup] DROP CONSTRAINT [FK_ExceptionTransfusionReactionWorkup_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionTrwSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionTrwSpecimen]'))
ALTER TABLE [dbo].[ExceptionTrwSpecimen] DROP CONSTRAINT [FK_ExceptionTrwSpecimen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitAboRh_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitAboRh]'))
ALTER TABLE [dbo].[ExceptionUnitAboRh] DROP CONSTRAINT [FK_ExceptionUnitAboRh_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitIssue_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitIssue]'))
ALTER TABLE [dbo].[ExceptionUnitIssue] DROP CONSTRAINT [FK_ExceptionUnitIssue_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitModification_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitModification]'))
ALTER TABLE [dbo].[ExceptionUnitModification] DROP CONSTRAINT [FK_ExceptionUnitModification_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionUnitSelection_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionUnitSelection]'))
ALTER TABLE [dbo].[ExceptionUnitSelection] DROP CONSTRAINT [FK_ExceptionUnitSelection_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_HcpcsAssignment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[HcpcsAssignment]'))
ALTER TABLE [dbo].[HcpcsAssignment] DROP CONSTRAINT [FK_HcpcsAssignment_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_IssuedUnitComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[IssuedUnitComment]'))
ALTER TABLE [dbo].[IssuedUnitComment] DROP CONSTRAINT [FK_IssuedUnitComment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LocalSupplier_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LocalSupplier]'))
ALTER TABLE [dbo].[LocalSupplier] DROP CONSTRAINT [FK_LocalSupplier_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_LoginMessage_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[LoginMessage]'))
ALTER TABLE [dbo].[LoginMessage] DROP CONSTRAINT [FK_LoginMessage_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Msbos_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Msbos]'))
ALTER TABLE [dbo].[Msbos] DROP CONSTRAINT [FK_Msbos_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedComponent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedComponent]'))
ALTER TABLE [dbo].[OrderedComponent] DROP CONSTRAINT [FK_OrderedComponent_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedTest]'))
ALTER TABLE [dbo].[OrderedTest] DROP CONSTRAINT [FK_OrderedTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_OrderedUnit_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[OrderedUnit]'))
ALTER TABLE [dbo].[OrderedUnit] DROP CONSTRAINT [FK_OrderedUnit_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientOrder_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientOrder]'))
ALTER TABLE [dbo].[PatientOrder] DROP CONSTRAINT [FK_PatientOrder_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecialInstruction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecialInstruction]'))
ALTER TABLE [dbo].[PatientSpecialInstruction] DROP CONSTRAINT [FK_PatientSpecialInstruction_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientSpecimen_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientSpecimen]'))
ALTER TABLE [dbo].[PatientSpecimen] DROP CONSTRAINT [FK_PatientSpecimen_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTest]'))
ALTER TABLE [dbo].[PatientTest] DROP CONSTRAINT [FK_PatientTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusion_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusion]'))
ALTER TABLE [dbo].[PatientTransfusion] DROP CONSTRAINT [FK_PatientTransfusion_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionComment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionComment]'))
ALTER TABLE [dbo].[PatientTransfusionComment] DROP CONSTRAINT [FK_PatientTransfusionComment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionReaction_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionReaction]'))
ALTER TABLE [dbo].[PatientTransfusionReaction] DROP CONSTRAINT [FK_PatientTransfusionReaction_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingBloodUnitTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingBloodUnitTest]'))
ALTER TABLE [dbo].[PendingBloodUnitTest] DROP CONSTRAINT [FK_PendingBloodUnitTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PendingSpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PendingSpecimenTest]'))
ALTER TABLE [dbo].[PendingSpecimenTest] DROP CONSTRAINT [FK_PendingSpecimenTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PoolCounter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PoolCounter]'))
ALTER TABLE [dbo].[PoolCounter] DROP CONSTRAINT [FK_PoolCounter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductModificationParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductModificationParameter]'))
ALTER TABLE [dbo].[ProductModificationParameter] DROP CONSTRAINT [FK_ProductModificationParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProductShipper_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ProductShipper]'))
ALTER TABLE [dbo].[ProductShipper] DROP CONSTRAINT [FK_ProductShipper_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Rack_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Rack]'))
ALTER TABLE [dbo].[Rack] DROP CONSTRAINT [FK_Rack_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackLot_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackLot]'))
ALTER TABLE [dbo].[RackLot] DROP CONSTRAINT [FK_RackLot_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RackTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[RackTest]'))
ALTER TABLE [dbo].[RackTest] DROP CONSTRAINT [FK_RackTest_VamcDivision]
GO


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Reagent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Reagent]'))
ALTER TABLE [dbo].[Reagent] DROP CONSTRAINT [FK_Reagent_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTestParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTestParameter]'))
ALTER TABLE [dbo].[ReagentTestParameter] DROP CONSTRAINT [FK_ReagentTestParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ReagentTypeParameter_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ReagentTypeParameter]'))
ALTER TABLE [dbo].[ReagentTypeParameter] DROP CONSTRAINT [FK_ReagentTypeParameter_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Shipment_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Shipment]'))
ALTER TABLE [dbo].[Shipment] DROP CONSTRAINT [FK_Shipment_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTest]'))
ALTER TABLE [dbo].[SpecimenTest] DROP CONSTRAINT [FK_SpecimenTest_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SpecimenTestThreshold_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[SpecimenTestThreshold]'))
ALTER TABLE [dbo].[SpecimenTestThreshold] DROP CONSTRAINT [FK_SpecimenTestThreshold_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Supply_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[Supply]'))
ALTER TABLE [dbo].[Supply] DROP CONSTRAINT [FK_Supply_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VBECSLock_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsLock]'))
ALTER TABLE [dbo].[VbecsLock] DROP CONSTRAINT [FK_VBECSLock_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_VbecsUserDivisionRole_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[VbecsUserDivisionRole]'))
ALTER TABLE [dbo].[VbecsUserDivisionRole] DROP CONSTRAINT [FK_VbecsUserDivisionRole_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadEvent_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadEvent]'))
ALTER TABLE [dbo].[WorkloadEvent] DROP CONSTRAINT [FK_WorkloadEvent_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionRequirement_CreateDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]'))
ALTER TABLE [dbo].[PatientTransfusionRequirement] DROP CONSTRAINT [FK_PatientTransfusionRequirement_CreateDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PatientTransfusionRequirement_InactivateDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[PatientTransfusionRequirement]'))
ALTER TABLE [dbo].[PatientTransfusionRequirement] DROP CONSTRAINT [FK_PatientTransfusionRequirement_InactivateDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_WorkloadProcess_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[WorkloadProcess]'))
ALTER TABLE [dbo].[WorkloadProcess] DROP CONSTRAINT [FK_WorkloadProcess_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionPatientAntigenDiscrepancy_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionPatientAntigenDiscrepancy]'))
ALTER TABLE [dbo].[ExceptionPatientAntigenDiscrepancy] DROP CONSTRAINT [FK_ExceptionPatientAntigenDiscrepancy_VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ExceptionReflexTest_VamcDivision]') AND parent_object_id = OBJECT_ID(N'[dbo].[ExceptionReflexTest]'))
ALTER TABLE [dbo].[ExceptionReflexTest] DROP CONSTRAINT [FK_ExceptionReflexTest_VamcDivision]
GO

DROP TRIGGER dbo.trMirrorVamcDivision
GO


/**********************************************
   Create the new VamcDivision table
**********************************************/
DROP TABLE dbo.VamcDivision
GO

CREATE TABLE dbo.VamcDivision (
	DivisionCode char (5) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	DivisionGuid uniqueidentifier NOT NULL ,
	DivisionName varchar (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	ServiceTypeIndicator bit NOT NULL ,
	IccbbaRegistrationNumber char (5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	ElectronicCrossmatchIndicator bit NULL,
	FacilityGuid uniqueidentifier NULL,
	LocalSupplierGuid uniqueidentifier NULL,
	AntibodyScreenDisplayCode int NULL,
	MaximumSpecimenExpirationDays smallint NULL,
	AutomatedInstrumentIndicator bit NULL,
	LabelPrinterUseIndicator bit NOT NULL,
	LabelPrinterComPortNumber tinyint NULL,
	LabelPrinterIPAddress varchar (15) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	LabelPrinterTcpPortNumber int NULL,
	TimeZoneId char (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	DaylightSavingsTypeId smallint NOT NULL,
	PrinterName varchar(50) NULL,
	PrinterAlertsIndicator bit NOT NULL,
	PrinterAlertsPrinterName varchar (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	PrinterOrderAlertTypeCode char (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	PrinterOrdersNeededHours smallint NULL,
	IconAlertsIndicator bit NULL,
	IconOrderAlertTypeCode char (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	IconOrdersNeededHours smallint NULL,
	IconRefreshRate int NULL,
	LoginMessageText varchar (510) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	InvoiceTemplateText varchar (1000) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	MedicalDirectorName varchar (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	UsaIndicator bit NOT NULL,
	LockInactivityTimeoutMin int NOT NULL,
	AccessionAreaId int NOT NULL,
	DaylightSavingsStartDate datetime NULL,
	DaylightSavingsEndDate datetime NULL,
	ReactivityPhaseCode char (1) NOT NULL,
	RecordStatusCode char (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	LabelPrinterEndPointId int NULL,
	LastUpdateDate datetime NOT NULL,
	LastUpdateUser varchar (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	RowVersion timestamp NOT NULL,
	LastUpdateFunctionId int NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE dbo.VamcDivision WITH NOCHECK ADD 
	CONSTRAINT PK_VamcDivision PRIMARY KEY  CLUSTERED 
	(
		DivisionCode
	) ON [PRIMARY] 
GO

ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [DF_VamcDivision_ServiceTypeIndicator]  DEFAULT (1) FOR [ServiceTypeIndicator]
GO

ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [DF_VamcDivision_ElectronicCrossmatchIndicator]  DEFAULT (0) FOR [ElectronicCrossmatchIndicator]
GO

ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [DF_VamcDivision_TimeZoneChangeIndicator]  DEFAULT (1) FOR [DaylightSavingsTypeId]
GO

ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [DF_VamcDivision_PrinterAlertsIndicator]  DEFAULT (0) FOR [PrinterAlertsIndicator]
GO

ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [DF_VamcDivision_UsaIndicator]  DEFAULT (1) FOR [UsaIndicator]
GO

ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [DF_VamcDivision_ReactivityPhaseCode]  DEFAULT ('9') FOR [ReactivityPhaseCode]
GO

ALTER TABLE [dbo].[VamcDivision] ADD  CONSTRAINT [DF_VamcDivision_LastUpdateFunctionId]  DEFAULT (0) FOR [LastUpdateFunctionId]
GO


EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an organizational unit of a VA Medical Center.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'DivisionCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a unique instance of an organizational unit of a VA Medical Center.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'DivisionGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of a VA Medical Center organizational unit.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'DivisionName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the VAMC division is a standard "full service" configured facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'ServiceTypeIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the division as an original blood collection facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'IccbbaRegistrationNumber'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the VAMC division has enabled electronic crossmatching.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'ElectronicCrossmatchIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links to the division''s record in the Facility table to enable getting the address for the division.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'FacilityGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links to the division''s record in the LocalSupplier table to enable getting the address for the division.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LocalSupplierGuid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific display option for antibody screen tests.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'AntibodyScreenDisplayCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates the maximum number of days a specimen can exist before it expires for the VAMC division.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'MaximumSpecimenExpirationDays'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the VAMC division has enabled automated instrument processing.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'AutomatedInstrumentIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the division uses a designated label printer.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LabelPrinterUseIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The standard time zone id for the division.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'TimeZoneId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific option for changing from standard time to daylight saving time.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'DaylightSavingsTypeId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Default report printer name for the division.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'PrinterName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the division has activated printer alerts for incoming orders.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'PrinterAlertsIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the printer that will print order alerts.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'PrinterAlertsPrinterName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of order alert.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'PrinterOrderAlertTypeCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a time interval, in hours, in which orders received by VBECS need to be filled.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'PrinterOrdersNeededHours'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the division has activated an icon for order alerts.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'IconAlertsIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of order alert.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'IconOrderAlertTypeCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a time interval, in hours, in which orders received by VBECS need to be filled.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'IconOrdersNeededHours'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The frequency, in seconds, with which the system will check for order updates.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'IconRefreshRate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The text of the message to be displayed at login.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LoginMessageText'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The detailed text for a VBECS shipping invoice template.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'InvoiceTemplateText'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of a blood bank medical director.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'MedicalDirectorName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates that the division is located in the USA.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'UsaIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The interval of inactivity, in minutes, after which the system will lock a current function.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LockInactivityTimeoutMin'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the Lab accession area for the division.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'AccessionAreaId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date daylight savings time starts.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'DaylightSavingsStartDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date daylight savings time ends.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'DaylightSavingsEndDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a specific reactivity phase for testing a reagent.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'ReactivityPhaseCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates the state of the associated record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'RecordStatusCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates the Label Printer End Point.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LabelPrinterEndPointId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time the record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the user who performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VamcDivision', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO



/**********************************************
   Save the temp VamcDivision data to the 
   new VamcDivision table
**********************************************/
INSERT INTO dbo.VamcDivision 
	(DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)
SELECT 	 DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, 
	 FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber,
	 TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, 
	 IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, 
	 DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId
  FROM #VamcDivision
GO

/**********************************************
   Drop the temp table
**********************************************/
DROP TABLE #VamcDivision
GO

/**********************************************
   Add the indexes to the VamcDivision table
**********************************************/
CREATE NONCLUSTERED INDEX [IX_VamcDivision_AntibodyScreenDisplayCode] ON [dbo].[VamcDivision] ([AntibodyScreenDisplayCode]) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IX_VamcDivision_DaylightSavingsTypeId] ON [dbo].[VamcDivision] ([DaylightSavingsTypeId]) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IX_VamcDivision_FacilityGuid] ON [dbo].[VamcDivision] ([FacilityGuid]) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IX_VamcDivision_IconOrderAlertTypeCode] ON [dbo].[VamcDivision] ([IconOrderAlertTypeCode]) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IX_VamcDivision_PrinterOrderAlertTypeCode] ON [dbo].[VamcDivision] ([PrinterOrderAlertTypeCode]) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IX_VamcDivision_TimeZoneId] ON [dbo].[VamcDivision] ([TimeZoneId]) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IX_VamcDivision_ReactivityPhaseCode] ON [dbo].[VamcDivision] ([ReactivityPhaseCode]) ON [PRIMARY]
GO


/**********************************************
   Add the foreign keys to the VamcDivision table
**********************************************/
ALTER TABLE dbo.VamcDivision ADD CONSTRAINT
	FK_VamcDivision_AntibodyScreenDisplay FOREIGN KEY
	(
		AntibodyScreenDisplayCode
	) REFERENCES dbo.AntibodyScreenDisplay
	(
		AntibodyScreenDisplayCode
	)
GO
ALTER TABLE dbo.VamcDivision ADD CONSTRAINT
	FK_VamcDivision_TimeZone FOREIGN KEY
	(
		TimeZoneId
	) REFERENCES dbo.TimeZone
	(
		TimeZoneId
	)
GO
ALTER TABLE dbo.VamcDivision ADD CONSTRAINT
	[FK_VamcDivision_DaylightSavingsType ] FOREIGN KEY
	(
		DaylightSavingsTypeId
	) REFERENCES dbo.[DaylightSavingsType ]
	(
		DaylightSavingsTypeId
	)
GO
ALTER TABLE dbo.VamcDivision ADD CONSTRAINT
	FK_VamcDivision_PrinterOrderAlertType FOREIGN KEY
	(
		PrinterOrderAlertTypeCode
	) REFERENCES dbo.OrderAlertType
	(
		OrderAlertTypeCode
	)
GO
ALTER TABLE dbo.VamcDivision ADD CONSTRAINT
	FK_VamcDivision_IconOrderAlertType FOREIGN KEY
	(
		IconOrderAlertTypeCode
	) REFERENCES dbo.OrderAlertType
	(
		OrderAlertTypeCode
	)
GO
ALTER TABLE dbo.VamcDivision ADD CONSTRAINT
	FK_VamcDivision_Facility FOREIGN KEY
	(
		FacilityGuid
	) REFERENCES dbo.Facility
	(
		FacilityGuid
	)
GO

ALTER TABLE [dbo].[BloodUnitModification] ADD CONSTRAINT [FK_BloodUnitModification_VamcDivision] FOREIGN KEY ([DivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[ExceptionElectronicTransfusion] ADD CONSTRAINT [FK_ExceptionElectronicTransfusion_VamcDivision] FOREIGN KEY ([DivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[PatientTransfusionRequirement] ADD CONSTRAINT [FK_PatientTransfusionRequirement_CreateDivision] FOREIGN KEY ([CreateDivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[PatientTransfusionRequirement] ADD CONSTRAINT [FK_PatientTransfusionRequirement_InactivateDivision] FOREIGN KEY ([InactivateDivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[PendingBloodUnitTest] WITH NOCHECK ADD CONSTRAINT [FK_PendingBloodUnitTest_VamcDivision] FOREIGN KEY ([DivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[PendingSpecimenTest] WITH NOCHECK ADD CONSTRAINT [FK_PendingSpecimenTest_VamcDivision] FOREIGN KEY ([DivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO

ALTER TABLE [dbo].[WorkloadProcess] WITH NOCHECK ADD CONSTRAINT [FK_WorkloadProcess_VamcDivision] FOREIGN KEY ([DivisionCode]) REFERENCES [dbo].[VamcDivision] ([DivisionCode])
GO


--Create Synonyms
IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'SynMirror_VamcDivision') 
DROP SYNONYM dbo.[SynMirror_VamcDivision]
GO

CREATE SYNONYM [dbo].[SynMirror_VamcDivision] FOR [@DBNAME@_MIRROR].[dbo].[VamcDivision]
GO

IF  EXISTS (SELECT * FROM sys.synonyms WHERE name = N'SynMirror_V_VamcDivision') 
DROP SYNONYM dbo.[SynMirror_V_VamcDivision]
GO

CREATE SYNONYM [dbo].[SynMirror_V_VamcDivision] FOR [@DBNAME@_MIRROR].[dbo].[V_VamcDivision]
GO


--Create Trigger

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trMirrorVamcDivision]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trMirrorVamcDivision]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[trMirrorVamcDivision]
ON [dbo].[VamcDivision]
FOR UPDATE 
AS 
BEGIN
	INSERT INTO [dbo].[SynMirror_VamcDivision]
	SELECT *, GETUTCDATE()
	FROM DELETED
END



GO



/**********************************************
   Add the foreign keys that reference 
   the VamcDivision table
**********************************************/
ALTER TABLE dbo.AntibodyParameter WITH NOCHECK ADD CONSTRAINT
	FK_AntibodyParameter_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.AntiseraWorklist WITH NOCHECK ADD CONSTRAINT
	FK_AntiseraWorklist_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.AssociatedInstitution ADD CONSTRAINT
	FK_AssociatedInstitution_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.BloodUnit WITH NOCHECK ADD CONSTRAINT
	FK_BloodUnit_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.BloodUnitAntigen WITH NOCHECK ADD CONSTRAINT
	FK_BloodUnitAntigen_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.BloodUnitTest WITH NOCHECK ADD CONSTRAINT
	FK_BloodUnitTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.CannedComment WITH NOCHECK ADD CONSTRAINT
	FK_CannedComment_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ComponentClassParameter WITH NOCHECK ADD CONSTRAINT
	FK_ComponentClassParameter_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.DailyControl WITH NOCHECK ADD CONSTRAINT
	FK_DailyControl_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.DailyQcWorklist WITH NOCHECK ADD CONSTRAINT
	FK_DailyQcWorklist_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.Equipment WITH NOCHECK ADD CONSTRAINT
	FK_Equipment_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionAntigenTest WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionAntigenTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionCautionTag WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionCautionTag_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionEmergencyIssueOrder WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionEmergencyIssueOrder_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionEmergencyIssueUnitTest WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionEmergencyIssueUnitTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionExpiredTask WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionExpiredTask_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionExpiredUnitReceived WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionExpiredUnitReceived_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionInconclusiveCrossmatch WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionInconclusiveCrossmatch_VamcDivision FOREIGN KEY
	(
	DivisionCode
	) REFERENCES dbo.VamcDivision
	(
	DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionLabelMismatch WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionLabelMismatch_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionPatientAboRh WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionPatientAboRh_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionPatientAboRhDiscrepancy WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionPatientAboRhDiscrepancy_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionPatientAntigenDiscrepancy WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionPatientAntigenDiscrepancy_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionPatientRestriction WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionPatientRestriction_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionPatientTest WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionPatientTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionPatientTestInactivated WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionPatientTestInactivated_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionQc WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionQc_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionQcInactivation WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionQcInactivation_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionQcNotPerformed WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionQcNotPerformed_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionQuarantine WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionQuarantine_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionRackTest WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionRackTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionReflexTest WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionReflexTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionRemoveFinalUnitStatus WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionRemoveFinalUnitStatus_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionReturnedUnit WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionReturnedUnit_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionSpecimen WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionSpecimen_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionTransfusion WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionTransfusion_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionTransfusionReactionWorkup WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionTransfusionReactionWorkup_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionTrwSpecimen WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionTrwSpecimen_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionUnitAboRh WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionUnitAboRh_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionUnitIssue WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionUnitIssue_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionUnitModification WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionUnitModification_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ExceptionUnitSelection WITH NOCHECK ADD CONSTRAINT
	FK_ExceptionUnitSelection_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.HcpcsAssignment WITH NOCHECK ADD CONSTRAINT
	FK_HcpcsAssignment_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.IssuedUnitComment WITH NOCHECK ADD CONSTRAINT
	FK_IssuedUnitComment_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.LocalSupplier WITH NOCHECK ADD CONSTRAINT
	FK_LocalSupplier_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.LoginMessage WITH NOCHECK ADD CONSTRAINT
	FK_LoginMessage_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.Msbos WITH NOCHECK ADD CONSTRAINT
	FK_Msbos_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.OrderedComponent WITH NOCHECK ADD CONSTRAINT
	FK_OrderedComponent_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.OrderedTest WITH NOCHECK ADD CONSTRAINT
	FK_OrderedTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.OrderedUnit WITH NOCHECK ADD CONSTRAINT
	FK_OrderedUnit_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.PatientOrder ADD CONSTRAINT
	FK_PatientOrder_VamcDivision FOREIGN KEY
	(
	DivisionCode
	) REFERENCES dbo.VamcDivision
	(
	DivisionCode
	)
GO

ALTER TABLE dbo.PatientSpecialInstruction WITH NOCHECK ADD CONSTRAINT
	FK_PatientSpecialInstruction_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.PatientSpecimen WITH NOCHECK ADD CONSTRAINT
	FK_PatientSpecimen_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.PatientTest WITH NOCHECK ADD CONSTRAINT
	FK_PatientTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.PatientTransfusion ADD CONSTRAINT
	FK_PatientTransfusion_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.PatientTransfusionComment WITH NOCHECK ADD CONSTRAINT
	FK_PatientTransfusionComment_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.PatientTransfusionReaction WITH NOCHECK ADD CONSTRAINT
	FK_PatientTransfusionReaction_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.PoolCounter WITH NOCHECK ADD CONSTRAINT
	FK_PoolCounter_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ProductModificationParameter WITH NOCHECK ADD CONSTRAINT
	FK_ProductModificationParameter_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ProductShipper WITH NOCHECK ADD CONSTRAINT
	FK_ProductShipper_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.Rack WITH NOCHECK ADD CONSTRAINT
	FK_Rack_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.RackLot WITH NOCHECK ADD CONSTRAINT
	FK_RackLot_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.RackTest ADD CONSTRAINT
	FK_RackTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.Reagent WITH NOCHECK ADD CONSTRAINT
	FK_Reagent_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ReagentTestParameter WITH NOCHECK ADD CONSTRAINT
	FK_ReagentTestParameter_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.ReagentTypeParameter WITH NOCHECK ADD CONSTRAINT
	FK_ReagentTypeParameter_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.Shipment WITH NOCHECK ADD CONSTRAINT
	FK_Shipment_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.SpecimenTest WITH NOCHECK ADD CONSTRAINT
	FK_SpecimenTest_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.SpecimenTestThreshold WITH NOCHECK ADD CONSTRAINT
	FK_SpecimenTestThreshold_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.Supply WITH NOCHECK ADD CONSTRAINT
	FK_Supply_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.VbecsLock ADD CONSTRAINT
	FK_VBECSLock_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.VbecsUserDivisionRole WITH NOCHECK ADD CONSTRAINT
	FK_VbecsUserDivisionRole_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

ALTER TABLE dbo.WorkloadEvent WITH NOCHECK ADD CONSTRAINT
	FK_WorkloadEvent_VamcDivision FOREIGN KEY
	(
		DivisionCode
	) REFERENCES dbo.VamcDivision
	(
		DivisionCode
	)
GO

USE @DBNAME@_MIRROR
GO
/*---------------------------------------------------------
  Create the VamcDivision view in the Mirror database
  (now that both mirror/non-mirror are updated)
---------------------------------------------------------*/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_VamcDivision]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.V_VamcDivision
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE VIEW V_VamcDivision
AS 
SELECT Source='MIRROR', MirrorId, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber, TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LabelPrinterEndPointId, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, MirrorDate
FROM dbo.VamcDivision
UNION ALL 
SELECT Source='ACTIVE', 0, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber, TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LabelPrinterEndPointId, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, LastUpdateDate AS MirrorDate 
FROM Syn_VamcDivision
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

--Permissions

GRANT SELECT, INSERT ON dbo.VamcDivision TO VbecsAppMirrorUser
GO

GRANT SELECT ON dbo.V_VamcDivision TO VbecsAppMirrorUser
GO


USE @DBNAME@
GO

--Permissions

GRANT SELECT ON  dbo.VamcDivision TO [VbecsAppUser]
GO

ALTER TABLE [dbo].[VamcDivision] ADD CONSTRAINT [FK_VamcDivision_VbecsEndPoint] FOREIGN KEY ([LabelPrinterEndPointId]) REFERENCES [dbo].[VbecsEndPoint] ([VbecsEndPointId])
GO


--Adding stored procedures

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetVbecsEndPoint]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetVbecsEndPoint]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Gets row(s) from VbecsEndPoint table (Defect 340457)
**
**	Author: Michael Glaze
**
**	Date: 	07/8/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetVbecsEndPoint]
(	
		@vbecsendpointid int = NULL
)	
AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT
		EndPointAddress,
		EndPointPort,
		EndPointType,
		[RowVersion]
	FROM
		dbo.VbecsEndPoint ep
	WHERE @vbecsendpointid IS NULL OR @vbecsendpointid = ep.VbecsEndPointId

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)


GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spUpdateVbecsEndPoint]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spUpdateVbecsEndPoint]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc: 	Updates VbecsEndPoint table (Defect 340457)
**
**	Author: Pablo Sanchez
**
**	Date: 	07/10/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date			Name		Description
**	-------------------	-----------------------	-----------------------------------------------------------------------------------------------------------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spUpdateVbecsEndPoint]
(	
		@vbecsendpointid INT,
		@endpointaddress VARCHAR (255),
		@endpointport INT,
		@endpointtype VARCHAR (50),
		@lastupdatedate DATETIME = NULL,
		@lastupdateuser VARCHAR (30) = NULL,
		@rowversion			TIMESTAMP,
		@lastupdatefunctionid		INT
)
AS

SET NOCOUNT ON

DECLARE	@ERROR	INT,
		@ROWCOUNT	INT

UPDATE [dbo].[VbecsEndPoint]
	SET 
		[EndPointAddress] = @endPointAddress,
		[EndPointPort] = @endPointPort,
		[EndPointType] = @endPointType,
		[LastUpdateDate] = ISNULL(@lastupdatedate, GETUTCDATE()),
		[LastUpdateUser] = ISNULL(@lastupdateuser, SUSER_NAME()),
		[LastUpdateFunctionId] = @lastupdatefunctionid

	WHERE 
		VbecsEndPointId = @vbecsendpointid
		AND	[RowVersion] = @rowversion
	
	SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT

	IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM dbo.VbecsEndPoint  WHERE [RowVersion] = @rowversion ) <> 1 
	RAISERROR(50001, 16, 127)
	ELSE
	IF (@ERROR = 0 AND @ROWCOUNT > 1)
		SET @ERROR = -1

SET NOCOUNT OFF
                                
RETURN (@ERROR)




GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spUpdateVbecsGlobalConfig]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spUpdateVbecsGlobalConfig]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc: 	Updates VbecsGlobalconfig table (Defect 340457)
**
**	Author: Pablo Sanchez
**
**	Date: 	07/10/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spUpdateVbecsGlobalConfig]
(
	@applicationname varchar(100),
    @parametername varchar(100),
    @parametervalue varchar(1000),
    @lastupdatedate datetime = NULL,
    @lastupdateuser varchar(30) = NULL,
	@rowversion			TIMESTAMP,
	@lastupdatefunctionid		INT
 

)	
AS

SET NOCOUNT ON

DECLARE	@ERROR	INT,
		@ROWCOUNT	INT

UPDATE [dbo].[VbecsGlobalConfig]
   SET
   [ParameterValue] = @parametervalue,
   [LastUpdateDate] = ISNULL(@lastupdatedate, GETUTCDATE()),
   [LastUpdateUser] = ISNULL(@lastupdateuser, SUSER_NAME()),
   [LastUpdateFunctionId] = @lastupdatefunctionid

 WHERE [ParameterName] = @parametername AND [ApplicationName] = @applicationname AND [RowVersion] = @rowversion 
	SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT

	IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM dbo.VbecsGlobalConfig  WHERE [RowVersion] = @rowversion ) <> 1 
	RAISERROR(50001, 16, 127)
	ELSE
	IF (@ERROR = 0 AND @ROWCOUNT > 1)            
		SET @ERROR = -1

SET NOCOUNT OFF
                                
RETURN (@ERROR)




GO
	

	

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetInterface]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetInterface]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc: 	Gets an interface defined in the InterfaceControl table.
**
**	Author: Brian Tomlin	
**
**	Date: 	03/27/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/05	N. Paterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners
**	11/14/08	M. Smith	The InterfaceControl was split into two tables.  Changed to join the new Interface reference table.  CR 2516
**	12/09/08	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/05/09	D. Askew	Return all interface parameters to load the Interface object (CR 2606)
**	07/18/16	M. Glaze	Extend proc to support all functionality previously in spHL7GetInterfaceControlParameters (Defect 340457).
**	09/23/16	M. Glaze	Replace logic in spHL7GetInterface proc with similar logic in the new view V_LinearInterface (Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spHL7GetInterface]
(
	@interfaceapplicationid	varchar(50) = null,
	@vbecsapplicationid	varchar(50) = null,
	@interfacename		varchar(50) = null,
    @interfaceid		tinyint = null
)

AS

SET NOCOUNT ON

	SELECT 		
			vl.[InterfaceId],
			vl.[InterfaceName], 
			vl.[FieldSeparator], 
			vl.[EncodingCharacters], 
			vl.[InterfaceApplicationID], 
			vl.[VbecsApplicationID], 
			vl.[VersionID], 
			vl.[ApplicationAckType], 
			
			vl.[VbecsFacilityID],
			vl.[LogEventsIndicator],
			vl.[ProcessingID],
			vl.[PurgeSuccessfulMessage],
			vl.[PurgeUnSuccessfulMessage],

			vl.EndPointId

	FROM 	V_LinearInterface vl

	WHERE 	
		( @interfacename IS NOT NULL AND vl.InterfaceName = @interfacename )
	
		OR 

		( @interfaceid IS NOT NULL AND vl.InterfaceId = @interfaceid )
	
		OR 

		( @interfaceapplicationid IS NOT NULL AND @vbecsapplicationid IS NOT NULL AND vl.InterfaceApplicationId = @interfaceapplicationid AND vl.VbecsApplicationId = @vbecsapplicationid )

		OR
		
		( @interfacename IS NULL AND @interfaceid IS NULL AND @interfaceapplicationid IS NULL AND @vbecsapplicationid IS NULL )

SET NOCOUNT OFF







GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7GetPendingTransmissionMessages]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7GetPendingTransmissionMessages]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**        Desc:         Gets HL7 Messages with a PendingTransmission state and sets the 
**                MessageStatus to Awaiting Response.
**
**        Author: Brian Tomlin        
**
**        Date:         3/04/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date	Name	Description
**        -----------   -------------       ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	06/29/05	N. Paterson	** Reviewed for compliance with database standards and recommendations **
**							Comment Header Adjusted,  Added NOCOUNT, Specified table owners
**	03/17/11	D. Askew	Removed commented-out code; added TansmitCount (CR 2962)
**	03/20/11	D. Askew	Added code to NOT return messages which have been re-sent ReTransmitAttempts + 1 (CR 2967)
**	04/18/11	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	06/19/12	C. Van Stedum	Changed the where clause of the first update statement so that it could grab the first row with a status of 1 and has not exceeded its retry attempts CR 3233
**	06/26/12	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	07/18/16	M. Glaze	Updated to reflect changes made for VbecsAdmin configuration such as deleting InterfaceControl table (Defect 340457).
**	11/29/16	M. Glaze	Remove unused _ReTransmitAttempts lookups for individual interfaces (Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spHL7GetPendingTransmissionMessages]

AS 

SET NOCOUNT ON

DECLARE @pendingmessagelogid      INT
DECLARE @messagestream                   VARCHAR(3500)
DECLARE @interfaceid   TINYINT
DECLARE @messagecontrolid   VARCHAR(20)
DECLARE @transmitcount                      TINYINT

        UPDATE 
                        dbo.MessageLog 
        SET
                        @pendingmessagelogid = MessageLogId,
                        @interfaceid = InterfaceId,
                        @messagecontrolid = MessageControlId,
                        @messagestream = MessageStream,
                        @transmitcount = TransmitCount,
                        MessageStatusCode =  8,
                        LastUpdateDate = GETUTCDATE(),
                        LastUpdateUser = SUSER_NAME()
        WHERE
                        MessageLogId = (
                                            SELECT TOP 1 MessageLogId
                                            FROM dbo.MessageLog ML
											INNER JOIN dbo.Interface I ON ML.interfaceId = I.InterfaceId
											LEFT JOIN dbo.VbecsGlobalConfig vgcr on I.ApplicationName = vgcr.ApplicationName and vgcr.ParameterName = 'VBECS_ReTransmitAttempts'
                                            WHERE MessageStatusCode = 1
                                                and ISNULL(TransmitCount, 0) <= isnull(convert(int, vgcr.ParameterValue), 0)
                                                )

            --If there's a message to process, send back the fields 
            IF @pendingmessagelogid IS NOT NULL
                    BEGIN
                            SELECT    @interfaceid AS InterfaceId, 
                                                @messagecontrolid AS MessageControlId,
                                                @messagestream AS MessageStream,
                                                ISNULL(@transmitcount, 0) AS TransmitCount
                    END


SET NOCOUNT OFF


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7InsertMessageLog]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7InsertMessageLog]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Inserts entry in the MessageLog table
**
**	Author:	Brian Tomlin
**
**	Date: 	10/08/2003
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	01/10/05	D. Askew		Added @lastupdatedate
**	06/29/05	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Comment Header Adjusted, Added NOCOUNT, Specified table owners, NULLs are OK no change
					Did not add error checking as planned,  as it would change logic
**	09/02/05	Lohse		Changed comments field length from 255 to 510
**	07/18/16	M. Glaze	Changed InterfaceControlId to InterfaceId (Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spHL7InsertMessageLog]
(
	@messagestatuscode	INT,
	@messagecontrolid	VARCHAR(20),
	@messagetype		VARCHAR(13),
	@datetimeofmessage	DATETIME,
	@sendingapplication	VARCHAR(50),
	@receivingapplication	VARCHAR(50),
	@messagestream	VARCHAR(3500),
	@interfaceid	TINYINT,
	@errortext		VARCHAR(3500) = NULL,
	@lastupdateuser	VARCHAR(30),
	@lastupdatefunctionid	INT,
	@lastupdatedate	DATETIME
)
AS

SET NOCOUNT ON

DECLARE @ERROR		INT,
	@ROWCOUNT	INT

SET @ERROR = 0

IF EXISTS( 
	SELECT MessageControlID FROM dbo.MessageLog WHERE MessageControlID = @messagecontrolid
	)

	BEGIN
		UPDATE
			dbo.MessageLog
		SET
			MessageStatusCode = 	@messagestatuscode,
			MessageControlID =	@messagecontrolid,
			MessageType =		@messagetype,
			DateTimeOfMessage =	@datetimeofmessage,
			SendingApplication =	@sendingapplication,
			ReceivingApplication =	@receivingapplication,
			MessageStream =		@messagestream,
			InterfaceID =	@interfaceid,
			ErrorText =		@errortext,
			LastUpdateDate =	@lastupdatedate,
			LastUpdateUser =	@lastupdateuser,
			LastUpdateFunctionId =	@lastupdatefunctionid
		WHERE
			MessageControlID = @messagecontrolid
	END
		
			ELSE
		
	BEGIN
			INSERT INTO
				dbo.MessageLog
				(
				MessageStatusCode,
				MessageControlID,
				MessageType,
				DateTimeOfMessage,
				SendingApplication,
				ReceivingApplication,
				MessageStream,
				InterfaceID,
				ErrorText,
				LastUpdateDate,
				LastUpdateUser,
				LastUpdateFunctionId
				)
			VALUES
				(
				@messagestatuscode,
				@messagecontrolid,
				@messagetype,
				@datetimeofmessage,
				@sendingapplication,
				@receivingapplication,
				@messagestream,
				@interfaceid,
				@errortext,
				@lastupdatedate,
				@lastupdateuser,
				@lastupdatefunctionid
				)
			
			SELECT @ERROR = @@ERROR, @ROWCOUNT = @@ROWCOUNT
				IF (@ERROR = 0)
					IF @ROWCOUNT <> 1
						SET @ERROR = -1
	END

SET NOCOUNT OFF

RETURN (@ERROR)


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spHL7PurgeMessageLog]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spHL7PurgeMessageLog]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc: 	Purges HL7 messages from the MessageLog table based on criteria defined in VBECS Administrator (CR 2519)
**
**	Author:	David Askew
**
**	Date: 	11/22/08
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	7/28/11	D. Askew	Changed MessageStatusCode IN (2, 6) to MessageStatusCode IN (1, 2, 6, 7, 8) to handle purging
**					failed messages too. (CR 3059)
**	6/26/12	Lohse		Removed 2nd WHERE clause so that only processed messages are purged (MessageStatusCode = 3) CR 3233
**	6/26/12	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	8/04/16	P. Sanchez	Changed table references to use Interface table (Defect 340457).
**	2/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spHL7PurgeMessageLog]

AS

SET NOCOUNT ON

	DECLARE @RowCount INT
	
	DECLARE @Now DATETIME
	
	SET @RowCount = 0
	
	SET @Now = GETUTCDATE()
	
	DELETE ML
	
	FROM
		dbo.MessageLog ML
		
		JOIN dbo.Interface I ON ML.InterfaceId = I.InterfaceId
	
	WHERE 
	
		( MessageStatusCode = 3 AND ML.LastUpdateDate <= DATEADD(DAY, -PurgeSuccessfulMessage, @Now ) )
	

	SET @RowCount = @@ROWCOUNT


SET NOCOUNT OFF

RETURN (@RowCount)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInsertVbecsEndPoint]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInsertVbecsEndPoint]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc: 	Insert into VbecsEndPoint table (Defect 340457).
**
**	Author: Pablo Sanchez
**
**	Date: 	08/31/2016
*******************************************************************************************************************************************************************************
**	Modified:
**	Date			Name		Description
**	-------------------	-----------------------	-----------------------------------------------------------------------------------------------------------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInsertVbecsEndPoint]
(	
		@vbecsendpointid INT, 
		@endpointaddress varchar(255),
		@endpointport INT,
		@endpointtype varchar(50),
		@lastupdatedate DATETIME,
		@lastupdateuser varchar(30),
		@lastupdatefunctionid	INT

)
AS

SET NOCOUNT ON

DECLARE @error	INT
DECLARE @rowcount	INT


INSERT INTO [dbo].[VbecsEndPoint]
           (
			VbecsEndPointId,
			EndPointAddress,
			EndPointPort,
			EndPointType,
			LastUpdateDate,
			LastUpdateUser,
			LastUpdateFunctionId
			)
     VALUES
           (
		   @vbecsendpointid,
		   @endpointaddress,
		   @endpointport,
		   @endpointtype,
		   @lastupdatedate,
		   @lastupdateuser,
		   @lastupdatefunctionid
		   )


	SELECT @error = @@ERROR, @rowcount = @@ROWCOUNT

	IF @rowcount <> 1 RAISERROR( 50003, 16, 1, 'VbecsEndPoint', @rowcount )

SET NOCOUNT OFF

RETURN(@error)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetVbecsDivisions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetVbecsDivisions]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**	Desc:	Selects division informtion from VAMCDivision table
**
**	Author:	Stas Antropov
**
**	Date: 	03/23/2005
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/05/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Removed name from header comments, added set nocount, specified object owners, space out SQL
**	08/11/2005	J.Engstrom	Removed join on DaylightSavings table.  Removed selection of DaylightSavingsYear column.  
**					Changed to select DaylighSavingsStartDate & DaylighSavingsEndDate from VamcDivision table.
**	10/18/2007	C. Jensen	Added PrinterName field to accomodate retrieval of reports printer (CR 2320).
**	10/01/2009	K.Dobranowski	Added ReactivityPhaseCode (CR 2717)
**	08/18/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/01/2016	D. Kozlov	Added LabelPrinterEndPointId to SELECT, removed LabelPrinterComPortNumber, LabelPrinterIPAddress and LabelPrinterTcpPortNumber (Defect 340457).
**	12/19/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetVbecsDivisions]
(
	@activeonly BIT
)

AS

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT 		VamcDivision.DivisionCode, 
				DivisionGuid, 
				DivisionName, 
				ServiceTypeIndicator, 
				VamcDivision.IccbbaRegistrationNumber, 
				ElectronicCrossmatchIndicator, 
				VamcDivision.FacilityGuid, 
				AccessionAreaId,
				Facility.FacilityName,
				LocalSupplierGuid, 
				AntibodyScreenDisplayCode, 
				MaximumSpecimenExpirationDays, 
				AutomatedInstrumentIndicator, 
				LabelPrinterUseIndicator, 
				PrinterName,
				TimeZoneId, 
				DaylightSavingsTypeId, 
				DaylightSavingsStartDate, 
				DaylightSavingsEndDate,
				PrinterAlertsIndicator, 
				PrinterAlertsPrinterName, 
				PrinterOrderAlertTypeCode, 
				PrinterOrdersNeededHours, 
				IconAlertsIndicator, 
				IconOrderAlertTypeCode, 
				IconOrdersNeededHours, 
				IconRefreshRate, 
				LoginMessageText, 
				InvoiceTemplateText, 
				MedicalDirectorName, 
				LockInactivityTimeoutMin, 
				VamcDivision.RecordStatusCode,
				VamcDivision.[RowVersion],
				ReactivityPhaseCode,
				LabelPrinterEndPointId

	FROM 		dbo.VamcDivision 

			LEFT OUTER JOIN dbo.Facility 

			ON dbo.Facility.FacilityGuid = dbo.VamcDivision.FacilityGuid

	WHERE		( @activeonly = 1 AND dbo.VamcDivision.RecordStatusCode = 'A' ) OR ( @activeonly = 0 )

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInsertVbecsGlobalConfig]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInsertVbecsGlobalConfig]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc:	Inserts parameter into VbecsGlobalConfig table.
**
**	Author:	Carrie Van Stedum
**
**	Date: 	01/15/2013
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------	---------	------------------
**	11/01/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/04/2016	M. Glaze	Added update section (Defect 340457). 
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInsertVbecsGlobalConfig]
(
	@applicationname    VARCHAR(100),
	@parametername	 	VARCHAR(100),
	@parametervalue		VARCHAR(1000),
	@lastupdateuser 	VARCHAR(30),
	@lastupdatefunctionid 	INT,
	@lastupdatedate 	DATETIME
)

AS

SET NOCOUNT ON

	DECLARE @error INT,
		 @rowcount INT;

	if exists (select 1 from dbo.VbecsGlobalConfig where ApplicationName=@applicationname and ParameterName=@parametername)
	begin

		update dbo.VbecsGlobalConfig
			set ParameterValue = @parametervalue,
			    LastUpdateDate = @lastupdatedate,
				LastUpdateUser = @lastupdateuser,
				LastUpdateFunctionID = @lastupdatefunctionid
			where ApplicationName = @applicationname
			  and ParameterName = @parametername;

	end
	else
	begin

		INSERT INTO	dbo.VbecsGlobalConfig
	
				( applicationname,
				  ParameterName ,
				  ParameterValue ,
				  LastUpdateDate ,
				  LastUpdateUser ,
				  LastUpdateFunctionId
				)
		VALUES
		( 
				@applicationname,
				@parametername, 
				@parametervalue, 
				@lastupdatedate,
				@lastupdateuser, 
				@lastupdatefunctionid 
		);

		SELECT @error = @@ERROR,  @rowcount = @@ROWCOUNT;

	end;

		
	IF @rowcount <> 1 RAISERROR( 50002, 16, 1, 'VbecsGlobalConfig', @rowcount )

SET NOCOUNT OFF

RETURN(isnull(@error, 0))

GO






--Permission
GRANT EXECUTE ON  [dbo].[spGetVbecsEndPoint] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spUpdateVbecsEndPoint] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spUpdateVbecsGlobalConfig] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7GetInterface] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7GetPendingTransmissionMessages] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7InsertMessageLog] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spHL7PurgeMessageLog] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInsertVbecsEndPoint] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetVbecsDivisions] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInsertVbecsGlobalConfig] TO [VbecsAppUser]
GO



--Add Data
--Data Migration Script

declare @updateDate date;
set @updateDate = getUTCdate();

declare @updateUser varchar(255);
select @updateUser = 'VBECS'    ---nt_user_name from sys.dm_exec_sessions where session_id=@@SPID;

declare @applicationName varchar(100);
declare @parameterName varchar(100);
declare @parameterValue varchar(100);



/*
	*** SECTION 2: transfer data from InterfaceControl to new structure:
		- Interface
		- VbecsGlobalConfig
		- VbecsEndPoint
*/

-- 2.1. update ApplicationName and ConfigPrefix for interfaces
update i
	set i.ApplicationName = 'HL7Service',
		i.ConfigPrefix = 'Interface_' + i.InterfaceName
from Interface i;

-- 2.2. copy data from InterfaceControl to Interface
--		this replaces the values that were filled in by the default constraints above
update i
	set i.ProcessingId = ic.ProcessingId,
	    i.PurgeSuccessfulMessage = 7,
        i.PurgeUnSuccessfulMessage = 7,
        i.LogEventsIndicator = 1,
        i.VbecsFacilityId = 'VBECS',
		i.LastUpdateDate = '2016-09-15',
		i.LastUpdateUser = 'vhaishadupok'
from Interface i
inner join InterfaceControl ic on ic.InterfaceId = i.InterfaceId;


-- 2.3. loop through Interfaces and add EndPoints one by one

declare @interfaceId int;
declare @interfaceName varchar(255);
declare @interfaceIpAddress varchar(255);
declare @interfaceServerName nvarchar(255);
declare @interfacePortNumber int;
declare @interfaceEndPointId int;
declare @interfaceEndPointType varchar(255);

declare interfaceCursor cursor for
	select i.InterfaceId, i.InterfaceName, ic.InterfaceIPAddress, ic.InterfaceDomainName, ic.InterfacePortNumber
	from Interface i
	inner join InterfaceControl ic on ic.InterfaceId = i.InterfaceId;

open interfaceCursor;

fetch next from interfaceCursor 
	into @interfaceId, @interfaceName, @interfaceIpAddress, @interfaceServerName, @interfacePortNumber;

while @@FETCH_STATUS = 0
begin

	--print 'Insert endpoint for interface ' + @interfaceName + ' (' + format(@interfaceId, '0') + ')' + ' : ' + isnull(isnull(@interfaceIpAddress, @interfaceServerName), '<null>') + ' : ' + isnull(format(@interfacePortNumber, '0'), '<null>');

	set @interfaceEndPointId = null;

	-- clear the endpoint details if this is not one of the 2-way interfaces
	if not @interfaceName in ('CPRS', 'BCE_COTS')
	begin
		select @interfaceIpAddress = null, @interfaceServerName = null, @interfacePortNumber = null;
	end;



	set @interfaceEndPointType = (case 
			when not @interfaceIpAddress is null then 'IPAddress' 
			when not @interfaceServerName is null then 'DnsHostName'
			else 'None' end);

	set @interfaceIpAddress = rtrim(isnull(@interfaceIpAddress, @interfaceServerName));

	
	insert into VbecsEndPoint
	(EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)
	select 
		@interfaceIpAddress as [EndPointAddress],
		@interfacePortNumber as [EndPointPort],
		@interfaceEndPointType as [EndPointType],
		@updateDate as [LastUpdateDate],
		@updateUser as [LastUpdateUser],
		0 as [LastUpdateFunctionId];

	set @interfaceEndPointId = SCOPE_IDENTITY();

	update Interface set VbecsEndPointId = @interfaceEndPointId where InterfaceId = @interfaceId;


	-- 2.7. copy IsActive flag for interfaces into global config

	select 	
		@applicationName = 'HL7Service',
		@parameterName = i.ConfigPrefix + '_IsActive',
		@parameterValue = (case when ic.InterfaceActiveIndicator = 1 then 'True' else 'False' end)
	from Interface i 
	inner join InterfaceControl ic on i.InterfaceId = ic.InterfaceId
	where i.InterfaceId = @interfaceId;

	exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


	if @interfaceName in ('CPRS', 'BCE_COTS')
	begin

		-- 2.8. copy Facility ID for interfaces into global config

		select 
			@applicationName = 'HL7Service',
			@parameterName = i.ConfigPrefix + '_FacilityID',
			@parameterValue = ic.InterfaceFacilityId
		from Interface i 
		inner join InterfaceControl ic on i.InterfaceId = ic.InterfaceId
		where i.InterfaceId = @interfaceId;

		exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;

	end;


	fetch next from interfaceCursor 
		into @interfaceId, @interfaceName, @interfaceIpAddress, @interfaceServerName, @interfacePortNumber;
end;

close interfaceCursor;
deallocate interfaceCursor;


-- 2.9. copy EmailAlert Address from interfaces into global config (single global setting) - copy from CPRS
--		note: this field was previously called [InterfaceAdministratorName] - but is in fact an email address

select 
	@applicationName = 'HL7Service',
	@parameterName = 'VBECS_EmailAlertAddress',
	@parameterValue = ic.InterfaceAdministratorName
from Interface i 
inner join InterfaceControl ic on i.InterfaceId = ic.InterfaceId
where i.InterfaceName = 'CPRS';

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 2.10. copy Ack Timeout from CPRS interface to global config (single global setting)

select 
	@applicationName = 'HL7Service',
	@parameterName = 'VBECS_AckTimeout',
	@parameterValue = format(ic.AckTimeout, '0')
from Interface i 
inner join InterfaceControl ic on i.InterfaceId = ic.InterfaceId
where i.InterfaceName = 'CPRS';

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 2.11. copy ReTransmit Attempts from CPRS interface to global config (single global setting)
select 
	@applicationName = 'HL7Service',	
	@parameterName = 'VBECS_ReTransmitAttempts',
	@parameterValue = format(ic.ReTransmitAttempts, '0')
from Interface i 
inner join InterfaceControl ic on i.InterfaceId = ic.InterfaceId
where i.InterfaceName = 'CPRS';

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 2.12. insert new EndPoint record for VBECS HL7 Service - use values from CPRS interface
--		 note: override address - we only support localhost now

declare @hl7EndPointId int;

insert into VbecsEndPoint
(EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser)
select 
	CASE WHEN VbecsIPAddress IS NULL Then NULL ELSE 'localhost' END as [EndPointAddress],
	ic.VbecsPortNumber as [EndPointPort],
	CASE WHEN VbecsIPAddress IS NULL Then 'None' ELSE 'AnyLocal' END as [EndPointType],
	@updateDate as [LastUpdateDate],
	@updateUser as [LastUpdateUser]
from InterfaceControl ic
inner join Interface i on ic.InterfaceId = i.InterfaceId
where i.InterfaceName = 'CPRS';

select @hl7EndPointId = SCOPE_IDENTITY();

select 
	@applicationName = 'HL7Service',
	@parameterValue = format(@hl7EndPointId, '0'),
	@parameterName = 'VBECS_EndPoint';

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


/*
	*** SECTION 3: pull values for VistaLink into tables:
		-- VbecsGlobalConfig
		-- VbecsEndPoint
*/

-- 3.1. insert address/port data for Vista interface from VistaLinkControl to VbecsEndPoint

declare @vistaInterfaceEndPointId int;

insert into VbecsEndPoint
(EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser)
select 
	rtrim(isnull (CONVERT (VARCHAR (200),vlc.VistaIpAddress), vlc.VistaDomainName)) as [EndPointAddress],
	vlc.VistaPortNumber as [EndPointPort],
	(case 
		when not vlc.VistaIpAddress is null then 'IPAddress' 
		when not vlc.VistaDomainName is null then 'DnsHostName'
		else 'None' end) as [EndPointType],
	@updateDate as [LastUpdateDate],
	@updateUser as [LastUpdateUser]
from (select null as x) vlc_null
left join VistaLinkControl vlc on 1 = 1;

select @vistaInterfaceEndPointId = SCOPE_IDENTITY();

-- 3.2. insert endpoint id for Vista interface into VbecsGlobalConfig

select 
	@applicationName = 'Vbecs',	
	@parameterName = 'Interface_Vista_EndPoint',
	@parameterValue = format(@vistaInterfaceEndPointId, '0');

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;

-- 3.3. insert address/port data for Vista service from VistaLinkControl to VbecsEndPoint

declare @vistaServiceEndPointId int;

insert into VbecsEndPoint
(EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser)
select 
	CASE WHEN VbecsServiceIPAddress IS NULL Then NULL ELSE 'localhost' END as [EndPointAddress],
	vlc.VbecsServicePortNumber as [EndPointPort],
	CASE WHEN VbecsServiceIPAddress IS NULL Then 'None' ELSE 'AnyLocal' END as [EndPointType],
	@updateDate as [LastUpdateDate],
	@updateUser as [LastUpdateUser]
from (select null as x) vlc_null
left join VistaLinkControl vlc on 1 = 1;

select @vistaServiceEndPointId = SCOPE_IDENTITY();

-- 3.4. insert endpoint id for Vista service into VbecsGlobalConfig

select 
	@applicationName = 'VistALinkService',	
	@parameterName = 'VBECS_EndPoint',
	@parameterValue = format(@vistaServiceEndPointId, '0');

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 3.4.1 Insert NULL values for Vista Broker IP and Port number 

declare @vistaBrokerEndPointId int;

insert into VbecsEndPoint
(EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser)

	VALUES ('0.0.0.0', 1024, 'IPAddress', @updateDate, @updateUser)  

select @vistaBrokerEndPointId = SCOPE_IDENTITY();

-- 3.4.2 insert endpoint id for Vista service into VbecsGlobalConfig

select 
	@applicationName = 'Vbecs',	
	@parameterName = 'Interface_Vista_BrokerEndPoint',
	@parameterValue = format(@vistaBrokerEndPointId, '0');

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 3.5. insert IsActive flag for Vista interface into VbecsGlobalConfig

select 
       @applicationName = 'VistALinkService',   
       @parameterName = 'Interface_Vista_IsActive',
       @parameterValue = 'True';

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 3.6. insert IsActive flag for Vista service into VbecsGlobalConfig

select 
       @applicationName = 'VistALinkService',   
       @parameterName = 'VBECS_IsActive',
       @parameterValue = 'True';

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 3.7. insert IsActive flag for HL7 service into VbecsGlobalConfig

select 
       @applicationName = 'Hl7Service',  
       @parameterName = 'VBECS_IsActive',
       @parameterValue = 'True';

exec spInsertVbecsGlobalConfig @applicationname=@applicationName, @parametername=@parameterName, @parametervalue=@parameterValue, @lastupdateuser=@updateUser, @lastupdatefunctionid=0, @lastupdatedate=@updateDate;


-- 4.3. cursor to loop through each division record and copy label printer values to new VbecsEndPoint record

declare @divisionCode char(5);
declare @ipAddress varchar(255);
declare @portNumber int;
declare @printerEndPointId int;

declare vamcDivisionCursor cursor for
	select DivisionCode, LabelPrinterIPAddress, LabelPrinterTcpPortNumber 
	from VamcDivision;

open vamcDivisionCursor;

fetch next from vamcDivisionCursor 
	into @divisionCode, @ipAddress, @portNumber;

while @@FETCH_STATUS = 0
begin

	--print 'Insert endpoint for division ' + @divisionCode + ' : ' + isnull(@ipAddress, '<null>') + ' : ' + isnull(format(@portNumber, '0'), '<null>');

	set @printerEndPointId = null;

	--if not @ipAddress is null
	begin 

		insert into VbecsEndPoint
		(EndPointAddress, EndPointPort, EndPointType, LastUpdateDate, LastUpdateUser)
		select 
			rtrim(@ipAddress) as [EndPointAddress],
			@portNumber as [EndPointPort],
			(case 
				when not @ipAddress is null then 'IPAddress' 
				else 'None' end) as [EndPointType],
			@updateDate,
			@updateUser;

		set @printerEndPointId = SCOPE_IDENTITY();

	end;

	update VamcDivision set LabelPrinterEndPointID = @printerEndPointId where DivisionCode = @divisionCode;

	fetch next from vamcDivisionCursor 
		into @divisionCode, @ipAddress, @portNumber;
end;

close vamcDivisionCursor;
deallocate vamcDivisionCursor;


USE @DBNAME@_MIRROR
GO

update vdm 
        set vdm.LabelPrinterEndPointId = vd.LabelPrinterEndPointId 
from VamcDivision vdm 
inner join Syn_VamcDivision vd on vdm.DivisionCode = vd.DivisionCode; 



USE @DBNAME@
GO

-- Delete rows from [dbo].[VbecsGlobalConfig]
DELETE FROM [dbo].[VbecsGlobalConfig] WHERE [ApplicationName]='HL7Service' AND [ParameterName]='ListenerIpAddress'
DELETE FROM [dbo].[VbecsGlobalConfig] WHERE [ApplicationName]='HL7Service' AND [ParameterName]='ListenerPortNumber'
DELETE FROM [dbo].[VbecsGlobalConfig] WHERE [ApplicationName]='VistaLinkService' AND [ParameterName]='ListenerIpAddress'
DELETE FROM [dbo].[VbecsGlobalConfig] WHERE [ApplicationName]='VistaLinkService' AND [ParameterName]='ListenerPortNumber'
DELETE FROM [dbo].[VbecsGlobalConfig] WHERE [ApplicationName]='VbecsAdmin' AND [ParameterName]='VistAClientTimeout'
DELETE FROM [dbo].[VbecsGlobalConfig] WHERE [ApplicationName]='VistaLinkService' AND [ParameterName]='VistAClientTimeout'

--Delete rows from BrokenRuleSet

DELETE FROM dbo.BrokenRuleSet WHERE FormName = 'LabelPrinterConfig' AND FieldName IN ('ComPortNumberNotSet','ComPortNumberOutOfRange');

--Remove table and columns


ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT[FK_InterfaceControl_Interface]
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [PK_InterfaceControl]
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [DF_InterfaceControl_AckTimeout]
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [DF_InterfaceControl_ReTransmitAttempts]
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [DF_InterfaceControl_PurgeSuccessfulMessage]
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [DF_InterfaceControl_PurgeUnSuccessfulMessage]
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [DF_InterfaceControl_LogEventsIndicator]
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [DF_InterfaceControl_LastUpdateFunctionId]
GO

ALTER TABLE [dbo].[VistaLinkControl] DROP CONSTRAINT [PK_VistaLinkControl]
GO

ALTER TABLE [dbo].[VistaLinkControl] DROP CONSTRAINT [DF_VistaLinkControl_LastUpdateFunctionId]
GO

DROP INDEX [IX_InterfaceControl_InterfaceId] ON [dbo].[InterfaceControl]
GO

DROP TABLE [dbo].[VistaLinkControl]
GO

DROP TABLE [dbo].[InterfaceControl]
GO

DROP SYNONYM [dbo].[SynMirror_InterfaceControl]
GO

DROP SYNONYM [dbo].[SynMirror_V_InterfaceControl]
GO

DROP SYNONYM [dbo].[SynMirror_V_VistaLinkControl]
GO

DROP SYNONYM [dbo].[SynMirror_VistaLinkControl]
GO

ALTER TABLE [dbo].[VamcDivision] DROP
COLUMN [LabelPrinterComPortNumber],
COLUMN [LabelPrinterIPAddress],
COLUMN [LabelPrinterTcpPortNumber]
GO


IF OBJECT_ID(N'[dbo].[spHL7UpdateInterfaceControlParameters]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spHL7UpdateInterfaceControlParameters]
GO

IF OBJECT_ID(N'[dbo].[spUpdateVistALinkConfig]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spUpdateVistALinkConfig]
GO

IF OBJECT_ID(N'[dbo].[spInsertVistALinkConfig]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spInsertVistALinkConfig]
GO

IF OBJECT_ID(N'[dbo].[spGetVistALinkConfig]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spGetVistALinkConfig]
GO

IF OBJECT_ID(N'[dbo].[spHL7UpdateInterfaceControlStatus]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spHL7UpdateInterfaceControlStatus]
GO

IF OBJECT_ID(N'[dbo].[spHL7GetInterfaceControlParameters]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spHL7GetInterfaceControlParameters]
GO

IF OBJECT_ID(N'[dbo].[spHL7GetMessageTypesByInterfaceControlID]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spHL7GetMessageTypesByInterfaceControlID]
GO

IF OBJECT_ID(N'[dbo].[spGetInterfaceActiveIndicator]', 'P') IS NOT NULL
DROP PROCEDURE [dbo].[spGetInterfaceActiveIndicator]
GO


USE @DBNAME@_MIRROR
GO

ALTER TABLE [dbo].[InterfaceControl] DROP CONSTRAINT [PK_InterfaceControl]
GO

ALTER TABLE [dbo].[VistaLinkControl] DROP CONSTRAINT [PK_VistaLinkControl]
GO

DROP INDEX [IX_VistaLinkControl_MirrorDate] ON [dbo].[VistaLinkControl]
GO

DROP INDEX [IX_VistaLinkControl] ON [dbo].[VistaLinkControl]
GO

DROP VIEW [dbo].[V_VistaLinkControl]
GO

DROP VIEW [dbo].[V_InterfaceControl]
GO

DROP TABLE [dbo].[VistaLinkControl]
GO

DROP TABLE [dbo].[InterfaceControl]
GO

DROP SYNONYM [dbo].[Syn_InterfaceControl]
GO

DROP SYNONYM [dbo].[Syn_VistaLinkControl]
GO


ALTER TABLE [dbo].[VamcDivision] DROP
COLUMN [LabelPrinterComPortNumber],
COLUMN [LabelPrinterIPAddress],
COLUMN [LabelPrinterTcpPortNumber]
GO


/*---------------------------------------------------------
  Create the VamcDivision view in the Mirror database
  (now that both mirror/non-mirror are updated)
---------------------------------------------------------*/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_VamcDivision]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.V_VamcDivision
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****************************************************************************************************************************************************************
**	Name: 	V_VamcDivision
**
**	Desc: 	Returns data in VamcDivision table (main and mirror) (Defect 340457).
**
**	Author:	Kwame Adu-Poku
**
**	Date: 	09/19/2016
**
******************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------	---------	------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************************************************************/

CREATE VIEW V_VamcDivision
AS 
SELECT Source='MIRROR', MirrorId, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LabelPrinterEndPointId, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, MirrorDate
FROM dbo.VamcDivision
UNION ALL 
SELECT Source='ACTIVE', 0, DivisionCode, DivisionGuid, DivisionName, ServiceTypeIndicator, IccbbaRegistrationNumber, ElectronicCrossmatchIndicator, FacilityGuid, LocalSupplierGuid, AntibodyScreenDisplayCode, MaximumSpecimenExpirationDays, AutomatedInstrumentIndicator, LabelPrinterUseIndicator, TimeZoneId, DaylightSavingsTypeId, PrinterName, PrinterAlertsIndicator, PrinterAlertsPrinterName, PrinterOrderAlertTypeCode, PrinterOrdersNeededHours, IconAlertsIndicator, IconOrderAlertTypeCode, IconOrdersNeededHours, IconRefreshRate, LoginMessageText, InvoiceTemplateText, MedicalDirectorName, UsaIndicator, LockInactivityTimeoutMin, AccessionAreaId, DaylightSavingsStartDate, DaylightSavingsEndDate, ReactivityPhaseCode, RecordStatusCode, LabelPrinterEndPointId, LastUpdateDate, LastUpdateUser, [ROWVERSION], LastUpdateFunctionId, LastUpdateDate AS MirrorDate 
FROM Syn_VamcDivision
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

--Permissions

GRANT SELECT ON dbo.V_VamcDivision TO VbecsAppMirrorUser
GO

ALTER TABLE [dbo].[VamcDivision] ALTER COLUMN [LabelPrinterEndPointId] int NOT NULL


USE @DBNAME@
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetVbecsUserDivisionsAndRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetVbecsUserDivisionsAndRoles]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Retrieves divisions with associated roles (including inactive) for a given user.
**
**	Author: Stas Antropov
**
**	Date: 	11/15/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date			Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	02/14/2005	Stas Antropov	Added where clause to exclude system users. 
**	07/05/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					Removed name, input/output descriptions from header comment, added set nocount, capitalized AS,
**					placed rowcount in square brackets, spaced out SQL, specified object owners
**	08/15/2005	J. Engstrom	Removed join on DaylightSavings table.  Removed selection of DaylightSavingsYear column.  
**						Changed to select DaylighSavingsStartDate & DaylighSavingsEndDate from VamcDivision table.
**	10/18/2007	C. Jensen	Added PrinterName field to accomodate retrieval of reports printer (CR 2320).
**	10/01/2009	K. Dobranowski	Added ReactivityPhaseCode (CR 2717)
**	08/18/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/13/2016	Pablo Sanchez	Removed LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber columns and added LabelPrinterEndPointId column (Defect 340457).
**	12/19/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetVbecsUserDivisionsAndRoles]
(
	@vbecsuserid	VARCHAR (30)
)
AS 

DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT		
		VamcDivision.DivisionCode, 
		VamcDivision.DivisionGuid, 
		VamcDivision.DivisionName, 
		VamcDivision.ServiceTypeIndicator, 
		VamcDivision.IccbbaRegistrationNumber, 
		VamcDivision.ElectronicCrossmatchIndicator, 
		VamcDivision.FacilityGuid, 
		VamcDivision.AccessionAreaId,
		VamcDivision.LocalSupplierGuid, 
		VamcDivision.AntibodyScreenDisplayCode, 
		VamcDivision.MaximumSpecimenExpirationDays, 
		VamcDivision.AutomatedInstrumentIndicator, 
		VamcDivision.LabelPrinterUseIndicator, 
		VamcDivision.PrinterName,
		VamcDivision.TimeZoneId, 
		VamcDivision.DaylightSavingsTypeId, 
		VamcDivision.DaylightSavingsStartDate, 
		VamcDivision.DaylightSavingsEndDate,
		VamcDivision.PrinterAlertsIndicator, 
		VamcDivision.PrinterAlertsPrinterName, 
		VamcDivision.PrinterOrderAlertTypeCode, 
		VamcDivision.PrinterOrdersNeededHours, 
		VamcDivision.IconAlertsIndicator, 
		VamcDivision.IconOrderAlertTypeCode, 
		VamcDivision.IconOrdersNeededHours, 
		VamcDivision.IconRefreshRate, 
		VamcDivision.LoginMessageText, 
		VamcDivision.InvoiceTemplateText, 
		VamcDivision.MedicalDirectorName, 
		VamcDivision.LockInactivityTimeoutMin, 
		VamcDivision.RecordStatusCode,
		VamcDivision.[RowVersion],
		VamcDivision.ReactivityPhaseCode,
		VamcDivision.LabelPrinterEndPointId,
		UserRole.UserRoleID,
		UserRole.UserRoleName, 
		VbecsUserDivisionRole.RecordStatusCode 	AS UserDivisionRoleRecordStatusCode,
		VbecsUserDivisionRole.[RowVersion] 		AS UserDivisionRoleRowVersion

	FROM		dbo.VamcDivision 

	INNER JOIN 	dbo.VbecsUserDivisionRole ON 

		dbo.VamcDivision.DivisionCode =dbo.VbecsUserDivisionRole.DivisionCode

		INNER JOIN 	dbo.UserRole ON 
	
			dbo.VbecsUserDivisionRole.UserRoleId = dbo.UserRole.UserRoleId
	
			INNER JOIN	dbo.VbecsUser ON 
		
				dbo.VbecsUser.VbecsUserId = dbo.VbecsUserDivisionRole.VbecsUserId

	WHERE		dbo.VbecsUserDivisionRole.VbecsUserId = @vbecsuserid

		AND 	SystemUserIndicator <> 1;

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInsertVamcDivisionBase]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInsertVamcDivisionBase]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**
**	Desc: 	Adds the information to the VamcDivision table.
**
**	Author: 	Stas Antropov
**
**	Date: 	07/23/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	------------		------------			-------------------
**	10/31/2004	Stas Antropov		Added @facilityguid, @accessionareaid,  
**						@daylightsavingsstartdate and @daylightsavingsenddate
**	12/2/2004	Stas Antropov		Added InvoiceTemplateText (BR_17.05).
**	01/10/2005	D. Askew		Added @lastupdatedate
**	06/06/2005 	D. Askew		** Reviewed for compliance with database standards and recommendations **
**						Removed execution option SET XACT_ABORT ON; changed SQL key words to all caps;
**						Minor changes made to error handling; verified NO COUNT is ON/OFF; changed to return 
**						@error rather than always 0; removed superfluous BEGIN/END
**	06/28/2005 	D. Askew		Comments updated
**	07/28/2005	D. Askew		Removed call to spSaveVamcDivisionDaylightSavingsConfig (now handled in code);
**						removed unused parameters @daylightsavingsstartdate and @daylightsavingsenddate
**	08/11/2005	J. Engstrom		Added  parameters @daylightsavingsstartdate and @daylightsavingsenddate.
**						Changed procedure to set DaylightSavingsStartDate and DaylightSavingsEndDate on the VamcDivision table.
**	10/18/2007	C. Jensen		Added PrinterName field to accomodate insertion of reports printer name (CR 2320).
**	09/13/2016	Pablo Sanchez	Removed LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber columns (Defect 340457).
**	10/14/2016	Michael Lerner	Added @labelprinterendpointaddress,@labelprinterendpointport,@labelprinterendpointtype,removed NULL from @timezoneid,
**								added Insert statement into EndPointTable,select statement IDENT_CURRENT('dbo.VbecsEndPoint') (Defect 340457). 
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **			
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInsertVamcDivisionBase]
(
	@divisioncode		CHAR(5),
	@divisionname			VARCHAR(50),
	@divisionguid			UNIQUEIDENTIFIER,
	@facilityguid			UNIQUEIDENTIFIER,
	@localsupplierguid		UNIQUEIDENTIFIER,
	@accessionareaid		INT,
	@servicetypeindicator		BIT,
	@labelprinteruseindicator 	BIT,
	@printername			VARCHAR(50)	= NULL, -- not supplied if no printers are installed on the server	
	@timezoneid			CHAR(1), 
	@daylightsavingstypeid		SMALLINT,
	@daylightsavingsstartdate	DATETIME	= NULL, -- not supplied if division doesn't use custom daylight savings
	@daylightsavingsenddate	DATETIME	= NULL, -- not supplied if division doesn't use custom daylight savings
	@lockinactivitytimeoutmin 	INT,
	@invoicetemplatetext		VARCHAR(1000),
	@recordstatuscode		CHAR(1),
	@lastupdateuser 		VARCHAR(30), 
	@lastupdatefunctionid		INT,
	@lastupdatedate		DATETIME,
	@labelprinterendpointaddress	VARCHAR(255) = NULL,
	@labelprinterendpointport		INT = NULL,
	@labelprinterendpointtype		VARCHAR(50)
)

AS

SET NOCOUNT ON

DECLARE @error	INT
DECLARE @rowcount	INT
DECLARE @labelprinterendpointid INT

BEGIN TRANSACTION InnerTran	
	BEGIN TRY

		INSERT INTO dbo.VbecsEndPoint
		(
			EndPointAddress,
			EndPointPort,
			EndPointType,
			LastUpdateDate,
			LastUpdateUser,
			LastUpdateFunctionId
		)
		VALUES
		(
			@labelprinterendpointaddress,
			@labelprinterendpointport,
			@labelprinterendpointtype,
			@lastupdatedate,
			@lastupdateuser,
			@lastupdatefunctionid
		)  
	END TRY
	BEGIN CATCH
		SELECT @error = @@ERROR, @rowcount = @@ROWCOUNT
		IF @rowcount <> 1	
			BEGIN
				RAISERROR( 50003, 16, 1, 'VbecsEndPoint', @rowcount )
				IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION InnerTran	     
				SET NOCOUNT OFF
				RETURN(@error)			
			END
	END CATCH
    
	BEGIN TRY	
 		SELECT @labelprinterendpointid = IDENT_CURRENT('dbo.VbecsEndPoint'), @rowcount = @@ROWCOUNT, @error = @@ERROR
	END TRY
    BEGIN CATCH   
		IF @rowcount <> 1 
			BEGIN
				RAISERROR( 50003, 16, 1, 'VbecsEndPoint', @rowcount )
				IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION InnerTran
				SET NOCOUNT OFF          
				RETURN(@error)			
			END
	END CATCH
    
	BEGIN TRY		  
		INSERT INTO dbo.VamcDivision
		( 
			DivisionCode,
			DivisionName,
			DivisionGuid,
			FacilityGuid,
			LocalSupplierGuid,
			AccessionAreaId,
			ServiceTypeIndicator,
			LabelPrinterUseIndicator,
			PrinterName,	
			TimeZoneId,
			DaylightSavingsTypeId,
			DaylightSavingsStartDate,
			DaylightSavingsEndDate,
			LockInactivityTimeoutMin,		
			InvoiceTemplateText,
			LabelPrinterEndPointId,
			RecordStatusCode,
			LastUpdateDate,
			LastUpdateUser,
			LastUpdateFunctionId
		)
		VALUES 
		(
			@divisioncode,
			@divisionname,
			@divisionguid,
			@facilityguid,
			@localsupplierguid,
			@accessionareaid,
			@servicetypeindicator,
			@labelprinteruseindicator,
			@printername,	
			@timezoneid,
			@daylightsavingstypeid,
			@daylightsavingsstartdate,
			@daylightsavingsenddate,
			@lockinactivitytimeoutmin,
			@invoicetemplatetext,
			@labelprinterendpointid,
			@recordstatuscode,
			@lastupdatedate,
			@lastupdateuser,
			@lastupdatefunctionid
		)

	END TRY
	BEGIN CATCH
		SELECT @error = @@ERROR, @rowcount = @@ROWCOUNT
		IF @rowcount <> 1 
			BEGIN 
				IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION InnerTran
				RAISERROR( 50003, 16, 1, 'VamcDivision', @rowcount )
				SET NOCOUNT OFF          
				RETURN(@error)
			END
	END CATCH

	IF @@TRANCOUNT > 0 COMMIT TRANSACTION InnerTran  
	
	SELECT @error = @@ERROR

SET NOCOUNT OFF

RETURN(@error)



GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spUpdateVamcDivisionBase]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spUpdateVamcDivisionBase]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Updates information in the VamcDivision table.
**
**	Author: 	Stas Antropov
**
**	Date: 	07/23/2004
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	------------		------------		-------------------
**	10/31/2004	S. Antropov	Added @facilityguid, @accessionareaid, 
**					@daylightsavingsstartdate and @daylightsavingsenddate
**	01/10/2005	D. Askew	Added @lastupdatedate
**	07/28/2005	D. Askew	Capitalized all SQL keywords; removed SET XACT_ABORT ON/OFF;
**					added NOCOUNT ON/OFF; removed call to spSaveVamcDivisionDaylightSavingsConfig
**					(now handled in code); removed BEGIN/END; removed RETURN 0;
**					removed unused parameters @daylightsavingsstartdate and @daylightsavingsenddate;
**					changed parameter names to all lower case in UPDATE statement
**	08/11/2005	J. Engstrom	Changed procedure to set DaylightSavingsStartDate and DaylightSavingsEndDate on the VamcDivision table.
					Removed line calling spSaveVamcDivisionDaylightSavingsConfig.
**	07/12/2005	N.Paterson	** Secondary review for compliance with database standards and recommendations ** capitalized NULL
**	10/18/2007	C. Jensen	Added PrinterName field to accomodate update of reports printer name (CR 2320).
**	09/13/16	Pablo Sanchez	Removed LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber column added @labelprinterendpointid. Removed NULL from @timezoneid (Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spUpdateVamcDivisionBase]
(
	@divisioncode		CHAR(5),
	@divisionname 			VARCHAR(50),
	@divisionguid			UNIQUEIDENTIFIER, -- stub parameter, not used
	@facilityguid			UNIQUEIDENTIFIER,
	@localsupplierguid		UNIQUEIDENTIFIER,
	@accessionareaid		INT,
	@servicetypeindicator		BIT,
	@labelprinteruseindicator 	BIT,
	@printername			VARCHAR(50)	= NULL, -- not supplied if no printers are installed on the server
	@timezoneid			CHAR(1), 
	@daylightsavingstypeid		SMALLINT,
	@daylightsavingsstartdate 	datetime = NULL, -- not supplied if daylight savings is not custom	
	@daylightsavingsenddate	datetime = NULL, -- not supplied if daylight savings is not custom
	@lockinactivitytimeoutmin 	INT,
	@recordstatuscode		CHAR(1),
	@labelprinterendpointid INT,
	@lastupdateuser 		VARCHAR(30), 
	@lastupdatefunctionid		INT,
	@rowversion			ROWVERSION,
	@lastupdatedate		DATETIME
)

AS

SET NOCOUNT ON

DECLARE 	@ERROR INT,
		@ROWCOUNT INT;

	UPDATE
		dbo.VamcDivision
	SET 	
		DivisionName = @divisionname,
		FacilityGuid = @facilityguid,
		LocalSupplierGuid = @localsupplierguid,
		AccessionAreaId = @accessionareaid,
		ServiceTypeIndicator = @servicetypeindicator,
		LabelPrinterUseIndicator = @labelprinteruseindicator,
		PrinterName = @printername,
		TimeZoneId = @timezoneid,
		DaylightSavingsTypeId = @daylightsavingstypeid,
		DaylightSavingsStartDate = @daylightsavingsstartdate,
		DaylightSavingsEndDate = @daylightsavingsenddate,
		LockInactivityTimeoutMin = @lockinactivitytimeoutmin,		
		RecordStatusCode = @recordstatuscode,
		LabelPrinterEndPointId = @labelprinterendpointid,
		LastUpdateDate = @lastupdatedate,
		LastUpdateUser = @lastupdateuser,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE	
		DivisionCode = @divisioncode
		AND [RowVersion] = @rowversion

	SELECT @ERROR = @@ERROR, 
		@ROWCOUNT = @@ROWCOUNT

	IF @ERROR = 0 AND @ROWCOUNT <> 1 AND ( SELECT COUNT(1) FROM dbo.VamcDivision WHERE [RowVersion] = @rowversion ) <> 1 
		RAISERROR( 50001, 16, 127 )

	ELSE
	IF @ROWCOUNT <> 1 
		RAISERROR( 50002, 16, 1, 'VamcDivision', @ROWCOUNT )

SET NOCOUNT OFF

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetDivision]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetDivision]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**
**	Desc: 	Selects records from the VamcDivision table based on the primary key.
**
**	Author:	Cameron Taylor
**
**	Date: 	10/30/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date			Name		Description
**	04/08/2003	LMeyer		Added ServiceTypeIndicator, AntibodyScreenDisplayCode, AutoAboRhIndicator,
**						MaximumSpecimenExpirationDays
**	01/14/2004	C. Jensen	Added fields from pertaining to DivisionAlerts.
**	03/04/2004	C. Taylor	Added MedicalDirectorName.
**	04/08/2004	Greg Lohse	Adding DivisionGUID field
**	04/15/2004	C. Jensen	Added FacilityGUID
** 	06/25/2004	S. Antropov	Updatred list of columns
**	09/09/2004	S. Antropov	Added VamcDivision.AccessionAreaId
**	07/18/2005	D. Askew	** Reviewed for compliance with database standards and recommendations **
**						NO COUNT set OFF; comments updated; capitalized SQL statements; 
**						changed formatting slightly for readability
**	08/10/2005	J. Engstrom	Modified procedure to get DaylighSavingsStartDate and DayLightSavingsEndDate from VamcDivision 
**						table.  Removed Left Outer Join on DaylighSavings table.
**	10/18/2007	C. Jensen	Added PrinterName field to accomodate retrieval of reports printer (CR 2320).
**	10/01/2009	K. Dobranowski	Added ReactivityPhaseCode (CR 2717)
**	08/18/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/13/2016	Pablo Sanchez	Removed LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber columns and added LabelPrinterEndPointId column (Defect 340457).
**	12/19/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDivision]
(
	@divisioncode	CHAR(5)
)

AS

SET NOCOUNT ON

	SELECT 	VamcDivision.DivisionCode, 
			DivisionGuid, 
			DivisionName, 
			ServiceTypeIndicator, 
			VamcDivision.IccbbaRegistrationNumber, 
			ElectronicCrossmatchIndicator, 
			VamcDivision.FacilityGuid, 
			VamcDivision.AccessionAreaId,
			Facility.FacilityName,
			VamcDivision.LocalSupplierGuid, 
			AntibodyScreenDisplayCode, 
			MaximumSpecimenExpirationDays, 
			AutomatedInstrumentIndicator, 
			LabelPrinterUseIndicator, 
			PrinterName,
			TimeZoneId, 
			DaylightSavingsTypeId, 
			DaylightSavingsStartDate, 
			DaylightSavingsEndDate,
			PrinterAlertsIndicator, 
			PrinterAlertsPrinterName, 
			PrinterOrderAlertTypeCode, 
			PrinterOrdersNeededHours, 
			IconAlertsIndicator, 
			IconOrderAlertTypeCode, 
			IconOrdersNeededHours, 
			IconRefreshRate, 
			LoginMessageText, 
			InvoiceTemplateText, 
			MedicalDirectorName, 
			LockInactivityTimeoutMin, 
			VamcDivision.RecordStatusCode,
			VamcDivision.[RowVersion],
			ReactivityPhaseCode,
			LabelPrinterEndPointId
	FROM 		dbo.VamcDivision 
		LEFT OUTER JOIN dbo.Facility ON Facility.FacilityGuid = VamcDivision.FacilityGuid
	WHERE
		VamcDivision.DivisionCode = @divisionCode;	

RETURN @@ERROR

SET NOCOUNT OFF

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetVbecsGlobalConfigValue]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetVbecsGlobalConfigValue]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Selects parameter value from HL7 Client Monitor Config.
**
**	Author:	Carrie Van Stedum
**
**	Date: 	1/15/2013
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	11/01/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/13/16	P. Sanchez	Added LastUpdateFunctionId to SELECT (Defect 340457).
**	12/19/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetVbecsGlobalConfigValue]
(
	@applicationname	VARCHAR(100),
	@parametername 		VARCHAR(100)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT 	
		ParameterValue,
		LastUpdateUser,
		LastUpdateDate,
		[RowVersion],
		LastUpdateFunctionID
	FROM  	
		dbo.VbecsGlobalConfig
	WHERE 
		ApplicationName = @applicationname AND
		ParameterName = @parametername

SET @ERROR = @@ERROR

SET NOCOUNT OFF
 
RETURN(@ERROR)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAllVbecsGlobalConfigValue]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAllVbecsGlobalConfigValue]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Selects parameter value from HL7 Client Monitor Config.
**
**	Author:	Carrie Van Stedum
**
**	Date: 	1/15/2013
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	11/01/2013	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/13/2016	P. Sanchez	Added LastUpdateFunctionId to SELECT (Defect 340457).
**	12/19/2016	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAllVbecsGlobalConfigValue]
(
	@applicationname	VARCHAR(100)
)
AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT 	
		ParameterName,
		ParameterValue,
		LastUpdateUser,
		LastUpdateDate,
		[RowVersion],
		LastUpdateFunctionId
	FROM  	
		dbo.VbecsGlobalConfig
	WHERE 
		ApplicationName = @applicationname 

SET @ERROR = @@ERROR

SET NOCOUNT OFF
 
RETURN(@ERROR)

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trCreateExpiredOrderedComponentMessage]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trCreateExpiredOrderedComponentMessage]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Creates HL7 Component Order Update Message (CR 2368)
**
**	Author:	David Askew
**
**	Date: 	10/28/2009
**	
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	08/15/11	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	09/13/16	Pablo Sanchez	Changed to get Processing Id and VbecsFacilityId from Interface tables and InterfaceFaicilityId from VbecsGlobalConfgig table(Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE TRIGGER [dbo].[trCreateExpiredOrderedComponentMessage] 

ON [dbo].[OrderedComponent] 

FOR UPDATE 

AS 

IF EXISTS (SELECT OrderedComponentGuid FROM Inserted WHERE OrderStatusCode = 'X' AND TaskStatusCode = 'E') 

BEGIN	

	DECLARE @messageStream 		VARCHAR(3500)

	DECLARE @carriageReturn 		VARCHAR(5)	
	DECLARE @currentTime		DATETIME
	DECLARE @currentUtcTime		DATETIME
	DECLARE @hl7CurrentTime		VARCHAR(100)
	
	DECLARE @msh 			VARCHAR(875)
	DECLARE @pid 			VARCHAR(875)
	DECLARE @orc 			VARCHAR(875)
	DECLARE @obr 			VARCHAR(875)
	
	DECLARE @fieldSeparator 		CHAR(1)		-- Interface
	DECLARE @encodingCharacters		CHAR(4)		-- Interface
	DECLARE @interfaceApplicationId	VARCHAR(50)		-- Interface
	DECLARE @vbecsApplicationId		VARCHAR(50)		-- Interface
	DECLARE @versionId			VARCHAR(8)		-- Interface
	DECLARE @interfaceFacilityId		VARCHAR(20)		-- VbecsGlobalConfig
	DECLARE @processingId		CHAR(1)		-- Interface
	DECLARE @vbecsFacilityId		VARCHAR(20)		-- Interface
	
	DECLARE @componentSeparator	CHAR(1)
	DECLARE @messageControlId		VARCHAR(50)
	DECLARE @messageType		VARCHAR(13)
	DECLARE @orderControlCode		CHAR(2) 	
	DECLARE @namespaceId		VARCHAR(5)
	DECLARE @orderStatus			CHAR(2)
	DECLARE @orderComments		VARCHAR(255)
	
	DECLARE @patientLastName		VARCHAR(30)
	DECLARE @patientFirstName 		VARCHAR(30)
	DECLARE @patientMiddleName		VARCHAR(30)
	DECLARE @patientSexCode		CHAR(1)
	DECLARE @patientDob			VARCHAR(100)
	DECLARE @vistaPatientId 		VARCHAR(50)
	
	DECLARE @cprsOrderNumber		VARCHAR(20)
	DECLARE @vbecsOrderNumber		VARCHAR(25)
	DECLARE @orderGroupNumber		VARCHAR(30)
	DECLARE @orderStatusCode		CHAR(1)
	DECLARE @orderSpecialInstructions	VARCHAR(510)
	DECLARE @labOrderNumber		VARCHAR(20)
	DECLARE @labTestId			CHAR(15)
	DECLARE @cprsOrderableItemID	CHAR(2)
	DECLARE @componentClassName	VARCHAR(35)
	
	-- Get interface data for message
	SELECT 
		@fieldSeparator 			= I.FieldSeparator,
		@encodingCharacters 		= I.EncodingCharacters,
		@interfaceApplicationId 		= I.InterfaceApplicationId,
		@vbecsApplicationId 		= I.VbecsApplicationId,
		@versionId 			= I.VersionId,
		@interfaceFacilityId 		= VGC.ParameterValue,
		@processingId 			= I.ProcessingId,
		@vbecsFacilityId 		= I.VbecsFacilityId
	FROM
		dbo.Interface I
		LEFT JOIN dbo.VbecsGlobalConfig VGC on VGC.ApplicationName = I.ApplicationName
                        AND VGC.ParameterName = I.ConfigPrefix + '_FacilityID'

	WHERE
		I.InterfaceId = 1
	
	-- Get patient order data for message
	SELECT 
		@patientLastName 		= P.PatientLastName, 
		@patientFirstName		= P.PatientFirstName, 
		@patientMiddleName		= ISNULL(P.PatientMiddleName, ''), 
		@patientSexCode		= ISNULL(P.PatientSexCode, ''),
		@patientDob			= ISNULL(SUBSTRING(dbo.fnDateTimeConversionToHL7DateTime(P.PatientDob),0, 9), ''),
		@vistaPatientId			= CAST(P.VistaPatientId AS VARCHAR(50)), 
		@cprsOrderNumber		= OC.CprsOrderNumber,
		@vbecsOrderNumber		= CAST(OC.VbecsOrderNumber AS VARCHAR(25)), 
		@orderGroupNumber		= PO.OrderGroupNumber,
		@orderStatusCode		= OC.OrderStatusCode,
		@orderSpecialInstructions	= ISNULL(OC.OrderSpecialInstructions, ''),
		@labOrderNumber		= OC.LabOrderNumber,
		@labTestId			= OC.LabTestId,
		@cprsOrderableItemID		= CCLASS.CprsOrderableItemID, 
		@componentClassName		= CCLASS.ComponentClassName
	FROM 
		dbo.Patient P 
		JOIN dbo.PatientTreatment PT 		ON P.PatientGuid 		= PT.PatientGuid
		JOIN dbo.PatientOrder PO 		ON PT.PatientTreatmentGuid 	= PO.PatientTreatmentGuid
		JOIN dbo.OrderedComponent OC 	ON PO.PatientOrderGuid 	= OC.PatientOrderGuid
		JOIN dbo.ComponentClass CCLASS 	ON OC.ComponentClassId 	= CCLASS.ComponentClassId 
	WHERE 
		OC.OrderedComponentGuid 	= (SELECT OrderedComponentGuid FROM Inserted)
		AND OC.OrderStatusCode 	= 'X'
		AND TaskStatusCode 		= 'E'

	-- Set the variables values
	SET @carriageReturn 		= CHAR(13)
	SET @componentSeparator 	= SUBSTRING(@encodingCharacters, 1, 1)
	SET @currentUtcTime		= GETUTCDATE()
	-- Only used to calculate the time zone differential
	SET @currentTime		= GETDATE() 														

	SET @hl7CurrentTime 		= REPLACE(REPLACE(REPLACE(CONVERT(VARCHAR(36), @currentUtcTime, 20), ' ',''),'-',''),':','') 				-- yyyyMMddhhss
					 + '-0' + CONVERT( VARCHAR(10), ABS(DATEPART(HOUR,@currentTime) - DATEPART(HOUR,@currentUtcTime))) + '00'	-- Get time zone in -0500 format, where 5 is hrs from UTC

	SET @messageControlId		= 'VBECS' + REPLACE(REPLACE(REPLACE(REPLACE(CONVERT( VARCHAR(36), @currentUtcTime, 21 ),'-',''),' ',''),':',''),'.','')	-- yyyyMMddhhssccc (c = milliseconds)

	SET @messageType		 = 'OMG^O19' 
	SET @namespaceId		= 'VBEC'
	SET @orderStatus		= 'ZE'
	SET @orderComments		= 'Expired by background job'

	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			MSH SEGMENT	
	SET @msh = 
		'MSH' 
		+ @fieldSeparator 
		+ @encodingCharacters 
		+ @fieldSeparator 
		+ @vbecsApplicationId 
		+ @fieldSeparator 
		+ @vbecsFacilityId 
		+ @fieldSeparator 
		+ @interfaceApplicationId 
		+ @fieldSeparator 
		+ @interfaceFacilityId 
		+ @fieldSeparator 
		+ @hl7CurrentTime
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @messageType
		+ @fieldSeparator 
		+ @messageControlId
		+ @fieldSeparator 
		+ @processingId 
		+ @fieldSeparator 
		+ @versionId 
		+ @carriageReturn

	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			PID SEGMENT	
	SET @pid = 
		'PID' 
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @vistaPatientId
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @patientLastName
		+ @componentSeparator
		+ @patientFirstName
		+ @componentSeparator
		+ @patientMiddleName
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @patientDob
		+ @fieldSeparator 
		+ @patientSexCode
		+ @carriageReturn
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			ORC SEGMENT	
	SET @orc = 
		'ORC'
		+ @fieldSeparator
		+ 'SC' 				-- Always send a Status Change Order Control code
		+ @fieldSeparator
		+ @cprsOrderNumber
		+ @componentSeparator
		+ 'OR'
		+ @fieldSeparator
		+ @vbecsOrderNumber
		+ @componentSeparator
		+ @namespaceId
		+ @fieldSeparator
		+ @orderGroupNumber
		+ @fieldSeparator
		+ @orderStatus
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @componentSeparator
		+ @orderComments
		+ @carriageReturn
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			OBR SEGMENT	
	SET @obr = 
		'OBR'
		+ @fieldSeparator
		+ '1'				-- Set ID
		+ @fieldSeparator
		+ @cprsOrderNumber
		+ @componentSeparator
		+ 'OR'
		+ @fieldSeparator
		+ @vbecsOrderNumber
		+ @componentSeparator
		+ @namespaceId
		+ @fieldSeparator
		+ @cprsOrderableItemID
		+ @componentSeparator
		+ @componentClassName
		+ @componentSeparator
		+ '99VBC'
		+ @componentSeparator
		+ @componentSeparator
		+ @orderSpecialInstructions
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @labOrderNumber
		+ ';;;'
		+ @labTestId
		+ @carriageReturn
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- Create HL7 message
	SET @messageStream = @msh + @pid + @orc + @obr
	
	-- Insert HL7 into MessageLog table for transmission to CPRS (via Client Monitor Service)
	EXEC spHL7InsertMessageLog
		1, 
		@messageControlId,
		@messageType,
		@currentUtcTime,
		@vbecsApplicationId,
		@interfaceApplicationId,
		@messageStream,
		1,
		NULL,
		'System',
		-1,
		@currentUtcTime

END



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trSetOrderAcceptanceDateForOrderedComponent]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trSetOrderAcceptanceDateForOrderedComponent]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Sets the OrderAcceptanceDate
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	11/9/2009
**	
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	11/9/2009	Krzysztof Dobranowski	Initial creation (CR 2368)
**	08/15/11	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	02/14/17	K. Adu-Poku	Added dbo prefix to table name (Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE TRIGGER [dbo].[trSetOrderAcceptanceDateForOrderedComponent]
ON [dbo].[OrderedComponent]
FOR UPDATE 
AS 
	DECLARE @statusbeforeupdate CHAR
	DECLARE @statusafterupdate CHAR
	DECLARE @orderedcomponentguid UNIQUEIDENTIFIER

	SELECT @statusbeforeupdate = OrderStatusCode FROM DELETED
	SELECT @statusafterupdate = OrderStatusCode FROM INSERTED

IF (@statusbeforeupdate = 'P' AND @statusafterupdate = 'A')
BEGIN
	SELECT @orderedcomponentguid = OrderedComponentGuid FROM INSERTED

	UPDATE
		dbo.OrderedComponent
	SET
		OrderAcceptanceDate = GETUTCDATE()
	WHERE
		OrderedComponentGuid = @orderedcomponentguid

END



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trCreateExpiredOrderedTestMessage]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trCreateExpiredOrderedTestMessage]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Creates HL7 Component Order Update Message (CR 2368)
**
**	Author:	David Askew
**
**	Date: 	11/2/2009
**	
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	08/15/11	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	09/13/16	Pablo Sanchez	Changed to get Processing Id and VbecsFacilityId from Interface tables and InterfaceFaicilityId from VbecsGlobalConfgig table(Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE TRIGGER [dbo].[trCreateExpiredOrderedTestMessage] 

ON [dbo].[OrderedTest] 

FOR UPDATE 

AS 

IF EXISTS (SELECT OrderedTestGuid FROM Inserted WHERE OrderStatusCode = 'X' AND TaskStatusCode = 'E') 

BEGIN	

	DECLARE @messageStream 		VARCHAR(3500)
	
	DECLARE @carriageReturn 		VARCHAR(5)	
	DECLARE @currentTime		DATETIME
	DECLARE @currentUtcTime		DATETIME
	DECLARE @hl7CurrentTime		VARCHAR(100)
	
	DECLARE @msh 			VARCHAR(875)
	DECLARE @pid 			VARCHAR(875)
	DECLARE @orc 			VARCHAR(875)
	DECLARE @obr 			VARCHAR(875)
	
	DECLARE @fieldSeparator 		CHAR(1)		-- Interface
	DECLARE @encodingCharacters		CHAR(4)		-- Interface
	DECLARE @interfaceApplicationId	VARCHAR(50)		-- Interface
	DECLARE @vbecsApplicationId		VARCHAR(50)		-- Interface
	DECLARE @versionId			VARCHAR(8)		-- Interface
	DECLARE @interfaceFacilityId		VARCHAR(20)		-- VbecsGlobalConfig
	DECLARE @processingId		CHAR(1)		-- Interface
	DECLARE @vbecsFacilityId		VARCHAR(20)		-- Interface
	
	DECLARE @componentSeparator	CHAR(1)
	DECLARE @messageControlId		VARCHAR(50)
	DECLARE @messageType		VARCHAR(13)
	DECLARE @orderControlCode		CHAR(2) 	
	DECLARE @namespaceId		VARCHAR(5)
	DECLARE @orderStatus			CHAR(2)
	DECLARE @orderComments		VARCHAR(255)
	
	DECLARE @patientLastName		VARCHAR(30)
	DECLARE @patientFirstName 		VARCHAR(30)
	DECLARE @patientMiddleName		VARCHAR(30)
	DECLARE @patientSexCode		CHAR(1)
	DECLARE @patientDob			VARCHAR(100)
	DECLARE @vistaPatientId 		VARCHAR(50)
	
	DECLARE @cprsOrderNumber		VARCHAR(20)
	DECLARE @vbecsOrderNumber		VARCHAR(25)
	DECLARE @orderGroupNumber		VARCHAR(30)
	DECLARE @orderStatusCode		CHAR(1)
	DECLARE @orderSpecialInstructions	VARCHAR(510)
	DECLARE @labOrderNumber		VARCHAR(20)
	DECLARE @labTestId			CHAR(15)
	DECLARE @cprsOrderableItemID	CHAR(2)
	DECLARE @orderableTestName		VARCHAR(35)
	
	-- Get interface data for message
	SELECT 
		@fieldSeparator 			= I.FieldSeparator,
		@encodingCharacters 		= I.EncodingCharacters,
		@interfaceApplicationId 		= I.InterfaceApplicationId,
		@vbecsApplicationId 		= I.VbecsApplicationId,
		@versionId 			= I.VersionId,
		@interfaceFacilityId 		= VGC.ParameterValue,
		@processingId 			= I.ProcessingId,
		@vbecsFacilityId 		= I.VbecsFacilityId
	FROM
		dbo.Interface I
		LEFT JOIN dbo.VbecsGlobalConfig VGC on VGC.ApplicationName = I.ApplicationName
                        AND VGC.ParameterName = I.ConfigPrefix + '_FacilityID'
	WHERE
		I.InterfaceId = 1
	
	-- Get patient order data for message
	SELECT 
		@patientLastName 		= P.PatientLastName, 
		@patientFirstName		= P.PatientFirstName, 
		@patientMiddleName		= ISNULL(P.PatientMiddleName, ''), 
		@patientSexCode		= ISNULL(P.PatientSexCode, ''),
		@patientDob			= ISNULL(SUBSTRING(dbo.fnDateTimeConversionToHL7DateTime(P.PatientDob),0, 9), ''),
		@vistaPatientId			= CAST(P.VistaPatientId AS VARCHAR(50)), 
		@cprsOrderNumber		= OT.CprsOrderNumber,
		@vbecsOrderNumber		= CAST(OT.VbecsOrderNumber AS VARCHAR(25)), 
		@orderGroupNumber		= PO.OrderGroupNumber,
		@orderStatusCode		= OT.OrderStatusCode,
		@orderableTestName		= ORT.OrderableTestName,
		@labOrderNumber		= OT.LabOrderNumber,
		@labTestId			= OT.LabTestId,
		@cprsOrderableItemID		= ORT.CprsOrderableItemID
	FROM 
		dbo.Patient P 
		JOIN dbo.PatientTreatment PT 		ON P.PatientGuid 		= PT.PatientGuid
		JOIN dbo.PatientOrder PO 		ON PT.PatientTreatmentGuid	= PO.PatientTreatmentGuid
		JOIN dbo.OrderedTest OT 		ON PO.PatientOrderGuid 	= OT.PatientOrderGuid
		JOIN dbo.OrderableTest ORT 		ON OT.OrderableTestId 		= ORT.OrderableTestId
	WHERE 
		OT.OrderedTestGuid 		= (SELECT OrderedTestGuid FROM Inserted)
		AND OT.OrderStatusCode 	= 'X'
		AND OT.TaskStatusCode 	= 'E'
	
	-- Set the variables values
	SET @carriageReturn 		= CHAR(13)
	SET @componentSeparator 	= SUBSTRING(@encodingCharacters, 1, 1)
	SET @currentUtcTime		= GETUTCDATE()
	-- Only used to calculate the time zone differential
	SET @currentTime		= GETDATE()														
	
	SET @hl7CurrentTime 		= REPLACE(REPLACE(REPLACE(CONVERT(VARCHAR(36), @currentUtcTime, 20), ' ',''),'-',''),':','') 				-- yyyyMMddhhss
					 + '-0' + CONVERT( VARCHAR(10), ABS(DATEPART(HOUR,@currentTime) - DATEPART(HOUR,@currentUtcTime))) + '00'	-- Get time zone in -0500 format, where 5 is hrs from UTC
	
	SET @messageControlId		= 'VBECS' + REPLACE(REPLACE(REPLACE(REPLACE(CONVERT( VARCHAR(36), @currentUtcTime, 21 ),'-',''),' ',''),':',''),'.','')	-- yyyyMMddhhssccc (c = milliseconds)
	
	SET @messageType		 = 'OMG^O19' 
	SET @namespaceId		= 'VBEC'
	SET @orderStatus		= 'ZE'
	SET @orderComments		= 'Expired by background job'
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			MSH SEGMENT	
	SET @msh = 
		'MSH' 
		+ @fieldSeparator 
		+ @encodingCharacters 
		+ @fieldSeparator 
		+ @vbecsApplicationId 
		+ @fieldSeparator 
		+ @vbecsFacilityId 
		+ @fieldSeparator 
		+ @interfaceApplicationId 
		+ @fieldSeparator 
		+ @interfaceFacilityId 
		+ @fieldSeparator 
		+ @hl7CurrentTime
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @messageType
		+ @fieldSeparator 
		+ @messageControlId
		+ @fieldSeparator 
		+ @processingId 
		+ @fieldSeparator 
		+ @versionId 
		+ @carriageReturn
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			PID SEGMENT	
	SET @pid = 
		'PID' 
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @vistaPatientId
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @patientLastName
		+ @componentSeparator
		+ @patientFirstName
		+ @componentSeparator
		+ @patientMiddleName
		+ @fieldSeparator 
		+ @fieldSeparator 
		+ @patientDob
		+ @fieldSeparator 
		+ @patientSexCode
		+ @carriageReturn
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			ORC SEGMENT	
	SET @orc = 
		'ORC'
		+ @fieldSeparator
		+ 'SC' 				-- Always send a Status Change Order Control code
		+ @fieldSeparator
		+ @cprsOrderNumber
		+ @componentSeparator
		+ 'OR'
		+ @fieldSeparator
		+ @vbecsOrderNumber
		+ @componentSeparator
		+ @namespaceId
		+ @fieldSeparator
		+ @orderGroupNumber
		+ @fieldSeparator
		+ @orderStatus
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @componentSeparator
		+ @orderComments
		+ @carriageReturn
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- 			OBR SEGMENT	
	SET @obr = 
		'OBR'
		+ @fieldSeparator
		+ '1'				-- Set ID
		+ @fieldSeparator
		+ @cprsOrderNumber
		+ @componentSeparator
		+ 'OR'
		+ @fieldSeparator
		+ @vbecsOrderNumber
		+ @componentSeparator
		+ @namespaceId
		+ @fieldSeparator
		+ @cprsOrderableItemID
		+ @componentSeparator
		+ @orderableTestName
		+ @componentSeparator
		+ '99VBC'
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @fieldSeparator
		+ @labOrderNumber
		+ ';;;'
		+ @labTestId
		+ @carriageReturn
	
	-- ***************************************************************************************************************************************************************************************************************************************************************************** 
	-- Create HL7 message
	SET @messageStream = @msh + @pid + @orc + @obr
	
	-- Insert HL7 into MessageLog table for transmission to CPRS (via Client Monitor Service)
	EXEC spHL7InsertMessageLog
		1, 
		@messageControlId,
		@messageType,
		@currentUtcTime,
		@vbecsApplicationId,
		@interfaceApplicationId,
		@messageStream,
		1,
		NULL,
		'System',
		-1,
		@currentUtcTime

END



GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[trSetOrderAcceptanceDateForOrderedTest]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[trSetOrderAcceptanceDateForOrderedTest]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Sets the OrderAcceptanceDate
**
**	Author:	Krzysztof Dobranowski
**
**	Date: 	11/9/2009
**	
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	08/15/11	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	02/14/17	K. Adu-Poku	Added dbo prefix to table name (Defect 340457).
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE TRIGGER [dbo].[trSetOrderAcceptanceDateForOrderedTest]
ON [dbo].[OrderedTest]
FOR UPDATE 
AS 
	DECLARE @statusbeforeupdate CHAR
	DECLARE @statusafterupdate CHAR
	DECLARE @orderedtestguid UNIQUEIDENTIFIER

	SELECT @statusbeforeupdate = OrderStatusCode FROM DELETED
	SELECT @statusafterupdate = OrderStatusCode FROM INSERTED

IF (@statusbeforeupdate = 'P' AND @statusafterupdate = 'A')
BEGIN
	SELECT @orderedtestguid = OrderedTestGuid FROM INSERTED

	UPDATE
		dbo.OrderedTest
	SET
		OrderAcceptanceDate = GETUTCDATE()
	WHERE
		OrderedTestGuid = @orderedtestguid

END


GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAuditDivision]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAuditDivision]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Get Division audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/13/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	10/24/2007	K. Dobranowski Changed all JOINS to LEFT JOINS (CR 2312)
**	10/25/2007	K. Dobranowski Added PrinterName to SELECT statement (CR 2320)
**	10/02/2009	K.Dobranowski Added ReactivityPhaseCode to SELECT statement (CR 2717)
**	08/18/2010	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/14/2016	Pablo Sanchez	Removed LabelPrinterComPortNumber, LabelPrinterIPAddress, LabelPrinterTcpPortNumber columns and added LabelPrinterEndPointId column (Defect 340457).
**	10/02/2016	K. Dobranowski	Added second SELECT to get the Label Printer IP and Port (Defect 340457).
**	02/14/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditDivision]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	CHAR(5)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	SELECT

		VVD.DivisionCode,
		VVD.DivisionName,
		VVD.ServiceTypeIndicator,
		dbo.Facility.FacilityName,
		VVD.RecordStatusCode,
		VVD.LabelPrinterUseIndicator,
		VVD.AccessionAreaId,
		VVD.LockInactivityTimeoutMin,	
		dbo.TimeZone.TimeZoneName,
		dbo.DaylightSavingsType.DaylightSavingsTypeText,
		VVD.ElectronicCrossmatchIndicator,
		VVD.IccbbaRegistrationNumber,
		VVD.MaximumSpecimenExpirationDays,
		VVD.MedicalDirectorName,
		VVD.LoginMessageText,
		VVD.InvoiceTemplateText,
		dbo.AntibodyScreenDisplay.AntibodyScreenDisplayText,
		VVD.MirrorId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VVD.LastUpdateDate) AS MirrorDate,
		VVD.LastUpdateUser,
		VVD.DaylightSavingsStartDate,
		VVD.DaylightSavingsEndDate,
		VVD.PrinterName,
		VVD.ReactivityPhaseCode,
		VVD.LabelPrinterEndPointId

	FROM

		dbo.SynMirror_V_VamcDivision VVD

	LEFT JOIN dbo.Facility ON dbo.Facility.FacilityGuid = VVD.FacilityGuid

	LEFT JOIN dbo.TimeZone ON dbo.TimeZone.TimeZoneId = VVD.TimeZoneId
	LEFT JOIN dbo.AntibodyScreenDisplay ON dbo.AntibodyScreenDisplay.AntibodyScreenDisplayCode = VVD.AntibodyScreenDisplayCode
	LEFT JOIN dbo.DaylightSavingsType ON dbo.DaylightSavingsType.DaylightSavingsTypeId = VVD.DaylightSavingsTypeId
	
	WHERE

		VVD.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VVD.DivisionCode = @divisioncode
	
	ORDER BY

		VVD.DivisionCode,
		VVD.Source,
		VVD.MirrorId DESC

	--getting label printer IP and Port
	SELECT

		VD.DivisionCode,
		VD.DivisionName,
		VEP.EndPointPort,
		VEP.EndPointAddress,
		VEP.MirrorId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,
		VEP.LastUpdateUser

	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	LEFT JOIN dbo.VamcDivision VD ON VD.LabelPrinterEndPointId = VEP.VbecsEndPointId
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate  AND  @enddate

	AND

		VD.DivisionCode = @divisioncode
	
	ORDER BY

		VD.DivisionCode,
		VEP.Source,
		VEP.MirrorId DESC

SET @ERROR = @@ERROR


SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spVistaGetXmlBloodBankData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spVistaGetXmlBloodBankData]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Retrieves blood bank data XML to return to VistA
**
**	Author:	Brian Tomlin / Stas Antropov
**
**	Date: 	01/25/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------		---------		-----------------
**	07/19/05	C. Taylor	Added call to fnOrderedUnitCrossmatchResultCode to ensure latest crossmatch result is used 
**					(there may be repeat XMs)
**	06/29/05	N. Paterson	** Reviewed for compliance with database standards and recommendations **
**					Header added, Added NOCOUNT, Specified table owners, Removed comments, UPPERCASED SQL
**	08/21/05	S. Antropov	** Reviewed for compliance with database standards and recommendations **
**					Performed secondary review during the code promotion - merged changes
**	08/24/05	C. Taylor	Fixed typo introduced during compliance: INNER JOIN 
**					dbo.PatientTransfusionRequirement.PatientTransReq
**	09/09/05	D. Askew	Changed JOIN on Patient to select either the FinalMergeToPatient if the patient has one or more
**					merges (choosing the final merge record) or simply the patient guid if there are none
**	10/27/05	C. Jensen	Added code to not get ABO/Rh if from Db conversion.
**	01/23/06	M. Smith	** Reviewed for compliance with database standards and recommendations **
**	03/29/07	D. Askew	Made changes for DR 2595, see Assigned and crossmatched units: changed [Unit!10!expDate] to use 
**					BloodUnitMedia.UnitExpirationDate rather than PatientSpecimen.SpecimenExpirationDate; changed
**					INNER JOIN on dbo.PatientSpecimen to LEFT JOIN; added AND condition for 
**					dbo.PatientSpecimen.SpecimenExpirationDate, which will be NULL for certain blood product types
**	07/13/07	Lohse		Adding datetime conversion for CR2253.
**	05/13/08	M. Smith	Changed @VistaPatientID to BIGINT datatype (CR 2431)
**	06/04/08	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	01/04/10	M. Smith	Changed to get and check UnitStatusCode from the BloodUnitStatusCodeCurrent table. (CR 1174)
**	01/25/10	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	02/18/10	D. Askew 	Added noBloodRequiredIndicator to SELECT (CR 2742).
**	06/24/10	D. Askew	Reformatted SQL; removed merge code; added productCode to SELECT (CR 2806).
**	07/18/11	K. Dobranowski  Modified JOIN statements for PatientTransfusion record (CR 2901)
**	07/28/11	D. Askew	Added AND Msbos.RecordStatusCode <> 'X' to WHERE clause for MSBOS entries. (CR 3078)
**	10/14/11	M. Smith	Added AND MsbosComponentClass.RecordStatusCode <> 'X' to WHERE clause for MSBOS entries
**					and  Msbos.DivisionCode = @DivisionCode for surgery names. (CR 3156)
**	11/14/11	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	07/28/16	K. Adu-Poku	Added Surgery!19!name to the order by list. (Defect 334314)
**	07/28/16	K. Adu-Poku	Added statement to SELECT DivisionCode from AssociatedInstitution. (Defect 210520)
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spVistaGetXmlBloodBankData]
(
	@vistapatientid 	BIGINT,
	@divisioncode 	CHAR(5)
)
AS

SET NOCOUNT ON

DECLARE @patientfoundflag AS BIT;
DECLARE @patientguid AS UNIQUEIDENTIFIER;
DECLARE @abo AS VarChar(2);
DECLARE @rh AS VarChar(2);
	
		/****** Defect 210520: include associated institutions (convert parameter from associated division to a regular division) *******/
	IF EXISTS (SELECT 1 FROM dbo.AssociatedInstitution WHERE RecordStatusCode = 'A' AND InstitutionDivisionCode = @divisioncode)
		SELECT @divisioncode = AssociatedInstitution.DivisionCode FROM dbo.AssociatedInstitution WHERE RecordStatusCode = 'A' AND InstitutionDivisionCode = @divisioncode

		
	SELECT @patientfoundflag = ISNULL((	SELECT TOP 1 1
						FROM 	dbo.Patient
						WHERE	VistaPatientID = @vistapatientid), 0 );

	SELECT @patientguid = (SELECT TOP 1 PatientGuid FROM dbo.Patient P WHERE P.VistaPatientID = @vistapatientid);

	SELECT @abo = (SELECT ABO FROM dbo.fnGetABORhTable(@patientguid) WHERE TestDivision IS NOT NULL);

	SELECT @rh = (SELECT Rh FROM dbo.fnGetABORhTable(@patientguid) WHERE TestDivision IS NOT NULL);
		

	-- <BloodBank>
	SELECT	1					AS Tag,
			NULL					AS Parent,
			1					 AS [Bloodbank!1!GroupOrder!hide],
			NULL					 AS [Component!13!GroupOrder!hide],
			NULL 					 AS [Bloodbank!1],
			NULL					 AS [Patient!2!dfn],
			NULL					 AS [Patient!2!firstName],
			NULL					 AS [Patient!2!lastName],
			NULL					 AS [Patient!2!ssn],
			NULL					 AS [Patient!2!abo],
			NULL					 AS [Patient!2!rh],
			NULL					 AS [TransfusionReactions!3],
			NULL					 AS [TransfusionReaction!4!type],
			NULL					 AS [TransfusionReaction!4!date],
			NULL					 AS [TransfusionRequirements!5],
			NULL					 AS [TransfusionRequirement!6!modifier],
			NULL					 AS [Antibodies!7],
			NULL					 AS [Antibody!8!name],
			NULL					 AS [Units!9],
			NULL					 AS [Unit!10!status],
			NULL					 AS [Unit!10!id],
			NULL					 AS [Unit!10!product],
			NULL					 AS [Unit!10!productCode],
			NULL					 AS [Unit!10!location],
			NULL					 AS [Unit!10!expDate],
			NULL					 AS [Specimen!11!expDate],
			NULL					 AS [Specimen!11!uid],
			NULL					 AS [Components!12],
			NULL					 AS [Component!13!name],
			NULL					 AS [Component!13!id],
			NULL					 AS [Component!13!specimen],
			NULL					 AS [LabTests!14],
			NULL					 AS [LabTest!15!id],
			NULL					 AS [LabTest!15!name],
			NULL					 AS [MsbosList!16],
			NULL					 AS [Msbos!17!name],
			NULL					 AS [Msbos!17!threshold],
			NULL					 AS [Surgeries!18],
			NULL					 AS [Surgery!19!name],
			NULL					 AS [Surgery!19!noBloodRequiredIndicator]
	
	UNION ALL
	
	-- <Patient dfn="" firstName="" lastName="" ssn="" abo="" rh="">
	SELECT	2					AS Tag,
			1					AS Parent,
			2					 AS [Bloodbank!1!GroupOrder!hide],
			NULL					 AS [Component!13!GroupOrder!hide],
			NULL 					 AS [Bloodbank!1],
			P.VistaPatientID			 	AS [Patient!2!dfn],
			P.PatientFirstName			 AS [Patient!2!firstName],
			P.PatientLastName			 AS [Patient!2!lastName],
			P.PatientSSN				 AS [Patient!2!ssn],
			@abo 					AS [Patient!2!abo],
			@rh 					AS [Patient!2!rh],
			NULL					 AS [TransfusionReactions!3],
			NULL					 AS [TransfusionReaction!4!type],
			NULL					 AS [TransfusionReaction!4!date],
			NULL					 AS [TransfusionRequirements!5],
			NULL					 AS [TransfusionRequirement!6!modifier],
			NULL					 AS [Antibodies!7],
			NULL					 AS [Antibody!8!name],
			NULL					 AS [Units!9],
			NULL					 AS [Unit!10!status],
			NULL					 AS [Unit!10!id],
			NULL					 AS [Unit!10!product],
			NULL					 AS [Unit!10!productCode],
			NULL					 AS [Unit!10!location],
			NULL					 AS [Unit!10!expDate],
			NULL					 AS [Specimen!11!expDate],
			NULL					 AS [Specimen!11!uid],
			NULL					 AS [Components!12],
			NULL					 AS [Component!13!name],
			NULL					 AS [Component!13!id],
			NULL					 AS [Component!13!specimen],
			NULL					 AS [LabTests!14],
			NULL					 AS [LabTest!15!id],
			NULL					 AS [LabTest!15!name],
			NULL					 AS [MsbosList!16],
			NULL					 AS [Msbos!17!name],
			NULL					 AS [Msbos!17!threshold],
			NULL					 AS [Surgeries!18],
			NULL					 AS [Surgery!19!name],
			NULL					 AS [Surgery!19!noBloodRequiredIndicator]
	
	FROM		
		dbo.Patient P

	WHERE		
		P.VistaPatientID = @vistapatientid
	
	UNION ALL
	
	-- <TransfusionReactions>
	SELECT	3					AS Tag,
			2					AS Parent,
			2					 AS [Bloodbank!1!GroupOrder!hide],
			NULL					 AS [Component!13!GroupOrder!hide],
			NULL 					 AS [Bloodbank!1],
			NULL					 AS [Patient!2!dfn],
			NULL					 AS [Patient!2!firstName],
			NULL					 AS [Patient!2!lastName],
			NULL					 AS [Patient!2!ssn],
			NULL					 AS [Patient!2!abo],
			NULL					 AS [Patient!2!rh],
			NULL					 AS [TransfusionReactions!3],
			NULL					 AS [TransfusionReaction!4!type],
			NULL					 AS [TransfusionReaction!4!date],
			NULL					 AS [TransfusionRequirements!5],
			NULL					 AS [TransfusionRequirement!6!modifier],
			NULL					 AS [Antibodies!7],
			NULL					 AS [Antibody!8!name],
			NULL					 AS [Units!9],
			NULL					 AS [Unit!10!status],
			NULL					 AS [Unit!10!id],
			NULL					 AS [Unit!10!product],
			NULL					 AS [Unit!10!productCode],
			NULL					 AS [Unit!10!location],
			NULL					 AS [Unit!10!expDate],
			NULL					 AS [Specimen!11!expDate],
			NULL					 AS [Specimen!11!uid],
			NULL					 AS [Components!12],
			NULL					 AS [Component!13!name],
			NULL					 AS [Component!13!id],
			NULL					 AS [Component!13!specimen],
			NULL					 AS [LabTests!14],
			NULL					 AS [LabTest!15!id],
			NULL					 AS [LabTest!15!name],
			NULL					 AS [MsbosList!16],
			NULL					 AS [Msbos!17!name],
			NULL					 AS [Msbos!17!threshold],
			NULL					 AS [Surgeries!18],
			NULL					 AS [Surgery!19!name],
			NULL					 AS [Surgery!19!noBloodRequiredIndicator] 
	
	WHERE		
		@patientfoundflag = 1
	
	UNION ALL
	
	-- <TransfusionReaction type="" date="">
	SELECT DISTINCT	
			4					AS Tag,
			3					AS Parent,
			2					 AS [Bloodbank!1!GroupOrder!hide],
			NULL					 AS [Component!13!GroupOrder!hide],
			NULL 					 AS [Bloodbank!1],
			NULL					 AS [Patient!2!dfn],
			NULL					 AS [Patient!2!firstName],
			NULL					 AS [Patient!2!lastName],
			NULL					 AS [Patient!2!ssn],
			NULL					 AS [Patient!2!abo],
			NULL					 AS [Patient!2!rh],
			NULL					 AS [TransfusionReactions!3],
			TRT.TransfusionReactionTypeText	 AS [TransfusionReaction!4!type],
			dbo.fnDateTimeConversionToHL7DateTime(dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, PTR.NotedDateTime ))		 AS [TransfusionReaction!4!date],
			NULL					 AS [TransfusionRequirements!5],
			NULL					 AS [TransfusionRequirement!6!modifier],
			NULL					 AS [Antibodiess!7],
			NULL					 AS [Antibody!8!name],
			NULL					 AS [Units!9],
			NULL					 AS [Unit!10!status],
			NULL					 AS [Unit!10!id],
			NULL					 AS [Unit!10!product],
			NULL					 AS [Unit!10!productCode],
			NULL					 AS [Unit!10!location],
			NULL					 AS [Unit!10!expDate],
			NULL					 AS [Specimen!11!expDate],
			NULL					 AS [Specimen!11!uid],
			NULL					 AS [Components!12],
			NULL					 AS [Component!13!name],
			NULL					 AS [Component!13!id],
			NULL					 AS [Component!13!specimen],
			NULL					 AS [LabTests!14],
			NULL					 AS [LabTest!15!id],
			NULL					 AS [LabTest!15!name],
			NULL					 AS [MsbosList!16],
			NULL					 AS [Msbos!17!name],
			NULL					 AS [Msbos!17!threshold],
			NULL					 AS [Surgeries!18],
			NULL					 AS [Surgery!19!name],
			NULL					 AS [Surgery!19!noBloodRequiredIndicator] 
	
	FROM		
		dbo.PatientTransfusionReaction PTR
	
		JOIN dbo.Patient P 
			ON P.PatientGuid = PTR.PatientGuid
	
		LEFT JOIN dbo.TransfusionReactionType TRT 
			ON TRT.TransfusionReactionTypeCode = PTR.TransfusionReactionTypeCode
	
	WHERE		
		P.VistaPatientID = @vistapatientid

		AND PTR.RecordStatusCode NOT IN ('X','I','E')

		AND @patientfoundflag = 1
			
	UNION ALL 
	
	-- <TransfusionRequirements>
	SELECT	5					AS Tag,
			2					AS Parent,
			2					 AS [Bloodbank!1!GroupOrder!hide],
			NULL					 AS [Component!13!GroupOrder!hide],
			NULL 					 AS [Bloodbank!1],
			NULL					 AS [Patient!2!dfn],
			NULL					 AS [Patient!2!firstName],
			NULL					 AS [Patient!2!lastName],
			NULL					 AS [Patient!2!ssn],
			NULL					 AS [Patient!2!abo],
			NULL					 AS [Patient!2!rh],
			NULL					 AS [TransfusionReactions!3],
			NULL					 AS [TransfusionReaction!4!type],
			NULL					 AS [TransfusionReaction!4!date],
			NULL					 AS [TransfusionRequirements!5],
			NULL					 AS [TransfusionRequirement!6!modifier],
			NULL					 AS [Antibodies!7],
			NULL					 AS [Antibody!8!name],
			NULL					 AS [Units!9],
			NULL					 AS [Unit!10!status],
			NULL					 AS [Unit!10!id],
			NULL					 AS [Unit!10!product],
			NULL					 AS [Unit!10!productCode],
			NULL					 AS [Unit!10!location],
			NULL					 AS [Unit!10!expDate],
			NULL					 AS [Specimen!11!expDate],
			NULL					 AS [Specimen!11!uid],
			NULL					 AS [Components!12],
			NULL					 AS [Component!13!name],
			NULL					 AS [Component!13!id],
			NULL					 AS [Component!13!specimen],
			NULL					 AS [LabTests!14],
			NULL					 AS [LabTest!15!id],
			NULL					 AS [LabTest!15!name],
			NULL					 AS [MsbosList!16],
			NULL					 AS [Msbos!17!name],
			NULL					 AS [Msbos!17!threshold],
			NULL					 AS [Surgeries!18],
			NULL					 AS [Surgery!19!name],
			NULL					 AS [Surgery!19!noBloodRequiredIndicator] 
	
	WHERE		
		@patientfoundflag = 1
	
	UNION ALL
	
	-- <TransfusionRequirement modifier="" >
	SELECT	6								AS Tag,
			5								AS Parent,
			2					 			AS [Bloodbank!1!GroupOrder!hide],
			NULL					 			AS [Component!13!GroupOrder!hide],
			NULL 					 			AS [Bloodbank!1],
			NULL					 			AS [Patient!2!dfn],
			NULL					 			AS [Patient!2!firstName],
			NULL					 			AS [Patient!2!lastName],
			NULL						 		AS [Patient!2!ssn],
			NULL					 			AS [Patient!2!abo],
			NULL					 			AS [Patient!2!rh],
			NULL					 			AS [TransfusionReactions!3],
			NULL						 		AS [TransfusionReaction!4!type],
			NULL					 			AS [TransfusionReaction!4!date],
			NULL					 			AS [TransfusionRequirements!5],
			dbo.PatientTransfusionRequirement.TransfusionRequirementText	AS [TransfusionRequirement!6!modifier],
			NULL					 			AS [Antibodies!7],
			NULL					 			AS [Antibody!8!name],
			NULL					 			AS [Units!9],
			NULL					 			AS [Unit!10!status],
			NULL					 			AS [Unit!10!id],
			NULL					 			AS [Unit!10!product],
			NULL					 			AS [Unit!10!productCode],
			NULL								AS [Unit!10!location],
			NULL					 			AS [Unit!10!expDate],
			NULL					 			AS [Specimen!11!expDate],
			NULL					 			AS [Specimen!11!uid],
			NULL					 			AS [Components!12],
			NULL					 			AS [Component!13!name],
			NULL					 			AS [Component!13!id],
			NULL					 			AS [Component!13!specimen],
			NULL								AS [LabTests!14],
			NULL					 			AS [LabTest!15!id],
			NULL					 			AS [LabTest!15!name],
			NULL					 			AS [MsbosList!16],
			NULL					 			AS [Msbos!17!name],
			NULL					 			AS [Msbos!17!threshold],
			NULL					 			AS [Surgeries!18],
			NULL					 			AS [Surgery!19!name],
			NULL					 			AS [Surgery!19!noBloodRequiredIndicator]  
	
	
	FROM		
		dbo.Patient
	
		INNER JOIN dbo.PatientTransfusionRequirement
			ON dbo.Patient.PatientGuid = dbo.PatientTransfusionRequirement.PatientGuid
	
	WHERE		
		dbo.Patient.VistaPatientID = @vistapatientid
	
		AND dbo.PatientTransfusionRequirement.PatientGUID = dbo.Patient.PatientGUID
		
		AND dbo.PatientTransfusionRequirement.RecordStatusCode IN ('A', 'C', 'H' )
		
		-- The following line Addresses CR 840
		AND dbo.PatientTransfusionRequirement.TransfusionRequirementCategoryCode IN ('AN', 'CR')
		
		AND @patientfoundflag = 1
	
	UNION ALL
	
	-- <Antibodies>
	SELECT	7					AS Tag,
			2					AS Parent,
			2					AS [Bloodbank!1!GroupOrder!hide],
			NULL					AS [Component!13!GroupOrder!hide],
			NULL 					AS [Bloodbank!1],
			NULL					AS [Patient!2!dfn],
			NULL					AS [Patient!2!firstName],
			NULL					AS [Patient!2!lastName],
			NULL					AS [Patient!2!ssn],
			NULL					AS [Patient!2!abo],
			NULL					AS [Patient!2!rh],
			NULL					AS [TransfusionReactions!3],
			NULL					AS [TransfusionReaction!4!type],
			NULL					AS [TransfusionReaction!4!date],
			NULL					AS [TransfusionRequirements!5],
			NULL					AS [TransfusionRequirement!6!modifier],
			NULL					AS [Antibodies!7],
			NULL					AS [Antibody!8!name],
			NULL					AS [Units!9],
			NULL					AS [Unit!10!status],
			NULL					AS [Unit!10!id],
			NULL					AS [Unit!10!product],
			NULL					AS [Unit!10!productCode],
			NULL					AS [Unit!10!location],
			NULL					AS [Unit!10!expDate],
			NULL					AS [Specimen!11!expDate],
			NULL					AS [Specimen!11!uid],
			NULL					AS [Components!12],
			NULL					AS [Component!13!name],
			NULL					AS [Component!13!id],
			NULL					AS [Component!13!specimen],
			NULL					AS [LabTests!14],
			NULL					AS [LabTest!15!id],
			NULL					AS [LabTest!15!name],
			NULL					AS [MsbosList!16],
			NULL					AS [Msbos!17!name],
			NULL					AS [Msbos!17!threshold],
			NULL					AS [Surgeries!18],
			NULL					AS [Surgery!19!name],
			NULL					AS [Surgery!19!noBloodRequiredIndicator]  
	
	WHERE		
		@patientfoundflag = 1
	
	UNION ALL
	
	-- <Antibody name="">
	SELECT DISTINCT	
			8					AS Tag,
			7					AS Parent,
			2					AS [Bloodbank!1!GroupOrder!hide],
			NULL					AS [Component!13!GroupOrder!hide],
			NULL 					AS [Bloodbank!1],
			NULL					AS [Patient!2!dfn],
			NULL					AS [Patient!2!firstName],
			NULL					AS [Patient!2!lastName],
			NULL					AS [Patient!2!ssn],
			NULL					AS [Patient!2!abo],
			NULL					AS [Patient!2!rh],
			NULL					AS [TransfusionReactions!3],
			NULL					AS [TransfusionReaction!4!type],
			NULL					AS [TransfusionReaction!4!date],
			NULL					AS [TransfusionRequirements!5],
			NULL					AS [TransfusionRequirement!6!modifier],
			NULL					AS [Antibodies!7],
			dbo.AntibodyType.AntibodyTypeName	AS [Antibody!8!name],
			NULL					AS [Units!9],
			NULL					AS [Unit!10!status],
			NULL					AS [Unit!10!id],
			NULL					AS [Unit!10!product],
			NULL					AS [Unit!10!productCode],
			NULL					AS [Unit!10!location],
			NULL					AS [Unit!10!expDate],
			NULL					AS [Specimen!11!expDate],
			NULL					AS [Specimen!11!uid],
			NULL					AS [Components!12],
			NULL					AS [Component!13!name],
			NULL					AS [Component!13!id],
			NULL					AS [Component!13!specimen],
			NULL					AS [LabTests!14],
			NULL					AS [LabTest!15!id],
			NULL					AS [LabTest!15!name],
			NULL					AS [MsbosList!16],
			NULL					AS [Msbos!17!name],
			NULL					AS [Msbos!17!threshold],
			NULL					AS [Surgeries!18],
			NULL					AS [Surgery!19!name],
			NULL					AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.Patient
	
		INNER JOIN dbo.PatientTransfusionRequirement
			ON dbo.PatientTransfusionRequirement.PatientGUID = dbo.Patient.PatientGUID		
		
		INNER JOIN dbo.AntibodyType
			ON dbo.AntibodyType.AntibodyTypeID =dbo. PatientTransfusionRequirement.AntibodyTypeID
		
	WHERE		
		dbo.Patient.VistaPatientID = @vistapatientid
		
		AND @patientfoundflag = 1
		
		AND dbo.AntibodyType.AntibodyTypeId != 1
		
		AND dbo.AntibodyType.AntibodyTypeId != 4
		
		AND dbo.PatientTransfusionRequirement.RecordStatusCode IN ('A', 'C', 'H' )
	
	
	UNION ALL
	
	-- <Units>
	SELECT	9					AS Tag,
			2					AS Parent,
			2					AS [Bloodbank!1!GroupOrder!hide],
			NULL					AS [Component!13!GroupOrder!hide],
			NULL 					AS [Bloodbank!1],
			NULL					AS [Patient!2!dfn],
			NULL					AS [Patient!2!firstName],
			NULL					AS [Patient!2!lastName],
			NULL					AS [Patient!2!ssn],
			NULL					AS [Patient!2!abo],
			NULL					AS [Patient!2!rh],
			NULL					AS [TransfusionReactions!3],
			NULL					AS [TransfusionReaction!4!type],
			NULL					AS [TransfusionReaction!4!date],
			NULL					AS [TransfusionRequirements!5],
			NULL					AS [TransfusionRequirement!6!modifier],
			NULL					AS [Antibodies!7],
			NULL					AS [Antibody!8!name],
			NULL					AS [Units!9],
			NULL					AS [Unit!10!status],
			NULL					AS [Unit!10!id],
			NULL					AS [Unit!10!product],
			NULL					AS [Unit!10!productCode],
			NULL					AS [Unit!10!location],
			NULL					AS [Unit!10!expDate],
			NULL					AS [Specimen!11!expDate],
			NULL					AS [Specimen!11!uid],
			NULL					AS [Components!12],
			NULL					AS [Component!13!name],
			NULL					AS [Component!13!id],
			NULL					AS [Component!13!specimen],
			NULL					AS [LabTests!14],
			NULL					AS [LabTest!15!id],
			NULL					AS [LabTest!15!name],
			NULL					AS [MsbosList!16],
			NULL					AS [Msbos!17!name],
			NULL					AS [Msbos!17!threshold],
			NULL					AS [Surgeries!18],
			NULL					AS [Surgery!19!name],
			NULL					AS [Surgery!19!noBloodRequiredIndicator]  
	
	WHERE		
		@patientfoundflag = 1
	
	UNION ALL
	
	-- Assigned and crossmatched units
	-- <Unit status="" id="" product="" location="" expDate="" />
	SELECT DISTINCT	
			10												AS Tag,
			9												AS Parent,
			2					 							AS [Bloodbank!1!GroupOrder!hide],
			NULL					 							AS [Component!13!GroupOrder!hide],
			NULL 					 							AS [Bloodbank!1],
			NULL					 							AS [Patient!2!dfn],
			NULL					 							AS [Patient!2!firstName],
			NULL					 							AS [Patient!2!lastName],
			NULL					 							AS [Patient!2!ssn],
			NULL					 							AS [Patient!2!abo],
			NULL					 							AS [Patient!2!rh],
			NULL					 							AS [TransfusionReactions!3],
			NULL					 							AS [TransfusionReaction!4!type],
			NULL					 							AS [TransfusionReaction!4!date],
			NULL					 							AS [TransfusionRequirements!5],
			NULL					 							AS [TransfusionRequirement!6!modifier],
			NULL					 							AS [Antibodies!7],
			NULL					 							AS [Antibody!8!name],
			NULL					 							AS [Units!9],
			BUSCC.UnitStatusCode		 								AS [Unit!10!status],
			dbo.BloodUnit.EyeReadableUnitId		 						AS [Unit!10!id],
			dbo.ProductType.ProductTypePrintName	 							AS [Unit!10!product],
			-- ******************************************************************************************************************************************************************************************
			CASE dbo.BloodUnit.LabelTypeCode
			WHEN 'I' THEN 
				dbo.BloodUnit.UnitProductCode 
				+ dbo.DonationType.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS 
				+ dbo.BloodUnit.UnitDivisionId 
			ELSE 
				dbo.BloodUnit.UnitProductCode
			END 												AS [Unit!10!productCode],
			-- ******************************************************************************************************************************************************************************************
			dbo.VamcDivision.DivisionName		 							AS [Unit!10!location],
			dbo.fnDateTimeConversionToHL7DateTime(
				dbo.fnTimeZoneConversionDateTime( 
					@divisioncode, 0, BloodUnitMedia.UnitExpirationDate ))				AS [Unit!10!expDate],				
			NULL						 						AS [Specimen!11!expDate],
			NULL					 							AS [Specimen!11!uid],
			NULL						 						AS [Components!12],
			NULL					 							AS [Component!13!name],
			NULL					 							AS [Component!13!id],
			NULL					 							AS [Component!13!specimen],
			NULL					 							AS [LabTests!14],
			NULL					 							AS [LabTest!15!id],
			NULL					 							AS [LabTest!15!name],
			NULL					 							AS [MsbosList!16],
			NULL					 							AS [Msbos!17!name],
			NULL					 							AS [Msbos!17!threshold],
			NULL												AS [Surgeries!18],
			NULL										 		AS [Surgery!19!name],
			NULL					 							AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.BloodUnitStatusCodeCurrent BUSCC
		
		INNER JOIN dbo.BloodUnit
			ON BUSCC.BloodUnitGUID = dbo.BloodUnit.BloodUnitGUID
		
		LEFT  JOIN dbo.PatientTransfusion
			ON dbo.BloodUnit.BloodUnitGuid = dbo.PatientTransfusion.BloodUnitGuid AND dbo.PatientTransfusion.RecordStatusCode = 'A'
		
		INNER JOIN dbo.OrderedUnit
			ON dbo.BloodUnit.BloodUnitGUID = dbo.OrderedUnit.BloodUnitGUID
		
		INNER JOIN dbo.OrderedComponent
			ON dbo.OrderedUnit.OrderedComponentGUID = dbo.OrderedComponent.OrderedComponentGUID
		
		LEFT JOIN dbo.PatientSpecimen
			ON dbo.OrderedComponent.PatientSpecimenGuid = dbo.PatientSpecimen.PatientSpecimenGuid
	
		INNER JOIN dbo.PatientOrder
			ON dbo.OrderedComponent.PatientOrderGUID = dbo.PatientOrder.PatientOrderGUID
		
		INNER JOIN dbo.PatientTreatment
			ON dbo.PatientOrder.PatientTreatmentGUID = dbo.PatientTreatment.PatientTreatmentGUID
		
		INNER JOIN dbo.Patient
			ON dbo.PatientTreatment.PatientGUID = dbo.Patient.PatientGUID
		
		INNER JOIN dbo.BloodProduct
			ON dbo.BloodUnit.BloodProductGUID = dbo.BloodProduct.BloodProductGUID
		
		INNER JOIN dbo.ProductType
			ON  dbo.BloodProduct.ProductTypeCode = dbo.ProductType.ProductTypeCode
		
		INNER JOIN dbo.VamcDivision
			ON  dbo.BloodUnit.DivisionCode = dbo.VamcDivision.DivisionCode
		
		INNER JOIN dbo.BloodUnitMedia
			ON dbo.BloodUnit.BloodUnitGUID = dbo.BloodUnitMedia.BloodUnitGUID
	
		INNER JOIN dbo.DonationType 
			ON dbo.BloodUnit.DonationTypeId = dbo.DonationType.DonationTypeId
		
	WHERE		

		dbo.Patient.VistaPatientID = @vistapatientid
	
		AND BUSCC.UnitStatusCode IN ( 'S', 'C' )
	
		AND @patientfoundflag = 1
	
		AND dbo.PatientTransfusion.TransfusionStartDateTime IS NULL
	
		AND	
		(	
			dbo.PatientSpecimen.SpecimenExpirationDate IS NULL 
			OR dbo.PatientSpecimen.SpecimenExpirationDate IS NOT NULL AND dbo.PatientSpecimen.SpecimenExpirationDate > GETUTCDATE()
		)

		AND dbo.OrderedUnit.ReleaseDate IS NULL

		AND dbo.OrderedUnit.SelectedDate IS NOT NULL
	
		AND ((dbo.fnOrderedUnitCrossmatchResultCode(OrderedUnit.OrderedUnitGuid) IN ('C', 'E', 'G')) OR (OrderedUnit.CrossmatchResultCode IS NULL))
	
	UNION ALL
	
	-- Autologous units
	-- <Unit status="" id="" product="" location="" expDate="" />
	SELECT DISTINCT	
			10												AS Tag,
			9												AS Parent,
			2					 							AS [Bloodbank!1!GroupOrder!hide],
			NULL					 							AS [Component!13!GroupOrder!hide],
			NULL 					 							AS [Bloodbank!1],
			NULL					 							AS [Patient!2!dfn],
			NULL					 							AS [Patient!2!firstName],
			NULL					 							AS [Patient!2!lastName],
			NULL					 							AS [Patient!2!ssn],
			NULL					 							AS [Patient!2!abo],
			NULL					 							AS [Patient!2!rh],
			NULL					 							AS [TransfusionReactions!3],
			NULL					 							AS [TransfusionReaction!4!type],
			NULL					 							AS [TransfusionReaction!4!date],
			NULL					 							AS [TransfusionRequirements!5],
			NULL					 							AS [TransfusionRequirement!6!modifier],
			NULL					 							AS [Antibodies!7],
			NULL					 							AS [Antibody!8!name],
			NULL					 							AS [Units!9],
			dbo.DonationType.RestrictionTypeCode	 							AS [Unit!10!status],
			dbo.BloodUnit.EyeReadableUnitId								AS [Unit!10!id],
			dbo.ProductType.ProductTypePrintName	 							AS [Unit!10!product],
			-- ******************************************************************************************************************************************************************************************
			CASE dbo.BloodUnit.LabelTypeCode
			WHEN 'I' THEN 
				dbo.BloodUnit.UnitProductCode 
				+ dbo.DonationType.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS 
				+ dbo.BloodUnit.UnitDivisionId 
			ELSE 
				dbo.BloodUnit.UnitProductCode
			END 												AS [Unit!10!productCode],
			-- ******************************************************************************************************************************************************************************************
			dbo.VamcDivision.DivisionName		 							AS [Unit!10!location],
			dbo.fnDateTimeConversionToHL7DateTime(
				dbo.fnTimeZoneConversionDateTime( 
					@divisioncode, 0, BloodUnitMedia.UnitExpirationDate ))				AS [Unit!10!expDate],
			NULL					 							AS [Specimen!11!expDate],
			NULL					 							AS [Specimen!11!uid],
			NULL					 							AS [Components!12],
			NULL					 							AS [Component!13!name],
			NULL					 							AS [Component!13!id],
			NULL					 							AS [Component!13!specimen],
			NULL					 							AS [LabTests!14],
			NULL					 							AS [LabTest!15!id],
			NULL					 							AS [LabTest!15!name],
			NULL					 							AS [MsbosList!16],
			NULL					 							AS [Msbos!17!name],
			NULL					 							AS [Msbos!17!threshold],
			NULL					 							AS [Surgeries!18],
			NULL					 							AS [Surgery!19!name],
			NULL					 							AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.DonationType
	
		INNER JOIN dbo.BloodUnit
			ON dbo.DonationType.DonationTypeId = dbo.BloodUnit.DonationTypeId
		
		INNER JOIN dbo.BloodUnitMedia
			ON dbo.BloodUnit.BloodUnitGUID = dbo.BloodUnitMedia.BloodUnitGUID
		
		LEFT OUTER JOIN dbo.PatientTransfusion
			ON dbo.BloodUnit.BloodUnitGuid = dbo.PatientTransfusion.BloodUnitGuid AND dbo.PatientTransfusion.RecordStatusCode = 'A'
		
		INNER JOIN dbo.OrderedUnit
			ON dbo.BloodUnit.BloodUnitGUID = dbo.OrderedUnit.BloodUnitGUID
		
		INNER JOIN dbo.Patient
			ON dbo.BloodUnitMedia.DirectedPatientGUID = dbo.Patient.PatientGUID
		
		INNER JOIN dbo.BloodProduct
			ON dbo.BloodUnit.BloodProductGUID = dbo.BloodProduct.BloodProductGUID
		
		INNER JOIN dbo.ProductType
			ON dbo.BloodProduct.ProductTypeCode = dbo.ProductType.ProductTypeCode
		
		INNER JOIN dbo.VamcDivision
			ON dbo.BloodUnit.DivisionCode = dbo.VamcDivision.DivisionCode
		
	WHERE		
		dbo.Patient.VistaPatientID = @vistapatientid
	
		AND dbo.DonationType.RestrictionTypeCode IN ('A', 'D')
	
		AND @patientfoundflag = 1
	
		AND dbo.BloodUnitMedia.UnitExpirationDate > GETUTCDATE()
	
		AND PatientTransfusion.TransfusionStartDateTime IS NULL
	
		AND dbo.OrderedUnit.ReleaseDate IS NULL
	
		AND dbo.OrderedUnit.SelectedDate IS NOT NULL
	
		AND ((dbo.OrderedUnit.CrossmatchResultCode IN ('C', 'G')) OR (dbo.OrderedUnit.CrossmatchResultCode IS NULL))
	
	UNION ALL
	
	-- <Specimen expDate="" uid="" />
	SELECT DISTINCT	
			11										AS Tag,
			2										AS Parent,
			2					 					AS [Bloodbank!1!GroupOrder!hide],
			NULL					 					AS [Component!13!GroupOrder!hide],
			NULL 					 					AS [Bloodbank!1],
			NULL					 					AS [Patient!2!dfn],
			NULL					 					AS [Patient!2!firstName],
			NULL					 					AS [Patient!2!lastName],
			NULL					 					AS [Patient!2!ssn],
			NULL					 					AS [Patient!2!abo],
			NULL					 					AS [Patient!2!rh],
			NULL					 					AS [TransfusionReactions!3],
			NULL					 					AS [TransfusionReaction!4!type],
			NULL					 					AS [TransfusionReaction!4!date],
			NULL					 					AS [TransfusionRequirements!5],
			NULL					 					AS [TransfusionRequirement!6!modifier],
			NULL					 					AS [Antibodies!7],
			NULL					 					AS [Antibody!8!name],
			NULL					 					AS [Units!9],
			NULL					 					AS [Unit!10!status],
			NULL					 					AS [Unit!10!id],
			NULL					 					AS [Unit!10!product],
			NULL					 					AS [Unit!10!productCode],
			NULL					 					AS [Unit!10!location],
			NULL					 					AS [Unit!10!expDate],
			dbo.fnDateTimeConversionToHL7DateTime(
				dbo.fnTimeZoneConversionDateTime( 
					@divisioncode, 0, PatientSpecimen.SpecimenExpirationDate ))	AS [Specimen!11!expDate],
			dbo.PatientSpecimen.SpecimenUID		 				AS [Specimen!11!uid],
			NULL					 					AS [Components!12],
			NULL					 					AS [Component!13!name],
			NULL					 					AS [Component!13!id],
			NULL					 					AS [Component!13!specimen],
			NULL					 					AS [LabTests!14],
			NULL					 					AS [LabTest!15!id],
			NULL					 					AS [LabTest!15!name],
			NULL					 					AS [MsbosList!16],
			NULL					 					AS [Msbos!17!name],
			NULL					 					AS [Msbos!17!threshold],
			NULL					 					AS [Surgeries!18],
			NULL					 					AS [Surgery!19!name],
			NULL					 					AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.PatientSpecimen
	
		INNER JOIN dbo.OrderedTest
			ON dbo.PatientSpecimen.PatientSpecimenGUID = dbo.OrderedTest.PatientSpecimenGUID
		
		INNER JOIN dbo.OrderableTest
			ON dbo.OrderedTest.OrderableTestID = dbo.OrderableTest.OrderableTestID
		
		INNER JOIN dbo.Patient
			ON dbo.PatientSpecimen.PatientGUID =dbo. Patient.PatientGUID	
		
	WHERE	
		dbo.Patient.VistaPatientID = @vistapatientid
	
		AND dbo.PatientSpecimen.UnacceptableSpecimenIndicator <> 1
	
		AND dbo.OrderableTest.CprsOrderableItemID = '1'
	
		AND dbo.PatientSpecimen.SpecimenExpirationDate > GETUTCDATE()
	
		AND @patientfoundflag = 1
	
	/****** Brian Tomlin:  Added Division check on PatientSpecimen 07-12-2004 *******/
		AND dbo.PatientSpecimen.DivisionCode = @divisioncode
		
	
	UNION ALL
	
	-- <Components>
	SELECT		
			12					AS Tag,
			1					AS Parent,
			3					AS [Bloodbank!1!GroupOrder!hide],
			NULL					AS [Component!13!GroupOrder!hide],
			NULL 					AS [Bloodbank!1],
			NULL					AS [Patient!2!dfn],
			NULL					AS [Patient!2!firstName],
			NULL					AS [Patient!2!lastName],
			NULL					AS [Patient!2!ssn],
			NULL					AS [Patient!2!abo],
			NULL					AS [Patient!2!rh],
			NULL					AS [TransfusionReactions!3],
			NULL					AS [TransfusionReaction!4!type],
			NULL					AS [TransfusionReaction!4!date],
			NULL					AS [TransfusionRequirements!5],
			NULL					AS [TransfusionRequirement!6!modifier],
			NULL					AS [Antibodies!7],
			NULL					AS [Antibody!8!name],
			NULL					AS [Units!9],
			NULL					AS [Unit!10!status],
			NULL					AS [Unit!10!id],
			NULL					AS [Unit!10!product],
			NULL					AS [Unit!10!productCode],
			NULL					AS [Unit!10!location],
			NULL					AS [Unit!10!expDate],
			NULL					AS [Specimen!11!expDate],
			NULL					AS [Specimen!11!uid],
			NULL					AS [Components!12],
			NULL					AS [Component!13!name],
			NULL					AS [Component!13!id],
			NULL					AS [Component!13!specimen],
			NULL					AS [LabTests!14],
			NULL					AS [LabTest!15!id],
			NULL					AS [LabTest!15!name],
			NULL					AS [MsbosList!16],
			NULL					AS [Msbos!17!name],
			NULL					AS [Msbos!17!threshold],
			NULL					AS [Surgeries!18],
			NULL					AS [Surgery!19!name],
			NULL					AS [Surgery!19!noBloodRequiredIndicator]  
	
	UNION ALL
	
	-- <Component name="" id="" specimen="">
	SELECT DISTINCT	
			13						AS Tag,
			12						AS Parent,
			3					 	AS [Bloodbank!1!GroupOrder!hide],
			NULL					 	AS [Component!13!GroupOrder!hide],
			NULL 					 	AS [Bloodbank!1],
			NULL					 	AS [Patient!2!dfn],
			NULL					 	AS [Patient!2!firstName],
			NULL					 	AS [Patient!2!lastName],
			NULL					 	AS [Patient!2!ssn],
			NULL					 	AS [Patient!2!abo],
			NULL					 	AS [Patient!2!rh],
			NULL					 	AS [TransfusionReactions!3],
			NULL					 	AS [TransfusionReaction!4!type],
			NULL					 	AS [TransfusionReaction!4!date],
			NULL					 	AS [TransfusionRequirements!5],
			NULL					 	AS [TransfusionRequirement!6!modifier],
			NULL					 	AS [Antibodies!7],
			NULL					 	AS [Antibody!8!name],
			NULL					 	AS [Units!9],
			NULL					 	AS [Unit!10!status],
			NULL					 	AS [Unit!10!id],
			NULL					 	AS [Unit!10!product],
			NULL					 	AS [Unit!10!productCode],
			NULL					 	AS [Unit!10!location],
			NULL					 	AS [Unit!10!expDate],
			NULL					 	AS [Specimen!11!expDate],
			NULL					 	AS [Specimen!11!uid],
			NULL					 	AS [Components!12],
			CompCls.ComponentClassShortName		AS [Component!13!name],
			RTRIM( CompCls.CprsOrderableItemID )	 	AS [Component!13!id],
			CompClsParam.SpecimenRequiredIndicator	AS [Component!13!specimen],
			NULL					 	AS [LabTests!14],
			NULL					 	AS [LabTest!15!id],
			NULL					 	AS [LabTest!15!name],
			NULL					 	AS [MsbosList!16],
			NULL					 	AS [Msbos!17!name],
			NULL					 	AS [Msbos!17!threshold],
			NULL					 	AS [Surgeries!18],
			NULL					 	AS [Surgery!19!name],
			NULL					 	AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.ComponentClass CompCls
		
		INNER JOIN dbo.ComponentClassParameter CompClsParam
			ON CompCls.ComponentClassID = CompClsParam.ComponentClassID
		
	WHERE 		
		CompCls.CprsOrderableItemID IS NOT NULL
	
		AND CompClsParam.DivisionCode = @divisioncode
	
	UNION ALL
	
	-- <LabTests>
	SELECT		
			14					AS Tag,
			13					AS Parent,
			3					AS [Bloodbank!1!GroupOrder!hide],
			1					AS [Component!13!GroupOrder!hide],
			NULL 					AS [Bloodbank!1],
			NULL					AS [Patient!2!dfn],
			NULL					AS [Patient!2!firstName],
			NULL					AS [Patient!2!lastName],
			NULL					AS [Patient!2!ssn],
			NULL					AS [Patient!2!abo],
			NULL					AS [Patient!2!rh],
			NULL					AS [TransfusionReactions!3],
			NULL					AS [TransfusionReaction!4!type],
			NULL					AS [TransfusionReaction!4!date],
			NULL					AS [TransfusionRequirements!5],
			NULL					AS [TransfusionRequirement!6!modifier],
			NULL					AS [Antibodies!7],
			NULL					AS [Antibody!8!name],
			NULL					AS [Units!9],
			NULL					AS [Unit!10!status],
			NULL					AS [Unit!10!id],
			NULL					AS [Unit!10!product],
			NULL					AS [Unit!10!productCode],
			NULL					AS [Unit!10!location],
			NULL					AS [Unit!10!expDate],
			NULL					AS [Specimen!11!expDate],
			NULL					AS [Specimen!11!uid],
			NULL					AS [Components!12],
			NULL					AS [Component!13!name],
			RTRIM( CompCls.CprsOrderableItemID )	AS [Component!13!id],
			NULL					AS [Component!13!specimen],
			NULL					AS [LabTests!14],
			NULL					AS [LabTest!15!id],
			NULL					AS [LabTest!15!name],
			NULL					AS [MsbosList!16],
			NULL					AS [Msbos!17!name],
			NULL					AS [Msbos!17!threshold],
			NULL					AS [Surgeries!18],
			NULL					AS [Surgery!19!name],
			NULL					AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.ComponentClass CompCls
		
		INNER JOIN dbo.ComponentClassParameter CompClsParam
			ON CompCls.ComponentClassID = CompClsParam.ComponentClassID
		
	WHERE 		
		CompCls.CprsOrderableItemID IS NOT NULL
			
		AND CompClsParam.DivisionCode = @divisioncode
	
	UNION ALL
	
	-- <LabTest id="" name="">
	SELECT DISTINCT	
			15					 AS Tag,
			14					 AS Parent,
			3					 AS [Bloodbank!1!GroupOrder!hide],
			1					 AS [Component!13!GroupOrder!hide],
			NULL 					 AS [Bloodbank!1],
			NULL					 AS [Patient!2!dfn],
			NULL					 AS [Patient!2!firstName],
			NULL					 AS [Patient!2!lastName],
			NULL					 AS [Patient!2!ssn],
			NULL					 AS [Patient!2!abo],
			NULL					 AS [Patient!2!rh],
			NULL					 AS [TransfusionReactions!3],
			NULL					 AS [TransfusionReaction!4!type],
			NULL					 AS [TransfusionReaction!4!date],
			NULL					 AS [TransfusionRequirements!5],
			NULL					 AS [TransfusionRequirement!6!modifier],
			NULL					 AS [Antibodies!7],
			NULL					 AS [Antibody!8!name],
			NULL					 AS [Units!9],
			NULL					 AS [Unit!10!status],
			NULL					 AS [Unit!10!id],
			NULL					 AS [Unit!10!product],
			NULL					 AS [Unit!10!productCode],
			NULL					 AS [Unit!10!location],
			NULL					 AS [Unit!10!expDate],
			NULL					 AS [Specimen!11!expDate],
			NULL					 AS [Specimen!11!uid],
			NULL					 AS [Components!12],
			NULL					 AS [Component!13!name],
			RTRIM( CompCls.CprsOrderableItemID )	 AS [Component!13!id],
			NULL					 AS [Component!13!specimen],
			NULL					 AS [LabTests!14],
			RTRIM( SpecTestThrd.LabTestID ) 	 AS [LabTest!15!id],
			SpecTestThrd.VistALaboratoryTestName 	 AS [LabTest!15!name],
			NULL					 AS [MsbosList!16],
			NULL					 AS [Msbos!17!name],
			NULL					 AS [Msbos!17!threshold],
			NULL					 AS [Surgeries!18],
			NULL					 AS [Surgery!19!name],
			NULL					 AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.ComponentClass CompCls
	
		INNER JOIN dbo.SpecimenTestThreshold SpecTestThrd
			ON SpecTestThrd.ComponentClassID = CompCls.ComponentClassID		
		
	WHERE
		CompCls.CprsOrderableItemID IS NOT NULL
		
		AND SpecTestThrd.DivisionCode = @divisioncode
	
	UNION ALL
	
	-- <MsbosList>
	SELECT		
			16					AS Tag,
			13					AS Parent,
			3					AS [Bloodbank!1!GroupOrder],
			2					AS [Component!13!GroupOrder!hide],
			NULL 					AS [Bloodbank!1],
			NULL					AS [Patient!2!dfn],
			NULL					AS [Patient!2!firstName],
			NULL					AS [Patient!2!lastName],
			NULL					AS [Patient!2!ssn],
			NULL					AS [Patient!2!abo],
			NULL					AS [Patient!2!rh],
			NULL					AS [TransfusionReactions!3],
			NULL					AS [TransfusionReaction!4!type],
			NULL					AS [TransfusionReaction!4!date],
			NULL					AS [TransfusionRequirements!5],
			NULL					AS [TransfusionRequirement!6!modifier],
			NULL					AS [Antibodies!7],
			NULL					AS [Antibody!8!name],
			NULL					AS [Units!9],
			NULL					AS [Unit!10!status],
			NULL					AS [Unit!10!id],
			NULL					AS [Unit!10!product],
			NULL					AS [Unit!10!productCode],
			NULL					AS [Unit!10!location],
			NULL					AS [Unit!10!expDate],
			NULL					AS [Specimen!11!expDate],
			NULL					AS [Specimen!11!uid],
			NULL					AS [Components!12],
			NULL					AS [Component!13!name],
			RTRIM( CompCls.CprsOrderableItemID )	AS [Component!13!id],
			NULL					AS [Component!13!specimen],
			NULL					AS [LabTests!14],
			NULL					AS [LabTest!15!id],
			NULL					AS [LabTest!15!name],
			NULL					AS [MsbosList!16],
			NULL					AS [Msbos!17!name],
			NULL					AS [Msbos!17!threshold],
			NULL					AS [Surgeries!18],
			NULL					AS [Surgery!19!name],
			NULL					AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.ComponentClass CompCls
		
		INNER JOIN dbo.ComponentClassParameter CompClsParam
			ON CompCls.ComponentClassID = CompClsParam.ComponentClassID
		
	WHERE 		
		CompCls.CprsOrderableItemID IS NOT NULL
		
		AND CompClsParam.DivisionCode = @divisioncode
	
	UNION ALL
	
	-- <Msbos name="" threshold="" />
	SELECT DISTINCT	
			17							AS Tag,
			16							AS Parent,
			3							AS [Bloodbank!1!GroupOrder!hide],
			2							AS [Component!13!GroupOrder!hide],
			NULL 							AS [Bloodbank!1],
			NULL							AS [Patient!2!dfn],
			NULL							AS [Patient!2!firstName],
			NULL							AS [Patient!2!lastName],
			NULL							AS [Patient!2!ssn],
			NULL							AS [Patient!2!abo],
			NULL							AS [Patient!2!rh],
			NULL							AS [TransfusionReactions!3],
			NULL							AS [TransfusionReaction!4!type],
			NULL							AS [TransfusionReaction!4!date],
			NULL							AS [TransfusionRequirements!5],
			NULL							AS [TransfusionRequirement!6!modifier],
			NULL							AS [Antibodies!7],
			NULL							AS [Antibody!8!name],
			NULL							AS [Units!9],
			NULL							AS [Unit!10!status],
			NULL							AS [Unit!10!id],
			NULL							AS [Unit!10!product],
			NULL							AS [Unit!10!productCode],
			NULL							AS [Unit!10!location],
			NULL							AS [Unit!10!expDate],
			NULL							AS [Specimen!11!expDate],
			NULL							AS [Specimen!11!uid],
			NULL							AS [Components!12],
			NULL							AS [Component!13!name],
			rtrim( CompCls.CprsOrderableItemID )			AS [Component!13!id],
			NULL							AS [Component!13!specimen],
			NULL							AS [LabTests!14],
			NULL							AS [LabTest!15!id],
			NULL							AS [LabTest!15!name],
			NULL							AS [MsbosList!16],
			Msbos.SurgeryName					AS [Msbos!17!name],
			MsbosComponentClass.MaximumSetupUnitQuantity 	AS [Msbos!17!threshold],
			NULL					 		AS [Surgeries!18],
			NULL					 		AS [Surgery!19!name],
			NULL					 		AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		
		dbo.ComponentClass CompCls
	
		INNER JOIN dbo.MsbosComponentClass
			ON CompCls.ComponentClassID = MsbosComponentClass.ComponentClassID		
		
	
		INNER JOIN dbo.Msbos
			ON Msbos.MsbosGUID = MsbosComponentClass.MsbosGUID
			
		WHERE 
			Msbos.DivisionCode = @divisioncode
		
			AND CompCls.CprsOrderableItemID IS NOT NULL

			/****** CR 3078: filter out inactive MSBOS records *******/
			AND Msbos.RecordStatusCode <> 'X'
			/****** CR 3156: filter out inactive MsbosComponentClass records *******/
			AND MsbosComponentClass.RecordStatusCode <> 'X'
	
	UNION ALL
	
	-- <Surgeries>
	SELECT		
			18					AS Tag,
			1					AS Parent,
			4					AS [Bloodbank!1!GroupOrder!hide],
			NULL					AS [Component!13!GroupOrder!hide],
			NULL 					AS [Bloodbank!1],
			NULL					AS [Patient!2!dfn],
			NULL					AS [Patient!2!firstName],
			NULL					AS [Patient!2!lastName],
			NULL					AS [Patient!2!ssn],
			NULL					AS [Patient!2!abo],
			NULL					AS [Patient!2!rh],
			NULL					AS [TransfusionReactions!3],
			NULL					AS [TransfusionReaction!4!type],
			NULL					AS [TransfusionReaction!4!date],
			NULL					AS [TransfusionRequirements!5],
			NULL					AS [TransfusionRequirement!6!modifier],
			NULL					AS [Antibodies!7],
			NULL					AS [Antibody!8!name],
			NULL					AS [Units!9],
			NULL					AS [Unit!10!status],
			NULL					AS [Unit!10!id],
			NULL					AS [Unit!10!product],
			NULL					AS [Unit!10!productCode],
			NULL					AS [Unit!10!location],
			NULL					AS [Unit!10!expDate],
			NULL					AS [Specimen!11!expDate],
			NULL					AS [Specimen!11!uid],
			NULL					AS [Components!12],
			NULL					AS [Component!13!name],
			NULL					AS [Component!13!id],
			NULL					AS [Component!13!specimen],
			NULL					AS [LabTests!14],
			NULL					AS [LabTest!15!id],
			NULL					AS [LabTest!15!name],
			NULL					AS [MsbosList!16],
			NULL					AS [Msbos!17!name],
			NULL					AS [Msbos!17!threshold],
			NULL					AS [Surgeries!18],
			NULL					AS [Surgery!19!name],
			NULL					AS [Surgery!19!noBloodRequiredIndicator] 
	
	UNION ALL
	
	-- <Surgery name="">
	SELECT DISTINCT	
			19										AS Tag,
			18										AS Parent,
			4					 					AS [Bloodbank!1!GroupOrder!hide],
			NULL					 					AS [Component!13!GroupOrder!hide],
			NULL 					 					AS [Bloodbank!1],
			NULL					 					AS [Patient!2!dfn],
			NULL					 					AS [Patient!2!firstName],
			NULL					 					AS [Patient!2!lastName],
			NULL					 					AS [Patient!2!ssn],
			NULL					 					AS [Patient!2!abo],
			NULL					 					AS [Patient!2!rh],
			NULL					 					AS [TransfusionReactions!3],
			NULL					 					AS [TransfusionReaction!4!type],
			NULL					 					AS [TransfusionReaction!4!date],
			NULL					 					AS [TransfusionRequirements!5],
			NULL					 					AS [TransfusionRequirement!6!modifier],
			NULL					 					AS [Antibodies!7],
			NULL					 					AS [Antibody!8!name],
			NULL					 					AS [Units!9],
			NULL					 					AS [Unit!10!status],
			NULL					 					AS [Unit!10!id],
			NULL					 					AS [Unit!10!product],
			NULL						 				AS [Unit!10!productCode],
			NULL					 					AS [Unit!10!location],
			NULL					 					AS [Unit!10!expDate],
			NULL					 					AS [Specimen!11!expDate],
			NULL					 					AS [Specimen!11!uid],
			NULL					 					AS [Components!12],
			NULL					 					AS [Component!13!name],
			NULL					 					AS [Component!13!id],
			NULL					 					AS [Component!13!specimen],
			NULL					 					AS [LabTests!14],
			NULL					 					AS [LabTest!15!id],
			NULL					 					AS [LabTest!15!name],
			NULL					 					AS [MsbosList!16],
			NULL					 					AS [Msbos!17!name],
			NULL					 					AS [Msbos!17!threshold],
			NULL					 					AS [Surgeries!18],
			dbo.Msbos.SurgeryName								AS [Surgery!19!name],
			CASE WHEN (TypeAndScreenIndicator = 1 OR NoBloodRequiredIndicator = 1)
			THEN	1
			ELSE 	0
			END 						 				AS [Surgery!19!noBloodRequiredIndicator]  
	
	FROM		dbo.Msbos

	WHERE			
			/****** CR 3156: filter out by division *******/
                                	Msbos.DivisionCode = @divisioncode

			/****** CR 3078: filter out inactive MSBOS records *******/
	    AND		Msbos.RecordStatusCode <> 'X'
	
	ORDER BY	[Bloodbank!1!GroupOrder!hide], 
			[Component!13!id], 
			[Component!13!GroupOrder!hide], 
			[LabTest!15!id], 
			[Msbos!17!name], 
			[Surgery!19!name],  
			Tag

	FOR XML EXPLICIT

SET NOCOUNT OFF

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[V_LinearInterface]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[V_LinearInterface]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/****************************************************************************************************************************************************************
**	Name: 	V_LinearInterface
**
**	Desc: 	Returns data like old interfacecontrol table (Defect 340457).
**
**	Author:	Pablo Sanchez
**
**	Date: 	09/19/2016
**
******************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------------	---------	------------------
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************************************************************/
CREATE VIEW [dbo].[V_LinearInterface]
AS

	SELECT 		
			I.[InterfaceId],
			I.[InterfaceName], 
			I.[FieldSeparator], 
			I.[EncodingCharacters], 
			I.[InterfaceApplicationID], 
			I.[VbecsApplicationID], 
			I.[VersionID], 
			I.[ApplicationAckType], 
			
			(case when vep.[EndPointType] = 'IPAddress' then vep.[EndPointAddress] else convert(varchar(255), null) end) as [InterfaceIPAddress],
			(case when vep.[EndPointType] = 'DnsHostName' then vep.[EndPointAddress] else convert(varchar(255), null) end) as [InterfaceDomainName],
			vep.[EndPointPort] as [InterfacePortNumber],
			vep.[EndPointAddress] as [InterfaceEndPointAddress],
			vep.[EndPointType] as [InterfaceEndPointType],

			convert(bit, (case when vgc2.[ParameterValue] = 'true' then 1 else 0 end)) as [InterfaceActiveIndicator],

			vgc3.[ParameterValue] as [InterfaceFacilityID],

			vep2.[EndPointAddress] as [VbecsIPAddress],
			vep2.[EndPointPort] as [VbecsPortNumber],
			vep2.[EndPointAddress] as [VbecsEndPointAddress],
			vep2.[EndPointType] as [VbecsEndPointType],

			convert(int, vgc5.[ParameterValue]) as [AckTimeout],
			convert(int, vgc6.[ParameterValue]) as [ReTransmitAttempts],
			vgc7.[ParameterValue] as [InterfaceAdministratorName], -- should this be renamed to EmailAddress?

			I.[VbecsFacilityID],
			I.[LogEventsIndicator],
			I.[ProcessingID],
			I.[PurgeSuccessfulMessage],
			I.[PurgeUnSuccessfulMessage],

			vep.VbecsEndPointId as EndPointId,

			isnull(vep.LastUpdateDate, I.LastUpdateDate) as LastUpdateDate, 
			isnull(vep.LastUpdateUser, I.LastUpdateUser) as LastUpdateUser, 
			isnull(vep.[RowVersion], I.[RowVersion]) as [RowVersion], 
			isnull(vep.LastUpdateFunctionId, I.LastUpdateFunctionId) as LastUpdateFunctionId


	FROM dbo.Interface I

		LEFT JOIN dbo.VbecsEndPoint vep on vep.VbecsEndPointId = I.VbecsEndPointId

		LEFT JOIN dbo.VbecsGlobalConfig vgc2 on vgc2.ApplicationName = I.ApplicationName
			   AND vgc2.ParameterName = I.ConfigPrefix + '_IsActive'

		LEFT JOIN dbo.VbecsGlobalConfig vgc3 on vgc3.ApplicationName = I.ApplicationName
			   AND vgc3.ParameterName = I.ConfigPrefix + '_FacilityID'

		LEFT JOIN dbo.VbecsGlobalConfig vgc4 on vgc4.ApplicationName = I.ApplicationName			
			   AND vgc4.ParameterName = 'VBECS' + '_EndPoint'

		LEFT JOIN dbo.VbecsEndPoint vep2 on vep2.VbecsEndPointId = convert(int, vgc4.ParameterValue)
			
		LEFT JOIN dbo.VbecsGlobalConfig vgc5 on vgc5.ApplicationName = I.ApplicationName
			   AND vgc5.ParameterName = 'VBECS' + '_AckTimeout'

		LEFT JOIN dbo.VbecsGlobalConfig vgc6 on vgc6.ApplicationName = I.ApplicationName
			   AND vgc6.ParameterName = 'VBECS' + '_ReTransmitAttempts'

		LEFT JOIN dbo.VbecsGlobalConfig vgc7 on vgc7.ApplicationName = I.ApplicationName
			   AND vgc7.ParameterName = 'VBECS' + '_EmailAlertAddress'




GO


-- alter the column added to not allow NULLS

ALTER TABLE [dbo].[Interface] ALTER COLUMN [ApplicationName] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [ConfigPrefix] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [ProcessingId] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [PurgeSuccessfulMessage] [tinyint] NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [PurgeUnSuccessfulMessage] [tinyint] NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [LogEventsIndicator] [bit] NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [VbecsFacilityId] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [VbecsEndPointId] [int] NOT NULL
ALTER TABLE [dbo].[Interface] ALTER COLUMN [ApplicationAckType] [char] (2) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[VbecsEndPoint] ALTER COLUMN [EndPointType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL

ALTER TABLE [dbo].[Interface]  WITH CHECK ADD  CONSTRAINT [FK_Interface_VbecsEndPoint] FOREIGN KEY([VbecsEndPointId])
REFERENCES [dbo].[VbecsEndPoint] ([VbecsEndPointId])
GO

ALTER TABLE [dbo].[Interface] CHECK CONSTRAINT [FK_Interface_VbecsEndPoint]
GO

ALTER TABLE [dbo].[VamcDivision] ALTER COLUMN [LabelPrinterEndPointId] int NOT NULL

CREATE NONCLUSTERED INDEX [IX_VamcDivision_LabelPrinterEndPointId] ON [dbo].[VamcDivision] ([LabelPrinterEndPointId]) ON [PRIMARY]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAuditInterfaceControl]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAuditInterfaceControl]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************************************************************
**	Desc: 	Get Interface Control audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   03/18/2004
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	04/27/2004	M. Jablonski		Call fnTimeZoneConversionDateTime function on all dates
**	07/13/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	08/18/2005	N.Paterson	Implemented differences between Review_Start and DEV before porting changes to DEV
**	07/17/2007	K. Dobranowski  Fixed names of two columns InterfaceFacilityId and VbecsFacilityId (was InterfaceFacilityID and VbecsFacilityID) CR 1979
**	07/17/2007	K. Dobranowski	Added InterfaceDomainName to SELECT statement CR 2267
**	11/14/2008	M. Smith	Changed to get the InterfaceName from the new Interface reference table.  CR 2516
**	12/17/2008	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	03/16/2010	K. Dobranowski	Added InterfaceActiveIndicator (CR 2940)
**	04/04/2011	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/30/2016	K. Dobranowski	I rewrote this stored procedure to acommodate latest DB design changes for interface configuration (Defect 340457).
**	10/25/2016	K. Dobranowski	Fixed select getting the inteface IP and Port to use direct link from EndPoint to Interface table (Defect 340457).
**	02/14/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditInterfaceControl]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	CHAR(5)
)
 AS

/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	--this SELECT returns VBECS IP and Port
	SELECT

		VEP.EndPointAddress AS VbecsIPAddress,
		VEP.EndPointPort AS VbecsPortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = 'VBECS_EndPoint' AND VGC.ApplicationName = 'HL7Service'
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

	--this SELECT returns Interface IP and Port
	SELECT

		I.InterfaceId,
		I.InterfaceName,
		VEP.EndPointAddress AS InterfaceIPAddress,
		VEP.EndPointPort AS InterfacePortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.Interface	I
		ON I.VbecsEndPointId = VEP.VbecsEndPointId   
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	AND VEP.EndPointType IS NOT NULL
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

  	--this SELECT returns Interface Status and Facility ID
	SELECT

		I.InterfaceId,
		I.InterfaceName,
		VGC.ParameterName,
		VGC.ParameterValue,
		VGC.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VGC.LastUpdateDate) AS MirrorDate,

		VGC.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsGlobalConfig VGC

	JOIN dbo.Interface	I
		ON VGC.ParameterName LIKE I.ConfigPrefix + '%'   
	
	WHERE

		VGC.ApplicationName = 'HL7Service'
	AND	(VGC.ParameterName LIKE '%FacilityID' OR VGC.ParameterName LIKE '%IsActive')
	AND	VGC.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		I.InterfaceId,
		VGC.ParameterName,
		VGC.Source,
		VGC.MirrorId DESC   
		
		--this SELECT returns AckTimeout, ReTransmitAttempts and Email that are common for all interfaces
	SELECT

		VGC.ParameterName,
		VGC.ParameterValue,
		VGC.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VGC.LastUpdateDate) AS MirrorDate,

		VGC.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsGlobalConfig VGC

	WHERE

		VGC.ApplicationName = 'HL7Service'
	AND	VGC.ParameterName IN ('VBECS_AckTimeout', 'VBECS_EmailAlertAddress','VBECS_ReTransmitAttempts')
	AND	VGC.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VGC.ParameterName,
		VGC.Source,
		VGC.MirrorId DESC 
		  
SET @ERROR = @@ERROR



SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)



GO




if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetAuditVistALinkControl]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetAuditVistALinkControl]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Get VistALink Control audit information
**
**	Author: Krzysztof Dobranowski
**
**	Date:   02/10/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	07/14/2005	N.Paterson	** Reviewed for compliance with database standards and recommendations **
					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
					Changed date filter from => <= to using BETWEEN, placed input paramerters in brackets, error check input dates
**	07/26/2007	K. Dobranowski	Added VistaDomainName to SELECT statement (CR 2267)
**	02/19/2014	C. Jensen	Added VVC.VbecsServiceIpAddress, VVC.VbecsServicePortNumber to SELECT statement. (CR 3149)
**	04/28/2014	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	09/30/2016	K. Dobranowski Updated sproc to select values from EndPoint and GlobalConfig (Defect 340457).
**	10/25/2016	K. Dobranowski Removed LEFT from JOINs (Defect 340457).
**	02/13/2017	K. Dobranowski Added new SELECT to get the broker IP and Port (Task 459208).
**	02/14/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetAuditVistALinkControl]
(
	@startdate 	DATETIME,
	@enddate	DATETIME,
	@divisioncode	CHAR(5)
)
 AS

 SET NOCOUNT ON
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT


--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

SET @ERROR = @@ERROR
	IF @ERROR !=0 GOTO SPROC_EXIT

	--this SELECT returns VBECS IP and Port
	SELECT

		VEP.EndPointAddress AS VbecsServiceIpAddress,
		VEP.EndPointPort AS VbecsServicePortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = 'VBECS_EndPoint' AND VGC.ApplicationName = 'VistALinkService'
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

	--this SELECT returns Vista IP and Port
	SELECT

		VEP.EndPointAddress AS VistaIpAddress,
		VEP.EndPointPort AS VistaPortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = 'Interface_Vista_EndPoint' AND VGC.ApplicationName = 'Vbecs'
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC
	--this SELECT returns Broker IP and Port
	SELECT

		VEP.EndPointAddress AS BrokerIpAddress,
		VEP.EndPointPort AS BrokerPortNumber,
		VEP.MirrorId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, VEP.LastUpdateDate) AS MirrorDate,

		VEP.LastUpdateUser
	
	FROM

		dbo.SynMirror_V_VbecsEndPoint VEP

	JOIN dbo.VbecsGlobalConfig VGC
		ON VGC.ParameterValue = VEP.VbecsEndPointId AND VGC.ParameterName = 'Interface_Vista_BrokerEndPoint' AND VGC.ApplicationName = 'Vbecs'
	
	WHERE

		VEP.MirrorDate BETWEEN @startdate AND @enddate
	
	ORDER BY

		VEP.Source,
		VEP.MirrorId DESC

SET @ERROR = @@ERROR
	

SPROC_EXIT:

	SET NOCOUNT OFF
	RETURN(@ERROR)


GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spIncompatibleCrossmatchResultsExist]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spIncompatibleCrossmatchResultsExist]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************************************************************
**
**	Desc: 	BR_3.23:
**		If the selected unit in the past has had an incompatible crossmatch result with the current patient, 
**		display a warning message: 'Unit has been previously incompatible with this patient. Please select 
**		a new unit'. The unit is cleared from the screen and a new unit can be selected.
**
**	Author: Carl Jensen
**
**	Date: 	7/10/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	***********	*******		*************
**	06/08/2004	C. Taylor	Replaced PatientGuid clause with fnWherePatientGuid function, to include possible merged patients
**	01/13/2005	D. Askew	Added @lastupdatedate
**	06/29/2005	NPaterson	** Reviewed for compliance with database standards and recommendations **
**					        Comment Header Adjusted, Added NOCOUNT, Specified table owners, Removed comments, UPPERCASED SQL
**	07/19/2005	C. Taylor	Added check for incompatible repeat crossmatch results
**	07/22/2005	N.Paterson	Reformatted SQL to be easier to read				
**	08/22/2005	S. Antropov	** Reviewed for compliance with database standards and recommendations **
**							Performed secondary review during the code promotion - merged changes
**	09/09/2005	D. Askew	Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	09/29/2016	C. Jensen	Changed AND CrossmatchResultCode IN ('D', 'I') to AND CrossmatchResultCode IN ('G', 'I')  Defect 357455.
**	02/14/17	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spIncompatibleCrossmatchResultsExist]
(
	@patientguid		UNIQUEIDENTIFIER,
	@bloodunitguid		UNIQUEIDENTIFIER,
	@lastupdatedate		DATETIME = NULL			
)

AS

SET NOCOUNT ON

DECLARE @ReturnValue INT

SET @ReturnValue = 0
	
IF EXISTS (
			SELECT 1
		    FROM 
                dbo.OrderedUnit OU
			JOIN 
                dbo.OrderedComponent OC ON OU.OrderedComponentGUID = OC.OrderedComponentGUID
			JOIN
                dbo.PatientOrder PO ON OC.PatientOrderGUID = PO.PatientOrderGUID
			JOIN
                dbo.PatientTreatment PT ON PO.PatientTreatmentGuid = PT.PatientTreatmentGuid
            JOIN
                dbo.Patient  P ON P.PatientGUID =PT.PatientGUID
		    WHERE 
                BloodUnitGUID = @bloodunitguid
			AND P.PatientGUID IN 
			(
				SELECT 
					P.PatientGuid
				FROM
					dbo.Patient P
				JOIN 
				    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
				WHERE
					LinkPatient.PatientGuid = @patientguid
			)
			AND CrossmatchResultCode IN ('G', 'I')
          )
	SET @ReturnValue = 1
ELSE IF EXISTS (
			SELECT 1
		    FROM 
                dbo.OrderedUnit OU
			JOIN 
                dbo.OrderedTest OT ON OU.OrderedTestGUID = OT.OrderedTestGUID
			JOIN 
                dbo.PatientOrder PO ON OT.PatientOrderGUID = PO.PatientOrderGUID
			JOIN 
                dbo.PatientTreatment PT ON PO.PatientTreatmentGuid = PT.PatientTreatmentGuid
            JOIN 
                dbo.Patient P ON P.PatientGUID =PT.PatientGUID
		    WHERE 
                BloodUnitGUID = @bloodunitguid
			AND P.PatientGUID IN
			(
				SELECT 
					P.PatientGuid
				FROM
					dbo.Patient P
				JOIN 
				    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
				WHERE
					LinkPatient.PatientGuid = @patientguid
			)
			AND CrossmatchResultCode IN ('G', 'I')
		)
	SET @ReturnValue = 1
				    
SET NOCOUNT OFF

RETURN(@ReturnValue)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[vw_BloodUnitsWithAntigensIdentified]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[vw_BloodUnitsWithAntigensIdentified]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*********************************************************************************************************************
**
**  Desc:   Returns active blood units with identified antigens
**
**  Author: Stas Antropov
**
**  Date:   07/19/2005
**
*****************************************************************************************************************************************************
**  Modified:
**	Date		Name		Description
**	----------		-------------		--------------------
**	11/28/2008	M. Smith	Added dbo prefix to view name (CR 2503)
**	12/17/2008	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
**	01/26/2017	K. Dobranowski Modified JOIN ON AntiseraWorklistTyping to LEFT JOIN (Defect 434762)
**	01/26/2017	K. Adu-Poku	** Reviewed for compliance with database standards and recommendations **
*****************************************************************************************************************************************************/
CREATE  VIEW [dbo].[vw_BloodUnitsWithAntigensIdentified]
AS

    SELECT DISTINCT 
            dbo.BloodUnit.BloodUnitGuid,
            dbo.AntigenType.AntigenTypeID,
            dbo.AntigenType.AntigenTypeName + 
            (CASE WHEN dbo.BloodUnitAntigen.Positive = 1 THEN ' Pos' ELSE ' Neg' END) as AntigenTypeName
    FROM
            dbo.BloodUnit
    JOIN
            dbo.BloodUnitAntigen ON dbo.BloodUnit.BloodUnitGuid = dbo.BloodUnitAntigen.BloodUnitGuid
    JOIN
            dbo.AntigenType ON dbo.AntigenType.AntigenTypeID = dbo.BloodUnitAntigen.AntigenTypeID
    WHERE
            dbo.BloodUnitAntigen.RecordStatusCode = 'A'
        AND dbo.BloodUnit.RecordStatusCode = 'A'

    UNION

    SELECT DISTINCT 
            dbo.BloodUnit.BloodUnitGuid,
            dbo.AntigenType.AntigenTypeID,
            dbo.AntigenType.AntigenTypeName + ' ' + dbo.TestResult.TestResultText COLLATE SQL_Latin1_General_CP1_CS_AS as AntigenTypeName
    FROM
            dbo.BloodUnitTest
    JOIN
            dbo.TestResult ON dbo.BloodUnitTest.TestResultID = dbo.TestResult.TestResultID
    JOIN
            dbo.BloodUnit ON dbo.BloodUnitTest.BloodUnitGUID = dbo.BloodUnit.BloodUnitGuid
    LEFT JOIN
            dbo.AntiseraWorklistTyping ON dbo.BloodUnitTest.AntiseraWorklistTypingGUID = dbo.AntiseraWorklistTyping.AntiseraWorklistTypingGUID
    JOIN
            dbo.AntigenTest ON dbo.BloodUnitTest.BloodTestTypeID = dbo.AntigenTest.BloodTestTypeID
    JOIN
            dbo.AntigenType ON dbo.AntigenType.AntigenTypeID = dbo.AntigenTest.AntigenTypeID
    WHERE
            dbo.BloodUnitTest.RecordStatusCode = 'A'
        AND dbo.BloodUnit.RecordStatusCode = 'A'








GO



--Permissions

GRANT EXECUTE ON  [dbo].[spGetVbecsUserDivisionsAndRoles] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInsertVamcDivisionBase] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spUpdateVamcDivisionBase] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetDivision] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetVbecsGlobalConfigValue] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAllVbecsGlobalConfigValue] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAuditDivision] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spVistaGetXmlBloodBankData] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAuditInterfaceControl] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetAuditVistALinkControl] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spIncompatibleCrossmatchResultsExist] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[V_LinearInterface] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[vw_BloodUnitsWithAntigensIdentified] TO [VbecsAppUser]
GO

--Adding Blood Product Changes formerly 2.2.0.2 RevB changes

-- Delete rows from [dbo].[BloodProductModification]
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='1e68cdd4-e724-4008-9610-37dde4cc28a3'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='60b9c13e-8c81-4a66-aaf0-40e137d70fe2'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='8a7d8dda-4664-40f7-bd9d-58d425732a60'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='d0e67254-0b8b-41bc-8251-70b2726f61f7'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='c63c3caa-bfc5-4880-acd6-75d2f8fbd1e7'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='873a5910-f3f2-41ad-98ac-8caf26c2e0f6'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='76a9121b-4b27-4e98-baae-9b8c226888cf'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='2ec37cd3-3bf9-4036-a064-a09829026590'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='a27e655c-8879-4ece-8ad8-a725ec46eafb'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='be5244fc-05d8-49ef-a77e-b8e9153476b5'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='0e4700e9-7a41-4d9b-b80a-c461ea277293'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='f01c0894-e4fd-4f73-a9f8-c4bf85d9e4a6'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='2e29495e-293b-4c3b-b16d-eaccbacab863'
		DELETE FROM [dbo].[BloodProductModification] WHERE [BloodProductModificationGuid]='439317fc-b121-4488-b1ec-fbb4b0e07dba'
		-- Operation applied to 14 rows out of 14

		-- Update rows in [dbo].[BloodProductModification]
		UPDATE [dbo].[BloodProductModification] SET [ExpirationDateRule]=24, [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductModificationGuid]='5e20a657-c397-461a-8964-0819f0d1da46'
		UPDATE [dbo].[BloodProductModification] SET [ExpirationDateRule]=24, [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductModificationGuid]='c4021584-58b2-465c-beaf-3f355330ee36'
		UPDATE [dbo].[BloodProductModification] SET [ExpirationDateRule]=24, [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductModificationGuid]='02500799-fe01-4b59-8e93-86e4d3fd57e0'
		UPDATE [dbo].[BloodProductModification] SET [ExpirationDateRule]=24, [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductModificationGuid]='d4c1bf83-ff57-4b49-bb6f-91485ebd88ec'
		UPDATE [dbo].[BloodProductModification] SET [ExpirationDateRule]=4, [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductModificationGuid]='07c18d8a-7bc1-4cd7-9c62-93b08284e3e6'
		UPDATE [dbo].[BloodProductModification] SET [ExpirationDateRule]=24, [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductModificationGuid]='ad44cd81-d5ea-4ad3-ae02-9a8f83435973'
		-- Operation applied to 6 rows out of 6

		-- Update rows in [dbo].[BloodProduct]
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=48h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f7511bf5-3136-46c6-8048-0002d234403c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f744803-a8c7-4be8-b57b-000dc9f262b9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d813e55-2ce3-41e5-b6db-00129a6467b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e95ecb89-ab1c-4281-b116-003599453ee1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='faf0bec7-9a8e-4d67-8a17-003edd518e1c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='583d0f67-65ba-48eb-851f-0053840688ac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fbd6f05f-03aa-4933-b897-005d13ebbd92'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f609bce-1994-43c0-abc5-00797f5ecb87'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR CP2D IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d838e572-c8bc-489d-85ea-007ab19dea5e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CP2D IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a3a81e76-4891-497e-94a6-009e06684c19'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='404050f7-b7cb-46f2-ae92-00a9727ed76c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99ff5ca3-93df-40bb-9384-00b0e1d0cca9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6cdfa3c0-8bc1-4ecc-bd49-00ba5619a3dd'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|Psoralen-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='51e7a037-8be1-47f6-84af-00c7f906d08d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='195c1032-be19-4459-9f59-00d639997b50'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9dc632dd-5e31-43b0-8d3b-00dbaee14a9c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C MNFI LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8c84bc25-06c9-4bd4-81b6-00e3b8857610'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c466828-b522-4dc4-9610-01045a3d6257'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b24b30c-b628-4e5b-a795-010694720a6b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a74f83a-1bf5-4567-a411-01305f7b703a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='071c9183-124f-4956-84d5-0146dfc5538c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='867966e8-2777-47c0-877f-014a1b0bd3df'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-80C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='79f2764e-62d0-4671-9ad1-014b972e5969'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59907475-59cf-432b-9087-01523ce74582'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/350mL/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='098a3133-e1cf-4c0e-9d69-015dc0e433eb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='82c67c6f-9887-4509-b18e-016b454e4d06'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|3rd container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='61ab2176-fb97-437c-b1a4-0171db4f0f86'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='87a6aa63-824d-4918-b26b-01960469100f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 OPN IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3d809fc-9904-4ca7-a863-019b2892ec9f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e3a1fec2-b7a6-4773-ab10-01a72e170eca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05528312-299a-49a4-a0ec-01c5057e247a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e43d868-5963-4a36-9276-01dd0a4aac03'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bcef76b1-613a-449d-ad18-01e0efd8b493'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='706144a6-cd50-4f92-8a8d-01f9b6db5212'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da80a69e-1877-4c19-b4d8-02167dd3fa3c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='824b7edd-7113-4bb0-a654-022a635ddcd6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='636e0e7e-3348-4a77-981f-023cad1ad338'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='78bf99e9-e3d1-45e2-9bc7-02578767eb28'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='188c0162-35a0-4e79-8998-0258bd6d5053'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ce1ad4d-4e4a-490a-af98-0269e1c6131a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='47d0593b-cf72-4c31-a96a-0275d808134c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a3d6398a-5cab-4b4a-9d2e-0288effcf01e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a59ffaef-a8fc-4f4b-8f89-02899aedf7dc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A MNFI OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a184dbca-fae5-4035-8445-028db3a5a370'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ad652829-d541-41c5-aa49-028ff30ff981'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='211d5149-05fa-4152-b2cd-0296c9b7a7c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='105c0e5a-ace7-4178-9f05-0298845701ef'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='df3c69c7-8458-4c5c-92d2-02af68631d53'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f4f5429-ffe7-44f9-a1dc-02b7a768f72b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='66ab7ef6-9ddd-4958-87e2-02b85ac78325'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3edd6947-fda6-4c4d-95ca-02d3233bc595'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a60e16bc-df15-410b-af2a-02f7be51455b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5fff13bd-0723-4b43-bbc2-031d2b5dd83e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/450mL/<=-65C|Open|ResLeu:<1E6,WB filtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a87f0df9-d7f8-4951-9506-03384413e8b0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='39d7c8f8-bbc1-471c-aa49-0347535f532a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='70f09ae1-11bc-4ae3-baf0-034cde02878c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 7C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9617d91c-db5f-49aa-83c9-035d1f74598e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c12b66f1-fcd9-4594-9108-035d6871efb0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED PLASMA|CPD/450mL/<=-30C|Cryo reduced|Frozen <=6h|2 units', [ProductShortName]='PLASMA Pool CPD CRYORed 2U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e6f525f9-63d5-4a3e-a53e-037cbcde5454'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='051df4f3-023e-45a6-85b9-03866d05ef7e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD LUKOPR 1C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7ec8df8-c4b1-4b13-a85d-038846474bd8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ff375825-7ead-4fe5-9b5d-039a1e07e6f9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|For mnf:injectable|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fca0eeca-2eac-4ab5-8d46-03c9979f5c3e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|<200 mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4296af12-7915-4a08-93b5-03d48f57d791'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb762690-cfd4-4aba-8a8e-03d889ac7394'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='325c1808-39ff-416d-ac60-03f17e830448'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='06709155-fa60-46d9-8529-03f1d8783c1d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f45a2983-59b1-497e-9e3e-04129e63f639'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ca23cfa-f6e9-4d7b-9a4d-0446ac0599c2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b9825717-ca09-4408-b9a8-045f0e4de9bd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='26f1823e-f613-40f7-92ce-0464944b660c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6eeb0fdf-098e-4602-bc0e-046f23c77d08'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ec6b8127-3318-4ebc-81cf-04810db05ba4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d39ef13c-7739-4aee-84f6-04824bd7d5ab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz ACD-A MNFI IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca32f397-4cd6-4e1c-8bd3-04b845c0097c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dec8cb24-a7b9-4f97-812f-04d10e5205a7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR PA 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='33f6e274-eec6-4c5e-8d6e-04e8d1678340'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='855f2295-09c1-4a7d-b95c-04edb3d5fa11'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d47550e2-2bfc-4150-971b-04f2ad64e8da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='489df6c4-c8ba-4f61-9e29-0515b9551be9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27d919b8-a58e-4094-a5e6-051fb7ff02be'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d5ed881-f6fb-47f0-871e-05238afa02ec'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-80C|ResLeu:<1E6|1st container', [ProductShortName]='RBC AFR Froz Gly40% LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e66efca8-67f2-4571-9965-0525a984a76c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR CP2D 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4bac4dec-0851-4ca1-9aa3-0539a05bf4aa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81b3c073-64b4-46fd-acdd-053f94e43df3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='06b21389-2977-4d71-bcac-0546a5c4526a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='90d74415-9ff7-4bcc-859d-0552da159767'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz ACD-A>PAS-C MNFNI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f507150d-4aeb-4386-a28b-059684e292bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6d6e02f2-c3f4-47ae-b1fd-05a6aa3413f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='128c3c27-c074-413b-a6bd-05a895fcc859'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Irradiated|ResLeu:<5E6|1st container', [ProductShortName]='RBC AFR Froz None IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4407b919-86b2-4a37-96b1-05ba5d82dfaf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|>=600mL|Frozen <=6h|2nd container|Quar:>=4m/retested', [ProductShortName]='FFP AFR ACD-A MNFI LrgVol 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e03cf02-e30b-439b-80cd-05e1ec8567c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='682984cc-98b3-49ba-8dba-061fb4eec53c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR PA 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1677b553-9b63-4d00-bd4b-06498c4d98f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='44b2f3f6-1379-4797-badd-065873b7118b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1d875474-077f-441d-a262-0658820a6503'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR PLS Red/PA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6445357-0200-4539-8686-066208328618'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 MNFNI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dbbbcc07-701b-40b2-960a-06771b6b2aa1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27d6efc5-7d64-41f3-8aa4-06836453cfca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fbbfdc87-b4f0-4199-96d0-06ad449fa101'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e3aef376-72cb-46c9-839d-06c062ca6287'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97e7c70f-703f-4eee-85da-06d914d0dd7d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 3C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='668c6063-787b-4de8-939d-06ddc66b3069'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a9461b7-3d25-4d9c-87dd-06e07fd58f98'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CPD-50 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0df8383a-f81f-4d9d-b019-06e272987e33'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1b8acc66-eada-4165-8edc-06eda8cff282'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0480abb4-0b25-4dc8-9c0b-06f82061cc8f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='248be240-d744-4733-832c-06fa7b1930c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='38643514-2b25-485d-a482-070819602bae'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b79f44f-f6b8-4ab2-b5ca-070a40e28bda'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C|For mnf:noninjectable', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='58e3ddd5-ec0a-49bc-8de5-07174db40efe'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|NS/XX/<=-30C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0f825d1-d58d-41f3-86d5-071d50a56212'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0f2c394-bc7b-46e0-a48f-0725d3f6f0e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b609e90f-df53-440e-920c-0734f5c465ec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37e6d83f-80d5-4c63-b96d-07489bbaeff3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8a9f7a77-947d-420b-8d3e-074e642af213'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b5673c4e-e051-4c03-ba90-0758e1b08279'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a435bd6-962f-4209-8a4e-077a7708c609'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1e6ca56-eaad-446b-92e5-077f4fbf374c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR PA 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73630e46-0c17-4524-985f-078303774035'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='219bbea2-7c40-40d9-ab21-078a6071a62f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c000aee-0d44-43cf-a0b8-07991ac6600e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='31f5c722-daec-41af-938d-07a80b3c861e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='727bcfd9-2b64-41ac-a69a-07bb2633ae22'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2c32ebce-3d55-4cde-b6b3-07cc0de8af49'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='35e4e980-c8c7-49e7-98f4-07e33923b347'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d09cd63d-e7a0-40f0-930e-07e76c5fb09c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|1st container', [ProductShortName]='RBC AFR Froz Rej None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27ad39ea-5181-4908-991c-07eea9931680'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf3baf3d-f1b4-4644-9663-08049fb28de2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b50cea2d-a6ef-4f80-bda6-0840f6447a25'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='06a69853-cb51-4288-9f13-0874b4b10bd6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 3C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c7c3a567-db85-4950-821f-08956431b604'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eabe1783-8b5f-4ef3-80e5-08b0a0ce007c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed47add9-6533-4a99-a98c-08f666eb21f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15264baa-0131-406b-8d9f-090706733c9f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8a356896-f4a3-4e6e-bb79-0937b9b70add'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7668fd6f-116f-4aae-a961-0942e0c9b99b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|1st container', [ProductShortName]='FFP AFR Nacit IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='067a2092-911e-4a90-ab44-095838e58dec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash SAGM LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65b63c62-1361-4498-9552-095a5e81901f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fe0aa3c5-35a2-40a6-ba03-0971a9eb3547'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e8e21b35-ec9c-4cae-8f22-098846efdfae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e5572ea-389d-4fb1-85cf-098ebc3a41db'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='127fa837-932f-4fd8-a18a-099d7f7ab3bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6770dae1-6c23-4811-9f67-09a1c6921443'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Irradiated|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f7655a1-0315-4e32-a764-09a4cbbe5edc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis PLASMA|NaCitrate/XX/<=-25C|For mnf:noninjectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62211d5a-b45b-47b8-bd59-09af2d96ddb6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None NMT OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a36f0f9-8da7-4972-ae8a-09d2cd8c8ccf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 IRD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c3fcd359-8684-4519-93e4-09d875c841b3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e52f0609-d86e-4550-a551-09e035e7ded2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e9b6f83-b66d-4a3e-877a-09e9180650e9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6b1cbe38-82f8-444a-a9b3-09f396253e9a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e7b85a0-1210-43b2-8a34-09fe48afa9ab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='771b139d-5b63-4fab-bc8e-0a026a9ee62f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7236f8a-6c7d-4f17-a1a2-0a1d4ab63880'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|ResLeu:<1E6|Quar:>=90d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9cd3c34-9d8a-4e1e-a441-0a2239266a2c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2ec50628-1ebc-438c-b278-0a260eb55a04'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='507cbc05-6a50-4cde-b8a5-0a352ea4c523'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='08b963ae-448b-4739-a0d3-0a402e291954'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d672738-1803-4263-8f54-0a4a36752096'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2992ec17-40da-4711-9421-0a4e88528ef2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb19221e-8408-4922-aa0e-0a7d15dafeb4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9b46ae4-4e73-4acf-95c0-0a8a34b98a28'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='601f774e-6138-4e63-83ee-0a9944d24ea9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Not for tx or mnf|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c5b2deb-1e49-4cdb-b3e3-0aa4019781a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='af3600b3-eaed-4adb-bebe-0aa8cedb7e2c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17db7a9b-63ef-44de-a1a1-0ac02ad5dc43'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|2nd container', [ProductShortName]='RBC AFR Froz None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='165ee53d-d6d8-4a75-848a-0ac7ca5ba240'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='67271341-1694-4172-becf-0ad5b38e9b95'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='515eda3b-78bb-4a6c-98c1-0ae2069f0d1b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9717eeeb-92fb-48ac-8263-0af17cfa5a81'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d2703eb-ffb9-40cd-9924-0b0c6aa19455'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e934b552-b38f-463e-a0f4-0b12a8b5c749'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b3ddbb16-0257-4d6d-a8f3-0b1fbaec3225'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3c348810-387e-470b-9907-0b23f91a1a73'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7ec2a692-5947-4c3f-b77c-0b24c5cae89f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f29dcb2-be23-4465-93c5-0b2fe80c6f5f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='54075713-4466-4607-bc16-0b34a5d31b0b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='33de86a1-e01c-4b6a-8071-0b3bcdbe486a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04842478-bd39-4ebc-b181-0b3fb1423a2c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9408d94-5e6d-433f-9083-0b455d29dcf6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CP2D/XX/<=-65C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='11c29961-fc12-4362-9a45-0b50e6ff7b47'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8c8d85e9-1913-4e8a-a2dc-0b5738e3beea'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d2670dd0-f79f-4789-9006-0b7709800319'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7268c0e1-2c21-42e9-a245-0b8b51a77b79'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4af44482-ce0a-49d0-9d44-0b92e740c3cf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8993118f-e6cf-495a-8090-0b9f2e704020'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d66a32c-a5ce-4b16-b674-0ba7e3caaca1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='355d2f0b-0d57-4292-bbb7-0ba931f0aafa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c4134bf9-d782-4ef0-8b72-0bb51507bff5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d781d99-94da-4a66-88ac-0bbe49982739'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e9605b3-f46f-444b-96a4-0be1219c373d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7628b75b-a398-41b6-be6b-0be35589a1af'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='918e7cf5-4c1a-4c6c-b51b-0bf14da833b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='844129e6-3196-4615-b509-0bff7d311265'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c2dc29c2-1da3-444f-abdd-0c09b8a31e3b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=72h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b9e72d48-4957-48dd-867d-0c0b323d19d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15c30eec-c013-4c19-8edc-0c17d2c54d81'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='090a749c-b7e4-4973-86a9-0c25578b338e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7212469-4233-4783-9e68-0c49897f5592'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 5C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='654e0bdf-9222-4eac-a851-0c5ad4f64782'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f1da18c9-b2b3-43d4-aef0-0c5e6d1e2ab9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b683d6fb-24b9-447c-8809-0c6489aa1380'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80b5b39a-bbf7-4fc3-b722-0c6a381d995c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa1ef2a4-3605-490c-aaea-0c73c2576071'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='87787968-0c7d-4c91-b99b-0c8435df6c5a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='662938e0-6816-4a85-b2c4-0c982da270ca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d0c28239-af4d-4df9-9aa1-0ca8641eefd2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bbb0b45f-9fe2-4faf-ace8-0cae62e4fede'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a6aa90bb-ba87-4083-9394-0cb04490d2c4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c979c251-0885-4408-8cba-0cc087dc3fc8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfcd7a98-38cd-4d4c-8126-0cce57d2c2b4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14e25e74-9072-4de2-bec8-0ce48d2a112d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|2nd container', [ProductShortName]='RBC AFR Froz Rej None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f1e4026-3e1f-497d-9ed4-0cf38cd71860'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 5C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='078f43ad-fefb-42c1-90c9-0d093fa6a051'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='36fbe125-bc66-4185-a368-0d0e430b2f78'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56144b6a-5bc1-4ff0-8f80-0d213fd5aa0e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='175b6950-ee05-47a8-b1a6-0d26630fff6e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/500mL/<=-65C|Open|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2413656d-b147-466c-b83f-0d2fae82b217'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|For mnf:noninjectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='900ede66-650c-40a4-9282-0d2fe3d05284'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6841ffde-de99-4cad-a3fd-0d3a325e75f7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d23203fd-b671-4cba-9462-0d4af5378749'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1153c645-e13e-4129-8354-0d4bb93436d3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3410397e-0b99-4954-8ab4-0d9b7d8a5101'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-30C|Frozen >24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='24e139ac-8683-4265-837e-0db77b724f83'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='919231bd-803a-43c8-854f-0dbc0491a537'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='727b275d-d30f-462a-a5d5-0dbee8a52b14'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz None MNFNI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e9790fbd-0a12-4744-a09e-0dc3888e9393'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4d06c13-b689-4847-b05c-0dc52cee60dd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc939073-82ac-4bb8-a2fc-0dc74562c5c2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f859fe95-9295-443d-8804-0dd21b6c91b0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='983840cc-e135-4d86-96df-0df6cd79283b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50414cb3-564a-4b2f-bb95-0df9f0093926'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-65C|ResLeu:<1E6|Frozen <=6h|1st container', [ProductShortName]='FFP AFR CPD-50 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='02de27c1-6168-4494-8bfa-0dfa600bda5f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|2nd container', [ProductShortName]='FFP AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='160e9c48-ea45-4c3d-bc3c-0e10aaa22b90'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='243d5cd4-ec8b-4ab7-8807-0e117f67cf86'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR PA 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7121853e-5f00-491e-8950-0e4907cc318a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='89826014-130e-465e-a4fe-0e619d2d9759'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|<200 mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ade47b22-f427-4e16-800c-0e9203b5e91b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='467efe86-4459-4457-8c64-0e9ab9be7bec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7582789-5b7e-40ac-8bf8-0e9b82246927'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e057ad3-10e8-4702-96ee-0ea4acc15075'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da3e076e-55cc-4fce-8df6-0ea4b1fd78dc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2d83bed-0390-467a-9faa-0eab816dadfa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e79ed73-2848-4b5f-8fdd-0eaccd498fc1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7bd7bb5c-2e3e-472f-8f1e-0eadc4766775'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7fe7a209-fb57-4a0a-a5f8-0eb706308cad'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c15de35c-0958-4058-931a-0ec014c1faab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e171612c-3cdc-43fb-b4db-0ee3eb781063'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5fbbaf9-782f-4f2b-8992-0ef4baefaa7d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46e96e03-9e4b-4f7c-a733-0f034230c6a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4a15ae10-9aa6-4e4d-befb-0f25b3460f64'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-30C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d00f3522-bc86-497a-8dd5-0f2f41e2840f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d2171462-e5d0-4ae0-b6b0-0f33cd7a8e59'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='265475c0-7e11-4f85-a1ed-0f34a02e7d3b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9545838b-ba6b-472d-8e23-0f3f8ddec00a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='134a8fb0-b996-48f5-9008-0f40ec940944'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cae6f0f3-bd36-41ec-8a0f-0f49d7ce5a65'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='49f09a05-e597-43da-ac2b-0f5b818e37d0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 7C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='744acf3f-8f93-4e20-b48e-0f5fbc956e10'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81bb3040-4e3b-41fc-850d-0f66bd9ef799'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01d253d6-b884-4f30-be64-0f71044bdf9c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fcbbc5ce-e366-4216-b04a-0f74a99af100'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='35d2b26c-cb13-4984-84fb-0f7828afedf0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen SERUM|None/450mL/<=-25C', [ProductShortName]='SERUM Froz None', [MaximumStorageTime]=8760, [OriginalProductTypeCode]='E076', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c97fa2bb-f162-4a04-ab4b-0fafff17438d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 2C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d31c7872-9c27-406c-bb91-0fd1db861255'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='296af449-0b00-4d10-b53d-0fd4161e4e43'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='CRYOPRECIPITATE|CPD/450mL/<=-30C|ResLeu:<1E6|Quar:>=62d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2ec1eb58-d0f3-409e-ac10-0fda3af510ac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0fd91893-41db-4c5b-9f8d-0fe49ca26810'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c5419a9c-5559-4959-9864-0ff92120202c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None MNFNI 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c8b54df7-3018-40e4-bbd4-10318c4a977d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD LUKOPR1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='958d423e-3d30-4738-9ed8-103a68bf0869'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|Frozen <=2h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99a97941-6827-486d-ad7f-103d9ab49c82'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63be6f32-d134-427c-9977-10422e40b185'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4df77b98-88aa-4ddf-87d1-105af6b9e0e9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C NMT LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='13559085-1b66-4b73-8c85-106184babced'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a32863cf-561d-4cf5-80ef-106495705deb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9cd1e806-70d5-470b-84e8-10716e46eb69'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='07ec1b1e-396e-4bbf-80ae-1077dc9d0db9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9116d3b-470f-43fb-a989-10840c7b3e7e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='20db9d84-5c8d-406f-bf67-10891e997b1e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce07f066-b5ad-4d26-b858-10a19d3b1a42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='74c9e0ea-0146-4924-a94e-10a330e62d95'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|1st container', [ProductShortName]='FFP CPD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9ceab73-bee6-4356-9bba-10b1aa0e370e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7e7c83bc-0360-41c3-9427-10b986b64274'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7cbfe74b-eb6a-49cf-951c-10c1dc1ad1fd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d863a8d-8ace-44d9-b82f-10d3d8832504'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='906c24c9-4f25-4ca3-bab0-10d8f17301f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63c24d42-e33c-4b34-8e0d-10e7bc4a35ac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='553ca92c-6bba-4085-b682-10f4b47c5172'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a349ce5d-fe75-45c1-b0f5-114900edc81f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b6e250d4-6c9c-4763-98e4-1161c2fd929c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f46008b-48b7-4678-8ba6-1164f8600041'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cddd7598-ca58-43f3-8c25-11ab0c691624'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bd38cf4c-6054-4b14-a74b-11b595c08cbd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6cbae4a3-733f-478c-85ad-11d7eaedf021'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99572fab-35fd-4881-a868-11e0b0d3224c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0154ee1-c198-4a98-86ea-1253d4d75c3f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|<200 mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46980d02-02f3-48e7-89cf-12594850ba51'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb0bde4f-bd48-4e0a-b502-125e932e4daf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7d9ec611-8469-4579-8695-127554f185c3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-E LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1ca44259-a088-4be1-95e1-12794214065a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fe127ab0-da69-443a-9b56-127d0580c12a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED CRYOPRECIPITATE|None/XX/<=-30C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0907f9d1-9418-405e-9739-12a0f2789864'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|For mnf:injectable|Frozen <=24h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4acf0b28-efd6-4a3c-821e-12ac42fa9495'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR NS MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='403c9ec1-f0d1-4c52-b3f7-12ba1565b8dd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee5f8029-2d2b-44fe-9b0d-12babfaae559'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3f4ce6f-0702-4cdf-8801-12bbe37a00c3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c2320e10-18ea-4d95-b954-12bcd5d1c93f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b949d8c-6535-4e07-a73e-12be5c86a008'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f160414-b603-419b-866b-12c24aa88262'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 6C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f057950-3590-4bfe-a932-12c72cb5556e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='54c8c9ce-c67e-420b-b3eb-12ce8674bb4c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='19608e36-b440-4576-92b1-12dae4076643'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED GRANULOCYTES|CPD/450mL/rt|Irradiated|Plasma Reduced|6 units', [ProductShortName]='GRAN Pool CPD IRD PLS Red 6U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d75ff5c5-0fab-48c2-b007-1334409234b3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d87b7f7b-979e-4c39-a070-1334a94aea59'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea74e646-aa1e-442a-b5e1-134433c735fd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01445b93-f2dd-40f4-ba1b-136328b147bd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='247531c8-144c-4af6-aa54-1364cb499307'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc783f74-dab1-4045-bd16-1385711978b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6cd083e-0500-4708-9aaf-138fd75effe2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e96ad9a-56d4-428f-b99a-13af50850ad6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e4685df-df3b-42d4-a5c4-13b4013e09f2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|2nd container', [ProductShortName]='PLT AFR Froz DMSO OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a932b1ef-14ee-4abf-9cd2-13b57eaed945'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e104364e-587d-4f17-bde0-13c566c6f633'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='714eb1ac-af47-485b-9974-13c7bea51689'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/450mL/<=-65C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e8ffc0bc-0aac-4b4b-bf00-13d3bd51c207'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81922c8e-fc82-4f2a-8639-13d4c27f8b59'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|ResLeu:<1E6|2nd container', [ProductShortName]='FFP AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73dd99bd-7011-4671-86e2-13ddb0aa4ecd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a513bf8d-380e-431c-89e0-13dfdf4d0371'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1a299e7e-3a8a-48fe-ac14-13e0f0bf2fc4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='77f9efe2-e04b-477e-b7f6-13e5dcebb5cb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3602859a-41c1-4728-a616-13eef65ff24f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='90f586c3-0639-4b83-8e96-13f95240db42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e02da9e-5e8f-4aa2-9dd8-13fab7ba9194'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-65C|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2bb53ad5-31f2-4000-9a1f-13fb714746c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 4C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f3015eb-3e1d-48bb-a798-140409b38367'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|4 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2c67266-2d78-4789-9f3e-14079ad76e19'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6bcd3738-619e-4dc4-8f46-140ef23c90fe'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='72d62690-0943-4eb8-9ebc-14349ced4d6e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='117368e9-e12e-49d9-9a36-143b10c670c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='23add771-b150-42de-a09a-143f80522daa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='549dfe8e-4195-4448-9f03-145e10e67384'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|5th container', [ProductShortName]='FFP AFR NaCit 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a8e07af5-e945-4172-97c9-14af3a4da37b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1d2cf92-f474-4d26-a3bc-14b91b41c738'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='af6a72f5-6e7c-4223-8432-14c249966cda'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97a75c0b-e5c4-4490-83f6-14c49c235b8d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a9f38db-7f07-4fe9-b421-14ce3935d2fc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='11da7f96-b786-4ffb-b363-14e85ab083ee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8bc4eda9-879f-42a9-9caa-1519b13a7031'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='093273b4-a7fb-4397-8961-1540f066cd39'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|5 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5204f5bd-7eaf-43e9-a78c-154b46cb2af7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='504f9c4d-ae38-4030-916e-156016ab5a93'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly35%/450mL/<=-65C|ResLeu:<1E6|2nd container', [ProductShortName]='RBC AFR Froz Gly35% LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4019e9f6-0cfe-4cb3-8a60-156ab092a89f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=15h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ba0b299a-e838-4cfd-b63c-159607b4a0b7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:injectable', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f4ffa2b-e288-4148-925d-159bbbe3b358'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59df50b5-bed8-448a-807d-15a7445d7dc9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis CRYOPRECIPITATE|ACD-A/XX/<=-25C|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f1ad5191-75bf-4efb-a5dd-15bf8f91c06c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ed2711d-5ff8-4c9f-98d6-15c00a86ac67'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR CP2D 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fc5df842-2a99-48b1-b77b-15cba24771da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d6c35aec-85c7-4aac-be30-15fb4a6906e5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a316ec7a-d813-4c46-adba-16041a3b31c6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2517575a-4e53-4a1f-ba20-164aed367318'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='16c49236-f508-4758-a17a-164d7c7ce3a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59de2b1b-b96e-4075-87f5-164dbe0410d3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/450mL/<=-120C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37277309-d319-42ba-a63d-167d068178ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='342329bd-07c8-4c1d-944f-169fd0de6ce1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open|2nd container', [ProductShortName]='PLT AFR Froz DMSO NMT OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='db844b86-69f0-4e7b-a024-16bea98a62d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA Thaw None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9da739d-903d-46e5-b128-16c3b5e9220a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='693ead87-b62a-4a6e-857a-16cdd4bfde3c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='28052ce2-c3c6-47bd-af66-16d66c9fee9a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be4ac940-9102-46d9-939b-16e3966626a8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|For mnf:noninjectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee6ba36b-7036-4fc5-b474-16f58dedc14e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae662f9f-7298-4ee6-894d-170458e265b5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Thawed PLASMA|CPD/450mL/<=-25C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b642c96d-e652-46b7-a2a5-171835939b99'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6b3ad796-2b22-4e6d-99c9-171e055219bc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e81e305-5afb-4807-8d17-1720fb22e6d8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|3rd container', [ProductShortName]='FFP CPD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='412651c4-0a68-488f-a16d-173bdb002040'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a3d8e580-f20d-4ac9-9612-1742b75cb68a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C|ResLeu:<5E6|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3d055067-9513-4831-9d67-1749ae884f1c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4577c73a-a253-4e02-8e12-177f9f25fd84'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7881656a-ddfa-4d87-ab4b-177ffda4adb1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 2C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cbb2b9e6-0ed8-45e5-9aa3-178f42d25f36'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a40515b-aee0-4371-a624-179009ef6941'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='100b1f53-1bb4-4ac5-92f7-17a1d08fd7a8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5adc555b-8aa8-4aa9-bc77-17ab178b07dd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ec7fd935-bfd4-4211-9841-17cbab89153c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed1a789d-1e6c-4b9f-a732-17d5a217c1f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='CRYO AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a0aa6eb-7c49-42e2-bd3a-17e0e84d74e2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3d8f9df8-dd8a-43b6-bd21-181cbc5390c1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ccdbc5e4-bc4c-423f-9be3-182591d7bfe7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46a19a31-3c52-4be5-aa1b-1827ae8115af'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='740b79dc-2814-4556-9332-18309adcaeb8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f5eea0e-604c-485f-9a15-1832c93c516e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C OPN IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='adf22dce-426b-4ee8-b8e7-1836d64d35a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f8ecd1a3-fa6e-450c-b243-1857c0deba74'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6cd73a0f-2d3d-49d7-9b24-186c69519462'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='68170a26-c174-48d5-b0f4-18824b587a66'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-30C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='307f66d4-acdb-4397-9e34-1890e3acf3de'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5b2604de-c409-469b-a3d2-18ae57866dd4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='24a49454-e37f-4508-8f0a-18c95e85968f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis CRYOPRECIPITATE|NaCitrate/XX/<=-25C|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73fc306b-7d95-4a3b-a2c2-18cf4e5ce6a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfb1b6d4-4867-420a-8ea6-18e8efdc60c4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='743cc1e8-4525-4288-ae9c-18e99127a73e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a599a5f7-1ba9-4b4f-a9ac-18ffe3f991a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e0361b4f-e168-45f7-9ece-190dbad82da3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CP2D/XX/<=-25C|For mnf:injectable|Frozen <=15h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0800c1ec-b228-4dcf-9bf6-1917be92175f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd4810d5-6008-4da9-8496-191f4a2f7a65'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='734937db-827e-488b-82e4-19271fc75456'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bc0386e5-7370-42ff-8689-192ba45e1537'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a057d45f-c710-4f27-8239-19557f2a60ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee3cfd43-ed33-4614-b90c-197780fe9527'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|1st container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dbea63ce-b550-4a7d-977e-19b261322aaa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='23962b47-6837-41f6-96a3-19b4c181585c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='03958448-a664-4a2a-b30d-19b8b7c1d2fe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR None IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6407559c-fbd1-4d10-8930-19d5e7cabda6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a594a1f4-5539-402b-88a9-1a04c7f3e0a9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='afe86f25-a1f1-49ae-b31f-1a0cc5a04d1c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='730e9f3b-def3-48aa-b2d9-1a0e7d895fac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e29f780b-809b-455e-8025-1a1188170997'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e91c53e0-425f-4381-8ecb-1a45ed3cfafc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='df0dc164-c0b6-49ad-a374-1a47b5ea034d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0fd3d984-ca8f-419d-afcb-1a6d995fad84'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c0e89202-a1c0-41f8-8252-1a74c3dc48b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD QUAR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62f824c7-9f10-453b-95b9-1a76c2378c7c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='68ad78a5-6596-4110-9b0a-1a8b0af98aa5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c43f6b9-e336-4a09-98ec-1a8ce6db7b5f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e69af77e-63c7-486a-958d-1a8e55824a7b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-D IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80ffff2e-cba0-4835-8c73-1ae80bfa6efb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='82da58b0-facb-49a8-8860-1af591f283df'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8a051bf3-7f73-4a2e-bfcd-1b1928b7717d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee63f9a8-62b5-425c-bb66-1b2952524344'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81a6a2f0-bece-4d0d-84c7-1b2a1da059f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz ACD-A MNFI IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='52d625ab-0573-4826-8f6b-1b4bbd7197f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e25bfbdd-f4ce-4d38-8630-1b5544ebfe62'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='895a64db-6777-4c3a-b684-1b5c75dcf32a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz Gly40% OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f1c718ec-a050-477d-b441-1b716e86531d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='45ea865e-a8f0-4f37-9088-1b81ad47739e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da4bfa20-9f9b-4595-ad37-1ba6a95a8dd4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f4f11a7-3b28-4e44-8bc1-1bafac98f45f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c46d112a-02fd-4636-8499-1bea42e99f0b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='531bbfc9-4c34-481e-8639-1bebf09d2815'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='220f9b56-21fb-41de-b211-1bee298f0473'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9428318-aa56-4423-8f06-1bf7df4fc85c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b314262b-abef-47d3-9e5d-1bfa103fa02b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7aa910f2-34e8-42a4-9566-1bfe0d636fe5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e43aae52-c1ba-4445-a688-1c0818f60791'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a60235fc-d7d2-4d2c-a4c9-1c29a3b755a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f5d55a3-da57-4127-b289-1c2a59521b2e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12d1c37f-2fca-46c5-bbe2-1c2fa30d066c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|For mnf:injectable', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e53060ec-51d1-4366-bf8a-1c333a9d7564'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='565cd2d1-a2ac-4d31-916a-1c4015573b2c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|ResLeu:<1E6|2nd container', [ProductShortName]='PLT AFR Froz DMSO OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='20426e41-7d6d-4314-8aab-1c555827f69d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca7b2d2a-eefe-44a4-8fdb-1c66312b4557'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='101f72bd-7661-4d65-b2ce-1c6a56861f1a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 6C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='34c68c63-2e1e-4dc7-9f81-1c77ca004adf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash ACD-A>PAS-D LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='88508bcb-149e-42bd-9a76-1c9b2a3c51c3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7186758c-3043-4689-b9c3-1ccfedb7acdf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dbfeefef-b296-4045-b498-1cf598be0c1a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc10c284-3ebf-4a7d-adf8-1d0cec5cc9f1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac48c4da-bf05-40b5-86cf-1d2780b72cf2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|Irradiated|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3665e80-be74-4f97-ab71-1d4dc169abe3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a64875d3-65ba-4a3f-a89b-1d564d76ce23'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-D IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b1af311-7ac2-4444-919c-1d782c0a619a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17150488-1e0f-4635-b55b-1d87a39f5df3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|Buffy coat plts prep|5 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01543a95-ca4c-46b6-a3f0-1d8a25e9abed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='70730f4d-5579-4192-94a8-1d908ab48ed3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7587415f-1e75-4ffd-838b-1db1b15c0116'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='066ad462-89e8-475a-9c57-1dbd7f472956'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e2fd8f38-52fb-4f18-9ad6-1dc374307d90'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='13e24cfa-03d3-4a7a-a3bb-1dfcc44bca51'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1233b1ff-69ba-4893-b837-1e015a8a39f1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='64ae2340-f61b-4912-98bf-1e0d95128c6a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='367ddedb-c03b-4cd4-9dfb-1e1bae35a77f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Irradiated|ResLeu:<5E6|1st container', [ProductShortName]='PLT AFR Froz DMSO IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a5b60242-6bb0-43bd-9532-1e28f7f36667'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d77c07a1-2e98-4030-b5d7-1e3604a7e810'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9dfbac83-38f4-48c0-9350-1e463713ae6a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3b73ea4f-caea-411a-bf1f-1e4b30618dd5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='28b316fe-f204-4fd1-9c7d-1e4e48a69cb6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1cb55c2e-02dc-41c1-aee1-1e620f5b1ca9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|Buffy coat plts prep|4 units|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d6671e37-6323-4c79-97d0-1e64ba8ebbec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='481dd0a3-7430-40f9-a2a7-1e7426ac5481'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 1C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8902fdb5-4d39-4d25-8170-1ea261dc4545'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='793813f4-3b8a-495f-b9f4-1ea8e299ec20'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ff87b82-349e-407c-8329-1eba0ca3d98b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4355242b-8dfa-4487-be59-1ebb317db05a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73a832d5-8f96-4323-a374-1ebd73f7e3a3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|4th container', [ProductShortName]='FFP AFR ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f187265e-6a86-4887-8a17-1ec96893c38e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04c24c36-7971-4af1-a08e-1ed60c8be227'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|3rd container|Methylene blue-treated', [ProductShortName]='FFP AFR ACD-A LUKOPR 3C Methyl Blue', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4827252-decc-4d08-a47a-1eeb07176fcd'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|3rd container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f4cd791-a780-4c41-b011-1f2e63fb5048'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c2c226b-da1b-4155-ab73-1f4c5f26bf51'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5456899c-462c-4e74-932b-1f5479cca572'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:noninjectable|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2809fa2-39f2-4349-b235-1f5cac1104b0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cbccb67e-8ed0-4c13-bfdb-1f5dd8395134'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f20e6d5-a096-4c3c-bbfb-1f66bb014c13'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2c0ef873-3a31-4ba3-b96d-1f74b75766ca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR SAGM IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='53567118-9701-4adb-8f4f-1f7e9eb1924d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>SAGM OPN LUKOPR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a00f801d-6f6c-434f-ba51-1fc0b3c7e9a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f3c7a33-0ec4-4b61-8c29-1fd16fe67d61'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9c363a7-b814-4cd6-b41b-1fd70860c7ed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 4C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea9ae6bf-dbc9-4aad-aea2-1fd92e033cbe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cf4b84cd-d0a8-40cc-9a9c-1feefeebc8ab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14c8405c-289e-4aba-9b84-201ba36863b1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly35%/450mL/<=-65C|ResLeu:<1E6|1st container', [ProductShortName]='RBC AFR Froz Gly35% LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0bb3e4f9-af43-43ef-ac08-203a324f8865'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='64de95e0-d228-4c01-8ece-2054c0fb2d23'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0279f3d-819a-4285-8d5d-20590d45d19c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46b7d6ab-8d19-4b27-8fd3-2072255f38aa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9495e71d-7856-454b-853b-20741aeb9031'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9cb0f9c-7c53-4407-a953-2077dba6b5a9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3fcf92e4-bd16-4313-bd93-2086b36536d1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50530d6a-6ef7-4e96-9f04-208ae2a6ab84'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e70f3be-84b6-44b3-81f8-20bd7c36170c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0da9364a-74ac-4905-b10e-20be3db33bc8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a56d4808-38ef-4d03-b78c-20cb54a56bb1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0de9aeba-ed5a-4f48-a8c1-20d5da208352'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ddbbe0fc-ddf0-46df-9f37-20e1aa9848a2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 3C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc49ef02-b638-43b1-889f-20ee58900620'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e52882da-5f87-471c-aebd-210485654cf1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80afb254-4199-4e7f-ae37-2105ef912cf0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='71550e11-a75a-4e59-b742-2108892db8e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7edda184-8bf9-4ff2-9174-2115cdb1eaa9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|0.5 CPD/XX/<=-30C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e31361e5-182a-4ac6-b54e-21207da8120b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d4b6e46-0d6a-47b8-b0db-212976cdda80'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7523a296-ffc2-44c3-848f-2149be432a6a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c5c63d1-8391-4849-ae3e-21502d0b2a62'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='925cf063-f890-4b38-9113-215b216fd063'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:noninjectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee464842-8ac1-4554-a6c7-218070018fe7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='056d6a5f-0a3a-41f1-be6f-21960506ffd6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e5f7cf7-a4bc-4e1f-b91a-219780eaad32'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='87ec0c25-fd29-44d4-a66d-219a79c35f90'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bde2fe6a-c432-41da-851f-21a400eec015'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09afa9be-b31f-4ede-976c-21a5cc5e3ef0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7afb1d01-3157-471e-9dd2-21a7272412e7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='933240b8-98de-48ac-996c-21b4b78cb264'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='67bc2e6b-9fba-4308-8d95-21b6921a2f02'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e6bf7192-e321-443b-a163-21c58196a287'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/500mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e8acdb23-af7a-43ef-81dd-21d6f31b5744'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='040e8ad3-2306-4a4c-8434-21f426423e60'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A PLS Red/PA 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='644f82ce-a5ad-40f6-aeaa-21fc45633d7c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae8c98c0-4252-42f4-9e7f-221919473fac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d2c54586-21d2-496e-bc48-22198b5ceb79'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d00056d3-3428-43f3-a5c4-2229571242f9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|6th container', [ProductShortName]='FFP AFR NaCit 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2574d576-265e-41e9-85aa-22552186a374'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFI 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ed3f4c1-1a04-4ba5-b106-226925a010ac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b546c144-e3ed-410f-9ec0-228db5132adc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62c86293-cf5a-482a-a01b-2291e8148335'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e69fa0c2-84b5-4922-9d07-229f39788164'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 7C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dab3fb43-721c-4a36-8f78-22ae72379529'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f408279-c5a3-4e2e-9dbd-22b5ba300143'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|For mnf:noninjectable|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='814f029b-4ca9-41ef-b735-22b5e45ca6a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e1dc247-eafd-48cd-8c8c-22bb65939373'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60e06132-ae56-47de-b5c9-22d318a85410'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='516eb5de-e885-44ae-92e4-22d9b7ca4b84'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5708dc3-ab7c-413e-8e26-22f029d732f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b1f1601-e296-41bf-aea5-22fcc70d72ae'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='61aa55c6-d137-4d4e-922c-2302a76fe66a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|Not for tx or mnf|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bb7b28b2-7c1d-43bb-a7f8-23144e291ddf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63e458ee-58b1-48fb-a36a-233129233d12'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='32fca804-5009-4a78-878d-234679b99d3e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be9403d5-66eb-49ed-a1d0-234a2eb12210'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c20dff55-c856-4eba-8b91-235afe700b51'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e96dc13a-d140-407f-a17c-23666253c323'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7e6f174-48ba-4cac-8fba-23800ba5cac1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f853f113-660d-4efa-93d3-2382cbe9827f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9aec0f1-d128-4b0a-9b97-23873e08d8f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55f65d87-c66b-41a0-a099-238da7abd52f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='768b5a39-9afa-4835-940b-23aa5360a558'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0bd0f62-80de-4012-b45f-23c48cc20334'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a60f91ba-94bf-44ea-bb1e-23df55d84d42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='090bc9f4-9407-4efb-8ba1-23ec39fb650a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD LUKOPR 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2feabcd6-8e2c-4bb4-9754-23ef1243514b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='66966ff7-f512-497d-b4b4-23fefdaf67e2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=400mL<600mL|Quar:>=90d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fb28a957-18fa-4939-992e-240b17a6dbf3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|6 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9638907a-f796-4782-98f5-242193ac295c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09d1e57f-027c-4527-b57c-2424464d743b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f116a022-956b-4c4b-bbb0-247b124f43ed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e03c088e-d7fb-4111-acfa-2492efe12adf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 8C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='77f05932-a6de-4808-a68e-2494b61f9bc3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED FRESH FROZEN PLASMA|CPD/XX/<=-30C|Not for tx or mnf|ResLeu:<1E6|>=600mL|3 units', [ProductShortName]='FFP Pool CPD NMT LUKOPR LrgVol 3U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='049dfb33-7f67-4cf5-9f9b-24b3f370551c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dbfbf38e-5641-47d8-b467-24b74cef7d7d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED PLASMA|CPD/450mL/<=-25C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bb737d04-5831-41f8-a729-24bc695ce9d4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e01f324-3981-4407-80e1-24d0b74805c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee35d2d0-9449-46fb-9a9b-24d377014d8d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen SERUM|None/XX/<=-18C', [ProductShortName]='SERUM Froz None', [MaximumStorageTime]=8760, [OriginalProductTypeCode]='E076', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c260ef12-536e-489d-92e2-24d95117e78d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e04a61a2-05ec-4cbf-babf-24eed003463a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open|1st container:not auto', [ProductShortName]='PLT AFR Froz DMSO NMT OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b3e5388-5210-441c-9128-24faa24ebb4b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFI 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1021acb8-e9a6-48a7-a886-25030b29eb9b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8ad4cb01-9711-4049-b8a4-2538fa294c9f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f315270-dc7e-42e5-9048-254872fe8a6c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e0f564b-8a12-425d-aaa8-2556388159cc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='71f55004-9139-4ab6-81f5-25574a6e7372'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-D IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dad4f466-4835-4838-b851-2560504a7548'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8ab18371-0acc-4671-a77e-2568ab3eca53'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac70b97c-e63c-42f9-8994-25759d93ff57'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7512ce3-63aa-4b9f-a38c-258048f46d1a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 5C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d9bd96dd-99bb-4c70-b616-258e1109d0fa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46a146f3-98ae-4462-af3d-25a4921b85ab'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b7980f2-db9f-4519-b928-25a5d00f810e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a29c959b-2028-4478-a198-25cf1996168d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da961b4b-e2e1-40d7-8c84-25e439460d81'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ff79d07-ef3d-411f-a2f4-2601f7e09cae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='432f6de5-c4ea-4f39-81a8-26259afe5257'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfbb7b50-8a31-45ab-9e5b-26281390123f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='915e71fd-048b-444c-b996-26448e2d7f04'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='828acee1-56f8-4b88-b931-266078d777b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0b9a999-49e4-4b3e-80bc-266b6057ac85'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='529170f0-93ca-4545-a7af-2670226ae260'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa0be3e6-71c7-4069-aa6d-2674a517af89'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17dba687-dec0-45d5-af28-2676c5b1b293'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a88f8e3-079a-4c53-9756-2683233a7fc9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d19dee85-b8b5-44cc-879e-268ad74f3433'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 7C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ebdd5824-8eb6-4001-9597-269faec0c6c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1a5f3ad-29a1-4479-bec1-26a06e9bad23'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c2ebf0e6-1fec-4e27-96d3-26a1ca727efc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None LUKOPR 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b89fa6c-4516-4c29-b844-26aa8cd6c5cb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d21e6ba-39eb-44e6-9c1e-26bd508ea176'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6cb34228-4587-49f7-a51e-26be493802f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e9c65cc-30d3-468f-84d9-26c3501c24ab'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d11f2b63-2ebd-4b96-8bce-26cdbccfd924'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6ffee490-e6f6-43d3-b069-26e01ac7bc09'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1af2564c-9c6f-48f9-a68b-26f5d18dec62'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b0e3bbfc-e1d3-4aa3-bdc2-26fb66900e1b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Not for tx or mnf|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a655f1a-15b2-4a30-88a7-26fe763860bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd040f00-9380-465b-95b3-27052654c720'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55fbdb82-88ee-4855-bf44-270d06ca8766'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|4th container', [ProductShortName]='FFP AFR NaCit 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60f1d127-5097-4ab5-8bbb-272138bb66e7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b5c18e00-0ffa-4469-abe0-273a274a60b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='58067761-ad64-4d2b-966b-277224bb019d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|>=600mL|Frozen <=6h|3rd container|Quar:>=4m/retested', [ProductShortName]='FFP AFR ACD-A LrgVol QUAR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b6dd8e34-3f9f-4e3b-b9b5-2782bb2f03aa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e866252d-d1bd-435a-9ecb-27843b58812b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq 0.5 CPD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a22de3e0-d33a-4ff6-86d9-279c09de004c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fee86696-0bc4-48f3-b719-27b2ce1637df'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-30C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3de6debf-2a51-49b0-9a71-27b322840d97'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1527529a-c817-47c1-b078-27bb32cd64d8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6927123f-08b2-468b-a284-27c0e00cb9c7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1778ab67-ade9-431a-9efe-27c3463e085d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|1st container', [ProductShortName]='FFP AFR NaCit 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eca0caa4-b5ca-4173-a9ae-27f112cd0a6f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='74cb4145-3f47-43f0-885e-2807d5c26aeb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1b0c6bbc-2bc0-4208-b301-280b70bdafa5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62320d5e-859c-4311-afd9-281677507638'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>SAGM IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cfcec1bc-7066-481a-9a55-2839ce53e043'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|2nd container', [ProductShortName]='RBC AFR Froz None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7819e51-4991-4bb5-8cd3-285369b70820'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None IRD LUKOPR SR/SD-PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7d1bf0c-8ea1-4229-8dcc-28582b07a58f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A LUKOPR CRYORed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a84c395e-32c9-4592-804e-2859fbae35fc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fad319c7-764d-4a60-b226-2861614be8d5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C|For mnf:noninjectable|Open|Irradiated|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ba71d261-a2e9-40b1-af6f-28620bb2530c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d485335-b2e0-4e4a-b9b6-28770fe8e8c3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='82b617f4-a373-4215-b130-2885961c6a3f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ad76fe7a-dc1a-4f6c-ae19-288dce3d8415'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-65C|4 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee1d712f-098c-4b16-b553-28a60ee0c590'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='989850f1-1e80-4dda-962d-28bf10991765'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 5C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8543802e-caae-4a41-9b8d-28d96fafd43d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-25C|Cryo reduced|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9f0f123-9746-4965-8eb2-28e3137198eb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5a7b299-7f67-4b36-a8df-28e4c45b4d18'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='de598dca-0edd-49a6-a163-28ee8fcf683a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Gly40% OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4cb4b85a-ca56-480a-a3bf-28f3f566f167'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='090ed9d4-e663-4638-9791-290508537bcc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 1C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8925ada6-c7c6-4c7d-9259-291b7013a305'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b0b03ee0-c1e3-4904-8650-29263236cfb3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a1ad8e8-3c4c-44e8-90ec-2931db83eda5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa6453a8-2f88-48d4-9efd-2933ca146dc4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7976eff8-5a98-46bc-914e-2966bcf77146'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d1a18e9-93c0-4082-8cef-296babfa78d3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='de6d13d9-99a5-4060-8802-2994d3d1a57d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73ea7f01-64ab-4354-864c-2994f5af7bac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f5088ed-7595-483a-a27f-29b0ccfccf2f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR SUPRed 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4adaccd2-0afd-4327-8f72-29c0a8af068b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7cde7143-e43e-4fac-bee5-29c31dbc6fb9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='87ec523a-36e6-45b2-89aa-29d55fbec94c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5dbbbf65-129f-41ea-94af-29dc8071c1cc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a2a885b-e4bf-4526-b0a1-29ec9750aeb0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bc1f997f-2d84-48f5-ab89-29fa11de1d14'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 NMT OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4392141-10e6-4b7f-8c38-2a039d57f2dd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3145c516-4179-49cc-ab75-2a1997df2d98'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='668b3674-ca6a-4b18-8428-2a3a41352bd7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-30C|For mnf:injectable|ResLeu:<1E6|Frozen >24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d5cf0f0f-a8d5-42d1-9479-2a55e8160d42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1d9124aa-356d-4b15-99d2-2a6358f8fbb9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej Gly40% OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27686e22-4c8f-44e3-aa5a-2a6e53cd2c6c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0d1f5f4-2f19-4446-9b83-2a8430a67452'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cea4f3b9-3625-4ffb-9fb9-2a9ff2d0273e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4cc35711-60f7-47d3-9163-2aa936174414'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e8e3740b-4844-4523-85a8-2aaa226e9cc4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c96fc002-1e65-4473-bc66-2aac5b5a6b31'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a4beb15-cbf2-4765-a041-2aba89a4edcc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a391ff2-26e2-4dd4-8a81-2aeb79648c1e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='400c3f4e-21cb-47ab-bddf-2affc2077ff5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|ResLeu:<1E6|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95b159a0-9d49-427f-8a17-2b1174573d8f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1a00309c-10ae-40ab-806e-2b2fab7a2ddd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR NS MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='815f3cd1-15de-4bb2-b06a-2b3073dfb590'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='84fc85ef-d906-4be8-9157-2b43f3b844d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D MNFI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='784a6ea8-670c-440a-965a-2b47f82094d4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8a1983a1-c2d9-48b2-8692-2b485f9795fc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a87f75a1-1366-4d15-915e-2b4fc2bb0540'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf84ecb2-79ba-44e6-b895-2b6f7c2e05eb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e2cf9c50-ef2b-4308-864a-2b7558bae135'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR SAGM LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cbf1046e-759d-4a67-80d8-2b8cc51f72f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 4C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c6e7bdc-b9cd-4825-99ea-2b8ef671ee54'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='402e54d6-d110-408a-b84c-2b9834e11012'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f7f276b-65a6-4614-ac13-2bac4c8ea5f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 1C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='839bc668-fd11-4215-889a-2bbf18880c30'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c1bc5d7-47f6-49fa-ba26-2bea941b99bf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b869f4c-d6cd-41db-b5b9-2bf17c513931'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b4d51ddd-5b59-4ac2-867a-2bf3062be7d7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d0cf4f28-9706-4873-82a6-2bfea625b179'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='efd46370-003b-4714-b5d6-2c12c3f95e41'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ba5b51e4-83ed-4969-98b4-2c458a28ccdf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a153a819-42d8-4259-95b8-2c4c5cc825a3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='232c85cc-e8d2-4e1c-a46d-2c675c1bde29'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ff788458-2c05-4835-a3bd-2c8c86c84c9b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b40ee16d-1534-4123-8685-2c9cd56a2029'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='72069650-b54f-40b8-9e13-2cb8ffc0ec37'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='053ab39f-bacb-4f9c-8f54-2cc3cf28d249'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c897d35b-37d1-40b0-b24f-2cc5a561e007'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5bb2c461-6b3a-4d41-9744-2cd81963c9cc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a92c41b4-3622-42fd-95a0-2ce010d99dc9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='98c5b914-6c23-4c51-b6bd-2ce47a9866bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='35e749ef-c166-4764-936a-2cefaabafc0e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='02e1b106-c5c3-4fbc-8e56-2d1db5fb052b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR SAGM IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='74929a18-0ab9-48c6-9061-2d33d592c887'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|0.5 CPD/XX/<=-25C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='efb1851a-b217-4218-91b7-2d41020679f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq CPD-50 MNFI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f2f5f965-db86-4d3c-886e-2d5511e7f230'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f1e330d-45e2-4a0c-b26d-2d68a5ea9cde'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='00025457-b774-4406-991b-2d6d4175abff'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='94d0f304-ef26-409b-a54d-2d8eb001f112'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd2a2048-1ced-4f0c-b739-2d94db9e33af'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b3038be-b72e-4878-9610-2d99572253c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65700213-b47f-498e-ba7c-2dcc89a9a87a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='099208a6-e354-40c1-a33e-2ddeaacc8bf0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b3823c25-de16-4bb6-900a-2de48074fe3c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None LUKOPR SR/Q-PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='44c77176-2040-4e54-8e13-2dfc65f68a6b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fce16035-52f7-48cd-a5d9-2e0d787c2b2f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='31d9aac7-9886-4997-b2e9-2e1c21820181'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 5C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27cebb76-5306-4d31-878e-2e2e62dcdddd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f91d8091-ac78-4fe6-8dfb-2e3098f196a8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFI OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ecb87a2-81bf-4027-a126-2e3333898f2c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='633ff56f-9896-46aa-ab60-2e4382d5d29a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='643363f1-b807-4ebd-84f1-2e44d3601c78'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CPD-50 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e1e7d56-cf86-4aca-bab0-2e51765530ae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c19c84c0-ab1c-4a5e-a8ad-2e54993546a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5cfc332-71a5-4694-93c4-2e59a8764859'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|<200 mL|Frozen <=18h|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='802abcde-a771-498b-979e-2e627ea4e412'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/350mL/<=-30C|Cryo reduced', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa526de5-c6c8-4ed2-9302-2e65f5dd6a35'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f2b6684-060c-4ab3-b36e-2e6e9b0be71f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c26a686-b0ad-4050-8aa5-2e78a442ab84'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd6df627-a8b8-40b1-83b1-2e8bc9f6bf52'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1dbff09-24c2-416b-9c6c-2e990516e295'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9eb54dd-8782-4f55-9d6c-2e9c92e6184d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR SUPRed 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c1cefe64-2957-46c7-acf4-2eaf1bf9a37c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c153172-9fe6-4942-b1fb-2eb0a3b9b11b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b440f923-9249-4643-9645-2eb30f7bb1e6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 1C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ddd5e534-b7fc-473a-ba7e-2ee0a98a7ed4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CP2D/XX/<=-25C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4cc075d7-144b-42c7-9bc1-2ee17cd3e0f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4041e48-6cba-4f60-a3ed-2ee3d24bbb5e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e85b44a4-6138-4b51-a54d-2eea0846c26b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb976418-7086-48e2-8bd3-2eeded6da71e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|>=600mL|Frozen >24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='33514860-9391-4cbe-88d9-2efc51dadadd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f759a180-196f-42e3-97de-2f12120d67d7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ded26ad1-ce93-4214-bf3c-2f67311784c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 8C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b94fce78-4412-47f7-8e1d-2f73d22f1bd7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9cddd0b8-64a4-450e-9ee0-2f77e29361e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b62d36f-c1c1-4513-b543-2f8488bb38dd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='18155b78-1915-40af-9e44-2f854e3fe8c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a254b3c-12ed-4fdb-b7c9-2f96711c71ab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b7812da-5a33-4eca-bc3f-2fa5b48c77f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ec8222b3-8a7e-49f4-9efa-2fd934fadf58'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05a2e856-49c3-4a7e-b608-3018192f5637'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f4cd1aac-413c-4642-81de-3041ef6d6fd5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6f6aab91-a4b4-468d-9707-305102d2b938'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN PA 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ad8206d2-1557-47fc-a117-305456a82453'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR SAGM 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3513e8ee-e3a4-4da7-9731-30563b5c2b49'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12113fe1-c24e-4898-97d7-305d146f3bf9'
		UPDATE [dbo].[BloodProduct] SET [RetireDate]='2015-03-06 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1daaca7-949c-42b0-bd21-306358a14c83'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3853f39f-e853-4a3f-8adf-307b3e28c15b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e98084a0-94e6-4e02-bf3c-308290acdd06'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8dd7c506-30e9-435f-a36c-3096691e3234'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis PLASMA|NaCitrate/XX/<=-25C|For mnf:noninjectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='239ab05f-4cb5-4d47-ae20-30a30fe8e40e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD LUKOPR SUPRed 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f19f5741-3a25-46a6-a2bf-30b807c7e68b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05699460-f532-4365-a4ce-30d24a9c2a33'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81d0365d-311e-4c89-8884-30d2964968f7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d8699587-ce47-46e0-a105-30df290c54ef'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|>=600mL|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1ad51a8c-3f7a-4736-9137-30f7f0a713c2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='074a6f21-d200-441b-9447-30fe4c34a6d0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a919a9a-757e-41fa-b80c-3111bafc9bae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4688ff8b-1b2f-4082-8210-311d2a577e42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD QUAR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3bbb03fd-4621-4bbf-ba1c-312836d74025'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='76d53eb9-2f08-434e-8b79-31363dc7e63a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a3b28ad-e14c-4c2b-804b-314576380035'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='188042c1-614d-4778-9e34-314b004873f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55ab314b-bf60-4ed8-98d0-3160ff0a08c2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f1d03c5a-e822-4310-8a7f-317e193aa893'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3006fd1e-bc91-40a8-b043-31a5fe4afb25'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c02b117-d6a5-4853-850b-31b9328d5578'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2468908f-c722-4b75-b85a-31bd6eaffb21'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a78c6048-3113-4d75-af2a-31bd7a4f2235'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 IRD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4929c9d-7d34-47fa-91a3-31cd692bd497'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd729a45-180b-4a61-b885-31e2ed25e837'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2cec4c9c-40f4-4857-a4f7-31e351819424'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='471c351d-e99e-42e1-8e42-31e9f1954020'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fc4325e5-4eb7-444a-a9d2-31f059d645d4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='58327b27-c617-4c39-abdc-321ef4e7c192'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='58f27cdf-79f2-4b46-8af9-323a93f7e1db'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Quar:>=90d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a3200832-ebf1-40a5-af74-323d23891a47'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed37cba0-413a-42ab-8207-324d68ea0ff0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 3C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e39e3689-4b45-486c-b2bc-3250417f8df9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='64309538-9c98-4076-a750-325ccb819d8f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3893896f-3b65-4898-bb20-325d9e47c705'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d9897056-f304-4187-b8f3-327d3bacaaf5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='532b6051-5209-491f-b148-3287802eeb27'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|For mnf:injectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65ad374e-35b6-4084-b220-328dec1e3855'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85e78989-7aff-434b-a570-32ad1af5b507'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d6c76dec-db8c-49e0-baa6-32b8af502d0b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='32607a74-0802-4baa-a521-32da91723a17'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d902379-4d73-43a4-8f8f-32e1467b73e4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Irradiated|1st container', [ProductShortName]='FFP CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f62d001c-b104-4c12-9f97-32f0b7af7305'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B MNFI LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1b15c401-5fa1-4656-a392-32f1e5241dc0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e2a31a85-bab0-4c09-819e-32fd44ed829f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|Irradiated|1st container', [ProductShortName]='FFP AFR CPD-50 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da6c6863-7ec3-4ff2-9488-3308bfc1aa28'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ffc7b22-a88d-47c8-bdac-331bada066a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFI 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='df95e759-e309-4098-94a6-33200a1b5ce1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='734ac4ad-d4e9-4ae2-b44c-332c44715504'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9ee0693-a6e9-4438-a0a0-333295b0d4e3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c794893f-0af6-47e1-914a-33335a18cc38'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|For mnf:noninjectable', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd5ac2f2-5a9f-446e-a293-3378255920f5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/XX/<=-65C|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2b8fb83-0621-4b5b-b91c-338ff12ef620'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>SAGM OPN IRD LUKOPR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a01ded1-5e3a-4352-96eb-3397e7c0140e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 MNFI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f93db734-8d0c-4a49-a30b-339a3f60e507'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='94180fbf-6a1c-4d54-9bbb-33a04a1e3c1d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7bf6b1f-2695-4566-8507-33aadfed34c6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14182210-e040-4817-b534-33bdef54044b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='71bd90a3-b315-4adf-b404-33ea58a61e58'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A MNFI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a81cd35-0cf4-49cb-956d-33f9ff57dafc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b291dbf6-17cc-4ebf-8679-346171be1a00'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<5E6|50mL|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a5467b61-30df-41e6-a1cd-346c476b506c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='221992b7-b643-4610-bb69-34791b15955f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 OPN SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='abed5ddb-54b7-46d7-95b9-347bc02749f6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1effcfb4-672a-4472-b7a4-34963d0682f4'
		UPDATE [dbo].[BloodProduct] SET [ProductTypeCode]='E011', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5a6a85e-8eea-43ce-acad-34abfd075bc4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='92c66188-2321-4fea-b1fd-34b56ef1d11c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='812191ce-5a47-45c9-8f13-34d9a560e668'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 8C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a127d38f-0cf7-4af6-af60-34e612b8a9c5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|ResLeu:<1E6|Frozen <=18h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6ce99d06-01c4-4a03-9f34-34fc165136f6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='68a9e0d6-bba9-4438-ba7d-350e3c9c3a74'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7df7be99-192f-432f-a7b1-351507a36215'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5ac8e83-f8ba-4880-89c4-3543186f4245'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/350mL/<=-30C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d306d78f-1475-4e07-9093-354ecbb6d77b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27cdfe6c-b17e-416f-a23e-354f0d2f9cbc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq CPD-50 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='876492fa-fb7d-4359-b599-35503c96f6f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 3C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='98e06cc5-c90d-4a01-b47a-355080fec083'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6579be85-769d-49a8-b1d3-35621590e49c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60ea3e4a-f025-40eb-b503-3562bddaa691'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|1st container', [ProductShortName]='RBC AFR Froz None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='376fd520-d8b4-48ab-b06a-3568870b3426'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c07f7db5-38c0-4b9b-bb52-356eaa398dd5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/450mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3737b0f3-7eb0-495d-b65b-35a2578f6e42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c0ed1c55-4b01-4ae5-ab80-35d3b837c224'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='901bf8a6-2656-4967-8bcb-35d99d46fec5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CP2D 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55f83253-87e0-4fb4-bcb4-35f4b6b58b13'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR SAL Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da7a90df-a3e1-40b7-a7c2-36077b50a7ed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa68a4a9-5af6-49bc-9dc6-360daaec3ec4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6969a673-af0a-4953-8ef7-360eecf0c452'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|Frozen <=6h|3rd container', [ProductShortName]='FFP AFR Nacit LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='51e7fda4-878d-404b-83af-3651edbf82a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3443021d-5e14-4a9a-8d2b-365458b4d0bc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7499836-3bec-4bb1-8654-3654c381375d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e0ddff0-1d63-4e26-bc46-367b70fb2d54'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ce4afcb-09b6-457c-a32f-368027f66553'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8006be6a-116b-4d63-bc65-369e6d847a12'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-65C|ResLeu:<1E6|3 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f360cf6-1edf-43be-9ce9-36a8f1558446'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='702c1a56-50d8-450b-a4fb-36bc0165361a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A MNFI OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f749f046-9d66-44c0-a5d5-36db5e4b9c2a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='02b43809-342a-430c-b205-36e82f5894fc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|For mnf:noninjectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0619624b-4949-4543-84c3-36ef9c39f442'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 8C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4046c32-19fb-4281-8a46-36f3c1a8d877'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1bedcb65-35f2-478a-9624-36f55334d30d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f960b81-bbda-4c96-9eb4-3701a0e368d8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80097c83-a6f0-4570-94e0-370f1eebf4a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea00554d-5abe-4fad-86a0-37405c6e9fa0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37abf122-48f3-4255-996b-375d840ba76e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg AS3 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f408f1e-12b1-4671-b723-376d109b8e3e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a09c53f4-8931-4aae-9bc0-378644e56612'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='24c27fb1-ca9d-45a7-99c4-37992930659c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|1st container', [ProductShortName]='RBC AFR Froz Rej None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d68c9b28-54a1-459d-b991-37b87a107b80'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bc36b1ee-eb0e-4e45-a38f-37dbef456c8c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22f3f0de-c36b-4370-8246-37eca9317204'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f85f4bcd-8101-488d-83f7-37f4c38b8728'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80209022-7db1-40b0-b978-38068e2f1cc3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e84504f9-7bff-4ecc-844a-381fc65d8ef2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa6a1056-c43c-4a29-9cc1-383df4ac2943'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|3rd container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='87bcc3ae-c6db-45df-86c8-383f4bbc6f43'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='39b83afd-d25e-4423-81b5-38447dc756e0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e79b399-4a78-45b5-8a2a-384486e1bad6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='53e0b737-f03d-4b9c-964d-38467057b569'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|2nd container', [ProductShortName]='RBC AFR Froz Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a158c129-3bc9-487e-a9db-3851ad79d026'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2ad79c06-33f8-4e32-bfe4-385c5206c3c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='35584f92-98eb-43ad-90fe-38606673b08a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2039ca59-7d53-4990-a1fa-386107017f19'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8fb04e98-71ff-41bd-80aa-387781fd97cf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:injectable|Frozen <=18h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f0c0700-66e4-4298-9d90-38787f036cba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f42decf2-9383-4d8a-a0ab-388026f1bfdd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eb6e3375-2803-4434-bccb-388e6240e7ce'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C|LowVol:anticoag adj', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6344c15b-bec6-4e9e-8ddb-38928f051779'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a49125d6-89af-4a05-a37a-3896bc37ab6d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ea94c73-f4ad-48a6-9788-38975c633f8e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b4511ac-c494-491d-8688-38a1ed9bec42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c0cfc91a-2fcf-4e9c-a57f-38a420794efd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='40be83d5-64cd-40ed-a577-38a6070985ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='94f01caf-e72d-4055-81a8-38a6cdba2db5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a928198-280b-42c4-9bb5-38a7ca4dca54'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9fb4519a-11e9-4909-a138-38c275ab658d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eb0cec9b-4e6c-4699-a9ca-3900f5a7385a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA Thaw None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85d5b31e-3a96-4cd1-87d9-3903532e31d3'
		UPDATE [dbo].[BloodProduct] SET [ProductTypeCode]='E011', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4fdd1d70-8b25-40ec-b3f9-39067b0d738b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1309465-9c52-41d8-8633-392f8cd7bfd1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-E LUKOPR 3C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d44320d8-b56a-410f-9bf8-3942ddb4e0f3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='44516a3c-6f0b-449a-be0b-394eca59f154'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65cf916c-7736-4de3-9963-3952c9145d21'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4c5b75c-b5ac-4829-b4ef-3961197fbd73'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4797b761-093f-4967-a261-39945fbb5e99'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='79ec1ad3-fcfa-47c6-bb41-39bdc4b8ba36'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3650dda4-7299-4119-836a-3a01ba3bb1bc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C|For mnf:injectable|ResLeu:<1E6|1st container', [ProductShortName]='FFP AFR CPD-50 MNFI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0582378-9609-4fce-91d9-3a11ce36c047'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59f1dc78-70f4-4c00-a217-3a169f9289c1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CP2D/XX/<=-65C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4d564687-07ba-4d03-bdb4-3a38a2800f4f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|3rd container', [ProductShortName]='FFP AFR ACD-A LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7ff85969-fcb5-4c49-b140-3a550b6ea878'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c8b5196-44dd-48e0-9c6f-3a617623ad11'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1180fc0b-de14-4995-bea7-3a6287c2a673'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6f9757f6-71e2-479c-9bc2-3a815f50de46'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80f172e7-b701-4488-abe6-3a820444fd21'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6b7c04c3-3300-43f6-a058-3a864002a483'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN LUKOPR SAL Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cee8fe79-8f45-48c5-8e46-3a9911cf0154'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFI 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2cb4ec8b-55bb-47e4-9c3e-3ab122f48da1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash AS3 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='58b18945-ca38-4735-b779-3ab75069a9f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e9efd52-315a-47ab-af64-3abd91436f0a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73277db4-f25d-46c4-be59-3acbc4d13114'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9947ba4-2f94-4ddb-a1d9-3acd0442912a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='51e4d226-b61a-4208-9c9b-3ad6eb896e31'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3624fb9d-38ca-4c94-a887-3adcf6bb6fc7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d1e5405-455a-4110-93b1-3af4d9942e00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6ef0c858-3f32-4559-ac65-3af924cefcba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65f2df5a-4b4a-454a-9288-3b03cbf75120'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='119e6af5-79ca-477f-b5d3-3b03f6e240c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fe813de3-92e6-4788-8ede-3b06f34bd665'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9dcb6239-56ed-4991-b305-3b25394ef3e4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b3e99835-0794-4883-b6a4-3b398f950a38'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|7 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='627eaf10-0051-45df-9d92-3b45efd4d424'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFI 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5e042425-e6dd-4a29-9701-3b48d8e00d9c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99481d45-b322-4243-b37c-3b4dd4a1f415'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|1st container', [ProductShortName]='RBC AFR Froz Rej None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bcfee2a8-d6fc-4af8-aae7-3b6aebb7d138'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='676bd975-8daf-4270-ab8b-3b727e5283d4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80eacf91-09cf-4d34-b9ac-3b79b0e33db3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Not for tx or mnf|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c8a5fea1-01cc-4d26-badc-3b7e1eb1c930'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1f83bd9-914e-4845-a6af-3b80aecc7c68'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3ba843a-6d76-4735-85aa-3bae8b2f2907'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='CRYOPRECIPITATE|NS/450mL/<=-30C|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e638202-2465-425c-9c20-3bfd02c48e18'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='90828614-4894-46d3-947e-3c144de55cfb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6762bdbe-32fe-4abe-9625-3c15492c0bd3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a6cf86a-cfb4-439b-8090-3c215f38160e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a6adc422-5717-4268-a2de-3c2783af9ec6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='30f00efa-f6e1-49af-83cd-3c35c27c0a21'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ffcdfbbe-fba4-4d8a-bfda-3c396e3c51f1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15a4574d-3bcf-496c-973c-3c4934633429'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3e77f6c-a2fb-4514-96ac-3c540bf187b5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='21ead686-5175-4ec5-8471-3c6152e74359'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='535ea2b7-a84b-40c6-8c03-3c62a1ccb8e1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='308c362f-5a7d-413c-8824-3c6516b21a09'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e217514-a122-4791-b056-3c8561fd53ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b10355e-bddb-46f4-aa94-3c872cc4eb9d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7558344-c2b5-408b-8dab-3cc5f6df1bd9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7701ee6d-9f57-4d7a-aef9-3ce10e3ff3a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-D LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01275c47-d35f-4869-9b6a-3d00f2c5336c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='16d5ca2e-560d-4599-9e12-3d47cc9f020b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN PA 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aeb5a5ae-d3b4-4d17-99d7-3d5da63af007'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14ef23eb-7dc7-40b7-b694-3d5e3988bb6a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f447f73e-0e12-44b9-9ca8-3d64991745d1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='41357784-4be4-4f79-b4d7-3d8528f23c0b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ad67c83c-2daf-4a7c-b462-3daee3e80b81'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='39fe817f-8771-4b90-b95f-3db5af0de720'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2b44050-2498-4923-aed2-3dd47608a82c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5c589eb-9986-4809-b60e-3dd4a3dd7a62'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='29b31f36-86fd-4e6c-94d9-3ddd376c3925'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca893d44-283e-430d-b329-3de7421ef43e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a989cf90-d5c9-4ef8-9efc-3dea602c25f6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/500mL/<=-65C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='47dd012f-bc33-48d5-a39f-3e17c40ee4ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='475694f1-c0a6-475d-9801-3e2e4473b362'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Irradiated|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='454a2c12-0ea7-48a9-baf2-3e3987d7215c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPDA-1/450mL/<=-25C|Cryo reduced|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a554650-6897-44eb-bf40-3e490bb42e1f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0566d76f-c15d-4124-9478-3e54fac96505'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd337ae6-2e19-4bc4-adf7-3e5a696d6fa2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 3C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b200a0b5-ecf9-429e-bee4-3e683556a2c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='af240236-b882-4f74-85eb-3e8225512d42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='099c4c6d-3ea2-45d8-8585-3e8b6f27c8dd'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/250mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4114f3af-b7d9-400e-ac88-3e976e2d223b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d371af48-b024-4ab8-b707-3e983e44100e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|3rd container|Quar:>=4m/retested', [ProductShortName]='FFP AFR NaCit IRD LUKOPR 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0494ec3f-f998-4af9-9d5b-3e9f7196a4fb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aec05ec1-3c02-40b8-8e7f-3ea34e674e2a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|2nd container|Quar:>=4m/retested', [ProductShortName]='FFP AFR NaCit IRD LUKOPR 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4edc3b4-b50d-4b91-a751-3ea504b1e1d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c723b4b8-4ced-4bc2-a94b-3ead9558836c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-80C|Open|Irradiated|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b508c13f-f765-4dfb-ac23-3eba77c475b4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a8930e67-c624-443f-a3a4-3ef961151433'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 5C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a20452f-3f5e-4706-853a-3efa470b0195'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a9965d2-d6e4-4e3b-b998-3f0a2f3d374c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a092c50f-481e-451e-ac52-3f1e0de9c4d8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55d25126-171e-4706-903d-3f239e168bae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='26f63576-8948-455d-a669-3f32f2a975b0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='90cfed04-dc75-492d-8a06-3f39b03d9897'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22b660bc-5621-4943-a2c7-3f55f4a2c1db'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c9e9858-fa7e-432a-a1c0-3f5e486e4dd1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD IRD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='89089aa7-6ab4-4ef9-bcd0-3f73b1ca5020'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf775131-5f45-4431-b15d-3f78e133f1d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0c16019a-7df4-444e-a446-3f8e79073c5e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='13f4bcca-2785-47b7-bca8-3f9997bbf369'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c18be1b-e163-4717-b0c7-3f9b9f71e200'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C LUKOPR Psoraln 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2fcdbffb-9ac9-4511-9dc4-3fa19de17280'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5d505fd-bd6e-4954-bd29-3fbbbd89b9d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b82239e-5cf1-434e-8771-3fc7331020e6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-65C|ResLeu:<1E6|Frozen <=6h|2nd container', [ProductShortName]='FFP AFR CPD-50 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='40815711-9857-4779-a88c-3fd1742ce619'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c861113a-4bea-4766-8758-3fe0ffe37eea'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9f4e53e-c8db-42d9-a31b-3fe18ed6ef69'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56676e1b-86af-4e6f-923b-4007013efea6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0d44ba24-d0b2-4625-be70-400b88b43ea0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8da539de-9861-44bd-82e3-401441f21deb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee5639af-c049-493f-bc22-401a4ce22f5d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ff9b0280-34a2-4323-be25-402597c5cbcf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a1cd263-cbe4-4e42-ab6d-4070725ffc9d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d064eaa-2702-4638-9ee1-4093d833a963'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Irradiated|2nd container', [ProductShortName]='FFP CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='42168024-9fac-4109-84de-40b78de2aca6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f06ce08-cdc1-4374-9091-40d132cd2d43'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='89344d67-b2cc-4647-858e-40d87aee0c2c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|Buffy coat plts prep|5 units|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='58564a7b-2aed-4c6e-b07b-40ee9a420e34'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1d3ca635-9027-4e86-8354-40eeecb1b01e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73d40617-28dd-48ab-82bd-40f836b26949'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12ed4920-33f5-436a-bcef-4103786f2f93'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5cdee97c-a8cd-49f3-956d-4112318948da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 8C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ab57e1f3-71c7-4b11-a085-41223576f344'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4368771-4ed2-45c6-a70a-412db16915f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e92873e9-0653-4f66-ab65-413ccb9eb864'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfe834db-94d8-41b3-bc32-413d1c2dfbf7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4fbdaa0f-0a9b-4c3a-9310-414586e76ea2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='687981c6-dd27-4b15-a392-414bcf7147ca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d8e8b2dd-3f4e-49db-bcfc-416152b99092'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4381a136-2e3c-43bf-9286-416643a2669f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|2nd container', [ProductShortName]='RBC AFR Froz Gly40% OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5af0b66a-37b5-4d49-854f-41688e04e9da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR PA 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c6b62b9-74aa-41cf-8050-417aacff1f4a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 3C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86d89593-cffa-48fe-b7ec-419685cd92e4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e4ccc9b-f6a1-4499-8346-41a491fbfda4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='52c9e9b3-c7ff-4dae-8806-41a9e72d69d6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d0d3642-ae4c-476d-a011-41ab9e8aa15e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='29fb9742-fad6-4cfe-89fc-41b05fb29cc9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1228deac-1d8d-415a-8071-41b475cf85e0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0998ecbf-4377-47b3-9d95-41f88c8c9857'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a871981f-b8ce-493d-9ec1-420519fe76d6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 2C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='33887d84-87f3-4544-b689-420c768b3ac7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a327fc59-3ccf-4d1e-b7e4-42457b525c83'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='29f459f6-7595-4a65-99df-424ec368c5bc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1b0c76b0-1ecd-4028-891b-4257f7d535ee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f07b2e7-a570-4a5b-a8ac-425e5686cf0e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56001b6a-8575-4f59-a046-42652668db88'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD QUAR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='98b5f42b-f98a-45d4-b183-427ea0b7c12a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='768d2f2b-9ada-466f-820c-42b78c6dbe9a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|2nd container|Methylene blue-treated', [ProductShortName]='FFP AFR ACD-A LUKOPR 2C Methyl Blue', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4200bcd4-b423-407c-adc2-42c10e00ff73'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='528f22f7-995d-454e-ba60-42d842581278'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='098f3ca1-ae7c-44b6-bacd-430245cb5a0d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5b3eb920-51f7-452d-92ba-43242c9eb29d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e588d2b-9564-44a8-9aea-4338600f4040'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFI 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c8c07f8b-f0ba-48ea-8114-435f6cc8198c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ef2669d0-c750-41c2-b94c-43752d015930'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50b4a9d6-2394-4a05-b4ef-438e6e8188dc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-65C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e08530a-b0b9-4a30-aed0-438f19dea067'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 5C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a5595b64-424b-486e-996e-43959707730e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1802bff1-fd0c-4f86-897d-4398ce122967'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='651b3d10-1c32-4e2a-80c0-43b7b95a4461'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='559657e3-155e-4d50-91aa-43c4013aea74'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 3C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='91305cd2-6405-490a-a6ad-43c999a7ad36'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='afc5c91e-a2ac-4fb1-b22e-43ccc9bad9f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='00d18738-e62a-41e1-bc8c-43ce65228d27'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f424f0c2-91d3-4824-a395-43f80e163ee0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej Gly40% OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7e9e5810-bd18-4107-9ad4-4407798ce144'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd5ca20a-9614-4627-9fca-440f2111701b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|>=200mL<400mL|Quar:>=90d/retested', [ProductShortName]='FFP AFR ACD-A QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='033089c7-6c43-4c2f-8328-440f8211d553'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='333db3e9-da5c-4cf7-87d9-4423cb025609'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='19dba38c-ca46-422e-831e-4435d673cef0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e863898-8261-458a-abb0-446f2d0a778e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f52a5c4-3f22-46c7-a691-44704de5fe25'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 4C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d38a0e08-3dcc-4754-85e3-44a5b16ec011'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4fd3ddea-423c-4049-af92-44b68f437d1e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR None OPN PLS Red/ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc455325-5e83-4a15-8a01-44be36502659'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc204cad-a8ce-452f-ae7d-44be5a6bf308'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f605215-6e53-4220-9bed-44ca12c8786d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='30483d1d-ca14-4b1c-818f-44e52cb68ca6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8a4b67ab-305b-4c26-99f3-44ebd5454b7a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|2nd container:not auto', [ProductShortName]='PLT AFR Froz DMSO OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='219dec6d-af3a-4dee-9005-44f83d8f2c55'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/250mL/<=-65C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bd7abfc5-b04f-4ab8-bbad-4507291efff0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-120C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c7dbfe8-0bf0-42de-80b5-450a80119403'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ace6249-ffc3-41d0-8d57-4516108ac63c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a3b3ba02-f062-42f9-812d-4533bb001b1d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ef2c8a47-c2c0-4afc-a727-4542219bad7a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e8ba18f-2de6-48c3-b40f-4560b78e18f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea82acca-d317-416f-9630-4560dc2c97b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dbac4afa-4a2c-4651-9960-458be8fbd870'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22577100-dd39-46b8-9360-458eb3a5a522'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|1st container', [ProductShortName]='FFP CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8934fca7-d496-4a73-81ae-45a37bcf4d0f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e86b5e27-60c5-4510-aea5-45a4e1840374'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='631fd0db-446a-47bf-b798-45a5aa886861'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9b0df40-6604-4a5d-b8b1-45b6ac2f13b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22a35c3b-8f9c-4128-a62a-45b9b1f0f971'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='567aee49-b127-4e2e-a635-45c545c09daa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c6b04034-83bb-441d-9f43-45d159cad760'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f257943-f5e8-414c-be7e-45d68a4ef467'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|Irradiated|2nd container', [ProductShortName]='FFP AFR CPD-50 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5abdcbe8-6ed9-4e3a-8e03-45da32b3c209'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8966b90b-896c-4de5-9048-45e318e0f449'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c4300cd-4d95-4cff-9f92-45e8a8e18193'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d70a26dc-9bab-4eaa-9ce3-45e91874f6e8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4447bb8d-cd4d-496e-9517-45eafa057b81'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e93dc7e6-8893-4c0d-bcce-45ebaa4a39b8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ef1faa87-bcbd-48ba-aef9-460a7457f577'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a0db2dd-7db3-4e7c-a540-46159ebee986'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='595449af-1eda-4a4e-baac-462275895e57'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='44bdba38-7c5f-4149-a74d-462b6a17ce2c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aacc0032-49e7-4f2c-8149-463ad13db0ff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ae25063-4df1-4090-8c09-46a82e5cc3b8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|2nd container', [ProductShortName]='FFP CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eb8933a3-3203-4f7c-927f-46b0d6155744'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4a497c6c-7b8a-4870-9aec-46c21c9dc8f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFI 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a36672e0-c889-4bd8-bb55-46c83403dfb7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|For mnf:injectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d3fdf65-dc05-40cd-b181-46d206ca23b0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9580c60d-07a3-450b-9b72-46d8131a8e01'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ccd9696-459f-4da9-8204-470c36f03baa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b4f840a-783a-448f-ab7d-471868933f69'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01bab951-a1a7-4e24-bec5-472f20c2b658'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|4th container', [ProductShortName]='FFP AFR ACD-A IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='013a3968-1f41-44fc-aebf-4741620a1800'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR SAL Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73169bcd-c234-45bc-8876-474b016cddc8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc7f6ff7-8503-4d15-9748-474cc2ea7917'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6b0c9c2e-7e64-46d0-a926-4762a459d9ac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='451f2e23-c5d1-4d56-8199-476c7d502442'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='30fec2ef-298c-426c-b086-47a47d7f9d74'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:injectable|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e06aa26-279d-47df-9c88-47a596b3e6ef'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a5a4772e-f585-4d15-96e0-47b6dea59eee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4dad94c-003e-431d-9408-47f6d8d552d7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56c77213-da62-4beb-b149-47f985df6978'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9823b601-4b21-45d1-9778-480252d64a6f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='71b18a30-8dcc-4a39-8012-48116c92853a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 7C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0123cfab-7ef7-4729-a829-4849b3eef536'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3433f54a-ed90-4839-b348-48738d523ddf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/450mL/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e1c6dd8-4963-4a56-af48-488c9c19634e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='35b1bfb0-cce1-4bd4-9ea0-4PORTd2251d6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3c6cc9d2-6b11-4bd9-8dae-48a6a06c309b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ec0bba6b-ffb2-4dcb-8bc0-48c77b22b9f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7263993c-12c0-4897-9785-48cd370a0afb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3bbbb83e-c615-4d4f-aa7f-48deffb17ea2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='38b05d78-f314-4069-ac50-48e03de149eb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b05793ce-5130-43e2-a7d0-48e8b1060473'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f8bf5f2-fabb-4763-afdf-48f4354ef79b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d42eeb5c-429b-47af-bc4a-49184db1ec0c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50a9b49c-696b-42f0-a93d-4934f3f3d0a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 7C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='96cd6307-170d-4615-a73d-493b72e640c8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75f9e739-a716-4237-99f2-4957c67ee3d2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c6469d4c-1bb5-42b2-86ef-4959cb7b3055'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bbd3c27a-a9dd-45a1-916f-495d645904d8'
		UPDATE [dbo].[BloodProduct] SET [RetireDate]='2015-03-06 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3c1e0a5f-67e5-412f-8a8b-4976421276b4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='600b8bca-e53e-440d-94ac-497b90c980f6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|Irradiated|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3fb2121b-7d19-484e-9521-49b50bf0739a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dcf58410-822a-4be6-bd8c-49b5dc1ad9bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2642c0eb-36e4-41f8-955b-49d28242f718'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0d8981a9-0893-4983-8c9b-49dc91fbe3f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2c709e7e-eef8-4bc3-a5a4-49e05243494d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None LUKOPR SR/SD-PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6992f23f-15aa-47ad-82a2-49e5c550644b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a2d3b25-c84a-41a6-8cb8-49fc317325a9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5cbf8d3-45ae-42c1-b0f8-4a2e4b8ed7d3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='07c10503-31da-4494-9e37-4a3c9e74d0c1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0d5155b0-16b4-42c7-b5f8-4a441caf85a7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4bb9cbe1-9ed6-4663-839e-4a48868b11dd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0440d659-5057-450b-b710-4a8101dc8744'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4800f16d-cdd9-449b-991b-4a814b2ab80a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7c7f030-1f70-4c2e-9f28-4a83e43dce72'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1b51d733-3dcc-40b4-9f95-4a9490d3900d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e8f620c8-d342-4ce1-99c4-4a99521e3c8e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a40de53f-aa71-4beb-ae4c-4a9b8cf93e66'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95553ca8-199b-4ec4-be55-4aa041c1c37f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd5e1fa1-fac5-4758-8a8a-4ac64be10b00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='276296ba-5ee0-47b2-bb11-4acb49d7886d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='25003ee1-c780-4ae7-aeb7-4ae65f8a90c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='200ee710-5f9f-4518-8205-4af242bf7942'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None IRD LUKOPR SR/Q-PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09939d2d-a001-4a28-bd89-4b10fae69c5e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09de9a0b-15c9-4d07-9382-4b1c111a1899'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='29ff6223-b9ce-4ab9-87ad-4b47433049e7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bac81905-64d6-451a-9d67-4b4be852ae16'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='903dab46-afb5-451f-8b7d-4b560f468964'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a0ecd80-44a5-4963-8972-4b58763f0271'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4414a97e-9cde-47b3-8943-4b868fdb66cb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b1b26dc-d9da-4aaa-a1ab-4b8ab9d35045'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9103e352-36d2-4caa-b7f1-4b929cbec640'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f06ffee9-63ad-49dd-8227-4b947065ac8a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw 0.5 CPD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7171257f-73e3-4ba0-be24-4ba8326f743e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce2c9418-a1fb-4143-92d3-4bab4e3dc053'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d2ab03e9-9382-46e4-95e2-4bc7fff6de1c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 4C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='08eec6e3-19d2-4593-a5d9-4bcc090c7c23'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open|1st container', [ProductShortName]='PLT AFR Froz DMSO NMT OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='52525e96-50bc-43c8-a859-4bd369f3f539'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3b4e319a-a425-4bae-aac4-4be11b90bfe5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly35%/450mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37f4fc8c-e8ec-423c-afed-4be1bf21baa9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f654bdb-86ae-4095-a271-4be24a24717e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8046f1b2-a63f-498a-8d8e-4be2661488f1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Not for tx or mnf|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c3c495cf-39ad-46d7-a9de-4bf33d8ac657'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b9d7f364-2b34-4af1-8323-4bf9053d9e17'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cdac81da-cd77-4e13-8c47-4c03ab1a12ad'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46bc01c6-5c9e-4cb2-b90b-4c1ff5eda4ed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFNI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5fcacfcb-a402-4f1e-9654-4c2e58b1b7c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e7f3d70-e68e-4fa9-aa39-4c31917ad06c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|2nd container|Methylene blue-treated', [ProductShortName]='FFP AFR NaCit LUKOPR 2C Methyl Blue', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c5c2323-7902-4c0f-b754-4c56438f952c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='721994bb-b45c-453e-b1a5-4c629e7c522b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d2e24f66-9843-4dc4-ac3e-4c68490be7ff'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Not for tx or mnf|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05fc0037-d661-431b-bd21-4c72cc258e1b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6569ef20-0f5f-4307-adc1-4c961f380f84'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='882d7e24-953e-4f94-92c0-4c9e5f6b92d7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd70712c-74cd-4861-baf9-4ca24baed26d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-30C|Quar:>=4m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3b3158d5-d86e-4d27-be6f-4cb114ec56fe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e97ac05b-a29a-4aad-82f6-4cb483cc43f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR SUPRed 1C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56b9cef5-3969-4d5b-b39d-4cb81e7a8aab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee99607e-e6a1-4641-869a-4ce5941f4b79'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e9f28e68-d83d-486a-a5b8-4cec567aca46'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='08679382-4564-4f38-8d8f-4cef2d04d102'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='221868a8-2db3-4015-bcdb-4cf1492e8178'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a46f9607-2d8b-4093-ad88-4cf3eb4db398'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-65C|Irradiated|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='808c17c2-3ea4-47c7-8ab2-4cf97c11fbeb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a657d4e3-e94e-44ed-9096-4d1333c9ab4b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a593ef26-a8ca-40a0-8ee7-4d15fca4eb49'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b407d6a-1676-40ba-8907-4d1bfe6cfae5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e4d817a-3f51-4290-af0a-4d1ce7aeee48'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='945456f4-7b00-487f-bd27-4d4047828e90'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7d03e1bd-5b96-4e14-b712-4d78c71d499e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b8a4ef4e-0fa4-4e34-b067-4d83f150cac1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=400mL<600mL|Psoralen-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a2ff93f-4dd3-4720-8bd7-4dac819e0a53'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4569456-cb51-4895-b8e7-4dcbdfc3683e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C MNFI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f8afe733-e4c6-4384-a500-4dd073375da2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81587248-33b4-4bb5-a75a-4dd169ff54af'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a828d00c-ba77-419a-83c9-4dd718e93c59'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ca0eb53-30d4-46ee-873a-4de3876f19c8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|Irradiated|ResLeu:<1E6|1st container', [ProductShortName]='FFP AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dcb333de-070d-4aa6-a1b0-4deb544e6bd4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='68649281-2782-42c3-bad8-4df654aa945c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e526a010-f304-42e1-ba10-4e351ef22fd8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56f8cd53-8e52-49fc-a174-4e59019ceb26'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b07a7a0b-65c9-419a-a292-4e5b93d63c47'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='87b662c9-9616-4171-bac7-4e666357289c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='097605c5-d534-4014-80a5-4e6a1502c15c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5041684d-f5d8-4240-beb2-4e6cc4d78090'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a912ecf2-0c1d-429b-b038-4e71a095b720'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f00433b-f1f8-49ca-8038-4e7deeea7423'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be26d807-bbfe-409f-ada2-4e8193703170'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b713d38-7da8-4761-b975-4e81b47336f7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4d7c335-84f9-4099-b568-4e85a7824cf6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12d83109-60de-4782-a2d1-4ebb0c48974f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9964485f-e9f4-4768-9e61-4ebffb63a4d0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e530c1ec-d5b9-48f2-9c52-4ec566c85512'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='facd3c29-1a18-4790-8058-4ed5a073ad73'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='681f50d6-544e-4186-b223-4ee283ad7c34'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f2293ceb-c145-4612-8c45-4eea04ec29a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='afea7dee-48db-4733-8573-4efe2eb10e18'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8785eef7-41f2-4ad4-9d2f-4f0354702439'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2572749d-5aa5-4eb8-976a-4f10f2acc86c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C|For mnf:injectable', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c828fa0e-7991-44b0-84c8-4f17745989a9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='94f709f3-f00e-4a07-9f53-4f4d450f548c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR SAL Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='576d7374-3860-477f-8d1b-4f52835c7da6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c2538f8-8324-46c8-81ec-4f665853bd9e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd00aed0-53f5-4f3b-b5cb-4f7b1d358740'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27b2dbdb-088a-4d5e-8fe2-4f8ee5869875'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e95d487-3cb2-47b6-995b-4f8f2e6c7a67'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='47e36bc3-9988-4e70-b6b8-4fa5130298f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='baabe5a8-673d-455e-9a7a-4fc9196060e9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN IRD LUKOPR PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3d116aff-43ed-49a9-b483-4fccf853b652'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 1C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2ba9dbb5-4ba6-4bb5-b77e-4fcfca81de87'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='61cc0e12-e56e-440b-b242-4fdb93fadc87'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ccebc678-d38d-4406-bb47-4ff1f75800b6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|Frozen <=8h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c0a3a73f-3d63-4e54-9842-4ff7671d7ba7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1574731-74e5-424d-b80f-50175418bab7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da9766b1-157e-4453-adbc-501dc99d3b10'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d8ce73f9-58b5-4a7f-9477-5023834b3aba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0f103e4-1364-4701-a120-5028bad8d31d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D-AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5150eece-8f41-496c-893c-5037560f173b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3eb5a15f-26ba-44e7-8cc5-5054f2009257'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='47e4d2fe-3d71-4e92-8606-5081a46d2fd4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b8cbe89-fed0-4994-9fdd-50833644b254'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b6331150-090b-465f-aeab-509e6fbb3af8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-25C|Cryo reduced|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf218304-0985-446e-890e-50d1756fab5e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1ea3c47-90e0-4d47-9ab3-50dac78597d1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|For mnf:noninjectable', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9cb6a610-9867-467e-a573-50f6e55f3f0c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis PLASMA|ACD-A/XX/<=-25C|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6724e97c-85a3-48c0-b9d5-510acc25f791'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bb5a0e4d-01a8-4d15-95cd-511e0f5c795c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2034b9b6-7024-416c-a978-5121479cfb7c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='54792a62-9773-4317-82cd-5124a7ef1f6f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='082f102c-1476-48a3-9ce8-5142e9f6038b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='141c88ff-d3fe-40d1-a7af-51566cfa4c05'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='528afb95-3d1b-4f87-8e88-516f81fd3737'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a747901-d88a-489f-a0c4-5177c627c3a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fdeb82a9-ff55-4231-bb19-517bd56ffe45'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='750f23e8-59e7-4c1b-876d-517e53fb0d5d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea41bab8-9897-4944-aaa1-518a487ae2ae'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='CRYOPRECIPITATE|NS/450mL/<=-30C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dfaeba4a-8e9c-4deb-9240-51997af3b69f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7626e11f-9585-4bab-9b67-51c32b39524c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb81d7f1-7207-47fc-b943-51dbf75ebd21'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2875be9b-2323-4433-a1a2-51e9af304ede'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR CP2D 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b36568b-f83f-47e3-a386-51eb82e918ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='042a5861-e6ba-402e-adbe-51eeb264fa7b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6242f94b-dd55-4a87-bb77-520eb573a230'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e0def8a4-ee19-4683-bf53-523a333821ef'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e85c7837-85c5-44d5-a5ba-523ed9937908'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2eb3bbf1-254f-4850-8d9b-52421dc78448'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bd45accc-3410-4040-99ee-5246ad078a75'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='544edaa8-d549-420b-94ab-526c91342d13'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='93f65cfa-c3d9-4708-ade6-52ad26a0a54e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='627621d0-9d0b-40fc-9854-52baabf7a052'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac37b7e4-b1bd-4c1e-b012-52d4dff6ad86'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a238e591-cbcc-4266-99e0-52d7157593f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6d2d2917-b9c6-4651-a586-52de1bf89e97'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='84f7bab6-95bd-4597-a662-52e2cd17d587'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA Thaw None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd5ac32b-f668-4918-887c-52efc72d18e1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|3rd container', [ProductShortName]='PLT AFR Froz DMSO 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='648cee55-8129-4658-8185-52f4dffc8389'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 1C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='172be15d-423b-40e4-949f-52f5ce77e290'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca7e127a-cdb2-493a-b4e3-53064f1c5f00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73e9bde3-f56a-471f-8992-530dd66bfe58'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b31013e-d057-4046-8487-530fef18c5cf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN IRD LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86179d68-ef63-439a-8cef-5314c8b69991'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d8af4dd-11d1-414a-8140-53200767f8de'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|0.5 CPD/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fee9aa93-56c0-4b0e-946e-53204a17dfdc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='390f0eb8-c212-4c35-bc2a-5327926c98e2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|2nd container', [ProductShortName]='RBC AFR Froz Gly40% OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bea63b00-e248-431e-8742-534fca667eb7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12662cc6-c9fd-40f2-a374-53543c811565'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>SAGM LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63276200-e72f-42c5-93d2-5365b0633430'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='676e8945-2804-4e90-b672-536d684135bf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='936529d7-ca77-4921-be9e-5395e9847aa1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='822d40bf-d827-4cc0-9c64-539c5762451e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|Irradiated|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0496a077-534e-4787-8120-53ad4046f956'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='068c7f0e-9067-4666-bf94-53bf37c3b4ab'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6297e0a7-0716-433c-8846-53d713785f73'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a29cd396-8a60-4395-8f02-53e06e3117e3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0646abac-363b-4b61-9f2a-53e29ad3e3a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 1C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='66ad6499-af51-410a-a10a-53eec266396c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9819088-ba54-4c19-b4f0-5401981d43ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17934872-29a4-4cd5-a723-541230a159a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5b35e75b-2448-47c5-a767-541b0b087a62'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8eac0421-c182-41ce-ad14-5424e421681e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='24977301-7ebd-485a-af98-5426ba8b7c40'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4becdd7b-6961-400a-82c4-5437c8689224'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b928b2e4-e51e-44c7-b4f0-543e3c29514d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15caf660-d200-4632-b1f0-54586322f851'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e7d75d4-68f5-409a-9c44-5469d78c8bae'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='CRYOPRECIPITATE|CPDA-1/450mL/<=-25C|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f2da28ed-b309-4593-914f-549fadd4d492'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 3C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60d776e4-a3f9-482f-af7a-54a7a0044caf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e70d2ca-f18b-4e34-9292-54a980290eed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz None MNFNI LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c1de5f4f-7f4b-4440-9266-54aacd642ef0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='129dac10-5e62-45a8-b66b-54b14b89f451'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5809f5e-abe1-4a6b-93f8-54b48db19113'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97114df0-ed1a-4af3-b84e-54d81c4639e9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c140c09-11a8-4342-b51e-54e4882badea'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7e41fcf0-9403-4d7e-9441-54f304d991d7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|0.5 CPD/XX/<=-25C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7b05ff5-d242-4920-b9eb-54feb55b3092'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='202f6123-1fd9-4712-8df6-550cd4318325'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='826e87cd-933b-4dc5-82dd-552313aeda26'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='955ca778-a117-4d26-91b5-55249fa9bfe8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e701aaff-3812-4833-ae7d-552bd82927d4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ef619d4f-a4eb-4be4-886b-552eb05663ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3637a9cf-e394-4440-9241-553fb31ce21b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='242a2f42-0858-4721-86a4-553ffcfababf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7ea3070a-edfb-4c51-8312-5540df6fd671'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFI 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c8a09c8-ca07-4e3e-b1d2-554f50aeac2c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|>=600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='906f9336-0d90-47c9-b649-5553f96b8b8c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|ResLeu:<5E6|2nd container', [ProductShortName]='RBC AFR Froz Gly40% OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd47ed09-4c94-4f19-88a8-556031c542bc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|Frozen <=6h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4f71d31-a292-4c41-afc6-55745719e83c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 4CBacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5318ed4-42f2-46e7-af75-5577f0355282'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='32396fa1-d38f-4c82-8f4a-559aa68ddf5d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|1st container|Methylene blue-treated', [ProductShortName]='FFP AFR ACD-A LUKOPR 1C Methyl Blue', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b65fcb45-40b5-4cbe-919e-55a366566bf2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='CRYOPRECIPITATE|CPDA-1/450mL/<=-25C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae721b66-08ed-4b3f-a80e-55c0f3b2c439'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d17c9657-4068-4ead-a9ac-55eb74b8546c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='979ed533-53e3-4e1a-8874-56000fef8f81'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6937b18c-ec32-46bc-91a7-560c4e156cf6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2d8f3f7-2b2f-4c13-a4d2-561b08382e77'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e15d9f2-06a3-45c3-a028-5633bec1a9af'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a63ed53d-1ea3-4057-a0b9-563cdcce9007'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5b30f21-03ca-43ad-a430-564ae7282301'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='92055ade-7dee-4733-bd51-565fba08691b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e426128f-99be-4fd5-bf58-566f3971d16d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='204b1bde-41a1-4a1f-9b15-56908ba2868a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|1st container', [ProductShortName]='FFP AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='085954db-7890-4c7e-aa74-56990a7cf7f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62217889-5e58-4ca0-a428-56bceacf8285'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|For mnf:injectable|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='257e1097-3fd5-4ded-a22c-56cdf9d8a88f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9248b600-46eb-4895-a980-56d68a13f0ed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b1be1ec-9c48-4c8d-872a-56e273925ca9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17965621-fcc3-4ba7-9119-56e8ed38a7c8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e9f05919-aec4-4791-acc7-56ec60d47fb5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|6th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit IRD 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd2249ac-8b7e-46e2-97ff-56f6a649c0a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4163a367-7abb-427b-9d55-56fbabec9cbf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Not for tx or mnf|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='988a6622-7066-4f9c-b480-570783ba8697'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None LUKOPR 4C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d70ae5a3-bbbd-4b5f-8875-571198f10357'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c0c01d11-9d4a-48f9-b00e-5712ad98b967'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b8861457-92ed-4f87-979b-57137882ce43'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b4f4dee-e2af-4098-936c-571bfa15a18d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd1374d6-31e7-4dbc-9e39-571fe1902ddf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:noninjectable|Frozen <=8h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0c46ff67-b7c0-4991-8957-572e550e259f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash SAGM IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a75c85e-21b6-42c5-9686-57348e8adbb7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1bd788b6-f0d8-4399-943c-5740f76dea1f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b376d978-3059-4173-97a4-5753063d2496'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56298c36-fcbb-4fa8-83c0-57755c1f7fc3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75d05816-2fe0-486a-96d1-57aa8367799e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 3C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9cdca9db-3977-4923-b137-57b9845151fe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e18203fe-d6e1-461e-b530-57cc29200d22'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dbe88b1a-42e4-4b2e-becd-57f61b43bb87'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='263c56ce-a416-4750-be97-57f640ffac6d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4706e09d-4422-4bd2-9380-5800ae3bdc7e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/500mL/<=-65C|Open|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cba0e28c-fbe3-4140-b5a1-580a9a5c33bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='493ca5ec-c11d-4d38-9bff-581398d2dd0c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='889b9daa-25a9-4f05-bc6c-58158b64d045'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6293b421-52b8-4fbf-984e-582236d6f3a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be7eae1b-ad72-4dee-bdc6-5823bf4d3338'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e326dccc-1807-4843-90fd-5842679e94bb'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=72h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6bb58c6-fac3-4450-8085-5856f630b93b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|2nd container', [ProductShortName]='RBC AFR Froz None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f523348c-f22c-44f1-89c3-587416e94b32'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1613278b-19cd-4bd2-b1a6-588194ed63f1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3985ee0d-0ac1-436c-a94d-588a9cc1ed13'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e7219f5-0715-44fe-9081-588d8e22db82'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fabf205d-f13d-490c-a89e-5893b94ed86b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3c3e2dcf-8859-4860-9f2c-589a14e2a1e8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6039ec7a-69ba-4abb-93ae-58a224735428'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='125822f8-de9f-416c-bf0c-58c071e8ac65'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d849d272-5231-4915-aa20-58c2542e5ac7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='629ed9c0-7ad0-4705-80be-58c3ca8d0f57'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN IRD LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e686104-ca44-4785-899f-58c89cebfa35'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f62a3ea-7155-4ed2-a22b-58c99afdfa5d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95b714d7-3cb2-4a00-940c-58dc93c59c9c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d137e3dc-2858-475c-bd87-58e04887a7ec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b8f9171-d7f5-4c5e-bc9f-58e2cf089c68'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D MNFNI OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7062eb3a-f0d0-4819-affe-591496ad5f4e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 4C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e4bf38d-7924-424b-bff9-5924ad66bfb2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz ACD-A>PAS-C MNFNI LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7bc1da7-6d78-4363-9f04-592953a7dda1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-D LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14709128-474c-4dcd-8921-59555c791f54'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='06c43405-b375-4335-b587-59650e83b6c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c5fd004c-2d9e-45ca-8ca6-59666387e766'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='806905a8-4bf6-45a9-86ce-5972f8490332'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='72b7b724-8457-4b81-838c-5976244be8fa'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c4dd7803-70fd-4d7a-bbdb-597630ec7e9d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|<200 mL|Frozen <=18h|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e63a534-742c-41e0-9f1e-599de3bff956'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR CP2D 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9a74e0a-2dc8-4d51-a4a4-59ae429bf110'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='42aa818c-0698-401f-b13a-59bc6e0e318a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cbca5fde-fe2c-4be1-8bc6-59d7b2a82ef6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ba0a8c4d-c5cc-4284-81fb-59f95fed77de'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a0b8f0f-08af-4650-8758-5a04321babd8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='878db69e-205b-406e-b356-5a0698824c13'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='535a1af3-6795-42de-a379-5a1dc6ceb170'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6266e99f-ebf2-45db-b1b3-5a28853e3831'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b496dc82-c12f-4d0e-a8cd-5a450ffea0c8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6bd1003d-436f-42fb-9648-5a536edb0807'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8018ed95-ab79-4885-8181-5a556f8c5701'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c99d9b9-cc9e-4cdb-b43f-5a7c2762cbb7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0913c4a5-9fc6-4748-b8b7-5a7f969566e5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='43d11a10-04d4-4ea5-8200-5a9198362fb2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|ResLeu:<1E6|Quar:>=62d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4bc8294-02a4-438f-92b3-5ab3bdebc7da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 6C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7b1d470-f753-4036-a14f-5ac61c75079c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65f3a4a0-aa8c-4892-9e79-5ac8886641d6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2ff2d7e-fb86-41d4-aea6-5accc974adbe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ddbd331-1293-4f1d-8197-5ad5cd172031'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|Buffy coat plts prep|4 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8bd234ae-2ac0-428f-bda9-5ad622d55060'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b9380e93-7c88-4c53-a24d-5ad6735f63db'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b040869-b895-438c-a07e-5ad9491dca47'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d40d87e9-1be9-42e2-afce-5ae39956ce3b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='074e1030-d2e2-4e21-b8bb-5b0d2e7b71f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='841fcf4b-b592-4a65-aa4b-5b0ea8d84ab5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be8e8961-e02d-4512-8d9a-5b12c11c7d74'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e9b2980-f73a-4abd-85ee-5b31b1646478'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f66b56a2-6fe0-4360-9e46-5b381e43b2af'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7d38a378-0515-4a77-8a09-5b49e4c78b67'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw 0.5 CPD IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cbd27016-2fb9-463f-a52d-5b4b0a6a141e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd31c8bc-615a-4c9a-8be3-5b5d8ff1e80c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0397977b-a84d-4abe-aa0c-5b73d6afd830'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None NMT OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1eb9091e-4b64-45cd-923c-5b7e7657bc9a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-65C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b5028619-be05-4083-80f6-5b957a124c42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c011861-b878-4d81-8fcf-5bb5668a2b5b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|1st container', [ProductShortName]='FFP AFR NaCit LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f46af6cb-ce2b-4366-a75c-5bb7df1220b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f290a43-1291-4f07-b07e-5bbdbe2efe69'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a58dc36-34ae-4951-b5e2-5bc1496a1ca3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='88af9231-a89c-4456-9e17-5bdf49df9866'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD PA 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='25d9a8b5-fe8c-4844-a45b-5be1b8bb71ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5cd5bfb3-42d3-4501-85f3-5be56ebc16b3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='84ab3e91-7cc9-448e-87a3-5c11a048e02d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='91a63e52-b3dc-4f5a-8780-5c266636301a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7d96cf11-416a-46ae-9905-5c298bb37f01'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Irradiated|ResLeu:<5E6|2nd container', [ProductShortName]='PLT AFR Froz DMSO IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80120598-3949-4488-98d8-5c40a86e5cae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bc31f924-d747-432a-8e70-5c4b064c0b5c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f14a6416-ffa5-4153-a030-5c5b5a4dbe8a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C LUKOPR 2C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd96c1ff-ef10-41a4-a7c4-5c629775aa87'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='558ac514-a74d-4c39-9dea-5c66c680b41e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c876ce2-cd18-433e-9cb1-5c71c6558c6f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6792a00-9818-473a-a4d6-5c72f215a892'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa84735e-264a-46c9-9406-5c754639f646'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eea4fab6-2022-49f2-b53b-5c918ed4c09b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b8c0fe5-90e6-4616-9a31-5c923d8f3df6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED FRESH FROZEN PLASMA|CPD/XX/<=-30C|ResLeu:<1E6|>=600mL|3 units|Psoralen-treated', [ProductShortName]='FFP Pool CPD LUKOPR LrgVol 3U Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9004481f-fe03-44d0-83a7-5caf03257da6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN LUKOPR ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be4da2de-a4d0-48ea-889b-5cb128fceec0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|ResLeu:<5E6|2nd container', [ProductShortName]='RBC AFR Froz Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='92b2aaeb-7b61-4370-aace-5cb9ce046588'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60c0298a-f9f7-4ab2-8ec3-5cc8d6f948f9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37094f89-050a-4045-9cd0-5cfac57341fd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4c0171a-ffad-42cc-8d92-5d0cc3ff57a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ede4435-ce16-4363-ac87-5d138e46512a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='382ae367-1f72-4c24-a02d-5d203887fca6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e1a822f-20d7-4032-840b-5d22b78c4eae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf3976fe-b4cc-4ca5-b4ce-5d292ea8209d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='24586a20-fb04-451e-aef2-5d3195a50cac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6662b5df-1ad9-42c1-9a15-5d4d0f84ce30'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='38b2da12-0d6e-40c7-b31c-5d54cde251ca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f1b20a14-00f7-4e3f-bb0a-5d69c47ae23c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1ce0cd2-fce4-4ab6-8aaf-5d76c5e47eee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='18e58726-81d4-4e75-8af4-5d7bd4513de2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='23831017-0aad-4c08-8c8c-5dc219cc70b2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly17%/450mL/<=-120C|Open|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='748d9fb3-f69e-41ae-ad5b-5dc6d33a3473'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c19a9b17-cf1e-48c0-b679-5df680bd0c13'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15b9f538-00ae-4458-976d-5dfd24a0a04c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bcf42a26-f01f-489f-a43a-5e007696c4f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='708ca055-b0c2-4d44-81b4-5e27648c8724'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c83ac4a-4985-475d-bd01-5e2a8da0bc38'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz DMSO IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa5ede6f-d42c-4f6f-9abb-5e47cfab5272'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9374afed-ef7b-45bf-9cb5-5e582a19b1ff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 3C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e11a6e1e-53ff-442f-84cf-5e9234c462fb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5e2f398d-8c11-448e-84f5-5e930ca01561'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c1e8edc5-744e-4943-859e-5e93ea556d09'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>SAGM OPN', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e23edb7-bb6b-490e-b2c9-5eace2607dda'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Rej None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a6fcfae2-00b5-4e0e-a2a7-5ebc277ffcfe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c332f18-9aee-455a-ba45-5ebe4aa1932b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='107065fd-dd58-4f54-bf8e-5ec3be9d3fc4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7104bdf-c779-4574-b543-5ed3244507b5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15b0fc06-5d69-4311-9f75-5ed9ebb19bdb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR ALB Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b01d47c8-9a2f-4233-a78d-5ee458de1956'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f6cdebb-413d-4dc4-a125-5ef015be6372'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-30C|For mnf:injectable|ResLeu:<1E6|Supernat rem', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='92c78ab6-75ec-4ff1-87ca-5ef62a30bfc1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|ResLeu:<5E6|1st container', [ProductShortName]='RBC AFR Froz None LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7738d1b-3a36-441c-8b7c-5f0474afa497'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 MNFI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d86dd0b8-4138-432b-a238-5f0bc1194aa8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a62db46b-0506-40b0-bb03-5f1cf691fbcc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='047230da-88c9-4906-8c04-5f231f0059bd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8bfd46c5-0b80-46db-8b53-5f360dfd1f35'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|ResLeu:<1E6|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='070993ce-9947-4863-a987-5f47ebd8bb3a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d9f4372-a9c0-48ed-8961-5f4b700336a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63d189fd-936e-44a2-b6ec-5f4cc3053238'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b77b44f7-e0a0-4246-83f3-5f641351f864'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='77b19854-f281-41c1-9616-5f682c10164b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05b796c6-eb2c-45b5-92e9-5f719be195fa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f6a022c-c2a0-4b39-a8c7-5f8c26214dca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='76bb036c-29fa-46f4-9dc8-5f982225dd6e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='78c6a553-ded1-44f2-809f-5fa3b84f95bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0e21130-fec0-469f-9d1b-5faef222a722'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95954369-ad69-4ba7-bf22-5fb91bd007e3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d00cfd5f-a642-45b5-b05b-5fbbb1e664d9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>SAGM IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e9d35ddc-2a0d-465c-a171-5fda3d2e94f0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis CRYOPRECIPITATE|None/XX/<=-30C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f1f8df8-b6de-444e-a456-5fe1c666fa08'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6ffc11c2-17a0-426e-ad55-5fe8bb6ee932'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|5th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e192450c-0eeb-4e25-b411-5fed544b5093'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85f1e745-4dfe-47f0-83cd-600852572304'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bb573e0b-f890-433f-bc83-60238b017ccd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-D LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73c2b2e3-ef44-47dc-8dd4-60339db9b8e0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C|ResLeu:<5E6|50mL|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c837182-93f2-4464-bd7d-6038133ba47c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c7e2bfe-be7f-4f82-97fd-605234dffc3d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce75e0b5-cd9c-4ca5-832a-605f336f6e0c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3099ae73-c639-45e9-ab8f-60601d4e8c07'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='CRYO AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0a1750b-dcf9-44b6-b9f8-6073fe621775'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e4fd8678-995a-40e1-a9ba-60938c256da2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d55414cf-9879-442b-90d0-609416a6a695'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 1C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0471397d-5e3b-4c51-b97a-60af26db13a6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea2cb398-7c66-4e33-87d6-60b0e8e7eccf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='93bcc7ec-5883-4540-bbfb-60c3e53f070a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ef4819ee-c6be-4a83-af65-60ce4e7d68a9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='20ba3260-c768-4fc5-8fd3-60e0b0e4b3ba'
		UPDATE [dbo].[BloodProduct] SET [RetireDate]='2015-03-06 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5767d786-1231-4971-9342-60e3bbd0f82b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='934809f7-6287-4184-8b91-60e531dc7617'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9006181a-02a5-4125-b999-60ea37db021f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CPD-50 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a370385d-8c46-45f5-b126-60ebce0d8070'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|1st container', [ProductShortName]='RBC AFR Froz None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ddabf276-9b2b-4b2d-94b5-60f4dd564e72'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa57afe6-bba2-4a79-8599-611f641e24a8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b9b57ac0-c689-43e4-b387-611faf884d15'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d94f6ebd-53fd-4a12-bcd3-612366c27349'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b43a6ea6-8334-4fb1-8151-61333325544a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ac4ccf2-6063-423b-80a1-613440b25fd1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='16005729-f9ed-458c-8a01-614632d339a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f5cd9e2-3584-42b4-98e1-6171d408a074'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='de1c4d0c-2eaf-45a0-9f75-61823f2af174'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D MNFI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a6a96a62-c458-4a6d-9f6e-618cb819ad56'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7ab9010e-101e-485c-9adc-618cc67a03a6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc39bdfd-2c6a-4a19-8432-61bb1886a674'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='762f0656-d64b-4eaa-bd6f-61da73afd353'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|>=600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1d170951-db9e-4b9c-b6ad-61e01076691b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9537c485-e720-48bc-b569-61e453e2f635'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='31b6cb7b-5078-4c05-848b-61ee1bee156a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='93ee270d-4743-4358-9ee9-620edc503e26'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='64969fb4-0d92-414b-953d-621abd221707'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be4a988e-f8e3-4f46-bc31-6224edee493e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='74e878fc-0625-4d90-9982-62256985a457'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d660bc27-9db7-4ed8-bfda-622994354019'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='974b5916-1344-4aa0-9ec9-6244486a6621'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red/SAL Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1db7461-fc6c-43a2-b330-624d47548de0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4dcf35bd-72ac-405b-b8db-626d55ec31a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d5f1aa2a-9205-4b5c-a5ac-62862d55fe60'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2aec9e17-e566-4a5d-b2ea-6290cafae1e9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c0972fad-94ce-47cf-b3cf-6296d2eede06'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='144358b8-5679-492b-baef-62a81cee8c52'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6068bac1-25c3-4085-83a4-62b124e3f1ce'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='67c05062-2814-4a00-8eb1-62cf37055543'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b754f7bb-20b1-462c-b07d-62d3d61ec7c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='234e28cb-9854-4485-b273-6306a66c3e69'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01f323b2-b87e-460f-a09e-633fd44d85fc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|3rd container', [ProductShortName]='FFP AFR Nacit IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='31c76d03-3c7b-4f96-b1e9-637e2927c083'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0039fd51-e5cc-486b-ad5e-637f862f2e98'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d5d0cd1-e28f-4d1d-9607-638ce7d69e38'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2bfa7fe1-8884-4fd7-934f-639e3ee42849'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='569417f3-d4ea-4dc7-a840-639f1cd868d2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a4ed130-eabf-4465-a52a-63a9035dcba2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1182d4dd-9203-4240-84c3-63c62371b847'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 NMT LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f7f1344-b868-4afc-9c04-63c900d5f645'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4787dc67-9e00-47c3-acb5-63caf1fd42e0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5879e2d1-6e55-4e74-924d-63d93f1dff31'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq CPD-50 LUKOPR 1C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f82d292d-63a8-49ef-8a2f-63e3362a37bc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2c855716-3aab-4129-bcec-640164fc33f1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Frozen <=15h|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e515713a-e125-47d8-9725-64021dcc2773'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12602933-01d4-4054-8313-641ab8b31f13'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ff1fc422-d917-4654-a15a-642556ae70cc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3435f44a-b19f-4551-945d-64372e920ded'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8edb89a8-9120-4bb8-beeb-64678c1b76cb'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fda4ac7d-f0a0-4d0e-8f35-646817b547b9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d461bed0-70cb-417b-875b-646c6f57c56a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cf3bd62c-06ec-4d9a-9cc6-647424e7f45b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|>=600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a6ea87ca-8ac7-4405-90bd-6478468e30b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e63042ce-1c9b-45a9-b87f-64abc7f6050a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73e1d4e7-427f-4bee-9a74-64c6503d07f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='676d0b7f-9451-4619-a48f-64c878df0ce2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a182a6f0-71d9-4bcf-8096-64ccee0ad216'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97c35d3a-efaa-4b0f-a875-64e829f25a81'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='165ed9c1-30fc-4d9e-9448-6515d8b1b235'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a73b545-4d92-4bfe-8f1a-651bf9d81ef4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e1fcfc7-fadf-45a8-9411-651dffdc1867'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a18f9c9-5b9f-4c51-8c6a-65224958986e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='438e1883-7265-4752-a8c9-6529ba6c1c96'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='98eb891c-3ac5-461b-b2ff-6540e7008f0f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red/ALB Add 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5bf2e2d0-2afc-4b27-b064-6544ad9f63c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='00f1653b-bdd8-4a46-b342-65647f6781b1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/XX/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c582aee-0ea8-444d-b27b-6568ef4fa113'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b23c13d4-5f33-4638-8434-656f1effc953'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d891511-d380-4ada-a591-6571fdd1e6f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e02b84d-d628-4d13-8f6c-6583a6912eb0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8fe43139-884a-4f02-bbe8-659031eee575'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='707c873d-ccce-49e8-8460-65930f409587'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d5b7fc37-4147-47e2-81f3-65ad642a3203'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Irradiated|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f57cd07-0ed8-4181-8204-65b83df365cf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f493b51a-555d-4c24-bdec-65c70b492b07'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|>=200mL<400mL|Frozen >24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e03a84cf-28df-4d28-beb9-65e5ea203efd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc45eb2a-7a14-45d5-abd1-65effd49d1ca'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Not for tx or mnf|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac33e10c-685c-4e9a-9564-660c43801cb5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-30C|>=200mL<400mL|Frozen <=18h|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2d0b7ae-16a5-4b90-a067-662658329523'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7309c2c4-0dec-43ab-8b28-663b220e623a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='30b857da-3728-40fc-8f4a-6640b989fb4c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='35ce5d0f-d5ed-43a8-9be6-6641f4ec302d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c4636c57-2b60-4fa3-803e-66476e76eac2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b943525-b704-4412-8bcf-665bcbe7a90b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='482a5f3b-055f-4efc-a76a-6661bcf95988'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis PLASMA|NaCitrate/XX/<=-25C|Frozen <=6h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14085b86-7a72-4f94-b11c-66686f7fccdb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dbbacc76-5859-4d20-9237-668c34ac3bbd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7e02f9f-cbdb-463c-a789-668c87621748'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 6C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ef1a15b6-518a-4e16-9ec3-668f12f5ffe1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0cb5659-f44d-4553-ac22-669e048d4cda'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D MNFI OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='88be4f54-3123-4e7d-a7d6-66a4072b658b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f966720-41a5-4fd6-ade8-66a6501555b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='788a6150-6a48-464f-b365-66ae6ff081fb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-D IRD LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2eab7f93-3c17-458a-a28f-66cbf7985e90'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/450mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63e8fb71-64b2-4d09-8948-66ccece069e1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED GRANULOCYTES|CPD/450mL/rt|Irradiated|Plasma Reduced|5 units', [ProductShortName]='GRAN Pool CPD IRD PLS Red 5U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f923d51-fa28-4456-a2ff-66d4769edc47'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9c8dd60-6d53-441e-a2cf-66d4c3b0bf9a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9bbb8b0e-c935-4671-a1cd-66dd6780f429'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C|Psoralen-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3b5488f4-f037-45e5-8561-66e85354efb5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b6f5561-5c58-4695-b092-66f73ecc91d2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7f65629-72f2-4a4b-9dff-66fe2d597a9b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='66637877-7ef9-418f-be97-6702f0e634d0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:injectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='48839022-c3c5-43db-922d-67202dad70e0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04cdef8e-4bcd-4b8b-9399-673f58fd8a19'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS MNFNI 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95b6de51-b8c4-4d54-aa4b-6743337e871e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73b4a70f-af29-4596-b70d-674397a06623'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cf6ff905-0ec6-4e8e-bead-674638b9cebd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 4C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed1a8332-d217-4c78-904c-674818390152'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aee3b2a0-e968-4042-a9c0-675bf05628be'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-65C|Irradiated|ResLeu:<1E6|Frozen <=6h|1st container', [ProductShortName]='FFP AFR CPD-50 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55896b79-c984-4013-ae43-675c0052f68b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR ALB Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='800addc1-3877-40f6-a1ef-6767c4b50c83'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED GRANULOCYTES|CPD/450mL/rt|Irradiated|6 units', [ProductShortName]='GRAN Pool CPD IRD 6U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee9039c5-69ed-4849-a3ed-676cd37d4395'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e2fb1c51-7c2f-4238-b975-6780c56dc3b9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85250f5c-1f2a-4e58-9e0b-67920146061d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2cc91ec3-350e-4783-afae-67930bf89a4d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5feccda9-7337-4339-b145-67b418e01c7d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-25C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5bff222d-90ee-4822-ba52-67bb2ffc8bcc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD QUAR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0d140a4b-4d81-47b9-985d-67caf0227974'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|3rd container', [ProductShortName]='FFP CPDA-1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='00c7729c-668b-4b2f-ae81-67d6daf93e5a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c6205d28-7881-43e4-a382-67f95e5252ec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ea59b61-4882-4b09-bbe3-6811efc9dd3c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-25C|For mnf:noninjectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a9d0a1c-a857-4ab3-b452-6817ad963419'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2559cce5-ef75-4d96-9660-6824ff076504'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c3f7cf41-c038-480e-969c-6828eeef3873'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59b62be6-4f63-4862-912a-68298beaa382'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR SAGM LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='654f7037-20eb-4f07-a313-6835be655308'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d899707b-5a6e-4e82-ac11-683a294b8f13'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/250mL/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='352d8cd1-0eb2-4530-b355-683e365fdfff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='503347ee-51ae-4b02-9dac-6840ea33edf5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6a19b16-3190-400c-936d-6844c364fdb3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='32230ad1-e64a-45a9-960a-6853c3f36bab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='575c0025-fd08-4499-9077-6866a37f3374'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a81445bb-49d3-42ea-b3d8-68933325cb93'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|2nd container', [ProductShortName]='PLT AFR Froz DMSO OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d61ea9ac-db51-41f7-9916-689a36444721'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14cfd2ea-175f-4dd2-af19-68bc3f8e4e05'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CP2D/XX/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f193aef-704c-490a-8937-68ef2e0d3e29'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c24828f7-42fa-41b3-b9c2-6907b1902d8a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e208512-7043-4b7c-8ba1-69190096a267'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc1bbe7e-6e5e-4575-8e80-691de88b5d5a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR None OPN PLS Red/ALB Add 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1be36d09-b8ef-4417-86b8-691f5d5a64fe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR PA 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ff816ca-af4f-4339-b247-6958728bf6e8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='47d9b89f-bb33-44bd-ac57-69599874599e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f80c9d1-7bec-4a3e-9f4c-695f5f13fa87'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|1st container|Quar:>=112d/retested', [ProductShortName]='FFP CPD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5963331a-d11b-4ebc-88d7-696e08df0919'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa671965-58d4-4742-a414-69b7b8e0dd60'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1ea97638-7572-42d7-803d-69bebe0d83f1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-120C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ad5f5718-93b9-4313-a2dd-69c7ff95c273'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|>=600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='302c38cb-a026-4c97-b89e-69d1ace5d85e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1a0ff05f-c820-4c33-b80e-69e11361581b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='561bffd7-eca4-4935-8a16-69e580b1be00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b200c27-a012-4d4e-aaea-69e8aff7b288'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1379c92-4a00-4f1c-9b58-69fdb8ad7a2d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1675861-6c4b-4472-908e-69fe7d027665'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='843c98fd-5be7-41ac-a752-6a187a9fc258'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=48h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6b7b349f-ee99-498d-a4fb-6a25f12ece06'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR ALB Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d34c87bb-7584-4023-bb0c-6a27f1697611'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fc3cf28f-1e81-4cca-87d5-6a3416ead923'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a528b80f-9b8b-4a62-9f68-6a3ce31de57d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:injectable|Frozen <=8h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='90746fbc-5822-4599-b81b-6a450330d396'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='10aee4ba-7b07-4eaf-bf77-6a4cbf0b9ca2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d277d92-486c-4962-b643-6a4fe6bc3672'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='36ad931b-d01f-4997-8b92-6a52dcd2faf4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f3b7a02-bbcf-4cb6-b79a-6a667029f09a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f3fcb738-fe9d-4d7d-8416-6a70f8d6dd58'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='45ec02cb-5a20-4522-997a-6a7cdc58b02f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f44c22f-1465-4b9a-af8c-6a82573ea82a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9c10833-e2b9-4253-8d29-6aa3c9b9c958'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 4CBacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='392a9cb7-baea-4f90-a798-6aa6bf7fa5f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 8C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dba40789-dc9e-446f-ba5e-6ab6e32bb052'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='996630d5-b50e-4f05-a249-6acb5f20371d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f7b76312-bf91-4081-a14f-6acfa08322c3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A LUKOPR CRYORed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5bb48fbd-e698-4d76-b274-6ad6aa29b4ec'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|3rd container', [ProductShortName]='FFP AFR NaCit 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d10dd248-309c-43bd-b33e-6ad9bc389cd7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bb0e65c9-15ce-4bc7-a3e9-6ae3d20ea97b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR CP2D IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ed4fd55-51a9-4ca6-84ca-6afeec3437ad'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 4C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d809296b-87d1-4e77-896d-6b02f3562b18'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='befabd6a-f14e-449d-96dc-6b1450adabc4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|2nd container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A IRD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97f4d9dc-af46-4a28-9aa5-6b23c737a8c8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f27dea45-7c42-44a9-b88d-6b2914babc4b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4299de09-4d45-4718-9da7-6b31dc8e101b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 1C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fbc0c356-d113-4ff0-afaf-6b32a93b4c57'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA Thaw None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6b2d6f76-7d3c-4532-92f4-6b4e3689f76d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12c398f0-a74e-45a9-9b41-6b6ed8f99b31'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|For mnf:injectable|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c6d728c8-06f3-498c-8b57-6b727806be43'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c5abcd6-6529-4a90-9ec6-6b7d5d1a488e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='660c6b29-e187-471d-ad15-6b89f4e0f099'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4fb7e2b2-49e3-414b-b4d8-6ba14d029635'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7b41ac3-1736-4bdb-ba06-6bc0b7de57a2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c65c872f-12a6-4376-9b75-6bccf6bbdaed'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|4th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit IRD 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d71d60e4-6596-4b06-921a-6bcdc5d1e3c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 3C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1fad4b6-2a52-40d3-9bb3-6bdddce73d99'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f5598de-5f30-4051-9a5d-6be2be4cb890'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ecbb442-ea47-4b75-a027-6be6d826bcbe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='befb59e8-c580-43d9-b0ff-6c3939964e3e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='28268463-2edb-424c-b1e4-6c3cf101311c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05de88ef-6e8a-4922-97b0-6c3dc78371bb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b428e9fc-448a-4b26-b781-6c5af159ee6d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bcf9e5ae-4e3b-4297-a411-6c8a18ee8672'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f84e459-5adc-4610-bea2-6c910534d808'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED GRANULOCYTES|CPD/450mL/rt|Irradiated|7 units', [ProductShortName]='GRAN Pool CPD IRD 7U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c295f8d3-57ae-42f9-92a7-6c972fe8735b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/450mL/<=-120C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c00cfa9-7d16-4660-a013-6c9b5fac524f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 1C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e84b9a66-bd74-44cd-912e-6cb2d578c3b7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|<200 mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='320ce080-6902-43df-bc7e-6cd47836bb89'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e86f677b-9b07-4e83-bb66-6cd6e868c429'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c6a4600-7016-4671-af54-6cdf85d10fde'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cf480dc4-f6ef-4d67-928c-6cef5a9e7ef9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4ea5847-2232-4ca0-b3e2-6cffa4496dee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a6b8489f-dea1-42e2-87ec-6d09d1b01133'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='49a9a493-b000-4c20-8e00-6d0ac28ca6dc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 8C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='43eac84b-a900-4009-8c0c-6d152a1c6ed6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='967aba28-cfd9-4665-989a-6d1554b45cb8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8fba04ac-be70-4b3b-8092-6d16ac30861e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|ResLeu:<1E6|1st container', [ProductShortName]='RBC AFR Froz Gly40% OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='36a1d208-58af-4339-b5fa-6d29c2faee2a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-C LUKOPR 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d54fd17-df5e-49d0-a9d3-6d2bd5f9f464'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12c0f2fc-01e1-4999-9a04-6d31829fb3e1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis CRYOPRECIPITATE|ACD-A/XX/<=-25C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='650248d2-d6fc-46d2-9ac8-6d3628997237'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='78728826-20fe-4db0-abcc-6d3a36e89b09'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7747a12-7431-4f0c-b611-6d3bfde8104f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e26d3a5-e47a-479e-ad57-6d5f69f47759'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-25C|For mnf:injectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bd28eeeb-0d5a-4bf7-9075-6d816b7238ae'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/XX/<=-25C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8c61331f-2f0f-4502-9908-6d905b6c63bd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6001d5cf-89d4-441a-823a-6da600a4df3a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|2nd container|Quar:>=112d/retested', [ProductShortName]='FFP CPD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14a18236-3dd1-4f39-a466-6de509961115'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red/SAL Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='274f7798-e429-4219-9a0f-6dea0686da6b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99deaa37-ddff-4101-b206-6df1228aa62e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-65C|ResLeu:<1E6|4 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a5eb4aa5-97af-45a7-bec1-6df47ec4a33e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ccfbb195-853c-4867-8acb-6dfb5e1dd499'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-65C|Irradiated|ResLeu:<1E6|2nd container', [ProductShortName]='FFP AFR CPD-50 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1fda0674-f85f-4b8b-879f-6dfc84cf55f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f4f66935-70d7-40e4-87a9-6e0249fdb71f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95449a46-02a6-413c-87c5-6e12844f51b4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f92e55c-ab26-4d02-93a0-6e22fa90bee0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d7b12c4-e201-4079-a007-6e2d587c60eb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7fb143b2-05df-4311-a7e4-6e35d60c437e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2b61b737-c1ce-4f26-b9ff-6e5b0e26423a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='48631dc8-79ad-43ed-ba01-6e61a2e7a286'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='859ecb9b-2a75-4026-bad2-6e81ecc5bac7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7b3b319-70d3-4826-9855-6e8ff7de3a90'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD PA 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf76e9dc-d30c-4fb1-b801-6e956d326788'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65854a9d-4d6c-4db9-a01a-6ebe79f656e9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f1e25236-1fd4-4cb9-a079-6ecdb61db395'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='392851cd-1227-4665-995b-6ece15fe3231'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22d400a0-609b-4624-8e47-6ece54e98ea7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 6C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a2ab50d-8f98-494b-9f50-6f156540cb3c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e2249747-2acf-4fd2-8b47-6f1973fc07b6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='24506144-dc75-4a05-960b-6f271f85df16'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='40eced93-e586-4887-b57e-6f2a291020dc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7914d0d7-0eb3-45f9-b7a6-6f316b18da8c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|5th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A IRD 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='905685fb-a9b7-461a-a17f-6f47b0d8a34b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a574be03-7ee1-422d-8eae-6f66d12033f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-F LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b73ed00f-3a7f-49d3-889e-6f715769bc79'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='03feabc4-24fe-4370-a81f-6f7e9fd90e21'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/400mL/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1029b180-8c26-49f2-803c-6fb4993c454f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eff659cf-f445-46fc-b4ba-6fc6df267065'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cddd2a67-98fd-4789-b24a-6fc93647b2a6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6871f574-a6fd-48ff-a854-6fe1f3c3fe27'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f526acd0-db6f-45c3-8050-6ff376d5c534'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9eeee1c-add2-4ce5-80a6-6ffb1962f30f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='06476fca-bc0d-44b8-a5fc-7026307370ff'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-80C|Open|ResLeu:<1E6|1st container', [ProductShortName]='RBC AFR Froz Gly40% OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50bcb853-79ec-4c73-8218-70303389015c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc9ee733-8480-41eb-b49d-70370b9df3ef'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e09ad06a-4729-4fb2-bd95-7045dd0de804'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/350mL/<=-30C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='776c4830-a0e7-401d-8575-706ba98573b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej Gly40% OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f461ae73-1619-4cec-b33e-706d5c4e513c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 3C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0abd651d-b13e-462e-b68f-706e962077a9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dfc9b6f8-a259-4181-9396-708f6b168f27'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9fcd84f8-2e36-4fe1-9888-709ea07d2bde'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='935c2053-db64-4e6b-89ba-709f09ea8602'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-30C|ResLeu:<1E6|Cryo reduced|Quar:>=62d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37d28181-b2f6-4265-b8ff-70a833e657c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 2C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e464e8d-6814-4ebe-8c0d-70b6362f9cf9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='745757a1-de1f-44bf-93a2-70bd84227915'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b07bbd81-a5c8-409c-a380-70be7659ca52'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9693f210-df95-4bfc-8f9d-70c2c3950ce9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR ALB Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b688b513-76b8-408d-aabf-70d2276db319'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a075978c-f7c1-4551-85d5-7116fe3f896e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f0b42ed-a019-436e-9d1a-71377cf54982'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='554d5f00-8ef9-4b50-9a56-71736a406317'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ca9027f-1406-4149-bc5c-71756b2cf209'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b739ccc4-55a3-4d5d-a056-7192ec13975c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='69a4eab3-6aa6-4191-9310-71962e2852b5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 MNFI IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a0e512d-d181-4f73-9322-71a8b004ecca'
		UPDATE [dbo].[BloodProduct] SET [RetireDate]='2015-03-06 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f7ad5c8a-28c9-421d-81fc-71ad0ac578e3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='841f597f-670b-4e34-aa9e-71adc4a08be9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='70207a2d-e0e6-422c-a4cf-71b91a10a6c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97d6b1f4-13d4-4e0d-bcc9-71bb000f9d3f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0c4f26e0-ee37-4ed8-87eb-71bf88e43485'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='769a01bb-a931-4221-8d8a-71c7b6ad220c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='480e44f6-c930-47cd-a594-72033f5da812'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d21d941-28ea-4560-885d-721f5bad2386'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da8ba88a-c4d2-4fa3-bbd2-727c288de1c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17a9d4ae-b361-4ca1-b7ba-727ff8bd2abf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='653a5925-7b2f-4d57-8dc6-72881c7a1296'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='529f54ea-c758-4474-84a7-72a0921d0be8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3456bfc7-3a99-49e0-9254-72a4dac164c3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d2cf5c3-6935-4ff8-b545-72aafcb4f1d6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='983002cf-dee7-434b-b0dc-72b13face293'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|4th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A IRD 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='90edf8f5-3676-4a33-ab62-72c58da4550d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8bd8dfac-de40-4966-8b75-72d6f80ce043'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b64863d-5c82-476c-9df6-730d76c2d047'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f507519-6d0d-495f-ad95-7317318cbae9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c62108d-b311-4f04-9e05-733cf8f52976'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4eba6620-b15f-4ad9-af0f-7343f207672f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1886ac8-3239-45fd-bc7b-73442b26e716'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='816129c6-a0bc-440d-bc31-7349ee3934da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4399b7b-b73e-4118-af43-7353ca2d53e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0eb5f2a4-73f8-472e-b2e9-7372297e880b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Not for tx or mnf|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5cbf1ae1-08c9-4ede-a0b1-7375338ccc45'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c09bf8d6-75b3-44c3-ae46-7395a00aa230'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a73d3ad-9fb4-4a19-8939-7396c159792e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e93da69-5f89-4e67-b129-739bfb7bc8c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f163b672-623e-48b2-8550-739c2e6cbc13'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 6C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8bcf8e8f-c91c-4d1c-918a-739f5a61bc0b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|5th container', [ProductShortName]='FFP AFR ACD-A IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e874028e-e2ce-43d4-bd40-73ad01f51d51'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='41cfda4f-fe14-4961-9e95-73aeefb424d8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8ee982b3-7786-4378-a248-73b23f0362a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7e9fb19b-607f-48fc-96b1-73b7255c3d01'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ea8f42b-18d5-472e-9416-73bdf406bdc3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2cd4656d-b718-45d7-b340-73d419858b9d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2afd69be-5f04-4f14-afaa-73dcb8ed620a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd1e983e-46e1-409a-a6a7-73ebdbbaf191'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0c453a5a-dcb5-4cef-b328-74147d7e23b8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59a60483-dbca-4747-ac4b-7419be544f1a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c040909b-80c3-434e-ad2f-74230519b84f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFI 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0be66e35-93a6-46b5-881b-742d253db79d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c7072b97-6f67-4d4b-b2f3-7430a3fc5f03'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d7845c76-3341-40e0-8fc2-7430c3f0cc29'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f7442148-54d3-4f6c-88c4-7437bbad20a7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6589d35-94b1-4827-804b-7442079168eb'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|1st container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A IRD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='afb8da63-4e1a-4cda-8501-7468c4887207'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='96ec13e8-ee99-4321-9f09-746fcdd4c128'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0942ff99-0b6e-4b0e-832c-7479cdae045d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f0e9e7a-219e-43e2-ba04-748be110261d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|For mnf:noninjectable|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='58de1729-3be6-4797-9d78-748e4079cf73'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e365bfb-c318-49c4-a31d-749702fc936a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ffa7a1be-d64e-42c4-a79e-749a3838485a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 2C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='79d82b66-2d9d-4ea1-a550-749cf371c1ce'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0178eb66-21e4-4cd0-8268-749da5e29a69'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55ef4ee7-dd39-4019-94aa-74ac9ef385c8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81880b6f-6751-4c3e-8c8e-74b1ff22ed85'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e9e44395-9ae5-4800-9e56-74c92d69c82d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='100d6e4b-10a0-4ef3-b76d-74e21b5cccf7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa8c4443-3d1d-4fc2-acf7-74f75d760f06'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce909619-088f-4ab4-a426-751dc01d6c70'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='080a492f-e8dd-48d8-a57d-753be696f9a2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Thawed PLASMA|CPD/450mL/<=-25C|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ec6abb0-bf23-466a-af6f-75405ef2f31e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=600mL|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2ff25e2e-2e2b-43dc-9969-7543b83f3e53'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c925edd5-bbeb-4356-b491-7547e85e75b6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|Irradiated|ResLeu:<1E6|Quar: nationally defined', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb16d7d6-c15e-4c47-b99f-754b7fbe10fb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a30ef82-924f-4083-8c75-7556ef7d24b4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Not for tx or mnf|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6bc5d13-b869-4b08-99e0-75581d126b08'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e0258f0e-55e8-4097-bcb1-756477947574'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17861d3d-172e-45b0-af14-7571c7e50782'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6fd81e01-587c-4f90-9ebd-758b4dd8a800'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f635d3c-8f2d-4d16-8065-759d473a6b67'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1b777e04-2871-4f8e-a325-75cb2fc2779e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa810d1c-b26a-48b2-8709-75cf946fd54b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6adb8373-cd01-4281-9b81-75e015769aa5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80526153-cd64-478c-9878-75f26ebe51d3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/500mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2b9cf78-4657-4b56-996f-760c39d914f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='725ba79b-3138-4629-a843-7612223ed3c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Gly40% OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea8286c5-0cc2-4abd-9a65-76304c38619c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a188c903-5064-405c-887b-763b28d37133'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='338e3fdb-c9c6-41aa-92dd-763ddee6f067'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/450mL/<=-65C|Open|Irradiated|ResLeu:<1E6,WB filtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='061e142c-7404-4cd3-9053-763fa193b46a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='41fcd77d-ea65-4313-8cb0-7644dacdb858'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-30C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='585bdf2f-418f-4075-8b9f-764e839f6781'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|3rd container', [ProductShortName]='FFP AFR NaCit LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ec2211a-9cd4-4789-b5da-765da5f5be39'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ccbc0ffd-4fa2-44b3-8a62-765f1bc385b0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d74586a-4196-4996-9d0b-766a2746b059'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1256ee6d-5fb6-4f9c-b82d-7687de8307dc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f6ff6ca-7bd5-47dc-b2e0-7688e7cd5f0f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|3rd container', [ProductShortName]='FFP AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5dfae1b0-0647-4ae6-b5d1-768fe4e6f777'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|7 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0c74c8d-cd88-481f-9d5a-769990f98709'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-E LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ab5a83d-f5af-43a4-bb64-76bbe99660da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8bb3ac49-a9dc-4f94-a907-76c591d7a860'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|1st container', [ProductShortName]='RBC AFR Froz None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5e62b63-0a35-4205-9303-76d9675b3b9f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0507ba4c-45d1-4538-86d0-771cc8f5dfe6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='670e872f-a40d-45ac-95f9-7720af965744'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='070a8b7b-8aac-4c4a-91ec-77393b302564'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='254f3ff1-950e-4c8f-9c72-774fb25b4969'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be2d2d71-f2cb-493d-8354-7755a775c384'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd5fbccb-564d-4d35-9a27-7786d8112f2b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4f20256-7fb5-4ff6-8064-778e0f80dec0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CP2D IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d125b704-f31d-4b4c-a4dd-7791695f6244'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 3C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a7d294ed-11c7-42d7-8eff-7794571d57e8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|For mnf:injectable|Frozen <=8h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='296c565c-b14c-4f3f-8b3b-7799ff0daeae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a958b0e-2744-4807-9881-77a53da77ad9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN IRD PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc1de370-523e-4322-9a35-77bb1b54d487'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Not for tx or mnf|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e0e4ab2b-5e1c-4181-85dd-77c83b07944c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b04b7d63-6074-4bfe-906a-77d6a546c6f7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f9881ec-dc14-452a-a447-77e0682df6e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='39b7f594-e39f-475c-980a-77fd793fc0d0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq 0.5 CPD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='731169c8-d50f-4bc9-8364-7800f18a79b9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5da6efeb-8eaa-4b69-a43c-7801597f98a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg AS3 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='348943d8-9c9d-445e-9a7a-78205f466a4d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='07a382f0-f424-4b21-ba50-7831ec3eee20'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aed49465-8410-4968-88c6-78635ca63a6b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 4C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='03dea0fa-5fbb-4127-8bbd-78753296f181'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf023cd6-4749-4683-bb76-7886d8a638f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0afbf503-0049-428a-84af-78acd999a295'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dfa508d2-0762-4ebc-b535-78b456f60bcc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e3e0d245-95a3-4ac4-8596-78bb48b0d965'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a5e9e0f-6a5f-4222-a2fb-78c93eeca050'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD LUKOPR 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9cba165f-390b-422e-8ca0-78d758d6c64c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bd12229a-761e-4810-a07b-78fbc47bace0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2437b15f-ae3b-48b1-bce7-78ffdb14c0f6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e3c6306a-6ae6-4793-88fe-791aac80b692'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ae93d72-6587-4c8b-8545-7920386a3295'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='10ceadda-948a-4476-9e26-7950fd655c03'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|Quar:>=4m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a75346f-19f9-4d10-8d84-7957ef642a99'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='701d5ea5-8917-4e5b-b1af-795862b7ebb4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3bd09bc7-ecc5-473d-a413-796388336f65'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='994d3a6a-70e1-41e5-bfeb-7963b37b1d74'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='db49023f-7211-48a5-8497-7988562404d9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw 0.5 CPD IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee318c38-dda3-470d-b674-799ab598cd55'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a761399b-56b4-46b3-b241-79c50aefddf6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfd7a58f-ece4-4717-bffa-79c8c41ebe58'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50542f78-ad6c-4cb4-92b4-79d08f653adc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|6 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d7c23d53-c943-40d6-ba06-79ea315680a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b670b84e-ae8a-4fa9-b0fb-79f45fbe2665'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='57643325-53ed-4cb3-af45-7a0202e238ad'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73c28ed8-774e-4251-99b7-7a137a16b7bb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e9e22cd-6bde-43ca-bda9-7a195d9a2e62'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='06e7ffdc-9587-4644-b63a-7a2455e0722e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2436f48-9d46-4170-96d9-7a29aa28ad72'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 2C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='517245e2-1a53-469d-b121-7a37e74edd5d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='afd269fa-cafc-47cd-b2b1-7a3abf564701'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='204a1b13-d4a0-43ea-9390-7a403070c1c7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f3ad4e0-74fc-4254-a06b-7a4351f94e91'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4911163e-5062-416b-be22-7a435a0db49a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='717932b8-4109-488a-96c0-7a45c2e0a2aa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9cf5a74d-8425-45bb-a7e6-7a4979d1f435'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f0af384-de39-4069-ad78-7a6555764342'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2b341b2-bbf7-42a7-942f-7a7d1734a6ab'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|1st container', [ProductShortName]='RBC AFR Froz Gly40% OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6f58bde2-b550-4edb-8e3a-7a8fb9467d00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='57451d50-9b1d-4cd1-b47e-7a9d599e7115'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Quar:>=90d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2da08ad0-92da-4e80-ad5f-7aa535c86901'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|1st container', [ProductShortName]='RBC AFR Froz None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea6074fe-0a25-42a9-89e7-7aadc532cb77'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Frozen <=15h|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9302e77-e2ff-4030-af28-7ac62a9d98db'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d362873-cf2a-4b15-9656-7ace9cd516a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='72498521-10a6-44be-bd22-7ad5ed34baba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='af63749f-619e-4b8d-adb0-7adc1b512c5f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-30C|<200 mL|Frozen <=18h|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1950b7fc-2feb-461a-8cdf-7afb163870d9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b534f4b-037f-4cef-a2e6-7b0e87c3190e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0240f466-ea92-49b0-a129-7b2bb77cc59d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 7C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6f32d163-44f3-4a26-a3be-7b82d8bf0f81'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8e57aba7-b879-4bc5-8434-7b8d0d57ac94'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='49ac7763-975e-4ab3-bbe0-7bc173f0cde5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-C LUKOPR 3C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bd22de49-8255-4607-b5ad-7bc3f74bc15a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2bff0af9-d9f3-4882-903b-7bdbf0b74ff5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|ResLeu:<5E6|2nd container', [ProductShortName]='PLT AFR Froz DMSO OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b292c64-e6ec-4f2b-9380-7c3729582efe'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|2nd container', [ProductShortName]='FFP AFR NaCit 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86ba713f-bc95-403c-bfd0-7c373011737e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|ResLeu:<5E6|1st container', [ProductShortName]='RBC AFR Froz Rej None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ccfb5c4f-4b99-4f66-852d-7c4138afbb20'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1780b055-a91d-4499-8173-7c58664d6c68'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc2b04e5-3a4c-4460-82be-7c59de67e3b8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fcadfe2f-a777-4cdc-83e4-7c6102c5ce1e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|0.5 CPD/XX/<=-25C|Not for tx or mnf|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80359482-2109-4bd5-a3b9-7c6692b8fac1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8c52401c-2b0a-4ac3-82b9-7c68495928b4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Irradiated|3rd container|Quar:>=112d/retested', [ProductShortName]='FFP CPDA-1 IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1deaed29-91f2-47fd-a0fb-7c6c981d1ab7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3486836f-7626-4e4f-bfd6-7c7b4ebd8bef'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2fe99f2f-493f-4399-90ce-7c7c02eda35b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a391ccc-9fc6-4c91-b242-7c80a625acb7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea887a74-8ff4-4508-9c29-7c840910d11e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='acc30840-5056-4d81-96d6-7c856094d5fc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='33b4ffae-2dad-4a77-9558-7c8ceb6a1501'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d6f4feaf-2267-4d0f-808c-7c9ad4a59551'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9eacebf-ceae-4ce3-bd7a-7c9c25b3e944'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 5C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='216b5f32-1929-42cd-9c2f-7c9d5064909c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-25C|Frozen <=6h|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ca4fe3c-ad68-4953-a074-7cab31929df7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fc6e06da-573b-4b43-a8a6-7cc677891cbb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa757f41-5748-45e7-9bdb-7ce64f5686f6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD PLS Red/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ebf5df5-b730-4521-9aea-7d0509be02b8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Not for tx or mnf|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='df7ecd17-cf79-40df-b8df-7d0a763bcb35'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='76f6eb30-02ac-4470-a696-7d1132467c83'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly35%/450mL/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce3b170e-f83f-4602-849b-7d16d78c4e22'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|<200 mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4fda635f-eddc-4415-878f-7d19df846388'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f40a15fd-10b2-4c13-a8f9-7d1dcc166113'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d005eb3f-3836-4628-b1c2-7d20e3329501'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f5e6c6d-cd8b-4d9e-89c3-7d2356fd331a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='64562dba-754e-4126-b8a4-7d2686d70988'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e20e860c-888b-4dd5-be55-7d2d67d1769d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b020238-5520-471f-8fb8-7d35ab595a72'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='700e0623-7bfb-40a8-b4eb-7d38e9b14caf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1ca7cabd-acf3-4847-ab41-7d41d9c757a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bcf5b025-d2b7-49ee-a3ac-7d4612f3e92b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f035cb96-a7e1-4b9b-87a8-7d4f8fb3fc48'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63032cf2-b092-4c0e-9d61-7d50b3d43d92'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8625664c-2188-4774-9982-7d5259b0a80b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14eb34b2-0b46-4b5f-8fb6-7d5b55f93b0e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a22b5b19-f066-445f-8ba0-7d7e20588bb1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12c996c2-4f05-439d-b159-7d89143c5c33'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='19a8e320-a13d-4fa6-a821-7dc3bc2d081a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Rej None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae8dcb14-d58c-40e6-ade4-7dcc97a14002'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a283665-84c1-4dff-b2b9-7de36ef38f61'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ede15b8-1cb0-4f84-9374-7ded621038f4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|1st container:not auto', [ProductShortName]='PLT AFR Froz DMSO OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63403c61-368d-4e62-bfc2-7df382b5f9ae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b492d2b5-9826-4af5-ba7d-7e09c527c43b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 6C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b3c20d3-6ded-4bb7-9ece-7e1460ac46f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f3daaf6-8e0e-42c3-91d9-7e2a9d52f497'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/400mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d84654e9-edca-4938-a8b2-7e4a3836efc9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|ResLeu:<1E6|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='433f7d00-386b-4708-ac29-7e4c2de74401'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d83ed327-df79-4150-af45-7e4cfab729cc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0257c68d-7d7c-4d94-8abc-7e4dfb7caeed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 OPN LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c1164507-6de7-4b79-bab7-7e64c5472197'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa7bd40d-fc35-48f6-8bab-7e7d53806739'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6fdd735e-8c80-4a5f-840a-7ebf7713be58'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C LUKOPR 3C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='509ce998-3f02-4498-b574-7ec510474df1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd1a8e3e-a0e9-424c-bee4-7ec570e9121d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b19df7dc-6676-48a8-afa9-7ec67dedcbee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa1d1dd7-9d9c-460c-bba0-7ec7fd71a7f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac34fd39-7b6d-45ca-8d0d-7ecfc8dd7781'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8bd7c970-14be-43fb-8482-7edaaf49a99b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75e4c79f-7360-494c-b71a-7ee7b3fd11c8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-D IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6cbb36ad-819b-460a-9e16-7f18872d520d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='16a2f7c9-ac4c-4629-9883-7f35188495a9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C|Irradiated|ResLeu:<1E6,WB filtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ed5100f-f296-46d3-afa2-7f586f1c1afa'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='21e315d2-9241-41c9-9a77-7f592e4fff2c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3432b89c-9690-4a73-bfc4-7f61345a6f44'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e1773d6-acd6-4625-8e80-7f6cd93b570f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46112c71-a3a1-481a-a7fb-7f772d7554a7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|0.5 CPD/XX/<=-30C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='32da055d-469a-4333-b2e9-7f798cc81bc5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='913e0798-c5d0-40eb-89d6-7f821dcea26f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ea4e7812-7f15-46c1-a80b-7fPORTe7d2b3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='acdb0daa-11a1-4342-bb9c-7f89ef7864b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPD IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb87be2a-1ef6-4ff3-a830-7fa6fda6b025'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='57a2ca8a-533a-4479-9292-7fd42d620d36'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b0b8dc35-be11-4dee-8040-7fdfc580f035'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 MNFI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='036841a1-4d71-4f6d-8e97-7fe24b1632dd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14836aa0-8482-4f03-8b19-7fe8bb404d33'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='db4a070f-63c8-453e-bb51-7ffdcfe8751d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ba314d06-39c9-48d1-887d-8008d8d5c70e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f8ea6bd-9b9f-46a4-a347-8010fe32c8a6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='170ec478-3a74-478f-8413-801d270f9a42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37d1dc6e-1129-4528-ad84-8027570ce513'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/450mL/<=-65C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6f26f529-e7a7-441d-bff8-80348737b1ad'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e6faaef-4d8e-42fb-93a1-80425a4f0b86'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7297e2a7-f6c1-467a-8565-804c703955e7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5291a930-f4c9-457a-bee5-804d4f2e4033'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c8d190f-334b-4e73-b9fa-805318acfd54'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e0aa2bcb-6a63-4ab4-a96c-805c3285e778'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e678813-fc7a-4a1c-83c7-8074dcea40a2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|2nd container', [ProductShortName]='FFP AFR ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd40bca0-a29d-461f-8b85-80904e93355b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-30C|Open|ResLeu:<1E6|Buffy coat plts prep|Psoralen-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5014a256-0223-4991-9d9b-809636042796'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f80e863-96e3-4a8d-956f-80ad9cfc992a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5e137f5f-f025-4ac1-a40b-80bebee709f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ceb231db-d921-48be-8347-80f2e5b48eba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='88afd288-733e-469a-9e89-80ff8c089b77'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='573c55d3-c780-43ab-90d7-810ed9f48511'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CP2D 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='951dd55e-ef00-4601-b1bf-81390b851fb7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 1C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='13b67ec8-6409-4f42-920b-8154461d3784'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='738aaa6c-224b-4346-8404-817e6ab5770d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-D LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0dbfdea5-b111-4b5b-ab42-8181cde8f972'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b02908d3-456f-464e-844d-81888e3d4b31'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='de714c35-6912-4153-9d72-81951b43d28a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eef0210b-ed02-413a-938b-81952ff91d00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9533a4ac-e469-4291-ae00-819b0fac5ee8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f49d7f2d-54a0-4be9-9ded-81b63e0b840b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd8c9a4e-a215-47c0-9f92-81ccd2061c76'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 4C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c3761b1c-1817-4721-9240-81d69a550aa0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='03368624-2b1d-4970-80fa-81f8ee0fef09'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ae94336-67a1-4676-9075-81f9f710b0f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca593f51-e189-4e25-a3f1-8212d209a26b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81609445-bd24-412d-a307-8215d58155b8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3fac34bd-b215-4d5d-b93f-821685ffb078'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-E LUKOPR 4C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3cf222e7-5f90-467b-9a9a-82208e240427'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None LUKOPR SR/SD-PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f5d262c-3c91-4aef-b7a4-822135f31256'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq CPD-50 MNFI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ae4069d-389b-4b73-af27-8222fe236545'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/XX/<=-65C|Open|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e96c33c1-6b87-44f4-801e-82291d317927'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a9793f19-6199-4e90-8cb2-8237342cb586'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e390961-0284-438e-984a-82963532fd71'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0ac0f8a-bbf2-46ad-9015-829bb6073a53'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd1825cd-268c-41f3-af66-82a0d10b3e00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='10d18b5f-dc4e-4765-9dd3-82a7b4a7e93e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d07731d-e975-457f-a4fb-82d8ee1b79b9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3b6d5d75-cda2-44e4-a7fb-82da72b09f52'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7d0e7b85-69cf-495b-9b4b-8311269b2cc3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='66a9da61-a9a6-4a50-9d37-831c94f49196'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='23f2fcf3-dcf7-406a-9e64-832e6dffab4f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open|4th container', [ProductShortName]='PLT AFR Froz DMSO NMT OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='415c9bea-df39-40d1-8d9b-833110bccbb0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED CRYOPRECIPITATE|None/XX/<=-30C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4975e3e9-30e1-4ae1-93e8-833142bbf8d9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c5f1fc5-81b0-45f8-a2a0-834fe8e6e1f7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='26f58b4f-6527-4d5f-b087-8350418b84b0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62fcc3f0-dfe5-4eaf-8323-83647f578c16'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|ResLeu:<1E6|2nd container', [ProductShortName]='RBC AFR Froz Gly40% OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='49bd8c34-624f-4f33-b8e7-83739b03ee99'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a77273d1-a6d4-436a-bb0e-8394d256d77c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|4th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='630ae365-1893-4513-957c-83a2b4fb1754'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='13490ada-9f15-4899-b86c-83b85f95de3b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2ea783b0-92a7-4627-877b-83be9f6f04e1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0e9f395-577f-45bd-9828-83bf29b38717'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eb23d726-cfaa-4209-a291-83c3b6b56ecc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99cd2589-8d37-43cd-ade8-83d80846fac8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d4c9c08-91bf-41a9-9b02-83e9da061be6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dac527e9-8d6d-4dd7-8469-841ac57d1098'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5bb5058-f7fd-482e-9773-842c39557a9e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d34ce90-8505-40e0-bb93-843fbb68879e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='77a44e41-7b0d-4878-ad4f-847520dbd5a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4bd8c53f-3826-44ec-b921-84876810f432'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='155e7b8a-a498-45d4-8315-8493ada3818e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8abe4492-487c-4c2b-b08d-84963ad28387'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fce2eca7-f3c5-438b-a72e-84a7f9a2856f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/200mL/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='840ea45f-e1bb-41cc-aabd-84a8e7b379e8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ded0ba85-94d2-4e95-810e-84d2bf0bf511'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f21f071-4bbc-4a20-a930-84e92e1dfda8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|ResLeu:<1E6|Quar:>=4m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='49f33087-1486-40c2-8235-84f5e039d9f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ea1a82d-deb1-4510-901e-8505190b009f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ea91963-e149-4454-9c0b-8507da00c207'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-80C|ResLeu:<1E6|2nd container', [ProductShortName]='RBC AFR Froz Gly40% LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c86f1e4d-eedd-4a3f-bacd-8536eec8e6c3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|For mnf:injectable|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6cd00817-0ecf-4ab9-bf22-855006be6a78'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f40e3b5-2404-4714-8a62-85599dd55fe1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7ce28fa7-6442-4e0f-b5e7-857ad3080329'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CP2D/XX/<=-65C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9350c9ce-fbf1-4233-8334-858c77937f02'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86295cca-9332-4b79-8361-858d5d308f2b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CPD-50 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae8f9cf9-4629-4ada-927d-859d77ab19c3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8fe02304-cda2-487f-b498-85ac4ff815ef'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6f48c9f1-ceaf-4f94-9973-85b8c5890904'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFNI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1c6f1d3-aabe-49da-b125-85c1665cf577'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='880ab7ae-b596-4527-96d1-85c4897e5e79'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ddcd7c6-812b-4616-af27-85d0f28b2c2f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Frozen <=8h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a465329-8471-49e7-a78b-85eac67101b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='89b22ff6-e361-43fb-8899-85ebffceee56'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 3C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='639677df-0cad-4984-9cb1-85f4575c6969'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|2nd container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit IRD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='16532084-5a3b-4582-9556-85fcd73631b8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-E LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f92d441-b864-4c3d-8829-861fbefec54b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6801ee1-d2b5-414c-b2b8-86283e24f844'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6eb6b422-3696-4aed-8cf0-868c24c89e44'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f95e05f5-ebc0-47a7-9587-8695b82a6271'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac8a260d-f479-445e-ab86-86a83f38cde0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|2nd container', [ProductShortName]='FFP AFR Nacit LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd992988-61ca-4e1f-ba6e-86afda921eca'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c1b017fe-9818-472a-95c7-86b6bfaa5f3f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c7385db7-970c-44f3-9d7d-86dfe4335752'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b6a72faf-b4c8-49c8-b343-86f2aa1d6627'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fc850d0b-5ab4-4b43-a163-86fbf9f9d71a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='159e96f3-6eaf-49f2-bc49-870b12eb435c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f62b616-3e73-4534-a554-872d6f01110b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='978bb278-8d93-4b21-981e-873c2c48a53e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4a8e3a48-ffc7-412d-96c4-87595f283ba5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95e824d8-6f6f-4366-a662-877695f5008a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c7bda07d-b8a3-4b85-9fb8-877e65300cba'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b2c2890a-bc58-4340-a811-878955c4e1e0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfb11ad2-1c65-4c62-9736-87991ee81395'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='927a88d7-abab-4686-abc5-87b4c9ee7e9e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b87b0291-7939-469a-ac14-87bf7c858757'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ebe2d846-9f38-4495-a61e-87ed3cd95cd3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1bcf9810-a128-441e-b5e6-880f5b18ab5c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD QUAR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b835cc7-dad0-4696-875f-8818af6e3397'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|ResLeu:<5E6|1st container', [ProductShortName]='PLT AFR Froz DMSO OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6b816a42-8cf1-403f-955a-881f8b5c6a6b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR None OPN LUKOPR PLS Red/ALB Add 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='acf3ae2a-cd51-4a66-b34c-8822b0d54d39'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1f4d7a8-d672-435e-b2c1-8836d847e0c6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='74863ac0-1257-4c23-a653-88576aaef14d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD PA 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85e975f8-5b1f-44f9-8075-8857f46e4a27'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|4th container', [ProductShortName]='PLT AFR Froz DMSO OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7d48c69e-0519-4fa6-bcae-885b107945b9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4c77626-98c8-499d-8e1e-886a24246c61'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='019d8886-a01a-4508-812c-88786b85cb0a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='71d1e040-e468-4dc1-9253-88831cd0433e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='20481cf5-ad2a-45a5-8c65-8883a759165a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3bf8b415-cd48-48a4-8607-8887ddda1f0f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1530131f-28a6-4f6a-83d8-889347d645b8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 4C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4c2b25b-7316-46d9-b96c-88a215281371'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-80C|Open|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dc5959c6-60d5-4317-ad3c-88c5f395952f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bba86f43-08eb-40e7-8673-88cae29673b8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f1ef65ae-ec2d-43e7-8a89-88cc97917a0e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12c47211-3748-4864-aa1e-88d2b45150ed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='61a9439c-2623-453e-8a92-891282cae895'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='52cba171-8377-456b-ab15-8915d6c55fec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='29b1ac58-983b-4b9e-9c73-891d55d8caa5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05db268f-6308-4f18-866a-89256db5774a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac4eb8cb-695b-4b76-a065-893d307d4015'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1d71d92e-0e36-4d5d-ad6d-896c68b8d012'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6aac8ddf-31ed-41d6-bc6f-8985833d5d1f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86ac928d-5b31-4652-ace3-898efb30446e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C|ResLeu:<1E6,WB filtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7c5f3bd-d80d-4041-9995-899b08c678ec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None IRD LUKOPR SR/SD-PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='72a3ad0b-7144-477f-8091-89ae11dc73d3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='602ada89-c03b-4961-b125-89c48f546dde'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='28c4b7e1-1baa-421b-a059-89cd8eac2d73'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg SAGM IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fd6d084f-f7de-4b67-b32f-89dc2f6cb5df'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='350bc9f1-04f7-4ca3-a309-89e5cbd1fe1d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-65C|Irradiated|ResLeu:<1E6|1st container', [ProductShortName]='FFP AFR CPD-50 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d57a7f8-6431-4369-be6e-89e6772cfb03'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b931cfa6-de42-46b9-9f37-89f78e0d2caa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9995263-2d44-4d12-b34b-8a01717bf515'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<5E6|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e72d380c-94e2-40e8-b43a-8a187f222d48'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 NMT LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c070d901-6424-45d4-b733-8a29fe3607de'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e3d2516-0a6d-405c-9f58-8a4c465af6fd'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/450mL/<=-30C|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ddb1e6f8-98df-48f9-a007-8a55d4f21498'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5481eae5-8ee5-454f-877b-8a632b455a2e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='67e4bd7a-1873-4d51-bdb1-8a63be9badad'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8fc0d17a-8846-4676-b18b-8a6972ac142a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C|ResLeu:<5E6|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c141e52a-8eeb-4f28-b5ac-8a71aa189fef'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='be7df365-3431-4dc4-8e1c-8a85e104e7e5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2cdc51a6-0f6b-449e-aaf3-8a8b1e5838a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0579f283-c883-48bd-ad86-8a95ed0c73fc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7e16d9e-a8c1-4b2a-89e2-8aa3580a5669'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq CPD-50 LUKOPR 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9393c727-8b3c-4e18-b6ff-8aa64f199f71'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|Frozen <=6h|1st container', [ProductShortName]='FFP AFR Nacit LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='79b543b1-4da9-43fb-8526-8aec1490e2c1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='08fb91b6-2f08-4e44-a5bf-8aede0d16881'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open|2nd container:not auto', [ProductShortName]='PLT AFR Froz DMSO NMT OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b42264bc-d720-42e3-8881-8af29745720f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17ee8ef1-5cba-4116-a499-8afcc0313748'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e55b2df-d273-4e6c-8e54-8afdc41cada9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a367d09-96dd-4947-9f6e-8b1c3c5b981c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='678f37dd-34db-40f9-b6a7-8b4e1433dae1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c7c4845-e535-4308-8e24-8ba6ad8aaf3f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-30C|ResLeu:<5E6|50mL|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d292add-0fa3-4b53-a284-8ba908b4b61a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd278194-e3d2-4eb7-9fe2-8bbabe78951e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='af52811b-736f-4b02-bfaf-8bc3e293db33'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bef07d2b-fe1e-4105-a153-8be5f28bd5db'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4770e87-c046-4d2a-8555-8bf54d1cce32'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bcfe8cd1-0717-4ae2-8e4a-8bfaee1d05a4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a8e56668-7e97-469a-bb44-8c1a53e2e8b6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ec7498c6-6e38-41e4-a627-8c388f3a8a65'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz None MNFNI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5b608937-6a38-4f29-a9f7-8c3dd391d499'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='CRYOPRECIPITATE|None/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a95841f5-c498-45d6-a0f1-8c40bb8a8a5c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f856957-578d-4a9b-9dc0-8c439d7044b4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='813cda0d-31d8-484f-a002-8c4721877599'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c4fd7d24-915a-4c1b-bc6c-8c500589b7fa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0cd1bdd2-9af5-4727-b357-8c658fb42d9a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f7ddd839-e204-4528-9661-8c65efa50015'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6ffd8011-58e7-46b2-86fa-8c9aa20d48fd'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55422c48-c3e4-45b7-a24e-8ca77539d2de'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Irradiated|2nd container', [ProductShortName]='RBC AFR Froz None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0ad2eaf5-9215-43b5-a721-8cb1484cf14d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6038d765-48f2-44ef-a180-8cb503637b78'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:noninjectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='caf8c12e-7dde-495b-8c03-8cbb88dbe67f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a5f9f5ac-6fd8-439e-a18d-8cd22fbe3671'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e42485dc-6c26-4f95-b61a-8ce49ec1fb82'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ffe9f496-71ce-4ff9-acdf-8d101e15cdd3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f4b0674-d02d-488e-af61-8d29a152c0e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e13044e2-1ed9-4a36-ae7f-8d414dfecbe6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='979ec52e-e126-430a-88e2-8d5644c2aa53'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='970d656e-0f5d-4b55-a860-8d6d1447838e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='93d5c8ca-2904-45ab-b880-8d7aad71050e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|ResLeu:<1E6|Quar: nationally defined', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0e314fa7-b8dc-48e7-ad6b-8d8666b7a308'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED CRYOPRECIPITATE|None/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3caec97f-9265-4755-80d4-8d8c8f673856'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a3df60d-be0a-47b8-9dfb-8d942f59e32e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='621dee8b-d883-4996-b9ff-8da29cb6164d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b3a3868e-a796-43e7-930d-8da975dc68b6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFI 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d375364f-f198-49d0-82aa-8db779cfb81c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 6C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='34786c0e-2d71-4521-9818-8dc5f2a3e6e3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa03c396-8f75-450f-8ddf-8dd1668f886f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash AS3 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='43ba8743-519c-465b-9ec5-8de15c667254'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 7C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d2cc1423-04bf-4a77-bdd6-8deb748957ec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86146d09-40b9-4c55-a610-8df7bb3c0855'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='69abeb79-146f-4d56-a96e-8e0ec0f67d6f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|5th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit IRD 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='047a2208-9261-4002-b0ee-8e11367c53a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-E LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3035f499-0c70-4f19-81fb-8e128ae955aa'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dcff10d9-a82c-4b48-8433-8e1aa3a7589b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='42737b8e-07c0-4c5e-a822-8e4f1637d5a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='db1ab59c-4a6e-405d-b2d0-8e5b0b7dd851'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED GRANULOCYTES|CPD/450mL/rt|Irradiated|8 units', [ProductShortName]='GRAN Pool CPD IRD 8U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7c132d9-824d-44bc-a97b-8e69650d00cb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='38f9bf65-1863-483f-b5d2-8e969b186920'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='26753e6b-559b-4395-86bb-8ea6978ba72f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f12c6397-24b4-477d-ae44-8ea7bd90742c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Irradiated|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75d72c12-4e95-402c-94b0-8ea7c066eaf1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e3f41fb3-8887-44fd-b5c4-8ecc44ff1c72'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8f6c3c1e-bda5-452b-b25d-8ecc9d3bca46'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|ResLeu:<1E6|2nd container', [ProductShortName]='FFP AFR CPD-50 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d56c18c1-e3bf-4435-ac29-8ee8bdb13a87'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|>=600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1723e73-1dfa-4b35-a11a-8ef516a9754b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1b06194d-e258-4eb8-8e10-8ef631232e89'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3c754938-3035-4126-89b4-8ef660295f75'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 4C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e57428d-e789-41c9-8990-8efca23bae51'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f3bbf1ba-29f4-4035-865a-8f022cd3a485'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e517ffe4-f803-40bb-9a50-8f32df9a71d4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD PLS Red/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a876b13-e4f4-4a11-901f-8f43d3ef915e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|Irradiated|1st container', [ProductShortName]='RBC AFR Froz Gly40% OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b6b0a47-efb5-4ee9-aba0-8f46c5b7c044'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15fde0ca-1fea-4c8f-b651-8f4aa2044eea'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='edbe3875-a15d-47c1-8e3b-8f52e81e9a17'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f832523a-4694-43b4-9d18-8fa0b9f40b08'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97e7d8d4-68e1-4138-afad-8fa1446fcaae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR SAGM LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5af742e1-a84c-4bf2-90e3-8faab08b81d7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='958911db-d9ee-4847-a94d-8fc07d5a6da7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='418485ab-9ff9-487c-9469-8ffb15b54abb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fbe33b4b-2fb6-4fd5-81f6-900c39bc9a4d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1fa65e4-3aeb-4ce6-b66d-90151aedbadd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d322576e-e6ba-4ffa-b54d-9023f8ad0d4f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d51bfa2f-5313-488e-ad15-902feeca2a9a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e6338fdc-5c02-4f10-b6ef-9039a32b5d10'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1d71ac20-8946-42f0-88ae-904b586b5b28'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-25C|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c224bb3e-11f9-4353-81a0-905865c5ee87'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4aee6e3a-f309-44cf-8c37-9060d7e4d8a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='893588ae-938d-4e9c-b88e-9066a4ab3117'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C|For mnf:injectable|ResLeu:<1E6|2nd container', [ProductShortName]='FFP AFR CPD-50 MNFI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='137f196e-bedb-4452-a856-906e615c5c4e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|For mnf:injectable|ResLeu:<1E6|Buffy coat plts prep|4 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2127c349-7337-4c22-b8ac-908d9cd14b7a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='77d72b56-709b-413a-b8f7-909254d35715'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee0fe0b2-1ba1-497b-b3c3-9094c163c20e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D MNFI OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5844a186-2410-40ec-bd1b-90ab35c5c4cf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa2b73ad-c83e-4777-ae28-90b9c09a9541'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3bdbf080-1998-4eeb-a625-90c16df98401'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6f1ff58e-23f3-4ee8-9194-90cf90b7609f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|6th container', [ProductShortName]='FFP AFR ACD-A 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6bd76b41-4adb-4da9-bad9-90e1cd67f97e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c73af5c-d8e7-487e-851a-90ea0115f74d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4ef25e19-9ef8-42cd-82c2-90f5cd31f953'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9547fd16-e275-4b42-97a7-91182fe6a609'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3fd75a2d-08ee-40fd-9831-912f11ffcb9b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2aa3cc8-9169-4381-96f0-9147503840f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='709ea564-2e75-44aa-ae7f-917346e426a9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='26b17275-8e01-4a41-b71c-9187b57c7d9b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3f5b6b0-41a5-4bd7-b22c-919157506d1b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fee9a25e-4ed6-4e40-8964-91a5392b2ced'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b425c93b-776c-4acf-b369-91aa551dabfe'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3074df72-0f66-4b35-9c79-91b42d4eab69'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='362f5218-af4d-4ca0-b364-91c10cd5b103'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='74f5e61a-bbf1-475e-9799-91cfa0d29287'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='90695fb2-92bf-4c34-b724-91e13a0ea4f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5157a8fb-a6fc-4c43-92d9-91e56d37e744'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=400mL<600mL|Quar:>=62d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f5d959f-987a-4b8c-8122-92000a8c850a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1462fb5-16bc-486f-a3d9-92159bc8968e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Not for tx or mnf|Open|3rd container', [ProductShortName]='PLT AFR Froz DMSO NMT OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e78e445e-2b50-4197-81b1-921dc141691d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e577be38-38f6-4dab-9112-92249745f68b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b653544d-4441-498a-9638-9237041b3359'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|>=400mL<600mL|Frozen >24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b3afe139-989f-4720-a837-92417b059170'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|ResLeu:<5E6|>=200mL<400mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5613c48-d296-4cf2-8c85-92465d484a29'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='53b24ed2-5bbc-4e80-916c-924c3ce92af4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|6th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A IRD 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0279432f-6f7b-40df-b046-9255e107ce2a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='791e7060-fd07-426f-8e35-92562cfd1bf7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|ResLeu:<5E6|3rd container', [ProductShortName]='PLT AFR Froz DMSO OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='227f2bcd-fc92-4915-9473-9262af7d262a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq CPD-50 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7dfa8aa3-1f4e-4aa5-9d37-9284518ce6d6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-25C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50e6fb03-c842-46c1-b91c-928eb6e2b183'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-E IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='87c9e999-56ab-4fb0-a6fc-929d736ac1c7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='809912bb-e839-4b84-8891-92a6ec37e2d1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fbfa6ef2-f58b-40c1-8711-92acf3247836'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9acd55f6-32ee-4bf9-bc75-92b9408266d4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|1st container', [ProductShortName]='PLT AFR Froz DMSO OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a6f44ac-9137-44bf-be46-92c25006a0e7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=600mL|Quar:>=90d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='292c8bcd-5e5d-4d3c-9248-92de12f7c526'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0cb2bb14-9248-4c96-9aa2-92f5fba02f35'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|5 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='61e01a98-a840-4996-adfb-92fca097b7f3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN LUKOPR SR/PA1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d97dd534-b739-421e-9591-92fde1989cfb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fdb46d66-6d98-4a79-b6fa-930afb3e34db'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb48e972-41dd-45e2-b7cf-933ee24834c3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed7c38f3-645c-49ef-913d-93871ac5176c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='699826c6-cdde-4610-8ec8-93b2988c11c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9138a23d-6bdd-4bbb-86a9-93ea4155bb20'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Rej None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='610c8bbc-3896-4f4d-bd13-93f526ad72bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c989be85-92f8-4e3e-b36f-93fa902807a4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3bb2b4f1-4ff3-4c78-a8a9-9464719228eb'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97fc27e9-9148-43cd-8e40-946b0c8d3445'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6d9638eb-bd09-4f6b-a899-946fcfca1144'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='953c4b00-08a5-48ca-b4c7-947b6effb3a9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg AS3 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f7af412-f833-4f46-a0a2-9480721887f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='57233239-f820-4d2a-b1fc-9485f3019e11'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a579ec7-8c5d-49bb-beea-9487d0212569'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eecdbd05-caa6-4fb2-b56e-948cd3cfb198'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae65ec70-697c-486b-be46-9493039b355e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D NMT OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='957d972f-ba89-4d11-ba13-94b212ec3aef'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bbd4dbe9-4ea0-4bcf-8fdb-94b7f2ea249c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red/SAL Add 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='25de718e-bc34-42dc-b000-94d9339f546f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|2nd container', [ProductShortName]='FFP AFR NaCit IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='11adad87-b981-4151-bb3c-94e72ce66047'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b5ae9a72-2847-486b-9b5e-94f48e0af5a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3c014544-efe6-44c3-9d57-951b49903b78'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN IRD LUKOPR SAL Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae444f46-5259-45ee-9efa-95375773accd'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-80C|Open|ResLeu:<1E6|2nd container', [ProductShortName]='RBC AFR Froz Gly40% OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b75eb2d7-4a4f-4213-8e12-95431df3934b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='54a02163-73d9-4a8e-8b41-955f40dadc66'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|1st container|Quar:>=4m/retested', [ProductShortName]='FFP AFR NaCit IRD LUKOPR 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c847f06-1e9e-4e26-bdad-95902beeaaed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='31efe057-9a80-4e45-972b-9593a51bc96f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|>=600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6cd56ce8-e13d-45b3-a386-9594b501db99'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='af88ede5-f30e-4068-af40-95e4053eb7ec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0992b3a8-1d51-4d54-b23c-95e61a36dc4b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|ResLeu:<1E6|1st container', [ProductShortName]='FFP AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1a6a5e9f-43d2-4732-bdfc-95fa31b30173'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|1st container|Psoralen-treated', [ProductShortName]='FFP AFR CPD-50 1C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bea89edd-0793-4441-bd02-96032626a77a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-25C|For mnf:injectable|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c57f3f9a-7521-41e1-a55c-9607f5f0584b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75cedcca-e11c-44cf-b13d-960923752182'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c901e2d-e953-4c64-b3df-9616756408a8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA Thaw None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d68ddc0a-a325-41a8-8891-9623789fae85'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0c0fccbf-a89f-424f-8dda-96298336c160'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3d8e65da-64b2-4ddb-a73f-964d9b1d8444'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit IRD 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e2f7670-8d02-4370-ac69-9669f0abecd3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Not for tx or mnf', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a48acd4e-49bb-4294-98a1-9676ee64c106'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|ResLeu:<1E6|1st container', [ProductShortName]='FFP AFR CPD-50 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5887a7d8-5019-4af8-800f-968938e4cfb9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/250mL/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50715757-6332-4bee-b293-96939c2be343'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 8C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='19bf0893-0468-4385-8c95-96a1f758b815'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa110c06-a428-4424-bc4d-96b39b2f7c8b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d7425d13-b480-4e67-9f2b-96c196a46fdd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eafb904c-c816-4878-b5f4-97057e813794'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f47b3ec-3bbd-4f38-bc85-97284f573f75'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='604e6f70-61e4-4d83-b474-974287a91b8f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e8b132f7-6e01-4bf1-ad50-974afeab153c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f600d833-1a4a-48b3-af88-9756760efabf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR SUPRed 3C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86f6a460-c399-414f-83a3-97614a7ec990'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa055f0f-6e13-46c7-97c2-9761541de2b6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='03997a8e-a7a3-4804-9955-976a8a3e93b6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ac8f3c1c-f173-4485-880e-9795a8338a49'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e7f7a44e-be91-4bff-9fc0-9796a7328f22'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='30779567-0823-4a12-9a7d-9797969174fc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C Ribo', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8989c84c-74bc-4982-a258-97a40783847f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR CP2D IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d6882cc-2c4b-4544-b18d-97a4be86e611'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b267ce0-ca22-4671-b951-97a83daa1cc9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='29e09539-b85b-4867-9ea4-97abfe987be8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ebb3e7f4-afb9-40a9-a31b-97d8fc4b86eb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f02606e7-1bd4-460e-89e9-97dd301fa844'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2cf213b4-2655-4cfc-b1e1-97dedf772ba1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85962fa6-1f4b-43a6-a751-97e1177296cb'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|2nd container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3da147b5-8957-4b92-af41-98084084382e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 2C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9561a175-fc52-4c96-8d9e-981f434d2cb4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='71322598-6b1d-40e5-944c-9828873b6e26'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='716d9c69-9805-4d14-8d70-9831eea3d2c9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1dfa73a8-c7fc-4598-8725-98352ddfe25f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65818514-1c3e-43ca-b7d2-984800fb8a56'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='33e07775-017f-4953-baa0-98560af044b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1d7fc85-1c15-4acb-be22-986a32f51f50'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 6C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01a08784-04fc-4d57-a496-987c98c26f25'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='adfec4d7-3ff2-4a52-ab00-98a1b058db86'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3d2ae287-986d-4f2c-bcb8-98b8ffeb9f7c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fe2a075e-22b8-43e3-8180-98cb926d530c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4af80350-ff93-4349-8924-98d8d4dfb0af'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='45986b58-4056-4b98-aa84-98da00a7f643'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='18d33287-f04b-44fe-bd74-98efa0a82363'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0d5e2a34-4ea0-4fe9-9e81-990e117d5fb2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bff6119c-5101-4521-b6e3-991ea587c579'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='69c8ff5f-d3a9-4aa1-81f7-992a439921c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cce4b601-7ed7-4e99-af96-994b093bf582'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='885ca279-cd94-4d74-9f86-995db84a2915'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|Frozen <=6h|2nd container', [ProductShortName]='FFP AFR Nacit LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f860e7a-aec2-4109-829e-997807c2b270'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED FRESH FROZEN PLASMA|CPD/XX/<=-25C|Frozen <=8h|2 units|Psoralen-treated', [ProductShortName]='FFP Pool CPD 2U Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='45620c60-a4be-4191-a6a4-998498822dbd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD 8C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7672774f-a896-4eb3-b51e-9984ad0729c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='05e3a4e2-cbfc-47e6-8656-99abdbd7fac5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e8eea9eb-a993-4f75-a2f7-99c4a949606d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a06e3d0d-d709-49f3-b606-99c8b3c8ebfc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fceb5ad0-fd1f-4cec-a78f-99cd058d80f6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 IRD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='391cfb8b-8029-4784-9e06-99dcac90dadf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='83abead1-0fef-4b54-aa98-99e1456c3d56'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN LUKOPR PA 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eabd0dbd-e7c6-4ae8-811d-99e627befa79'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fb658605-d43b-42b2-8339-99e8373f7457'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='914a3e43-f476-42f0-89b7-99fe54557899'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6661db72-eaaa-4e90-b58e-9a008532f3d0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6136bc20-2cb1-40ad-9b8b-9a3771e6c457'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='892f13be-e1e3-4fee-ada3-9a484fb99563'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-65C|Irradiated|ResLeu:<1E6|Frozen <=6h|2nd container', [ProductShortName]='FFP AFR CPD-50 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='77b2a2a3-a52a-451e-81af-9a54a02c15f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A 6C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c41d5cf-9af7-4552-9cc5-9a7795705c60'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CP2D IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a04375ff-8286-4c61-872e-9a7bbe5ead02'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1d639ad-377e-48f5-b482-9a81e55c1d2c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c1259dce-b465-4fbc-bd17-9a8d89ae379b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3a72c686-ac0d-4be2-99a0-9aa1aa2fca94'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR SUPRed 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='11456e2d-bc94-48ef-9710-9aa6fc987386'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8324707b-3f2a-4dd9-8db8-9ab0288cd2eb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c47c7cc2-6c6b-4366-860c-9ac0b297e208'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2684fb93-d4da-4dd1-b964-9aca64889a08'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c0454595-7f60-4d4d-932f-9ad6770260f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='00294712-bbca-4b76-b929-9adff9c5e09c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b8e990a0-5dc8-491d-bd0a-9ae97d796ecf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='91a0996a-00a3-4c36-a8ed-9aeb06b71bf9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='70941920-1840-47e3-bca9-9b0015fa48b4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|>=600mL|Frozen <=6h|2nd container', [ProductShortName]='FFP AFR ACD-A LrgVol 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e614a0d-a045-4676-9037-9b05f295a889'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bacad020-1408-47c8-9245-9b076d766837'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b8a7dd93-c929-4a0a-b008-9b1175bfab92'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a650709f-8e81-4c01-a8fb-9b240768a8d9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='537aa016-e77a-456f-ba65-9b2d90bb8319'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb42e861-2d7a-4d1e-8ab2-9b525dce1d42'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b506bdf6-142f-4eaf-803d-9b5386b38075'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 NMT LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bc420f7c-0ee2-4a76-ba2d-9b718dc504e8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED PLASMA|CPD/450mL/<=-30C|For mnf:injectable|Frozen <=24h|2 units', [ProductShortName]='PLASMA Pool CPD MNFI 2U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27c89c82-0f53-4633-a32b-9b9a8cd8bf06'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED SERUM|None/450mL/<=-30C|For mnf:injectable|Frozen >24h|3 units', [ProductShortName]='SERUM Pool Froz None MNFI 3U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f873c3a-e477-486d-9941-9bb213417186'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ee8a2a1-8a84-472f-99d5-9bb74c7adb1e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='457d67fc-3204-4f1c-a842-9bbde0aa2536'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='79e068c7-4fb7-48b1-b6be-9bd7815b6799'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD LUKOPR PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7d12a058-15a1-4eca-a421-9be40c5b3bf7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 MNFI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d0c40b8e-1ee8-460f-b5ca-9be7e3345f7e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='91979c3d-de86-4a4b-ad62-9c21bf24a6c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ba43481-faa2-4295-aebc-9c32d3612356'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='148416c2-9fd2-4680-a1fc-9c6ae73e1fff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej Gly40% OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50191f0c-f407-4a62-8872-9c6bfa8d2920'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2283e002-8334-4afd-a516-9c6fae334462'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d12586a4-43b0-4c96-9252-9c824b40a42f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d0d11abe-dae2-416f-9d95-9c866221b984'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4127fba0-5abd-41ec-bd89-9c903a3aed4c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a6d37884-0993-4ed6-8f3d-9c93c57d8928'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4327948c-7ede-48b3-9e5f-9c9cb7d07d91'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b620aec8-91fc-421c-a77b-9cace8dc0695'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPDA-1/XX/<=-25C|Cryo reduced|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d53843b-6078-4c90-b8c7-9cad16cb80b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b15a68db-ba7a-4feb-bcd8-9cd29f86c76c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='18ba6405-7cff-4c6d-998b-9cd2e6fb5832'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/250mL/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed93a3ce-7fbe-4f7d-95b7-9ce04d60fb0d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2205992d-bf34-4a39-a2c2-9cea40208856'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='460dff6a-bc84-47c8-bec3-9d193bc33941'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e67bd78a-b407-41a7-ad00-9d2b820a6ca0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6fccc55f-3614-4a05-926c-9d3406769828'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6a4c5a10-94b4-4014-bb13-9d43be8e6432'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='80ec1b75-a12e-46fc-81a1-9d585a737a03'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='13aa43d0-c0b9-480e-aaa2-9d63aecb0ba1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bd612e6a-a21d-43b0-9ee3-9d68cd374a0e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CP2D/XX/<=-65C|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d552aae7-279c-41ff-a335-9d745cba2393'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='520ca0a9-4097-459c-a2f9-9d808ca8a300'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Not for tx or mnf|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d3bf5c1-d4d6-44a8-ac83-9d998c8a07c8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|ResLeu:<1E6|Buffy coat plts prep|6 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca211458-ed8f-4c39-a526-9e0997fffa12'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash SAGM IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c00703a-9da6-4eb6-86fb-9e09e44731a6'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|Irradiated|1st container', [ProductShortName]='FFP CPD IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2b5e5236-3fac-46ac-a1e4-9e1406aa93e8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR SAL Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='78cfdad1-421f-4642-9425-9e1d625dc4ab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b360929c-0345-400d-938f-9e28d5ae2674'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da8ed84b-354a-4756-9e26-9e34628c0451'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5e2d5f93-c955-4375-b3eb-9e3d7f90457d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT OPN 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='10da8778-8eb6-4679-a5f4-9e41d341ce50'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Not for tx or mnf|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2d28426c-5bac-4a17-91d2-9e466ec422e8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|Irradiated|3rd container|Quar:>=112d/retested', [ProductShortName]='FFP CPD IRD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='252632de-877c-4991-80ed-9e628d42109d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9192654c-b7ba-49b8-b4c0-9e7615818517'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8ebc8eef-3a84-4500-ab4e-9e766ac8cef1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce5a28f4-b658-4828-a2b5-9ea0db3f2121'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|Irradiated|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8ea1325c-f488-43d3-99c8-9ea9f230d4ec'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='30027d0c-5c7b-4c48-9e88-9eb00e2e891c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9baa87d3-e38c-4cdb-873c-9eb3fccd6711'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e762d43d-68af-40c8-b2e0-9ebaeb97291a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|1st container|Quar:>=112d/retested', [ProductShortName]='FFP AFR ACD-A 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='73d64176-4ebe-4041-babb-9ebd27127a90'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f345b024-f123-4344-b4bf-9ebef5daa5d1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e629fb11-5e8e-4db9-8a02-9ec4ae21d564'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='36456102-5529-42ee-9560-9ec617e734b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3209577-9082-4047-8f65-9ecd4493389b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e0339f4-2c0e-4b6d-a0ad-9ee1ce965d7c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1139dff5-8d74-472f-a47e-9f14dc156e2d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 2C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7b91422e-8aad-4d75-87d6-9f16ed3351e5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6fca4b5b-51a5-406f-8a3d-9f3853677bdd'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='661ffb72-a75a-40e2-9967-9f60441eda70'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c6848424-8c13-408c-bbe4-9f63cbf0eb3f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN LUKOPR PLS Red 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='01692e74-b541-491a-9342-9f705612cddf'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Frozen <=18h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='70f44788-8d56-4c68-8f4b-9f89a0f8154f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='88e0535f-fe77-4e9e-9a30-9f946f56082b'
		UPDATE [dbo].[BloodProduct] SET [RetireDate]='2014-10-20 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='18e1eace-da5c-41ac-a901-9f9dab6589d6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A MNFNI OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f17f9a5a-e3c6-4041-a99b-9f9dfcdbbed6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1f76a1a6-aa67-400f-a532-9fadb30f2584'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='38525c45-600b-4384-a730-9fbb3e200a50'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD IRD LUKOPR 7C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e64a1a55-100f-443a-bc5b-9fbc0a502f5d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f9fed78-cb06-48d7-b4d4-9fe42a96ab49'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='27e0f56a-0474-4547-babb-9fec5d587733'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59049522-c066-4e02-b9fa-9ffa8a1f3cf2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz DMSO 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5452e337-99aa-4609-aff2-a00091c9cfa6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9a9e43ac-eea5-4169-b88e-a01208287e12'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2fffa5b-9892-4af4-b279-a0194b2a1477'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85e81f6e-72ec-4628-a3f0-a0195f43bb82'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a4d3905-f384-480c-9925-a0211303fddb'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4fe0416f-30b1-49fa-a9ff-a0272f7448d6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ab81fbdd-3f1a-40a2-a5da-a02786287b46'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='240a0d07-8535-4f6b-8ed6-a0390ba3f621'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2a1e1f39-2c43-42e3-94bd-a03f40e3ae89'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bb4f717a-d9b8-45c0-97a7-a041fce98313'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='CRYOPRECIPITATE|CPD/450mL/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca50f8ed-ee4a-4928-b7d1-a0539199c5a7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|Gly40%/XX/<=-65C|Irradiated|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='85d2152a-ff15-4d38-a5c4-a0592d7b10c6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='98e16a74-25f4-4d56-8ffe-a070ad978876'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e532287f-1c5d-4749-8eb0-a07e9df99304'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b03c7ac-15eb-4215-bad3-a08b7b6e4380'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f8fb625f-0fdb-4551-8bf7-a09144728f3f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='91f8e285-9bcc-450d-9540-a0a708fc7434'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bef6ace1-8a46-4fcd-ba97-a0a9542f9d7b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-D LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d0a1ae1f-33c0-479f-aa6e-a0cf85c6d626'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz None OPN IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e2f70d47-367b-4f84-895c-a0f6d83a7851'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd6d52aa-296e-434a-a143-a1009269121c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR NaCit 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ebf909ff-52c6-4707-9740-a106df183cc6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e55cf62f-6f92-411b-b102-a11510e12032'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f45e6b7a-2b13-445a-9c3d-a12471ec4322'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='996e60e8-c5b2-4adb-9d6c-a126d871e90f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b4a0f8b3-ce1a-4625-b4e5-a1277678890c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86da531d-4ad1-47ec-bb13-a12d0694c7ff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c35ab501-d605-43a8-b79f-a13d55c729d0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|For mnf:noninjectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='79cb096d-f838-463f-9d81-a1545ea7398e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>SAGM OPN IRD', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='786939d2-cd59-4b3b-a137-a15ab7bed011'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3cdfc506-a803-4376-8e99-a15b96f5dab4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22b2e089-e366-446b-89b9-a163b1006376'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1bc064c4-2e55-43ac-986e-a164f61b2d5d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d7eb1d3d-e268-4d0b-9693-a173c2fc1bcc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e6258cd1-f447-447e-9d66-a1825ca69953'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR SAGM IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e7a9127-f3fd-45c3-9265-a1b4de6b8ecb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4afa5faf-80e2-4ec4-ad1e-a1ce2c0fb867'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-30C|Cryo reduced', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7782ac14-45aa-44ae-b034-a1cf04a44489'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None NMT OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1306c9b1-feac-4074-b386-a1ded47d0949'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4d6e806d-b258-4a9a-a8a0-a1e255b49272'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c01d1b95-af58-4d84-819c-a1e436fe22bb'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|3rd container', [ProductShortName]='FFP AFR ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7e62ca60-7160-4069-9463-a1fd5c8fecac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg SAGM LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b9ade354-5fbf-4b32-9d89-a210f185beba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65de1a31-6115-4e58-950e-a2186bd671be'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ec0e17f2-a2df-441e-abcb-a21a107e2860'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='311fddd8-c742-403a-be0c-a21fd008a896'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e65322b8-9eb1-4eca-b15f-a22ffe9c755f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-65C|ResLeu:<1E6|5 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f9c658f-3fd8-4b6e-9150-a2366077c34b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|ResLeu:<1E6|4 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f985a58-6c1e-4972-8242-a24c7166dc67'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfcbcfc1-c4f8-4a6d-ac71-a25de3cc6be4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR CP2D 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f97c474-2fef-41a3-b154-a26ea1e79756'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5b167d66-f7ec-4056-984a-a272b5d7dfce'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='361ab527-3a1f-4e22-ae00-a278d68f1ebb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7143cd98-6de0-4796-8b32-a28652526821'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc88cccf-c1dd-4b2d-a172-a28a770414bb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59655719-e535-458e-97b6-a290e234f4da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D-AS3 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d9c1371-66b3-48ec-81b9-a2a51377d50b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a3aeda62-5f8d-49bf-b409-a2a7b8e21cc8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A PLS Red/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8476c0ff-264c-4f14-b1ca-a2ab80ce95f9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 7C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eaa7bc92-2bb6-471d-9aa3-a2acc45ef509'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eadd73ad-58fc-4cca-8cb5-a2b33331aac5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 6C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='af72d752-0f51-424f-b90e-a2b3bdfe51be'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='769ec36f-4d63-4f40-b3c8-a2d64c9b6757'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8a65d3d2-e6eb-4eab-88ca-a2e89c77e53c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8b035051-6406-4a5a-a6f6-a31fcbd8428f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0PORT411-b47f-4802-bf11-a32477c2a8f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2994ac1e-10b8-464d-bb34-a32f030cac57'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR SUPRed 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='34b348a1-2501-45d6-80ea-a344e704f022'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR SUPRed 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='03543bbb-6570-4de4-ad77-a3503515bc70'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04c44538-04e0-4d30-99a8-a362a33fa880'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='41f85d0a-fb7f-4068-a38e-a36e450aa3d4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d14eb95b-2c23-4997-a571-a37097bdce67'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1ac9c26e-a2ab-43a9-92e2-a378e39d71c4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='70579117-28bc-440d-b056-a3863aaa811e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f891673f-0c38-41bb-8df6-a39953023b27'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None IRD LUKOPR SR/Q-PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6395ce2a-eadf-48bd-b17f-a39f798743cf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD LUKOPR 2C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b275e55e-2e7e-4daf-bac4-a3a013b4d384'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a29ad18d-341f-41fa-a5d2-a3b6ae8c9ff4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a086a52e-1dc8-4b1a-b3dc-a3c7b68cc133'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN IRD PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='208fa042-b855-44dd-8213-a3eb2dc41af0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e3c9ba8-6a73-4dda-a7ef-a3eddff77348'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='722ccd7b-df92-4a33-b4e7-a3f1ecd110d2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-65C|Open|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a58bef5d-8b6a-49c7-be28-a40ea898e2bc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5429b2ac-1c89-4fb3-aa98-a41e5296fc8f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c838688-4659-4517-b402-a421824a61f1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-65C|Irradiated|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4659340a-9743-413f-817b-a45358e649d8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1db316aa-670d-475a-950f-a45b4cc51faa'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-120C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60bb2eeb-65ff-4bb9-8279-a475c838176c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4704289-b537-4983-8c33-a482fb281aa9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='edfbbca6-fc53-4576-81e2-a4837e08ebce'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f37c92cb-24d6-44ee-b834-a49406627358'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='08b97899-17a7-476b-a167-a4ae2cb4c03a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f31dab7e-ca99-47c7-910f-a4ba0d1de77b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cc68a689-b79c-4c3e-809e-a4c834781355'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4bd65f03-87b8-44ed-9a89-a4e50d1bc0ab'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9519b87a-48d7-48e8-860b-a4f3b870d754'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Frozen <=15h|Riboflavin-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='17173b52-39f7-46df-92ec-a504a7117888'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|2nd container', [ProductShortName]='FFP AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='261251f3-7f07-4a7f-bbeb-a5092b29dc23'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c07ed49-fcbd-4495-8b1f-a50cacf79b7a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>SAGM LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8c355cda-4ca4-48b9-a320-a50f6f89ae4c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2c8727db-c6e3-422e-bf13-a5164346eeee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62e1fac6-bad5-4020-9e4c-a520c74d5934'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5de038b3-87dd-4128-b7f8-a5368db31714'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='67b974b6-586b-45f4-ae57-a54c4ede1516'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0e50d45-9be3-46c2-9c65-a56da5260978'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5a7bd59-584e-4c72-93d2-a56dd90bf3e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ec21d982-e0ea-4a60-b793-a57efd89ec43'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|Irradiated|ResLeu:<1E6|Quar: nationally defined', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='83d754b6-f3d7-4841-9318-a57fc2957743'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=2h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b9dfcb17-ed4f-4e5d-8b03-a58c18759b76'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='72088eab-6840-42f2-9c6f-a5ad4eead94e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04a0acb9-8c67-4720-a300-a5bd609368bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR SUPRed 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='127b328c-0a03-4b80-87cf-a5ce47a56391'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15019b6a-e81f-4b52-bc71-a5d0507acf0e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='12a84d9b-d70f-4001-8148-a5da9cf09200'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|3rd container', [ProductShortName]='FFP AFR NaCit IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d8add11c-bff5-4937-98e1-a5e3cb5334e1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='503772ce-963e-4b6b-b315-a5fadf7e4613'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e9e3cfd9-9473-477b-9a23-a5fedef02545'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a012bf9d-1ae1-4d10-af32-a5ff4c2c1afa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='174ff07f-19e1-4ee2-a0e5-a6033e0e90ec'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|Quar:>=4m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5fa8bfd8-5d90-4f3a-8f00-a61f80b8ecee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='874038a7-a69b-471b-b580-a624f2f230f2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw 0.5 CPD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15a61afc-fa3c-407f-806e-a62838867e22'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0acf5b91-98ea-4ac7-9c96-a62cd3fa7ce4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cfd4cd2a-2e75-4c76-99cf-a636549f8a0e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='96b142c8-b265-4e48-9718-a63e1da32b90'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 1C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='018aae74-f6e1-446f-85ac-a6552bb51126'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash NS IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='93865c59-ea65-46ab-ad7b-a6654122e87c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7dc87539-e17a-4a1f-b358-a667f5a7c83d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='89af9665-0df3-4a8b-bb4b-a677a6374c9f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0633b0d7-a713-4df3-98ae-a67850f7df02'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='220d73f7-f248-4adf-9ef3-a67dd24bfae3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d4dfe030-d4d5-4682-857b-a689328071e1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7e7afa5b-851c-4b9b-96e4-a68ab0a2cc14'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d9f52aee-862b-4d27-a478-a68cecd91974'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a4a1dc83-b265-420e-848a-a69983c2754f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='93547e7b-18b5-4c18-988f-a69ac40bde73'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='81732b74-2b1d-43b4-9eb0-a6a4d784a13f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9267f493-bb06-4c6e-bb35-a6bb84753830'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN IRD LUKOPR ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99df746a-a553-4192-bf8a-a6cec3ca3895'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f506cc78-9c33-4838-803e-a6daa91abfff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b4bf5cbe-3ab5-469c-8594-a6f09e54c8f6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz ACD-A>PAS-C MNFNI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5be12244-7cc8-4d84-9701-a6ffbc48fc7d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD QUAR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e0677cc-fcfd-41b4-8b5b-a70883c78e8d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='421c9668-3599-4a22-a182-a745f3114d39'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c8159167-fda1-4d4f-a100-a75042cba413'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/450mL/<=-65C|Open|Irradiated|ResLeu:<1E6,WB filtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c462070-6e8b-4796-b4a3-a7622b4e575f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='25d2d292-a703-40be-a37f-a7647b5fc49b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 5C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c3f25eb0-59dc-42c8-b47b-a7665f7aaaa6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None NMT OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='50510f87-af12-4300-a9db-a76d71c99bb2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='331bbec0-da17-48a4-9fe8-a77315a3b17c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fe2a79fa-090c-40a2-9c1b-a7736a0702f4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2984c243-991e-4f20-a988-a779bfd97c58'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD-50>SAGM IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22c4ad49-e7cf-4d04-b92d-a780ae0691be'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a5436947-2e8d-43d2-8d66-a78635a53906'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|NS/XX/<=-30C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bbf5dd95-9e68-4e54-b95c-a7932984f335'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0de86ed0-4fb7-40b7-8e76-a7b41de8871c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6e6bb25b-39e9-4894-a44b-a7d5ae7f430f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d07a4696-e43f-49c2-8ba3-a7e269fbd153'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|ResLeu:<5E6|2nd container', [ProductShortName]='RBC AFR Froz Rej None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04893592-5e1d-47b1-87ad-a7ff1c2f9891'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04fcfe0c-6d0a-4333-93c1-a7ff8079d4c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR None OPN LUKOPR PLS Red/ALB Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86de7a6e-2d51-45b7-9e4b-a801e17a449c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-30C|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ebfb222d-56bf-4ce8-a3db-a82103b8105b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='76c90f1d-04e1-4df3-a9f8-a82634cccbc4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA Thaw None 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='08065650-fbee-4d67-9ca6-a84db600bfe5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|ResLeu:<1E6|1st container', [ProductShortName]='PLT AFR Froz DMSO OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cfddfd2e-d14e-4846-98a8-a856f133c35b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|For mnf:injectable|ResLeu:<1E6|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e7f25a1-139d-4795-83c6-a86b89a2e9a1'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-30C|ResLeu:<1E6|Cryo reduced', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4bd51b93-b91e-4130-9f64-a882c95a7606'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5c9fb45f-b3c5-4a4a-87de-a899d02566f8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4cbc5013-f0bd-48f1-85d9-a8cffcbb7c03'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red/ALB Add 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04b583e0-6527-4d82-97d0-a8d341f4c8e0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1c1fac3-9078-46e7-85e2-a9234289ba35'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='66b577b3-3e93-4d00-9d27-a93ab98e77fe'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2be475f-b243-4b2a-8bc4-a94dcc024e22'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='39199341-57c2-4e55-9365-a95654869fb8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d31474cc-ce9b-4dde-bdf3-a957f1186fed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='63f0177f-8bb2-492a-9585-a9600ae8dc9c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='070ff18c-3396-4dc2-bb5f-a98c982ab5da'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='98b37b66-973a-4067-a290-a98f481710df'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR CP2D IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7c8d050-ddf6-4987-a87f-a9966dabd5ba'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b3b6cff8-bf3c-41f0-9dbd-a9b9ef75d484'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6857b774-7322-4d6f-89b2-a9bc44091762'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NS/XX/<=-30C|For mnf:noninjectable|ResLeu:<1E6|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf7ccf8d-5afd-40e7-a987-a9c3336eeca6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='93fd2f3f-60ea-4bf0-b55b-a9c6dabc6a78'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|For mnf:injectable|Frozen <=8h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='436aac2f-a0f3-45df-b8db-a9cbb7b37c7d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b4cf3e2c-c0f8-4631-9167-a9f044fa82e0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b0355af3-f0cd-4118-aafa-aa02c73bc1d9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='45ebb88c-9b70-4f60-a083-aa2ba6f38ef2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 3C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd84a79d-6eda-4cd6-9c0a-aa47fec6550d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit MNFNI 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b636cd06-e1df-4d17-92a8-aa4fbf01ca10'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='515ec447-faa9-4484-a382-aa517b9cf75c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-25C|Irradiated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f8fb11d-5a65-447b-b82d-aa68231758b3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='310dc721-bdd8-4f33-b9de-aa6ac6df4af5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0d25c8d-13be-47ee-a65c-aa7601295610'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|2nd container', [ProductShortName]='FFP AFR ACD-A LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6bebc89a-3088-4302-b8d7-aa7c0b967da6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='856842f9-8626-460c-8a4f-aa80493b2683'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='36e6b16c-826d-48e4-9dcc-aaa388731ff4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 OPN IRD LUKOPR ALB Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='11c377dd-58f0-42f0-bc5b-aaa645665dd0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|Not for tx or mnf|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='15245415-6e28-469c-a099-aaa8f8fa620a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|<200 mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='393a3721-4cd4-4650-89a3-aaba7965d481'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|2nd container', [ProductShortName]='RBC AFR Froz Rej None OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4030e7ed-76ec-45aa-819f-aae1b203a8f0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-30C|Open|ResLeu:<1E6|2nd container|Psoralen-treated', [ProductShortName]='PLT AFR Froz DMSO OPN LUKOPR 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='70df6913-f782-4204-a5b9-aae74d6285b4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4d3cdec0-932d-4214-8583-aae95a45fb31'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 4C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d5bf573-6c35-4d0c-9ef6-ab0a95a81fa2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/450mL/<=-120C|Not for tx or mnf|Open', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='792382a4-d6f6-41a8-8fc8-ab2371608487'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5a6637ad-9832-421e-afc4-ab707e38c407'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Not for tx or mnf|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1b68519-7b8d-4944-b2e6-ab778c0714f0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='840b41ea-7dfb-436c-ab90-ab89ca5d6930'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='94901133-cb7b-4686-87ae-ab8a82088385'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|Open|Buffy coat plts prep|4 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cf5477a7-6fad-4b32-a859-ab9b3e8102a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f979dbb3-5342-48e3-91d1-abb0f56c1a00'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|ResLeu:<1E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='35d7588a-8249-43ea-bc0c-abde4e919425'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f29f50ad-0484-4cf9-bef3-abf6c26dee28'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='415c75b6-fdd9-4caf-928b-ac0d1ac1adc3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c4ac6354-e893-4a71-a508-ac1057976e72'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D-AS3 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0a16b675-31bf-4973-905f-ac1737ac6cd5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 1C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dec26bdb-4c0c-42f6-823d-ac28c80576f3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Thawed PLASMA|CPD/450mL/<=-25C|Irradiated|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='42f0dddb-f2cb-4dcd-a257-ac2a2a083777'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='42578a5e-3b7e-4c5b-a297-ac2fe4884c80'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f385b2fd-4d20-405e-b992-ac5da6cae9c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CP2D IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e0ed8308-b825-40b1-b1a2-ac77b5a33fad'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f399bf1e-f0a3-4d31-8f21-ac7d57dc28f9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED GRANULOCYTES|CPD/450mL/rt|Irradiated|Plasma Reduced|4 units', [ProductShortName]='GRAN Pool CPD IRD PLS Red 4U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='23be97ac-a34a-4f02-8ade-ac8f2f642d04'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS OPN PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e1e1cd03-1cf3-4e65-87c5-aca951d2266a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c4ab25e-6cf3-45a8-9b7f-acb265685685'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD IRD 1C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2223add1-1272-4d23-ba1e-acb3d464e7fb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='21b76716-0082-4183-8c3c-acc169697097'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='92ad5cff-4959-4095-8f2a-ace17f557fe2'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|<200 mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1351032f-2f89-43f1-87e0-ace8c8265240'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 8C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f17038c-5752-4a3a-ac03-acf7b09dd07f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8952c799-7c65-4df2-bde8-acf92226e49d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3d9a084d-b77d-4648-924d-acfe242e5728'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|Fin Con:NS|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bfb2bf86-883d-4fa1-8f0d-ad1fddd5c645'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97849743-1d2a-45d2-879f-ad2252886f4c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD PLS Red/PA 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aa7ce910-04bc-4795-b825-ad4c94850497'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd919ed6-28c7-4f41-9185-ad52b5da10d1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3f3ce607-4410-49f8-a7ec-ad5443c5bc11'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='46f905d6-5852-470c-abec-ad57b384507d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65ceecd9-3cd7-40af-8d34-ad84c275c672'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca844eef-fec8-4512-8c60-ada28012b1b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c11740a4-0be2-458a-aa1b-ada3125256db'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='54ff17a0-9ffa-4ea7-90ee-adb610c4b12f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d9cc4d09-87ae-4e0b-becf-adb7a09c6614'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-25C|Frozen <=15h|Methylene blue-treated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aabceade-6205-44f1-91f6-addbc3fb5ed2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B IRD LUKOPR 1C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9bf54aac-4c32-4750-83c5-adede76a988d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ad4ce9f2-65c4-42b7-8e5c-ae0b9e30a2a3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 8C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='31a6833e-5da2-4f25-8a38-ae5873442d21'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Not for tx or mnf|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='65c0647a-530c-42b9-ad4a-ae5f93ec72b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6eb655c3-8336-4d88-8d67-ae66b0699de4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5700311-32e1-4901-a0e0-ae69d3099432'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c45489c5-4530-4d53-b00a-ae69e57be91a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|3rd container|Quar:>=112d/retested', [ProductShortName]='FFP CPD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9cd476d2-6241-4222-bf7f-ae6f8b017038'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='92be95a6-6954-428b-af6a-ae705c8d73f1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4c499fda-27d1-4ebb-9eac-ae707ddbf578'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='43f0c3c6-c190-498e-b3be-ae72635e50c5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='64ad2874-1efd-4a56-ae47-ae756790d178'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c8011fd5-225c-4328-8c62-ae891ad9679e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e9a25268-365d-43af-b920-ae8970a8504f'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='59fac7ee-45dc-4d9e-a4bc-aeb644789cf9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D>AS3 LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e7991b0-bbad-4a50-9559-aece0da04a9c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red/ALB Add 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b7b82f4b-2c42-4e06-8a6d-aedff3390c93'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5eb6fd71-aabc-4de9-b72e-af010e9da8d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 NMT OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0c51a2de-c67c-4c91-b956-af173d4ab735'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CPD-50 LUKOPR 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b6735782-bfdc-493c-8a6f-af24dd4c3881'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 3C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f5e8d6ea-b7ef-45cc-a96a-af291800a55a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='82544b74-2f0e-4cd4-8f8e-af29deb9e0ae'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 6C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bc9e1fa9-2eaf-4a6a-afef-af380c969500'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/450mL/<=-30C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='92e0755e-1bf2-47ca-b238-af43f1e1dc4a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-D IRD LUKOPR 1C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d79d78d4-70b1-4d1e-ad6a-af559b93b707'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='995e9d39-8ecf-40fd-b58f-af62d2d62439'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A IRD 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7fbb355a-77ec-4b1a-8662-af97086e42db'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|ResLeu:<1E6|Buffy coat plts prep|5 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='252d239b-67cc-4dd6-afda-afa56b5be229'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e247b85f-fe38-4978-b206-afcaaeb6ae48'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d45fdc53-a0bb-474f-bcca-afcf23e40867'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='84f35c52-b920-4741-8a33-afd2dce4bc4a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|1st container', [ProductShortName]='RBC AFR Froz Gly40% OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c7a04ac4-7a43-45a2-bea7-afe2d06a7d25'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-25C|2nd container|Psoralen-treated', [ProductShortName]='FFP AFR CPD-50 2C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b16fae06-a2e1-4ad1-9e90-afebe05eaef9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A MNFNI 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7f4d1be7-1426-4668-b84c-afff667058b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c8fd2a08-166a-4e9c-881e-b0045b9c148c'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0f9dc254-4377-446b-af84-b006728f6e9d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD LUKOPR PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ba987be3-6db9-41cc-9afc-b00961a7b7e5'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|5th container|Quar:>=112d/retested', [ProductShortName]='FFP AFR NaCit 5C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='55826e89-b3f4-4ea8-a614-b00aeb034981'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='PLASMA|CPD/450mL/<=-25C|Frozen >24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7aa5d34e-cf7b-4957-a7f2-b00c1b47d801'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|>=400mL<600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='83a9db89-df11-4f8c-a9c7-b02c15b436b0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='53ce0a4e-49f0-441b-b486-b02e438ad2a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e5a0e829-3c5c-4b5a-9b80-b036e255a83e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw ACD-A IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4582a2d6-a073-4dc2-aa28-b0557b4399f3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED PLASMA|CPD/450mL/<=-25C|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='329fcd8d-f2d4-4121-b57a-b05e48f2aab1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq 0.5 CPD IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c7e7016-6215-4cda-b394-b05f741aeeea'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A PLS Red/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b8ae4e5f-f0df-4d64-aabb-b06a31ca50e6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None IRD QUAR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='23593a8f-6d9c-4cb3-aece-b0759570b192'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='51b971e3-a492-45da-99d0-b075cbd806d3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bf2f4ba2-8702-4b90-a67c-b08259adc893'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-65C|2 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e87c400f-5631-4a72-b904-b08a9d8289a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1e1f5aa8-90f9-4d47-8101-b0941dd9e085'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3032e2b1-a780-4b1f-b531-b0a1112ae9bf'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0c8a7884-d41a-41fb-b421-b0a331cec185'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='215817d1-f2f3-4f9d-801e-b0a76b349fd4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D NMT OPN 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='16f5f371-a010-4c4b-9f96-b0aa9543d3d5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 5C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bcc2891b-59ba-4ba4-bf78-b0ac3348c379'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0b2e420-2f70-4905-bb83-b0c24a9dd719'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash PAS-C LUKOPR 4C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60384ba0-27cd-486f-a69a-b0c80ed3c45f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw CP2D 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fcb63af4-2954-4d5b-b07f-b0cb4575ab1d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Irradiated|Aphr not automated', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4b4484be-3e51-4d59-836f-b0dbd028ca27'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ef956baf-5df6-4681-a96b-b0ea6ac924ba'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='709909b1-ab6a-4a9d-8637-b0ec8d437f0b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR PLS Red 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8fc8e4a1-0a5b-4e50-b9e1-b0f417d71433'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a00acc09-60a8-477e-94c0-b100b84ee11c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NS IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6c5b08da-9bb6-4996-9c95-b10c7fb630b1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='191f633a-f1dd-453f-8baa-b10f0fafcba8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None LUKOPR SR/Q-PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b8015003-94e5-4063-93ea-b1143ba53b50'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='42c318a5-94e4-4c58-bffc-b129f3373f04'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='379f237e-115d-41a8-a1f6-b12c17a78985'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a48d74c5-6733-461c-9aa1-b152c7f46a21'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f56664c6-373d-4a2b-8913-b15df13790f1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09c5654c-c5f3-4b00-921d-b16917826819'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c95f0f58-63eb-472b-ac70-b1814fa32053'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-D LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f334487-1c28-4698-a2e1-b186553ef65b'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='84b6a57f-ed2a-4929-b66e-b1987f737256'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='78311f3a-9725-4ffa-893f-b1af845f0bbc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5409760d-8592-4e56-828b-b1c0f0cf660d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 MNFNI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed3b746c-0a38-4459-a862-b1ca43dd90db'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9b708b3f-bf2c-42c8-b74c-b1cb9a4fd549'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c45873c6-534b-4d60-a56f-b1cf6e6be061'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f02d0796-2248-42cf-9dcf-b1fbd596acd7'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Thawed PLASMA|CPD/450mL/<=-25C|Irradiated|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2055cd2e-1a75-4b1d-9c3e-b20811ec3b10'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a93ea18b-ce7f-495d-98fb-b2287090330c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D-AS3 IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e906a86-211e-4e4d-afbb-b229a51831c9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-B LUKOPR 4C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9239761e-b195-4d88-a660-b2446e4464fa'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD PLS Red 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3c0c2373-36ec-4417-bebf-b2471ee6a835'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR CP2D 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c9795fe7-47cd-41f6-962d-b256c27c8cfd'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D IRD LUKOPR SR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9f1b71eb-a5e5-488d-9676-b25cdabbbcc4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|Gly40%/XX/<=-65C|Open|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d45afd09-ab44-4a0a-a4a8-b27f6affae8e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d19d1fd1-f813-4c6b-8b75-b28265337d70'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c6337de-fc6f-40a4-bdb6-b283823ee47f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 6C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a10f09f5-d707-493b-8564-b28a60d4f298'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='085f9d60-d696-4300-be64-b29fd1ef733b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='289ea5dd-3623-430b-a819-b2a7658499dc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|<200 mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eddd5ac4-78fb-48f1-9161-b2a7f40d4954'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B NMT 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='21c12a1a-8184-4d40-99ca-b2e0f81d4b1a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0996ac40-bece-401a-857f-b30448e20c52'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b1afb387-0b54-4e56-b91e-b30c6248c662'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Rejuvenated RED BLOOD CELLS|None/XX/<=-65C|Open|Irradiated|ResLeu:<5E6', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5e8af5f0-d3a9-4349-8900-b31eeb42c554'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='6d545345-77a5-47fa-ac89-b341f955eb23'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz DMSO 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5bebe127-05c1-4a80-b132-b35177cdacf1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPD>AS1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='56e08225-260f-4017-aaf8-b352fc8c3369'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='64d7fc0e-6bf9-4c35-9abb-b3537b3c9d96'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='14a0cfd5-0984-4996-babc-b37884459ced'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='590ab89c-3e4f-4690-9fb4-b37d6d68383a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='30562b5a-0d22-4f5a-98bf-b3a42f63bef1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Froz Rej None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ac19c66-15df-4efb-8526-b3d276a70ad9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C LUKOPR 1C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75b0ed4c-52f6-4969-855a-b3ecee88a33d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C MNFI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cb79c708-3c1c-49d1-b6fa-b423a9f0a1dc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2694b8b2-c459-47c2-9969-b464abf175ef'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Irradiated|>=600mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='33ccd329-420c-41a3-a1bc-b46a422952b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0200b4a-749d-4779-a080-b49bb36e4806'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit PLS Red 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='57d8f341-b352-464e-8cc7-b49c03298d00'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f6651068-afa3-42ad-a34d-b4ea42652ef4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7c270a19-c6c3-48a6-9c08-b50b1ebe3e37'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cd3164b6-1dae-4a71-9071-b512ea5f23f3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2af433d0-168c-4887-b102-b51843fd9bcc'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED PLASMA|CPD/450mL/<=-30C|For mnf:injectable|2 units', [ProductShortName]='PLASMA Pool CPD MNFI 2U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ae288e7e-2fea-40b1-b3b8-b5364ebc6da1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN LUKOPR 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='204bb781-a991-43db-9010-b5515af7d7c6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 2C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3da523cd-69f8-485e-9fdf-b56fda490eeb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dfa9e3f1-1d88-4eeb-b4aa-b57f3f8ad0a7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d2c9e08f-7d6c-4a8b-a4d5-b581123e386f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw NaCit 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09ca4788-5094-4110-ba01-b5aba7a46165'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='19a94be8-0c7d-4266-b137-b5c70b44bf1a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/XX/<=-65C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='82d1b7e6-2d8a-433e-a53d-b5d07ef5f017'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5b00a23e-d589-422b-aa2a-b5dce274a7be'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='988b877c-1e41-4475-83aa-b5eaee1f0977'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD LUKOPR PLS Red 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='37eaf440-df16-4d43-92c4-b60b161cebc4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fa498ab5-6127-492b-9d14-b64a97a01c67'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='POOLED PLASMA|CPD/450mL/<=-30C|For mnf:injectable|Frozen <=6h|2 units', [ProductShortName]='PLASMA Pool CPD MNFI 2U', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='34301f1b-e71d-42a6-9303-b68f9b0e77e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8d3ed716-6e7e-4062-b8ed-b695b78eac97'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPDA-1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='19d9b00c-1899-4026-b0e6-b699e0ff0fce'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN LUKOPR SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='afd9036e-3b2f-45f1-b7bf-b6ac455d6e82'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4972f452-775c-4198-8ccd-b6ad435e973f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2af0c3c2-cc1b-4204-9b7c-b6ae31983aa6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c6dac27c-3774-4d90-b9a6-b6ba7a95b4f7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 LUKOPR SUPRed 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8053e90d-a55f-4cd2-857d-b6f522b85b2a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bacf6c7e-140c-4316-81e0-b6fa5300d4c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1fda9449-1ef1-4624-aa4f-b6fd8d15fbe6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPDA-1 QUAR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2e06c428-5ccd-44b4-9f11-b6ffe4da973d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e824c684-451b-40ef-961d-b703fc672e80'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d6f5c50f-e3d5-4e36-af19-b71331beea24'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Not for tx or mnf|Fin Con:NS|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9edca461-c907-44c8-bf6e-b72d2f2d4318'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Irradiated|1st container', [ProductShortName]='RBC AFR Froz None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75a131f2-85cb-4ea0-96f0-b741cbd7519d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Rej None OPN IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c64db419-7208-4c08-bdaf-b744509cf5c0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a57eefbd-d6b4-4c87-a0d3-b7523038c81f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A NMT 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a2c0c516-37b4-4f8a-9a1e-b75768791ceb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A OPN IRD SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='22e5e51a-935e-483e-b5eb-b7721abe8340'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Froz None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='08e9224f-7a64-40fb-8bfb-b78929caa5fb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a1c142b3-f537-4eb0-bb1c-b78cf09bf1b7'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d53887a5-ba12-49db-adf8-b7981b5bea06'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw None LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='40e2bceb-be3f-40ee-96a0-b79bc2dc0cd3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D IRD 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='077eb07d-bbf5-4258-a890-b79e36f09d43'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-25C|Not for tx or mnf|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d3fdaec2-7a8f-42d4-b25c-b7dc3a849e86'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-30C|ResLeu:<1E6|>=400mL<600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='21a23093-bbd8-4857-8144-b7e57b130508'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-65C|Irradiated|>=600mL', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce077d8f-848f-472e-87e7-b81ce8d8ce36'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR None 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d03d5eca-33f9-4144-8102-b841f689b4e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A IRD LUKOPR SR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='763a1d4c-2681-4c98-b6ce-b84699db985e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-65C|6 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='aebc3319-9c01-4dca-9adb-b85f1fcff342'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 OPN IRD SR/PA 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9c4b907d-38ec-4445-afe6-b8716db9b461'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='95a50161-0365-485c-b9b9-b8a3f1ab3131'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN LUKOPR 3C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e3456a79-2956-4e94-a633-b8afd2d14b74'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7be56c5d-0770-4b43-a37f-b8c01b0566b8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 7C BacMtr', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='551c1144-fa9b-482e-PORT-b8c532673f5a'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-25C|Frozen <=24h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='395c8cfa-7223-496b-b342-b8ced9b2bcbe'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-A/XX/<=-25C|Frozen <=6h|Quar:>=112d/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fe3de465-bde8-4ac1-81f6-b8d987dd2561'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Wash None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ce0df3de-66ee-4014-9833-b8e48730a6a0'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E LUKOPR 1C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='75746a8a-6a15-4daf-992a-b8f5f29b7a36'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 3C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9d1615be-a5ef-4a8e-aba6-b8feb9aa6fc3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw CPD-50 LUKOPR 1C Psoraln', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='97dcc505-7eac-4952-9b93-b912b028409d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='da228981-31a0-45f5-9e2c-b92ccf1b22c8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 MNFI 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0cfea8df-8c47-48b2-b8b1-b92f32090cf0'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|CPD-50/XX/<=-30C|For mnf:injectable|Frozen <=2h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='71fb98f9-af79-4aa6-975a-b92ff2aba250'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 IRD LUKOPR 1C', [RetireDate]='2015-04-07 00:00:00.000', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c20b14a2-146c-44fc-b484-b93f03372e79'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='865db562-3212-487f-b4ce-b9438551c74e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Froz ACD-A MNFRNI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='40ccffa0-8e5b-4d38-a384-b9669de5a2fb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CP2D LUKOPR 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2c95be11-d598-48b5-a3a7-b96bb2c9d073'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD LUKOPR 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='004517bf-1569-4301-afa7-b96e02314dc9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP CPD 3C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3ef99c77-7167-4691-beca-b96fa4743e53'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f9fce48c-db26-4a03-b74c-b98ab3f29f09'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS1 LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ff41fb5-a5cf-4a46-bbdb-b996f5d5045b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS1 OPN LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='190dc063-7059-4394-8810-b99978097912'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit OPN IRD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2744a47b-ce0a-45d5-af69-b99f5fcdc0fc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e97977a8-b93b-4922-bc7e-b9a207e0a882'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Not for tx or mnf|Aphr not automated|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3588499e-907b-4e91-9112-b9a388bfafcb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Rej None OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d1370b4-ed27-499b-a316-b9c7b99a303e'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-65C|Not for tx or mnf|Fin Con:NS', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='28bbf6cb-1974-4631-bfd2-b9da07e8eeff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0b1ba3b3-a2ac-4203-893a-b9e60d0082da'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-25C|For mnf:noninjectable|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='69562e77-67de-4c16-9f76-b9e7a865a03e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='beb9a33d-28a5-49b0-a7ee-ba23d5b20125'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw CPDA-1 IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d26b9fd2-7daa-4bd7-b767-ba2e30553bc5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2b478fe8-9513-4ee9-a9f8-ba2f01f7a627'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='04e3688d-b99c-47a0-b78a-ba64820a45b6'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A>PAS-C 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b4c8632f-8455-470b-9654-ba692a29f749'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2b6f4e4a-cac6-4364-8afd-ba83340c1695'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg Rej None OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7fe26723-3412-4028-a3b7-bae19cb59484'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPDA-1/XX/<=-65C|2nd container|Quar:>=112d/retested', [ProductShortName]='FFP CPDA-1 2C QUAR', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='47078ada-48e8-46e1-9d76-bae70d0ed4d3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a93de30c-bde4-4f58-9a16-bb070491262b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR Thaw NaCit IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7a993cfc-93bf-4e07-a69b-bb234ad9ecee'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='60d57b88-a178-4a1d-802b-bb3ce6f4d1a2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9e480fb3-8c39-436a-b5c4-bb54a67dd3b4'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D-AS3 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='3e5447ed-96f1-43e4-a6bd-bb58d47e203e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4cb4f9b3-72e9-44eb-90df-bb5cfe8100d2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-C MNFI LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2f41d463-8e01-41b8-af7e-bb6747f8eeb5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD IRD LUKOPR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ee032aee-ba45-4332-bc94-bba3a02c2ce9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='WB CPD LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='86108c87-a876-4020-a8bd-bbb3332bde15'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit LUKOPR PLS Red 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='06f1e348-d673-4f05-8f2d-bbcad5731286'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ec9f256-b3d1-4e12-9d05-bbdbb47966f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Liq 0.5 CPD IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='fdc9fe69-315b-4362-afd3-bbdfe187b8a1'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None QUAR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='9ad82e85-4693-424a-80b1-bbfcb1723489'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 MNFNI LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='dd1fac0c-0999-4486-9ab2-bc07d3cb7620'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw ACD-A IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='965d2e94-64a6-4f66-bde1-bc0a41bd4733'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None QUAR 8C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2cddceb2-e259-4a15-a707-bc342b02dfd8'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-65C|Irradiated|1st container', [ProductShortName]='FFP AFR NaCit IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2c2565dc-f7cf-4fb9-b747-bc57b930874d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d1ca4ce8-cabb-4c79-94cd-bc6ce268f835'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD>AS5 IRD 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='62d3b321-4029-452c-9221-bc8abeb31b6d'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4e0da6d2-5601-40ae-b72e-bcb67f87fb21'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|ACD-B/XX/<=-30C|Irradiated|>=200mL<400mL|Quar:>=6m/retested', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7691ab2a-7fb3-4c3d-b861-bcb89c09106a'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B OPN IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5f8598e0-9c92-42fb-8333-bcbdac4c4ed5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b44ebf1a-d3a6-4791-bbe9-bced6a28233b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLASMA AFR Thaw None 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='99d20d68-5cc9-47b8-9d0d-bcffdb3c612b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR None LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a42df799-cf2d-4259-b4fb-bd271f2469c4'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|ResLeu:<1E6|>=200mL<400mL|Frozen <=18h|1st container|Methylene blue-treated', [ProductShortName]='FFP AFR NaCit LUKOPR 1C Methyl Blue', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f310059-c005-411f-b2aa-bd2a92a21eed'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 LUKOPR 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='1c52a550-6703-48ed-8aa1-bd3c3a91ce96'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR Deg None OPN 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='4f0cfcfb-fbc0-41de-9156-bd403385c39b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d9ddae2e-3003-4222-bd31-bd562138e422'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPD LUKOPR 5C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='2976fb4f-cb18-4ea9-ac22-bd60bff6e02b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ca663fe2-925b-41e4-ac38-bd7af45aaf35'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c1da973f-8cd4-4a51-949c-bd7fbd676cd5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP AFR ACD-A 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5ab45191-4725-483c-96fe-bd91df24a771'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CPDA-1 IRD LUKOPR PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a0ab1a2e-5072-437a-9c7b-bd9da007bd1d'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis PLATELETS|DMSO/XX/<=-65C|Open|Irradiated|ResLeu:<5E6|3rd container', [ProductShortName]='PLT AFR Froz DMSO OPN IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='0150b4bd-bba2-4be5-be94-bdb3ead37ff9'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D OPN IRD LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='41f2afdb-09cc-4454-b1ce-bde36ba7faeb'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Wash None OPN IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='cddb33ea-812f-4f26-911f-bdea4cdca30c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A IRD 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='eeac0321-41f4-431a-8bc6-be0449805ad8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b69ae40f-13dd-4611-8aa4-be0a6a2b5021'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC CPDA-1 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='41ff3394-1266-4bb0-86e3-be0edaf18a50'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR PLS Red/ALB Add 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='5d3cb176-9c0a-49f1-a657-be1398b4235e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Wash None NMT OPN 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='060d9201-333a-43d6-bfb5-be18e022e610'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen POOLED PLATELETS|DMSO/XX/<=-80C|For mnf:injectable|ResLeu:<1E6|Buffy coat plts prep|5 units', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='e415dcaa-af0d-4258-b918-be2177287b07'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-65C|ResLeu:<1E6|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7cb7ab29-f09f-428c-9c44-be32841e53e2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A LUKOPR SR/PA 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='88478402-016a-4cba-a821-be34cd0279b2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP Thaw None IRD 1C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ed71d383-4b81-48d4-b1ce-be42122326e8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg Rej None OPN 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='f0520546-e3fa-4d6e-9cd7-be98eb6c701e'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR PAS-E IRD LUKOPR 2C BacTest', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='474a90c8-5945-4317-9678-bea7f600e0ff'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR Thaw DMSO OPN 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='c4410a0f-373b-4c77-b1d1-beb3c3f5d4f5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='FFP None IRD 6C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='52fe2aac-d9dc-42f6-ba90-bebc232e8ef3'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='FRESH FROZEN PLASMA|CPD/450mL/<=-30C|Irradiated|Frozen <=6h', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='b002e6ca-1cc3-4594-af80-bedfea524fc8'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-B MNFNI OPN 1CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='43b7993d-1c3d-4cf5-9d90-bee6601ed1a5'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09910835-ffe6-4915-9116-bef6e43e940b'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='8879f690-4a93-4829-ace4-beff0f433126'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit IRD 4C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='d008631d-d980-4307-84d6-bf0a975c9aa3'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR ACD-A>AS3 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='084f0d33-5a0c-4436-a872-bf19354c0ccc'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR NaCit NMT 2CNA', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='ecbe64a5-bd81-4453-bb24-bf1a1ebafa62'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Frozen Apheresis RED BLOOD CELLS|None/XX/<=-65C|Open|ResLeu:<5E6|2nd container', [ProductShortName]='RBC AFR Froz None OPN LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='bced81ad-f4d3-48e4-9933-bf6c2823db3f'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC AFR CP2D>AS3 IRD LUKOPR 7C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='167edfe5-8bb8-4723-b315-bf6e38d6ced2'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='PLT AFR ACD-A OPN IRD LUKOPR 2C Pedi', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='a8d494ac-4fce-4718-840d-bf7331e2f82c'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD LUKOPR 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='116129f9-ffa7-4a6f-9840-bf8d8ea0e1ac'
		UPDATE [dbo].[BloodProduct] SET [ProductShortName]='RBC Deg None IRD 3C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='09fb04d7-e24f-4d7b-a610-bf92b9008cd9'
		UPDATE [dbo].[BloodProduct] SET [ProductName]='Apheresis FRESH FROZEN PLASMA|NaCitrate/XX/<=-30C|Irradiated|ResLeu:<1E6|>=200mL<400mL|Frozen <=6h|2nd container', [ProductShortName]='FFP AFR Nacit IRD LUKOPR 2C', [LastUpdateDate]='2016-07-27 11:17:06.000', [LastUpdateUser]='DNS   AdupoK0' WHERE [BloodProductGuid]='7ca6c4ee-b9db-4062-afe1-bf9cfa35a0b1'
		UPDATE [dbo].[BloodProduct] SET 