<?

	Class FileValidator {
	
		private $num_error;
		private $valid_file_names;

		function __construct ($valid_names) {
			$this->num_error = 0;
			$this->error_msg = '';
			$this->valid_file_names = $valid_names;
			
		}
		
		function validate ($file_name, $tmp_dir_unzip, $validation_result, $service_type = 'VRSS') {
			
			
			$new_file_name =  strtolower (str_replace('_', '', $file_name));
			$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
			global $file_upload_report;
			$_SESSION['service_type'] = $service_type;

			$msg = '<b>' . $file_name . '</b> -> ' . $new_file_name;
			$file_upload_report = $file_upload_report . $msg;
			if ('VRSS' == $service_type) {
				echo $msg;
			}
			
			global $db;
						
			$sql = 'Select * From APP_FileFormat Where format_name = \'vrss\' Order By format_order';
			$rs = $db->Execute($sql) or die ("<br>$sql <br>Select file failed");
			$record_count = $rs->RecordCount();
			
			if (($handle = fopen($tmp_dir_unzip . $file_name, "r")) !== FALSE) {	//"," bug fix 08/07/2013	
								
				$row = 0;
				
				$total_row = count(file($tmp_dir_unzip . $file_name, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
				$actual_num_row = $total_row - 1;
				$_SESSION['num_data'] = $actual_num_row;
				
				$msg = '['. $total_row . ' rows found in the file.] <br>';
				$file_upload_report = $file_upload_report . $msg;
				
				if ('VRSS' == $service_type) {
					echo $msg;
				}
			
				while (($data = fgetcsv($handle)) !== FALSE) {
					$num = count($data);	
					
					if ($num != $record_count && $row < $total_row){
					
						$this->error_msg = 'There should be ' . $record_count . ' columns but row ' . $row . ' has ' . $num . ' columns. ';	// . var_dump($data);
						$this->num_error++;
						array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
						$validation_result['error']['error_count']++;
						FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error');
						
					}
					
					$row++;
					if (1 == $row) {
						
						continue;
					}
					
					$rs->movefirst();
					
					for ($c=0; $c < $num; $c++) {
						
						$col_num = $c + 1;
						$value = scrub_white_list($data[$c], 'DATA');
						$data_length = strlen(trim($value));
						
						$field_name = $rs->fields('field_name');
						$data_type = $rs->fields('data_type');
						$allow_null = $rs->fields('allow_null');
						$pick_list = $rs->fields('pick_list');
						$field_length = $rs->fields('field_length');
						$skip_data = $rs->fields('skip_data');
						$arr_util_rate_ack_type = str_getcsv($rs->fields('util_rate_ack_type'));
						$util_rate_ack = $rs->fields('util_rate_ack');
						$arr_util_rate_rej_type = str_getcsv($rs->fields('util_rate_rej_type'));
						$util_rate_rej = $rs->fields('util_rate_rej');
						
						if ( 'N' == $skip_data ) {
							
							if ( 0 == strlen(trim($value)) && 'N' == $allow_null && !in_array('A', $arr_util_rate_ack_type) && !in_array('G', $arr_util_rate_ack_type) && !in_array('A', $arr_util_rate_rej_type)) {
								
								$this->error_msg = $field_name . ' doesn\'t allow null';
								$this->num_error++;
								array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
								$validation_result['error']['error_count']++;
								FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
								
							} else {
								
								switch($data_type) {
									case 'V':
										if ( substr_count($value, ',') > 0 ) {
											
											$this->error_msg = $field_name . ' field has extra comma in "'. $value . '". Please remove it before upload. ';
											$this->num_error++;
											array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
											$validation_result['error']['error_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
											//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
										}
										
										break;
									case 'D':
										
										$match_result = preg_match('/^(\d{4})(\d{2})(\d{2})$/', trim($value), $datebit);
										
										if (1 == $match_result && 0 != strlen(trim($value))) {
											if (!checkdate($datebit[2] , $datebit[3] , $datebit[1])) {
											
												$this->error_msg = $value . ' is not in the valid date format for field: '. $field_name;
												$this->num_error++;
												array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
												$validation_result['error']['error_count']++;
												FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
												//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
												$date_format_ok = 'N';
											} else {
												$date_format_ok = 'Y';	
											}
										} else {
											$date_format_ok = 'Y';
										}
										
										break;
									case 'N':
										if (!is_numeric($value) && 0 != strlen(trim($value))) {
											
											$this->error_msg = $value . ' is not numeric for field: '. $field_name;
											$this->num_error++;
											array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
											$validation_result['error']['error_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
											//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
										}
										break;
										
									case 'T':
										
										break;
										
									default:
										
										$this->error_msg = $data_type . ' is not defined in the db. value = ' . $value;
										array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
										$validation_result['error']['error_count']++;
										FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
										
										break;
								}
								
								if ( $data_length > $field_length ) {
									
									$this->error_msg = $field_name . ' allows ' . $field_length . '. actual length: ' . $data_length . ' value: ' . $value;
									$this->num_error++;
									array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
									$validation_result['error']['error_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
									//echo $file_err_msg . $validation_result['error']['error_count'] . ' :' . $this->error_msg . '<br>';
								}
							
								$pick_list_error = FALSE;
								
								if ('N' != $pick_list && !in_array('B', $arr_util_rate_ack_type) && !in_array('B', $arr_util_rate_rej_type)) {
									
									if ('Y' == $pick_list) {
										$pick_values = str_getcsv($rs->fields('pick_values'));
										
									} else if ('A' == $pick_list) {	
										$income_benefit_type = array_pop($validation_result["$new_file_name"]['data']['IncomeBenefitType']);
										
										array_push($validation_result["$new_file_name"]['data']['IncomeBenefitType'], $income_benefit_type);
										if ('1' == $income_benefit_type) {
											$pick_values = str_getcsv($rs->fields('pick_values'));
										} else if ('2' == $income_benefit_type) {
											$pick_values = array(1,2,3,4,5,6,7,10,11,12,13,14);
										}
										
									} else if ('B' == $pick_list) {	
										$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
										
										array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
										if ('4' == $service_event_type) {
											$pick_values = str_getcsv($rs->fields('pick_values'));
										} else if ('2' == $service_event_type) {
											$pick_values = array(1,2,3,4,5,);
										} else if ('1' == $service_event_type) {
											$pick_values = array(1,2,3,4,5,6,);
										}
									}
									if (!in_array($value, $pick_values)) {
										
										$pick_list_error = TRUE;
										$this->error_msg = $value . ' is not in the pick list for field: ' . $field_name;
										$this->num_error++;
										array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
										$validation_result['error']['error_count']++;
										FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
										
									}
								}
							
							}
						} 
						
						if ('export.csv' == $new_file_name) {
							
							if ('ExportIDStr' == $field_name) {
								$validation_result["$new_file_name"]['data']['ExportIDStr'] = $value;
							} else if ('ExportDate' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportDate'] = $value;
							} else if ('ExportPeriodBegin' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportPeriodBegin'] = $value;
							} else if ('ExportPeriodEnd' == $field_name){
								$validation_result["$new_file_name"]['data']['ExportPeriodEnd'] = $value;
								if ($validation_result["$new_file_name"]['data']['ExportDate'] != $value) {
									
									$this->error_msg = 'ExportPeriodEnd: ' . $value . ' should be equal to the ExportDate: ' . $validation_result["$new_file_name"]['data']['ExportDate'];
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
								}
								
							} else if ('ExportHashing' == $field_name){
								
								if ( (0 != strlen(trim($value))) && '0' != $value ) {
									
									$this->error_msg = 'ExportHasing should be either null or 0. Actual Value = ' . $value;
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
								}
							} else if ('DeltaOrRefresh' == $field_name){
								
								if ( (0 != strlen(trim($value))) && '1' != $value ) {
									
									$this->error_msg = 'DeltaOrRefresh should be either null or 1. Actual Value = ' . $value;
									
									array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
									$validation_result['error']['rej_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									
								}
							} 
						} else {
							
							 if ( 'ExportIDStr' == $field_name && ($value != $validation_result['export.csv']['data']['ExportIDStr']) ) {
								
								$this->error_msg = 'ExportIDStr: ' . $value . ' doesn\'t match the value ' . $validation_result['export.csv']['data']['ExportIDStr'] . ' in export.csv';
								array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
								$validation_result['error']['rej_count']++;
								FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
								
							}
						}
						
						if ('agencyprogram.csv' == $new_file_name) {
							
							if ('OrganizationID' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['OrganizationID'], $value);
								
							} else if ('ProgramID' == $field_name) {
								array_push($validation_result["$new_file_name"]['data']['ProgramID'], $value);
								
							} else if ('DateCreated' == $field_name && strtotime($value) > strtotime($validation_result['export.csv']['data']['ExportPeriodBegin'])){
								
							}
						}
						
						if ('client.csv' == $new_file_name) {
							
							if ( 'PersonalIdentificationNumber' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $value);
								
							} else if ( 'DateOfBirth' == $field_name ) {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
								$new_key = 'pid_' . $PID;
								$_SESSION["$new_key"] = $value;
								
								array_push($validation_result["$new_file_name"]['data']['DateOfBirth'], $value);
								
							}
							
						}
						
						if ('serviceevent.csv' == $new_file_name) {
							
							if ( 'ServiceEventStartDate' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceEventStartDate'], $value);
								
							} else if ( 'ServiceEventType' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $value);
								
							} else if ( 'ServiceCode' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ServiceCode'], $value);
							}

						}
						
						if ('programparticipation.csv' == $new_file_name) {
							
							if ( 'PersonalIdentificationNumber' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $value);
								
							} else if ( 'EntryDate' == $field_name ) {
								$PID = array_pop($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber']);
								array_push($validation_result["$new_file_name"]['data']['PersonalIdentificationNumber'], $PID);
								array_push($validation_result["$new_file_name"]['data']['EntryDate'], $value);
								
								$is_adult = 'N';
								$new_key = 'pid_' . $PID;
								
								if ( !isset($_SESSION["$new_key"]) ) {
									
									$this->error_msg = 'Personal Identification Number ' . $PID . ' was not found in the client.csv file.';
									$this->num_error++;
									array_push($validation_result["$new_file_name"]['error_msg'], $this->error_msg);
									$validation_result['error']['error_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['error_count'], 'error', $row);
									
								} else {
									$dob = $_SESSION["$new_key"];
									
									if (!preg_match('/^\d{1,2}\/\d{1,2}\/\d{4}$/', trim($dob)) && 0 != strlen(trim($dob))) { 
										$this->error_msg = 'Invalid date of birth \'' . $dob . '\' in Client.csv. The system will continue validation assuming the applicant is an adult.';
										$is_adult = 'Y';
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
										FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
										
									} else {
										
										$sub_18_years = date_create($value);
										date_sub($sub_18_years, date_interval_create_from_date_string('18 years'));
										$date_diff = date_diff(date_create($dob), $sub_18_years);
										if ( 0 <= $date_diff->format('%R%a') ) {
											$is_adult = 'Y';	
										}
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									
									}
								}
								
							} else if ( 'ExitDate' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['ExitDate'], $value);
								
							}
							
						}
						
						if ('incomebenefits.csv' == $new_file_name) {
							
							if ( 'IncomeBenefitType' == $field_name ) {
								array_push($validation_result["$new_file_name"]['data']['IncomeBenefitType'], $value);
								
							}

						}
						
						$id_check_file_names = array('clienthistorical.csv', 'incomebenefits.csv', 'serviceevent.csv', 'programparticipation.csv');
						
						if (in_array($new_file_name, $id_check_file_names)) {	
							
							if ( 'PersonalIdentificationNumber' == $field_name ){
								
								if (!in_array($value, $validation_result['client.csv']['data']['PersonalIdentificationNumber'])) {
									
									$this->error_msg = 'Personal Identification Number ' . $value . ' was not found in Client.csv and will be discarded.';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
									
								}
								
							} else if ('OrganizationID' == $field_name){
	
								if (!in_array($value, $validation_result['agencyprogram.csv']['data']['OrganizationID'])) {
									
									$this->error_msg = 'Organization ID ' . $value . ' not found in AgencyProgram.csv will be discarded.';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
									
								}
								
							} else if ('ProgramID' == $field_name){

								if (!in_array($value, $validation_result['agencyprogram.csv']['data']['ProgramID'])) {
									
									$this->error_msg = 'Program ID ' . $value . ' not found in AgencyProgram.csv will be discarded.';
									array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
									$validation_result['error']['ack_count']++;
									FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
									
								}
							}
						}
						
						$cnt_ack = count($arr_util_rate_ack_type);
						$cnt_rej = count($arr_util_rate_rej_type);
						
						for($i = 0; $i < $cnt_ack; $i++) {
							
							$util_rate_ack_type = $arr_util_rate_ack_type[$i];
							
							switch($util_rate_ack_type) {
								case 'N':
									
									break;
								
								case 'A':
								case 'O':	
									$is_adult = 'Y';
									if ('O' == $util_rate_ack_type) {
										$is_adult = array_pop($validation_result["$new_file_name"]['data']['IsAdult']);
										
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['A']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['A'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) && 'Y' == $is_adult ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['A']++;
									}
									
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['A'];
										if ($threshold_count > $threshold) {
											
											$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% acknowledge threshold limit set for this data. ';
											
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											
										}
									}
									
									break;

								case 'B':
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['B']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['B'] = 0;	
									}
										
									if ( $pick_list_error ) {
										
										$pick_values = str_getcsv($rs->fields('pick_values'));
										if (!in_array($value, $pick_values)) {
											
											$validation_result["$new_file_name"][$field_name]['util_ack']['B']++;
											
											$this->error_msg = 'Value ' . $value . ' is not found in the CSV specs.';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
										}
										
									}
									
									break;
									
								case 'C':									
								case 'E':	
									
									if ( 'C' == $util_rate_ack_type ) {
										$util_rate_ack = 15;
									} else if ( 'E' == $util_rate_ack_type ) { 
										$util_rate_ack = 10;
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['C']) ) {
											$validation_result["$new_file_name"][$field_name]['util_ack']['C'] = 0;	
									}
										
									if ( '8' == $value || '9' == $value ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['C']++;
									}
									
									if ( $total_row == $row ) {
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['C'];
										
										if ($threshold_count > $threshold) {
											
											$this->error_msg = 'There are ' . $threshold_count . ' don\'t know or refused answer (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% acknowledge threshold limit set for this data. ';
											
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											
										}
									}
									
									break;
									
								case 'D':	
									
									break;
									
								case 'F':	
									$acceptable_values = array(1,2,4);
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['F']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['F'] = 0;	
									}
									
									if (!in_array($value, $acceptable_values)) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['F']++;
										
										$this->error_msg = 'ServiceEventType ' . $value . ' with values other than 1,2,or 4 will be ignored.';
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
										FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
									}
																			
									break;
									
								case 'G':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['G']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['G'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['G']++;
									}
									if ( $total_row == $row ) {
										
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['G'];
										//??No Threshold?
										if ($threshold_count > 0) {
											$this->error_msg = 'Records with missing value will be ignored.';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											
										}
									}
										
									break;
									
								case 'H': 
								case 'J':
								case 'L':
										
									break;
									
								case 'I':
									$acceptable_values_one = array(1,2,3,4,5,6,7,8);
									$acceptable_values_two = array(3,5,17);
									
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['I']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['I'] = 0;	
									}
									
									if ( ('1' == $service_event_type || '2' == $service_event_type) && !in_array($value, $acceptable_values_one)) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['I']++;
										
									} else if ( '4' == $service_event_type && !in_array($value, $acceptable_values_two)) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['I']++;
									}
									if ( $total_row == $row ) {
										
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['I'];
										
										if ($threshold_count > 0) {
											$this->error_msg = 'ServiceCode with a value outside of the range 1-8 where ServiceEventType is 1 or 2 and ';
											$this->error_msg .= '<br>ServiceCode with a value that is anything other than 3,5,or 17 where ServiceEventType is 4 will be ignored.';
											
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											
										}
									}
										
									break;
									
								case 'K':
									$service_code_range = array(1,2,3,4,5,6,7,8);
									$service_code = array_pop($validation_result["$new_file_name"]['data']['ServiceCode']);
									
									array_push($validation_result["$new_file_name"]['data']['ServiceCode'], $service_code);
									
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['K']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['K'] = 0;	
									}
									
									if ( '1' == $service_event_type && in_array($service_code, $service_code_range) &&  0 == strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['K']++;
										
										$this->error_msg = 'Missing financialAssistanceAmount data where ServiceEventType is 1 and ServiceCode is 1-8. ';
											
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
										FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
									}
										
									break;
									
								case 'M':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['M']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['M'] = 0;	
									}
									
									if ( 5 != strlen(trim($value)) && 0 != strlen(trim($value))) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['M']++;
										
										$this->error_msg = 'Zip code ' . $value . ' should be 5 digit numeric value.';
										array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
										$validation_result['error']['ack_count']++;
										FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack', $row);
									}
										
									break;
										
								case 'P':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_ack']['N']) ) {
										$validation_result["$new_file_name"][$field_name]['util_ack']['N'] = 0;	
									}
									
									$exit_date = array_pop($validation_result["$new_file_name"]['data']['ExitDate']);
									
									array_push($validation_result["$new_file_name"]['data']['ExitDate'], $exit_date);
									
									if ( 0 == strlen(trim($value)) && 0 != strlen(trim($exit_date)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_ack']['N']++;
									}
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_ack / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_ack']['N'];
										//??No Threshold?
										if ($threshold_count > $threshold) {
											
											$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_ack . '% ack threshold limit set for this data. ';
											array_push($validation_result["$new_file_name"]['ack_msg'], $this->error_msg);
											$validation_result['error']['ack_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['ack_count'], 'ack');
											
										}
									}
										
									break;
									
								default:
									
									break;		
							}
						}
						
						for($i = 0; $i < $cnt_rej; $i++) {
							
							$util_rate_rej_type = $arr_util_rate_rej_type[$i];
							
							switch($util_rate_rej_type) {
								case 'N':
									
									break;
								
								case 'A':
								case 'O':
									$is_adult = 'Y';
									if ('O' == $util_rate_rej_type) {
										$is_adult = array_pop($validation_result["$new_file_name"]['data']['IsAdult']);
										
										array_push($validation_result["$new_file_name"]['data']['IsAdult'], $is_adult);
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['A']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['A'] = 0;	
									}
									
									if ( 0 == strlen(trim($value)) && 'Y' == $is_adult ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['A']++;
									}
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['A'];
										//echo '<br>' . $new_file_name . '.' . $field_name . ' - Threshold = ' . $threshold . ', threshold count = '. $threshold_count;
										if ($threshold_count > $threshold) {
											
											$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% rejection threshold limit set for this data. ';
											
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
										}
									}
									break;
								
								case 'B':
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['B']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['B'] = 0;	
									}
										
									if ( $pick_list_error ) {
										
										$pick_values = str_getcsv($rs->fields('pick_values'));
										if (!in_array($value, $pick_values)) {
											
											$validation_result["$new_file_name"][$field_name]['util_rej']['B']++;
											
											$this->error_msg = 'Value ' . $value . ' is not found in the CSV specs.';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
										}
										
									}
									break;
									
								case 'C':									
								case 'E':	
									
									if ( 'C' == $util_rate_rej_type ) {
										$util_rate_rej = 15;
									} else if ( 'E' == $util_rate_rej_type ) { 
										$util_rate_rej = 10;
									}
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['C']) ) {
												$validation_result["$new_file_name"][$field_name]['util_rej']['C'] = 0;	
										}
										
									if ( '8' == $value || '9' == $value ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['C']++;
									}
									
									if ( $total_row == $row ) {
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['C'];
										
										if ($threshold_count > $threshold) {
											
											$this->error_msg = 'There are(is) ' . $threshold_count . ' don\'t know or refused answer (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% reject threshold limit set for this data. ';
											
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
										}
									}
									
									break;
									
								case 'D':	
									
									break;
									
								case 'F':	
								case 'G':	
								case 'I':
								case 'K':
										
									break;
								
								case 'H':	
									
									$service_event_start_date = array_pop($validation_result["$new_file_name"]['data']['ServiceEventStartDate']);
									
									array_push($validation_result["$new_file_name"]['data']['ServiceEventStartDate'], $service_event_start_date);
									
									if ( 0 != strlen(trim($value)) ) {	
										if ( strtotime($value) < strtotime($service_event_start_date) ) {
											
											$this->error_msg = 'ServiceEventEndDate ' . $value . ' can not be prior to ServiceEventStartDate ' . $service_event_start_date . ' in serviceevent.csv ';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
										}
									}
									break;
								
								case 'J':								
									$service_event_type = array_pop($validation_result["$new_file_name"]['data']['ServiceEventType']);
									
									array_push($validation_result["$new_file_name"]['data']['ServiceEventType'], $service_event_type);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['J']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['J'] = 0;	
									}
									
									if ( ('1' == $service_event_type || '2' == $service_event_type) &&  0 == strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['J']++;
										
									}
									if ( $total_row == $row ) {
										
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['J'];
										//??No Threshold?
										if ($threshold_count > 0) {
											
											//$this->error_msg = 'There are ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											//$this->error_msg .= ' records which is more than ' . $util_rate_rej . '% rej threshold limit set for this data. ';
											$this->error_msg = 'Missing service code where ServiceEventType is 1 or 2 is rejected.';
																						
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
										}
									}
										
									break;
									
								case 'L':
									$entry_date = array_pop($validation_result["$new_file_name"]['data']['EntryDate']);
									//put the value back to the array
									array_push($validation_result["$new_file_name"]['data']['EntryDate'], $entry_date);
									
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['L']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['L'] = 0;	
									}
									
									if ( 0 != strlen(trim($value)) ) {	
										if ( strtotime($value) < strtotime($entry_date) ) {
											
											$validation_result["$new_file_name"][$field_name]['util_rej']['L']++;
											$this->error_msg = 'ExitDate ' . $value . ' should be later than the EntryDate ' . $entry_date;
																							
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
										}
									}
										
									break;
									
								case 'M':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['M']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['M'] = 0;	
									}
									
									if ( 5 != strlen(trim($value)) && 0 != strlen(trim($value)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['M']++;
										
										$this->error_msg = 'Zip code ' . $value . ' should be 5 digit numeric value.';
										array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
										$validation_result['error']['rej_count']++;
										FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej', $row);
									}
									
										
									break;
									
								case 'P':	
									if ( !isset($validation_result["$new_file_name"][$field_name]['util_rej']['N']) ) {
										$validation_result["$new_file_name"][$field_name]['util_rej']['N'] = 0;	
									}
									
									$exit_date = array_pop($validation_result["$new_file_name"]['data']['ExitDate']);
									
									array_push($validation_result["$new_file_name"]['data']['ExitDate'], $exit_date);
									
									if ( 0 == strlen(trim($value)) && 0 != strlen(trim($exit_date)) ) {
										
										$validation_result["$new_file_name"][$field_name]['util_rej']['N']++;
									}
									if ( $total_row == $row ) {
										
										$threshold = $actual_num_row * $util_rate_rej / 100;
										$threshold_count = $validation_result["$new_file_name"][$field_name]['util_rej']['N'];
										//??No Threshold?
										if ($threshold_count > $threshold) {
											//Rej	
											$this->error_msg = 'There are(is) ' . $threshold_count . ' missing data (' . $field_name . ') in ' . $new_file_name . ' out of ' . $actual_num_row;
											$this->error_msg .= ' records <br>' . $spacer . ' which is more than ' . $util_rate_rej . '% rej threshold limit set for this data. ';
											array_push($validation_result["$new_file_name"]['rej_msg'], $this->error_msg);
											$validation_result['error']['rej_count']++;
											FileValidator::display_error($this->error_msg, $validation_result['error']['rej_count'], 'rej');
											//echo $rej_err_msg . $validation_result['error']['rej_count'] . ' :' . $this->error_msg . '<br>';
										}
									}
									
									break;
									
								default:
									
									break;		
							}
						}

						$rs->movenext();
						
						
					}
					
				}
						if ( $total_row == $row ) {
							
							$file_rej_count = count($validation_result["$new_file_name"]['rej_msg']);
							$file_ack_count =  count($validation_result["$new_file_name"]['ack_msg']);
							$file_err_count =  count($validation_result["$new_file_name"]['error_msg']);
							
							if (0 == $file_rej_count && 0 == $file_ack_count && 0 == $file_err_count) {
								$msg = $spacer . '<b><font color=blue>No issue found.</font></b><br>'; 
								$file_upload_report = $file_upload_report . $msg;
								if ('VRSS' == $service_type) {
									echo $msg;
								}
							}
						}				
				
				fclose($handle);
				
			} else {
				
				$msg = $spacer . 'Read file failed: ' . $tmp_dir_unzip . $file_name;
				$file_upload_report = $file_upload_report . $msg;
				if ('VRSS' == $service_type) {
					echo $msg;
				}
			}
			
			$rs->Close();
			
			return $validation_result;
			
		}
		
		function display_error($err_msg, $count, $type, $row = -1) {
			global $file_upload_report;
			$spacer = '&nbsp; &nbsp; &nbsp; &nbsp;';
			$row_info = '';
			
			if ('error' == $type) {
				$head_err_msg = '<b><font color=red>File Error #';
			} else if ('ack' == $type) {
				$head_err_msg = '<b><font color=green>Acknowledgement required #';
			} else if ('rej' == $type) { 
				$head_err_msg = '<b><font color=red>Rejected #';
			}
			
			if ( -1 < $row ) {
				$row_info = ' (row #' . $row . ')';	
			}
			$msg = $spacer . $head_err_msg . $count . ' :</font></b> ' . $err_msg . $row_info . '<br>';
			$file_upload_report = $file_upload_report . $msg;
			if ('VRSS' == $_SESSION['service_type']) {
				echo $msg;
			}
			
		}
		
		function is_file_name_valid ($file_name) {
			
			return in_array($file_name, $this->valid_file_names);
		}
		
		
	}
	
?>
