﻿using Microsoft.Xrm.Sdk.Client;
using System;
using System.Collections.Generic;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VRM.Integration.Servicebus.Core;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.StateObject
{
    public class MakeGroupAppointmentStateObject: PipeState
    {
        public MakeGroupAppointmentStateObject(MakeGroupAppointmentRequestMessage request)
        {
            OrganizationName = request.OrganizationName;
            UserId = request.UserId;
            AppointmentId = request.AppointmentId;
            MakeGroupAppointmentRequestMessage = request;
            LogRequest = true;
            PatUserDuz = request.PatUserDuz;
            ProUserDuz = request.ProUserDuz;
            SystemUsers = new List<SystemUser>();
            EcProcessingTimeMs = 0;
        }
        /// <summary>
        /// Gets or sets the CRM organization name.
        /// </summary>
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log the request.
        /// </summary>
        public bool LogRequest { get; set; }

        /// <summary>
        /// Get or set the CRM Organization Service Proxy.
        /// </summary>
        public OrganizationServiceProxy OrganizationServiceProxy { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid AppointmentId { get; set; }

        public string SAMLToken { get; set; }

        public string PatUserDuz { get; set; }

        public string ProUserDuz { get; set; }

        /// <summary>
        /// Gets or sets whether to use a fake response.
        /// </summary>
        public string VistaFakeResponseType { get; set; }

        public string VistaAppointmentType { get; set; }

        public string VistaAppointmentPurpose { get; set; }

        public AppointmentType AppointmentType { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public ServiceAppointment ServiceAppointment { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public Appointment CrmAppointment { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public List<SystemUser> SystemUsers { get; set; }

        public mcs_facility PatFacility { get; set; }

        public mcs_facility ProFacility { get; set; }

        /// <summary>
        /// Vista Clinic booked on the patient side
        /// </summary>
        public mcs_resource PatClinic { get; set; }

        /// <summary>
        /// Vista Clinic booked on the provider side
        /// </summary>
        public mcs_resource ProClinic { get; set; }

        /// <summary>
        /// Gets or sets a serialized Appointment.
        /// </summary>
        public string SerializedAppointment { get; set; }

        /// <summary>
        /// Gets or Sets whether an exception occured.
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or Sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Plugin Request Message
        /// </summary>
        public MakeGroupAppointmentRequestMessage MakeGroupAppointmentRequestMessage { get; set; }

        /// <summary>
        /// Plugin Response Message.
        /// </summary>
        public MakeGroupAppointmentResponseMessage MakeGroupAppointmentResponseMessage { get; set; }

        /// <summary>
        /// Patient Side Ec Request
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentRequest PatEcRequest { get; set; }

        /// <summary>
        /// Patient Side Ec Response
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentResponse PatEcResponse { get; set; }
        /// <summary>
        /// Provider Side Ec Request
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentRequest ProEcRequest { get; set; }

        /// <summary>
        /// Provider Side Ec Response
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentResponse ProEcResponse { get; set; }

        /// <summary>
        /// Query Bean for appointment request (both sides sharing same bean)
        /// </summary>
        public VIMTVIASchdMakeApptReqqueryBean EcQueryBean { get; set; }

        public VIMTVIAScheLIloginVIARequest PatLoginRequest { get; set; }

        public VIMTVIAScheLIloginVIARequest ProLoginRequest { get; set; }

        public int EcProcessingTimeMs { get; set; }
    }
}
