﻿using Microsoft.Xrm.Sdk.Client;
using System;
using System.Collections.Generic;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VRM.Integration.Servicebus.Core;
using VIMT.VIAEMRService.Messages;
using VIMT.VIASchedulingService.Messages;

namespace VA.TMP.Integration.VIMT.Vista.StateObject
{
    public class GetConsultsForPatientStateObject : PipeState
    {
        public GetConsultsForPatientStateObject(GetConsultsForPatientRequest request)
        {
            OrganizationName = request.OrganizationName;
            UserId = request.UserId;
            GetConsultsRequest = request;
            LogRequest = request.LogRequest;
            IsHomeMobile = request.IsHomeMobile;
            IsStoreForward = request.IsStoreForward;
            SamlToken = request.SAMLToken;
            PatUserDuz = request.PatUserDuz;
            ProUserDuz = request.ProUserDuz;
            EcProcessingTimeMs = 0;
        }

        /// <summary>
        /// Gets or sets a serialized Consult EC Request.
        /// </summary>
        public string SerializedConsult { get; set; }

        /// <summary>
        /// Gets or Sets whether an exception occured.
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or Sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Gets or sets the CRM organization name.
        /// </summary>
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log the request.
        /// </summary>
        public bool LogRequest { get; set; }

        /// <summary>
        /// Get or set the CRM Organization Service Proxy.
        /// </summary>
        public OrganizationServiceProxy OrganizationServiceProxy { get; set; }

        /// <summary>
        /// Used to fake the EC Call/Response for local testing
        /// </summary>
        public string ConsultsFakeResponseType { get; set; }

        /// <summary>
        /// Used to filter down the consults returned from vista to only those records with a status in this string concatenated list
        /// </summary>
        public string mcs_status { get; set; }

        /// <summary>
        /// Request Message coming from the Plugin
        /// </summary>
        public GetConsultsForPatientRequest GetConsultsRequest { get; set; }

        /// <summary>
        /// Response Message to be sent back to the Plugin
        /// </summary>
        public GetConsultsForPatientResponse GetConsultsResponse { get; set; }

        /// <summary>
        /// Request Message to be sent to the EC
        /// </summary>
        public VIMTVIAEMRgcfpgetConsultsForPatientRequest PatEcRequest { get; set; }

        public VIMTVIAEMRgcfpgetConsultsForPatientRequest ProEcRequest { get; set; }

        /// <summary>
        /// Response Message Received from the EC
        /// </summary>
        public VIMTVIAEMRgcfpgetConsultsForPatientResponse PatEcResponse { get; set; }

        public VIMTVIAEMRgcfpgetConsultsForPatientResponse ProEcResponse { get; set; }

        /// <summary>
        /// Login Requests sent through EC prior to calling Get Consults EC
        /// </summary>
        public VIMTVIAScheLIloginVIARequest PatLoginRequest { get; set; }

        public VIMTVIAScheLIloginVIARequest ProLoginRequest { get; set; }

        public string PatientStationCode { get; set; }

        public string ProviderStationCode { get; set; }
        
        /// <summary>
        /// Flag sent from plugin to determine if the consults from patient side is retrieved (false = retrieved, true = not retrieved)
        /// </summary>
        public bool IsHomeMobile { get; set; }

        /// <summary>
        /// Flag sent from plugin to determine if the consults from provider side is retrieved (false = retrieved, true = not retrieved)
        /// </summary>
        public bool IsStoreForward { get; set; }

        public string SamlToken { get; set; }
        /// <summary>
        /// result of PatLoginRequest - returned to plugin for use in Make Appointment
        /// </summary>
        public string PatUserDuz { get; set; }

        /// <summary>
        /// result of ProLoginRequest - returned to plugin for use in Make Appointment
        /// </summary>
        public string ProUserDuz { get; set; }

        public int EcProcessingTimeMs { get; set; }
    }
}
