﻿using Microsoft.Xrm.Sdk.Client;
using System;
using System.Collections.Generic;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VRM.Integration.Servicebus.Core;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.StateObject
{
    public class CancelGroupAppointmentStateObject:PipeState
    {
        public CancelGroupAppointmentStateObject(CancelGroupAppointmentRequestMessage request)
        {
            OrganizationName = request.OrganizationName;
            UserId = request.UserId;
            CancelGroupAppointmentRequest = request;
            LogRequest = request.LogRequest;
            AppointmentId = request.AppointmentId;
            SamlToken = request.SamlToken;
            PatUserDuz = request.PatUserDuz;
            ProUserDuz = request.ProUserDuz;
            SystemUsers = new List<SystemUser>();
            EcProcessingTimeMs = 0;
        }

        /// <summary>
        /// Gets or sets a serialized Consult EC Request.
        /// </summary>
        public string SerializedCancelRequest { get; set; }

        /// <summary>
        /// Gets or Sets whether an exception occured.
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or Sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Gets or sets the CRM organization name.
        /// </summary>
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log the request.
        /// </summary>
        public bool LogRequest { get; set; }

        /// <summary>
        /// Get or set the CRM Organization Service Proxy.
        /// </summary>
        public OrganizationServiceProxy OrganizationServiceProxy { get; set; }

        /// <summary>
        /// Request Message coming from the Plugin
        /// </summary>
        public CancelGroupAppointmentRequestMessage CancelGroupAppointmentRequest { get; set; }

        /// <summary>
        /// Response Message to be sent back to the Plugin
        /// </summary>
        public CancelGroupAppointmentResponseMessage CancelGroupAppointmentResponse { get; set; }

        public string CancelAppointmentFakeResponseType { get; set; }

        public string AppointmentPurpose { get; set; }

        public string VistaAppointmentType { get; set; }

        public string Via_AppToken { get; set; }

        public string Via_AppPassword { get; set; }

        public ServiceAppointment ServiceAppointment { get; set; }

        public Appointment CrmAppointment { get; set; }

        public Guid AppointmentId { get; set; }

        public AppointmentType AppointmentType { get; set; }

        public mcs_facility PatientFacility { get; set; }

        public mcs_facility ProviderFacility { get; set; }

        public mcs_resource PatientClinic { get; set; }

        public mcs_resource ProviderClinic { get; set; }

        public List<SystemUser> SystemUsers { get; set; }
        
        public VIMTVIASchedCancApcancelAppointmentRequest PatEcRequest { get; set; }

        public VIMTVIASchedCancApcancelAppointmentResponse PatEcResponse { get; set; }

        public VIMTVIASchedCancApcancelAppointmentRequest ProEcRequest { get; set; }

        public VIMTVIASchedCancApcancelAppointmentResponse ProEcResponse { get; set; }

        public VIMTVIAScheLIloginVIARequest PatLoginRequest { get; set; }

        public VIMTVIAScheLIloginVIARequest ProLoginRequest { get; set; }

        public string PatUserDuz { get; set; }

        public string ProUserDuz { get; set; }

        public string SamlToken { get; set; }

        public int EcProcessingTimeMs { get; set; }

    }
}
