﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.ViaLogin;
using VA.TMP.Integration.VIMT.Messages.Vista;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class ViaLoginProcessor
    {
        public IMessageBase Execute(ViaLoginRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<ViaLoginStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ViaLoginStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ViaLoginStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ViaLoginStateObject>, MapToLoginEcRequestStep>("MapToLoginEcRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ViaLoginStateObject>, SerializeInstanceStep>("SerializeInstanceStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ViaLoginStateObject>, SendLoginToEcStep>("SendLoginToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ViaLoginStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ViaLoginStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new ViaLoginStateObject(request))
            {
                new Pipeline<ViaLoginStateObject>()
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("MapToLoginEcRequestStep")) 
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("SerializeInstanceStep"))
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("SendLoginToEcStep"))
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<ViaLoginStateObject>>("StopProcessingStep"))
                    .Execute(state);
                return state.LoginResponse;
            }
        }
    }
}
